'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) exit.n 1.3 95/05/06 15:31:01
'\" 
.so man.macros
.TH exit n "" Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
exit \- Exit the process
.SH SYNOPSIS
\fBuse Tk qw(exit);\fR
.br
...
.br
\fBexit\fR?(\fIreturnCode\fR)?
.BE

.SH DESCRIPTION
.PP
Terminate the process, returning \fIreturnCode\fR (an integer) to the
system as the exit status.
If \fIreturnCode\fR isn't specified then it defaults
to 0.
This command replaces the perl command by the same name.
It is identical to perl's \fBexit\fR command except that
before exiting it destroys all the windows managed by
the process.
This allows various cleanup operations to be performed, such
as removing application names from the global registry of applications.
.SH BUGS
.VS
This function is necessary as 
calling \fIperl's\fR \fBexit\fR from inside a callback associated with 
a binding (including \fBMenu\fR and \fBButton\fR \fB-command\fR callbacks)
can result in memory access violations due to leaving Tk's 
internal data-structures in an inconsistent state.
.PP
Workround is to either \fI$mainwindow\fR->\fBdestroy\fR or 
use \fBTk::exit\fR as described here.
.VE

.SH KEYWORDS
exit, process
