/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ProjectSettingsInfo.h"
#include "ProjectSettingsWidget.h"
#include "../Project.h"


ProjectSettingsInfo::ProjectSettingsInfo( const QString& title, const QString& id, Project* prj )
: _title(title), _id(id), _sortIndex(-1), _orgPrj(prj)
{
  if( prj )
  {
    _modPrj = new Project(*prj);
  }
}

ProjectSettingsInfo::ProjectSettingsInfo( const QString& title, const QString& id, int sortIndex )
: _title(title), _id(id), _sortIndex(sortIndex), _orgPrj(0), _modPrj(0)
{
}

ProjectSettingsInfo::~ProjectSettingsInfo()
{
  delete _modPrj;
}

const QString& ProjectSettingsInfo::getTitle()
{
  return _title;
}

const QString& ProjectSettingsInfo::getSettingsId()
{
  return _id;
}

void ProjectSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  ProjectSettingsWidget* psw = dynamic_cast<ProjectSettingsWidget*>(sw);
  psw->setProject(_modPrj);
}

void ProjectSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  ProjectSettingsWidget* psw = dynamic_cast<ProjectSettingsWidget*>(sw);
  _modPrj = psw->getProject();
}

bool ProjectSettingsInfo::isModified()
{
  if( _orgPrj && _modPrj )
  {
    return ! _orgPrj->operator ==(*_modPrj);
  }
  else
  {
    return false;
  }
}

void ProjectSettingsInfo::ok()
{
  if( _orgPrj && _modPrj )
  {
    _orgPrj->operator=(*_modPrj);
  }
}

void ProjectSettingsInfo::apply()
{
  if( _orgPrj && _modPrj )
  {
    _orgPrj->operator=(*_modPrj);
  }
}

void ProjectSettingsInfo::cancel()
{
  // nop
}

int ProjectSettingsInfo::getSortIndex()
{
  if( _orgPrj )
  {
    return _orgPrj->getSortPos();
  }

  return _sortIndex;
}
