/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ScParam.h"
#include "ScCmdData.h"

ScParam::ScParam() : _id(Id::next()), _error(sc::Success)
{
}

ScParam::~ScParam()
{
}

ID ScParam::getId()
{
  return _id;
}

void ScParam::setError( const sc::Error* err )
{
  _error = err;
}

const sc::Error* ScParam::getError() const
{
  return _error;
}

bool ScParam::hasError() const
{
  return _error != sc::Success;
}
