/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "SignalTarget.h"


SignalTarget::SignalTarget( QObject* src ) : _src(src)
{
  connect(
    _src, SIGNAL(modelAboutToBeReset()),
    this, SLOT(modelAboutToBeReset()));
  connect(
    _src, SIGNAL(modelReset()),
    this, SLOT(modelReset()));

  connect(
    _src, SIGNAL(layoutAboutToBeChanged()),
    this, SLOT(layoutAboutToBeChanged()));
  connect(
    _src, SIGNAL(layoutChanged()),
    this, SLOT(layoutChanged()));

  connect(
    _src, SIGNAL(rowsAboutToBeInserted(const QModelIndex&,int,int)),
    this, SLOT(rowsAboutToBeInserted(const QModelIndex&,int,int)));
  connect(
    _src, SIGNAL(rowsInserted(const QModelIndex&,int,int)),
    this, SLOT(rowsInserted(const QModelIndex&,int,int)));}

SignalTarget::~SignalTarget()
{
  disconnect(
    _src, SIGNAL(modelAboutToBeReset()),
    this, SLOT(modelAboutToBeReset()));
  disconnect(
    _src, SIGNAL(modelReset()),
    this, SLOT(modelReset()));

  disconnect(
    _src, SIGNAL(layoutAboutToBeChanged()),
    this, SLOT(layoutAboutToBeChanged()));
  disconnect(
    _src, SIGNAL(layoutChanged()),
    this, SLOT(layoutChanged()));

  disconnect(
    _src, SIGNAL(rowsAboutToBeInserted(const QModelIndex&,int,int)),
    this, SLOT(rowsAboutToBeInserted(const QModelIndex&,int,int)));
  disconnect(
    _src, SIGNAL(rowsInserted(const QModelIndex&,int,int)),
    this, SLOT(rowsInserted(const QModelIndex&,int,int)));
}

#if 0
  void WcViewItemProxyModelTest::srcDataChanged( const QModelIndex& srcTopLeft, const QModelIndex&
    srcBottomRight );
  void WcViewItemProxyModelTest::srcHeaderDataChanged( Qt::Orientation orientation,
    int first, int last );
  void WcViewItemProxyModelTest::srcRowsAboutToBeRemoved( const QModelIndex& srcParent,
    int start, int end );
  void WcViewItemProxyModelTest::srcRowsRemoved( const QModelIndex& srcParent,
    int start, int end );
#endif