-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Function to construct string announcing version and title of tool           --
--                                                                            --
--------------------------------------------------------------------------------
separate (Banner)
function Get_Version (J : in Justification) return TypBannerLine is
   R : TypBannerLine;
begin
   if CommandLine.Data.PlainOutput then
      R :=
        CreateBannerLine
        (FromText          => "POGS " & Version.Toolset_Distribution & " Edition",
         WithJustification => J,
         FillChar          => ' ');
   else
      R := CreateBannerLine (FromText          => "POGS " & Version.Toolset_Banner_Line,
                             WithJustification => J,
                             FillChar          => ' ');
   end if;
   return R;
end Get_Version;
