/*
 * Copyright (C) Jan 2013 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/***
         *** This file was generated at "2017-03-19 12:09:18"
         *** by:
         ***    > /mswg/release/eat_me/last_release/adabe_plugins/adb2c/adb2pack.py --input adb/connectib/connectib.adb --file-prefix connectib --prefix connectib_
         ***/
#include "connectib_layouts.h"

void connectib_cmdif_ctx_special_qp_commands_uapp_pack(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->uapp_qp_buf_id);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sw_wq_mkn);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_nim_indicies_allocated);

}

void connectib_cmdif_ctx_special_qp_commands_uapp_unpack(struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->uapp_qp_buf_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 32;
	ptr_struct->sw_wq_mkn = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->num_nim_indicies_allocated = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_qp_commands_uapp_print(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_uapp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uapp_qp_buf_id       : " UH_FMT "\n", ptr_struct->uapp_qp_buf_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_wq_mkn            : " U32H_FMT "\n", ptr_struct->sw_wq_mkn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_nim_indicies_allocated : " U32H_FMT "\n", ptr_struct->num_nim_indicies_allocated);

}

int connectib_cmdif_ctx_special_qp_commands_uapp_size(void)
{
	 return 12;
}

void connectib_cmdif_ctx_special_qp_commands_uapp_dump(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_uapp_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_underlay_pack(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ste_ix);

}

void connectib_cmdif_ctx_special_qp_commands_underlay_unpack(struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_qp_commands_underlay_print(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_underlay ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ste_ix               : " U32H_FMT "\n", ptr_struct->ste_ix);

}

int connectib_cmdif_ctx_special_qp_commands_underlay_size(void)
{
	 return 12;
}

void connectib_cmdif_ctx_special_qp_commands_underlay_dump(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_underlay_print(ptr_struct, file, 0);
}

void connectib_regular_qp_eth_pack(const struct connectib_regular_qp_eth *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rq_head_qpn);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->lag_tx_port_affinity);

}

void connectib_regular_qp_eth_unpack(struct connectib_regular_qp_eth *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->rq_head_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 0;
	ptr_struct->lag_tx_port_affinity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_regular_qp_eth_print(const struct connectib_regular_qp_eth *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_regular_qp_eth ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rq_head_qpn          : " UH_FMT "\n", ptr_struct->rq_head_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lag_tx_port_affinity : " UH_FMT "\n", ptr_struct->lag_tx_port_affinity);

}

int connectib_regular_qp_eth_size(void)
{
	 return 4;
}

void connectib_regular_qp_eth_dump(const struct connectib_regular_qp_eth *ptr_struct, FILE* file)
{
	connectib_regular_qp_eth_print(ptr_struct, file, 0);
}

void connectib_regular_qp_ipoib_pack(const struct connectib_regular_qp_ipoib *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->underlay_qp_ste_ix);

}

void connectib_regular_qp_ipoib_unpack(struct connectib_regular_qp_ipoib *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->underlay_qp_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_regular_qp_ipoib_print(const struct connectib_regular_qp_ipoib *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_regular_qp_ipoib ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "underlay_qp_ste_ix   : " U32H_FMT "\n", ptr_struct->underlay_qp_ste_ix);

}

int connectib_regular_qp_ipoib_size(void)
{
	 return 4;
}

void connectib_regular_qp_ipoib_dump(const struct connectib_regular_qp_ipoib *ptr_struct, FILE* file)
{
	connectib_regular_qp_ipoib_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_inner_pack(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_special_qp_commands_uapp_pack(&(ptr_struct->uapp), ptr_buff);
}

void connectib_cmdif_ctx_special_qp_commands_inner_unpack(union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_special_qp_commands_uapp_unpack(&(ptr_struct->uapp), ptr_buff);
}

void connectib_cmdif_ctx_special_qp_commands_inner_print(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_inner ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "underlay_qp:\n");
	connectib_cmdif_ctx_special_qp_commands_underlay_print(&(ptr_struct->underlay_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uapp:\n");
	connectib_cmdif_ctx_special_qp_commands_uapp_print(&(ptr_struct->uapp), file, indent_level + 1);

}

int connectib_cmdif_ctx_special_qp_commands_inner_size(void)
{
	 return 12;
}

void connectib_cmdif_ctx_special_qp_commands_inner_dump(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_inner_print(ptr_struct, file, 0);
}

void connectib_pmlp_code_style_lane_pack(const struct connectib_pmlp_code_style_lane *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module_num);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->module_lane);

}

void connectib_pmlp_code_style_lane_unpack(struct connectib_pmlp_code_style_lane *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->module_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 14;
	ptr_struct->module_lane = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_pmlp_code_style_lane_print(const struct connectib_pmlp_code_style_lane *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmlp_code_style_lane ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module_num           : " UH_FMT "\n", ptr_struct->module_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module_lane          : " UH_FMT "\n", ptr_struct->module_lane);

}

int connectib_pmlp_code_style_lane_size(void)
{
	 return 4;
}

void connectib_pmlp_code_style_lane_dump(const struct connectib_pmlp_code_style_lane *ptr_struct, FILE* file)
{
	connectib_pmlp_code_style_lane_print(ptr_struct, file, 0);
}

void connectib_dw_pack(const struct connectib_dw *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dw);

}

void connectib_dw_unpack(struct connectib_dw *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->dw = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dw_print(const struct connectib_dw *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dw ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dw                   : " U32H_FMT "\n", ptr_struct->dw);

}

int connectib_dw_size(void)
{
	 return 4;
}

void connectib_dw_dump(const struct connectib_dw *ptr_struct, FILE* file)
{
	connectib_dw_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_nvlog_pack(const struct connectib_nv_tlv_type_nvlog *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sub_class);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_nvlog_unpack(struct connectib_nv_tlv_type_nvlog *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 8;
	ptr_struct->sub_class = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_nvlog_print(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_nvlog ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sub_class            : " UH_FMT "\n", ptr_struct->sub_class);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_nvlog_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_nvlog_dump(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_nvlog_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_eswitch_pack(const struct connectib_nv_tlv_type_eswitch *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->port);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_eswitch_unpack(struct connectib_nv_tlv_type_eswitch *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 14;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_eswitch_print(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_eswitch ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : " UH_FMT "\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : " UH_FMT "\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_eswitch_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_eswitch_dump(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_eswitch_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_per_host_pack(const struct connectib_nv_tlv_type_per_host *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->parameter_index);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->function);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_per_host_unpack(struct connectib_nv_tlv_type_per_host *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 22;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset = 14;
	ptr_struct->function = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_per_host_print(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_per_host ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "function             : " UH_FMT "\n", ptr_struct->function);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : " UH_FMT "\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_per_host_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_per_host_dump(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_per_host_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_bmc_pack(const struct connectib_nv_tlv_type_bmc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 13, (u_int32_t)ptr_struct->parameter_index);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->channel);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_bmc_unpack(struct connectib_nv_tlv_type_bmc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 19;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 13);

	offset = 14;
	ptr_struct->channel = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_bmc_print(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_bmc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "channel              : " UH_FMT "\n", ptr_struct->channel);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : " UH_FMT "\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_bmc_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_bmc_dump(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_bmc_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_physical_port_pack(const struct connectib_nv_tlv_type_physical_port *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_physical_port_unpack(struct connectib_nv_tlv_type_physical_port *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 8;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_physical_port_print(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_physical_port ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : " UH_FMT "\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_physical_port_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_physical_port_dump(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_physical_port_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_global_pack(const struct connectib_nv_tlv_type_global *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->parameter_index);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_global_unpack(struct connectib_nv_tlv_type_global *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->parameter_index = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_global_print(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_global ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : " UH_FMT "\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : " UH_FMT "\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_global_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_global_dump(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_global_print(ptr_struct, file, 0);
}

void connectib_regular_qp_sub_type_pack(const union connectib_regular_qp_sub_type *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_regular_qp_eth_pack(&(ptr_struct->eth), ptr_buff);
}

void connectib_regular_qp_sub_type_unpack(union connectib_regular_qp_sub_type *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_regular_qp_eth_unpack(&(ptr_struct->eth), ptr_buff);
}

void connectib_regular_qp_sub_type_print(const union connectib_regular_qp_sub_type *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_regular_qp_sub_type ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipoib:\n");
	connectib_regular_qp_ipoib_print(&(ptr_struct->ipoib), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth:\n");
	connectib_regular_qp_eth_print(&(ptr_struct->eth), file, indent_level + 1);

}

int connectib_regular_qp_sub_type_size(void)
{
	 return 4;
}

void connectib_regular_qp_sub_type_dump(const union connectib_regular_qp_sub_type *ptr_struct, FILE* file)
{
	connectib_regular_qp_sub_type_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_other_pack(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->next_sqn_for_4page_allocate);

	offset = 32;
	connectib_cmdif_ctx_special_qp_commands_inner_pack(&(ptr_struct->inner), ptr_buff + offset/8);

}

void connectib_cmdif_ctx_special_qp_commands_other_unpack(struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->next_sqn_for_4page_allocate = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	connectib_cmdif_ctx_special_qp_commands_inner_unpack(&(ptr_struct->inner), ptr_buff + offset/8);

}

void connectib_cmdif_ctx_special_qp_commands_other_print(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_other ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_sqn_for_4page_allocate : " U32H_FMT "\n", ptr_struct->next_sqn_for_4page_allocate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inner:\n");
	connectib_cmdif_ctx_special_qp_commands_inner_print(&(ptr_struct->inner), file, indent_level + 1);

}

int connectib_cmdif_ctx_special_qp_commands_other_size(void)
{
	 return 16;
}

void connectib_cmdif_ctx_special_qp_commands_other_dump(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_other_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_rts2rts_pack(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->new_cqn_rcv);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->new_srqn_rmpn);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->srq_cre_type);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qp_params);

}

void connectib_cmdif_ctx_special_qp_commands_rts2rts_unpack(struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->new_cqn_rcv = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 40;
	ptr_struct->new_srqn_rmpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 36;
	ptr_struct->srq_cre_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->qp_params = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_qp_commands_rts2rts_print(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_rts2rts ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "new_cqn_rcv          : " UH_FMT "\n", ptr_struct->new_cqn_rcv);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "new_srqn_rmpn        : " UH_FMT "\n", ptr_struct->new_srqn_rmpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_cre_type         : " UH_FMT "\n", ptr_struct->srq_cre_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_params            : " U32H_FMT "\n", ptr_struct->qp_params);

}

int connectib_cmdif_ctx_special_qp_commands_rts2rts_size(void)
{
	 return 16;
}

void connectib_cmdif_ctx_special_qp_commands_rts2rts_dump(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_rts2rts_print(ptr_struct, file, 0);
}

void connectib_pmlp_code_style_pack(const struct connectib_pmlp_code_style *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->width);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(32, 32, i, 288, 1);
	connectib_pmlp_code_style_lane_pack(&(ptr_struct->local_lane[i]), ptr_buff + offset/8);
	}

}

void connectib_pmlp_code_style_unpack(struct connectib_pmlp_code_style *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->width = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(32, 32, i, 288, 1);
	connectib_pmlp_code_style_lane_unpack(&(ptr_struct->local_lane[i]), ptr_buff + offset/8);
	}

}

void connectib_pmlp_code_style_print(const struct connectib_pmlp_code_style *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmlp_code_style ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "width                : " UH_FMT "\n", ptr_struct->width);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_lane_%03d:\n", i);
	connectib_pmlp_code_style_lane_print(&(ptr_struct->local_lane[i]), file, indent_level + 1);
	}

}

int connectib_pmlp_code_style_size(void)
{
	 return 36;
}

void connectib_pmlp_code_style_dump(const struct connectib_pmlp_code_style *ptr_struct, FILE* file)
{
	connectib_pmlp_code_style_print(ptr_struct, file, 0);
}

void connectib_pmlp_prm_style_pack(const struct connectib_pmlp_prm_style *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->width);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module0);

	offset = 46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->lane0);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module1);

	offset = 78;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->lane1);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module2);

	offset = 110;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->lane2);

	offset = 152;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module3);

	offset = 142;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->lane3);

}

void connectib_pmlp_prm_style_unpack(struct connectib_pmlp_prm_style *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->width = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->module0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 46;
	ptr_struct->lane0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 88;
	ptr_struct->module1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 78;
	ptr_struct->lane1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 120;
	ptr_struct->module2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 110;
	ptr_struct->lane2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 152;
	ptr_struct->module3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 142;
	ptr_struct->lane3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_pmlp_prm_style_print(const struct connectib_pmlp_prm_style *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmlp_prm_style ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "width                : " UH_FMT "\n", ptr_struct->width);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module0              : " UH_FMT "\n", ptr_struct->module0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane0                : " UH_FMT "\n", ptr_struct->lane0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module1              : " UH_FMT "\n", ptr_struct->module1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane1                : " UH_FMT "\n", ptr_struct->lane1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module2              : " UH_FMT "\n", ptr_struct->module2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane2                : " UH_FMT "\n", ptr_struct->lane2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module3              : " UH_FMT "\n", ptr_struct->module3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane3                : " UH_FMT "\n", ptr_struct->lane3);

}

int connectib_pmlp_prm_style_size(void)
{
	 return 36;
}

void connectib_pmlp_prm_style_dump(const struct connectib_pmlp_prm_style *ptr_struct, FILE* file)
{
	connectib_pmlp_prm_style_print(ptr_struct, file, 0);
}

void connectib_register_access_data_reduced_pack(const struct connectib_register_access_data_reduced *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword[i]);
	}

}

void connectib_register_access_data_reduced_unpack(struct connectib_register_access_data_reduced *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_register_access_data_reduced_print(const struct connectib_register_access_data_reduced *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_access_data_reduced ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : " U32H_FMT "\n", i, ptr_struct->dword[i]);
	}

}

int connectib_register_access_data_reduced_size(void)
{
	 return 16;
}

void connectib_register_access_data_reduced_dump(const struct connectib_register_access_data_reduced *ptr_struct, FILE* file)
{
	connectib_register_access_data_reduced_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_hdr_pack(const struct connectib_nv_tlv_hdr *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 9, (u_int32_t)ptr_struct->length);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->writer_host_id);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->version);

	offset = 11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->writer_id);

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_current);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_default);

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rd_en);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ovr_en);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->header_type);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->priority);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->valid);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->type);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->crc16);

}

void connectib_nv_tlv_hdr_unpack(struct connectib_nv_tlv_hdr *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 23;
	ptr_struct->length = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 9);

	offset = 20;
	ptr_struct->writer_host_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 16;
	ptr_struct->version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 11;
	ptr_struct->writer_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 9;
	ptr_struct->read_current = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 8;
	ptr_struct->read_default = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 7;
	ptr_struct->rd_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->ovr_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 4;
	ptr_struct->header_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 2;
	ptr_struct->priority = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 0;
	ptr_struct->valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->type = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 80;
	ptr_struct->crc16 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_nv_tlv_hdr_print(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_hdr ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "length               : " UH_FMT "\n", ptr_struct->length);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "writer_host_id       : " UH_FMT "\n", ptr_struct->writer_host_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version              : " UH_FMT "\n", ptr_struct->version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "writer_id            : %s (" UH_FMT ")\n", (ptr_struct->writer_id == 0 ? ("NV_WRITER_ID_UNSPECIFIED") : ((ptr_struct->writer_id == 1 ? ("NV_WRITER_ID_CHASSIS_BMC") : ((ptr_struct->writer_id == 2 ? ("NV_WRITER_ID_MAD") : ((ptr_struct->writer_id == 3 ? ("NV_WRITER_ID_BMC") : ((ptr_struct->writer_id == 4 ? ("NV_WRITER_ID_CMD_IF") : ((ptr_struct->writer_id == 5 ? ("NV_WRITER_ID_ICMD") : ((ptr_struct->writer_id == 6 ? ("NV_WRITER_ID_ICMD_UEFI_HII") : ((ptr_struct->writer_id == 7 ? ("NV_WRITER_ID_ICMD_UEFI_CLP") : ((ptr_struct->writer_id == 8 ? ("NV_WRITER_ID_ICMD_FLEXBOOT") : ((ptr_struct->writer_id == 9 ? ("NV_WRITER_ID_ICMD_MLXCONFIG") : ((ptr_struct->writer_id == 10 ? ("NV_WRITER_ID_ICMD_USER1") : ((ptr_struct->writer_id == 11 ? ("NV_WRITER_ID_ICMD_USER2") : ((ptr_struct->writer_id == 31 ? ("NV_WRITER_ID_OTHER") : ("unknown")))))))))))))))))))))))))), ptr_struct->writer_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_current         : " UH_FMT "\n", ptr_struct->read_current);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_default         : " UH_FMT "\n", ptr_struct->read_default);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rd_en                : " UH_FMT "\n", ptr_struct->rd_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ovr_en               : " UH_FMT "\n", ptr_struct->ovr_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "header_type          : " UH_FMT "\n", ptr_struct->header_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "priority             : " UH_FMT "\n", ptr_struct->priority);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "valid                : " UH_FMT "\n", ptr_struct->valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type                 : " U32H_FMT "\n", ptr_struct->type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "crc16                : " UH_FMT "\n", ptr_struct->crc16);

}

int connectib_nv_tlv_hdr_size(void)
{
	 return 12;
}

void connectib_nv_tlv_hdr_dump(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file)
{
	connectib_nv_tlv_hdr_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_pack(const union connectib_nv_tlv_type *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_dw_pack(&(ptr_struct->as_dw), ptr_buff);
}

void connectib_nv_tlv_type_unpack(union connectib_nv_tlv_type *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_dw_unpack(&(ptr_struct->as_dw), ptr_buff);
}

void connectib_nv_tlv_type_print(const union connectib_nv_tlv_type *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "global:\n");
	connectib_nv_tlv_type_global_print(&(ptr_struct->global), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "physical_port:\n");
	connectib_nv_tlv_type_physical_port_print(&(ptr_struct->physical_port), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bmc:\n");
	connectib_nv_tlv_type_bmc_print(&(ptr_struct->bmc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "per_host:\n");
	connectib_nv_tlv_type_per_host_print(&(ptr_struct->per_host), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eswitch:\n");
	connectib_nv_tlv_type_eswitch_print(&(ptr_struct->eswitch), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvlog:\n");
	connectib_nv_tlv_type_nvlog_print(&(ptr_struct->nvlog), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "as_dw:\n");
	connectib_dw_print(&(ptr_struct->as_dw), file, indent_level + 1);

}

int connectib_nv_tlv_type_size(void)
{
	 return 4;
}

void connectib_nv_tlv_type_dump(const union connectib_nv_tlv_type *ptr_struct, FILE* file)
{
	connectib_nv_tlv_type_print(ptr_struct, file, 0);
}

void connectib_register_access_data_pack(const struct connectib_register_access_data *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword[i]);
	}

}

void connectib_register_access_data_unpack(struct connectib_register_access_data *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_register_access_data_print(const struct connectib_register_access_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_access_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : " U32H_FMT "\n", i, ptr_struct->dword[i]);
	}

}

int connectib_register_access_data_size(void)
{
	 return 32;
}

void connectib_register_access_data_dump(const struct connectib_register_access_data *ptr_struct, FILE* file)
{
	connectib_register_access_data_print(ptr_struct, file, 0);
}

void connectib_mfba_header_pack(const struct connectib_mfba_header *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 9, (u_int32_t)ptr_struct->size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

}

void connectib_mfba_header_unpack(struct connectib_mfba_header *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 55;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 9);

	offset = 72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_mfba_header_print(const struct connectib_mfba_header *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfba_header ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : " UH_FMT "\n", ptr_struct->address);

}

int connectib_mfba_header_size(void)
{
	 return 12;
}

void connectib_mfba_header_dump(const struct connectib_mfba_header *ptr_struct, FILE* file)
{
	connectib_mfba_header_print(ptr_struct, file, 0);
}

void connectib_pmmp_sfp_protocol_override_layout_pack(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tengig_ethernet_compliance_code);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cable_technology);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->bit_rate);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ethernet_compliance_code);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ext_ethernet_compliance_code);

}

void connectib_pmmp_sfp_protocol_override_layout_unpack(struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->tengig_ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->cable_technology = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->bit_rate = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->ext_ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_pmmp_sfp_protocol_override_layout_print(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmmp_sfp_protocol_override_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tengig_ethernet_compliance_code : " UH_FMT "\n", ptr_struct->tengig_ethernet_compliance_code);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cable_technology     : " UH_FMT "\n", ptr_struct->cable_technology);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bit_rate             : " UH_FMT "\n", ptr_struct->bit_rate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ethernet_compliance_code : " UH_FMT "\n", ptr_struct->ethernet_compliance_code);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ext_ethernet_compliance_code : " UH_FMT "\n", ptr_struct->ext_ethernet_compliance_code);

}

int connectib_pmmp_sfp_protocol_override_layout_size(void)
{
	 return 12;
}

void connectib_pmmp_sfp_protocol_override_layout_dump(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, FILE* file)
{
	connectib_pmmp_sfp_protocol_override_layout_print(ptr_struct, file, 0);
}

void connectib_pmmp_qsfp_protocol_override_layout_pack(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ethernet_compliance_code);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cable_breakout);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->giga_ethernet_compliance_code);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ext_ethernet_compliance_code);

}

void connectib_pmmp_qsfp_protocol_override_layout_unpack(struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->cable_breakout = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->giga_ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->ext_ethernet_compliance_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_pmmp_qsfp_protocol_override_layout_print(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmmp_qsfp_protocol_override_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ethernet_compliance_code : " UH_FMT "\n", ptr_struct->ethernet_compliance_code);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cable_breakout       : " UH_FMT "\n", ptr_struct->cable_breakout);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "giga_ethernet_compliance_code : " UH_FMT "\n", ptr_struct->giga_ethernet_compliance_code);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ext_ethernet_compliance_code : " UH_FMT "\n", ptr_struct->ext_ethernet_compliance_code);

}

int connectib_pmmp_qsfp_protocol_override_layout_size(void)
{
	 return 12;
}

void connectib_pmmp_qsfp_protocol_override_layout_dump(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, FILE* file)
{
	connectib_pmmp_qsfp_protocol_override_layout_print(ptr_struct, file, 0);
}

void connectib_pcie_timers_states_pack(const struct connectib_pcie_timers_states *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_boot_image_start);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_link_image);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->calibration_time);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_first_perst);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_detect_state);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_l0);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_crs_en);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_plastic_image_start);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_to_iron_image_start);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->perst_handler);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->times_in_l1);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->times_in_l23);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dl_down);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->config_cycle1usec);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->config_cycle2to7usec);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->config_cycle8to15usec);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->config_cycle16to63usec);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->config_cycle64usec);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->correctable_err_msg_sent);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->non_fatal_err_msg_sent);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fatal_err_msg_sent);

}

void connectib_pcie_timers_states_unpack(struct connectib_pcie_timers_states *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->life_time_counter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->life_time_counter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->time_to_boot_image_start = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->time_to_link_image = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->calibration_time = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->time_to_first_perst = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->time_to_detect_state = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->time_to_l0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->time_to_crs_en = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->time_to_plastic_image_start = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->time_to_iron_image_start = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->perst_handler = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->times_in_l1 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->times_in_l23 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->dl_down = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->config_cycle1usec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->config_cycle2to7usec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->config_cycle8to15usec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->config_cycle16to63usec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->config_cycle64usec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->correctable_err_msg_sent = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->non_fatal_err_msg_sent = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->fatal_err_msg_sent = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pcie_timers_states_print(const struct connectib_pcie_timers_states *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcie_timers_states ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_high : " U32H_FMT "\n", ptr_struct->life_time_counter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_low : " U32H_FMT "\n", ptr_struct->life_time_counter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_boot_image_start : " U32H_FMT "\n", ptr_struct->time_to_boot_image_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_link_image   : " U32H_FMT "\n", ptr_struct->time_to_link_image);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "calibration_time     : " U32H_FMT "\n", ptr_struct->calibration_time);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_first_perst  : " U32H_FMT "\n", ptr_struct->time_to_first_perst);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_detect_state : " U32H_FMT "\n", ptr_struct->time_to_detect_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_l0           : " U32H_FMT "\n", ptr_struct->time_to_l0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_crs_en       : " U32H_FMT "\n", ptr_struct->time_to_crs_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_plastic_image_start : " U32H_FMT "\n", ptr_struct->time_to_plastic_image_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_to_iron_image_start : " U32H_FMT "\n", ptr_struct->time_to_iron_image_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "perst_handler        : " U32H_FMT "\n", ptr_struct->perst_handler);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "times_in_l1          : " U32H_FMT "\n", ptr_struct->times_in_l1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "times_in_l23         : " U32H_FMT "\n", ptr_struct->times_in_l23);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dl_down              : " U32H_FMT "\n", ptr_struct->dl_down);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "config_cycle1usec    : " U32H_FMT "\n", ptr_struct->config_cycle1usec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "config_cycle2to7usec : " U32H_FMT "\n", ptr_struct->config_cycle2to7usec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "config_cycle8to15usec : " U32H_FMT "\n", ptr_struct->config_cycle8to15usec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "config_cycle16to63usec : " U32H_FMT "\n", ptr_struct->config_cycle16to63usec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "config_cycle64usec   : " U32H_FMT "\n", ptr_struct->config_cycle64usec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "correctable_err_msg_sent : " U32H_FMT "\n", ptr_struct->correctable_err_msg_sent);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "non_fatal_err_msg_sent : " U32H_FMT "\n", ptr_struct->non_fatal_err_msg_sent);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fatal_err_msg_sent   : " U32H_FMT "\n", ptr_struct->fatal_err_msg_sent);

}

int connectib_pcie_timers_states_size(void)
{
	 return 248;
}

void connectib_pcie_timers_states_dump(const struct connectib_pcie_timers_states *ptr_struct, FILE* file)
{
	connectib_pcie_timers_states_print(ptr_struct, file, 0);
}

void connectib_pcie_lanes_counters_pack(const struct connectib_pcie_lanes_counters *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane0);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane1);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane2);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane3);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane4);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane5);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane6);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane7);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane8);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane9);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane10);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane11);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane12);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane13);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane14);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_counter_lane15);

}

void connectib_pcie_lanes_counters_unpack(struct connectib_pcie_lanes_counters *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->life_time_counter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->life_time_counter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->error_counter_lane0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->error_counter_lane1 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->error_counter_lane2 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->error_counter_lane3 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->error_counter_lane4 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->error_counter_lane5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->error_counter_lane6 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->error_counter_lane7 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->error_counter_lane8 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->error_counter_lane9 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->error_counter_lane10 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->error_counter_lane11 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->error_counter_lane12 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->error_counter_lane13 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->error_counter_lane14 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->error_counter_lane15 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pcie_lanes_counters_print(const struct connectib_pcie_lanes_counters *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcie_lanes_counters ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_high : " U32H_FMT "\n", ptr_struct->life_time_counter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_low : " U32H_FMT "\n", ptr_struct->life_time_counter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane0  : " U32H_FMT "\n", ptr_struct->error_counter_lane0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane1  : " U32H_FMT "\n", ptr_struct->error_counter_lane1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane2  : " U32H_FMT "\n", ptr_struct->error_counter_lane2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane3  : " U32H_FMT "\n", ptr_struct->error_counter_lane3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane4  : " U32H_FMT "\n", ptr_struct->error_counter_lane4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane5  : " U32H_FMT "\n", ptr_struct->error_counter_lane5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane6  : " U32H_FMT "\n", ptr_struct->error_counter_lane6);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane7  : " U32H_FMT "\n", ptr_struct->error_counter_lane7);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane8  : " U32H_FMT "\n", ptr_struct->error_counter_lane8);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane9  : " U32H_FMT "\n", ptr_struct->error_counter_lane9);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane10 : " U32H_FMT "\n", ptr_struct->error_counter_lane10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane11 : " U32H_FMT "\n", ptr_struct->error_counter_lane11);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane12 : " U32H_FMT "\n", ptr_struct->error_counter_lane12);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane13 : " U32H_FMT "\n", ptr_struct->error_counter_lane13);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane14 : " U32H_FMT "\n", ptr_struct->error_counter_lane14);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_counter_lane15 : " U32H_FMT "\n", ptr_struct->error_counter_lane15);

}

int connectib_pcie_lanes_counters_size(void)
{
	 return 248;
}

void connectib_pcie_lanes_counters_dump(const struct connectib_pcie_lanes_counters *ptr_struct, FILE* file)
{
	connectib_pcie_lanes_counters_print(ptr_struct, file, 0);
}

void connectib_pcie_perf_counters_pack(const struct connectib_pcie_perf_counters *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->life_time_counter_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_errors);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_errors);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->l0_to_recovery_eieos);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->l0_to_recovery_ts);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->l0_to_recovery_framing);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->l0_to_recovery_retrain);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->crc_error_dllp);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->crc_error_tlp);

}

void connectib_pcie_perf_counters_unpack(struct connectib_pcie_perf_counters *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->life_time_counter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->life_time_counter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->rx_errors = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->tx_errors = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->l0_to_recovery_eieos = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->l0_to_recovery_ts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->l0_to_recovery_framing = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->l0_to_recovery_retrain = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->crc_error_dllp = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->crc_error_tlp = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pcie_perf_counters_print(const struct connectib_pcie_perf_counters *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcie_perf_counters ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_high : " U32H_FMT "\n", ptr_struct->life_time_counter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "life_time_counter_low : " U32H_FMT "\n", ptr_struct->life_time_counter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_errors            : " U32H_FMT "\n", ptr_struct->rx_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_errors            : " U32H_FMT "\n", ptr_struct->tx_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0_to_recovery_eieos : " U32H_FMT "\n", ptr_struct->l0_to_recovery_eieos);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0_to_recovery_ts    : " U32H_FMT "\n", ptr_struct->l0_to_recovery_ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0_to_recovery_framing : " U32H_FMT "\n", ptr_struct->l0_to_recovery_framing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0_to_recovery_retrain : " U32H_FMT "\n", ptr_struct->l0_to_recovery_retrain);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "crc_error_dllp       : " U32H_FMT "\n", ptr_struct->crc_error_dllp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "crc_error_tlp        : " U32H_FMT "\n", ptr_struct->crc_error_tlp);

}

int connectib_pcie_perf_counters_size(void)
{
	 return 200;
}

void connectib_pcie_perf_counters_dump(const struct connectib_pcie_perf_counters *ptr_struct, FILE* file)
{
	connectib_pcie_perf_counters_print(ptr_struct, file, 0);
}

void connectib_phys_layer_stat_cntrs_pack(const struct connectib_phys_layer_stat_cntrs *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_since_last_clear_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_since_last_clear_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_received_bits_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_received_bits_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_symbol_errors_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_symbol_errors_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane0_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane0_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane1_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane1_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane2_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane2_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane3_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->phy_corrected_bits_lane3_low);

	offset = 796;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_ber_coef);

	offset = 784;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->raw_ber_magnitude);

	offset = 828;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->effective_ber_coef);

	offset = 816;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->effective_ber_magnitude);

}

void connectib_phys_layer_stat_cntrs_unpack(struct connectib_phys_layer_stat_cntrs *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->time_since_last_clear_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->time_since_last_clear_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->phy_received_bits_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->phy_received_bits_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->phy_symbol_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->phy_symbol_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->phy_corrected_bits_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->phy_corrected_bits_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->phy_corrected_bits_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->phy_corrected_bits_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->phy_corrected_bits_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->phy_corrected_bits_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->phy_corrected_bits_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->phy_corrected_bits_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->phy_corrected_bits_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->phy_corrected_bits_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 796;
	ptr_struct->raw_ber_coef = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 784;
	ptr_struct->raw_ber_magnitude = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 828;
	ptr_struct->effective_ber_coef = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 816;
	ptr_struct->effective_ber_magnitude = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_phys_layer_stat_cntrs_print(const struct connectib_phys_layer_stat_cntrs *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_phys_layer_stat_cntrs ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_high : " U32H_FMT "\n", ptr_struct->time_since_last_clear_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_low : " U32H_FMT "\n", ptr_struct->time_since_last_clear_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_received_bits_high : " U32H_FMT "\n", ptr_struct->phy_received_bits_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_received_bits_low : " U32H_FMT "\n", ptr_struct->phy_received_bits_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_symbol_errors_high : " U32H_FMT "\n", ptr_struct->phy_symbol_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_symbol_errors_low : " U32H_FMT "\n", ptr_struct->phy_symbol_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_high : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_low : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane0_high : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane0_low : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane1_high : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane1_low : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane2_high : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane2_low : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane3_high : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phy_corrected_bits_lane3_low : " U32H_FMT "\n", ptr_struct->phy_corrected_bits_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_ber_coef         : " UH_FMT "\n", ptr_struct->raw_ber_coef);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_ber_magnitude    : " UH_FMT "\n", ptr_struct->raw_ber_magnitude);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "effective_ber_coef   : " UH_FMT "\n", ptr_struct->effective_ber_coef);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "effective_ber_magnitude : " UH_FMT "\n", ptr_struct->effective_ber_magnitude);

}

int connectib_phys_layer_stat_cntrs_size(void)
{
	 return 248;
}

void connectib_phys_layer_stat_cntrs_dump(const struct connectib_phys_layer_stat_cntrs *ptr_struct, FILE* file)
{
	connectib_phys_layer_stat_cntrs_print(ptr_struct, file, 0);
}

void connectib_eth_per_traffic_congestion_grp_data_layout_pack(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->wred_discard_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->wred_discard_low);

}

void connectib_eth_per_traffic_congestion_grp_data_layout_unpack(struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->wred_discard_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->wred_discard_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_per_traffic_congestion_grp_data_layout_print(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_per_traffic_congestion_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wred_discard_high    : " U32H_FMT "\n", ptr_struct->wred_discard_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wred_discard_low     : " U32H_FMT "\n", ptr_struct->wred_discard_low);

}

int connectib_eth_per_traffic_congestion_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_per_traffic_congestion_grp_data_layout_dump(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_per_traffic_congestion_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_ib_port_counters_pack(const struct connectib_ib_port_counters *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_downed_counter);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_error_recovery_counter);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->symbol_error_counter);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_remote_physical_errors);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_errors);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_xmit_discards);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_switch_relay_errors);

	offset = 124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->excessive_buffer_overrun_errors);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->local_link_integrity_errors);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_rcv_constraint_errors);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_xmit_constraint_errors);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vl15_dropped);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_xmit_data);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_rcv_data);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_xmit_pkts);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_rcv_pkts);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_xmit_wait);

}

void connectib_ib_port_counters_unpack(struct connectib_ib_port_counters *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->link_downed_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->link_error_recovery_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->symbol_error_counter = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 48;
	ptr_struct->port_rcv_remote_physical_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 32;
	ptr_struct->port_rcv_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 80;
	ptr_struct->port_xmit_discards = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->port_rcv_switch_relay_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 124;
	ptr_struct->excessive_buffer_overrun_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 120;
	ptr_struct->local_link_integrity_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 104;
	ptr_struct->port_rcv_constraint_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->port_xmit_constraint_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 144;
	ptr_struct->vl15_dropped = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 160;
	ptr_struct->port_xmit_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->port_rcv_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->port_xmit_pkts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->port_rcv_pkts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->port_xmit_wait = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_ib_port_counters_print(const struct connectib_ib_port_counters *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ib_port_counters ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_downed_counter  : " UH_FMT "\n", ptr_struct->link_downed_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_error_recovery_counter : " UH_FMT "\n", ptr_struct->link_error_recovery_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_error_counter : " UH_FMT "\n", ptr_struct->symbol_error_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_remote_physical_errors : " UH_FMT "\n", ptr_struct->port_rcv_remote_physical_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_errors      : " UH_FMT "\n", ptr_struct->port_rcv_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_discards   : " UH_FMT "\n", ptr_struct->port_xmit_discards);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_switch_relay_errors : " UH_FMT "\n", ptr_struct->port_rcv_switch_relay_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "excessive_buffer_overrun_errors : " UH_FMT "\n", ptr_struct->excessive_buffer_overrun_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_link_integrity_errors : " UH_FMT "\n", ptr_struct->local_link_integrity_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_constraint_errors : " UH_FMT "\n", ptr_struct->port_rcv_constraint_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_constraint_errors : " UH_FMT "\n", ptr_struct->port_xmit_constraint_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl15_dropped         : " UH_FMT "\n", ptr_struct->vl15_dropped);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_data       : " U32H_FMT "\n", ptr_struct->port_xmit_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_data        : " U32H_FMT "\n", ptr_struct->port_rcv_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_pkts       : " U32H_FMT "\n", ptr_struct->port_xmit_pkts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_pkts        : " U32H_FMT "\n", ptr_struct->port_rcv_pkts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_wait       : " U32H_FMT "\n", ptr_struct->port_xmit_wait);

}

int connectib_ib_port_counters_size(void)
{
	 return 248;
}

void connectib_ib_port_counters_dump(const struct connectib_ib_port_counters *ptr_struct, FILE* file)
{
	connectib_ib_port_counters_print(ptr_struct, file, 0);
}

void connectib_llr_counters_pack(const struct connectib_llr_counters *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_cells_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_cells_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_error_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_error_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_crc_error_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_rx_crc_error_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_cells_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_cells_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_ret_cells_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_ret_cells_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_ret_events_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->llr_tx_ret_events_low);

}

void connectib_llr_counters_unpack(struct connectib_llr_counters *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->llr_rx_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->llr_rx_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->llr_rx_error_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->llr_rx_error_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->llr_rx_crc_error_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->llr_rx_crc_error_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->llr_tx_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->llr_tx_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->llr_tx_ret_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->llr_tx_ret_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->llr_tx_ret_events_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->llr_tx_ret_events_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_llr_counters_print(const struct connectib_llr_counters *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_llr_counters ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_cells_high    : " U32H_FMT "\n", ptr_struct->llr_rx_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_cells_low     : " U32H_FMT "\n", ptr_struct->llr_rx_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_error_high    : " U32H_FMT "\n", ptr_struct->llr_rx_error_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_error_low     : " U32H_FMT "\n", ptr_struct->llr_rx_error_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_crc_error_high : " U32H_FMT "\n", ptr_struct->llr_rx_crc_error_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_crc_error_low : " U32H_FMT "\n", ptr_struct->llr_rx_crc_error_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_cells_high    : " U32H_FMT "\n", ptr_struct->llr_tx_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_cells_low     : " U32H_FMT "\n", ptr_struct->llr_tx_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_cells_high : " U32H_FMT "\n", ptr_struct->llr_tx_ret_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_cells_low : " U32H_FMT "\n", ptr_struct->llr_tx_ret_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_events_high : " U32H_FMT "\n", ptr_struct->llr_tx_ret_events_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_events_low : " U32H_FMT "\n", ptr_struct->llr_tx_ret_events_low);

}

int connectib_llr_counters_size(void)
{
	 return 248;
}

void connectib_llr_counters_dump(const struct connectib_llr_counters *ptr_struct, FILE* file)
{
	connectib_llr_counters_print(ptr_struct, file, 0);
}

void connectib_discard_cntrs_grp_data_pack(const struct connectib_discard_cntrs_grp_data *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_general_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_general_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_policy_engine_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_policy_engine_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_vlan_membership_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_vlan_membership_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_tag_frame_type_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_tag_frame_type_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_vlan_membership_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_vlan_membership_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->loopback_filter_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->loopback_filter_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_general_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_general_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_link_down_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_link_down_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_hoq_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_hoq_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_isolation_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_isolation_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_policy_engine_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_policy_engine_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_tx_link_down_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ingress_tx_link_down_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_stp_filter_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_stp_filter_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_hoq_stall_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->egress_hoq_stall_low);

}

void connectib_discard_cntrs_grp_data_unpack(struct connectib_discard_cntrs_grp_data *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->ingress_general_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->ingress_general_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->ingress_policy_engine_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->ingress_policy_engine_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->ingress_vlan_membership_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->ingress_vlan_membership_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->ingress_tag_frame_type_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->ingress_tag_frame_type_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->egress_vlan_membership_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->egress_vlan_membership_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->loopback_filter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->loopback_filter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->egress_general_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->egress_general_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->egress_link_down_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->egress_link_down_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->egress_hoq_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->egress_hoq_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->port_isolation_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->port_isolation_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->egress_policy_engine_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->egress_policy_engine_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->ingress_tx_link_down_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->ingress_tx_link_down_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->egress_stp_filter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->egress_stp_filter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->egress_hoq_stall_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->egress_hoq_stall_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_discard_cntrs_grp_data_print(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_discard_cntrs_grp_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_general_high : " U32H_FMT "\n", ptr_struct->ingress_general_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_general_low  : " U32H_FMT "\n", ptr_struct->ingress_general_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_policy_engine_high : " U32H_FMT "\n", ptr_struct->ingress_policy_engine_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_policy_engine_low : " U32H_FMT "\n", ptr_struct->ingress_policy_engine_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_vlan_membership_high : " U32H_FMT "\n", ptr_struct->ingress_vlan_membership_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_vlan_membership_low : " U32H_FMT "\n", ptr_struct->ingress_vlan_membership_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tag_frame_type_high : " U32H_FMT "\n", ptr_struct->ingress_tag_frame_type_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tag_frame_type_low : " U32H_FMT "\n", ptr_struct->ingress_tag_frame_type_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_vlan_membership_high : " U32H_FMT "\n", ptr_struct->egress_vlan_membership_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_vlan_membership_low : " U32H_FMT "\n", ptr_struct->egress_vlan_membership_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "loopback_filter_high : " U32H_FMT "\n", ptr_struct->loopback_filter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "loopback_filter_low  : " U32H_FMT "\n", ptr_struct->loopback_filter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_general_high  : " U32H_FMT "\n", ptr_struct->egress_general_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_general_low   : " U32H_FMT "\n", ptr_struct->egress_general_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_link_down_high : " U32H_FMT "\n", ptr_struct->egress_link_down_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_link_down_low : " U32H_FMT "\n", ptr_struct->egress_link_down_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_high      : " U32H_FMT "\n", ptr_struct->egress_hoq_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_low       : " U32H_FMT "\n", ptr_struct->egress_hoq_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_isolation_high  : " U32H_FMT "\n", ptr_struct->port_isolation_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_isolation_low   : " U32H_FMT "\n", ptr_struct->port_isolation_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_policy_engine_high : " U32H_FMT "\n", ptr_struct->egress_policy_engine_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_policy_engine_low : " U32H_FMT "\n", ptr_struct->egress_policy_engine_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tx_link_down_high : " U32H_FMT "\n", ptr_struct->ingress_tx_link_down_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tx_link_down_low : " U32H_FMT "\n", ptr_struct->ingress_tx_link_down_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_stp_filter_high : " U32H_FMT "\n", ptr_struct->egress_stp_filter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_stp_filter_low : " U32H_FMT "\n", ptr_struct->egress_stp_filter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_stall_high : " U32H_FMT "\n", ptr_struct->egress_hoq_stall_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_stall_low : " U32H_FMT "\n", ptr_struct->egress_hoq_stall_low);

}

int connectib_discard_cntrs_grp_data_size(void)
{
	 return 248;
}

void connectib_discard_cntrs_grp_data_dump(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file)
{
	connectib_discard_cntrs_grp_data_print(ptr_struct, file, 0);
}

void connectib_phys_layer_cntrs_pack(const struct connectib_phys_layer_cntrs *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_since_last_clear_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_since_last_clear_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->symbol_errors_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->symbol_errors_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sync_headers_errors_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sync_headers_errors_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane0_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane0_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane1_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane1_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane2_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane2_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane3_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->edpl_bip_errors_lane3_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane0_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane0_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane1_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane1_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane2_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane2_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane3_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_corrected_blocks_lane3_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane0_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane0_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane1_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane1_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane2_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane2_low);

	offset = 896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane3_high);

	offset = 928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_fec_uncorrectable_blocks_lane3_low);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_blocks_high);

	offset = 992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_blocks_low);

	offset = 1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_uncorrectable_blocks_high);

	offset = 1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_uncorrectable_blocks_low);

	offset = 1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_no_errors_blocks_high);

	offset = 1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_no_errors_blocks_low);

	offset = 1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_single_error_blocks_high);

	offset = 1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_single_error_blocks_low);

	offset = 1216;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_total_high);

	offset = 1248;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_total_low);

	offset = 1280;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane0_high);

	offset = 1312;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane0_low);

	offset = 1344;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane1_high);

	offset = 1376;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane1_low);

	offset = 1408;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane2_high);

	offset = 1440;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane2_low);

	offset = 1472;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane3_high);

	offset = 1504;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_corrected_symbols_lane3_low);

	offset = 1536;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->link_down_events);

	offset = 1568;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->successful_recovery_events);

}

void connectib_phys_layer_cntrs_unpack(struct connectib_phys_layer_cntrs *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->time_since_last_clear_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->time_since_last_clear_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->symbol_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->symbol_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->sync_headers_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->sync_headers_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->edpl_bip_errors_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->edpl_bip_errors_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->edpl_bip_errors_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->edpl_bip_errors_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->edpl_bip_errors_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->edpl_bip_errors_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->edpl_bip_errors_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->edpl_bip_errors_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->fc_fec_corrected_blocks_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->fc_fec_corrected_blocks_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->fc_fec_corrected_blocks_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->fc_fec_corrected_blocks_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->fc_fec_corrected_blocks_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->fc_fec_corrected_blocks_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->fc_fec_corrected_blocks_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->fc_fec_corrected_blocks_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->fc_fec_uncorrectable_blocks_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->fc_fec_uncorrectable_blocks_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->fc_fec_uncorrectable_blocks_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->fc_fec_uncorrectable_blocks_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->fc_fec_uncorrectable_blocks_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->fc_fec_uncorrectable_blocks_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 896;
	ptr_struct->fc_fec_uncorrectable_blocks_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 928;
	ptr_struct->fc_fec_uncorrectable_blocks_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 960;
	ptr_struct->rs_fec_corrected_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 992;
	ptr_struct->rs_fec_corrected_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1024;
	ptr_struct->rs_fec_uncorrectable_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1056;
	ptr_struct->rs_fec_uncorrectable_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1088;
	ptr_struct->rs_fec_no_errors_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1120;
	ptr_struct->rs_fec_no_errors_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1152;
	ptr_struct->rs_fec_single_error_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1184;
	ptr_struct->rs_fec_single_error_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1216;
	ptr_struct->rs_fec_corrected_symbols_total_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1248;
	ptr_struct->rs_fec_corrected_symbols_total_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1280;
	ptr_struct->rs_fec_corrected_symbols_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1312;
	ptr_struct->rs_fec_corrected_symbols_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1344;
	ptr_struct->rs_fec_corrected_symbols_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1376;
	ptr_struct->rs_fec_corrected_symbols_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1408;
	ptr_struct->rs_fec_corrected_symbols_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1440;
	ptr_struct->rs_fec_corrected_symbols_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1472;
	ptr_struct->rs_fec_corrected_symbols_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1504;
	ptr_struct->rs_fec_corrected_symbols_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1536;
	ptr_struct->link_down_events = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1568;
	ptr_struct->successful_recovery_events = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_phys_layer_cntrs_print(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_phys_layer_cntrs ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_high : " U32H_FMT "\n", ptr_struct->time_since_last_clear_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_low : " U32H_FMT "\n", ptr_struct->time_since_last_clear_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_errors_high   : " U32H_FMT "\n", ptr_struct->symbol_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_errors_low    : " U32H_FMT "\n", ptr_struct->symbol_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sync_headers_errors_high : " U32H_FMT "\n", ptr_struct->sync_headers_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sync_headers_errors_low : " U32H_FMT "\n", ptr_struct->sync_headers_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane0_high : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane0_low : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane1_high : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane1_low : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane2_high : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane2_low : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane3_high : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane3_low : " U32H_FMT "\n", ptr_struct->edpl_bip_errors_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane0_high : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane0_low : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane1_high : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane1_low : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane2_high : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane2_low : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane3_high : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane3_low : " U32H_FMT "\n", ptr_struct->fc_fec_corrected_blocks_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane0_high : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane0_low : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane1_high : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane1_low : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane2_high : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane2_low : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane3_high : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane3_low : " U32H_FMT "\n", ptr_struct->fc_fec_uncorrectable_blocks_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_blocks_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_blocks_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_uncorrectable_blocks_high : " U32H_FMT "\n", ptr_struct->rs_fec_uncorrectable_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_uncorrectable_blocks_low : " U32H_FMT "\n", ptr_struct->rs_fec_uncorrectable_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_no_errors_blocks_high : " U32H_FMT "\n", ptr_struct->rs_fec_no_errors_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_no_errors_blocks_low : " U32H_FMT "\n", ptr_struct->rs_fec_no_errors_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_single_error_blocks_high : " U32H_FMT "\n", ptr_struct->rs_fec_single_error_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_single_error_blocks_low : " U32H_FMT "\n", ptr_struct->rs_fec_single_error_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_total_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_total_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_total_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_total_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane0_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane0_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane1_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane1_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane2_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane2_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane3_high : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane3_low : " U32H_FMT "\n", ptr_struct->rs_fec_corrected_symbols_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_down_events     : " U32H_FMT "\n", ptr_struct->link_down_events);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "successful_recovery_events : " U32H_FMT "\n", ptr_struct->successful_recovery_events);

}

int connectib_phys_layer_cntrs_size(void)
{
	 return 200;
}

void connectib_phys_layer_cntrs_dump(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file)
{
	connectib_phys_layer_cntrs_print(ptr_struct, file, 0);
}

void connectib_correct_on_demand_layout_pack(const struct connectib_correct_on_demand_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rewind_counter_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rewind_counter_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->data_rewinded_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->data_rewinded_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pkt_rewinded_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pkt_rewinded_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->total_rcv_data_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->total_rcv_data_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->total_rcv_pkt_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->total_rcv_pkt_low);

}

void connectib_correct_on_demand_layout_unpack(struct connectib_correct_on_demand_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->rewind_counter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->rewind_counter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->data_rewinded_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->data_rewinded_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->pkt_rewinded_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->pkt_rewinded_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->total_rcv_data_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->total_rcv_data_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->total_rcv_pkt_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->total_rcv_pkt_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_correct_on_demand_layout_print(const struct connectib_correct_on_demand_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_correct_on_demand_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rewind_counter_high  : " U32H_FMT "\n", ptr_struct->rewind_counter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rewind_counter_low   : " U32H_FMT "\n", ptr_struct->rewind_counter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_rewinded_high   : " U32H_FMT "\n", ptr_struct->data_rewinded_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_rewinded_low    : " U32H_FMT "\n", ptr_struct->data_rewinded_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkt_rewinded_high    : " U32H_FMT "\n", ptr_struct->pkt_rewinded_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkt_rewinded_low     : " U32H_FMT "\n", ptr_struct->pkt_rewinded_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_rcv_data_high  : " U32H_FMT "\n", ptr_struct->total_rcv_data_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_rcv_data_low   : " U32H_FMT "\n", ptr_struct->total_rcv_data_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_rcv_pkt_high   : " U32H_FMT "\n", ptr_struct->total_rcv_pkt_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_rcv_pkt_low    : " U32H_FMT "\n", ptr_struct->total_rcv_pkt_low);

}

int connectib_correct_on_demand_layout_size(void)
{
	 return 56;
}

void connectib_correct_on_demand_layout_dump(const struct connectib_correct_on_demand_layout *ptr_struct, FILE* file)
{
	connectib_correct_on_demand_layout_print(ptr_struct, file, 0);
}

void connectib_eth_per_traffic_grp_data_layout_pack(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->transmit_queue_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->transmit_queue_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->no_buffer_discard_uc_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->no_buffer_discard_uc_low);

}

void connectib_eth_per_traffic_grp_data_layout_unpack(struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->transmit_queue_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->transmit_queue_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->no_buffer_discard_uc_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->no_buffer_discard_uc_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_per_traffic_grp_data_layout_print(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_per_traffic_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transmit_queue_high  : " U32H_FMT "\n", ptr_struct->transmit_queue_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transmit_queue_low   : " U32H_FMT "\n", ptr_struct->transmit_queue_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_buffer_discard_uc_high : " U32H_FMT "\n", ptr_struct->no_buffer_discard_uc_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_buffer_discard_uc_low : " U32H_FMT "\n", ptr_struct->no_buffer_discard_uc_low);

}

int connectib_eth_per_traffic_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_per_traffic_grp_data_layout_dump(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_per_traffic_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_per_prio_grp_data_layout_pack(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_octets_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_octets_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_frames_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_frames_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_octets_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_octets_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_frames_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_frames_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_duration_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_duration_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_pause_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_pause_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_pause_duration_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_pause_duration_low);

	offset = 896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_transition_high);

	offset = 928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_pause_transition_low);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_discards_high);

	offset = 992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_discards_low);

	offset = 1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->device_stall_minor_watermark_cnt_high);

	offset = 1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->device_stall_minor_watermark_cnt_low);

	offset = 1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->device_stall_critical_watermark_cnt_high);

	offset = 1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->device_stall_critical_watermark_cnt_low);

}

void connectib_eth_per_prio_grp_data_layout_unpack(struct connectib_eth_per_prio_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->rx_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->rx_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->rx_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->rx_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->tx_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->tx_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->tx_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->tx_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->rx_pause_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->rx_pause_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->rx_pause_duration_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->rx_pause_duration_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->tx_pause_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->tx_pause_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->tx_pause_duration_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->tx_pause_duration_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 896;
	ptr_struct->rx_pause_transition_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 928;
	ptr_struct->rx_pause_transition_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 960;
	ptr_struct->rx_discards_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 992;
	ptr_struct->rx_discards_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1024;
	ptr_struct->device_stall_minor_watermark_cnt_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1056;
	ptr_struct->device_stall_minor_watermark_cnt_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1088;
	ptr_struct->device_stall_critical_watermark_cnt_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1120;
	ptr_struct->device_stall_critical_watermark_cnt_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_per_prio_grp_data_layout_print(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_per_prio_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_octets_high       : " U32H_FMT "\n", ptr_struct->rx_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_octets_low        : " U32H_FMT "\n", ptr_struct->rx_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_frames_high       : " U32H_FMT "\n", ptr_struct->rx_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_frames_low        : " U32H_FMT "\n", ptr_struct->rx_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_octets_high       : " U32H_FMT "\n", ptr_struct->tx_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_octets_low        : " U32H_FMT "\n", ptr_struct->tx_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_frames_high       : " U32H_FMT "\n", ptr_struct->tx_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_frames_low        : " U32H_FMT "\n", ptr_struct->tx_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_high        : " U32H_FMT "\n", ptr_struct->rx_pause_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_low         : " U32H_FMT "\n", ptr_struct->rx_pause_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_duration_high : " U32H_FMT "\n", ptr_struct->rx_pause_duration_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_duration_low : " U32H_FMT "\n", ptr_struct->rx_pause_duration_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_high        : " U32H_FMT "\n", ptr_struct->tx_pause_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_low         : " U32H_FMT "\n", ptr_struct->tx_pause_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_duration_high : " U32H_FMT "\n", ptr_struct->tx_pause_duration_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_duration_low : " U32H_FMT "\n", ptr_struct->tx_pause_duration_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_transition_high : " U32H_FMT "\n", ptr_struct->rx_pause_transition_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_transition_low : " U32H_FMT "\n", ptr_struct->rx_pause_transition_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_discards_high     : " U32H_FMT "\n", ptr_struct->rx_discards_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_discards_low      : " U32H_FMT "\n", ptr_struct->rx_discards_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_minor_watermark_cnt_high : " U32H_FMT "\n", ptr_struct->device_stall_minor_watermark_cnt_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_minor_watermark_cnt_low : " U32H_FMT "\n", ptr_struct->device_stall_minor_watermark_cnt_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_critical_watermark_cnt_high : " U32H_FMT "\n", ptr_struct->device_stall_critical_watermark_cnt_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_critical_watermark_cnt_low : " U32H_FMT "\n", ptr_struct->device_stall_critical_watermark_cnt_low);

}

int connectib_eth_per_prio_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_per_prio_grp_data_layout_dump(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_per_prio_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_extended_cntrs_grp_data_layout_pack(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_transmit_wait_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_transmit_wait_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ecn_marked_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ecn_marked_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->no_buffer_discard_mc_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->no_buffer_discard_mc_low);

}

void connectib_eth_extended_cntrs_grp_data_layout_unpack(struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->port_transmit_wait_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->port_transmit_wait_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->ecn_marked_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->ecn_marked_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->no_buffer_discard_mc_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->no_buffer_discard_mc_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_extended_cntrs_grp_data_layout_print(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_extended_cntrs_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_transmit_wait_high : " U32H_FMT "\n", ptr_struct->port_transmit_wait_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_transmit_wait_low : " U32H_FMT "\n", ptr_struct->port_transmit_wait_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecn_marked_high      : " U32H_FMT "\n", ptr_struct->ecn_marked_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecn_marked_low       : " U32H_FMT "\n", ptr_struct->ecn_marked_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_buffer_discard_mc_high : " U32H_FMT "\n", ptr_struct->no_buffer_discard_mc_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_buffer_discard_mc_low : " U32H_FMT "\n", ptr_struct->no_buffer_discard_mc_low);

}

int connectib_eth_extended_cntrs_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_extended_cntrs_grp_data_layout_dump(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_extended_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_3635_cntrs_grp_data_layout_pack(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_alignment_errors_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_alignment_errors_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_fcs_errors_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_fcs_errors_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_single_collision_frames_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_single_collision_frames_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_multiple_collision_frames_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_multiple_collision_frames_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_sqe_test_errors_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_sqe_test_errors_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_deferred_transmissions_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_deferred_transmissions_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_late_collisions_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_late_collisions_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_excessive_collisions_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_excessive_collisions_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_internal_mac_transmit_errors_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_internal_mac_transmit_errors_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_carrier_sense_errors_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_carrier_sense_errors_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_frame_too_longs_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_frame_too_longs_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_internal_mac_receive_errors_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_internal_mac_receive_errors_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_symbol_errors_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3stats_symbol_errors_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3control_in_unknown_opcodes_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3control_in_unknown_opcodes_low);

	offset = 896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3in_pause_frames_high);

	offset = 928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3in_pause_frames_low);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3out_pause_frames_high);

	offset = 992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dot3out_pause_frames_low);

}

void connectib_eth_3635_cntrs_grp_data_layout_unpack(struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->dot3stats_alignment_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->dot3stats_alignment_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->dot3stats_fcs_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->dot3stats_fcs_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->dot3stats_single_collision_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->dot3stats_single_collision_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->dot3stats_multiple_collision_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->dot3stats_multiple_collision_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->dot3stats_sqe_test_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->dot3stats_sqe_test_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->dot3stats_deferred_transmissions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->dot3stats_deferred_transmissions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->dot3stats_late_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->dot3stats_late_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->dot3stats_excessive_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->dot3stats_excessive_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->dot3stats_internal_mac_transmit_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->dot3stats_internal_mac_transmit_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->dot3stats_carrier_sense_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->dot3stats_carrier_sense_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->dot3stats_frame_too_longs_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->dot3stats_frame_too_longs_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->dot3stats_internal_mac_receive_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->dot3stats_internal_mac_receive_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->dot3stats_symbol_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->dot3stats_symbol_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->dot3control_in_unknown_opcodes_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->dot3control_in_unknown_opcodes_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 896;
	ptr_struct->dot3in_pause_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 928;
	ptr_struct->dot3in_pause_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 960;
	ptr_struct->dot3out_pause_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 992;
	ptr_struct->dot3out_pause_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_3635_cntrs_grp_data_layout_print(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_3635_cntrs_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_alignment_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_alignment_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_alignment_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_alignment_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_fcs_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_fcs_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_fcs_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_fcs_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_single_collision_frames_high : " U32H_FMT "\n", ptr_struct->dot3stats_single_collision_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_single_collision_frames_low : " U32H_FMT "\n", ptr_struct->dot3stats_single_collision_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_multiple_collision_frames_high : " U32H_FMT "\n", ptr_struct->dot3stats_multiple_collision_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_multiple_collision_frames_low : " U32H_FMT "\n", ptr_struct->dot3stats_multiple_collision_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_sqe_test_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_sqe_test_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_sqe_test_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_sqe_test_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_deferred_transmissions_high : " U32H_FMT "\n", ptr_struct->dot3stats_deferred_transmissions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_deferred_transmissions_low : " U32H_FMT "\n", ptr_struct->dot3stats_deferred_transmissions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_late_collisions_high : " U32H_FMT "\n", ptr_struct->dot3stats_late_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_late_collisions_low : " U32H_FMT "\n", ptr_struct->dot3stats_late_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_excessive_collisions_high : " U32H_FMT "\n", ptr_struct->dot3stats_excessive_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_excessive_collisions_low : " U32H_FMT "\n", ptr_struct->dot3stats_excessive_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_transmit_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_internal_mac_transmit_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_transmit_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_internal_mac_transmit_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_carrier_sense_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_carrier_sense_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_carrier_sense_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_carrier_sense_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_frame_too_longs_high : " U32H_FMT "\n", ptr_struct->dot3stats_frame_too_longs_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_frame_too_longs_low : " U32H_FMT "\n", ptr_struct->dot3stats_frame_too_longs_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_receive_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_internal_mac_receive_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_receive_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_internal_mac_receive_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_symbol_errors_high : " U32H_FMT "\n", ptr_struct->dot3stats_symbol_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_symbol_errors_low : " U32H_FMT "\n", ptr_struct->dot3stats_symbol_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3control_in_unknown_opcodes_high : " U32H_FMT "\n", ptr_struct->dot3control_in_unknown_opcodes_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3control_in_unknown_opcodes_low : " U32H_FMT "\n", ptr_struct->dot3control_in_unknown_opcodes_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3in_pause_frames_high : " U32H_FMT "\n", ptr_struct->dot3in_pause_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3in_pause_frames_low : " U32H_FMT "\n", ptr_struct->dot3in_pause_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3out_pause_frames_high : " U32H_FMT "\n", ptr_struct->dot3out_pause_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3out_pause_frames_low : " U32H_FMT "\n", ptr_struct->dot3out_pause_frames_low);

}

int connectib_eth_3635_cntrs_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_3635_cntrs_grp_data_layout_dump(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_3635_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_2819_cntrs_grp_data_layout_pack(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_drop_events_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_drop_events_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_octets_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_octets_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_broadcast_pkts_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_broadcast_pkts_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_multicast_pkts_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_multicast_pkts_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_crc_align_errors_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_crc_align_errors_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_undersize_pkts_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_undersize_pkts_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_oversize_pkts_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_oversize_pkts_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_fragments_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_fragments_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_jabbers_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_jabbers_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_collisions_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_collisions_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts64octets_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts64octets_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts65to127octets_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts65to127octets_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts128to255octets_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts128to255octets_low);

	offset = 896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts256to511octets_high);

	offset = 928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts256to511octets_low);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts512to1023octets_high);

	offset = 992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts512to1023octets_low);

	offset = 1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts1024to1518octets_high);

	offset = 1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts1024to1518octets_low);

	offset = 1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts1519to2047octets_high);

	offset = 1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts1519to2047octets_low);

	offset = 1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts2048to4095octets_high);

	offset = 1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts2048to4095octets_low);

	offset = 1216;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts4096to8191octets_high);

	offset = 1248;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts4096to8191octets_low);

	offset = 1280;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts8192to10239octets_high);

	offset = 1312;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ether_stats_pkts8192to10239octets_low);

}

void connectib_eth_2819_cntrs_grp_data_layout_unpack(struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->ether_stats_drop_events_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->ether_stats_drop_events_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->ether_stats_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->ether_stats_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->ether_stats_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->ether_stats_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->ether_stats_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->ether_stats_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->ether_stats_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->ether_stats_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->ether_stats_crc_align_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->ether_stats_crc_align_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->ether_stats_undersize_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->ether_stats_undersize_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->ether_stats_oversize_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->ether_stats_oversize_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->ether_stats_fragments_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->ether_stats_fragments_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->ether_stats_jabbers_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->ether_stats_jabbers_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->ether_stats_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->ether_stats_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->ether_stats_pkts64octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->ether_stats_pkts64octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->ether_stats_pkts65to127octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->ether_stats_pkts65to127octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->ether_stats_pkts128to255octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->ether_stats_pkts128to255octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 896;
	ptr_struct->ether_stats_pkts256to511octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 928;
	ptr_struct->ether_stats_pkts256to511octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 960;
	ptr_struct->ether_stats_pkts512to1023octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 992;
	ptr_struct->ether_stats_pkts512to1023octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1024;
	ptr_struct->ether_stats_pkts1024to1518octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1056;
	ptr_struct->ether_stats_pkts1024to1518octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1088;
	ptr_struct->ether_stats_pkts1519to2047octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1120;
	ptr_struct->ether_stats_pkts1519to2047octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1152;
	ptr_struct->ether_stats_pkts2048to4095octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1184;
	ptr_struct->ether_stats_pkts2048to4095octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1216;
	ptr_struct->ether_stats_pkts4096to8191octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1248;
	ptr_struct->ether_stats_pkts4096to8191octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1280;
	ptr_struct->ether_stats_pkts8192to10239octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1312;
	ptr_struct->ether_stats_pkts8192to10239octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_2819_cntrs_grp_data_layout_print(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_2819_cntrs_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_drop_events_high : " U32H_FMT "\n", ptr_struct->ether_stats_drop_events_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_drop_events_low : " U32H_FMT "\n", ptr_struct->ether_stats_drop_events_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_broadcast_pkts_high : " U32H_FMT "\n", ptr_struct->ether_stats_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_broadcast_pkts_low : " U32H_FMT "\n", ptr_struct->ether_stats_broadcast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_multicast_pkts_high : " U32H_FMT "\n", ptr_struct->ether_stats_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_multicast_pkts_low : " U32H_FMT "\n", ptr_struct->ether_stats_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_crc_align_errors_high : " U32H_FMT "\n", ptr_struct->ether_stats_crc_align_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_crc_align_errors_low : " U32H_FMT "\n", ptr_struct->ether_stats_crc_align_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_undersize_pkts_high : " U32H_FMT "\n", ptr_struct->ether_stats_undersize_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_undersize_pkts_low : " U32H_FMT "\n", ptr_struct->ether_stats_undersize_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_oversize_pkts_high : " U32H_FMT "\n", ptr_struct->ether_stats_oversize_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_oversize_pkts_low : " U32H_FMT "\n", ptr_struct->ether_stats_oversize_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_fragments_high : " U32H_FMT "\n", ptr_struct->ether_stats_fragments_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_fragments_low : " U32H_FMT "\n", ptr_struct->ether_stats_fragments_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_jabbers_high : " U32H_FMT "\n", ptr_struct->ether_stats_jabbers_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_jabbers_low : " U32H_FMT "\n", ptr_struct->ether_stats_jabbers_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_collisions_high : " U32H_FMT "\n", ptr_struct->ether_stats_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_collisions_low : " U32H_FMT "\n", ptr_struct->ether_stats_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts64octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts64octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts64octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts64octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts65to127octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts65to127octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts65to127octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts65to127octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts128to255octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts128to255octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts128to255octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts128to255octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts256to511octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts256to511octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts256to511octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts256to511octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts512to1023octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts512to1023octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts512to1023octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts512to1023octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1024to1518octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts1024to1518octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1024to1518octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts1024to1518octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1519to2047octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts1519to2047octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1519to2047octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts1519to2047octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts2048to4095octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts2048to4095octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts2048to4095octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts2048to4095octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts4096to8191octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts4096to8191octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts4096to8191octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts4096to8191octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts8192to10239octets_high : " U32H_FMT "\n", ptr_struct->ether_stats_pkts8192to10239octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts8192to10239octets_low : " U32H_FMT "\n", ptr_struct->ether_stats_pkts8192to10239octets_low);

}

int connectib_eth_2819_cntrs_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_2819_cntrs_grp_data_layout_dump(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_2819_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_2863_cntrs_grp_data_layout_pack(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_octets_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_octets_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_ucast_pkts_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_ucast_pkts_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_discards_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_discards_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_errors_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_errors_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_unknown_protos_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_unknown_protos_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_octets_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_octets_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_ucast_pkts_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_ucast_pkts_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_discards_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_discards_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_errors_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_errors_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_multicast_pkts_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_multicast_pkts_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_broadcast_pkts_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_in_broadcast_pkts_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_multicast_pkts_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_multicast_pkts_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_broadcast_pkts_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->if_out_broadcast_pkts_low);

}

void connectib_eth_2863_cntrs_grp_data_layout_unpack(struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->if_in_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->if_in_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->if_in_ucast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->if_in_ucast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->if_in_discards_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->if_in_discards_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->if_in_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->if_in_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->if_in_unknown_protos_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->if_in_unknown_protos_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->if_out_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->if_out_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->if_out_ucast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->if_out_ucast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->if_out_discards_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->if_out_discards_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->if_out_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->if_out_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->if_in_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->if_in_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->if_in_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->if_in_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->if_out_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->if_out_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->if_out_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->if_out_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_2863_cntrs_grp_data_layout_print(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_2863_cntrs_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_octets_high    : " U32H_FMT "\n", ptr_struct->if_in_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_octets_low     : " U32H_FMT "\n", ptr_struct->if_in_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_ucast_pkts_high : " U32H_FMT "\n", ptr_struct->if_in_ucast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_ucast_pkts_low : " U32H_FMT "\n", ptr_struct->if_in_ucast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_discards_high  : " U32H_FMT "\n", ptr_struct->if_in_discards_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_discards_low   : " U32H_FMT "\n", ptr_struct->if_in_discards_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_errors_high    : " U32H_FMT "\n", ptr_struct->if_in_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_errors_low     : " U32H_FMT "\n", ptr_struct->if_in_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_unknown_protos_high : " U32H_FMT "\n", ptr_struct->if_in_unknown_protos_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_unknown_protos_low : " U32H_FMT "\n", ptr_struct->if_in_unknown_protos_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_octets_high   : " U32H_FMT "\n", ptr_struct->if_out_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_octets_low    : " U32H_FMT "\n", ptr_struct->if_out_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_ucast_pkts_high : " U32H_FMT "\n", ptr_struct->if_out_ucast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_ucast_pkts_low : " U32H_FMT "\n", ptr_struct->if_out_ucast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_discards_high : " U32H_FMT "\n", ptr_struct->if_out_discards_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_discards_low  : " U32H_FMT "\n", ptr_struct->if_out_discards_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_errors_high   : " U32H_FMT "\n", ptr_struct->if_out_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_errors_low    : " U32H_FMT "\n", ptr_struct->if_out_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_multicast_pkts_high : " U32H_FMT "\n", ptr_struct->if_in_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_multicast_pkts_low : " U32H_FMT "\n", ptr_struct->if_in_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_broadcast_pkts_high : " U32H_FMT "\n", ptr_struct->if_in_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_broadcast_pkts_low : " U32H_FMT "\n", ptr_struct->if_in_broadcast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_multicast_pkts_high : " U32H_FMT "\n", ptr_struct->if_out_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_multicast_pkts_low : " U32H_FMT "\n", ptr_struct->if_out_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_broadcast_pkts_high : " U32H_FMT "\n", ptr_struct->if_out_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_broadcast_pkts_low : " U32H_FMT "\n", ptr_struct->if_out_broadcast_pkts_low);

}

int connectib_eth_2863_cntrs_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_2863_cntrs_grp_data_layout_dump(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_2863_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_802_3_cntrs_grp_data_layout_pack(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frames_transmitted_ok_high);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frames_transmitted_ok_low);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frames_received_ok_high);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frames_received_ok_low);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frame_check_sequence_errors_high);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frame_check_sequence_errors_low);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_alignment_errors_high);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_alignment_errors_low);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_octets_transmitted_ok_high);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_octets_transmitted_ok_low);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_octets_received_ok_high);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_octets_received_ok_low);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_multicast_frames_xmitted_ok_high);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_multicast_frames_xmitted_ok_low);

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_broadcast_frames_xmitted_ok_high);

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_broadcast_frames_xmitted_ok_low);

	offset = 512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_multicast_frames_received_ok_high);

	offset = 544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_multicast_frames_received_ok_low);

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_broadcast_frames_recieved_ok_high);

	offset = 608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_broadcast_frames_recieved_ok_low);

	offset = 640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_in_range_length_errors_high);

	offset = 672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_in_range_length_errors_low);

	offset = 704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_out_of_range_length_field_high);

	offset = 736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_out_of_range_length_field_low);

	offset = 768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frame_too_long_errors_high);

	offset = 800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_frame_too_long_errors_low);

	offset = 832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_symbol_error_during_carrier_high);

	offset = 864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_symbol_error_during_carrier_low);

	offset = 896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_mac_control_frames_transmitted_high);

	offset = 928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_mac_control_frames_transmitted_low);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_mac_control_frames_received_high);

	offset = 992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_mac_control_frames_received_low);

	offset = 1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_unsupported_opcodes_received_high);

	offset = 1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_unsupported_opcodes_received_low);

	offset = 1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_pause_mac_ctrl_frames_received_high);

	offset = 1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_pause_mac_ctrl_frames_received_low);

	offset = 1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_pause_mac_ctrl_frames_transmitted_high);

	offset = 1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->a_pause_mac_ctrl_frames_transmitted_low);

}

void connectib_eth_802_3_cntrs_grp_data_layout_unpack(struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->a_frames_transmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->a_frames_transmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->a_frames_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->a_frames_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->a_frame_check_sequence_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->a_frame_check_sequence_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->a_alignment_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->a_alignment_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->a_octets_transmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->a_octets_transmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->a_octets_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->a_octets_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->a_multicast_frames_xmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->a_multicast_frames_xmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	ptr_struct->a_broadcast_frames_xmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 480;
	ptr_struct->a_broadcast_frames_xmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 512;
	ptr_struct->a_multicast_frames_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 544;
	ptr_struct->a_multicast_frames_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 576;
	ptr_struct->a_broadcast_frames_recieved_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 608;
	ptr_struct->a_broadcast_frames_recieved_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 640;
	ptr_struct->a_in_range_length_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 672;
	ptr_struct->a_in_range_length_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 704;
	ptr_struct->a_out_of_range_length_field_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 736;
	ptr_struct->a_out_of_range_length_field_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 768;
	ptr_struct->a_frame_too_long_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 800;
	ptr_struct->a_frame_too_long_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 832;
	ptr_struct->a_symbol_error_during_carrier_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 864;
	ptr_struct->a_symbol_error_during_carrier_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 896;
	ptr_struct->a_mac_control_frames_transmitted_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 928;
	ptr_struct->a_mac_control_frames_transmitted_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 960;
	ptr_struct->a_mac_control_frames_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 992;
	ptr_struct->a_mac_control_frames_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1024;
	ptr_struct->a_unsupported_opcodes_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1056;
	ptr_struct->a_unsupported_opcodes_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1088;
	ptr_struct->a_pause_mac_ctrl_frames_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1120;
	ptr_struct->a_pause_mac_ctrl_frames_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1152;
	ptr_struct->a_pause_mac_ctrl_frames_transmitted_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1184;
	ptr_struct->a_pause_mac_ctrl_frames_transmitted_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_802_3_cntrs_grp_data_layout_print(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_802_3_cntrs_grp_data_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_transmitted_ok_high : " U32H_FMT "\n", ptr_struct->a_frames_transmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_transmitted_ok_low : " U32H_FMT "\n", ptr_struct->a_frames_transmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_received_ok_high : " U32H_FMT "\n", ptr_struct->a_frames_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_received_ok_low : " U32H_FMT "\n", ptr_struct->a_frames_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_check_sequence_errors_high : " U32H_FMT "\n", ptr_struct->a_frame_check_sequence_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_check_sequence_errors_low : " U32H_FMT "\n", ptr_struct->a_frame_check_sequence_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_alignment_errors_high : " U32H_FMT "\n", ptr_struct->a_alignment_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_alignment_errors_low : " U32H_FMT "\n", ptr_struct->a_alignment_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_transmitted_ok_high : " U32H_FMT "\n", ptr_struct->a_octets_transmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_transmitted_ok_low : " U32H_FMT "\n", ptr_struct->a_octets_transmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_received_ok_high : " U32H_FMT "\n", ptr_struct->a_octets_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_received_ok_low : " U32H_FMT "\n", ptr_struct->a_octets_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_xmitted_ok_high : " U32H_FMT "\n", ptr_struct->a_multicast_frames_xmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_xmitted_ok_low : " U32H_FMT "\n", ptr_struct->a_multicast_frames_xmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_xmitted_ok_high : " U32H_FMT "\n", ptr_struct->a_broadcast_frames_xmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_xmitted_ok_low : " U32H_FMT "\n", ptr_struct->a_broadcast_frames_xmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_received_ok_high : " U32H_FMT "\n", ptr_struct->a_multicast_frames_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_received_ok_low : " U32H_FMT "\n", ptr_struct->a_multicast_frames_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_recieved_ok_high : " U32H_FMT "\n", ptr_struct->a_broadcast_frames_recieved_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_recieved_ok_low : " U32H_FMT "\n", ptr_struct->a_broadcast_frames_recieved_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_in_range_length_errors_high : " U32H_FMT "\n", ptr_struct->a_in_range_length_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_in_range_length_errors_low : " U32H_FMT "\n", ptr_struct->a_in_range_length_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_out_of_range_length_field_high : " U32H_FMT "\n", ptr_struct->a_out_of_range_length_field_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_out_of_range_length_field_low : " U32H_FMT "\n", ptr_struct->a_out_of_range_length_field_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_too_long_errors_high : " U32H_FMT "\n", ptr_struct->a_frame_too_long_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_too_long_errors_low : " U32H_FMT "\n", ptr_struct->a_frame_too_long_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_symbol_error_during_carrier_high : " U32H_FMT "\n", ptr_struct->a_symbol_error_during_carrier_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_symbol_error_during_carrier_low : " U32H_FMT "\n", ptr_struct->a_symbol_error_during_carrier_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_transmitted_high : " U32H_FMT "\n", ptr_struct->a_mac_control_frames_transmitted_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_transmitted_low : " U32H_FMT "\n", ptr_struct->a_mac_control_frames_transmitted_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_received_high : " U32H_FMT "\n", ptr_struct->a_mac_control_frames_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_received_low : " U32H_FMT "\n", ptr_struct->a_mac_control_frames_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_unsupported_opcodes_received_high : " U32H_FMT "\n", ptr_struct->a_unsupported_opcodes_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_unsupported_opcodes_received_low : " U32H_FMT "\n", ptr_struct->a_unsupported_opcodes_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_received_high : " U32H_FMT "\n", ptr_struct->a_pause_mac_ctrl_frames_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_received_low : " U32H_FMT "\n", ptr_struct->a_pause_mac_ctrl_frames_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_transmitted_high : " U32H_FMT "\n", ptr_struct->a_pause_mac_ctrl_frames_transmitted_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_transmitted_low : " U32H_FMT "\n", ptr_struct->a_pause_mac_ctrl_frames_transmitted_low);

}

int connectib_eth_802_3_cntrs_grp_data_layout_size(void)
{
	 return 248;
}

void connectib_eth_802_3_cntrs_grp_data_layout_dump(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file)
{
	connectib_eth_802_3_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_dct_qp_pack(const struct connectib_dct_qp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dc_access_key_violation_count_state);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dc_access_key_violation_count);

}

void connectib_dct_qp_unpack(struct connectib_dct_qp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 30;
	ptr_struct->dc_access_key_violation_count_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 64;
	ptr_struct->dc_access_key_violation_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dct_qp_print(const struct connectib_dct_qp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dct_qp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_violation_count_state : " UH_FMT "\n", ptr_struct->dc_access_key_violation_count_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_violation_count : " U32H_FMT "\n", ptr_struct->dc_access_key_violation_count);

}

int connectib_dct_qp_size(void)
{
	 return 16;
}

void connectib_dct_qp_dump(const struct connectib_dct_qp *ptr_struct, FILE* file)
{
	connectib_dct_qp_print(ptr_struct, file, 0);
}

void connectib_dcr_qp_pack(const struct connectib_dcr_qp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->gb_first_psn);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->gb_last_psn);

	offset = 39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_gb);

	offset = 38;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drtl_cause_dcr_cleanup);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->reconnect_ack_psn);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dcr_heartbeat_clr_timestamp);

}

void connectib_dcr_qp_unpack(struct connectib_dcr_qp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->gb_first_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 40;
	ptr_struct->gb_last_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 39;
	ptr_struct->is_gb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 38;
	ptr_struct->drtl_cause_dcr_cleanup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->reconnect_ack_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->dcr_heartbeat_clr_timestamp = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dcr_qp_print(const struct connectib_dcr_qp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dcr_qp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gb_first_psn         : " UH_FMT "\n", ptr_struct->gb_first_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gb_last_psn          : " UH_FMT "\n", ptr_struct->gb_last_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_gb                : " UH_FMT "\n", ptr_struct->is_gb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drtl_cause_dcr_cleanup : " UH_FMT "\n", ptr_struct->drtl_cause_dcr_cleanup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reconnect_ack_psn    : " UH_FMT "\n", ptr_struct->reconnect_ack_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_heartbeat_clr_timestamp : " U32H_FMT "\n", ptr_struct->dcr_heartbeat_clr_timestamp);

}

int connectib_dcr_qp_size(void)
{
	 return 16;
}

void connectib_dcr_qp_dump(const struct connectib_dcr_qp *ptr_struct, FILE* file)
{
	connectib_dcr_qp_print(ptr_struct, file, 0);
}

void connectib_regular_qp_pack(const struct connectib_regular_qp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ds_exceeds_pi_retries);

	offset = 27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->req_retrans_is_rdma_read);

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->use_deth_sqpn);

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->pm_state);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->xport_retry_counter);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->xport_retry_limit);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rnr_retry_counter);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rnr_retry_limit);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->sw_uar);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->log_rtm);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sw_log_rtm);

	offset = 64;
	connectib_regular_qp_sub_type_pack(&(ptr_struct->sub_type_fields), ptr_buff + offset/8);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->ib_ft_root_id);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sw_xport_retry_limit);

}

void connectib_regular_qp_unpack(struct connectib_regular_qp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->ds_exceeds_pi_retries = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 27;
	ptr_struct->req_retrans_is_rdma_read = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 26;
	ptr_struct->use_deth_sqpn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 24;
	ptr_struct->pm_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 16;
	ptr_struct->xport_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->xport_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 4;
	ptr_struct->rnr_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 0;
	ptr_struct->rnr_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 40;
	ptr_struct->sw_uar = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 36;
	ptr_struct->log_rtm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->sw_log_rtm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	connectib_regular_qp_sub_type_unpack(&(ptr_struct->sub_type_fields), ptr_buff + offset/8);

	offset = 104;
	ptr_struct->ib_ft_root_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->sw_xport_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_regular_qp_print(const struct connectib_regular_qp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_regular_qp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ds_exceeds_pi_retries : " UH_FMT "\n", ptr_struct->ds_exceeds_pi_retries);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "req_retrans_is_rdma_read : " UH_FMT "\n", ptr_struct->req_retrans_is_rdma_read);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "use_deth_sqpn        : " UH_FMT "\n", ptr_struct->use_deth_sqpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pm_state             : " UH_FMT "\n", ptr_struct->pm_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xport_retry_counter  : " UH_FMT "\n", ptr_struct->xport_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xport_retry_limit    : " UH_FMT "\n", ptr_struct->xport_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_retry_counter    : " UH_FMT "\n", ptr_struct->rnr_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_retry_limit      : " UH_FMT "\n", ptr_struct->rnr_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_uar               : " UH_FMT "\n", ptr_struct->sw_uar);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_rtm              : " UH_FMT "\n", ptr_struct->log_rtm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_log_rtm           : " UH_FMT "\n", ptr_struct->sw_log_rtm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sub_type_fields:\n");
	connectib_regular_qp_sub_type_print(&(ptr_struct->sub_type_fields), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_ft_root_id        : " UH_FMT "\n", ptr_struct->ib_ft_root_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_xport_retry_limit : " UH_FMT "\n", ptr_struct->sw_xport_retry_limit);

}

int connectib_regular_qp_size(void)
{
	 return 16;
}

void connectib_regular_qp_dump(const struct connectib_regular_qp *ptr_struct, FILE* file)
{
	connectib_regular_qp_print(ptr_struct, file, 0);
}

void connectib_schedint_cause_pack(const struct connectib_schedint_cause *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clear_all_causes);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_destroy_qp);

	offset = 5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_qp_flush);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_apm);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_duplicate);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_sl_diff);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_pp_diff);

}

void connectib_schedint_cause_unpack(struct connectib_schedint_cause *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 7;
	ptr_struct->clear_all_causes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->schedint_destroy_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 5;
	ptr_struct->schedint_qp_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 4;
	ptr_struct->schedint_apm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 3;
	ptr_struct->schedint_duplicate = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->schedint_sl_diff = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->schedint_pp_diff = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_schedint_cause_print(const struct connectib_schedint_cause *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_schedint_cause ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clear_all_causes     : " UH_FMT "\n", ptr_struct->clear_all_causes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_destroy_qp  : " UH_FMT "\n", ptr_struct->schedint_destroy_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_qp_flush    : " UH_FMT "\n", ptr_struct->schedint_qp_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_apm         : " UH_FMT "\n", ptr_struct->schedint_apm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_duplicate   : " UH_FMT "\n", ptr_struct->schedint_duplicate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_sl_diff     : " UH_FMT "\n", ptr_struct->schedint_sl_diff);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_pp_diff     : " UH_FMT "\n", ptr_struct->schedint_pp_diff);

}

int connectib_schedint_cause_size(void)
{
	 return 1;
}

void connectib_schedint_cause_dump(const struct connectib_schedint_cause *ptr_struct, FILE* file)
{
	connectib_schedint_cause_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_ib_pack(const struct connectib_fw_qpc_ib *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->oldest_non_acked_psn);

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invalid_user_index);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->max_read_atomic_reduced);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->ulp_stateless_offload_mode);

}

void connectib_fw_qpc_ib_unpack(struct connectib_fw_qpc_ib *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->oldest_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 7;
	ptr_struct->invalid_user_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->max_read_atomic_reduced = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 4;
	ptr_struct->ulp_stateless_offload_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_fw_qpc_ib_print(const struct connectib_fw_qpc_ib *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_ib ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oldest_non_acked_psn : " UH_FMT "\n", ptr_struct->oldest_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invalid_user_index   : " UH_FMT "\n", ptr_struct->invalid_user_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic_reduced : " UH_FMT "\n", ptr_struct->max_read_atomic_reduced);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ulp_stateless_offload_mode : " UH_FMT "\n", ptr_struct->ulp_stateless_offload_mode);

}

int connectib_fw_qpc_ib_size(void)
{
	 return 4;
}

void connectib_fw_qpc_ib_dump(const struct connectib_fw_qpc_ib *ptr_struct, FILE* file)
{
	connectib_fw_qpc_ib_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_eth_pack(const struct connectib_fw_qpc_eth *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->tis_num);

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sq_in_lb_block);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reg_umr);

}

void connectib_fw_qpc_eth_unpack(struct connectib_fw_qpc_eth *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->tis_num = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 7;
	ptr_struct->sq_in_lb_block = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->reg_umr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_fw_qpc_eth_print(const struct connectib_fw_qpc_eth *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_eth ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tis_num              : " UH_FMT "\n", ptr_struct->tis_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sq_in_lb_block       : " UH_FMT "\n", ptr_struct->sq_in_lb_block);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reg_umr              : " UH_FMT "\n", ptr_struct->reg_umr);

}

int connectib_fw_qpc_eth_size(void)
{
	 return 4;
}

void connectib_fw_qpc_eth_dump(const struct connectib_fw_qpc_eth *ptr_struct, FILE* file)
{
	connectib_fw_qpc_eth_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_data0_pack(const struct connectib_hw_msix_context_data0 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->data);

}

void connectib_hw_msix_context_data0_unpack(struct connectib_hw_msix_context_data0 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_msix_context_data0_print(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context_data0 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data                 : " U32H_FMT "\n", ptr_struct->data);

}

int connectib_hw_msix_context_data0_size(void)
{
	 return 4;
}

void connectib_hw_msix_context_data0_dump(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file)
{
	connectib_hw_msix_context_data0_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_generic_headers_pack(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword_select_valid);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword_select);

}

void connectib_hw_ste_tag_generic_headers_unpack(struct connectib_hw_ste_tag_generic_headers *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->dword_select_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->dword_select = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_generic_headers_print(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_generic_headers ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_select_valid   : " UH_FMT "\n", ptr_struct->dword_select_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_select         : " U32H_FMT "\n", ptr_struct->dword_select);

}

int connectib_hw_ste_tag_generic_headers_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_generic_headers_dump(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_generic_headers_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_port_pack(const struct connectib_hw_ste_tag_port *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset = 19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset = 18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->qp_type);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_sniffer);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_lb);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->func_lb);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->multicast);

}

void connectib_hw_ste_tag_port_unpack(struct connectib_hw_ste_tag_port *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 19;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 18;
	ptr_struct->bth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 16;
	ptr_struct->qp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 3;
	ptr_struct->sx_sniffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->force_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->func_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_ste_tag_port_print(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_port ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : " UH_FMT "\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : " UH_FMT "\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth                  : " UH_FMT "\n", ptr_struct->bth);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_type              : " UH_FMT "\n", ptr_struct->qp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_sniffer           : " UH_FMT "\n", ptr_struct->sx_sniffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_lb             : " UH_FMT "\n", ptr_struct->force_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "func_lb              : " UH_FMT "\n", ptr_struct->func_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "multicast            : " UH_FMT "\n", ptr_struct->multicast);

}

int connectib_hw_ste_tag_port_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_port_dump(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_port_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_source_gvmi_qp_pack(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->source_gvmi);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->source_qp);

	offset = 39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->source_is_requestor);

}

void connectib_hw_ste_tag_source_gvmi_qp_unpack(struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->source_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 40;
	ptr_struct->source_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 39;
	ptr_struct->source_is_requestor = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_ste_tag_source_gvmi_qp_print(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_source_gvmi_qp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_gvmi          : " UH_FMT "\n", ptr_struct->source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_qp            : " UH_FMT "\n", ptr_struct->source_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_is_requestor  : " UH_FMT "\n", ptr_struct->source_is_requestor);

}

int connectib_hw_ste_tag_source_gvmi_qp_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_source_gvmi_qp_dump(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_source_gvmi_qp_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l4_pack(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->dest_qp);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey);

}

void connectib_hw_ste_tag_ib_l4_unpack(struct connectib_hw_ste_tag_ib_l4 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->dest_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 48;
	ptr_struct->pkey = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_ste_tag_ib_l4_print(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l4 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dest_qp              : " UH_FMT "\n", ptr_struct->dest_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey                 : " UH_FMT "\n", ptr_struct->pkey);

}

int connectib_hw_ste_tag_ib_l4_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_ib_l4_dump(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_ib_l4_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l3_pack(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dgid_127_96);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dgid_95_64);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dgid_63_32);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dgid_31_0);

}

void connectib_hw_ste_tag_ib_l3_unpack(struct connectib_hw_ste_tag_ib_l3 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->dgid_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->dgid_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->dgid_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->dgid_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_ib_l3_print(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l3 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_127_96          : " U32H_FMT "\n", ptr_struct->dgid_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_95_64           : " U32H_FMT "\n", ptr_struct->dgid_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_63_32           : " U32H_FMT "\n", ptr_struct->dgid_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_31_0            : " U32H_FMT "\n", ptr_struct->dgid_31_0);

}

int connectib_hw_ste_tag_ib_l3_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_ib_l3_dump(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_ib_l3_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l3_extended_pack(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->traffic_class);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey);

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dceth_complete);

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->deth_complete);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth_complete);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ip_version);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qkey_dc_access_key_63_32);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qkey_dc_access_key_31_0);

}

void connectib_hw_ste_tag_ib_l3_extended_unpack(struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset = 8;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 0;
	ptr_struct->traffic_class = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->pkey = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 35;
	ptr_struct->dceth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 34;
	ptr_struct->deth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 33;
	ptr_struct->bth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->ip_version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->qkey_dc_access_key_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->qkey_dc_access_key_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_ib_l3_extended_print(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l3_extended ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : " UH_FMT "\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : " UH_FMT "\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "traffic_class        : " UH_FMT "\n", ptr_struct->traffic_class);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey                 : " UH_FMT "\n", ptr_struct->pkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dceth_complete       : " UH_FMT "\n", ptr_struct->dceth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "deth_complete        : " UH_FMT "\n", ptr_struct->deth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth_complete         : " UH_FMT "\n", ptr_struct->bth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ip_version           : " UH_FMT "\n", ptr_struct->ip_version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey_dc_access_key_63_32 : " U32H_FMT "\n", ptr_struct->qkey_dc_access_key_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey_dc_access_key_31_0 : " U32H_FMT "\n", ptr_struct->qkey_dc_access_key_31_0);

}

int connectib_hw_ste_tag_ib_l3_extended_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_ib_l3_extended_dump(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_ib_l3_extended_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l2_pack(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dlid);

	offset = 15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->qp_type);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->multicast);

	offset = 76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwh_ethertype);

}

void connectib_hw_ste_tag_ib_l2_unpack(struct connectib_hw_ste_tag_ib_l2 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->dlid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 15;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 14;
	ptr_struct->bth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 12;
	ptr_struct->qp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 0;
	ptr_struct->multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 76;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset = 112;
	ptr_struct->rwh_ethertype = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_ste_tag_ib_l2_print(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l2 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dlid                 : " UH_FMT "\n", ptr_struct->dlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : " UH_FMT "\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth                  : " UH_FMT "\n", ptr_struct->bth);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_type              : " UH_FMT "\n", ptr_struct->qp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : " UH_FMT "\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "multicast            : " UH_FMT "\n", ptr_struct->multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : " UH_FMT "\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwh_ethertype        : " UH_FMT "\n", ptr_struct->rwh_ethertype);

}

int connectib_hw_ste_tag_ib_l2_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_ib_l2_dump(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_ib_l2_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_bulk_pack(const struct connectib_hw_ste_tag_bulk *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tag_127_96);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tag_95_64);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tag_63_32);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tag_31_0);

}

void connectib_hw_ste_tag_bulk_unpack(struct connectib_hw_ste_tag_bulk *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->tag_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->tag_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->tag_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->tag_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_bulk_print(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_bulk ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_127_96           : " U32H_FMT "\n", ptr_struct->tag_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_95_64            : " U32H_FMT "\n", ptr_struct->tag_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_63_32            : " U32H_FMT "\n", ptr_struct->tag_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_31_0             : " U32H_FMT "\n", ptr_struct->tag_31_0);

}

int connectib_hw_ste_tag_bulk_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_bulk_dump(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_bulk_print(ptr_struct, file, 0);
}

void connectib_hw_transaction_pdf_pack(const struct connectib_hw_transaction_pdf *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_data_bits);

	offset = 13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_data_bits);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->seed);

	offset = 11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bytes);

	offset = 10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bits);

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_crc);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sig_zones_covered);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sig_type);

}

void connectib_hw_transaction_pdf_unpack(struct connectib_hw_transaction_pdf *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 14;
	ptr_struct->invert_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 13;
	ptr_struct->swap_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 12;
	ptr_struct->seed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 11;
	ptr_struct->swap_crc_bytes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 10;
	ptr_struct->swap_crc_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 9;
	ptr_struct->invert_crc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 8;
	ptr_struct->sig_zones_covered = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->sig_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_transaction_pdf_print(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_transaction_pdf ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_data_bits     : " UH_FMT "\n", ptr_struct->invert_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_data_bits       : " UH_FMT "\n", ptr_struct->swap_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "seed                 : " UH_FMT "\n", ptr_struct->seed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bytes       : " UH_FMT "\n", ptr_struct->swap_crc_bytes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bits        : " UH_FMT "\n", ptr_struct->swap_crc_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_crc           : " UH_FMT "\n", ptr_struct->invert_crc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_zones_covered    : " UH_FMT "\n", ptr_struct->sig_zones_covered);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_type             : " UH_FMT "\n", ptr_struct->sig_type);

}

int connectib_hw_transaction_pdf_size(void)
{
	 return 8;
}

void connectib_hw_transaction_pdf_dump(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file)
{
	connectib_hw_transaction_pdf_print(ptr_struct, file, 0);
}

void connectib_hw_pdf_decoder_pack(const struct connectib_hw_pdf_decoder *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_data_bits);

	offset = 13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_data_bits);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->seed);

	offset = 11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bytes);

	offset = 10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bits);

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_crc);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->regular);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sig_type);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dif_app_tag_bit_check_en);

	offset = 46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dif_guard_check_type);

	offset = 44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dif_learn_mode);

	offset = 43;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_learn_app_tag);

	offset = 42;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_learn_ref_tag);

	offset = 41;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_inc_ref_tag);

}

void connectib_hw_pdf_decoder_unpack(struct connectib_hw_pdf_decoder *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 14;
	ptr_struct->invert_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 13;
	ptr_struct->swap_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 12;
	ptr_struct->seed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 11;
	ptr_struct->swap_crc_bytes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 10;
	ptr_struct->swap_crc_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 9;
	ptr_struct->invert_crc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 8;
	ptr_struct->regular = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->sig_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->dif_app_tag_bit_check_en = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 46;
	ptr_struct->dif_guard_check_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 44;
	ptr_struct->dif_learn_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 43;
	ptr_struct->dif_learn_app_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 42;
	ptr_struct->dif_learn_ref_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 41;
	ptr_struct->dif_inc_ref_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_pdf_decoder_print(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_pdf_decoder ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_data_bits     : " UH_FMT "\n", ptr_struct->invert_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_data_bits       : " UH_FMT "\n", ptr_struct->swap_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "seed                 : " UH_FMT "\n", ptr_struct->seed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bytes       : " UH_FMT "\n", ptr_struct->swap_crc_bytes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bits        : " UH_FMT "\n", ptr_struct->swap_crc_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_crc           : " UH_FMT "\n", ptr_struct->invert_crc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular              : " UH_FMT "\n", ptr_struct->regular);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_type             : " UH_FMT "\n", ptr_struct->sig_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_app_tag_bit_check_en : " UH_FMT "\n", ptr_struct->dif_app_tag_bit_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_guard_check_type : " UH_FMT "\n", ptr_struct->dif_guard_check_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_mode       : " UH_FMT "\n", ptr_struct->dif_learn_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_app_tag    : " UH_FMT "\n", ptr_struct->dif_learn_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_ref_tag    : " UH_FMT "\n", ptr_struct->dif_learn_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_inc_ref_tag      : " UH_FMT "\n", ptr_struct->dif_inc_ref_tag);

}

int connectib_hw_pdf_decoder_size(void)
{
	 return 8;
}

void connectib_hw_pdf_decoder_dump(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file)
{
	connectib_hw_pdf_decoder_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_tx_set_ini_pack(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_pre);

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pre_polarity);

	offset = 17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_post);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_polarity);

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_main);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->main_polarity);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->preemp_mode);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ob_bias);

}

void connectib_serdes_conf_tx_set_ini_unpack(struct connectib_serdes_conf_tx_set_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	ptr_struct->ob_preemp_pre = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 24;
	ptr_struct->pre_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 17;
	ptr_struct->ob_preemp_post = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 16;
	ptr_struct->post_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 9;
	ptr_struct->ob_preemp_main = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 8;
	ptr_struct->main_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->preemp_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 2;
	ptr_struct->ob_bias = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_serdes_conf_tx_set_ini_print(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_tx_set_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_pre        : " UH_FMT "\n", ptr_struct->ob_preemp_pre);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pre_polarity         : " UH_FMT "\n", ptr_struct->pre_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_post       : " UH_FMT "\n", ptr_struct->ob_preemp_post);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_polarity        : " UH_FMT "\n", ptr_struct->post_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_main       : " UH_FMT "\n", ptr_struct->ob_preemp_main);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "main_polarity        : " UH_FMT "\n", ptr_struct->main_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "preemp_mode          : " UH_FMT "\n", ptr_struct->preemp_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_bias              : " UH_FMT "\n", ptr_struct->ob_bias);

}

int connectib_serdes_conf_tx_set_ini_size(void)
{
	 return 4;
}

void connectib_serdes_conf_tx_set_ini_dump(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_tx_set_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_rx_set_ini_pack(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->slicer_ind_en);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->slicer1_enable);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->slicer2_enable);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap0);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap1);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap2);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap3);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap4);

}

void connectib_serdes_conf_rx_set_ini_unpack(struct connectib_serdes_conf_rx_set_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->slicer_ind_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 20;
	ptr_struct->slicer1_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 16;
	ptr_struct->slicer2_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 8;
	ptr_struct->ffe_tap0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->ffe_tap1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->ffe_tap2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->ffe_tap3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 40;
	ptr_struct->ffe_tap4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_serdes_conf_rx_set_ini_print(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_rx_set_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer_ind_en        : " UH_FMT "\n", ptr_struct->slicer_ind_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer1_enable       : " UH_FMT "\n", ptr_struct->slicer1_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer2_enable       : " UH_FMT "\n", ptr_struct->slicer2_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap0             : " UH_FMT "\n", ptr_struct->ffe_tap0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap1             : " UH_FMT "\n", ptr_struct->ffe_tap1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap2             : " UH_FMT "\n", ptr_struct->ffe_tap2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap3             : " UH_FMT "\n", ptr_struct->ffe_tap3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap4             : " UH_FMT "\n", ptr_struct->ffe_tap4);

}

int connectib_serdes_conf_rx_set_ini_size(void)
{
	 return 8;
}

void connectib_serdes_conf_rx_set_ini_dump(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_rx_set_ini_print(ptr_struct, file, 0);
}

void connectib_aba_index_pack(const struct connectib_aba_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0_start);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0_end);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1_start);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1_end);

	offset = 58;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1);

	offset = 52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2_start);

	offset = 46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2_end);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2);

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3_start);

	offset = 90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3_end);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3);

	offset = 78;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4_start);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4_end);

	offset = 66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4);

	offset = 122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5_start);

	offset = 116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5_end);

	offset = 110;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5);

}

void connectib_aba_index_unpack(struct connectib_aba_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->aba_index0_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 20;
	ptr_struct->aba_index0_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 14;
	ptr_struct->aba_index0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 8;
	ptr_struct->aba_index1_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 2;
	ptr_struct->aba_index1_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 58;
	ptr_struct->aba_index1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 52;
	ptr_struct->aba_index2_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 46;
	ptr_struct->aba_index2_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 40;
	ptr_struct->aba_index2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 34;
	ptr_struct->aba_index3_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 90;
	ptr_struct->aba_index3_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 84;
	ptr_struct->aba_index3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 78;
	ptr_struct->aba_index4_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 72;
	ptr_struct->aba_index4_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 66;
	ptr_struct->aba_index4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 122;
	ptr_struct->aba_index5_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 116;
	ptr_struct->aba_index5_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 110;
	ptr_struct->aba_index5 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

}

void connectib_aba_index_print(const struct connectib_aba_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_aba_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0_start     : " UH_FMT "\n", ptr_struct->aba_index0_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0_end       : " UH_FMT "\n", ptr_struct->aba_index0_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0           : " UH_FMT "\n", ptr_struct->aba_index0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1_start     : " UH_FMT "\n", ptr_struct->aba_index1_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1_end       : " UH_FMT "\n", ptr_struct->aba_index1_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1           : " UH_FMT "\n", ptr_struct->aba_index1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2_start     : " UH_FMT "\n", ptr_struct->aba_index2_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2_end       : " UH_FMT "\n", ptr_struct->aba_index2_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2           : " UH_FMT "\n", ptr_struct->aba_index2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3_start     : " UH_FMT "\n", ptr_struct->aba_index3_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3_end       : " UH_FMT "\n", ptr_struct->aba_index3_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3           : " UH_FMT "\n", ptr_struct->aba_index3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4_start     : " UH_FMT "\n", ptr_struct->aba_index4_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4_end       : " UH_FMT "\n", ptr_struct->aba_index4_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4           : " UH_FMT "\n", ptr_struct->aba_index4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5_start     : " UH_FMT "\n", ptr_struct->aba_index5_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5_end       : " UH_FMT "\n", ptr_struct->aba_index5_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5           : " UH_FMT "\n", ptr_struct->aba_index5);

}

int connectib_aba_index_size(void)
{
	 return 16;
}

void connectib_aba_index_dump(const struct connectib_aba_index *ptr_struct, FILE* file)
{
	connectib_aba_index_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_specific_pack(const union connectib_cmdif_ctx_special_qp_commands_specific *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_special_qp_commands_other_pack(&(ptr_struct->other), ptr_buff);
}

void connectib_cmdif_ctx_special_qp_commands_specific_unpack(union connectib_cmdif_ctx_special_qp_commands_specific *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_special_qp_commands_other_unpack(&(ptr_struct->other), ptr_buff);
}

void connectib_cmdif_ctx_special_qp_commands_specific_print(const union connectib_cmdif_ctx_special_qp_commands_specific *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands_specific ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rts2rts:\n");
	connectib_cmdif_ctx_special_qp_commands_rts2rts_print(&(ptr_struct->rts2rts), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "other:\n");
	connectib_cmdif_ctx_special_qp_commands_other_print(&(ptr_struct->other), file, indent_level + 1);

}

int connectib_cmdif_ctx_special_qp_commands_specific_size(void)
{
	 return 16;
}

void connectib_cmdif_ctx_special_qp_commands_specific_dump(const union connectib_cmdif_ctx_special_qp_commands_specific *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_specific_print(ptr_struct, file, 0);
}

void connectib_pmcr_reg_pack(const struct connectib_pmcr_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pmcr_reg_unpack(struct connectib_pmcr_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pmcr_reg_print(const struct connectib_pmcr_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmcr_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pmcr_reg_size(void)
{
	 return 24;
}

void connectib_pmcr_reg_dump(const struct connectib_pmcr_reg *ptr_struct, FILE* file)
{
	connectib_pmcr_reg_print(ptr_struct, file, 0);
}

void connectib_mpein_reg_pack(const struct connectib_mpein_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pcie_index);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->capability_mask);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->link_speed_enabled);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_width_enabled);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->link_speed_active);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_width_active);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->lane0_physical_position);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->num_of_vfs);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->num_of_pfs);

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->bdf0);

	offset = 223;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->lane_reversal);

	offset = 208;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_type);

	offset = 196;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_payload_size);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_read_request_size);

	offset = 304;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_state);

	offset = 288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->device_status);

	offset = 336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->receiver_detect_result);

}

void connectib_mpein_reg_unpack(struct connectib_mpein_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->pcie_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->capability_mask = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 80;
	ptr_struct->link_speed_enabled = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 72;
	ptr_struct->link_width_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 112;
	ptr_struct->link_speed_active = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 104;
	ptr_struct->link_width_active = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->lane0_physical_position = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 144;
	ptr_struct->num_of_vfs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 128;
	ptr_struct->num_of_pfs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 160;
	ptr_struct->bdf0 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 223;
	ptr_struct->lane_reversal = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 208;
	ptr_struct->port_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 196;
	ptr_struct->max_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->max_read_request_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 304;
	ptr_struct->port_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 288;
	ptr_struct->device_status = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 336;
	ptr_struct->receiver_detect_result = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_mpein_reg_print(const struct connectib_mpein_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mpein_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcie_index           : " UH_FMT "\n", ptr_struct->pcie_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "capability_mask      : " U32H_FMT "\n", ptr_struct->capability_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_speed_enabled   : " UH_FMT "\n", ptr_struct->link_speed_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_width_enabled   : " UH_FMT "\n", ptr_struct->link_width_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_speed_active    : " UH_FMT "\n", ptr_struct->link_speed_active);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_width_active    : " UH_FMT "\n", ptr_struct->link_width_active);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane0_physical_position : " UH_FMT "\n", ptr_struct->lane0_physical_position);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_of_vfs           : " UH_FMT "\n", ptr_struct->num_of_vfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_of_pfs           : " UH_FMT "\n", ptr_struct->num_of_pfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bdf0                 : " UH_FMT "\n", ptr_struct->bdf0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane_reversal        : " UH_FMT "\n", ptr_struct->lane_reversal);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_type            : " UH_FMT "\n", ptr_struct->port_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_payload_size     : " UH_FMT "\n", ptr_struct->max_payload_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_request_size : " UH_FMT "\n", ptr_struct->max_read_request_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_state           : " UH_FMT "\n", ptr_struct->port_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_status        : " UH_FMT "\n", ptr_struct->device_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_detect_result : " UH_FMT "\n", ptr_struct->receiver_detect_result);

}

int connectib_mpein_reg_size(void)
{
	 return 44;
}

void connectib_mpein_reg_dump(const struct connectib_mpein_reg *ptr_struct, FILE* file)
{
	connectib_mpein_reg_print(ptr_struct, file, 0);
}

void connectib_mvts_pack(const struct connectib_mvts *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_timestamp_flag);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->running_flag);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clear_all_ts_flag);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fw_ver_major);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fw_ver_subminor);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fw_ver_minor);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ts_day);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ts_month);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ts_year);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ts_seconds);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ts_minutes);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ts_hour);

}

void connectib_mvts_unpack(struct connectib_mvts *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	ptr_struct->check_timestamp_flag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->running_flag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->clear_all_ts_flag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->fw_ver_major = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 80;
	ptr_struct->fw_ver_subminor = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->fw_ver_minor = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 120;
	ptr_struct->ts_day = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 112;
	ptr_struct->ts_month = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->ts_year = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 144;
	ptr_struct->ts_seconds = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->ts_minutes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 128;
	ptr_struct->ts_hour = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_mvts_print(const struct connectib_mvts *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mvts ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_timestamp_flag : " UH_FMT "\n", ptr_struct->check_timestamp_flag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "running_flag         : " UH_FMT "\n", ptr_struct->running_flag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clear_all_ts_flag    : " UH_FMT "\n", ptr_struct->clear_all_ts_flag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ver_major         : " UH_FMT "\n", ptr_struct->fw_ver_major);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ver_subminor      : " UH_FMT "\n", ptr_struct->fw_ver_subminor);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ver_minor         : " UH_FMT "\n", ptr_struct->fw_ver_minor);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_day               : " UH_FMT "\n", ptr_struct->ts_day);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_month             : " UH_FMT "\n", ptr_struct->ts_month);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_year              : " UH_FMT "\n", ptr_struct->ts_year);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_seconds           : " UH_FMT "\n", ptr_struct->ts_seconds);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_minutes           : " UH_FMT "\n", ptr_struct->ts_minutes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts_hour              : " UH_FMT "\n", ptr_struct->ts_hour);

}

int connectib_mvts_size(void)
{
	 return 20;
}

void connectib_mvts_dump(const struct connectib_mvts *ptr_struct, FILE* file)
{
	connectib_mvts_print(ptr_struct, file, 0);
}

void connectib_pmlp_pack(const union connectib_pmlp *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_pmlp_code_style_pack(&(ptr_struct->code_style), ptr_buff);
}

void connectib_pmlp_unpack(union connectib_pmlp *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_pmlp_code_style_unpack(&(ptr_struct->code_style), ptr_buff);
}

void connectib_pmlp_print(const union connectib_pmlp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmlp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prm_style:\n");
	connectib_pmlp_prm_style_print(&(ptr_struct->prm_style), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "code_style:\n");
	connectib_pmlp_code_style_print(&(ptr_struct->code_style), file, indent_level + 1);

}

int connectib_pmlp_size(void)
{
	 return 36;
}

void connectib_pmlp_dump(const union connectib_pmlp *ptr_struct, FILE* file)
{
	connectib_pmlp_print(ptr_struct, file, 0);
}

void connectib_pplm_reg_pack(const struct connectib_pplm_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->active_port_profile);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->static_port_profile);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_profile_mode);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fec_mode_active);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->retransmission_active);

	offset = 156;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_cap_10g_40g);

	offset = 152;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_cap_25g);

	offset = 148;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_cap_50g);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_cap_100g);

	offset = 140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_cap_56g);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_correction_bypass_cap);

	offset = 188;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_admin_10g_40g);

	offset = 184;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_admin_25g);

	offset = 180;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_admin_50g);

	offset = 176;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_admin_100g);

	offset = 172;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fec_override_admin_56g);

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rs_fec_correction_bypass_admin);

}

void connectib_pplm_reg_unpack(struct connectib_pplm_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 80;
	ptr_struct->active_port_profile = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 72;
	ptr_struct->static_port_profile = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->port_profile_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->fec_mode_active = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->retransmission_active = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 156;
	ptr_struct->fec_override_cap_10g_40g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 152;
	ptr_struct->fec_override_cap_25g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 148;
	ptr_struct->fec_override_cap_50g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 144;
	ptr_struct->fec_override_cap_100g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 140;
	ptr_struct->fec_override_cap_56g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->rs_fec_correction_bypass_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 188;
	ptr_struct->fec_override_admin_10g_40g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 184;
	ptr_struct->fec_override_admin_25g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 180;
	ptr_struct->fec_override_admin_50g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 176;
	ptr_struct->fec_override_admin_100g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 172;
	ptr_struct->fec_override_admin_56g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->rs_fec_correction_bypass_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_pplm_reg_print(const struct connectib_pplm_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pplm_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "active_port_profile  : " UH_FMT "\n", ptr_struct->active_port_profile);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "static_port_profile  : " UH_FMT "\n", ptr_struct->static_port_profile);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_profile_mode    : " UH_FMT "\n", ptr_struct->port_profile_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_mode_active      : " UH_FMT "\n", ptr_struct->fec_mode_active);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_active : " UH_FMT "\n", ptr_struct->retransmission_active);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_cap_10g_40g : " UH_FMT "\n", ptr_struct->fec_override_cap_10g_40g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_cap_25g : " UH_FMT "\n", ptr_struct->fec_override_cap_25g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_cap_50g : " UH_FMT "\n", ptr_struct->fec_override_cap_50g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_cap_100g : " UH_FMT "\n", ptr_struct->fec_override_cap_100g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_cap_56g : " UH_FMT "\n", ptr_struct->fec_override_cap_56g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_correction_bypass_cap : " UH_FMT "\n", ptr_struct->rs_fec_correction_bypass_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_admin_10g_40g : " UH_FMT "\n", ptr_struct->fec_override_admin_10g_40g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_admin_25g : " UH_FMT "\n", ptr_struct->fec_override_admin_25g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_admin_50g : " UH_FMT "\n", ptr_struct->fec_override_admin_50g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_admin_100g : " UH_FMT "\n", ptr_struct->fec_override_admin_100g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_override_admin_56g : " UH_FMT "\n", ptr_struct->fec_override_admin_56g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_correction_bypass_admin : " UH_FMT "\n", ptr_struct->rs_fec_correction_bypass_admin);

}

int connectib_pplm_reg_size(void)
{
	 return 24;
}

void connectib_pplm_reg_dump(const struct connectib_pplm_reg *ptr_struct, FILE* file)
{
	connectib_pplm_reg_print(ptr_struct, file, 0);
}

void connectib_plpc_reg_pack(const struct connectib_plpc_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->proto_mask);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->profile_id);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->lane_speed);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->fec_mode_policy);

	offset = 87;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->lpbf);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fec_mode_capability);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->retransmission_capability);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fec_mode_support_admin);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->retransmission_support_admin);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fec_mode_request_admin);

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->retransmission_request_admin);

}

void connectib_plpc_reg_unpack(struct connectib_plpc_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	ptr_struct->proto_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 4;
	ptr_struct->profile_id = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset = 48;
	ptr_struct->lane_speed = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 88;
	ptr_struct->fec_mode_policy = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 87;
	ptr_struct->lpbf = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 104;
	ptr_struct->fec_mode_capability = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->retransmission_capability = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->fec_mode_support_admin = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 128;
	ptr_struct->retransmission_support_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 168;
	ptr_struct->fec_mode_request_admin = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 160;
	ptr_struct->retransmission_request_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_plpc_reg_print(const struct connectib_plpc_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_plpc_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "proto_mask           : " UH_FMT "\n", ptr_struct->proto_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "profile_id           : " UH_FMT "\n", ptr_struct->profile_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane_speed           : " UH_FMT "\n", ptr_struct->lane_speed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_mode_policy      : " UH_FMT "\n", ptr_struct->fec_mode_policy);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lpbf                 : " UH_FMT "\n", ptr_struct->lpbf);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_mode_capability  : " UH_FMT "\n", ptr_struct->fec_mode_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_capability : " UH_FMT "\n", ptr_struct->retransmission_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_mode_support_admin : " UH_FMT "\n", ptr_struct->fec_mode_support_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_support_admin : " UH_FMT "\n", ptr_struct->retransmission_support_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_mode_request_admin : " UH_FMT "\n", ptr_struct->fec_mode_request_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_request_admin : " UH_FMT "\n", ptr_struct->retransmission_request_admin);

}

int connectib_plpc_reg_size(void)
{
	 return 40;
}

void connectib_plpc_reg_dump(const struct connectib_plpc_reg *ptr_struct, FILE* file)
{
	connectib_plpc_reg_print(ptr_struct, file, 0);
}

void connectib_pplr_reg_pack(const struct connectib_pplr_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pplr_reg_unpack(struct connectib_pplr_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pplr_reg_print(const struct connectib_pplr_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pplr_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pplr_reg_size(void)
{
	 return 8;
}

void connectib_pplr_reg_dump(const struct connectib_pplr_reg *ptr_struct, FILE* file)
{
	connectib_pplr_reg_print(ptr_struct, file, 0);
}

void connectib_project_nvgn_pack(const struct connectib_project_nvgn *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->nv_pointer);

	offset = 128;
	connectib_nv_tlv_hdr_pack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset = 224;
	connectib_register_access_data_reduced_pack(&(ptr_struct->tlv_data), ptr_buff + offset/8);

}

void connectib_project_nvgn_unpack(struct connectib_project_nvgn *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->nv_pointer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	connectib_nv_tlv_hdr_unpack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset = 224;
	connectib_register_access_data_reduced_unpack(&(ptr_struct->tlv_data), ptr_buff + offset/8);

}

void connectib_project_nvgn_print(const struct connectib_project_nvgn *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvgn ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nv_pointer           : " U32H_FMT "\n", ptr_struct->nv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tlv_header:\n");
	connectib_nv_tlv_hdr_print(&(ptr_struct->tlv_header), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tlv_data:\n");
	connectib_register_access_data_reduced_print(&(ptr_struct->tlv_data), file, indent_level + 1);

}

int connectib_project_nvgn_size(void)
{
	 return 44;
}

void connectib_project_nvgn_dump(const struct connectib_project_nvgn *ptr_struct, FILE* file)
{
	connectib_project_nvgn_print(ptr_struct, file, 0);
}

void connectib_project_nvia_pack(const struct connectib_project_nvia *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->target);

}

void connectib_project_nvia_unpack(struct connectib_project_nvia *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	ptr_struct->target = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_project_nvia_print(const struct connectib_project_nvia *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvia ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "target               : " UH_FMT "\n", ptr_struct->target);

}

int connectib_project_nvia_size(void)
{
	 return 8;
}

void connectib_project_nvia_dump(const struct connectib_project_nvia *ptr_struct, FILE* file)
{
	connectib_project_nvia_print(ptr_struct, file, 0);
}

void connectib_project_nvgc_pack(const struct connectib_project_nvgc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->nvda_read_factory_settings);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->nvda_read_current_settings);

}

void connectib_project_nvgc_unpack(struct connectib_project_nvgc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->nvda_read_factory_settings = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->nvda_read_current_settings = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_project_nvgc_print(const struct connectib_project_nvgc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvgc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvda_read_factory_settings : " UH_FMT "\n", ptr_struct->nvda_read_factory_settings);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvda_read_current_settings : " UH_FMT "\n", ptr_struct->nvda_read_current_settings);

}

int connectib_project_nvgc_size(void)
{
	 return 16;
}

void connectib_project_nvgc_dump(const struct connectib_project_nvgc *ptr_struct, FILE* file)
{
	connectib_project_nvgc_print(ptr_struct, file, 0);
}

void connectib_project_nvqc_pack(const struct connectib_project_nvqc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_nv_tlv_type_pack(&(ptr_struct->type), ptr_buff + offset/8);

	offset = 63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->support_rd);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->support_wr);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->version);

}

void connectib_project_nvqc_unpack(struct connectib_project_nvqc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_nv_tlv_type_unpack(&(ptr_struct->type), ptr_buff + offset/8);

	offset = 63;
	ptr_struct->support_rd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 62;
	ptr_struct->support_wr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 56;
	ptr_struct->version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_project_nvqc_print(const struct connectib_project_nvqc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvqc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type:\n");
	connectib_nv_tlv_type_print(&(ptr_struct->type), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "support_rd           : " UH_FMT "\n", ptr_struct->support_rd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "support_wr           : " UH_FMT "\n", ptr_struct->support_wr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version              : " UH_FMT "\n", ptr_struct->version);

}

int connectib_project_nvqc_size(void)
{
	 return 8;
}

void connectib_project_nvqc_dump(const struct connectib_project_nvqc *ptr_struct, FILE* file)
{
	connectib_project_nvqc_print(ptr_struct, file, 0);
}

void connectib_project_nvda_pack(const struct connectib_project_nvda *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_nv_tlv_hdr_pack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset = 96;
	connectib_register_access_data_pack(&(ptr_struct->nvda_data), ptr_buff + offset/8);

}

void connectib_project_nvda_unpack(struct connectib_project_nvda *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_nv_tlv_hdr_unpack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset = 96;
	connectib_register_access_data_unpack(&(ptr_struct->nvda_data), ptr_buff + offset/8);

}

void connectib_project_nvda_print(const struct connectib_project_nvda *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvda ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tlv_header:\n");
	connectib_nv_tlv_hdr_print(&(ptr_struct->tlv_header), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvda_data:\n");
	connectib_register_access_data_print(&(ptr_struct->nvda_data), file, indent_level + 1);

}

int connectib_project_nvda_size(void)
{
	 return 44;
}

void connectib_project_nvda_dump(const struct connectib_project_nvda *ptr_struct, FILE* file)
{
	connectib_project_nvda_print(ptr_struct, file, 0);
}

void connectib_pmtu_reg_pack(const struct connectib_pmtu_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_mtu);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->admin_mtu);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->oper_mtu);

}

void connectib_pmtu_reg_unpack(struct connectib_pmtu_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->max_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->admin_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 96;
	ptr_struct->oper_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_pmtu_reg_print(const struct connectib_pmtu_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmtu_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_mtu              : " UH_FMT "\n", ptr_struct->max_mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "admin_mtu            : " UH_FMT "\n", ptr_struct->admin_mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oper_mtu             : " UH_FMT "\n", ptr_struct->oper_mtu);

}

int connectib_pmtu_reg_size(void)
{
	 return 16;
}

void connectib_pmtu_reg_dump(const struct connectib_pmtu_reg *ptr_struct, FILE* file)
{
	connectib_pmtu_reg_print(ptr_struct, file, 0);
}

void connectib_pamp_reg_pack(const struct connectib_pamp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pamp_reg_unpack(struct connectib_pamp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pamp_reg_print(const struct connectib_pamp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pamp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pamp_reg_size(void)
{
	 return 44;
}

void connectib_pamp_reg_dump(const struct connectib_pamp_reg *ptr_struct, FILE* file)
{
	connectib_pamp_reg_print(ptr_struct, file, 0);
}

void connectib_ppaos_reg_pack(const struct connectib_ppaos_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ppaos_reg_unpack(struct connectib_ppaos_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ppaos_reg_print(const struct connectib_ppaos_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ppaos_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_ppaos_reg_size(void)
{
	 return 16;
}

void connectib_ppaos_reg_dump(const struct connectib_ppaos_reg *ptr_struct, FILE* file)
{
	connectib_ppaos_reg_print(ptr_struct, file, 0);
}

void connectib_pprt_reg_pack(const struct connectib_pprt_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pprt_reg_unpack(struct connectib_pprt_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pprt_reg_print(const struct connectib_pprt_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pprt_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pprt_reg_size(void)
{
	 return 32;
}

void connectib_pprt_reg_dump(const struct connectib_pprt_reg *ptr_struct, FILE* file)
{
	connectib_pprt_reg_print(ptr_struct, file, 0);
}

void connectib_pptt_reg_pack(const struct connectib_pptt_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pptt_reg_unpack(struct connectib_pptt_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pptt_reg_print(const struct connectib_pptt_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pptt_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pptt_reg_size(void)
{
	 return 28;
}

void connectib_pptt_reg_dump(const struct connectib_pptt_reg *ptr_struct, FILE* file)
{
	connectib_pptt_reg_print(ptr_struct, file, 0);
}

void connectib_slrg_reg_pack(const struct connectib_slrg_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrg_reg_unpack(struct connectib_slrg_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrg_reg_print(const struct connectib_slrg_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_slrg_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_slrg_reg_size(void)
{
	 return 40;
}

void connectib_slrg_reg_dump(const struct connectib_slrg_reg *ptr_struct, FILE* file)
{
	connectib_slrg_reg_print(ptr_struct, file, 0);
}

void connectib_ptas_reg_pack(const struct connectib_ptas_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ptas_reg_unpack(struct connectib_ptas_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ptas_reg_print(const struct connectib_ptas_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ptas_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_ptas_reg_size(void)
{
	 return 44;
}

void connectib_ptas_reg_dump(const struct connectib_ptas_reg *ptr_struct, FILE* file)
{
	connectib_ptas_reg_print(ptr_struct, file, 0);
}

void connectib_sltp_reg_pack(const struct connectib_sltp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_sltp_reg_unpack(struct connectib_sltp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_sltp_reg_print(const struct connectib_sltp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sltp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_sltp_reg_size(void)
{
	 return 20;
}

void connectib_sltp_reg_dump(const struct connectib_sltp_reg *ptr_struct, FILE* file)
{
	connectib_sltp_reg_print(ptr_struct, file, 0);
}

void connectib_slrp_reg_pack(const struct connectib_slrp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrp_reg_unpack(struct connectib_slrp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrp_reg_print(const struct connectib_slrp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_slrp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_slrp_reg_size(void)
{
	 return 40;
}

void connectib_slrp_reg_dump(const struct connectib_slrp_reg *ptr_struct, FILE* file)
{
	connectib_slrp_reg_print(ptr_struct, file, 0);
}

void connectib_paos_reg_pack(const struct connectib_paos_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->oper_status);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->admin_status);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->swid);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->e);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ee);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ase);

}

void connectib_paos_reg_unpack(struct connectib_paos_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->oper_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 20;
	ptr_struct->admin_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->swid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 62;
	ptr_struct->e = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 33;
	ptr_struct->ee = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->ase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_paos_reg_print(const struct connectib_paos_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_paos_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oper_status          : " UH_FMT "\n", ptr_struct->oper_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "admin_status         : " UH_FMT "\n", ptr_struct->admin_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swid                 : " UH_FMT "\n", ptr_struct->swid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e                    : " UH_FMT "\n", ptr_struct->e);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ee                   : " UH_FMT "\n", ptr_struct->ee);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ase                  : " UH_FMT "\n", ptr_struct->ase);

}

int connectib_paos_reg_size(void)
{
	 return 16;
}

void connectib_paos_reg_dump(const struct connectib_paos_reg *ptr_struct, FILE* file)
{
	connectib_paos_reg_print(ptr_struct, file, 0);
}

void connectib_mjtag_pack(const struct connectib_mjtag *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->size);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sequence_number);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->cmd);

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(32, 32, i, 352, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword[i]);
	}

}

void connectib_mjtag_unpack(struct connectib_mjtag *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 4;
	ptr_struct->sequence_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 0;
	ptr_struct->cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(32, 32, i, 352, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mjtag_print(const struct connectib_mjtag *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mjtag ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sequence_number      : " UH_FMT "\n", ptr_struct->sequence_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmd                  : " UH_FMT "\n", ptr_struct->cmd);

	for (i = 0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : " U32H_FMT "\n", i, ptr_struct->dword[i]);
	}

}

int connectib_mjtag_size(void)
{
	 return 44;
}

void connectib_mjtag_dump(const struct connectib_mjtag *ptr_struct, FILE* file)
{
	connectib_mjtag_print(ptr_struct, file, 0);
}

void connectib_mqis_reg_pack(const struct connectib_mqis_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->info_type);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->info_length);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->read_length);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->read_offset);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->info_string[i]);
	}

}

void connectib_mqis_reg_unpack(struct connectib_mqis_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->info_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->info_length = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 80;
	ptr_struct->read_length = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->read_offset = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	ptr_struct->info_string[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mqis_reg_print(const struct connectib_mqis_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mqis_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "info_type            : " UH_FMT "\n", ptr_struct->info_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "info_length          : " UH_FMT "\n", ptr_struct->info_length);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_length          : " UH_FMT "\n", ptr_struct->read_length);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_offset          : " UH_FMT "\n", ptr_struct->read_offset);

	for (i = 0; i < 1; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "info_string_%03d     : " U32H_FMT "\n", i, ptr_struct->info_string[i]);
	}

}

int connectib_mqis_reg_size(void)
{
	 return 20;
}

void connectib_mqis_reg_dump(const struct connectib_mqis_reg *ptr_struct, FILE* file)
{
	connectib_mqis_reg_print(ptr_struct, file, 0);
}

void connectib_mcda_reg_pack(const struct connectib_mcda_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->update_handle);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->offset);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->size);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->data[i]);
	}

}

void connectib_mcda_reg_unpack(struct connectib_mcda_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->update_handle = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 32;
	ptr_struct->offset = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 80;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	ptr_struct->data[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mcda_reg_print(const struct connectib_mcda_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcda_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "update_handle        : " UH_FMT "\n", ptr_struct->update_handle);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "offset               : " U32H_FMT "\n", ptr_struct->offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	for (i = 0; i < 1; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_%03d            : " U32H_FMT "\n", i, ptr_struct->data[i]);
	}

}

int connectib_mcda_reg_size(void)
{
	 return 20;
}

void connectib_mcda_reg_dump(const struct connectib_mcda_reg *ptr_struct, FILE* file)
{
	connectib_mcda_reg_print(ptr_struct, file, 0);
}

void connectib_mcc_reg_pack(const struct connectib_mcc_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->instruction);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->time_elapsed_since_last_cmd);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->component_index);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->update_handle);

	offset = 124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->control_state);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->error_code);

	offset = 105;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->control_progress);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->handle_owner_host_id);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->handle_owner_type);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->component_size);

}

void connectib_mcc_reg_unpack(struct connectib_mcc_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->instruction = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 4;
	ptr_struct->time_elapsed_since_last_cmd = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset = 48;
	ptr_struct->component_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 72;
	ptr_struct->update_handle = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 124;
	ptr_struct->control_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 112;
	ptr_struct->error_code = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 105;
	ptr_struct->control_progress = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 100;
	ptr_struct->handle_owner_host_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->handle_owner_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->component_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mcc_reg_print(const struct connectib_mcc_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcc_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "instruction          : " UH_FMT "\n", ptr_struct->instruction);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_elapsed_since_last_cmd : " UH_FMT "\n", ptr_struct->time_elapsed_since_last_cmd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_index      : " UH_FMT "\n", ptr_struct->component_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "update_handle        : " UH_FMT "\n", ptr_struct->update_handle);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "control_state        : " UH_FMT "\n", ptr_struct->control_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_code           : " UH_FMT "\n", ptr_struct->error_code);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "control_progress     : " UH_FMT "\n", ptr_struct->control_progress);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "handle_owner_host_id : " UH_FMT "\n", ptr_struct->handle_owner_host_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "handle_owner_type    : " UH_FMT "\n", ptr_struct->handle_owner_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_size       : " U32H_FMT "\n", ptr_struct->component_size);

}

int connectib_mcc_reg_size(void)
{
	 return 32;
}

void connectib_mcc_reg_dump(const struct connectib_mcc_reg *ptr_struct, FILE* file)
{
	connectib_mcc_reg_print(ptr_struct, file, 0);
}

void connectib_mcqi_reg_pack(const struct connectib_mcqi_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->component_index);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_pending_component);

	offset = 91;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->info_type);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->info_size);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->offset);

	offset = 176;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->data_size);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(192, 32, i, 224, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->data[i]);
	}

}

void connectib_mcqi_reg_unpack(struct connectib_mcqi_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->component_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 0;
	ptr_struct->read_pending_component = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 91;
	ptr_struct->info_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 96;
	ptr_struct->info_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->offset = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 176;
	ptr_struct->data_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(192, 32, i, 224, 1);
	ptr_struct->data[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mcqi_reg_print(const struct connectib_mcqi_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcqi_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_index      : " UH_FMT "\n", ptr_struct->component_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_pending_component : " UH_FMT "\n", ptr_struct->read_pending_component);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "info_type            : " UH_FMT "\n", ptr_struct->info_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "info_size            : " U32H_FMT "\n", ptr_struct->info_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "offset               : " U32H_FMT "\n", ptr_struct->offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_size            : " UH_FMT "\n", ptr_struct->data_size);

	for (i = 0; i < 1; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_%03d            : " U32H_FMT "\n", i, ptr_struct->data[i]);
	}

}

int connectib_mcqi_reg_size(void)
{
	 return 28;
}

void connectib_mcqi_reg_dump(const struct connectib_mcqi_reg *ptr_struct, FILE* file)
{
	connectib_mcqi_reg_print(ptr_struct, file, 0);
}

void connectib_mcqs_reg_pack(const struct connectib_mcqs_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->component_index);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_index_flag);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->identifier);

	offset = 92;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->component_update_state);

	offset = 87;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->component_status);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->last_update_state_changer_host_id);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->last_update_state_changer_type);

}

void connectib_mcqs_reg_unpack(struct connectib_mcqs_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->component_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 0;
	ptr_struct->last_index_flag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->identifier = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 92;
	ptr_struct->component_update_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 87;
	ptr_struct->component_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 100;
	ptr_struct->last_update_state_changer_host_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->last_update_state_changer_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_mcqs_reg_print(const struct connectib_mcqs_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcqs_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_index      : " UH_FMT "\n", ptr_struct->component_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_index_flag      : " UH_FMT "\n", ptr_struct->last_index_flag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "identifier           : " UH_FMT "\n", ptr_struct->identifier);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_update_state : " UH_FMT "\n", ptr_struct->component_update_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "component_status     : " UH_FMT "\n", ptr_struct->component_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_update_state_changer_host_id : " UH_FMT "\n", ptr_struct->last_update_state_changer_host_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_update_state_changer_type : " UH_FMT "\n", ptr_struct->last_update_state_changer_type);

}

int connectib_mcqs_reg_size(void)
{
	 return 16;
}

void connectib_mcqs_reg_dump(const struct connectib_mcqs_reg *ptr_struct, FILE* file)
{
	connectib_mcqs_reg_print(ptr_struct, file, 0);
}

void connectib_mfbe_pack(const struct connectib_mfbe *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_64kb_erase);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_32kb_erase);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

}

void connectib_mfbe_unpack(struct connectib_mfbe *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->bulk_64kb_erase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->bulk_32kb_erase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_mfbe_print(const struct connectib_mfbe *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfbe ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_64kb_erase      : " UH_FMT "\n", ptr_struct->bulk_64kb_erase);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_32kb_erase      : " UH_FMT "\n", ptr_struct->bulk_32kb_erase);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : " UH_FMT "\n", ptr_struct->address);

}

int connectib_mfbe_size(void)
{
	 return 12;
}

void connectib_mfbe_dump(const struct connectib_mfbe *ptr_struct, FILE* file)
{
	connectib_mfbe_print(ptr_struct, file, 0);
}

void connectib_project_mfba_pack(const struct connectib_project_mfba *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_mfba_header_pack(&(ptr_struct->mfba_header), ptr_buff + offset/8);

	offset = 96;
	connectib_register_access_data_pack(&(ptr_struct->mfba_data), ptr_buff + offset/8);

}

void connectib_project_mfba_unpack(struct connectib_project_mfba *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_mfba_header_unpack(&(ptr_struct->mfba_header), ptr_buff + offset/8);

	offset = 96;
	connectib_register_access_data_unpack(&(ptr_struct->mfba_data), ptr_buff + offset/8);

}

void connectib_project_mfba_print(const struct connectib_project_mfba *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_mfba ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfba_header:\n");
	connectib_mfba_header_print(&(ptr_struct->mfba_header), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfba_data:\n");
	connectib_register_access_data_print(&(ptr_struct->mfba_data), file, indent_level + 1);

}

int connectib_project_mfba_size(void)
{
	 return 44;
}

void connectib_project_mfba_dump(const struct connectib_project_mfba *ptr_struct, FILE* file)
{
	connectib_project_mfba_print(ptr_struct, file, 0);
}

void connectib_register_misc_counters_pack(const struct connectib_register_misc_counters *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->counter_select);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ecc);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ldb_silent_drop);

}

void connectib_register_misc_counters_unpack(struct connectib_register_misc_counters *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	ptr_struct->counter_select = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->ecc = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->ldb_silent_drop = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_register_misc_counters_print(const struct connectib_register_misc_counters *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_misc_counters ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_select       : " U32H_FMT "\n", ptr_struct->counter_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecc                  : " U32H_FMT "\n", ptr_struct->ecc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ldb_silent_drop      : " U32H_FMT "\n", ptr_struct->ldb_silent_drop);

}

int connectib_register_misc_counters_size(void)
{
	 return 32;
}

void connectib_register_misc_counters_dump(const struct connectib_register_misc_counters *ptr_struct, FILE* file)
{
	connectib_register_misc_counters_print(ptr_struct, file, 0);
}

void connectib_mtmp_pack(const struct connectib_mtmp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->sensor_index);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->internal_diodes_query);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_temperture);

	offset = 65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mtr);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mte);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature_threshold_hi);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->tee);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature_threshold_lo);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->name_hi);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->name_lo);

}

void connectib_mtmp_unpack(struct connectib_mtmp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	ptr_struct->sensor_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 0;
	ptr_struct->internal_diodes_query = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->temperature = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 80;
	ptr_struct->max_temperture = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 65;
	ptr_struct->mtr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->mte = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 112;
	ptr_struct->temperature_threshold_hi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 96;
	ptr_struct->tee = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 144;
	ptr_struct->temperature_threshold_lo = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 192;
	ptr_struct->name_hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->name_lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mtmp_print(const struct connectib_mtmp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mtmp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sensor_index         : " UH_FMT "\n", ptr_struct->sensor_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "internal_diodes_query : " UH_FMT "\n", ptr_struct->internal_diodes_query);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature          : " UH_FMT "\n", ptr_struct->temperature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_temperture       : " UH_FMT "\n", ptr_struct->max_temperture);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtr                  : " UH_FMT "\n", ptr_struct->mtr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mte                  : " UH_FMT "\n", ptr_struct->mte);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature_threshold_hi : " UH_FMT "\n", ptr_struct->temperature_threshold_hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tee                  : " UH_FMT "\n", ptr_struct->tee);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature_threshold_lo : " UH_FMT "\n", ptr_struct->temperature_threshold_lo);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "name_hi              : " U32H_FMT "\n", ptr_struct->name_hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "name_lo              : " U32H_FMT "\n", ptr_struct->name_lo);

}

int connectib_mtmp_size(void)
{
	 return 32;
}

void connectib_mtmp_dump(const struct connectib_mtmp *ptr_struct, FILE* file)
{
	connectib_mtmp_print(ptr_struct, file, 0);
}

void connectib_register_mfrl_pack(const struct connectib_register_mfrl *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->reset_level);

}

void connectib_register_mfrl_unpack(struct connectib_register_mfrl *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 56;
	ptr_struct->reset_level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_mfrl_print(const struct connectib_register_mfrl *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfrl ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reset_level          : " UH_FMT "\n", ptr_struct->reset_level);

}

int connectib_register_mfrl_size(void)
{
	 return 16;
}

void connectib_register_mfrl_dump(const struct connectib_register_mfrl *ptr_struct, FILE* file)
{
	connectib_register_mfrl_print(ptr_struct, file, 0);
}

void connectib_register_mfai_pack(const struct connectib_register_mfai *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->permanent);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->use_address);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->use_image_id);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->image_id);

}

void connectib_register_mfai_unpack(struct connectib_register_mfai *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 2;
	ptr_struct->permanent = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->use_address = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->use_image_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 56;
	ptr_struct->image_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_mfai_print(const struct connectib_register_mfai *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfai ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : " UH_FMT "\n", ptr_struct->address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "permanent            : " UH_FMT "\n", ptr_struct->permanent);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "use_address          : " UH_FMT "\n", ptr_struct->use_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "use_image_id         : " UH_FMT "\n", ptr_struct->use_image_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "image_id             : " UH_FMT "\n", ptr_struct->image_id);

}

int connectib_register_mfai_size(void)
{
	 return 16;
}

void connectib_register_mfai_dump(const struct connectib_register_mfai *ptr_struct, FILE* file)
{
	connectib_register_mfai_print(ptr_struct, file, 0);
}

void connectib_mfpa_pack(const struct connectib_mfpa *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->boot_address);

	offset = 156;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->flash_num);

	offset = 143;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sub_sector_wrp_en);

	offset = 142;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sector_wrp_en);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_64kb_erase_en);

	offset = 129;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_32kb_erase_en);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wip);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->jedec_id);

	offset = 214;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->sector_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->block_allignment);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->block_size);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->capability_mask);

}

void connectib_mfpa_unpack(struct connectib_mfpa *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 40;
	ptr_struct->boot_address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 156;
	ptr_struct->flash_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 143;
	ptr_struct->sub_sector_wrp_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 142;
	ptr_struct->sector_wrp_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->bulk_64kb_erase_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 129;
	ptr_struct->bulk_32kb_erase_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 128;
	ptr_struct->wip = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->jedec_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 214;
	ptr_struct->sector_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset = 200;
	ptr_struct->block_allignment = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 192;
	ptr_struct->block_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 224;
	ptr_struct->capability_mask = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mfpa_print(const struct connectib_mfpa *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfpa ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "boot_address         : " UH_FMT "\n", ptr_struct->boot_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flash_num            : " UH_FMT "\n", ptr_struct->flash_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sub_sector_wrp_en    : " UH_FMT "\n", ptr_struct->sub_sector_wrp_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sector_wrp_en        : " UH_FMT "\n", ptr_struct->sector_wrp_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_64kb_erase_en   : " UH_FMT "\n", ptr_struct->bulk_64kb_erase_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_32kb_erase_en   : " UH_FMT "\n", ptr_struct->bulk_32kb_erase_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wip                  : " UH_FMT "\n", ptr_struct->wip);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "jedec_id             : " UH_FMT "\n", ptr_struct->jedec_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sector_size          : " UH_FMT "\n", ptr_struct->sector_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "block_allignment     : " UH_FMT "\n", ptr_struct->block_allignment);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "block_size           : " UH_FMT "\n", ptr_struct->block_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "capability_mask      : " U32H_FMT "\n", ptr_struct->capability_mask);

}

int connectib_mfpa_size(void)
{
	 return 32;
}

void connectib_mfpa_dump(const struct connectib_mfpa *ptr_struct, FILE* file)
{
	connectib_mfpa_print(ptr_struct, file, 0);
}

void connectib_fpga_shell_caps_pack(const struct connectib_fpga_shell_caps *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->total_rcv_credits);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_num_qps);

	offset = 63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rc);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uc);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ud);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dc);

	offset = 55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rre);

	offset = 54;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rwe);

	offset = 53;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rae);

	offset = 46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->qp_type);

	offset = 90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log_ddr_size);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_fpga_qp_msg_size);

}

void connectib_fpga_shell_caps_unpack(struct connectib_fpga_shell_caps *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->total_rcv_credits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->max_num_qps = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 63;
	ptr_struct->rc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 62;
	ptr_struct->uc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 61;
	ptr_struct->ud = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 60;
	ptr_struct->dc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 55;
	ptr_struct->rre = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 54;
	ptr_struct->rwe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 53;
	ptr_struct->rae = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 46;
	ptr_struct->qp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 90;
	ptr_struct->log_ddr_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 96;
	ptr_struct->max_fpga_qp_msg_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_fpga_shell_caps_print(const struct connectib_fpga_shell_caps *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fpga_shell_caps ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_rcv_credits    : " UH_FMT "\n", ptr_struct->total_rcv_credits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_num_qps          : " UH_FMT "\n", ptr_struct->max_num_qps);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rc                   : " UH_FMT "\n", ptr_struct->rc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uc                   : " UH_FMT "\n", ptr_struct->uc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ud                   : " UH_FMT "\n", ptr_struct->ud);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc                   : " UH_FMT "\n", ptr_struct->dc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rre                  : " UH_FMT "\n", ptr_struct->rre);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwe                  : " UH_FMT "\n", ptr_struct->rwe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rae                  : " UH_FMT "\n", ptr_struct->rae);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_type              : %s (" UH_FMT ")\n", (ptr_struct->qp_type == 1 ? ("Shell_qp") : ((ptr_struct->qp_type == 2 ? ("Sandbox_qp") : ("unknown")))), ptr_struct->qp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_ddr_size         : " UH_FMT "\n", ptr_struct->log_ddr_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_fpga_qp_msg_size : " U32H_FMT "\n", ptr_struct->max_fpga_qp_msg_size);

}

int connectib_fpga_shell_caps_size(void)
{
	 return 64;
}

void connectib_fpga_shell_caps_dump(const struct connectib_fpga_shell_caps *ptr_struct, FILE* file)
{
	connectib_fpga_shell_caps_print(ptr_struct, file, 0);
}

void connectib_pmmp_sfp_protocol_override_layout_auto_pack(const union connectib_pmmp_sfp_protocol_override_layout_auto *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_pmmp_sfp_protocol_override_layout_pack(&(ptr_struct->pmmp_sfp_protocol_override_layout), ptr_buff);
}

void connectib_pmmp_sfp_protocol_override_layout_auto_unpack(union connectib_pmmp_sfp_protocol_override_layout_auto *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_pmmp_sfp_protocol_override_layout_unpack(&(ptr_struct->pmmp_sfp_protocol_override_layout), ptr_buff);
}

void connectib_pmmp_sfp_protocol_override_layout_auto_print(const union connectib_pmmp_sfp_protocol_override_layout_auto *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmmp_sfp_protocol_override_layout_auto ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pmmp_sfp_protocol_override_layout:\n");
	connectib_pmmp_sfp_protocol_override_layout_print(&(ptr_struct->pmmp_sfp_protocol_override_layout), file, indent_level + 1);

}

int connectib_pmmp_sfp_protocol_override_layout_auto_size(void)
{
	 return 12;
}

void connectib_pmmp_sfp_protocol_override_layout_auto_dump(const union connectib_pmmp_sfp_protocol_override_layout_auto *ptr_struct, FILE* file)
{
	connectib_pmmp_sfp_protocol_override_layout_auto_print(ptr_struct, file, 0);
}

void connectib_pmmp_qsfp_protocol_override_layout_auto_pack(const union connectib_pmmp_qsfp_protocol_override_layout_auto *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_pmmp_qsfp_protocol_override_layout_pack(&(ptr_struct->pmmp_qsfp_protocol_override_layout), ptr_buff);
}

void connectib_pmmp_qsfp_protocol_override_layout_auto_unpack(union connectib_pmmp_qsfp_protocol_override_layout_auto *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_pmmp_qsfp_protocol_override_layout_unpack(&(ptr_struct->pmmp_qsfp_protocol_override_layout), ptr_buff);
}

void connectib_pmmp_qsfp_protocol_override_layout_auto_print(const union connectib_pmmp_qsfp_protocol_override_layout_auto *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmmp_qsfp_protocol_override_layout_auto ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pmmp_qsfp_protocol_override_layout:\n");
	connectib_pmmp_qsfp_protocol_override_layout_print(&(ptr_struct->pmmp_qsfp_protocol_override_layout), file, indent_level + 1);

}

int connectib_pmmp_qsfp_protocol_override_layout_auto_size(void)
{
	 return 12;
}

void connectib_pmmp_qsfp_protocol_override_layout_auto_dump(const union connectib_pmmp_qsfp_protocol_override_layout_auto *ptr_struct, FILE* file)
{
	connectib_pmmp_qsfp_protocol_override_layout_auto_print(ptr_struct, file, 0);
}

void connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_pack(const union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_pcie_timers_states_pack(&(ptr_struct->pcie_timers_states), ptr_buff);
}

void connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_unpack(union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_pcie_timers_states_unpack(&(ptr_struct->pcie_timers_states), ptr_buff);
}

void connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_print(const union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcie_perf_counters:\n");
	connectib_pcie_perf_counters_print(&(ptr_struct->pcie_perf_counters), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcie_lanes_counters:\n");
	connectib_pcie_lanes_counters_print(&(ptr_struct->pcie_lanes_counters), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcie_timers_states:\n");
	connectib_pcie_timers_states_print(&(ptr_struct->pcie_timers_states), file, indent_level + 1);

}

int connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_size(void)
{
	 return 248;
}

void connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_dump(const union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto *ptr_struct, FILE* file)
{
	connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_print(ptr_struct, file, 0);
}

void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_pack(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_phys_layer_stat_cntrs_pack(&(ptr_struct->phys_layer_stat_cntrs), ptr_buff);
}

void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_unpack(union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_phys_layer_stat_cntrs_unpack(&(ptr_struct->phys_layer_stat_cntrs), ptr_buff);
}

void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_print(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_802_3_cntrs_grp_data_layout:\n");
	connectib_eth_802_3_cntrs_grp_data_layout_print(&(ptr_struct->eth_802_3_cntrs_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_2863_cntrs_grp_data_layout:\n");
	connectib_eth_2863_cntrs_grp_data_layout_print(&(ptr_struct->eth_2863_cntrs_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_2819_cntrs_grp_data_layout:\n");
	connectib_eth_2819_cntrs_grp_data_layout_print(&(ptr_struct->eth_2819_cntrs_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_3635_cntrs_grp_data_layout:\n");
	connectib_eth_3635_cntrs_grp_data_layout_print(&(ptr_struct->eth_3635_cntrs_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_extended_cntrs_grp_data_layout:\n");
	connectib_eth_extended_cntrs_grp_data_layout_print(&(ptr_struct->eth_extended_cntrs_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_per_prio_grp_data_layout:\n");
	connectib_eth_per_prio_grp_data_layout_print(&(ptr_struct->eth_per_prio_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_per_traffic_grp_data_layout:\n");
	connectib_eth_per_traffic_grp_data_layout_print(&(ptr_struct->eth_per_traffic_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "correct_on_demand:\n");
	connectib_correct_on_demand_layout_print(&(ptr_struct->correct_on_demand), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phys_layer_cntrs:\n");
	connectib_phys_layer_cntrs_print(&(ptr_struct->phys_layer_cntrs), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "discard:\n");
	connectib_discard_cntrs_grp_data_print(&(ptr_struct->discard), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_counters:\n");
	connectib_llr_counters_print(&(ptr_struct->llr_counters), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_port_counters:\n");
	connectib_ib_port_counters_print(&(ptr_struct->ib_port_counters), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_per_traffic_congestion_grp_data_layout:\n");
	connectib_eth_per_traffic_congestion_grp_data_layout_print(&(ptr_struct->eth_per_traffic_congestion_grp_data_layout), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phys_layer_stat_cntrs:\n");
	connectib_phys_layer_stat_cntrs_print(&(ptr_struct->phys_layer_stat_cntrs), file, indent_level + 1);

}

int connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_size(void)
{
	 return 248;
}

void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_dump(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, FILE* file)
{
	connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_print(ptr_struct, file, 0);
}

void connectib_access_register_unit_perf_counters_data_line_pack(const struct connectib_access_register_unit_perf_counters_data_line *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->value);

}

void connectib_access_register_unit_perf_counters_data_line_unpack(struct connectib_access_register_unit_perf_counters_data_line *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->value = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_access_register_unit_perf_counters_data_line_print(const struct connectib_access_register_unit_perf_counters_data_line *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_access_register_unit_perf_counters_data_line ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "value                : " U32H_FMT "\n", ptr_struct->value);

}

int connectib_access_register_unit_perf_counters_data_line_size(void)
{
	 return 4;
}

void connectib_access_register_unit_perf_counters_data_line_dump(const struct connectib_access_register_unit_perf_counters_data_line *ptr_struct, FILE* file)
{
	connectib_access_register_unit_perf_counters_data_line_print(ptr_struct, file, 0);
}

void connectib_access_register_unit_perf_counters_cfg_line_pack(const struct connectib_access_register_unit_perf_counters_cfg_line *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->select);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cmd);

}

void connectib_access_register_unit_perf_counters_cfg_line_unpack(struct connectib_access_register_unit_perf_counters_cfg_line *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_access_register_unit_perf_counters_cfg_line_print(const struct connectib_access_register_unit_perf_counters_cfg_line *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_access_register_unit_perf_counters_cfg_line ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "select               : " UH_FMT "\n", ptr_struct->select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmd                  : " UH_FMT "\n", ptr_struct->cmd);

}

int connectib_access_register_unit_perf_counters_cfg_line_size(void)
{
	 return 4;
}

void connectib_access_register_unit_perf_counters_cfg_line_dump(const struct connectib_access_register_unit_perf_counters_cfg_line *ptr_struct, FILE* file)
{
	connectib_access_register_unit_perf_counters_cfg_line_print(ptr_struct, file, 0);
}

void connectib_node_description_pack(const struct connectib_node_description *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 512, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->d[i]);
	}

}

void connectib_node_description_unpack(struct connectib_node_description *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 512, 1);
	ptr_struct->d[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_node_description_print(const struct connectib_node_description *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_node_description ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 16; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "d_%03d               : " U32H_FMT "\n", i, ptr_struct->d[i]);
	}

}

int connectib_node_description_size(void)
{
	 return 64;
}

void connectib_node_description_dump(const struct connectib_node_description *ptr_struct, FILE* file)
{
	connectib_node_description_print(ptr_struct, file, 0);
}

void connectib_application_prio_entry_pack(const struct connectib_application_prio_entry *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->protocol_id);

	offset = 13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->sel);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->priority);

}

void connectib_application_prio_entry_unpack(struct connectib_application_prio_entry *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->protocol_id = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 13;
	ptr_struct->sel = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 8;
	ptr_struct->priority = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_application_prio_entry_print(const struct connectib_application_prio_entry *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_application_prio_entry ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "protocol_id          : " UH_FMT "\n", ptr_struct->protocol_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sel                  : " UH_FMT "\n", ptr_struct->sel);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "priority             : " UH_FMT "\n", ptr_struct->priority);

}

int connectib_application_prio_entry_size(void)
{
	 return 4;
}

void connectib_application_prio_entry_dump(const struct connectib_application_prio_entry *ptr_struct, FILE* file)
{
	connectib_application_prio_entry_print(ptr_struct, file, 0);
}

void connectib_tc_qos_configuration_pack(const struct connectib_tc_qos_configuration *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->bw_allocation);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->group);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->r);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->b);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->g);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->max_bw_value);

	offset = 44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_bw_units);

}

void connectib_tc_qos_configuration_unpack(struct connectib_tc_qos_configuration *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	ptr_struct->bw_allocation = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 12;
	ptr_struct->group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 2;
	ptr_struct->r = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->b = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 56;
	ptr_struct->max_bw_value = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 44;
	ptr_struct->max_bw_units = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_tc_qos_configuration_print(const struct connectib_tc_qos_configuration *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_tc_qos_configuration ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bw_allocation        : " UH_FMT "\n", ptr_struct->bw_allocation);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "group                : " UH_FMT "\n", ptr_struct->group);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "r                    : " UH_FMT "\n", ptr_struct->r);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "b                    : " UH_FMT "\n", ptr_struct->b);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "g                    : " UH_FMT "\n", ptr_struct->g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_bw_value         : " UH_FMT "\n", ptr_struct->max_bw_value);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_bw_units         : " UH_FMT "\n", ptr_struct->max_bw_units);

}

int connectib_tc_qos_configuration_size(void)
{
	 return 8;
}

void connectib_tc_qos_configuration_dump(const struct connectib_tc_qos_configuration *ptr_struct, FILE* file)
{
	connectib_tc_qos_configuration_print(ptr_struct, file, 0);
}

void connectib_fw_ref_count_pack(const struct connectib_fw_ref_count *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 28, (u_int32_t)ptr_struct->ref_counter);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ref_valid_cre_type);

}

void connectib_fw_ref_count_unpack(struct connectib_fw_ref_count *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	ptr_struct->ref_counter = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 28);

	offset = 0;
	ptr_struct->ref_valid_cre_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_fw_ref_count_print(const struct connectib_fw_ref_count *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_ref_count ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ref_counter          : " UH_FMT "\n", ptr_struct->ref_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ref_valid_cre_type   : " UH_FMT "\n", ptr_struct->ref_valid_cre_type);

}

int connectib_fw_ref_count_size(void)
{
	 return 4;
}

void connectib_fw_ref_count_dump(const struct connectib_fw_ref_count *ptr_struct, FILE* file)
{
	connectib_fw_ref_count_print(ptr_struct, file, 0);
}

void connectib_mac_address_layout_pack(const struct connectib_mac_address_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->mac_addr_47_32);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mac_addr_31_0);

}

void connectib_mac_address_layout_unpack(struct connectib_mac_address_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->mac_addr_47_32 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 32;
	ptr_struct->mac_addr_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mac_address_layout_print(const struct connectib_mac_address_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mac_address_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac_addr_47_32       : " UH_FMT "\n", ptr_struct->mac_addr_47_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac_addr_31_0        : " U32H_FMT "\n", ptr_struct->mac_addr_31_0);

}

int connectib_mac_address_layout_size(void)
{
	 return 8;
}

void connectib_mac_address_layout_dump(const struct connectib_mac_address_layout *ptr_struct, FILE* file)
{
	connectib_mac_address_layout_print(ptr_struct, file, 0);
}

void connectib_tir_dmfs_pack(const struct connectib_tir_dmfs *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tir_ste_ix);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hash_filter_base_ix);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hash_entries_base_ix);

}

void connectib_tir_dmfs_unpack(struct connectib_tir_dmfs *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	ptr_struct->tir_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->hash_filter_base_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->hash_entries_base_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_tir_dmfs_print(const struct connectib_tir_dmfs *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_tir_dmfs ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tir_ste_ix           : " U32H_FMT "\n", ptr_struct->tir_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hash_filter_base_ix  : " U32H_FMT "\n", ptr_struct->hash_filter_base_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hash_entries_base_ix : " U32H_FMT "\n", ptr_struct->hash_entries_base_ix);

}

int connectib_tir_dmfs_size(void)
{
	 return 16;
}

void connectib_tir_dmfs_dump(const struct connectib_tir_dmfs *ptr_struct, FILE* file)
{
	connectib_tir_dmfs_print(ptr_struct, file, 0);
}

void connectib_rx_hash_field_select_pack(const struct connectib_rx_hash_field_select *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->selected_fields);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->l4_prot_type);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->l3_prot_type);

}

void connectib_rx_hash_field_select_unpack(struct connectib_rx_hash_field_select *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	ptr_struct->selected_fields = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

	offset = 1;
	ptr_struct->l4_prot_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->l3_prot_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_rx_hash_field_select_print(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_rx_hash_field_select ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "selected_fields      : %s (" UH_FMT ")\n", (ptr_struct->selected_fields == 0 ? ("SRC_IP") : ((ptr_struct->selected_fields == 1 ? ("DST_IP") : ((ptr_struct->selected_fields == 2 ? ("L4_SPORT") : ((ptr_struct->selected_fields == 3 ? ("L4_DPORT") : ((ptr_struct->selected_fields == 4 ? ("IPSEC_SPI") : ("unknown")))))))))), ptr_struct->selected_fields);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l4_prot_type         : " UH_FMT "\n", ptr_struct->l4_prot_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l3_prot_type         : " UH_FMT "\n", ptr_struct->l3_prot_type);

}

int connectib_rx_hash_field_select_size(void)
{
	 return 4;
}

void connectib_rx_hash_field_select_dump(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file)
{
	connectib_rx_hash_field_select_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_special_pack(const union connectib_fw_qpc_special *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_dct_qp_pack(&(ptr_struct->dct_qp), ptr_buff);
}

void connectib_fw_qpc_special_unpack(union connectib_fw_qpc_special *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_dct_qp_unpack(&(ptr_struct->dct_qp), ptr_buff);
}

void connectib_fw_qpc_special_print(const union connectib_fw_qpc_special *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_special ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular_qp:\n");
	connectib_regular_qp_print(&(ptr_struct->regular_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_qp:\n");
	connectib_dcr_qp_print(&(ptr_struct->dcr_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_qp:\n");
	connectib_dct_qp_print(&(ptr_struct->dct_qp), file, indent_level + 1);

}

int connectib_fw_qpc_special_size(void)
{
	 return 16;
}

void connectib_fw_qpc_special_dump(const union connectib_fw_qpc_special *ptr_struct, FILE* file)
{
	connectib_fw_qpc_special_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_q_pack(const struct connectib_fw_qpc_q *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->qp_state);

	offset = 16;
	connectib_schedint_cause_pack(&(ptr_struct->schedint_cause), ptr_buff + offset/8);

	offset = 15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sxdc_valid);

	offset = 14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qpc_valid);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dct_cleanup_state);

	offset = 11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_in_linked_list);

	offset = 10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cmdif_awaiting);

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dup_sx_flush_kill_qp_arb_disabled);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->broken_wq_buffer);

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->broken_cq);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->catas_event_generated);

	offset = 5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_wqe_event_generated);

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->async_event_generated);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->flushed_in_error);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sl_diff_flow_done);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->all_connections_closed_event_req);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->disable_flushed_in_error);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->packet_pacing_rate_limit_index);

	offset = 55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat_odp_ext);

	offset = 54;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat_gnrl_ext);

	offset = 53;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat_retry_cntr_ext);

	offset = 51;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat_odp_ext);

	offset = 50;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat_gnrl_ext);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vendor_syndrome);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->hw_syndrome);

	offset = 123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->trap_reason);

	offset = 122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->connect_sent_to_ctrl_dct);

	offset = 121;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->needed_events_generated);

	offset = 116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->retransmission_state);

	offset = 115;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_fault_event_fired);

	offset = 113;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_fault_event_fired);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->trap_data_odp_gvmi);

}

void connectib_fw_qpc_q_unpack(struct connectib_fw_qpc_q *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->qp_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	connectib_schedint_cause_unpack(&(ptr_struct->schedint_cause), ptr_buff + offset/8);

	offset = 15;
	ptr_struct->sxdc_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 14;
	ptr_struct->qpc_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 12;
	ptr_struct->dct_cleanup_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 11;
	ptr_struct->qp_in_linked_list = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 10;
	ptr_struct->cmdif_awaiting = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 9;
	ptr_struct->dup_sx_flush_kill_qp_arb_disabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 8;
	ptr_struct->broken_wq_buffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 7;
	ptr_struct->broken_cq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 6;
	ptr_struct->catas_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 5;
	ptr_struct->last_wqe_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 4;
	ptr_struct->async_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 3;
	ptr_struct->flushed_in_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->sl_diff_flow_done = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->all_connections_closed_event_req = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->disable_flushed_in_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 56;
	ptr_struct->packet_pacing_rate_limit_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 55;
	ptr_struct->rx_heartbeat_odp_ext = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 54;
	ptr_struct->rx_heartbeat_gnrl_ext = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 53;
	ptr_struct->rx_heartbeat_retry_cntr_ext = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 51;
	ptr_struct->sx_heartbeat_odp_ext = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 50;
	ptr_struct->sx_heartbeat_gnrl_ext = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 80;
	ptr_struct->vendor_syndrome = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->hw_syndrome = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 123;
	ptr_struct->trap_reason = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 122;
	ptr_struct->connect_sent_to_ctrl_dct = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 121;
	ptr_struct->needed_events_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 116;
	ptr_struct->retransmission_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 115;
	ptr_struct->rx_fault_event_fired = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 113;
	ptr_struct->sx_fault_event_fired = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->trap_data_odp_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_fw_qpc_q_print(const struct connectib_fw_qpc_q *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_q ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : " UH_FMT "\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_cause:\n");
	connectib_schedint_cause_print(&(ptr_struct->schedint_cause), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sxdc_valid           : " UH_FMT "\n", ptr_struct->sxdc_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpc_valid            : " UH_FMT "\n", ptr_struct->qpc_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_cleanup_state    : " UH_FMT "\n", ptr_struct->dct_cleanup_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_in_linked_list    : " UH_FMT "\n", ptr_struct->qp_in_linked_list);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmdif_awaiting       : " UH_FMT "\n", ptr_struct->cmdif_awaiting);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dup_sx_flush_kill_qp_arb_disabled : " UH_FMT "\n", ptr_struct->dup_sx_flush_kill_qp_arb_disabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "broken_wq_buffer     : " UH_FMT "\n", ptr_struct->broken_wq_buffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "broken_cq            : " UH_FMT "\n", ptr_struct->broken_cq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "catas_event_generated : " UH_FMT "\n", ptr_struct->catas_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_wqe_event_generated : " UH_FMT "\n", ptr_struct->last_wqe_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "async_event_generated : " UH_FMT "\n", ptr_struct->async_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flushed_in_error     : " UH_FMT "\n", ptr_struct->flushed_in_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl_diff_flow_done    : " UH_FMT "\n", ptr_struct->sl_diff_flow_done);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "all_connections_closed_event_req : " UH_FMT "\n", ptr_struct->all_connections_closed_event_req);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disable_flushed_in_error : " UH_FMT "\n", ptr_struct->disable_flushed_in_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "packet_pacing_rate_limit_index : " UH_FMT "\n", ptr_struct->packet_pacing_rate_limit_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat_odp_ext : " UH_FMT "\n", ptr_struct->rx_heartbeat_odp_ext);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat_gnrl_ext : " UH_FMT "\n", ptr_struct->rx_heartbeat_gnrl_ext);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat_retry_cntr_ext : " UH_FMT "\n", ptr_struct->rx_heartbeat_retry_cntr_ext);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat_odp_ext : " UH_FMT "\n", ptr_struct->sx_heartbeat_odp_ext);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat_gnrl_ext : " UH_FMT "\n", ptr_struct->sx_heartbeat_gnrl_ext);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vendor_syndrome      : " UH_FMT "\n", ptr_struct->vendor_syndrome);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_syndrome          : " UH_FMT "\n", ptr_struct->hw_syndrome);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_reason          : %s (" UH_FMT ")\n", (ptr_struct->trap_reason == 0 ? ("NORMAL") : ((ptr_struct->trap_reason == 1 ? ("SET_LIMIT") : ((ptr_struct->trap_reason == 2 ? ("DCR_OVERFLOW") : ((ptr_struct->trap_reason == 3 ? ("DCR_DUP_WA") : ((ptr_struct->trap_reason == 4 ? ("DCI_RECONNECT") : ("unknown")))))))))), ptr_struct->trap_reason);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connect_sent_to_ctrl_dct : " UH_FMT "\n", ptr_struct->connect_sent_to_ctrl_dct);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "needed_events_generated : " UH_FMT "\n", ptr_struct->needed_events_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_state : " UH_FMT "\n", ptr_struct->retransmission_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_fault_event_fired : " UH_FMT "\n", ptr_struct->rx_fault_event_fired);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_fault_event_fired : " UH_FMT "\n", ptr_struct->sx_fault_event_fired);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_data_odp_gvmi   : " UH_FMT "\n", ptr_struct->trap_data_odp_gvmi);

}

int connectib_fw_qpc_q_size(void)
{
	 return 16;
}

void connectib_fw_qpc_q_dump(const struct connectib_fw_qpc_q *ptr_struct, FILE* file)
{
	connectib_fw_qpc_q_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_ts_special_pack(const union connectib_fw_qpc_ts_special *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_fw_qpc_ib_pack(&(ptr_struct->ib_qp), ptr_buff);
}

void connectib_fw_qpc_ts_special_unpack(union connectib_fw_qpc_ts_special *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_fw_qpc_ib_unpack(&(ptr_struct->ib_qp), ptr_buff);
}

void connectib_fw_qpc_ts_special_print(const union connectib_fw_qpc_ts_special *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_ts_special ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_qp:\n");
	connectib_fw_qpc_eth_print(&(ptr_struct->eth_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_qp:\n");
	connectib_fw_qpc_ib_print(&(ptr_struct->ib_qp), file, indent_level + 1);

}

int connectib_fw_qpc_ts_special_size(void)
{
	 return 4;
}

void connectib_fw_qpc_ts_special_dump(const union connectib_fw_qpc_ts_special *ptr_struct, FILE* file)
{
	connectib_fw_qpc_ts_special_print(ptr_struct, file, 0);
}

void connectib_fw_xrqc_pack(const struct connectib_fw_xrqc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_offloads);

	offset = 59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->nsq_log_page_size);

	offset = 51;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->ncq_log_page_size);

	offset = 43;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->stg_log_page_size);

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->memory_page_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->tgt_num);

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->send_cq_num);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ioccsize);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->log_match_list_size);

}

void connectib_fw_xrqc_unpack(struct connectib_fw_xrqc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->num_offloads = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 59;
	ptr_struct->nsq_log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 51;
	ptr_struct->ncq_log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 43;
	ptr_struct->stg_log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 35;
	ptr_struct->memory_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 72;
	ptr_struct->tgt_num = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 112;
	ptr_struct->send_cq_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 144;
	ptr_struct->ioccsize = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 128;
	ptr_struct->log_match_list_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_fw_xrqc_print(const struct connectib_fw_xrqc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_xrqc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_offloads         : " U32H_FMT "\n", ptr_struct->num_offloads);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nsq_log_page_size    : " UH_FMT "\n", ptr_struct->nsq_log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ncq_log_page_size    : " UH_FMT "\n", ptr_struct->ncq_log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "stg_log_page_size    : " UH_FMT "\n", ptr_struct->stg_log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_page_size     : " UH_FMT "\n", ptr_struct->memory_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tgt_num              : " UH_FMT "\n", ptr_struct->tgt_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_cq_num          : " UH_FMT "\n", ptr_struct->send_cq_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ioccsize             : " UH_FMT "\n", ptr_struct->ioccsize);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_match_list_size  : " UH_FMT "\n", ptr_struct->log_match_list_size);

}

int connectib_fw_xrqc_size(void)
{
	 return 32;
}

void connectib_fw_xrqc_dump(const struct connectib_fw_xrqc *ptr_struct, FILE* file)
{
	connectib_fw_xrqc_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_data_pack(const union connectib_hw_msix_context_data *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_msix_context_data0_pack(&(ptr_struct->regular), ptr_buff);
}

void connectib_hw_msix_context_data_unpack(union connectib_hw_msix_context_data *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_msix_context_data0_unpack(&(ptr_struct->regular), ptr_buff);
}

void connectib_hw_msix_context_data_print(const union connectib_hw_msix_context_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular:\n");
	connectib_hw_msix_context_data0_print(&(ptr_struct->regular), file, indent_level + 1);

}

int connectib_hw_msix_context_data_size(void)
{
	 return 4;
}

void connectib_hw_msix_context_data_dump(const union connectib_hw_msix_context_data *ptr_struct, FILE* file)
{
	connectib_hw_msix_context_data_print(ptr_struct, file, 0);
}

void connectib_steering_qp_entry_pack(const struct connectib_steering_qp_entry *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->qp_number);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_responder);

}

void connectib_steering_qp_entry_unpack(struct connectib_steering_qp_entry *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->qp_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 0;
	ptr_struct->force_responder = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_steering_qp_entry_print(const struct connectib_steering_qp_entry *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_steering_qp_entry ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_number            : " UH_FMT "\n", ptr_struct->qp_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_responder      : " UH_FMT "\n", ptr_struct->force_responder);

}

int connectib_steering_qp_entry_size(void)
{
	 return 4;
}

void connectib_steering_qp_entry_dump(const struct connectib_steering_qp_entry *ptr_struct, FILE* file)
{
	connectib_steering_qp_entry_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_pack(const union connectib_hw_ste_tag *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_ste_tag_generic_headers_pack(&(ptr_struct->generic_headers), ptr_buff);
}

void connectib_hw_ste_tag_unpack(union connectib_hw_ste_tag *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_ste_tag_generic_headers_unpack(&(ptr_struct->generic_headers), ptr_buff);
}

void connectib_hw_ste_tag_print(const union connectib_hw_ste_tag *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk:\n");
	connectib_hw_ste_tag_bulk_print(&(ptr_struct->bulk), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl2:\n");
	connectib_hw_ste_tag_ib_l2_print(&(ptr_struct->ibl2), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl3_extended:\n");
	connectib_hw_ste_tag_ib_l3_extended_print(&(ptr_struct->ibl3_extended), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl3:\n");
	connectib_hw_ste_tag_ib_l3_print(&(ptr_struct->ibl3), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl4:\n");
	connectib_hw_ste_tag_ib_l4_print(&(ptr_struct->ibl4), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_gvmi_qp:\n");
	connectib_hw_ste_tag_source_gvmi_qp_print(&(ptr_struct->source_gvmi_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port:\n");
	connectib_hw_ste_tag_port_print(&(ptr_struct->port), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "generic_headers:\n");
	connectib_hw_ste_tag_generic_headers_print(&(ptr_struct->generic_headers), file, indent_level + 1);

}

int connectib_hw_ste_tag_size(void)
{
	 return 16;
}

void connectib_hw_ste_tag_dump(const union connectib_hw_ste_tag *ptr_struct, FILE* file)
{
	connectib_hw_ste_tag_print(ptr_struct, file, 0);
}

void connectib_hw_pdf_entry_pack(const union connectib_hw_pdf_entry *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_transaction_pdf_pack(&(ptr_struct->transaction_pdf), ptr_buff);
}

void connectib_hw_pdf_entry_unpack(union connectib_hw_pdf_entry *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_transaction_pdf_unpack(&(ptr_struct->transaction_pdf), ptr_buff);
}

void connectib_hw_pdf_entry_print(const union connectib_hw_pdf_entry *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_pdf_entry ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pdf_decoder:\n");
	connectib_hw_pdf_decoder_print(&(ptr_struct->pdf_decoder), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transaction_pdf:\n");
	connectib_hw_transaction_pdf_print(&(ptr_struct->transaction_pdf), file, indent_level + 1);

}

int connectib_hw_pdf_entry_size(void)
{
	 return 8;
}

void connectib_hw_pdf_entry_dump(const union connectib_hw_pdf_entry *ptr_struct, FILE* file)
{
	connectib_hw_pdf_entry_print(ptr_struct, file, 0);
}

void connectib_hw_dct_dc_access_key_63_32_pack(const struct connectib_hw_dct_dc_access_key_63_32 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_dc_access_key_63_32_unpack(struct connectib_hw_dct_dc_access_key_63_32 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 448;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_dc_access_key_63_32_print(const struct connectib_hw_dct_dc_access_key_63_32 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_dc_access_key_63_32 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_dc_access_key_63_32_size(void)
{
	 return 64;
}

void connectib_hw_dct_dc_access_key_63_32_dump(const struct connectib_hw_dct_dc_access_key_63_32 *ptr_struct, FILE* file)
{
	connectib_hw_dct_dc_access_key_63_32_print(ptr_struct, file, 0);
}

void connectib_hw_dct_dc_access_key_31_0_pack(const struct connectib_hw_dct_dc_access_key_31_0 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_dc_access_key_31_0_unpack(struct connectib_hw_dct_dc_access_key_31_0 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_dc_access_key_31_0_print(const struct connectib_hw_dct_dc_access_key_31_0 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_dc_access_key_31_0 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_dc_access_key_31_0_size(void)
{
	 return 64;
}

void connectib_hw_dct_dc_access_key_31_0_dump(const struct connectib_hw_dct_dc_access_key_31_0 *ptr_struct, FILE* file)
{
	connectib_hw_dct_dc_access_key_31_0_print(ptr_struct, file, 0);
}

void connectib_hw_dct_tclass_pack(const struct connectib_hw_dct_tclass *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 416;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_tclass_unpack(struct connectib_hw_dct_tclass *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 416;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_dct_tclass_print(const struct connectib_hw_dct_tclass *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_tclass ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_tclass_size(void)
{
	 return 64;
}

void connectib_hw_dct_tclass_dump(const struct connectib_hw_dct_tclass *ptr_struct, FILE* file)
{
	connectib_hw_dct_tclass_print(ptr_struct, file, 0);
}

void connectib_hw_dct_context_number_pack(const struct connectib_hw_dct_context_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 424;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_context_number_unpack(struct connectib_hw_dct_context_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 424;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_dct_context_number_print(const struct connectib_hw_dct_context_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_context_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_context_number_size(void)
{
	 return 64;
}

void connectib_hw_dct_context_number_dump(const struct connectib_hw_dct_context_number *ptr_struct, FILE* file)
{
	connectib_hw_dct_context_number_print(ptr_struct, file, 0);
}

void connectib_hw_dct_hop_limit_pack(const struct connectib_hw_dct_hop_limit *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_hop_limit_unpack(struct connectib_hw_dct_hop_limit *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 384;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_dct_hop_limit_print(const struct connectib_hw_dct_hop_limit *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_hop_limit ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_hop_limit_size(void)
{
	 return 64;
}

void connectib_hw_dct_hop_limit_dump(const struct connectib_hw_dct_hop_limit *ptr_struct, FILE* file)
{
	connectib_hw_dct_hop_limit_print(ptr_struct, file, 0);
}

void connectib_hw_dct_cq_number_pack(const struct connectib_hw_dct_cq_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 392;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_cq_number_unpack(struct connectib_hw_dct_cq_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 392;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_dct_cq_number_print(const struct connectib_hw_dct_cq_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_cq_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_cq_number_size(void)
{
	 return 64;
}

void connectib_hw_dct_cq_number_dump(const struct connectib_hw_dct_cq_number *ptr_struct, FILE* file)
{
	connectib_hw_dct_cq_number_print(ptr_struct, file, 0);
}

void connectib_hw_dct_ts_pack(const struct connectib_hw_dct_ts *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_ts_unpack(struct connectib_hw_dct_ts *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 352;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_ts_print(const struct connectib_hw_dct_ts *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_ts ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_ts_size(void)
{
	 return 64;
}

void connectib_hw_dct_ts_dump(const struct connectib_hw_dct_ts *ptr_struct, FILE* file)
{
	connectib_hw_dct_ts_print(ptr_struct, file, 0);
}

void connectib_hw_dct_ipd_pack(const struct connectib_hw_dct_ipd *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_ipd_unpack(struct connectib_hw_dct_ipd *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 356;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_ipd_print(const struct connectib_hw_dct_ipd *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_ipd ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_ipd_size(void)
{
	 return 64;
}

void connectib_hw_dct_ipd_dump(const struct connectib_hw_dct_ipd *ptr_struct, FILE* file)
{
	connectib_hw_dct_ipd_print(ptr_struct, file, 0);
}

void connectib_hw_dct_my_gid_mac_index_pack(const struct connectib_hw_dct_my_gid_mac_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_my_gid_mac_index_unpack(struct connectib_hw_dct_my_gid_mac_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 360;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_dct_my_gid_mac_index_print(const struct connectib_hw_dct_my_gid_mac_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_my_gid_mac_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_my_gid_mac_index_size(void)
{
	 return 64;
}

void connectib_hw_dct_my_gid_mac_index_dump(const struct connectib_hw_dct_my_gid_mac_index *ptr_struct, FILE* file)
{
	connectib_hw_dct_my_gid_mac_index_print(ptr_struct, file, 0);
}

void connectib_hw_dct_extended_atomic_pack(const struct connectib_hw_dct_extended_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_extended_atomic_unpack(struct connectib_hw_dct_extended_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_extended_atomic_print(const struct connectib_hw_dct_extended_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_extended_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_extended_atomic_size(void)
{
	 return 64;
}

void connectib_hw_dct_extended_atomic_dump(const struct connectib_hw_dct_extended_atomic *ptr_struct, FILE* file)
{
	connectib_hw_dct_extended_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_dct_pkey_table_index_pack(const struct connectib_hw_dct_pkey_table_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 372;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_pkey_table_index_unpack(struct connectib_hw_dct_pkey_table_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 372;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

}

void connectib_hw_dct_pkey_table_index_print(const struct connectib_hw_dct_pkey_table_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_pkey_table_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_pkey_table_index_size(void)
{
	 return 64;
}

void connectib_hw_dct_pkey_table_index_dump(const struct connectib_hw_dct_pkey_table_index *ptr_struct, FILE* file)
{
	connectib_hw_dct_pkey_table_index_print(ptr_struct, file, 0);
}

void connectib_hw_dct_counter_index_pack(const struct connectib_hw_dct_counter_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_counter_index_unpack(struct connectib_hw_dct_counter_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 320;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_dct_counter_index_print(const struct connectib_hw_dct_counter_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_counter_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_counter_index_size(void)
{
	 return 64;
}

void connectib_hw_dct_counter_index_dump(const struct connectib_hw_dct_counter_index *ptr_struct, FILE* file)
{
	connectib_hw_dct_counter_index_print(ptr_struct, file, 0);
}

void connectib_hw_dct_srq_number_pack(const struct connectib_hw_dct_srq_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 328;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_srq_number_unpack(struct connectib_hw_dct_srq_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 328;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_dct_srq_number_print(const struct connectib_hw_dct_srq_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_srq_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_srq_number_size(void)
{
	 return 64;
}

void connectib_hw_dct_srq_number_dump(const struct connectib_hw_dct_srq_number *ptr_struct, FILE* file)
{
	connectib_hw_dct_srq_number_print(ptr_struct, file, 0);
}

void connectib_hw_dct_atomic_like_write_pack(const struct connectib_hw_dct_atomic_like_write *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_atomic_like_write_unpack(struct connectib_hw_dct_atomic_like_write *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 288;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_atomic_like_write_print(const struct connectib_hw_dct_atomic_like_write *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_atomic_like_write ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_atomic_like_write_size(void)
{
	 return 64;
}

void connectib_hw_dct_atomic_like_write_dump(const struct connectib_hw_dct_atomic_like_write *ptr_struct, FILE* file)
{
	connectib_hw_dct_atomic_like_write_print(ptr_struct, file, 0);
}

void connectib_hw_dct_my_lid_pack(const struct connectib_hw_dct_my_lid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 289;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_my_lid_unpack(struct connectib_hw_dct_my_lid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 289;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

}

void connectib_hw_dct_my_lid_print(const struct connectib_hw_dct_my_lid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_my_lid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_my_lid_size(void)
{
	 return 64;
}

void connectib_hw_dct_my_lid_dump(const struct connectib_hw_dct_my_lid *ptr_struct, FILE* file)
{
	connectib_hw_dct_my_lid_print(ptr_struct, file, 0);
}

void connectib_hw_dct_qp_valid_pack(const struct connectib_hw_dct_qp_valid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_qp_valid_unpack(struct connectib_hw_dct_qp_valid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 296;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_qp_valid_print(const struct connectib_hw_dct_qp_valid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_qp_valid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_qp_valid_size(void)
{
	 return 64;
}

void connectib_hw_dct_qp_valid_dump(const struct connectib_hw_dct_qp_valid *ptr_struct, FILE* file)
{
	connectib_hw_dct_qp_valid_print(ptr_struct, file, 0);
}

void connectib_hw_dct_max_read_atomic_pack(const struct connectib_hw_dct_max_read_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 297;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_max_read_atomic_unpack(struct connectib_hw_dct_max_read_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 297;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_dct_max_read_atomic_print(const struct connectib_hw_dct_max_read_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_max_read_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_max_read_atomic_size(void)
{
	 return 64;
}

void connectib_hw_dct_max_read_atomic_dump(const struct connectib_hw_dct_max_read_atomic *ptr_struct, FILE* file)
{
	connectib_hw_dct_max_read_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_dct_flow_label_pack(const struct connectib_hw_dct_flow_label *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 300;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_flow_label_unpack(struct connectib_hw_dct_flow_label *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 300;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

}

void connectib_hw_dct_flow_label_print(const struct connectib_hw_dct_flow_label *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_flow_label ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_flow_label_size(void)
{
	 return 64;
}

void connectib_hw_dct_flow_label_dump(const struct connectib_hw_dct_flow_label *ptr_struct, FILE* file)
{
	connectib_hw_dct_flow_label_print(ptr_struct, file, 0);
}

void connectib_hw_dct_grh_bit_pack(const struct connectib_hw_dct_grh_bit *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_grh_bit_unpack(struct connectib_hw_dct_grh_bit *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 260;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_grh_bit_print(const struct connectib_hw_dct_grh_bit *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_grh_bit ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_grh_bit_size(void)
{
	 return 64;
}

void connectib_hw_dct_grh_bit_dump(const struct connectib_hw_dct_grh_bit *ptr_struct, FILE* file)
{
	connectib_hw_dct_grh_bit_print(ptr_struct, file, 0);
}

void connectib_hw_dct_port_number_pack(const struct connectib_hw_dct_port_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 261;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_port_number_unpack(struct connectib_hw_dct_port_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 261;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_port_number_print(const struct connectib_hw_dct_port_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_port_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_port_number_size(void)
{
	 return 64;
}

void connectib_hw_dct_port_number_dump(const struct connectib_hw_dct_port_number *ptr_struct, FILE* file)
{
	connectib_hw_dct_port_number_print(ptr_struct, file, 0);
}

void connectib_hw_dct_adaptive_routing_pack(const struct connectib_hw_dct_adaptive_routing *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 262;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_adaptive_routing_unpack(struct connectib_hw_dct_adaptive_routing *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 262;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_adaptive_routing_print(const struct connectib_hw_dct_adaptive_routing *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_adaptive_routing ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_adaptive_routing_size(void)
{
	 return 64;
}

void connectib_hw_dct_adaptive_routing_dump(const struct connectib_hw_dct_adaptive_routing *ptr_struct, FILE* file)
{
	connectib_hw_dct_adaptive_routing_print(ptr_struct, file, 0);
}

void connectib_hw_dct_tcu_trap_pack(const struct connectib_hw_dct_tcu_trap *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 263;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_tcu_trap_unpack(struct connectib_hw_dct_tcu_trap *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 263;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_tcu_trap_print(const struct connectib_hw_dct_tcu_trap *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_tcu_trap ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_tcu_trap_size(void)
{
	 return 64;
}

void connectib_hw_dct_tcu_trap_dump(const struct connectib_hw_dct_tcu_trap *ptr_struct, FILE* file)
{
	connectib_hw_dct_tcu_trap_print(ptr_struct, file, 0);
}

void connectib_hw_dct_tcu_drop_pack(const struct connectib_hw_dct_tcu_drop *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 264;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_tcu_drop_unpack(struct connectib_hw_dct_tcu_drop *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 264;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_tcu_drop_print(const struct connectib_hw_dct_tcu_drop *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_tcu_drop ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_tcu_drop_size(void)
{
	 return 64;
}

void connectib_hw_dct_tcu_drop_dump(const struct connectib_hw_dct_tcu_drop *ptr_struct, FILE* file)
{
	connectib_hw_dct_tcu_drop_print(ptr_struct, file, 0);
}

void connectib_hw_dct_dc_access_key_log_num_byte_pack(const struct connectib_hw_dct_dc_access_key_log_num_byte *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_dc_access_key_log_num_byte_unpack(struct connectib_hw_dct_dc_access_key_log_num_byte *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 265;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_dct_dc_access_key_log_num_byte_print(const struct connectib_hw_dct_dc_access_key_log_num_byte *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_dc_access_key_log_num_byte ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_dc_access_key_log_num_byte_size(void)
{
	 return 64;
}

void connectib_hw_dct_dc_access_key_log_num_byte_dump(const struct connectib_hw_dct_dc_access_key_log_num_byte *ptr_struct, FILE* file)
{
	connectib_hw_dct_dc_access_key_log_num_byte_print(ptr_struct, file, 0);
}

void connectib_hw_dct_fast_path_pack(const struct connectib_hw_dct_fast_path *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_fast_path_unpack(struct connectib_hw_dct_fast_path *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 268;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_fast_path_print(const struct connectib_hw_dct_fast_path *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_fast_path ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_fast_path_size(void)
{
	 return 64;
}

void connectib_hw_dct_fast_path_dump(const struct connectib_hw_dct_fast_path *ptr_struct, FILE* file)
{
	connectib_hw_dct_fast_path_print(ptr_struct, file, 0);
}

void connectib_hw_dct_mtu_pack(const struct connectib_hw_dct_mtu *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 269;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_mtu_unpack(struct connectib_hw_dct_mtu *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 269;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_dct_mtu_print(const struct connectib_hw_dct_mtu *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_mtu ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_mtu_size(void)
{
	 return 64;
}

void connectib_hw_dct_mtu_dump(const struct connectib_hw_dct_mtu *ptr_struct, FILE* file)
{
	connectib_hw_dct_mtu_print(ptr_struct, file, 0);
}

void connectib_hw_dct_read_enable_pack(const struct connectib_hw_dct_read_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_read_enable_unpack(struct connectib_hw_dct_read_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 272;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_read_enable_print(const struct connectib_hw_dct_read_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_read_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_read_enable_size(void)
{
	 return 64;
}

void connectib_hw_dct_read_enable_dump(const struct connectib_hw_dct_read_enable *ptr_struct, FILE* file)
{
	connectib_hw_dct_read_enable_print(ptr_struct, file, 0);
}

void connectib_hw_dct_send_with_invalidate_enable_pack(const struct connectib_hw_dct_send_with_invalidate_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 273;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_send_with_invalidate_enable_unpack(struct connectib_hw_dct_send_with_invalidate_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 273;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_send_with_invalidate_enable_print(const struct connectib_hw_dct_send_with_invalidate_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_send_with_invalidate_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_send_with_invalidate_enable_size(void)
{
	 return 64;
}

void connectib_hw_dct_send_with_invalidate_enable_dump(const struct connectib_hw_dct_send_with_invalidate_enable *ptr_struct, FILE* file)
{
	connectib_hw_dct_send_with_invalidate_enable_print(ptr_struct, file, 0);
}

void connectib_hw_dct_ignore_pkey_check_pack(const struct connectib_hw_dct_ignore_pkey_check *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 274;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_ignore_pkey_check_unpack(struct connectib_hw_dct_ignore_pkey_check *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 274;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_ignore_pkey_check_print(const struct connectib_hw_dct_ignore_pkey_check *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_ignore_pkey_check ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_ignore_pkey_check_size(void)
{
	 return 64;
}

void connectib_hw_dct_ignore_pkey_check_dump(const struct connectib_hw_dct_ignore_pkey_check *ptr_struct, FILE* file)
{
	connectib_hw_dct_ignore_pkey_check_print(ptr_struct, file, 0);
}

void connectib_hw_dct_max_message_size_pack(const struct connectib_hw_dct_max_message_size *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 275;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_max_message_size_unpack(struct connectib_hw_dct_max_message_size *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 275;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_dct_max_message_size_print(const struct connectib_hw_dct_max_message_size *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_max_message_size ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_max_message_size_size(void)
{
	 return 64;
}

void connectib_hw_dct_max_message_size_dump(const struct connectib_hw_dct_max_message_size *ptr_struct, FILE* file)
{
	connectib_hw_dct_max_message_size_print(ptr_struct, file, 0);
}

void connectib_hw_dct_inline_scatter_pack(const struct connectib_hw_dct_inline_scatter *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_inline_scatter_unpack(struct connectib_hw_dct_inline_scatter *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 280;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_dct_inline_scatter_print(const struct connectib_hw_dct_inline_scatter *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_inline_scatter ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_inline_scatter_size(void)
{
	 return 64;
}

void connectib_hw_dct_inline_scatter_dump(const struct connectib_hw_dct_inline_scatter *ptr_struct, FILE* file)
{
	connectib_hw_dct_inline_scatter_print(ptr_struct, file, 0);
}

void connectib_hw_dct_write_enable_pack(const struct connectib_hw_dct_write_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 282;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_write_enable_unpack(struct connectib_hw_dct_write_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 282;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_dct_write_enable_print(const struct connectib_hw_dct_write_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_write_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_write_enable_size(void)
{
	 return 64;
}

void connectib_hw_dct_write_enable_dump(const struct connectib_hw_dct_write_enable *ptr_struct, FILE* file)
{
	connectib_hw_dct_write_enable_print(ptr_struct, file, 0);
}

void connectib_hw_dct_rnr_timer_pack(const struct connectib_hw_dct_rnr_timer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 283;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_rnr_timer_unpack(struct connectib_hw_dct_rnr_timer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 283;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_dct_rnr_timer_print(const struct connectib_hw_dct_rnr_timer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_rnr_timer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_rnr_timer_size(void)
{
	 return 64;
}

void connectib_hw_dct_rnr_timer_dump(const struct connectib_hw_dct_rnr_timer *ptr_struct, FILE* file)
{
	connectib_hw_dct_rnr_timer_print(ptr_struct, file, 0);
}

void connectib_hw_dct_complete_to_64B_eyald_pack(const struct connectib_hw_dct_complete_to_64B_eyald *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_dct_complete_to_64B_eyald_unpack(struct connectib_hw_dct_complete_to_64B_eyald *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_dct_complete_to_64B_eyald_print(const struct connectib_hw_dct_complete_to_64B_eyald *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct_complete_to_64B_eyald ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_dct_complete_to_64B_eyald_size(void)
{
	 return 64;
}

void connectib_hw_dct_complete_to_64B_eyald_dump(const struct connectib_hw_dct_complete_to_64B_eyald *ptr_struct, FILE* file)
{
	connectib_hw_dct_complete_to_64B_eyald_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_qp_valid_pack(const struct connectib_hw_r_qpc_qp_valid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_qp_valid_unpack(struct connectib_hw_r_qpc_qp_valid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_qp_valid_print(const struct connectib_hw_r_qpc_qp_valid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_qp_valid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_qp_valid_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_qp_valid_dump(const struct connectib_hw_r_qpc_qp_valid *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_qp_valid_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_grh_to_cqe_pack(const struct connectib_hw_r_qpc_grh_to_cqe *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_grh_to_cqe_unpack(struct connectib_hw_r_qpc_grh_to_cqe *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_grh_to_cqe_print(const struct connectib_hw_r_qpc_grh_to_cqe *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_grh_to_cqe ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_grh_to_cqe_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_grh_to_cqe_dump(const struct connectib_hw_r_qpc_grh_to_cqe *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_grh_to_cqe_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_drop_my_self_multicast_pack(const struct connectib_hw_r_qpc_drop_my_self_multicast *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_drop_my_self_multicast_unpack(struct connectib_hw_r_qpc_drop_my_self_multicast *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_drop_my_self_multicast_print(const struct connectib_hw_r_qpc_drop_my_self_multicast *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_drop_my_self_multicast ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_drop_my_self_multicast_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_drop_my_self_multicast_dump(const struct connectib_hw_r_qpc_drop_my_self_multicast *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_drop_my_self_multicast_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ack_type_pack(const struct connectib_hw_r_qpc_ack_type *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_ack_type_unpack(struct connectib_hw_r_qpc_ack_type *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_r_qpc_ack_type_print(const struct connectib_hw_r_qpc_ack_type *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ack_type ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_ack_type_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_ack_type_dump(const struct connectib_hw_r_qpc_ack_type *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_ack_type_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_e2e_credits_enabled_pack(const struct connectib_hw_r_qpc_e2e_credits_enabled *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_e2e_credits_enabled_unpack(struct connectib_hw_r_qpc_e2e_credits_enabled *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_e2e_credits_enabled_print(const struct connectib_hw_r_qpc_e2e_credits_enabled *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_e2e_credits_enabled ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_e2e_credits_enabled_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_e2e_credits_enabled_dump(const struct connectib_hw_r_qpc_e2e_credits_enabled *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_e2e_credits_enabled_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_no_direct_access_pack(const struct connectib_hw_r_qpc_no_direct_access *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_no_direct_access_unpack(struct connectib_hw_r_qpc_no_direct_access *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 5;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_no_direct_access_print(const struct connectib_hw_r_qpc_no_direct_access *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_no_direct_access ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_no_direct_access_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_no_direct_access_dump(const struct connectib_hw_r_qpc_no_direct_access *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_no_direct_access_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_post_receive_slave_enable_pack(const struct connectib_hw_r_qpc_post_receive_slave_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_post_receive_slave_enable_unpack(struct connectib_hw_r_qpc_post_receive_slave_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 6;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_post_receive_slave_enable_print(const struct connectib_hw_r_qpc_post_receive_slave_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_post_receive_slave_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_post_receive_slave_enable_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_post_receive_slave_enable_dump(const struct connectib_hw_r_qpc_post_receive_slave_enable *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_post_receive_slave_enable_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_atomic_like_write_pack(const struct connectib_hw_r_qpc_atomic_like_write *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_atomic_like_write_unpack(struct connectib_hw_r_qpc_atomic_like_write *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 7;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_atomic_like_write_print(const struct connectib_hw_r_qpc_atomic_like_write *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_atomic_like_write ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_atomic_like_write_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_atomic_like_write_dump(const struct connectib_hw_r_qpc_atomic_like_write *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_atomic_like_write_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_write_enable_pack(const struct connectib_hw_r_qpc_write_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_write_enable_unpack(struct connectib_hw_r_qpc_write_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_write_enable_print(const struct connectib_hw_r_qpc_write_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_write_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_write_enable_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_write_enable_dump(const struct connectib_hw_r_qpc_write_enable *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_write_enable_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_max_read_atomic_pack(const struct connectib_hw_r_qpc_max_read_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_max_read_atomic_unpack(struct connectib_hw_r_qpc_max_read_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 9;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_r_qpc_max_read_atomic_print(const struct connectib_hw_r_qpc_max_read_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_max_read_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_max_read_atomic_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_max_read_atomic_dump(const struct connectib_hw_r_qpc_max_read_atomic *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_max_read_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_extended_atomic_pack(const struct connectib_hw_r_qpc_extended_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_extended_atomic_unpack(struct connectib_hw_r_qpc_extended_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_extended_atomic_print(const struct connectib_hw_r_qpc_extended_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_extended_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_extended_atomic_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_extended_atomic_dump(const struct connectib_hw_r_qpc_extended_atomic *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_extended_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ignore_pkey_check_pack(const struct connectib_hw_r_qpc_ignore_pkey_check *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_ignore_pkey_check_unpack(struct connectib_hw_r_qpc_ignore_pkey_check *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_ignore_pkey_check_print(const struct connectib_hw_r_qpc_ignore_pkey_check *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ignore_pkey_check ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_ignore_pkey_check_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_ignore_pkey_check_dump(const struct connectib_hw_r_qpc_ignore_pkey_check *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_ignore_pkey_check_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_send_with_invalidate_enable_pack(const struct connectib_hw_r_qpc_send_with_invalidate_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_send_with_invalidate_enable_unpack(struct connectib_hw_r_qpc_send_with_invalidate_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 17;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_send_with_invalidate_enable_print(const struct connectib_hw_r_qpc_send_with_invalidate_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_send_with_invalidate_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_send_with_invalidate_enable_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_send_with_invalidate_enable_dump(const struct connectib_hw_r_qpc_send_with_invalidate_enable *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_send_with_invalidate_enable_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_read_enable_pack(const struct connectib_hw_r_qpc_read_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_read_enable_unpack(struct connectib_hw_r_qpc_read_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 18;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_read_enable_print(const struct connectib_hw_r_qpc_read_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_read_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_read_enable_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_read_enable_dump(const struct connectib_hw_r_qpc_read_enable *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_read_enable_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_fast_path_pack(const struct connectib_hw_r_qpc_fast_path *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_fast_path_unpack(struct connectib_hw_r_qpc_fast_path *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_fast_path_print(const struct connectib_hw_r_qpc_fast_path *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_fast_path ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_fast_path_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_fast_path_dump(const struct connectib_hw_r_qpc_fast_path *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_fast_path_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_check_source_uc_lb_pack(const struct connectib_hw_r_qpc_check_source_uc_lb *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_check_source_uc_lb_unpack(struct connectib_hw_r_qpc_check_source_uc_lb *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 21;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_check_source_uc_lb_print(const struct connectib_hw_r_qpc_check_source_uc_lb *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_check_source_uc_lb ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_check_source_uc_lb_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_check_source_uc_lb_dump(const struct connectib_hw_r_qpc_check_source_uc_lb *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_check_source_uc_lb_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_check_source_mc_lb_pack(const struct connectib_hw_r_qpc_check_source_mc_lb *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_check_source_mc_lb_unpack(struct connectib_hw_r_qpc_check_source_mc_lb *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 22;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_check_source_mc_lb_print(const struct connectib_hw_r_qpc_check_source_mc_lb *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_check_source_mc_lb ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_check_source_mc_lb_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_check_source_mc_lb_dump(const struct connectib_hw_r_qpc_check_source_mc_lb *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_check_source_mc_lb_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_check_source_gvmi_pack(const struct connectib_hw_r_qpc_check_source_gvmi *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_check_source_gvmi_unpack(struct connectib_hw_r_qpc_check_source_gvmi *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 23;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_check_source_gvmi_print(const struct connectib_hw_r_qpc_check_source_gvmi *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_check_source_gvmi ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_check_source_gvmi_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_check_source_gvmi_dump(const struct connectib_hw_r_qpc_check_source_gvmi *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_check_source_gvmi_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_inline_scatter_pack(const struct connectib_hw_r_qpc_inline_scatter *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_inline_scatter_unpack(struct connectib_hw_r_qpc_inline_scatter *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_r_qpc_inline_scatter_print(const struct connectib_hw_r_qpc_inline_scatter *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_inline_scatter ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_inline_scatter_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_inline_scatter_dump(const struct connectib_hw_r_qpc_inline_scatter *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_inline_scatter_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rwq_type_pack(const struct connectib_hw_r_qpc_rwq_type *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rwq_type_unpack(struct connectib_hw_r_qpc_rwq_type *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_r_qpc_rwq_type_print(const struct connectib_hw_r_qpc_rwq_type *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rwq_type ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rwq_type_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rwq_type_dump(const struct connectib_hw_r_qpc_rwq_type *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rwq_type_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_last_opcode_pack(const struct connectib_hw_r_qpc_last_opcode *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_last_opcode_unpack(struct connectib_hw_r_qpc_last_opcode *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_last_opcode_print(const struct connectib_hw_r_qpc_last_opcode *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_last_opcode ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_last_opcode_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_last_opcode_dump(const struct connectib_hw_r_qpc_last_opcode *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_last_opcode_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_fw_link_type_pack(const struct connectib_hw_r_qpc_fw_link_type *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_fw_link_type_unpack(struct connectib_hw_r_qpc_fw_link_type *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_fw_link_type_print(const struct connectib_hw_r_qpc_fw_link_type *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_fw_link_type ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_fw_link_type_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_fw_link_type_dump(const struct connectib_hw_r_qpc_fw_link_type *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_fw_link_type_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_check_source_uc_wire_pack(const struct connectib_hw_r_qpc_check_source_uc_wire *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_check_source_uc_wire_unpack(struct connectib_hw_r_qpc_check_source_uc_wire *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 30;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_check_source_uc_wire_print(const struct connectib_hw_r_qpc_check_source_uc_wire *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_check_source_uc_wire ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_check_source_uc_wire_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_check_source_uc_wire_dump(const struct connectib_hw_r_qpc_check_source_uc_wire *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_check_source_uc_wire_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_write_rkey_pack(const struct connectib_hw_r_qpc_write_rkey *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_write_rkey_unpack(struct connectib_hw_r_qpc_write_rkey *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_write_rkey_print(const struct connectib_hw_r_qpc_write_rkey *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_write_rkey ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_write_rkey_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_write_rkey_dump(const struct connectib_hw_r_qpc_write_rkey *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_write_rkey_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rx_heartbeat_pack(const struct connectib_hw_r_qpc_rx_heartbeat *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rx_heartbeat_unpack(struct connectib_hw_r_qpc_rx_heartbeat *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 64;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_rx_heartbeat_print(const struct connectib_hw_r_qpc_rx_heartbeat *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rx_heartbeat ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rx_heartbeat_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rx_heartbeat_dump(const struct connectib_hw_r_qpc_rx_heartbeat *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rx_heartbeat_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_e2e_credits_prefetch_threshold_pack(const struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_e2e_credits_prefetch_threshold_unpack(struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 65;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_r_qpc_e2e_credits_prefetch_threshold_print(const struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_e2e_credits_prefetch_threshold ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_e2e_credits_prefetch_threshold_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_e2e_credits_prefetch_threshold_dump(const struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_e2e_credits_prefetch_threshold_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_e2e_fetch_enable_pack(const struct connectib_hw_r_qpc_e2e_fetch_enable *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_e2e_fetch_enable_unpack(struct connectib_hw_r_qpc_e2e_fetch_enable *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 68;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_e2e_fetch_enable_print(const struct connectib_hw_r_qpc_e2e_fetch_enable *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_e2e_fetch_enable ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_e2e_fetch_enable_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_e2e_fetch_enable_dump(const struct connectib_hw_r_qpc_e2e_fetch_enable *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_e2e_fetch_enable_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_tcu_drop_pack(const struct connectib_hw_r_qpc_tcu_drop *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_tcu_drop_unpack(struct connectib_hw_r_qpc_tcu_drop *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 69;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_tcu_drop_print(const struct connectib_hw_r_qpc_tcu_drop *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_tcu_drop ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_tcu_drop_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_tcu_drop_dump(const struct connectib_hw_r_qpc_tcu_drop *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_tcu_drop_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_can_use_reserved_lkey_pack(const struct connectib_hw_r_qpc_can_use_reserved_lkey *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_can_use_reserved_lkey_unpack(struct connectib_hw_r_qpc_can_use_reserved_lkey *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 70;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_can_use_reserved_lkey_print(const struct connectib_hw_r_qpc_can_use_reserved_lkey *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_can_use_reserved_lkey ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_can_use_reserved_lkey_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_can_use_reserved_lkey_dump(const struct connectib_hw_r_qpc_can_use_reserved_lkey *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_can_use_reserved_lkey_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_tcu_trap_pack(const struct connectib_hw_r_qpc_tcu_trap *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_tcu_trap_unpack(struct connectib_hw_r_qpc_tcu_trap *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 71;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_tcu_trap_print(const struct connectib_hw_r_qpc_tcu_trap *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_tcu_trap ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_tcu_trap_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_tcu_trap_dump(const struct connectib_hw_r_qpc_tcu_trap *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_tcu_trap_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rnr_timer_pack(const struct connectib_hw_r_qpc_rnr_timer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rnr_timer_unpack(struct connectib_hw_r_qpc_rnr_timer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 75;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_r_qpc_rnr_timer_print(const struct connectib_hw_r_qpc_rnr_timer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rnr_timer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rnr_timer_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rnr_timer_dump(const struct connectib_hw_r_qpc_rnr_timer *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rnr_timer_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rwqe_limit_event_pack(const struct connectib_hw_r_qpc_rwqe_limit_event *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rwqe_limit_event_unpack(struct connectib_hw_r_qpc_rwqe_limit_event *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 80;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_rwqe_limit_event_print(const struct connectib_hw_r_qpc_rwqe_limit_event *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rwqe_limit_event ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rwqe_limit_event_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rwqe_limit_event_dump(const struct connectib_hw_r_qpc_rwqe_limit_event *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rwqe_limit_event_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rwqe_consumer_index_pack(const struct connectib_hw_r_qpc_rwqe_consumer_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rwqe_consumer_index_unpack(struct connectib_hw_r_qpc_rwqe_consumer_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 96;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_rwqe_consumer_index_print(const struct connectib_hw_r_qpc_rwqe_consumer_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rwqe_consumer_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rwqe_consumer_index_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rwqe_consumer_index_dump(const struct connectib_hw_r_qpc_rwqe_consumer_index *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rwqe_consumer_index_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rcyclic_producer_pack(const struct connectib_hw_r_qpc_rcyclic_producer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rcyclic_producer_unpack(struct connectib_hw_r_qpc_rcyclic_producer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 96;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_rcyclic_producer_print(const struct connectib_hw_r_qpc_rcyclic_producer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rcyclic_producer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rcyclic_producer_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rcyclic_producer_dump(const struct connectib_hw_r_qpc_rcyclic_producer *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rcyclic_producer_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rwqe_producer_index_pack(const struct connectib_hw_r_qpc_rwqe_producer_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rwqe_producer_index_unpack(struct connectib_hw_r_qpc_rwqe_producer_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 112;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_rwqe_producer_index_print(const struct connectib_hw_r_qpc_rwqe_producer_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rwqe_producer_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rwqe_producer_index_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rwqe_producer_index_dump(const struct connectib_hw_r_qpc_rwqe_producer_index *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rwqe_producer_index_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_qp_state_pack(const struct connectib_hw_r_qpc_qp_state *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_qp_state_unpack(struct connectib_hw_r_qpc_qp_state *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 144;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_qp_state_print(const struct connectib_hw_r_qpc_qp_state *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_qp_state ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_qp_state_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_qp_state_dump(const struct connectib_hw_r_qpc_qp_state *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_qp_state_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rdb_write_pointer_pack(const struct connectib_hw_r_qpc_rdb_write_pointer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rdb_write_pointer_unpack(struct connectib_hw_r_qpc_rdb_write_pointer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 160;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_r_qpc_rdb_write_pointer_print(const struct connectib_hw_r_qpc_rdb_write_pointer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rdb_write_pointer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rdb_write_pointer_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rdb_write_pointer_dump(const struct connectib_hw_r_qpc_rdb_write_pointer *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rdb_write_pointer_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_first_non_acked_psn_pack(const struct connectib_hw_r_qpc_first_non_acked_psn *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_first_non_acked_psn_unpack(struct connectib_hw_r_qpc_first_non_acked_psn *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 168;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_first_non_acked_psn_print(const struct connectib_hw_r_qpc_first_non_acked_psn *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_first_non_acked_psn ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_first_non_acked_psn_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_first_non_acked_psn_dump(const struct connectib_hw_r_qpc_first_non_acked_psn *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_first_non_acked_psn_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rcyclic_consumer_pack(const struct connectib_hw_r_qpc_rcyclic_consumer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rcyclic_consumer_unpack(struct connectib_hw_r_qpc_rcyclic_consumer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 192;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_rcyclic_consumer_print(const struct connectib_hw_r_qpc_rcyclic_consumer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rcyclic_consumer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rcyclic_consumer_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rcyclic_consumer_dump(const struct connectib_hw_r_qpc_rcyclic_consumer *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rcyclic_consumer_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_msn_pack(const struct connectib_hw_r_qpc_msn *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_msn_unpack(struct connectib_hw_r_qpc_msn *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 200;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_msn_print(const struct connectib_hw_r_qpc_msn *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_msn ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_msn_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_msn_dump(const struct connectib_hw_r_qpc_msn *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_msn_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_dct_number_pack(const struct connectib_hw_r_qpc_dct_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_dct_number_unpack(struct connectib_hw_r_qpc_dct_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 232;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_dct_number_print(const struct connectib_hw_r_qpc_dct_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_dct_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_dct_number_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_dct_number_dump(const struct connectib_hw_r_qpc_dct_number *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_dct_number_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_cq_number_pack(const struct connectib_hw_r_qpc_cq_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_cq_number_unpack(struct connectib_hw_r_qpc_cq_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 232;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_cq_number_print(const struct connectib_hw_r_qpc_cq_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_cq_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_cq_number_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_cq_number_dump(const struct connectib_hw_r_qpc_cq_number *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_cq_number_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_expected_psn_pack(const struct connectib_hw_r_qpc_expected_psn *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_expected_psn_unpack(struct connectib_hw_r_qpc_expected_psn *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 256;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_expected_psn_print(const struct connectib_hw_r_qpc_expected_psn *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_expected_psn ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_expected_psn_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_expected_psn_dump(const struct connectib_hw_r_qpc_expected_psn *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_expected_psn_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_flush_syndrom_pack(const struct connectib_hw_r_qpc_flush_syndrom *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_flush_syndrom_unpack(struct connectib_hw_r_qpc_flush_syndrom *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 280;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_r_qpc_flush_syndrom_print(const struct connectib_hw_r_qpc_flush_syndrom *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_flush_syndrom ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_flush_syndrom_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_flush_syndrom_dump(const struct connectib_hw_r_qpc_flush_syndrom *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_flush_syndrom_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_counter_index_pack(const struct connectib_hw_r_qpc_counter_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_counter_index_unpack(struct connectib_hw_r_qpc_counter_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 288;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_r_qpc_counter_index_print(const struct connectib_hw_r_qpc_counter_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_counter_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_counter_index_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_counter_index_dump(const struct connectib_hw_r_qpc_counter_index *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_counter_index_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_always_zero_pack(const struct connectib_hw_r_qpc_always_zero *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_always_zero_unpack(struct connectib_hw_r_qpc_always_zero *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 296;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_always_zero_print(const struct connectib_hw_r_qpc_always_zero *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_always_zero ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_always_zero_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_always_zero_dump(const struct connectib_hw_r_qpc_always_zero *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_always_zero_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rdb_read_pointer_pack(const struct connectib_hw_r_qpc_rdb_read_pointer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rdb_read_pointer_unpack(struct connectib_hw_r_qpc_rdb_read_pointer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 312;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_r_qpc_rdb_read_pointer_print(const struct connectib_hw_r_qpc_rdb_read_pointer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rdb_read_pointer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rdb_read_pointer_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rdb_read_pointer_dump(const struct connectib_hw_r_qpc_rdb_read_pointer *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rdb_read_pointer_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rx_length_committed_pack(const struct connectib_hw_r_qpc_rx_length_committed *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_rx_length_committed_unpack(struct connectib_hw_r_qpc_rx_length_committed *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 320;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_rx_length_committed_print(const struct connectib_hw_r_qpc_rx_length_committed *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rx_length_committed ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_rx_length_committed_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_rx_length_committed_dump(const struct connectib_hw_r_qpc_rx_length_committed *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_rx_length_committed_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ts_pack(const struct connectib_hw_r_qpc_ts *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_ts_unpack(struct connectib_hw_r_qpc_ts *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 352;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_ts_print(const struct connectib_hw_r_qpc_ts *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ts ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_ts_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_ts_dump(const struct connectib_hw_r_qpc_ts *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_ts_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_sx_heartbeat_pack(const struct connectib_hw_r_qpc_sx_heartbeat *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_sx_heartbeat_unpack(struct connectib_hw_r_qpc_sx_heartbeat *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 356;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_sx_heartbeat_print(const struct connectib_hw_r_qpc_sx_heartbeat *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_sx_heartbeat ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_sx_heartbeat_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_sx_heartbeat_dump(const struct connectib_hw_r_qpc_sx_heartbeat *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_sx_heartbeat_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_sqn_pack(const struct connectib_hw_r_qpc_sqn *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_sqn_unpack(struct connectib_hw_r_qpc_sqn *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 357;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

}

void connectib_hw_r_qpc_sqn_print(const struct connectib_hw_r_qpc_sqn *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_sqn ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_sqn_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_sqn_dump(const struct connectib_hw_r_qpc_sqn *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_sqn_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_dct_gvmi_pack(const struct connectib_hw_r_qpc_dct_gvmi *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_dct_gvmi_unpack(struct connectib_hw_r_qpc_dct_gvmi *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_dct_gvmi_print(const struct connectib_hw_r_qpc_dct_gvmi *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_dct_gvmi ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_dct_gvmi_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_dct_gvmi_dump(const struct connectib_hw_r_qpc_dct_gvmi *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_dct_gvmi_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_no_wqe_drop_count_pack(const struct connectib_hw_r_qpc_no_wqe_drop_count *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_no_wqe_drop_count_unpack(struct connectib_hw_r_qpc_no_wqe_drop_count *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 368;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_r_qpc_no_wqe_drop_count_print(const struct connectib_hw_r_qpc_no_wqe_drop_count *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_no_wqe_drop_count ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_no_wqe_drop_count_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_no_wqe_drop_count_dump(const struct connectib_hw_r_qpc_no_wqe_drop_count *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_no_wqe_drop_count_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_write_va_63_32_pack(const struct connectib_hw_r_qpc_write_va_63_32 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_write_va_63_32_unpack(struct connectib_hw_r_qpc_write_va_63_32 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 384;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_write_va_63_32_print(const struct connectib_hw_r_qpc_write_va_63_32 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_write_va_63_32 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_write_va_63_32_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_write_va_63_32_dump(const struct connectib_hw_r_qpc_write_va_63_32 *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_write_va_63_32_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_write_va_31_0_pack(const struct connectib_hw_r_qpc_write_va_31_0 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_write_va_31_0_unpack(struct connectib_hw_r_qpc_write_va_31_0 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 416;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_write_va_31_0_print(const struct connectib_hw_r_qpc_write_va_31_0 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_write_va_31_0 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_write_va_31_0_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_write_va_31_0_dump(const struct connectib_hw_r_qpc_write_va_31_0 *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_write_va_31_0_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_srq_number_pack(const struct connectib_hw_r_qpc_srq_number *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_srq_number_unpack(struct connectib_hw_r_qpc_srq_number *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 456;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_srq_number_print(const struct connectib_hw_r_qpc_srq_number *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_srq_number ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_srq_number_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_srq_number_dump(const struct connectib_hw_r_qpc_srq_number *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_srq_number_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_next_dcr_pack(const struct connectib_hw_r_qpc_next_dcr *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_next_dcr_unpack(struct connectib_hw_r_qpc_next_dcr *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 456;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_next_dcr_print(const struct connectib_hw_r_qpc_next_dcr *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_next_dcr ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_next_dcr_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_next_dcr_dump(const struct connectib_hw_r_qpc_next_dcr *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_next_dcr_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_mpi_uar_pack(const struct connectib_hw_r_qpc_mpi_uar *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_mpi_uar_unpack(struct connectib_hw_r_qpc_mpi_uar *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_mpi_uar_print(const struct connectib_hw_r_qpc_mpi_uar *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_mpi_uar ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_mpi_uar_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_mpi_uar_dump(const struct connectib_hw_r_qpc_mpi_uar *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_mpi_uar_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_responder_session_id_pack(const struct connectib_hw_r_qpc_responder_session_id *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_responder_session_id_unpack(struct connectib_hw_r_qpc_responder_session_id *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_responder_session_id_print(const struct connectib_hw_r_qpc_responder_session_id *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_responder_session_id ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_responder_session_id_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_responder_session_id_dump(const struct connectib_hw_r_qpc_responder_session_id *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_responder_session_id_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_xrc_domain_pack(const struct connectib_hw_r_qpc_xrc_domain *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_xrc_domain_unpack(struct connectib_hw_r_qpc_xrc_domain *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_xrc_domain_print(const struct connectib_hw_r_qpc_xrc_domain *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_xrc_domain ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_xrc_domain_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_xrc_domain_dump(const struct connectib_hw_r_qpc_xrc_domain *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_xrc_domain_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_dcr_connected_pack(const struct connectib_hw_r_qpc_dcr_connected *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 509;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_dcr_connected_unpack(struct connectib_hw_r_qpc_dcr_connected *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 509;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_dcr_connected_print(const struct connectib_hw_r_qpc_dcr_connected *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_dcr_connected ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_dcr_connected_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_dcr_connected_dump(const struct connectib_hw_r_qpc_dcr_connected *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_dcr_connected_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_e2e_pa_63_32_pack(const struct connectib_hw_r_qpc_e2e_pa_63_32 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_e2e_pa_63_32_unpack(struct connectib_hw_r_qpc_e2e_pa_63_32 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 448;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_e2e_pa_63_32_print(const struct connectib_hw_r_qpc_e2e_pa_63_32 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_e2e_pa_63_32 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " U32H_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_e2e_pa_63_32_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_e2e_pa_63_32_dump(const struct connectib_hw_r_qpc_e2e_pa_63_32 *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_e2e_pa_63_32_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_e2e_pa_31_2_pack(const struct connectib_hw_r_qpc_e2e_pa_31_2 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_e2e_pa_31_2_unpack(struct connectib_hw_r_qpc_e2e_pa_31_2 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 480;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

}

void connectib_hw_r_qpc_e2e_pa_31_2_print(const struct connectib_hw_r_qpc_e2e_pa_31_2 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_e2e_pa_31_2 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_e2e_pa_31_2_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_e2e_pa_31_2_dump(const struct connectib_hw_r_qpc_e2e_pa_31_2 *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_e2e_pa_31_2_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_check_source_mc_wire_pack(const struct connectib_hw_r_qpc_check_source_mc_wire *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_check_source_mc_wire_unpack(struct connectib_hw_r_qpc_check_source_mc_wire *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 510;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_check_source_mc_wire_print(const struct connectib_hw_r_qpc_check_source_mc_wire *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_check_source_mc_wire ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_check_source_mc_wire_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_check_source_mc_wire_dump(const struct connectib_hw_r_qpc_check_source_mc_wire *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_check_source_mc_wire_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_connection_state_pack(const struct connectib_hw_r_qpc_connection_state *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_r_qpc_connection_state_unpack(struct connectib_hw_r_qpc_connection_state *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 510;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_r_qpc_connection_state_print(const struct connectib_hw_r_qpc_connection_state *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_connection_state ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_r_qpc_connection_state_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_connection_state_dump(const struct connectib_hw_r_qpc_connection_state *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_connection_state_print(ptr_struct, file, 0);
}

void connectib_pf_vf_vpd_pack(const struct connectib_pf_vf_vpd *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 15, (u_int32_t)ptr_struct->vpd_address);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->F);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vpd_data);

}

void connectib_pf_vf_vpd_unpack(struct connectib_pf_vf_vpd *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	ptr_struct->vpd_address = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 15);

	offset = 0;
	ptr_struct->F = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->vpd_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pf_vf_vpd_print(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_vf_vpd ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vpd_address          : " UH_FMT "\n", ptr_struct->vpd_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "F                    : " UH_FMT "\n", ptr_struct->F);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vpd_data             : " U32H_FMT "\n", ptr_struct->vpd_data);

}

int connectib_pf_vf_vpd_size(void)
{
	 return 8;
}

void connectib_pf_vf_vpd_dump(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file)
{
	connectib_pf_vf_vpd_print(ptr_struct, file, 0);
}

void connectib_pf_vf_sriov_pack(const struct connectib_pf_vf_sriov *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_enable);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_en);

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_int_en);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_mse);

	offset = 27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ari_capable_hierarchy);

	offset = 19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_system_page_size);

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->num_vfs);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->not_in_use);

}

void connectib_pf_vf_sriov_unpack(struct connectib_pf_vf_sriov *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->vf_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->vf_migration_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 29;
	ptr_struct->vf_migration_int_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->vf_mse = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 27;
	ptr_struct->ari_capable_hierarchy = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 19;
	ptr_struct->log_system_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 6;
	ptr_struct->num_vfs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset = 32;
	ptr_struct->not_in_use = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pf_vf_sriov_print(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_vf_sriov ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_enable            : " UH_FMT "\n", ptr_struct->vf_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_en      : " UH_FMT "\n", ptr_struct->vf_migration_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_int_en  : " UH_FMT "\n", ptr_struct->vf_migration_int_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mse               : " UH_FMT "\n", ptr_struct->vf_mse);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_capable_hierarchy : " UH_FMT "\n", ptr_struct->ari_capable_hierarchy);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_system_page_size : " UH_FMT "\n", ptr_struct->log_system_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_vfs              : " UH_FMT "\n", ptr_struct->num_vfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "not_in_use           : " U32H_FMT "\n", ptr_struct->not_in_use);

}

int connectib_pf_vf_sriov_size(void)
{
	 return 8;
}

void connectib_pf_vf_sriov_dump(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file)
{
	connectib_pf_vf_sriov_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_preset_tx_ini_pack(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 512, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_preset_tx_ini_unpack(struct connectib_serdes_conf_preset_tx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 512, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_preset_tx_ini_print(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_preset_tx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 16; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_preset_tx_ini_size(void)
{
	 return 64;
}

void connectib_serdes_conf_preset_tx_ini_dump(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_preset_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_active_tx_ini_pack(const struct connectib_serdes_active_tx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_tx_ini_unpack(struct connectib_serdes_active_tx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_tx_ini_print(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_active_tx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_active_tx_ini_size(void)
{
	 return 16;
}

void connectib_serdes_active_tx_ini_dump(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_active_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_active_rx_ini_pack(const struct connectib_serdes_active_rx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 256, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_rx_ini_unpack(struct connectib_serdes_active_rx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 256, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_rx_ini_print(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_active_rx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_active_rx_ini_size(void)
{
	 return 32;
}

void connectib_serdes_active_rx_ini_dump(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_active_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_force_tx_ini_pack(const struct connectib_serdes_force_tx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 320, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_tx_ini_unpack(struct connectib_serdes_force_tx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 320, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_tx_ini_print(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_force_tx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_force_tx_ini_size(void)
{
	 return 40;
}

void connectib_serdes_force_tx_ini_dump(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_force_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_force_rx_ini_pack(const struct connectib_serdes_force_rx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 640, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_rx_ini_unpack(struct connectib_serdes_force_rx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 10; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 640, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_rx_ini_print(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_force_rx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_force_rx_ini_size(void)
{
	 return 80;
}

void connectib_serdes_force_rx_ini_dump(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_force_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_aba_tx_ini_pack(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_tx_ini_unpack(struct connectib_serdes_conf_aba_tx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_tx_ini_print(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_aba_tx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_aba_tx_ini_size(void)
{
	 return 128;
}

void connectib_serdes_conf_aba_tx_ini_dump(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_aba_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_aba_rx_ini_pack(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_rx_ini_unpack(struct connectib_serdes_conf_aba_rx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_rx_ini_print(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_aba_rx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_aba_rx_ini_size(void)
{
	 return 256;
}

void connectib_serdes_conf_aba_rx_ini_dump(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_aba_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_autoneg_tx_ini_pack(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_tx_ini_unpack(struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_tx_ini_print(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_autoneg_tx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_autoneg_tx_ini_size(void)
{
	 return 128;
}

void connectib_serdes_conf_autoneg_tx_ini_dump(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_autoneg_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_autoneg_rx_ini_pack(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_rx_ini_unpack(struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 32; i++) {
	offset = adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_rx_ini_print(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_autoneg_rx_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_autoneg_rx_ini_size(void)
{
	 return 256;
}

void connectib_serdes_conf_autoneg_rx_ini_dump(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file)
{
	connectib_serdes_conf_autoneg_rx_ini_print(ptr_struct, file, 0);
}

void connectib_aba_indexes_pack(const struct connectib_aba_indexes *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_aba_index_pack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset = 128;
	connectib_aba_index_pack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset = 256;
	connectib_aba_index_pack(&(ptr_struct->encode_8_10_legacy), ptr_buff + offset/8);

}

void connectib_aba_indexes_unpack(struct connectib_aba_indexes *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_aba_index_unpack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset = 128;
	connectib_aba_index_unpack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset = 256;
	connectib_aba_index_unpack(&(ptr_struct->encode_8_10_legacy), ptr_buff + offset/8);

}

void connectib_aba_indexes_print(const struct connectib_aba_indexes *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_aba_indexes ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_64_66:\n");
	connectib_aba_index_print(&(ptr_struct->encode_64_66), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_8_10:\n");
	connectib_aba_index_print(&(ptr_struct->encode_8_10), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_8_10_legacy:\n");
	connectib_aba_index_print(&(ptr_struct->encode_8_10_legacy), file, indent_level + 1);

}

int connectib_aba_indexes_size(void)
{
	 return 48;
}

void connectib_aba_indexes_dump(const struct connectib_aba_indexes *ptr_struct, FILE* file)
{
	connectib_aba_indexes_print(ptr_struct, file, 0);
}

void connectib_serdes_param_mask_per_proto_ini_pack(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx);

}

void connectib_serdes_param_mask_per_proto_ini_unpack(struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->rx = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_serdes_param_mask_per_proto_ini_print(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_param_mask_per_proto_ini ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx                   : " U32H_FMT "\n", ptr_struct->rx);

}

int connectib_serdes_param_mask_per_proto_ini_size(void)
{
	 return 4;
}

void connectib_serdes_param_mask_per_proto_ini_dump(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file)
{
	connectib_serdes_param_mask_per_proto_ini_print(ptr_struct, file, 0);
}

void connectib_pf_array_default_ones_pack(const struct connectib_pf_array_default_ones *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 64; i++) {
	offset = adb2c_calc_array_field_address(31, 1, i, 64, 1);
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ix[i]);
	}

}

void connectib_pf_array_default_ones_unpack(struct connectib_pf_array_default_ones *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 64; i++) {
	offset = adb2c_calc_array_field_address(31, 1, i, 64, 1);
	ptr_struct->ix[i] = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);
	}

}

void connectib_pf_array_default_ones_print(const struct connectib_pf_array_default_ones *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_array_default_ones ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 64; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ix_%03d              : " UH_FMT "\n", i, ptr_struct->ix[i]);
	}

}

int connectib_pf_array_default_ones_size(void)
{
	 return 8;
}

void connectib_pf_array_default_ones_dump(const struct connectib_pf_array_default_ones *ptr_struct, FILE* file)
{
	connectib_pf_array_default_ones_print(ptr_struct, file, 0);
}

void connectib_nv_ets_tcN_config_reg_pack(const struct connectib_nv_ets_tcN_config_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->bw_allocation);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->group);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->max_bw_value);

	offset = 44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_bw_units);

}

void connectib_nv_ets_tcN_config_reg_unpack(struct connectib_nv_ets_tcN_config_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 25;
	ptr_struct->bw_allocation = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 12;
	ptr_struct->group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 56;
	ptr_struct->max_bw_value = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 44;
	ptr_struct->max_bw_units = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_nv_ets_tcN_config_reg_print(const struct connectib_nv_ets_tcN_config_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_ets_tcN_config_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bw_allocation        : " UH_FMT "\n", ptr_struct->bw_allocation);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "group                : " UH_FMT "\n", ptr_struct->group);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_bw_value         : " UH_FMT "\n", ptr_struct->max_bw_value);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_bw_units         : %s (" UH_FMT ")\n", (ptr_struct->max_bw_units == 4 ? ("GBPS") : ("unknown")), ptr_struct->max_bw_units);

}

int connectib_nv_ets_tcN_config_reg_size(void)
{
	 return 8;
}

void connectib_nv_ets_tcN_config_reg_dump(const struct connectib_nv_ets_tcN_config_reg *ptr_struct, FILE* file)
{
	connectib_nv_ets_tcN_config_reg_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_fpga_cap_pack(const struct connectib_cmdif_ctx_fpga_cap *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->state);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mailbox_write_offset);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mailbox_write_size);

}

void connectib_cmdif_ctx_fpga_cap_unpack(struct connectib_cmdif_ctx_fpga_cap *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->state = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->mailbox_write_offset = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->mailbox_write_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_fpga_cap_print(const struct connectib_cmdif_ctx_fpga_cap *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_fpga_cap ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "state                : " U32H_FMT "\n", ptr_struct->state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mailbox_write_offset : " U32H_FMT "\n", ptr_struct->mailbox_write_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mailbox_write_size   : " U32H_FMT "\n", ptr_struct->mailbox_write_size);

}

int connectib_cmdif_ctx_fpga_cap_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_fpga_cap_dump(const struct connectib_cmdif_ctx_fpga_cap *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_fpga_cap_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_fpga_access_reg_pack(const struct connectib_cmdif_ctx_fpga_access_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->state);

}

void connectib_cmdif_ctx_fpga_access_reg_unpack(struct connectib_cmdif_ctx_fpga_access_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->state = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_fpga_access_reg_print(const struct connectib_cmdif_ctx_fpga_access_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_fpga_access_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "state                : " U32H_FMT "\n", ptr_struct->state);

}

int connectib_cmdif_ctx_fpga_access_reg_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_fpga_access_reg_dump(const struct connectib_cmdif_ctx_fpga_access_reg *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_fpga_access_reg_print(ptr_struct, file, 0);
}

void connectib_cmdif_create_lag_pack(const struct connectib_cmdif_create_lag *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_remap_affinity_1);

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tx_remap_affinity_2);

}

void connectib_cmdif_create_lag_unpack(struct connectib_cmdif_create_lag *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->tx_remap_affinity_1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 24;
	ptr_struct->tx_remap_affinity_2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_create_lag_print(const struct connectib_cmdif_create_lag *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_create_lag ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_remap_affinity_1  : " UH_FMT "\n", ptr_struct->tx_remap_affinity_1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_remap_affinity_2  : " UH_FMT "\n", ptr_struct->tx_remap_affinity_2);

}

int connectib_cmdif_create_lag_size(void)
{
	 return 32;
}

void connectib_cmdif_create_lag_dump(const struct connectib_cmdif_create_lag *ptr_struct, FILE* file)
{
	connectib_cmdif_create_lag_print(ptr_struct, file, 0);
}

void connectib_cmdif_modify_sq_pack(const struct connectib_cmdif_modify_sq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qp_flush_syndrom);

}

void connectib_cmdif_modify_sq_unpack(struct connectib_cmdif_modify_sq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->qp_flush_syndrom = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_modify_sq_print(const struct connectib_cmdif_modify_sq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_modify_sq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_flush_syndrom     : " U32H_FMT "\n", ptr_struct->qp_flush_syndrom);

}

int connectib_cmdif_modify_sq_size(void)
{
	 return 32;
}

void connectib_cmdif_modify_sq_dump(const struct connectib_cmdif_modify_sq *ptr_struct, FILE* file)
{
	connectib_cmdif_modify_sq_print(ptr_struct, file, 0);
}

void connectib_cmdif_modify_rq_pack(const struct connectib_cmdif_modify_rq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qp_flush_syndrom);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lwm);

}

void connectib_cmdif_modify_rq_unpack(struct connectib_cmdif_modify_rq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->qp_flush_syndrom = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->lwm = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_modify_rq_print(const struct connectib_cmdif_modify_rq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_modify_rq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_flush_syndrom     : " U32H_FMT "\n", ptr_struct->qp_flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lwm                  : " U32H_FMT "\n", ptr_struct->lwm);

}

int connectib_cmdif_modify_rq_size(void)
{
	 return 32;
}

void connectib_cmdif_modify_rq_dump(const struct connectib_cmdif_modify_rq *ptr_struct, FILE* file)
{
	connectib_cmdif_modify_rq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_l2_table_pack(const struct connectib_cmdif_ctx_l2_table *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hw_rx_ix);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hw_sx_ix);

}

void connectib_cmdif_ctx_l2_table_unpack(struct connectib_cmdif_ctx_l2_table *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->hw_rx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->hw_sx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_l2_table_print(const struct connectib_cmdif_ctx_l2_table *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_l2_table ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_rx_ix             : " U32H_FMT "\n", ptr_struct->hw_rx_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_sx_ix             : " U32H_FMT "\n", ptr_struct->hw_sx_ix);

}

int connectib_cmdif_ctx_l2_table_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_l2_table_dump(const struct connectib_cmdif_ctx_l2_table *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_l2_table_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_dmfs_ft_pack(const struct connectib_cmdif_ctx_dmfs_ft *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_num);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->log_size);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ft_in_level0);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ft_is_root);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_table_id);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->table_miss_mode);

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->lag_demux);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->decap_en);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->encap_en);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->table_id);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_head_ix);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_head_ix);

}

void connectib_cmdif_ctx_dmfs_ft_unpack(struct connectib_cmdif_ctx_dmfs_ft *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->vport_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 8;
	ptr_struct->log_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 2;
	ptr_struct->ft_in_level0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->ft_is_root = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 40;
	ptr_struct->next_table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 36;
	ptr_struct->table_miss_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 34;
	ptr_struct->lag_demux = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 33;
	ptr_struct->decap_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->encap_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->rx_head_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->sx_head_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_dmfs_ft_print(const struct connectib_cmdif_ctx_dmfs_ft *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_dmfs_ft ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_num            : " UH_FMT "\n", ptr_struct->vport_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_size             : " UH_FMT "\n", ptr_struct->log_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_in_level0         : " UH_FMT "\n", ptr_struct->ft_in_level0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_is_root           : " UH_FMT "\n", ptr_struct->ft_is_root);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_table_id        : " UH_FMT "\n", ptr_struct->next_table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_miss_mode      : " UH_FMT "\n", ptr_struct->table_miss_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lag_demux            : " UH_FMT "\n", ptr_struct->lag_demux);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "decap_en             : " UH_FMT "\n", ptr_struct->decap_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encap_en             : " UH_FMT "\n", ptr_struct->encap_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_id             : " UH_FMT "\n", ptr_struct->table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : " UH_FMT "\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_head_ix           : " U32H_FMT "\n", ptr_struct->rx_head_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_head_ix           : " U32H_FMT "\n", ptr_struct->sx_head_ix);

}

int connectib_cmdif_ctx_dmfs_ft_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_dmfs_ft_dump(const struct connectib_cmdif_ctx_dmfs_ft *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_dmfs_ft_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_dmfs_fg_pack(const struct connectib_cmdif_ctx_dmfs_fg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_num);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->table_id);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vst_root_hash_meta_ix);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_end_ste_ix);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_end_ste_ix);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_root_hash_meta_ix);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_root_hash_meta_ix);

}

void connectib_cmdif_ctx_dmfs_fg_unpack(struct connectib_cmdif_ctx_dmfs_fg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->vport_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 72;
	ptr_struct->table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->vst_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->rx_end_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->sx_end_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->rx_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->sx_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_dmfs_fg_print(const struct connectib_cmdif_ctx_dmfs_fg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_dmfs_fg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_num            : " UH_FMT "\n", ptr_struct->vport_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_id             : " UH_FMT "\n", ptr_struct->table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : " UH_FMT "\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vst_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->vst_root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_end_ste_ix        : " U32H_FMT "\n", ptr_struct->rx_end_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_end_ste_ix        : " U32H_FMT "\n", ptr_struct->sx_end_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->rx_root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->sx_root_hash_meta_ix);

}

int connectib_cmdif_ctx_dmfs_fg_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_dmfs_fg_dump(const struct connectib_cmdif_ctx_dmfs_fg *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_dmfs_fg_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_dmfs_fte_pack(const struct connectib_cmdif_ctx_dmfs_fte *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_num);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->copied_items_cntr);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->next_hierarchy_to_alloc);

	offset = 39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fte_use_iterator);

	offset = 38;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->src_port_ext_match_exists);

	offset = 37;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->modify_flow_list);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->external_dest_vport);

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->internal_dest_vport);

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uc_match_exists);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mc_match_exists);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fte_add_remove_);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->table_id);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->iterator_ix);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fte_rx_ix);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fte_sx_ix);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fte_rx2_ix);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fte_sx2_ix);

}

void connectib_cmdif_ctx_dmfs_fte_unpack(struct connectib_cmdif_ctx_dmfs_fte *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->vport_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 48;
	ptr_struct->copied_items_cntr = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 40;
	ptr_struct->next_hierarchy_to_alloc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 39;
	ptr_struct->fte_use_iterator = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 38;
	ptr_struct->src_port_ext_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 37;
	ptr_struct->modify_flow_list = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 36;
	ptr_struct->external_dest_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 35;
	ptr_struct->internal_dest_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 34;
	ptr_struct->uc_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 33;
	ptr_struct->mc_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->fte_add_remove_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	ptr_struct->iterator_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->fte_rx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->fte_sx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->fte_rx2_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->fte_sx2_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_dmfs_fte_print(const struct connectib_cmdif_ctx_dmfs_fte *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_dmfs_fte ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_num            : " UH_FMT "\n", ptr_struct->vport_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copied_items_cntr    : " UH_FMT "\n", ptr_struct->copied_items_cntr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_hierarchy_to_alloc : " UH_FMT "\n", ptr_struct->next_hierarchy_to_alloc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_use_iterator     : " UH_FMT "\n", ptr_struct->fte_use_iterator);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "src_port_ext_match_exists : " UH_FMT "\n", ptr_struct->src_port_ext_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "modify_flow_list     : " UH_FMT "\n", ptr_struct->modify_flow_list);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "external_dest_vport  : " UH_FMT "\n", ptr_struct->external_dest_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "internal_dest_vport  : " UH_FMT "\n", ptr_struct->internal_dest_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uc_match_exists      : " UH_FMT "\n", ptr_struct->uc_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mc_match_exists      : " UH_FMT "\n", ptr_struct->mc_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_add_remove_      : " UH_FMT "\n", ptr_struct->fte_add_remove_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_id             : " UH_FMT "\n", ptr_struct->table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : " UH_FMT "\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "iterator_ix          : " U32H_FMT "\n", ptr_struct->iterator_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_rx_ix            : " U32H_FMT "\n", ptr_struct->fte_rx_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_sx_ix            : " U32H_FMT "\n", ptr_struct->fte_sx_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_rx2_ix           : " U32H_FMT "\n", ptr_struct->fte_rx2_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_sx2_ix           : " U32H_FMT "\n", ptr_struct->fte_sx2_ix);

}

int connectib_cmdif_ctx_dmfs_fte_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_dmfs_fte_dump(const struct connectib_cmdif_ctx_dmfs_fte *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_dmfs_fte_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_create_mtt_pack(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mtt_ix);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_mtts);

}

void connectib_cmdif_ctx_create_mtt_unpack(struct connectib_cmdif_ctx_create_mtt *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->mtt_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->num_mtts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_create_mtt_print(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_create_mtt ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_ix               : " U64H_FMT "\n", ptr_struct->mtt_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_mtts             : " U32H_FMT "\n", ptr_struct->num_mtts);

}

int connectib_cmdif_ctx_create_mtt_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_create_mtt_dump(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_create_mtt_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_psv_pack(const struct connectib_cmdif_ctx_psv *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_psv);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_alloced_psv);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pd);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->psv_ix[i]);
	}

}

void connectib_cmdif_ctx_psv_unpack(struct connectib_cmdif_ctx_psv *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->num_psv = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->num_alloced_psv = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->pd = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 256, 1);
	ptr_struct->psv_ix[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_cmdif_ctx_psv_print(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_psv ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_psv              : " U32H_FMT "\n", ptr_struct->num_psv);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_alloced_psv      : " U32H_FMT "\n", ptr_struct->num_alloced_psv);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : " U32H_FMT "\n", ptr_struct->pd);

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psv_ix_%03d          : " U32H_FMT "\n", i, ptr_struct->psv_ix[i]);
	}

}

int connectib_cmdif_ctx_psv_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_psv_dump(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_psv_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_mcg_pack(const struct connectib_cmdif_ctx_mcg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_mcg_index);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_mcg_index);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->gid_msb);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->gid_lsb);

	offset = 208;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->member_count);

	offset = 206;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->ulp);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->iterator_ix);

}

void connectib_cmdif_ctx_mcg_unpack(struct connectib_cmdif_ctx_mcg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->rx_mcg_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->sx_mcg_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->gid_msb = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 128;
	ptr_struct->gid_lsb = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 208;
	ptr_struct->member_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 206;
	ptr_struct->ulp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 224;
	ptr_struct->iterator_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_mcg_print(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_mcg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_mcg_index         : " U32H_FMT "\n", ptr_struct->rx_mcg_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_mcg_index         : " U32H_FMT "\n", ptr_struct->sx_mcg_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gid_msb              : " U64H_FMT "\n", ptr_struct->gid_msb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gid_lsb              : " U64H_FMT "\n", ptr_struct->gid_lsb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "member_count         : " UH_FMT "\n", ptr_struct->member_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ulp                  : " UH_FMT "\n", ptr_struct->ulp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "iterator_ix          : " U32H_FMT "\n", ptr_struct->iterator_ix);

}

int connectib_cmdif_ctx_mcg_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_mcg_dump(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_mcg_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_sniffer_pack(const struct connectib_cmdif_ctx_sniffer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_0_1);

}

void connectib_cmdif_ctx_sniffer_unpack(struct connectib_cmdif_ctx_sniffer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->port_0_1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmdif_ctx_sniffer_print(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_sniffer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_0_1             : " UH_FMT "\n", ptr_struct->port_0_1);

}

int connectib_cmdif_ctx_sniffer_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_sniffer_dump(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_sniffer_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_rmp_pack(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->bitmask);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lwm);

}

void connectib_cmdif_ctx_special_modify_rmp_unpack(struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->bitmask = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->lwm = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_modify_rmp_print(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_rmp ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bitmask              : " U64H_FMT "\n", ptr_struct->bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lwm                  : " U32H_FMT "\n", ptr_struct->lwm);

}

int connectib_cmdif_ctx_special_modify_rmp_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_modify_rmp_dump(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_modify_rmp_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_arm_rq_pack(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lwm);

}

void connectib_cmdif_ctx_special_arm_rq_unpack(struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->lwm = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_arm_rq_print(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_arm_rq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lwm                  : " U32H_FMT "\n", ptr_struct->lwm);

}

int connectib_cmdif_ctx_special_arm_rq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_arm_rq_dump(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_arm_rq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_mkey_pack(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->hw_addr);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->octoword_actual_size_mtt);

}

void connectib_cmdif_ctx_special_mkey_unpack(struct connectib_cmdif_ctx_special_mkey *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->hw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 128;
	ptr_struct->octoword_actual_size_mtt = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_mkey_print(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_mkey ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_addr              : " U64H_FMT "\n", ptr_struct->hw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : " U64H_FMT "\n", ptr_struct->fw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "octoword_actual_size_mtt : " U32H_FMT "\n", ptr_struct->octoword_actual_size_mtt);

}

int connectib_cmdif_ctx_special_mkey_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_mkey_dump(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_mkey_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_cq_pack(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mtt_ix);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->producer_index);

	offset = 127;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cqe_128b_size);

	offset = 122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log2_size);

	offset = 117;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset = 111;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->cq_page_offset);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fence_slice);

	offset = 184;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->old_sw_eqn);

	offset = 183;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->modify_fields_c_eqn);

}

void connectib_cmdif_ctx_special_modify_cq_unpack(struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->mtt_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 72;
	ptr_struct->producer_index = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 127;
	ptr_struct->cqe_128b_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 122;
	ptr_struct->log2_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 117;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 111;
	ptr_struct->cq_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 128;
	ptr_struct->fence_slice = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 184;
	ptr_struct->old_sw_eqn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 183;
	ptr_struct->modify_fields_c_eqn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmdif_ctx_special_modify_cq_print(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_cq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_ix               : " U64H_FMT "\n", ptr_struct->mtt_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "producer_index       : " UH_FMT "\n", ptr_struct->producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cqe_128b_size        : " UH_FMT "\n", ptr_struct->cqe_128b_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_size            : " UH_FMT "\n", ptr_struct->log2_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : " UH_FMT "\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_page_offset       : " UH_FMT "\n", ptr_struct->cq_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fence_slice          : " U32H_FMT "\n", ptr_struct->fence_slice);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "old_sw_eqn           : " UH_FMT "\n", ptr_struct->old_sw_eqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "modify_fields_c_eqn  : " UH_FMT "\n", ptr_struct->modify_fields_c_eqn);

}

int connectib_cmdif_ctx_special_modify_cq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_modify_cq_dump(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_modify_cq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_cq_pack(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

}

void connectib_cmdif_ctx_special_create_cq_unpack(struct connectib_cmdif_ctx_special_create_cq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_cmdif_ctx_special_create_cq_print(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_cq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : " U64H_FMT "\n", ptr_struct->fw_addr);

}

int connectib_cmdif_ctx_special_create_cq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_cq_dump(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_cq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_eq_pack(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_eqc_addr);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mtt_ix_pas);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->event_bitmask);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hw_eqn);

	offset = 248;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->offset_in_page);

	offset = 242;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log_page_size);

	offset = 239;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_pa_mode);

}

void connectib_cmdif_ctx_special_create_eq_unpack(struct connectib_cmdif_ctx_special_create_eq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->fw_eqc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->mtt_ix_pas = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 128;
	ptr_struct->event_bitmask = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 192;
	ptr_struct->hw_eqn = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 248;
	ptr_struct->offset_in_page = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 242;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 239;
	ptr_struct->is_pa_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmdif_ctx_special_create_eq_print(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_eq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_eqc_addr          : " U64H_FMT "\n", ptr_struct->fw_eqc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_ix_pas           : " U64H_FMT "\n", ptr_struct->mtt_ix_pas);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "event_bitmask        : " U64H_FMT "\n", ptr_struct->event_bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_eqn               : " U32H_FMT "\n", ptr_struct->hw_eqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "offset_in_page       : " UH_FMT "\n", ptr_struct->offset_in_page);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : " UH_FMT "\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_pa_mode           : " UH_FMT "\n", ptr_struct->is_pa_mode);

}

int connectib_cmdif_ctx_special_create_eq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_eq_dump(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_eq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_rqt_pack(const struct connectib_cmdif_ctx_rqt *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rqt_fw_data_ix);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rqt_hw_data_ix);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rss_indirection_table_base_qpn);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rss_qpn_size);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_rqs_to_dec);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_max_size);

	offset = 176;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_actual_size);

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_actual_size_old);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rqt_fw_data_ix_old);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rqt_hw_data_ix_old);

}

void connectib_cmdif_ctx_rqt_unpack(struct connectib_cmdif_ctx_rqt *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->rqt_fw_data_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->rqt_hw_data_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->rss_indirection_table_base_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->rss_qpn_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 96;
	ptr_struct->num_rqs_to_dec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->rqt_max_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 176;
	ptr_struct->rqt_actual_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 160;
	ptr_struct->rqt_actual_size_old = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 192;
	ptr_struct->rqt_fw_data_ix_old = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->rqt_hw_data_ix_old = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_rqt_print(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_rqt ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_fw_data_ix       : " U32H_FMT "\n", ptr_struct->rqt_fw_data_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_hw_data_ix       : " U32H_FMT "\n", ptr_struct->rqt_hw_data_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rss_indirection_table_base_qpn : " UH_FMT "\n", ptr_struct->rss_indirection_table_base_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rss_qpn_size         : " UH_FMT "\n", ptr_struct->rss_qpn_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_rqs_to_dec       : " U32H_FMT "\n", ptr_struct->num_rqs_to_dec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_max_size         : " UH_FMT "\n", ptr_struct->rqt_max_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_actual_size      : " UH_FMT "\n", ptr_struct->rqt_actual_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_actual_size_old  : " UH_FMT "\n", ptr_struct->rqt_actual_size_old);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_fw_data_ix_old   : " U32H_FMT "\n", ptr_struct->rqt_fw_data_ix_old);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_hw_data_ix_old   : " U32H_FMT "\n", ptr_struct->rqt_hw_data_ix_old);

}

int connectib_cmdif_ctx_rqt_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_rqt_dump(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_rqt_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_xrq_pack(const struct connectib_cmdif_ctx_special_create_xrq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->curr_mtt_offset);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fw_srqn);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->tgt_num);

	offset = 68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->offload);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->topology);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->nvme_sq_mkn);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->nvme_cq_mkn);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->uapp_data_mkn);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->uapp_ctrl_mkn);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_nim_indicies_allocated);

}

void connectib_cmdif_ctx_special_create_xrq_unpack(struct connectib_cmdif_ctx_special_create_xrq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->curr_mtt_offset = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 40;
	ptr_struct->fw_srqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 72;
	ptr_struct->tgt_num = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 68;
	ptr_struct->offload = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->topology = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 104;
	ptr_struct->nvme_sq_mkn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 136;
	ptr_struct->nvme_cq_mkn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 168;
	ptr_struct->uapp_data_mkn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->uapp_ctrl_mkn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->num_nim_indicies_allocated = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_xrq_print(const struct connectib_cmdif_ctx_special_create_xrq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_xrq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "curr_mtt_offset      : " UH_FMT "\n", ptr_struct->curr_mtt_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_srqn              : " UH_FMT "\n", ptr_struct->fw_srqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tgt_num              : " UH_FMT "\n", ptr_struct->tgt_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "offload              : " UH_FMT "\n", ptr_struct->offload);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "topology             : " UH_FMT "\n", ptr_struct->topology);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvme_sq_mkn          : " UH_FMT "\n", ptr_struct->nvme_sq_mkn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvme_cq_mkn          : " UH_FMT "\n", ptr_struct->nvme_cq_mkn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uapp_data_mkn        : " UH_FMT "\n", ptr_struct->uapp_data_mkn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uapp_ctrl_mkn        : " UH_FMT "\n", ptr_struct->uapp_ctrl_mkn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_nim_indicies_allocated : " U32H_FMT "\n", ptr_struct->num_nim_indicies_allocated);

}

int connectib_cmdif_ctx_special_create_xrq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_xrq_dump(const struct connectib_cmdif_ctx_special_create_xrq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_xrq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_srq_pack(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srqi);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cont_srq);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pas_offset);

}

void connectib_cmdif_ctx_special_create_srq_unpack(struct connectib_cmdif_ctx_special_create_srq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 72;
	ptr_struct->srqi = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->cont_srq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->pas_offset = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_srq_print(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_srq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : " U64H_FMT "\n", ptr_struct->fw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srqi                 : " UH_FMT "\n", ptr_struct->srqi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cont_srq             : " UH_FMT "\n", ptr_struct->cont_srq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_offset           : " U32H_FMT "\n", ptr_struct->pas_offset);

}

int connectib_cmdif_ctx_special_create_srq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_srq_dump(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_srq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_rq_pack(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_qpc_addr);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->no_lro_qpn);

	offset = 123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_max_qp);

	offset = 116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->wq_type);

}

void connectib_cmdif_ctx_special_create_rq_unpack(struct connectib_cmdif_ctx_special_create_rq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->fw_qpc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->no_lro_qpn = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 123;
	ptr_struct->log_max_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 116;
	ptr_struct->wq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_rq_print(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_rq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_addr          : " U64H_FMT "\n", ptr_struct->fw_qpc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_lro_qpn           : " U32H_FMT "\n", ptr_struct->no_lro_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_qp           : " UH_FMT "\n", ptr_struct->log_max_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_type              : " UH_FMT "\n", ptr_struct->wq_type);

}

int connectib_cmdif_ctx_special_create_rq_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_rq_dump(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_rq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_qp_commands_pack(const struct connectib_cmdif_ctx_special_qp_commands *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_qpc_addr);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->qpi);

	offset = 123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_max_qp);

	offset = 122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_dci);

	offset = 121;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_enhanced_ipoib);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_xrq);

	offset = 117;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->offload_xrq_type);

	offset = 116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_tag_matching_xrq);

	offset = 128;
	connectib_cmdif_ctx_special_qp_commands_specific_pack(&(ptr_struct->specific), ptr_buff + offset/8);

}

void connectib_cmdif_ctx_special_qp_commands_unpack(struct connectib_cmdif_ctx_special_qp_commands *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->fw_qpc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->qpi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 123;
	ptr_struct->log_max_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 122;
	ptr_struct->is_dci = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 121;
	ptr_struct->is_enhanced_ipoib = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 120;
	ptr_struct->is_xrq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 117;
	ptr_struct->offload_xrq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 116;
	ptr_struct->is_tag_matching_xrq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 128;
	connectib_cmdif_ctx_special_qp_commands_specific_unpack(&(ptr_struct->specific), ptr_buff + offset/8);

}

void connectib_cmdif_ctx_special_qp_commands_print(const struct connectib_cmdif_ctx_special_qp_commands *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_qp_commands ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_addr          : " U64H_FMT "\n", ptr_struct->fw_qpc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpi                  : " U32H_FMT "\n", ptr_struct->qpi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_qp           : " UH_FMT "\n", ptr_struct->log_max_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_dci               : " UH_FMT "\n", ptr_struct->is_dci);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_enhanced_ipoib    : " UH_FMT "\n", ptr_struct->is_enhanced_ipoib);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_xrq               : " UH_FMT "\n", ptr_struct->is_xrq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "offload_xrq_type     : " UH_FMT "\n", ptr_struct->offload_xrq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_tag_matching_xrq  : " UH_FMT "\n", ptr_struct->is_tag_matching_xrq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "specific:\n");
	connectib_cmdif_ctx_special_qp_commands_specific_print(&(ptr_struct->specific), file, indent_level + 1);

}

int connectib_cmdif_ctx_special_qp_commands_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_qp_commands_dump(const struct connectib_cmdif_ctx_special_qp_commands *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_qp_commands_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_tis_pack(const struct connectib_cmdif_ctx_special_modify_tis *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->transport_domain);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->underlay_qpn);

}

void connectib_cmdif_ctx_special_modify_tis_unpack(struct connectib_cmdif_ctx_special_modify_tis *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->transport_domain = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 40;
	ptr_struct->underlay_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_cmdif_ctx_special_modify_tis_print(const struct connectib_cmdif_ctx_special_modify_tis *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_tis ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transport_domain     : " UH_FMT "\n", ptr_struct->transport_domain);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "underlay_qpn         : " UH_FMT "\n", ptr_struct->underlay_qpn);

}

int connectib_cmdif_ctx_special_modify_tis_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_modify_tis_dump(const struct connectib_cmdif_ctx_special_modify_tis *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_modify_tis_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_tir_pack(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->bitmask);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->tir_ste_ix);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hash_filter_base_ix);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hash_entries_base_ix);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rqt_number);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->old_rqt_number);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->inline_rqn);

	offset = 196;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disp_type);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->transport_domain);

}

void connectib_cmdif_ctx_special_modify_tir_unpack(struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->bitmask = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->tir_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->hash_filter_base_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->hash_entries_base_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 136;
	ptr_struct->rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 168;
	ptr_struct->old_rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->inline_rqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 196;
	ptr_struct->disp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 232;
	ptr_struct->transport_domain = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_cmdif_ctx_special_modify_tir_print(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_tir ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bitmask              : " U32H_FMT "\n", ptr_struct->bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tir_ste_ix           : " U32H_FMT "\n", ptr_struct->tir_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hash_filter_base_ix  : " U32H_FMT "\n", ptr_struct->hash_filter_base_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hash_entries_base_ix : " U32H_FMT "\n", ptr_struct->hash_entries_base_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_number           : " UH_FMT "\n", ptr_struct->rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "old_rqt_number       : " UH_FMT "\n", ptr_struct->old_rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_rqn           : " UH_FMT "\n", ptr_struct->inline_rqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disp_type            : " UH_FMT "\n", ptr_struct->disp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transport_domain     : " UH_FMT "\n", ptr_struct->transport_domain);

}

int connectib_cmdif_ctx_special_modify_tir_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_modify_tir_dump(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_modify_tir_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_pack(const struct connectib_cmdif_ctx_special_create *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_mapped_mtts);

}

void connectib_cmdif_ctx_special_create_unpack(struct connectib_cmdif_ctx_special_create *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->num_mapped_mtts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_print(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_mapped_mtts      : " U32H_FMT "\n", ptr_struct->num_mapped_mtts);

}

int connectib_cmdif_ctx_special_create_size(void)
{
	 return 32;
}

void connectib_cmdif_ctx_special_create_dump(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file)
{
	connectib_cmdif_ctx_special_create_print(ptr_struct, file, 0);
}

void connectib_flush_type_bitmask_pack(const struct connectib_flush_type_bitmask *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword);

}

void connectib_flush_type_bitmask_unpack(struct connectib_flush_type_bitmask *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->dword = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_flush_type_bitmask_print(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flush_type_bitmask ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword                : " U32H_FMT "\n", ptr_struct->dword);

}

int connectib_flush_type_bitmask_size(void)
{
	 return 4;
}

void connectib_flush_type_bitmask_dump(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file)
{
	connectib_flush_type_bitmask_print(ptr_struct, file, 0);
}

void connectib_flush_type_bits_pack(const struct connectib_flush_type_bits *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mkey_flush);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_s_flush);

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_r_flush);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_flush);

}

void connectib_flush_type_bits_unpack(struct connectib_flush_type_bits *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->mkey_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->qp_s_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 29;
	ptr_struct->qp_r_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->rx_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_flush_type_bits_print(const struct connectib_flush_type_bits *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flush_type_bits ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mkey_flush           : " UH_FMT "\n", ptr_struct->mkey_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_s_flush           : " UH_FMT "\n", ptr_struct->qp_s_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_r_flush           : " UH_FMT "\n", ptr_struct->qp_r_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_flush             : " UH_FMT "\n", ptr_struct->rx_flush);

}

int connectib_flush_type_bits_size(void)
{
	 return 4;
}

void connectib_flush_type_bits_dump(const struct connectib_flush_type_bits *ptr_struct, FILE* file)
{
	connectib_flush_type_bits_print(ptr_struct, file, 0);
}

void connectib_reg_access_reg_tlv_data_pack(const union connectib_reg_access_reg_tlv_data *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_pmcr_reg_pack(&(ptr_struct->pmcr), ptr_buff);
}

void connectib_reg_access_reg_tlv_data_unpack(union connectib_reg_access_reg_tlv_data *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_pmcr_reg_unpack(&(ptr_struct->pmcr), ptr_buff);
}

void connectib_reg_access_reg_tlv_data_print(const union connectib_reg_access_reg_tlv_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_reg_access_reg_tlv_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfpa:\n");
	connectib_mfpa_print(&(ptr_struct->mfpa), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfai:\n");
	connectib_register_mfai_print(&(ptr_struct->mfai), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfrl:\n");
	connectib_register_mfrl_print(&(ptr_struct->mfrl), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtmp:\n");
	connectib_mtmp_print(&(ptr_struct->mtmp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "misc_counters:\n");
	connectib_register_misc_counters_print(&(ptr_struct->misc_counters), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfba:\n");
	connectib_project_mfba_print(&(ptr_struct->mfba), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfbe:\n");
	connectib_mfbe_print(&(ptr_struct->mfbe), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcqs:\n");
	connectib_mcqs_reg_print(&(ptr_struct->mcqs), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcqi:\n");
	connectib_mcqi_reg_print(&(ptr_struct->mcqi), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcc:\n");
	connectib_mcc_reg_print(&(ptr_struct->mcc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcda:\n");
	connectib_mcda_reg_print(&(ptr_struct->mcda), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mqis:\n");
	connectib_mqis_reg_print(&(ptr_struct->mqis), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mjtag:\n");
	connectib_mjtag_print(&(ptr_struct->mjtag), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "paos:\n");
	connectib_paos_reg_print(&(ptr_struct->paos), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slrp:\n");
	connectib_slrp_reg_print(&(ptr_struct->slrp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sltp:\n");
	connectib_sltp_reg_print(&(ptr_struct->sltp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ptas:\n");
	connectib_ptas_reg_print(&(ptr_struct->ptas), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slrg:\n");
	connectib_slrg_reg_print(&(ptr_struct->slrg), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pptt:\n");
	connectib_pptt_reg_print(&(ptr_struct->pptt), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pprt:\n");
	connectib_pprt_reg_print(&(ptr_struct->pprt), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ppaos:\n");
	connectib_ppaos_reg_print(&(ptr_struct->ppaos), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ppamp:\n");
	connectib_pamp_reg_print(&(ptr_struct->ppamp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pmtu:\n");
	connectib_pmtu_reg_print(&(ptr_struct->pmtu), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvda:\n");
	connectib_project_nvda_print(&(ptr_struct->nvda), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvdi:\n");
	connectib_nv_tlv_hdr_print(&(ptr_struct->nvdi), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvqc:\n");
	connectib_project_nvqc_print(&(ptr_struct->nvqc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvgc:\n");
	connectib_project_nvgc_print(&(ptr_struct->nvgc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvia:\n");
	connectib_project_nvia_print(&(ptr_struct->nvia), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvgn:\n");
	connectib_project_nvgn_print(&(ptr_struct->nvgn), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pplr:\n");
	connectib_pplr_reg_print(&(ptr_struct->pplr), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "plpc:\n");
	connectib_plpc_reg_print(&(ptr_struct->plpc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pplm:\n");
	connectib_pplm_reg_print(&(ptr_struct->pplm), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pmlp:\n");
	connectib_pmlp_print(&(ptr_struct->pmlp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mvts:\n");
	connectib_mvts_print(&(ptr_struct->mvts), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mpein:\n");
	connectib_mpein_reg_print(&(ptr_struct->mpein), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pmcr:\n");
	connectib_pmcr_reg_print(&(ptr_struct->pmcr), file, indent_level + 1);

}

int connectib_reg_access_reg_tlv_data_size(void)
{
	 return 44;
}

void connectib_reg_access_reg_tlv_data_dump(const union connectib_reg_access_reg_tlv_data *ptr_struct, FILE* file)
{
	connectib_reg_access_reg_tlv_data_print(ptr_struct, file, 0);
}

void connectib_pmaos_reg_pack(const struct connectib_pmaos_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->oper_status);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->admin_status);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->e);

	offset = 52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->error_type);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ee);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ase);

}

void connectib_pmaos_reg_unpack(struct connectib_pmaos_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->oper_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 20;
	ptr_struct->admin_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 8;
	ptr_struct->module = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 62;
	ptr_struct->e = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 52;
	ptr_struct->error_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 33;
	ptr_struct->ee = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->ase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_pmaos_reg_print(const struct connectib_pmaos_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmaos_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oper_status          : " UH_FMT "\n", ptr_struct->oper_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "admin_status         : " UH_FMT "\n", ptr_struct->admin_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module               : " UH_FMT "\n", ptr_struct->module);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e                    : " UH_FMT "\n", ptr_struct->e);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error_type           : " UH_FMT "\n", ptr_struct->error_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ee                   : " UH_FMT "\n", ptr_struct->ee);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ase                  : " UH_FMT "\n", ptr_struct->ase);

}

int connectib_pmaos_reg_size(void)
{
	 return 16;
}

void connectib_pmaos_reg_dump(const struct connectib_pmaos_reg *ptr_struct, FILE* file)
{
	connectib_pmaos_reg_print(ptr_struct, file, 0);
}

void connectib_mtppse_reg_pack(const struct connectib_mtppse_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pin);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->event_generation_mode);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->event_arm);

}

void connectib_mtppse_reg_unpack(struct connectib_mtppse_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->pin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 60;
	ptr_struct->event_generation_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->event_arm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_mtppse_reg_print(const struct connectib_mtppse_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mtppse_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pin                  : " UH_FMT "\n", ptr_struct->pin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "event_generation_mode : " UH_FMT "\n", ptr_struct->event_generation_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "event_arm            : " UH_FMT "\n", ptr_struct->event_arm);

}

int connectib_mtppse_reg_size(void)
{
	 return 16;
}

void connectib_mtppse_reg_dump(const struct connectib_mtppse_reg *ptr_struct, FILE* file)
{
	connectib_mtppse_reg_print(ptr_struct, file, 0);
}

void connectib_mtpps_reg_pack(const struct connectib_mtpps_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_max_num_of_pps_out_pins);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_max_num_of_pps_in_pins);

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_number_of_pps_pins);

	offset = 92;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_0_mode);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_1_mode);

	offset = 76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_2_mode);

	offset = 68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_3_mode);

	offset = 124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_4_mode);

	offset = 116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_5_mode);

	offset = 108;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_6_mode);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->cap_pin_7_mode);

	offset = 280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pin);

	offset = 276;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pin_mode);

	offset = 268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pattern);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->enable);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_stamp_hi);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->time_stamp_lo);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->out_periodic_adjustment);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->out_pulse_duration);

}

void connectib_mtpps_reg_unpack(struct connectib_mtpps_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->cap_max_num_of_pps_out_pins = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 20;
	ptr_struct->cap_max_num_of_pps_in_pins = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 12;
	ptr_struct->cap_number_of_pps_pins = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 92;
	ptr_struct->cap_pin_0_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 84;
	ptr_struct->cap_pin_1_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 76;
	ptr_struct->cap_pin_2_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 68;
	ptr_struct->cap_pin_3_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 124;
	ptr_struct->cap_pin_4_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 116;
	ptr_struct->cap_pin_5_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 108;
	ptr_struct->cap_pin_6_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 100;
	ptr_struct->cap_pin_7_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 280;
	ptr_struct->pin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 276;
	ptr_struct->pin_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 268;
	ptr_struct->pattern = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 320;
	ptr_struct->time_stamp_hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->time_stamp_lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 400;
	ptr_struct->out_periodic_adjustment = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 384;
	ptr_struct->out_pulse_duration = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_mtpps_reg_print(const struct connectib_mtpps_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mtpps_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_max_num_of_pps_out_pins : " UH_FMT "\n", ptr_struct->cap_max_num_of_pps_out_pins);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_max_num_of_pps_in_pins : " UH_FMT "\n", ptr_struct->cap_max_num_of_pps_in_pins);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_number_of_pps_pins : " UH_FMT "\n", ptr_struct->cap_number_of_pps_pins);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_0_mode       : " UH_FMT "\n", ptr_struct->cap_pin_0_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_1_mode       : " UH_FMT "\n", ptr_struct->cap_pin_1_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_2_mode       : " UH_FMT "\n", ptr_struct->cap_pin_2_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_3_mode       : " UH_FMT "\n", ptr_struct->cap_pin_3_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_4_mode       : " UH_FMT "\n", ptr_struct->cap_pin_4_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_5_mode       : " UH_FMT "\n", ptr_struct->cap_pin_5_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_6_mode       : " UH_FMT "\n", ptr_struct->cap_pin_6_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_pin_7_mode       : " UH_FMT "\n", ptr_struct->cap_pin_7_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pin                  : " UH_FMT "\n", ptr_struct->pin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pin_mode             : " UH_FMT "\n", ptr_struct->pin_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pattern              : " UH_FMT "\n", ptr_struct->pattern);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "enable               : " UH_FMT "\n", ptr_struct->enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_stamp_hi        : " U32H_FMT "\n", ptr_struct->time_stamp_hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_stamp_lo        : " U32H_FMT "\n", ptr_struct->time_stamp_lo);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "out_periodic_adjustment : " UH_FMT "\n", ptr_struct->out_periodic_adjustment);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "out_pulse_duration   : " UH_FMT "\n", ptr_struct->out_pulse_duration);

}

int connectib_mtpps_reg_size(void)
{
	 return 64;
}

void connectib_mtpps_reg_dump(const struct connectib_mtpps_reg *ptr_struct, FILE* file)
{
	connectib_mtpps_reg_print(ptr_struct, file, 0);
}

void connectib_fpga_ctrl_pack(const struct connectib_fpga_ctrl *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->status);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->operation);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flash_select_oper);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flash_select_admin);

}

void connectib_fpga_ctrl_unpack(struct connectib_fpga_ctrl *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->operation = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->flash_select_oper = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 40;
	ptr_struct->flash_select_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_fpga_ctrl_print(const struct connectib_fpga_ctrl *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fpga_ctrl ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status               : %s (" UH_FMT ")\n", (ptr_struct->status == 0 ? ("Success") : ((ptr_struct->status == 1 ? ("Failure") : ((ptr_struct->status == 2 ? ("In_progress") : ("unknown")))))), ptr_struct->status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "operation            : %s (" UH_FMT ")\n", (ptr_struct->operation == 1 ? ("LOAD") : ((ptr_struct->operation == 2 ? ("RESET") : ((ptr_struct->operation == 3 ? ("FLASH_SELECT") : ((ptr_struct->operation == 4 ? ("Sandbox_Bypass_On") : ((ptr_struct->operation == 5 ? ("Sandbox_Bypass_Off") : ("unknown")))))))))), ptr_struct->operation);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flash_select_oper    : %s (" UH_FMT ")\n", (ptr_struct->flash_select_oper == 0 ? ("Factory_default") : ((ptr_struct->flash_select_oper == 1 ? ("User") : ("unknown")))), ptr_struct->flash_select_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flash_select_admin   : %s (" UH_FMT ")\n", (ptr_struct->flash_select_admin == 0 ? ("Factory_default") : ((ptr_struct->flash_select_admin == 1 ? ("User") : ("unknown")))), ptr_struct->flash_select_admin);

}

int connectib_fpga_ctrl_size(void)
{
	 return 16;
}

void connectib_fpga_ctrl_dump(const struct connectib_fpga_ctrl *ptr_struct, FILE* file)
{
	connectib_fpga_ctrl_print(ptr_struct, file, 0);
}

void connectib_fpga_cap_pack(const struct connectib_fpga_cap *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fpga_device);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->fpga_id);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->register_file_ver);

	offset = 78;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->access_reg_modify_mode);

	offset = 70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->access_reg_query_mode);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fpga_ctrl_modify);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->image_version);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->image_date);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->image_time);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->shell_version);

	offset = 384;
	connectib_fpga_shell_caps_pack(&(ptr_struct->shell_caps), ptr_buff + offset/8);

	offset = 904;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->ieee_vendor_id);

	offset = 944;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->sandbox_product_id);

	offset = 928;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->sandbox_product_version);

	offset = 960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sandbox_basic_caps);

	offset = 1008;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->sandbox_extended_caps_len);

	offset = 1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sandbox_extended_caps_addr_h);

	offset = 1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sandbox_extended_caps_addr_l);

	offset = 1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_ddr_start_addr_h);

	offset = 1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_ddr_start_addr_l);

	offset = 1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_cr_space_start_addr_h);

	offset = 1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_cr_space_start_addr_l);

	offset = 1216;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_ddr_size);

	offset = 1248;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fpga_cr_space_size);

}

void connectib_fpga_cap_unpack(struct connectib_fpga_cap *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->fpga_device = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 0;
	ptr_struct->fpga_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->register_file_ver = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 78;
	ptr_struct->access_reg_modify_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 70;
	ptr_struct->access_reg_query_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 64;
	ptr_struct->fpga_ctrl_modify = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 128;
	ptr_struct->image_version = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->image_date = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->image_time = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->shell_version = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	connectib_fpga_shell_caps_unpack(&(ptr_struct->shell_caps), ptr_buff + offset/8);

	offset = 904;
	ptr_struct->ieee_vendor_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 944;
	ptr_struct->sandbox_product_id = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 928;
	ptr_struct->sandbox_product_version = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 960;
	ptr_struct->sandbox_basic_caps = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1008;
	ptr_struct->sandbox_extended_caps_len = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 1024;
	ptr_struct->sandbox_extended_caps_addr_h = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1056;
	ptr_struct->sandbox_extended_caps_addr_l = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1088;
	ptr_struct->fpga_ddr_start_addr_h = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1120;
	ptr_struct->fpga_ddr_start_addr_l = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1152;
	ptr_struct->fpga_cr_space_start_addr_h = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1184;
	ptr_struct->fpga_cr_space_start_addr_l = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1216;
	ptr_struct->fpga_ddr_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 1248;
	ptr_struct->fpga_cr_space_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_fpga_cap_print(const struct connectib_fpga_cap *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fpga_cap ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_device          : %s (" UH_FMT ")\n", (ptr_struct->fpga_device == 0 ? ("KU040") : ((ptr_struct->fpga_device == 1 ? ("KU060") : ("unknown")))), ptr_struct->fpga_device);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_id              : %s (" UH_FMT ")\n", (ptr_struct->fpga_id == 0 ? ("unknown") : ((ptr_struct->fpga_id == 1 ? ("Newton_X") : ("unknown")))), ptr_struct->fpga_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "register_file_ver    : " U32H_FMT "\n", ptr_struct->register_file_ver);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "access_reg_modify_mode : %s (" UH_FMT ")\n", (ptr_struct->access_reg_modify_mode == 0 ? ("Not_allowed") : ((ptr_struct->access_reg_modify_mode == 1 ? ("All_range_allowed") : ("unknown")))), ptr_struct->access_reg_modify_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "access_reg_query_mode : %s (" UH_FMT ")\n", (ptr_struct->access_reg_query_mode == 0 ? ("Not_allowed") : ((ptr_struct->access_reg_query_mode == 1 ? ("All_range_allowed") : ("unknown")))), ptr_struct->access_reg_query_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_ctrl_modify     : " UH_FMT "\n", ptr_struct->fpga_ctrl_modify);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "image_version        : " U32H_FMT "\n", ptr_struct->image_version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "image_date           : " U32H_FMT "\n", ptr_struct->image_date);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "image_time           : " U32H_FMT "\n", ptr_struct->image_time);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "shell_version        : " U32H_FMT "\n", ptr_struct->shell_version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "shell_caps:\n");
	connectib_fpga_shell_caps_print(&(ptr_struct->shell_caps), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ieee_vendor_id       : " UH_FMT "\n", ptr_struct->ieee_vendor_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_product_id   : %s (" UH_FMT ")\n", (ptr_struct->sandbox_product_id == 1 ? ("example") : ((ptr_struct->sandbox_product_id == 2 ? ("IPsec") : ((ptr_struct->sandbox_product_id == 3 ? ("TLS") : ("unknown")))))), ptr_struct->sandbox_product_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_product_version : " UH_FMT "\n", ptr_struct->sandbox_product_version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_basic_caps   : " U32H_FMT "\n", ptr_struct->sandbox_basic_caps);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_extended_caps_len : " UH_FMT "\n", ptr_struct->sandbox_extended_caps_len);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_extended_caps_addr_h : " U32H_FMT "\n", ptr_struct->sandbox_extended_caps_addr_h);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sandbox_extended_caps_addr_l : " U32H_FMT "\n", ptr_struct->sandbox_extended_caps_addr_l);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_ddr_start_addr_h : " U32H_FMT "\n", ptr_struct->fpga_ddr_start_addr_h);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_ddr_start_addr_l : " U32H_FMT "\n", ptr_struct->fpga_ddr_start_addr_l);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_cr_space_start_addr_h : " U32H_FMT "\n", ptr_struct->fpga_cr_space_start_addr_h);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_cr_space_start_addr_l : " U32H_FMT "\n", ptr_struct->fpga_cr_space_start_addr_l);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_ddr_size        : " U32H_FMT "\n", ptr_struct->fpga_ddr_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpga_cr_space_size   : " U32H_FMT "\n", ptr_struct->fpga_cr_space_size);

}

int connectib_fpga_cap_size(void)
{
	 return 256;
}

void connectib_fpga_cap_dump(const struct connectib_fpga_cap *ptr_struct, FILE* file)
{
	connectib_fpga_cap_print(ptr_struct, file, 0);
}

void connectib_fpga_access_reg_pack(const struct connectib_fpga_access_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->size);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->address_h);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->address_l);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(152, 8, i, 160, 1);
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->data[i]);
	}

}

void connectib_fpga_access_reg_unpack(struct connectib_fpga_access_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 48;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->address_h = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->address_l = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(152, 8, i, 160, 1);
	ptr_struct->data[i] = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);
	}

}

void connectib_fpga_access_reg_print(const struct connectib_fpga_access_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fpga_access_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address_h            : " U32H_FMT "\n", ptr_struct->address_h);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address_l            : " U32H_FMT "\n", ptr_struct->address_l);

	for (i = 0; i < 1; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_%03d            : " UH_FMT "\n", i, ptr_struct->data[i]);
	}

}

int connectib_fpga_access_reg_size(void)
{
	 return 20;
}

void connectib_fpga_access_reg_dump(const struct connectib_fpga_access_reg *ptr_struct, FILE* file)
{
	connectib_fpga_access_reg_print(ptr_struct, file, 0);
}

void connectib_pmmp_reg_pack(const struct connectib_pmmp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->eeprom_override);

	offset = 64;
	connectib_pmmp_qsfp_protocol_override_layout_auto_pack(&(ptr_struct->qsfp_cable_protocol_technology), ptr_buff + offset/8);

	offset = 160;
	connectib_pmmp_sfp_protocol_override_layout_auto_pack(&(ptr_struct->sfp_cable_protocol_technology), ptr_buff + offset/8);

	offset = 280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cable_length);

	offset = 312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->attenuation_5g);

	offset = 304;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->attenuation_7g);

	offset = 296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->attenuation_12g);

	offset = 344;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module_identifier);

}

void connectib_pmmp_reg_unpack(struct connectib_pmmp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->module = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->eeprom_override = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 64;
	connectib_pmmp_qsfp_protocol_override_layout_auto_unpack(&(ptr_struct->qsfp_cable_protocol_technology), ptr_buff + offset/8);

	offset = 160;
	connectib_pmmp_sfp_protocol_override_layout_auto_unpack(&(ptr_struct->sfp_cable_protocol_technology), ptr_buff + offset/8);

	offset = 280;
	ptr_struct->cable_length = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 312;
	ptr_struct->attenuation_5g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 304;
	ptr_struct->attenuation_7g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 296;
	ptr_struct->attenuation_12g = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 344;
	ptr_struct->module_identifier = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_pmmp_reg_print(const struct connectib_pmmp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmmp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module               : " UH_FMT "\n", ptr_struct->module);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eeprom_override      : " UH_FMT "\n", ptr_struct->eeprom_override);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qsfp_cable_protocol_technology:\n");
	connectib_pmmp_qsfp_protocol_override_layout_auto_print(&(ptr_struct->qsfp_cable_protocol_technology), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sfp_cable_protocol_technology:\n");
	connectib_pmmp_sfp_protocol_override_layout_auto_print(&(ptr_struct->sfp_cable_protocol_technology), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cable_length         : " UH_FMT "\n", ptr_struct->cable_length);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "attenuation_5g       : " UH_FMT "\n", ptr_struct->attenuation_5g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "attenuation_7g       : " UH_FMT "\n", ptr_struct->attenuation_7g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "attenuation_12g      : " UH_FMT "\n", ptr_struct->attenuation_12g);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module_identifier    : " UH_FMT "\n", ptr_struct->module_identifier);

}

int connectib_pmmp_reg_size(void)
{
	 return 44;
}

void connectib_pmmp_reg_dump(const struct connectib_pmmp_reg *ptr_struct, FILE* file)
{
	connectib_pmmp_reg_print(ptr_struct, file, 0);
}

void connectib_pcmr_reg_pack(const struct connectib_pcmr_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pcs_cap);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fcs_cap);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sht_cap);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mtu_cap);

	offset = 59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->type_cap);

	offset = 58;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->len_cap);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fc_cap);

	offset = 55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cp_cap);

	offset = 95;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pcs_chk);

	offset = 94;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fcs_chk);

	offset = 93;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sht_chk);

	offset = 92;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mtu_chk);

	offset = 91;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->type_chk);

	offset = 90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->len_chk);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fc_chk);

	offset = 87;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cp_chk);

}

void connectib_pcmr_reg_unpack(struct connectib_pcmr_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 63;
	ptr_struct->pcs_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 62;
	ptr_struct->fcs_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 61;
	ptr_struct->sht_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 60;
	ptr_struct->mtu_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 59;
	ptr_struct->type_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 58;
	ptr_struct->len_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 56;
	ptr_struct->fc_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 55;
	ptr_struct->cp_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 95;
	ptr_struct->pcs_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 94;
	ptr_struct->fcs_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 93;
	ptr_struct->sht_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 92;
	ptr_struct->mtu_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 91;
	ptr_struct->type_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 90;
	ptr_struct->len_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 88;
	ptr_struct->fc_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 87;
	ptr_struct->cp_chk = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_pcmr_reg_print(const struct connectib_pcmr_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcmr_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcs_cap              : " UH_FMT "\n", ptr_struct->pcs_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fcs_cap              : " UH_FMT "\n", ptr_struct->fcs_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sht_cap              : " UH_FMT "\n", ptr_struct->sht_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu_cap              : " UH_FMT "\n", ptr_struct->mtu_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type_cap             : " UH_FMT "\n", ptr_struct->type_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "len_cap              : " UH_FMT "\n", ptr_struct->len_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_cap               : " UH_FMT "\n", ptr_struct->fc_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cp_cap               : " UH_FMT "\n", ptr_struct->cp_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcs_chk              : " UH_FMT "\n", ptr_struct->pcs_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fcs_chk              : " UH_FMT "\n", ptr_struct->fcs_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sht_chk              : " UH_FMT "\n", ptr_struct->sht_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu_chk              : " UH_FMT "\n", ptr_struct->mtu_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type_chk             : " UH_FMT "\n", ptr_struct->type_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "len_chk              : " UH_FMT "\n", ptr_struct->len_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_chk               : " UH_FMT "\n", ptr_struct->fc_chk);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cp_chk               : " UH_FMT "\n", ptr_struct->cp_chk);

}

int connectib_pcmr_reg_size(void)
{
	 return 12;
}

void connectib_pcmr_reg_dump(const struct connectib_pcmr_reg *ptr_struct, FILE* file)
{
	connectib_pcmr_reg_print(ptr_struct, file, 0);
}

void connectib_mcion_reg_pack(const struct connectib_mcion_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module_status_bits);

}

void connectib_mcion_reg_unpack(struct connectib_mcion_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->module = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 56;
	ptr_struct->module_status_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_mcion_reg_print(const struct connectib_mcion_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcion_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module               : " UH_FMT "\n", ptr_struct->module);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module_status_bits   : " UH_FMT "\n", ptr_struct->module_status_bits);

}

int connectib_mcion_reg_size(void)
{
	 return 24;
}

void connectib_mcion_reg_dump(const struct connectib_mcion_reg *ptr_struct, FILE* file)
{
	connectib_mcion_reg_print(ptr_struct, file, 0);
}

void connectib_pddr_reg_pack(const struct connectib_pddr_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pddr_reg_unpack(struct connectib_pddr_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pddr_reg_print(const struct connectib_pddr_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pddr_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pddr_reg_size(void)
{
	 return 256;
}

void connectib_pddr_reg_dump(const struct connectib_pddr_reg *ptr_struct, FILE* file)
{
	connectib_pddr_reg_print(ptr_struct, file, 0);
}

void connectib_mpcnt_reg_pack(const struct connectib_mpcnt_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->grp);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pcie_index);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clr);

	offset = 64;
	connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_pack(&(ptr_struct->counter_set), ptr_buff + offset/8);

}

void connectib_mpcnt_reg_unpack(struct connectib_mpcnt_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->grp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 8;
	ptr_struct->pcie_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->clr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_unpack(&(ptr_struct->counter_set), ptr_buff + offset/8);

}

void connectib_mpcnt_reg_print(const struct connectib_mpcnt_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mpcnt_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grp                  : " UH_FMT "\n", ptr_struct->grp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pcie_index           : " UH_FMT "\n", ptr_struct->pcie_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clr                  : " UH_FMT "\n", ptr_struct->clr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_set:\n");
	connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto_print(&(ptr_struct->counter_set), file, indent_level + 1);

}

int connectib_mpcnt_reg_size(void)
{
	 return 256;
}

void connectib_mpcnt_reg_dump(const struct connectib_mpcnt_reg *ptr_struct, FILE* file)
{
	connectib_mpcnt_reg_print(ptr_struct, file, 0);
}

void connectib_mcia_reg_pack(const struct connectib_mcia_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->status);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->module);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->l);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->device_address);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->page_number);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->i2c_device_address);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->size);

	offset = 66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->passwd_cap);

	offset = 65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->passwd_clr);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->passwd_v);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->password);

	for (i = 0; i < 12; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 512, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword[i]);
	}

}

void connectib_mcia_reg_unpack(struct connectib_mcia_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->module = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->l = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->device_address = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 40;
	ptr_struct->page_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->i2c_device_address = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 80;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 66;
	ptr_struct->passwd_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 65;
	ptr_struct->passwd_clr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->passwd_v = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->password = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	for (i = 0; i < 12; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 512, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mcia_reg_print(const struct connectib_mcia_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcia_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status               : " UH_FMT "\n", ptr_struct->status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "module               : " UH_FMT "\n", ptr_struct->module);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l                    : " UH_FMT "\n", ptr_struct->l);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_address       : " UH_FMT "\n", ptr_struct->device_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "page_number          : " UH_FMT "\n", ptr_struct->page_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "i2c_device_address   : " UH_FMT "\n", ptr_struct->i2c_device_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "passwd_cap           : " UH_FMT "\n", ptr_struct->passwd_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "passwd_clr           : " UH_FMT "\n", ptr_struct->passwd_clr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "passwd_v             : " UH_FMT "\n", ptr_struct->passwd_v);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "password             : " U32H_FMT "\n", ptr_struct->password);

	for (i = 0; i < 12; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : " U32H_FMT "\n", i, ptr_struct->dword[i]);
	}

}

int connectib_mcia_reg_size(void)
{
	 return 64;
}

void connectib_mcia_reg_dump(const struct connectib_mcia_reg *ptr_struct, FILE* file)
{
	connectib_mcia_reg_print(ptr_struct, file, 0);
}

void connectib_ppad_reg_pack(const struct connectib_ppad_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->mac_47_32);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->single_base_mac);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mac_31_0);

}

void connectib_ppad_reg_unpack(struct connectib_ppad_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->mac_47_32 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->single_base_mac = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->mac_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_ppad_reg_print(const struct connectib_ppad_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ppad_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac_47_32            : " UH_FMT "\n", ptr_struct->mac_47_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "single_base_mac      : " UH_FMT "\n", ptr_struct->single_base_mac);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac_31_0             : " U32H_FMT "\n", ptr_struct->mac_31_0);

}

int connectib_ppad_reg_size(void)
{
	 return 16;
}

void connectib_ppad_reg_dump(const struct connectib_ppad_reg *ptr_struct, FILE* file)
{
	connectib_ppad_reg_print(ptr_struct, file, 0);
}

void connectib_pvlc_reg_pack(const struct connectib_pvlc_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vl_hw_cap);

	offset = 92;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vl_admin);

	offset = 124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vl_operational);

}

void connectib_pvlc_reg_unpack(struct connectib_pvlc_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 60;
	ptr_struct->vl_hw_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 92;
	ptr_struct->vl_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 124;
	ptr_struct->vl_operational = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_pvlc_reg_print(const struct connectib_pvlc_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pvlc_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl_hw_cap            : " UH_FMT "\n", ptr_struct->vl_hw_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl_admin             : " UH_FMT "\n", ptr_struct->vl_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl_operational       : " UH_FMT "\n", ptr_struct->vl_operational);

}

int connectib_pvlc_reg_size(void)
{
	 return 16;
}

void connectib_pvlc_reg_dump(const struct connectib_pvlc_reg *ptr_struct, FILE* file)
{
	connectib_pvlc_reg_print(ptr_struct, file, 0);
}

void connectib_ppcnt_reg_pack(const struct connectib_ppcnt_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->grp);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->pnat);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->swid);

	offset = 59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->prio_tc);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clr);

	offset = 64;
	connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_pack(&(ptr_struct->counter_set), ptr_buff + offset/8);

}

void connectib_ppcnt_reg_unpack(struct connectib_ppcnt_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->grp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 16;
	ptr_struct->pnat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->swid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 59;
	ptr_struct->prio_tc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 32;
	ptr_struct->clr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_unpack(&(ptr_struct->counter_set), ptr_buff + offset/8);

}

void connectib_ppcnt_reg_print(const struct connectib_ppcnt_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ppcnt_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grp                  : " UH_FMT "\n", ptr_struct->grp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pnat                 : " UH_FMT "\n", ptr_struct->pnat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swid                 : " UH_FMT "\n", ptr_struct->swid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio_tc              : " UH_FMT "\n", ptr_struct->prio_tc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clr                  : " UH_FMT "\n", ptr_struct->clr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_set:\n");
	connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_print(&(ptr_struct->counter_set), file, indent_level + 1);

}

int connectib_ppcnt_reg_size(void)
{
	 return 256;
}

void connectib_ppcnt_reg_dump(const struct connectib_ppcnt_reg *ptr_struct, FILE* file)
{
	connectib_ppcnt_reg_print(ptr_struct, file, 0);
}

void connectib_ptys_reg_pack(const struct connectib_ptys_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->proto_mask);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_tx_aba_param);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->an_disable_cap);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->an_disable_admin);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved_high);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->data_rate_oper);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->an_status);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_proto_capability);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->eth_proto_capability);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_proto_capability);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_link_width_capability);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_proto_admin);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->eth_proto_admin);

	offset = 240;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_proto_admin);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_link_width_admin);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->fc_proto_oper);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->eth_proto_oper);

	offset = 336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_proto_oper);

	offset = 320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->ib_link_width_oper);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->eth_proto_lp_advertise);

}

void connectib_ptys_reg_unpack(struct connectib_ptys_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	ptr_struct->proto_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 7;
	ptr_struct->force_tx_aba_param = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->an_disable_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->an_disable_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->reserved_high = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->data_rate_oper = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 32;
	ptr_struct->an_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->fc_proto_capability = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->eth_proto_capability = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 144;
	ptr_struct->ib_proto_capability = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 128;
	ptr_struct->ib_link_width_capability = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 160;
	ptr_struct->fc_proto_admin = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->eth_proto_admin = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 240;
	ptr_struct->ib_proto_admin = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 224;
	ptr_struct->ib_link_width_admin = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 256;
	ptr_struct->fc_proto_oper = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->eth_proto_oper = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 336;
	ptr_struct->ib_proto_oper = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 320;
	ptr_struct->ib_link_width_oper = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 384;
	ptr_struct->eth_proto_lp_advertise = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_ptys_reg_print(const struct connectib_ptys_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ptys_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "proto_mask           : %s (" UH_FMT ")\n", (ptr_struct->proto_mask == 1 ? ("InfiniBand") : ((ptr_struct->proto_mask == 2 ? ("FC") : ((ptr_struct->proto_mask == 4 ? ("Ethernet") : ("unknown")))))), ptr_struct->proto_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_tx_aba_param   : " UH_FMT "\n", ptr_struct->force_tx_aba_param);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "an_disable_cap       : " UH_FMT "\n", ptr_struct->an_disable_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "an_disable_admin     : " UH_FMT "\n", ptr_struct->an_disable_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved_high        : " UH_FMT "\n", ptr_struct->reserved_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_rate_oper       : " UH_FMT "\n", ptr_struct->data_rate_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "an_status            : " UH_FMT "\n", ptr_struct->an_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_proto_capability  : " U32H_FMT "\n", ptr_struct->fc_proto_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_proto_capability : " U32H_FMT "\n", ptr_struct->eth_proto_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_proto_capability  : " UH_FMT "\n", ptr_struct->ib_proto_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_link_width_capability : " UH_FMT "\n", ptr_struct->ib_link_width_capability);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_proto_admin       : " U32H_FMT "\n", ptr_struct->fc_proto_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_proto_admin      : " U32H_FMT "\n", ptr_struct->eth_proto_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_proto_admin       : " UH_FMT "\n", ptr_struct->ib_proto_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_link_width_admin  : " UH_FMT "\n", ptr_struct->ib_link_width_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_proto_oper        : " U32H_FMT "\n", ptr_struct->fc_proto_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_proto_oper       : " U32H_FMT "\n", ptr_struct->eth_proto_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_proto_oper        : " UH_FMT "\n", ptr_struct->ib_proto_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_link_width_oper   : " UH_FMT "\n", ptr_struct->ib_link_width_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_proto_lp_advertise : " U32H_FMT "\n", ptr_struct->eth_proto_lp_advertise);

}

int connectib_ptys_reg_size(void)
{
	 return 64;
}

void connectib_ptys_reg_dump(const struct connectib_ptys_reg *ptr_struct, FILE* file)
{
	connectib_ptys_reg_print(ptr_struct, file, 0);
}

void connectib_pmlp_reg_pack(const struct connectib_pmlp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->width);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rxtx);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lane0_module_mapping);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lane1_module_mapping);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lane2_module_mapping);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lane3_module_mapping);

}

void connectib_pmlp_reg_unpack(struct connectib_pmlp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->width = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->rxtx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->lane0_module_mapping = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->lane1_module_mapping = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->lane2_module_mapping = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->lane3_module_mapping = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pmlp_reg_print(const struct connectib_pmlp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmlp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "width                : " UH_FMT "\n", ptr_struct->width);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rxtx                 : " UH_FMT "\n", ptr_struct->rxtx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane0_module_mapping : " U32H_FMT "\n", ptr_struct->lane0_module_mapping);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane1_module_mapping : " U32H_FMT "\n", ptr_struct->lane1_module_mapping);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane2_module_mapping : " U32H_FMT "\n", ptr_struct->lane2_module_mapping);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lane3_module_mapping : " U32H_FMT "\n", ptr_struct->lane3_module_mapping);

}

int connectib_pmlp_reg_size(void)
{
	 return 64;
}

void connectib_pmlp_reg_dump(const struct connectib_pmlp_reg *ptr_struct, FILE* file)
{
	connectib_pmlp_reg_print(ptr_struct, file, 0);
}

void connectib_register_mfbe_pack(const struct connectib_register_mfbe *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_64kb_erase);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_32kb_erase);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

}

void connectib_register_mfbe_unpack(struct connectib_register_mfbe *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->bulk_64kb_erase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->bulk_32kb_erase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_register_mfbe_print(const struct connectib_register_mfbe *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfbe ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_64kb_erase      : " UH_FMT "\n", ptr_struct->bulk_64kb_erase);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_32kb_erase      : " UH_FMT "\n", ptr_struct->bulk_32kb_erase);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : " UH_FMT "\n", ptr_struct->address);

}

int connectib_register_mfbe_size(void)
{
	 return 12;
}

void connectib_register_mfbe_dump(const struct connectib_register_mfbe *ptr_struct, FILE* file)
{
	connectib_register_mfbe_print(ptr_struct, file, 0);
}

void connectib_register_mfba_pack(const struct connectib_register_mfba *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 9, (u_int32_t)ptr_struct->size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

	offset = 96;
	connectib_register_access_data_pack(&(ptr_struct->data), ptr_buff + offset/8);

}

void connectib_register_mfba_unpack(struct connectib_register_mfba *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 55;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 9);

	offset = 72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	connectib_register_access_data_unpack(&(ptr_struct->data), ptr_buff + offset/8);

}

void connectib_register_mfba_print(const struct connectib_register_mfba *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfba ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : " UH_FMT "\n", ptr_struct->address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data:\n");
	connectib_register_access_data_print(&(ptr_struct->data), file, indent_level + 1);

}

int connectib_register_mfba_size(void)
{
	 return 44;
}

void connectib_register_mfba_dump(const struct connectib_register_mfba *ptr_struct, FILE* file)
{
	connectib_register_mfba_print(ptr_struct, file, 0);
}

void connectib_register_mfpa_pack(const struct connectib_register_mfpa *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->boot_address);

	offset = 156;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->flash_num);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_64kb_erase_en);

	offset = 129;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bulk_32kb_erase_en);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wip);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->jedec_id);

	offset = 214;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->sector_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->block_allignment);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->capability_mask);

}

void connectib_register_mfpa_unpack(struct connectib_register_mfpa *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 40;
	ptr_struct->boot_address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 156;
	ptr_struct->flash_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 130;
	ptr_struct->bulk_64kb_erase_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 129;
	ptr_struct->bulk_32kb_erase_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 128;
	ptr_struct->wip = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->jedec_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 214;
	ptr_struct->sector_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset = 200;
	ptr_struct->block_allignment = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 224;
	ptr_struct->capability_mask = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_register_mfpa_print(const struct connectib_register_mfpa *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfpa ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : " UH_FMT "\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : " UH_FMT "\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "boot_address         : " UH_FMT "\n", ptr_struct->boot_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flash_num            : " UH_FMT "\n", ptr_struct->flash_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_64kb_erase_en   : " UH_FMT "\n", ptr_struct->bulk_64kb_erase_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk_32kb_erase_en   : " UH_FMT "\n", ptr_struct->bulk_32kb_erase_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wip                  : " UH_FMT "\n", ptr_struct->wip);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "jedec_id             : " UH_FMT "\n", ptr_struct->jedec_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sector_size          : " UH_FMT "\n", ptr_struct->sector_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "block_allignment     : " UH_FMT "\n", ptr_struct->block_allignment);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "capability_mask      : " U32H_FMT "\n", ptr_struct->capability_mask);

}

int connectib_register_mfpa_size(void)
{
	 return 32;
}

void connectib_register_mfpa_dump(const struct connectib_register_mfpa *ptr_struct, FILE* file)
{
	connectib_register_mfpa_print(ptr_struct, file, 0);
}

void connectib_db_threshold_register_layout_pack(const struct connectib_db_threshold_register_layout *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->threshold);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->size);

}

void connectib_db_threshold_register_layout_unpack(struct connectib_db_threshold_register_layout *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->threshold = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 48;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_db_threshold_register_layout_print(const struct connectib_db_threshold_register_layout *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_db_threshold_register_layout ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "threshold            : " UH_FMT "\n", ptr_struct->threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

}

int connectib_db_threshold_register_layout_size(void)
{
	 return 16;
}

void connectib_db_threshold_register_layout_dump(const struct connectib_db_threshold_register_layout *ptr_struct, FILE* file)
{
	connectib_db_threshold_register_layout_print(ptr_struct, file, 0);
}

void connectib_register_pplr_pack(const struct connectib_register_pplr *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->exl);

}

void connectib_register_pplr_unpack(struct connectib_register_pplr *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 61;
	ptr_struct->exl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_register_pplr_print(const struct connectib_register_pplr *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_pplr ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "exl                  : " UH_FMT "\n", ptr_struct->exl);

}

int connectib_register_pplr_size(void)
{
	 return 16;
}

void connectib_register_pplr_dump(const struct connectib_register_pplr *ptr_struct, FILE* file)
{
	connectib_register_pplr_print(ptr_struct, file, 0);
}

void connectib_register_host_endianness_pack(const struct connectib_register_host_endianness *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->he);

}

void connectib_register_host_endianness_unpack(struct connectib_register_host_endianness *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->he = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_register_host_endianness_print(const struct connectib_register_host_endianness *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_host_endianness ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "he                   : %s (" UH_FMT ")\n", (ptr_struct->he == 0 ? ("LITTLE_ENDIAN") : ((ptr_struct->he == 1 ? ("BIG_ENDIAN") : ("unknown")))), ptr_struct->he);

}

int connectib_register_host_endianness_size(void)
{
	 return 16;
}

void connectib_register_host_endianness_dump(const struct connectib_register_host_endianness *ptr_struct, FILE* file)
{
	connectib_register_host_endianness_print(ptr_struct, file, 0);
}

void connectib_register_fp_sl_map_pack(const struct connectib_register_fp_sl_map *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fp_sl_indication);

}

void connectib_register_fp_sl_map_unpack(struct connectib_register_fp_sl_map *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->fp_sl_indication = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_register_fp_sl_map_print(const struct connectib_register_fp_sl_map *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_fp_sl_map ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fp_sl_indication     : " UH_FMT "\n", ptr_struct->fp_sl_indication);

}

int connectib_register_fp_sl_map_size(void)
{
	 return 16;
}

void connectib_register_fp_sl_map_dump(const struct connectib_register_fp_sl_map *ptr_struct, FILE* file)
{
	connectib_register_fp_sl_map_print(ptr_struct, file, 0);
}

void connectib_register_power_settings_pack(const struct connectib_register_power_settings *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->power_settings_level);

}

void connectib_register_power_settings_unpack(struct connectib_register_power_settings *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->power_settings_level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_power_settings_print(const struct connectib_register_power_settings *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_power_settings ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "power_settings_level : " UH_FMT "\n", ptr_struct->power_settings_level);

}

int connectib_register_power_settings_size(void)
{
	 return 16;
}

void connectib_register_power_settings_dump(const struct connectib_register_power_settings *ptr_struct, FILE* file)
{
	connectib_register_power_settings_print(ptr_struct, file, 0);
}

void connectib_register_loopback_control_pack(const struct connectib_register_loopback_control *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_lb);

}

void connectib_register_loopback_control_unpack(struct connectib_register_loopback_control *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->no_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_register_loopback_control_print(const struct connectib_register_loopback_control *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_loopback_control ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : " UH_FMT "\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_lb                : " UH_FMT "\n", ptr_struct->no_lb);

}

int connectib_register_loopback_control_size(void)
{
	 return 16;
}

void connectib_register_loopback_control_dump(const struct connectib_register_loopback_control *ptr_struct, FILE* file)
{
	connectib_register_loopback_control_print(ptr_struct, file, 0);
}

void connectib_pfcc_reg_pack(const struct connectib_pfcc_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->shl_opr);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->shl_cap);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->pnat);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_remote_admin);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_local_admin);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dcbx_operation_type);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->prio_mask_rx);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->prio_mask_tx);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ppan);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cbftx);

	offset = 87;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fctx_disabled);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pfctx);

	offset = 65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aptx);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pptx);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cbfrx);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pfcrx);

	offset = 97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aprx);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pprx);

	offset = 144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->device_stall_critical_watermark);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->device_stall_minor_watermark);

}

void connectib_pfcc_reg_unpack(struct connectib_pfcc_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->shl_opr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->shl_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 16;
	ptr_struct->pnat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->cap_remote_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->cap_local_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->dcbx_operation_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 56;
	ptr_struct->prio_mask_rx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 40;
	ptr_struct->prio_mask_tx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->ppan = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 88;
	ptr_struct->cbftx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 87;
	ptr_struct->fctx_disabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 72;
	ptr_struct->pfctx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 65;
	ptr_struct->aptx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->pptx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 120;
	ptr_struct->cbfrx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->pfcrx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 97;
	ptr_struct->aprx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->pprx = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 144;
	ptr_struct->device_stall_critical_watermark = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 128;
	ptr_struct->device_stall_minor_watermark = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_pfcc_reg_print(const struct connectib_pfcc_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pfcc_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "shl_opr              : " UH_FMT "\n", ptr_struct->shl_opr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "shl_cap              : " UH_FMT "\n", ptr_struct->shl_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pnat                 : " UH_FMT "\n", ptr_struct->pnat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_remote_admin     : " UH_FMT "\n", ptr_struct->cap_remote_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_local_admin      : " UH_FMT "\n", ptr_struct->cap_local_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcbx_operation_type  : " UH_FMT "\n", ptr_struct->dcbx_operation_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio_mask_rx         : " UH_FMT "\n", ptr_struct->prio_mask_rx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio_mask_tx         : " UH_FMT "\n", ptr_struct->prio_mask_tx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ppan                 : %s (" UH_FMT ")\n", (ptr_struct->ppan == 0 ? ("disabled") : ((ptr_struct->ppan == 1 ? ("enabled") : ("unknown")))), ptr_struct->ppan);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cbftx                : " UH_FMT "\n", ptr_struct->cbftx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fctx_disabled        : " UH_FMT "\n", ptr_struct->fctx_disabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pfctx                : " UH_FMT "\n", ptr_struct->pfctx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aptx                 : " UH_FMT "\n", ptr_struct->aptx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pptx                 : " UH_FMT "\n", ptr_struct->pptx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cbfrx                : " UH_FMT "\n", ptr_struct->cbfrx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pfcrx                : " UH_FMT "\n", ptr_struct->pfcrx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aprx                 : " UH_FMT "\n", ptr_struct->aprx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pprx                 : " UH_FMT "\n", ptr_struct->pprx);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_critical_watermark : " UH_FMT "\n", ptr_struct->device_stall_critical_watermark);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_stall_minor_watermark : " UH_FMT "\n", ptr_struct->device_stall_minor_watermark);

}

int connectib_pfcc_reg_size(void)
{
	 return 32;
}

void connectib_pfcc_reg_dump(const struct connectib_pfcc_reg *ptr_struct, FILE* file)
{
	connectib_pfcc_reg_print(ptr_struct, file, 0);
}

void connectib_access_register_unit_port_capabilities_pack(const struct connectib_access_register_unit_port_capabilities *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->reserved_1);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->reserved_0);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_capabilities_127_96);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_capabilities_95_64);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_capabilities_63_32);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_capabilities_31_0);

}

void connectib_access_register_unit_port_capabilities_unpack(struct connectib_access_register_unit_port_capabilities *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->reserved_1 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 0;
	ptr_struct->reserved_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->port_capabilities_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->port_capabilities_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->port_capabilities_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->port_capabilities_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_access_register_unit_port_capabilities_print(const struct connectib_access_register_unit_port_capabilities *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_access_register_unit_port_capabilities ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved_1           : " UH_FMT "\n", ptr_struct->reserved_1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved_0           : " UH_FMT "\n", ptr_struct->reserved_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_capabilities_127_96 : " U32H_FMT "\n", ptr_struct->port_capabilities_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_capabilities_95_64 : " U32H_FMT "\n", ptr_struct->port_capabilities_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_capabilities_63_32 : " U32H_FMT "\n", ptr_struct->port_capabilities_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_capabilities_31_0 : " U32H_FMT "\n", ptr_struct->port_capabilities_31_0);

}

int connectib_access_register_unit_port_capabilities_size(void)
{
	 return 20;
}

void connectib_access_register_unit_port_capabilities_dump(const struct connectib_access_register_unit_port_capabilities *ptr_struct, FILE* file)
{
	connectib_access_register_unit_port_capabilities_print(ptr_struct, file, 0);
}

void connectib_register_unit_perf_counters_global_ctrl_pack(const struct connectib_register_unit_perf_counters_global_ctrl *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cmd);

}

void connectib_register_unit_perf_counters_global_ctrl_unpack(struct connectib_register_unit_perf_counters_global_ctrl *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_unit_perf_counters_global_ctrl_print(const struct connectib_register_unit_perf_counters_global_ctrl *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_unit_perf_counters_global_ctrl ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmd                  : " UH_FMT "\n", ptr_struct->cmd);

}

int connectib_register_unit_perf_counters_global_ctrl_size(void)
{
	 return 16;
}

void connectib_register_unit_perf_counters_global_ctrl_dump(const struct connectib_register_unit_perf_counters_global_ctrl *ptr_struct, FILE* file)
{
	connectib_register_unit_perf_counters_global_ctrl_print(ptr_struct, file, 0);
}

void connectib_access_register_unit_perf_counters_data_pack(const struct connectib_access_register_unit_perf_counters_data *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	connectib_access_register_unit_perf_counters_data_line_pack(&(ptr_struct->counter[i]), ptr_buff + offset/8);
	}

}

void connectib_access_register_unit_perf_counters_data_unpack(struct connectib_access_register_unit_perf_counters_data *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	connectib_access_register_unit_perf_counters_data_line_unpack(&(ptr_struct->counter[i]), ptr_buff + offset/8);
	}

}

void connectib_access_register_unit_perf_counters_data_print(const struct connectib_access_register_unit_perf_counters_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_access_register_unit_perf_counters_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_%03d:\n", i);
	connectib_access_register_unit_perf_counters_data_line_print(&(ptr_struct->counter[i]), file, indent_level + 1);
	}

}

int connectib_access_register_unit_perf_counters_data_size(void)
{
	 return 32;
}

void connectib_access_register_unit_perf_counters_data_dump(const struct connectib_access_register_unit_perf_counters_data *ptr_struct, FILE* file)
{
	connectib_access_register_unit_perf_counters_data_print(ptr_struct, file, 0);
}

void connectib_access_register_unit_perf_counters_cfg_pack(const struct connectib_access_register_unit_perf_counters_cfg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	connectib_access_register_unit_perf_counters_cfg_line_pack(&(ptr_struct->counter[i]), ptr_buff + offset/8);
	}

}

void connectib_access_register_unit_perf_counters_cfg_unpack(struct connectib_access_register_unit_perf_counters_cfg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	connectib_access_register_unit_perf_counters_cfg_line_unpack(&(ptr_struct->counter[i]), ptr_buff + offset/8);
	}

}

void connectib_access_register_unit_perf_counters_cfg_print(const struct connectib_access_register_unit_perf_counters_cfg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_access_register_unit_perf_counters_cfg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_%03d:\n", i);
	connectib_access_register_unit_perf_counters_cfg_line_print(&(ptr_struct->counter[i]), file, indent_level + 1);
	}

}

int connectib_access_register_unit_perf_counters_cfg_size(void)
{
	 return 32;
}

void connectib_access_register_unit_perf_counters_cfg_dump(const struct connectib_access_register_unit_perf_counters_cfg *ptr_struct, FILE* file)
{
	connectib_access_register_unit_perf_counters_cfg_print(ptr_struct, file, 0);
}

void connectib_register_set_node_pack(const struct connectib_register_set_node *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_node_description_pack(&(ptr_struct->node_description), ptr_buff + offset/8);

}

void connectib_register_set_node_unpack(struct connectib_register_set_node *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_node_description_unpack(&(ptr_struct->node_description), ptr_buff + offset/8);

}

void connectib_register_set_node_print(const struct connectib_register_set_node *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_set_node ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "node_description:\n");
	connectib_node_description_print(&(ptr_struct->node_description), file, indent_level + 1);

}

int connectib_register_set_node_size(void)
{
	 return 64;
}

void connectib_register_set_node_dump(const struct connectib_register_set_node *ptr_struct, FILE* file)
{
	connectib_register_set_node_print(ptr_struct, file, 0);
}

void connectib_dcbx_app_reg_pack(const struct connectib_dcbx_app_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

	offset = 58;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->num_app_prio);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	connectib_application_prio_entry_pack(&(ptr_struct->app_prio[i]), ptr_buff + offset/8);
	}

}

void connectib_dcbx_app_reg_unpack(struct connectib_dcbx_app_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 58;
	ptr_struct->num_app_prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	for (i = 0; i < 1; i++) {
	offset = adb2c_calc_array_field_address(128, 32, i, 160, 1);
	connectib_application_prio_entry_unpack(&(ptr_struct->app_prio[i]), ptr_buff + offset/8);
	}

}

void connectib_dcbx_app_reg_print(const struct connectib_dcbx_app_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dcbx_app_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : " UH_FMT "\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_app_prio         : " UH_FMT "\n", ptr_struct->num_app_prio);

	for (i = 0; i < 1; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "app_prio_%03d:\n", i);
	connectib_application_prio_entry_print(&(ptr_struct->app_prio[i]), file, indent_level + 1);
	}

}

int connectib_dcbx_app_reg_size(void)
{
	 return 20;
}

void connectib_dcbx_app_reg_dump(const struct connectib_dcbx_app_reg *ptr_struct, FILE* file)
{
	connectib_dcbx_app_reg_print(ptr_struct, file, 0);
}

void connectib_dcbx_param_reg_pack(const struct connectib_dcbx_param_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->max_application_table_size);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dcbx_standby_cap);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dcbx_ieee_cap);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dcbx_cee_cap);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->version_admin);

	offset = 53;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->version_oper);

	offset = 92;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_of_tc_admin);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_of_tc_oper);

	offset = 76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pfc_cap_admin);

	offset = 68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pfc_cap_oper);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->willing_admin);

	offset = 124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->remote_num_of_tc);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->remote_pfc_cap);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->remote_willing);

	offset = 152;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->error);

}

void connectib_dcbx_param_reg_unpack(struct connectib_dcbx_param_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 26;
	ptr_struct->max_application_table_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 8;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 2;
	ptr_struct->dcbx_standby_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 1;
	ptr_struct->dcbx_ieee_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->dcbx_cee_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 61;
	ptr_struct->version_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 53;
	ptr_struct->version_oper = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 92;
	ptr_struct->num_of_tc_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 84;
	ptr_struct->num_of_tc_oper = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 76;
	ptr_struct->pfc_cap_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 68;
	ptr_struct->pfc_cap_oper = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->willing_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 124;
	ptr_struct->remote_num_of_tc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 100;
	ptr_struct->remote_pfc_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->remote_willing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 152;
	ptr_struct->error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_dcbx_param_reg_print(const struct connectib_dcbx_param_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dcbx_param_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_application_table_size : " UH_FMT "\n", ptr_struct->max_application_table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : " UH_FMT "\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcbx_standby_cap     : " UH_FMT "\n", ptr_struct->dcbx_standby_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcbx_ieee_cap        : " UH_FMT "\n", ptr_struct->dcbx_ieee_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcbx_cee_cap         : " UH_FMT "\n", ptr_struct->dcbx_cee_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version_admin        : %s (" UH_FMT ")\n", (ptr_struct->version_admin == 0 ? ("disabled") : ((ptr_struct->version_admin == 1 ? ("CEE") : ((ptr_struct->version_admin == 2 ? ("IEEE") : ((ptr_struct->version_admin == 3 ? ("CEE_and_IEEE") : ("unknown")))))))), ptr_struct->version_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version_oper         : %s (" UH_FMT ")\n", (ptr_struct->version_oper == 0 ? ("disabled") : ((ptr_struct->version_oper == 1 ? ("CEE_enabled") : ((ptr_struct->version_oper == 2 ? ("IEEE_enabled") : ("unknown")))))), ptr_struct->version_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_of_tc_admin      : " UH_FMT "\n", ptr_struct->num_of_tc_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_of_tc_oper       : " UH_FMT "\n", ptr_struct->num_of_tc_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pfc_cap_admin        : " UH_FMT "\n", ptr_struct->pfc_cap_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pfc_cap_oper         : " UH_FMT "\n", ptr_struct->pfc_cap_oper);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "willing_admin        : %s (" UH_FMT ")\n", (ptr_struct->willing_admin == 0 ? ("non_willing") : ((ptr_struct->willing_admin == 1 ? ("willing") : ("unknown")))), ptr_struct->willing_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "remote_num_of_tc     : " UH_FMT "\n", ptr_struct->remote_num_of_tc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "remote_pfc_cap       : " UH_FMT "\n", ptr_struct->remote_pfc_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "remote_willing       : " UH_FMT "\n", ptr_struct->remote_willing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "error                : " UH_FMT "\n", ptr_struct->error);

}

int connectib_dcbx_param_reg_size(void)
{
	 return 64;
}

void connectib_dcbx_param_reg_dump(const struct connectib_dcbx_param_reg *ptr_struct, FILE* file)
{
	connectib_dcbx_param_reg_print(ptr_struct, file, 0);
}

void connectib_mlcr_pack(const struct connectib_mlcr *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->led_type);

	offset = 27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_local_or_uid_only);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->beacon_duration);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->beacon_remain);

}

void connectib_mlcr_unpack(struct connectib_mlcr *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->led_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 27;
	ptr_struct->cap_local_or_uid_only = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->beacon_duration = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 80;
	ptr_struct->beacon_remain = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_mlcr_print(const struct connectib_mlcr *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mlcr ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "led_type             : " UH_FMT "\n", ptr_struct->led_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_local_or_uid_only : " UH_FMT "\n", ptr_struct->cap_local_or_uid_only);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "beacon_duration      : " UH_FMT "\n", ptr_struct->beacon_duration);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "beacon_remain        : " UH_FMT "\n", ptr_struct->beacon_remain);

}

int connectib_mlcr_size(void)
{
	 return 12;
}

void connectib_mlcr_dump(const struct connectib_mlcr *ptr_struct, FILE* file)
{
	connectib_mlcr_print(ptr_struct, file, 0);
}

void connectib_qhll_pack(const struct connectib_qhll *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset = 59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->hll_time);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hll_mask);

	offset = 93;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->stall_cnt);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->stall_en);

}

void connectib_qhll_unpack(struct connectib_qhll *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 59;
	ptr_struct->hll_time = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 32;
	ptr_struct->hll_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 93;
	ptr_struct->stall_cnt = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 64;
	ptr_struct->stall_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_qhll_print(const struct connectib_qhll *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_qhll ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : " UH_FMT "\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hll_time             : " UH_FMT "\n", ptr_struct->hll_time);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hll_mask             : " UH_FMT "\n", ptr_struct->hll_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "stall_cnt            : " UH_FMT "\n", ptr_struct->stall_cnt);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "stall_en             : " UH_FMT "\n", ptr_struct->stall_en);

}

int connectib_qhll_size(void)
{
	 return 12;
}

void connectib_qhll_dump(const struct connectib_qhll *ptr_struct, FILE* file)
{
	connectib_qhll_print(ptr_struct, file, 0);
}

void connectib_qtct_reg_pack(const struct connectib_qtct_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->prio);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_remote_admin);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_local_admin);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->operation_type);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->tclass);

}

void connectib_qtct_reg_unpack(struct connectib_qtct_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 29;
	ptr_struct->prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 8;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->cap_remote_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->cap_local_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->operation_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 61;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_qtct_reg_print(const struct connectib_qtct_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_qtct_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio                 : " UH_FMT "\n", ptr_struct->prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : " UH_FMT "\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_remote_admin     : " UH_FMT "\n", ptr_struct->cap_remote_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_local_admin      : " UH_FMT "\n", ptr_struct->cap_local_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "operation_type       : %s (" UH_FMT ")\n", (ptr_struct->operation_type == 0 ? ("local_operative_parameters") : ((ptr_struct->operation_type == 1 ? ("local_admin_parameters") : ((ptr_struct->operation_type == 2 ? ("remote_admin_parameters") : ("unknown")))))), ptr_struct->operation_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : " UH_FMT "\n", ptr_struct->tclass);

}

int connectib_qtct_reg_size(void)
{
	 return 8;
}

void connectib_qtct_reg_dump(const struct connectib_qtct_reg *ptr_struct, FILE* file)
{
	connectib_qtct_reg_print(ptr_struct, file, 0);
}

void connectib_qpdp_reg_pack(const struct connectib_qpdp_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->pprio);

}

void connectib_qpdp_reg_unpack(struct connectib_qpdp_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 61;
	ptr_struct->pprio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_qpdp_reg_print(const struct connectib_qpdp_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_qpdp_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : " UH_FMT "\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pprio                : " UH_FMT "\n", ptr_struct->pprio);

}

int connectib_qpdp_reg_size(void)
{
	 return 8;
}

void connectib_qpdp_reg_dump(const struct connectib_qpdp_reg *ptr_struct, FILE* file)
{
	connectib_qpdp_reg_print(ptr_struct, file, 0);
}

void connectib_qetcr_reg_pack(const struct connectib_qetcr_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_remote_admin);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cap_local_admin);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->operation_type);

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(64, 64, i, 640, 1);
	connectib_tc_qos_configuration_pack(&(ptr_struct->tc[i]), ptr_buff + offset/8);
	}

	offset = 576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->global_configuration);

}

void connectib_qetcr_reg_unpack(struct connectib_qetcr_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->cap_remote_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->cap_local_admin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->operation_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(64, 64, i, 640, 1);
	connectib_tc_qos_configuration_unpack(&(ptr_struct->tc[i]), ptr_buff + offset/8);
	}

	offset = 576;
	ptr_struct->global_configuration = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_qetcr_reg_print(const struct connectib_qetcr_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_qetcr_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : " UH_FMT "\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_remote_admin     : " UH_FMT "\n", ptr_struct->cap_remote_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cap_local_admin      : " UH_FMT "\n", ptr_struct->cap_local_admin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "operation_type       : " UH_FMT "\n", ptr_struct->operation_type);

	for (i = 0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tc_%03d:\n", i);
	connectib_tc_qos_configuration_print(&(ptr_struct->tc[i]), file, indent_level + 1);
	}

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "global_configuration : " U64H_FMT "\n", ptr_struct->global_configuration);

}

int connectib_qetcr_reg_size(void)
{
	 return 80;
}

void connectib_qetcr_reg_dump(const struct connectib_qetcr_reg *ptr_struct, FILE* file)
{
	connectib_qetcr_reg_print(ptr_struct, file, 0);
}

void connectib_pcam_reg_pack(const struct connectib_pcam_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->access_reg_group);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->feature_group);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(64, 32, i, 640, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_access_reg_cap_mask[i]);
	}

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(320, 32, i, 640, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->feature_cap_mask[i]);
	}

}

void connectib_pcam_reg_unpack(struct connectib_pcam_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->access_reg_group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->feature_group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(64, 32, i, 640, 1);
	ptr_struct->port_access_reg_cap_mask[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(320, 32, i, 640, 1);
	ptr_struct->feature_cap_mask[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_pcam_reg_print(const struct connectib_pcam_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pcam_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "access_reg_group     : " UH_FMT "\n", ptr_struct->access_reg_group);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "feature_group        : " UH_FMT "\n", ptr_struct->feature_group);

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_access_reg_cap_mask_%03d : " U32H_FMT "\n", i, ptr_struct->port_access_reg_cap_mask[i]);
	}

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "feature_cap_mask_%03d : " U32H_FMT "\n", i, ptr_struct->feature_cap_mask[i]);
	}

}

int connectib_pcam_reg_size(void)
{
	 return 80;
}

void connectib_pcam_reg_dump(const struct connectib_pcam_reg *ptr_struct, FILE* file)
{
	connectib_pcam_reg_print(ptr_struct, file, 0);
}

void connectib_mcam_reg_pack(const struct connectib_mcam_reg *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->access_reg_group);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->feature_group);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(64, 32, i, 576, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mng_access_reg_cap_mask[i]);
	}

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(320, 32, i, 576, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mng_feature_cap_mask[i]);
	}

}

void connectib_mcam_reg_unpack(struct connectib_mcam_reg *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->access_reg_group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->feature_group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(64, 32, i, 576, 1);
	ptr_struct->mng_access_reg_cap_mask[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(320, 32, i, 576, 1);
	ptr_struct->mng_feature_cap_mask[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mcam_reg_print(const struct connectib_mcam_reg *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mcam_reg ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "access_reg_group     : " UH_FMT "\n", ptr_struct->access_reg_group);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "feature_group        : " UH_FMT "\n", ptr_struct->feature_group);

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mng_access_reg_cap_mask_%03d : " U32H_FMT "\n", i, ptr_struct->mng_access_reg_cap_mask[i]);
	}

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mng_feature_cap_mask_%03d : " U32H_FMT "\n", i, ptr_struct->mng_feature_cap_mask[i]);
	}

}

int connectib_mcam_reg_size(void)
{
	 return 72;
}

void connectib_mcam_reg_dump(const struct connectib_mcam_reg *ptr_struct, FILE* file)
{
	connectib_mcam_reg_print(ptr_struct, file, 0);
}

void connectib_ib_gid_pack(const struct connectib_ib_gid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword[i]);
	}

}

void connectib_ib_gid_unpack(struct connectib_ib_gid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 4; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 128, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_ib_gid_print(const struct connectib_ib_gid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ib_gid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : " U32H_FMT "\n", i, ptr_struct->dword[i]);
	}

}

int connectib_ib_gid_size(void)
{
	 return 16;
}

void connectib_ib_gid_dump(const struct connectib_ib_gid *ptr_struct, FILE* file)
{
	connectib_ib_gid_print(ptr_struct, file, 0);
}

void connectib_dmfs_encap_meta_pack(const struct connectib_dmfs_encap_meta *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->header_type);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->encap_size);

}

void connectib_dmfs_encap_meta_unpack(struct connectib_dmfs_encap_meta *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 61;
	ptr_struct->header_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 48;
	ptr_struct->encap_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

}

void connectib_dmfs_encap_meta_print(const struct connectib_dmfs_encap_meta *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_encap_meta ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "header_type          : " UH_FMT "\n", ptr_struct->header_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encap_size           : " UH_FMT "\n", ptr_struct->encap_size);

}

int connectib_dmfs_encap_meta_size(void)
{
	 return 8;
}

void connectib_dmfs_encap_meta_dump(const struct connectib_dmfs_encap_meta *ptr_struct, FILE* file)
{
	connectib_dmfs_encap_meta_print(ptr_struct, file, 0);
}

void connectib_flow_counter_fw_ctx_pack(const struct connectib_flow_counter_fw_ctx *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->src_gvmi);

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ft_type);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ft_type_valid);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mac);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->next_flow_counter);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->prev_flow_counter);

}

void connectib_flow_counter_fw_ctx_unpack(struct connectib_flow_counter_fw_ctx *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 48;
	ptr_struct->src_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 33;
	ptr_struct->ft_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 32;
	ptr_struct->ft_type_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->mac = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset = 128;
	ptr_struct->next_flow_counter = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->prev_flow_counter = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_flow_counter_fw_ctx_print(const struct connectib_flow_counter_fw_ctx *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flow_counter_fw_ctx ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "src_gvmi             : " UH_FMT "\n", ptr_struct->src_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_type              : " UH_FMT "\n", ptr_struct->ft_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_type_valid        : " UH_FMT "\n", ptr_struct->ft_type_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac                  : " U64H_FMT "\n", ptr_struct->mac);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_flow_counter    : " U32H_FMT "\n", ptr_struct->next_flow_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prev_flow_counter    : " U32H_FMT "\n", ptr_struct->prev_flow_counter);

}

int connectib_flow_counter_fw_ctx_size(void)
{
	 return 32;
}

void connectib_flow_counter_fw_ctx_dump(const struct connectib_flow_counter_fw_ctx *ptr_struct, FILE* file)
{
	connectib_flow_counter_fw_ctx_print(ptr_struct, file, 0);
}

void connectib_l2_table_entry_fw_ctx_pack(const struct connectib_l2_table_entry_fw_ctx *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_mac_address_layout_pack(&(ptr_struct->mac), ptr_buff + offset/8);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->vlan);

	offset = 83;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vlan_valid);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hw_rx_ix);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hw_sx_ix);

}

void connectib_l2_table_entry_fw_ctx_unpack(struct connectib_l2_table_entry_fw_ctx *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_mac_address_layout_unpack(&(ptr_struct->mac), ptr_buff + offset/8);

	offset = 84;
	ptr_struct->vlan = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset = 83;
	ptr_struct->vlan_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->hw_rx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->hw_sx_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_l2_table_entry_fw_ctx_print(const struct connectib_l2_table_entry_fw_ctx *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_l2_table_entry_fw_ctx ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mac:\n");
	connectib_mac_address_layout_print(&(ptr_struct->mac), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vlan                 : " UH_FMT "\n", ptr_struct->vlan);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vlan_valid           : " UH_FMT "\n", ptr_struct->vlan_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_rx_ix             : " U32H_FMT "\n", ptr_struct->hw_rx_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_sx_ix             : " U32H_FMT "\n", ptr_struct->hw_sx_ix);

}

int connectib_l2_table_entry_fw_ctx_size(void)
{
	 return 32;
}

void connectib_l2_table_entry_fw_ctx_dump(const struct connectib_l2_table_entry_fw_ctx *ptr_struct, FILE* file)
{
	connectib_l2_table_entry_fw_ctx_print(ptr_struct, file, 0);
}

void connectib_dmfs_fte_meta_pack(const struct connectib_dmfs_fte_meta *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->external_dest_vport);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->internal_dest_vport);

	offset = 29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uc_match_exists);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mc_match_exists);

	offset = 27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->src_port_ext_match_exists);

	offset = 26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fte_use_iterator);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->valid);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dest_iter_ix);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vst_dealloc_hash_ix);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vst_dealloc_ste_ix);

}

void connectib_dmfs_fte_meta_unpack(struct connectib_dmfs_fte_meta *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->external_dest_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->internal_dest_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 29;
	ptr_struct->uc_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->mc_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 27;
	ptr_struct->src_port_ext_match_exists = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 26;
	ptr_struct->fte_use_iterator = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->dest_iter_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->vst_dealloc_hash_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->vst_dealloc_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dmfs_fte_meta_print(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_fte_meta ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "external_dest_vport  : " UH_FMT "\n", ptr_struct->external_dest_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "internal_dest_vport  : " UH_FMT "\n", ptr_struct->internal_dest_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uc_match_exists      : " UH_FMT "\n", ptr_struct->uc_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mc_match_exists      : " UH_FMT "\n", ptr_struct->mc_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "src_port_ext_match_exists : " UH_FMT "\n", ptr_struct->src_port_ext_match_exists);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fte_use_iterator     : " UH_FMT "\n", ptr_struct->fte_use_iterator);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "valid                : " UH_FMT "\n", ptr_struct->valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dest_iter_ix         : " U32H_FMT "\n", ptr_struct->dest_iter_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vst_dealloc_hash_ix  : " U32H_FMT "\n", ptr_struct->vst_dealloc_hash_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vst_dealloc_ste_ix   : " U32H_FMT "\n", ptr_struct->vst_dealloc_ste_ix);

}

int connectib_dmfs_fte_meta_size(void)
{
	 return 64;
}

void connectib_dmfs_fte_meta_dump(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file)
{
	connectib_dmfs_fte_meta_print(ptr_struct, file, 0);
}

void connectib_dmfs_ft_meta_pack(const struct connectib_dmfs_ft_meta *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->log2_table_size);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->level);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ft_is_root);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->valid);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->total_ref_count);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_num);

	offset = 64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->prev_ft);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->next_ft);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->groups_list_head);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->groups_member_count);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ft_rx_head_ix);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ft_sx_head_ix);

	offset = 264;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_table_id);

	offset = 260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->table_miss_mode);

	offset = 258;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->lag_demux);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->decap_en);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->encap_en);

	offset = 304;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fgs_in_rx_hw_count);

	offset = 288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->fgs_in_sx_hw_count);

}

void connectib_dmfs_ft_meta_unpack(struct connectib_dmfs_ft_meta *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->log2_table_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 1;
	ptr_struct->ft_is_root = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->total_ref_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 32;
	ptr_struct->vport_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 64;
	ptr_struct->prev_ft = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 96;
	ptr_struct->next_ft = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->groups_list_head = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->groups_member_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->ft_rx_head_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->ft_sx_head_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 264;
	ptr_struct->next_table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 260;
	ptr_struct->table_miss_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 258;
	ptr_struct->lag_demux = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 257;
	ptr_struct->decap_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->encap_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 304;
	ptr_struct->fgs_in_rx_hw_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 288;
	ptr_struct->fgs_in_sx_hw_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_dmfs_ft_meta_print(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_ft_meta ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : " UH_FMT "\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_table_size      : " UH_FMT "\n", ptr_struct->log2_table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "level                : " UH_FMT "\n", ptr_struct->level);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_is_root           : " UH_FMT "\n", ptr_struct->ft_is_root);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "valid                : " UH_FMT "\n", ptr_struct->valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_ref_count      : " UH_FMT "\n", ptr_struct->total_ref_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_num            : " UH_FMT "\n", ptr_struct->vport_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prev_ft              : " U32H_FMT "\n", ptr_struct->prev_ft);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_ft              : " U32H_FMT "\n", ptr_struct->next_ft);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "groups_list_head     : " U32H_FMT "\n", ptr_struct->groups_list_head);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "groups_member_count  : " U32H_FMT "\n", ptr_struct->groups_member_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_rx_head_ix        : " U32H_FMT "\n", ptr_struct->ft_rx_head_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_sx_head_ix        : " U32H_FMT "\n", ptr_struct->ft_sx_head_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_table_id        : " UH_FMT "\n", ptr_struct->next_table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_miss_mode      : " UH_FMT "\n", ptr_struct->table_miss_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lag_demux            : " UH_FMT "\n", ptr_struct->lag_demux);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "decap_en             : " UH_FMT "\n", ptr_struct->decap_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encap_en             : " UH_FMT "\n", ptr_struct->encap_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fgs_in_rx_hw_count   : " UH_FMT "\n", ptr_struct->fgs_in_rx_hw_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fgs_in_sx_hw_count   : " UH_FMT "\n", ptr_struct->fgs_in_sx_hw_count);

}

int connectib_dmfs_ft_meta_size(void)
{
	 return 64;
}

void connectib_dmfs_ft_meta_dump(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file)
{
	connectib_dmfs_ft_meta_print(ptr_struct, file, 0);
}

void connectib_dmfs_fg_meta_pack(const struct connectib_dmfs_fg_meta *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->table_id);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->match_criteria_enable);

	offset = 87;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vlan_match_exist);

	offset = 86;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->in_rx_hw);

	offset = 85;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->in_sx_hw);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_num);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->start_flow_index);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->end_flow_index);

	offset = 160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->prev_group_id);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->next_group_id);

	offset = 224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vst_root_hash_meta_ix);

	offset = 256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_root_hash_meta_ix);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_root_hash_meta_ix);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_end_ste_ix);

	offset = 352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sx_end_ste_ix);

	offset = 384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->unused_ftes_in_rx_count);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->unused_ftes_in_sx_count);

}

void connectib_dmfs_fg_meta_unpack(struct connectib_dmfs_fg_meta *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 56;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 32;
	ptr_struct->table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 88;
	ptr_struct->match_criteria_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 87;
	ptr_struct->vlan_match_exist = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 86;
	ptr_struct->in_rx_hw = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 85;
	ptr_struct->in_sx_hw = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->vport_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 96;
	ptr_struct->start_flow_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 128;
	ptr_struct->end_flow_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 160;
	ptr_struct->prev_group_id = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 192;
	ptr_struct->next_group_id = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 224;
	ptr_struct->vst_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 256;
	ptr_struct->rx_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 288;
	ptr_struct->sx_root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	ptr_struct->rx_end_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 352;
	ptr_struct->sx_end_ste_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 384;
	ptr_struct->unused_ftes_in_rx_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 416;
	ptr_struct->unused_ftes_in_sx_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dmfs_fg_meta_print(const struct connectib_dmfs_fg_meta *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_fg_meta ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : " UH_FMT "\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_id             : " UH_FMT "\n", ptr_struct->table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "match_criteria_enable : " UH_FMT "\n", ptr_struct->match_criteria_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vlan_match_exist     : " UH_FMT "\n", ptr_struct->vlan_match_exist);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "in_rx_hw             : " UH_FMT "\n", ptr_struct->in_rx_hw);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "in_sx_hw             : " UH_FMT "\n", ptr_struct->in_sx_hw);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_num            : " UH_FMT "\n", ptr_struct->vport_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "start_flow_index     : " U32H_FMT "\n", ptr_struct->start_flow_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "end_flow_index       : " U32H_FMT "\n", ptr_struct->end_flow_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prev_group_id        : " U32H_FMT "\n", ptr_struct->prev_group_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_group_id        : " U32H_FMT "\n", ptr_struct->next_group_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vst_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->vst_root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->rx_root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_root_hash_meta_ix : " U32H_FMT "\n", ptr_struct->sx_root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_end_ste_ix        : " U32H_FMT "\n", ptr_struct->rx_end_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_end_ste_ix        : " U32H_FMT "\n", ptr_struct->sx_end_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unused_ftes_in_rx_count : " U32H_FMT "\n", ptr_struct->unused_ftes_in_rx_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unused_ftes_in_sx_count : " U32H_FMT "\n", ptr_struct->unused_ftes_in_sx_count);

}

int connectib_dmfs_fg_meta_size(void)
{
	 return 64;
}

void connectib_dmfs_fg_meta_dump(const struct connectib_dmfs_fg_meta *ptr_struct, FILE* file)
{
	connectib_dmfs_fg_meta_print(ptr_struct, file, 0);
}

void connectib_mkey_dump_pack(const struct connectib_mkey_dump *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ready_4_dump);

}

void connectib_mkey_dump_unpack(struct connectib_mkey_dump *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->ready_4_dump = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_mkey_dump_print(const struct connectib_mkey_dump *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mkey_dump ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ready_4_dump         : " UH_FMT "\n", ptr_struct->ready_4_dump);

}

int connectib_mkey_dump_size(void)
{
	 return 4;
}

void connectib_mkey_dump_dump(const struct connectib_mkey_dump *ptr_struct, FILE* file)
{
	connectib_mkey_dump_print(ptr_struct, file, 0);
}

void connectib_fw_tis_pack(const struct connectib_fw_tis *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lag_tx_port_affinity);

	offset = 59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->strict_lag_tx_port_affinity);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->prio);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->sqn_head);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->transport_domain);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->underlay_qpn);

}

void connectib_fw_tis_unpack(struct connectib_fw_tis *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 60;
	ptr_struct->lag_tx_port_affinity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 59;
	ptr_struct->strict_lag_tx_port_affinity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->sqn_head = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 104;
	ptr_struct->transport_domain = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 136;
	ptr_struct->underlay_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_fw_tis_print(const struct connectib_fw_tis *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_tis ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lag_tx_port_affinity : " UH_FMT "\n", ptr_struct->lag_tx_port_affinity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "strict_lag_tx_port_affinity : " UH_FMT "\n", ptr_struct->strict_lag_tx_port_affinity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio                 : " UH_FMT "\n", ptr_struct->prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn_head             : " UH_FMT "\n", ptr_struct->sqn_head);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transport_domain     : " UH_FMT "\n", ptr_struct->transport_domain);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "underlay_qpn         : " UH_FMT "\n", ptr_struct->underlay_qpn);

}

int connectib_fw_tis_size(void)
{
	 return 64;
}

void connectib_fw_tis_dump(const struct connectib_fw_tis *ptr_struct, FILE* file)
{
	connectib_fw_tis_print(ptr_struct, file, 0);
}

void connectib_fw_tir_pack(const struct connectib_fw_tir *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->inline_rqn);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disp_type);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->lro_max_ip_payload_size);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lro_enable_mask);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->lro_timeout_period_usecs);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rqt_number);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_hash_fn);

	offset = 99;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tunneled_offload_en);

	offset = 97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_hash_symmetric);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->steering_start_pipe);

	offset = 128;
	connectib_rx_hash_field_select_pack(&(ptr_struct->rx_hash_field_selector_outer), ptr_buff + offset/8);

	offset = 160;
	connectib_rx_hash_field_select_pack(&(ptr_struct->rx_hash_field_selector_inner), ptr_buff + offset/8);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->transport_domain);

	offset = 198;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->self_lb_block);

	offset = 384;
	connectib_tir_dmfs_pack(&(ptr_struct->dmfs), ptr_buff + offset/8);

}

void connectib_fw_tir_unpack(struct connectib_fw_tir *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 40;
	ptr_struct->inline_rqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 36;
	ptr_struct->disp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 88;
	ptr_struct->lro_max_ip_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 84;
	ptr_struct->lro_enable_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 64;
	ptr_struct->lro_timeout_period_usecs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 104;
	ptr_struct->rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 100;
	ptr_struct->rx_hash_fn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 99;
	ptr_struct->tunneled_offload_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 97;
	ptr_struct->rx_hash_symmetric = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 96;
	ptr_struct->steering_start_pipe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 128;
	connectib_rx_hash_field_select_unpack(&(ptr_struct->rx_hash_field_selector_outer), ptr_buff + offset/8);

	offset = 160;
	connectib_rx_hash_field_select_unpack(&(ptr_struct->rx_hash_field_selector_inner), ptr_buff + offset/8);

	offset = 200;
	ptr_struct->transport_domain = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 198;
	ptr_struct->self_lb_block = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 384;
	connectib_tir_dmfs_unpack(&(ptr_struct->dmfs), ptr_buff + offset/8);

}

void connectib_fw_tir_print(const struct connectib_fw_tir *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_tir ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_rqn           : " UH_FMT "\n", ptr_struct->inline_rqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disp_type            : " UH_FMT "\n", ptr_struct->disp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_max_ip_payload_size : " UH_FMT "\n", ptr_struct->lro_max_ip_payload_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_enable_mask      : " UH_FMT "\n", ptr_struct->lro_enable_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_timeout_period_usecs : " UH_FMT "\n", ptr_struct->lro_timeout_period_usecs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_number           : " UH_FMT "\n", ptr_struct->rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_fn           : " UH_FMT "\n", ptr_struct->rx_hash_fn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tunneled_offload_en  : " UH_FMT "\n", ptr_struct->tunneled_offload_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_symmetric    : " UH_FMT "\n", ptr_struct->rx_hash_symmetric);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_start_pipe  : " UH_FMT "\n", ptr_struct->steering_start_pipe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_field_selector_outer:\n");
	connectib_rx_hash_field_select_print(&(ptr_struct->rx_hash_field_selector_outer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_field_selector_inner:\n");
	connectib_rx_hash_field_select_print(&(ptr_struct->rx_hash_field_selector_inner), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transport_domain     : " UH_FMT "\n", ptr_struct->transport_domain);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "self_lb_block        : " UH_FMT "\n", ptr_struct->self_lb_block);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dmfs:\n");
	connectib_tir_dmfs_print(&(ptr_struct->dmfs), file, indent_level + 1);

}

int connectib_fw_tir_size(void)
{
	 return 64;
}

void connectib_fw_tir_dump(const struct connectib_fw_tir *ptr_struct, FILE* file)
{
	connectib_fw_tir_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_pack(const struct connectib_fw_qpc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sw_st);

	offset = 53;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->sw_rwq_type);

	offset = 52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_sq);

	offset = 50;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->sw_rq_type);

	offset = 49;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_dual_write);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ack_fence_req);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ack_slice_to_fence);

	offset = 37;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->min_wqe_inline_mode);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->allow_multi_pkt_send_wqe);

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_connected_to_nvme_xrq);

	offset = 91;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->sw_timer_granularity);

	offset = 86;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->current_timer_granularity);

	offset = 85;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->one_side_flush);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->apm_path_validation_failed);

	offset = 83;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_slave_send);

	offset = 82;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_slave_receive);

	offset = 81;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_master);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sqd_on_sigerr);

	offset = 76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl_diff_new_sl);

	offset = 73;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->fw_max_read_atomic);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->hca_sq_owner);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cmdif_entry_ix);

	offset = 96;
	connectib_fw_qpc_ts_special_pack(&(ptr_struct->fw_qpc_ts_special), ptr_buff + offset/8);

	offset = 128;
	connectib_fw_qpc_q_pack(&(ptr_struct->responder), ptr_buff + offset/8);

	offset = 256;
	connectib_fw_qpc_q_pack(&(ptr_struct->requestor), ptr_buff + offset/8);

	offset = 384;
	connectib_fw_qpc_special_pack(&(ptr_struct->fw_qpc_special), ptr_buff + offset/8);

}

void connectib_fw_qpc_unpack(struct connectib_fw_qpc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 56;
	ptr_struct->sw_st = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 53;
	ptr_struct->sw_rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 52;
	ptr_struct->no_sq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 50;
	ptr_struct->sw_rq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 49;
	ptr_struct->qp_dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->ack_fence_req = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 40;
	ptr_struct->ack_slice_to_fence = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 37;
	ptr_struct->min_wqe_inline_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 36;
	ptr_struct->allow_multi_pkt_send_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 35;
	ptr_struct->is_connected_to_nvme_xrq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 91;
	ptr_struct->sw_timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 86;
	ptr_struct->current_timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 85;
	ptr_struct->one_side_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 84;
	ptr_struct->apm_path_validation_failed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 83;
	ptr_struct->cd_slave_send = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 82;
	ptr_struct->cd_slave_receive = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 81;
	ptr_struct->cd_master = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 80;
	ptr_struct->sqd_on_sigerr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 76;
	ptr_struct->sl_diff_new_sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 73;
	ptr_struct->fw_max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 72;
	ptr_struct->hca_sq_owner = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 64;
	ptr_struct->cmdif_entry_ix = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 96;
	connectib_fw_qpc_ts_special_unpack(&(ptr_struct->fw_qpc_ts_special), ptr_buff + offset/8);

	offset = 128;
	connectib_fw_qpc_q_unpack(&(ptr_struct->responder), ptr_buff + offset/8);

	offset = 256;
	connectib_fw_qpc_q_unpack(&(ptr_struct->requestor), ptr_buff + offset/8);

	offset = 384;
	connectib_fw_qpc_special_unpack(&(ptr_struct->fw_qpc_special), ptr_buff + offset/8);

}

void connectib_fw_qpc_print(const struct connectib_fw_qpc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_st                : " UH_FMT "\n", ptr_struct->sw_st);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_rwq_type          : " UH_FMT "\n", ptr_struct->sw_rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_sq                : " UH_FMT "\n", ptr_struct->no_sq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_rq_type           : " UH_FMT "\n", ptr_struct->sw_rq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_dual_write        : " UH_FMT "\n", ptr_struct->qp_dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_fence_req        : " UH_FMT "\n", ptr_struct->ack_fence_req);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_slice_to_fence   : " UH_FMT "\n", ptr_struct->ack_slice_to_fence);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "min_wqe_inline_mode  : " UH_FMT "\n", ptr_struct->min_wqe_inline_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "allow_multi_pkt_send_wqe : " UH_FMT "\n", ptr_struct->allow_multi_pkt_send_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_connected_to_nvme_xrq : " UH_FMT "\n", ptr_struct->is_connected_to_nvme_xrq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_timer_granularity : " UH_FMT "\n", ptr_struct->sw_timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "current_timer_granularity : " UH_FMT "\n", ptr_struct->current_timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "one_side_flush       : " UH_FMT "\n", ptr_struct->one_side_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "apm_path_validation_failed : " UH_FMT "\n", ptr_struct->apm_path_validation_failed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_slave_send        : " UH_FMT "\n", ptr_struct->cd_slave_send);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_slave_receive     : " UH_FMT "\n", ptr_struct->cd_slave_receive);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_master            : " UH_FMT "\n", ptr_struct->cd_master);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqd_on_sigerr        : " UH_FMT "\n", ptr_struct->sqd_on_sigerr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl_diff_new_sl       : " UH_FMT "\n", ptr_struct->sl_diff_new_sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_max_read_atomic   : " UH_FMT "\n", ptr_struct->fw_max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hca_sq_owner         : " UH_FMT "\n", ptr_struct->hca_sq_owner);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmdif_entry_ix       : " UH_FMT "\n", ptr_struct->cmdif_entry_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_ts_special:\n");
	connectib_fw_qpc_ts_special_print(&(ptr_struct->fw_qpc_ts_special), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder:\n");
	connectib_fw_qpc_q_print(&(ptr_struct->responder), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "requestor:\n");
	connectib_fw_qpc_q_print(&(ptr_struct->requestor), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_special:\n");
	connectib_fw_qpc_special_print(&(ptr_struct->fw_qpc_special), file, indent_level + 1);

}

int connectib_fw_qpc_size(void)
{
	 return 64;
}

void connectib_fw_qpc_dump(const struct connectib_fw_qpc *ptr_struct, FILE* file)
{
	connectib_fw_qpc_print(ptr_struct, file, 0);
}

void connectib_fw_srqc_pack(const struct connectib_fw_srqc *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->catas_event_generated);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->basic_cyclic_rcv_wqe);

	offset = 61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invalid_user_index);

	offset = 60;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->end_padding_mode);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->trap_reason);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->trap_data);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->no_lro_qpn);

	offset = 128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->memory_rq_state);

	offset = 256;
	connectib_fw_xrqc_pack(&(ptr_struct->xrq), ptr_buff + offset/8);

}

void connectib_fw_srqc_unpack(struct connectib_fw_srqc *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset = 63;
	ptr_struct->catas_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 62;
	ptr_struct->basic_cyclic_rcv_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 61;
	ptr_struct->invalid_user_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 60;
	ptr_struct->end_padding_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->trap_reason = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->trap_data = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 136;
	ptr_struct->no_lro_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 128;
	ptr_struct->memory_rq_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 256;
	connectib_fw_xrqc_unpack(&(ptr_struct->xrq), ptr_buff + offset/8);

}

void connectib_fw_srqc_print(const struct connectib_fw_srqc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_srqc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "catas_event_generated : " UH_FMT "\n", ptr_struct->catas_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "basic_cyclic_rcv_wqe : " UH_FMT "\n", ptr_struct->basic_cyclic_rcv_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invalid_user_index   : " UH_FMT "\n", ptr_struct->invalid_user_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "end_padding_mode     : " UH_FMT "\n", ptr_struct->end_padding_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_reason          : %s (" UH_FMT ")\n", (ptr_struct->trap_reason == 1 ? ("NOP") : ((ptr_struct->trap_reason == 2 ? ("SET_LIMIT") : ("unknown")))), ptr_struct->trap_reason);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_data            : " UH_FMT "\n", ptr_struct->trap_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_lro_qpn           : " UH_FMT "\n", ptr_struct->no_lro_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_rq_state      : " UH_FMT "\n", ptr_struct->memory_rq_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xrq:\n");
	connectib_fw_xrqc_print(&(ptr_struct->xrq), file, indent_level + 1);

}

int connectib_fw_srqc_size(void)
{
	 return 64;
}

void connectib_fw_srqc_dump(const struct connectib_fw_srqc *ptr_struct, FILE* file)
{
	connectib_fw_srqc_print(ptr_struct, file, 0);
}

void connectib_sw_ads_pack(const struct connectib_sw_ads *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey_index);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->free_ar);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fl);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rlid);

	offset = 41;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->mlid);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset = 88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset = 84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->stat_rate);

	offset = 80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->log_rtm);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->src_addr_index);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->ack_timeout);

	offset = 108;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset = 100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(152, 8, i, 352, 1);
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rgid_rip[i]);
	}

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->udp_sport);

	offset = 266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->dscp);

	offset = 264;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->ecn);

	offset = 263;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_eth_prio);

	offset = 261;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_ecn);

	offset = 260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_dscp);

	offset = 304;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rmac_47_32);

	offset = 296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset = 292;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset = 289;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->eth_prio);

	offset = 288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dei_cfi_reserved_from_prm_041);

	offset = 320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rmac_31_0);

}

void connectib_sw_ads_unpack(struct connectib_sw_ads *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->pkey_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 1;
	ptr_struct->free_ar = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->fl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 48;
	ptr_struct->rlid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 41;
	ptr_struct->mlid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset = 40;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 88;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 84;
	ptr_struct->stat_rate = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 80;
	ptr_struct->log_rtm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->src_addr_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 64;
	ptr_struct->ack_timeout = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 108;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset = 100;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	for (i = 0; i < 16; i++) {
	offset = adb2c_calc_array_field_address(152, 8, i, 352, 1);
	ptr_struct->rgid_rip[i] = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);
	}

	offset = 272;
	ptr_struct->udp_sport = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 266;
	ptr_struct->dscp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 264;
	ptr_struct->ecn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 263;
	ptr_struct->f_eth_prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 261;
	ptr_struct->f_ecn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 260;
	ptr_struct->f_dscp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 304;
	ptr_struct->rmac_47_32 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 296;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 292;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 289;
	ptr_struct->eth_prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset = 288;
	ptr_struct->dei_cfi_reserved_from_prm_041 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 320;
	ptr_struct->rmac_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_sw_ads_print(const struct connectib_sw_ads *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_ads ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_index           : " UH_FMT "\n", ptr_struct->pkey_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "free_ar              : " UH_FMT "\n", ptr_struct->free_ar);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fl                   : " UH_FMT "\n", ptr_struct->fl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rlid                 : " UH_FMT "\n", ptr_struct->rlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlid                 : " UH_FMT "\n", ptr_struct->mlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : " UH_FMT "\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : " UH_FMT "\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "stat_rate            : %s (" UH_FMT ")\n", (ptr_struct->stat_rate == 0 ? ("no_limit") : ((ptr_struct->stat_rate == 7 ? ("Gbps_2_5") : ((ptr_struct->stat_rate == 8 ? ("Gbps_10") : ((ptr_struct->stat_rate == 9 ? ("Gbps_30") : ((ptr_struct->stat_rate == 10 ? ("Gbps_5") : ((ptr_struct->stat_rate == 11 ? ("Gbps_20") : ((ptr_struct->stat_rate == 12 ? ("Gbps_40") : ((ptr_struct->stat_rate == 13 ? ("Gbps_60") : ((ptr_struct->stat_rate == 14 ? ("Gbps_80") : ((ptr_struct->stat_rate == 15 ? ("Gbps_120") : ("unknown")))))))))))))))))))), ptr_struct->stat_rate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_rtm              : " UH_FMT "\n", ptr_struct->log_rtm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "src_addr_index       : " UH_FMT "\n", ptr_struct->src_addr_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_timeout          : " UH_FMT "\n", ptr_struct->ack_timeout);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : " UH_FMT "\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : " UH_FMT "\n", ptr_struct->tclass);

	for (i = 0; i < 16; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rgid_rip_%03d        : " UH_FMT "\n", i, ptr_struct->rgid_rip[i]);
	}

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "udp_sport            : " UH_FMT "\n", ptr_struct->udp_sport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dscp                 : " UH_FMT "\n", ptr_struct->dscp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecn                  : " UH_FMT "\n", ptr_struct->ecn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_eth_prio           : " UH_FMT "\n", ptr_struct->f_eth_prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_ecn                : " UH_FMT "\n", ptr_struct->f_ecn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_dscp               : " UH_FMT "\n", ptr_struct->f_dscp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rmac_47_32           : " UH_FMT "\n", ptr_struct->rmac_47_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : " UH_FMT "\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : " UH_FMT "\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_prio             : " UH_FMT "\n", ptr_struct->eth_prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dei_cfi_reserved_from_prm_041 : " UH_FMT "\n", ptr_struct->dei_cfi_reserved_from_prm_041);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rmac_31_0            : " U32H_FMT "\n", ptr_struct->rmac_31_0);

}

int connectib_sw_ads_size(void)
{
	 return 44;
}

void connectib_sw_ads_dump(const struct connectib_sw_ads *ptr_struct, FILE* file)
{
	connectib_sw_ads_print(ptr_struct, file, 0);
}

void connectib_hw_msix_ext_context_pack(const struct connectib_hw_msix_ext_context *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mask_3_0);

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disable_3_0);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->need);

	offset = 76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->timestamp_51_32);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->min_wait);

	offset = 96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->timestamp_31_0);

}

void connectib_hw_msix_ext_context_unpack(struct connectib_hw_msix_ext_context *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->mask_3_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 24;
	ptr_struct->disable_3_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 23;
	ptr_struct->need = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 76;
	ptr_struct->timestamp_51_32 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset = 64;
	ptr_struct->min_wait = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset = 96;
	ptr_struct->timestamp_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_msix_ext_context_print(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_ext_context ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mask_3_0             : " UH_FMT "\n", ptr_struct->mask_3_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disable_3_0          : " UH_FMT "\n", ptr_struct->disable_3_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "need                 : " UH_FMT "\n", ptr_struct->need);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timestamp_51_32      : " UH_FMT "\n", ptr_struct->timestamp_51_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "min_wait             : " UH_FMT "\n", ptr_struct->min_wait);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timestamp_31_0       : " U32H_FMT "\n", ptr_struct->timestamp_31_0);

}

int connectib_hw_msix_ext_context_size(void)
{
	 return 16;
}

void connectib_hw_msix_ext_context_dump(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file)
{
	connectib_hw_msix_ext_context_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_pack(const struct connectib_hw_msix_context *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->addr_31_2_);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->addr_63_32_);

	offset = 64;
	connectib_hw_msix_context_data_pack(&(ptr_struct->data), ptr_buff + offset/8);

	offset = 127;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->spec_mask);

}

void connectib_hw_msix_context_unpack(struct connectib_hw_msix_context *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->addr_31_2_ = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

	offset = 32;
	ptr_struct->addr_63_32_ = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 64;
	connectib_hw_msix_context_data_unpack(&(ptr_struct->data), ptr_buff + offset/8);

	offset = 127;
	ptr_struct->spec_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_msix_context_print(const struct connectib_hw_msix_context *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_31_2_           : " UH_FMT "\n", ptr_struct->addr_31_2_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_63_32_          : " U32H_FMT "\n", ptr_struct->addr_63_32_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data:\n");
	connectib_hw_msix_context_data_print(&(ptr_struct->data), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "spec_mask            : " UH_FMT "\n", ptr_struct->spec_mask);

}

int connectib_hw_msix_context_size(void)
{
	 return 16;
}

void connectib_hw_msix_context_dump(const struct connectib_hw_msix_context *ptr_struct, FILE* file)
{
	connectib_hw_msix_context_print(ptr_struct, file, 0);
}

void connectib_hw_rdb_atomic_data_pack(const struct connectib_hw_rdb_atomic_data *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->atomic_data[i]);
	}

}

void connectib_hw_rdb_atomic_data_unpack(struct connectib_hw_rdb_atomic_data *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i = 0; i < 8; i++) {
	offset = adb2c_calc_array_field_address(0, 32, i, 256, 1);
	ptr_struct->atomic_data[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_hw_rdb_atomic_data_print(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_rdb_atomic_data ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i = 0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_data_%03d     : " U32H_FMT "\n", i, ptr_struct->atomic_data[i]);
	}

}

int connectib_hw_rdb_atomic_data_size(void)
{
	 return 32;
}

void connectib_hw_rdb_atomic_data_dump(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file)
{
	connectib_hw_rdb_atomic_data_print(ptr_struct, file, 0);
}

void connectib_hw_mtt2_pack(const struct connectib_hw_mtt2 *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hi);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lo);

}

void connectib_hw_mtt2_unpack(struct connectib_hw_mtt2 *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 32;
	ptr_struct->lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_mtt2_print(const struct connectib_hw_mtt2 *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_mtt2 ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hi                   : " U32H_FMT "\n", ptr_struct->hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lo                   : " U32H_FMT "\n", ptr_struct->lo);

}

int connectib_hw_mtt2_size(void)
{
	 return 8;
}

void connectib_hw_mtt2_dump(const struct connectib_hw_mtt2 *ptr_struct, FILE* file)
{
	connectib_hw_mtt2_print(ptr_struct, file, 0);
}

void connectib_hw_mtt_pack(const struct connectib_hw_mtt *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->pas_63_32);

	offset = 63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rd_en);

	offset = 62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wr_en);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 29, (u_int32_t)ptr_struct->pas_31_3);

}

void connectib_hw_mtt_unpack(struct connectib_hw_mtt *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->pas_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 63;
	ptr_struct->rd_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 62;
	ptr_struct->wr_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->pas_31_3 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 29);

}

void connectib_hw_mtt_print(const struct connectib_hw_mtt *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_mtt ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_63_32            : " U32H_FMT "\n", ptr_struct->pas_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rd_en                : " UH_FMT "\n", ptr_struct->rd_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wr_en                : " UH_FMT "\n", ptr_struct->wr_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_31_3             : " UH_FMT "\n", ptr_struct->pas_31_3);

}

int connectib_hw_mtt_size(void)
{
	 return 8;
}

void connectib_hw_mtt_dump(const struct connectib_hw_mtt *ptr_struct, FILE* file)
{
	connectib_hw_mtt_print(ptr_struct, file, 0);
}

void connectib_steering_qp_list_pack(const struct connectib_steering_qp_list *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry0), ptr_buff + offset/8);

	offset = 32;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry1), ptr_buff + offset/8);

	offset = 64;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry2), ptr_buff + offset/8);

	offset = 96;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry3), ptr_buff + offset/8);

	offset = 128;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry4), ptr_buff + offset/8);

	offset = 160;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry5), ptr_buff + offset/8);

	offset = 192;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry6), ptr_buff + offset/8);

	offset = 224;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry7), ptr_buff + offset/8);

	offset = 256;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry8), ptr_buff + offset/8);

	offset = 288;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry9), ptr_buff + offset/8);

	offset = 320;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry10), ptr_buff + offset/8);

	offset = 352;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry11), ptr_buff + offset/8);

	offset = 384;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry12), ptr_buff + offset/8);

	offset = 416;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry13), ptr_buff + offset/8);

	offset = 448;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry14), ptr_buff + offset/8);

	offset = 480;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry15), ptr_buff + offset/8);

}

void connectib_steering_qp_list_unpack(struct connectib_steering_qp_list *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry0), ptr_buff + offset/8);

	offset = 32;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry1), ptr_buff + offset/8);

	offset = 64;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry2), ptr_buff + offset/8);

	offset = 96;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry3), ptr_buff + offset/8);

	offset = 128;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry4), ptr_buff + offset/8);

	offset = 160;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry5), ptr_buff + offset/8);

	offset = 192;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry6), ptr_buff + offset/8);

	offset = 224;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry7), ptr_buff + offset/8);

	offset = 256;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry8), ptr_buff + offset/8);

	offset = 288;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry9), ptr_buff + offset/8);

	offset = 320;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry10), ptr_buff + offset/8);

	offset = 352;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry11), ptr_buff + offset/8);

	offset = 384;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry12), ptr_buff + offset/8);

	offset = 416;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry13), ptr_buff + offset/8);

	offset = 448;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry14), ptr_buff + offset/8);

	offset = 480;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry15), ptr_buff + offset/8);

}

void connectib_steering_qp_list_print(const struct connectib_steering_qp_list *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_steering_qp_list ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry0:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry0), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry1:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry1), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry2:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry2), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry3:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry3), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry4:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry4), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry5:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry5), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry6:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry6), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry7:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry7), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry8:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry8), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry9:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry9), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry10:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry10), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry11:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry11), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry12:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry12), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry13:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry13), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry14:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry14), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry15:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry15), file, indent_level + 1);

}

int connectib_steering_qp_list_size(void)
{
	 return 64;
}

void connectib_steering_qp_list_dump(const struct connectib_steering_qp_list *ptr_struct, FILE* file)
{
	connectib_steering_qp_list_print(ptr_struct, file, 0);
}

void connectib_hw_ste_pack(const struct connectib_hw_ste *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->member_count);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_packet_qp);

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_fw_int);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rx_cmd);

	offset = 56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pport_byte_counters_trigger);

	offset = 48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pport_packet_counters_trigger);

	offset = 44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vport_byte_counters_trigger);

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vport_packet_counters_trigger);

	offset = 37;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_sniffer);

	offset = 36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_func_lb);

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_wire);

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_fw_int);

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->sx_cmd);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->fw_id);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_lookup_type);

	offset = 120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hit_lookup_type_hash_field_mask);

	offset = 114;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log2_hit_entry_size);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->gvmi);

	offset = 128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->hit_base_address_63_32);

	offset = 184;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hit_lookup_type);

	offset = 160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->hit_base_address_31_8);

	offset = 192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->miss_address_63_32);

	offset = 250;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log2_hit_table_size);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 26, (u_int32_t)ptr_struct->miss_address_31_6);

	offset = 256;
	connectib_hw_ste_tag_pack(&(ptr_struct->tag_data), ptr_buff + offset/8);

	offset = 384;
	connectib_hw_ste_tag_pack(&(ptr_struct->tag_mask), ptr_buff + offset/8);

}

void connectib_hw_ste_unpack(struct connectib_hw_ste *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 8;
	ptr_struct->member_count = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 3;
	ptr_struct->rx_packet_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 2;
	ptr_struct->rx_fw_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->rx_cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 56;
	ptr_struct->pport_byte_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 48;
	ptr_struct->pport_packet_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 44;
	ptr_struct->vport_byte_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 40;
	ptr_struct->vport_packet_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset = 37;
	ptr_struct->sx_sniffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 36;
	ptr_struct->sx_func_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 35;
	ptr_struct->sx_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 34;
	ptr_struct->sx_fw_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 32;
	ptr_struct->sx_cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 72;
	ptr_struct->fw_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->my_lookup_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 120;
	ptr_struct->hit_lookup_type_hash_field_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 114;
	ptr_struct->log2_hit_entry_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 96;
	ptr_struct->gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 128;
	ptr_struct->hit_base_address_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 184;
	ptr_struct->hit_lookup_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 160;
	ptr_struct->hit_base_address_31_8 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->miss_address_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 250;
	ptr_struct->log2_hit_table_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset = 224;
	ptr_struct->miss_address_31_6 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 26);

	offset = 256;
	connectib_hw_ste_tag_unpack(&(ptr_struct->tag_data), ptr_buff + offset/8);

	offset = 384;
	connectib_hw_ste_tag_unpack(&(ptr_struct->tag_mask), ptr_buff + offset/8);

}

void connectib_hw_ste_print(const struct connectib_hw_ste *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "member_count         : " UH_FMT "\n", ptr_struct->member_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_packet_qp         : " UH_FMT "\n", ptr_struct->rx_packet_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_fw_int            : " UH_FMT "\n", ptr_struct->rx_fw_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_cmd               : " UH_FMT "\n", ptr_struct->rx_cmd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pport_byte_counters_trigger : " UH_FMT "\n", ptr_struct->pport_byte_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pport_packet_counters_trigger : " UH_FMT "\n", ptr_struct->pport_packet_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_byte_counters_trigger : " UH_FMT "\n", ptr_struct->vport_byte_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_packet_counters_trigger : " UH_FMT "\n", ptr_struct->vport_packet_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_sniffer           : " UH_FMT "\n", ptr_struct->sx_sniffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_func_lb           : " UH_FMT "\n", ptr_struct->sx_func_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_wire              : " UH_FMT "\n", ptr_struct->sx_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_fw_int            : " UH_FMT "\n", ptr_struct->sx_fw_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_cmd               : " UH_FMT "\n", ptr_struct->sx_cmd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_id                : " UH_FMT "\n", ptr_struct->fw_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lookup_type       : " UH_FMT "\n", ptr_struct->my_lookup_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_lookup_type_hash_field_mask : " UH_FMT "\n", ptr_struct->hit_lookup_type_hash_field_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_hit_entry_size  : " UH_FMT "\n", ptr_struct->log2_hit_entry_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gvmi                 : " UH_FMT "\n", ptr_struct->gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_base_address_63_32 : " U32H_FMT "\n", ptr_struct->hit_base_address_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_lookup_type      : " UH_FMT "\n", ptr_struct->hit_lookup_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_base_address_31_8 : " UH_FMT "\n", ptr_struct->hit_base_address_31_8);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "miss_address_63_32   : " U32H_FMT "\n", ptr_struct->miss_address_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_hit_table_size  : " UH_FMT "\n", ptr_struct->log2_hit_table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "miss_address_31_6    : " UH_FMT "\n", ptr_struct->miss_address_31_6);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_data:\n");
	connectib_hw_ste_tag_print(&(ptr_struct->tag_data), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_mask:\n");
	connectib_hw_ste_tag_print(&(ptr_struct->tag_mask), file, indent_level + 1);

}

int connectib_hw_ste_size(void)
{
	 return 64;
}

void connectib_hw_ste_dump(const struct connectib_hw_ste *ptr_struct, FILE* file)
{
	connectib_hw_ste_print(ptr_struct, file, 0);
}

void connectib_hw_timer_pack(const struct connectib_hw_timer *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->timer_granularity);

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->timer_state);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->timer_valid);

}

void connectib_hw_timer_unpack(struct connectib_hw_timer *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	ptr_struct->timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset = 1;
	ptr_struct->timer_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 0;
	ptr_struct->timer_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_timer_print(const struct connectib_hw_timer *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_timer ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_granularity    : " UH_FMT "\n", ptr_struct->timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_state          : " UH_FMT "\n", ptr_struct->timer_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_valid          : " UH_FMT "\n", ptr_struct->timer_valid);

}

int connectib_hw_timer_size(void)
{
	 return 1;
}

void connectib_hw_timer_dump(const struct connectib_hw_timer *ptr_struct, FILE* file)
{
	connectib_hw_timer_print(ptr_struct, file, 0);
}

void connectib_sxdc_requestor_in_sq_pack(const struct connectib_sxdc_requestor_in_sq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_requestor_in_sq_unpack(struct connectib_sxdc_requestor_in_sq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 39;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_requestor_in_sq_print(const struct connectib_sxdc_requestor_in_sq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_requestor_in_sq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_requestor_in_sq_size(void)
{
	 return 8;
}

void connectib_sxdc_requestor_in_sq_dump(const struct connectib_sxdc_requestor_in_sq *ptr_struct, FILE* file)
{
	connectib_sxdc_requestor_in_sq_print(ptr_struct, file, 0);
}

void connectib_sxdc_responder_in_sq_pack(const struct connectib_sxdc_responder_in_sq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 38;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_responder_in_sq_unpack(struct connectib_sxdc_responder_in_sq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 38;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_responder_in_sq_print(const struct connectib_sxdc_responder_in_sq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_responder_in_sq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_responder_in_sq_size(void)
{
	 return 8;
}

void connectib_sxdc_responder_in_sq_dump(const struct connectib_sxdc_responder_in_sq *ptr_struct, FILE* file)
{
	connectib_sxdc_responder_in_sq_print(ptr_struct, file, 0);
}

void connectib_sxdc_scheduling_interrupt_pack(const struct connectib_sxdc_scheduling_interrupt *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 37;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_scheduling_interrupt_unpack(struct connectib_sxdc_scheduling_interrupt *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 37;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_scheduling_interrupt_print(const struct connectib_sxdc_scheduling_interrupt *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_scheduling_interrupt ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_scheduling_interrupt_size(void)
{
	 return 8;
}

void connectib_sxdc_scheduling_interrupt_dump(const struct connectib_sxdc_scheduling_interrupt *ptr_struct, FILE* file)
{
	connectib_sxdc_scheduling_interrupt_print(ptr_struct, file, 0);
}

void connectib_sxdc_doorbell_int_pack(const struct connectib_sxdc_doorbell_int *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_doorbell_int_unpack(struct connectib_sxdc_doorbell_int *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 35;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_doorbell_int_print(const struct connectib_sxdc_doorbell_int *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_doorbell_int ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_doorbell_int_size(void)
{
	 return 8;
}

void connectib_sxdc_doorbell_int_dump(const struct connectib_sxdc_doorbell_int *ptr_struct, FILE* file)
{
	connectib_sxdc_doorbell_int_print(ptr_struct, file, 0);
}

void connectib_sxdc_fast_path_pack(const struct connectib_sxdc_fast_path *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_fast_path_unpack(struct connectib_sxdc_fast_path *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 34;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_fast_path_print(const struct connectib_sxdc_fast_path *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_fast_path ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_fast_path_size(void)
{
	 return 8;
}

void connectib_sxdc_fast_path_dump(const struct connectib_sxdc_fast_path *ptr_struct, FILE* file)
{
	connectib_sxdc_fast_path_print(ptr_struct, file, 0);
}

void connectib_sxdc_external_db_en_pack(const struct connectib_sxdc_external_db_en *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_external_db_en_unpack(struct connectib_sxdc_external_db_en *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 33;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_external_db_en_print(const struct connectib_sxdc_external_db_en *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_external_db_en ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_external_db_en_size(void)
{
	 return 8;
}

void connectib_sxdc_external_db_en_dump(const struct connectib_sxdc_external_db_en *ptr_struct, FILE* file)
{
	connectib_sxdc_external_db_en_print(ptr_struct, file, 0);
}

void connectib_sxdc_valid_pack(const struct connectib_sxdc_valid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_valid_unpack(struct connectib_sxdc_valid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 32;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sxdc_valid_print(const struct connectib_sxdc_valid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_valid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_valid_size(void)
{
	 return 8;
}

void connectib_sxdc_valid_dump(const struct connectib_sxdc_valid *ptr_struct, FILE* file)
{
	connectib_sxdc_valid_print(ptr_struct, file, 0);
}

void connectib_sxdc_sq_pack(const struct connectib_sxdc_sq *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_sq_unpack(struct connectib_sxdc_sq *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_sxdc_sq_print(const struct connectib_sxdc_sq *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_sq ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_sq_size(void)
{
	 return 8;
}

void connectib_sxdc_sq_dump(const struct connectib_sxdc_sq *ptr_struct, FILE* file)
{
	connectib_sxdc_sq_print(ptr_struct, file, 0);
}

void connectib_sxdc_swqe_producer_index_pack(const struct connectib_sxdc_swqe_producer_index *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_swqe_producer_index_unpack(struct connectib_sxdc_swqe_producer_index *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->val = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_sxdc_swqe_producer_index_print(const struct connectib_sxdc_swqe_producer_index *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_swqe_producer_index ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_swqe_producer_index_size(void)
{
	 return 8;
}

void connectib_sxdc_swqe_producer_index_dump(const struct connectib_sxdc_swqe_producer_index *ptr_struct, FILE* file)
{
	connectib_sxdc_swqe_producer_index_print(ptr_struct, file, 0);
}

void connectib_sxdc_uar_pack(const struct connectib_sxdc_uar *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->val);

}

void connectib_sxdc_uar_unpack(struct connectib_sxdc_uar *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 40;
	ptr_struct->val = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_sxdc_uar_print(const struct connectib_sxdc_uar *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sxdc_uar ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_sxdc_uar_size(void)
{
	 return 8;
}

void connectib_sxdc_uar_dump(const struct connectib_sxdc_uar *ptr_struct, FILE* file)
{
	connectib_sxdc_uar_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_check_gen);

	offset = 22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_init);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->w_pad);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 23;
	ptr_struct->w_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 22;
	ptr_struct->w_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 20;
	ptr_struct->w_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_non_repeating_m_non_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : " UH_FMT "\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : " UH_FMT "\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : " UH_FMT "\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_check_gen          : " UH_FMT "\n", ptr_struct->w_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_init               : " UH_FMT "\n", ptr_struct->w_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_pad                : " UH_FMT "\n", ptr_struct->w_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset = 23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_check_gen);

	offset = 22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_init);

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->w_pad);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 23;
	ptr_struct->w_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 22;
	ptr_struct->w_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 20;
	ptr_struct->w_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_non_repeating_m_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : " UH_FMT "\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_check_gen          : " UH_FMT "\n", ptr_struct->w_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_init               : " UH_FMT "\n", ptr_struct->w_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_pad                : " UH_FMT "\n", ptr_struct->w_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_non_repeating_m_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_w_non_repeating_m_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_block_size_selector);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 16;
	ptr_struct->w_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_repeating_m_non_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : " UH_FMT "\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : " UH_FMT "\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : " UH_FMT "\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_block_size_selector : " UH_FMT "\n", ptr_struct->w_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_repeating_m_non_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_w_repeating_m_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_block_size_selector);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->w_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_repeating_m_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : " UH_FMT "\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_block_size_selector : " UH_FMT "\n", ptr_struct->w_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_repeating_m_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_w_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_w_repeating_m_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_same_block_non_repeating_pack(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset = 30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->copy_byte_mask);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_non_repeating_unpack(struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 16;
	ptr_struct->copy_byte_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_non_repeating_print(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_same_block_non_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : " UH_FMT "\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : " UH_FMT "\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : " UH_FMT "\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copy_byte_mask       : " UH_FMT "\n", ptr_struct->copy_byte_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_same_block_non_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_same_block_non_repeating_dump(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_same_block_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_same_block_repeating_pack(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->copy_byte_mask);

	offset = 8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset = 32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->raw_size);

	offset = 72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset = 64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset = 104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset = 96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset = 136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset = 135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset = 134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset = 131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset = 130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset = 168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset = 200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset = 192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset = 232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset = 224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset = 272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset = 257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset = 256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset = 288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->w_dif_ref_tag);

	offset = 320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset = 385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset = 384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset = 416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->m_dif_ref_tag);

	offset = 448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_repeating_unpack(struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 16;
	ptr_struct->copy_byte_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset = 32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset = 224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset = 272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset = 400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset = 385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset = 416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset = 448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_repeating_print(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_same_block_repeating ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : " UH_FMT "\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copy_byte_mask       : " UH_FMT "\n", ptr_struct->copy_byte_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : " UH_FMT "\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : " UH_FMT "\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : " UH_FMT "\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : " U32H_FMT "\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : " UH_FMT "\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : " UH_FMT "\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : " UH_FMT "\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : " UH_FMT "\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : " UH_FMT "\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : " UH_FMT "\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : " UH_FMT "\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : " UH_FMT "\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : " UH_FMT "\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : " UH_FMT "\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : " UH_FMT "\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : " UH_FMT "\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : " UH_FMT "\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : " UH_FMT "\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : " UH_FMT "\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : " UH_FMT "\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : " UH_FMT "\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : " U32H_FMT "\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_same_block_repeating_size(void)
{
	 return 64;
}

void connectib_hw_bsf_entry_same_block_repeating_dump(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file)
{
	connectib_hw_bsf_entry_same_block_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_dct_pack(const union connectib_hw_dct *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_dct_dc_access_key_63_32_pack(&(ptr_struct->dc_access_key_63_32), ptr_buff);
}

void connectib_hw_dct_unpack(union connectib_hw_dct *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_dct_dc_access_key_63_32_unpack(&(ptr_struct->dc_access_key_63_32), ptr_buff);
}

void connectib_hw_dct_print(const union connectib_hw_dct *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "complete_to_64B_eyald:\n");
	connectib_hw_dct_complete_to_64B_eyald_print(&(ptr_struct->complete_to_64B_eyald), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer:\n");
	connectib_hw_dct_rnr_timer_print(&(ptr_struct->rnr_timer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable:\n");
	connectib_hw_dct_write_enable_print(&(ptr_struct->write_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter:\n");
	connectib_hw_dct_inline_scatter_print(&(ptr_struct->inline_scatter), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size:\n");
	connectib_hw_dct_max_message_size_print(&(ptr_struct->max_message_size), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check:\n");
	connectib_hw_dct_ignore_pkey_check_print(&(ptr_struct->ignore_pkey_check), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable:\n");
	connectib_hw_dct_send_with_invalidate_enable_print(&(ptr_struct->send_with_invalidate_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable:\n");
	connectib_hw_dct_read_enable_print(&(ptr_struct->read_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu:\n");
	connectib_hw_dct_mtu_print(&(ptr_struct->mtu), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path:\n");
	connectib_hw_dct_fast_path_print(&(ptr_struct->fast_path), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_log_num_byte:\n");
	connectib_hw_dct_dc_access_key_log_num_byte_print(&(ptr_struct->dc_access_key_log_num_byte), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop:\n");
	connectib_hw_dct_tcu_drop_print(&(ptr_struct->tcu_drop), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap:\n");
	connectib_hw_dct_tcu_trap_print(&(ptr_struct->tcu_trap), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing:\n");
	connectib_hw_dct_adaptive_routing_print(&(ptr_struct->adaptive_routing), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number:\n");
	connectib_hw_dct_port_number_print(&(ptr_struct->port_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit:\n");
	connectib_hw_dct_grh_bit_print(&(ptr_struct->grh_bit), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label:\n");
	connectib_hw_dct_flow_label_print(&(ptr_struct->flow_label), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic:\n");
	connectib_hw_dct_max_read_atomic_print(&(ptr_struct->max_read_atomic), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid:\n");
	connectib_hw_dct_qp_valid_print(&(ptr_struct->qp_valid), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid:\n");
	connectib_hw_dct_my_lid_print(&(ptr_struct->my_lid), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write:\n");
	connectib_hw_dct_atomic_like_write_print(&(ptr_struct->atomic_like_write), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number:\n");
	connectib_hw_dct_srq_number_print(&(ptr_struct->srq_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index:\n");
	connectib_hw_dct_counter_index_print(&(ptr_struct->counter_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index:\n");
	connectib_hw_dct_pkey_table_index_print(&(ptr_struct->pkey_table_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic:\n");
	connectib_hw_dct_extended_atomic_print(&(ptr_struct->extended_atomic), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index:\n");
	connectib_hw_dct_my_gid_mac_index_print(&(ptr_struct->my_gid_mac_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd:\n");
	connectib_hw_dct_ipd_print(&(ptr_struct->ipd), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts:\n");
	connectib_hw_dct_ts_print(&(ptr_struct->ts), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number:\n");
	connectib_hw_dct_cq_number_print(&(ptr_struct->cq_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit:\n");
	connectib_hw_dct_hop_limit_print(&(ptr_struct->hop_limit), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number:\n");
	connectib_hw_dct_context_number_print(&(ptr_struct->context_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass:\n");
	connectib_hw_dct_tclass_print(&(ptr_struct->tclass), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_31_0:\n");
	connectib_hw_dct_dc_access_key_31_0_print(&(ptr_struct->dc_access_key_31_0), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_63_32:\n");
	connectib_hw_dct_dc_access_key_63_32_print(&(ptr_struct->dc_access_key_63_32), file, indent_level + 1);

}

int connectib_hw_dct_size(void)
{
	 return 64;
}

void connectib_hw_dct_dump(const union connectib_hw_dct *ptr_struct, FILE* file)
{
	connectib_hw_dct_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_pack(const union connectib_hw_r_qpc *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_r_qpc_qp_valid_pack(&(ptr_struct->qp_valid), ptr_buff);
}

void connectib_hw_r_qpc_unpack(union connectib_hw_r_qpc *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_r_qpc_qp_valid_unpack(&(ptr_struct->qp_valid), ptr_buff);
}

void connectib_hw_r_qpc_print(const union connectib_hw_r_qpc *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state:\n");
	connectib_hw_r_qpc_connection_state_print(&(ptr_struct->connection_state), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire:\n");
	connectib_hw_r_qpc_check_source_mc_wire_print(&(ptr_struct->check_source_mc_wire), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_31_2:\n");
	connectib_hw_r_qpc_e2e_pa_31_2_print(&(ptr_struct->e2e_pa_31_2), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_63_32:\n");
	connectib_hw_r_qpc_e2e_pa_63_32_print(&(ptr_struct->e2e_pa_63_32), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_connected:\n");
	connectib_hw_r_qpc_dcr_connected_print(&(ptr_struct->dcr_connected), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xrc_domain:\n");
	connectib_hw_r_qpc_xrc_domain_print(&(ptr_struct->xrc_domain), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder_session_id:\n");
	connectib_hw_r_qpc_responder_session_id_print(&(ptr_struct->responder_session_id), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mpi_uar:\n");
	connectib_hw_r_qpc_mpi_uar_print(&(ptr_struct->mpi_uar), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_dcr:\n");
	connectib_hw_r_qpc_next_dcr_print(&(ptr_struct->next_dcr), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number:\n");
	connectib_hw_r_qpc_srq_number_print(&(ptr_struct->srq_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va_31_0:\n");
	connectib_hw_r_qpc_write_va_31_0_print(&(ptr_struct->write_va_31_0), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va_63_32:\n");
	connectib_hw_r_qpc_write_va_63_32_print(&(ptr_struct->write_va_63_32), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count:\n");
	connectib_hw_r_qpc_no_wqe_drop_count_print(&(ptr_struct->no_wqe_drop_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi:\n");
	connectib_hw_r_qpc_dct_gvmi_print(&(ptr_struct->dct_gvmi), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn:\n");
	connectib_hw_r_qpc_sqn_print(&(ptr_struct->sqn), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat:\n");
	connectib_hw_r_qpc_sx_heartbeat_print(&(ptr_struct->sx_heartbeat), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts:\n");
	connectib_hw_r_qpc_ts_print(&(ptr_struct->ts), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed:\n");
	connectib_hw_r_qpc_rx_length_committed_print(&(ptr_struct->rx_length_committed), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer:\n");
	connectib_hw_r_qpc_rdb_read_pointer_print(&(ptr_struct->rdb_read_pointer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "always_zero:\n");
	connectib_hw_r_qpc_always_zero_print(&(ptr_struct->always_zero), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index:\n");
	connectib_hw_r_qpc_counter_index_print(&(ptr_struct->counter_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom:\n");
	connectib_hw_r_qpc_flush_syndrom_print(&(ptr_struct->flush_syndrom), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn:\n");
	connectib_hw_r_qpc_expected_psn_print(&(ptr_struct->expected_psn), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number:\n");
	connectib_hw_r_qpc_cq_number_print(&(ptr_struct->cq_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_number:\n");
	connectib_hw_r_qpc_dct_number_print(&(ptr_struct->dct_number), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn:\n");
	connectib_hw_r_qpc_msn_print(&(ptr_struct->msn), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer:\n");
	connectib_hw_r_qpc_rcyclic_consumer_print(&(ptr_struct->rcyclic_consumer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn:\n");
	connectib_hw_r_qpc_first_non_acked_psn_print(&(ptr_struct->first_non_acked_psn), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer:\n");
	connectib_hw_r_qpc_rdb_write_pointer_print(&(ptr_struct->rdb_write_pointer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state:\n");
	connectib_hw_r_qpc_qp_state_print(&(ptr_struct->qp_state), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index:\n");
	connectib_hw_r_qpc_rwqe_producer_index_print(&(ptr_struct->rwqe_producer_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_producer:\n");
	connectib_hw_r_qpc_rcyclic_producer_print(&(ptr_struct->rcyclic_producer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index:\n");
	connectib_hw_r_qpc_rwqe_consumer_index_print(&(ptr_struct->rwqe_consumer_index), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event:\n");
	connectib_hw_r_qpc_rwqe_limit_event_print(&(ptr_struct->rwqe_limit_event), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer:\n");
	connectib_hw_r_qpc_rnr_timer_print(&(ptr_struct->rnr_timer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap:\n");
	connectib_hw_r_qpc_tcu_trap_print(&(ptr_struct->tcu_trap), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey:\n");
	connectib_hw_r_qpc_can_use_reserved_lkey_print(&(ptr_struct->can_use_reserved_lkey), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop:\n");
	connectib_hw_r_qpc_tcu_drop_print(&(ptr_struct->tcu_drop), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable:\n");
	connectib_hw_r_qpc_e2e_fetch_enable_print(&(ptr_struct->e2e_fetch_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold:\n");
	connectib_hw_r_qpc_e2e_credits_prefetch_threshold_print(&(ptr_struct->e2e_credits_prefetch_threshold), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat:\n");
	connectib_hw_r_qpc_rx_heartbeat_print(&(ptr_struct->rx_heartbeat), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey:\n");
	connectib_hw_r_qpc_write_rkey_print(&(ptr_struct->write_rkey), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire:\n");
	connectib_hw_r_qpc_check_source_uc_wire_print(&(ptr_struct->check_source_uc_wire), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type:\n");
	connectib_hw_r_qpc_fw_link_type_print(&(ptr_struct->fw_link_type), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode:\n");
	connectib_hw_r_qpc_last_opcode_print(&(ptr_struct->last_opcode), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type:\n");
	connectib_hw_r_qpc_rwq_type_print(&(ptr_struct->rwq_type), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter:\n");
	connectib_hw_r_qpc_inline_scatter_print(&(ptr_struct->inline_scatter), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi:\n");
	connectib_hw_r_qpc_check_source_gvmi_print(&(ptr_struct->check_source_gvmi), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb:\n");
	connectib_hw_r_qpc_check_source_mc_lb_print(&(ptr_struct->check_source_mc_lb), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb:\n");
	connectib_hw_r_qpc_check_source_uc_lb_print(&(ptr_struct->check_source_uc_lb), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path:\n");
	connectib_hw_r_qpc_fast_path_print(&(ptr_struct->fast_path), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable:\n");
	connectib_hw_r_qpc_read_enable_print(&(ptr_struct->read_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable:\n");
	connectib_hw_r_qpc_send_with_invalidate_enable_print(&(ptr_struct->send_with_invalidate_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check:\n");
	connectib_hw_r_qpc_ignore_pkey_check_print(&(ptr_struct->ignore_pkey_check), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic:\n");
	connectib_hw_r_qpc_extended_atomic_print(&(ptr_struct->extended_atomic), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic:\n");
	connectib_hw_r_qpc_max_read_atomic_print(&(ptr_struct->max_read_atomic), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable:\n");
	connectib_hw_r_qpc_write_enable_print(&(ptr_struct->write_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write:\n");
	connectib_hw_r_qpc_atomic_like_write_print(&(ptr_struct->atomic_like_write), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable:\n");
	connectib_hw_r_qpc_post_receive_slave_enable_print(&(ptr_struct->post_receive_slave_enable), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access:\n");
	connectib_hw_r_qpc_no_direct_access_print(&(ptr_struct->no_direct_access), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled:\n");
	connectib_hw_r_qpc_e2e_credits_enabled_print(&(ptr_struct->e2e_credits_enabled), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type:\n");
	connectib_hw_r_qpc_ack_type_print(&(ptr_struct->ack_type), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast:\n");
	connectib_hw_r_qpc_drop_my_self_multicast_print(&(ptr_struct->drop_my_self_multicast), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe:\n");
	connectib_hw_r_qpc_grh_to_cqe_print(&(ptr_struct->grh_to_cqe), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid:\n");
	connectib_hw_r_qpc_qp_valid_print(&(ptr_struct->qp_valid), file, indent_level + 1);

}

int connectib_hw_r_qpc_size(void)
{
	 return 64;
}

void connectib_hw_r_qpc_dump(const union connectib_hw_r_qpc *ptr_struct, FILE* file)
{
	connectib_hw_r_qpc_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_packet_allowed_pack(const struct connectib_hw_s_qpc_packet_allowed *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_packet_allowed_unpack(struct connectib_hw_s_qpc_packet_allowed *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 2;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_packet_allowed_print(const struct connectib_hw_s_qpc_packet_allowed *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_packet_allowed ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_packet_allowed_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_packet_allowed_dump(const struct connectib_hw_s_qpc_packet_allowed *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_packet_allowed_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_qp_valid_pack(const struct connectib_hw_s_qpc_qp_valid *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_qp_valid_unpack(struct connectib_hw_s_qpc_qp_valid *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 0;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_qp_valid_print(const struct connectib_hw_s_qpc_qp_valid *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_qp_valid ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_qp_valid_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_qp_valid_dump(const struct connectib_hw_s_qpc_qp_valid *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_qp_valid_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_uncompleted_non_wire_wqe_pack(const struct connectib_hw_s_qpc_uncompleted_non_wire_wqe *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_uncompleted_non_wire_wqe_unpack(struct connectib_hw_s_qpc_uncompleted_non_wire_wqe *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 1;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_uncompleted_non_wire_wqe_print(const struct connectib_hw_s_qpc_uncompleted_non_wire_wqe *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_uncompleted_non_wire_wqe ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_uncompleted_non_wire_wqe_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_uncompleted_non_wire_wqe_dump(const struct connectib_hw_s_qpc_uncompleted_non_wire_wqe *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_uncompleted_non_wire_wqe_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_dc_full_handshake_pack(const struct connectib_hw_s_qpc_dc_full_handshake *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_dc_full_handshake_unpack(struct connectib_hw_s_qpc_dc_full_handshake *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 3;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_dc_full_handshake_print(const struct connectib_hw_s_qpc_dc_full_handshake *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_dc_full_handshake ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_dc_full_handshake_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_dc_full_handshake_dump(const struct connectib_hw_s_qpc_dc_full_handshake *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_dc_full_handshake_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_e2e_credits_enabled_pack(const struct connectib_hw_s_qpc_e2e_credits_enabled *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_e2e_credits_enabled_unpack(struct connectib_hw_s_qpc_e2e_credits_enabled *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 4;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_e2e_credits_enabled_print(const struct connectib_hw_s_qpc_e2e_credits_enabled *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_e2e_credits_enabled ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_e2e_credits_enabled_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_e2e_credits_enabled_dump(const struct connectib_hw_s_qpc_e2e_credits_enabled *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_e2e_credits_enabled_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_no_direct_access_pack(const struct connectib_hw_s_qpc_no_direct_access *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_no_direct_access_unpack(struct connectib_hw_s_qpc_no_direct_access *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 5;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_no_direct_access_print(const struct connectib_hw_s_qpc_no_direct_access *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_no_direct_access ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_no_direct_access_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_no_direct_access_dump(const struct connectib_hw_s_qpc_no_direct_access *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_no_direct_access_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_umr_permission_select_pack(const struct connectib_hw_s_qpc_umr_permission_select *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_umr_permission_select_unpack(struct connectib_hw_s_qpc_umr_permission_select *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 6;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_s_qpc_umr_permission_select_print(const struct connectib_hw_s_qpc_umr_permission_select *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_umr_permission_select ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_umr_permission_select_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_umr_permission_select_dump(const struct connectib_hw_s_qpc_umr_permission_select *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_umr_permission_select_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_max_read_atomic_pack(const struct connectib_hw_s_qpc_max_read_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_max_read_atomic_unpack(struct connectib_hw_s_qpc_max_read_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 9;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_s_qpc_max_read_atomic_print(const struct connectib_hw_s_qpc_max_read_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_max_read_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_max_read_atomic_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_max_read_atomic_dump(const struct connectib_hw_s_qpc_max_read_atomic *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_max_read_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_extended_atomic_pack(const struct connectib_hw_s_qpc_extended_atomic *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_extended_atomic_unpack(struct connectib_hw_s_qpc_extended_atomic *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 12;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_s_qpc_extended_atomic_print(const struct connectib_hw_s_qpc_extended_atomic *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_extended_atomic ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_extended_atomic_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_extended_atomic_dump(const struct connectib_hw_s_qpc_extended_atomic *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_extended_atomic_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_ignore_pkey_check_pack(const struct connectib_hw_s_qpc_ignore_pkey_check *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_ignore_pkey_check_unpack(struct connectib_hw_s_qpc_ignore_pkey_check *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 16;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_ignore_pkey_check_print(const struct connectib_hw_s_qpc_ignore_pkey_check *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_ignore_pkey_check ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_ignore_pkey_check_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_ignore_pkey_check_dump(const struct connectib_hw_s_qpc_ignore_pkey_check *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_ignore_pkey_check_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_rnr_nak_retry_counter_pack(const struct connectib_hw_s_qpc_rnr_nak_retry_counter *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_rnr_nak_retry_counter_unpack(struct connectib_hw_s_qpc_rnr_nak_retry_counter *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 17;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_s_qpc_rnr_nak_retry_counter_print(const struct connectib_hw_s_qpc_rnr_nak_retry_counter *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_rnr_nak_retry_counter ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_rnr_nak_retry_counter_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_rnr_nak_retry_counter_dump(const struct connectib_hw_s_qpc_rnr_nak_retry_counter *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_rnr_nak_retry_counter_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_fast_path_pack(const struct connectib_hw_s_qpc_fast_path *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_fast_path_unpack(struct connectib_hw_s_qpc_fast_path *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 20;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_fast_path_print(const struct connectib_hw_s_qpc_fast_path *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_fast_path ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_fast_path_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_fast_path_dump(const struct connectib_hw_s_qpc_fast_path *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_fast_path_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_rnr_nak_retry_limit_pack(const struct connectib_hw_s_qpc_rnr_nak_retry_limit *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_rnr_nak_retry_limit_unpack(struct connectib_hw_s_qpc_rnr_nak_retry_limit *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 21;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_hw_s_qpc_rnr_nak_retry_limit_print(const struct connectib_hw_s_qpc_rnr_nak_retry_limit *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_rnr_nak_retry_limit ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_rnr_nak_retry_limit_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_rnr_nak_retry_limit_dump(const struct connectib_hw_s_qpc_rnr_nak_retry_limit *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_rnr_nak_retry_limit_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_inline_scatter_pack(const struct connectib_hw_s_qpc_inline_scatter *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_inline_scatter_unpack(struct connectib_hw_s_qpc_inline_scatter *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 24;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_s_qpc_inline_scatter_print(const struct connectib_hw_s_qpc_inline_scatter *ptr_struct, FILE* file, int indent_level)
{
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_inline_scatter ========\n");
	int i = 0;
	(void)i;
	(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : " UH_FMT "\n", ptr_struct->val);

}

int connectib_hw_s_qpc_inline_scatter_size(void)
{
	 return 64;
}

void connectib_hw_s_qpc_inline_scatter_dump(const struct connectib_hw_s_qpc_inline_scatter *ptr_struct, FILE* file)
{
	connectib_hw_s_qpc_inline_scatter_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_ldb_int_pack(const struct connectib_hw_s_qpc_ldb_int *ptr_struct, u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->val);

}

void connectib_hw_s_qpc_ldb_int_unpack(struct connectib_hw_s_qpc_ldb_int *ptr_struct, const u_int8_t* ptr_buff)
{
	u_int32_t offset;
	int i = 0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset = 28;
	ptr_struct->val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_ldb_int_print(const struct connectib_hw_s_qpc_ldb_int *ptr_struct, FILE* file, int indent_level)
{
	adb2c_a