/*
 * Copyright (c) 2016 Rob Clark <rob@ti.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>

/* Generate raw frame via (for example):
 *   gst-launch-1.0 -v videotestsrc num-buffers=1 ! \
 *      "video/x-raw,width=512,height=512,format=NV12" ! \
 *      filesink location=frame-512x512-NV12.raw
 *
 * And then convert to 'C' array like:
 *   hexdump -v -e '"" 8/4 "0x%08x, " "\n"' frame-512x512-NV12.raw
 */
const uint32_t raw_512x512_nv12[] = {
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xd2d2d2eb, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2,
		0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xd2d2d2d2, 0xaaaad2d2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x91aaaaaa, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191, 0x91919191,
		0x91919191, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x5151516a, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151,
		0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x51515151, 0x29295151, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929, 0x29292929,
		0x29292929, 0x29292929, 0x10101029, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x6a6a1010, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a,
		0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x6a6a6a6a, 0x106a6a6a, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
		0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0x101010aa, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebeb1010, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x6713cd10, 0x29a52ba2, 0xa4d5cb5d, 0x20622a27, 0xe96d7870, 0xa625eb1e, 0xa4132962, 0x351229ab,
		0x4273774c, 0xa562d0e0, 0xc35c17ad, 0xbe1e41dc, 0xbfab904e, 0xeb1f3386, 0x3864ac15, 0x3ee644d0,
		0x328f50e9, 0x4a7a18bd, 0x916112aa, 0x6ed9aa62, 0x7f37c6a4, 0xd0a66a6e, 0x965184d6, 0x3ec4d613,
		0xbd623660, 0xe378e2d9, 0x8eda9983, 0x1f64d431, 0xaabe1bc7, 0x6b6b2276, 0x8ab06942, 0x4c1774cc,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xaac1e198, 0xcec3e519, 0x62e5b169, 0xc4e02fe7, 0xe88425e8, 0xabb0845f, 0x959e3b40, 0x7a1e4427,
		0x7dc877e4, 0x1fe56ed2, 0x8e7c338d, 0xb91fbe90, 0xdf5dc15b, 0xc92523c6, 0x5e13b125, 0xdf67937c,
		0xb8718f9b, 0xa16ba434, 0xbb74b840, 0x12403ba5, 0x3643142b, 0xdae82693, 0x69c2cf22, 0xb17ad0b0,
		0x27922ac8, 0xb3971994, 0x8dc56592, 0x9bd0a6e8, 0x4b2e9288, 0x16ceda64, 0x5ceb7067, 0xe4c26b86,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2846dcbd, 0x6919d4d8, 0x898ecfd5, 0xb27b9640, 0xc6185ec9, 0x4a3cd2d6, 0xb8885046, 0xaec88c9a,
		0x6263cdae, 0xb3328ac3, 0x55a21c5c, 0x6b875527, 0x70d6333e, 0xb07659d0, 0x4a6e4acd, 0x2417a1b1,
		0x7ae3b5c8, 0xca706317, 0x721fbd37, 0xb77c2f5e, 0xa9a8cbd2, 0x7e2b9813, 0x6f943f74, 0x38ce1a8c,
		0x18e27261, 0xc35cac4e, 0x88b7d892, 0xcec56ea8, 0x3b644a1f, 0xa69f211a, 0xcf1ae746, 0x20c120c8,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x995bbe83, 0xb35ed44d, 0x3eab4bc3, 0xc4ea85c7, 0x84e04810, 0x62811da8, 0x32b06774, 0xd056234c,
		0xca209b85, 0xaddd49b4, 0x16cfab1f, 0xb078bd7d, 0x505ca0d3, 0xa037d7a1, 0xd6975552, 0xa1d26c93,
		0x512cc294, 0xc7883468, 0x933f1f8c, 0xa5b18668, 0x208956e1, 0x9a28e2a5, 0xa7a48f11, 0x87e26d81,
		0x8d7934e2, 0x38a3e1e2, 0x7fb03b83, 0xb7442b4b, 0x79852168, 0x65bc8c74, 0x2ad016bb, 0x941370b7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x462387c3, 0xcfb7e32f, 0x5d60dd35, 0x2075d6c3, 0x2349bd78, 0x14a21eaf, 0xbb3981ca, 0xde82c219,
		0xdddbbe68, 0xe75186a4, 0xb0252bad, 0xacd03db7, 0x7ea95062, 0x9a41c03b, 0x4a8fd06e, 0x9fe1d121,
		0x41e2b6db, 0x95b5154a, 0x42d39764, 0xb7dd63c5, 0x54c36c57, 0x52dc2b91, 0x3714e1b2, 0xc3b8ea92,
		0xab314b95, 0xca8fb89b, 0x71ae4566, 0x572bb8af, 0x28901787, 0x2c476298, 0x267992eb, 0x88707d52,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe77a38a3, 0xbd49277e, 0xe688cce2, 0x7cd6ae36, 0x7de6e348, 0x3ea0d411, 0x9bdb9d6e, 0xdc70b0dc,
		0x99da5b58, 0x86486592, 0x695c5252, 0x5fb18dd6, 0x1ee11ca3, 0x9e971578, 0x6056df44, 0x1b431838,
		0x486e91c1, 0x3619e298, 0x5a236c9d, 0x1326a497, 0x687a3312, 0x819229b2, 0xd59e5aa0, 0x134fb7bd,
		0x73e7b755, 0xbf213252, 0x60b11b3a, 0x8b775f19, 0x26872a7c, 0xda1d7f82, 0xc3cda3d6, 0xd8214876,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc286ab21, 0x7fca575f, 0x204a1938, 0x2251e8d6, 0xb824b95b, 0xe17b8785, 0xadddbc38, 0xc71fcadd,
		0xdb1f4c55, 0x64c0c380, 0x1e9a44c3, 0xa51fd3d7, 0xe826e3ba, 0xaa5c8d7e, 0x3ac982b1, 0xd0b0d5d7,
		0x658a5345, 0x866ce478, 0xdcc37a58, 0x70446bbb, 0x5c888610, 0x4b25dc2e, 0xca88b1b7, 0x2c83b127,
		0xbfe29c21, 0x19352ae4, 0x4abc99dc, 0x754dd644, 0x73675b47, 0xb43ee335, 0x4913487a, 0xa8dcac47,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xb4442b1a, 0x138299ac, 0x9f7e7bc8, 0xc8a2abeb, 0xd3963eb2, 0x42331353, 0x1642dd2c, 0xa06a351e,
		0xc562935f, 0x84dec36d, 0xabdedf4b, 0xa1cd31bc, 0x483310a6, 0xc06a6f4c, 0xb52e97d8, 0x29707448,
		0x9a5ad844, 0xa7d41ac4, 0x101fc373, 0x16599554, 0x30148853, 0x8d6f8cbd, 0x14af2f19, 0x3379d688,
		0xb622d6d6, 0x90cba09a, 0x2fcce193, 0x178a6751, 0x3131aac3, 0x98aab38c, 0x6ee25db6, 0xd410cfa1,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xbd936c8e, 0x554fe98b, 0xad4a3cdc, 0xb7eacf76, 0xcf855072, 0x1aa35657, 0x8dbe2549, 0x6878a754,
		0x59c75376, 0xe4a16659, 0x574d68a0, 0x562a6285, 0xd32b3868, 0xe0c49abd, 0x193e40b9, 0xba60ab40,
		0xe7b868bf, 0x9b733ca3, 0x89ca6812, 0xbd67453f, 0xc0d43cd9, 0x6a9815a5, 0x6e388b81, 0x29304c27,
		0x55618abd, 0x6b2bb84f, 0x10e2193b, 0x4a51c744, 0x3ec33b3a, 0x8684caab, 0x5aa3e4ab, 0x804eafa7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xde9495a0, 0x682f6ed6, 0x498c3672, 0xcb507a53, 0xabcb1375, 0x6a147092, 0x5c9c4c8d, 0x1d4669a5,
		0x72716899, 0xa8e78744, 0xdb9d99e6, 0x9cc98631, 0xd0e87ddd, 0x2d8d301c, 0x1d1f5a56, 0xcb7fa2c2,
		0x6ecbbcd8, 0x62266e12, 0x913248eb, 0xac6d597b, 0x55347ac7, 0xbf9c54c3, 0x1fd9ea35, 0xe884c9bd,
		0x7ac092b1, 0x87e874de, 0xc922d6b1, 0x367e4119, 0x9962c662, 0x7ca94d93, 0xe532235c, 0x87bc4d5a,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x3b4aa552, 0x5023e1b3, 0x4e646868, 0x29888881, 0x668f61bc, 0x563e6526, 0x5db7751e, 0x9bb15736,
		0x343cd1ca, 0xadd24a2e, 0x7f179742, 0x99169f9e, 0x3eb4e04b, 0x60a0e91f, 0xc2a9e487, 0x5ccd5614,
		0xe8911a90, 0xd7c9b1ca, 0x25ea616c, 0xc16bd02e, 0xa6ca691d, 0xb07d6c3c, 0xdfdc6f11, 0xb9999592,
		0x476513b1, 0xe26eac92, 0xa144813d, 0xb4368cad, 0x66c99361, 0x7d3d1642, 0x5a6eaea2, 0x107c8595,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x8a8e9c7f, 0xe52b8721, 0xbdb1d6be, 0x87ba1e25, 0xdeab5f6b, 0xb84533cd, 0x9133a1b3, 0x2cdf71bd,
		0x7b29b42b, 0x16638b18, 0x1e735f6a, 0x4ea5ac11, 0xd86b866c, 0x9c2331c4, 0x50262674, 0x496ea4ca,
		0x9fe73bc3, 0x43a42938, 0x255eb44c, 0x1f62cd31, 0xd7dbe593, 0x3b3c5ec7, 0x193fd415, 0x786f8e81,
		0x9a2cc6bd, 0xa4788844, 0x756dd595, 0xe854cb4a, 0x813e7f35, 0x871b2795, 0x6e77cea3, 0xd06d7a7d,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x14877a4a, 0x71463dd8, 0xb996a098, 0x2ee3151b, 0x5a44e95e, 0xb729b6ce, 0x1bc8d094, 0x87cdb682,
		0x6c381176, 0x9c756edc, 0x95d6d085, 0x95c0b044, 0xe3e84962, 0xe2cb9e57, 0x7f4fb61b, 0x913fb052,
		0x6c134495, 0x5c928d13, 0x8d46648d, 0x7d505187, 0xe8693471, 0x3eb229ab, 0x62bc5e42, 0x25e3b28b,
		0x961415d7, 0xa526e2d0, 0x459a18df, 0xd5d723a6, 0xeb7a88bb, 0x994480b1, 0x4950835e, 0x338c2f12,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x92323f91, 0xab75e044, 0x4413a4d0, 0xd6297062, 0x93364795, 0x51c53729, 0xb5be259f, 0xd07c4b62,
		0xe2689ece, 0x862ed0c4, 0x2c622f90, 0x9464a75c, 0x61742b2e, 0x55e3748e, 0x7246da58, 0x5a3f7962,
		0x50ac33e2, 0x4a94245b, 0x82a24e50, 0x25383852, 0xda50eb93, 0xb82aa9c7, 0xdd99c898, 0x9c3d26af,
		0x3b1e9622, 0xe656de81, 0x12cfde3e, 0x78e64ce6, 0xc79fb03b, 0xb7b84494, 0xc3d5a8b0, 0xcfdb7c2f,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x4a6ec776, 0xb7b8b71e, 0x38e0e28c, 0xc744511f, 0xab803133, 0x62626d96, 0xa51558d1, 0x2bc9e85d,
		0x25b8a456, 0xb168d5ab, 0x9ad0368d, 0x4a6e9356, 0x2dc62aab, 0xad6a938d, 0x2ae89350, 0x7f6edc1f,
		0x4b1ce6ce, 0xe4aaa833, 0xe2967172, 0xcd17826f, 0xab8f771c, 0xcf5b263c, 0xb0b35739, 0x2533a312,
		0x66499056, 0x8c2c7d31, 0xb52d946b, 0xae7f6a2d, 0x15b0196d, 0xdc9b4f41, 0x264b62bc, 0xea7d87d6,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1b5c5ad6, 0x97339e64, 0x94697da7, 0xdc56962e, 0xa446a816, 0xebb87b5d, 0xc7858e50, 0x50d7d673,
		0xc95023c7, 0x3f497b92, 0x2968e57b, 0x92df7434, 0x47264824, 0x333b1d54, 0x827ebbde, 0x23cd2264,
		0x5e1ca458, 0x75d4617a, 0xd022ce19, 0xbeca53de, 0x5d4a8ec6, 0x816859c3, 0xb42fc6df, 0x77c76e6c,
		0x3996df96, 0x728599bb, 0x786d1689, 0x9a7d7d34, 0x8dab7d74, 0x31caa191, 0x2a6e8c81, 0x864e504c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdedbb1d5, 0x499e953c, 0x80665146, 0x3c61618e, 0x7d65cf3d, 0x33ea645b, 0x4056c7d3, 0x63a613a3,
		0x3ae4d468, 0xebaaa076, 0x8fe2835c, 0x91da4bd2, 0xaf4e844d, 0x9f57cabf, 0x9fbe794b, 0x2480dc56,
		0x87ab495d, 0xb5352a50, 0x4a22881e, 0xd59a87c2, 0xcb5e56d7, 0xa95266a5, 0x10c35bd1, 0xb83f66e0,
		0x9328a6e3, 0x99825968, 0x37b33f99, 0x3ee2841f, 0x77902452, 0x69665fa9, 0xcf5e4bde, 0x7d4fb34b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdc311273, 0xa9409e81, 0xd5d76044, 0x9b638f64, 0x36dca5a7, 0xcf1e268e, 0xc96426a3, 0x63375711,
		0x31be2118, 0x1fb1685b, 0x1487ca2c, 0x48601678, 0x8a5fdd4d, 0x37bde217, 0x81cea74e, 0x80617ad0,
		0xc912b1de, 0xc887df95, 0x30967c82, 0x3462411c, 0x3ecbaa50, 0x6e194bbc, 0x7ab9cf10, 0xe7568a93,
		0x94b7c362, 0x24259616, 0xcd243399, 0x75d281ca, 0xb060c3e2, 0xac4d6489, 0x5c1f7a19, 0xd07ed4d3,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1616378c, 0xdbd2b656, 0xb7e0a8a1, 0x445f448c, 0xabd02c79, 0x2be69d1c, 0xa7af649a, 0x5265c876,
		0xacba9fb0, 0x6f5fad3e, 0x7231dbcb, 0x914bb1dd, 0xb25c7a22, 0xb5936612, 0x28ac6ae7, 0x5c71b01c,
		0x45e32421, 0xacebc86b, 0x7ea2ab6b, 0x94225ea3, 0x6cb4ade9, 0xaa98e62e, 0x3c106853, 0x272dd961,
		0x408d5aca, 0xcb4a769e, 0x8376d08c, 0x634b727b, 0x5b1ba56b, 0x1c7fb131, 0x8a8a3ec7, 0xa4ddb22b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x438b4244, 0xe09cde9a, 0x28814d82, 0x12525c29, 0x25403e8f, 0xd9af12bc, 0xb85ca5bb, 0x2f54881a,
		0xd1d69778, 0x248e9521, 0xcabdb780, 0x919d664a, 0x4d4333aa, 0x61b431b1, 0x6f5a9e5f, 0x95b1a5cb,
		0xb58d5abc, 0x6388c2ad, 0x5b4636b2, 0x3eb7dea0, 0x7a1a61eb, 0x81197eb1, 0x3080e2bf, 0x32a27949,
		0x70844462, 0xd716d449, 0x35ce5c6f, 0xe32b5812, 0x549ca5a6, 0x711f687f, 0x7cc37453, 0xd38f4fe8,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x87b33576, 0xb77a3c6e, 0xde962cc3, 0xe03ed618, 0x5be5dde9, 0x47553cb6, 0x2144e828, 0xd6e074b5,
		0x9f39e34e, 0x19621fdf, 0x44736125, 0x48791076, 0x3713e82b, 0x1643443e, 0x7bb3656d, 0x4d44574c,
		0x5fc67719, 0xca38cc81, 0xa05ed67d, 0xe868e513, 0x69b4a154, 0xd051cb90, 0x56508177, 0x2bd8444c,
		0x4a9c85e2, 0x4862d5d0, 0xbf508f44, 0x3f723267, 0x9a2bc3b7, 0xd0e76893, 0x34cd3d75, 0x83718676,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe28fea48, 0x626b85b0, 0x46444587, 0x1c22d658, 0x702b50ab, 0x2cb33ee6, 0x986a5199, 0x8e528c8e,
		0x1699aa31, 0x50b928c0, 0x942fb198, 0x92bb8a87, 0x6eabde5e, 0xb11d9d6d, 0x4cdb9e36, 0x62e2a356,
		0x21b37bcc, 0x25d9e7c2, 0x74ead5a7, 0xdb1173b3, 0x38ca91dc, 0xba6716a4, 0xaf5d2357, 0x11cf3a69,
		0xa9d63e94, 0xd5557779, 0x68b58ee7, 0x2e43de9f, 0x5481249f, 0x5c41ae70, 0x8ca57652, 0x8e817a8d,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x791fab94, 0xba70de82, 0x186497aa, 0x58da5fea, 0x67a550b1, 0x89131b70, 0x65ce9956, 0x3561d082,
		0x133fc41f, 0xc5b6af9f, 0xe0cecd1f, 0x93871d7a, 0x17521667, 0x79426265, 0xbdd16b94, 0xd1d3ade7,
		0xd6536744, 0x30b13694, 0xb1323156, 0x178e63c9, 0xc35e31cd, 0x3f5a1713, 0x5fa8a360, 0xc2875da1,
		0xb1564c53, 0xc6c99921, 0xe943599f, 0xaf79a3bc, 0x5cc27e5c, 0xcfc26015, 0xa94c44c5, 0x19c22b50,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x263e537f, 0xe4896dc2, 0x531d4750, 0xbaaf4a17, 0x3d9bdb1f, 0x812bad31, 0x6592e43d, 0xa5316391,
		0x94e2581c, 0xa058d87f, 0x4c96b475, 0x4bbb8152, 0xebbe4946, 0x4ab16e25, 0x1897a9ae, 0xc218744a,
		0xc6833935, 0xe89d70d4, 0x7ccaa262, 0x5428b755, 0x534a5d25, 0x3d29cc93, 0x42544a91, 0x84ddab19,
		0x62d2b01f, 0x1ce35ca5, 0x8ab3cb48, 0xe83a5cbd, 0xb1111aca, 0x6eb2595e, 0x8a9e8417, 0xdc56779c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc710bee5, 0xe2b6e793, 0x1b4a3056, 0x647b9870, 0xd0ea3aac, 0x161f3d26, 0x9993564a, 0x279f23ba,
		0xbfca4125, 0xbb7ba45d, 0x906467bc, 0x9678dae8, 0x553a99d6, 0x258fc38a, 0x132b7a81, 0x3268d635,
		0xce66cfa1, 0x999cbca4, 0xb11f71cf, 0xb6969131, 0x9f8e399f, 0xb1b17f6e, 0x563dd0ea, 0x34194a86,
		0x99948dd3, 0x8ea39e4c, 0x264e2dbe, 0xd762e6a0, 0x7a27b133, 0x16119970, 0x31bf57db, 0x44188194,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xa37234ea, 0xb11a95d0, 0x4eeb53bb, 0x34416c3f, 0x67b625a1, 0x21cc8153, 0x22d1a581, 0x74cdea22,
		0x93d57f3b, 0x3b45123b, 0xcf38c219, 0x989b4b87, 0xe87c2b62, 0xe6b781b6, 0xae6bbdeb, 0xdae71aa8,
		0x11d96fad, 0x1ab03ce2, 0x74c37abf, 0x6120ce61, 0xcb4fa17f, 0xc13ae77e, 0x9f627c91, 0xafcd1432,
		0x7979beb8, 0x65e482ce, 0x9aca374a, 0x7e138968, 0x9027894e, 0xa596444a, 0x77b09b7d, 0xe2e64839,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x97876e8e, 0x546e549f, 0xea49b0a4, 0x28daa460, 0xb9da9cdb, 0xa47a9fb6, 0xba701ce1, 0xaebd2580,
		0x1125375e, 0xd691db18, 0x2e13e842, 0x51498de6, 0x13a8b79e, 0xd45087ab, 0x327a9534, 0x26b9d3c9,
		0x4624d357, 0x4ad6a8b0, 0x9f23bd32, 0x317f92e1, 0xd768baa3, 0x6d7b4cc4, 0x3ec42b5f, 0x3b66e6d5,
		0xdd7e68ab, 0x7ccbe474, 0x2e70e7a4, 0xb72b2113, 0x1812803e, 0x608a38c7, 0x836e74b6, 0x252ba967,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xa1508dad, 0xa5d624dc, 0x38196910, 0x428f62d2, 0x117ac37c, 0xc2e29673, 0xa94c718c, 0xd66e681d,
		0x1372438d, 0xd78269d0, 0x64d0da5d, 0x9d5cc44c, 0x68bf87b1, 0xcb32d668, 0x5757dd13, 0xaabb6e95,
		0x93d9427c, 0x4e364910, 0x5ad35ce1, 0x25d6b8d7, 0xc3da822f, 0x909a6766, 0xeb88b856, 0x919d2cb6,
		0x10a568ab, 0xd459e918, 0x991d8713, 0xa7a98a7e, 0xcac394e1, 0x25c97231, 0x53d9bda9, 0xa07bc841,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc3a9946b, 0xc776dfa9, 0xcc5f5db7, 0x803e83ba, 0x24749b62, 0x7b4a6666, 0xcb66c960, 0x11bdd6b1,
		0x9be0a4ca, 0x3c1976aa, 0x97b69769, 0x9fd71571, 0x2ec17499, 0xcb5f8ec8, 0x41e0b988, 0xae10a4eb,
		0x1c677441, 0x2384d5b8, 0x7d3f3637, 0x3f496643, 0x90c8d6dc, 0x4e955c3d, 0x13896d74, 0xd6957ab2,
		0xa311bdb7, 0x90689097, 0x25abd04f, 0x4fb1e7cc, 0x1382c87d, 0xd076183e, 0xc4369b56, 0x9b1fa5a5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1fb683a4, 0xbd2acfe3, 0x123c8be2, 0xe3bf2b18, 0x18c5238a, 0xac6a108f, 0x44bc485c, 0x15cc9583,
		0xcc947e38, 0xbd312584, 0xc5a21f68, 0x59dc367a, 0x44ac7e57, 0xd6d78f15, 0xcb5c2bb7, 0x32709612,
		0x97838d80, 0xa6e79617, 0x2e1f49c9, 0x7e9076dc, 0x3d33dc13, 0x846d294a, 0x4ac723bc, 0x2b4f17c9,
		0xe07b8bd0, 0x8d1cb63a, 0x8863e37c, 0x88445d22, 0x872c3dcb, 0xa76ee115, 0x1e3ee999, 0x16ce40b4,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x6f75587a, 0x85cdd0af, 0x9d8d1590, 0x8f5e36a3, 0xc793371b, 0x7a686f13, 0xca74a581, 0xe29d8070,
		0xa66aad8e, 0xa3cc535d, 0x13945057, 0xa56a4b68, 0xa683a7c7, 0xe9bed6e2, 0x3e82e8a1, 0x1224479c,
		0x4e548d5d, 0x208168be, 0x4a7495dd, 0xe2d0e9eb, 0xa5d2906b, 0x5622ab8d, 0xb366b850, 0x4ca5bd1f,
		0xc52bae19, 0xca527db7, 0xe722c39b, 0x7a3da538, 0x6c9dab13, 0x89b1398f, 0x1916cd98, 0xcad07470,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd7c415cd, 0x1fa8e0e8, 0xb676b69e, 0x61d0a3a4, 0x7bb9d6cc, 0xbd42a7a8, 0xa86828ce, 0xc3309678,
		0x2a625616, 0xca312336, 0x388d4c38, 0xaa5f5638, 0x7b441231, 0x2b138a9b, 0x52795f46, 0x4ee291d4,
		0x1cb374b7, 0x4a2f4a1a, 0xce603f75, 0x8d2be370, 0x1312d12b, 0x9e8f2b2b, 0x744274e8, 0x5abdb16a,
		0x54d74a4c, 0x6b2fc358, 0x65c36eac, 0x229be031, 0x9f1d5ce9, 0x7464b5d1, 0xb3984450, 0x202567b5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x7ac794be, 0x689725b2, 0x5cd4b42f, 0x5660981a, 0x105c4ae5, 0x9dd4b998, 0xb9998a68, 0x915fd89a,
		0x327a5486, 0x541671e9, 0x5a8c14e6, 0x64ba55c8, 0x9fcb774d, 0x5190841d, 0x2b3e4681, 0xe51999b8,
		0xddc742ae, 0x44cc3cc0, 0xe1bf246e, 0x5f5b6446, 0x3c87c22f, 0x82da61db, 0x665a32cd, 0x5696d2d0,
		0x68ca3c8c, 0x4d8dabd5, 0xbb8dc0ae, 0x5d8535ea, 0x44622bb9, 0x68619cdc, 0x38e92c9f, 0xaf8717a6,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x337d1f4f, 0x839956e9, 0x6cc9eb1f, 0x72c313be, 0x60584a65, 0x1868a5bd, 0x202b1329, 0x4d506ad7,
		0xc0b4a627, 0x1f7e62bf, 0x769083a9, 0xb1a04a60, 0x35621f3f, 0x817ac543, 0xa4ad9d76, 0x215b6049,
		0xd98dd345, 0x12a23e1a, 0x81b741c4, 0x5683486e, 0x45776276, 0xde2570e5, 0x8cb0cfda, 0x40314476,
		0x25de81d8, 0x6f903774, 0x315ddea1, 0x4fd55bab, 0x3893195f, 0x66a8caae, 0x5c2d85a9, 0xbd3a6144,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe0c36d5a, 0x71b098b1, 0xe656816e, 0xb143cdd8, 0x91acd62a, 0xe6b4683e, 0x96d67a13, 0xd3de2853,
		0x1b3472b1, 0x2b8cd095, 0x8f9abd5e, 0xb61032b7, 0x19bebfe2, 0xbbb17331, 0xe2108925, 0x95cbbf62,
		0x11e46f56, 0x8e8b50be, 0x8a48989f, 0x71a48ee8, 0x2fc19025, 0xd5285849, 0xe4679333, 0x1868bc36,
		0x68384156, 0xd2394012, 0x7e34c886, 0xd4ae7550, 0x7aad24b7, 0x6e5e644a, 0x451d736d, 0x4c1e686b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc8bca2e0, 0x31dae9e7, 0x12575042, 0x3b963168, 0xa17d3632, 0x74dde2d0, 0x62e2e326, 0x6b5111c4,
		0xd7b1936c, 0x773fe26a, 0xa4abc4e0, 0x72c21017, 0x4a29a381, 0x225667c2, 0xe41ee66c, 0x888fdd29,
		0x3c12cfe2, 0xdc887417, 0x224c4cd9, 0xb1bd5cd7, 0xd5876d19, 0x68e519bf, 0x935b5891, 0xb9628411,
		0x548e56bc, 0x9965c78c, 0xc7117d5c, 0x341384b3, 0x2fb24de4, 0x7e5f4588, 0xcfb7d0c7, 0x37302e3e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc868bd29, 0xa03c70ad, 0x83cd5774, 0xc4e2d649, 0x93a6227e, 0x7ae35abc, 0x62507461, 0xcd622675,
		0x61742d34, 0x2874953e, 0xb3c29678, 0xc022be36, 0xcb5ba4d0, 0x6e44a340, 0xabd6d76c, 0xd882b877,
		0x7dab3832, 0x2199a7b9, 0x23c43a96, 0x3bce8c3c, 0x7fa5d650, 0x72a2908f, 0x748c213b, 0x6e1c79e2,
		0xc52bbe54, 0xa1361528, 0x31cfd923, 0x27b9881f, 0x31a294e8, 0x98ab6e8f, 0x4244c3dc, 0x7d728d9b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdea5c1c8, 0xe18de2e1, 0x82da992b, 0x974a247b, 0x634c9932, 0x1ac686de, 0x94d6e2c4, 0x40346841,
		0x6f581ce4, 0x194fc712, 0xbfde34dc, 0xc5c48738, 0xbd77c319, 0xc47f4a62, 0x38825c26, 0xa7a55273,
		0xd61c66d8, 0x14bdeb11, 0x8dd562b2, 0xc5d743cf, 0xe54013cb, 0x173ce095, 0x891ec8ea, 0xeb739915,
		0xdfc5a1d4, 0xe988bd9f, 0x71b725b7, 0xace9814a, 0x817d1ec1, 0xbc65dd5e, 0x557d4aab, 0x44e2aba4,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x3094ab2b, 0x191789a5, 0xeb7f393f, 0x8f87b124, 0x154ac22b, 0x32868c5b, 0x1dbd7874, 0x7ea3d527,
		0x265e60c6, 0x4aab9bc0, 0xc6257957, 0x8115431e, 0x227d2514, 0x4827384c, 0x64d95378, 0xd31a861a,
		0x6b1d7a41, 0xb71962b1, 0x877dc352, 0x99d95cd6, 0x5033b8ae, 0x348f2dd2, 0xd0c996e5, 0x7a8ce540,
		0xa3a5d985, 0x97812b3b, 0xada61962, 0xe9a56f59, 0x4442a170, 0xe86ab7d1, 0x2d844234, 0x66a78759,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x74387be4, 0xdb9040d7, 0xe29912b4, 0xabbcc51e, 0x83a19a67, 0xc2226be9, 0xb4e2104c, 0xaad39228,
		0x63861db4, 0xbcae1291, 0xca4d899f, 0xd1a9d0c3, 0xb16e81c1, 0xb11b6edb, 0x5623ba83, 0x7f9b764b,
		0x16ac7625, 0x4f66c7e2, 0xe8998252, 0x91d3d955, 0x768031d5, 0xc9be3168, 0x6ed4662c, 0xd5668185,
		0xeba58a43, 0x841f18b1, 0xe59bb5d9, 0xddc6514b, 0x56cd67d1, 0x44bbda31, 0xa55baa54, 0xe49b1f97,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd06a3461, 0x9341e49a, 0x664a25ac, 0x12e86169, 0xd07423e6, 0x117623d2, 0xa368874d, 0xc3c57a44,
		0x4acf30b0, 0x9356e262, 0xc97c66d8, 0xd7c67571, 0xb24a1f68, 0x465aea56, 0xe818b64a, 0x866f2529,
		0xb5145984, 0x95c560a5, 0xd94e7ab1, 0xaec5dc24, 0x7e483863, 0x1ccae836, 0x3e413978, 0x40dd48e4,
		0xdcc98fe9, 0xb13f834a, 0x3d954066, 0x87722921, 0xb5674b2c, 0x837a6835, 0xe3dca62d, 0xe3bd5281,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x6850af58, 0x1fe2bcca, 0x536f7028, 0x78325e2b, 0x239f38ce, 0xb3a89115, 0xc32a2476, 0xcb788f7a,
		0xb55c97b8, 0xa9807a31, 0xc3b1e927, 0x946e11dd, 0x2510b6c1, 0xc2e2d374, 0x62b745a5, 0xe9736e8e,
		0x8fe72381, 0xaf5de5d5, 0x5676ac93, 0x14b06745, 0x6568c937, 0xc3b49e38, 0x42c7ea10, 0x753a3c83,
		0x7831eac1, 0x44e190be, 0x6c9673c0, 0xc583d1b7, 0x87c74d39, 0xcc833ddc, 0xe550389e, 0x62344319,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x17c636ca, 0x57baa48c, 0xab2c1adf, 0x2850bf3e, 0x3148d81e, 0x15b7d86a, 0x3b2a9fc7, 0xc1c8cfca,
		0xcae877cd, 0x25508fdc, 0xb9eb5c43, 0xe47b7c52, 0xc39d9014, 0x6bdb265b, 0x7e4b46bc, 0xcca574a1,
		0x8092b01f, 0x9ae49f95, 0x3e373cd5, 0x7b9354b7, 0x2ce22e4d, 0x2b7a2c72, 0x78aec3ac, 0x99335b3c,
		0x9896bea5, 0x164c4056, 0x979d7130, 0xba1f9355, 0xa5366d1c, 0x44d75970, 0xac703ac9, 0x3cb5cd38,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xb8137fdc, 0x63a69dba, 0x905eda3d, 0xd865a6a2, 0x1f494c8d, 0xcba21c19, 0xc1664265, 0xa5d95f5a,
		0x87baac13, 0xbca147ab, 0xab507850, 0xeb13dc87, 0xd3388719, 0x1e429ee6, 0x5e89b78d, 0x302b3961,
		0x88cc4836, 0x58a468c3, 0x8f6be199, 0x2b6ea4a0, 0xb0d820a7, 0xe41d70e1, 0xe1d29d96, 0xabcaa510,
		0x6242e797, 0x293a6ec8, 0xbea93b6d, 0x662248b1, 0x386babb1, 0x9f9abda8, 0x385eacae, 0x728a39e2,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x95ccb08b, 0x42a6a57a, 0xdf271ad6, 0xd274157c, 0xcaa24d64, 0x406a16db, 0x9fdfc32b, 0x75ac1bdf,
		0xcaad5b42, 0xb8987d78, 0x99965e4f, 0xaa13569f, 0x55999ed0, 0xb6cf805d, 0xdf96bd19, 0xcbbd97a8,
		0xa8b9a3c8, 0xc4764283, 0x6e38e3bd, 0xdc417ada, 0x384b9e69, 0x5e788eab, 0x9f577aa7, 0xaa4741da,
		0xb0ea8995, 0x7ca93e5e, 0xe1bcac9b, 0xa48acf16, 0x188c2b3f, 0x2aa88ca9, 0x641cb34e, 0x288d3f5b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x895cc7b6, 0xcfbabea7, 0xbc657118, 0x147ac2a8, 0x7978da80, 0x2cebc519, 0xaeba6a19, 0x3540dfa4,
		0xb7c25f7e, 0x19355644, 0x82e3113f, 0x1f77a099, 0x25e6d280, 0x7bcbaa78, 0x4972583b, 0xe6a1b39d,
		0xdf5be51e, 0x285d2caf, 0xb6784465, 0xd6e8b48a, 0x7b16cb70, 0x50b085aa, 0x92195ae1, 0x9861e3e2,
		0xa8d881a1, 0x34bd8dcf, 0x23d5e9bb, 0x997d6e3a, 0x4696a580, 0x9925a271, 0x55845084, 0x3ac1df5c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x957cc680, 0x52e2e865, 0x263a2594, 0x58791a4a, 0xe4a63bdf, 0x906d716b, 0x14d11431, 0xbe711783,
		0x4c1bb7c7, 0x9654adeb, 0x675a6a20, 0x2666df79, 0x444048e2, 0x4a363e5c, 0x531d6217, 0x81b58d3e,
		0x508b32ca, 0x3957276d, 0x8d50ba6d, 0x19ac748b, 0x9f39aaba, 0xb7c555e0, 0xb7183d67, 0x733cd62b,
		0x49e8cdb9, 0x2c787e62, 0x3d1815cc, 0x46d6df43, 0xc38b6196, 0x35c824dd, 0xe7bc5c74, 0xa84762e7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xb750abc4, 0x83414690, 0xd6841394, 0xc06fb13d, 0x535128a6, 0x8fa7d317, 0x894a9d70, 0x5a64567d,
		0x67738940, 0x7719a6b6, 0x48b28fd0, 0xc1bb373c, 0xb062b83e, 0x23c81ae3, 0x2273de8a, 0x781c2568,
		0xb66f4339, 0x1d663297, 0xcc9d8dd3, 0x5d6898de, 0xa4b6386c, 0xbcb7da6f, 0x32542215, 0x3cb41968,
		0x6f3e92de, 0x65b512d2, 0x523cc5cf, 0x86b9682e, 0xb16a3b82, 0xb7dbc936, 0x61c3d81f, 0x96d97d42,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x15b279a8, 0x8790904c, 0x38653a17, 0x725fcf81, 0x7f55a1b1, 0x2abd32d5, 0x56dc4cd7, 0xbf18c292,
		0x2b10b0a3, 0x995e4280, 0x25358193, 0x389a5fbe, 0x8f6e6a4d, 0xe1c93e56, 0x929813b7, 0xcb8e563e,
		0x56e23a23, 0xb0874d53, 0x9a819abd, 0xc61c42a6, 0x88ae5162, 0x5c855c35, 0xbccde5c8, 0xd01162c2,
		0x3e90ac34, 0xde972364, 0x636765c3, 0x7b27c2d9, 0x12343344, 0x675cd932, 0x7c98e961, 0xe0be5625,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x66c92c2b, 0x5e17ea75, 0xdfbb9bd6, 0x4846733c, 0x8ab1ca24, 0x3db14611, 0x54ceda8c, 0x37687cc1,
		0x74ab5037, 0x204a5c49, 0xd89a3d4a, 0x40e17d48, 0xbc633b31, 0xcc38a96e, 0xc68c939e, 0x9f55459d,
		0xe92e1987, 0x38bd797b, 0xd1dae12b, 0x78a54fc1, 0x4d241c9b, 0x72319431, 0x9da7d0c8, 0x74e8d959,
		0x93284073, 0xbc1fb3d1, 0x7098aca8, 0x29d7358c, 0x9dc44ab8, 0x202755d4, 0x5c3d905c, 0xaad2ca92,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xce93a428, 0xe38d7a30, 0x38a8593c, 0x44257a48, 0x7688a3b7, 0xc682345f, 0x85218e68, 0x777b632f,
		0x668a45b2, 0xc3b81811, 0xac29a1cc, 0xdcb18f92, 0x5b4429c7, 0xc1ce804f, 0xbf4fa840, 0xcd4acfa9,
		0xb8e4ba8c, 0x6f2bb536, 0x96ca85d3, 0x4f4abe51, 0xcecd723e, 0x2594a663, 0xb1bebc13, 0xe4a49fe7,
		0x91bd28be, 0xda28e562, 0x79cebf7f, 0x69357923, 0x9a647e26, 0xbe3e1861, 0xdc8ca613, 0xd03a1fab,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x7110259f, 0x5e3c1957, 0xd72e51dd, 0x63dae4a5, 0x42b92cb1, 0xeb30d7e3, 0xe88e456d, 0xa64f7693,
		0xdd8c8f60, 0xcacc52b3, 0x7c99d065, 0x52e796bf, 0x49103656, 0xbed39dd2, 0x7dbd5278, 0x7c6e3a62,
		0x9f73672e, 0x7988255d, 0xc5536223, 0x4ac3b532, 0x53177823, 0x4fd691cc, 0x1b36ab63, 0x652190b4,
		0x3899663b, 0x5cb4bace, 0x7e2f9e47, 0x60d6b179, 0xe6cad046, 0x8b9f2292, 0x45ab515f, 0x76ace971,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2c1d6ab7, 0x88daa410, 0x28278326, 0xa9aad679, 0xca674213, 0xab9677c2, 0xa45cdb9a, 0xc3bfb537,
		0x22af5219, 0x36852f7a, 0x4734cbcb, 0x5ca792d0, 0x84a16199, 0xc6462643, 0xdc1e6d6b, 0x87c13ea2,
		0x9b90d64b, 0x561d8215, 0x81507aaf, 0x6b583266, 0x94962f4c, 0x1317558e, 0x93c79ddc, 0xb03cae9b,
		0x64961da0, 0x1fe5315c, 0x7e7248dc, 0xea25deb2, 0xa43e663c, 0x606e738b, 0x50996d66, 0x787396bf,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdab9976d, 0x85b06436, 0xbe9412aa, 0x37734d9e, 0x576de396, 0xe3d9cdd6, 0x91669714, 0xcf1644d0,
		0xc8186abd, 0xbec08a3f, 0xeab19346, 0x1dce83c5, 0x3142a9b0, 0xd7e1d257, 0x232b1c18, 0x1268dd90,
		0xb06251e4, 0xe0a2133b, 0xa8c0cbbd, 0xb1c213ea, 0xb69171b9, 0x5011ce87, 0x63b992a0, 0xe9171b9e,
		0x39b42837, 0x23bc26c7, 0x7abb9987, 0x50b525d0, 0xaf7819e3, 0x3e89304c, 0x1e551e26, 0xd668dcba,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc32daa9e, 0x549934c9, 0xe29ab7b1, 0xc6332838, 0x9fcb5981, 0xb71d2045, 0xb1ae5693, 0xc8e5daa8,
		0x3b7ed791, 0xaba187e0, 0xad58258f, 0x707f689d, 0x2da9349e, 0x16e9e934, 0xe7e23c5c, 0xd53e5e2b,
		0xdcc28f3f, 0x615e90cd, 0x5cc97a50, 0x3f4856e5, 0xb8e5638f, 0x29c444b6, 0x66e8888d, 0x349090ba,
		0x941989b6, 0x67389a54, 0x712db725, 0x48d03cd1, 0x2d9dc585, 0x271334b2, 0x8dbd3e7e, 0xb38de162,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc331a56e, 0xd1971411, 0x9438b93d, 0x9ec96525, 0xc9a65aae, 0x261929c6, 0x2756175c, 0xaf99c09b,
		0x3329be71, 0xd82827a4, 0x6be15fc9, 0x7a974359, 0x781eb861, 0x3a626db4, 0x938ccb59, 0x3b43784d,
		0x42d6b415, 0x912f4215, 0x79696241, 0xcfa21f55, 0x9ab5e2a8, 0x7878703f, 0x9b7982a4, 0x49ca5615,
		0x987a6367, 0xeb38b0bc, 0x64829f8e, 0xd27647b6, 0xd6acb4d8, 0x19c380e0, 0xc117d090, 0x11e1a492,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdac386b8, 0x44a8e2a2, 0xb04a1927, 0x9a7a2a62, 0xd1dae844, 0xe8cee6a1, 0xad3cb750, 0x8410d2a9,
		0xb0d21e5f, 0x69304566, 0x25936419, 0x3c3812d5, 0x345a80d6, 0x68253721, 0xe1e11411, 0xda77501d,
		0x9c9ec067, 0x9313e0a6, 0x257e8393, 0xa7194c17, 0x5cdd3529, 0x63e476da, 0x26467ee2, 0x4cc64668,
		0x45209324, 0xd4b76848, 0x53dd53e9, 0x3882487e, 0x14a6c125, 0x14e237d6, 0xba1d1a5c, 0xa687246e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2d2e4fa2, 0x67cde2c4, 0x58cf8e70, 0xbd245016, 0xbb8a4a1f, 0x6a84a1b2, 0x895f7d6b, 0x462333d1,
		0xd6c1ae59, 0x3cbae228, 0xb74c3535, 0x9140b158, 0x3e816545, 0x9f314932, 0x1729aa60, 0x1cdbc275,
		0x3119b356, 0x67e7b2c8, 0x392bde67, 0xa563dc2a, 0xdb8313ca, 0xc65255cf, 0xc1507d6c, 0x3d8362d4,
		0x77c43aca, 0x21dd9fae, 0x3e62af5a, 0x31183e2b, 0x7d8c1024, 0x19703593, 0x77ceb1bf, 0xbc5e3ed5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x7328da2a, 0x5c2a1879, 0x6b11613e, 0x27a1db1b, 0x8493383d, 0x6317361e, 0x98be46ae, 0xd3d39d38,
		0xa6d1b761, 0x4eea44c5, 0x68e7ae44, 0x9cae6b9a, 0x98916867, 0xdf8aa1e7, 0xca1cd468, 0x9792167a,
		0xba248dc1, 0xe916947b, 0xb74b979a, 0xc7a6168f, 0x5d817fd3, 0xc378e81f, 0xb2977e1f, 0x1bdcab7f,
		0x52af38a0, 0x8ba97838, 0x24c9d698, 0xbd142796, 0x585b59d5, 0x26497a19, 0xd671dcdc, 0x516315e7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd0b1712d, 0x23763999, 0xe8a26e6a, 0x933beb72, 0x2e18b19e, 0xd4627f9b, 0xd97f123e, 0x72685696,
		0x1f263b75, 0xa1c02586, 0x16ac1643, 0x5ea619c1, 0x628d895d, 0x4d516688, 0x65ba922c, 0x9278e02b,
		0x7dbe4fcb, 0x6336879b, 0xc4e08a52, 0x32e28f69, 0x9cd79944, 0x5d7b7a80, 0xd63f82d6, 0xc41c4445,
		0xb3ba8a84, 0x591bcf9c, 0xe25acac7, 0x2477e2e5, 0x8114c080, 0x3e6c2b44, 0x1cc09bb4, 0x439987a5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x6813caab, 0x99d66c4b, 0x16ccb41a, 0x48aa833e, 0x94d1dc68, 0xe08ba273, 0x727dbcd3, 0xdb9c3c32,
		0x1e7a1396, 0x583b8545, 0x9a772634, 0xb32a97cb, 0x7b73c82b, 0xa06271ce, 0xa14bc186, 0xe88d8b66,
		0x5831d274, 0x8b688b4d, 0x5e31b668, 0x9f398f96, 0xbbaa64d4, 0x6e5bc03c, 0x512588d9, 0x7fd5e425,
		0xbde75574, 0x68eac925, 0xc0cd88e8, 0x1e63b73c, 0x1c9469dc, 0x5fda2437, 0xe0ddcc46, 0x9120b611,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x17df30c9, 0xe06eae6a, 0x8a8d572a, 0x22347d5c, 0xda2bb575, 0x88909f81, 0x3db78db3, 0x56904dc5,
		0xa1133fc4, 0x503887e0, 0x3f48dd16, 0xbf132eb9, 0xe3434aa9, 0x21bfc3dc, 0xa2878599, 0xbed2d04c,
		0x4a316298, 0x85b09f6b, 0x62d13fde, 0x54651638, 0xbad6bccc, 0x1a17e12d, 0xda47922a, 0x2773d421,
		0x705a7572, 0xb7836587, 0x9969131e, 0xabb78053, 0xe2233133, 0x8ab763cd, 0x8cca916e, 0x5eb4a3e1,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xba835785, 0x1f1a251a, 0x8cc33598, 0x2093dbcc, 0x25b93fc7, 0xa77274c4, 0x3a5360bd, 0x9a458a96,
		0xcea9c123, 0x89b72b9d, 0xbc1f84c6, 0x8362978a, 0xbddac422, 0x878a82b1, 0x6893b968, 0x146ad3bc,
		0x53c3b45a, 0x522ec31b, 0xd02eded7, 0x2e89dc2b, 0x997dc32d, 0x3e8dda56, 0xbaa69d7e, 0x9aae1337,
		0xa8caeb7c, 0x6a9e7fe9, 0x6ee84421, 0x12943d4d, 0x3e78163c, 0xbddeea50, 0xd987c651, 0x879a4e81,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x98b767bc, 0xe8b68838, 0x1b914c8a, 0x44eabeb1, 0x2bc45680, 0x62312362, 0x6b2c3613, 0xcd991782,
		0xa485bc6b, 0x25dc4d5a, 0x57d8d38c, 0xd93b183f, 0xe480824c, 0x1aa0874f, 0xce6d81cd, 0xa33194d7,
		0x742b1297, 0xcd9d1a38, 0xcadadb55, 0x2da54c70, 0x597d7aad, 0xdadeacb3, 0xcd67ab1f, 0x1faa5c67,
		0x8a7fda93, 0x5e5f3c6f, 0x3f924216, 0xe8d7cb2b, 0xc3b8191a, 0x1f75dc76, 0xea1190ca, 0x31b193ab,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x8d9f5c92, 0xa7891fc2, 0x14d39cdc, 0x8d5e2ae8, 0x124c1c7d, 0x93a78737, 0xce42ea6c, 0x11acab89,
		0x238131c0, 0xdfa61316, 0xcbbb1142, 0xe67a69b4, 0x7feb5e4d, 0x9325d591, 0x1d17bb11, 0xb12813a0,
		0xab233274, 0x3e435fc2, 0x54433531, 0x51b91f2b, 0xd5d6bd95, 0x3431586c, 0x3763bcc3, 0x6d68cfb2,
		0x145641b8, 0x93a176d0, 0xe841e7d8, 0x9aa573c8, 0xbbe23cab, 0x66563a66, 0xc147cb22, 0x361a9681,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x993939e2, 0x3870a3dd, 0x77ac4ab1, 0x1fa5d395, 0xb42c6ebe, 0x611fc440, 0x8794c513, 0x1f818fab,
		0x27a0d645, 0x201756ad, 0x5ea4d3c6, 0xaa44b031, 0x67665723, 0x3ad08d9a, 0xe86b89c6, 0x3f4e2b16,
		0x1eaa3aca, 0x5ed9b4dd, 0x461fa56c, 0x9ac65638, 0x55abb1c1, 0xe23db95a, 0xae9ed0b5, 0xaac3923c,
		0x254fdae9, 0x2c895453, 0xb0d17ab0, 0xdfdaeb6e, 0x251b7b35, 0xb682bb1d, 0x5c4b9aeb, 0x978e56e0,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xbc63dad1, 0x796b5c8a, 0x671f32e5, 0xb1e52893, 0x5c657167, 0xa550dc81, 0x7449a3bd, 0x1c199fe7,
		0xb1e118b4, 0x7fe53b68, 0xca93845f, 0x2575106c, 0x9da76fab, 0xc6eb8d6d, 0x9d8ec85b, 0x2aa4de13,
		0x84e529c0, 0x51a63e89, 0xa270732b, 0x2ccb1396, 0x91da5455, 0x5025187f, 0x7d39e5d0, 0xd4df81bd,
		0xb968104b, 0xe217afb2, 0x748db779, 0xda987bd2, 0xba1ad971, 0x341da678, 0x981fda93, 0x7856b1eb,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1b418560, 0x8c7a24a4, 0xc1e0539c, 0x8d42bbe3, 0xbe1a2354, 0x875ecc1b, 0x933983b4, 0xe24cdc62,
		0xe3678b53, 0x417d9f21, 0x5587dcc6, 0x3330408c, 0x46d2a52d, 0x8074d3e3, 0x16819b85, 0x6f4c739a,
		0x25d3db56, 0x1688b3a3, 0x8d597a4a, 0xbfc93269, 0xad84842d, 0x35c62cd9, 0x7f122236, 0x10bd9c7b,
		0x1ba47696, 0x1f27ad34, 0x344ebe33, 0x8dbddd3e, 0xc1e07983, 0x97deda9b, 0x989fafd2, 0xb54dc9a3,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x6dae1869, 0x719cd84f, 0xa95daeb3, 0x8d72d6a9, 0x26286285, 0xde4995c8, 0xe56766d4, 0xbb4168d3,
		0xbfe977dc, 0x4496a5b5, 0xb7832542, 0xd450658f, 0x3de81d61, 0x43488545, 0x3042de69, 0x3624a0ce,
		0xb9759865, 0x897d5c4d, 0xe0b6bac7, 0x9bbeb58f, 0xaa876349, 0x9268198d, 0xb3273da0, 0x175ce255,
		0xdf255612, 0x7ab84d91, 0xcb1492bb, 0xd26c586a, 0x3ab4376b, 0x28327987, 0x5d1018cb, 0x72749fe3,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd6cf6d12, 0x29d2c267, 0x1f50674e, 0xb29b76c0, 0x4a8e501e, 0xd11038cf, 0x8dd24b40, 0x81d41f83,
		0x44b2b995, 0x87564d6d, 0x3984158c, 0x50d77f76, 0x81e88f6b, 0xeb677f4c, 0xeaaeb7e5, 0x582b8dad,
		0x89a63c13, 0xd0871765, 0xc2ab58c9, 0x9cacbe2a, 0x87e2cfa8, 0x8ac2bc79, 0x3e7a5b57, 0xe7977a4a,
		0x6fa48c76, 0x38136c12, 0x82bd3158, 0xce81a47a, 0xdd731329, 0x9ead5f3b, 0xc32dcd7f, 0x8bc932d0,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x7aa3aa35, 0x8e40bb10, 0xdab55848, 0x20bc7a4d, 0x4e71cbd6, 0x60909130, 0x689e33b0, 0x354bdf4e,
		0x4f9d745b, 0x30977424, 0x938badc6, 0x5ee88e40, 0x39d4434a, 0xc1d0bf1b, 0x8de9243e, 0xd661363a,
		0x708ca33e, 0xe8a3bdea, 0x3138304d, 0xc1934f17, 0x44baeb6f, 0x1d1e5c99, 0xd72c7b37, 0xca943c58,
		0x86683ae8, 0x38cc2c6d, 0x359177c3, 0x8120e36e, 0x161de899, 0x41978d93, 0x12193bc9, 0x2572606a,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x352bcdd3, 0xc79ec426, 0x47b384a1, 0x90d6e12b, 0x32ab1a1a, 0x6610c2a3, 0x77a71e6d, 0xb3601332,
		0xdea9832e, 0x187e3db6, 0xe8983417, 0x258592ca, 0x3eaa15dc, 0xa0a86c8e, 0xd118dd2f, 0xd4c67a50,
		0x6e2415e2, 0xd2d49924, 0xe5384131, 0x30714255, 0xbdebb77b, 0x2831b115, 0xc81d9e3e, 0x99532b82,
		0x444d3d8a, 0x77506cc7, 0xbf6a8943, 0xc8263d44, 0x7a8d25de, 0xcacb25b2, 0xdcb01acd, 0x194a4b8d,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe442d833, 0xd233deab, 0x1e49e97d, 0x48e7ce5c, 0xd263d17f, 0xe34acd70, 0xb711e752, 0x44364d32,
		0x3bd6e8e9, 0x41e6846b, 0x5eab6234, 0x7d878a5c, 0x9269e168, 0x89cb5fc9, 0xdacd4fb5, 0x517f7b11,
		0x834c4a49, 0x8f3c84a7, 0x4cad8c74, 0x9f4898e5, 0x3b9832ca, 0xab22dfa2, 0xeb4ac36f, 0x57af44c6,
		0x89559539, 0x1b544e45, 0x69496790, 0xc59267dc, 0x50e75b1e, 0x816fe29a, 0x9139698c, 0x6a51d15c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xcee8caeb, 0xb0b82dbf, 0x5e53abb9, 0x251543dd, 0x77745c4b, 0x2160b174, 0x4f93d65f, 0x9eaab44d,
		0x1c49c5d6, 0xaa196e1f, 0xabc45d44, 0x8d1377ae, 0x581413a5, 0x7b5c9acc, 0xa7753119, 0x2b673a5c,
		0xb027672b, 0x1f947fbb, 0x1cba353b, 0x581774ea, 0x749d3b81, 0xc8cce88a, 0x64b5ebc8, 0xe0cc8a49,
		0x767d67d2, 0xdcdaad9e, 0xeb2e10cf, 0x7988867a, 0x7450afeb, 0x415d2d4a, 0xe56e4de1, 0x3b8838b4,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xcf67a366, 0x60756865, 0x2bd0a879, 0x271719d5, 0xd7dc735b, 0xb1536ead, 0x1978c995, 0xe6de6b82,
		0x83b91dd0, 0x78a9d6ae, 0x18e32344, 0x53e15ae3, 0x6c863fb8, 0x76394098, 0x39c98515, 0x627e9352,
		0x18936a88, 0x5d248b61, 0x565f1761, 0x36bab466, 0x8e1fcf7c, 0x8176c9a7, 0x11813a6d, 0x7aaa20c3,
		0xe9c78d9b, 0x252ab019, 0x8d196123, 0xc0e599d7, 0xe67f45b2, 0xe6969c9f, 0x2373a114, 0x681239b8,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe774625c, 0xbd46b278, 0x63e7dd98, 0x4f115442, 0x3dc23aaf, 0xdd23e241, 0x1699bd18, 0x40d44ed2,
		0x936fa5d6, 0x87dfe061, 0x5c2c9136, 0xad5d311f, 0xcee18aa2, 0x7b612d2b, 0x6c106da6, 0x17c4aad2,
		0x72b15585, 0x6ea4a773, 0x1e7832e6, 0x387a7a32, 0x88d637bc, 0xb2da831f, 0xcc89673a, 0xdd4abd7a,
		0x29562c71, 0x8ad85471, 0x2be67c44, 0xbecca13d, 0xca99d650, 0xb83e76bc, 0xdd458bba, 0x14a7d469,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x3a36e5cc, 0x132b321c, 0x2994713a, 0x9ae014dc, 0x5e248d6b, 0xa5ab52e7, 0x451ab69e, 0x648c5c61,
		0x4d47a5ea, 0xd5ba8d13, 0x9c57ca19, 0xbd41d81c, 0xa24b1761, 0x8ad26262, 0x63ddc417, 0x295e7f23,
		0xe483261f, 0x515bd417, 0x4f298713, 0x6031a451, 0x622d2b62, 0x7e3e17a9, 0xdecf9730, 0x5487ab4d,
		0xcae42154, 0x545077c7, 0x9fdd6458, 0x743d9f62, 0x209ea99f, 0x953098a0, 0x80c3e43e, 0x1d8f50a3,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x818774dc, 0x16239e2d, 0x58b73e3b, 0x2fca3811, 0x5fba916a, 0xe33577e7, 0xa7b6b071, 0x75e097e6,
		0x8c401f2f, 0x883cb79f, 0xd889ceca, 0x858a99d8, 0xc57c9dd2, 0xa2b3de62, 0x1f9eb11d, 0x962712d7,
		0x92e5bb35, 0xe2263528, 0xea4e3a7b, 0xacbd54c1, 0x1db8ab4d, 0xc25a608d, 0x4674c94e, 0x9385c43b,
		0x38b76a44, 0x5e493c40, 0x34db185c, 0xbb14916b, 0xa18d99c3, 0x7a6d254d, 0xc334d259, 0x81a76789,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdf8bc48a, 0xc82f3eab, 0x1570449c, 0xc5aebe73, 0x41cd44ae, 0xbd777641, 0x60b1ac6d, 0x751921aa,
		0x745aca5c, 0x7b3f8550, 0x34c09f90, 0xdf5d4f9c, 0x5a97663d, 0xc3dec62a, 0x7c2d33ba, 0x841f3e5d,
		0x561e5bc6, 0x6ae182a5, 0x37e72667, 0x426667a7, 0x93c0dc7b, 0xa15483a7, 0xbd582295, 0xc1442d43,
		0x2bab2d40, 0xa9c38095, 0xa0de7352, 0xba527757, 0x9466a8be, 0x6a19d59e, 0xcb50562d, 0x66123b1c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x784321b2, 0x6f4fcabb, 0x3c9f8581, 0xa489cc4a, 0xde5c835a, 0x33954fad, 0x4ceaab90, 0x63cdb288,
		0xe1961396, 0xb0c4d0da, 0x67213a47, 0x1497d543, 0x3d9d4c5a, 0x13791996, 0x9e682535, 0xce47286c,
		0x31c3bd19, 0xa1d4dfb5, 0xc93c4cb1, 0xd8e2dcde, 0xea45bd12, 0x1b2a7f1b, 0x8c795928, 0xdda09f66,
		0xa5c1454a, 0x58e565e8, 0x2ce79939, 0x70195327, 0xd62ad58f, 0x62eb14b7, 0x993c4999, 0xa688a938,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x288a407a, 0xc6828b5c, 0xcc6423c4, 0xa85d6074, 0x8144734a, 0x2191dc74, 0x6a85addc, 0x3f659481,
		0x1b188ddc, 0x4813be88, 0x96647ecc, 0xb95b74aa, 0x6e8d514c, 0x475e8fca, 0x84718846, 0x979eab26,
		0x253e2bc3, 0xaada7155, 0xe9e1ac81, 0xb77ad98c, 0x45224dc9, 0xe9b854a2, 0x8dd693bf, 0xe7be5fa3,
		0xc61cb260, 0x48abca5f, 0x901a8c12, 0xb84824b7, 0x89b44436, 0x64517699, 0x2ad1acbe, 0x6852d5dc,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xcb8547bd, 0x13ca5c69, 0xea9fd68c, 0xd0295713, 0xde85137c, 0x86696770, 0xbb5cb175, 0xe59aa294,
		0xb7977f55, 0x21bf4f36, 0xc1ad8d66, 0x3885e319, 0x12687415, 0x858d70c7, 0x2f4a7f13, 0xbd48126a,
		0x2e4a5c31, 0x85191362, 0x974269ae, 0xbce85c8a, 0x5c5869e7, 0x7749de82, 0xbf95d0a3, 0xde9e4b1f,
		0x92749883, 0x7818d0b1, 0x13304ab7, 0xb8dcc44f, 0x8a4dac8e, 0x70dd4442, 0x5c5ba59f, 0x844abf51,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xaa33349f, 0xeb493de4, 0x9570e7b1, 0x43c9b1df, 0x41413e18, 0x861fa7a3, 0x626fb836, 0x9d92dcc3,
		0x1f5bc6b6, 0x3a365dbe, 0xe72167ce, 0x4a3a6c47, 0xdf2db58f, 0xcc2c998b, 0x7acde774, 0x6222125b,
		0x50e57419, 0x3246a2dc, 0xaf17605f, 0xe57143db, 0x54e6376d, 0x7b916699, 0x4a9133af, 0xc43e6492,
		0xe213d3b3, 0xe8e27926, 0x6f4aaf73, 0x6f1f7fa5, 0xdaac57bd, 0x85d85a8f, 0x538e3239, 0x2073674f,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xa071e520, 0xb9b72f14, 0xabb6565c, 0xb5869245, 0x60561ad3, 0x218dc030, 0x3ec1c21f, 0x434a6530,
		0xe9418747, 0x942eeb6a, 0x2d76e94a, 0x1355c658, 0x44b938e0, 0x41162d18, 0x8b44e392, 0x632babd3,
		0x8858747c, 0x8f8865e8, 0x54609070, 0x57cf8ca0, 0x2b148f37, 0x1cb7a3e6, 0xe2c974e3, 0x987ca843,
		0xdcaf8715, 0xbd76a076, 0xc66ce01f, 0xb9a42ee0, 0x9c1b20c1, 0xa442b7a5, 0xeb92306a, 0x19caa8d5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xad62a01c, 0x595e318d, 0x4e94d965, 0x713ad5d9, 0x5ec4821a, 0x34d7b3cf, 0x4a73ce31, 0xb19f1a93,
		0x81499dc2, 0x52a73e15, 0x4ad15b95, 0x70d6384e, 0xd153b52a, 0x9b4ae449, 0x60657468, 0xc162261d,
		0xd85a597f, 0xbddd3886, 0x62411ee0, 0xca495cb8, 0xc0789845, 0x34b8ba8d, 0xd262b965, 0x597b3ceb,
		0x7e90905f, 0xd38c69c6, 0x3d93dc99, 0xb9b3ae23, 0xac50e39b, 0xcbd27f83, 0x6b649e56, 0x6d74a72b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd1e34493, 0xa8194399, 0x5be6bbce, 0x51c39fe2, 0x3eaf9981, 0xbe2380c8, 0x8a62dc6b, 0x33b6d736,
		0x9d722b6d, 0x51c7109a, 0x645674d1, 0x83e17b27, 0xd1b47426, 0x22c92b41, 0xd65675d6, 0x9eca3cca,
		0x6210261f, 0xbe6b1b8f, 0xdc96c1d3, 0x87978e45, 0x58575197, 0xc397aa6a, 0x183924ea, 0xe53bd8d1,
		0xa59313b6, 0x4d47b138, 0x8bc1a429, 0x714c4625, 0x2f6ee84b, 0x21d18e29, 0x8de1a0d7, 0x414e64e7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x313ca9a7, 0xcac36634, 0xd1d0d6ba, 0x5768cc62, 0xd8166250, 0xe527251a, 0x208e12ce, 0x7f8de4cf,
		0x62bdeb25, 0x908d6044, 0x7abe5922, 0x4d76b3c0, 0x442452d4, 0x8fb695de, 0x3416e822, 0xd784ea4a,
		0xe155b73b, 0x93e8eb2b, 0xe283c34a, 0x68dd4825, 0xac909650, 0x1253737e, 0x6d4d6ebc, 0x8299c3d2,
		0x77b7c63e, 0xe3849b86, 0xd5183886, 0xbc4cb0e6, 0xdb7830ad, 0x5c3fe573, 0x72513838, 0x7157bb74,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x83241a5c, 0xbda5993d, 0xd6524f29, 0x81e28132, 0x78b1b662, 0xa6e38080, 0xc61b257d, 0xb82640a6,
		0xad4c48c7, 0x34d452c8, 0x8a50e541, 0xaa73e160, 0xe1594d7c, 0x2a136b68, 0x338113e0, 0x906e7b51,
		0x9a4e52d2, 0x389d1332, 0x75e42120, 0x6e406456, 0xe1448b4e, 0xb3c715c7, 0x199eb9b6, 0xe9b7db13,
		0xcd2117ae, 0xde6828d3, 0x3e5173d4, 0xbdb232af, 0x1e6c72e5, 0x9fd4a785, 0x1d6c402e, 0x218fd088,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x129b4e8b, 0x849adcb2, 0x6849ddd4, 0xd1789755, 0xd3cabab9, 0xdfa1b43f, 0xc2c13c54, 0xe05ca599,
		0xa1dad699, 0x18c0c36f, 0x97c36250, 0xbed526c0, 0x137a67d6, 0xaa968794, 0xd3ba8a7d, 0xa587a5e1,
		0x6ad6b12b, 0x8d6528a8, 0x74dd9556, 0x9977e3d7, 0x19513190, 0x153c6d6a, 0xd3502cd8, 0x63984349,
		0xcd889850, 0x3ecc3243, 0x80917a38, 0x75a2865c, 0x8b4ad117, 0x12d8b15f, 0x6856b8bb, 0x2d1ba24a,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x93c66859, 0x1ca454b9, 0x63b2ca26, 0x69e235c9, 0x335e6e77, 0xb33cc235, 0x14c95554, 0x195559a5,
		0x3eaddd78, 0x3d53d616, 0x9f608552, 0x89c13d28, 0x71859e2a, 0x5787eb8a, 0x5cc396b0, 0x3bcf8e42,
		0x52361adc, 0xb3424caf, 0xdb6e67ea, 0xe8a6e9d0, 0xeab76239, 0xca6a9f44, 0xe33e7d47, 0xa639b19a,
		0x753593da, 0xb9d6bc8d, 0xbdd64c68, 0xc11dcdc9, 0x6a1473d6, 0x684a25de, 0x7810c626, 0x95b23293,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x4fa56ba2, 0x63c1b751, 0xc9b513b4, 0x276835b2, 0x504baf7a, 0x238fa861, 0x7531707c, 0x1ce939cc,
		0x61a25d63, 0xa2688b98, 0xa3df7444, 0xe7384850, 0x407a182f, 0xeac4bb48, 0x859a369e, 0x2b6a352b,
		0x51254750, 0xad318146, 0xd0747227, 0x81ce763d, 0xbf994326, 0x3e74a954, 0x4b69d1bb, 0xd877712a,
		0xa4e0e295, 0x9987e8d8, 0x1a45c68b, 0xc3da2e3d, 0x98a43290, 0xcae3bd49, 0x4c746827, 0x7e9c5d8a,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2237548a, 0x7d165056, 0xbb4f72c5, 0xe5c39912, 0x4b919fc0, 0xe6bf68c3, 0x2eb18ecc, 0xe9634532,
		0x2bb7325c, 0x6b22be3c, 0xa3892f29, 0x1f14495b, 0x5d5a8be7, 0xab70d1aa, 0x73414745, 0x7935749d,
		0x67a45b3e, 0x7936c74b, 0x5311b79f, 0x3f1266d8, 0x74d5b157, 0x2b5c8d9a, 0xc2d24b7a, 0x1b775cb0,
		0x7ad0ab5d, 0xbab9b545, 0x4f97309f, 0x7c456071, 0x3842101f, 0x57ebc157, 0xc2a77abf, 0xc2b6452d,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe8582511, 0x695bd4c9, 0x3c5d2e59, 0x113a829f, 0x28523f6e, 0x69ccde7f, 0x1994af69, 0xc97b7d8f,
		0x7c135c62, 0x755d94bc, 0x9e3891da, 0xc7573e49, 0xca254198, 0x746654d3, 0x2593c983, 0x452f73bc,
		0x94d656a7, 0x174d41bd, 0x3f225999, 0x222ab8e8, 0xe68ccecc, 0x8e204a3a, 0x8f9ca562, 0x28387275,
		0xd7e1c933, 0x4091258d, 0x7f1341a4, 0xc9168788, 0x25a6e861, 0xca62302e, 0x1fa92036, 0x8622c759,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xeb2db712, 0x28b38dcc, 0x26df254d, 0x3d85d0a1, 0xc06d6c60, 0x63b65071, 0x36b3d22f, 0x9654e12b,
		0x766ddc74, 0xbf3fe85f, 0x95cabfa1, 0x4a25271b, 0xa7b5151f, 0x48a71dc5, 0x79b3df7c, 0x6e582e87,
		0xd9bc38af, 0x6479a7c0, 0x96a63619, 0x2a3a926f, 0x5c9b9baa, 0x8d9dbc11, 0x8ea32573, 0x2497b555,
		0xdc386015, 0xe2ea13d6, 0xab6f1e9a, 0xcc4ea183, 0x61192578, 0x6c23c1a9, 0x1f7a3843, 0xa59a2b32,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2892568e, 0x94445661, 0x7a1e55a0, 0x8ec9a319, 0x5de04996, 0xd57c7999, 0x86331c1c, 0x51ca93bd,
		0x19e8d594, 0x6ea3dfdd, 0x8885b859, 0x6059e2ad, 0xd355e258, 0x25562e80, 0x91a3892f, 0x18b184db,
		0x5956dc56, 0x83b74154, 0x7ac34bd2, 0x5642ce47, 0x8d2819ca, 0x271b2b1d, 0xc1e782ab, 0xe8b7474f,
		0x8b8d4ce0, 0xe8e98140, 0xd2d3a182, 0x8710b162, 0xeb535d65, 0x162fbe11, 0xbd1ac0e6, 0x45652893,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x58aab7aa, 0xd4c33062, 0x5cabbd77, 0x2828dabf, 0xb6d0b134, 0xe21f7a1c, 0x2dcd4432, 0xd625738d,
		0x42a846c0, 0x5dac787f, 0x76477edf, 0x2c17b647, 0x72bb1767, 0xe75186dd, 0x6e62a579, 0x1c5c98dc,
		0xcb7e8d78, 0x742fc856, 0xc8799a33, 0xa8439171, 0x9fe82353, 0x39515160, 0x4a8ce331, 0xbf97e164,
		0xbf268ddc, 0x528f8f86, 0x1961155c, 0xd338b725, 0xe877b328, 0xa686271c, 0x4666dc68, 0x4160bfa1,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x9f752564, 0xe67b1ad1, 0xa8d285ac, 0xc35c97db, 0x133cca15, 0x8a7a55b1, 0xe2c76f71, 0x6e1e7e79,
		0x1389e81e, 0x8d5b8f1f, 0x61eaea7a, 0x8c3b7e9f, 0x5e2f444c, 0xd6974928, 0xebcb557c, 0x7d386888,
		0x7a5b2438, 0x389583c4, 0xa3a247d0, 0x433cb710, 0x924ab81f, 0xc26450d8, 0xe26d6abb, 0x8539cb93,
		0x9cbd47e4, 0xd9b641cb, 0x38d03126, 0xd7c6b1a6, 0x56874b9d, 0x634cb3cb, 0x6e818d80, 0x998a385c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x22d05499, 0xca4714d1, 0x81908666, 0xa788b76d, 0x2ddc933b, 0xaab3e59f, 0x13229dd7, 0xceb3b57f,
		0x6a8d2864, 0x218c499a, 0x47b746e2, 0xa3c53bdc, 0x996a91e2, 0xcf4a5417, 0x5129753b, 0x5d42d4be,
		0x3fc67e74, 0xab344fc3, 0xe8632d14, 0xde2d63dd, 0x64e02331, 0xe75527ab, 0xd08cd091, 0x3879e1de,
		0x239b561e, 0xc4827033, 0x546918be, 0x93df9f30, 0x1380dde8, 0x2a5cab67, 0x5c69b052, 0x70e24b9f,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x99e06b6e, 0x81261f63, 0xc4c2bf7f, 0xb0ac5e50, 0x261ee8a5, 0x66c973c4, 0x5197cd8b, 0x412f3c9f,
		0x6ab199b7, 0xd2628139, 0x288b4a61, 0x70dbc921, 0x458f1f74, 0xd14aa5a9, 0x58312a8f, 0x9a7b21a1,
		0x1be6bf4f, 0x14c22b55, 0xbb994d93, 0xc3177344, 0x18161985, 0xa721b4b4, 0x16e85c8f, 0xb47a4667,
		0x2e99ba40, 0x14d04376, 0x6ae5a66d, 0xe0818279, 0x1e63b12c, 0xd6b7e9a6, 0xea2266bb, 0xa48f1d8e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x4aa268bd, 0xe6193a62, 0x948d571b, 0xdeca6884, 0xdc931176, 0x99bbb544, 0xc36c2467, 0x7e47cada,
		0x131c833b, 0xe7bb5bb3, 0xe26419ab, 0xd07a7025, 0x419fa7b6, 0xdd936328, 0x24e3509e, 0x57e5e330,
		0xebb8e8a4, 0x2b881652, 0x1b66a696, 0xccd5e5d8, 0x87819a41, 0xdea63e17, 0x6aa5c8b6, 0x443cb4e6,
		0xbfb9986f, 0x81c593b9, 0x7c8b25e8, 0xe58b5ba6, 0x7731a523, 0xb08193af, 0x62858dde, 0x576a872b,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x12184daa, 0x422065cd, 0xcfca2917, 0x55ded52e, 0x9686a28b, 0x678ad1d5, 0x8c7e596a, 0xa920a954,
		0x4283c2a7, 0x61b8b350, 0xbb4490e8, 0xe87fe8e8, 0x8a9a72cf, 0x174b684b, 0x9089e668, 0x6fa18848,
		0x1a3f1b98, 0x166213bd, 0xc1a75e1d, 0x1fafdee2, 0xd668cd41, 0xb12d7e8d, 0x159f5929, 0x9c9a71a5,
		0x1d1fcaab, 0x515f861f, 0x8a364a78, 0xa11f28b7, 0x43c6b5cb, 0x9396857f, 0x79b749bc, 0x6875b050,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xcd1d1937, 0x4c3ba0ca, 0x97a13371, 0xcd10c92a, 0x31d0e3e4, 0xac36c7c0, 0x87ce9197, 0xc297b2c4,
		0x19317a45, 0x1a5caec9, 0x8f2ad33a, 0xb6ea78b4, 0x457f5abd, 0x364fb437, 0xc1da35c7, 0xe48dc6e8,
		0x3c55122b, 0xae501fb9, 0x19814fde, 0x72815e62, 0x29a9af86, 0x206c985c, 0xced6caa0, 0xe2bb5b7d,
		0xdc827619, 0x627a1b5f, 0x93c33cd6, 0x1418c5ab, 0x5c69e36e, 0x8019bd17, 0x56b97454, 0xd3af9622,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc3b1a83e, 0x29691057, 0xc9eb7850, 0x8d154377, 0x8798d5a5, 0x8d9a95e2, 0xb47ecb10, 0xc9d0e874,
		0x76dc87cc, 0x15824c63, 0x6015e15a, 0x3ce0d963, 0x504f6181, 0x5e9c6bc5, 0xb71ed0e2, 0xd8a7c359,
		0x751fcb39, 0x3d503d47, 0xb7ce7947, 0xea4c4132, 0x38654131, 0xe2888a62, 0xde6d6065, 0x3c9d6f71,
		0x682b766f, 0xb43c2e9f, 0x997bd549, 0x19787c82, 0xc4d454c2, 0x76c36253, 0xd2893582, 0xbe3d3a7c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xd21e43c1, 0xb3ab6d52, 0x88ce1a8d, 0x7413203a, 0xbdb776ab, 0xe6db3e5d, 0x396b2c8d, 0xbdc96e3e,
		0x7ccce983, 0x504e68da, 0x2be2bb6a, 0x546154d2, 0xa7e5851b, 0x90596941, 0x71e824b6, 0x4d157d53,
		0xc67790c3, 0x7a666a42, 0xe2b3dc10, 0xabeb8756, 0x287a6021, 0x6381569d, 0x4542d651, 0x5e40b07f,
		0x7ad0ccd2, 0x6a80c0de, 0x99385d89, 0xb262283e, 0x9e4cbe10, 0x75dc4d57, 0x3829666a, 0x2ad57883,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1b199fe2, 0x3525d9ba, 0xb148d14f, 0x7ee5604f, 0xd553a317, 0xdb1d9beb, 0xcc966c56, 0x9f832022,
		0x2bdec448, 0xcb9a2574, 0xd0da606d, 0x23479f48, 0x7189c868, 0xcb61b061, 0xcca6c445, 0x1e8ed0d6,
		0x51843cea, 0x8a8ea7a9, 0x9b319e38, 0x92a653ca, 0xd4e82e55, 0x5c56d633, 0xbb547166, 0x6e8141a7,
		0x35bd9b66, 0x61681840, 0x97d88dbb, 0x26b2a5b9, 0xc68b6b10, 0x7e658025, 0x3e732ce9, 0xcdc17437,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x57a5e4a3, 0x658f7ab3, 0x6837e76f, 0xaed327b5, 0xcb4881a4, 0x6a18d1d3, 0xb621ae49, 0x70dcda21,
		0x60351919, 0xab8d62e8, 0x93d8ac60, 0x8593de7e, 0x8a194d89, 0x34b26148, 0x10331e6a, 0x4a5be228,
		0xd044abb1, 0x6ccb19a2, 0xbd2299be, 0x9d5a82b4, 0x84d188cc, 0xcce455db, 0x87a310a3, 0x6e82d9eb,
		0x74cabee2, 0x98d3ca7d, 0x8fa288de, 0x2d8d393c, 0x61b436c2, 0x91381e95, 0xe68d6247, 0x14dc2d73,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xabe333de, 0x68312b3e, 0x89995913, 0x26ba5091, 0xa395ea99, 0x71cbe214, 0xd3c51762, 0x2f19e33b,
		0x3e8a9ed3, 0xcb264081, 0x52dcc545, 0x9f6a3798, 0x146ecb81, 0x82745ad4, 0xd06bc34a, 0xd256b1e0,
		0x8b932517, 0x203f782b, 0x6e87cdc9, 0xcde23813, 0x143893ac, 0xd87389dd, 0x86538d2c, 0x5a44c16d,
		0x5e1c5c90, 0x33e343ba, 0x83725017, 0xc6cf9f7e, 0x4ac81f6e, 0xac55dfce, 0x75752d3b, 0x934a815c,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x39d646b7, 0x3dc2c935, 0x3893e216, 0xa099ddbe, 0x5a5f28d0, 0x1380cb68, 0x46cb5ea5, 0xb7cf3d6e,
		0xa0259dbe, 0x50419d18, 0xe9e5a91c, 0x6ea76095, 0xc9ae8d4f, 0xda7f994c, 0x7a7321c0, 0xda813f68,
		0x5c9662d3, 0x84a4e723, 0x88856057, 0x468651a1, 0x61d34ed0, 0x80ba9639, 0xb74031ba, 0x34a5d6e6,
		0xcc6c4e4a, 0xeb9a3a19, 0x7347be1d, 0x3b991fa5, 0x81c625cb, 0xd2bd2fcf, 0xa62c68c5, 0x93c493cd,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xbb7b3f31, 0xbf8b9a99, 0x4f25c879, 0x62701462, 0xce81ce71, 0x2d118d17, 0xc831a835, 0x526b9ebd,
		0xacbd14b6, 0x15dc9c89, 0xa01959bf, 0xd16e7f76, 0x14d96bcf, 0x5ed64568, 0xc349cc14, 0x62dc6779,
		0x444d8652, 0xb93f8a87, 0x301a2b44, 0xc022cda4, 0x8deb945b, 0x9edf7ca7, 0x4069b295, 0xd9c6399d,
		0xe4de9412, 0x2bd2b054, 0x5e231d14, 0x43cb6eae, 0x29af4a23, 0x2593a398, 0x9b8f392e, 0x12916210,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x79b12025, 0x39687d8f, 0xd02ce75f, 0x4a3f8b56, 0x45204856, 0xbe5b2ad7, 0xa0b119c8, 0xb7a44e4b,
		0x6199bdbb, 0x1b433e1f, 0x522fb079, 0xeb9d923a, 0x89136848, 0xc99b384c, 0xd2ca30dc, 0x47894b37,
		0x4493904d, 0xc1cb3d7c, 0x42243191, 0x8393d01d, 0x9a7f8c2a, 0x58e03c70, 0xd7d05c98, 0x8fa9a56e,
		0xa59555c2, 0x88b0c78e, 0x45e123d9, 0xdc87b29b, 0x20838d2c, 0x5cb5822a, 0x56c07a2d, 0xc98dcab7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x4d99c393, 0x62586f16, 0xe0a664a5, 0x56e3879d, 0x7a184d7e, 0x10817b16, 0xac9268a8, 0x2c9e2bd0,
		0x9b99decd, 0x612b5d8f, 0xdc4ad223, 0xbc5599be, 0x70128474, 0x61ab71d5, 0xa53ee081, 0x8766ca7c,
		0x5c8d82c2, 0x9b8edcdf, 0xbda16f62, 0x6a1f58c3, 0x876b323e, 0x8abeb16e, 0xc499e2c3, 0x344d615c,
		0xea6e6aa3, 0x4a3381c7, 0x28c8d0b3, 0x52aa106d, 0x664113e8, 0x9f45a95f, 0xb0c14fc3, 0x25b8152e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x383673a1, 0x5c5c72e7, 0x7db91b6d, 0x88a3e859, 0x8d68dfe9, 0xb484a567, 0xeaafb9b1, 0x6d5a3393,
		0x7fb979eb, 0xe8941f23, 0x866cc19b, 0x4473964a, 0xa6d8bd74, 0xde2a174a, 0x3e5c48bc, 0x47722b6f,
		0x893a5cd6, 0x4966b1d2, 0xc6b7e891, 0x778044df, 0x55b16594, 0x567923a4, 0xe59e913a, 0xa28d4862,
		0xda68d592, 0x4b39b923, 0xe2b66e7f, 0x5b563e21, 0x1ec5939d, 0xe9203b5c, 0xd0919537, 0xb738d62e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x3b62e44e, 0x2974866c, 0x8463e795, 0xde5bce67, 0x823445bd, 0x1864aa12, 0x7f2e31e1, 0x9bb26870,
		0xe81f693b, 0xd2a36092, 0x2b937a28, 0x5f1b8896, 0x4ead384c, 0x89d0df62, 0x764a21b2, 0x62ad25eb,
		0xcf761c89, 0xa4509557, 0x5c64bd44, 0xa9d99370, 0xde724953, 0x9b104b32, 0x5ce041b6, 0x22905c84,
		0x7284b78d, 0x8dc0945b, 0xbdaab23c, 0x1a686195, 0x24585428, 0x62471422, 0xb32f6f41, 0xcac178b7,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x55416175, 0xa5a0a95e, 0x19813541, 0x7ee83cc6, 0x575838d6, 0xcf2187cf, 0x46c5885e, 0xb7ccc868,
		0x1e83ae73, 0x22584324, 0xa9c1dc83, 0x312a6ec4, 0x446cadd5, 0x3ee33843, 0x74e36b62, 0xdb3cba37,
		0x50679fb7, 0xd1508a49, 0x5c86cd56, 0x244f6954, 0x6d8db756, 0x7b614cd4, 0xe283d07e, 0x6d549ac1,
		0x90c11494, 0x34111191, 0x93a4c2c6, 0x6ce27911, 0x78b13365, 0xc0b7358c, 0x5c79bae2, 0x5d9fb410,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x87b0a13b, 0x17e0dcbd, 0x1738994c, 0x4290e89b, 0xe8d6b656, 0x45973ee6, 0x41bde2e0, 0xc2a8787b,
		0xb52b6cb8, 0x8d8fa490, 0x45192dcf, 0x959f4ad7, 0x88166558, 0xd767b2c8, 0x366f4aaa, 0xd3d630e8,
		0xc3e62e83, 0xd2628ea8, 0xc73f3bc8, 0x9f99a288, 0xb723d69d, 0xd28d26cf, 0xbe63866f, 0xa5b5293c,
		0x5644a2a9, 0x1bbfe8c6, 0x65a39e66, 0x75e4864d, 0x3e193177, 0x4c979dbe, 0xa5919961, 0x4cabaece,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xcfd2c87c, 0x385744ae, 0x7f6259b7, 0x2b313fc2, 0x7dd0e419, 0x33e9aa57, 0x6e1862ad, 0xba4454a9,
		0x19d27f2f, 0x5e6ca720, 0xba532531, 0xb19f19ce, 0x3e873a8d, 0x9f349938, 0x99a699ab, 0x4ac34069,
		0x723e80cb, 0xa588a499, 0xbe6dbdbd, 0x64db6233, 0xe112a64b, 0xc597b625, 0xce803e88, 0xcad7c0ae,
		0xa3c4a8ca, 0x4338861f, 0x32a945d3, 0x3672876c, 0x52494c60, 0xbdc170b8, 0xb479ea75, 0x97e7665d,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x52a8d65c, 0x2bbe9930, 0x742554a4, 0x39a6d55e, 0xce46c220, 0x993d13db, 0xcd8ac0a4, 0xa07e5b14,
		0xdfbee78d, 0x6fca4d8c, 0x4f93c65f, 0x8428bba8, 0x43e12e98, 0x6f4dc74e, 0xc0ac7b67, 0x1fe0ea73,
		0x3824b8b1, 0x4ac2ca19, 0x44329e35, 0x4e39842f, 0xeb5a253e, 0x547e438c, 0x34dad6ca, 0xdfbaa65e,
		0x988a281d, 0xab32a253, 0xd7b59456, 0x89667d6e, 0xb562861f, 0x5b5a8b7a, 0x8730cf45, 0x6276b874,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xc931cbb7, 0xcb5d221f, 0xd35c8815, 0x6c38164c, 0x2415506c, 0x9a4932b8, 0x835d45c3, 0x74798e77,
		0x72ccc91e, 0xc0ce711a, 0xbad85680, 0xe9187465, 0x964a4078, 0x4ab1602b, 0xac81d0b8, 0x4e50752a,
		0x159ad838, 0x9d3424e4, 0x336cb7e9, 0x5c6c2d7d, 0xd61e3174, 0x5941854e, 0xa9959357, 0xe15fb829,
		0x3771d958, 0x77ae6086, 0x9cc7afa5, 0x93bf6855, 0x8a65dd8f, 0xdf3e11e1, 0x1f9148ab, 0x8834c838,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x7a4aa8b1, 0x6310977a, 0xc02b19c2, 0xc49e958c, 0x353d6b1f, 0x37312acc, 0x6d6ea92d, 0x36361219,
		0x8a1f2396, 0x76783884, 0x46488d92, 0x2a6e23e2, 0x5b7a6f2f, 0x2d8241ac, 0x5d26b8c4, 0xdaca9b69,
		0xe6c3df38, 0xc3956a63, 0x8c3e2f44, 0x90973940, 0xa03bc913, 0xd6bda145, 0x748d53e9, 0xd0a11beb,
		0x5a7a27a0, 0x84d09db8, 0x5cde95e7, 0x54a4491f, 0xad5377d6, 0x906cba33, 0x56c231cc, 0x2f229585,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x44176b4a, 0xaab24168, 0x3b6dc116, 0x65209c41, 0x27bd3616, 0x4ad2d73a, 0x88bc339d, 0xc28f9db1,
		0x4b6fae40, 0x6ca37c11, 0xaa9a9094, 0xd94ea268, 0x6e94bd97, 0x199f681a, 0xaf75368c, 0xe6997e55,
		0x16a1cdb2, 0xbc2fc050, 0x7383bcdb, 0xe8baa856, 0x4bb034d0, 0x133a9673, 0x72c315c9, 0xafa585eb,
		0x26a5a519, 0xd2977ce9, 0x1920473e, 0xa8131ea9, 0x422b2f16, 0x4be5cf2b, 0x54c18da7, 0x313e207e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2573165e, 0xc38dd6c2, 0x1f48c6a5, 0x2b762948, 0xd6b98d51, 0xd67482ba, 0xd66a9c59, 0x60aa7887,
		0x92e2b2d3, 0xa3746378, 0x2c165e89, 0x64953bac, 0xcf994dd6, 0x102bd82c, 0xc59323e8, 0x71961fca,
		0x3931a2cd, 0x87b74baa, 0xc361a619, 0x8ad69ebc, 0xb2a12b1a, 0xa36f64d7, 0xa359b7d0, 0x7a693e2b,
		0x79149e7c, 0x84e1d93e, 0xad44a062, 0xb2c3c33a, 0x25cae1e4, 0xebce4fc5, 0x15907b3d, 0x918b4524,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x1c828310, 0xae7aa0ad, 0x6e9628b7, 0x16c419a0, 0x873293d0, 0x20d0e294, 0x7b562b3d, 0xc8877f79,
		0x81993096, 0x3ec8cadf, 0x8774d56e, 0x8166a4d4, 0xa389d7e9, 0x10ddb2e2, 0xa0818125, 0x59c35bea,
		0x73525e86, 0x2579c395, 0xa0b2cb93, 0x50e91a99, 0x1e10b084, 0xcf82e895, 0x2b2b7e23, 0x34ca2560,
		0x7481ebeb, 0x76d0d96e, 0x616ec578, 0x7422818b, 0x5778d5ac, 0xb825154c, 0x782ddb68, 0x6f2b2852,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x2b45d83e, 0x6b7c7b2a, 0x4a7da04e, 0x26306c6e, 0x1ae04ab7, 0xbe2b3fa5, 0x547f9a4a, 0x4224b185,
		0x1a73df67, 0x19c1d169, 0xddd73a46, 0x569d25e0, 0xc462a4d3, 0x1923d584, 0x403d74d2, 0x9c4353b8,
		0xc425ddb9, 0x704d6e12, 0xe89c4d8f, 0x3c19d6c6, 0x45b2e356, 0x9671688a, 0xc03c497a, 0xb81236b0,
		0x1935b18b, 0xa9647a9c, 0x109eb67f, 0xcac335c0, 0xd711e74a, 0x90a22477, 0x9f76cf4f, 0xaad5a52e,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x509838e6, 0xd7926613, 0x8fd77544, 0x5b6e458e, 0x682e8de2, 0x1d4052eb, 0x5ee42f7f, 0x855e34ab,
		0x386d2b44, 0x355f7bcf, 0x546648ea, 0xbd5e78d0, 0x58278d93, 0x2c8e62ca, 0x81a4d85e, 0x60cee633,
		0x5189688d, 0x8e362bd6, 0xbd1de4eb, 0x4c1e3c6a, 0x4dd2c76c, 0xd43d9fb4, 0xad89151f, 0x4ed2743f,
		0x42e5cc38, 0x407a9bca, 0x97d47177, 0xd613b9d8, 0xca6f3c9a, 0x708e7a6a, 0x8b8e58cb, 0x64d3df92,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x8e9e5b51, 0x3abb616b, 0x62ca8599, 0xb5a68224, 0x98b08074, 0xce313e8c, 0x9baba2dc, 0xb75bbd11,
		0xdc89a72e, 0x9280a457, 0xa2d620a5, 0xdc86c0a3, 0x3bb19629, 0x496936d9, 0x86dad081, 0x80ac5b36,
		0xd09fb5da, 0x7f31d251, 0x2113d9cb, 0x811ae160, 0x356e5cc5, 0xaec2af39, 0xcd38c1c7, 0xad78dcc4,
		0x15db61cd, 0x18385d1b, 0x3e34d561, 0x98a556d4, 0x2eb88ac0, 0x5bc53b26, 0x3b745126, 0x7a24d8a2,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xe2576438, 0x4b1c6c53, 0x9f55ce71, 0x57d645e7, 0xa6af234b, 0x3edcdf62, 0x2faf3c86, 0xd618986c,
		0x4cc79d25, 0x52466eba, 0xeb6fa050, 0xb1382059, 0x6b4bbc71, 0x6e8f52af, 0x50df5c5e, 0x1fba68c2,
		0x8c6ae9c6, 0x4342af38, 0xca7c2b2e, 0xdcea31a6, 0xd9627b87, 0x244798d0, 0x442393bd, 0x1fbb9589,
		0x6d164a93, 0x30759f47, 0xbc75283c, 0x12c1c3b3, 0xbc101abc, 0x4e6b4486, 0x8d2bbb18, 0x11818e5f,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x72a05599, 0x2e6d88a8, 0x695474a8, 0x1f226c44, 0x962b5265, 0x26877e6f, 0xd213b458, 0xe4729ee2,
		0x414ae829, 0x548eb741, 0x55eb11c9, 0x3d5051d0, 0xe9ab258e, 0x9e23b54e, 0xbab35ad2, 0x1a1b351f,
		0x5ec32952, 0xb4659c8d, 0x247e93cc, 0x7fd7bf63, 0x81af4b8c, 0x10865ac1, 0xc84b68da, 0x5bbf7a68,
		0x6e508867, 0x88598172, 0x5abd23e4, 0x1f684a77, 0xbd2ea58d, 0x4a5c93ad, 0xa28bba9f, 0xdf30dea5,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0xebebeb10, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb, 0xebebebeb,
		0xebebebeb, 0xebebebeb, 0x1010ebeb, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x10100000, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x20202010, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0x199d2d99, 0xc0d1b48e, 0x9ec65463, 0xe84219ce, 0x66db31c3, 0x86e9d1b1, 0xcb925352, 0xe08ed098,
		0xbccaac3a, 0x957ba3a3, 0x96912856, 0x5ccf774e, 0xdb198782, 0xd6de8491, 0xe956c824, 0x71879adf,
		0x47d12b58, 0x1c9d9973, 0xc4185a13, 0x47bdd571, 0xe678a8d6, 0x74a0d1e8, 0xa4b03e44, 0x84848b61,
		0x19aa4047, 0x45bee39d, 0xd030c5a2, 0xbe74a21e, 0x30377135, 0x51974f9d, 0x7dbb4de2, 0x51eb1097,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0x6ef0f05a, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0, 0x6ef06ef0,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x92108948, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x92109210,
		0x92109210, 0x92109210, 0x92109210, 0x92109210, 0x10a69210, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6,
		0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x10a610a6, 0x196e10a6, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236, 0x22362236,
		0x22362236, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca, 0xdecadeca,
		0xdecadeca, 0xdecadeca, 0xdecadeca, 0xf05ae792, 0xf05af05a, 0xf05af05a, 0xf05af05a, 0xf05af05a,
		0xf05af05a, 0xf05af05a, 0xf05af05a,