.\" dpkg manual page - update-alternatives(1)
.\"
.\" Copyright © 1997-1998 Charles Briscoe-Smith
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008 Pierre Habouzit <madcoder@debian.org>
.\" Copyright © 2009-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH update\-alternatives 1 %RELEASE_DATE% %VERSION% "dpkg suite"
.nh
.SH 名前
update\-alternatives \- シンボリックリンクを管理してデフォルトのコマンドを決定する
.
.SH 書式
\fBupdate\-alternatives\fP [\fIoption\fP...] \fIcommand\fP
.
.SH 説明
\fBupdate\-alternatives\fP は Debian の alternatives
システムを構成するシンボリックリンクを生成・削除・管理したり、リンクの情報を表示したりするツールである。
.PP
同一の、あるいは類似の機能を持つ複数のプログラムを一つのシステムに同時にインストールし、共存させることができる。例えば多くのシステムでは、複数のテキストエディタを共存させている。これにより、システムのユーザは好みに応じて別々のエディタを使うことができるようになる。しかしプログラムからすると、特に指定がなかったときにどのエディタを起動すれば良いのかという、なかなか難しい問題を抱えることになる。
.PP
Debian の alternatives
システムは、この問題を解決するためのものである。互いに置き換え可能な機能を提供する全てのファイルは、ファイルシステム中の「一般名 (generic
name)」を共有する。その一般名が実際にどのファイルを参照するかは、 alternatives
システムとシステム管理者とが決定する。例えば、テキストエディタである \fBed\fP(1) と \fBnvi\fP(1)
の両方がシステムにインストールされていたとすると、一般名である \fI/usr/bin/editor\fP は、デフォルトでは \fI/usr/bin/nvi\fP
を参照する。システム管理者はこれを上書きし、 \fI/usr/bin/ed\fP
を参照させるようにすることもできる。こうすると、その後明示的な設定がなければ、 alternatives システムはその設定を変更しない。
.PP
一般名は、選ばれた「選択肢 (alternative)」への直接のシンボリックリンクではなく、 \fIalternatives\fP \fIディレクトリ\fP
にある名前へのシンボリックリンクになっており、その名前が実際に参照されるファイルへのシンボリックリンクになっている。こうなっている理由は、システム管理者による変更を
\fI%CONFDIR%\fP ディレクトリ以下で完結させるためである。なぜこうするのが良いかについては FHS に説明がある。
.PP
When each package providing a file with a particular functionality is
installed, changed or removed, \fBupdate\-alternatives\fP is called to update
information about that file in the alternatives system.
\fBupdate\-alternatives\fP is usually called from the \fBpostinst\fP (configure) or
\fBprerm\fP (remove and deconfigure) scripts in Debian packages.
.PP
複数の選択肢を同期させ、グループとして変更すると便利なことが多い。例えば \fBvi\fP(1)
エディタのいろいろな派生システムが同時にインストールされていたとすると、 \fI/usr/share/man/man1/vi.1\fP が参照する man
ページは、 \fI/usr/bin/vi\fP が参照する実行ファイルに対応しているべきであろう。 \fBupdate\-alternatives\fP は、
\fImaster\fP リンクと \fIslave\fP リンクによってこれを取り扱う。 master が変更されると、それに関連づけされた各 slave
も同時に変更される。 master リンクとそれに関連づけされた slave とは、 \fIリンクグループ\fP を形成する。
.PP
各リンクグループは、いかなる時点においても、 automatic または manual の 2 つのモードのいずれかにある。グループが
automatic モードにある場合は、パッケージのインストール・削除の際にリンクを更新するか、どのように更新するかは、 alternatives
システムが自動的に決定する。 manual モードでは、 alternatives システムは (何らかの問題が発生した場合を除き)
リンクを変更せず、システム管理者の行った設定が保持される。
.PP
リンクグループがシステムに導入されると、まず automatic モードとして機能する。システム管理者がその設定を変更すると、次に
\fBupdate\-alternatives\fP がリンクグループに対して実行されたときに変更が認識され、そのリンクグループは自動的に manual
モードに切り換わる。
.PP
各選択肢は \fIpriority\fP 属性を持っている。リンクグループが automatic モードにあるときは、 \fIpriority\fP
のもっとも高いものが、そのグループのメンバーが参照する選択肢になる。
.PP
When using the \fB\-\-config\fP option, \fBupdate\-alternatives\fP will list all of
the choices for the link group of which given \fIname\fP is the master
alternative name.  The current choice is marked with a ‘*’.  You will then
be prompted for your choice regarding this link group.  Depending on the
choice made, the link group might no longer be in \fIauto\fP mode. You will
need to use the \fB\-\-auto\fP option in order to return to the automatic mode
(or you can rerun \fB\-\-config\fP and select the entry marked as automatic).
.PP
非対話的に設定をしたい場合は \fB\-\-set\fP オプションを代わりに使用する (以下を参照)。
.PP
同一のファイルを提供する異なるパッケージは、これを \fB協調して\fP 行う必要がある。言い換えると、こうした場合、関連するパッケージのすべてで
\fBupdate\-alternatives\fP の使用が必須となる。\fBupdate\-alternatives\fP
機構を使用していないパッケージのファイルを上書きすることはできない。
.
.SH 用語
\fBupdate\-alternatives\fP の動作は極めて複雑なので、ここでいくつかの固有の用語を説明し、動作の理解の助けとしたい。
.TP 
一般名 (generic name / alternative link)
\fI/usr/bin/editor\fP のような名前。 alternatives システムによって、類似の機能を持つ複数のファイルのいずれかを参照する。
.TP 
選択肢名 (alternative name)
alternatives ディレクトリに存在するシンボリックリンク名
.TP 
選択肢 (alternative / alternative path)
ファイルシステム中の特定ファイルの名称、alternatives システムによって、一般名からのアクセスが可能となる。
.TP 
alternatives ディレクトリ
シンボリックリンクを保持するディレクトリ。デフォルトは \fI%CONFDIR%/alternatives\fP。
.TP 
administrative ディレクトリ
\fBupdate\-alternatives\fP の状態情報を保持するディレクトリ。デフォルトは
\fI/var/lib/dpkg/alternatives\fP。
.TP 
リンクグループ
関連するシンボリックリンクのセットで、グループ単位での更新を行うためのもの。
.TP 
master リンク
リンクグループに属する選択肢のリンクで、グループ内の他のリンクの設定を決定するもの。
.TP 
slave リンク
リンクグループに属する選択肢のリンクで、 master リンクの設定によって設定されるもの。
.TP 
automatic モード
リンクグループが automatic モードにある場合、alternatives システムは、グループ内の各リンクが priority
のもっとも高い選択肢を参照することを担保する。
.TP 
manual モード
リンクグループが manual モードにある場合、alternatives システムはシステム管理者の行った設定を一切変更しない。
.
.SH コマンド
.TP 
\fB\-\-install\fP \fIlink name path priority\fP [\fB\-\-slave\fP \fIlink name path\fP]...
選択肢のグループをシステムに追加する。\fIlink\fP は master リンクの一般名、\fIname\fP は alternatives
ディレクトリにおけるシンボリックリンクの名前、 \fIpath\fP は master リンクとなる選択肢の名前となる。\fB\-\-slave\fP
オプションに続く引数は、alternatives ディレクトリでの一般名およびシンボリックリンクの名前と slave
リンクとなる選択肢のパスの順となる。\fB\-\-slave\fP オプションと、それにに続く 3
つの引数のセットは、いくつ設定してもよく、まったく設定しないこともできる。master
となる選択肢は必ず存在している必要があり、存在していない場合は失敗となるが、slave
の選択肢がインストールされていない場合は、(依然として警告が表示されるものの) 対応する slave
の選択肢のリンクが単にインストールされないだけである。選択肢のリンクがインストールされるパスに、何らかの実ファイルがインストールされている場合、\fB\-\-force\fP
が指定されない限り、それらのファイルは保持される。
.IP
指定された選択肢の名前が既に alternatives
システム内に存在している場合、与えられた情報は、グループに対する新たな選択肢として追加される。それ以外の場合は、与えられた情報を用いて、新しいグループが
automatic モードで追加される。グループが automatic モードにあり、新たに追加された選択肢の priority
がそのグループに対してインストールされている他の選択肢のものより高い場合、シンボリックリンクは新たに追加された選択肢を参照するように更新される。
.TP 
\fB\-\-set\fP \fIname path\fP
プログラム \fIpath\fP を \fIname\fP の選択肢として設定する。 \fI\-\-config\fP
と同等だが、こちらは非対話的であるため、スクリプト向けである。
.TP 
\fB\-\-remove\fP \fIname path\fP
(master の) 選択肢とそれに関連する全ての slave リンクを削除する。 \fIname\fP は alternatives
ディレクトリ内の名前であり、 \fIpath\fP は \fIname\fP のリンク先に指定されうるファイル名の絶対パスである。 \fIname\fP が実際に
\fIpath\fP にリンクされている場合には、 \fIname\fP は他の適切な選択肢を参照するよう更新される (グループは automatic
モードに戻される) が、そのような選択肢が残っていなければ削除される。関連する slave リンクも対応して更新 (削除) される。 \fIname\fP
が現在その \fIpath\fP を参照していなければ、リンクの変更は行われない。その選択肢の情報が削除されるだけである。
.TP 
\fB\-\-remove\-all\fP \fIname\fP
すべての選択肢と、それに関連するすべての slave リンクを削除する。 \fIname\fP は、alternatives ディレクトリ内の名前である。
.TP 
\fB\-\-all\fP
すべての選択肢に対して \fB\-\-config\fP を呼び出す。これは \fB\-\-skip\-auto\fP と組み合わせることで、automatic
モードで設定されていないすべての選択肢を確認、設定する際に有用である。問題のある選択肢も表示される。問題のある選択肢をすべて修正するためには \fByes
\&\*(rq | update\-alternatives \-\-force \-\-all\fP を実行すればよい。
.TP 
\fB\-\-auto\fP \fIname\fP
\fIname\fP で指定される選択肢のリンクグループを、automatic モードに変更する。この処理を行う際に、master
のシンボリックリンクと対応する各 slave は、現在インストールされている選択肢のうち、もっとも priority
の高いものを参照するように更新される。
.TP 
\fB\-\-display\fP \fIname\fP
Display information about the link group.  Information displayed includes
the group's mode (auto or manual), the master and slave links, which
alternative the master link currently points to, what other alternatives are
available (and their corresponding slave alternatives), and the highest
priority alternative currently installed.
.TP 
\fB\-\-get\-selections\fP
List all master alternative names (those controlling a link group)  and
their status (since version 1.15.0).  Each line contains up to 3 fields
(separated by one or more spaces). The first field is the alternative name,
the second one is the status (either \fBauto\fP or \fBmanual\fP), and the last one
contains the current choice in the alternative (beware: it's a filename and
thus might contain spaces).
.TP 
\fB\-\-set\-selections\fP
Read configuration of alternatives on standard input in the format generated
by \fB\-\-get\-selections\fP and reconfigure them accordingly (since version
1.15.0).
.TP 
\fB\-\-query\fP \fIname\fP
Display information about the link group like \fB\-\-display\fP does, but in a
machine parseable way (since version 1.15.0, see section \fBQUERY FORMAT\fP
below).
.TP 
\fB\-\-list\fP \fIname\fP
リンクグループのすべての対象を表示する。
.TP 
\fB\-\-config\fP \fIname\fP
リンクグループで利用可能なすべての選択肢を表示し、対話的に選択肢の 1 つを選択できるようにする。これにより、リンクグループが更新される。
.TP 
\fB\-\-help\fP
利用方法を表示して終了する。
.TP 
\fB\-\-version\fP
バージョン情報を表示して終了する。
.
.SH オプション
.TP 
\fB\-\-altdir\fP \fIdirectory\fP
alternatives ディレクトリをデフォルトから変えたいときに指定する。
.TP 
\fB\-\-admindir\fP\fI directory\fP
administrative ディレクトリをデフォルトから変えたいときに指定する。
.TP 
\fB\-\-log\fP\fI file\fP
Specifies the log file (since version 1.15.0), when this is to be different
from the default (%LOGDIR%/alternatives.log).
.TP 
\fB\-\-force\fP
Allow replacing or dropping any real file that is installed where an
alternative link has to be installed or removed.
.TP 
\fB\-\-skip\-auto\fP
automatic モードで適切に設定されている選択肢について、設定の確認を行わない。このオプションは \fB\-\-config\fP および \fB\-\-all\fP
とともに指定した場合のみ有効である。
.TP 
\fB\-\-verbose\fP
Generate more comments about what is being done.
.TP 
\fB\-\-quiet\fP
エラー以外のコメントを出力しない。
.
.SH 終了ステータス
.TP 
\fB0\fP
指定したアクションが正しく実行された。
.TP 
\fB2\fP
コマンドラインの解釈か、アクションの実行時に問題が発生した。
.
.SH 環境変数
.TP 
\fBDPKG_ADMINDIR\fP
\fB\-\-admindir\fP オプションが指定されていない場合に、この変数が設定されていると、この値が administrative
ディレクトリの起点として使用される。
.
.SH ファイル
.TP 
\fI%CONFDIR%/alternatives/\fP
デフォルトの alternatives ディレクトリ。 \fB\-\-altdir\fP オプションによって変更できる。
.TP 
\fI%ADMINDIR%/alternatives/\fP
デフォルトの administration ディレクトリ。 \fB\-\-admindir\fP オプションによって変更できる。
.
.SH "QUERY FORMAT"
The \fB\-\-query\fP format is using an RFC822\-like flat format. It's made of \fIn\fP
+ 1 blocks where \fIn\fP is the number of alternatives available in the queried
link group. The first block contains the following fields:
.TP 
\fBName:\fP\fI name\fP
alternative ディレクトリに存在する選択肢の名前
.TP 
\fBLink:\fP\fI link\fP
選択肢の一般名
.TP 
\fBSlaves:\fP\fI list\-of\-slaves\fP
このヘッダが存在している場合、\fB以降の\fP 行には、この選択肢の master リンクに対応するすべての slave
リンクが記述される。これは、slave 毎に 1 行ずつ記述され、各行は、1 文字のスペースに続き、slave の選択肢の一般名、スペース、slave
リンクのパスが記述される。
.TP 
\fBStatus:\fP\fI status\fP
選択肢の状況 (\fBauto\fP もしくは \fBmanual\fP)
.TP 
\fBBest:\fP\fI best\-choice\fP
このリンクグループで最適な選択肢のパス。利用可能な選択肢が存在しない場合、存在しない。
.TP 
\fBValue:\fP\fI currently\-selected\-alternative\fP
現在選択されている選択肢のパス。リンクが存在しない場合、\fBnone\fP という特別な値が設定される場合がある。
.PP
これ以外のブロックは、クエリ対象のリンクグループにおいて利用可能な選択肢を表示する。
.TP 
\fBAlternative:\fP\fI path\-of\-this\-alternative\fP
このブロックの選択肢のパス。
.TP 
\fBPriority:\fP\fI priority\-value\fP
この選択肢の priority の値。
.TP 
\fBSlaves:\fP\fI list\-of\-slaves\fP
このヘッダが存在している場合、\fB以降の\fP 行には、この選択肢の master リンクに対応するすべての slave
の選択肢が記述される。これは、slave 毎に 1 行ずつ記述され、各行は、1 文字のスペースに続き、slave の選択肢の一般名、スペース、slave
の選択肢のパスが記述される。
.
.SS Example
.nf
$ update\-alternatives \-\-query editor
Name: editor
Link: /usr/bin/editor
Slaves:
 editor.1.gz /usr/share/man/man1/editor.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/editor.1.gz
 editor.it.1.gz /usr/share/man/it/man1/editor.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/editor.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/editor.1.gz
Status: auto
Best: /usr/bin/vim.basic
Value: /usr/bin/vim.basic

Alternative: /bin/ed
Priority: \-100
Slaves:
 editor.1.gz /usr/share/man/man1/ed.1.gz

Alternative: /usr/bin/vim.basic
Priority: 50
Slaves:
 editor.1.gz /usr/share/man/man1/vim.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/vim.1.gz
 editor.it.1.gz /usr/share/man/it/man1/vim.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/vim.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/vim.1.gz
.fi
.
.SH 診断メッセージ
\fB\-\-verbose\fP を指定した場合、\fBupdate\-alternatives\fP は、実行中の処理内容を逐一標準出力に出力する。問題が起きると、
\fBupdate\-alternatives\fP はエラーメッセージを標準エラー出力に出力し、終了ステータス 2
を返す。これらの診断メッセージは、読めばわかるはずである。もしわからなければ、バグとして報告して欲しい。
.
.SH 例
例えば \fBnvi\fP や \fBvim\fP のように、テキストエディタ \fBvi\fP
と互換性のあるプログラムを提供するパッケージが複数ある。どのパッケージが使われるかは、リンクグループ \fBvi\fP によって制御される。リンクグループ
\fBvi\fP にはプログラム自身のリンクと、関連する man ページのリンクが含まれる。
.PP
\fBvi\fP を提供するパッケージとその現在の設定を表示するには、\fB\-\-display\fP アクションを使用する:
.PP
.RS
\fBupdate\-alternatives \-\-display vi\fP
.RE
.PP
特定の \fBvi\fP の実装を選ぶには、root としてこのコマンドを実行し、一覧から数字を選ぶ:
.PP
.RS
\fBupdate\-alternatives \-\-config vi\fP
.RE
.PP
\fBvi\fP 実装の選択を自動的に行なうように戻すには、root としてこのコマンドを実行する:
.PP
.RS
\fBupdate\-alternatives \-\-auto vi\fP
.RE
.
.SH 関連項目
\fBln\fP(1), FHS, the Filesystem Hierarchy Standard.
.SH 翻訳者
高橋 基信 <monyo@monyo.com>.
喜瀬 浩 <kise@fuyuneko.jp>.
関戸 幸一 <sekido@mbox.kyoto-inet.or.jp>.
鍋谷 栄展 <nabe@debian.or.jp>.
倉澤 望 <nabetaro@debian.or.jp>.
石川 睦 <ishikawa@linux.or.jp>.
鵜飼 文敏 <ukai@debian.or.jp>.
中野 武雄 <nakano@apm.seikei.ac.jp>.
.SH 翻訳校正
Debian JP Documentation ML <debian-doc@debian.or.jp>.
