/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-cc.org
   2016-05-28 13:52
   Version 4.11.0 (rev ce980c4)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2016-05-28 on yves.more-magic.net (Linux)
   command line: posixwin.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <signal.h>
#include <utime.h>
#include <winsock2.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    int what_len = name_len + 3;
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(what_len);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    C_strlcpy(what, name, what_len);
    if (strchr("\\/", name[name_len - 1]))
	C_strlcat(what, "*", what_len);
    else
	C_strlcat(what, "\\*", what_len);

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_lstat(fn)	    C_stat(fn)

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
        /* Can't barf() here, so the NUL byte check happens in Scheme */
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))

#define C_flushall()	    C_fix(_flushall())

#define C_umask(m)          C_fix(_umask(C_unfix(m)))

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map;
    for (map = errmap; map->win32; ++map)
    {
	if (map->win32 == w32err)
	{
	    errno = map->libc;
	    return;
	}
    }
    errno = ENOSYS; /* For lack of anything better */
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

static int C_fcall
process_wait(C_word h, C_word t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_fix(0))

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo()) /* for C_isNT */
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		C_strlcpy(C_shlcmd + len, cmdnam, sizeof(C_shlcmd));
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  C_word * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((C_word)parent_end,0)) >= 0;
                /* Make new handle inheritable */
		if (success)
		  success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);
	    }
	}
    }

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		C_strlcpy(pb, *p, len+1);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
            /* This _should_ already have been checked for embedded NUL bytes */
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) {
	if (child_io_handles[i] != NULL)
	    CloseHandle(child_io_handles[i]);
    }

    if (success)
    {
	*phandle = (C_word)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) {
	    if (io_fds[i] != -1)
		_close(io_fds[i]);
	}
    }

    return success;
}

static int set_file_mtime(char *filename, C_word tm)
{
  struct _utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return _utime(filename, &tb);
}

#include <signal.h>
#include <errno.h>

#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_flonum(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b,l)    (C_strlcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name, l), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#ifdef HAVE_SETENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)      C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif


#define PROT_NONE       0
#define PROT_READ       1
#define PROT_WRITE      2
#define PROT_EXEC       4
#define MAP_FILE        0
#define MAP_SHARED      1
#define MAP_PRIVATE     2
#define MAP_FIXED       0x10
#define MAP_ANONYMOUS   0x20

// This value is available starting with Windows XP with SP2 
// and Windows Server 2003 with SP1.
#ifndef FILE_MAP_EXECUTE
#define FILE_MAP_EXECUTE 0x20
#endif//FILE_MAP_EXECUTE

static int page_flags[] =
{
    0,
    PAGE_READONLY,
    PAGE_READWRITE,
    PAGE_READWRITE,
    PAGE_EXECUTE_READ,
    PAGE_EXECUTE_READ,
    PAGE_EXECUTE_READWRITE
};

static int file_flags[] =
{
    0,
    FILE_MAP_READ,
    FILE_MAP_READ|FILE_MAP_WRITE,
    FILE_MAP_READ|FILE_MAP_WRITE,
    FILE_MAP_READ|FILE_MAP_EXECUTE,
    FILE_MAP_READ|FILE_MAP_EXECUTE,
    FILE_MAP_READ|FILE_MAP_WRITE|FILE_MAP_EXECUTE
};

void* mmap(void* addr,int len,int prot,int flags,int fd,int off)
{
    HANDLE hMap;
    HANDLE hFile;

    void* ptr;

    if ((flags & MAP_FIXED) || (flags & MAP_PRIVATE) || (flags & MAP_ANONYMOUS))
    {
        errno = EINVAL;
        return (void*)-1;
    }

    /*
     * We must cast because _get_osfhandle returns intptr_t, but it must
     * be compared with INVALID_HANDLE_VALUE, which is a HANDLE type.
     * Who comes up with this shit?
     */
    hFile = (HANDLE)_get_osfhandle(fd);
    if (hFile == INVALID_HANDLE_VALUE)
    {
        return (void*)-1;
    }

    hMap = CreateFileMapping(
            hFile,
            NULL,
            page_flags[prot & (PROT_READ|PROT_WRITE|PROT_EXEC)],
            0,
            0,
            NULL);

    if (hMap == INVALID_HANDLE_VALUE)
    {
        set_last_errno();
        return (void*)-1;
    }

    ptr = MapViewOfFile(
            hMap,
            file_flags[prot & (PROT_READ|PROT_WRITE|PROT_EXEC)],
            0,
            off,
            len);

    if (ptr == NULL)
    {
        set_last_errno();
        ptr = (void*)-1;
    }

    CloseHandle(hMap);

    return ptr;
}

int munmap(void* addr,int len)
{
    if (UnmapViewOfFile(addr))
    {
        errno = 0;
        return 0;
    }
    set_last_errno();
    return -1;
}

int is_bad_mmap(void* p)
{
    void* bad_ptr;
    bad_ptr = (void*)-1;
    return p == bad_ptr;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[402];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,49,32,108,111,99,55,50,32,109,115,103,55,51,32,46,32,97,114,103,115,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,54,32,108,105,110,107,56,55,32,101,114,114,56,56,32,108,111,99,56,57,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,50,32,46,32,116,109,112,49,48,49,49,48,51,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,49,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,55,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,52,48,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,56,32,46,32,116,109,112,49,52,55,49,52,57,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,55,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,57,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,49,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,51,41,0,0,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,53,49,57,32,102,105,108,101,49,55,53,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,57,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,49,56,52,32,112,111,115,49,56,53,32,46,32,119,104,101,110,99,101,49,56,54,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,50,48,56,32,109,50,48,57,32,108,111,99,50,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,50,50,50,32,102,100,50,50,51,32,105,110,112,50,50,52,32,114,50,50,53,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,21),40,102,95,50,54,53,56,32,102,100,50,50,56,32,46,32,109,50,50,57,41,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,21),40,102,95,50,54,55,50,32,102,100,50,51,49,32,46,32,109,50,51,50,41,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,16),40,102,95,50,54,56,54,32,112,111,114,116,50,51,56,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,24),40,102,95,50,55,51,52,32,111,108,100,50,52,55,32,46,32,110,101,119,50,52,56,41};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,53,57,50,54,48,41,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,56,55,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,11),40,103,50,57,51,32,102,51,48,50,41,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,57,50,32,103,50,57,57,51,49,48,41,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,55,57,32,46,32,116,109,112,50,55,56,50,56,48,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,51,51,52,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,7),40,97,50,57,53,48,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,47),40,97,50,57,53,54,32,100,105,114,51,52,50,51,52,51,51,52,56,32,102,105,108,101,51,52,52,51,52,53,51,52,57,32,101,120,116,51,52,54,51,52,55,51,53,48,41,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,51,50,51,32,46,32,116,109,112,51,50,50,51,50,52,41,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,54,53,51,54,54,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,51,49,53,55,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,11),40,103,52,50,56,32,109,52,51,48,41,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,52,50,49,41,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,46),40,97,51,49,54,51,32,100,105,114,52,48,52,52,48,53,52,49,48,32,102,105,108,52,48,54,52,48,55,52,49,49,32,101,120,116,52,48,56,52,48,57,52,49,50,41,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,52,48,50,41,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,52,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,7),40,97,51,51,51,48,41,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,7),40,97,51,51,51,53,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,7),40,97,51,51,53,53,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,100,105,114,52,53,55,32,102,115,52,53,56,32,114,52,53,57,41};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,13),40,102,95,51,52,48,49,32,120,52,53,53,41,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,15),40,102,95,51,52,49,55,32,46,32,95,52,53,50,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,15),40,102,95,51,52,48,57,32,46,32,95,52,53,49,41,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,52,52,54,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,51,52,52,57,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,52,53,50,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,51,52,53,53,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,18),40,102,95,51,52,54,49,32,120,52,57,53,32,121,52,57,54,41,0,0,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,51,52,53,56,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,102,95,51,52,54,57,32,46,32,95,52,57,51,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,7),40,97,51,52,54,54,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,57,48,32,46,32,116,109,112,52,56,57,52,57,49,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,53,50,50,32,116,109,53,50,51,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,53,51,48,53,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,53,52,51,53,52,52,41,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,53,54,50,53,54,51,41,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,53,55,52,41,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,54,48,55,32,46,32,116,109,112,54,48,54,54,48,56,41};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,54,50,49,32,118,97,108,54,50,50,41,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,54,50,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,54,52,49,41,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,54,51,56,41,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,54,52,53,32,112,114,111,99,54,52,54,41,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,7),40,97,51,56,52,49,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,33),40,97,51,56,52,55,32,101,112,105,100,54,55,48,32,101,110,111,114,109,54,55,49,32,101,99,111,100,101,54,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,54,53,53,41};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,55,53,48,32,102,108,97,103,115,55,53,49,32,46,32,109,111,100,101,55,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,55,54,49,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,55,55,48,32,115,105,122,101,55,55,49,32,46,32,98,117,102,102,101,114,55,55,50,41,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,55,56,50,32,98,117,102,102,101,114,55,56,51,32,46,32,115,105,122,101,55,56,52,41,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,22),40,115,117,102,102,105,120,45,108,111,111,112,32,105,110,100,101,120,56,49,53,41,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,99,111,117,110,116,56,49,51,41,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,48,50,41,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,57,52,41,0,0,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,56,50,52,41,0,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,56,51,52,32,105,110,112,56,51,53,32,114,56,51,54,41,0,0,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,52,48,32,46,32,109,56,52,49,41,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,53,48,32,46,32,109,56,53,49,41};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,56,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,56,54,53,41,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,52,52,48,55,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,20),40,97,52,52,49,51,32,46,32,114,101,115,117,108,116,115,56,56,49,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,55,55,32,112,114,111,99,56,55,56,32,46,32,109,111,100,101,56,55,57,41,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,7),40,97,52,52,51,49,41,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,20),40,97,52,52,51,55,32,46,32,114,101,115,117,108,116,115,56,56,56,41,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,56,52,32,112,114,111,99,56,56,53,32,46,32,109,111,100,101,56,56,54,41};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,7),40,97,52,52,53,53,41,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,20),40,97,52,52,54,54,32,46,32,114,101,115,117,108,116,115,57,48,51,41,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,7),40,97,52,52,54,48,41,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,7),40,97,52,52,55,53,41,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,56,57,49,32,116,104,117,110,107,56,57,50,32,46,32,109,111,100,101,56,57,51,41};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,7),40,97,52,52,56,57,41,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,20),40,97,52,53,48,48,32,46,32,114,101,115,117,108,116,115,57,50,48,41,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,7),40,97,52,52,57,52,41,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,7),40,97,52,53,48,57,41,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,57,48,56,32,116,104,117,110,107,57,48,57,32,46,32,109,111,100,101,57,49,48,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,57,50,57,57,51,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,48,48,52,32,109,49,48,48,53,41,0,0,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,48,49,48,32,97,99,99,49,48,49,49,32,108,111,99,49,48,49,50,41,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,49,54,41};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,49,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,49,56,41,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,28),40,109,111,100,101,32,105,110,112,49,48,50,55,32,109,49,48,50,56,32,108,111,99,49,48,50,57,41,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,28),40,99,104,101,99,107,32,102,100,49,48,52,49,32,105,110,112,49,48,52,50,32,114,49,48,52,51,41,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,33),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,49,48,52,55,32,46,32,109,49,48,52,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,34),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,49,48,53,48,32,46,32,109,49,48,53,49,41,0,0,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,23),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,49,48,53,55,41,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,36),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,49,48,54,51,32,46,32,110,101,119,49,48,54,52,41,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,48,56,49,41,0,0,0,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,48,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,48,56,56,41};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,48,57,48,32,109,111,100,101,49,48,57,49,32,46,32,115,105,122,101,49,48,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,105,108,115,116,49,49,50,50,32,111,108,115,116,49,49,50,51,41};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,37),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,49,49,48,57,32,101,120,97,99,116,102,49,49,49,48,41,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,49),40,115,101,116,97,114,103,32,105,110,116,49,49,51,48,49,49,51,54,32,99,45,115,116,114,105,110,103,49,49,51,49,49,49,51,55,32,105,110,116,49,49,51,50,49,49,51,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,49),40,115,101,116,101,110,118,32,105,110,116,49,49,52,48,49,49,52,54,32,99,45,115,116,114,105,110,103,49,49,52,49,49,49,52,55,32,105,110,116,49,49,52,50,49,49,52,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,24),40,100,111,108,111,111,112,49,49,53,52,32,108,49,49,53,54,32,105,49,49,53,55,41};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,61),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,49,49,53,48,32,108,115,116,49,49,53,49,32,97,114,103,118,101,99,45,115,101,116,116,101,114,49,49,53,50,32,105,100,120,49,49,53,51,41,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,67),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,49,49,54,51,32,102,105,108,101,110,97,109,101,49,49,54,52,32,97,114,103,108,115,116,49,49,54,53,32,101,110,118,108,115,116,49,49,54,54,32,101,120,97,99,116,102,49,49,54,55,41,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,53),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,49,49,55,54,32,109,115,103,49,49,55,55,32,102,105,108,101,110,97,109,101,49,49,55,56,32,114,101,115,49,49,55,57,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,49,56,57,32,46,32,116,109,112,49,49,56,56,49,49,57,48,41,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,51),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,49,50,49,48,32,102,105,108,101,110,97,109,101,49,50,49,49,32,46,32,116,109,112,49,50,48,57,49,50,49,50,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,50,51,50,41,0,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,50,51,52,32,46,32,97,114,103,115,49,50,51,53,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,50,55,54,32,99,109,100,49,50,55,55,32,97,114,103,115,49,50,55,56,32,101,110,118,49,50,55,57,32,115,116,100,111,117,116,102,49,50,56,48,32,115,116,100,105,110,102,49,50,56,49,32,115,116,100,101,114,114,102,49,50,56,50,32,46,32,116,109,112,49,50,55,53,49,50,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,7),40,103,49,51,52,53,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,51,52,52,41,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,51,52,49,41,0,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,7),40,97,53,53,54,52,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,38),40,97,53,53,55,48,32,105,110,49,51,55,48,32,111,117,116,49,51,55,49,32,112,105,100,49,51,55,50,32,101,114,114,49,51,55,51,41,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,63),40,37,112,114,111,99,101,115,115,32,108,111,99,49,51,51,52,32,101,114,114,63,49,51,51,53,32,99,109,100,49,51,51,54,32,97,114,103,115,49,51,51,55,32,101,110,118,49,51,51,56,32,101,120,97,99,116,102,49,51,51,57,41,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,51,56,50,32,46,32,116,109,112,49,51,56,49,49,51,56,51,41,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,52,48,49,32,46,32,116,109,112,49,52,48,48,49,52,48,50,41};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,52,49,55,32,110,111,104,97,110,103,49,52,49,56,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,13),40,115,108,101,101,112,32,115,49,52,50,48,41,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,52,54,50,32,108,101,110,49,52,54,51,32,112,114,111,116,49,52,54,52,32,102,108,97,103,49,52,54,53,32,102,100,49,52,54,54,32,46,32,111,102,102,49,52,54,55,41};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,52,56,52,32,46,32,108,101,110,49,52,56,53,41,0,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,52,56,57,41,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,52,57,50,41,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,46,32,95,49,53,50,51,49,53,50,55,41,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,49,53,51,48,49,53,51,52,41,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,49,53,51,54,49,53,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,49,53,52,50,49,53,52,54,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,53,52,56,49,53,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,53,52,49,53,53,56,41};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,49,53,54,48,49,53,54,52,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,49,53,54,54,49,53,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,55,50,49,53,55,54,41,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,49,53,55,56,49,53,56,50,41,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,49,53,56,52,49,53,56,56,41,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,49,53,57,48,49,53,57,52,41,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,49,53,57,54,49,54,48,48,41};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,49,54,48,50,49,54,48,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,49,54,48,56,49,54,49,50,41,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,49,54,49,52,49,54,49,56,41,0,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,49,54,50,48,49,54,50,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,49,54,50,54,49,54,51,48,41};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,54,51,50,49,54,51,54,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,49,54,51,56,49,54,52,50,41,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,49,54,52,52,49,54,52,56,41,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,49,54,53,48,49,54,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,49,54,53,54,49,54,54,48,41,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,49,54,54,50,49,54,54,54,41,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,54,54,56,49,54,55,50,41};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,49,54,55,52,49,54,55,56,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,54,56,48,49,54,56,52,41,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,49,54,56,54,49,54,57,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,54,57,50,49,54,57,54,41,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,49,54,57,56,49,55,48,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,55,48,52,49,55,48,56,41,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,49,55,49,48,49,55,49,52,41,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,49,55,49,54,49,55,50,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,55,50,50,49,55,50,54,41,0,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,49,55,50,56,49,55,51,50,41,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,49,55,51,52,49,55,51,56,41,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,49,55,52,48,49,55,52,52,41,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,55,52,54,49,55,53,48,41,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,49,55,53,50,49,55,53,54,41,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,49,55,53,56,49,55,54,50,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,49,55,54,53,41,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,14),40,97,54,49,57,57,32,115,105,103,54,53,49,41,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,19),40,97,54,50,48,56,32,46,32,116,109,112,53,48,54,53,48,55,41,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,13),40,97,54,50,51,51,32,117,109,53,49,57,41,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,15),40,97,54,50,51,57,32,112,111,114,116,49,57,54,41,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,12),40,97,54,50,55,54,32,102,49,49,49,41,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,17),40,97,54,50,56,50,32,102,49,49,51,32,116,49,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k5891 */
C_regparm static C_word C_fcall stub1478(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k5835 */
C_regparm static C_word C_fcall stub1457(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_r=C_mk_bool(is_bad_mmap(t0));
return C_r;}

/* from k5826 */
C_regparm static C_word C_fcall stub1445(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k5388 */
C_regparm static C_word C_fcall stub1247(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from k5064 */
C_regparm static C_word C_fcall stub1143(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k5043 */
C_regparm static C_word C_fcall stub1133(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4838 */
C_regparm static C_word C_fcall stub1078(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1072(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k3726 */
C_regparm static C_word C_fcall stub633(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3624 */
C_regparm static C_word C_fcall stub593(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k3611 */
C_regparm static C_word C_fcall stub583(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k3544 */
C_regparm static C_word C_fcall stub554(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k6291 in a6282 in k2258 in k2255 in k2252 in k2249 in k2246 */
C_regparm static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2269 */
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_3158)
static void C_ccall f_3158(C_word c,C_word *av) C_noret;
C_noret_decl(f_6095)
static void C_ccall f_6095(C_word c,C_word *av) C_noret;
C_noret_decl(f_6089)
static void C_ccall f_6089(C_word c,C_word *av) C_noret;
C_noret_decl(f_6083)
static void C_ccall f_6083(C_word c,C_word *av) C_noret;
C_noret_decl(f_3344)
static void C_ccall f_3344(C_word c,C_word *av) C_noret;
C_noret_decl(f_2260)
static void C_ccall f_2260(C_word c,C_word *av) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word *av) C_noret;
C_noret_decl(f_3336)
static void C_ccall f_3336(C_word c,C_word *av) C_noret;
C_noret_decl(f_3348)
static void C_ccall f_3348(C_word c,C_word *av) C_noret;
C_noret_decl(f_4798)
static void C_ccall f_4798(C_word c,C_word *av) C_noret;
C_noret_decl(f_4796)
static void C_ccall f_4796(C_word c,C_word *av) C_noret;
C_noret_decl(f_2272)
static void C_ccall f_2272(C_word c,C_word *av) C_noret;
C_noret_decl(f_5521)
static C_word C_fcall f_5521(C_word t0,C_word t1);
C_noret_decl(f_3391)
static void C_ccall f_3391(C_word c,C_word *av) C_noret;
C_noret_decl(f_3194)
static void C_ccall f_3194(C_word c,C_word *av) C_noret;
C_noret_decl(f_2824)
static void C_ccall f_2824(C_word c,C_word *av) C_noret;
C_noret_decl(f_2825)
static void C_fcall f_2825(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3198)
static void C_fcall f_3198(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4782)
static void C_ccall f_4782(C_word c,C_word *av) C_noret;
C_noret_decl(f_2283)
static void C_ccall f_2283(C_word c,C_word *av) C_noret;
C_noret_decl(f_5530)
static C_word C_fcall f_5530(C_word t0,C_word t1);
C_noret_decl(f_2276)
static void C_ccall f_2276(C_word c,C_word *av) C_noret;
C_noret_decl(f_2290)
static void C_fcall f_2290(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2294)
static void C_ccall f_2294(C_word c,C_word *av) C_noret;
C_noret_decl(f_4805)
static void C_fcall f_4805(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4808)
static void C_ccall f_4808(C_word c,C_word *av) C_noret;
C_noret_decl(f_2287)
static void C_ccall f_2287(C_word c,C_word *av) C_noret;
C_noret_decl(f_2805)
static void C_ccall f_2805(C_word c,C_word *av) C_noret;
C_noret_decl(f_2801)
static void C_fcall f_2801(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4047)
static void C_ccall f_4047(C_word c,C_word *av) C_noret;
C_noret_decl(f_3384)
static void C_ccall f_3384(C_word c,C_word *av) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word *av) C_noret;
C_noret_decl(f_2835)
static void C_ccall f_2835(C_word c,C_word *av) C_noret;
C_noret_decl(f_3375)
static void C_ccall f_3375(C_word c,C_word *av) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word *av) C_noret;
C_noret_decl(f_4025)
static void C_ccall f_4025(C_word c,C_word *av) C_noret;
C_noret_decl(f_3369)
static void C_ccall f_3369(C_word c,C_word *av) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366(C_word c,C_word *av) C_noret;
C_noret_decl(f_2942)
static void C_ccall f_2942(C_word c,C_word *av) C_noret;
C_noret_decl(f_2957)
static void C_ccall f_2957(C_word c,C_word *av) C_noret;
C_noret_decl(f_3356)
static void C_ccall f_3356(C_word c,C_word *av) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351(C_word c,C_word *av) C_noret;
C_noret_decl(f_2949)
static void C_ccall f_2949(C_word c,C_word *av) C_noret;
C_noret_decl(f_4006)
static void C_ccall f_4006(C_word c,C_word *av) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word *av) C_noret;
C_noret_decl(f_4035)
static void C_fcall f_4035(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4241)
static void C_ccall f_4241(C_word c,C_word *av) C_noret;
C_noret_decl(f_4032)
static void C_ccall f_4032(C_word c,C_word *av) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980(C_word c,C_word *av) C_noret;
C_noret_decl(f_4232)
static void C_ccall f_4232(C_word c,C_word *av) C_noret;
C_noret_decl(f_2998)
static void C_ccall f_2998(C_word c,C_word *av) C_noret;
C_noret_decl(f_6131)
static void C_ccall f_6131(C_word c,C_word *av) C_noret;
C_noret_decl(f_6137)
static void C_ccall f_6137(C_word c,C_word *av) C_noret;
C_noret_decl(f_4235)
static void C_ccall f_4235(C_word c,C_word *av) C_noret;
C_noret_decl(f_6143)
static void C_ccall f_6143(C_word c,C_word *av) C_noret;
C_noret_decl(f_6149)
static void C_ccall f_6149(C_word c,C_word *av) C_noret;
C_noret_decl(f_4225)
static void C_ccall f_4225(C_word c,C_word *av) C_noret;
C_noret_decl(f_2497)
static void C_ccall f_2497(C_word c,C_word *av) C_noret;
C_noret_decl(f_2499)
static void C_ccall f_2499(C_word c,C_word *av) C_noret;
C_noret_decl(f_4201)
static void C_fcall f_4201(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6113)
static void C_ccall f_6113(C_word c,C_word *av) C_noret;
C_noret_decl(f_6119)
static void C_ccall f_6119(C_word c,C_word *av) C_noret;
C_noret_decl(f_4139)
static void C_fcall f_4139(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2489)
static void C_ccall f_2489(C_word c,C_word *av) C_noret;
C_noret_decl(f_2487)
static void C_ccall f_2487(C_word c,C_word *av) C_noret;
C_noret_decl(f_6125)
static void C_ccall f_6125(C_word c,C_word *av) C_noret;
C_noret_decl(f_2479)
static void C_ccall f_2479(C_word c,C_word *av) C_noret;
C_noret_decl(f_5658)
static void C_ccall f_5658(C_word c,C_word *av) C_noret;
C_noret_decl(f_6101)
static void C_ccall f_6101(C_word c,C_word *av) C_noret;
C_noret_decl(f_6107)
static void C_ccall f_6107(C_word c,C_word *av) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word *av) C_noret;
C_noret_decl(f_4906)
static void C_fcall f_4906(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5319)
static void C_ccall f_5319(C_word c,C_word *av) C_noret;
C_noret_decl(f_3002)
static void C_ccall f_3002(C_word c,C_word *av) C_noret;
C_noret_decl(f_6200)
static void C_ccall f_6200(C_word c,C_word *av) C_noret;
C_noret_decl(f_6209)
static void C_ccall f_6209(C_word c,C_word *av) C_noret;
C_noret_decl(f_5324)
static void C_ccall f_5324(C_word c,C_word *av) C_noret;
C_noret_decl(f_3630)
static void C_ccall f_3630(C_word c,C_word *av) C_noret;
C_noret_decl(f_3637)
static void C_ccall f_3637(C_word c,C_word *av) C_noret;
C_noret_decl(f_4640)
static void C_fcall f_4640(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5303)
static void C_ccall f_5303(C_word c,C_word *av) C_noret;
C_noret_decl(f_5307)
static void C_ccall f_5307(C_word c,C_word *av) C_noret;
C_noret_decl(f_2411)
static void C_ccall f_2411(C_word c,C_word *av) C_noret;
C_noret_decl(f_5857)
static void C_ccall f_5857(C_word c,C_word *av) C_noret;
C_noret_decl(f_5851)
static void C_ccall f_5851(C_word c,C_word *av) C_noret;
C_noret_decl(f_6234)
static void C_ccall f_6234(C_word c,C_word *av) C_noret;
C_noret_decl(f_3747)
static void C_fcall f_3747(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3041)
static void C_fcall f_3041(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5145)
static void C_ccall f_5145(C_word c,C_word *av) C_noret;
C_noret_decl(f_6240)
static void C_ccall f_6240(C_word c,C_word *av) C_noret;
C_noret_decl(f_6247)
static void C_ccall f_6247(C_word c,C_word *av) C_noret;
C_noret_decl(f_6244)
static void C_ccall f_6244(C_word c,C_word *av) C_noret;
C_noret_decl(f_3474)
static void C_ccall f_3474(C_word c,C_word *av) C_noret;
C_noret_decl(f_3476)
static void C_fcall f_3476(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5427)
static void C_ccall f_5427(C_word c,C_word *av) C_noret;
C_noret_decl(f_5420)
static void C_ccall f_5420(C_word c,C_word *av) C_noret;
C_noret_decl(f_5330)
static void C_ccall f_5330(C_word c,C_word *av) C_noret;
C_noret_decl(f_3469)
static void C_ccall f_3469(C_word c,C_word *av) C_noret;
C_noret_decl(f_5334)
static void C_fcall f_5334(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3467)
static void C_ccall f_3467(C_word c,C_word *av) C_noret;
C_noret_decl(f_5434)
static void C_ccall f_5434(C_word c,C_word *av) C_noret;
C_noret_decl(f_3461)
static void C_ccall f_3461(C_word c,C_word *av) C_noret;
C_noret_decl(f_5848)
static void C_fcall f_5848(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5845)
static void C_ccall f_5845(C_word c,C_word *av) C_noret;
C_noret_decl(f_5841)
static void C_ccall f_5841(C_word c,C_word *av) C_noret;
C_noret_decl(f_3020)
static void C_ccall f_3020(C_word c,C_word *av) C_noret;
C_noret_decl(f_3023)
static void C_ccall f_3023(C_word c,C_word *av) C_noret;
C_noret_decl(f_5122)
static void C_fcall f_5122(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_3027)
static void C_ccall f_3027(C_word c,C_word *av) C_noret;
C_noret_decl(f_5129)
static void C_ccall f_5129(C_word c,C_word *av) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word *av) C_noret;
C_noret_decl(f_3456)
static void C_ccall f_3456(C_word c,C_word *av) C_noret;
C_noret_decl(f_3459)
static void C_ccall f_3459(C_word c,C_word *av) C_noret;
C_noret_decl(f_3450)
static void C_ccall f_3450(C_word c,C_word *av) C_noret;
C_noret_decl(f_4672)
static void C_ccall f_4672(C_word c,C_word *av) C_noret;
C_noret_decl(f_3210)
static void C_ccall f_3210(C_word c,C_word *av) C_noret;
C_noret_decl(f_3218)
static void C_ccall f_3218(C_word c,C_word *av) C_noret;
C_noret_decl(f_3795)
static void C_ccall f_3795(C_word c,C_word *av) C_noret;
C_noret_decl(f_5132)
static void C_ccall f_5132(C_word c,C_word *av) C_noret;
C_noret_decl(f_3017)
static void C_ccall f_3017(C_word c,C_word *av) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135(C_word c,C_word *av) C_noret;
C_noret_decl(f_3941)
static void C_ccall f_3941(C_word c,C_word *av) C_noret;
C_noret_decl(f_5138)
static void C_ccall f_5138(C_word c,C_word *av) C_noret;
C_noret_decl(f_4666)
static void C_ccall f_4666(C_word c,C_word *av) C_noret;
C_noret_decl(f_4660)
static void C_ccall f_4660(C_word c,C_word *av) C_noret;
C_noret_decl(f_5863)
static void C_fcall f_5863(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3935)
static void C_ccall f_3935(C_word c,C_word *av) C_noret;
C_noret_decl(f_3709)
static void C_ccall f_3709(C_word c,C_word *av) C_noret;
C_noret_decl(f_5105)
static void C_ccall f_5105(C_word c,C_word *av) C_noret;
C_noret_decl(f_3707)
static void C_ccall f_3707(C_word c,C_word *av) C_noret;
C_noret_decl(f_3932)
static void C_ccall f_3932(C_word c,C_word *av) C_noret;
C_noret_decl(f_3703)
static void C_ccall f_3703(C_word c,C_word *av) C_noret;
C_noret_decl(f_4658)
static void C_ccall f_4658(C_word c,C_word *av) C_noret;
C_noret_decl(f_4650)
static void C_ccall f_4650(C_word c,C_word *av) C_noret;
C_noret_decl(f_3773)
static void C_ccall f_3773(C_word c,C_word *av) C_noret;
C_noret_decl(f_3777)
static void C_ccall f_3777(C_word c,C_word *av) C_noret;
C_noret_decl(f_3812)
static void C_ccall f_3812(C_word c,C_word *av) C_noret;
C_noret_decl(f_3810)
static void C_ccall f_3810(C_word c,C_word *av) C_noret;
C_noret_decl(f_4399)
static void C_ccall f_4399(C_word c,C_word *av) C_noret;
C_noret_decl(f_4505)
static void C_ccall f_4505(C_word c,C_word *av) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501(C_word c,C_word *av) C_noret;
C_noret_decl(f_3818)
static void C_ccall f_3818(C_word c,C_word *av) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391(C_word c,C_word *av) C_noret;
C_noret_decl(f_3765)
static void C_ccall f_3765(C_word c,C_word *av) C_noret;
C_noret_decl(f_3994)
static void C_ccall f_3994(C_word c,C_word *av) C_noret;
C_noret_decl(f_3997)
static void C_ccall f_3997(C_word c,C_word *av) C_noret;
C_noret_decl(f_3991)
static void C_ccall f_3991(C_word c,C_word *av) C_noret;
C_noret_decl(f_3499)
static void C_ccall f_3499(C_word c,C_word *av) C_noret;
C_noret_decl(f_3495)
static void C_ccall f_3495(C_word c,C_word *av) C_noret;
C_noret_decl(f_4522)
static void C_ccall f_4522(C_word c,C_word *av) C_noret;
C_noret_decl(f_3981)
static void C_ccall f_3981(C_word c,C_word *av) C_noret;
C_noret_decl(f_3400)
static void C_ccall f_3400(C_word c,C_word *av) C_noret;
C_noret_decl(f_3401)
static void C_ccall f_3401(C_word c,C_word *av) C_noret;
C_noret_decl(f_3409)
static void C_ccall f_3409(C_word c,C_word *av) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word *av) C_noret;
C_noret_decl(f_4515)
static void C_ccall f_4515(C_word c,C_word *av) C_noret;
C_noret_decl(f_4510)
static void C_ccall f_4510(C_word c,C_word *av) C_noret;
C_noret_decl(f_5789)
static void C_ccall f_5789(C_word c,C_word *av) C_noret;
C_noret_decl(f_4354)
static void C_ccall f_4354(C_word c,C_word *av) C_noret;
C_noret_decl(f_4689)
static void C_ccall f_4689(C_word c,C_word *av) C_noret;
C_noret_decl(f_4681)
static void C_fcall f_4681(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4363)
static void C_ccall f_4363(C_word c,C_word *av) C_noret;
C_noret_decl(f_4388)
static void C_ccall f_4388(C_word c,C_word *av) C_noret;
C_noret_decl(f_4381)
static void C_ccall f_4381(C_word c,C_word *av) C_noret;
C_noret_decl(f_5763)
static void C_ccall f_5763(C_word c,C_word *av) C_noret;
C_noret_decl(f_5767)
static void C_ccall f_5767(C_word c,C_word *av) C_noret;
C_noret_decl(f_5897)
static void C_ccall f_5897(C_word c,C_word *av) C_noret;
C_noret_decl(f_4373)
static void C_ccall f_4373(C_word c,C_word *av) C_noret;
C_noret_decl(f_5774)
static void C_ccall f_5774(C_word c,C_word *av) C_noret;
C_noret_decl(f_3442)
static void C_ccall f_3442(C_word c,C_word *av) C_noret;
C_noret_decl(f_4370)
static void C_ccall f_4370(C_word c,C_word *av) C_noret;
C_noret_decl(f_5779)
static void C_ccall f_5779(C_word c,C_word *av) C_noret;
C_noret_decl(f_3447)
static void C_ccall f_3447(C_word c,C_word *av) C_noret;
C_noret_decl(f_5771)
static void C_ccall f_5771(C_word c,C_word *av) C_noret;
C_noret_decl(f_3430)
static void C_ccall f_3430(C_word c,C_word *av) C_noret;
C_noret_decl(f_5748)
static void C_ccall f_5748(C_word c,C_word *av) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439(C_word c,C_word *av) C_noret;
C_noret_decl(f_3436)
static void C_ccall f_3436(C_word c,C_word *av) C_noret;
C_noret_decl(f_3433)
static void C_ccall f_3433(C_word c,C_word *av) C_noret;
C_noret_decl(f_5759)
static void C_ccall f_5759(C_word c,C_word *av) C_noret;
C_noret_decl(f_3427)
static void C_ccall f_3427(C_word c,C_word *av) C_noret;
C_noret_decl(f_3423)
static void C_ccall f_3423(C_word c,C_word *av) C_noret;
C_noret_decl(f_6293)
static void C_ccall f_6293(C_word c,C_word *av) C_noret;
C_noret_decl(f_3417)
static void C_ccall f_3417(C_word c,C_word *av) C_noret;
C_noret_decl(f_6277)
static void C_ccall f_6277(C_word c,C_word *av) C_noret;
C_noret_decl(f_5736)
static void C_ccall f_5736(C_word c,C_word *av) C_noret;
C_noret_decl(f_5236)
static void C_ccall f_5236(C_word c,C_word *av) C_noret;
C_noret_decl(f_5730)
static void C_ccall f_5730(C_word c,C_word *av) C_noret;
C_noret_decl(f_3238)
static void C_ccall f_3238(C_word c,C_word *av) C_noret;
C_noret_decl(f_3950)
static void C_ccall f_3950(C_word c,C_word *av) C_noret;
C_noret_decl(f_6283)
static void C_ccall f_6283(C_word c,C_word *av) C_noret;
C_noret_decl(f_6281)
static void C_ccall f_6281(C_word c,C_word *av) C_noret;
C_noret_decl(f_3959)
static void C_ccall f_3959(C_word c,C_word *av) C_noret;
C_noret_decl(f_6256)
static void C_ccall f_6256(C_word c,C_word *av) C_noret;
C_noret_decl(f_4734)
static void C_ccall f_4734(C_word c,C_word *av) C_noret;
C_noret_decl(f_4736)
static void C_ccall f_4736(C_word c,C_word *av) C_noret;
C_noret_decl(f_4722)
static void C_ccall f_4722(C_word c,C_word *av) C_noret;
C_noret_decl(f_2684)
static void C_ccall f_2684(C_word c,C_word *av) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word *av) C_noret;
C_noret_decl(f_5351)
static void C_ccall f_5351(C_word c,C_word *av) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word *av) C_noret;
C_noret_decl(f_2672)
static void C_ccall f_2672(C_word c,C_word *av) C_noret;
C_noret_decl(f_5366)
static void C_ccall f_5366(C_word c,C_word *av) C_noret;
C_noret_decl(f_5362)
static void C_ccall f_5362(C_word c,C_word *av) C_noret;
C_noret_decl(f_5258)
static void C_ccall f_5258(C_word c,C_word *av) C_noret;
C_noret_decl(f_2658)
static void C_ccall f_2658(C_word c,C_word *av) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word *av) C_noret;
C_noret_decl(f_2643)
static void C_fcall f_2643(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4495)
static void C_ccall f_4495(C_word c,C_word *av) C_noret;
C_noret_decl(f_4490)
static void C_ccall f_4490(C_word c,C_word *av) C_noret;
C_noret_decl(f_5191)
static void C_ccall f_5191(C_word c,C_word *av) C_noret;
C_noret_decl(f_4485)
static void C_ccall f_4485(C_word c,C_word *av) C_noret;
C_noret_decl(f_4481)
static void C_ccall f_4481(C_word c,C_word *av) C_noret;
C_noret_decl(f_5169)
static void C_ccall f_5169(C_word c,C_word *av) C_noret;
C_noret_decl(f_4476)
static void C_ccall f_4476(C_word c,C_word *av) C_noret;
C_noret_decl(f_2916)
static void C_fcall f_2916(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4471)
static void C_ccall f_4471(C_word c,C_word *av) C_noret;
C_noret_decl(f_4467)
static void C_ccall f_4467(C_word c,C_word *av) C_noret;
C_noret_decl(f_4461)
static void C_ccall f_4461(C_word c,C_word *av) C_noret;
C_noret_decl(f_2919)
static void C_ccall f_2919(C_word c,C_word *av) C_noret;
C_noret_decl(f_4456)
static void C_ccall f_4456(C_word c,C_word *av) C_noret;
C_noret_decl(f_2935)
static void C_ccall f_2935(C_word c,C_word *av) C_noret;
C_noret_decl(f_4451)
static void C_ccall f_4451(C_word c,C_word *av) C_noret;
C_noret_decl(f_2907)
static void C_ccall f_2907(C_word c,C_word *av) C_noret;
C_noret_decl(f_2909)
static void C_fcall f_2909(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5158)
static void C_ccall f_5158(C_word c,C_word *av) C_noret;
C_noret_decl(f_5154)
static void C_fcall f_5154(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4447)
static void C_ccall f_4447(C_word c,C_word *av) C_noret;
C_noret_decl(f_4442)
static void C_ccall f_4442(C_word c,C_word *av) C_noret;
C_noret_decl(f_4432)
static void C_ccall f_4432(C_word c,C_word *av) C_noret;
C_noret_decl(f_4438)
static void C_ccall f_4438(C_word c,C_word *av) C_noret;
C_noret_decl(f_4423)
static void C_ccall f_4423(C_word c,C_word *av) C_noret;
C_noret_decl(f_4427)
static void C_ccall f_4427(C_word c,C_word *av) C_noret;
C_noret_decl(f_6161)
static void C_ccall f_6161(C_word c,C_word *av) C_noret;
C_noret_decl(f_2728)
static void C_ccall f_2728(C_word c,C_word *av) C_noret;
C_noret_decl(f_6167)
static void C_ccall f_6167(C_word c,C_word *av) C_noret;
C_noret_decl(f_3077)
static void C_ccall f_3077(C_word c,C_word *av) C_noret;
C_noret_decl(f_3067)
static void C_fcall f_3067(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word *av) C_noret;
C_noret_decl(f_4314)
static void C_ccall f_4314(C_word c,C_word *av) C_noret;
C_noret_decl(f_3055)
static void C_ccall f_3055(C_word c,C_word *av) C_noret;
C_noret_decl(f_4344)
static void C_ccall f_4344(C_word c,C_word *av) C_noret;
C_noret_decl(f_2734)
static void C_ccall f_2734(C_word c,C_word *av) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word *av) C_noret;
C_noret_decl(f_2841)
static void C_ccall f_2841(C_word c,C_word *av) C_noret;
C_noret_decl(f_2844)
static void C_ccall f_2844(C_word c,C_word *av) C_noret;
C_noret_decl(f_2849)
static void C_fcall f_2849(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4304)
static void C_ccall f_4304(C_word c,C_word *av) C_noret;
C_noret_decl(f_5557)
static void C_ccall f_5557(C_word c,C_word *av) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word *av) C_noret;
C_noret_decl(f_4323)
static void C_ccall f_4323(C_word c,C_word *av) C_noret;
C_noret_decl(f_2859)
static void C_ccall f_2859(C_word c,C_word *av) C_noret;
C_noret_decl(f_5503)
static void C_ccall f_5503(C_word c,C_word *av) C_noret;
C_noret_decl(f_6041)
static void C_ccall f_6041(C_word c,C_word *av) C_noret;
C_noret_decl(f_6047)
static void C_ccall f_6047(C_word c,C_word *av) C_noret;
C_noret_decl(f_4414)
static void C_ccall f_4414(C_word c,C_word *av) C_noret;
C_noret_decl(f_3254)
static void C_fcall f_3254(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3251)
static void C_fcall f_3251(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4418)
static void C_ccall f_4418(C_word c,C_word *av) C_noret;
C_noret_decl(f_2881)
static void C_ccall f_2881(C_word c,C_word *av) C_noret;
C_noret_decl(f_5516)
static void C_fcall f_5516(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5514)
static void C_fcall f_5514(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4403)
static void C_ccall f_4403(C_word c,C_word *av) C_noret;
C_noret_decl(f_3285)
static void C_ccall f_3285(C_word c,C_word *av) C_noret;
C_noret_decl(f_4408)
static void C_ccall f_4408(C_word c,C_word *av) C_noret;
C_noret_decl(f_5565)
static void C_ccall f_5565(C_word c,C_word *av) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023(C_word c,C_word *av) C_noret;
C_noret_decl(f_6029)
static void C_ccall f_6029(C_word c,C_word *av) C_noret;
C_noret_decl(f_5560)
static void C_ccall f_5560(C_word c,C_word *av) C_noret;
C_noret_decl(f_6035)
static void C_ccall f_6035(C_word c,C_word *av) C_noret;
C_noret_decl(f_2547)
static void C_ccall f_2547(C_word c,C_word *av) C_noret;
C_noret_decl(f_5571)
static void C_ccall f_5571(C_word c,C_word *av) C_noret;
C_noret_decl(f_3263)
static void C_fcall f_3263(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3261)
static void C_ccall f_3261(C_word c,C_word *av) C_noret;
C_noret_decl(f_2891)
static void C_ccall f_2891(C_word c,C_word *av) C_noret;
C_noret_decl(f_2897)
static void C_ccall f_2897(C_word c,C_word *av) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539(C_word c,C_word *av) C_noret;
C_noret_decl(f_2537)
static void C_ccall f_2537(C_word c,C_word *av) C_noret;
C_noret_decl(f_6005)
static void C_ccall f_6005(C_word c,C_word *av) C_noret;
C_noret_decl(f_2552)
static void C_ccall f_2552(C_word c,C_word *av) C_noret;
C_noret_decl(f_6011)
static void C_ccall f_6011(C_word c,C_word *av) C_noret;
C_noret_decl(f_6017)
static void C_ccall f_6017(C_word c,C_word *av) C_noret;
C_noret_decl(f_2568)
static void C_ccall f_2568(C_word c,C_word *av) C_noret;
C_noret_decl(f_2556)
static void C_fcall f_2556(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2251)
static void C_ccall f_2251(C_word c,C_word *av) C_noret;
C_noret_decl(f_2574)
static void C_ccall f_2574(C_word c,C_word *av) C_noret;
C_noret_decl(f_2257)
static void C_ccall f_2257(C_word c,C_word *av) C_noret;
C_noret_decl(f_2254)
static void C_ccall f_2254(C_word c,C_word *av) C_noret;
C_noret_decl(f_2248)
static void C_ccall f_2248(C_word c,C_word *av) C_noret;
C_noret_decl(f_4630)
static void C_ccall f_4630(C_word c,C_word *av) C_noret;
C_noret_decl(f_4638)
static void C_ccall f_4638(C_word c,C_word *av) C_noret;
C_noret_decl(f_4998)
static void C_fcall f_4998(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5598)
static void C_ccall f_5598(C_word c,C_word *av) C_noret;
C_noret_decl(f_5596)
static void C_ccall f_5596(C_word c,C_word *av) C_noret;
C_noret_decl(f_5592)
static void C_ccall f_5592(C_word c,C_word *av) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_2507)
static void C_ccall f_2507(C_word c,C_word *av) C_noret;
C_noret_decl(f_4614)
static void C_ccall f_4614(C_word c,C_word *av) C_noret;
C_noret_decl(f_3739)
static void C_ccall f_3739(C_word c,C_word *av) C_noret;
C_noret_decl(f_3735)
static void C_fcall f_3735(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3593)
static void C_ccall f_3593(C_word c,C_word *av) C_noret;
C_noret_decl(f_3729)
static void C_ccall f_3729(C_word c,C_word *av) C_noret;
C_noret_decl(f_3599)
static void C_ccall f_3599(C_word c,C_word *av) C_noret;
C_noret_decl(f_3547)
static void C_ccall f_3547(C_word c,C_word *av) C_noret;
C_noret_decl(f_3143)
static void C_fcall f_3143(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3717)
static void C_ccall f_3717(C_word c,C_word *av) C_noret;
C_noret_decl(f_6303)
static void C_ccall f_6303(C_word c,C_word *av) C_noret;
C_noret_decl(f_3137)
static void C_ccall f_3137(C_word c,C_word *av) C_noret;
C_noret_decl(f_4194)
static void C_fcall f_4194(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3656)
static void C_ccall f_3656(C_word c,C_word *av) C_noret;
C_noret_decl(f_2509)
static void C_ccall f_2509(C_word c,C_word *av) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word *av) C_noret;
C_noret_decl(f_3915)
static void C_ccall f_3915(C_word c,C_word *av) C_noret;
C_noret_decl(f_3919)
static void C_fcall f_3919(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585(C_word c,C_word *av) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527(C_word c,C_word *av) C_noret;
C_noret_decl(f_3589)
static void C_ccall f_3589(C_word c,C_word *av) C_noret;
C_noret_decl(f_2517)
static void C_ccall f_2517(C_word c,C_word *av) C_noret;
C_noret_decl(f_2529)
static void C_ccall f_2529(C_word c,C_word *av) C_noret;
C_noret_decl(f_5041)
static void C_ccall f_5041(C_word c,C_word *av) C_noret;
C_noret_decl(f_2519)
static void C_ccall f_2519(C_word c,C_word *av) C_noret;
C_noret_decl(f_5718)
static void C_ccall f_5718(C_word c,C_word *av) C_noret;
C_noret_decl(f_3516)
static void C_ccall f_3516(C_word c,C_word *av) C_noret;
C_noret_decl(f_4969)
static C_word C_fcall f_4969(C_word t0,C_word t1);
C_noret_decl(f_5032)
static void C_ccall f_5032(C_word c,C_word *av) C_noret;
C_noret_decl(f_4955)
static void C_fcall f_4955(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3848)
static void C_ccall f_3848(C_word c,C_word *av) C_noret;
C_noret_decl(f_3842)
static void C_ccall f_3842(C_word c,C_word *av) C_noret;
C_noret_decl(f_4531)
static void C_ccall f_4531(C_word c,C_word *av) C_noret;
C_noret_decl(f_3663)
static void C_ccall f_3663(C_word c,C_word *av) C_noret;
C_noret_decl(f_3660)
static void C_ccall f_3660(C_word c,C_word *av) C_noret;
C_noret_decl(f_5444)
static void C_ccall f_5444(C_word c,C_word *av) C_noret;
C_noret_decl(f_3520)
static void C_ccall f_3520(C_word c,C_word *av) C_noret;
C_noret_decl(f_5448)
static void C_ccall f_5448(C_word c,C_word *av) C_noret;
C_noret_decl(f_5987)
static void C_ccall f_5987(C_word c,C_word *av) C_noret;
C_noret_decl(f_5981)
static void C_ccall f_5981(C_word c,C_word *av) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word *av) C_noret;
C_noret_decl(f_4092)
static void C_fcall f_4092(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5993)
static void C_ccall f_5993(C_word c,C_word *av) C_noret;
C_noret_decl(f_5452)
static void C_ccall f_5452(C_word c,C_word *av) C_noret;
C_noret_decl(f_3557)
static void C_ccall f_3557(C_word c,C_word *av) C_noret;
C_noret_decl(f_5999)
static void C_ccall f_5999(C_word c,C_word *av) C_noret;
C_noret_decl(f_3551)
static void C_ccall f_3551(C_word c,C_word *av) C_noret;
C_noret_decl(f_5969)
static void C_ccall f_5969(C_word c,C_word *av) C_noret;
C_noret_decl(f_5464)
static void C_ccall f_5464(C_word c,C_word *av) C_noret;
C_noret_decl(f_5024)
static void C_ccall f_5024(C_word c,C_word *av) C_noret;
C_noret_decl(f_5963)
static void C_ccall f_5963(C_word c,C_word *av) C_noret;
C_noret_decl(f_5975)
static void C_ccall f_5975(C_word c,C_word *av) C_noret;
C_noret_decl(f_5475)
static void C_ccall f_5475(C_word c,C_word *av) C_noret;
C_noret_decl(f_5479)
static void C_ccall f_5479(C_word c,C_word *av) C_noret;
C_noret_decl(f_5471)
static void C_ccall f_5471(C_word c,C_word *av) C_noret;
C_noret_decl(f_5945)
static void C_ccall f_5945(C_word c,C_word *av) C_noret;
C_noret_decl(f_4078)
static void C_ccall f_4078(C_word c,C_word *av) C_noret;
C_noret_decl(f_4075)
static void C_ccall f_4075(C_word c,C_word *av) C_noret;
C_noret_decl(f_3692)
static void C_ccall f_3692(C_word c,C_word *av) C_noret;
C_noret_decl(f_5957)
static void C_ccall f_5957(C_word c,C_word *av) C_noret;
C_noret_decl(f_5951)
static void C_ccall f_5951(C_word c,C_word *av) C_noret;
C_noret_decl(f_4087)
static void C_ccall f_4087(C_word c,C_word *av) C_noret;
C_noret_decl(f_4084)
static void C_ccall f_4084(C_word c,C_word *av) C_noret;
C_noret_decl(f_3684)
static void C_ccall f_3684(C_word c,C_word *av) C_noret;
C_noret_decl(f_6173)
static void C_ccall f_6173(C_word c,C_word *av) C_noret;
C_noret_decl(f_6179)
static void C_ccall f_6179(C_word c,C_word *av) C_noret;
C_noret_decl(f_5939)
static void C_ccall f_5939(C_word c,C_word *av) C_noret;
C_noret_decl(f_5930)
static void C_ccall f_5930(C_word c,C_word *av) C_noret;
C_noret_decl(f_4065)
static void C_ccall f_4065(C_word c,C_word *av) C_noret;
C_noret_decl(f_5904)
static void C_fcall f_5904(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6155)
static void C_ccall f_6155(C_word c,C_word *av) C_noret;
C_noret_decl(f_2614)
static void C_ccall f_2614(C_word c,C_word *av) C_noret;
C_noret_decl(f_6186)
static void C_ccall f_6186(C_word c,C_word *av) C_noret;
C_noret_decl(f_4297)
static void C_ccall f_4297(C_word c,C_word *av) C_noret;
C_noret_decl(f_2601)
static void C_ccall f_2601(C_word c,C_word *av) C_noret;
C_noret_decl(f_2606)
static void C_fcall f_2606(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4281)
static void C_ccall f_4281(C_word c,C_word *av) C_noret;
C_noret_decl(f_4283)
static void C_ccall f_4283(C_word c,C_word *av) C_noret;
C_noret_decl(f_2347)
static void C_ccall f_2347(C_word c,C_word *av) C_noret;
C_noret_decl(f_5487)
static void C_ccall f_5487(C_word c,C_word *av) C_noret;
C_noret_decl(f_5483)
static void C_ccall f_5483(C_word c,C_word *av) C_noret;
C_noret_decl(f_2340)
static void C_ccall f_2340(C_word c,C_word *av) C_noret;
C_noret_decl(f_2335)
static void C_ccall f_2335(C_word c,C_word *av) C_noret;
C_noret_decl(f_4269)
static void C_ccall f_4269(C_word c,C_word *av) C_noret;
C_noret_decl(f_4265)
static void C_fcall f_4265(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4162)
static void C_ccall f_4162(C_word c,C_word *av) C_noret;
C_noret_decl(f_4897)
static void C_ccall f_4897(C_word c,C_word *av) C_noret;
C_noret_decl(f_4894)
static void C_fcall f_4894(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2366)
static void C_ccall f_2366(C_word c,C_word *av) C_noret;
C_noret_decl(f_2368)
static void C_ccall f_2368(C_word c,C_word *av) C_noret;
C_noret_decl(f_2362)
static void C_ccall f_2362(C_word c,C_word *av) C_noret;
C_noret_decl(f_2360)
static void C_ccall f_2360(C_word c,C_word *av) C_noret;
C_noret_decl(f_4841)
static void C_ccall f_4841(C_word c,C_word *av) C_noret;
C_noret_decl(f_4185)
static void C_ccall f_4185(C_word c,C_word *av) C_noret;
C_noret_decl(f_4181)
static void C_ccall f_4181(C_word c,C_word *av) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word *av) C_noret;
C_noret_decl(f_2386)
static void C_ccall f_2386(C_word c,C_word *av) C_noret;
C_noret_decl(f_2380)
static void C_ccall f_2380(C_word c,C_word *av) C_noret;
C_noret_decl(f_2384)
static void C_ccall f_2384(C_word c,C_word *av) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word *av) C_noret;
C_noret_decl(f_5062)
static void C_ccall f_5062(C_word c,C_word *av) C_noret;
C_noret_decl(f_2374)
static void C_ccall f_2374(C_word c,C_word *av) C_noret;
C_noret_decl(f_2372)
static void C_ccall f_2372(C_word c,C_word *av) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word *av) C_noret;
C_noret_decl(f_3310)
static void C_ccall f_3310(C_word c,C_word *av) C_noret;
C_noret_decl(f_3329)
static void C_ccall f_3329(C_word c,C_word *av) C_noret;
C_noret_decl(f_2761)
static void C_ccall f_2761(C_word c,C_word *av) C_noret;
C_noret_decl(f_3319)
static void C_ccall f_3319(C_word c,C_word *av) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word *av) C_noret;
C_noret_decl(f_2392)
static void C_ccall f_2392(C_word c,C_word *av) C_noret;
C_noret_decl(f_3307)
static void C_ccall f_3307(C_word c,C_word *av) C_noret;
C_noret_decl(f_4750)
static void C_ccall f_4750(C_word c,C_word *av) C_noret;
C_noret_decl(f_2702)
static void C_ccall f_2702(C_word c,C_word *av) C_noret;
C_noret_decl(f_2777)
static void C_ccall f_2777(C_word c,C_word *av) C_noret;
C_noret_decl(f_4861)
static void C_ccall f_4861(C_word c,C_word *av) C_noret;
C_noret_decl(f_4748)
static void C_ccall f_4748(C_word c,C_word *av) C_noret;
C_noret_decl(f_2774)
static void C_ccall f_2774(C_word c,C_word *av) C_noret;
C_noret_decl(f_4814)
static void C_ccall f_4814(C_word c,C_word *av) C_noret;
C_noret_decl(f_4776)
static void C_ccall f_4776(C_word c,C_word *av) C_noret;
C_noret_decl(f_2795)
static void C_ccall f_2795(C_word c,C_word *av) C_noret;
C_noret_decl(f_4762)
static void C_ccall f_4762(C_word c,C_word *av) C_noret;
C_noret_decl(f_4764)
static void C_ccall f_4764(C_word c,C_word *av) C_noret;
C_noret_decl(f_5086)
static void C_fcall f_5086(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2741)
static void C_fcall f_2741(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2744)
static void C_ccall f_2744(C_word c,C_word *av) C_noret;
C_noret_decl(f_4718)
static void C_fcall f_4718(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4828)
static void C_ccall f_4828(C_word c,C_word *av) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word *av) C_noret;
C_noret_decl(f_2328)
static void C_ccall f_2328(C_word c,C_word *av) C_noret;
C_noret_decl(f_6059)
static void C_ccall f_6059(C_word c,C_word *av) C_noret;
C_noret_decl(f_4888)
static void C_ccall f_4888(C_word c,C_word *av) C_noret;
C_noret_decl(f_6077)
static void C_ccall f_6077(C_word c,C_word *av) C_noret;
C_noret_decl(f_4880)
static void C_ccall f_4880(C_word c,C_word *av) C_noret;
C_noret_decl(f_3177)
static void C_fcall f_3177(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2319)
static void C_ccall f_2319(C_word c,C_word *av) C_noret;
C_noret_decl(f_3175)
static void C_ccall f_3175(C_word c,C_word *av) C_noret;
C_noret_decl(f_5074)
static void C_fcall f_5074(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6053)
static void C_ccall f_6053(C_word c,C_word *av) C_noret;
C_noret_decl(f_6071)
static void C_ccall f_6071(C_word c,C_word *av) C_noret;
C_noret_decl(f_6065)
static void C_ccall f_6065(C_word c,C_word *av) C_noret;
C_noret_decl(f_2315)
static void C_ccall f_2315(C_word c,C_word *av) C_noret;
C_noret_decl(f_3168)
static void C_ccall f_3168(C_word c,C_word *av) C_noret;
C_noret_decl(f_3164)
static void C_ccall f_3164(C_word c,C_word *av) C_noret;

C_noret_decl(trf_2825)
static void C_ccall trf_2825(C_word c,C_word *av) C_noret;
static void C_ccall trf_2825(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2825(t0,t1,t2);}

C_noret_decl(trf_3198)
static void C_ccall trf_3198(C_word c,C_word *av) C_noret;
static void C_ccall trf_3198(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3198(t0,t1,t2);}

C_noret_decl(trf_2290)
static void C_ccall trf_2290(C_word c,C_word *av) C_noret;
static void C_ccall trf_2290(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2290(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4805)
static void C_ccall trf_4805(C_word c,C_word *av) C_noret;
static void C_ccall trf_4805(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4805(t0,t1);}

C_noret_decl(trf_2801)
static void C_ccall trf_2801(C_word c,C_word *av) C_noret;
static void C_ccall trf_2801(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2801(t0,t1);}

C_noret_decl(trf_4035)
static void C_ccall trf_4035(C_word c,C_word *av) C_noret;
static void C_ccall trf_4035(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4035(t0,t1);}

C_noret_decl(trf_4201)
static void C_ccall trf_4201(C_word c,C_word *av) C_noret;
static void C_ccall trf_4201(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4201(t0,t1);}

C_noret_decl(trf_4139)
static void C_ccall trf_4139(C_word c,C_word *av) C_noret;
static void C_ccall trf_4139(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4139(t0,t1,t2);}

C_noret_decl(trf_4906)
static void C_ccall trf_4906(C_word c,C_word *av) C_noret;
static void C_ccall trf_4906(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4906(t0,t1);}

C_noret_decl(trf_4640)
static void C_ccall trf_4640(C_word c,C_word *av) C_noret;
static void C_ccall trf_4640(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4640(t0,t1,t2,t3);}

C_noret_decl(trf_3747)
static void C_ccall trf_3747(C_word c,C_word *av) C_noret;
static void C_ccall trf_3747(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3747(t0,t1,t2);}

C_noret_decl(trf_3041)
static void C_ccall trf_3041(C_word c,C_word *av) C_noret;
static void C_ccall trf_3041(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3041(t0,t1);}

C_noret_decl(trf_3476)
static void C_ccall trf_3476(C_word c,C_word *av) C_noret;
static void C_ccall trf_3476(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3476(t0,t1,t2);}

C_noret_decl(trf_5334)
static void C_ccall trf_5334(C_word c,C_word *av) C_noret;
static void C_ccall trf_5334(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5334(t0,t1);}

C_noret_decl(trf_5848)
static void C_ccall trf_5848(C_word c,C_word *av) C_noret;
static void C_ccall trf_5848(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5848(t0,t1);}

C_noret_decl(trf_5122)
static void C_ccall trf_5122(C_word c,C_word *av) C_noret;
static void C_ccall trf_5122(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_5122(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5863)
static void C_ccall trf_5863(C_word c,C_word *av) C_noret;
static void C_ccall trf_5863(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5863(t0,t1);}

C_noret_decl(trf_4681)
static void C_ccall trf_4681(C_word c,C_word *av) C_noret;
static void C_ccall trf_4681(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4681(t0,t1,t2,t3);}

C_noret_decl(trf_2643)
static void C_ccall trf_2643(C_word c,C_word *av) C_noret;
static void C_ccall trf_2643(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2643(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2916)
static void C_ccall trf_2916(C_word c,C_word *av) C_noret;
static void C_ccall trf_2916(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2916(t0,t1);}

C_noret_decl(trf_2909)
static void C_ccall trf_2909(C_word c,C_word *av) C_noret;
static void C_ccall trf_2909(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2909(t0,t1,t2);}

C_noret_decl(trf_5154)
static void C_ccall trf_5154(C_word c,C_word *av) C_noret;
static void C_ccall trf_5154(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5154(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3067)
static void C_ccall trf_3067(C_word c,C_word *av) C_noret;
static void C_ccall trf_3067(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3067(t0,t1);}

C_noret_decl(trf_2849)
static void C_ccall trf_2849(C_word c,C_word *av) C_noret;
static void C_ccall trf_2849(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2849(t0,t1,t2);}

C_noret_decl(trf_3254)
static void C_ccall trf_3254(C_word c,C_word *av) C_noret;
static void C_ccall trf_3254(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3254(t0,t1);}

C_noret_decl(trf_3251)
static void C_ccall trf_3251(C_word c,C_word *av) C_noret;
static void C_ccall trf_3251(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3251(t0,t1);}

C_noret_decl(trf_5516)
static void C_ccall trf_5516(C_word c,C_word *av) C_noret;
static void C_ccall trf_5516(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_5516(t0,t1,t2);}

C_noret_decl(trf_5514)
static void C_ccall trf_5514(C_word c,C_word *av) C_noret;
static void C_ccall trf_5514(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_5514(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3263)
static void C_ccall trf_3263(C_word c,C_word *av) C_noret;
static void C_ccall trf_3263(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3263(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2556)
static void C_ccall trf_2556(C_word c,C_word *av) C_noret;
static void C_ccall trf_2556(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2556(t0,t1);}

C_noret_decl(trf_4998)
static void C_ccall trf_4998(C_word c,C_word *av) C_noret;
static void C_ccall trf_4998(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4998(t0,t1,t2,t3);}

C_noret_decl(trf_3735)
static void C_ccall trf_3735(C_word c,C_word *av) C_noret;
static void C_ccall trf_3735(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3735(t0,t1,t2);}

C_noret_decl(trf_3143)
static void C_ccall trf_3143(C_word c,C_word *av) C_noret;
static void C_ccall trf_3143(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3143(t0,t1,t2);}

C_noret_decl(trf_4194)
static void C_ccall trf_4194(C_word c,C_word *av) C_noret;
static void C_ccall trf_4194(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4194(t0,t1,t2);}

C_noret_decl(trf_3919)
static void C_ccall trf_3919(C_word c,C_word *av) C_noret;
static void C_ccall trf_3919(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3919(t0,t1);}

C_noret_decl(trf_4955)
static void C_ccall trf_4955(C_word c,C_word *av) C_noret;
static void C_ccall trf_4955(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4955(t0,t1,t2);}

C_noret_decl(trf_4092)
static void C_ccall trf_4092(C_word c,C_word *av) C_noret;
static void C_ccall trf_4092(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4092(t0,t1,t2);}

C_noret_decl(trf_5904)
static void C_ccall trf_5904(C_word c,C_word *av) C_noret;
static void C_ccall trf_5904(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5904(t0,t1);}

C_noret_decl(trf_2606)
static void C_ccall trf_2606(C_word c,C_word *av) C_noret;
static void C_ccall trf_2606(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2606(t0,t1,t2,t3);}

C_noret_decl(trf_4265)
static void C_ccall trf_4265(C_word c,C_word *av) C_noret;
static void C_ccall trf_4265(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4265(t0,t1,t2,t3);}

C_noret_decl(trf_4894)
static void C_ccall trf_4894(C_word c,C_word *av) C_noret;
static void C_ccall trf_4894(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4894(t0,t1);}

C_noret_decl(trf_5086)
static void C_ccall trf_5086(C_word c,C_word *av) C_noret;
static void C_ccall trf_5086(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_5086(t0,t1,t2,t3);}

C_noret_decl(trf_2741)
static void C_ccall trf_2741(C_word c,C_word *av) C_noret;
static void C_ccall trf_2741(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2741(t0,t1);}

C_noret_decl(trf_4718)
static void C_ccall trf_4718(C_word c,C_word *av) C_noret;
static void C_ccall trf_4718(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4718(t0,t1,t2,t3);}

C_noret_decl(trf_3177)
static void C_ccall trf_3177(C_word c,C_word *av) C_noret;
static void C_ccall trf_3177(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3177(t0,t1,t2);}

C_noret_decl(trf_5074)
static void C_ccall trf_5074(C_word c,C_word *av) C_noret;
static void C_ccall trf_5074(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5074(t0,t1,t2,t3,t4);}

/* a3157 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3158,2,av);}
/* posix-common.scm:502: decompose-pathname */
t2=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* set-alarm! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6095,2,av);}
/* posixwin.scm:1566: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[371];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* read-symbolic-link in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6089(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6089,2,av);}
/* posixwin.scm:1565: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[370];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* process-signal in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6083(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6083,2,av);}
/* posixwin.scm:1564: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[369];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3342 in a3335 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in ... */
static void C_ccall f_3344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,2))){C_save_and_reclaim((void *)f_3344,2,av);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3348,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3351,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:546: pproc */
t5=((C_word*)t0)[7];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2260(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(18,c,6))){C_save_and_reclaim((void *)f_2260,2,av);}
a=C_alloc(18);
t2=C_mutate2(&lf[2] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2272,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[8]+1 /* (set! ##sys#posix-error ...) */,lf[2]);
t4=C_mutate2(&lf[9] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2290,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[18]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2340,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2360,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6277,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6283,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:251: getter-with-setter */
t9=*((C_word*)lf[394]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=lf[401];
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a3330 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3331(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3331,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a3335 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_3336,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3344,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:545: directory */
t3=*((C_word*)lf[30]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k3346 in k3342 in a3335 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in ... */
static void C_ccall f_3348(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3348,2,av);}
/* posix-common.scm:544: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* duplicate-fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_4798,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_check_exact_2(t2,*((C_word*)lf[70]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4805,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_4805(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[70]);
t8=t5;
f_4805(t8,C_dup2(t2,t6));}}

/* k4794 in port->fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_4796,2,av);}
a=C_alloc(8);
if(C_truep(C_i_zerop(t1))){
/* posixwin.scm:1085: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[15];
av2[3]=lf[12];
av2[4]=lf[275];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4776,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4782,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1082: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* posix-error in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,2))){
C_save_and_reclaim((void*)f_2272,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2276,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:183: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t6;
tp(2,av2);}}

/* g1345 in chkstrlst in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static C_word C_fcall f_5521(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;{}
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* k3389 in k3382 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 in ... */
static void C_ccall f_3391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3391,2,av);}
/* posix-common.scm:548: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k3192 in loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_3194,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3198,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li35),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:501: g428 */
t3=t2;
f_3198(t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:511: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3177(t4,((C_word*)t0)[5],t3);}}

/* k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_2824,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2825,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2844,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2849,a[2]=t5,a[3]=t2,a[4]=((C_word)li26),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2849(t7,t3,t1);}

/* g293 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2825(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_2825,3,t0,t1,t2);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2835,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:440: symbolic-link? */
t4=*((C_word*)lf[36]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* g428 in k3192 in loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3198(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_3198,3,t0,t1,t2);}
a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3206,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3218,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:509: irregex-match-substring */
t5=*((C_word*)lf[92]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k4780 in k4794 in port->fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4782,2,av);}
/* posixwin.scm:1083: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[12];
av2[4]=lf[276];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2281 in k2274 in posix-error in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_2283,2,av);}{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[3]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=t1;
av2[6]=((C_word*)t0)[5];
C_apply(7,av2);}}

/* for-each-loop1344 in chkstrlst in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static C_word C_fcall f_5530(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_5521(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k2274 in posix-error in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,3))){C_save_and_reclaim((void *)f_2276,2,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2283,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2287,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub67(t4,t5);
/* posix-common.scm:180: ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* ##sys#stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2290(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(12,0,2))){
C_save_and_reclaim_args((void *)trf_2290,5,t1,t2,t3,t4,t5);}
a=C_alloc(12);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2294,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;{
C_word av2[2];
av2[0]=t7;
av2[1]=C_fstat(t2);
f_2294(2,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2315,a[2]=t6,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:224: port? */
t8=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}}

/* k2292 in stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2294,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:238: posix-error */
t2=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[11];
av2[5]=((C_word*)t0)[5];
f_2272(6,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k4803 in duplicate-fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4805(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_4805,2,t0,t1);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4808,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4814,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1096: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k4806 in k4803 in duplicate-fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4808,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2285 in k2274 in posix-error in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2287(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2287,2,av);}
/* posix-common.scm:184: string-append */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[5];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k2803 in rmdir in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2805(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2805,2,av);}
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:431: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[77];
av2[4]=lf[78];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}}

/* rmdir in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2801(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_2801,2,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2805,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:429: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k4045 in k4033 in k4030 in file-write in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_4047,2,av);}
/* posixwin.scm:776: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[166];
av2[4]=lf[167];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k3382 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3384(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_3384,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3391,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:548: action */
t3=((C_word*)t0)[6];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}
else{
/* posix-common.scm:549: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[8]);}}

/* k4039 in k4033 in k4030 in file-write in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4041,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2833 in g293 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_2835,2,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=*((C_word*)lf[79]+1);
t3=*((C_word*)lf[79]+1);
/* posix-common.scm:439: g303 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[79]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[79]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2841,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:441: directory? */
t3=*((C_word*)lf[41]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3375(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,2))){C_save_and_reclaim((void *)f_3375,2,av);}
a=C_alloc(16);
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3307,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3310,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:539: pproc */
t5=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[8];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3319,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[12],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:540: lproc */
t4=((C_word*)t0)[13];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}}

/* a2950 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2951,2,av);}
/* posix-common.scm:458: decompose-pathname */
t2=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* file-write in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,5))){
C_save_and_reclaim((void*)f_4025,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_exact_2(t2,lf[166]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4032,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_4032(2,av2);}}
else{
/* posixwin.scm:770: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[15];
av2[3]=lf[166];
av2[4]=lf[168];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}
else{
/* posixwin.scm:770: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[15];
av2[3]=lf[166];
av2[4]=lf[168];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}

/* k3367 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3369(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3369,2,av);}
if(C_truep(t1)){
/* posix-common.scm:547: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:547: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3263(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

/* k3364 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3366,2,av);}
/* posix-common.scm:547: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k2940 in k2914 in loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2942(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2942,2,av);}
/* posix-common.scm:461: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2909(t2,((C_word*)t0)[3],t1);}

/* a2956 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2957(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2957,5,av);}
if(C_truep(t3)){
/* posix-common.scm:459: make-pathname */
t5=*((C_word*)lf[87]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
t5=t2;
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* a3355 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3356,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3349 in k3342 in a3335 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in ... */
static void C_ccall f_3351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3351,2,av);}
if(C_truep(t1)){
/* posix-common.scm:546: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:544: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3263(t3,((C_word*)t0)[7],((C_word*)t0)[4],((C_word*)t0)[8],t2);}}

/* k2947 in loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2949,2,av);}
t2=((C_word*)t0)[2];
f_2916(t2,C_i_not(t1));}

/* k4004 in k3992 in k3989 in file-read in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4006(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_4006,2,av);}
/* posixwin.scm:763: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[163];
av2[4]=lf[164];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k4098 in k4094 in loop in k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_4100,2,av);}
a=C_alloc(8);
t2=C_a_i_bitwise_ior(&a,2,C_a_i_bitwise_ior(&a,2,*((C_word*)lf[136]+1),*((C_word*)lf[139]+1)),*((C_word*)lf[141]+1));
t3=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IWRITE));
t4=C_open(t1,t2,t3);
t5=C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
if(C_truep(C_fixnum_lessp(((C_word*)t0)[2],((C_word*)t0)[3]))){
t6=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
/* posixwin.scm:810: loop */
t7=((C_word*)((C_word*)t0)[4])[1];
f_4092(t7,((C_word*)t0)[5],t6);}
else{
/* posixwin.scm:811: posix-error */
t6=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[10];
av2[3]=lf[169];
av2[4]=lf[171];
av2[5]=((C_word*)t0)[6];
f_2272(6,av2);}}}
else{
/* posixwin.scm:812: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=((C_word*)t0)[7];
C_values(4,av2);}}}

/* k4033 in k4030 in file-write in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4035(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_4035,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=C_i_check_exact_2(t2,lf[166]);
t4=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4041,a[2]=((C_word*)t0)[4],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4047,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:775: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t7;
tp(2,av2);}}
else{
t7=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t7;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k4239 in k4230 in change-directory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4241,2,av);}
/* posixwin.scm:822: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[73];
av2[4]=lf[178];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k4030 in file-write in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4032(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4032,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4035,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4035(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4035(t3,C_block_size(((C_word*)t0)[3]));}}

/* k2978 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2980(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2980,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:450: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[83];
av2[4]=lf[84];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}}

/* k4230 in change-directory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4232(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_4232,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4235,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4241,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:821: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}}

/* directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_2998,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3002,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:467: current-directory */
t5=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_i_car(t3);
f_3002(2,av2);}}}

/* set-user-id! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6131,2,av);}
/* posixwin.scm:1572: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[377];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* signal-mask in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6137,2,av);}
/* posixwin.scm:1573: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[378];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4233 in k4230 in change-directory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4235,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* signal-mask! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6143,2,av);}
/* posixwin.scm:1574: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[379];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* signal-masked? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6149,2,av);}
/* posixwin.scm:1575: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[380];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* change-directory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4225,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[73]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4232,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:819: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[73];
tp(4,av2);}}

/* k2495 in symbolic-link? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2497,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[29],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* block-device? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2499,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2507,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:289: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k4199 in loop in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4201(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,2))){
C_save_and_reclaim_args((void *)trf_4201,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_difference(((C_word*)t0)[2],C_fix(1));
/* posixwin.scm:790: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4194(t3,((C_word*)t0)[4],t2);}
else{
t2=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* set-process-group-id! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6113,2,av);}
/* posixwin.scm:1569: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[374];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-root-directory! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6119(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6119,2,av);}
/* posixwin.scm:1570: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[375];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* suffix-loop in loop in k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4139(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,2))){
C_save_and_reclaim_args((void *)trf_4139,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4162,a[2]=t3,a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:802: random */
t5=*((C_word*)lf[172]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* symbolic-link? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2489(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2489,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2497,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:286: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2485 in regular-file? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2487,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[28],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* set-signal-mask! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6125,2,av);}
/* posixwin.scm:1571: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[376];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* regular-file? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2479,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2487,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:283: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* process* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,7))){
C_save_and_reclaim((void*)f_5658,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1324: %process */
f_5514(t1,lf[318],C_SCHEME_TRUE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1324: %process */
f_5514(t1,lf[318],C_SCHEME_TRUE,t2,t5,t9,t13);}}

/* set-group-id! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6101,2,av);}
/* posixwin.scm:1567: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[372];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-groups! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6107,2,av);}
/* posixwin.scm:1568: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[373];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5345 in k5332 in process-run in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_5347,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5351,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1251: ##sys#shell-command-arguments */
t4=*((C_word*)lf[309]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k4904 in k4895 in k4892 in set-buffering-mode! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4906(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_4906,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1145: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word av2[7];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[283];
av2[3]=lf[284];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k5317 in k5305 in shell-command in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5319,2,av);}
/* posixwin.scm:1241: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[305];
av2[3]=lf[306];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3002(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3002,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_nullp(((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=t6;
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=C_i_check_string_2(t2,lf[30]);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3017,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t11;
av2[2]=C_fix(256);
av2[3]=C_make_character(32);
tp(4,av2);}}

/* a6199 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6200,3,av);}
t3=C_i_check_exact_2(t2,lf[127]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_slot(*((C_word*)lf[126]+1),t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a6208 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1))){
C_save_and_reclaim((void*)f_6209,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[106]):C_SCHEME_UNDEFINED);
if(C_truep(t4)){
t6=C_umask(t4);
if(C_truep(t4)){
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t6=C_umask(C_fix(0));
if(C_truep(t4)){
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* ##sys#shell-command-arguments in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5324(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(6,c,1))){C_save_and_reclaim((void *)f_5324,3,av);}
a=C_alloc(6);
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,lf[310],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_3630,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3637,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:613: check-time-vector */
f_3476(t7,lf[119],t2);}

/* k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3637(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3637,2,av);}
a=C_alloc(9);
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[119]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3646,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3656,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:617: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[119];
tp(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3663,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3684,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:619: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_make_character(0);
tp(4,av2);}}}

/* check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4640(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_4640,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4658,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1030: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t4;
tp(4,av2);}}

/* ##sys#shell-command in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5303(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_5303,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5307,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1236: get-environment-variable */
t3=*((C_word*)lf[307]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[308];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k5305 in shell-command in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_5307,2,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_mpointer(&a,(void*)C_shlcmd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5319,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1240: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t2;
tp(2,av2);}}}}

/* k2409 in file-type in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2411(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2411,2,av);}
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[28];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[29];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[30];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[31];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[32];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[33];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=(C_truep(t3)?lf[34]:lf[28]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}}}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k5855 in k5849 in k5846 in k5843 in map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5857(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_5857,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_record3(&a,3,lf[337],((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5849 in k5846 in k5843 in map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
if(!C_demand(C_calculate_demand(21,c,2))){C_save_and_reclaim((void *)f_5851,2,av);}
a=C_alloc(21);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_truep(((C_word*)t0)[6])?C_i_foreign_pointer_argumentp(((C_word*)t0)[6]):C_SCHEME_FALSE);
t8=C_i_foreign_integer_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_integer_argumentp(((C_word*)t0)[7]);
t13=stub1445(t6,t7,t8,t9,t10,t11,t12);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5857,a[2]=((C_word*)t0)[8],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5863,a[2]=t15,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t14,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t14)){
t17=C_i_foreign_pointer_argumentp(t14);
t18=t16;
f_5863(t18,stub1457(C_SCHEME_UNDEFINED,t17));}
else{
t17=t16;
f_5863(t17,stub1457(C_SCHEME_UNDEFINED,C_SCHEME_FALSE));}}

/* a6233 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6234(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6234,3,av);}
t3=C_i_check_exact_2(t2,lf[106]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_umask(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scan in k3737 in loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3747(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(7,0,4))){
C_save_and_reclaim_args((void *)trf_3747,3,t0,t1,t2);}
a=C_alloc(7);
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3773,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:647: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[74]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
tp(5,av2);}}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posix-common.scm:650: scan */
t6=t1;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* loop in k3025 in k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3041(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_3041,2,t0,t1);}
a=C_alloc(6);
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_block_size(((C_word*)t0)[4]);
t4=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3055,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:484: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[74]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=t4;
tp(5,av2);}}}

/* k5143 in k5130 in k5127 in $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5145,2,av);}
/* posixwin.scm:1210: build-exec-argvec */
f_5074(((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5],C_fix(1));}

/* a6239 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6240(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_6240,3,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6244,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6256,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:331: port? */
t5=*((C_word*)lf[17]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k6245 in k6242 in a6239 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6247,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6242 in a6239 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_6244,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6247,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t2,C_fix(0)))){
/* posix-common.scm:340: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[10];
av2[3]=lf[49];
av2[4]=lf[396];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(!C_demand(C_calculate_demand(38,c,4))){C_save_and_reclaim((void *)f_3474,2,av);}
a=C_alloc(38);
t2=C_mutate2((C_word*)lf[106]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate2(&lf[107] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3476,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[109]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3495,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[112]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3516,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[113]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3547,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t7=C_fix((C_word)sizeof(struct tm));
t8=C_mutate2((C_word*)lf[115]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3585,a[2]=t7,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t9=C_fix((C_word)sizeof(struct tm));
t10=C_mutate2((C_word*)lf[119]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3630,a[2]=t9,a[3]=((C_word)li61),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate2((C_word*)lf[122]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3692,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[123]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3709,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[124]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3729,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[125]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3795,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3810,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6200,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:662: getter-with-setter */
t17=*((C_word*)lf[394]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=t16;
av2[3]=*((C_word*)lf[125]+1);
((C_proc)(void*)(*((C_word*)t17+1)))(4,av2);}}

/* check-time-vector in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3476(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,4))){
C_save_and_reclaim_args((void *)trf_3476,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:580: ##sys#error */
t6=*((C_word*)lf[54]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[108];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(!C_demand(C_calculate_demand(35,c,5))){C_save_and_reclaim((void *)f_5427,2,av);}
a=C_alloc(35);
t2=t1;
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=((*(int *)C_data_pointer(t3))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(1));
t6=((*(int *)C_data_pointer(t5))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t7=C_a_i_bytevector(&a,1,C_fix(1));
t8=((*(int *)C_data_pointer(t7))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t9=C_a_i_bytevector(&a,1,C_fix(1));
t10=((*(int *)C_data_pointer(t9))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t11=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5434,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t9,a[6]=((C_word*)t0)[4],a[7]=t5,a[8]=((C_word*)t0)[5],a[9]=t7,a[10]=((C_word*)t0)[6],a[11]=t2,tmp=(C_word)a,a+=12,tmp);
t12=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5471,a[2]=t11,a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[3],a[8]=t9,a[9]=t7,a[10]=t5,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1285: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[314]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t12;
av2[2]=t3;
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[315];
tp(6,av2);}}

/* ##sys#process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7=av[7];
C_word t8=av[8];
C_word t9;
C_word *a;
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(C_calculate_demand((c-9)*C_SIZEOF_PAIR +14,c,3))){
C_save_and_reclaim((void*)f_5420,c,av);}
a=C_alloc((c-9)*C_SIZEOF_PAIR+14);
t9=C_build_rest(&a,c,9,av);
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_FALSE:C_i_car(t9));
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5427,a[2]=t1,a[3]=t8,a[4]=t7,a[5]=t6,a[6]=t2,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5503,a[2]=t12,tmp=(C_word)a,a+=3,tmp);
t14=C_a_i_cons(&a,2,t3,t4);
/* posixwin.scm:1280: $quote-args-list */
f_4955(t13,t14,t11);}

/* process-run in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5330(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5330,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5334,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_5334(t6,C_u_i_car(t5));}
else{
t5=t4;
f_5334(t5,C_SCHEME_FALSE);}}

/* f_3469 in a3466 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3469(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3469,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5332 in process-run in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5334(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,4))){
C_save_and_reclaim_args((void *)trf_5334,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
/* posixwin.scm:1250: process-spawn */
t2=*((C_word*)lf[303]+1);{
C_word av2[5];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[291]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5347,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1251: ##sys#shell-command */
t3=*((C_word*)lf[305]+1);{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a3466 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_3467,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3469,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5432 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_5434,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5444,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[8])){
/* posixwin.scm:1290: open-input-file* */
t3=*((C_word*)lf[64]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[9])));
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_5444(2,av2);}}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5464,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1295: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t2;
tp(2,av2);}}}

/* f_3461 in a3458 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3461,4,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5846 in k5843 in map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5848(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_5848,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5851,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(((C_word*)t0)[6]))){
if(C_truep(C_specialp(((C_word*)t0)[6]))){
t4=t3;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5851(2,av2);}}
else{
/* posixwin.scm:1512: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[15];
av2[3]=lf[336];
av2[4]=lf[339];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixwin.scm:1512: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[15];
av2[3]=lf[336];
av2[4]=lf[339];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k5843 in map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5845(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_5845,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5848,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[7]))){
t4=((C_word*)t0)[7];
t5=t3;
f_5848(t5,C_u_i_car(t4));}
else{
t4=t3;
f_5848(t4,C_fix(0));}}

/* map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word *a;
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(C_calculate_demand((c-7)*C_SIZEOF_PAIR +8,c,2))){
C_save_and_reclaim((void*)f_5841,c,av);}
a=C_alloc((c-7)*C_SIZEOF_PAIR+8);
t7=C_build_rest(&a,c,7,av);
C_word t8;
C_word t9;
C_word t10;
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5845,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t1,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t2;
f_5845(2,av2);}}
else{
/* posixwin.scm:1509: ##sys#null-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[340]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[340]+1);
av2[1]=t8;
tp(2,av2);}}}

/* k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_3020,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3023,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:471: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[90]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[90]+1);
av2[1]=t3;
tp(2,av2);}}

/* k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_3023,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3027,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:474: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[30];
tp(4,av2);}}

/* $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5122(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,2))){
C_save_and_reclaim_args((void *)trf_5122,7,t0,t1,t2,t3,t4,t5,t6);}
a=C_alloc(11);
t7=C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5129,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=t5,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t4,a[10]=t6,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1208: pathname-strip-directory */
t9=*((C_word*)lf[299]+1);{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}

/* k3025 in k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3027(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,5))){C_save_and_reclaim((void *)f_3027,2,av);}
a=C_alloc(10);
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:476: posix-error */
t3=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=lf[30];
av2[4]=lf[89];
av2[5]=((C_word*)t0)[4];
f_2272(6,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3041,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li32),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3041(t6,((C_word*)t0)[3]);}}

/* k5127 in $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,4))){C_save_and_reclaim((void *)f_5129,2,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5132,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=C_block_size(t1);
/* posixwin.scm:1209: setarg */
t4=((C_word*)t0)[8];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=t1;
av2[4]=t3;
f_5032(5,av2);}}

/* a3452 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3453,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3455 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3456,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3458 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_3459,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3461,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3449 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3450(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3450,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-execute-access? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4672,3,av);}
/* posixwin.scm:1035: check */
f_4640(t1,t2,C_fix((C_word)2),lf[267]);}

/* k3208 in k3204 in g428 in k3192 in loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3210(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3210,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3216 in g428 in k3192 in loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3218(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3218,2,av);}
/* posix-common.scm:509: make-pathname */
t2=*((C_word*)lf[87]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-signal-handler! in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3795,4,av);}
t4=C_i_check_exact_2(t2,lf[125]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=C_i_vector_set(*((C_word*)lf[126]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[126]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k5130 in k5127 in $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,5))){C_save_and_reclaim((void *)f_5132,2,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5135,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5145,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[9])){
/* posixwin.scm:1210: $quote-args-list */
f_4955(t3,((C_word*)t0)[9],((C_word*)t0)[10]);}
else{
/* posixwin.scm:1210: build-exec-argvec */
f_5074(t2,((C_word*)t0)[4],C_SCHEME_FALSE,((C_word*)t0)[8],C_fix(1));}}

/* k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_3017,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3020,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:470: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[90]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[90]+1);
av2[1]=t3;
tp(2,av2);}}

/* k5133 in k5130 in k5127 in $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,5))){C_save_and_reclaim((void *)f_5135,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5138,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1211: build-exec-argvec */
f_5074(t2,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[7],C_fix(0));}

/* k3939 in k3930 in k3917 in file-open in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_3941,2,av);}
/* posixwin.scm:740: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[158];
av2[4]=lf[159];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}

/* k5136 in k5133 in k5130 in k5127 in $exec-setup in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5138(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5138,2,av);}
t2=C_flushall();
/* posixwin.scm:1213: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* file-write-access? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4666,3,av);}
/* posixwin.scm:1034: check */
f_4640(t1,t2,C_fix((C_word)4),lf[266]);}

/* file-read-access? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4660,3,av);}
/* posixwin.scm:1033: check */
f_4640(t1,t2,C_fix((C_word)2),lf[265]);}

/* k5861 in k5849 in k5846 in k5843 in map-file-to-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5863(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,10))){
C_save_and_reclaim_args((void *)trf_5863,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
/* posixwin.scm:1515: posix-error */
t2=lf[2];{
C_word av2[11];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[336];
av2[4]=lf[338];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
av2[8]=((C_word*)t0)[6];
av2[9]=((C_word*)t0)[7];
av2[10]=((C_word*)t0)[8];
f_2272(11,av2);}}
else{
t2=((C_word*)t0)[9];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_record3(&a,3,lf[337],((C_word*)t0)[10],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k3933 in k3930 in k3917 in file-open in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3935,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* unsetenv in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3709(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_3709,3,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[123]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3717,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:636: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[123];
tp(4,av2);}}

/* k5103 in doloop1154 in build-exec-argvec in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5105(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5105,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_5086(t5,((C_word*)t0)[5],t3,t4);}

/* k3705 in k3701 in setenv in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3707,2,av);}
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k3930 in k3917 in file-open in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,2))){C_save_and_reclaim((void *)f_3932,2,av);}
a=C_alloc(10);
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3935,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3941,a[2]=t3,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:739: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k3701 in setenv in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3703,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3707,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:631: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[122];
tp(4,av2);}}

/* k4656 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_4658,2,av);}
a=C_alloc(4);
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4650,a[2]=((C_word*)t0)[3],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posixwin.scm:1031: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}}

/* k4648 in k4656 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4650(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4650,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3771 in scan in k3737 in loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3773(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_3773,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3777,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t5=C_block_size(((C_word*)t0)[6]);
/* posix-common.scm:648: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[74]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
av2[4]=t5;
tp(5,av2);}}

/* k3775 in k3771 in scan in k3737 in loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_3777,2,av);}
a=C_alloc(7);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3765,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posix-common.scm:649: loop */
t6=((C_word*)((C_word*)t0)[5])[1];
f_3735(t6,t4,t5);}

/* current-process-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3812,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fudge(C_fix(33));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3810(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word t198;
C_word t199;
C_word t200;
C_word t201;
C_word t202;
C_word t203;
C_word t204;
C_word t205;
C_word t206;
C_word t207;
C_word t208;
C_word t209;
C_word t210;
C_word t211;
C_word t212;
C_word t213;
C_word t214;
C_word t215;
C_word t216;
C_word t217;
C_word t218;
C_word t219;
C_word t220;
C_word t221;
C_word t222;
C_word t223;
C_word t224;
C_word t225;
C_word *a;
if(!C_demand(C_calculate_demand(341,c,9))){C_save_and_reclaim((void *)f_3810,2,av);}
a=C_alloc(341);
t2=C_mutate2((C_word*)lf[127]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate2((C_word*)lf[128]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3812,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[129]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3818,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[133]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate2((C_word*)lf[134]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate2((C_word*)lf[135]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate2((C_word*)lf[136]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate2((C_word*)lf[137]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate2((C_word*)lf[138]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate2((C_word*)lf[139]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate2((C_word*)lf[140]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate2((C_word*)lf[141]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate2((C_word*)lf[142]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate2((C_word*)lf[143]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate2((C_word*)lf[144]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate2((C_word*)lf[145]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate2((C_word*)lf[146]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate2((C_word*)lf[147]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate2((C_word*)lf[148]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate2((C_word*)lf[149]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate2((C_word*)lf[150]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate2((C_word*)lf[151]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate2((C_word*)lf[152]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate2((C_word*)lf[153]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate2((C_word*)lf[154]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate2((C_word*)lf[155]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate2((C_word*)lf[156]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate2((C_word*)lf[157]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=t31;
t33=C_mutate2((C_word*)lf[158]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3915,a[2]=t32,a[3]=((C_word)li72),tmp=(C_word)a,a+=4,tmp));
t34=C_mutate2((C_word*)lf[160]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3950,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate2((C_word*)lf[163]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3981,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate2((C_word*)lf[166]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4025,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate2((C_word*)lf[169]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4065,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate2((C_word*)lf[73]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4225,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t39=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4265,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp);
t40=C_mutate2((C_word*)lf[181]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4283,a[2]=t39,a[3]=((C_word)li83),tmp=(C_word)a,a+=4,tmp));
t41=C_mutate2((C_word*)lf[185]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4323,a[2]=t39,a[3]=((C_word)li84),tmp=(C_word)a,a+=4,tmp));
t42=C_mutate2((C_word*)lf[186]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4363,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate2((C_word*)lf[188]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4381,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate2((C_word*)lf[190]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4399,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate2((C_word*)lf[191]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4423,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate2((C_word*)lf[192]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4447,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate2((C_word*)lf[194]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4481,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate2((C_word*)lf[196]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4515,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate2((C_word*)lf[198]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t50=C_mutate2((C_word*)lf[199]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t51=C_mutate2((C_word*)lf[200]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t52=C_mutate2((C_word*)lf[201]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t53=C_mutate2((C_word*)lf[202]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t54=C_mutate2((C_word*)lf[203]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t55=C_mutate2((C_word*)lf[204]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t56=C_set_block_item(lf[205] /* signal/alrm */,0,C_fix(0));
t57=C_set_block_item(lf[206] /* signal/chld */,0,C_fix(0));
t58=C_set_block_item(lf[207] /* signal/cont */,0,C_fix(0));
t59=C_set_block_item(lf[208] /* signal/hup */,0,C_fix(0));
t60=C_set_block_item(lf[209] /* signal/io */,0,C_fix(0));
t61=C_set_block_item(lf[210] /* signal/kill */,0,C_fix(0));
t62=C_set_block_item(lf[211] /* signal/pipe */,0,C_fix(0));
t63=C_set_block_item(lf[212] /* signal/prof */,0,C_fix(0));
t64=C_set_block_item(lf[213] /* signal/quit */,0,C_fix(0));
t65=C_set_block_item(lf[214] /* signal/stop */,0,C_fix(0));
t66=C_set_block_item(lf[215] /* signal/trap */,0,C_fix(0));
t67=C_set_block_item(lf[216] /* signal/tstp */,0,C_fix(0));
t68=C_set_block_item(lf[217] /* signal/urg */,0,C_fix(0));
t69=C_set_block_item(lf[218] /* signal/usr1 */,0,C_fix(0));
t70=C_set_block_item(lf[219] /* signal/usr2 */,0,C_fix(0));
t71=C_set_block_item(lf[220] /* signal/vtalrm */,0,C_fix(0));
t72=C_set_block_item(lf[221] /* signal/winch */,0,C_fix(0));
t73=C_set_block_item(lf[222] /* signal/xcpu */,0,C_fix(0));
t74=C_set_block_item(lf[223] /* signal/xfsz */,0,C_fix(0));
t75=C_a_i_list7(&a,7,*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1),*((C_word*)lf[201]+1),*((C_word*)lf[202]+1),*((C_word*)lf[203]+1),*((C_word*)lf[204]+1));
t76=C_mutate2((C_word*)lf[224]+1 /* (set! signals-list ...) */,t75);
t77=C_mutate2((C_word*)lf[225]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t78=C_mutate2((C_word*)lf[226]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t79=C_mutate2((C_word*)lf[227]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t80=C_mutate2((C_word*)lf[228]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t81=C_mutate2((C_word*)lf[229]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t82=C_mutate2((C_word*)lf[230]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t83=C_mutate2((C_word*)lf[231]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t84=C_mutate2((C_word*)lf[232]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t85=C_mutate2((C_word*)lf[233]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t86=C_mutate2((C_word*)lf[234]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t87=C_mutate2((C_word*)lf[235]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t88=C_mutate2((C_word*)lf[236]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t89=C_mutate2((C_word*)lf[237]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t90=C_mutate2((C_word*)lf[238]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t91=C_mutate2((C_word*)lf[239]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t92=C_mutate2((C_word*)lf[240]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t93=C_mutate2((C_word*)lf[241]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t94=C_mutate2((C_word*)lf[242]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t95=C_mutate2((C_word*)lf[243]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t96=C_mutate2((C_word*)lf[244]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t97=C_mutate2((C_word*)lf[245]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t98=C_mutate2((C_word*)lf[246]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t99=C_mutate2((C_word*)lf[247]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t100=C_mutate2((C_word*)lf[248]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t101=C_mutate2((C_word*)lf[249]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t102=C_mutate2((C_word*)lf[250]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t103=C_mutate2((C_word*)lf[251]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t104=C_mutate2((C_word*)lf[252]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t105=C_mutate2((C_word*)lf[253]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t106=C_mutate2((C_word*)lf[254]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t107=C_mutate2((C_word*)lf[255]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t108=C_mutate2((C_word*)lf[256]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t109=C_mutate2((C_word*)lf[257]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t110=C_mutate2((C_word*)lf[258]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t111=C_mutate2((C_word*)lf[259]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t112=C_mutate2((C_word*)lf[260]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t113=C_mutate2((C_word*)lf[261]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t114=C_mutate2((C_word*)lf[262]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t115=C_mutate2((C_word*)lf[263]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4614,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp));
t116=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4640,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp);
t117=C_mutate2((C_word*)lf[265]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4660,a[2]=t116,a[3]=((C_word)li106),tmp=(C_word)a,a+=4,tmp));
t118=C_mutate2((C_word*)lf[266]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4666,a[2]=t116,a[3]=((C_word)li107),tmp=(C_word)a,a+=4,tmp));
t119=C_mutate2((C_word*)lf[267]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4672,a[2]=t116,a[3]=((C_word)li108),tmp=(C_word)a,a+=4,tmp));
t120=C_mutate2((C_word*)lf[50]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t121=C_mutate2((C_word*)lf[51]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t122=C_mutate2((C_word*)lf[52]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t123=C_SCHEME_UNDEFINED;
t124=(*a=C_VECTOR_TYPE|1,a[1]=t123,tmp=(C_word)a,a+=2,tmp);
t125=C_SCHEME_UNDEFINED;
t126=(*a=C_VECTOR_TYPE|1,a[1]=t125,tmp=(C_word)a,a+=2,tmp);
t127=C_set_block_item(t124,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4681,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t128=C_set_block_item(t126,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4718,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate2((C_word*)lf[64]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4736,a[2]=t126,a[3]=t124,a[4]=((C_word)li111),tmp=(C_word)a,a+=5,tmp));
t130=C_mutate2((C_word*)lf[65]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4750,a[2]=t126,a[3]=t124,a[4]=((C_word)li112),tmp=(C_word)a,a+=5,tmp));
t131=C_mutate2((C_word*)lf[12]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4764,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate2((C_word*)lf[70]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4798,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate2((C_word*)lf[278]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4828,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate2((C_word*)lf[279]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4841,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate2((C_word*)lf[280]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4855,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate2((C_word*)lf[281]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4873,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate2((C_word*)lf[283]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4888,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate2((C_word*)lf[289]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t139=C_mutate2((C_word*)lf[290]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t140=C_mutate2((C_word*)lf[291]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t141=C_mutate2((C_word*)lf[292]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t142=C_mutate2((C_word*)lf[293]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t143=C_mutate2(&lf[294] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4955,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t144=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5032,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp);
t145=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5053,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp);
t146=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5074,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp);
t147=C_mutate2(&lf[298] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5122,a[2]=t146,a[3]=t145,a[4]=t144,a[5]=((C_word)li127),tmp=(C_word)a,a+=6,tmp));
t148=C_mutate2(&lf[300] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5154,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate2((C_word*)lf[301]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5169,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate2((C_word*)lf[303]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5236,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate2((C_word*)lf[305]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5303,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate2((C_word*)lf[309]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5324,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate2((C_word*)lf[311]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5330,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate2((C_word*)lf[312]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5420,a[2]=((C_word)li134),tmp=(C_word)a,a+=3,tmp));
t155=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5514,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp);
t156=C_mutate2((C_word*)lf[317]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5598,a[2]=t155,a[3]=((C_word)li141),tmp=(C_word)a,a+=4,tmp));
t157=C_mutate2((C_word*)lf[318]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5658,a[2]=t155,a[3]=((C_word)li142),tmp=(C_word)a,a+=4,tmp));
t158=C_mutate2((C_word*)lf[130]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5718,a[2]=((C_word)li143),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate2((C_word*)lf[319]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5730,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate2((C_word*)lf[320]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5736,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate2((C_word*)lf[322]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5748,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate2((C_word*)lf[325]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5779,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate2((C_word*)lf[327]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t164=C_mutate2((C_word*)lf[328]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t165=C_mutate2((C_word*)lf[329]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t166=C_mutate2((C_word*)lf[330]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t167=C_mutate2((C_word*)lf[331]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t168=C_mutate2((C_word*)lf[332]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t169=C_mutate2((C_word*)lf[333]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t170=C_mutate2((C_word*)lf[334]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t171=C_mutate2((C_word*)lf[335]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANONYMOUS));
t172=C_mutate2((C_word*)lf[336]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5841,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate2((C_word*)lf[341]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5897,a[2]=((C_word)li149),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate2((C_word*)lf[343]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5930,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate2((C_word*)lf[344]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5939,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate2((C_word*)lf[345]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5945,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate2((C_word*)lf[347]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5951,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate2((C_word*)lf[348]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5957,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate2((C_word*)lf[349]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5963,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate2((C_word*)lf[350]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5969,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate2((C_word*)lf[351]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5975,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate2((C_word*)lf[352]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5981,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate2((C_word*)lf[353]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5987,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate2((C_word*)lf[354]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5993,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate2((C_word*)lf[355]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5999,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate2((C_word*)lf[356]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6005,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate2((C_word*)lf[357]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6011,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t188=C_mutate2((C_word*)lf[358]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6017,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t189=C_mutate2((C_word*)lf[359]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6023,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t190=C_mutate2((C_word*)lf[360]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6029,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t191=C_mutate2((C_word*)lf[361]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6035,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t192=C_mutate2((C_word*)lf[362]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6041,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t193=C_mutate2((C_word*)lf[363]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6047,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t194=C_mutate2((C_word*)lf[364]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6053,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t195=C_mutate2((C_word*)lf[365]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6059,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t196=C_mutate2((C_word*)lf[366]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6065,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t197=C_mutate2((C_word*)lf[367]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6071,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t198=C_mutate2((C_word*)lf[368]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6077,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t199=C_mutate2((C_word*)lf[369]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6083,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t200=C_mutate2((C_word*)lf[370]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6089,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t201=C_mutate2((C_word*)lf[371]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6095,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t202=C_mutate2((C_word*)lf[372]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6101,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t203=C_mutate2((C_word*)lf[373]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6107,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t204=C_mutate2((C_word*)lf[374]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6113,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t205=C_mutate2((C_word*)lf[375]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6119,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t206=C_mutate2((C_word*)lf[376]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6125,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t207=C_mutate2((C_word*)lf[377]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6131,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t208=C_mutate2((C_word*)lf[378]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6137,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t209=C_mutate2((C_word*)lf[379]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6143,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t210=C_mutate2((C_word*)lf[380]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6149,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t211=C_mutate2((C_word*)lf[381]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6155,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t212=C_mutate2((C_word*)lf[382]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6161,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t213=C_mutate2((C_word*)lf[383]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6167,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t214=C_mutate2((C_word*)lf[384]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6173,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t215=C_mutate2((C_word*)lf[385]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6179,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t216=C_set_block_item(lf[386] /* errno/wouldblock */,0,C_fix(0));
t217=C_mutate2((C_word*)lf[39]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6186,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t218=C_set_block_item(lf[387] /* open/fsync */,0,C_fix(0));
t219=C_set_block_item(lf[388] /* open/noctty */,0,C_fix(0));
t220=C_set_block_item(lf[389] /* open/nonblock */,0,C_fix(0));
t221=C_set_block_item(lf[390] /* open/sync */,0,C_fix(0));
t222=C_set_block_item(lf[391] /* perm/isgid */,0,C_fix(0));
t223=C_set_block_item(lf[392] /* perm/isuid */,0,C_fix(0));
t224=C_set_block_item(lf[393] /* perm/isvtx */,0,C_fix(0));
t225=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t225;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t225+1)))(2,av2);}}

/* call-with-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_4399,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4403,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[181]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k4503 in a4500 in a4494 in k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4505(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4505,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a4500 in a4494 in k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_4501,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4505,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:911: close-output-pipe */
t4=*((C_word*)lf[188]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* process-wait in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +9,c,5))){
C_save_and_reclaim((void*)f_3818,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+9);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=t8;
t10=C_i_nullp(t6);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t12=(C_truep(t4)?t4:C_fix(-1));
t13=t12;
t14=C_i_check_exact_2(t13,lf[129]);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3842,a[2]=t13,a[3]=t9,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3848,a[2]=t13,a[3]=((C_word)li70),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:678: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t15;
av2[3]=t16;
C_call_with_values(4,av2);}}

/* k4389 in k4386 in close-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4391,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3763 in k3775 in k3771 in scan in k3737 in loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3765(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3765,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3992 in k3989 in file-read in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,2))){C_save_and_reclaim((void *)f_3994,2,av);}
a=C_alloc(11);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3997,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4006,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:762: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k3995 in k3992 in k3989 in file-read in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3997(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,1))){C_save_and_reclaim((void *)f_3997,2,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3989 in file-read in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,5))){C_save_and_reclaim((void *)f_3991,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3994,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t2))){
if(C_truep(C_byteblockp(t2))){
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_3994(2,av2);}}
else{
/* posixwin.scm:759: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[15];
av2[3]=lf[163];
av2[4]=lf[165];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixwin.scm:759: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[15];
av2[3]=lf[163];
av2[4]=lf[165];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k3497 in seconds->local-time in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3499,2,av);}
t2=C_i_check_number_2(t1,lf[109]);
/* posix-common.scm:584: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[110]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[110]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* seconds->local-time in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_3495,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3499,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:582: current-seconds */
t4=*((C_word*)lf[111]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[109]);
/* posix-common.scm:584: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[110]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[110]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}

/* k4520 in create-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4522(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_4522,2,av);}
/* posixwin.scm:925: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}

/* file-read in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,3))){
C_save_and_reclaim((void*)f_3981,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_exact_2(t2,lf[163]);
t6=C_i_check_exact_2(t3,lf[163]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3991,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=C_u_i_car(t8);
f_3991(2,av2);}}
else{
t8=t3;
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t7;
av2[2]=t8;
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* k3398 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3400,2,av);}
a=C_alloc(4);
t2=t1;
t3=((C_word*)t0)[2];
f_3254(t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3401,a[2]=t2,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp));}

/* f_3401 in k3398 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3401,3,av);}
/* posix-common.scm:527: irregex-match */
t3=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* f_3409 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3409,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3204 in g428 in k3192 in loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3206(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_3206,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3210,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:510: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_3177(t5,t3,t4);}

/* create-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_4515,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_fixnum_or(*((C_word*)lf[143]+1),*((C_word*)lf[145]+1)):C_i_car(t2));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4522,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=C_pipe(C_SCHEME_FALSE,t4);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4531,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:923: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t7;
tp(2,av2);}}
else{
/* posixwin.scm:925: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}}

/* a4509 in k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4510,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[195]+1));
t3=C_mutate2((C_word*)lf[195]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5787 in current-user-name in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5789(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5789,2,av);}
/* posixwin.scm:1366: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[325];
av2[3]=lf[326];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4352 in open-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4354(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4354,2,av);}
a=C_alloc(2);
t2=open_binary_output_pipe(&a,1,t1);
/* posixwin.scm:853: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k4687 in mode in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_4689,2,av);}
/* posixwin.scm:1051: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* mode in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4681(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_4681,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4689,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[53]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posixwin.scm:1055: ##sys#error */
t10=*((C_word*)lf[54]+1);{
C_word av2[4];
av2[0]=t10;
av2[1]=t5;
av2[2]=lf[268];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
/* posixwin.scm:1051: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[269];
av2[3]=t4;
tp(4,av2);}}}
else{
/* posixwin.scm:1056: ##sys#error */
t9=*((C_word*)lf[54]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t5;
av2[2]=lf[270];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}}
else{
if(C_truep(t2)){
/* posixwin.scm:1051: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[271];
av2[3]=t4;
tp(4,av2);}}
else{
/* posixwin.scm:1051: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[272];
av2[3]=t4;
tp(4,av2);}}}}

/* close-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4363,3,av);}
a=C_alloc(5);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_TRUE,C_SCHEME_TRUE,lf[186]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4370,a[2]=t1,a[3]=t5,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:863: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t6;
tp(2,av2);}}

/* k4386 in close-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4388,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4391,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:873: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[10];
av2[3]=lf[188];
av2[4]=lf[189];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* close-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4381,3,av);}
a=C_alloc(5);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[188]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4388,a[2]=t1,a[3]=t5,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:871: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t6;
tp(2,av2);}}

/* k5761 in k5757 in system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_5763,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5767,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_osver);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5765 in k5761 in k5757 in system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_5767,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5771,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_processor);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* unmap-file-from-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5897,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_check_structure_2(t2,lf[337],lf[341]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5904,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_5904(t7,C_u_i_car(t6));}
else{
t6=t5;
f_5904(t6,C_slot(t2,C_fix(2)));}}

/* k4371 in k4368 in close-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4373,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5772 in system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5774,2,av);}
/* posixwin.scm:1357: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[322];
av2[3]=lf[324];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3442(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(!C_demand(C_calculate_demand(17,c,2))){C_save_and_reclaim((void *)f_3442,2,av);}
a=C_alloc(17);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=t1;
t9=((C_word*)t0)[8];
t10=C_i_check_string_2(t3,lf[80]);
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3251,a[2]=t8,a[3]=t5,a[4]=t12,a[5]=t9,a[6]=t2,a[7]=t3,a[8]=t6,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3417,a[2]=t12,a[3]=t7,a[4]=((C_word)li45),tmp=(C_word)a,a+=5,tmp);
t15=t13;
f_3251(t15,t14);}
else{
t14=t13;
f_3251(t14,t7);}}
else{
t14=t13;
f_3251(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3409,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));}}

/* k4368 in close-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4370,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4373,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:865: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[10];
av2[3]=lf[186];
av2[4]=lf[187];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* current-user-name in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_5779,2,av);}
a=C_alloc(3);
if(C_truep(C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_mpointer(&a,(void*)C_username);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5789,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1365: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t2;
tp(2,av2);}}}

/* a3446 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3447,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5769 in k5765 in k5761 in k5757 in system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,1))){C_save_and_reclaim((void *)f_5771,2,av);}
a=C_alloc(15);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_list5(&a,5,lf[323],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,4))){C_save_and_reclaim((void *)f_3430,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3433,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3456,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t3;
av2[2]=lf[103];
av2[3]=((C_word*)t0)[5];
av2[4]=t4;
tp(5,av2);}}

/* system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_5748,2,av);}
a=C_alloc(6);
if(C_truep(C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5759,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_mpointer(&a,(void*)C_hostname);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5774,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1356: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t2;
tp(2,av2);}}}

/* k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_3439,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3442,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3447,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t3;
av2[2]=lf[82];
av2[3]=((C_word*)t0)[8];
av2[4]=t4;
tp(5,av2);}}

/* k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3436(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_3436,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3439,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3450,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t3;
av2[2]=lf[81];
av2[3]=((C_word*)t0)[7];
av2[4]=t4;
tp(5,av2);}}

/* k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3433(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,4))){C_save_and_reclaim((void *)f_3433,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3436,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3453,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t3;
av2[2]=lf[102];
av2[3]=((C_word*)t0)[6];
av2[4]=t4;
tp(5,av2);}}

/* k5757 in system-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_5759,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5763,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_osrel);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_3427,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3430,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3459,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t3;
av2[2]=lf[104];
av2[3]=((C_word*)t0)[4];
av2[4]=t4;
tp(5,av2);}}

/* find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,4))){
C_save_and_reclaim((void*)f_3423,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3427,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3467,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[101]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[101]+1);
av2[1]=t4;
av2[2]=lf[105];
av2[3]=t3;
av2[4]=t5;
tp(5,av2);}}

/* k6291 in a6282 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6293(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6293,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub120(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_3417 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3417,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a6276 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6277(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_6277,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6281,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:253: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* get-host-name in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_5736,2,av);}
a=C_alloc(3);
if(C_truep(C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_mpointer(&a,(void*)C_hostname);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}
else{
/* posixwin.scm:1346: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[320];
av2[3]=lf[321];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}}

/* process-spawn in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,6))){
C_save_and_reclaim((void*)f_5236,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=C_i_nullp(t4);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=t10;
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=C_i_nullp(t13);
t15=(C_truep(t14)?C_SCHEME_FALSE:C_i_car(t13));
t16=C_i_nullp(t13);
t17=(C_truep(t16)?C_SCHEME_END_OF_LIST:C_i_cdr(t13));
t18=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5258,a[2]=t11,a[3]=t2,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1229: $exec-setup */
t19=lf[298];
f_5122(t19,t18,lf[303],t3,t6,t11,t15);}

/* sleep in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5730(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5730,3,av);}
t3=C_i_check_exact_2(t2,lf[319]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_sleep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3236 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3238,2,av);}
/* posix-common.scm:503: ##sys#glob->regexp */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[95]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[95]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* file-close in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_3950,3,av);}
a=C_alloc(7);
t3=C_i_check_exact_2(t2,lf[160]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3959,a[2]=t2,a[3]=t5,a[4]=((C_word)li73),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t1;
f_3959(2,av2);}}

/* a6282 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_6283,4,av);}
a=C_alloc(9);
t4=C_i_check_number_2(t3,lf[399]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6303,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=t5;
t7=t2;
t8=t3;
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6293,a[2]=t6,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t7)){
t10=C_i_foreign_string_argumentp(t7);
/* posix-common.scm:256: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t9;
av2[2]=t10;
tp(3,av2);}}
else{
t10=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=stub120(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k6279 in a6276 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_6281,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_mtime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in file-close in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_3959,2,av);}
t2=C_close(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=C_fix((C_word)errno);
if(C_truep(C_i_eqvp(t3,C_fix((C_word)EINTR)))){
/* posixwin.scm:749: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[161]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[161]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* posixwin.scm:751: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[10];
av2[3]=lf[160];
av2[4]=lf[162];
av2[5]=((C_word*)t0)[2];
f_2272(6,av2);}}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6254 in a6239 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_6256,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[47]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
f_6244(2,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_fix(-1);
f_6244(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_6244(2,av2);}}
else{
/* posix-common.scm:338: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[15];
av2[3]=lf[49];
av2[4]=lf[397];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k4732 in k4720 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4734,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open-input-file* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_4736,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[64]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4748,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1070: mode */
f_4681(t5,C_SCHEME_TRUE,t3,lf[64]);}

/* k4720 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4722(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4722,2,av);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:1063: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=lf[273];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4734,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1064: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[61]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[61]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=*((C_word*)lf[62]+1);
av2[4]=lf[274];
av2[5]=lf[47];
tp(6,av2);}}}

/* k2682 */
static void C_ccall f_2684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_2684,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:380: check */
f_2643(((C_word*)t0)[4],lf[65],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* f_2686 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2686(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_2686,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[12]);
t5=C_slot(t2,C_fix(7));
t6=C_eqp(lf[34],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2702,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:390: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[66]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[66]+1);
av2[1]=t7;
av2[2]=t2;
tp(3,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2728,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:391: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[69]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[69]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}}

/* k5349 in k5345 in k5332 in process-run in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5351,2,av);}
/* posixwin.scm:1251: process-spawn */
t2=*((C_word*)lf[303]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[291]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k2668 */
static void C_ccall f_2670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_2670,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:376: check */
f_2643(((C_word*)t0)[4],lf[64],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* f_2672 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_2672,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[65]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2684,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:380: mode */
f_2606(t5,C_SCHEME_FALSE,t3,lf[65]);}

/* k5364 in k5360 in k5485 in k5481 in k5477 in k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5366,2,av);}
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_pointer_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[3])?C_i_foreign_pointer_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[4])?C_i_foreign_pointer_argumentp(((C_word*)t0)[4]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[5])?C_i_foreign_pointer_argumentp(((C_word*)t0)[5]):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[6]);
t7=((C_word*)t0)[7];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=stub1247(C_SCHEME_UNDEFINED,((C_word*)t0)[8],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k5360 in k5485 in k5481 in k5477 in k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_5362,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5366,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[8])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[8]);
/* posixwin.scm:1274: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_5366(2,av2);}}}

/* k5256 in process-spawn in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5258(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5258,2,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_spawnvpe(((C_word*)t0)[3],t1);
/* posixwin.scm:1230: $exec-teardown */
f_5154(((C_word*)t0)[4],lf[303],lf[304],((C_word*)t0)[5],t2);}
else{
t2=C_spawnvp(((C_word*)t0)[3],t1);
/* posixwin.scm:1230: $exec-teardown */
f_5154(((C_word*)t0)[4],lf[303],lf[304],((C_word*)t0)[5],t2);}}

/* f_2658 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_2658,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[64]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2670,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:376: mode */
f_2606(t5,C_SCHEME_TRUE,t3,lf[64]);}

/* k2654 in check in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2656,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* check in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2643(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,5))){
C_save_and_reclaim_args((void *)trf_2643,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:369: posix-error */
t6=lf[2];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[10];
av2[3]=t2;
av2[4]=lf[60];
av2[5]=t3;
f_2272(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2656,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:370: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[61]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[61]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[62]+1);
av2[4]=lf[63];
av2[5]=lf[47];
tp(6,av2);}}}

/* a4494 in k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4495,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4501,a[2]=((C_word*)t0)[2],a[3]=((C_word)li99),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:908: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a4489 in k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4490,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[195]+1));
t3=C_mutate2((C_word*)lf[195]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5189 in process-execute in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5191,2,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_execve(t1);
/* posixwin.scm:1225: $exec-teardown */
f_5154(((C_word*)t0)[3],lf[301],lf[302],((C_word*)t0)[4],t2);}
else{
t2=C_execvp(t1);
/* posixwin.scm:1225: $exec-teardown */
f_5154(((C_word*)t0)[3],lf[301],lf[302],((C_word*)t0)[4],t2);}}

/* k4483 in with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(19,c,4))){C_save_and_reclaim((void *)f_4485,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4490,a[2]=t6,a[3]=t4,a[4]=((C_word)li98),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4495,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li100),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4510,a[2]=t4,a[3]=t6,a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:905: ##sys#dynamic-wind */
t10=*((C_word*)lf[99]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* with-output-to-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_4481,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4485,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[185]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* process-execute in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5169(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,6))){
C_save_and_reclaim((void*)f_5169,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=t9;
t11=C_i_nullp(t7);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t13=C_i_nullp(t12);
t14=(C_truep(t13)?C_SCHEME_FALSE:C_i_car(t12));
t15=C_i_nullp(t12);
t16=(C_truep(t15)?C_SCHEME_END_OF_LIST:C_i_cdr(t12));
t17=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5191,a[2]=t10,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1224: $exec-setup */
t18=lf[298];
f_5122(t18,t17,lf[301],t2,t5,t10,t14);}

/* a4475 in k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4476(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4476,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[193]+1));
t3=C_mutate2((C_word*)lf[193]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k2914 in loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2916(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_2916,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2919,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2942,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:461: pathname-directory */
t4=*((C_word*)lf[85]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k4469 in a4466 in a4460 in k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4471,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a4466 in a4460 in k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_4467,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4471,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:901: close-input-pipe */
t4=*((C_word*)lf[186]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a4460 in k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4461,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4467,a[2]=((C_word*)t0)[2],a[3]=((C_word)li94),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:898: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* k2917 in k2914 in loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_2919,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2935,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:449: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[83];
tp(4,av2);}}

/* a4455 in k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4456,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[193]+1));
t3=C_mutate2((C_word*)lf[193]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k2933 in k2917 in k2914 in loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2935,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:450: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[83];
av2[4]=lf[84];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}}

/* k4449 in with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(19,c,4))){C_save_and_reclaim((void *)f_4451,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4456,a[2]=t6,a[3]=t4,a[4]=((C_word)li93),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4461,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li95),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4476,a[2]=t4,a[3]=t6,a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:895: ##sys#dynamic-wind */
t10=*((C_word*)lf[99]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_2907,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2909,a[2]=t3,a[3]=((C_word)li28),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2909(t5,((C_word*)t0)[2],t1);}

/* loop in k2905 in k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2909(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_2909,3,t0,t1,t2);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2916,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2949,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:460: directory? */
t5=*((C_word*)lf[41]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=t3;
f_2916(t4,C_SCHEME_FALSE);}}

/* k5156 in $exec-teardown in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5158,2,av);}
t2=C_free_exec_args();
t3=C_free_exec_env();
t4=C_eqp(((C_word*)t0)[2],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm:1220: ##sys#error */
t5=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
t5=((C_word*)t0)[2];
t6=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* $exec-teardown in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5154(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,2))){
C_save_and_reclaim_args((void *)trf_5154,5,t1,t2,t3,t4,t5);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5158,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:1216: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t6;
tp(2,av2);}}

/* with-input-from-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_4447,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4451,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[181]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k4440 in a4437 in k4425 in call-with-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4442(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4442,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a4431 in k4425 in call-with-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4432(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4432,2,av);}
/* posixwin.scm:889: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a4437 in k4425 in call-with-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4438(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_4438,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4442,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:891: close-output-pipe */
t4=*((C_word*)lf[188]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* call-with-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_4423,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4427,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[185]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k4425 in call-with-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_4427,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4432,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li90),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4438,a[2]=t2,a[3]=((C_word)li91),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:888: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* terminal-name in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6161,2,av);}
/* posixwin.scm:1577: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[382];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2726 */
static void C_ccall f_2728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_2728,2,av);}
a=C_alloc(4);
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:396: posix-error */
t2=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[15];
av2[3]=lf[12];
av2[4]=lf[67];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2711,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:394: posix-error */
t4=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[10];
av2[3]=lf[12];
av2[4]=lf[68];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* user-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6167,2,av);}
/* posixwin.scm:1578: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[383];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3075 in k3065 in k3053 in loop in k3025 in k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3077,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3065 in k3053 in loop in k3025 in k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3067(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_3067,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
/* posix-common.scm:491: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3041(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3077,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:492: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3041(t3,t2);}}

/* k2709 in k2726 */
static void C_ccall f_2711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2711,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4312 in open-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4314(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4314,2,av);}
a=C_alloc(2);
t2=open_binary_input_pipe(&a,1,t1);
/* posixwin.scm:843: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k3053 in loop in k3025 in k3021 in k3018 in k3015 in k3000 in directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3055(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_3055,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_string_ref(t2,C_fix(0));
t4=C_fixnum_greaterp(((C_word*)t0)[2],C_fix(1));
t5=(C_truep(t4)?C_i_string_ref(t2,C_fix(1)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3067,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=C_eqp(C_make_character(46),t3);
if(C_truep(t7)){
t8=C_i_not(t5);
if(C_truep(t8)){
t9=t6;
f_3067(t9,t8);}
else{
t9=C_eqp(C_make_character(46),t5);
if(C_truep(t9)){
t10=C_eqp(C_fix(2),((C_word*)t0)[2]);
t11=t6;
f_3067(t11,(C_truep(t10)?t10:C_i_not(((C_word*)t0)[5])));}
else{
t10=t6;
f_3067(t10,C_i_not(((C_word*)t0)[5]));}}}
else{
t8=t6;
f_3067(t8,C_SCHEME_FALSE);}}

/* k4342 in open-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4344,2,av);}
a=C_alloc(2);
t2=open_text_output_pipe(&a,1,t1);
/* posixwin.scm:853: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* f_2734 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_2734,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_check_exact_2(t2,*((C_word*)lf[70]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2741,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_2741(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[70]);
t8=t5;
f_2741(t8,C_dup2(t2,t6));}}

/* k4335 in open-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4337(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4337,2,av);}
/* posixwin.scm:853: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* k2839 in k2833 in g293 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2841,2,av);}
if(C_truep(t1)){
/* posix-common.scm:439: g303 */
f_2801(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[79]+1);
t3=*((C_word*)lf[79]+1);
/* posix-common.scm:439: g303 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[79]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[79]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}}

/* k2842 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2844(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2844,2,av);}
/* posix-common.scm:445: rmdir */
f_2801(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* for-each-loop292 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2849(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_2849,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2859,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:434: g293 */
t5=((C_word*)t0)[3];
f_2825(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k4302 in open-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4304(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4304,2,av);}
a=C_alloc(2);
t2=open_text_input_pipe(&a,1,t1);
/* posixwin.scm:843: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k5555 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_5557,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5560,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1314: chkstrlst */
t3=((C_word*)t0)[9];
f_5516(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_5560(2,av2);}}}

/* k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,2))){C_save_and_reclaim((void *)f_3276,2,av);}
a=C_alloc(15);
t2=t1;
t3=C_slot(((C_word*)t0)[2],C_fix(1));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_3285,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posix-common.scm:536: directory? */
t6=*((C_word*)lf[41]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* open-output-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4323(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3))){
C_save_and_reclaim((void*)f_4323,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[185]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[182]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4337,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[182]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4344,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:856: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[185];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[183]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4354,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:857: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[185];
tp(4,av2);}}
else{
/* posixwin.scm:831: ##sys#error */
t10=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[184];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k2857 in for-each-loop292 in k2822 in delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2859,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2849(t3,((C_word*)t0)[4],t2);}

/* k5501 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5503(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5503,2,av);}
/* posixwin.scm:1280: string-intersperse */
t2=*((C_word*)lf[316]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* file-unlock in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6041,2,av);}
/* posixwin.scm:1557: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[362];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* get-groups in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6047,2,av);}
/* posixwin.scm:1558: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[363];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* a4413 in k4401 in call-with-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4414(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_4414,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4418,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:882: close-input-pipe */
t4=*((C_word*)lf[186]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3254(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,3))){
C_save_and_reclaim_args((void *)trf_3254,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3261,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:529: directory */
t4=*((C_word*)lf[30]+1);{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3251(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(13,0,2))){
C_save_and_reclaim_args((void *)trf_3251,2,t0,t1);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3254,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_closurep(((C_word*)t0)[9]))){
t4=t3;
f_3254(t4,((C_word*)t0)[9]);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3400,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:526: irregex */
t5=*((C_word*)lf[100]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[9];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}

/* k4416 in a4413 in k4401 in call-with-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4418,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2881(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,2))){
C_save_and_reclaim((void*)f_2881,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[83]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2891,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t9=C_block_size(t2);
t10=C_eqp(C_fix(0),t9);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2897,a[2]=t1,a[3]=t2,a[4]=t6,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t10)){
t12=t11;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t12;
av2[1]=t10;
f_2897(2,av2);}}
else{
/* posix-common.scm:456: file-exists? */
t12=*((C_word*)lf[88]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t12;
av2[1]=t11;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t12+1)))(3,av2);}}}

/* chkstrlst in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5516(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_5516,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5521,a[2]=((C_word*)t0)[2],a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5530,a[2]=t4,a[3]=((C_word)li136),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=f_5530(t6,t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5514(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(!C_demand(C_calculate_demand(25,0,3))){
C_save_and_reclaim_args((void *)trf_5514,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(25);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5516,a[2]=t2,a[3]=((C_word)li137),tmp=(C_word)a,a+=4,tmp);
t12=C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5557,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t10,a[8]=t1,a[9]=t11,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm:1309: chkstrlst */
t14=t11;
f_5516(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5592,a[2]=t9,a[3]=t8,a[4]=t13,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1312: ##sys#shell-command-arguments */
t16=*((C_word*)lf[309]+1);{
C_word av2[3];
av2[0]=t16;
av2[1]=t15;
av2[2]=((C_word*)t8)[1];
((C_proc)(void*)(*((C_word*)t16+1)))(3,av2);}}}

/* k4401 in call-with-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_4403,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4408,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li87),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4414,a[2]=t2,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:879: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3285(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,4))){C_save_and_reclaim((void *)f_3285,2,av);}
a=C_alloc(14);
if(C_truep(t1)){
if(C_truep((C_truep(C_i_equalp(((C_word*)t0)[2],lf[97]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(((C_word*)t0)[2],lf[98]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:537: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3263(t2,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3375,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:538: symbolic-link? */
t3=*((C_word*)lf[36]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}
else{
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3384,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:548: pproc */
t3=((C_word*)t0)[11];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* a4407 in k4401 in call-with-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4408,2,av);}
/* posixwin.scm:880: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a5564 in k5558 in k5555 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5565(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,9))){C_save_and_reclaim((void *)f_5565,2,av);}
/* posixwin.scm:1315: ##sys#process */
t2=*((C_word*)lf[312]+1);{
C_word *av2;
if(c >= 10) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(10);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
av2[4]=((C_word*)((C_word*)t0)[4])[1];
av2[5]=((C_word*)t0)[5];
av2[6]=C_SCHEME_TRUE;
av2[7]=C_SCHEME_TRUE;
av2[8]=((C_word*)t0)[6];
av2[9]=((C_word*)((C_word*)t0)[7])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(10,av2);}}

/* file-select in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6023,2,av);}
/* posixwin.scm:1554: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[359];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* file-test-lock in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6029(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6029,2,av);}
/* posixwin.scm:1555: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[360];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5558 in k5555 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5560(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,6))){C_save_and_reclaim((void *)f_5560,2,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5565,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li138),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5571,a[2]=((C_word*)t0)[6],a[3]=((C_word)li139),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1315: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[8];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* file-truncate in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6035(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6035,2,av);}
/* posixwin.scm:1556: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[361];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2545 in directory? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2547,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[30],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a5570 in k5558 in k5555 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5571(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5571,6,av);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm:1317: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
av2[5]=t5;
C_values(6,av2);}}
else{
/* posixwin.scm:1318: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}}

/* loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3263(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(14,0,3))){
C_save_and_reclaim_args((void *)trf_3263,5,t0,t1,t2,t3,t4);}
a=C_alloc(14);
if(C_truep(C_i_nullp(t3))){
t5=t4;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_slot(t3,C_fix(0));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3276,a[2]=t3,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t2,a[7]=t4,a[8]=((C_word*)t0)[3],a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=((C_word*)t0)[7],a[13]=((C_word*)t0)[8],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:534: make-pathname */
t8=*((C_word*)lf[87]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}}

/* k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3261(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,5))){C_save_and_reclaim((void *)f_3261,2,av);}
a=C_alloc(12);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3263,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li43),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3263(t5,((C_word*)t0)[8],((C_word*)t0)[9],t1,((C_word*)t0)[10]);}

/* k2889 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2891,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2895 in create-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,5))){C_save_and_reclaim((void *)f_2897,2,av);}
a=C_alloc(10);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
if(C_truep(((C_word*)t0)[4])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2907,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2951,a[2]=((C_word*)t0)[3],a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2957,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:458: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t2=((C_word*)t0)[5];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2980,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:449: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[83];
tp(4,av2);}}}}

/* directory? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2539,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2547,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:301: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2535 in socket? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2537(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2537,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[34],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-link in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6005,2,av);}
/* posixwin.scm:1551: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[356];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-file-position! in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2552(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_2552,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2556,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_2556(t7,C_u_i_car(t6));}
else{
t6=t5;
f_2556(t6,C_fix((C_word)SEEK_SET));}}

/* file-lock in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6011(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6011,2,av);}
/* posixwin.scm:1552: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[357];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* file-lock/blocking in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6017,2,av);}
/* posixwin.scm:1553: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[358];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2566 in k2554 in set-file-position! in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2568(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_2568,2,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posix-common.scm:326: posix-error */
t2=lf[2];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[45];
av2[4]=lf[46];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2272(7,av2);}}}

/* k2554 in set-file-position! in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2556(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,2))){
C_save_and_reclaim_args((void *)trf_2556,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[45]);
t4=C_i_check_exact_2(t2,lf[45]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2568,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2574,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:319: port? */
t7=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k2249 in k2246 */
static void C_ccall f_2251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2251,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2254,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_extras_toplevel(2,av2);}}

/* k2572 in k2554 in set-file-position! in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2574(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2574,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[47]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
f_2568(2,av2);}}
else{
t4=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_2568(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2568(2,av2);}}
else{
/* posix-common.scm:325: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[15];
av2[3]=lf[45];
av2[4]=lf[48];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2257(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2257,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2260,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_ports_toplevel(2,av2);}}

/* k2252 in k2249 in k2246 */
static void C_ccall f_2254(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2254,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2257,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_files_toplevel(2,av2);}}

/* k2246 */
static void C_ccall f_2248(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2248,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2251,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_irregex_toplevel(2,av2);}}

/* k4628 in k4636 in change-file-mode in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_4630,2,av);}
/* posixwin.scm:1021: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[263];
av2[4]=lf[264];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k4636 in change-file-mode in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4638,2,av);}
a=C_alloc(5);
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4630,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1020: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t3;
tp(2,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* loop in $quote-args-list in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4998(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(14,0,4))){
C_save_and_reclaim_args((void *)trf_4998,4,t0,t1,t2,t3);}
a=C_alloc(14);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1180: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[295]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[295]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5024,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
t8=t4;
t9=C_i_string_length(t8);
t10=t9;
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4969,a[2]=t10,a[3]=t8,a[4]=((C_word)li120),tmp=(C_word)a,a+=5,tmp);
t12=f_4969(t11,C_fix(0));
if(C_truep(t12)){
/* posixwin.scm:1185: string-append */
t13=*((C_word*)lf[4]+1);{
C_word av2[5];
av2[0]=t13;
av2[1]=t7;
av2[2]=lf[296];
av2[3]=t4;
av2[4]=lf[297];
((C_proc)(void*)(*((C_word*)t13+1)))(5,av2);}}
else{
t13=C_a_i_cons(&a,2,t4,t3);
/* posixwin.scm:1182: loop */
t15=t1;
t16=t6;
t17=t13;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}}

/* process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,7))){
C_save_and_reclaim((void*)f_5598,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1321: %process */
f_5514(t1,lf[317],C_SCHEME_FALSE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1321: %process */
f_5514(t1,lf[317],C_SCHEME_FALSE,t2,t5,t9,t13);}}

/* k5594 in k5590 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5596(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5596,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_5557(2,av2);}}

/* k5590 in %process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_5592,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5596,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1313: ##sys#shell-command */
t4=*((C_word*)lf[305]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_posix_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(!C_demand(C_calculate_demand(3,c,2))){
C_save_and_reclaim((void*)C_posix_toplevel,c,av);}
toplevel_initialized=1;
if(!C_demand_2(2181)){
C_save(t1);
C_rereclaim2(2181*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,402);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_h_intern(&lf[3],15,"\003syssignal-hook");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[10]=C_h_intern(&lf[10],11,"\000file-error");
lf[11]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[12]=C_h_intern(&lf[12],12,"port->fileno");
lf[13]=C_h_intern(&lf[13],17,"\003sysmake-c-string");
lf[14]=C_h_intern(&lf[14],27,"\003sysplatform-fixup-pathname");
lf[15]=C_h_intern(&lf[15],11,"\000type-error");
lf[16]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[17]=C_h_intern(&lf[17],5,"port\077");
lf[18]=C_h_intern(&lf[18],9,"file-stat");
lf[19]=C_h_intern(&lf[19],16,"_stat_st_blksize");
lf[20]=C_h_intern(&lf[20],15,"_stat_st_blocks");
lf[21]=C_h_intern(&lf[21],22,"file-modification-time");
lf[22]=C_h_intern(&lf[22],16,"file-access-time");
lf[23]=C_h_intern(&lf[23],16,"file-change-time");
lf[24]=C_h_intern(&lf[24],10,"file-owner");
lf[25]=C_h_intern(&lf[25],16,"file-permissions");
lf[26]=C_h_intern(&lf[26],9,"file-size");
lf[27]=C_h_intern(&lf[27],9,"file-type");
lf[28]=C_h_intern(&lf[28],12,"regular-file");
lf[29]=C_h_intern(&lf[29],13,"symbolic-link");
lf[30]=C_h_intern(&lf[30],9,"directory");
lf[31]=C_h_intern(&lf[31],16,"character-device");
lf[32]=C_h_intern(&lf[32],12,"block-device");
lf[33]=C_h_intern(&lf[33],4,"fifo");
lf[34]=C_h_intern(&lf[34],6,"socket");
lf[35]=C_h_intern(&lf[35],13,"regular-file\077");
lf[36]=C_h_intern(&lf[36],14,"symbolic-link\077");
lf[37]=C_h_intern(&lf[37],13,"block-device\077");
lf[38]=C_h_intern(&lf[38],17,"character-device\077");
lf[39]=C_h_intern(&lf[39],5,"fifo\077");
lf[40]=C_h_intern(&lf[40],7,"socket\077");
lf[41]=C_h_intern(&lf[41],10,"directory\077");
lf[42]=C_h_intern(&lf[42],8,"seek/set");
lf[43]=C_h_intern(&lf[43],8,"seek/end");
lf[44]=C_h_intern(&lf[44],8,"seek/cur");
lf[45]=C_h_intern(&lf[45],18,"set-file-position!");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[47]=C_h_intern(&lf[47],6,"stream");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[49]=C_h_intern(&lf[49],13,"file-position");
lf[50]=C_h_intern(&lf[50],12,"fileno/stdin");
lf[51]=C_h_intern(&lf[51],13,"fileno/stdout");
lf[52]=C_h_intern(&lf[52],13,"fileno/stderr");
lf[53]=C_h_intern(&lf[53],7,"\000append");
lf[54]=C_h_intern(&lf[54],9,"\003syserror");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[57]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[61]=C_h_intern(&lf[61],13,"\003sysmake-port");
lf[62]=C_h_intern(&lf[62],21,"\003sysstream-port-class");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[64]=C_h_intern(&lf[64],16,"open-input-file\052");
lf[65]=C_h_intern(&lf[65],17,"open-output-file\052");
lf[66]=C_h_intern(&lf[66],13,"\003sysport-data");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[69]=C_h_intern(&lf[69],25,"\003syspeek-unsigned-integer");
lf[70]=C_h_intern(&lf[70],16,"duplicate-fileno");
lf[71]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[72]=C_h_intern(&lf[72],17,"current-directory");
lf[73]=C_h_intern(&lf[73],16,"change-directory");
lf[74]=C_h_intern(&lf[74],13,"\003syssubstring");
lf[75]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[76]=C_h_intern(&lf[76],15,"\003sysmake-string");
lf[77]=C_h_intern(&lf[77],16,"delete-directory");
lf[78]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[79]=C_h_intern(&lf[79],11,"delete-file");
lf[80]=C_h_intern(&lf[80],10,"find-files");
lf[81]=C_h_intern(&lf[81],9,"\000dotfiles");
lf[82]=C_h_intern(&lf[82],16,"\000follow-symlinks");
lf[83]=C_h_intern(&lf[83],16,"create-directory");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[85]=C_h_intern(&lf[85],18,"pathname-directory");
lf[86]=C_h_intern(&lf[86],18,"decompose-pathname");
lf[87]=C_h_intern(&lf[87],13,"make-pathname");
lf[88]=C_h_intern(&lf[88],12,"file-exists\077");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[90]=C_h_intern(&lf[90],16,"\003sysmake-pointer");
lf[91]=C_h_intern(&lf[91],4,"glob");
lf[92]=C_h_intern(&lf[92],23,"irregex-match-substring");
lf[93]=C_h_intern(&lf[93],13,"irregex-match");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[95]=C_h_intern(&lf[95],16,"\003sysglob->regexp");
lf[96]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[97]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[98]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[99]=C_h_intern(&lf[99],16,"\003sysdynamic-wind");
lf[100]=C_h_intern(&lf[100],7,"irregex");
lf[101]=C_h_intern(&lf[101],15,"\003sysget-keyword");
lf[102]=C_h_intern(&lf[102],6,"\000limit");
lf[103]=C_h_intern(&lf[103],5,"\000seed");
lf[104]=C_h_intern(&lf[104],7,"\000action");
lf[105]=C_h_intern(&lf[105],5,"\000test");
lf[106]=C_h_intern(&lf[106],18,"file-creation-mode");
lf[108]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[109]=C_h_intern(&lf[109],19,"seconds->local-time");
lf[110]=C_h_intern(&lf[110],18,"\003sysdecode-seconds");
lf[111]=C_h_intern(&lf[111],15,"current-seconds");
lf[112]=C_h_intern(&lf[112],17,"seconds->utc-time");
lf[113]=C_h_intern(&lf[113],15,"seconds->string");
lf[114]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[115]=C_h_intern(&lf[115],19,"local-time->seconds");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[117]=C_h_intern(&lf[117],3,"fp=");
lf[118]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[119]=C_h_intern(&lf[119],12,"time->string");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[122]=C_h_intern(&lf[122],6,"setenv");
lf[123]=C_h_intern(&lf[123],8,"unsetenv");
lf[124]=C_h_intern(&lf[124],25,"get-environment-variables");
lf[125]=C_h_intern(&lf[125],19,"set-signal-handler!");
lf[126]=C_h_intern(&lf[126],17,"\003syssignal-vector");
lf[127]=C_h_intern(&lf[127],14,"signal-handler");
lf[128]=C_h_intern(&lf[128],18,"current-process-id");
lf[129]=C_h_intern(&lf[129],12,"process-wait");
lf[130]=C_h_intern(&lf[130],16,"\003sysprocess-wait");
lf[131]=C_h_intern(&lf[131],14,"\000process-error");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[133]=C_h_intern(&lf[133],8,"pipe/buf");
lf[134]=C_h_intern(&lf[134],11,"open/rdonly");
lf[135]=C_h_intern(&lf[135],11,"open/wronly");
lf[136]=C_h_intern(&lf[136],9,"open/rdwr");
lf[137]=C_h_intern(&lf[137],9,"open/read");
lf[138]=C_h_intern(&lf[138],10,"open/write");
lf[139]=C_h_intern(&lf[139],10,"open/creat");
lf[140]=C_h_intern(&lf[140],11,"open/append");
lf[141]=C_h_intern(&lf[141],9,"open/excl");
lf[142]=C_h_intern(&lf[142],10,"open/trunc");
lf[143]=C_h_intern(&lf[143],11,"open/binary");
lf[144]=C_h_intern(&lf[144],9,"open/text");
lf[145]=C_h_intern(&lf[145],14,"open/noinherit");
lf[146]=C_h_intern(&lf[146],10,"perm/irusr");
lf[147]=C_h_intern(&lf[147],10,"perm/iwusr");
lf[148]=C_h_intern(&lf[148],10,"perm/ixusr");
lf[149]=C_h_intern(&lf[149],10,"perm/irgrp");
lf[150]=C_h_intern(&lf[150],10,"perm/iwgrp");
lf[151]=C_h_intern(&lf[151],10,"perm/ixgrp");
lf[152]=C_h_intern(&lf[152],10,"perm/iroth");
lf[153]=C_h_intern(&lf[153],10,"perm/iwoth");
lf[154]=C_h_intern(&lf[154],10,"perm/ixoth");
lf[155]=C_h_intern(&lf[155],10,"perm/irwxu");
lf[156]=C_h_intern(&lf[156],10,"perm/irwxg");
lf[157]=C_h_intern(&lf[157],10,"perm/irwxo");
lf[158]=C_h_intern(&lf[158],9,"file-open");
lf[159]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[160]=C_h_intern(&lf[160],10,"file-close");
lf[161]=C_h_intern(&lf[161],22,"\003sysdispatch-interrupt");
lf[162]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[163]=C_h_intern(&lf[163],9,"file-read");
lf[164]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[165]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[166]=C_h_intern(&lf[166],10,"file-write");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[168]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[169]=C_h_intern(&lf[169],12,"file-mkstemp");
lf[170]=C_decode_literal(C_heaptop,"\376B\000\000$0123456789abcdefghijklmnopqrstuvwxyz");
lf[171]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[172]=C_h_intern(&lf[172],6,"random");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000\020invalid template");
lf[174]=C_decode_literal(C_heaptop,"\376B\000\000\026non-existent directory");
lf[175]=C_h_intern(&lf[175],17,"directory-exists\077");
lf[176]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[177]=C_h_intern(&lf[177],11,"string-copy");
lf[178]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[179]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[180]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[181]=C_h_intern(&lf[181],15,"open-input-pipe");
lf[182]=C_h_intern(&lf[182],5,"\000text");
lf[183]=C_h_intern(&lf[183],7,"\000binary");
lf[184]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[185]=C_h_intern(&lf[185],16,"open-output-pipe");
lf[186]=C_h_intern(&lf[186],16,"close-input-pipe");
lf[187]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[188]=C_h_intern(&lf[188],17,"close-output-pipe");
lf[189]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[190]=C_h_intern(&lf[190],20,"call-with-input-pipe");
lf[191]=C_h_intern(&lf[191],21,"call-with-output-pipe");
lf[192]=C_h_intern(&lf[192],20,"with-input-from-pipe");
lf[193]=C_h_intern(&lf[193],18,"\003sysstandard-input");
lf[194]=C_h_intern(&lf[194],19,"with-output-to-pipe");
lf[195]=C_h_intern(&lf[195],19,"\003sysstandard-output");
lf[196]=C_h_intern(&lf[196],11,"create-pipe");
lf[197]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[198]=C_h_intern(&lf[198],11,"signal/term");
lf[199]=C_h_intern(&lf[199],10,"signal/int");
lf[200]=C_h_intern(&lf[200],10,"signal/fpe");
lf[201]=C_h_intern(&lf[201],10,"signal/ill");
lf[202]=C_h_intern(&lf[202],11,"signal/segv");
lf[203]=C_h_intern(&lf[203],11,"signal/abrt");
lf[204]=C_h_intern(&lf[204],12,"signal/break");
lf[205]=C_h_intern(&lf[205],11,"signal/alrm");
lf[206]=C_h_intern(&lf[206],11,"signal/chld");
lf[207]=C_h_intern(&lf[207],11,"signal/cont");
lf[208]=C_h_intern(&lf[208],10,"signal/hup");
lf[209]=C_h_intern(&lf[209],9,"signal/io");
lf[210]=C_h_intern(&lf[210],11,"signal/kill");
lf[211]=C_h_intern(&lf[211],11,"signal/pipe");
lf[212]=C_h_intern(&lf[212],11,"signal/prof");
lf[213]=C_h_intern(&lf[213],11,"signal/quit");
lf[214]=C_h_intern(&lf[214],11,"signal/stop");
lf[215]=C_h_intern(&lf[215],11,"signal/trap");
lf[216]=C_h_intern(&lf[216],11,"signal/tstp");
lf[217]=C_h_intern(&lf[217],10,"signal/urg");
lf[218]=C_h_intern(&lf[218],11,"signal/usr1");
lf[219]=C_h_intern(&lf[219],11,"signal/usr2");
lf[220]=C_h_intern(&lf[220],13,"signal/vtalrm");
lf[221]=C_h_intern(&lf[221],12,"signal/winch");
lf[222]=C_h_intern(&lf[222],11,"signal/xcpu");
lf[223]=C_h_intern(&lf[223],11,"signal/xfsz");
lf[224]=C_h_intern(&lf[224],12,"signals-list");
lf[225]=C_h_intern(&lf[225],10,"errno/perm");
lf[226]=C_h_intern(&lf[226],11,"errno/noent");
lf[227]=C_h_intern(&lf[227],10,"errno/srch");
lf[228]=C_h_intern(&lf[228],10,"errno/intr");
lf[229]=C_h_intern(&lf[229],8,"errno/io");
lf[230]=C_h_intern(&lf[230],12,"errno/noexec");
lf[231]=C_h_intern(&lf[231],10,"errno/badf");
lf[232]=C_h_intern(&lf[232],11,"errno/child");
lf[233]=C_h_intern(&lf[233],11,"errno/nomem");
lf[234]=C_h_intern(&lf[234],11,"errno/acces");
lf[235]=C_h_intern(&lf[235],11,"errno/fault");
lf[236]=C_h_intern(&lf[236],10,"errno/busy");
lf[237]=C_h_intern(&lf[237],11,"errno/exist");
lf[238]=C_h_intern(&lf[238],12,"errno/notdir");
lf[239]=C_h_intern(&lf[239],11,"errno/isdir");
lf[240]=C_h_intern(&lf[240],11,"errno/inval");
lf[241]=C_h_intern(&lf[241],11,"errno/mfile");
lf[242]=C_h_intern(&lf[242],11,"errno/nospc");
lf[243]=C_h_intern(&lf[243],11,"errno/spipe");
lf[244]=C_h_intern(&lf[244],10,"errno/pipe");
lf[245]=C_h_intern(&lf[245],11,"errno/again");
lf[246]=C_h_intern(&lf[246],10,"errno/rofs");
lf[247]=C_h_intern(&lf[247],10,"errno/nxio");
lf[248]=C_h_intern(&lf[248],10,"errno/2big");
lf[249]=C_h_intern(&lf[249],10,"errno/xdev");
lf[250]=C_h_intern(&lf[250],11,"errno/nodev");
lf[251]=C_h_intern(&lf[251],11,"errno/nfile");
lf[252]=C_h_intern(&lf[252],11,"errno/notty");
lf[253]=C_h_intern(&lf[253],10,"errno/fbig");
lf[254]=C_h_intern(&lf[254],11,"errno/mlink");
lf[255]=C_h_intern(&lf[255],9,"errno/dom");
lf[256]=C_h_intern(&lf[256],11,"errno/range");
lf[257]=C_h_intern(&lf[257],12,"errno/deadlk");
lf[258]=C_h_intern(&lf[258],17,"errno/nametoolong");
lf[259]=C_h_intern(&lf[259],11,"errno/nolck");
lf[260]=C_h_intern(&lf[260],11,"errno/nosys");
lf[261]=C_h_intern(&lf[261],14,"errno/notempty");
lf[262]=C_h_intern(&lf[262],11,"errno/ilseq");
lf[263]=C_h_intern(&lf[263],16,"change-file-mode");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[265]=C_h_intern(&lf[265],17,"file-read-access\077");
lf[266]=C_h_intern(&lf[266],18,"file-write-access\077");
lf[267]=C_h_intern(&lf[267],20,"file-execute-access\077");
lf[268]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[270]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[273]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[275]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[277]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[278]=C_h_intern(&lf[278],27,"local-timezone-abbreviation");
lf[279]=C_h_intern(&lf[279],5,"_exit");
lf[280]=C_h_intern(&lf[280],14,"terminal-port\077");
lf[281]=C_h_intern(&lf[281],13,"terminal-size");
lf[282]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[283]=C_h_intern(&lf[283],19,"set-buffering-mode!");
lf[284]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[285]=C_h_intern(&lf[285],5,"\000full");
lf[286]=C_h_intern(&lf[286],5,"\000line");
lf[287]=C_h_intern(&lf[287],5,"\000none");
lf[288]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[289]=C_h_intern(&lf[289],13,"spawn/overlay");
lf[290]=C_h_intern(&lf[290],10,"spawn/wait");
lf[291]=C_h_intern(&lf[291],12,"spawn/nowait");
lf[292]=C_h_intern(&lf[292],13,"spawn/nowaito");
lf[293]=C_h_intern(&lf[293],12,"spawn/detach");
lf[295]=C_h_intern(&lf[295],16,"\003sysfast-reverse");
lf[296]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[299]=C_h_intern(&lf[299],24,"pathname-strip-directory");
lf[301]=C_h_intern(&lf[301],15,"process-execute");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[303]=C_h_intern(&lf[303],13,"process-spawn");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[305]=C_h_intern(&lf[305],17,"\003sysshell-command");
lf[306]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[307]=C_h_intern(&lf[307],24,"get-environment-variable");
lf[308]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[309]=C_h_intern(&lf[309],27,"\003sysshell-command-arguments");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[311]=C_h_intern(&lf[311],11,"process-run");
lf[312]=C_h_intern(&lf[312],11,"\003sysprocess");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[314]=C_h_intern(&lf[314],17,"\003sysmake-locative");
lf[315]=C_h_intern(&lf[315],8,"location");
lf[316]=C_h_intern(&lf[316],18,"string-intersperse");
lf[317]=C_h_intern(&lf[317],7,"process");
lf[318]=C_h_intern(&lf[318],8,"process\052");
lf[319]=C_h_intern(&lf[319],5,"sleep");
lf[320]=C_h_intern(&lf[320],13,"get-host-name");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[322]=C_h_intern(&lf[322],18,"system-information");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[325]=C_h_intern(&lf[325],17,"current-user-name");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[327]=C_h_intern(&lf[327],9,"prot/none");
lf[328]=C_h_intern(&lf[328],9,"prot/read");
lf[329]=C_h_intern(&lf[329],10,"prot/write");
lf[330]=C_h_intern(&lf[330],9,"prot/exec");
lf[331]=C_h_intern(&lf[331],8,"map/file");
lf[332]=C_h_intern(&lf[332],10,"map/shared");
lf[333]=C_h_intern(&lf[333],11,"map/private");
lf[334]=C_h_intern(&lf[334],9,"map/fixed");
lf[335]=C_h_intern(&lf[335],13,"map/anonymous");
lf[336]=C_h_intern(&lf[336],18,"map-file-to-memory");
lf[337]=C_h_intern(&lf[337],4,"mmap");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[339]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[340]=C_h_intern(&lf[340],16,"\003sysnull-pointer");
lf[341]=C_h_intern(&lf[341],22,"unmap-file-from-memory");
lf[342]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[343]=C_h_intern(&lf[343],26,"memory-mapped-file-pointer");
lf[344]=C_h_intern(&lf[344],19,"memory-mapped-file\077");
lf[345]=C_h_intern(&lf[345],17,"change-directory\052");
lf[346]=C_h_intern(&lf[346],5,"error");
lf[347]=C_h_intern(&lf[347],17,"change-file-owner");
lf[348]=C_h_intern(&lf[348],11,"create-fifo");
lf[349]=C_h_intern(&lf[349],14,"create-session");
lf[350]=C_h_intern(&lf[350],20,"create-symbolic-link");
lf[351]=C_h_intern(&lf[351],26,"current-effective-group-id");
lf[352]=C_h_intern(&lf[352],25,"current-effective-user-id");
lf[353]=C_h_intern(&lf[353],27,"current-effective-user-name");
lf[354]=C_h_intern(&lf[354],16,"current-group-id");
lf[355]=C_h_intern(&lf[355],15,"current-user-id");
lf[356]=C_h_intern(&lf[356],9,"file-link");
lf[357]=C_h_intern(&lf[357],9,"file-lock");
lf[358]=C_h_intern(&lf[358],18,"file-lock/blocking");
lf[359]=C_h_intern(&lf[359],11,"file-select");
lf[360]=C_h_intern(&lf[360],14,"file-test-lock");
lf[361]=C_h_intern(&lf[361],13,"file-truncate");
lf[362]=C_h_intern(&lf[362],11,"file-unlock");
lf[363]=C_h_intern(&lf[363],10,"get-groups");
lf[364]=C_h_intern(&lf[364],17,"group-information");
lf[365]=C_h_intern(&lf[365],17,"initialize-groups");
lf[366]=C_h_intern(&lf[366],17,"parent-process-id");
lf[367]=C_h_intern(&lf[367],12,"process-fork");
lf[368]=C_h_intern(&lf[368],16,"process-group-id");
lf[369]=C_h_intern(&lf[369],14,"process-signal");
lf[370]=C_h_intern(&lf[370],18,"read-symbolic-link");
lf[371]=C_h_intern(&lf[371],10,"set-alarm!");
lf[372]=C_h_intern(&lf[372],13,"set-group-id!");
lf[373]=C_h_intern(&lf[373],11,"set-groups!");
lf[374]=C_h_intern(&lf[374],21,"set-process-group-id!");
lf[375]=C_h_intern(&lf[375],19,"set-root-directory!");
lf[376]=C_h_intern(&lf[376],16,"set-signal-mask!");
lf[377]=C_h_intern(&lf[377],12,"set-user-id!");
lf[378]=C_h_intern(&lf[378],11,"signal-mask");
lf[379]=C_h_intern(&lf[379],12,"signal-mask!");
lf[380]=C_h_intern(&lf[380],14,"signal-masked\077");
lf[381]=C_h_intern(&lf[381],14,"signal-unmask!");
lf[382]=C_h_intern(&lf[382],13,"terminal-name");
lf[383]=C_h_intern(&lf[383],16,"user-information");
lf[384]=C_h_intern(&lf[384],17,"utc-time->seconds");
lf[385]=C_h_intern(&lf[385],12,"string->time");
lf[386]=C_h_intern(&lf[386],16,"errno/wouldblock");
lf[387]=C_h_intern(&lf[387],10,"open/fsync");
lf[388]=C_h_intern(&lf[388],11,"open/noctty");
lf[389]=C_h_intern(&lf[389],13,"open/nonblock");
lf[390]=C_h_intern(&lf[390],9,"open/sync");
lf[391]=C_h_intern(&lf[391],10,"perm/isgid");
lf[392]=C_h_intern(&lf[392],10,"perm/isuid");
lf[393]=C_h_intern(&lf[393],10,"perm/isvtx");
lf[394]=C_h_intern(&lf[394],18,"getter-with-setter");
lf[395]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[398]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[399]=C_h_intern(&lf[399],26,"set-file-modification-time");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[401]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,402,create_ptable());{}
t2=C_mutate2(&lf[0] /* (set! c1528 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2248,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t3;
C_scheduler_toplevel(2,av2);}}

/* k2505 in block-device? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2507,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[32],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* change-file-mode in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4614,4,av);}
a=C_alloc(5);
t4=C_i_check_string_2(t2,lf[263]);
t5=C_i_check_exact_2(t3,lf[263]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4638,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1019: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[263];
tp(4,av2);}}

/* k3737 in loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3739,2,av);}
a=C_alloc(9);
t2=t1;
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3747,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li64),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3747(t6,((C_word*)t0)[4],C_fix(0));}
else{
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* loop in get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3735(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,3))){
C_save_and_reclaim_args((void *)trf_3735,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3739,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub633(t5,t6);
/* posix-common.scm:640: ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k3591 in k3587 in local-time->seconds in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3593,2,av);}
a=C_alloc(9);
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3599,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:604: fp= */
t4=*((C_word*)lf[117]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[118];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* get-environment-variables in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3729(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_3729,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3735,a[2]=t3,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3735(t5,t1,C_fix(0));}

/* k3597 in k3591 in k3587 in local-time->seconds in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3599,2,av);}
if(C_truep(t1)){
/* posix-common.scm:605: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[115];
av2[3]=lf[116];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* seconds->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,2))){
C_save_and_reclaim((void*)f_3547,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3551,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:592: current-seconds */
t4=*((C_word*)lf[111]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_i_car(t2);
f_3551(2,av2);}}}

/* conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3143(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_3143,3,t0,t1,t2);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3158,a[2]=t4,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3164,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:501: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}}

/* k3715 in unsetenv in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3717(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3717,2,av);}
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k6301 in a6282 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6303(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_6303,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:259: posix-error */
t2=lf[2];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[399];
av2[4]=lf[400];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2272(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_3137,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3143,a[2]=t4,a[3]=((C_word)li38),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3143(t6,t1,t2);}

/* loop in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4194(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_4194,3,t0,t1,t2);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4201,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(t2,C_fix(0)))){
t4=C_i_string_ref(((C_word*)t0)[3],t2);
t5=t3;
f_4201(t5,C_eqp(t4,C_make_character(88)));}
else{
t4=t3;
f_4201(t4,C_SCHEME_FALSE);}}

/* k3654 in k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3656,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3660,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:617: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* character-device? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2509,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2517,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:292: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3644 in k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3646(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3646,2,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* posix-common.scm:618: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[119];
av2[3]=lf[120];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* file-open in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_3915,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3919,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3919(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3919(t6,((C_word*)t0)[2]);}}

/* k3917 in file-open in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3919(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_3919,2,t0,t1);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_string_2(((C_word*)t0)[2],lf[158]);
t4=C_i_check_exact_2(((C_word*)t0)[3],lf[158]);
t5=C_i_check_exact_2(t2,lf[158]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3932,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:737: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[158];
tp(4,av2);}}

/* local-time->seconds in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3585,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3589,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:602: check-time-vector */
f_3476(t3,lf[115],t2);}

/* k2525 */
static void C_ccall f_2527(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2527,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[33],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3587 in local-time->seconds in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3589(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3589,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3593,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:603: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k2515 in character-device? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2517(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2517,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[31],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* socket? in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2529,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2537,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:298: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k5039 in setarg in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5041,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1133(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_2519 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2519(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2519,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2527,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:295: file-type */
t4=*((C_word*)lf[27]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* ##sys#process-wait in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5718,4,av);}
if(C_truep(C_process_wait(t2,t3))){
/* posixwin.scm:1330: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_fix((C_word)C_exstatus);
C_values(5,av2);}}
else{
/* posixwin.scm:1331: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(-1);
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* seconds->utc-time in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3516(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_3516,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3520,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:586: current-seconds */
t4=*((C_word*)lf[111]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[112]);
/* posix-common.scm:588: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[110]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[110]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}}

/* loop in loop in $quote-args-list in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static C_word C_fcall f_4969(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
t2=C_eqp(t1,((C_word*)t0)[2]);
if(C_truep(t2)){
return(C_SCHEME_FALSE);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t1);
if(C_truep(C_u_i_char_whitespacep(t3))){
return(C_SCHEME_TRUE);}
else{
t4=C_fixnum_plus(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}}}

/* setarg in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5032(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_5032,5,av);}
a=C_alloc(5);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5041,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1192: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=stub1133(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* $quote-args-list in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4955(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_4955,3,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(t3)){
t4=t2;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4998,a[2]=t5,a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_4998(t7,t1,t2,C_SCHEME_END_OF_LIST);}}

/* a3847 in process-wait in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3848(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_3848,5,av);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:680: posix-error */
t6=lf[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[131];
av2[3]=lf[129];
av2[4]=lf[132];
av2[5]=((C_word*)t0)[2];
f_2272(6,av2);}}
else{
/* posix-common.scm:681: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}}

/* a3841 in process-wait in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3842(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3842,2,av);}
/* posix-common.scm:678: ##sys#process-wait */
t2=*((C_word*)lf[130]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4529 in create-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4531(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4531,2,av);}
/* posixwin.scm:924: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[196];
av2[4]=lf[197];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k3661 in k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3663,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:621: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[74]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:622: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[119];
av2[3]=lf[121];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3658 in k3654 in k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3660,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub593(t3,t2,((C_word*)t0)[3],t4);
/* posix-common.scm:610: ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub593(t3,t2,((C_word*)t0)[3],C_SCHEME_FALSE);
/* posix-common.scm:610: ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[4];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k5442 in k5432 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_5444,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5448,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm:1291: open-output-file* */
t4=*((C_word*)lf[65]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[7])));
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_5448(2,av2);}}}

/* k3518 in seconds->utc-time in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3520(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3520,2,av);}
t2=C_i_check_number_2(t1,lf[112]);
/* posix-common.scm:588: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[110]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[110]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}

/* k5446 in k5442 in k5432 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,5))){C_save_and_reclaim((void *)f_5448,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5452,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1293: open-input-file* */
t4=*((C_word*)lf[64]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6])));
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* posixwin.scm:1289: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
av2[4]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4])));
av2[5]=C_SCHEME_FALSE;
C_values(6,av2);}}}

/* current-effective-user-name in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5987(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5987,2,av);}
/* posixwin.scm:1548: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[353];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* current-effective-user-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5981,2,av);}
/* posixwin.scm:1547: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[352];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4094 in loop in k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4096(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_4096,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4100,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm:805: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[158];
tp(4,av2);}}

/* loop in k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4092(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(18,0,3))){
C_save_and_reclaim_args((void *)trf_4092,3,t0,t1,t2);}
a=C_alloc(18);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4096,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
t4=C_fixnum_difference(((C_word*)t0)[6],C_fix(1));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4139,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[5],a[5]=t6,a[6]=((C_word*)t0)[9],a[7]=((C_word)li77),tmp=(C_word)a,a+=8,tmp));
t8=((C_word*)t6)[1];
f_4139(t8,t3,t4);}

/* current-group-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5993(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5993,2,av);}
/* posixwin.scm:1549: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[354];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5450 in k5446 in k5442 in k5432 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5452,2,av);}
/* posixwin.scm:1289: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5])));
av2[5]=t1;
C_values(6,av2);}}

/* k3555 in k3549 in seconds->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3557,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:596: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[74]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:597: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[113];
av2[3]=lf[114];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* current-user-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5999(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5999,2,av);}
/* posixwin.scm:1550: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[355];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3549 in seconds->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3551(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3551,2,av);}
a=C_alloc(9);
t2=t1;
t3=C_i_check_number_2(t2,lf[113]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3557,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t2);
t7=stub554(t5,t6);
/* posix-common.scm:591: ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* create-symbolic-link in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5969,2,av);}
/* posixwin.scm:1545: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[350];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5462 in k5432 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5464(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5464,2,av);}
/* posixwin.scm:1296: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[131];
av2[3]=((C_word*)t0)[3];
av2[4]=lf[313];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k5022 in loop in $quote-args-list in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_5024,2,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[2]);
/* posixwin.scm:1182: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4998(t3,((C_word*)t0)[4],((C_word*)t0)[5],t2);}

/* create-session in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5963,2,av);}
/* posixwin.scm:1544: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[349];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* current-effective-group-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5975,2,av);}
/* posixwin.scm:1546: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[351];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5475(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,5))){C_save_and_reclaim((void *)f_5475,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5479,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1286: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[314]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[10];
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[315];
tp(6,av2);}}

/* k5477 in k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,5))){C_save_and_reclaim((void *)f_5479,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5483,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1286: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[314]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[10];
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[315];
tp(6,av2);}}

/* k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,5))){C_save_and_reclaim((void *)f_5471,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5475,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1286: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[314]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[10];
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[315];
tp(6,av2);}}

/* change-directory* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5945,2,av);}
/* posixwin.scm:1541: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[345];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4078(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_4078,2,av);}
a=C_alloc(16);
t2=t1;
t3=C_block_size(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4084,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],tmp=(C_word)a,a+=9,tmp);
t6=C_fixnum_difference(t4,C_fix(1));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4194,a[2]=t8,a[3]=t2,a[4]=((C_word)li79),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_4194(t10,t5,t6);}

/* k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_4075,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4078,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:785: string-copy */
t4=*((C_word*)lf[177]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* setenv in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3692,4,av);}
a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[122]);
t5=C_i_check_string_2(t3,lf[122]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3703,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:631: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[122];
tp(4,av2);}}

/* create-fifo in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5957(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5957,2,av);}
/* posixwin.scm:1543: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[348];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* change-file-owner in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5951,2,av);}
/* posixwin.scm:1542: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[347];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4087(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,3))){C_save_and_reclaim((void *)f_4087,2,av);}
a=C_alloc(13);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4092,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word)li78),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4092(t5,((C_word*)t0)[9],C_fix(1));}

/* k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(19,c,2))){C_save_and_reclaim((void *)f_4084,2,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4087,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4181,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4185,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:792: pathname-directory */
t6=*((C_word*)lf[85]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k3682 in k3635 in time->string in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3684,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub583(t3,t2,t4);
/* posix-common.scm:609: ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub583(t3,t2,C_SCHEME_FALSE);
/* posix-common.scm:609: ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* utc-time->seconds in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6173,2,av);}
/* posixwin.scm:1579: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[384];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* string->time in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6179,2,av);}
/* posixwin.scm:1580: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[385];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* memory-mapped-file? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5939,3,av);}
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[337]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* memory-mapped-file-pointer in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5930(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5930,3,av);}
t3=C_i_check_structure_2(t2,lf[337],lf[343]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_4065,3,av);}
a=C_alloc(6);
t3=C_i_check_string_2(t2,lf[169]);
t4=lf[170];
t5=C_block_size(t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4075,a[2]=t2,a[3]=t4,a[4]=t6,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:784: * */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t7;
av2[2]=t6;
av2[3]=t6;
av2[4]=t6;
C_times(5,av2);}}

/* k5902 in unmap-file-from-memory in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5904(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_5904,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=C_i_foreign_integer_argumentp(t1);
t5=stub1478(C_SCHEME_UNDEFINED,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* posixwin.scm:1524: posix-error */
t7=lf[2];{
C_word av2[7];
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=lf[341];
av2[4]=lf[342];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2272(7,av2);}}}

/* signal-unmask! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6155,2,av);}
/* posixwin.scm:1576: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[381];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2612 in mode in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2614,2,av);}
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* fifo? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6186(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6186,3,av);}
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k4295 in open-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4297(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4297,2,av);}
/* posixwin.scm:843: check */
f_4265(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word *a;
if(!C_demand(C_calculate_demand(53,c,6))){C_save_and_reclaim((void *)f_2601,2,av);}
a=C_alloc(53);
t2=C_mutate2((C_word*)lf[49]+1 /* (set! file-position ...) */,t1);
t3=C_mutate2((C_word*)lf[50]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t4=C_mutate2((C_word*)lf[51]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate2((C_word*)lf[52]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2606,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t11=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2643,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[64]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2658,a[2]=t9,a[3]=t7,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t13=C_mutate2((C_word*)lf[65]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2672,a[2]=t9,a[3]=t7,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t14=C_mutate2((C_word*)lf[12]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2686,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[70]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2734,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[72]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2761,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate2((C_word*)lf[77]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2795,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate2((C_word*)lf[83]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2881,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[30]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2998,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[91]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3137,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[80]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3423,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t22=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3474,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t23=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6209,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp);
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6234,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:563: getter-with-setter */
t25=*((C_word*)lf[394]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t25;
av2[1]=t22;
av2[2]=t23;
av2[3]=t24;
av2[4]=lf[395];
((C_proc)(void*)(*((C_word*)t25+1)))(5,av2);}}

/* mode in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_2606(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_2606,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2614,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[53]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:362: ##sys#error */
t10=*((C_word*)lf[54]+1);{
C_word av2[4];
av2[0]=t10;
av2[1]=t5;
av2[2]=lf[55];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[56];
av2[3]=t4;
tp(4,av2);}}}
else{
/* posix-common.scm:363: ##sys#error */
t9=*((C_word*)lf[54]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t5;
av2[2]=lf[57];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}}
else{
if(C_truep(t2)){
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[58];
av2[3]=t4;
tp(4,av2);}}
else{
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t1;
av2[2]=lf[59];
av2[3]=t4;
tp(4,av2);}}}}

/* k4279 in k4267 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4281,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open-input-pipe in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3))){
C_save_and_reclaim((void*)f_4283,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[181]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[182]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4297,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[182]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4304,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:846: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[181];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[183]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4314,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:847: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[181];
tp(4,av2);}}
else{
/* posixwin.scm:831: ##sys#error */
t10=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[184];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k2345 in file-stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(30,c,1))){C_save_and_reclaim((void *)f_2347,2,av);}
a=C_alloc(30);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),*((C_word*)lf[19]+1),*((C_word*)lf[20]+1));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5485 in k5481 in k5477 in k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_5487,2,av);}
a=C_alloc(9);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=((C_word*)t0)[8];
t9=t1;
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5362,a[2]=t5,a[3]=t6,a[4]=t7,a[5]=t8,a[6]=t9,a[7]=t2,a[8]=t4,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t11=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1274: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t10;
av2[2]=t11;
tp(3,av2);}}
else{
t11=t10;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_5362(2,av2);}}}

/* k5481 in k5477 in k5473 in k5469 in k5425 in process in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_5483,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5487,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(1));
t5=(C_truep(((C_word*)t0)[9])?C_fix(0):C_fix(2));
if(C_truep(((C_word*)t0)[10])){
/* posixwin.scm:1287: + */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=C_fix(0);
C_plus(5,av2);}}
else{
/* posixwin.scm:1287: + */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=C_fix(4);
C_plus(5,av2);}}}

/* file-stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5))){
C_save_and_reclaim((void*)f_2340,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2347,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:243: ##sys#stat */
f_2290(t6,t2,t5,C_SCHEME_TRUE,lf[18]);}

/* k2333 in k2313 in stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2335(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2335,2,av);}
/* posix-common.scm:226: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k4267 in check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4269(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4269,2,av);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:835: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=lf[179];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4281,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:836: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[61]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[61]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=*((C_word*)lf[62]+1);
av2[4]=lf[180];
av2[5]=lf[47];
tp(6,av2);}}}

/* check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4265(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_4265,4,t1,t2,t3,t4);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4269,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:833: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}

/* k4160 in suffix-loop in loop in k4085 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4162,2,av);}
t2=C_i_string_ref(((C_word*)t0)[2],t1);
t3=C_i_string_set(((C_word*)t0)[3],((C_word*)t0)[4],t2);
t4=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixwin.scm:803: suffix-loop */
t5=((C_word*)((C_word*)t0)[5])[1];
f_4139(t5,((C_word*)t0)[6],t4);}

/* k4895 in k4892 in set-buffering-mode! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_4897,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[283]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4906,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_slot(((C_word*)t0)[4],C_fix(7));
t6=C_eqp(lf[47],t5);
if(C_truep(t6)){
t7=C_setvbuf(((C_word*)t0)[4],t2,((C_word*)t0)[2]);
t8=t4;
f_4906(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
t7=t4;
f_4906(t7,C_SCHEME_TRUE);}}

/* k4892 in set-buffering-mode! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4894(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,5))){
C_save_and_reclaim_args((void *)trf_4894,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4897,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[285]);
if(C_truep(t5)){
t6=t4;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_fix((C_word)_IOFBF);
f_4897(2,av2);}}
else{
t6=C_eqp(t3,lf[286]);
if(C_truep(t6)){
t7=C_fix((C_word)_IOLBF);
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
f_4897(2,av2);}}
else{
t7=C_eqp(t3,lf[287]);
if(C_truep(t7)){
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_fix((C_word)_IONBF);
f_4897(2,av2);}}
else{
/* posixwin.scm:1139: ##sys#error */
t8=*((C_word*)lf[54]+1);{
C_word av2[6];
av2[0]=t8;
av2[1]=t4;
av2[2]=lf[283];
av2[3]=lf[288];
av2[4]=((C_word*)t0)[2];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}}}}

/* k2364 in file-access-time in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2366,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_atime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-change-time in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2368,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2372,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:265: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[23]);}

/* file-access-time in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2362,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2366,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:264: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2360(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
if(!C_demand(C_calculate_demand(48,c,4))){C_save_and_reclaim((void *)f_2360,2,av);}
a=C_alloc(48);
t2=C_mutate2((C_word*)lf[21]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate2((C_word*)lf[22]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2362,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[23]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2368,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[24]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2374,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[25]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2380,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[26]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2386,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[27]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2392,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[35]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2479,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[36]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2489,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[37]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2499,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[38]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2509,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[39]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2519,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[40]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2529,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[41]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2539,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[42]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t17=C_mutate2((C_word*)lf[43]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t18=C_mutate2((C_word*)lf[44]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t19=C_mutate2((C_word*)lf[45]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2552,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2601,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6240,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:329: getter-with-setter */
t22=*((C_word*)lf[394]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t22;
av2[1]=t20;
av2[2]=t21;
av2[3]=*((C_word*)lf[45]+1);
av2[4]=lf[398];
((C_proc)(void*)(*((C_word*)t22+1)))(5,av2);}}

/* _exit in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1))){
C_save_and_reclaim((void*)f_4841,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
t5=t1;
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t5;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=stub1078(C_SCHEME_UNDEFINED,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=stub1078(C_SCHEME_UNDEFINED,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k4183 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_4185,2,av);}
if(C_truep(t1)){
t2=t1;
/* posixwin.scm:792: directory-exists? */
t3=*((C_word*)lf[175]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
/* posixwin.scm:792: directory-exists? */
t2=*((C_word*)lf[175]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[176];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}}

/* k4179 in k4082 in k4076 in k4073 in file-mkstemp in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4181,2,av);}
if(C_truep(t1)){
t2=C_eqp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(t2)){
/* posixwin.scm:798: ##sys#signal-hook */
t3=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[10];
av2[3]=lf[169];
av2[4]=lf[173];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
f_4087(2,av2);}}}
else{
/* posixwin.scm:796: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[10];
av2[3]=lf[169];
av2[4]=lf[174];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* terminal-size in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_4873,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4880,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1122: terminal-port? */
t4=*((C_word*)lf[280]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* file-size in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2386(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2386,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2390,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:268: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[26]);}

/* file-permissions in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2380,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2384,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:267: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[25]);}

/* k2382 in file-permissions in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2384(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2384,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2376 in file-owner in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2378(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2378,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5060 in setenv in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5062(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5062,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1143(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* file-owner in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2374,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2378,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:266: ##sys#stat */
f_2290(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[24]);}

/* k2370 in file-change-time in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2372(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2372,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_ctime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* terminal-port? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4855,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[280]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4861,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1118: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[69]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[69]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k3308 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 in ... */
static void C_ccall f_3310(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3310,2,av);}
if(C_truep(t1)){
/* posix-common.scm:539: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:539: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3263(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

/* k3327 in k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in ... */
static void C_ccall f_3329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3329,2,av);}
/* posix-common.scm:541: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* current-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_2761,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:415: change-directory */
t5=*((C_word*)lf[73]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2774,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[76]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[76]+1);
av2[1]=t5;
av2[2]=C_fix(1024);
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* k3317 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 in ... */
static void C_ccall f_3319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(31,c,4))){C_save_and_reclaim((void *)f_3319,2,av);}
a=C_alloc(31);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3329,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3331,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li40),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3336,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word)li41),tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3356,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li42),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:543: ##sys#dynamic-wind */
t11=*((C_word*)lf[99]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t11;
av2[1]=t7;
av2[2]=t8;
av2[3]=t9;
av2[4]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3366,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3369,a[2]=((C_word*)t0)[8],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:547: pproc */
t4=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}

/* k2388 in file-size in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2390,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_double_to_num(&a,C_statbuf.st_size);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-type in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5))){
C_save_and_reclaim((void*)f_2392,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2411,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:271: ##sys#stat */
f_2290(t12,t2,t5,t9,lf[27]);}

/* k3305 in k3373 in k3283 in k3274 in loop in k3259 in k3252 in k3249 in k3440 in k3437 in k3434 in k3431 in k3428 in k3425 in find-files in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 in ... */
static void C_ccall f_3307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3307,2,av);}
/* posix-common.scm:539: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3263(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* open-output-file* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_4750,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[65]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4762,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1074: mode */
f_4681(t5,C_SCHEME_FALSE,t3,lf[65]);}

/* k2700 */
static void C_ccall f_2702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2702,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2775 in k2772 in current-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2777,2,av);}
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:421: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[74]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[74]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[2];
tp(5,av2);}}
else{
/* posix-common.scm:422: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[10];
av2[3]=lf[72];
av2[4]=lf[75];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k4859 in terminal-port? in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4861(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4861,2,av);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k4746 in open-input-file* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4748,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1070: check */
f_4718(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k2772 in current-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_2774,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_curdir(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2777,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:419: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t4;
tp(2,av2);}}

/* k4812 in k4803 in duplicate-fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4814,2,av);}
/* posixwin.scm:1097: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[10];
av2[3]=lf[70];
av2[4]=lf[277];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k4774 in k4794 in port->fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4776(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4776,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* delete-directory in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,6))){
C_save_and_reclaim((void*)f_2795,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2801,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp);
t7=C_i_check_string_2(t2,lf[77]);
if(C_truep(t5)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2824,a[2]=t6,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:434: find-files */
t9=*((C_word*)lf[80]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t9;
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[81];
av2[4]=C_SCHEME_TRUE;
av2[5]=lf[82];
av2[6]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t9+1)))(7,av2);}}
else{
/* posix-common.scm:446: rmdir */
f_2801(t1,t2);}}

/* k4760 in open-output-file* in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,4))){C_save_and_reclaim((void *)f_4762,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1074: check */
f_4718(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* port->fileno in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4764(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4764,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[12]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4796,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1079: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[69]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[69]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* doloop1154 in build-exec-argvec in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5086(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_5086,4,t0,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1201: argvec-setter */
t4=((C_word*)t0)[2];{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_fix(0);
((C_proc)C_fast_retrieve_proc(t4))(5,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5105,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixwin.scm:1204: argvec-setter */
t8=((C_word*)t0)[2];{
C_word av2[5];
av2[0]=t8;
av2[1]=t6;
av2[2]=t3;
av2[3]=t4;
av2[4]=t7;
((C_proc)C_fast_retrieve_proc(t8))(5,av2);}}}

/* k2739 */
static void C_fcall f_2741(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,5))){
C_save_and_reclaim_args((void *)trf_2741,2,t0,t1);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2744,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:407: posix-error */
t4=lf[2];{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[10];
av2[3]=lf[70];
av2[4]=lf[71];
av2[5]=((C_word*)t0)[3];
f_2272(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2742 in k2739 */
static void C_ccall f_2744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2744,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* check in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_4718(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_4718,4,t1,t2,t3,t4);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4722,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1061: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[7]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[7]+1);
av2[1]=t5;
tp(2,av2);}}

/* local-timezone-abbreviation in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4828,2,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1072(t2);
/* posixwin.scm:1104: ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* setenv in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_5053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_5053,5,av);}
a=C_alloc(5);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5062,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1193: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[13]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[13]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=stub1143(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k2326 in k2313 in stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2328(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2328,2,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_lstat(t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2294(2,av2);}}
else{
t2=C_stat(t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2294(2,av2);}}}

/* initialize-groups in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6059(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6059,2,av);}
/* posixwin.scm:1560: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[365];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-buffering-mode! in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_4888,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=t2;
t6=C_i_check_port_2(t5,C_fix(0),C_SCHEME_TRUE,lf[283]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4894,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_4894(t9,C_u_i_car(t8));}
else{
t8=t7;
f_4894(t8,C_fix((C_word)BUFSIZ));}}

/* process-group-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6077,2,av);}
/* posixwin.scm:1563: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[368];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4878 in terminal-size in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_4880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4880,2,av);}
if(C_truep(t1)){
/* posixwin.scm:1123: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
/* posixwin.scm:1124: ##sys#error */
t2=*((C_word*)lf[54]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[281];
av2[3]=lf[282];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* loop in k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_3177(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_3177,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:505: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3143(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3194,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:506: irregex-match */
t5=*((C_word*)lf[93]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k2317 in k2313 in stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2319,2,av);}
t2=C_fstat(t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2294(2,av2);}}

/* k3173 in k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_3175,2,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3177,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li36),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3177(t5,((C_word*)t0)[6],t1);}

/* build-exec-argvec in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_fcall f_5074(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,4))){
C_save_and_reclaim_args((void *)trf_5074,5,t1,t2,t3,t4,t5);}
a=C_alloc(8);
if(C_truep(t3)){
t6=C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5086,a[2]=t4,a[3]=t2,a[4]=t8,a[5]=((C_word)li125),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_5086(t10,t1,t3,t5);}
else{
/* posixwin.scm:1205: argvec-setter */
t6=t4;{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=t5;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_fix(0);
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}}

/* group-information in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6053,2,av);}
/* posixwin.scm:1559: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[364];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* process-fork in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6071,2,av);}
/* posixwin.scm:1562: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[367];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* parent-process-id in k3808 in k3472 in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_6065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6065,2,av);}
/* posixwin.scm:1561: error */
t2=*((C_word*)lf[346]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[366];
av2[3]=lf[0];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2313 in stat in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_2315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_2315,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2319,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:224: port->fileno */
t3=*((C_word*)lf[12]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2328,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2335,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:227: ##sys#platform-fixup-pathname */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[14]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[14]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* posix-common.scm:234: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[15];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[16];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k3166 in a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_3168,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3175,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:504: directory */
t4=*((C_word*)lf[30]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* posix-common.scm:504: directory */
t4=*((C_word*)lf[30]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[94];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* a3163 in conc-loop in glob in k2599 in k2358 in k2258 in k2255 in k2252 in k2249 in k2246 */
static void C_ccall f_3164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_3164,5,av);}
a=C_alloc(9);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3168,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t5,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3238,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t8=t3;
/* posix-common.scm:503: make-pathname */
t9=*((C_word*)lf[87]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=t8;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}
else{
/* posix-common.scm:503: make-pathname */
t8=*((C_word*)lf[87]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=lf[96];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[440] = {
{"f_3158:posixwin_2escm",(void*)f_3158},
{"f_6095:posixwin_2escm",(void*)f_6095},
{"f_6089:posixwin_2escm",(void*)f_6089},
{"f_6083:posixwin_2escm",(void*)f_6083},
{"f_3344:posixwin_2escm",(void*)f_3344},
{"f_2260:posixwin_2escm",(void*)f_2260},
{"f_3331:posixwin_2escm",(void*)f_3331},
{"f_3336:posixwin_2escm",(void*)f_3336},
{"f_3348:posixwin_2escm",(void*)f_3348},
{"f_4798:posixwin_2escm",(void*)f_4798},
{"f_4796:posixwin_2escm",(void*)f_4796},
{"f_2272:posixwin_2escm",(void*)f_2272},
{"f_5521:posixwin_2escm",(void*)f_5521},
{"f_3391:posixwin_2escm",(void*)f_3391},
{"f_3194:posixwin_2escm",(void*)f_3194},
{"f_2824:posixwin_2escm",(void*)f_2824},
{"f_2825:posixwin_2escm",(void*)f_2825},
{"f_3198:posixwin_2escm",(void*)f_3198},
{"f_4782:posixwin_2escm",(void*)f_4782},
{"f_2283:posixwin_2escm",(void*)f_2283},
{"f_5530:posixwin_2escm",(void*)f_5530},
{"f_2276:posixwin_2escm",(void*)f_2276},
{"f_2290:posixwin_2escm",(void*)f_2290},
{"f_2294:posixwin_2escm",(void*)f_2294},
{"f_4805:posixwin_2escm",(void*)f_4805},
{"f_4808:posixwin_2escm",(void*)f_4808},
{"f_2287:posixwin_2escm",(void*)f_2287},
{"f_2805:posixwin_2escm",(void*)f_2805},
{"f_2801:posixwin_2escm",(void*)f_2801},
{"f_4047:posixwin_2escm",(void*)f_4047},
{"f_3384:posixwin_2escm",(void*)f_3384},
{"f_4041:posixwin_2escm",(void*)f_4041},
{"f_2835:posixwin_2escm",(void*)f_2835},
{"f_3375:posixwin_2escm",(void*)f_3375},
{"f_2951:posixwin_2escm",(void*)f_2951},
{"f_4025:posixwin_2escm",(void*)f_4025},
{"f_3369:posixwin_2escm",(void*)f_3369},
{"f_3366:posixwin_2escm",(void*)f_3366},
{"f_2942:posixwin_2escm",(void*)f_2942},
{"f_2957:posixwin_2escm",(void*)f_2957},
{"f_3356:posixwin_2escm",(void*)f_3356},
{"f_3351:posixwin_2escm",(void*)f_3351},
{"f_2949:posixwin_2escm",(void*)f_2949},
{"f_4006:posixwin_2escm",(void*)f_4006},
{"f_4100:posixwin_2escm",(void*)f_4100},
{"f_4035:posixwin_2escm",(void*)f_4035},
{"f_4241:posixwin_2escm",(void*)f_4241},
{"f_4032:posixwin_2escm",(void*)f_4032},
{"f_2980:posixwin_2escm",(void*)f_2980},
{"f_4232:posixwin_2escm",(void*)f_4232},
{"f_2998:posixwin_2escm",(void*)f_2998},
{"f_6131:posixwin_2escm",(void*)f_6131},
{"f_6137:posixwin_2escm",(void*)f_6137},
{"f_4235:posixwin_2escm",(void*)f_4235},
{"f_6143:posixwin_2escm",(void*)f_6143},
{"f_6149:posixwin_2escm",(void*)f_6149},
{"f_4225:posixwin_2escm",(void*)f_4225},
{"f_2497:posixwin_2escm",(void*)f_2497},
{"f_2499:posixwin_2escm",(void*)f_2499},
{"f_4201:posixwin_2escm",(void*)f_4201},
{"f_6113:posixwin_2escm",(void*)f_6113},
{"f_6119:posixwin_2escm",(void*)f_6119},
{"f_4139:posixwin_2escm",(void*)f_4139},
{"f_2489:posixwin_2escm",(void*)f_2489},
{"f_2487:posixwin_2escm",(void*)f_2487},
{"f_6125:posixwin_2escm",(void*)f_6125},
{"f_2479:posixwin_2escm",(void*)f_2479},
{"f_5658:posixwin_2escm",(void*)f_5658},
{"f_6101:posixwin_2escm",(void*)f_6101},
{"f_6107:posixwin_2escm",(void*)f_6107},
{"f_5347:posixwin_2escm",(void*)f_5347},
{"f_4906:posixwin_2escm",(void*)f_4906},
{"f_5319:posixwin_2escm",(void*)f_5319},
{"f_3002:posixwin_2escm",(void*)f_3002},
{"f_6200:posixwin_2escm",(void*)f_6200},
{"f_6209:posixwin_2escm",(void*)f_6209},
{"f_5324:posixwin_2escm",(void*)f_5324},
{"f_3630:posixwin_2escm",(void*)f_3630},
{"f_3637:posixwin_2escm",(void*)f_3637},
{"f_4640:posixwin_2escm",(void*)f_4640},
{"f_5303:posixwin_2escm",(void*)f_5303},
{"f_5307:posixwin_2escm",(void*)f_5307},
{"f_2411:posixwin_2escm",(void*)f_2411},
{"f_5857:posixwin_2escm",(void*)f_5857},
{"f_5851:posixwin_2escm",(void*)f_5851},
{"f_6234:posixwin_2escm",(void*)f_6234},
{"f_3747:posixwin_2escm",(void*)f_3747},
{"f_3041:posixwin_2escm",(void*)f_3041},
{"f_5145:posixwin_2escm",(void*)f_5145},
{"f_6240:posixwin_2escm",(void*)f_6240},
{"f_6247:posixwin_2escm",(void*)f_6247},
{"f_6244:posixwin_2escm",(void*)f_6244},
{"f_3474:posixwin_2escm",(void*)f_3474},
{"f_3476:posixwin_2escm",(void*)f_3476},
{"f_5427:posixwin_2escm",(void*)f_5427},
{"f_5420:posixwin_2escm",(void*)f_5420},
{"f_5330:posixwin_2escm",(void*)f_5330},
{"f_3469:posixwin_2escm",(void*)f_3469},
{"f_5334:posixwin_2escm",(void*)f_5334},
{"f_3467:posixwin_2escm",(void*)f_3467},
{"f_5434:posixwin_2escm",(void*)f_5434},
{"f_3461:posixwin_2escm",(void*)f_3461},
{"f_5848:posixwin_2escm",(void*)f_5848},
{"f_5845:posixwin_2escm",(void*)f_5845},
{"f_5841:posixwin_2escm",(void*)f_5841},
{"f_3020:posixwin_2escm",(void*)f_3020},
{"f_3023:posixwin_2escm",(void*)f_3023},
{"f_5122:posixwin_2escm",(void*)f_5122},
{"f_3027:posixwin_2escm",(void*)f_3027},
{"f_5129:posixwin_2escm",(void*)f_5129},
{"f_3453:posixwin_2escm",(void*)f_3453},
{"f_3456:posixwin_2escm",(void*)f_3456},
{"f_3459:posixwin_2escm",(void*)f_3459},
{"f_3450:posixwin_2escm",(void*)f_3450},
{"f_4672:posixwin_2escm",(void*)f_4672},
{"f_3210:posixwin_2escm",(void*)f_3210},
{"f_3218:posixwin_2escm",(void*)f_3218},
{"f_3795:posixwin_2escm",(void*)f_3795},
{"f_5132:posixwin_2escm",(void*)f_5132},
{"f_3017:posixwin_2escm",(void*)f_3017},
{"f_5135:posixwin_2escm",(void*)f_5135},
{"f_3941:posixwin_2escm",(void*)f_3941},
{"f_5138:posixwin_2escm",(void*)f_5138},
{"f_4666:posixwin_2escm",(void*)f_4666},
{"f_4660:posixwin_2escm",(void*)f_4660},
{"f_5863:posixwin_2escm",(void*)f_5863},
{"f_3935:posixwin_2escm",(void*)f_3935},
{"f_3709:posixwin_2escm",(void*)f_3709},
{"f_5105:posixwin_2escm",(void*)f_5105},
{"f_3707:posixwin_2escm",(void*)f_3707},
{"f_3932:posixwin_2escm",(void*)f_3932},
{"f_3703:posixwin_2escm",(void*)f_3703},
{"f_4658:posixwin_2escm",(void*)f_4658},
{"f_4650:posixwin_2escm",(void*)f_4650},
{"f_3773:posixwin_2escm",(void*)f_3773},
{"f_3777:posixwin_2escm",(void*)f_3777},
{"f_3812:posixwin_2escm",(void*)f_3812},
{"f_3810:posixwin_2escm",(void*)f_3810},
{"f_4399:posixwin_2escm",(void*)f_4399},
{"f_4505:posixwin_2escm",(void*)f_4505},
{"f_4501:posixwin_2escm",(void*)f_4501},
{"f_3818:posixwin_2escm",(void*)f_3818},
{"f_4391:posixwin_2escm",(void*)f_4391},
{"f_3765:posixwin_2escm",(void*)f_3765},
{"f_3994:posixwin_2escm",(void*)f_3994},
{"f_3997:posixwin_2escm",(void*)f_3997},
{"f_3991:posixwin_2escm",(void*)f_3991},
{"f_3499:posixwin_2escm",(void*)f_3499},
{"f_3495:posixwin_2escm",(void*)f_3495},
{"f_4522:posixwin_2escm",(void*)f_4522},
{"f_3981:posixwin_2escm",(void*)f_3981},
{"f_3400:posixwin_2escm",(void*)f_3400},
{"f_3401:posixwin_2escm",(void*)f_3401},
{"f_3409:posixwin_2escm",(void*)f_3409},
{"f_3206:posixwin_2escm",(void*)f_3206},
{"f_4515:posixwin_2escm",(void*)f_4515},
{"f_4510:posixwin_2escm",(void*)f_4510},
{"f_5789:posixwin_2escm",(void*)f_5789},
{"f_4354:posixwin_2escm",(void*)f_4354},
{"f_4689:posixwin_2escm",(void*)f_4689},
{"f_4681:posixwin_2escm",(void*)f_4681},
{"f_4363:posixwin_2escm",(void*)f_4363},
{"f_4388:posixwin_2escm",(void*)f_4388},
{"f_4381:posixwin_2escm",(void*)f_4381},
{"f_5763:posixwin_2escm",(void*)f_5763},
{"f_5767:posixwin_2escm",(void*)f_5767},
{"f_5897:posixwin_2escm",(void*)f_5897},
{"f_4373:posixwin_2escm",(void*)f_4373},
{"f_5774:posixwin_2escm",(void*)f_5774},
{"f_3442:posixwin_2escm",(void*)f_3442},
{"f_4370:posixwin_2escm",(void*)f_4370},
{"f_5779:posixwin_2escm",(void*)f_5779},
{"f_3447:posixwin_2escm",(void*)f_3447},
{"f_5771:posixwin_2escm",(void*)f_5771},
{"f_3430:posixwin_2escm",(void*)f_3430},
{"f_5748:posixwin_2escm",(void*)f_5748},
{"f_3439:posixwin_2escm",(void*)f_3439},
{"f_3436:posixwin_2escm",(void*)f_3436},
{"f_3433:posixwin_2escm",(void*)f_3433},
{"f_5759:posixwin_2escm",(void*)f_5759},
{"f_3427:posixwin_2escm",(void*)f_3427},
{"f_3423:posixwin_2escm",(void*)f_3423},
{"f_6293:posixwin_2escm",(void*)f_6293},
{"f_3417:posixwin_2escm",(void*)f_3417},
{"f_6277:posixwin_2escm",(void*)f_6277},
{"f_5736:posixwin_2escm",(void*)f_5736},
{"f_5236:posixwin_2escm",(void*)f_5236},
{"f_5730:posixwin_2escm",(void*)f_5730},
{"f_3238:posixwin_2escm",(void*)f_3238},
{"f_3950:posixwin_2escm",(void*)f_3950},
{"f_6283:posixwin_2escm",(void*)f_6283},
{"f_6281:posixwin_2escm",(void*)f_6281},
{"f_3959:posixwin_2escm",(void*)f_3959},
{"f_6256:posixwin_2escm",(void*)f_6256},
{"f_4734:posixwin_2escm",(void*)f_4734},
{"f_4736:posixwin_2escm",(void*)f_4736},
{"f_4722:posixwin_2escm",(void*)f_4722},
{"f_2684:posixwin_2escm",(void*)f_2684},
{"f_2686:posixwin_2escm",(void*)f_2686},
{"f_5351:posixwin_2escm",(void*)f_5351},
{"f_2670:posixwin_2escm",(void*)f_2670},
{"f_2672:posixwin_2escm",(void*)f_2672},
{"f_5366:posixwin_2escm",(void*)f_5366},
{"f_5362:posixwin_2escm",(void*)f_5362},
{"f_5258:posixwin_2escm",(void*)f_5258},
{"f_2658:posixwin_2escm",(void*)f_2658},
{"f_2656:posixwin_2escm",(void*)f_2656},
{"f_2643:posixwin_2escm",(void*)f_2643},
{"f_4495:posixwin_2escm",(void*)f_4495},
{"f_4490:posixwin_2escm",(void*)f_4490},
{"f_5191:posixwin_2escm",(void*)f_5191},
{"f_4485:posixwin_2escm",(void*)f_4485},
{"f_4481:posixwin_2escm",(void*)f_4481},
{"f_5169:posixwin_2escm",(void*)f_5169},
{"f_4476:posixwin_2escm",(void*)f_4476},
{"f_2916:posixwin_2escm",(void*)f_2916},
{"f_4471:posixwin_2escm",(void*)f_4471},
{"f_4467:posixwin_2escm",(void*)f_4467},
{"f_4461:posixwin_2escm",(void*)f_4461},
{"f_2919:posixwin_2escm",(void*)f_2919},
{"f_4456:posixwin_2escm",(void*)f_4456},
{"f_2935:posixwin_2escm",(void*)f_2935},
{"f_4451:posixwin_2escm",(void*)f_4451},
{"f_2907:posixwin_2escm",(void*)f_2907},
{"f_2909:posixwin_2escm",(void*)f_2909},
{"f_5158:posixwin_2escm",(void*)f_5158},
{"f_5154:posixwin_2escm",(void*)f_5154},
{"f_4447:posixwin_2escm",(void*)f_4447},
{"f_4442:posixwin_2escm",(void*)f_4442},
{"f_4432:posixwin_2escm",(void*)f_4432},
{"f_4438:posixwin_2escm",(void*)f_4438},
{"f_4423:posixwin_2escm",(void*)f_4423},
{"f_4427:posixwin_2escm",(void*)f_4427},
{"f_6161:posixwin_2escm",(void*)f_6161},
{"f_2728:posixwin_2escm",(void*)f_2728},
{"f_6167:posixwin_2escm",(void*)f_6167},
{"f_3077:posixwin_2escm",(void*)f_3077},
{"f_3067:posixwin_2escm",(void*)f_3067},
{"f_2711:posixwin_2escm",(void*)f_2711},
{"f_4314:posixwin_2escm",(void*)f_4314},
{"f_3055:posixwin_2escm",(void*)f_3055},
{"f_4344:posixwin_2escm",(void*)f_4344},
{"f_2734:posixwin_2escm",(void*)f_2734},
{"f_4337:posixwin_2escm",(void*)f_4337},
{"f_2841:posixwin_2escm",(void*)f_2841},
{"f_2844:posixwin_2escm",(void*)f_2844},
{"f_2849:posixwin_2escm",(void*)f_2849},
{"f_4304:posixwin_2escm",(void*)f_4304},
{"f_5557:posixwin_2escm",(void*)f_5557},
{"f_3276:posixwin_2escm",(void*)f_3276},
{"f_4323:posixwin_2escm",(void*)f_4323},
{"f_2859:posixwin_2escm",(void*)f_2859},
{"f_5503:posixwin_2escm",(void*)f_5503},
{"f_6041:posixwin_2escm",(void*)f_6041},
{"f_6047:posixwin_2escm",(void*)f_6047},
{"f_4414:posixwin_2escm",(void*)f_4414},
{"f_3254:posixwin_2escm",(void*)f_3254},
{"f_3251:posixwin_2escm",(void*)f_3251},
{"f_4418:posixwin_2escm",(void*)f_4418},
{"f_2881:posixwin_2escm",(void*)f_2881},
{"f_5516:posixwin_2escm",(void*)f_5516},
{"f_5514:posixwin_2escm",(void*)f_5514},
{"f_4403:posixwin_2escm",(void*)f_4403},
{"f_3285:posixwin_2escm",(void*)f_3285},
{"f_4408:posixwin_2escm",(void*)f_4408},
{"f_5565:posixwin_2escm",(void*)f_5565},
{"f_6023:posixwin_2escm",(void*)f_6023},
{"f_6029:posixwin_2escm",(void*)f_6029},
{"f_5560:posixwin_2escm",(void*)f_5560},
{"f_6035:posixwin_2escm",(void*)f_6035},
{"f_2547:posixwin_2escm",(void*)f_2547},
{"f_5571:posixwin_2escm",(void*)f_5571},
{"f_3263:posixwin_2escm",(void*)f_3263},
{"f_3261:posixwin_2escm",(void*)f_3261},
{"f_2891:posixwin_2escm",(void*)f_2891},
{"f_2897:posixwin_2escm",(void*)f_2897},
{"f_2539:posixwin_2escm",(void*)f_2539},
{"f_2537:posixwin_2escm",(void*)f_2537},
{"f_6005:posixwin_2escm",(void*)f_6005},
{"f_2552:posixwin_2escm",(void*)f_2552},
{"f_6011:posixwin_2escm",(void*)f_6011},
{"f_6017:posixwin_2escm",(void*)f_6017},
{"f_2568:posixwin_2escm",(void*)f_2568},
{"f_2556:posixwin_2escm",(void*)f_2556},
{"f_2251:posixwin_2escm",(void*)f_2251},
{"f_2574:posixwin_2escm",(void*)f_2574},
{"f_2257:posixwin_2escm",(void*)f_2257},
{"f_2254:posixwin_2escm",(void*)f_2254},
{"f_2248:posixwin_2escm",(void*)f_2248},
{"f_4630:posixwin_2escm",(void*)f_4630},
{"f_4638:posixwin_2escm",(void*)f_4638},
{"f_4998:posixwin_2escm",(void*)f_4998},
{"f_5598:posixwin_2escm",(void*)f_5598},
{"f_5596:posixwin_2escm",(void*)f_5596},
{"f_5592:posixwin_2escm",(void*)f_5592},
{"toplevel:posixwin_2escm",(void*)C_posix_toplevel},
{"f_2507:posixwin_2escm",(void*)f_2507},
{"f_4614:posixwin_2escm",(void*)f_4614},
{"f_3739:posixwin_2escm",(void*)f_3739},
{"f_3735:posixwin_2escm",(void*)f_3735},
{"f_3593:posixwin_2escm",(void*)f_3593},
{"f_3729:posixwin_2escm",(void*)f_3729},
{"f_3599:posixwin_2escm",(void*)f_3599},
{"f_3547:posixwin_2escm",(void*)f_3547},
{"f_3143:posixwin_2escm",(void*)f_3143},
{"f_3717:posixwin_2escm",(void*)f_3717},
{"f_6303:posixwin_2escm",(void*)f_6303},
{"f_3137:posixwin_2escm",(void*)f_3137},
{"f_4194:posixwin_2escm",(void*)f_4194},
{"f_3656:posixwin_2escm",(void*)f_3656},
{"f_2509:posixwin_2escm",(void*)f_2509},
{"f_3646:posixwin_2escm",(void*)f_3646},
{"f_3915:posixwin_2escm",(void*)f_3915},
{"f_3919:posixwin_2escm",(void*)f_3919},
{"f_3585:posixwin_2escm",(void*)f_3585},
{"f_2527:posixwin_2escm",(void*)f_2527},
{"f_3589:posixwin_2escm",(void*)f_3589},
{"f_2517:posixwin_2escm",(void*)f_2517},
{"f_2529:posixwin_2escm",(void*)f_2529},
{"f_5041:posixwin_2escm",(void*)f_5041},
{"f_2519:posixwin_2escm",(void*)f_2519},
{"f_5718:posixwin_2escm",(void*)f_5718},
{"f_3516:posixwin_2escm",(void*)f_3516},
{"f_4969:posixwin_2escm",(void*)f_4969},
{"f_5032:posixwin_2escm",(void*)f_5032},
{"f_4955:posixwin_2escm",(void*)f_4955},
{"f_3848:posixwin_2escm",(void*)f_3848},
{"f_3842:posixwin_2escm",(void*)f_3842},
{"f_4531:posixwin_2escm",(void*)f_4531},
{"f_3663:posixwin_2escm",(void*)f_3663},
{"f_3660:posixwin_2escm",(void*)f_3660},
{"f_5444:posixwin_2escm",(void*)f_5444},
{"f_3520:posixwin_2escm",(void*)f_3520},
{"f_5448:posixwin_2escm",(void*)f_5448},
{"f_5987:posixwin_2escm",(void*)f_5987},
{"f_5981:posixwin_2escm",(void*)f_5981},
{"f_4096:posixwin_2escm",(void*)f_4096},
{"f_4092:posixwin_2escm",(void*)f_4092},
{"f_5993:posixwin_2escm",(void*)f_5993},
{"f_5452:posixwin_2escm",(void*)f_5452},
{"f_3557:posixwin_2escm",(void*)f_3557},
{"f_5999:posixwin_2escm",(void*)f_5999},
{"f_3551:posixwin_2escm",(void*)f_3551},
{"f_5969:posixwin_2escm",(void*)f_5969},
{"f_5464:posixwin_2escm",(void*)f_5464},
{"f_5024:posixwin_2escm",(void*)f_5024},
{"f_5963:posixwin_2escm",(void*)f_5963},
{"f_5975:posixwin_2escm",(void*)f_5975},
{"f_5475:posixwin_2escm",(void*)f_5475},
{"f_5479:posixwin_2escm",(void*)f_5479},
{"f_5471:posixwin_2escm",(void*)f_5471},
{"f_5945:posixwin_2escm",(void*)f_5945},
{"f_4078:posixwin_2escm",(void*)f_4078},
{"f_4075:posixwin_2escm",(void*)f_4075},
{"f_3692:posixwin_2escm",(void*)f_3692},
{"f_5957:posixwin_2escm",(void*)f_5957},
{"f_5951:posixwin_2escm",(void*)f_5951},
{"f_4087:posixwin_2escm",(void*)f_4087},
{"f_4084:posixwin_2escm",(void*)f_4084},
{"f_3684:posixwin_2escm",(void*)f_3684},
{"f_6173:posixwin_2escm",(void*)f_6173},
{"f_6179:posixwin_2escm",(void*)f_6179},
{"f_5939:posixwin_2escm",(void*)f_5939},
{"f_5930:posixwin_2escm",(void*)f_5930},
{"f_4065:posixwin_2escm",(void*)f_4065},
{"f_5904:posixwin_2escm",(void*)f_5904},
{"f_6155:posixwin_2escm",(void*)f_6155},
{"f_2614:posixwin_2escm",(void*)f_2614},
{"f_6186:posixwin_2escm",(void*)f_6186},
{"f_4297:posixwin_2escm",(void*)f_4297},
{"f_2601:posixwin_2escm",(void*)f_2601},
{"f_2606:posixwin_2escm",(void*)f_2606},
{"f_4281:posixwin_2escm",(void*)f_4281},
{"f_4283:posixwin_2escm",(void*)f_4283},
{"f_2347:posixwin_2escm",(void*)f_2347},
{"f_5487:posixwin_2escm",(void*)f_5487},
{"f_5483:posixwin_2escm",(void*)f_5483},
{"f_2340:posixwin_2escm",(void*)f_2340},
{"f_2335:posixwin_2escm",(void*)f_2335},
{"f_4269:posixwin_2escm",(void*)f_4269},
{"f_4265:posixwin_2escm",(void*)f_4265},
{"f_4162:posixwin_2escm",(void*)f_4162},
{"f_4897:posixwin_2escm",(void*)f_4897},
{"f_4894:posixwin_2escm",(void*)f_4894},
{"f_2366:posixwin_2escm",(void*)f_2366},
{"f_2368:posixwin_2escm",(void*)f_2368},
{"f_2362:posixwin_2escm",(void*)f_2362},
{"f_2360:posixwin_2escm",(void*)f_2360},
{"f_4841:posixwin_2escm",(void*)f_4841},
{"f_4185:posixwin_2escm",(void*)f_4185},
{"f_4181:posixwin_2escm",(void*)f_4181},
{"f_4873:posixwin_2escm",(void*)f_4873},
{"f_2386:posixwin_2escm",(void*)f_2386},
{"f_2380:posixwin_2escm",(void*)f_2380},
{"f_2384:posixwin_2escm",(void*)f_2384},
{"f_2378:posixwin_2escm",(void*)f_2378},
{"f_5062:posixwin_2escm",(void*)f_5062},
{"f_2374:posixwin_2escm",(void*)f_2374},
{"f_2372:posixwin_2escm",(void*)f_2372},
{"f_4855:posixwin_2escm",(void*)f_4855},
{"f_3310:posixwin_2escm",(void*)f_3310},
{"f_3329:posixwin_2escm",(void*)f_3329},
{"f_2761:posixwin_2escm",(void*)f_2761},
{"f_3319:posixwin_2escm",(void*)f_3319},
{"f_2390:posixwin_2escm",(void*)f_2390},
{"f_2392:posixwin_2escm",(void*)f_2392},
{"f_3307:posixwin_2escm",(void*)f_3307},
{"f_4750:posixwin_2escm",(void*)f_4750},
{"f_2702:posixwin_2escm",(void*)f_2702},
{"f_2777:posixwin_2escm",(void*)f_2777},
{"f_4861:posixwin_2escm",(void*)f_4861},
{"f_4748:posixwin_2escm",(void*)f_4748},
{"f_2774:posixwin_2escm",(void*)f_2774},
{"f_4814:posixwin_2escm",(void*)f_4814},
{"f_4776:posixwin_2escm",(void*)f_4776},
{"f_2795:posixwin_2escm",(void*)f_2795},
{"f_4762:posixwin_2escm",(void*)f_4762},
{"f_4764:posixwin_2escm",(void*)f_4764},
{"f_5086:posixwin_2escm",(void*)f_5086},
{"f_2741:posixwin_2escm",(void*)f_2741},
{"f_2744:posixwin_2escm",(void*)f_2744},
{"f_4718:posixwin_2escm",(void*)f_4718},
{"f_4828:posixwin_2escm",(void*)f_4828},
{"f_5053:posixwin_2escm",(void*)f_5053},
{"f_2328:posixwin_2escm",(void*)f_2328},
{"f_6059:posixwin_2escm",(void*)f_6059},
{"f_4888:posixwin_2escm",(void*)f_4888},
{"f_6077:posixwin_2escm",(void*)f_6077},
{"f_4880:posixwin_2escm",(void*)f_4880},
{"f_3177:posixwin_2escm",(void*)f_3177},
{"f_2319:posixwin_2escm",(void*)f_2319},
{"f_3175:posixwin_2escm",(void*)f_3175},
{"f_5074:posixwin_2escm",(void*)f_5074},
{"f_6053:posixwin_2escm",(void*)f_6053},
{"f_6071:posixwin_2escm",(void*)f_6071},
{"f_6065:posixwin_2escm",(void*)f_6065},
{"f_2315:posixwin_2escm",(void*)f_2315},
{"f_3168:posixwin_2escm",(void*)f_3168},
{"f_3164:posixwin_2escm",(void*)f_3164},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		2
o|eliminated procedure checks: 162 
o|specializations:
o|  4 (##sys#foreign-fixnum-argument fixnum)
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  3 (cdr pair)
o|  2 (string-ref string fixnum)
o|  3 (string-length string)
o|  2 (##sys#check-list (or pair list) *)
o|  3 (make-string fixnum)
o|  4 (##sys#check-open-port * *)
o|  9 (eqv? * (not float))
o|  11 (car pair)
(o e)|safe calls: 558 
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error c1528) 
o|Removed `not' forms: 8 
o|contracted procedure: "(posix-common.scm:184) strerror64" 
o|inlining procedure: k2295 
o|inlining procedure: k2295 
o|inlining procedure: k2310 
o|inlining procedure: k2310 
o|inlining procedure: k2329 
o|inlining procedure: k2329 
o|inlining procedure: k2406 
o|inlining procedure: k2418 
o|inlining procedure: k2418 
o|inlining procedure: k2430 
o|inlining procedure: k2430 
o|inlining procedure: k2442 
o|inlining procedure: k2442 
o|inlining procedure: k2406 
o|inlining procedure: k2563 
o|inlining procedure: k2563 
o|inlining procedure: k2575 
o|inlining procedure: k2575 
o|inlining procedure: k2585 
o|inlining procedure: k2585 
o|inlining procedure: k2612 
o|contracted procedure: k2628 
o|inlining procedure: k2625 
o|inlining procedure: k2625 
o|substituted constant variable: a2638 
o|inlining procedure: k2612 
o|inlining procedure: k2645 
o|inlining procedure: k2645 
o|substituted constant variable: a2689 
o|inlining procedure: k2690 
o|inlining procedure: k2690 
o|contracted procedure: k2706 
o|inlining procedure: k2709 
o|inlining procedure: k2709 
o|inlining procedure: k2742 
o|inlining procedure: k2742 
o|inlining procedure: k2766 
o|inlining procedure: k2766 
o|substituted constant variable: a2787 
o|inlining procedure: k2806 
o|inlining procedure: k2806 
o|inlining procedure: k2827 
o|propagated global variable: r28286355 delete-file 
o|inlining procedure: k2827 
o|inlining procedure: k2819 
o|inlining procedure: k2851 
o|inlining procedure: k2851 
o|inlining procedure: k2819 
o|inlining procedure: k2889 
o|inlining procedure: k2889 
o|inlining procedure: k2911 
o|contracted procedure: "(posix-common.scm:462) g336337" 
o|inlining procedure: k2922 
o|inlining procedure: k2922 
o|inlining procedure: k2911 
o|inlining procedure: k2959 
o|inlining procedure: k2959 
o|contracted procedure: "(posix-common.scm:463) g354355" 
o|inlining procedure: k2967 
o|inlining procedure: k2967 
o|inlining procedure: k3028 
o|inlining procedure: k3028 
o|inlining procedure: k3043 
o|inlining procedure: k3043 
o|inlining procedure: k3084 
o|inlining procedure: k3084 
o|substituted constant variable: a3106 
o|substituted constant variable: a3108 
o|inlining procedure: k3145 
o|inlining procedure: k3145 
o|inlining procedure: k3179 
o|inlining procedure: k3179 
o|inlining procedure: k3232 
o|inlining procedure: k3232 
o|inlining procedure: k3240 
o|inlining procedure: k3240 
o|contracted procedure: "(posix-common.scm:557) find-files" 
o|inlining procedure: k3265 
o|inlining procedure: k3265 
o|inlining procedure: k3286 
o|inlining procedure: k3286 
o|inlining procedure: k3305 
o|inlining procedure: k3305 
o|inlining procedure: k3314 
o|inlining procedure: k3346 
o|inlining procedure: k3346 
o|inlining procedure: k3314 
o|inlining procedure: k3364 
o|inlining procedure: k3364 
o|inlining procedure: k3379 
o|inlining procedure: k3379 
o|contracted procedure: k3406 
o|inlining procedure: k3411 
o|inlining procedure: k3411 
o|inlining procedure: k3481 
o|inlining procedure: k3481 
o|inlining procedure: k3558 
o|inlining procedure: k3558 
o|contracted procedure: "(posix-common.scm:594) ctime552" 
o|inlining procedure: k3594 
o|inlining procedure: k3594 
o|inlining procedure: k3638 
o|contracted procedure: "(posix-common.scm:617) strftime579" 
o|inlining procedure: k3624 
o|inlining procedure: k3624 
o|inlining procedure: k3638 
o|contracted procedure: "(posix-common.scm:619) asctime578" 
o|inlining procedure: k3611 
o|inlining procedure: k3611 
o|inlining procedure: k3740 
o|inlining procedure: k3749 
o|inlining procedure: k3749 
o|inlining procedure: k3740 
o|contracted procedure: "(posix-common.scm:643) get631" 
o|inlining procedure: k3850 
o|inlining procedure: k3850 
o|inlining procedure: k3933 
o|inlining procedure: k3933 
o|inlining procedure: k3961 
o|inlining procedure: k3961 
o|inlining procedure: k3995 
o|inlining procedure: k3995 
o|inlining procedure: k4039 
o|inlining procedure: k4039 
o|inlining procedure: k4109 
o|inlining procedure: k4109 
o|inlining procedure: k4141 
o|inlining procedure: k4141 
o|contracted procedure: k4163 
o|inlining procedure: k4169 
o|inlining procedure: k4169 
o|inlining procedure: k4186 
o|inlining procedure: k4186 
o|inlining procedure: k4196 
o|inlining procedure: k4196 
o|inlining procedure: k4233 
o|inlining procedure: k4233 
o|inlining procedure: k4249 
o|inlining procedure: k4249 
o|inlining procedure: k4270 
o|inlining procedure: k4270 
o|inlining procedure: k4295 
o|inlining procedure: k4295 
o|inlining procedure: "(posixwin.scm:848) badmode830" 
o|substituted constant variable: a4319 
o|substituted constant variable: a4321 
o|inlining procedure: k4335 
o|inlining procedure: k4335 
o|inlining procedure: "(posixwin.scm:858) badmode830" 
o|substituted constant variable: a4359 
o|substituted constant variable: a4361 
o|substituted constant variable: a4366 
o|substituted constant variable: a4367 
o|inlining procedure: k4371 
o|inlining procedure: k4371 
o|substituted constant variable: a4384 
o|substituted constant variable: a4385 
o|inlining procedure: k4389 
o|inlining procedure: k4389 
o|inlining procedure: k4520 
o|inlining procedure: k4520 
o|inlining procedure: k4622 
o|inlining procedure: k4622 
o|inlining procedure: k4648 
o|inlining procedure: k4648 
o|inlining procedure: k4687 
o|contracted procedure: k4703 
o|inlining procedure: k4700 
o|inlining procedure: k4700 
o|substituted constant variable: a4713 
o|inlining procedure: k4687 
o|inlining procedure: k4723 
o|inlining procedure: k4723 
o|substituted constant variable: a4767 
o|contracted procedure: k4771 
o|inlining procedure: k4768 
o|inlining procedure: k4768 
o|inlining procedure: k4806 
o|inlining procedure: k4806 
o|contracted procedure: "(posixwin.scm:1114) ex01076" 
o|substituted constant variable: a4858 
o|contracted procedure: k4865 
o|inlining procedure: k4862 
o|inlining procedure: k4862 
o|inlining procedure: k4875 
o|inlining procedure: k4875 
o|substituted constant variable: a4891 
o|inlining procedure: k4901 
o|inlining procedure: k4901 
o|inlining procedure: k4911 
o|inlining procedure: k4911 
o|inlining procedure: k4924 
o|inlining procedure: k4924 
o|substituted constant variable: a4940 
o|substituted constant variable: a4942 
o|substituted constant variable: a4944 
o|inlining procedure: k4957 
o|inlining procedure: k4957 
o|inlining procedure: k5000 
o|inlining procedure: k5000 
o|inlining procedure: k5022 
o|inlining procedure: k5022 
o|contracted procedure: "(posixwin.scm:1185) needs-quoting?1111" 
o|inlining procedure: k4971 
o|inlining procedure: k4971 
o|inlining procedure: k5076 
o|inlining procedure: k5088 
o|inlining procedure: k5088 
o|inlining procedure: k5076 
o|inlining procedure: k5143 
o|inlining procedure: k5143 
o|inlining procedure: k5159 
o|inlining procedure: k5159 
o|inlining procedure: k5196 
o|inlining procedure: k5196 
o|inlining procedure: k5263 
o|inlining procedure: k5263 
o|inlining procedure: k5308 
o|inlining procedure: k5308 
o|inlining procedure: k5335 
o|inlining procedure: k5335 
o|substituted constant variable: g129012911298 
o|substituted constant variable: g129012911298 
o|substituted constant variable: g129012911298 
o|substituted constant variable: g129212931299 
o|substituted constant variable: g129212931299 
o|substituted constant variable: g129212931299 
o|substituted constant variable: g129412951300 
o|substituted constant variable: g129412951300 
o|substituted constant variable: g129412951300 
o|substituted constant variable: g129612971301 
o|substituted constant variable: g129612971301 
o|substituted constant variable: g129612971301 
o|inlining procedure: k5435 
o|inlining procedure: k5450 
o|inlining procedure: k5450 
o|inlining procedure: k5435 
o|contracted procedure: "(posixwin.scm:1284) c-process1238" 
o|inlining procedure: k5497 
o|inlining procedure: k5497 
o|inlining procedure: k5532 
o|inlining procedure: k5532 
o|inlining procedure: k5573 
o|inlining procedure: k5573 
o|inlining procedure: k5720 
o|inlining procedure: k5720 
o|inlining procedure: k5738 
o|inlining procedure: k5738 
o|inlining procedure: k5750 
o|inlining procedure: k5750 
o|inlining procedure: k5781 
o|inlining procedure: k5781 
o|contracted procedure: "(posixwin.scm:1514) bad-mmap?1438" 
o|inlining procedure: k5835 
o|inlining procedure: k5835 
o|contracted procedure: "(posixwin.scm:1513) mmap1437" 
o|contracted procedure: k5877 
o|inlining procedure: k5905 
o|inlining procedure: k5905 
o|contracted procedure: "(posixwin.scm:1523) munmap1475" 
o|inlining procedure: k6221 
o|inlining procedure: k6221 
o|inlining procedure: k6245 
o|inlining procedure: k6245 
o|inlining procedure: k6257 
o|inlining procedure: k6257 
o|inlining procedure: k6267 
o|inlining procedure: k6267 
o|inlining procedure: k6304 
o|inlining procedure: k6304 
o|contracted procedure: "(posix-common.scm:256) g116117" 
o|inlining procedure: k6291 
o|inlining procedure: k6291 
o|replaced variables: 640 
o|removed binding forms: 450 
o|substituted constant variable: r22966314 
o|substituted constant variable: r24196320 
o|substituted constant variable: r24316322 
o|substituted constant variable: r24436324 
o|substituted constant variable: r24076326 
o|substituted constant variable: r25766330 
o|inlining procedure: k2612 
o|substituted constant variable: r26266336 
o|inlining procedure: k2612 
o|inlining procedure: k2612 
o|propagated global variable: g3033046356 delete-file 
o|inlining procedure: k2827 
o|inlining procedure: k2827 
o|propagated global variable: r28286644 delete-file 
o|propagated global variable: r28286644 delete-file 
o|converted assignments to bindings: (rmdir286) 
o|substituted constant variable: loc338 
o|substituted constant variable: loc338 
o|substituted constant variable: loc356 
o|substituted constant variable: loc356 
o|substituted constant variable: r30446383 
o|substituted constant variable: r31466387 
o|substituted constant variable: r32336393 
o|substituted constant variable: r32336393 
o|substituted constant variable: r32416397 
o|substituted constant variable: r32416397 
o|substituted constant variable: loc444 
o|substituted constant variable: r36256431 
o|substituted constant variable: r36256431 
o|substituted constant variable: r36126438 
o|substituted constant variable: r36126438 
o|substituted constant variable: r37416444 
o|substituted constant variable: r41876475 
o|substituted constant variable: r41876475 
o|substituted constant variable: r42506484 
o|removed side-effect free assignment to unused variable: badmode830 
o|inlining procedure: k4295 
o|inlining procedure: k4335 
o|inlining procedure: k4687 
o|substituted constant variable: r47016532 
o|inlining procedure: k4687 
o|inlining procedure: k4687 
o|inlining procedure: k4774 
o|substituted constant variable: r48636543 
o|substituted constant variable: r49126551 
o|substituted constant variable: r49126551 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r49726563 
o|substituted constant variable: r51446571 
o|substituted constant variable: r51446571 
o|substituted constant variable: r54516590 
o|substituted constant variable: r54516590 
o|substituted constant variable: c-pointer12411258 
o|substituted constant variable: c-pointer12411258 
o|substituted constant variable: c-pointer12411258 
o|substituted constant variable: r54986593 
o|substituted constant variable: r54986593 
o|substituted constant variable: r54986595 
o|substituted constant variable: r54986595 
o|inlining procedure: k5855 
o|substituted constant variable: r58366611 
o|substituted constant variable: r58366611 
o|converted assignments to bindings: (check1009) 
o|substituted constant variable: r62586624 
o|substituted constant variable: r62926631 
o|substituted constant variable: r62926631 
o|simplifications: ((let . 2)) 
o|replaced variables: 42 
o|removed binding forms: 662 
o|removed conditional forms: 1 
o|inlining procedure: k3087 
o|inlining procedure: k3801 
o|inlining procedure: k3801 
o|inlining procedure: k4010 
o|inlining procedure: k4010 
o|inlining procedure: k4058 
o|inlining procedure: k4058 
o|contracted procedure: k5368 
o|inlining procedure: k5615 
o|inlining procedure: k5675 
o|inlining procedure: k5867 
o|inlining procedure: k5867 
o|replaced variables: 18 
o|removed binding forms: 111 
o|substituted constant variable: r26136633 
o|substituted constant variable: r26136635 
o|substituted constant variable: r26136637 
o|substituted constant variable: r30886733 
o|substituted constant variable: r30886733 
o|substituted constant variable: r38026748 
o|substituted constant variable: r40116753 
o|substituted constant variable: r40596755 
o|substituted constant variable: r46886700 
o|substituted constant variable: r46886702 
o|substituted constant variable: r46886704 
o|substituted constant variable: r5369 
o|substituted constant variable: r58686773 
o|inlining procedure: k6218 
o|inlining procedure: k6218 
o|simplifications: ((let . 3)) 
o|replaced variables: 2 
o|removed binding forms: 19 
o|removed conditional forms: 4 
o|inlining procedure: k4847 
o|inlining procedure: k4847 
o|substituted constant variable: a5367 
o|substituted constant variable: r62196809 
o|replaced variables: 1 
o|removed binding forms: 15 
o|substituted constant variable: r48486841 
o|removed binding forms: 4 
o|removed binding forms: 1 
o|simplifications: ((if . 56) (##core#call . 396)) 
o|  call simplifications:
o|    <
o|    ##sys#structure?
o|    ##sys#check-structure	2
o|    ##sys#make-structure	2
o|    +	2
o|    ##sys#foreign-pointer-argument	7
o|    ##sys#check-list	2
o|    ##sys#foreign-string-argument	5
o|    string-length
o|    char-whitespace?
o|    *
o|    fx>=	2
o|    string-set!
o|    bitwise-ior	2
o|    fxior	3
o|    list	5
o|    values	11
o|    ##sys#fudge
o|    vector-set!	2
o|    char=?
o|    ##sys#foreign-block-argument	2
o|    ##sys#foreign-integer-argument	4
o|    fx-	6
o|    ##sys#check-number	4
o|    ##sys#check-vector
o|    procedure?
o|    member
o|    fx+	8
o|    string-ref	3
o|    fx>
o|    cons	8
o|    ##sys#size	11
o|    ##sys#call-with-values	8
o|    not	5
o|    ##sys#check-string	19
o|    fx=	10
o|    zero?	2
o|    ##sys#null-pointer?	5
o|    pair?	14
o|    ##sys#check-exact	25
o|    ##sys#slot	16
o|    eq?	32
o|    cdr	20
o|    ##sys#eqv?	8
o|    null?	54
o|    car	35
o|    vector
o|    fixnum?	4
o|    string?
o|    fx<	13
o|    ##sys#foreign-fixnum-argument	12
o|    apply	9
o|contracted procedure: k2269 
o|contracted procedure: k2298 
o|contracted procedure: k2307 
o|contracted procedure: k2323 
o|contracted procedure: k2351 
o|contracted procedure: k2342 
o|contracted procedure: k2472 
o|contracted procedure: k2394 
o|contracted procedure: k2466 
o|contracted procedure: k2397 
o|contracted procedure: k2460 
o|contracted procedure: k2400 
o|contracted procedure: k2454 
o|contracted procedure: k2403 
o|contracted procedure: k2415 
o|contracted procedure: k2421 
o|contracted procedure: k2427 
o|contracted procedure: k2433 
o|contracted procedure: k2439 
o|contracted procedure: k2445 
o|contracted procedure: k2451 
o|contracted procedure: k2557 
o|contracted procedure: k2560 
o|contracted procedure: k2582 
o|contracted procedure: k2578 
o|contracted procedure: k2588 
o|contracted procedure: k2594 
o|contracted procedure: k2615 
o|contracted procedure: k2622 
o|contracted procedure: k2648 
o|contracted procedure: k2660 
o|contracted procedure: k2674 
o|contracted procedure: k2730 
o|contracted procedure: k2693 
o|contracted procedure: k2722 
o|contracted procedure: k2712 
o|contracted procedure: k2736 
o|contracted procedure: k2745 
o|contracted procedure: k2751 
o|contracted procedure: k2754 
o|contracted procedure: k2757 
o|contracted procedure: k2788 
o|contracted procedure: k2763 
o|contracted procedure: k2874 
o|contracted procedure: k2797 
o|contracted procedure: k2809 
o|contracted procedure: k2816 
o|contracted procedure: k2854 
o|contracted procedure: k2864 
o|contracted procedure: k2868 
o|contracted procedure: k2991 
o|contracted procedure: k2883 
o|contracted procedure: k2886 
o|contracted procedure: k2988 
o|contracted procedure: k2892 
o|contracted procedure: k2925 
o|contracted procedure: k2970 
o|contracted procedure: k3121 
o|contracted procedure: k3003 
o|contracted procedure: k3115 
o|contracted procedure: k3006 
o|contracted procedure: k3109 
o|contracted procedure: k3009 
o|contracted procedure: k3012 
o|contracted procedure: k3031 
o|contracted procedure: k3046 
o|contracted procedure: k3050 
o|contracted procedure: k3056 
o|contracted procedure: k3102 
o|contracted procedure: k3059 
o|contracted procedure: k3078 
o|contracted procedure: k3081 
o|contracted procedure: k3096 
o|contracted procedure: k3087 
o|contracted procedure: k3127 
o|contracted procedure: k3148 
o|contracted procedure: k3151 
o|contracted procedure: k3182 
o|contracted procedure: k3189 
o|contracted procedure: k3212 
o|contracted procedure: k3228 
o|contracted procedure: k3246 
o|contracted procedure: k3268 
o|contracted procedure: k3271 
o|contracted procedure: k3277 
o|contracted procedure: k3289 
o|contracted procedure: k3298 
o|contracted procedure: k3324 
o|contracted procedure: k3395 
o|contracted procedure: k3414 
o|contracted procedure: k3478 
o|contracted procedure: k3491 
o|contracted procedure: k3484 
o|contracted procedure: k3500 
o|contracted procedure: k3506 
o|contracted procedure: k3521 
o|contracted procedure: k3527 
o|contracted procedure: k3552 
o|contracted procedure: k3569 
o|contracted procedure: k3565 
o|contracted procedure: k3544 
o|contracted procedure: k3575 
o|contracted procedure: k3685 
o|contracted procedure: k3632 
o|contracted procedure: k3641 
o|contracted procedure: k3624 
o|contracted procedure: k3675 
o|contracted procedure: k3671 
o|contracted procedure: k3611 
o|contracted procedure: k3694 
o|contracted procedure: k3697 
o|contracted procedure: k3711 
o|contracted procedure: k3752 
o|contracted procedure: k3759 
o|contracted procedure: k3767 
o|contracted procedure: k3779 
o|contracted procedure: k3783 
o|contracted procedure: k3790 
o|contracted procedure: k3726 
o|contracted procedure: k3797 
o|contracted procedure: k3880 
o|contracted procedure: k3820 
o|contracted procedure: k3874 
o|contracted procedure: k3823 
o|contracted procedure: k3868 
o|contracted procedure: k3826 
o|contracted procedure: k3862 
o|contracted procedure: k3829 
o|contracted procedure: k3832 
o|contracted procedure: k3835 
o|contracted procedure: k3853 
o|contracted procedure: k6196 
o|contracted procedure: k3912 
o|contracted procedure: k3920 
o|contracted procedure: k3923 
o|contracted procedure: k3926 
o|contracted procedure: k3936 
o|contracted procedure: k3945 
o|contracted procedure: k3952 
o|contracted procedure: k3964 
o|contracted procedure: k3970 
o|contracted procedure: k3983 
o|contracted procedure: k3986 
o|contracted procedure: k4001 
o|contracted procedure: k4016 
o|contracted procedure: k4027 
o|contracted procedure: k4036 
o|contracted procedure: k4042 
o|contracted procedure: k4051 
o|contracted procedure: k4067 
o|contracted procedure: k4070 
o|contracted procedure: k4079 
o|contracted procedure: k4102 
o|contracted procedure: k4106 
o|contracted procedure: k4112 
o|contracted procedure: k4118 
o|contracted procedure: k4125 
o|contracted procedure: k4135 
o|contracted procedure: k4144 
o|contracted procedure: k4147 
o|contracted procedure: k4154 
o|contracted procedure: k4172 
o|contracted procedure: k4190 
o|contracted procedure: k4206 
o|contracted procedure: k4212 
o|contracted procedure: k4219 
o|contracted procedure: k4227 
o|contracted procedure: k4236 
o|contracted procedure: k4252 
o|contracted procedure: k4273 
o|contracted procedure: k4285 
o|contracted procedure: k4298 
o|contracted procedure: k4308 
o|contracted procedure: k4325 
o|contracted procedure: k4338 
o|contracted procedure: k4348 
o|contracted procedure: k4374 
o|contracted procedure: k4392 
o|contracted procedure: k4536 
o|contracted procedure: k4517 
o|contracted procedure: k4526 
o|contracted procedure: k4572 
o|contracted procedure: k4616 
o|contracted procedure: k4619 
o|contracted procedure: k4625 
o|contracted procedure: k4642 
o|contracted procedure: k4645 
o|contracted procedure: k4690 
o|contracted procedure: k4697 
o|contracted procedure: k4726 
o|contracted procedure: k4738 
o|contracted procedure: k4752 
o|contracted procedure: k4790 
o|contracted procedure: k4777 
o|contracted procedure: k4800 
o|contracted procedure: k4809 
o|contracted procedure: k4818 
o|contracted procedure: k4821 
o|contracted procedure: k4824 
o|contracted procedure: k4850 
o|contracted procedure: k48386840 
o|contracted procedure: k48386845 
o|contracted procedure: k4869 
o|contracted procedure: k4898 
o|contracted procedure: k4918 
o|contracted procedure: k4914 
o|contracted procedure: k4921 
o|contracted procedure: k4927 
o|contracted procedure: k4933 
o|contracted procedure: k4945 
o|contracted procedure: k5003 
o|contracted procedure: k5009 
o|inlining procedure: k5018 
o|inlining procedure: k5018 
o|contracted procedure: k4962 
o|contracted procedure: k4974 
o|contracted procedure: k4991 
o|contracted procedure: k4980 
o|contracted procedure: k4987 
o|contracted procedure: k5035 
o|contracted procedure: k5043 
o|contracted procedure: k5050 
o|contracted procedure: k5056 
o|contracted procedure: k5064 
o|contracted procedure: k5071 
o|contracted procedure: k5079 
o|contracted procedure: k5091 
o|contracted procedure: k5097 
o|contracted procedure: k5100 
o|contracted procedure: k5112 
o|contracted procedure: k5116 
o|contracted procedure: k5124 
o|contracted procedure: k5150 
o|contracted procedure: k5162 
o|contracted procedure: k5229 
o|contracted procedure: k5171 
o|contracted procedure: k5223 
o|contracted procedure: k5174 
o|contracted procedure: k5217 
o|contracted procedure: k5177 
o|contracted procedure: k5211 
o|contracted procedure: k5180 
o|contracted procedure: k5205 
o|contracted procedure: k5183 
o|contracted procedure: k5199 
o|contracted procedure: k5186 
o|contracted procedure: k5296 
o|contracted procedure: k5238 
o|contracted procedure: k5290 
o|contracted procedure: k5241 
o|contracted procedure: k5284 
o|contracted procedure: k5244 
o|contracted procedure: k5278 
o|contracted procedure: k5247 
o|contracted procedure: k5272 
o|contracted procedure: k5250 
o|contracted procedure: k5266 
o|contracted procedure: k5253 
o|contracted procedure: k5352 
o|contracted procedure: k5508 
o|contracted procedure: k5422 
o|contracted procedure: k5372 
o|contracted procedure: k5376 
o|contracted procedure: k5380 
o|contracted procedure: k5384 
o|contracted procedure: k5388 
o|contracted procedure: k5410 
o|contracted procedure: k5417 
o|contracted procedure: k5489 
o|contracted procedure: k5493 
o|contracted procedure: k5505 
o|contracted procedure: k5518 
o|contracted procedure: k5535 
o|contracted procedure: k5545 
o|contracted procedure: k5549 
o|contracted procedure: k5552 
o|contracted procedure: k5651 
o|contracted procedure: k5600 
o|contracted procedure: k5645 
o|contracted procedure: k5603 
o|contracted procedure: k5639 
o|contracted procedure: k5606 
o|contracted procedure: k5633 
o|contracted procedure: k5609 
o|contracted procedure: k5627 
o|contracted procedure: k5612 
o|contracted procedure: k5621 
o|contracted procedure: k5615 
o|contracted procedure: k5711 
o|contracted procedure: k5660 
o|contracted procedure: k5705 
o|contracted procedure: k5663 
o|contracted procedure: k5699 
o|contracted procedure: k5666 
o|contracted procedure: k5693 
o|contracted procedure: k5669 
o|contracted procedure: k5687 
o|contracted procedure: k5672 
o|contracted procedure: k5681 
o|contracted procedure: k5675 
o|contracted procedure: k5732 
o|contracted procedure: k5835 
o|contracted procedure: k5806 
o|contracted procedure: k5810 
o|contracted procedure: k5814 
o|contracted procedure: k5818 
o|contracted procedure: k5822 
o|contracted procedure: k5826 
o|contracted procedure: k5873 
o|contracted procedure: k5899 
o|contracted procedure: k5908 
o|contracted procedure: k5919 
o|contracted procedure: k5887 
o|contracted procedure: k5891 
o|contracted procedure: k5922 
o|contracted procedure: k5932 
o|contracted procedure: k6202 
o|contracted procedure: k6227 
o|contracted procedure: k6211 
o|contracted procedure: k6214 
o|contracted procedure: k6236 
o|contracted procedure: k6248 
o|contracted procedure: k6264 
o|contracted procedure: k6260 
o|contracted procedure: k6270 
o|contracted procedure: k6285 
o|contracted procedure: k6307 
o|contracted procedure: k6298 
o|simplifications: ((if . 1) (let . 63)) 
o|removed binding forms: 326 
o|inlining procedure: k3497 
o|inlining procedure: k3518 
o|inlining procedure: "(posixwin.scm:842) mode829" 
o|inlining procedure: "(posixwin.scm:852) mode829" 
o|inlining procedure: k5039 
o|inlining procedure: k5060 
o|replaced variables: 189 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: mode829 
o|substituted constant variable: r50407057 
o|substituted constant variable: r50407057 
o|substituted constant variable: r50617060 
o|substituted constant variable: r50617060 
o|replaced variables: 10 
o|removed binding forms: 91 
o|contracted procedure: k5852 
o|contracted procedure: k5915 
o|converted assignments to bindings: (check831) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 14 
o|contracted procedure: k4288 
o|contracted procedure: k4328 
o|replaced variables: 2 
o|removed binding forms: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: loop1114 0 
o|direct leaf routine/allocation: g13451352 0 
o|contracted procedure: k5025 
o|converted assignments to bindings: (loop1114) 
o|contracted procedure: "(posixwin.scm:1306) k5538" 
o|simplifications: ((let . 1)) 
o|removed binding forms: 2 
o|replaced variables: 3 
o|removed binding forms: 1 
o|direct leaf routine/allocation: for-each-loop13441362 0 
o|converted assignments to bindings: (for-each-loop13441362) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (k5902 k5846 k5861 %process1333 chkstrlst1340 k5332 $exec-setup $exec-teardown $quote-args-list build-exec-argvec1129 doloop11541155 loop1121 k4892 k4904 k4803 mode1025 check1026 check1009 check831 k4199 loop801 suffix-loop814 loop812 k4033 k3917 scan640 loop637 check-time-vector k3249 k3252 loop456 g428429 loop420 conc-loop401 k3065 loop380 k2914 loop333 g293300 for-each-loop292309 rmdir286 k2739 mode206 check207 k2554 ##sys#stat) 
o|calls to known targets: 169 
o|unused rest argument: _452 f_3417 
o|unused rest argument: _451 f_3409 
o|unused rest argument: _493 f_3469 
o|identified direct recursive calls: f_3747 1 
o|identified direct recursive calls: f_4969 1 
o|identified direct recursive calls: f_4998 1 
o|identified direct recursive calls: f_5530 1 
o|unused rest argument: _15231527 f_5945 
o|unused rest argument: _15301534 f_5951 
o|unused rest argument: _15361540 f_5957 
o|unused rest argument: _15421546 f_5963 
o|unused rest argument: _15481552 f_5969 
o|unused rest argument: _15541558 f_5975 
o|unused rest argument: _15601564 f_5981 
o|unused rest argument: _15661570 f_5987 
o|unused rest argument: _15721576 f_5993 
o|unused rest argument: _15781582 f_5999 
o|unused rest argument: _15841588 f_6005 
o|unused rest argument: _15901594 f_6011 
o|unused rest argument: _15961600 f_6017 
o|unused rest argument: _16021606 f_6023 
o|unused rest argument: _16081612 f_6029 
o|unused rest argument: _16141618 f_6035 
o|unused rest argument: _16201624 f_6041 
o|unused rest argument: _16261630 f_6047 
o|unused rest argument: _16321636 f_6053 
o|unused rest argument: _16381642 f_6059 
o|unused rest argument: _16441648 f_6065 
o|unused rest argument: _16501654 f_6071 
o|unused rest argument: _16561660 f_6077 
o|unused rest argument: _16621666 f_6083 
o|unused rest argument: _16681672 f_6089 
o|unused rest argument: _16741678 f_6095 
o|unused rest argument: _16801684 f_6101 
o|unused rest argument: _16861690 f_6107 
o|unused rest argument: _16921696 f_6113 
o|unused rest argument: _16981702 f_6119 
o|unused rest argument: _17041708 f_6125 
o|unused rest argument: _17101714 f_6131 
o|unused rest argument: _17161720 f_6137 
o|unused rest argument: _17221726 f_6143 
o|unused rest argument: _17281732 f_6149 
o|unused rest argument: _17341738 f_6155 
o|unused rest argument: _17401744 f_6161 
o|unused rest argument: _17461750 f_6167 
o|unused rest argument: _17521756 f_6173 
o|unused rest argument: _17581762 f_6179 
o|fast box initializations: 18 
o|fast global references: 76 
o|fast global assignments: 7 
o|dropping unused closure argument: f_2290 
o|dropping unused closure argument: f_2801 
o|dropping unused closure argument: f_4640 
o|dropping unused closure argument: f_3476 
o|dropping unused closure argument: f_4681 
o|dropping unused closure argument: f_2643 
o|dropping unused closure argument: f_5154 
o|dropping unused closure argument: f_5514 
o|dropping unused closure argument: f_4955 
o|dropping unused closure argument: f_2606 
o|dropping unused closure argument: f_4265 
o|dropping unused closure argument: f_4718 
o|dropping unused closure argument: f_5074 
*/
/* end of file */
