/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

class XATrace
{
    static Hashtable filewriters;
    static Hashtable xacodes;
    private PrintWriter destination;
    
    XATrace(String fileName)
        throws IOException
    {
        destination=getFileWriter(fileName);
    }

    XATrace(PrintWriter destination)
    {
        this.destination=destination;
    }
    
    void trace(Xid xid, String message)
    {
        String time=new java.sql.Timestamp(System.currentTimeMillis()).toString();
        String threadname=Thread.currentThread().getName();
        String xidString= xid==null ? "(null)" : xid.toString();
        StringBuffer sb=new StringBuffer(time);
        sb.append(" ");
        sb.append(threadname);
        sb.append(" ");
        sb.append(xidString);
        sb.append(" ");
        sb.append(message);
        synchronized(destination) {
            destination.println(sb.toString());
        }
        return;
    }

    void trace(String message)
    {
        String time=new java.sql.Timestamp(System.currentTimeMillis()).toString();
        String threadname=Thread.currentThread().getName();
        String xidString= "(none)";
        StringBuffer sb=new StringBuffer(time);
        sb.append(" ");
        sb.append(threadname);
        sb.append(" ");
        sb.append(xidString);
        sb.append(" ");
        sb.append(message);
        synchronized(destination) {
            destination.println(sb.toString());
        }
        return;
    }
    
    void traceXAError(Xid xid, int code)
    {
        trace(xid, "XA Error: " + xacodes.get(new Integer(code)));
    }

    static PrintWriter getFileWriter(String name)
        throws IOException
    {
        synchronized(filewriters) {
            Object o=filewriters.get(name);
            if(o==null) {
                FileOutputStream output=new FileOutputStream(name);
                o=new PrintWriter(output, true);
                filewriters.put(name, o);
            }
            return (PrintWriter)o;
        }
    }
    
    static {
        filewriters=new Hashtable();

        xacodes=new Hashtable();
        xacodes.put(new Integer(XAException.XAER_INVAL), "XAER_INVAL");
        xacodes.put(new Integer(XAException.XA_HEURCOM), "XA_HEURCOM");
        xacodes.put(new Integer(XAException.XA_HEURHAZ), "XA_HEURHAZ");
        xacodes.put(new Integer(XAException.XA_HEURMIX), "XA_HEURMIX");
        xacodes.put(new Integer(XAException.XA_HEURRB), "XA_HEURRB");
        xacodes.put(new Integer(XAException.XA_NOMIGRATE), "XA_NOMIGRATE");
        xacodes.put(new Integer(XAException.XA_RBBASE), "XA_RBBASE");
        xacodes.put(new Integer(XAException.XA_RBCOMMFAIL), "XA_RBCOMMFAIL");
        xacodes.put(new Integer(XAException.XA_RBDEADLOCK), "XA_RBDEADLOCK");
        xacodes.put(new Integer(XAException.XA_RBEND), "XA_RBEND");
        xacodes.put(new Integer(XAException.XA_RBINTEGRITY), "XA_RBINTEGRITY");
        xacodes.put(new Integer(XAException.XA_RBOTHER), "XA_RBOTHER");
        xacodes.put(new Integer(XAException.XA_RBPROTO), "XA_RBPROTO");
        xacodes.put(new Integer(XAException.XA_RBROLLBACK), "XA_RBROLLBACK");
        xacodes.put(new Integer(XAException.XA_RBTIMEOUT), "XA_RBTIMEOUT");
        xacodes.put(new Integer(XAException.XA_RBTRANSIENT), "XA_RBTRANSIENT");
        xacodes.put(new Integer(XAException.XA_RDONLY), "XA_RDONLY");
        xacodes.put(new Integer(XAException.XA_RETRY), "XA_RETRY");
        xacodes.put(new Integer(XAException.XAER_ASYNC), "XAER_ASYNC");
        xacodes.put(new Integer(XAException.XAER_DUPID), "XAER_DUPID");
        xacodes.put(new Integer(XAException.XAER_INVAL), "XAER_INVAL");
        xacodes.put(new Integer(XAException.XAER_NOTA), "XAER_NOTA");
        xacodes.put(new Integer(XAException.XAER_PROTO), "XAER_PROTO");
        xacodes.put(new Integer(XAException.XAER_RMERR), "XAER_RMERR");
        xacodes.put(new Integer(XAException.XAER_RMFAIL), "XAER_RMFAIL");
    }
}
