/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.LocalException;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBase;
import com.zeroc.IceInternal.QueueExecutorService;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RequestHandler;
import com.zeroc.IceInternal.RetryException;
import java.util.concurrent.Callable;

public class QueueRequestHandler
implements RequestHandler {
    private final RequestHandler _delegate;
    private final QueueExecutorService _executor;

    public QueueRequestHandler(Instance instance, RequestHandler delegate) {
        this._executor = instance.getQueueExecutor();
        assert (delegate != null);
        this._delegate = delegate;
    }

    @Override
    public RequestHandler update(RequestHandler previousHandler, RequestHandler newHandler) {
        try {
            if (previousHandler == this || previousHandler == this._delegate) {
                return newHandler;
            }
            if (previousHandler.getConnection() == this._delegate.getConnection()) {
                return newHandler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int sendAsyncRequest(final ProxyOutgoingAsyncBase out) throws RetryException {
        return this._executor.execute(new Callable<Integer>(){

            @Override
            public Integer call() throws RetryException {
                return QueueRequestHandler.this._delegate.sendAsyncRequest(out);
            }
        });
    }

    @Override
    public void asyncRequestCanceled(final OutgoingAsyncBase outAsync, final LocalException ex) {
        this._executor.executeNoThrow(new Callable<Void>(){

            @Override
            public Void call() {
                QueueRequestHandler.this._delegate.asyncRequestCanceled(outAsync, ex);
                return null;
            }
        });
    }

    @Override
    public Reference getReference() {
        return this._delegate.getReference();
    }

    @Override
    public ConnectionI getConnection() {
        return this._delegate.getConnection();
    }
}

