/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.Stamps;

final class Clusters
implements Stamps.Updater {
    private static String[] dirs;
    private static String dirPrefix;
    private static final Clusters INSTANCE;

    private Clusters() {
    }

    static void scheduleSave(Stamps stamps) {
        stamps.scheduleSaveImpl(INSTANCE, "all-clusters.dat", false);
    }

    static boolean compareDirs(DataInputStream dataInputStream) throws IOException {
        String[] stringArray;
        int n = dataInputStream.readInt();
        if (n != (stringArray = Clusters.relativeDirsWithHome()).length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = dataInputStream.readUTF();
            if (string.equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    static synchronized String[] dirs() {
        if (dirs == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = System.getProperty("netbeans.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            dirs = arrayList.toArray(new String[0]);
        }
        return dirs;
    }

    static int findCommonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != string2.charAt(i)) {
                return n2;
            }
            if (c != '/' && c != File.separatorChar) continue;
            n2 = i + 1;
        }
        return n;
    }

    static synchronized String dirPrefix() {
        if (dirPrefix == null) {
            String string = System.getProperty("netbeans.home");
            for (String string2 : Clusters.dirs()) {
                if (string == null) {
                    string = string2;
                    continue;
                }
                int n = Clusters.findCommonPrefix(string, string2);
                if (n <= 3) {
                    string = "";
                    break;
                }
                string = string.substring(0, n);
            }
            dirPrefix = string == null ? "" : string;
        }
        return dirPrefix;
    }

    static String[] relativeDirsWithHome() {
        String[] stringArray = Clusters.dirs();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = System.getProperty("netbeans.home", "");
        if (stringArray2[0].length() >= Clusters.dirPrefix().length()) {
            stringArray2[0] = stringArray2[0].substring(Clusters.dirPrefix().length());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i].substring(Clusters.dirPrefix().length()).replace(File.separatorChar, '/');
        }
        return stringArray2;
    }

    static synchronized void clear() {
        dirs = null;
        dirPrefix = null;
    }

    @Override
    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        String[] stringArray = Clusters.relativeDirsWithHome();
        dataOutputStream.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
        }
    }

    @Override
    public void cacheReady() {
    }

    static {
        INSTANCE = new Clusters();
    }
}

