/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.Compression;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.KnownHosts;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.PortWatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserAuthNone;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Session
implements Runnable {
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEXINIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    private static final int PACKET_MAX_SIZE = 262144;
    private byte[] V_S;
    private byte[] V_C = Util.str2byte("SSH-2.0-JSCH-0.1.53");
    private byte[] I_C;
    private byte[] I_S;
    private byte[] K_S;
    private byte[] session_id;
    private byte[] IVc2s;
    private byte[] IVs2c;
    private byte[] Ec2s;
    private byte[] Es2c;
    private byte[] MACc2s;
    private byte[] MACs2c;
    private int seqi = 0;
    private int seqo = 0;
    String[] guess = null;
    private Cipher s2ccipher;
    private Cipher c2scipher;
    private MAC s2cmac;
    private MAC c2smac;
    private byte[] s2cmac_result1;
    private byte[] s2cmac_result2;
    private Compression deflater;
    private Compression inflater;
    private IO io;
    private Socket socket;
    private int timeout = 0;
    private volatile boolean isConnected = false;
    private boolean isAuthed = false;
    private Thread connectThread = null;
    private Object lock = new Object();
    boolean x11_forwarding = false;
    boolean agent_forwarding = false;
    InputStream in = null;
    OutputStream out = null;
    static Random random;
    Buffer buf;
    Packet packet;
    SocketFactory socket_factory = null;
    static final int buffer_margin = 84;
    private Hashtable config = null;
    private Proxy proxy = null;
    private UserInfo userinfo;
    private String hostKeyAlias = null;
    private int serverAliveInterval = 0;
    private int serverAliveCountMax = 1;
    private IdentityRepository identityRepository = null;
    private HostKeyRepository hostkeyRepository = null;
    protected boolean daemon_thread = false;
    private long kex_start_time = 0L;
    int max_auth_tries = 6;
    int auth_failures = 0;
    String host = "127.0.0.1";
    String org_host = "127.0.0.1";
    int port = 22;
    String username = null;
    byte[] password = null;
    JSch jsch;
    private volatile boolean in_kex = false;
    int[] uncompress_len = new int[1];
    int[] compress_len = new int[1];
    private int s2ccipher_size = 8;
    private int c2scipher_size = 8;
    Runnable thread;
    private GlobalRequestReply grr = new GlobalRequestReply();
    private static final byte[] keepalivemsg;
    private static final byte[] nomoresessions;
    private HostKey hostkey = null;

    Session(JSch jSch, String string, String string2, int n) throws JSchException {
        this.jsch = jSch;
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        this.username = string;
        this.org_host = this.host = string2;
        this.port = n;
        this.applyConfig();
        if (this.username == null) {
            try {
                this.username = (String)System.getProperties().get("user.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.username == null) {
            throw new JSchException("username is not given.");
        }
    }

    public void connect() throws JSchException {
        this.connect(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int n) throws JSchException {
        if (this.isConnected) {
            throw new JSchException("session is already connected");
        }
        this.io = new IO();
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(this.getConfig("random"));
                random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
        Packet.setRandom(random);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "Connecting to " + this.host + " port " + this.port);
        }
        try {
            Object object;
            Object object2;
            int n2;
            Object object3;
            if (this.proxy == null) {
                OutputStream outputStream;
                if (this.socket_factory == null) {
                    this.socket = Util.createSocket(this.host, this.port, n);
                    object3 = this.socket.getInputStream();
                    outputStream = this.socket.getOutputStream();
                } else {
                    this.socket = this.socket_factory.createSocket(this.host, this.port);
                    object3 = this.socket_factory.getInputStream(this.socket);
                    outputStream = this.socket_factory.getOutputStream(this.socket);
                }
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream((InputStream)object3);
                this.io.setOutputStream(outputStream);
            } else {
                object3 = this.proxy;
                synchronized (object3) {
                    this.proxy.connect(this.socket_factory, this.host, this.port, n);
                    this.io.setInputStream(this.proxy.getInputStream());
                    this.io.setOutputStream(this.proxy.getOutputStream());
                    this.socket = this.proxy.getSocket();
                }
            }
            if (n > 0 && this.socket != null) {
                this.socket.setSoTimeout(n);
            }
            this.isConnected = true;
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "Connection established");
            }
            this.jsch.addSession(this);
            object3 = new byte[this.V_C.length + 1];
            System.arraycopy(this.V_C, 0, object3, 0, this.V_C.length);
            object3[((Object)object3).length - 1] = 10;
            this.io.put((byte[])object3, 0, ((Object)object3).length);
            do {
                int n3 = 0;
                for (n2 = 0; n2 < this.buf.buffer.length && (n3 = this.io.getByte()) >= 0; ++n2) {
                    this.buf.buffer[n2] = (byte)n3;
                    if (n3 != 10) continue;
                }
                if (n3 < 0) {
                    throw new JSchException("connection is closed by foreign host");
                }
                if (this.buf.buffer[n2 - 1] != 10 || --n2 <= 0 || this.buf.buffer[n2 - 1] != 13) continue;
                --n2;
            } while (n2 <= 3 || n2 != this.buf.buffer.length && (this.buf.buffer[0] != 83 || this.buf.buffer[1] != 83 || this.buf.buffer[2] != 72 || this.buf.buffer[3] != 45));
            if (n2 == this.buf.buffer.length || n2 < 7 || this.buf.buffer[4] == 49 && this.buf.buffer[6] != 57) {
                throw new JSchException("invalid server's version string");
            }
            this.V_S = new byte[n2];
            System.arraycopy(this.buf.buffer, 0, this.V_S, 0, n2);
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "Remote version string: " + Util.byte2str(this.V_S));
                JSch.getLogger().log(1, "Local version string: " + Util.byte2str(this.V_C));
            }
            this.send_kexinit();
            this.buf = this.read(this.buf);
            if (this.buf.getCommand() != 20) {
                this.in_kex = false;
                throw new JSchException("invalid protocol: " + this.buf.getCommand());
            }
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "SSH_MSG_KEXINIT received");
            }
            object3 = this.receive_kexinit(this.buf);
            do {
                this.buf = this.read(this.buf);
                if (((KeyExchange)object3).getState() == this.buf.getCommand()) {
                    this.kex_start_time = System.currentTimeMillis();
                    boolean bl = ((KeyExchange)object3).next(this.buf);
                    if (bl) continue;
                    this.in_kex = false;
                    throw new JSchException("verify: " + bl);
                }
                this.in_kex = false;
                throw new JSchException("invalid protocol(kex): " + this.buf.getCommand());
            } while (((KeyExchange)object3).getState() != 0);
            try {
                this.checkHost(this.host, this.port, (KeyExchange)object3);
            }
            catch (JSchException jSchException) {
                this.in_kex = false;
                throw jSchException;
            }
            this.send_newkeys();
            this.buf = this.read(this.buf);
            if (this.buf.getCommand() == 21) {
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "SSH_MSG_NEWKEYS received");
                }
            } else {
                this.in_kex = false;
                throw new JSchException("invalid protocol(newkyes): " + this.buf.getCommand());
            }
            this.receive_newkeys(this.buf, (KeyExchange)object3);
            try {
                String string = this.getConfig("MaxAuthTries");
                if (string != null) {
                    this.max_auth_tries = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new JSchException("MaxAuthTries: " + this.getConfig("MaxAuthTries"), numberFormatException);
            }
            boolean bl = false;
            boolean bl2 = false;
            UserAuth userAuth = null;
            try {
                object2 = Class.forName(this.getConfig("userauth.none"));
                userAuth = (UserAuth)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
            bl = userAuth.start(this);
            object2 = this.getConfig("PreferredAuthentications");
            String[] stringArray = Util.split((String)object2, ",");
            Object object4 = null;
            if (!bl) {
                object4 = ((UserAuthNone)userAuth).getMethods();
                object4 = object4 != null ? ((String)object4).toLowerCase() : object2;
            }
            String[] stringArray2 = Util.split(object4, ",");
            int n4 = 0;
            while (!bl && stringArray != null && n4 < stringArray.length) {
                block69: {
                    object = stringArray[n4++];
                    boolean bl3 = false;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!stringArray2[i].equals(object)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) continue;
                    if (JSch.getLogger().isEnabled(1)) {
                        String string = "Authentications that can continue: ";
                        for (int i = n4 - 1; i < stringArray.length; ++i) {
                            string = string + stringArray[i];
                            if (i + 1 >= stringArray.length) continue;
                            string = string + ",";
                        }
                        JSch.getLogger().log(1, string);
                        JSch.getLogger().log(1, "Next authentication method: " + (String)object);
                    }
                    userAuth = null;
                    try {
                        Class<?> clazz = null;
                        if (this.getConfig("userauth." + (String)object) != null) {
                            clazz = Class.forName(this.getConfig("userauth." + (String)object));
                            userAuth = (UserAuth)clazz.newInstance();
                        }
                    }
                    catch (Exception exception) {
                        if (!JSch.getLogger().isEnabled(2)) break block69;
                        JSch.getLogger().log(2, "failed to load " + (String)object + " method");
                    }
                }
                if (userAuth == null) continue;
                bl2 = false;
                try {
                    bl = userAuth.start(this);
                    if (!bl || !JSch.getLogger().isEnabled(1)) continue;
                    JSch.getLogger().log(1, "Authentication succeeded (" + (String)object + ").");
                }
                catch (JSchAuthCancelException jSchAuthCancelException) {
                    bl2 = true;
                }
                catch (JSchPartialAuthException jSchPartialAuthException) {
                    Object object5 = object4;
                    object4 = jSchPartialAuthException.getMethods();
                    stringArray2 = Util.split((String)object4, ",");
                    if (!((String)object5).equals(object4)) {
                        n4 = 0;
                    }
                    bl2 = false;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (JSchException jSchException) {
                    throw jSchException;
                }
                catch (Exception exception) {
                    if (!JSch.getLogger().isEnabled(2)) break;
                    JSch.getLogger().log(2, "an exception during authentication\n" + exception.toString());
                    break;
                }
            }
            if (!bl) {
                if (this.auth_failures >= this.max_auth_tries && JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "Login trials exceeds " + this.max_auth_tries);
                }
                if (bl2) {
                    throw new JSchException("Auth cancel");
                }
                throw new JSchException("Auth fail");
            }
            if (this.socket != null && (n > 0 || this.timeout > 0)) {
                this.socket.setSoTimeout(this.timeout);
            }
            this.isAuthed = true;
            object = this.lock;
            synchronized (object) {
                if (this.isConnected) {
                    this.connectThread = new Thread(this);
                    this.connectThread.setName("Connect thread " + this.host + " session");
                    if (this.daemon_thread) {
                        this.connectThread.setDaemon(this.daemon_thread);
                    }
                    this.connectThread.start();
                    this.requestPortForwarding();
                }
            }
        }
        catch (Exception exception) {
            this.in_kex = false;
            try {
                if (this.isConnected) {
                    String string = exception.toString();
                    this.packet.reset();
                    this.buf.checkFreeSize(13 + string.length() + 2 + 84);
                    this.buf.putByte((byte)1);
                    this.buf.putInt(3);
                    this.buf.putString(Util.str2byte(string));
                    this.buf.putString(Util.str2byte("en"));
                    this.write(this.packet);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                this.disconnect();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            this.isConnected = false;
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException("Session.connect: " + exception);
        }
        finally {
            Util.bzero(this.password);
            this.password = null;
        }
    }

    private KeyExchange receive_kexinit(Buffer buffer) throws Exception {
        int n = buffer.getInt();
        if (n != buffer.getLength()) {
            buffer.getByte();
            this.I_S = new byte[buffer.index - 5];
        } else {
            this.I_S = new byte[n - 1 - buffer.getByte()];
        }
        System.arraycopy(buffer.buffer, buffer.s, this.I_S, 0, this.I_S.length);
        if (!this.in_kex) {
            this.send_kexinit();
        }
        this.guess = KeyExchange.guess(this.I_S, this.I_C);
        if (this.guess == null) {
            throw new JSchException("Algorithm negotiation fail");
        }
        if (!this.isAuthed && (this.guess[2].equals("none") || this.guess[3].equals("none"))) {
            throw new JSchException("NONE Cipher should not be chosen before authentification is successed.");
        }
        KeyExchange keyExchange = null;
        try {
            Class<?> clazz = Class.forName(this.getConfig(this.guess[0]));
            keyExchange = (KeyExchange)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSchException(exception.toString(), exception);
        }
        keyExchange.init(this, this.V_S, this.V_C, this.I_S, this.I_C);
        return keyExchange;
    }

    public void rekey() throws Exception {
        this.send_kexinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_kexinit() throws Exception {
        if (this.in_kex) {
            return;
        }
        String string = this.getConfig("cipher.c2s");
        String string2 = this.getConfig("cipher.s2c");
        String[] stringArray = this.checkCiphers(this.getConfig("CheckCiphers"));
        if (stringArray != null && stringArray.length > 0) {
            string = Util.diffString(string, stringArray);
            string2 = Util.diffString(string2, stringArray);
            if (string == null || string2 == null) {
                throw new JSchException("There are not any available ciphers.");
            }
        }
        String string3 = this.getConfig("kex");
        String[] stringArray2 = this.checkKexes(this.getConfig("CheckKexes"));
        if (stringArray2 != null && stringArray2.length > 0 && (string3 = Util.diffString(string3, stringArray2)) == null) {
            throw new JSchException("There are not any available kexes.");
        }
        String string4 = this.getConfig("server_host_key");
        String[] stringArray3 = this.checkSignatures(this.getConfig("CheckSignatures"));
        if (stringArray3 != null && stringArray3.length > 0 && (string4 = Util.diffString(string4, stringArray3)) == null) {
            throw new JSchException("There are not any available sig algorithm.");
        }
        this.in_kex = true;
        this.kex_start_time = System.currentTimeMillis();
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)20);
        Random random = Session.random;
        synchronized (random) {
            Session.random.fill(buffer.buffer, buffer.index, 16);
            buffer.skip(16);
        }
        buffer.putString(Util.str2byte(string3));
        buffer.putString(Util.str2byte(string4));
        buffer.putString(Util.str2byte(string));
        buffer.putString(Util.str2byte(string2));
        buffer.putString(Util.str2byte(this.getConfig("mac.c2s")));
        buffer.putString(Util.str2byte(this.getConfig("mac.s2c")));
        buffer.putString(Util.str2byte(this.getConfig("compression.c2s")));
        buffer.putString(Util.str2byte(this.getConfig("compression.s2c")));
        buffer.putString(Util.str2byte(this.getConfig("lang.c2s")));
        buffer.putString(Util.str2byte(this.getConfig("lang.s2c")));
        buffer.putByte((byte)0);
        buffer.putInt(0);
        buffer.setOffSet(5);
        this.I_C = new byte[buffer.getLength()];
        buffer.getByte(this.I_C);
        this.write(packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEXINIT sent");
        }
    }

    private void send_newkeys() throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)21);
        this.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_NEWKEYS sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHost(String string, int n, KeyExchange keyExchange) throws JSchException {
        String string2 = this.getConfig("StrictHostKeyChecking");
        if (this.hostKeyAlias != null) {
            string = this.hostKeyAlias;
        }
        byte[] byArray = keyExchange.getHostKey();
        String string3 = keyExchange.getKeyType();
        String string4 = keyExchange.getFingerPrint();
        if (this.hostKeyAlias == null && n != 22) {
            string = "[" + string + "]:" + n;
        }
        HostKeyRepository hostKeyRepository = this.getHostKeyRepository();
        String string5 = this.getConfig("HashKnownHosts");
        this.hostkey = string5.equals("yes") && hostKeyRepository instanceof KnownHosts ? ((KnownHosts)hostKeyRepository).createHashedHostKey(string, byArray) : new HostKey(string, byArray);
        int n2 = 0;
        HostKeyRepository hostKeyRepository2 = hostKeyRepository;
        synchronized (hostKeyRepository2) {
            n2 = hostKeyRepository.check(string, byArray);
        }
        boolean bl = false;
        if ((string2.equals("ask") || string2.equals("yes")) && n2 == 2) {
            Object object;
            String string6 = null;
            HostKeyRepository hostKeyRepository3 = hostKeyRepository;
            synchronized (hostKeyRepository3) {
                string6 = hostKeyRepository.getKnownHostsRepositoryID();
            }
            if (string6 == null) {
                string6 = "known_hosts";
            }
            boolean bl2 = false;
            if (this.userinfo != null) {
                object = "WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!\nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the " + string3 + " host key has just been changed.\nThe fingerprint for the " + string3 + " key sent by the remote host " + string + " is\n" + string4 + ".\nPlease contact your system administrator.\nAdd correct host key in " + string6 + " to get rid of this message.";
                if (string2.equals("ask")) {
                    bl2 = this.userinfo.promptYesNo((String)object + "\nDo you want to delete the old key and insert the new key?");
                } else {
                    this.userinfo.showMessage((String)object);
                }
            }
            if (!bl2) {
                throw new JSchException("HostKey has been changed: " + string);
            }
            object = hostKeyRepository;
            synchronized (object) {
                hostKeyRepository.remove(string, keyExchange.getKeyAlgorithName(), null);
                bl = true;
            }
        }
        if ((string2.equals("ask") || string2.equals("yes")) && n2 != 0 && !bl) {
            if (string2.equals("yes")) {
                throw new JSchException("reject HostKey: " + this.host);
            }
            if (this.userinfo != null) {
                boolean bl3 = this.userinfo.promptYesNo("The authenticity of host '" + this.host + "' can't be established.\n" + string3 + " key fingerprint is " + string4 + ".\nAre you sure you want to continue connecting?");
                if (!bl3) {
                    throw new JSchException("reject HostKey: " + this.host);
                }
                bl = true;
            } else {
                if (n2 == 1) {
                    throw new JSchException("UnknownHostKey: " + this.host + ". " + string3 + " key fingerprint is " + string4);
                }
                throw new JSchException("HostKey has been changed: " + this.host);
            }
        }
        if (string2.equals("no") && 1 == n2) {
            bl = true;
        }
        if (n2 == 0) {
            HostKey[] hostKeyArray = hostKeyRepository.getHostKey(string, keyExchange.getKeyAlgorithName());
            String string7 = Util.byte2str(Util.toBase64(byArray, 0, byArray.length));
            for (int i = 0; i < hostKeyArray.length; ++i) {
                if (!hostKeyArray[n2].getKey().equals(string7) || !hostKeyArray[i].getMarker().equals("@revoked")) continue;
                if (this.userinfo != null) {
                    this.userinfo.showMessage("The " + string3 + " host key for " + this.host + " is marked as revoked.\nThis could mean that a stolen key is being used to impersonate this host.");
                }
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "Host '" + this.host + "' has provided revoked key.");
                }
                throw new JSchException("revoked HostKey: " + this.host);
            }
        }
        if (n2 == 0 && JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "Host '" + this.host + "' is known and matches the " + string3 + " host key");
        }
        if (bl && JSch.getLogger().isEnabled(2)) {
            JSch.getLogger().log(2, "Permanently added '" + this.host + "' (" + string3 + ") to the list of known hosts.");
        }
        if (bl) {
            HostKeyRepository hostKeyRepository4 = hostKeyRepository;
            synchronized (hostKeyRepository4) {
                hostKeyRepository.add(this.hostkey, this.userinfo);
            }
        }
    }

    public Channel openChannel(String string) throws JSchException {
        if (!this.isConnected) {
            throw new JSchException("session is down");
        }
        try {
            Channel channel = Channel.getChannel(string);
            this.addChannel(channel);
            channel.init();
            if (channel instanceof ChannelSession) {
                this.applyConfigChannel((ChannelSession)channel);
            }
            return channel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Packet packet) throws Exception {
        if (this.deflater != null) {
            this.compress_len[0] = packet.buffer.index;
            packet.buffer.buffer = this.deflater.compress(packet.buffer.buffer, 5, this.compress_len);
            packet.buffer.index = this.compress_len[0];
        }
        if (this.c2scipher != null) {
            packet.padding(this.c2scipher_size);
            byte by = packet.buffer.buffer[4];
            Random random = Session.random;
            synchronized (random) {
                Session.random.fill(packet.buffer.buffer, packet.buffer.index - by, by);
            }
        } else {
            packet.padding(8);
        }
        if (this.c2smac != null) {
            this.c2smac.update(this.seqo);
            this.c2smac.update(packet.buffer.buffer, 0, packet.buffer.index);
            this.c2smac.doFinal(packet.buffer.buffer, packet.buffer.index);
        }
        if (this.c2scipher != null) {
            byte[] byArray = packet.buffer.buffer;
            this.c2scipher.update(byArray, 0, packet.buffer.index, byArray, 0);
        }
        if (this.c2smac != null) {
            packet.buffer.skip(this.c2smac.getBlockSize());
        }
    }

    public Buffer read(Buffer buffer) throws Exception {
        block18: {
            int n;
            Object object;
            int n2 = 0;
            while (true) {
                Object object2;
                int n3;
                buffer.reset();
                this.io.getByte(buffer.buffer, buffer.index, this.s2ccipher_size);
                buffer.index += this.s2ccipher_size;
                if (this.s2ccipher != null) {
                    this.s2ccipher.update(buffer.buffer, 0, this.s2ccipher_size, buffer.buffer, 0);
                }
                if ((n2 = buffer.buffer[0] << 24 & 0xFF000000 | buffer.buffer[1] << 16 & 0xFF0000 | buffer.buffer[2] << 8 & 0xFF00 | buffer.buffer[3] & 0xFF) < 5 || n2 > 262144) {
                    this.start_discard(buffer, this.s2ccipher, this.s2cmac, n2, 262144);
                }
                if (buffer.index + (n3 = n2 + 4 - this.s2ccipher_size) > buffer.buffer.length) {
                    object2 = new byte[buffer.index + n3];
                    System.arraycopy(buffer.buffer, 0, object2, 0, buffer.index);
                    buffer.buffer = object2;
                }
                if (n3 % this.s2ccipher_size != 0) {
                    object2 = "Bad packet length " + n3;
                    if (JSch.getLogger().isEnabled(4)) {
                        JSch.getLogger().log(4, (String)object2);
                    }
                    this.start_discard(buffer, this.s2ccipher, this.s2cmac, n2, 262144 - this.s2ccipher_size);
                }
                if (n3 > 0) {
                    this.io.getByte(buffer.buffer, buffer.index, n3);
                    buffer.index += n3;
                    if (this.s2ccipher != null) {
                        this.s2ccipher.update(buffer.buffer, this.s2ccipher_size, n3, buffer.buffer, this.s2ccipher_size);
                    }
                }
                if (this.s2cmac != null) {
                    this.s2cmac.update(this.seqi);
                    this.s2cmac.update(buffer.buffer, 0, buffer.index);
                    this.s2cmac.doFinal(this.s2cmac_result1, 0);
                    this.io.getByte(this.s2cmac_result2, 0, this.s2cmac_result2.length);
                    if (!Arrays.equals(this.s2cmac_result1, this.s2cmac_result2)) {
                        if (n3 > 262144) {
                            throw new IOException("MAC Error");
                        }
                        this.start_discard(buffer, this.s2ccipher, this.s2cmac, n2, 262144 - n3);
                        continue;
                    }
                }
                ++this.seqi;
                if (this.inflater != null) {
                    byte by = buffer.buffer[4];
                    this.uncompress_len[0] = buffer.index - 5 - by;
                    object = this.inflater.uncompress(buffer.buffer, 5, this.uncompress_len);
                    if (object == null) {
                        System.err.println("fail in inflater");
                        break block18;
                    }
                    buffer.buffer = object;
                    buffer.index = 5 + this.uncompress_len[0];
                }
                if ((n = buffer.getCommand() & 0xFF) == 1) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    int n4 = buffer.getInt();
                    byte[] byArray = buffer.getString();
                    byte[] byArray2 = buffer.getString();
                    throw new JSchException("SSH_MSG_DISCONNECT: " + n4 + " " + Util.byte2str(byArray) + " " + Util.byte2str(byArray2));
                }
                if (n == 2) continue;
                if (n == 3) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    int n5 = buffer.getInt();
                    if (!JSch.getLogger().isEnabled(1)) continue;
                    JSch.getLogger().log(1, "Received SSH_MSG_UNIMPLEMENTED for " + n5);
                    continue;
                }
                if (n == 4) {
                    buffer.rewind();
                    buffer.getInt();
                    buffer.getShort();
                    continue;
                }
                if (n != 93) break;
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                object = Channel.getChannel(buffer.getInt(), this);
                if (object == null) continue;
                object.addRemoteWindowSize(buffer.getUInt());
            }
            if (n == 52) {
                this.isAuthed = true;
                if (this.inflater == null && this.deflater == null) {
                    object = this.guess[6];
                    this.initDeflater((String)object);
                    object = this.guess[7];
                    this.initInflater((String)object);
                }
            }
        }
        buffer.rewind();
        return buffer;
    }

    private void start_discard(Buffer buffer, Cipher cipher, MAC mAC, int n, int n2) throws JSchException, IOException {
        MAC mAC2 = null;
        if (!cipher.isCBC()) {
            throw new JSchException("Packet corrupt");
        }
        if (n != 262144 && mAC != null) {
            mAC2 = mAC;
        }
        n2 -= buffer.index;
        while (n2 > 0) {
            buffer.reset();
            int n3 = n2 > buffer.buffer.length ? buffer.buffer.length : n2;
            this.io.getByte(buffer.buffer, 0, n3);
            if (mAC2 != null) {
                mAC2.update(buffer.buffer, 0, n3);
            }
            n2 -= n3;
        }
        if (mAC2 != null) {
            mAC2.doFinal(buffer.buffer, 0);
        }
        throw new JSchException("Packet corrupt");
    }

    byte[] getSessionId() {
        return this.session_id;
    }

    private void receive_newkeys(Buffer buffer, KeyExchange keyExchange) throws Exception {
        this.updateKeys(keyExchange);
        this.in_kex = false;
    }

    private void updateKeys(KeyExchange keyExchange) throws Exception {
        int n;
        byte[] byArray = keyExchange.getK();
        byte[] byArray2 = keyExchange.getH();
        HASH hASH = keyExchange.getHash();
        if (this.session_id == null) {
            this.session_id = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.session_id, 0, byArray2.length);
        }
        this.buf.reset();
        this.buf.putMPInt(byArray);
        this.buf.putByte(byArray2);
        this.buf.putByte((byte)65);
        this.buf.putByte(this.session_id);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVc2s = hASH.digest();
        int n2 = n = this.buf.index - this.session_id.length - 1;
        this.buf.buffer[n2] = (byte)(this.buf.buffer[n2] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVs2c = hASH.digest();
        int n3 = n;
        this.buf.buffer[n3] = (byte)(this.buf.buffer[n3] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Ec2s = hASH.digest();
        int n4 = n;
        this.buf.buffer[n4] = (byte)(this.buf.buffer[n4] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Es2c = hASH.digest();
        int n5 = n;
        this.buf.buffer[n5] = (byte)(this.buf.buffer[n5] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACc2s = hASH.digest();
        int n6 = n;
        this.buf.buffer[n6] = (byte)(this.buf.buffer[n6] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACs2c = hASH.digest();
        try {
            byte[] byArray3;
            byte[] byArray4;
            String string = this.guess[3];
            Class<?> clazz = Class.forName(this.getConfig(string));
            this.s2ccipher = (Cipher)clazz.newInstance();
            while (this.s2ccipher.getBlockSize() > this.Es2c.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Es2c);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                byArray4 = hASH.digest();
                byArray3 = new byte[this.Es2c.length + byArray4.length];
                System.arraycopy(this.Es2c, 0, byArray3, 0, this.Es2c.length);
                System.arraycopy(byArray4, 0, byArray3, this.Es2c.length, byArray4.length);
                this.Es2c = byArray3;
            }
            this.s2ccipher.init(1, this.Es2c, this.IVs2c);
            this.s2ccipher_size = this.s2ccipher.getIVSize();
            string = this.guess[5];
            clazz = Class.forName(this.getConfig(string));
            this.s2cmac = (MAC)clazz.newInstance();
            this.MACs2c = this.expandKey(this.buf, byArray, byArray2, this.MACs2c, hASH, this.s2cmac.getBlockSize());
            this.s2cmac.init(this.MACs2c);
            this.s2cmac_result1 = new byte[this.s2cmac.getBlockSize()];
            this.s2cmac_result2 = new byte[this.s2cmac.getBlockSize()];
            string = this.guess[2];
            clazz = Class.forName(this.getConfig(string));
            this.c2scipher = (Cipher)clazz.newInstance();
            while (this.c2scipher.getBlockSize() > this.Ec2s.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Ec2s);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                byArray4 = hASH.digest();
                byArray3 = new byte[this.Ec2s.length + byArray4.length];
                System.arraycopy(this.Ec2s, 0, byArray3, 0, this.Ec2s.length);
                System.arraycopy(byArray4, 0, byArray3, this.Ec2s.length, byArray4.length);
                this.Ec2s = byArray3;
            }
            this.c2scipher.init(0, this.Ec2s, this.IVc2s);
            this.c2scipher_size = this.c2scipher.getIVSize();
            string = this.guess[4];
            clazz = Class.forName(this.getConfig(string));
            this.c2smac = (MAC)clazz.newInstance();
            this.MACc2s = this.expandKey(this.buf, byArray, byArray2, this.MACc2s, hASH, this.c2smac.getBlockSize());
            this.c2smac.init(this.MACc2s);
            string = this.guess[6];
            this.initDeflater(string);
            string = this.guess[7];
            this.initInflater(string);
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw exception;
            }
            throw new JSchException(exception.toString(), exception);
        }
    }

    private byte[] expandKey(Buffer buffer, byte[] byArray, byte[] byArray2, byte[] byArray3, HASH hASH, int n) throws Exception {
        byte[] byArray4 = byArray3;
        int n2 = hASH.getBlockSize();
        while (byArray4.length < n) {
            buffer.reset();
            buffer.putMPInt(byArray);
            buffer.putByte(byArray2);
            buffer.putByte(byArray4);
            hASH.update(buffer.buffer, 0, buffer.index);
            byte[] byArray5 = new byte[byArray4.length + n2];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            System.arraycopy(hASH.digest(), 0, byArray5, byArray4.length, n2);
            Util.bzero(byArray4);
            byArray4 = byArray5;
        }
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Packet packet, Channel channel, int n) throws Exception {
        long l = this.getTimeout();
        while (true) {
            if (this.in_kex) {
                if (l > 0L && System.currentTimeMillis() - this.kex_start_time > l) {
                    throw new JSchException("timeout in wating for rekeying process.");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Channel channel2 = channel;
            synchronized (channel2) {
                if (channel.rwsize < (long)n) {
                    try {
                        ++channel.notifyme;
                        channel.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        --channel.notifyme;
                    }
                }
                if (this.in_kex) {
                    continue;
                }
                if (channel.rwsize >= (long)n) {
                    channel.rwsize -= (long)n;
                    break;
                }
            }
            if (channel.close || !channel.isConnected()) {
                throw new IOException("channel is broken");
            }
            boolean bl = false;
            int n2 = 0;
            byte by = 0;
            int n3 = -1;
            Channel channel3 = channel;
            synchronized (channel3) {
                if (channel.rwsize > 0L) {
                    long l2 = channel.rwsize;
                    if (l2 > (long)n) {
                        l2 = n;
                    }
                    if (l2 != (long)n) {
                        n2 = packet.shift((int)l2, this.c2scipher != null ? this.c2scipher_size : 8, this.c2smac != null ? this.c2smac.getBlockSize() : 0);
                    }
                    by = packet.buffer.getCommand();
                    n3 = channel.getRecipient();
                    n = (int)((long)n - l2);
                    channel.rwsize -= l2;
                    bl = true;
                }
            }
            if (bl) {
                this._write(packet);
                if (n == 0) {
                    return;
                }
                packet.unshift(by, n3, n2, n);
            }
            channel3 = channel;
            synchronized (channel3) {
                if (this.in_kex) {
                    continue;
                }
                if (channel.rwsize >= (long)n) {
                    channel.rwsize -= (long)n;
                    break;
                }
            }
        }
        this._write(packet);
    }

    public void write(Packet packet) throws Exception {
        long l = this.getTimeout();
        while (this.in_kex) {
            if (l > 0L && System.currentTimeMillis() - this.kex_start_time > l) {
                throw new JSchException("timeout in wating for rekeying process.");
            }
            byte by = packet.buffer.getCommand();
            if (by == 20 || by == 21 || by == 30 || by == 31 || by == 31 || by == 32 || by == 33 || by == 34 || by == 1) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._write(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _write(Packet packet) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.encode(packet);
            if (this.io != null) {
                this.io.put(packet);
                ++this.seqo;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block42: {
            this.thread = this;
            Buffer buffer = new Buffer();
            Packet packet = new Packet(buffer);
            int n = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            KeyExchange keyExchange = null;
            int n2 = 0;
            try {
                block32: while (this.isConnected && this.thread != null) {
                    int n3;
                    try {
                        buffer = this.read(buffer);
                        n2 = 0;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (!this.in_kex && n2 < this.serverAliveCountMax) {
                            this.sendKeepAliveMsg();
                            ++n2;
                            continue;
                        }
                        if (this.in_kex && n2 < this.serverAliveCountMax) {
                            ++n2;
                            continue;
                        }
                        throw interruptedIOException;
                    }
                    int n4 = buffer.getCommand() & 0xFF;
                    if (keyExchange != null && keyExchange.getState() == n4) {
                        this.kex_start_time = System.currentTimeMillis();
                        n3 = keyExchange.next(buffer);
                        if (n3 != 0) continue;
                        throw new JSchException("verify: " + (n3 != 0));
                    }
                    switch (n4) {
                        case 20: {
                            keyExchange = this.receive_kexinit(buffer);
                            break;
                        }
                        case 21: {
                            this.send_newkeys();
                            this.receive_newkeys(buffer, keyExchange);
                            keyExchange = null;
                            break;
                        }
                        case 94: {
                            buffer.getInt();
                            buffer.getByte();
                            buffer.getByte();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            byte[] byArray = buffer.getString(nArray, nArray2);
                            if (channel == null || nArray2[0] == 0) break;
                            try {
                                channel.write(byArray, nArray[0], nArray2[0]);
                            }
                            catch (Exception exception) {
                                try {
                                    channel.disconnect();
                                }
                                catch (Exception exception2) {}
                                continue block32;
                            }
                            n3 = nArray2[0];
                            channel.setLocalWindowSize(channel.lwsize - n3);
                            if (channel.lwsize >= channel.lwsize_max / 2) continue block32;
                            packet.reset();
                            buffer.putByte((byte)93);
                            buffer.putInt(channel.getRecipient());
                            buffer.putInt(channel.lwsize_max - channel.lwsize);
                            Channel channel2 = channel;
                            synchronized (channel2) {
                                if (!channel.close) {
                                    this.write(packet);
                                }
                            }
                            channel.setLocalWindowSize(channel.lwsize_max);
                            break;
                        }
                        case 95: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            buffer.getInt();
                            byte[] byArray = buffer.getString(nArray, nArray2);
                            if (channel == null || nArray2[0] == 0) break;
                            channel.write_ext(byArray, nArray[0], nArray2[0]);
                            n3 = nArray2[0];
                            channel.setLocalWindowSize(channel.lwsize - n3);
                            if (channel.lwsize >= channel.lwsize_max / 2) continue block32;
                            packet.reset();
                            buffer.putByte((byte)93);
                            buffer.putInt(channel.getRecipient());
                            buffer.putInt(channel.lwsize_max - channel.lwsize);
                            Channel channel3 = channel;
                            synchronized (channel3) {
                                if (!channel.close) {
                                    this.write(packet);
                                }
                            }
                            channel.setLocalWindowSize(channel.lwsize_max);
                            break;
                        }
                        case 93: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) break;
                            channel.addRemoteWindowSize(buffer.getUInt());
                            break;
                        }
                        case 96: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) continue block32;
                            channel.eof_remote();
                            break;
                        }
                        case 97: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) continue block32;
                            channel.disconnect();
                            break;
                        }
                        case 91: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            int n5 = buffer.getInt();
                            long l = buffer.getUInt();
                            int n6 = buffer.getInt();
                            if (channel == null) continue block32;
                            channel.setRemoteWindowSize(l);
                            channel.setRemotePacketSize(n6);
                            channel.open_confirmation = true;
                            channel.setRecipient(n5);
                            break;
                        }
                        case 92: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) continue block32;
                            int n7 = buffer.getInt();
                            channel.setExitStatus(n7);
                            channel.close = true;
                            channel.eof_remote = true;
                            channel.setRecipient(0);
                            break;
                        }
                        case 98: {
                            int n7;
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            byte[] byArray = buffer.getString();
                            int n8 = n7 = buffer.getByte() != 0 ? 1 : 0;
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) continue block32;
                            int n9 = 100;
                            if (Util.byte2str(byArray).equals("exit-status")) {
                                n = buffer.getInt();
                                channel.setExitStatus(n);
                                n9 = 99;
                            }
                            if (n7 == 0) continue block32;
                            packet.reset();
                            buffer.putByte((byte)n9);
                            buffer.putInt(channel.getRecipient());
                            this.write(packet);
                            break;
                        }
                        case 90: {
                            buffer.getInt();
                            buffer.getShort();
                            byte[] byArray = buffer.getString();
                            String string = Util.byte2str(byArray);
                            if (!("forwarded-tcpip".equals(string) || "x11".equals(string) && this.x11_forwarding || "auth-agent@openssh.com".equals(string) && this.agent_forwarding)) {
                                packet.reset();
                                buffer.putByte((byte)92);
                                buffer.putInt(buffer.getInt());
                                buffer.putInt(1);
                                buffer.putString(Util.empty);
                                buffer.putString(Util.empty);
                                this.write(packet);
                                break;
                            }
                            Channel channel = Channel.getChannel(string);
                            this.addChannel(channel);
                            channel.getData(buffer);
                            channel.init();
                            Thread thread = new Thread(channel);
                            thread.setName("Channel " + string + " " + this.host);
                            if (this.daemon_thread) {
                                thread.setDaemon(this.daemon_thread);
                            }
                            thread.start();
                            break;
                        }
                        case 99: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) break;
                            channel.reply = 1;
                            break;
                        }
                        case 100: {
                            buffer.getInt();
                            buffer.getShort();
                            n = buffer.getInt();
                            Channel channel = Channel.getChannel(n, this);
                            if (channel == null) break;
                            channel.reply = 0;
                            break;
                        }
                        case 80: {
                            buffer.getInt();
                            buffer.getShort();
                            byte[] byArray = buffer.getString();
                            int n7 = buffer.getByte() != 0 ? 1 : 0;
                            if (n7 == 0) continue block32;
                            packet.reset();
                            buffer.putByte((byte)82);
                            this.write(packet);
                            break;
                        }
                        case 81: 
                        case 82: {
                            Thread thread = this.grr.getThread();
                            if (thread == null) continue block32;
                            this.grr.setReply(n4 == 81 ? 1 : 0);
                            if (n4 == 81 && this.grr.getPort() == 0) {
                                buffer.getInt();
                                buffer.getShort();
                                this.grr.setPort(buffer.getInt());
                            }
                            thread.interrupt();
                            break;
                        }
                        default: {
                            throw new IOException("Unknown SSH message type " + n4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.in_kex = false;
                if (!JSch.getLogger().isEnabled(1)) break block42;
                JSch.getLogger().log(1, "Caught an exception, leaving main loop due to " + exception.getMessage());
            }
        }
        try {
            this.disconnect();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        block17: {
            if (!this.isConnected) {
                return;
            }
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "Disconnecting from " + this.host + " port " + this.port);
            }
            Channel.disconnect(this);
            this.isConnected = false;
            PortWatcher.delPort(this);
            ChannelForwardedTCPIP.delPort(this);
            ChannelX11.removeFakedCookie(this);
            Object object = this.lock;
            synchronized (object) {
                if (this.connectThread != null) {
                    Thread.yield();
                    this.connectThread.interrupt();
                    this.connectThread = null;
                }
            }
            this.thread = null;
            try {
                if (this.io != null) {
                    if (this.io.in != null) {
                        this.io.in.close();
                    }
                    if (this.io.out != null) {
                        this.io.out.close();
                    }
                    if (this.io.out_ext != null) {
                        this.io.out_ext.close();
                    }
                }
                if (this.proxy == null) {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block17;
                }
                object = this.proxy;
                synchronized (object) {
                    this.proxy.close();
                }
                this.proxy = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.io = null;
        this.socket = null;
        this.jsch.removeSession(this);
    }

    public int setPortForwardingL(int n, String string, int n2) throws JSchException {
        return this.setPortForwardingL("127.0.0.1", n, string, n2);
    }

    public int setPortForwardingL(String string, int n, String string2, int n2) throws JSchException {
        return this.setPortForwardingL(string, n, string2, n2, null);
    }

    public int setPortForwardingL(String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        return this.setPortForwardingL(string, n, string2, n2, serverSocketFactory, 0);
    }

    public int setPortForwardingL(String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory, int n3) throws JSchException {
        PortWatcher portWatcher = PortWatcher.addPort(this, string, n, string2, n2, serverSocketFactory);
        portWatcher.setConnectTimeout(n3);
        Thread thread = new Thread(portWatcher);
        thread.setName("PortWatcher Thread for " + string2);
        if (this.daemon_thread) {
            thread.setDaemon(this.daemon_thread);
        }
        thread.start();
        return portWatcher.lport;
    }

    public void delPortForwardingL(int n) throws JSchException {
        this.delPortForwardingL("127.0.0.1", n);
    }

    public void delPortForwardingL(String string, int n) throws JSchException {
        PortWatcher.delPort(this, string, n);
    }

    public String[] getPortForwardingL() throws JSchException {
        return PortWatcher.getPortForwarding(this);
    }

    public void setPortForwardingR(int n, String string, int n2) throws JSchException {
        this.setPortForwardingR(null, n, string, n2, null);
    }

    public void setPortForwardingR(String string, int n, String string2, int n2) throws JSchException {
        this.setPortForwardingR(string, n, string2, n2, null);
    }

    public void setPortForwardingR(int n, String string, int n2, SocketFactory socketFactory) throws JSchException {
        this.setPortForwardingR(null, n, string, n2, socketFactory);
    }

    public void setPortForwardingR(String string, int n, String string2, int n2, SocketFactory socketFactory) throws JSchException {
        int n3 = this._setPortForwardingR(string, n);
        ChannelForwardedTCPIP.addPort(this, string, n, n3, string2, n2, socketFactory);
    }

    public void setPortForwardingR(int n, String string) throws JSchException {
        this.setPortForwardingR(null, n, string, null);
    }

    public void setPortForwardingR(int n, String string, Object[] objectArray) throws JSchException {
        this.setPortForwardingR(null, n, string, objectArray);
    }

    public void setPortForwardingR(String string, int n, String string2, Object[] objectArray) throws JSchException {
        int n2 = this._setPortForwardingR(string, n);
        ChannelForwardedTCPIP.addPort(this, string, n, n2, string2, objectArray);
    }

    public String[] getPortForwardingR() throws JSchException {
        return ChannelForwardedTCPIP.getPortForwarding(this);
    }

    private Forwarding parseForwarding(String string) throws JSchException {
        Object object;
        Object object2;
        String[] stringArray = string.split(" ");
        if (stringArray.length > 1) {
            object2 = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                ((Vector)object2).addElement(stringArray[i].trim());
            }
            object = new StringBuffer();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                ((StringBuffer)object).append((String)((Vector)object2).elementAt(i));
                if (i + 1 >= ((Vector)object2).size()) continue;
                ((StringBuffer)object).append(":");
            }
            string = ((StringBuffer)object).toString();
        }
        object2 = string;
        object = new Forwarding();
        try {
            if (string.lastIndexOf(":") == -1) {
                throw new JSchException("parseForwarding: " + (String)object2);
            }
            ((Forwarding)object).hostport = Integer.parseInt(string.substring(string.lastIndexOf(":") + 1));
            if ((string = string.substring(0, string.lastIndexOf(":"))).lastIndexOf(":") == -1) {
                throw new JSchException("parseForwarding: " + (String)object2);
            }
            ((Forwarding)object).host = string.substring(string.lastIndexOf(":") + 1);
            if ((string = string.substring(0, string.lastIndexOf(":"))).lastIndexOf(":") != -1) {
                ((Forwarding)object).port = Integer.parseInt(string.substring(string.lastIndexOf(":") + 1));
                if ((string = string.substring(0, string.lastIndexOf(":"))).length() == 0 || string.equals("*")) {
                    string = "0.0.0.0";
                }
                if (string.equals("localhost")) {
                    string = "127.0.0.1";
                }
                ((Forwarding)object).bind_address = string;
            } else {
                ((Forwarding)object).port = Integer.parseInt(string);
                ((Forwarding)object).bind_address = "127.0.0.1";
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSchException("parseForwarding: " + numberFormatException.toString());
        }
        return object;
    }

    public int setPortForwardingL(String string) throws JSchException {
        Forwarding forwarding = this.parseForwarding(string);
        return this.setPortForwardingL(forwarding.bind_address, forwarding.port, forwarding.host, forwarding.hostport);
    }

    public int setPortForwardingR(String string) throws JSchException {
        Forwarding forwarding = this.parseForwarding(string);
        int n = this._setPortForwardingR(forwarding.bind_address, forwarding.port);
        ChannelForwardedTCPIP.addPort(this, forwarding.bind_address, forwarding.port, n, forwarding.host, forwarding.hostport, null);
        return n;
    }

    public Channel getStreamForwarder(String string, int n) throws JSchException {
        ChannelDirectTCPIP channelDirectTCPIP = new ChannelDirectTCPIP();
        channelDirectTCPIP.init();
        this.addChannel(channelDirectTCPIP);
        channelDirectTCPIP.setHost(string);
        channelDirectTCPIP.setPort(n);
        return channelDirectTCPIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _setPortForwardingR(String string, int n) throws JSchException {
        GlobalRequestReply globalRequestReply = this.grr;
        synchronized (globalRequestReply) {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            String string2 = ChannelForwardedTCPIP.normalize(string);
            this.grr.setThread(Thread.currentThread());
            this.grr.setPort(n);
            try {
                packet.reset();
                buffer.putByte((byte)80);
                buffer.putString(Util.str2byte("tcpip-forward"));
                buffer.putByte((byte)1);
                buffer.putString(Util.str2byte(string2));
                buffer.putInt(n);
                this.write(packet);
            }
            catch (Exception exception) {
                this.grr.setThread(null);
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
            int n2 = this.grr.getReply();
            for (int i = 0; i < 10 && n2 == -1; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n2 = this.grr.getReply();
            }
            this.grr.setThread(null);
            if (n2 != 1) {
                throw new JSchException("remote port forwarding failed for listen port " + n);
            }
            n = this.grr.getPort();
        }
        return n;
    }

    public void delPortForwardingR(int n) throws JSchException {
        this.delPortForwardingR(null, n);
    }

    public void delPortForwardingR(String string, int n) throws JSchException {
        ChannelForwardedTCPIP.delPort(this, string, n);
    }

    private void initDeflater(String string) throws JSchException {
        if (string.equals("none")) {
            this.deflater = null;
            return;
        }
        String string2 = this.getConfig(string);
        if (string2 != null && (string.equals("zlib") || this.isAuthed && string.equals("zlib@openssh.com"))) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.deflater = (Compression)clazz.newInstance();
                int n = 6;
                try {
                    n = Integer.parseInt(this.getConfig("compression_level"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deflater.init(1, n);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new JSchException(noClassDefFoundError.toString(), noClassDefFoundError);
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
    }

    private void initInflater(String string) throws JSchException {
        if (string.equals("none")) {
            this.inflater = null;
            return;
        }
        String string2 = this.getConfig(string);
        if (string2 != null && (string.equals("zlib") || this.isAuthed && string.equals("zlib@openssh.com"))) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.inflater = (Compression)clazz.newInstance();
                this.inflater.init(0, 0);
            }
            catch (Exception exception) {
                throw new JSchException(exception.toString(), exception);
            }
        }
    }

    void addChannel(Channel channel) {
        channel.setSession(this);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    void setUserName(String string) {
        this.username = string;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userinfo = userInfo;
    }

    public UserInfo getUserInfo() {
        return this.userinfo;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setX11Host(String string) {
        ChannelX11.setHost(string);
    }

    public void setX11Port(int n) {
        ChannelX11.setPort(n);
    }

    public void setX11Cookie(String string) {
        ChannelX11.setCookie(string);
    }

    public void setPassword(String string) {
        if (string != null) {
            this.password = Util.str2byte(string);
        }
    }

    public void setPassword(byte[] byArray) {
        if (byArray != null) {
            this.password = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.password, 0, byArray.length);
        }
    }

    public void setConfig(Properties properties) {
        this.setConfig((Hashtable)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(Hashtable hashtable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.config == null) {
                this.config = new Hashtable();
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.config.put(string, (String)hashtable.get(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.config == null) {
                this.config = new Hashtable();
            }
            this.config.put(string, string2);
        }
    }

    public String getConfig(String string) {
        String string2 = null;
        if (this.config != null && (string2 = (String)this.config.get(string)) instanceof String) {
            return string2;
        }
        string2 = JSch.getConfig(string);
        if (string2 instanceof String) {
            return string2;
        }
        return null;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socket_factory = socketFactory;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) throws JSchException {
        if (this.socket == null) {
            if (n < 0) {
                throw new JSchException("invalid timeout value");
            }
            this.timeout = n;
            return;
        }
        try {
            this.socket.setSoTimeout(n);
            this.timeout = n;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public String getServerVersion() {
        return Util.byte2str(this.V_S);
    }

    public String getClientVersion() {
        return Util.byte2str(this.V_C);
    }

    public void setClientVersion(String string) {
        this.V_C = Util.str2byte(string);
    }

    public void sendIgnore() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)2);
        this.write(packet);
    }

    public void sendKeepAliveMsg() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)80);
        buffer.putString(keepalivemsg);
        buffer.putByte((byte)1);
        this.write(packet);
    }

    public void noMoreSessionChannels() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)80);
        buffer.putString(nomoresessions);
        buffer.putByte((byte)0);
        this.write(packet);
    }

    public HostKey getHostKey() {
        return this.hostkey;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.username;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostKeyAlias(String string) {
        this.hostKeyAlias = string;
    }

    public String getHostKeyAlias() {
        return this.hostKeyAlias;
    }

    public void setServerAliveInterval(int n) throws JSchException {
        this.setTimeout(n);
        this.serverAliveInterval = n;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int n) {
        this.serverAliveCountMax = n;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setDaemonThread(boolean bl) {
        this.daemon_thread = bl;
    }

    private String[] checkCiphers(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "CheckCiphers: " + string);
        }
        String string2 = this.getConfig("cipher.c2s");
        String string3 = this.getConfig("cipher.s2c");
        Vector<String> vector = new Vector<String>();
        String[] stringArray = Util.split(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string3.indexOf(string4) == -1 && string2.indexOf(string4) == -1 || Session.checkCipher(this.getConfig(string4))) continue;
            vector.addElement(string4);
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        System.arraycopy(vector.toArray(), 0, stringArray2, 0, vector.size());
        if (JSch.getLogger().isEnabled(1)) {
            for (int i = 0; i < stringArray2.length; ++i) {
                JSch.getLogger().log(1, stringArray2[i] + " is not available.");
            }
        }
        return stringArray2;
    }

    static boolean checkCipher(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Cipher cipher = (Cipher)clazz.newInstance();
            cipher.init(0, new byte[cipher.getBlockSize()], new byte[cipher.getIVSize()]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String[] checkKexes(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "CheckKexes: " + string);
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = Util.split(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (Session.checkKex(this, this.getConfig(stringArray[i]))) continue;
            vector.addElement(stringArray[i]);
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        System.arraycopy(vector.toArray(), 0, stringArray2, 0, vector.size());
        if (JSch.getLogger().isEnabled(1)) {
            for (int i = 0; i < stringArray2.length; ++i) {
                JSch.getLogger().log(1, stringArray2[i] + " is not available.");
            }
        }
        return stringArray2;
    }

    static boolean checkKex(Session session, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            KeyExchange keyExchange = (KeyExchange)clazz.newInstance();
            keyExchange.init(session, null, null, null, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String[] checkSignatures(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "CheckSignatures: " + string);
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = Util.split(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class<?> clazz = Class.forName(JSch.getConfig(stringArray[i]));
                Signature signature = (Signature)clazz.newInstance();
                signature.init();
                continue;
            }
            catch (Exception exception) {
                vector.addElement(stringArray[i]);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        System.arraycopy(vector.toArray(), 0, stringArray2, 0, vector.size());
        if (JSch.getLogger().isEnabled(1)) {
            for (int i = 0; i < stringArray2.length; ++i) {
                JSch.getLogger().log(1, stringArray2[i] + " is not available.");
            }
        }
        return stringArray2;
    }

    public void setIdentityRepository(IdentityRepository identityRepository) {
        this.identityRepository = identityRepository;
    }

    IdentityRepository getIdentityRepository() {
        if (this.identityRepository == null) {
            return this.jsch.getIdentityRepository();
        }
        return this.identityRepository;
    }

    public void setHostKeyRepository(HostKeyRepository hostKeyRepository) {
        this.hostkeyRepository = hostKeyRepository;
    }

    public HostKeyRepository getHostKeyRepository() {
        if (this.hostkeyRepository == null) {
            return this.jsch.getHostKeyRepository();
        }
        return this.hostkeyRepository;
    }

    private void applyConfig() throws JSchException {
        Object object;
        int n;
        ConfigRepository configRepository = this.jsch.getConfigRepository();
        if (configRepository == null) {
            return;
        }
        ConfigRepository.Config config = configRepository.getConfig(this.org_host);
        String string = null;
        string = config.getUser();
        if (string != null) {
            this.username = string;
        }
        if ((string = config.getHostname()) != null) {
            this.host = string;
        }
        if ((n = config.getPort()) != -1) {
            this.port = n;
        }
        this.checkConfig(config, "kex");
        this.checkConfig(config, "server_host_key");
        this.checkConfig(config, "cipher.c2s");
        this.checkConfig(config, "cipher.s2c");
        this.checkConfig(config, "mac.c2s");
        this.checkConfig(config, "mac.s2c");
        this.checkConfig(config, "compression.c2s");
        this.checkConfig(config, "compression.s2c");
        this.checkConfig(config, "compression_level");
        this.checkConfig(config, "StrictHostKeyChecking");
        this.checkConfig(config, "HashKnownHosts");
        this.checkConfig(config, "PreferredAuthentications");
        this.checkConfig(config, "MaxAuthTries");
        this.checkConfig(config, "ClearAllForwardings");
        string = config.getValue("HostKeyAlias");
        if (string != null) {
            this.setHostKeyAlias(string);
        }
        if ((string = config.getValue("UserKnownHostsFile")) != null) {
            object = new KnownHosts(this.jsch);
            ((KnownHosts)object).setKnownHosts(string);
            this.setHostKeyRepository((HostKeyRepository)object);
        }
        if ((object = config.getValues("IdentityFile")) != null) {
            String[] stringArray = configRepository.getConfig("").getValues("IdentityFile");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.jsch.addIdentity(stringArray[i]);
                }
            } else {
                stringArray = new String[]{};
            }
            if (((Object)object).length - stringArray.length > 0) {
                IdentityRepository.Wrapper wrapper = new IdentityRepository.Wrapper(this.jsch.getIdentityRepository(), true);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object2 = object[i];
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!((String)object2).equals(stringArray[j])) continue;
                        object2 = null;
                        break;
                    }
                    if (object2 == null) continue;
                    IdentityFile identityFile = IdentityFile.newInstance((String)object2, null, this.jsch);
                    wrapper.add(identityFile);
                }
                this.setIdentityRepository(wrapper);
            }
        }
        if ((string = config.getValue("ServerAliveInterval")) != null) {
            try {
                this.setServerAliveInterval(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = config.getValue("ConnectTimeout")) != null) {
            try {
                this.setTimeout(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = config.getValue("MaxAuthTries")) != null) {
            this.setConfig("MaxAuthTries", string);
        }
        if ((string = config.getValue("ClearAllForwardings")) != null) {
            this.setConfig("ClearAllForwardings", string);
        }
    }

    private void applyConfigChannel(ChannelSession channelSession) throws JSchException {
        ConfigRepository configRepository = this.jsch.getConfigRepository();
        if (configRepository == null) {
            return;
        }
        ConfigRepository.Config config = configRepository.getConfig(this.org_host);
        String string = null;
        string = config.getValue("ForwardAgent");
        if (string != null) {
            channelSession.setAgentForwarding(string.equals("yes"));
        }
        if ((string = config.getValue("RequestTTY")) != null) {
            channelSession.setPty(string.equals("yes"));
        }
    }

    private void requestPortForwarding() throws JSchException {
        int n;
        if (this.getConfig("ClearAllForwardings").equals("yes")) {
            return;
        }
        ConfigRepository configRepository = this.jsch.getConfigRepository();
        if (configRepository == null) {
            return;
        }
        ConfigRepository.Config config = configRepository.getConfig(this.org_host);
        String[] stringArray = config.getValues("LocalForward");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.setPortForwardingL(stringArray[n]);
            }
        }
        if ((stringArray = config.getValues("RemoteForward")) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.setPortForwardingR(stringArray[n]);
            }
        }
    }

    private void checkConfig(ConfigRepository.Config config, String string) {
        String string2 = config.getValue(string);
        if (string2 != null) {
            this.setConfig(string, string2);
        }
    }

    static {
        keepalivemsg = Util.str2byte("keepalive@jcraft.com");
        nomoresessions = Util.str2byte("no-more-sessions@openssh.com");
    }

    private class GlobalRequestReply {
        private Thread thread = null;
        private int reply = -1;
        private int port = 0;

        private GlobalRequestReply() {
        }

        void setThread(Thread thread) {
            this.thread = thread;
            this.reply = -1;
        }

        Thread getThread() {
            return this.thread;
        }

        void setReply(int n) {
            this.reply = n;
        }

        int getReply() {
            return this.reply;
        }

        int getPort() {
            return this.port;
        }

        void setPort(int n) {
            this.port = n;
        }
    }

    private class Forwarding {
        String bind_address = null;
        int port = -1;
        String host = null;
        int hostport = -1;

        private Forwarding() {
        }
    }
}

