/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.helpers.RDFParserBase;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.rio.OWLAPIRDFFormat;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioOWLRDFParser
extends RDFParserBase {
    private final OWLAPIRDFFormat owlFormat;
    private final Set<OWLOntologyManagerFactory> ontologyManagerFactories = new HashSet<OWLOntologyManagerFactory>();

    public RioOWLRDFParser(OWLAPIRDFFormat owlFormat) {
        this.owlFormat = owlFormat;
    }

    public RioOWLRDFParser(OWLAPIRDFFormat owlFormat, ValueFactory valueFactory) {
        super(valueFactory);
        this.owlFormat = owlFormat;
    }

    @Inject
    public void setOntologyManagerFactories(Set<OWLOntologyManagerFactory> factories) {
        this.ontologyManagerFactories.clear();
        this.ontologyManagerFactories.addAll(factories);
    }

    public OWLAPIRDFFormat getRDFFormat() {
        return this.owlFormat;
    }

    public void parse(InputStream in, String baseURI) throws IOException {
        OWLDocumentFormat nextFormat = this.getRDFFormat().getOWLFormat();
        StreamDocumentSource source = new StreamDocumentSource(OWLAPIPreconditions.checkNotNull(in, "in cannot be null"), IRI.create(OWLAPIPreconditions.checkNotNull(baseURI, "baseURI cannot be null")), nextFormat, this.getRDFFormat().getDefaultMIMEType());
        this.render(source);
    }

    protected void render(@Nonnull OWLOntologyDocumentSource source) throws IOException {
        if (this.ontologyManagerFactories.isEmpty()) {
            throw new OWLRuntimeException("No ontology manager factories available, parsing is impossible");
        }
        try {
            OWLOntologyManagerFactory f = this.ontologyManagerFactories.iterator().next();
            OWLOntology ontology = f.get().loadOntologyFromOntologyDocument(source);
            new RioRenderer(ontology, this.getRDFHandler(), this.getRDFFormat().getOWLFormat(), new Resource[0]).render();
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException {
        OWLDocumentFormat nextFormat = this.getRDFFormat().getOWLFormat();
        ReaderDocumentSource source = new ReaderDocumentSource(OWLAPIPreconditions.checkNotNull(reader, "reader cannot be null"), IRI.create(OWLAPIPreconditions.checkNotNull(baseURI, "baseURI cannot be null")), nextFormat, this.getRDFFormat().getDefaultMIMEType());
        this.render(source);
    }
}

