/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "moszkvai t\u00e9li id\u0151",
               "",
               "moszkvai ny\u00e1ri id\u0151",
               "",
               "moszkvai id\u0151",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakiszt\u00e1ni t\u00e9li id\u0151",
               "",
               "pakiszt\u00e1ni ny\u00e1ri id\u0151",
               "",
               "pakiszt\u00e1ni id\u0151",
               "",
            };
        final String[] Magadan = new String[] {
               "magadani t\u00e9li id\u0151",
               "",
               "magad\u00e1ni ny\u00e1ri id\u0151",
               "",
               "magad\u00e1ni id\u0151",
               "",
            };
        final String[] Europe_Central = new String[] {
               "k\u00f6z\u00e9p-eur\u00f3pai t\u00e9li id\u0151",
               "CET",
               "k\u00f6z\u00e9p-eur\u00f3pai ny\u00e1ri id\u0151",
               "CEST",
               "k\u00f6z\u00e9p-eur\u00f3pai id\u0151z\u00f3na",
               "CET",
            };
        final String[] Acre = new String[] {
               "Acre z\u00f3naid\u0151",
               "",
               "Acre ny\u00e1ri id\u0151",
               "",
               "Acre id\u0151",
               "",
            };
        final String[] America_Eastern = new String[] {
               "keleti \u00e1llamokbeli z\u00f3naid\u0151",
               "",
               "keleti \u00e1llamokbeli ny\u00e1ri id\u0151",
               "",
               "keleti \u00e1llamokbeli id\u0151",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-szigeti t\u00e9li id\u0151",
               "",
               "Lord Howe-szigeti ny\u00e1ri id\u0151",
               "",
               "Lord Howe-szigeti id\u0151",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u00faj-z\u00e9landi t\u00e9li id\u0151",
               "",
               "\u00faj-z\u00e9landi ny\u00e1ri id\u0151",
               "",
               "\u00faj-z\u00e9landi id\u0151",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indiai-\u00f3ce\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutszki t\u00e9li id\u0151",
               "",
               "jakutszki ny\u00e1ri id\u0151",
               "",
               "jakutszki id\u0151",
               "",
            };
        final String[] East_Timor = new String[] {
               "kelet-timori t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "kosraei id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "kelet-eur\u00f3pai t\u00e9li id\u0151",
               "EET",
               "kelet-eur\u00f3pai ny\u00e1ri id\u0151",
               "EEST",
               "kelet-eur\u00f3pai id\u0151z\u00f3na",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "nyugat-argent\u00ednai t\u00e9li id\u0151",
               "",
               "nyugat-argent\u00ednai ny\u00e1ri id\u0151",
               "",
               "nyugat-argent\u00ednai id\u0151z\u00f3na",
               "",
            };
        final String[] Ponape = new String[] {
               "ponape-szigeti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edviai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre \u00e9s Miquelon-i z\u00f3naid\u0151",
               "",
               "Saint-Pierre \u00e9s Miquelon-i ny\u00e1ri id\u0151",
               "",
               "Saint-Pierre \u00e9s Miquelon-i id\u0151",
               "",
            };
        final String[] Indochina = new String[] {
               "indok\u00ednai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekatyerinburgi t\u00e9li id\u0151",
               "",
               "jekatyerinburgi ny\u00e1ri id\u0151",
               "",
               "jekatyerinburgi id\u0151",
               "",
            };
        final String[] Maldives = new String[] {
               "mald\u00edv-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahiti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis \u00e9s Futuna-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "d\u00e9l-afrikai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "syowai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "sor-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u00fczbegiszt\u00e1ni t\u00e9li id\u0151",
               "",
               "\u00fczbegiszt\u00e1ni ny\u00e1ri id\u0151",
               "",
               "\u00fczbegiszt\u00e1ni id\u0151",
               "",
            };
        final String[] Mongolia = new String[] {
               "ul\u00e1nb\u00e1tori t\u00e9li id\u0151",
               "",
               "ul\u00e1nb\u00e1tori ny\u00e1ri id\u0151",
               "",
               "ul\u00e1nb\u00e1tori id\u0151",
               "",
            };
        final String[] America_Central = new String[] {
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli z\u00f3naid\u0151",
               "",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli ny\u00e1ri id\u0151",
               "",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli id\u0151",
               "",
            };
        final String[] Niue = new String[] {
               "niuei id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "wake-szigeti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "falkland-szigeteki t\u00e9li id\u0151",
               "",
               "falkland-szigeteki ny\u00e1ri id\u0151",
               "",
               "falkland-szigeteki id\u0151",
               "",
            };
        final String[] Apia = new String[] {
               "apiai t\u00e9li id\u0151",
               "",
               "apiai ny\u00e1ri id\u0151",
               "",
               "apiai id\u0151",
               "",
            };
        final String[] Bhutan = new String[] {
               "but\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "naurui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "nyugat-kazahszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "kar\u00e1csony-szigeti t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unioni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "k\u00f3kusz-szigeteki t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathami t\u00e9li id\u0151",
               "",
               "chathami ny\u00e1ri id\u0151",
               "",
               "chathami id\u0151",
               "",
            };
        final String[] Vostok = new String[] {
               "vosztoki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednai t\u00e9li id\u0151",
               "",
               "argent\u00ednai ny\u00e1ri id\u0151",
               "",
               "argent\u00ednai id\u0151",
               "",
            };
        final String[] Gambier = new String[] {
               "gambieri id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "gal\u00e1pagosi t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "phoenix-szigeteki t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "z\u00f6ld-foki-szigeteki t\u00e9li id\u0151",
               "",
               "z\u00f6ld-foki-szigeteki ny\u00e1ri id\u0151",
               "",
               "z\u00f6ld-foki-szigeteki id\u0151z\u00f3na",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolk-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "szamoai t\u00e9li id\u0151",
               "",
               "szamoai ny\u00e1ri id\u0151",
               "",
               "szamoai id\u0151",
               "",
            };
        final String[] Davis = new String[] {
               "davisi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "kubai t\u00e9li id\u0151",
               "",
               "kubai ny\u00e1ri id\u0151",
               "",
               "kubai id\u0151z\u00f3na",
               "",
            };
        final String[] GMT = new String[] {
               "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "f\u00fcl\u00f6p-szigeteki t\u00e9li id\u0151",
               "",
               "f\u00fcl\u00f6p-szigeteki ny\u00e1ri id\u0151",
               "",
               "f\u00fcl\u00f6p-szigeteki id\u0151",
               "",
            };
        final String[] French_Southern = new String[] {
               "francia d\u00e9li \u00e9s antarktiszi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "\u00faj-kaled\u00f3niai t\u00e9li id\u0151",
               "",
               "\u00faj-kaled\u00f3niai ny\u00e1ri id\u0151",
               "",
               "\u00faj-kaled\u00f3niai id\u0151",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u00e1ni t\u00e9li id\u0151",
               "",
               "ir\u00e1ni ny\u00e1ri id\u0151",
               "",
               "ir\u00e1ni id\u0151",
               "",
            };
        final String[] Tajikistan = new String[] {
               "t\u00e1dzsikiszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tongai t\u00e9li id\u0151",
               "",
               "tongai ny\u00e1ri id\u0151",
               "",
               "tongai id\u0151",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladesi t\u00e9li id\u0151",
               "",
               "bangladesi ny\u00e1ri id\u0151",
               "",
               "bangladesi id\u0151",
               "",
            };
        final String[] Peru = new String[] {
               "perui t\u00e9li id\u0151",
               "",
               "perui ny\u00e1ri id\u0151",
               "",
               "perui id\u0151",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "kelet-gr\u00f6nlandi t\u00e9li id\u0151",
               "",
               "kelet-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "",
               "kelet-gr\u00f6nlandi id\u0151z\u00f3na",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "kelet-indon\u00e9ziai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiziszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "kelet-ausztr\u00e1liai t\u00e9li id\u0151",
               "",
               "kelet-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "",
               "kelet-ausztr\u00e1liai id\u0151",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francia-guyanai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "kolumbiai t\u00e9li id\u0151",
               "",
               "kolumbiai ny\u00e1ri id\u0151",
               "",
               "kolumbiai id\u0151",
               "",
            };
        final String[] Chile = new String[] {
               "chilei t\u00e9li id\u0151",
               "",
               "chilei ny\u00e1ri id\u0151",
               "",
               "chilei id\u0151z\u00f3na",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "gilbert-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutszki t\u00e9li id\u0151",
               "",
               "irkutszki ny\u00e1ri id\u0151",
               "",
               "irkutszki id\u0151",
               "",
            };
        final String[] Georgia = new String[] {
               "gr\u00faziai t\u00e9li id\u0151",
               "",
               "gr\u00faziai ny\u00e1ri id\u0151",
               "",
               "gr\u00faziai id\u0151",
               "",
            };
        final String[] Choibalsan = new String[] {
               "csojbalszani t\u00e9li id\u0151",
               "",
               "csojbalszani ny\u00e1ri id\u0151",
               "",
               "csojbalszani id\u0151",
               "",
            };
        final String[] China = new String[] {
               "k\u00ednai t\u00e9li id\u0151",
               "",
               "k\u00ednai ny\u00e1ri id\u0151",
               "",
               "k\u00ednai id\u0151",
               "",
            };
        final String[] Armenia = new String[] {
               "\u00f6rm\u00e9nyorsz\u00e1gi t\u00e9li id\u0151",
               "",
               "\u00f6rm\u00e9nyorsz\u00e1gi ny\u00e1ri id\u0151",
               "",
               "\u00f6rm\u00e9nyorsz\u00e1gi id\u0151",
               "",
            };
        final String[] Africa_Central = new String[] {
               "k\u00f6z\u00e9p-afrikai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "jap\u00e1n t\u00e9li id\u0151",
               "",
               "jap\u00e1n ny\u00e1ri id\u0151",
               "",
               "jap\u00e1n id\u0151",
               "",
            };
        final String[] Taipei = new String[] {
               "taipei t\u00e9li id\u0151",
               "",
               "taipei ny\u00e1ri id\u0151",
               "",
               "taipei id\u0151",
               "",
            };
        final String[] Hovd = new String[] {
               "hovdi t\u00e9li id\u0151",
               "",
               "hovdi ny\u00e1ri id\u0151",
               "",
               "hovdi id\u0151",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai id\u0151",
               "",
            };
        final String[] Sakhalin = new String[] {
               "szahalini t\u00e9li id\u0151",
               "",
               "szahalini ny\u00e1ri id\u0151",
               "",
               "szahalini id\u0151",
               "",
            };
        final String[] Paraguay = new String[] {
               "paraguayi t\u00e9li id\u0151",
               "",
               "paraguayi ny\u00e1ri id\u0151",
               "",
               "paraguayi id\u0151",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajziai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "egyezm\u00e9nyes koordin\u00e1lt vil\u00e1gid\u0151",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritiusi t\u00e9li id\u0151",
               "",
               "mauritiusi ny\u00e1ri id\u0151",
               "",
               "mauritiusi id\u0151z\u00f3na",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "kelet-afrikai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "salamon-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "marshall-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u00faj-fundlandi z\u00f3naid\u0151",
               "",
               "\u00faj-fundlandi ny\u00e1ri id\u0151",
               "",
               "\u00faj-fundlandi id\u0151",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afganiszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongi t\u00e9li id\u0151",
               "",
               "hongkongi ny\u00e1ri id\u0151",
               "",
               "hongkongi id\u0151z\u00f3na",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlanti-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "",
               "atlanti-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "",
               "atlanti-\u00f3ce\u00e1ni id\u0151",
               "",
            };
        final String[] Israel = new String[] {
               "izraeli t\u00e9li id\u0151",
               "",
               "izraeli ny\u00e1ri id\u0151",
               "",
               "izraeli id\u0151",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "k\u00f6z\u00e9p-indon\u00e9ziai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omszki t\u00e9li id\u0151",
               "",
               "omszki ny\u00e1ri id\u0151",
               "",
               "omszki id\u0151",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelle-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayi t\u00e9li id\u0151",
               "",
               "uruguayi ny\u00e1ri id\u0151",
               "",
               "uruguayi id\u0151",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "truki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatui t\u00e9li id\u0151",
               "",
               "vanuatui ny\u00e1ri id\u0151",
               "",
               "vanuatui id\u0151",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "novoszibirszki t\u00e9li id\u0151",
               "",
               "novoszibirszki ny\u00e1ri id\u0151",
               "",
               "novoszibirszki id\u0151",
               "",
            };
        final String[] Singapore = new String[] {
               "szingap\u00fari t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "azori t\u00e9li id\u0151",
               "",
               "azori ny\u00e1ri id\u0151",
               "",
               "azori id\u0151z\u00f3na",
               "",
            };
        final String[] Suriname = new String[] {
               "szurin\u00e1mi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasznojarszki t\u00e9li id\u0151",
               "",
               "krasznojarszki ny\u00e1ri id\u0151",
               "",
               "krasznojarszki id\u0151",
               "",
            };
        final String[] Myanmar = new String[] {
               "mianmari id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "amaz\u00f3niai t\u00e9li id\u0151",
               "",
               "amaz\u00f3niai ny\u00e1ri id\u0151",
               "",
               "amaz\u00f3niai id\u0151",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "kelet-kazahszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "fidzsi t\u00e9li id\u0151",
               "",
               "fidzsi ny\u00e1ri id\u0151",
               "",
               "fidzsi id\u0151",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovszk-kamcsatkai z\u00f3naid\u0151",
               "",
               "Petropavlovszk-kamcsatkai ny\u00e1ri id\u0151",
               "",
               "Petropavlovszk-kamcsatkai id\u0151",
               "",
            };
        final String[] Tuvalu = new String[] {
               "tuvalui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "macquarie-szigeti t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaii-aleuti t\u00e9li id\u0151",
               "",
               "hawaii-aleuti ny\u00e1ri id\u0151",
               "",
               "hawaii-aleuti id\u0151z\u00f3na",
               "",
            };
        final String[] Australia_Central = new String[] {
               "k\u00f6z\u00e9p-ausztr\u00e1liai t\u00e9li id\u0151",
               "",
               "k\u00f6z\u00e9p-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "",
               "k\u00f6z\u00e9p-ausztr\u00e1liai id\u0151",
               "",
            };
        final String[] America_Pacific = new String[] {
               "csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "",
               "csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "",
               "csendes-\u00f3ce\u00e1ni id\u0151",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "t\u00fcrkmeniszt\u00e1ni t\u00e9li id\u0151",
               "",
               "t\u00fcrkmeniszt\u00e1ni ny\u00e1ri id\u0151",
               "",
               "t\u00fcrkmeniszt\u00e1ni id\u0151",
               "",
            };
        final String[] Europe_Western = new String[] {
               "nyugat-eur\u00f3pai t\u00e9li id\u0151",
               "WET",
               "nyugat-eur\u00f3pai ny\u00e1ri id\u0151",
               "WEST",
               "nyugat-eur\u00f3pai id\u0151z\u00f3na",
               "WET",
            };
        final String[] Guyana = new String[] {
               "guyanai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pitcairn-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "rotherai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palaui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzs\u00e1ni t\u00e9li id\u0151",
               "",
               "azerbajdzs\u00e1ni ny\u00e1ri id\u0151",
               "",
               "azerbajdzs\u00e1ni id\u0151",
               "",
            };
        final String[] Mawson = new String[] {
               "mawsoni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni id\u0151",
               "",
            };
        final String[] Africa_Western = new String[] {
               "nyugat-afrikai t\u00e9li id\u0151",
               "",
               "nyugat-afrikai ny\u00e1ri id\u0151",
               "",
               "nyugat-afrikai id\u0151z\u00f3na",
               "",
            };
        final String[] South_Georgia = new String[] {
               "d\u00e9li-georgiai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "h\u00fasv\u00e9t-szigeti t\u00e9li id\u0151",
               "",
               "h\u00fasv\u00e9t-szigeti ny\u00e1ri id\u0151",
               "",
               "h\u00fasv\u00e9t-szigeti id\u0151z\u00f3na",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u00e9szaknyugat-mexik\u00f3i z\u00f3naid\u0151",
               "",
               "\u00e9szaknyugat-mexik\u00f3i ny\u00e1ri id\u0151",
               "",
               "\u00e9szaknyugat-mexik\u00f3i id\u0151",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "dumont-d\u2019Urville-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "nyugat-gr\u00f6nlandi t\u00e9li id\u0151",
               "",
               "nyugat-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "",
               "nyugat-gr\u00f6nlandi id\u0151z\u00f3na",
               "",
            };
        final String[] Ecuador = new String[] {
               "ecuadori t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00f6b\u00f6lbeli t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "koreai t\u00e9li id\u0151",
               "",
               "koreai ny\u00e1ri id\u0151",
               "",
               "koreai id\u0151",
               "",
            };
        final String[] Australia_Western = new String[] {
               "nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "",
               "nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "",
               "nyugat-ausztr\u00e1liai id\u0151",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "nyugat-indon\u00e9ziai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hegyvid\u00e9ki z\u00f3naid\u0151",
               "",
               "hegyvid\u00e9ki ny\u00e1ri id\u0151",
               "",
               "hegyvid\u00e9ki id\u0151",
               "",
            };
        final String[] Marquesas = new String[] {
               "marquises-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arab t\u00e9li id\u0151",
               "",
               "arab ny\u00e1ri id\u0151",
               "",
               "arab id\u0151",
               "",
            };
        final String[] Alaska = new String[] {
               "alaszkai z\u00f3naid\u0151",
               "",
               "alaszkai ny\u00e1ri id\u0151",
               "",
               "alaszkai id\u0151",
               "",
            };
        final String[] Vladivostok = new String[] {
               "vlagyivosztoki t\u00e9li id\u0151",
               "",
               "vlagyivosztoki ny\u00e1ri id\u0151",
               "",
               "vlagyivosztoki id\u0151",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorr\u00f3i t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelaui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "p\u00e1pua \u00faj-guineai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-i t\u00e9li id\u0151",
               "",
               "Fernando de Noronha-i ny\u00e1ri id\u0151",
               "",
               "Fernando de Noronha-i id\u0151",
               "",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edliai t\u00e9li id\u0151",
               "",
               "braz\u00edliai ny\u00e1ri id\u0151",
               "",
               "braz\u00edliai id\u0151",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anad\u00edri z\u00f3naid\u0151",
               "",
               "Anad\u00edri ny\u00e1ri id\u0151",
               "",
               "Anadiri id\u0151",
               "",
            };
        final String[] Samara = new String[] {
               "Szamarai z\u00f3naid\u0151",
               "",
               "Szamarai ny\u00e1ri id\u0151",
               "",
               "Szamarai id\u0151",
               "",
            };
        final String[] Pyongyang = new String[] {
               "phenjani id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indiai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "cook-szigeteki t\u00e9li id\u0151",
               "",
               "cook-szigeteki f\u00e9l ny\u00e1ri id\u0151",
               "",
               "cook-szigeteki id\u0151",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-szigetek" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vosztok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, \u00c9szak-Dakota" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fidzsi" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u00e1r" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malab\u00f3" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addisz-Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Pacific/Truk", "Truk" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "London" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn-szigetek" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasznojarszk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Csojbalszan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznyeck" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway-szigetek" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Africa/Asmera", "Asmera" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro-z\u00e1tony" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, \u00c9szak-Dakota" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "D\u00e9li-Georgia" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "R\u00f3ma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karacsi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El-Aj\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, \u00c9szak-Dakota" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Biskek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Ismeretlen v\u00e1ros" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Ungv\u00e1r" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Alg\u00edr" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Kart\u00fam" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos-szigetek" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovszk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "\u00edr ny\u00e1ri id\u0151",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Szaratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Akt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Szent Ilona" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Man-sziget" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "P\u00e1rizs" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1gr\u00e1b" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Csita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomszk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuvait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moszkva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tor" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novoszibirszk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Szrednekolimszk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Toki\u00f3" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Z\u00f6ld-foki szigetek" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azori-szigetek" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Kar\u00e1csony-sziget" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinyingr\u00e1d" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati-sziget" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Pr\u00e1ga" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Ponape-szigetek" },
            { "timezone.excity.Asia/Irkutsk", "Irkutszk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kamcsatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutszk" },
            { "timezone.excity.Africa/Djibouti", "Dzsibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Sanghaj" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "H\u00fasv\u00e9t-szigetek" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Pacific/Wake", "Wake-sziget" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1ri-szigetek" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerev\u00e1n" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Kair\u00f3" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Tbilisi", "Tbiliszi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minszk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Szimferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgogr\u00e1d" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Phenjan" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Ath\u00e9n" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Koppenh\u00e1ga" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzs\u00e1lem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Uszty-Nyera" },
            { "timezone.excity.Asia/Damascus", "Damaszkusz" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae-szigetek" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es-Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Si Minh-v\u00e1ros" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekatyerinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sz\u00f3fia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Asztrah\u00e1n" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgr\u00e1d" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "G\u00e1za" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Mexik\u00f3v\u00e1ros" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein-z\u00e1tony" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisszabon" },
            { "timezone.excity.Pacific/Gambier", "Gambier-szigetek" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozsje" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham-szigetek" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Szahalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "M\u00e1lta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Sz\u00f6ul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Isztanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Szarajev\u00f3" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vlagyivosztok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunisz" },
            { "timezone.excity.Asia/Macau", "Maka\u00f3" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Szamarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Szingap\u00far" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "B\u00e9cs" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kajm\u00e1n-szigetek" },
            { "timezone.excity.Europe/Bratislava", "Pozsony" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omszk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Fer\u00f6er" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kucseng" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Asgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "\u00c1den" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amszterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "K\u00f3kusz-sziget" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Br\u00fcsszel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komor\u00f3" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Szamara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Mald\u00edv-szigetek" },
        };
        return data;
    }
}
