/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractWindowsTerminalInput;
import net.rubygrapefruit.platform.internal.CharInputBuffer;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

public class WindowsTerminalInput
extends AbstractWindowsTerminalInput {
    private boolean raw;

    public String toString() {
        return "Windows console on stdin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(TerminalInputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.raw) {
                FunctionResult result = new FunctionResult();
                CharInputBuffer buffer = new CharInputBuffer();
                WindowsConsoleFunctions.readInput(buffer, result);
                if (result.isFailed()) {
                    throw new NativeException(String.format("Could not read from console: %s", result.getMessage()));
                }
                buffer.applyTo(listener);
            } else {
                this.readNonRaw(listener);
            }
        }
    }

    @Override
    public boolean supportsRawMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalInput rawMode() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.rawInputMode(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not switch console input to raw mode: %s", result.getMessage()));
            }
            this.raw = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalInput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.resetInputMode(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not reset console input mode: %s", result.getMessage()));
            }
            this.raw = false;
        }
        return this;
    }
}

