/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.util.CollectionUtils;

public class BuildQueue<T extends BuildableType>
implements Consumer {
    private final List<T> queue = new ArrayList<T>();
    private CompletionAction completionAction = CompletionAction.REMOVE;
    private int priority = 500;
    private final Colony colony;

    public BuildQueue(Colony colony, CompletionAction action, int priority) {
        this.colony = colony;
        this.completionAction = action;
        this.priority = priority;
    }

    public void clear() {
        this.queue.clear();
    }

    public void add(T buildable) {
        this.queue.add(buildable);
    }

    public List<T> getValues() {
        return this.queue;
    }

    public void setValues(List<T> values) {
        this.clear();
        this.queue.addAll(values);
    }

    public void remove(int index) {
        this.queue.remove(index);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public final CompletionAction getCompletionAction() {
        return this.completionAction;
    }

    public final void setCompletionAction(CompletionAction newCompletionAction) {
        this.completionAction = newCompletionAction;
    }

    public T getCurrentlyBuilding() {
        return (T)(this.queue.isEmpty() ? null : (BuildableType)this.queue.get(0));
    }

    public void setCurrentlyBuilding(T buildable) {
        if (buildable == null) {
            this.clear();
        } else {
            if (buildable instanceof BuildingType && this.queue.contains(buildable)) {
                this.queue.remove(buildable);
            }
            this.queue.add(0, buildable);
        }
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        T current = this.getCurrentlyBuilding();
        if (current != null) {
            boolean overflow = this.colony.getSpecification().getBoolean("model.option.saveProductionOverflow");
            ArrayList<AbstractGoods> consumption = new ArrayList<AbstractGoods>();
            for (AbstractGoods ag : ((BuildableType)current).getRequiredGoodsList()) {
                AbstractGoods available = CollectionUtils.find(input, AbstractGoods.matches(ag.getType()));
                if (available != null && ag.getAmount() <= available.getAmount()) {
                    int amount = overflow || ag.getType().isStorable() ? ag.getAmount() : available.getAmount();
                    consumption.add(new AbstractGoods(ag.getType(), amount));
                    continue;
                }
                return result;
            }
            result.setConsumption(consumption);
        }
        return result;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        T current = this.getCurrentlyBuilding();
        return current == null ? Collections.emptyList() : ((BuildableType)current).getRequiredGoodsList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Stream<Modifier> getConsumptionModifiers(String id) {
        return Stream.empty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[BuildQueue (").append(this.colony.getName()).append(')');
        for (BuildableType item : this.queue) {
            sb.append(' ').append(item.getId());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum CompletionAction {
        REMOVE,
        REMOVE_EXCEPT_LAST,
        SHUFFLE,
        ADD_RANDOM;

    }
}

