/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NumberRules;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class MessagesTest
extends FreeColTestCase {
    public static final String noSuchKey = "should.not.exist.and.thus.return.null";
    private static final Role armedBraveRole = MessagesTest.spec().getRole("model.role.armedBrave");
    private static final Role cavalryRole = MessagesTest.spec().getRole("model.role.cavalry");
    private static final Role defaultRole = MessagesTest.spec().getDefaultRole();
    private static final Role dragoonRole = MessagesTest.spec().getRole("model.role.dragoon");
    private static final Role infantryRole = MessagesTest.spec().getRole("model.role.infantry");
    private static final Role missionaryRole = MessagesTest.spec().getRole("model.role.missionary");
    private static final Role mountedBraveRole = MessagesTest.spec().getRole("model.role.mountedBrave");
    private static final Role nativeDragoonRole = MessagesTest.spec().getRole("model.role.nativeDragoon");
    private static final Role pioneerRole = MessagesTest.spec().getRole("model.role.pioneer");
    private static final Role scoutRole = MessagesTest.spec().getRole("model.role.scout");
    private static final Role soldierRole = MessagesTest.spec().getRole("model.role.soldier");
    private static final UnitType artillery = MessagesTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType brave = MessagesTest.spec().getUnitType("model.unit.brave");
    private static final UnitType caravel = MessagesTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType colonialRegular = MessagesTest.spec().getUnitType("model.unit.colonialRegular");
    private static final UnitType freeColonist = MessagesTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType hardyPioneer = MessagesTest.spec().getUnitType("model.unit.hardyPioneer");
    private static final UnitType jesuitMissionary = MessagesTest.spec().getUnitType("model.unit.jesuitMissionary");
    private static final UnitType kingsRegular = MessagesTest.spec().getUnitType("model.unit.kingsRegular");
    private static final UnitType manOWar = MessagesTest.spec().getUnitType("model.unit.manOWar");
    private static final UnitType masterCarpenter = MessagesTest.spec().getUnitType("model.unit.masterCarpenter");
    private static final UnitType seasonedScout = MessagesTest.spec().getUnitType("model.unit.seasonedScout");
    private static final UnitType treasureTrain = MessagesTest.spec().getUnitType("model.unit.treasureTrain");
    private static final UnitType veteranSoldier = MessagesTest.spec().getUnitType("model.unit.veteranSoldier");

    @Override
    public void tearDown() {
        Messages.loadMessageBundle(Locale.US);
    }

    public void testMessageString() {
        MessagesTest.assertEquals((String)"Press enter in order to end the turn.", (String)Messages.message("infoPanel.endTurn"));
        MessagesTest.assertEquals((String)"Trade Advisor", (String)Messages.message("reportTradeAction.name"));
        MessagesTest.assertEquals((String)"Score: %score%    |    Gold: %gold%    |    Tax: %tax%%    |    Year: %year%", (String)Messages.message("menuBar.statusLine"));
        MessagesTest.assertEquals((String)"Food is necessary to feed your colonists and to breed horses. A new colonist is born whenever a colony has 200 units of food or more.", (String)Messages.message("model.goods.food.description"));
        MessagesTest.assertEquals((String)noSuchKey, (String)Messages.message(noSuchKey));
    }

    public void testChangeLocaleSettings() {
        Messages.loadMessageBundle(Locale.US);
        MessagesTest.assertEquals((String)"Trade Advisor", (String)Messages.message("reportTradeAction.name"));
        Messages.loadMessageBundle(Locale.GERMANY);
        MessagesTest.assertEquals((String)"Handelsberater", (String)Messages.message("reportTradeAction.name"));
    }

    public void testMessageWithSpecialChars() {
        String key = HistoryEvent.HistoryEventType.FOUND_COLONY.getDescriptionKey();
        try {
            MessagesTest.assertEquals((String)"You establish the colony of %colony%.", (String)Messages.message(key));
        }
        catch (Exception e) {
            MessagesTest.fail((String)"Message fail");
            throw e;
        }
        String colNameWithSpecialChars = "$specialColName\\";
        try {
            MessagesTest.assertEquals((String)"You establish the colony of $specialColName\\.", (String)Messages.message(StringTemplate.template(key).addName("%colony%", "$specialColName\\")));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Illegal group reference")) {
                MessagesTest.fail((String)"Does not process messages with special chars");
            }
            throw e;
        }
    }

    public void testStringTemplates() {
        Game game = MessagesTest.getGame();
        game.changeMap(MessagesTest.getTestMap());
        Messages.loadMessageBundle(Locale.US);
        StringTemplate s1 = StringTemplate.key("!no.such.string.template");
        MessagesTest.assertEquals((String)s1.getId(), (String)Messages.message(s1));
        StringTemplate s2 = StringTemplate.key("model.tile.plains.name");
        MessagesTest.assertEquals((String)"Plains", (String)Messages.message(s2));
        StringTemplate t1 = new AbstractGoods(MessagesTest.spec().getPrimaryFoodType(), 100).getLabel();
        MessagesTest.assertEquals((int)2, (int)t1.entryList().size());
        List<AbstractMap.SimpleEntry<String, StringTemplate>> e = t1.entryList();
        MessagesTest.assertEquals((Object)((Object)StringTemplate.TemplateType.KEY), (Object)((Object)e.get(0).getValue().getTemplateType()));
        MessagesTest.assertEquals((Object)((Object)StringTemplate.TemplateType.NAME), (Object)((Object)e.get(1).getValue().getTemplateType()));
        MessagesTest.assertEquals((String)"model.abstractGoods.label", (String)t1.getId());
        MessagesTest.assertEquals((String)"100 Food", (String)Messages.message(t1));
        Object t2 = ((StringTemplate)StringTemplate.label(" / ").add("model.goods.food.name")).addName("xyz");
        MessagesTest.assertEquals((String)"Food / xyz", (String)Messages.message(t2));
        Colony colony = this.getStandardColony();
        MessagesTest.assertEquals((String)"New Amsterdam", (String)colony.getName());
        Object t3 = StringTemplate.template("model.building.locationLabel").addName("%location%", colony.getName());
        MessagesTest.assertEquals((String)"In New Amsterdam", (String)Messages.message(t3));
        Object t4 = ((StringTemplate)((StringTemplate)StringTemplate.label("").addName("(")).add("model.goods.food.name")).addName(")");
        MessagesTest.assertEquals((String)"(Food)", (String)Messages.message(t4));
    }

    public void testReplaceGarbage() {
        String mapping = "some.key={{}}abc   {{xyz}}def{{123|567}}\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(mapping.getBytes());
        try {
            Messages.loadMessages(stream);
        }
        catch (IOException ioe) {
            MessagesTest.fail();
        }
        MessagesTest.assertEquals((String)"abc   def", (String)Messages.message("some.key"));
    }

    public void testReplaceNumber() {
        double[] numbers = new double[]{-1.3, -1.0, -0.5, 0.0, 0.33, 1.0, 1.2, 2.0, 2.7, 3.0, 3.4, 11.0, 13.0, 27.0, 100.0};
        String mapping = "some.key=abc{{plural:%number%|zero=zero|one=one|two=two|few=few|many=many|other=other}}|xyz";
        ByteArrayInputStream stream = new ByteArrayInputStream(mapping.getBytes());
        try {
            Messages.loadMessages(stream);
        }
        catch (IOException ioe) {
            MessagesTest.fail();
        }
        Messages.setGrammaticalNumber(NumberRules.OTHER_NUMBER_RULE);
        for (double d : numbers) {
            MessagesTest.assertEquals((String)"abcother|xyz", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", d)));
        }
        Messages.setGrammaticalNumber(NumberRules.PLURAL_NUMBER_RULE);
        for (double d : numbers) {
            if (d == 1.0) {
                MessagesTest.assertEquals((String)"abcone|xyz", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", d)));
                continue;
            }
            MessagesTest.assertEquals((String)"abcother|xyz", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", d)));
        }
    }

    public void testReplaceArbitraryTag() {
        String testKey = "model.player.startGame";
        Object template = StringTemplate.template("model.player.startGame").add("%direction%", "east");
        String expected = "After months at sea, you have finally arrived off the coast of an unknown continent. Sail eastward in order to discover the New World and to claim it for the Crown.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
        template = StringTemplate.template("model.player.startGame").add("%direction%", "west");
        expected = "After months at sea, you have finally arrived off the coast of an unknown continent. Sail westward in order to discover the New World and to claim it for the Crown.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
        template = StringTemplate.template("model.player.startGame").add("%direction%", "whatever");
        expected = "After months at sea, you have finally arrived off the coast of an unknown continent. Sail into the wind in order to discover the New World and to claim it for the Crown.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
    }

    public void testReplaceChoicesPlural() {
        String mapping = "some.key=This is {{plural:%number%|one=a test|other=one of several tests|default=not much of a test}}.\nunit.template=%number% {{plural:%number%|%unit%}}\nunit.key={{plural:%number%|one=piece of artillery|other=pieces of artillery|default=artillery}}";
        ByteArrayInputStream stream = new ByteArrayInputStream(mapping.getBytes());
        try {
            Messages.loadMessages(stream);
        }
        catch (IOException ioe) {
            MessagesTest.fail();
        }
        MessagesTest.assertEquals((String)"artillery", (String)Messages.message("unit.key"));
        MessagesTest.assertEquals((String)"This is one of several tests.", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", 0)));
        MessagesTest.assertEquals((String)"This is a test.", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", 1)));
        MessagesTest.assertEquals((String)"This is one of several tests.", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", 2)));
        MessagesTest.assertEquals((String)"This is one of several tests.", (String)Messages.message(StringTemplate.template("some.key").addAmount("%number%", 24)));
        Object template = ((StringTemplate)StringTemplate.template("unit.template").addAmount("%number%", 1)).add("%unit%", "unit.key");
        MessagesTest.assertEquals((String)"1 piece of artillery", (String)Messages.message(template));
    }

    public void testReplaceChoicesGrammar() {
        String mapping = "key.france={{randomTag:%randomKey%|country=France|people=French|default=French people}}\ngreeting1=The {{otherRandomTag:default|%nation%}} are happy to see you.\ngreeting2=The {{otherRandomTag:people|%nation%}} are happy to see you.\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(mapping.getBytes());
        try {
            Messages.loadMessages(stream);
        }
        catch (IOException ioe) {
            MessagesTest.fail();
        }
        MessagesTest.assertEquals((String)"French people", (String)Messages.message("key.france"));
        Object t1 = StringTemplate.template("key.france").addTagged("%randomKey%", "country");
        MessagesTest.assertEquals((String)"France", (String)Messages.message(t1));
        Object t2 = StringTemplate.template("greeting1").add("%nation%", "key.france");
        MessagesTest.assertEquals((String)"The French people are happy to see you.", (String)Messages.message(t2));
        Object t3 = StringTemplate.template("greeting2").add("%nation%", "key.france");
        MessagesTest.assertEquals((String)"The French are happy to see you.", (String)Messages.message(t3));
    }

    public void testNestedChoices() {
        String mapping = "key1=%colony% tuottaa tuotetta {{tag:acc|%goods%}}.\nkey2={{plural:%amount%|one=ruoka|other=ruokaa|default={{tag:|acc=viljaa|default=Vilja}}}}\nkey3={{tag:|acc=viljaa|default={{plural:%amount%|one=ruoka|other=ruokaa|default=Ruoka}}}}\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(mapping.getBytes());
        try {
            Messages.loadMessages(stream);
        }
        catch (IOException ioe) {
            MessagesTest.fail();
        }
        Object t = ((StringTemplate)StringTemplate.template("key1").addName("%colony%", "someColony")).add("%goods%", "key2");
        MessagesTest.assertEquals((String)"someColony tuottaa tuotetta viljaa.", (String)Messages.message(t));
        MessagesTest.assertEquals((String)"Ruoka", (String)Messages.message(StringTemplate.key("key3")));
        MessagesTest.assertEquals((String)"Ruoka", (String)Messages.message("key3"));
    }

    public void testREFMessages() {
        Object template = ((StringTemplate)StringTemplate.template(Monarch.MonarchAction.ADD_TO_REF.getTextKey()).addAmount("%number%", 1)).addNamed("%unit%", kingsRegular);
        String expected = "The Crown has added 1 King's Regular to the Royal Expeditionary Force. Colonial leaders express concern.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
        template = ((StringTemplate)StringTemplate.template(Monarch.MonarchAction.ADD_TO_REF.getTextKey()).addAmount("%number%", 2)).addNamed("%unit%", artillery);
        expected = "The Crown has added 2 Pieces of Artillery to the Royal Expeditionary Force. Colonial leaders express concern.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
        template = ((StringTemplate)StringTemplate.template(Monarch.MonarchAction.ADD_TO_REF.getTextKey()).addAmount("%number%", 3)).addNamed("%unit%", manOWar);
        expected = "The Crown has added 3 Men of War to the Royal Expeditionary Force. Colonial leaders express concern.";
        MessagesTest.assertEquals((String)expected, (String)Messages.message(template));
    }

    public void testAbstractUnitDescription() {
        AbstractUnit au = new AbstractUnit("model.unit.merchantman", "model.role.default", 1);
        MessagesTest.assertEquals((String)"one Merchantman", (String)au.getDescription());
    }

    public void testUnitDescription() {
        Game game = MessagesTest.getStandardGame();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Nation refNation = dutch.getNation().getREFNation();
        ServerPlayer dutchREF = new ServerPlayer(game, false, refNation);
        ServerPlayer sioux = this.getServerPlayer(game, "model.nation.sioux");
        ServerUnit unit = new ServerUnit(game, null, dutchREF, kingsRegular, defaultRole);
        MessagesTest.assertEquals((String)"King's Regular", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force King's Regular", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force King's Regular", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(infantryRole, 1);
        MessagesTest.assertEquals((String)"Infantry", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force Infantry", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force Infantry (50 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(cavalryRole, 1);
        MessagesTest.assertEquals((String)"Cavalry", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force Cavalry", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Royal Expeditionary Force Cavalry (50 Muskets 50 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, colonialRegular, defaultRole);
        MessagesTest.assertEquals((String)"Colonial Regular", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Colonial Regular", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Colonial Regular", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(soldierRole, 1);
        MessagesTest.assertEquals((String)"Continental Army", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Continental Army", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Continental Army (50 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(dragoonRole, 1);
        MessagesTest.assertEquals((String)"Continental Cavalry", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Continental Cavalry", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Continental Cavalry (50 Muskets 50 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, veteranSoldier, soldierRole);
        MessagesTest.assertEquals((String)"Veteran Soldier", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Veteran Soldier", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Veteran Soldier (50 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(defaultRole, 0);
        MessagesTest.assertEquals((String)"Veteran Soldier", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Veteran Soldier", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Veteran Soldier (no muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(dragoonRole, 1);
        MessagesTest.assertEquals((String)"Veteran Dragoon", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Veteran Dragoon", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Veteran Dragoon (50 Muskets 50 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("Davy Crockett");
        MessagesTest.assertEquals((String)"Davy Crockett (Veteran Dragoon)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Davy Crockett (Dutch Veteran Dragoon)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Davy Crockett (Dutch Veteran Dragoon/50 Muskets 50 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, sioux, brave, defaultRole);
        MessagesTest.assertEquals((String)"Brave", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Sioux Brave", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Sioux Brave", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(armedBraveRole, 1);
        MessagesTest.assertEquals((String)"Armed Brave", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Sioux Armed Brave", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Sioux Armed Brave (25 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(mountedBraveRole, 1);
        MessagesTest.assertEquals((String)"Mounted Brave", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Sioux Mounted Brave", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Sioux Mounted Brave (25 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(nativeDragoonRole, 1);
        MessagesTest.assertEquals((String)"Native Dragoon", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Sioux Native Dragoon", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Sioux Native Dragoon (25 Muskets 25 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("Chingachgook");
        MessagesTest.assertEquals((String)"Chingachgook (Native Dragoon)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Chingachgook (Sioux Native Dragoon)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Chingachgook (Sioux Native Dragoon/25 Muskets 25 Horses)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, hardyPioneer, pioneerRole);
        MessagesTest.assertEquals((String)"Hardy Pioneer", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Hardy Pioneer (100 Tools)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Hardy Pioneer (100 Tools)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(defaultRole, 0);
        MessagesTest.assertEquals((String)"Hardy Pioneer", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Hardy Pioneer", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Hardy Pioneer (no tools)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("Daniel Boone");
        MessagesTest.assertEquals((String)"Daniel Boone (Hardy Pioneer)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Daniel Boone (Dutch Hardy Pioneer)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Daniel Boone (Dutch Hardy Pioneer/no tools)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, jesuitMissionary, missionaryRole);
        MessagesTest.assertEquals((String)"Jesuit Missionary", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Jesuit Missionary", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Jesuit Missionary (1 Bible)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.changeRole(defaultRole, 0);
        MessagesTest.assertEquals((String)"Jesuit Missionary", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Jesuit Missionary", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Jesuit Missionary (not commissioned)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, freeColonist, defaultRole);
        MessagesTest.assertEquals((String)"Free Colonist", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Free Colonist", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Free Colonist", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setRole(soldierRole);
        MessagesTest.assertEquals((String)"Soldier (Free Colonist)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Soldier (Free Colonist)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Soldier (Free Colonist/50 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("John Doe");
        MessagesTest.assertEquals((String)"John Doe (Soldier/Free Colonist)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"John Doe (Dutch Soldier/Free Colonist)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"John Doe (Dutch Soldier/Free Colonist/50 Muskets)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, masterCarpenter, defaultRole);
        MessagesTest.assertEquals((String)"Master Carpenter", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Master Carpenter", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Master Carpenter", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setRole(missionaryRole);
        MessagesTest.assertEquals((String)"Missionary (Master Carpenter)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Missionary (Master Carpenter)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Missionary (Master Carpenter/1 Bible)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, treasureTrain, defaultRole);
        unit.setTreasureAmount(4567);
        MessagesTest.assertEquals((String)"Treasure Train", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Treasure Train", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Treasure Train (4567 gold)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("The Gold of El Dorado");
        MessagesTest.assertEquals((String)"The Gold of El Dorado (Treasure Train)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"The Gold of El Dorado (Dutch Treasure Train)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"The Gold of El Dorado (Dutch Treasure Train/4567 gold)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit = new ServerUnit(game, null, dutch, caravel, defaultRole);
        MessagesTest.assertEquals((String)"Caravel", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Dutch Caravel", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Dutch Caravel", (String)unit.getDescription(Unit.UnitLabelType.FULL));
        unit.setName("Santa Maria");
        MessagesTest.assertEquals((String)"Santa Maria (Caravel)", (String)unit.getDescription());
        MessagesTest.assertEquals((String)"Santa Maria (Dutch Caravel)", (String)unit.getDescription(Unit.UnitLabelType.NATIONAL));
        MessagesTest.assertEquals((String)"Santa Maria (Dutch Caravel)", (String)unit.getDescription(Unit.UnitLabelType.FULL));
    }
}

