﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/s3/S3_EXPORTS.h>
#include <aws/s3/model/Grant.h>
#include <aws/s3/model/Owner.h>
#include <aws/s3/model/RequestCharged.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace S3 {
namespace Model {
class GetObjectAclResult {
 public:
  AWS_S3_API GetObjectAclResult() = default;
  AWS_S3_API GetObjectAclResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_S3_API GetObjectAclResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p> Container for the bucket owner's ID.</p>
   */
  inline const Owner& GetOwner() const { return m_owner; }
  template <typename OwnerT = Owner>
  void SetOwner(OwnerT&& value) {
    m_ownerHasBeenSet = true;
    m_owner = std::forward<OwnerT>(value);
  }
  template <typename OwnerT = Owner>
  GetObjectAclResult& WithOwner(OwnerT&& value) {
    SetOwner(std::forward<OwnerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of grants.</p>
   */
  inline const Aws::Vector<Grant>& GetGrants() const { return m_grants; }
  template <typename GrantsT = Aws::Vector<Grant>>
  void SetGrants(GrantsT&& value) {
    m_grantsHasBeenSet = true;
    m_grants = std::forward<GrantsT>(value);
  }
  template <typename GrantsT = Aws::Vector<Grant>>
  GetObjectAclResult& WithGrants(GrantsT&& value) {
    SetGrants(std::forward<GrantsT>(value));
    return *this;
  }
  template <typename GrantsT = Grant>
  GetObjectAclResult& AddGrants(GrantsT&& value) {
    m_grantsHasBeenSet = true;
    m_grants.emplace_back(std::forward<GrantsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline RequestCharged GetRequestCharged() const { return m_requestCharged; }
  inline void SetRequestCharged(RequestCharged value) {
    m_requestChargedHasBeenSet = true;
    m_requestCharged = value;
  }
  inline GetObjectAclResult& WithRequestCharged(RequestCharged value) {
    SetRequestCharged(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetObjectAclResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Owner m_owner;
  bool m_ownerHasBeenSet = false;

  Aws::Vector<Grant> m_grants;
  bool m_grantsHasBeenSet = false;

  RequestCharged m_requestCharged{RequestCharged::NOT_SET};
  bool m_requestChargedHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3
}  // namespace Aws
