﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/InAppMessageContent.h>
#include <aws/pinpoint/model/Layout.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>InApp Template Request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/InAppTemplateRequest">AWS
 * API Reference</a></p>
 */
class InAppTemplateRequest {
 public:
  AWS_PINPOINT_API InAppTemplateRequest() = default;
  AWS_PINPOINT_API InAppTemplateRequest(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API InAppTemplateRequest& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The content of the message, can include up to 5 modals. Each modal must
   * contain a message, a header, and background color. ImageUrl and buttons are
   * optional.</p>
   */
  inline const Aws::Vector<InAppMessageContent>& GetContent() const { return m_content; }
  inline bool ContentHasBeenSet() const { return m_contentHasBeenSet; }
  template <typename ContentT = Aws::Vector<InAppMessageContent>>
  void SetContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content = std::forward<ContentT>(value);
  }
  template <typename ContentT = Aws::Vector<InAppMessageContent>>
  InAppTemplateRequest& WithContent(ContentT&& value) {
    SetContent(std::forward<ContentT>(value));
    return *this;
  }
  template <typename ContentT = InAppMessageContent>
  InAppTemplateRequest& AddContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content.emplace_back(std::forward<ContentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Custom config to be sent to client.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetCustomConfig() const { return m_customConfig; }
  inline bool CustomConfigHasBeenSet() const { return m_customConfigHasBeenSet; }
  template <typename CustomConfigT = Aws::Map<Aws::String, Aws::String>>
  void SetCustomConfig(CustomConfigT&& value) {
    m_customConfigHasBeenSet = true;
    m_customConfig = std::forward<CustomConfigT>(value);
  }
  template <typename CustomConfigT = Aws::Map<Aws::String, Aws::String>>
  InAppTemplateRequest& WithCustomConfig(CustomConfigT&& value) {
    SetCustomConfig(std::forward<CustomConfigT>(value));
    return *this;
  }
  template <typename CustomConfigKeyT = Aws::String, typename CustomConfigValueT = Aws::String>
  InAppTemplateRequest& AddCustomConfig(CustomConfigKeyT&& key, CustomConfigValueT&& value) {
    m_customConfigHasBeenSet = true;
    m_customConfig.emplace(std::forward<CustomConfigKeyT>(key), std::forward<CustomConfigValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The layout of the message.</p>
   */
  inline Layout GetLayout() const { return m_layout; }
  inline bool LayoutHasBeenSet() const { return m_layoutHasBeenSet; }
  inline void SetLayout(Layout value) {
    m_layoutHasBeenSet = true;
    m_layout = value;
  }
  inline InAppTemplateRequest& WithLayout(Layout value) {
    SetLayout(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>As of <b>22-05-2023</b> tags has been deprecated for update operations.
   * After this date any value in tags is not processed and an error code is not
   * returned. To manage tags we recommend using either <a
   * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a>
   * in the <i>API Reference for Amazon Pinpoint</i>, <a
   * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a>
   * commands in the <i>AWS Command Line Interface Documentation</i> or <a
   * href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a>
   * in the <i>AWS SDK</i>.</p> <p>(Deprecated) A string-to-string map of
   * key-value pairs that defines the tags to associate with the message template.
   * Each tag consists of a required tag key and an associated tag value.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  InAppTemplateRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  InAppTemplateRequest& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the template.</p>
   */
  inline const Aws::String& GetTemplateDescription() const { return m_templateDescription; }
  inline bool TemplateDescriptionHasBeenSet() const { return m_templateDescriptionHasBeenSet; }
  template <typename TemplateDescriptionT = Aws::String>
  void SetTemplateDescription(TemplateDescriptionT&& value) {
    m_templateDescriptionHasBeenSet = true;
    m_templateDescription = std::forward<TemplateDescriptionT>(value);
  }
  template <typename TemplateDescriptionT = Aws::String>
  InAppTemplateRequest& WithTemplateDescription(TemplateDescriptionT&& value) {
    SetTemplateDescription(std::forward<TemplateDescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<InAppMessageContent> m_content;
  bool m_contentHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_customConfig;
  bool m_customConfigHasBeenSet = false;

  Layout m_layout{Layout::NOT_SET};
  bool m_layoutHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_templateDescription;
  bool m_templateDescriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
