﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/memorydb/MemoryDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MemoryDB {
namespace Model {

/**
 * <p>Represents the output of a CreateMultiRegionParameterGroup operation. A
 * multi-region parameter group represents a collection of parameters that can be
 * applied to clusters across multiple regions.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/MultiRegionParameterGroup">AWS
 * API Reference</a></p>
 */
class MultiRegionParameterGroup {
 public:
  AWS_MEMORYDB_API MultiRegionParameterGroup() = default;
  AWS_MEMORYDB_API MultiRegionParameterGroup(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API MultiRegionParameterGroup& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the multi-region parameter group.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  MultiRegionParameterGroup& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the parameter group family that this multi-region parameter group
   * is compatible with.</p>
   */
  inline const Aws::String& GetFamily() const { return m_family; }
  inline bool FamilyHasBeenSet() const { return m_familyHasBeenSet; }
  template <typename FamilyT = Aws::String>
  void SetFamily(FamilyT&& value) {
    m_familyHasBeenSet = true;
    m_family = std::forward<FamilyT>(value);
  }
  template <typename FamilyT = Aws::String>
  MultiRegionParameterGroup& WithFamily(FamilyT&& value) {
    SetFamily(std::forward<FamilyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the multi-region parameter group.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  MultiRegionParameterGroup& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the multi-region parameter group.</p>
   */
  inline const Aws::String& GetARN() const { return m_aRN; }
  inline bool ARNHasBeenSet() const { return m_aRNHasBeenSet; }
  template <typename ARNT = Aws::String>
  void SetARN(ARNT&& value) {
    m_aRNHasBeenSet = true;
    m_aRN = std::forward<ARNT>(value);
  }
  template <typename ARNT = Aws::String>
  MultiRegionParameterGroup& WithARN(ARNT&& value) {
    SetARN(std::forward<ARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_family;
  bool m_familyHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_aRN;
  bool m_aRNHasBeenSet = false;
};

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
