﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ivschat/Ivschat_EXPORTS.h>
#include <aws/ivschat/model/MessageReviewHandler.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ivschat {
namespace Model {
class GetRoomResult {
 public:
  AWS_IVSCHAT_API GetRoomResult() = default;
  AWS_IVSCHAT_API GetRoomResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IVSCHAT_API GetRoomResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetRoomResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Room ID, generated by the system. This is a relative identifier, the part of
   * the ARN that uniquely identifies the room.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetRoomResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Room name. The value does not need to be unique.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetRoomResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that
   * this is returned as a string</i>.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  GetRoomResult& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that
   * this is returned as a string</i>.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  GetRoomResult& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Maximum number of messages per second that can be sent to the room (by all
   * clients). Default: 10.</p>
   */
  inline int GetMaximumMessageRatePerSecond() const { return m_maximumMessageRatePerSecond; }
  inline void SetMaximumMessageRatePerSecond(int value) {
    m_maximumMessageRatePerSecondHasBeenSet = true;
    m_maximumMessageRatePerSecond = value;
  }
  inline GetRoomResult& WithMaximumMessageRatePerSecond(int value) {
    SetMaximumMessageRatePerSecond(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Maximum number of characters in a single message. Messages are expected to be
   * UTF-8 encoded and this limit applies specifically to rune/code-point count, not
   * number of bytes. Default: 500.</p>
   */
  inline int GetMaximumMessageLength() const { return m_maximumMessageLength; }
  inline void SetMaximumMessageLength(int value) {
    m_maximumMessageLengthHasBeenSet = true;
    m_maximumMessageLength = value;
  }
  inline GetRoomResult& WithMaximumMessageLength(int value) {
    SetMaximumMessageLength(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Configuration information for optional review of messages.</p>
   */
  inline const MessageReviewHandler& GetMessageReviewHandler() const { return m_messageReviewHandler; }
  template <typename MessageReviewHandlerT = MessageReviewHandler>
  void SetMessageReviewHandler(MessageReviewHandlerT&& value) {
    m_messageReviewHandlerHasBeenSet = true;
    m_messageReviewHandler = std::forward<MessageReviewHandlerT>(value);
  }
  template <typename MessageReviewHandlerT = MessageReviewHandler>
  GetRoomResult& WithMessageReviewHandler(MessageReviewHandlerT&& value) {
    SetMessageReviewHandler(std::forward<MessageReviewHandlerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags attached to the resource. Array of maps, each of the form
   * <code>string:string (key:value)</code>.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetRoomResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetRoomResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Array of logging configurations attached to the room.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLoggingConfigurationIdentifiers() const { return m_loggingConfigurationIdentifiers; }
  template <typename LoggingConfigurationIdentifiersT = Aws::Vector<Aws::String>>
  void SetLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    m_loggingConfigurationIdentifiersHasBeenSet = true;
    m_loggingConfigurationIdentifiers = std::forward<LoggingConfigurationIdentifiersT>(value);
  }
  template <typename LoggingConfigurationIdentifiersT = Aws::Vector<Aws::String>>
  GetRoomResult& WithLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    SetLoggingConfigurationIdentifiers(std::forward<LoggingConfigurationIdentifiersT>(value));
    return *this;
  }
  template <typename LoggingConfigurationIdentifiersT = Aws::String>
  GetRoomResult& AddLoggingConfigurationIdentifiers(LoggingConfigurationIdentifiersT&& value) {
    m_loggingConfigurationIdentifiersHasBeenSet = true;
    m_loggingConfigurationIdentifiers.emplace_back(std::forward<LoggingConfigurationIdentifiersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRoomResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Utils::DateTime m_createTime{};
  bool m_createTimeHasBeenSet = false;

  Aws::Utils::DateTime m_updateTime{};
  bool m_updateTimeHasBeenSet = false;

  int m_maximumMessageRatePerSecond{0};
  bool m_maximumMessageRatePerSecondHasBeenSet = false;

  int m_maximumMessageLength{0};
  bool m_maximumMessageLengthHasBeenSet = false;

  MessageReviewHandler m_messageReviewHandler;
  bool m_messageReviewHandlerHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::Vector<Aws::String> m_loggingConfigurationIdentifiers;
  bool m_loggingConfigurationIdentifiersHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivschat
}  // namespace Aws
