﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>The details of a metered product.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/MeteredProductSummary">AWS
 * API Reference</a></p>
 */
class MeteredProductSummary {
 public:
  AWS_DEADLINE_API MeteredProductSummary() = default;
  AWS_DEADLINE_API MeteredProductSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API MeteredProductSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The product ID.</p>
   */
  inline const Aws::String& GetProductId() const { return m_productId; }
  inline bool ProductIdHasBeenSet() const { return m_productIdHasBeenSet; }
  template <typename ProductIdT = Aws::String>
  void SetProductId(ProductIdT&& value) {
    m_productIdHasBeenSet = true;
    m_productId = std::forward<ProductIdT>(value);
  }
  template <typename ProductIdT = Aws::String>
  MeteredProductSummary& WithProductId(ProductIdT&& value) {
    SetProductId(std::forward<ProductIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The family to which the metered product belongs.</p>
   */
  inline const Aws::String& GetFamily() const { return m_family; }
  inline bool FamilyHasBeenSet() const { return m_familyHasBeenSet; }
  template <typename FamilyT = Aws::String>
  void SetFamily(FamilyT&& value) {
    m_familyHasBeenSet = true;
    m_family = std::forward<FamilyT>(value);
  }
  template <typename FamilyT = Aws::String>
  MeteredProductSummary& WithFamily(FamilyT&& value) {
    SetFamily(std::forward<FamilyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The vendor.</p>
   */
  inline const Aws::String& GetVendor() const { return m_vendor; }
  inline bool VendorHasBeenSet() const { return m_vendorHasBeenSet; }
  template <typename VendorT = Aws::String>
  void SetVendor(VendorT&& value) {
    m_vendorHasBeenSet = true;
    m_vendor = std::forward<VendorT>(value);
  }
  template <typename VendorT = Aws::String>
  MeteredProductSummary& WithVendor(VendorT&& value) {
    SetVendor(std::forward<VendorT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The port on which the metered product should run.</p>
   */
  inline int GetPort() const { return m_port; }
  inline bool PortHasBeenSet() const { return m_portHasBeenSet; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline MeteredProductSummary& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_productId;
  bool m_productIdHasBeenSet = false;

  Aws::String m_family;
  bool m_familyHasBeenSet = false;

  Aws::String m_vendor;
  bool m_vendorHasBeenSet = false;

  int m_port{0};
  bool m_portHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
