/* extension-collection.c generated by valac 0.56.17, the Vala compiler
 * generated from extension-collection.vala, do not modify */

/* extension-collection.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_EXTENSION_COLLECTION_0_PROPERTY,
	ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY,
	ZEITGEIST_EXTENSION_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistExtensionCollectionPrivate {
	GPtrArray* extensions;
	gchar** disabled_extensions;
	gint disabled_extensions_length1;
	gint _disabled_extensions_size_;
	ZeitgeistEngine* _engine;
};

static gint ZeitgeistExtensionCollection_private_offset;
static gpointer zeitgeist_extension_collection_parent_class = NULL;

static void _zeitgeist_extension_collection___lambda4_ (ZeitgeistExtensionCollection* self,
                                                 ZeitgeistExtension* ext);
static void __zeitgeist_extension_collection___lambda4__gfunc (gconstpointer data,
                                                        gpointer self);
static void zeitgeist_extension_collection_setup (ZeitgeistExtensionCollection* self,
                                           ZeitgeistRegisterExtensionFunc* builtins,
                                           gint builtins_length1);
static void _g_object_unref0_ (gpointer var);
static ZeitgeistExtension* zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self,
                                                                          ZeitgeistExtensionLoader* loader);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void zeitgeist_extension_collection_finalize (GObject * obj);
static GType zeitgeist_extension_collection_get_type_once (void);
static void _vala_zeitgeist_extension_collection_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_zeitgeist_extension_collection_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
zeitgeist_extension_collection_get_instance_private (ZeitgeistExtensionCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistExtensionCollection_private_offset);
}

static void
_zeitgeist_extension_collection___lambda4_ (ZeitgeistExtensionCollection* self,
                                            ZeitgeistExtension* ext)
{
	g_return_if_fail (ext != NULL);
	zeitgeist_extension_unload (ext);
}

static void
__zeitgeist_extension_collection___lambda4__gfunc (gconstpointer data,
                                                   gpointer self)
{
	_zeitgeist_extension_collection___lambda4_ ((ZeitgeistExtensionCollection*) self, (ZeitgeistExtension*) data);
}

ZeitgeistExtensionCollection*
zeitgeist_extension_collection_construct (GType object_type,
                                          ZeitgeistEngine* engine,
                                          ZeitgeistRegisterExtensionFunc* builtins,
                                          gint builtins_length1)
{
	ZeitgeistExtensionCollection * self = NULL;
	g_return_val_if_fail (engine != NULL, NULL);
	self = (ZeitgeistExtensionCollection*) g_object_new (object_type, "engine", engine, NULL);
	zeitgeist_extension_collection_setup (self, builtins, (gint) builtins_length1);
	return self;
}

ZeitgeistExtensionCollection*
zeitgeist_extension_collection_new (ZeitgeistEngine* engine,
                                    ZeitgeistRegisterExtensionFunc* builtins,
                                    gint builtins_length1)
{
	return zeitgeist_extension_collection_construct (ZEITGEIST_TYPE_EXTENSION_COLLECTION, engine, builtins, builtins_length1);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
zeitgeist_extension_collection_setup (ZeitgeistExtensionCollection* self,
                                      ZeitgeistRegisterExtensionFunc* builtins,
                                      gint builtins_length1)
{
	ZeitgeistExtension* extension = NULL;
	GPtrArray* _tmp0_;
	const gchar* disabled = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* ext_dir1 = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GDir* user_ext_dir = NULL;
	GDir* _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp0_;
	_tmp1_ = g_getenv ("ZEITGEIST_DISABLED_EXTENSIONS");
	disabled = _tmp1_;
	_tmp2_ = disabled;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		_tmp3_ = disabled;
		_tmp5_ = _tmp4_ = g_strsplit_set (_tmp3_, ",:;", 0);
		self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->disabled_extensions = _tmp5_;
		self->priv->disabled_extensions_length1 = _vala_array_length (_tmp4_);
		self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
	}
	{
		ZeitgeistRegisterExtensionFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
		func_collection = builtins;
		func_collection_length1 = builtins_length1;
		for (func_it = 0; func_it < func_collection_length1; func_it = func_it + 1) {
			ZeitgeistRegisterExtensionFunc func = NULL;
			func = func_collection[func_it];
			{
				ZeitgeistExtensionLoader* builtin = NULL;
				ZeitgeistRegisterExtensionFunc _tmp6_;
				ZeitgeistBuiltinExtension* _tmp7_;
				ZeitgeistExtensionLoader* _tmp8_;
				ZeitgeistExtension* _tmp9_;
				ZeitgeistExtension* _tmp10_;
				_tmp6_ = func;
				_tmp7_ = zeitgeist_builtin_extension_new (_tmp6_);
				builtin = (ZeitgeistExtensionLoader*) _tmp7_;
				_tmp8_ = builtin;
				_tmp9_ = zeitgeist_extension_collection_instantiate_extension (self, _tmp8_);
				_g_object_unref0 (extension);
				extension = _tmp9_;
				_tmp10_ = extension;
				if (_tmp10_ != NULL) {
					GPtrArray* _tmp11_;
					ZeitgeistExtension* _tmp12_;
					ZeitgeistExtension* _tmp13_;
					_tmp11_ = self->priv->extensions;
					_tmp12_ = extension;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					g_ptr_array_add (_tmp11_, _tmp13_);
				}
				_g_object_unref0 (builtin);
			}
		}
	}
	_tmp14_ = zeitgeist_utils_get_local_extensions_path ();
	ext_dir1 = _tmp14_;
	_tmp15_ = ext_dir1;
	if (!g_file_test (_tmp15_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS)) {
		_g_object_unref0 (extension);
		return;
	}
	user_ext_dir = NULL;
	{
		GDir* _tmp16_ = NULL;
		const gchar* _tmp17_;
		GDir* _tmp18_;
		GDir* _tmp19_;
		_tmp17_ = ext_dir1;
		_tmp18_ = g_dir_open (_tmp17_, (guint) 0, &_inner_error0_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = _tmp16_;
		_tmp16_ = NULL;
		_g_dir_close0 (user_ext_dir);
		user_ext_dir = _tmp19_;
		_g_dir_close0 (_tmp16_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("extension-collection.vala:72: Couldn't open local extensions directory" \
": %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (user_ext_dir);
		_g_object_unref0 (extension);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp22_ = user_ext_dir;
	if (_tmp22_ != NULL) {
		const gchar* file_name = NULL;
		GDir* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = user_ext_dir;
		_tmp24_ = g_dir_read_name (_tmp23_);
		file_name = _tmp24_;
		while (TRUE) {
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GDir* _tmp41_;
			const gchar* _tmp42_;
			_tmp25_ = file_name;
			if (!(_tmp25_ != NULL)) {
				break;
			}
			_tmp26_ = file_name;
			if (g_str_has_suffix (_tmp26_, ".so")) {
				gchar* path = NULL;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				ZeitgeistModuleLoader* loader = NULL;
				const gchar* _tmp31_;
				ZeitgeistModuleLoader* _tmp32_;
				ZeitgeistModuleLoader* _tmp33_;
				ZeitgeistExtension* _tmp34_;
				ZeitgeistExtension* _tmp35_;
				_tmp27_ = ext_dir1;
				_tmp28_ = file_name;
				_tmp29_ = g_build_filename (_tmp27_, _tmp28_, NULL);
				path = _tmp29_;
				_tmp30_ = path;
				g_debug ("extension-collection.vala:83: Loading extension: \"%s\"", _tmp30_);
				_tmp31_ = path;
				_tmp32_ = zeitgeist_module_loader_new (_tmp31_);
				loader = _tmp32_;
				_tmp33_ = loader;
				_tmp34_ = zeitgeist_extension_collection_instantiate_extension (self, (ZeitgeistExtensionLoader*) _tmp33_);
				_g_object_unref0 (extension);
				extension = _tmp34_;
				_tmp35_ = extension;
				if (_tmp35_ != NULL) {
					GPtrArray* _tmp36_;
					ZeitgeistExtension* _tmp37_;
					ZeitgeistExtension* _tmp38_;
					_tmp36_ = self->priv->extensions;
					_tmp37_ = extension;
					_tmp38_ = _g_object_ref0 (_tmp37_);
					g_ptr_array_add (_tmp36_, _tmp38_);
				}
				_g_object_unref0 (loader);
				_g_free0 (path);
			} else {
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp39_ = ext_dir1;
				_tmp40_ = file_name;
				g_debug ("extension-collection.vala:90: Ignored file \"%s/%s\"", _tmp39_, _tmp40_);
			}
			_tmp41_ = user_ext_dir;
			_tmp42_ = g_dir_read_name (_tmp41_);
			file_name = _tmp42_;
		}
	}
	_g_dir_close0 (user_ext_dir);
	_g_object_unref0 (extension);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static ZeitgeistExtension*
zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self,
                                                      ZeitgeistExtensionLoader* loader)
{
	ZeitgeistExtension* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (loader != NULL, NULL);
	if (g_type_module_use ((GTypeModule*) loader)) {
		const gchar* type_name = NULL;
		GType _tmp0_;
		GType _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp6_;
		gboolean enabled = FALSE;
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		ZeitgeistExtension* _tmp16_ = NULL;
		ZeitgeistExtension* e = NULL;
		ZeitgeistExtension* _tmp19_;
		_tmp0_ = zeitgeist_extension_loader_get_extension_type (loader);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_type_name (_tmp1_);
		type_name = _tmp2_;
		_tmp3_ = type_name;
		if (_tmp3_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp4_ = type_name;
		if (g_str_has_prefix (_tmp4_, "Zeitgeist")) {
			const gchar* _tmp5_;
			_tmp5_ = type_name;
			type_name = (const gchar*) (((gchar*) _tmp5_) + 9);
		}
		_tmp6_ = type_name;
		if (g_str_has_suffix (_tmp6_, "Extension")) {
			gchar* type_no_suffix = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp7_ = type_name;
			_tmp8_ = type_name;
			_tmp9_ = strlen (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_slice (_tmp7_, (glong) 0, (glong) (_tmp10_ - 9));
			type_no_suffix = (gchar*) _tmp11_;
			_tmp12_ = type_no_suffix;
			type_name = _tmp12_;
			_g_free0 (type_no_suffix);
		}
		_tmp13_ = type_name;
		_tmp14_ = self->priv->disabled_extensions;
		_tmp14__length1 = self->priv->disabled_extensions_length1;
		enabled = !_vala_string_array_contains (_tmp14_, _tmp14__length1, _tmp13_);
		if (!enabled) {
			const gchar* _tmp15_;
			_tmp15_ = type_name;
			g_message ("extension-collection.vala:115: Skipping %s (disabled)", _tmp15_);
		}
		if (enabled) {
			ZeitgeistEngine* _tmp17_;
			ZeitgeistExtension* _tmp18_;
			_tmp17_ = self->priv->_engine;
			_tmp18_ = zeitgeist_extension_loader_create_instance (loader, _tmp17_);
			_g_object_unref0 (_tmp16_);
			_tmp16_ = _tmp18_;
		} else {
			_g_object_unref0 (_tmp16_);
			_tmp16_ = NULL;
		}
		_tmp19_ = _g_object_ref0 (_tmp16_);
		e = _tmp19_;
		g_type_module_unuse ((GTypeModule*) loader);
		result = e;
		_g_object_unref0 (_tmp16_);
		return result;
	}
	result = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self,
                                                    gint* result_length1)
{
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				const gchar* ext_name = NULL;
				GPtrArray* _tmp6_;
				gconstpointer _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->extensions;
				_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->extensions;
				_tmp7_ = g_ptr_array_index (_tmp6_, (guint) i);
				_tmp8_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) ((ZeitgeistExtension*) _tmp7_)));
				ext_name = _tmp8_;
				_tmp9_ = ext_name;
				if (g_str_has_prefix (_tmp9_, "Zeitgeist")) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = ext_name;
					_tmp11_ = string_substring (_tmp10_, (glong) 9, (glong) -1);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp11_);
				} else {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = ext_name;
					_tmp13_ = g_strdup (_tmp12_);
					_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp13_);
				}
			}
		}
	}
	_tmp14_ = _result_;
	_tmp14__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}

void
zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self,
                                                       GPtrArray* events,
                                                       const char* sender)
{
	gint num_events = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = vala_g_ptr_array_get_length (events);
	_tmp1_ = _tmp0_;
	num_events = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					i = i + 1;
					_tmp3_ = i;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->extensions;
				_tmp5_ = vala_g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->extensions;
				_tmp8_ = g_ptr_array_index (_tmp7_, (guint) i);
				zeitgeist_extension_pre_insert_events ((ZeitgeistExtension*) _tmp8_, events, sender);
			}
		}
	}
	_tmp9_ = vala_g_ptr_array_get_length (events);
	_tmp10_ = _tmp9_;
	_vala_assert (num_events == _tmp10_, "num_events == events.length");
}

void
zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self,
                                                        GPtrArray* events,
                                                        const char* sender)
{
	gint num_events = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = vala_g_ptr_array_get_length (events);
	_tmp1_ = _tmp0_;
	num_events = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					i = i + 1;
					_tmp3_ = i;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->extensions;
				_tmp5_ = vala_g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->extensions;
				_tmp8_ = g_ptr_array_index (_tmp7_, (guint) i);
				zeitgeist_extension_post_insert_events ((ZeitgeistExtension*) _tmp8_, events, sender);
			}
		}
	}
	_tmp9_ = vala_g_ptr_array_get_length (events);
	_tmp10_ = _tmp9_;
	_vala_assert (num_events == _tmp10_, "num_events == events.length");
}

guint32*
zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self,
                                                       guint32* event_ids,
                                                       gint event_ids_length1,
                                                       const char* sender,
                                                       gint* result_length1)
{
	guint32* _tmp11_;
	gint _tmp11__length1;
	guint32* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				guint32* filtered_ids = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gint _tmp7_ = 0;
				guint32* _tmp8_;
				gint filtered_ids_length1;
				gint _filtered_ids_size_;
				guint32* _tmp9_;
				gint _tmp9__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->extensions;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->extensions;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				_tmp8_ = zeitgeist_extension_pre_delete_events ((ZeitgeistExtension*) _tmp6_, event_ids, (gint) event_ids_length1, sender, &_tmp7_);
				filtered_ids = _tmp8_;
				filtered_ids_length1 = _tmp7_;
				_filtered_ids_size_ = filtered_ids_length1;
				_tmp9_ = filtered_ids;
				_tmp9__length1 = filtered_ids_length1;
				if (_tmp9_ != NULL) {
					guint32* _tmp10_;
					gint _tmp10__length1;
					_tmp10_ = filtered_ids;
					_tmp10__length1 = filtered_ids_length1;
					event_ids = _tmp10_;
					event_ids_length1 = _tmp10__length1;
				}
				filtered_ids = (g_free (filtered_ids), NULL);
			}
		}
	}
	_tmp11_ = event_ids;
	_tmp11__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}

void
zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self,
                                                        guint32* event_ids,
                                                        gint event_ids_length1,
                                                        const char* sender)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->extensions;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->extensions;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				zeitgeist_extension_post_delete_events ((ZeitgeistExtension*) _tmp6_, event_ids, (gint) event_ids_length1, sender);
			}
		}
	}
}

ZeitgeistEngine*
zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self)
{
	ZeitgeistEngine* result;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}

static void
zeitgeist_extension_collection_set_engine (ZeitgeistExtensionCollection* self,
                                           ZeitgeistEngine* value)
{
	ZeitgeistEngine* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_extension_collection_get_engine (self);
	if (old_value != value) {
		self->priv->_engine = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY]);
	}
}

static void
zeitgeist_extension_collection_class_init (ZeitgeistExtensionCollectionClass * klass,
                                           gpointer klass_data)
{
	zeitgeist_extension_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistExtensionCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY, zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY] = g_param_spec_object ("engine", "engine", "engine", ZEITGEIST_TYPE_ENGINE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
zeitgeist_extension_collection_instance_init (ZeitgeistExtensionCollection * self,
                                              gpointer klass)
{
	gchar** _tmp0_;
	self->priv = zeitgeist_extension_collection_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->disabled_extensions = _tmp0_;
	self->priv->disabled_extensions_length1 = 0;
	self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
}

static void
zeitgeist_extension_collection_finalize (GObject * obj)
{
	ZeitgeistExtensionCollection * self;
	GPtrArray* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	_tmp0_ = self->priv->extensions;
	g_ptr_array_foreach (_tmp0_, __zeitgeist_extension_collection___lambda4__gfunc, self);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (zeitgeist_extension_collection_parent_class)->finalize (obj);
}

static GType
zeitgeist_extension_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionCollection), 0, (GInstanceInitFunc) zeitgeist_extension_collection_instance_init, NULL };
	GType zeitgeist_extension_collection_type_id;
	zeitgeist_extension_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionCollection", &g_define_type_info, 0);
	ZeitgeistExtensionCollection_private_offset = g_type_add_instance_private (zeitgeist_extension_collection_type_id, sizeof (ZeitgeistExtensionCollectionPrivate));
	return zeitgeist_extension_collection_type_id;
}

GType
zeitgeist_extension_collection_get_type (void)
{
	static volatile gsize zeitgeist_extension_collection_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_extension_collection_type_id__once)) {
		GType zeitgeist_extension_collection_type_id;
		zeitgeist_extension_collection_type_id = zeitgeist_extension_collection_get_type_once ();
		g_once_init_leave (&zeitgeist_extension_collection_type_id__once, zeitgeist_extension_collection_type_id);
	}
	return zeitgeist_extension_collection_type_id__once;
}

static void
_vala_zeitgeist_extension_collection_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	ZeitgeistExtensionCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY:
		g_value_set_object (value, zeitgeist_extension_collection_get_engine (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_extension_collection_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	ZeitgeistExtensionCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY:
		zeitgeist_extension_collection_set_engine (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

