/* zeitgeist-internal.h generated by valac 0.56.17, the Vala compiler, do not modify */

#ifndef __ZEITGEIST_INTERNAL_H__
#define __ZEITGEIST_INTERNAL_H__

#include <glib-object.h>
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA "core"
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 11

#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;
typedef struct _ZeitgeistDbReaderPrivate ZeitgeistDbReaderPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI
} ZeitgeistSQLiteEventViewRows;

#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())
typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, gpointer user_data);
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA (zeitgeist_sq_lite_database_schema_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchema))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))

typedef struct _ZeitgeistSQLiteDatabaseSchema ZeitgeistSQLiteDatabaseSchema;
typedef struct _ZeitgeistSQLiteDatabaseSchemaClass ZeitgeistSQLiteDatabaseSchemaClass;
typedef struct _ZeitgeistSQLiteDatabaseSchemaPrivate ZeitgeistSQLiteDatabaseSchemaPrivate;
typedef struct _ZeitgeistSQLiteTableLookupPrivate ZeitgeistSQLiteTableLookupPrivate;
typedef struct _ZeitgeistWhereClausePrivate ZeitgeistWhereClausePrivate;
typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())

struct _ZeitgeistDbReader {
	GObject parent_instance;
	ZeitgeistDbReaderPrivate * priv;
	sqlite3* db;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistDbReaderClass {
	GObjectClass parent_class;
	void (*close) (ZeitgeistDbReader* self);
};

struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteDatabaseSchema {
	GObject parent_instance;
	ZeitgeistSQLiteDatabaseSchemaPrivate * priv;
};

struct _ZeitgeistSQLiteDatabaseSchemaClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteTableLookup {
	GObject parent_instance;
	ZeitgeistSQLiteTableLookupPrivate * priv;
};

struct _ZeitgeistSQLiteTableLookupClass {
	GObjectClass parent_class;
};

struct _ZeitgeistWhereClause {
	GObject parent_instance;
	ZeitgeistWhereClausePrivate * priv;
};

struct _ZeitgeistWhereClauseClass {
	GObjectClass parent_class;
};

VALA_EXTERN GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistDbReader, g_object_unref)
VALA_EXTERN GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSQLiteTableLookup, g_object_unref)
VALA_EXTERN ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error);
VALA_EXTERN ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type,
                                                  GError** error);
VALA_EXTERN ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self,
                                                        sqlite3_stmt* stmt,
                                                        guint32 event_id,
                                                        GError** error);
VALA_EXTERN ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self,
                                                            sqlite3_stmt* stmt,
                                                            GError** error);
VALA_EXTERN GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self,
                                           guint32* event_ids,
                                           gint event_ids_length1,
                                           const char* sender,
                                           GError** error);
VALA_EXTERN GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistWhereClause, g_object_unref)
VALA_EXTERN guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self,
                                                        ZeitgeistWhereClause* where,
                                                        guint max_events,
                                                        guint result_type,
                                                        gint* result_length1,
                                                        GError** error);
VALA_EXTERN guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self,
                                             ZeitgeistTimeRange* time_range,
                                             GPtrArray* event_templates,
                                             guint storage_state,
                                             guint max_events,
                                             guint result_type,
                                             const char* sender,
                                             gint* result_length1,
                                             GError** error);
VALA_EXTERN GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self,
                                            ZeitgeistTimeRange* time_range,
                                            GPtrArray* event_templates,
                                            guint storage_state,
                                            guint max_events,
                                            guint result_type,
                                            const char* sender,
                                            GError** error);
VALA_EXTERN ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self,
                                                                      ZeitgeistTimeRange* time_range,
                                                                      GPtrArray* event_templates,
                                                                      guint storage_state,
                                                                      GError** error);
VALA_EXTERN gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self,
                                               ZeitgeistTimeRange* time_range,
                                               GPtrArray* event_templates,
                                               GPtrArray* result_event_templates,
                                               guint storage_state,
                                               guint max_results,
                                               guint result_type,
                                               const char* sender,
                                               gint* result_length1,
                                               GError** error);
VALA_EXTERN void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
VALA_EXTERN ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self,
                                                                                 GPtrArray* templates,
                                                                                 GError** error);
VALA_EXTERN void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self,
                                             const gchar* field,
                                             const gchar* val,
                                             GError** error);
VALA_EXTERN void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self,
                                             const gchar* field,
                                             const gchar* val,
                                             GError** error);
VALA_EXTERN void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self,
                                             const gchar* field,
                                             const gchar* val,
                                             GError** error);
VALA_EXTERN ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self,
                                                                       const gchar* table_name,
                                                                       const gchar* symbol,
                                                                       ZeitgeistSQLiteTableLookup* lookup_table,
                                                                       GError** error);
VALA_EXTERN GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSQLiteDatabase, g_object_unref)
VALA_EXTERN ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self);
VALA_EXTERN GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error);
VALA_EXTERN ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type,
                                                               GError** error);
VALA_EXTERN ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
VALA_EXTERN ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type,
                                                                         GError** error);
VALA_EXTERN guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self,
                                                GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self,
                                                       ZeitgeistSQLiteDeletionCallback callback,
                                                       gpointer callback_target,
                                                       GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self,
                                                                 guint32* event_ids,
                                                                 gint event_ids_length1);
VALA_EXTERN ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self,
                                                                             guint32* event_ids,
                                                                             gint event_ids_length1,
                                                                             GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self,
                                                             const gchar* table_name,
                                                             GPtrArray* values,
                                                             GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self,
                                                   GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self,
                                                 GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self,
                                                   GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
VALA_EXTERN void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self,
                                                      gint rc,
                                                      const gchar* msg,
                                                      gint success_code,
                                                      GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self,
                                                    gint rc,
                                                    GError** error);
VALA_EXTERN gboolean zeitgeist_sq_lite_database_analyze (ZeitgeistSQLiteDatabase* self,
                                             GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_set_cache_size (ZeitgeistSQLiteDatabase* self,
                                                gint size);
VALA_EXTERN void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self,
                                                 int action,
                                                 const gchar* dbname,
                                                 const gchar* table,
                                                 gint64 rowid);
VALA_EXTERN GType zeitgeist_sq_lite_database_schema_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSQLiteDatabaseSchema, g_object_unref)
VALA_EXTERN void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database,
                                                      GError** error);
VALA_EXTERN gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database,
                                                           GError** error);
VALA_EXTERN gint64 zeitgeist_sq_lite_database_schema_get_creation_date (sqlite3* database);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database,
                                                            GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_setup_database (sqlite3* database,
                                                       GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database,
                                                      GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_create_basic_indices (sqlite3* database,
                                                             GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_create_event_indices (sqlite3* database,
                                                             GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_drop_basic_indices (sqlite3* database,
                                                           GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_drop_event_indices (sqlite3* database,
                                                           GError** error);
VALA_EXTERN void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database,
                                                   const gchar* sql,
                                                   GError** error);
VALA_EXTERN ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void);
VALA_EXTERN ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type);
VALA_EXTERN ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database,
                                                                const gchar* table_name,
                                                                GError** error);
VALA_EXTERN ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type,
                                                                      ZeitgeistSQLiteDatabase* database,
                                                                      const gchar* table_name,
                                                                      GError** error);
VALA_EXTERN gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self,
                                                   const gchar* name);
VALA_EXTERN gint zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self,
                                                   const gchar* name,
                                                   GError** error);
VALA_EXTERN const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self,
                                                       gint id,
                                                       GError** error);
VALA_EXTERN void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self,
                                            gint id);
VALA_EXTERN GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type,
                                                  gboolean negate);
VALA_EXTERN ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type,
                                                        ZeitgeistWhereClauseType type,
                                                        gboolean negate);
VALA_EXTERN gint zeitgeist_where_clause_get_conditions_length (ZeitgeistWhereClause* self);
VALA_EXTERN gboolean zeitgeist_where_clause_has_non_timestamp_condition (ZeitgeistWhereClause* self);
VALA_EXTERN void zeitgeist_where_clause_add (ZeitgeistWhereClause* self,
                                 const gchar* condition,
                                 const gchar* argument);
VALA_EXTERN void zeitgeist_where_clause_add_with_array (ZeitgeistWhereClause* self,
                                            const gchar* condition,
                                            GPtrArray* args);
VALA_EXTERN void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self,
                                                 const gchar* column,
                                                 gint val,
                                                 gboolean negation);
VALA_EXTERN void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self,
                                                         const gchar* column,
                                                         const gchar* val,
                                                         gboolean negation);
VALA_EXTERN void zeitgeist_where_clause_add_text_condition (ZeitgeistWhereClause* self,
                                                const gchar* column,
                                                const gchar* val,
                                                gboolean negation);
VALA_EXTERN void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self,
                                                    const gchar* column,
                                                    const gchar* needle,
                                                    gboolean negation);
VALA_EXTERN void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self,
                                    ZeitgeistWhereClause* clause);
VALA_EXTERN gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
VALA_EXTERN gboolean zeitgeist_where_clause_may_have_results (ZeitgeistWhereClause* self);
VALA_EXTERN gboolean zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self);
VALA_EXTERN void zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self,
                                           gboolean simple);
VALA_EXTERN gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
VALA_EXTERN GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
VALA_EXTERN gchar* zeitgeist_where_clause_get_right_boundary (const gchar* text);

G_END_DECLS

#endif
