/* downloads-directory-provider.c generated by valac 0.56.17, the Vala compiler
 * generated from downloads-directory-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"

#define DOWNLOADS_DIRECTORY_MONITOR_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP ","
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_DOWNLOADS_DIRECTORY_MONITOR (downloads_directory_monitor_get_type ())
#define DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor))
#define DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))
#define IS_DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define IS_DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define DOWNLOADS_DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))

typedef struct _DownloadsDirectoryMonitor DownloadsDirectoryMonitor;
typedef struct _DownloadsDirectoryMonitorClass DownloadsDirectoryMonitorClass;
typedef struct _DownloadsDirectoryMonitorPrivate DownloadsDirectoryMonitorPrivate;
enum  {
	DOWNLOADS_DIRECTORY_MONITOR_0_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _DownloadsDirectoryMonitorProcessEventData DownloadsDirectoryMonitorProcessEventData;

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _DownloadsDirectoryMonitor {
	DataProvider parent_instance;
	DownloadsDirectoryMonitorPrivate * priv;
};

struct _DownloadsDirectoryMonitorClass {
	DataProviderClass parent_class;
};

struct _DownloadsDirectoryMonitorPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	gchar* downloads_path;
	GFile* downloads_directory;
	GFileMonitor* monitor;
	gchar** ignored_actors;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
};

struct _DownloadsDirectoryMonitorProcessEventData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DownloadsDirectoryMonitor* self;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event_type;
	gchar* uri;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFileInfo* subject_info;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	GFileInfo* _tmp6_;
	gboolean _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GError* err;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	gchar* mimetype;
	GFileInfo* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* origin;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* basename;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ZeitgeistSubject* subject;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	ZeitgeistSubject* _tmp31_;
	gchar* actor;
	gchar* _tmp32_;
	ZeitgeistEvent* event;
	const gchar* _tmp33_;
	ZeitgeistEvent* _tmp34_;
	ZeitgeistEvent* _tmp35_;
	ZeitgeistSubject* _tmp36_;
	ZeitgeistEvent* _tmp37_;
	GPtrArray* events;
	GPtrArray* _tmp38_;
	GPtrArray* _tmp39_;
	ZeitgeistEvent* _tmp40_;
	GPtrArray* _tmp41_;
	GError* _inner_error0_;
};

static gint DownloadsDirectoryMonitor_private_offset;
static gpointer downloads_directory_monitor_parent_class = NULL;

VALA_EXTERN GType data_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataProvider, g_object_unref)
VALA_EXTERN GType data_hub_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataHub, g_object_unref)
VALA_EXTERN GType downloads_directory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DownloadsDirectoryMonitor, g_object_unref)
VALA_EXTERN void data_provider_start (DataProvider* self);
VALA_EXTERN void data_provider_stop (DataProvider* self);
VALA_EXTERN const gchar* data_provider_get_unique_id (DataProvider* self);
VALA_EXTERN void data_provider_set_unique_id (DataProvider* self,
                                  const gchar* value);
VALA_EXTERN const gchar* data_provider_get_name (DataProvider* self);
VALA_EXTERN void data_provider_set_name (DataProvider* self,
                             const gchar* value);
VALA_EXTERN const gchar* data_provider_get_description (DataProvider* self);
VALA_EXTERN void data_provider_set_description (DataProvider* self,
                                    const gchar* value);
VALA_EXTERN DataHub* data_provider_get_datahub (DataProvider* self);
VALA_EXTERN void data_provider_set_datahub (DataProvider* self,
                                DataHub* value);
VALA_EXTERN gboolean data_provider_get_enabled (DataProvider* self);
VALA_EXTERN void data_provider_set_enabled (DataProvider* self,
                                gboolean value);
VALA_EXTERN gboolean data_provider_get_register (DataProvider* self);
VALA_EXTERN void data_provider_set_register (DataProvider* self,
                                 gboolean value);
VALA_EXTERN DownloadsDirectoryMonitor* downloads_directory_monitor_new (DataHub* datahub,
                                                            GError** error);
VALA_EXTERN DownloadsDirectoryMonitor* downloads_directory_monitor_construct (GType object_type,
                                                                  DataHub* datahub,
                                                                  GError** error);
static void downloads_directory_monitor_real_start (DataProvider* base);
VALA_EXTERN gchar** data_hub_get_data_source_actors (DataHub* self,
                                         gboolean only_enabled,
                                         gint* result_length1);
static void downloads_directory_monitor_process_event (DownloadsDirectoryMonitor* self,
                                                GFile* file,
                                                GFile* other_file,
                                                GFileMonitorEvent event_type,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void downloads_directory_monitor_process_event_finish (DownloadsDirectoryMonitor* self,
                                                       GAsyncResult* _res_);
static void _downloads_directory_monitor_process_event_g_file_monitor_changed (GFileMonitor* _sender,
                                                                        GFile* file,
                                                                        GFile* other_file,
                                                                        GFileMonitorEvent event_type,
                                                                        gpointer self);
static void downloads_directory_monitor_real_stop (DataProvider* base);
static void downloads_directory_monitor_process_event_data_free (gpointer _data);
static gboolean downloads_directory_monitor_process_event_co (DownloadsDirectoryMonitorProcessEventData* _data_);
static void downloads_directory_monitor_process_event_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static GObject * downloads_directory_monitor_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void downloads_directory_monitor_finalize (GObject * obj);
static GType downloads_directory_monitor_get_type_once (void);
static void _vala_downloads_directory_monitor_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_downloads_directory_monitor_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
downloads_directory_monitor_get_instance_private (DownloadsDirectoryMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, DownloadsDirectoryMonitor_private_offset);
}

DownloadsDirectoryMonitor*
downloads_directory_monitor_construct (GType object_type,
                                       DataHub* datahub,
                                       GError** error)
{
	DownloadsDirectoryMonitor * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (DownloadsDirectoryMonitor*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,downloads-monitor", "name", "Downloads Directory Monitor", "description", "Logs files in the XDG downloads directory", "datahub", datahub, NULL);
	return self;
}

DownloadsDirectoryMonitor*
downloads_directory_monitor_new (DataHub* datahub,
                                 GError** error)
{
	return downloads_directory_monitor_construct (TYPE_DOWNLOADS_DIRECTORY_MONITOR, datahub, error);
}

static void
_downloads_directory_monitor_process_event_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self)
{
	downloads_directory_monitor_process_event ((DownloadsDirectoryMonitor*) self, file, other_file, event_type, NULL, NULL);
}

static void
downloads_directory_monitor_real_start (DataProvider* base)
{
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->downloads_path;
	if (_tmp0_ != NULL) {
		DataHub* _tmp1_;
		DataHub* _tmp2_;
		gint _tmp3_ = 0;
		gchar** _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp1_ = data_provider_get_datahub ((DataProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp4_ = data_hub_get_data_source_actors (_tmp2_, TRUE, &_tmp3_);
		self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
		self->priv->ignored_actors = _tmp4_;
		self->priv->ignored_actors_length1 = _tmp3_;
		self->priv->_ignored_actors_size_ = self->priv->ignored_actors_length1;
		_tmp5_ = self->priv->monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _downloads_directory_monitor_process_event_g_file_monitor_changed, self, 0);
	}
}

static void
downloads_directory_monitor_real_stop (DataProvider* base)
{
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->downloads_path;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _downloads_directory_monitor_process_event_g_file_monitor_changed, self);
	}
}

static void
downloads_directory_monitor_process_event_data_free (gpointer _data)
{
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->other_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (DownloadsDirectoryMonitorProcessEventData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
downloads_directory_monitor_process_event (DownloadsDirectoryMonitor* self,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	DownloadsDirectoryMonitorProcessEventData* _data_;
	DownloadsDirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (DownloadsDirectoryMonitorProcessEventData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, downloads_directory_monitor_process_event_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (other_file);
	_g_object_unref0 (_data_->other_file);
	_data_->other_file = _tmp2_;
	_data_->event_type = event_type;
	downloads_directory_monitor_process_event_co (_data_);
}

static void
downloads_directory_monitor_process_event_finish (DownloadsDirectoryMonitor* self,
                                                  GAsyncResult* _res_)
{
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
downloads_directory_monitor_process_event_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	downloads_directory_monitor_process_event_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
downloads_directory_monitor_process_event_co (DownloadsDirectoryMonitorProcessEventData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->event_type != G_FILE_MONITOR_EVENT_CREATED) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = g_file_get_uri (_data_->file);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->uri;
	if (g_str_has_suffix (_data_->_tmp2_, ".part")) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->uri;
		_data_->_tmp1_ = g_str_has_suffix (_data_->_tmp3_, ".crdownload");
	}
	if (_data_->_tmp1_) {
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, DOWNLOADS_DIRECTORY_MONITOR_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, downloads_directory_monitor_process_event_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->subject_info);
		_data_->subject_info = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->subject_info;
		if (g_file_info_get_is_hidden (_data_->_tmp8_)) {
			_data_->_tmp7_ = TRUE;
		} else {
			_data_->_tmp9_ = _data_->subject_info;
			_data_->_tmp7_ = g_file_info_get_is_backup (_data_->_tmp9_);
		}
		if (_data_->_tmp7_) {
			_g_object_unref0 (_data_->_tmp4_);
			_g_object_unref0 (_data_->subject_info);
			_g_free0 (_data_->uri);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = g_file_get_path (_data_->file);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->err;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("downloads-directory-provider.vala:120: Couldn't process %s: %s", _data_->_tmp11_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->subject_info);
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->subject_info);
		_g_free0 (_data_->uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->subject_info;
	_data_->_tmp15_ = g_file_info_get_attribute_string (_data_->_tmp14_, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
	_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
	_data_->mimetype = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->uri;
	_data_->_tmp18_ = g_path_get_dirname (_data_->_tmp17_);
	_data_->origin = _data_->_tmp18_;
	_data_->_tmp19_ = g_file_get_path (_data_->file);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_path_get_basename (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_g_free0 (_data_->_tmp20_);
	_data_->basename = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->uri;
	_data_->_tmp24_ = _data_->mimetype;
	_data_->_tmp25_ = zeitgeist_interpretation_for_mimetype (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->uri;
	_data_->_tmp27_ = zeitgeist_manifestation_for_uri (_data_->_tmp26_);
	_data_->_tmp28_ = _data_->mimetype;
	_data_->_tmp29_ = _data_->origin;
	_data_->_tmp30_ = _data_->basename;
	_data_->_tmp31_ = zeitgeist_subject_new_full (_data_->_tmp23_, _data_->_tmp25_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, "");
	_data_->subject = _data_->_tmp31_;
	_data_->_tmp32_ = g_strdup ("");
	_data_->actor = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->actor;
	_data_->_tmp34_ = zeitgeist_event_new_full (ZEITGEIST_ZG_CREATE_EVENT, ZEITGEIST_ZG_WORLD_ACTIVITY, _data_->_tmp33_, NULL, NULL, NULL);
	_data_->event = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->event;
	_data_->_tmp36_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp35_, _data_->_tmp36_);
	_data_->_tmp37_ = _data_->event;
	if (_data_->_tmp37_ != NULL) {
		_data_->_tmp38_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_data_->events = _data_->_tmp38_;
		_data_->_tmp39_ = _data_->events;
		_data_->_tmp40_ = _data_->event;
		_data_->event = NULL;
		g_ptr_array_add (_data_->_tmp39_, _data_->_tmp40_);
		_data_->_tmp41_ = _data_->events;
		g_signal_emit_by_name ((DataProvider*) _data_->self, "items-available", _data_->_tmp41_);
		_g_ptr_array_unref0 (_data_->events);
	}
	_g_object_unref0 (_data_->event);
	_g_free0 (_data_->actor);
	_g_object_unref0 (_data_->subject);
	_g_free0 (_data_->basename);
	_g_free0 (_data_->origin);
	_g_free0 (_data_->mimetype);
	_g_object_unref0 (_data_->subject_info);
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static const gchar*
downloads_directory_monitor_real_get_unique_id (DataProvider* base)
{
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}

static void
downloads_directory_monitor_real_set_unique_id (DataProvider* base,
                                                const gchar* value)
{
	DownloadsDirectoryMonitor* self;
	gchar* old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_unique_id (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY]);
	}
}

static const gchar*
downloads_directory_monitor_real_get_name (DataProvider* base)
{
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
downloads_directory_monitor_real_set_name (DataProvider* base,
                                           const gchar* value)
{
	DownloadsDirectoryMonitor* self;
	gchar* old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY]);
	}
}

static const gchar*
downloads_directory_monitor_real_get_description (DataProvider* base)
{
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
downloads_directory_monitor_real_set_description (DataProvider* base,
                                                  const gchar* value)
{
	DownloadsDirectoryMonitor* self;
	gchar* old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_description (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY]);
	}
}

static DataHub*
downloads_directory_monitor_real_get_datahub (DataProvider* base)
{
	DataHub* result;
	DownloadsDirectoryMonitor* self;
	DataHub* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}

static void
downloads_directory_monitor_real_set_datahub (DataProvider* base,
                                              DataHub* value)
{
	DownloadsDirectoryMonitor* self;
	DataHub* old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_datahub (base);
	if (old_value != value) {
		DataHub* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY]);
	}
}

static gboolean
downloads_directory_monitor_real_get_enabled (DataProvider* base)
{
	gboolean result;
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	result = self->priv->_enabled;
	return result;
}

static void
downloads_directory_monitor_real_set_enabled (DataProvider* base,
                                              gboolean value)
{
	DownloadsDirectoryMonitor* self;
	gboolean old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY]);
	}
}

static gboolean
downloads_directory_monitor_real_get_register (DataProvider* base)
{
	gboolean result;
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	result = self->priv->_register;
	return result;
}

static void
downloads_directory_monitor_real_set_register (DataProvider* base,
                                               gboolean value)
{
	DownloadsDirectoryMonitor* self;
	gboolean old_value;
	self = (DownloadsDirectoryMonitor*) base;
	old_value = downloads_directory_monitor_real_get_register (base);
	if (old_value != value) {
		self->priv->_register = value;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY]);
	}
}

static GObject *
downloads_directory_monitor_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (downloads_directory_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->downloads_path);
	self->priv->downloads_path = _tmp1_;
	_tmp2_ = self->priv->downloads_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = self->priv->downloads_path;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (self->priv->downloads_directory);
		self->priv->downloads_directory = _tmp4_;
		{
			GFileMonitor* _tmp5_ = NULL;
			GFile* _tmp6_;
			GFileMonitor* _tmp7_;
			GFileMonitor* _tmp8_;
			_tmp6_ = self->priv->downloads_directory;
			_tmp7_ = g_file_monitor_directory (_tmp6_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (self->priv->monitor);
			self->priv->monitor = _tmp8_;
			_g_object_unref0 (_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = err;
			_tmp10_ = _tmp9_->message;
			g_warning ("downloads-directory-provider.vala:66: Couldn't set up monitor on Downl" \
"oads directory: %s", _tmp10_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	return obj;
}

static void
downloads_directory_monitor_class_init (DownloadsDirectoryMonitorClass * klass,
                                        gpointer klass_data)
{
	downloads_directory_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DownloadsDirectoryMonitor_private_offset);
	((DataProviderClass *) klass)->start = (void (*) (DataProvider*)) downloads_directory_monitor_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider*)) downloads_directory_monitor_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = (const gchar* (*) (DataProvider*)) downloads_directory_monitor_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = (void (*) (DataProvider*, const gchar*)) downloads_directory_monitor_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = (const gchar* (*) (DataProvider*)) downloads_directory_monitor_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = (void (*) (DataProvider*, const gchar*)) downloads_directory_monitor_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = (const gchar* (*) (DataProvider*)) downloads_directory_monitor_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = (void (*) (DataProvider*, const gchar*)) downloads_directory_monitor_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = (DataHub* (*) (DataProvider*)) downloads_directory_monitor_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = (void (*) (DataProvider*, DataHub*)) downloads_directory_monitor_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = (gboolean (*) (DataProvider*)) downloads_directory_monitor_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = (void (*) (DataProvider*, gboolean)) downloads_directory_monitor_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = (gboolean (*) (DataProvider*)) downloads_directory_monitor_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = (void (*) (DataProvider*, gboolean)) downloads_directory_monitor_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_downloads_directory_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_downloads_directory_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = downloads_directory_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = downloads_directory_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
downloads_directory_monitor_instance_init (DownloadsDirectoryMonitor * self,
                                           gpointer klass)
{
	self->priv = downloads_directory_monitor_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
}

static void
downloads_directory_monitor_finalize (GObject * obj)
{
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_free0 (self->priv->downloads_path);
	_g_object_unref0 (self->priv->downloads_directory);
	_g_object_unref0 (self->priv->monitor);
	self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (downloads_directory_monitor_parent_class)->finalize (obj);
}

static GType
downloads_directory_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DownloadsDirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) downloads_directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DownloadsDirectoryMonitor), 0, (GInstanceInitFunc) downloads_directory_monitor_instance_init, NULL };
	GType downloads_directory_monitor_type_id;
	downloads_directory_monitor_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "DownloadsDirectoryMonitor", &g_define_type_info, 0);
	DownloadsDirectoryMonitor_private_offset = g_type_add_instance_private (downloads_directory_monitor_type_id, sizeof (DownloadsDirectoryMonitorPrivate));
	return downloads_directory_monitor_type_id;
}

GType
downloads_directory_monitor_get_type (void)
{
	static volatile gsize downloads_directory_monitor_type_id__once = 0;
	if (g_once_init_enter (&downloads_directory_monitor_type_id__once)) {
		GType downloads_directory_monitor_type_id;
		downloads_directory_monitor_type_id = downloads_directory_monitor_get_type_once ();
		g_once_init_leave (&downloads_directory_monitor_type_id__once, downloads_directory_monitor_type_id);
	}
	return downloads_directory_monitor_type_id__once;
}

static void
_vala_downloads_directory_monitor_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	switch (property_id) {
		case DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_downloads_directory_monitor_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	switch (property_id) {
		case DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

