/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageDataStorageFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ImageDataStorageFormat enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("uint8"),
        MAKE_STATIC_STRING_IMPL("float16"),
    };
    static_assert(static_cast<size_t>(ImageDataStorageFormat::Uint8) == 0, "ImageDataStorageFormat::Uint8 is not 0 as expected");
    static_assert(static_cast<size_t>(ImageDataStorageFormat::Float16) == 1, "ImageDataStorageFormat::Float16 is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageDataStorageFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageDataStorageFormat> parseEnumerationFromString<ImageDataStorageFormat>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ImageDataStorageFormat>, 2> mappings {
        std::pair<ComparableASCIILiteral, ImageDataStorageFormat> { "float16"_s, ImageDataStorageFormat::Float16 },
        std::pair<ComparableASCIILiteral, ImageDataStorageFormat> { "uint8"_s, ImageDataStorageFormat::Uint8 },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageDataStorageFormat> parseEnumeration<ImageDataStorageFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageDataStorageFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ImageDataStorageFormat>()
{
    return "\"uint8\", \"float16\""_s;
}

} // namespace WebCore

