// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HashicorpCloudOperationOperationState State is one of the states that an Operation can be in.
//
// The states are purposely coarse grained to make it easy to understand
// the operation state machine: pending => running => done. Or pending =>
// queued => running => done. No other state transitions are possible.
// Success/failure can be determined based on the result oneof.
//
// swagger:model hashicorp.cloud.operation.Operation.State
type HashicorpCloudOperationOperationState string

func NewHashicorpCloudOperationOperationState(value HashicorpCloudOperationOperationState) *HashicorpCloudOperationOperationState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HashicorpCloudOperationOperationState.
func (m HashicorpCloudOperationOperationState) Pointer() *HashicorpCloudOperationOperationState {
	return &m
}

const (

	// HashicorpCloudOperationOperationStatePENDING captures enum value "PENDING"
	HashicorpCloudOperationOperationStatePENDING HashicorpCloudOperationOperationState = "PENDING"

	// HashicorpCloudOperationOperationStateRUNNING captures enum value "RUNNING"
	HashicorpCloudOperationOperationStateRUNNING HashicorpCloudOperationOperationState = "RUNNING"

	// HashicorpCloudOperationOperationStateDONE captures enum value "DONE"
	HashicorpCloudOperationOperationStateDONE HashicorpCloudOperationOperationState = "DONE"

	// HashicorpCloudOperationOperationStateQUEUED captures enum value "QUEUED"
	HashicorpCloudOperationOperationStateQUEUED HashicorpCloudOperationOperationState = "QUEUED"
)

// for schema
var hashicorpCloudOperationOperationStateEnum []interface{}

func init() {
	var res []HashicorpCloudOperationOperationState
	if err := json.Unmarshal([]byte(`["PENDING","RUNNING","DONE","QUEUED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashicorpCloudOperationOperationStateEnum = append(hashicorpCloudOperationOperationStateEnum, v)
	}
}

func (m HashicorpCloudOperationOperationState) validateHashicorpCloudOperationOperationStateEnum(path, location string, value HashicorpCloudOperationOperationState) error {
	if err := validate.EnumCase(path, location, value, hashicorpCloudOperationOperationStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this hashicorp cloud operation operation state
func (m HashicorpCloudOperationOperationState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHashicorpCloudOperationOperationStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this hashicorp cloud operation operation state based on context it is used
func (m HashicorpCloudOperationOperationState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
