/*
  ==============================================================================

  This is an automatically generated GUI class created by the Projucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Projucer version: 7.0.9

  ------------------------------------------------------------------------------

  The Projucer is part of the JUCE library.
  Copyright (c) 2020 - Raw Material Software Limited.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...
#include "../Engine/VASTEngineHeader.h"
#include "VASTAudioProcessor.h"
#include "VASTAudioProcessorEditor.h"
//[/Headers]

#include "VASTLogoComponent.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
VASTLogoComponent::VASTLogoComponent (AudioProcessorEditor *editor, AudioProcessor* processor)
    : myEditor((VASTAudioProcessorEditor*)editor), myProcessor((VASTAudioProcessor*)processor)
{
    //[Constructor_pre] You can add your own custom stuff here..
    //[/Constructor_pre]

    c_screenSize.reset (new juce::TextButton ("c_screenSize"));
    addAndMakeVisible (c_screenSize.get());
    c_screenSize->setButtonText (juce::String());
    c_screenSize->addListener (this);
    c_screenSize->setColour (juce::TextButton::buttonColourId, juce::Colour (0x00a45c94));
    c_screenSize->setColour (juce::TextButton::buttonOnColourId, juce::Colour (0x00181f22));
    c_screenSize->setColour (juce::TextButton::textColourOffId, juce::Colour (0x00ffffff));
    c_screenSize->setColour (juce::TextButton::textColourOnId, juce::Colour (0x00ffffff));

    drawable1 = juce::Drawable::createFromImageData (vaporizer2_svg, vaporizer2_svgSize);
    drawable2 = juce::Drawable::createFromImageData (vast_svg, vast_svgSize);
    drawable3 = juce::Drawable::createFromImageData (logokreis_svg, logokreis_svgSize);
    drawable4 = juce::Drawable::createFromImageData (copyright_svg, copyright_svgSize);
    drawable5 = juce::Drawable::createFromImageData (dynamics_svg, dynamics_svgSize);
    drawable6 = juce::Drawable::createFromImageData (logokreisv_svg, logokreisv_svgSize);

    //[UserPreSize]

	c_screenSize->setComponentID("screenSize");
	setOpaque(true);

    return; //dont call setSize
    //[/UserPreSize]

    setSize (423, 76);


    //[Constructor] You can add your own custom stuff here..
    //[/Constructor]
}

VASTLogoComponent::~VASTLogoComponent()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    c_screenSize = nullptr;
    drawable1 = nullptr;
    drawable2 = nullptr;
    drawable3 = nullptr;
    drawable4 = nullptr;
    drawable5 = nullptr;
    drawable6 = nullptr;


    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void VASTLogoComponent::paint (juce::Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.fillAll (juce::Colour (0xff323e44));

    {
        int x = 0, y = 0, width = proportionOfWidth (1.0000f), height = proportionOfHeight (1.0000f);
        juce::Colour fillColour1 = juce::Colour (0xff2a3032), fillColour2 = juce::Colour (0xff141516);
        //[UserPaintCustomArguments] Customize the painting arguments here..
    		fillColour1 = myEditor->getCurrentVASTLookAndFeel()->findVASTColour(VASTColours::colVaporizerComponentBackground);
    		fillColour2 = myEditor->getCurrentVASTLookAndFeel()->findVASTColour(VASTColours::colVaporizerComponentBackground);
        //[/UserPaintCustomArguments]
        g.setGradientFill (juce::ColourGradient (fillColour1,
                                             static_cast<float> (proportionOfWidth (-0.0189f)) - 0.0f + x,
                                             static_cast<float> (proportionOfHeight (-0.1053f)) - 0.0f + y,
                                             fillColour2,
                                             static_cast<float> (proportionOfWidth (1.0213f)) - 0.0f + x,
                                             static_cast<float> (proportionOfHeight (1.0526f)) - 0.0f + y,
                                             false));
        g.fillRect (x, y, width, height);
    }

    {
        int x = proportionOfWidth (0.3762f), y = proportionOfHeight (0.1250f), width = proportionOfWidth (0.6095f), height = proportionOfHeight (0.5625f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black.withAlpha (0.639f));
        jassert (drawable1 != nullptr);
        if (drawable1 != nullptr)
            drawable1->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 0.639f);
    }

    {
        int x = proportionOfWidth (0.1548f), y = proportionOfHeight (0.0938f), width = proportionOfWidth (0.2119f), height = proportionOfHeight (0.7188f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black.withAlpha (0.613f));
        jassert (drawable2 != nullptr);
        if (drawable2 != nullptr)
            drawable2->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 0.613f);
    }

    {
        int x = proportionOfWidth (0.0191f), y = proportionOfHeight (0.0781f), width = proportionOfWidth (0.1310f), height = proportionOfHeight (0.8594f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black);
        jassert (drawable3 != nullptr);
        if (drawable3 != nullptr)
            drawable3->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 1.000f);
    }

    {
        int x = proportionOfWidth (0.3881f), y = proportionOfHeight (0.6900f), width = proportionOfWidth (0.5905f), height = proportionOfHeight (0.1094f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black.withAlpha (0.487f));
        jassert (drawable4 != nullptr);
        if (drawable4 != nullptr)
            drawable4->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 0.487f);
    }

    {
        int x = proportionOfWidth (0.1429f), y = proportionOfHeight (0.5169f), width = proportionOfWidth (0.2286f), height = proportionOfHeight (0.4219f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black);
        jassert (drawable5 != nullptr);
        if (drawable5 != nullptr)
            drawable5->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 1.000f);
    }

    {
        int x = proportionOfWidth (0.0400f), y = proportionOfHeight (0.2000f), width = proportionOfWidth (0.0850f), height = proportionOfHeight (0.6406f);
        //[UserPaintCustomArguments] Customize the painting arguments here..
        //[/UserPaintCustomArguments]
        g.setColour (juce::Colours::black.withAlpha (0.712f));
        jassert (drawable6 != nullptr);
        if (drawable6 != nullptr)
            drawable6->drawWithin (g, juce::Rectangle<int> (x, y, width, height).toFloat(),
                                   juce::RectanglePlacement::centred, 0.712f);
    }

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void VASTLogoComponent::resized()
{
    //[UserPreResize] Add your own custom resize code here..
    //[/UserPreResize]

    c_screenSize->setBounds (0, 0, proportionOfWidth (1.0000f), proportionOfHeight (1.0000f));
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void VASTLogoComponent::buttonClicked (juce::Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]
    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == c_screenSize.get())
    {
        //[UserButtonCode_c_screenSize] -- add your button handler code here..
		myEditor->vaporizerComponent->selectSizeMenu();
        //[/UserButtonCode_c_screenSize]
    }

    //[UserbuttonClicked_Post]
    //[/UserbuttonClicked_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...
//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Projucer information section --

    This is where the Projucer stores the metadata that describe this GUI layout, so
    make changes in here at your peril!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="VASTLogoComponent" componentName=""
                 parentClasses="public Component" constructorParams="AudioProcessorEditor *editor, AudioProcessor* processor"
                 variableInitialisers="myEditor((VASTAudioProcessorEditor*)editor), myProcessor((VASTAudioProcessor*)processor)"
                 snapPixels="8" snapActive="1" snapShown="1" overlayOpacity="0.330"
                 fixedSize="1" initialWidth="423" initialHeight="76">
  <BACKGROUND backgroundColour="ff323e44">
    <RECT pos="0 0 100% 100%" fill="linear: -1.891% -10.526%, 102.128% 105.263%, 0=ff2a3032, 1=ff141516"
          hasStroke="0"/>
    <IMAGE pos="37.619% 12.5% 60.952% 56.25%" resource="vaporizer2_svg"
           opacity="0.639" mode="1"/>
    <IMAGE pos="15.476% 9.375% 21.19% 71.875%" resource="vast_svg" opacity="0.613"
           mode="1"/>
    <IMAGE pos="1.905% 7.812% 13.095% 85.938%" resource="logokreis_svg"
           opacity="1.0" mode="1"/>
    <IMAGE pos="38.81% 69% 59.048% 10.938%" resource="copyright_svg" opacity="0.487"
           mode="1"/>
    <IMAGE pos="14.286% 51.688% 22.857% 42.188%" resource="dynamics_svg"
           opacity="1.0" mode="1"/>
    <IMAGE pos="4% 20% 8.5% 64.062%" resource="logokreisv_svg" opacity="0.712"
           mode="1"/>
  </BACKGROUND>
  <TEXTBUTTON name="c_screenSize" id="40a3d4cee5bfab7" memberName="c_screenSize"
              virtualName="" explicitFocusOrder="0" pos="0 0 100% 100%" bgColOff="a45c94"
              bgColOn="181f22" textCol="ffffff" textColOn="ffffff" buttonText=""
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif

//==============================================================================
// Binary resources - be careful not to edit any of these sections!

// JUCER_RESOURCE: copyright_svg, 44925, "../../Resources/copyright.svg"
static const unsigned char resource_VASTLogoComponent_copyright_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,
115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,46,
105,110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,
101,108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,110,
115,35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,45,
110,115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,34,
104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,111,
100,105,112,111,100,105,46,115,111,117,114,99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,107,
115,99,97,112,101,61,34,104,116,116,112,58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,119,
105,100,116,104,61,34,50,49,48,109,109,34,10,32,32,32,104,101,105,103,104,116,61,34,50,57,55,109,109,34,10,32,32,32,118,105,101,119,66,111,120,61,34,48,32,48,32,50,49,48,32,50,57,55,34,10,32,32,32,118,
101,114,115,105,111,110,61,34,49,46,49,34,10,32,32,32,105,100,61,34,115,118,103,51,55,53,56,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,51,32,40,50,
52,48,53,53,52,54,44,32,50,48,49,56,45,48,51,45,49,49,41,34,10,32,32,32,115,111,100,105,112,111,100,105,58,100,111,99,110,97,109,101,61,34,99,111,112,121,114,105,103,104,116,46,115,118,103,34,62,10,32,
32,60,100,101,102,115,10,32,32,32,32,32,105,100,61,34,100,101,102,115,51,55,53,50,34,62,10,32,32,32,32,60,112,97,116,116,101,114,110,10,32,32,32,32,32,32,32,121,61,34,48,34,10,32,32,32,32,32,32,32,120,
61,34,48,34,10,32,32,32,32,32,32,32,104,101,105,103,104,116,61,34,54,34,10,32,32,32,32,32,32,32,119,105,100,116,104,61,34,54,34,10,32,32,32,32,32,32,32,112,97,116,116,101,114,110,85,110,105,116,115,61,
34,117,115,101,114,83,112,97,99,101,79,110,85,115,101,34,10,32,32,32,32,32,32,32,105,100,61,34,69,77,70,104,98,97,115,101,112,97,116,116,101,114,110,34,32,47,62,10,32,32,32,32,60,112,97,116,116,101,114,
110,10,32,32,32,32,32,32,32,121,61,34,48,34,10,32,32,32,32,32,32,32,120,61,34,48,34,10,32,32,32,32,32,32,32,104,101,105,103,104,116,61,34,54,34,10,32,32,32,32,32,32,32,119,105,100,116,104,61,34,54,34,
10,32,32,32,32,32,32,32,112,97,116,116,101,114,110,85,110,105,116,115,61,34,117,115,101,114,83,112,97,99,101,79,110,85,115,101,34,10,32,32,32,32,32,32,32,105,100,61,34,69,77,70,104,98,97,115,101,112,97,
116,116,101,114,110,45,57,34,32,47,62,10,32,32,60,47,100,101,102,115,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,105,101,119,10,32,32,32,32,32,105,100,61,34,98,97,115,101,
34,10,32,32,32,32,32,112,97,103,101,99,111,108,111,114,61,34,35,102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,111,114,61,34,35,54,54,54,54,54,54,34,10,32,32,32,32,32,98,
111,114,100,101,114,111,112,97,99,105,116,121,61,34,49,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,99,105,116,121,61,34,48,46,48,34,10,32,32,32,32,32,105,110,
107,115,99,97,112,101,58,112,97,103,101,115,104,97,100,111,119,61,34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,61,34,50,46,56,34,10,32,32,32,32,32,105,110,107,115,99,97,
112,101,58,99,120,61,34,52,50,49,46,56,52,57,49,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,54,51,56,46,57,50,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,100,111,
99,117,109,101,110,116,45,117,110,105,116,115,61,34,109,109,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,116,45,108,97,121,101,114,61,34,108,97,121,101,114,49,34,10,32,
32,32,32,32,115,104,111,119,103,114,105,100,61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,119,105,100,116,104,61,34,50,53,54,48,34,10,32,32,
32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,104,101,105,103,104,116,61,34,49,51,54,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,120,61,34,
45,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,45,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,
105,122,101,100,61,34,49,34,32,47,62,10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,51,55,53,53,34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,
10,32,32,32,32,32,32,60,99,99,58,87,111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,
103,101,47,115,118,103,43,120,109,108,60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,32,32,32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,
117,114,99,101,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,73,109,97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,
60,100,99,58,116,105,116,108,101,62,60,47,100,99,58,116,105,116,108,101,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,114,100,102,58,82,68,70,62,10,32,32,60,47,109,101,
116,97,100,97,116,97,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,
111,117,112,109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,62,10,32,32,32,32,60,116,101,120,116,10,32,32,32,32,32,32,32,120,109,108,58,115,112,97,
99,101,61,34,112,114,101,115,101,114,118,101,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,
104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,49,48,46,53,56,51,51,51,51,48,50,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,46,50,53,59,102,111,110,116,45,102,
97,109,105,108,121,58,115,97,110,115,45,115,101,114,105,102,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,102,105,
108,108,58,35,48,48,48,48,48,48,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,
53,56,51,51,50,34,10,32,32,32,32,32,32,32,120,61,34,52,55,46,48,53,56,48,51,55,34,10,32,32,32,32,32,32,32,121,61,34,49,50,57,46,53,53,54,53,51,34,10,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,
51,55,55,48,34,62,60,116,115,112,97,110,10,32,32,32,32,32,32,32,32,32,115,111,100,105,112,111,100,105,58,114,111,108,101,61,34,108,105,110,101,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,116,115,112,
97,110,51,55,54,56,34,10,32,32,32,32,32,32,32,32,32,120,61,34,52,55,46,48,53,56,48,51,55,34,10,32,32,32,32,32,32,32,32,32,121,61,34,49,51,57,46,50,49,50,48,52,34,10,32,32,32,32,32,32,32,32,32,115,116,
121,108,101,61,34,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,32,47,62,60,47,116,101,120,116,62,10,32,32,32,32,60,103,10,32,32,32,32,32,32,32,105,100,61,34,103,51,
56,57,57,34,62,10,32,32,32,32,32,32,60,103,10,32,32,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,51,55,55,52,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,
121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,49,48,46,53,56,51,51,51,51,48,50,112,120,59,108,105,
110,101,45,104,101,105,103,104,116,58,49,46,50,53,59,102,111,110,116,45,102,97,109,105,108,121,58,115,97,110,115,45,115,101,114,105,102,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,
120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,102,105,108,108,58,35,102,50,102,50,102,50,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,
111,110,101,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,97,114,105,97,45,108,97,98,101,108,61,34,86,65,83,84,32,68,121,110,97,109,
105,99,115,32,45,32,84,111,98,105,97,115,32,83,116,101,105,110,34,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,50,51,34,10,32,
32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,
111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,
101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,
71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,
61,34,109,32,52,55,46,52,48,55,50,56,55,44,49,48,51,46,53,48,48,51,56,32,113,32,48,46,49,54,57,51,51,51,44,48,32,48,46,51,55,48,52,49,54,44,48,32,48,46,50,48,49,48,56,52,44,45,48,46,48,49,48,54,32,48,
46,51,48,54,57,49,55,44,48,46,48,53,50,57,32,48,46,48,57,53,50,53,44,48,46,48,54,51,53,32,48,46,49,50,55,44,48,46,50,48,49,48,56,32,48,46,48,52,50,51,51,44,48,46,49,51,55,53,56,32,48,46,48,56,52,54,55,
44,48,46,50,53,52,32,48,46,48,56,52,54,55,44,48,46,50,49,49,54,55,32,48,46,49,52,56,49,54,54,44,48,46,52,51,51,57,50,32,48,46,48,54,51,53,44,48,46,50,49,49,54,54,32,48,46,49,52,56,49,54,55,44,48,46,52,
50,51,51,51,32,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,48,46,49,48,53,56,51,32,48,46,48,49,48,53,56,44,48,46,48,53,50,57,32,48,46,48,50,49,49,55,44,48,46,49,48,53,56,52,32,
48,46,48,55,52,48,56,44,48,46,49,55,57,57,49,32,48,46,49,50,55,44,48,46,51,56,49,32,48,46,48,54,51,53,44,48,46,49,57,48,53,32,48,46,49,50,55,44,48,46,51,57,49,53,56,32,48,46,49,52,56,49,54,54,44,48,46,
52,51,51,57,50,32,48,46,50,56,53,55,53,44,48,46,56,53,55,50,53,32,48,46,49,52,56,49,54,54,44,48,46,52,50,51,51,51,32,48,46,50,57,54,51,51,51,44,48,46,56,53,55,50,53,32,48,46,48,55,52,48,56,44,48,46,50,
49,49,54,55,32,48,46,49,50,55,44,48,46,52,51,51,57,50,32,48,46,48,54,51,53,44,48,46,50,49,49,54,54,32,48,46,49,52,56,49,54,55,44,48,46,52,50,51,51,51,32,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,48,
46,48,51,49,55,53,44,48,46,49,49,54,52,50,32,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,48,46,48,52,50,51,51,44,48,46,49,50,55,32,48,46,49,49,54,52,49,55,44,48,46,51,48,54,57,49,32,48,46,50,49,49,54,
54,55,44,48,46,54,51,53,32,48,46,48,52,50,51,51,44,48,46,49,48,53,56,51,32,48,46,48,55,52,48,56,44,48,46,50,50,50,50,53,32,48,46,48,51,49,55,53,44,48,46,49,48,53,56,51,32,48,46,48,57,53,50,53,44,48,46,
49,57,48,53,32,48,46,48,50,49,49,55,44,48,46,48,50,49,50,32,48,46,48,55,52,48,56,44,48,46,48,54,51,53,32,48,46,49,50,55,44,45,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,45,48,46,49,48,53,56,52,32,48,
46,48,51,49,55,53,44,45,48,46,49,48,53,56,51,32,48,46,48,55,52,48,56,44,45,48,46,50,48,49,48,56,32,48,46,49,49,54,52,49,54,44,45,48,46,50,55,53,49,55,32,48,46,49,57,48,53,44,45,48,46,53,54,48,57,50,32,
48,46,48,55,52,48,56,44,45,48,46,50,56,53,55,53,32,48,46,49,55,57,57,49,54,44,45,48,46,53,54,48,57,49,32,48,46,48,54,51,53,44,45,48,46,49,54,57,51,52,32,48,46,49,48,53,56,51,52,44,45,48,46,51,51,56,54,
55,32,48,46,48,53,50,57,50,44,45,48,46,49,54,57,51,51,32,48,46,49,49,54,52,49,54,44,45,48,46,51,51,56,54,55,32,48,46,48,53,50,57,50,44,45,48,46,49,50,55,32,48,46,48,56,52,54,55,44,45,48,46,50,53,52,32,
48,46,48,52,50,51,51,44,45,48,46,49,51,55,53,56,32,48,46,48,57,53,50,53,44,45,48,46,50,54,52,53,56,32,48,46,49,53,56,55,53,44,45,48,46,52,52,52,53,32,48,46,50,57,54,51,51,51,44,45,48,46,56,57,57,53,56,
32,48,46,49,51,55,53,56,52,44,45,48,46,52,53,53,48,57,32,48,46,51,48,54,57,49,55,44,45,48,46,56,57,57,53,57,32,48,46,48,50,49,49,55,44,45,48,46,48,52,50,51,32,48,46,48,50,49,49,55,44,45,48,46,48,55,52,
49,32,48,44,45,48,46,48,52,50,51,32,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,48,46,48,54,51,53,44,45,48,46,49,53,56,55,53,32,48,46,49,49,54,52,49,55,44,45,48,46,51,50,56,48,56,32,48,46,48,53,50,
57,50,44,45,48,46,49,54,57,51,51,32,48,46,49,48,53,56,51,51,44,45,48,46,51,50,56,48,56,32,48,46,48,54,51,53,44,45,48,46,49,53,56,55,53,32,48,46,49,48,53,56,51,52,44,45,48,46,51,49,55,53,32,48,46,48,53,
50,57,50,44,45,48,46,49,54,57,51,52,32,48,46,49,49,54,52,49,54,44,45,48,46,51,51,56,54,55,32,48,46,48,51,49,55,53,44,45,48,46,48,57,53,50,32,48,46,48,54,51,53,44,45,48,46,49,55,57,57,50,32,48,46,48,52,
50,51,51,44,45,48,46,48,57,53,50,32,48,46,49,50,55,44,45,48,46,49,52,56,49,54,32,48,46,48,54,51,53,44,45,48,46,48,53,50,57,32,48,46,49,54,57,51,51,52,44,45,48,46,48,53,50,57,32,48,46,49,49,54,52,49,54,
44,48,32,48,46,50,51,50,56,51,51,44,48,32,104,32,48,46,50,51,50,56,51,51,32,113,32,48,46,48,56,52,54,55,44,48,46,48,50,49,50,32,48,46,49,52,56,49,54,55,44,48,46,48,52,50,51,32,48,46,48,54,51,53,44,48,
46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,46,48,57,53,51,32,48,44,48,46,48,50,49,50,32,48,44,48,46,48,53,50,57,32,48,46,48,49,48,53,56,44,48,46,48,50,49,50,32,48,44,48,46,48,52,50,51,32,45,48,46,48,
50,49,49,55,44,48,46,49,48,53,56,52,32,45,48,46,48,54,51,53,44,48,46,50,49,49,54,55,32,45,48,46,48,51,49,55,53,44,48,46,48,57,53,51,32,45,48,46,48,54,51,53,44,48,46,49,55,57,57,50,32,45,48,46,48,52,50,
51,51,44,48,46,48,56,52,55,32,45,48,46,48,55,52,48,56,44,48,46,49,55,57,57,49,32,45,48,46,48,50,49,49,55,44,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,48,46,49,54,57,51,52,32,45,48,46,48,54,51,53,
44,48,46,49,52,56,49,54,32,45,48,46,49,49,54,52,49,55,44,48,46,51,49,55,53,32,45,48,46,48,52,50,51,51,44,48,46,49,53,56,55,53,32,45,48,46,49,48,53,56,51,51,44,48,46,51,48,54,57,49,32,45,48,46,48,50,49,
49,55,44,48,46,48,52,50,51,32,45,48,46,48,50,49,49,55,44,48,46,48,55,52,49,32,48,44,48,46,48,51,49,56,32,45,48,46,48,50,49,49,55,44,48,46,48,55,52,49,32,45,48,46,48,56,52,54,55,44,48,46,49,55,57,57,50,
32,45,48,46,49,52,56,49,54,54,44,48,46,51,56,49,32,45,48,46,48,53,50,57,50,44,48,46,50,48,49,48,56,32,45,48,46,49,51,55,53,56,52,44,48,46,51,56,49,32,45,48,46,48,50,49,49,55,44,48,46,48,52,50,51,32,45,
48,46,48,50,49,49,55,44,48,46,48,56,52,55,32,48,44,48,46,48,51,49,56,32,45,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,45,48,46,48,53,50,57,50,44,48,46,49,51,55,53,56,32,45,48,46,49,48,53,56,51,51,44,
48,46,50,56,53,55,53,32,45,48,46,48,52,50,51,51,44,48,46,49,51,55,53,56,32,45,48,46,48,57,53,50,53,44,48,46,50,55,53,49,54,32,45,48,46,48,50,49,49,55,44,48,46,48,51,49,56,32,45,48,46,48,51,49,55,53,44,
48,46,48,55,52,49,32,48,44,48,46,48,51,49,56,32,45,48,46,48,50,49,49,55,44,48,46,48,55,52,49,32,45,48,46,49,53,56,55,53,44,48,46,52,48,50,49,55,32,45,48,46,50,57,54,51,51,51,44,48,46,56,49,52,57,50,32,
45,48,46,49,50,55,44,48,46,52,49,50,55,53,32,45,48,46,50,56,53,55,53,44,48,46,56,49,52,57,49,32,108,32,45,48,46,48,51,49,55,53,44,48,46,48,57,53,50,32,113,32,45,48,46,48,52,50,51,51,44,48,46,49,49,54,
52,50,32,45,48,46,48,56,52,54,55,44,48,46,50,51,50,56,52,32,45,48,46,48,51,49,55,53,44,48,46,49,48,53,56,51,32,45,48,46,48,55,52,48,56,44,48,46,50,50,50,50,53,32,45,48,46,48,53,50,57,50,44,48,46,49,50,
55,32,45,48,46,48,57,53,50,53,44,48,46,50,54,52,53,56,32,45,48,46,48,52,50,51,51,44,48,46,49,50,55,32,45,48,46,48,57,53,50,53,44,48,46,50,53,52,32,45,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,45,48,
46,48,52,50,51,51,44,48,46,49,50,55,32,45,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,45,48,46,48,52,50,51,51,44,48,46,49,50,55,32,45,48,46,48,54,51,53,44,48,46,49,53,56,55,53,32,45,48,46,49,49,54,52,
49,55,44,48,46,51,50,56,48,56,32,45,48,46,48,53,50,57,50,44,48,46,49,54,57,51,52,32,45,48,46,49,49,54,52,49,54,44,48,46,51,49,55,53,32,45,48,46,48,53,50,57,50,44,48,46,49,51,55,53,57,32,45,48,46,49,48,
53,56,51,52,44,48,46,50,57,54,51,52,32,45,48,46,48,52,50,51,51,44,48,46,49,52,56,49,54,32,45,48,46,49,52,56,49,54,54,44,48,46,50,50,50,50,53,32,45,48,46,48,52,50,51,51,44,48,46,48,50,49,50,32,45,48,46,
48,57,53,50,53,44,48,46,48,51,49,56,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,55,44,48,46,48,50,49,50,32,104,32,45,48,46,50,57,54,51,51,51,32,113,32,45,48,46,49,50,55,
44,48,32,45,48,46,50,55,53,49,54,55,44,48,32,45,48,46,49,52,56,49,54,55,44,48,46,48,49,48,54,32,45,48,46,50,51,50,56,51,51,44,45,48,46,48,52,50,51,32,45,48,46,48,57,53,50,53,44,45,48,46,48,53,50,57,32,
45,48,46,49,50,55,44,45,48,46,49,52,56,49,55,32,45,48,46,48,51,49,55,53,44,45,48,46,49,48,53,56,51,32,45,48,46,48,56,52,54,55,44,45,48,46,50,50,50,50,53,32,45,48,46,48,54,51,53,44,45,48,46,49,53,56,55,
53,32,45,48,46,49,49,54,52,49,55,44,45,48,46,51,50,56,48,56,32,45,48,46,48,53,50,57,50,44,45,48,46,49,55,57,57,50,32,45,48,46,49,50,55,44,45,48,46,51,52,57,50,53,32,45,48,46,48,50,49,49,55,44,45,48,46,
48,52,50,51,32,45,48,46,48,51,49,55,53,44,45,48,46,48,56,52,55,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,56,52,54,55,44,45,48,46,50,49,49,54,55,32,
45,48,46,49,53,56,55,53,44,45,48,46,52,50,51,51,52,32,45,48,46,48,54,51,53,44,45,48,46,50,50,50,50,53,32,45,48,46,49,52,56,49,54,55,44,45,48,46,52,50,51,51,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,
53,50,57,32,45,48,46,48,51,49,55,53,44,45,48,46,48,57,53,51,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,54,32,45,
48,46,49,48,53,56,51,51,44,45,48,46,50,56,53,55,53,32,45,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,54,32,45,48,46,49,48,53,56,51,51,44,45,48,46,50,57,54,51,51,32,45,48,46,48,50,49,49,55,44,45,48,46,
48,52,50,51,32,45,48,46,48,51,49,55,53,44,45,48,46,48,56,52,55,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,45,48,46,49,51,55,53,57,32,
45,48,46,49,48,53,56,51,51,44,45,48,46,50,55,53,49,55,32,45,48,46,48,52,50,51,51,44,45,48,46,49,52,56,49,55,32,45,48,46,48,57,53,50,53,44,45,48,46,50,57,54,51,51,32,45,48,46,48,53,50,57,50,44,45,48,46,
49,49,54,52,50,32,45,48,46,48,56,52,54,55,44,45,48,46,50,51,50,56,52,32,45,48,46,48,51,49,55,53,44,45,48,46,49,50,55,32,45,48,46,48,56,52,54,55,44,45,48,46,50,52,51,52,49,32,45,48,46,49,49,54,52,49,54,
44,45,48,46,50,57,54,51,52,32,45,48,46,50,49,49,54,54,54,44,45,48,46,54,48,51,50,53,32,45,48,46,48,57,53,50,53,44,45,48,46,51,49,55,53,32,45,48,46,50,50,50,50,53,44,45,48,46,54,49,51,56,52,32,45,48,46,
48,52,50,51,51,44,45,48,46,48,57,53,50,32,45,48,46,48,55,52,48,56,44,45,48,46,49,57,48,53,32,45,48,46,48,50,49,49,55,44,45,48,46,49,48,53,56,51,32,45,48,46,48,53,50,57,50,44,45,48,46,49,57,48,53,32,45,
48,46,48,51,49,55,53,44,45,48,46,48,54,51,53,32,45,48,46,48,53,50,57,50,44,45,48,46,49,50,55,32,45,48,46,48,49,48,53,56,44,45,48,46,48,55,52,49,32,45,48,46,48,52,50,51,51,44,45,48,46,49,51,55,53,56,32,
45,48,46,48,57,53,50,53,44,45,48,46,50,52,51,52,50,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,57,55,52,50,32,45,48,46,48,55,52,48,56,44,45,48,46,50,53,52,32,45,48,46,49,54,57,51,51,51,44,45,48,46,52,
57,55,52,49,32,45,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,45,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,55,32,45,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,45,48,46,48,52,50,51,51,44,45,
48,46,49,53,56,55,53,32,45,48,46,48,52,50,51,51,44,45,48,46,49,48,53,56,51,32,45,48,46,48,49,48,53,56,44,45,48,46,49,55,57,57,50,32,48,46,48,51,49,55,53,44,45,48,46,48,55,52,49,32,48,46,49,52,56,49,54,
55,44,45,48,46,48,57,53,51,32,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,50,49,49,55,44,48,32,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,122,34,32,47,62,
10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,50,53,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,
45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,
111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,
115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,
50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,54,48,46,50,52,56,51,52,50,44,49,49,48,46,52,55,52,56,32,113,
32,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,48,46,48,53,50,57,50,44,48,46,49,50,55,32,48,46,48,51,49,55,53,44,48,46,48,55,52,49,32,48,46,48,52,50,51,51,44,48,46,49,53,56,55,53,32,48,46,48,50,49,49,
55,44,48,46,48,55,52,49,32,48,44,48,46,49,52,56,49,54,32,45,48,46,48,49,48,53,56,44,48,46,48,54,51,53,32,45,48,46,48,56,52,54,55,44,48,46,48,57,53,51,32,45,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,
45,48,46,49,50,55,44,48,46,48,50,49,50,32,45,48,46,48,55,52,48,56,44,48,32,45,48,46,49,52,56,49,54,55,44,48,32,45,48,46,49,52,56,49,54,55,44,48,32,45,48,46,51,49,55,53,44,48,32,45,48,46,49,53,56,55,53,
44,48,32,45,48,46,50,53,52,44,45,48,46,48,53,50,57,32,45,48,46,49,48,53,56,51,51,44,45,48,46,48,54,51,53,32,45,48,46,49,53,56,55,53,44,45,48,46,50,50,50,50,53,32,45,48,46,48,52,50,51,51,44,45,48,46,49,
53,56,55,53,32,45,48,46,48,57,53,50,53,44,45,48,46,50,56,53,55,53,32,45,48,46,49,49,54,52,49,55,44,45,48,46,50,55,53,49,54,32,45,48,46,50,49,49,54,54,55,44,45,48,46,53,55,49,53,32,45,48,46,48,57,53,50,
53,44,45,48,46,50,57,54,51,51,32,45,48,46,50,49,49,54,54,54,44,45,48,46,53,56,50,48,56,32,45,48,46,48,51,49,55,53,44,45,48,46,48,57,53,51,32,45,48,46,48,54,51,53,44,45,48,46,49,55,57,57,50,32,45,48,46,
48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,54,51,53,44,45,48,46,49,53,56,55,53,32,45,48,46,48,51,49,55,53,44,45,48,46,48,55,52,49,32,45,48,46,48,57,53,50,53,44,45,48,46,49,50,55,32,45,48,46,
48,54,51,53,44,45,48,46,48,53,50,57,32,45,48,46,49,54,57,51,51,52,44,45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,45,48,46,48,50,49,50,32,45,48,46,49,50,55,44,45,48,46,48,49,48,54,32,45,48,46,48,
54,51,53,44,48,32,45,48,46,49,51,55,53,56,51,44,48,32,104,32,45,50,46,48,48,48,50,53,32,113,32,45,48,46,48,57,53,50,53,44,48,32,45,48,46,50,49,49,54,54,54,44,48,32,45,48,46,49,49,54,52,49,55,44,45,48,
46,48,49,48,54,32,45,48,46,50,50,50,50,53,44,48,32,45,48,46,49,48,53,56,51,52,44,48,46,48,49,48,54,32,45,48,46,50,48,49,48,56,52,44,48,46,48,51,49,56,32,45,48,46,48,56,52,54,55,44,48,46,48,50,49,50,32,
45,48,46,49,50,55,44,48,46,48,56,52,55,32,45,48,46,48,56,52,54,55,44,48,46,49,48,53,56,51,32,45,48,46,49,50,55,44,48,46,50,52,51,52,50,32,45,48,46,48,51,49,55,53,44,48,46,49,50,55,32,45,48,46,48,56,52,
54,55,44,48,46,50,54,52,53,56,32,45,48,46,49,48,53,56,51,52,44,48,46,50,52,51,52,50,32,45,48,46,50,48,49,48,56,52,44,48,46,53,48,56,32,45,48,46,48,56,52,54,55,44,48,46,50,54,52,53,56,32,45,48,46,49,57,
48,53,44,48,46,53,48,56,32,45,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,45,48,46,48,53,50,57,50,44,48,46,49,52,56,49,55,32,45,48,46,48,50,49,49,55,44,48,46,48,55,52,49,32,45,48,46,48,53,50,57,50,44,
48,46,49,53,56,55,53,32,45,48,46,48,51,49,55,53,44,48,46,48,56,52,55,32,45,48,46,48,55,52,48,56,44,48,46,49,53,56,55,53,32,45,48,46,48,51,49,55,53,44,48,46,48,54,51,53,32,45,48,46,48,55,52,48,56,44,48,
46,48,57,53,50,32,45,48,46,48,56,52,54,55,44,48,46,48,54,51,53,32,45,48,46,50,51,50,56,51,51,44,48,46,48,55,52,49,32,45,48,46,49,51,55,53,56,51,44,48,32,45,48,46,50,57,54,51,51,51,44,48,32,45,48,46,48,
56,52,54,55,44,48,32,45,48,46,49,54,57,51,51,52,44,48,32,45,48,46,48,55,52,48,56,44,45,48,46,48,49,48,54,32,45,48,46,49,50,55,44,45,48,46,48,53,50,57,32,45,48,46,48,53,50,57,50,44,45,48,46,48,51,49,56,
32,45,48,46,48,54,51,53,44,45,48,46,48,57,53,51,32,48,44,45,48,46,48,54,51,53,32,48,46,48,49,48,53,56,44,45,48,46,49,50,55,32,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,48,46,48,52,50,51,51,44,45,
48,46,49,51,55,53,56,32,48,46,48,51,49,55,53,44,45,48,46,48,55,52,49,32,48,46,48,53,50,57,50,44,45,48,46,49,48,53,56,51,32,48,46,49,52,56,49,54,54,44,45,48,46,51,51,56,54,55,32,48,46,50,54,52,53,56,51,
44,45,48,46,54,54,54,55,53,32,48,46,49,49,54,52,49,55,44,45,48,46,51,51,56,54,55,32,48,46,50,53,52,44,45,48,46,54,55,55,51,52,32,48,46,48,57,53,50,53,44,45,48,46,50,51,50,56,51,32,48,46,49,55,57,57,49,
55,44,45,48,46,52,53,53,48,56,32,48,46,48,56,52,54,55,44,45,48,46,50,51,50,56,51,32,48,46,49,55,57,57,49,54,44,45,48,46,52,54,53,54,55,32,48,46,51,49,55,53,44,45,48,46,55,54,50,32,48,46,54,48,51,50,53,
44,45,49,46,53,51,52,53,56,32,48,46,50,56,53,55,53,44,45,48,46,55,56,51,49,55,32,48,46,54,48,51,50,53,44,45,49,46,53,53,53,55,53,32,48,46,49,49,54,52,49,55,44,45,48,46,50,55,53,49,55,32,48,46,50,49,49,
54,54,55,44,45,48,46,53,54,48,57,50,32,48,46,49,48,53,56,51,51,44,45,48,46,50,56,53,55,53,32,48,46,50,50,50,50,53,44,45,48,46,53,54,48,57,49,32,48,46,48,53,50,57,50,44,45,48,46,49,49,54,52,50,32,48,46,
48,57,53,50,53,44,45,48,46,50,53,52,32,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,55,32,48,46,49,52,56,49,54,55,44,45,48,46,50,49,49,54,55,32,48,46,48,52,50,51,51,44,45,48,46,48,52,50,51,32,48,46,49,
51,55,53,56,51,44,45,48,46,48,54,51,53,32,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,51,49,55,53,44,48,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,48,
46,49,57,48,53,44,48,32,48,46,52,52,52,53,44,48,32,48,46,50,53,52,44,45,48,46,48,49,48,54,32,48,46,51,55,48,52,49,55,44,48,46,48,55,52,49,32,48,46,48,56,52,54,55,44,48,46,48,54,51,53,32,48,46,49,50,55,
44,48,46,50,49,49,54,55,32,48,46,48,53,50,57,50,44,48,46,49,51,55,53,56,32,48,46,49,48,53,56,51,51,44,48,46,50,53,52,32,48,46,49,48,53,56,51,51,44,48,46,50,52,51,52,49,32,48,46,49,57,48,53,44,48,46,52,
56,54,56,51,32,48,46,48,56,52,54,55,44,48,46,50,52,51,52,50,32,48,46,49,57,48,53,44,48,46,52,56,54,56,51,32,48,46,48,56,52,54,55,44,48,46,50,49,49,54,55,32,48,46,49,53,56,55,53,44,48,46,52,51,51,57,50,
32,48,46,48,56,52,54,55,44,48,46,50,50,50,50,53,32,48,46,49,55,57,57,49,54,44,48,46,52,51,51,57,50,32,48,46,51,49,55,53,44,48,46,55,55,50,53,56,32,48,46,54,48,51,50,53,44,49,46,53,54,54,51,51,32,48,46,
50,57,54,51,51,52,44,48,46,55,56,51,49,55,32,48,46,54,50,52,52,49,55,44,49,46,53,53,53,55,53,32,48,46,48,52,50,51,51,44,48,46,48,57,53,51,32,48,46,48,54,51,53,44,48,46,49,55,57,57,50,32,48,46,48,51,49,
55,53,44,48,46,48,56,52,55,32,48,46,48,54,51,53,44,48,46,49,55,57,57,49,32,48,46,49,49,54,52,49,55,44,48,46,50,55,53,49,55,32,48,46,50,50,50,50,53,44,48,46,53,54,48,57,50,32,48,46,49,49,54,52,49,55,44,
48,46,50,56,53,55,53,32,48,46,50,51,50,56,51,51,44,48,46,53,54,48,57,50,32,122,32,109,32,45,50,46,50,54,52,56,51,51,44,45,50,46,53,55,49,55,53,32,113,32,48,46,48,57,53,50,53,44,45,48,46,48,51,49,55,32,
48,46,49,49,54,52,49,55,44,45,48,46,49,48,53,56,52,32,48,46,48,51,49,55,53,44,45,48,46,48,55,52,49,32,48,46,48,49,48,53,56,44,45,48,46,49,53,56,55,53,32,45,48,46,48,49,48,53,56,44,45,48,46,48,57,53,50,
32,45,48,46,48,53,50,57,50,44,45,48,46,49,55,57,57,49,32,45,48,46,48,51,49,55,53,44,45,48,46,48,57,53,51,32,45,48,46,48,54,51,53,44,45,48,46,49,53,56,55,53,32,45,48,46,48,50,49,49,55,44,45,48,46,48,52,
50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,48,44,45,48,46,48,51,49,56,32,45,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,45,48,46,48,51,49,55,53,44,45,48,46,48,56,52,55,32,45,48,46,
48,54,51,53,44,45,48,46,49,54,57,51,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,57,53,50,32,45,48,46,48,54,51,53,44,45,48,46,49,57,48,53,32,45,48,46,49,53,56,55,53,44,45,48,46,51,56,49,32,45,48,46,50,
56,53,55,53,44,45,48,46,55,55,50,53,57,32,45,48,46,49,49,54,52,49,54,44,45,48,46,52,48,50,49,54,32,45,48,46,50,55,53,49,54,54,44,45,48,46,55,56,51,49,54,32,45,48,46,48,53,50,57,50,44,45,48,46,49,49,54,
52,50,32,45,48,46,48,57,53,50,53,44,45,48,46,50,51,50,56,52,32,45,48,46,48,51,49,55,53,44,45,48,46,49,49,54,52,49,32,45,48,46,48,56,52,54,55,44,45,48,46,50,50,50,50,53,32,45,48,46,48,50,49,49,55,44,45,
48,46,48,53,50,57,32,45,48,46,48,53,50,57,50,44,45,48,46,48,57,53,50,32,45,48,46,48,50,49,49,55,44,45,48,46,48,53,50,57,32,45,48,46,49,48,53,56,51,51,44,45,48,46,48,53,50,57,32,45,48,46,48,50,49,49,55,
44,48,46,48,50,49,50,32,45,48,46,48,52,50,51,51,44,48,46,48,51,49,56,32,45,48,46,48,50,49,49,55,44,48,46,48,49,48,54,32,45,48,46,48,52,50,51,51,44,48,46,48,51,49,55,32,45,48,46,48,52,50,51,51,44,48,46,
48,53,50,57,32,45,48,46,48,54,51,53,44,48,46,49,49,54,52,49,32,45,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,45,48,46,48,52,50,51,51,44,48,46,49,49,54,52,50,32,45,48,46,48,53,50,57,50,44,48,46,49,49,
54,52,50,32,45,48,46,48,56,52,54,55,44,48,46,50,51,50,56,51,32,45,48,46,48,51,49,55,53,44,48,46,49,49,54,52,50,32,45,48,46,48,56,52,54,55,44,48,46,50,51,50,56,52,32,45,48,46,49,55,57,57,49,55,44,48,46,
52,49,50,55,53,32,45,48,46,51,49,55,53,44,48,46,56,51,54,48,56,32,45,48,46,49,50,55,44,48,46,52,50,51,51,51,32,45,48,46,50,57,54,51,51,52,44,48,46,56,50,53,53,32,45,48,46,48,50,49,49,55,44,48,46,48,53,
50,57,32,45,48,46,48,52,50,51,51,44,48,46,49,48,53,56,51,32,45,48,46,48,49,48,53,56,44,48,46,48,53,50,57,32,45,48,46,48,51,49,55,53,44,48,46,49,48,53,56,52,32,45,48,46,48,51,49,55,53,44,48,46,48,56,52,
55,32,45,48,46,48,54,51,53,44,48,46,49,54,57,51,51,32,45,48,46,48,51,49,55,53,44,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,48,46,49,54,57,51,51,32,45,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,
45,48,46,48,50,49,49,55,44,48,46,49,49,54,52,50,32,48,46,48,49,48,53,56,44,48,46,48,54,51,53,32,48,46,48,51,49,55,53,44,48,46,49,48,53,56,51,32,48,46,48,53,50,57,50,44,48,46,48,56,52,55,32,48,46,50,50,
50,50,53,44,48,46,48,57,53,51,32,48,46,49,54,57,51,51,51,44,48,32,48,46,51,49,55,53,44,48,32,104,32,49,46,49,51,50,52,49,54,32,113,32,48,46,49,49,54,52,49,55,44,48,32,48,46,50,56,53,55,53,44,48,46,48,
49,48,54,32,48,46,49,54,57,51,51,52,44,48,32,48,46,50,53,52,44,45,48,46,48,51,49,56,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,
97,116,104,51,56,50,55,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,
58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,
109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,
108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,
32,32,32,32,32,32,32,32,32,100,61,34,109,32,54,51,46,54,50,57,48,53,54,44,49,48,51,46,51,51,49,48,53,32,113,32,48,46,54,48,51,50,53,44,45,48,46,48,50,49,50,32,49,46,48,54,56,57,49,55,44,48,46,48,57,53,
50,32,48,46,52,54,53,54,54,55,44,48,46,49,49,54,52,49,32,48,46,56,50,53,53,44,48,46,51,52,57,50,53,32,48,46,48,54,51,53,44,48,46,48,52,50,51,32,48,46,49,49,54,52,49,55,44,48,46,48,55,52,49,32,48,46,48,
54,51,53,44,48,46,48,51,49,55,32,48,46,49,49,54,52,49,54,44,48,46,48,56,52,55,32,48,46,48,50,49,49,55,44,48,46,48,50,49,50,32,48,46,48,52,50,51,51,44,48,46,48,52,50,51,32,48,46,48,50,49,49,55,44,48,46,
48,49,48,54,32,48,46,48,52,50,51,51,44,48,46,48,51,49,56,32,48,46,48,50,49,49,55,44,48,46,48,50,49,50,32,48,46,48,53,50,57,50,44,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,48,46,48,50,49,50,32,48,46,
48,53,50,57,50,44,48,46,48,53,50,57,32,48,46,48,52,50,51,51,44,48,46,48,53,50,57,32,48,46,48,56,52,54,55,44,48,46,49,48,53,56,52,32,48,46,48,52,50,51,51,44,48,46,48,53,50,57,32,48,46,48,56,52,54,55,44,
48,46,49,48,53,56,51,32,48,46,48,52,50,51,51,44,48,46,48,53,50,57,32,48,46,48,54,51,53,44,48,46,49,49,54,52,50,32,48,46,48,51,49,55,53,44,48,46,48,53,50,57,32,48,46,48,54,51,53,44,48,46,49,48,53,56,51,
32,48,46,48,57,53,50,53,44,48,46,49,52,56,49,55,32,48,46,49,52,56,49,54,55,44,48,46,51,51,56,54,55,32,48,46,48,53,50,57,50,44,48,46,49,55,57,57,49,32,48,46,49,48,53,56,51,51,44,48,46,51,56,49,32,48,46,
48,50,49,49,55,44,48,46,48,56,52,55,32,48,46,48,49,48,53,56,44,48,46,49,57,48,53,32,48,44,48,46,48,57,53,51,32,45,48,46,48,51,49,55,53,44,48,46,49,52,56,49,54,32,45,48,46,48,53,50,57,50,44,48,46,48,55,
52,49,32,45,48,46,49,54,57,51,51,52,44,48,46,48,56,52,55,32,45,48,46,49,49,54,52,49,54,44,48,46,48,49,48,54,32,45,48,46,50,52,51,52,49,54,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,32,45,48,
46,48,57,53,50,53,44,48,32,45,48,46,48,52,50,51,51,44,48,32,45,48,46,48,56,52,54,55,44,45,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,50,53,44,45,48,46,48,
49,48,54,32,45,48,46,48,51,49,55,53,44,48,32,45,48,46,48,55,52,48,56,44,45,48,46,48,50,49,50,32,45,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,45,48,46,48,52,50,51,51,44,45,48,46,48,50,49,50,32,45,
48,46,48,50,49,49,55,44,45,48,46,48,50,49,50,32,45,48,46,48,52,50,51,51,44,45,48,46,48,52,50,51,32,45,48,46,48,54,51,53,44,45,48,46,48,57,53,50,32,45,48,46,48,57,53,50,53,44,45,48,46,50,51,50,56,51,32,
45,48,46,48,50,49,49,55,44,45,48,46,49,51,55,53,57,32,45,48,46,48,55,52,48,56,44,45,48,46,50,52,51,52,50,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,50,51,51,51,32,45,48,46,53,48,56,44,45,48,46,54,51,
53,32,45,48,46,50,52,51,52,49,55,44,45,48,46,49,54,57,51,51,32,45,48,46,53,56,50,48,56,51,44,45,48,46,50,53,52,32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,45,48,46,49,50,55,44,45,48,46,48,50,49,
50,32,45,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,45,48,46,49,50,55,44,45,48,46,48,51,49,56,32,104,32,45,48,46,48,56,52,54,55,32,113,32,45,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,45,48,46,
49,54,57,51,51,51,44,45,48,46,48,50,49,50,32,45,48,46,48,56,52,54,55,44,48,32,45,48,46,49,54,57,51,51,52,44,48,32,45,48,46,53,53,48,51,51,51,44,48,32,45,48,46,57,50,48,55,53,44,48,46,49,54,57,51,51,32,
45,48,46,50,49,49,54,54,54,44,48,46,48,56,52,55,32,45,48,46,51,56,49,44,48,46,50,51,50,56,51,32,45,48,46,49,54,57,51,51,51,44,48,46,49,51,55,53,57,32,45,48,46,50,53,52,44,48,46,51,52,57,50,53,32,45,48,
46,48,52,50,51,51,44,48,46,48,56,52,55,32,45,48,46,48,54,51,53,44,48,46,49,55,57,57,50,32,45,48,46,48,49,48,53,56,44,48,46,48,56,52,55,32,45,48,46,48,51,49,55,53,44,48,46,49,57,48,53,32,45,48,46,48,50,
49,49,55,44,48,46,48,56,52,55,32,45,48,46,48,50,49,49,55,44,48,46,49,57,48,53,32,48,46,48,49,48,53,56,44,48,46,49,48,53,56,51,32,48,46,48,51,49,55,53,44,48,46,49,55,57,57,50,32,48,46,48,55,52,48,56,44,
48,46,50,52,51,52,49,32,48,46,49,55,57,57,49,54,44,48,46,51,55,48,52,49,32,48,46,49,49,54,52,49,55,44,48,46,49,50,55,32,48,46,51,49,55,53,44,48,46,50,52,51,52,50,32,48,46,50,51,50,56,51,52,44,48,46,49,
52,56,49,55,32,48,46,53,49,56,53,56,52,44,48,46,50,50,50,50,53,32,48,46,50,56,53,55,53,44,48,46,48,55,52,49,32,48,46,53,57,50,54,54,54,44,48,46,49,53,56,55,53,32,48,46,48,57,53,50,53,44,48,46,48,50,49,
50,32,48,46,49,57,48,53,44,48,46,48,51,49,56,32,48,46,48,57,53,50,53,44,48,46,48,49,48,54,32,48,46,49,57,48,53,44,48,46,48,52,50,51,32,48,46,49,52,56,49,54,55,44,48,46,48,52,50,51,32,48,46,51,48,54,57,
49,55,44,48,46,48,55,52,49,32,48,46,49,54,57,51,51,51,44,48,46,48,50,49,50,32,48,46,51,49,55,53,44,48,46,48,55,52,49,32,48,46,48,52,50,51,51,44,48,46,48,49,48,54,32,48,46,48,55,52,48,56,44,48,46,48,50,
49,50,32,48,46,48,51,49,55,53,44,48,32,48,46,48,55,52,48,56,44,48,46,48,49,48,54,32,48,46,48,57,53,50,53,44,48,46,48,50,49,50,32,48,46,49,57,48,53,44,48,46,48,53,50,57,32,48,46,48,57,53,50,53,44,48,46,
48,50,49,50,32,48,46,49,57,48,53,44,48,46,48,53,50,57,32,48,46,50,49,49,54,54,54,44,48,46,48,55,52,49,32,48,46,52,49,50,55,53,44,48,46,49,53,56,55,53,32,48,46,50,48,49,48,56,51,44,48,46,48,56,52,55,32,
48,46,51,56,49,44,48,46,50,48,49,48,57,32,48,46,50,51,50,56,51,51,44,48,46,49,52,56,49,54,32,48,46,52,49,50,55,52,57,44,48,46,51,52,57,50,53,32,48,46,49,57,48,53,44,48,46,49,57,48,53,32,48,46,51,48,54,
57,49,55,44,48,46,52,53,53,48,56,32,48,46,48,52,50,51,51,44,48,46,48,57,53,50,32,48,46,48,54,51,53,44,48,46,49,57,48,53,32,48,46,48,50,49,49,55,44,48,46,48,57,53,50,32,48,46,48,52,50,51,51,44,48,46,50,
48,49,48,56,32,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,48,46,48,50,49,49,55,44,48,46,49,50,55,32,48,44,48,46,48,54,51,53,32,48,46,48,50,49,49,55,44,48,46,49,50,55,32,118,32,48,46,49,49,54,52,50,32,
48,46,48,57,53,50,32,113,32,45,48,46,48,49,48,53,56,44,48,46,48,52,50,51,32,45,48,46,48,49,48,53,56,44,48,46,48,56,52,55,32,48,44,48,46,48,52,50,51,32,48,44,48,46,48,56,52,55,32,45,48,46,48,50,49,49,55,
44,48,46,48,56,52,55,32,45,48,46,48,51,49,55,53,44,48,46,49,55,57,57,50,32,48,44,48,46,48,56,52,55,32,45,48,46,48,51,49,55,53,44,48,46,49,54,57,51,51,32,45,48,46,48,53,50,57,50,44,48,46,49,53,56,55,53,
32,45,48,46,49,49,54,52,49,54,44,48,46,51,48,54,57,50,32,45,48,46,48,54,51,53,44,48,46,49,52,56,49,55,32,45,48,46,49,53,56,55,53,44,48,46,50,55,53,49,55,32,45,48,46,49,55,57,57,49,55,44,48,46,50,55,53,
49,54,32,45,48,46,52,53,53,48,56,52,44,48,46,52,54,53,54,54,32,45,48,46,50,55,53,49,54,54,44,48,46,49,57,48,53,32,45,48,46,53,57,50,54,54,54,44,48,46,51,51,56,54,55,32,45,48,46,49,48,53,56,51,51,44,48,
46,48,52,50,51,32,45,48,46,50,49,49,54,54,55,44,48,46,48,55,52,49,32,45,48,46,48,57,53,50,53,44,48,46,48,51,49,55,32,45,48,46,50,49,49,54,54,54,44,48,46,48,54,51,53,32,45,48,46,49,49,54,52,49,55,44,48,
46,48,52,50,51,32,45,48,46,50,52,51,52,49,55,44,48,46,48,53,50,57,32,45,48,46,49,50,55,44,48,46,48,50,49,50,32,45,48,46,50,53,52,44,48,46,48,53,50,57,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,
45,48,46,49,49,54,52,49,55,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,32,45,48,46,49,48,53,56,51,51,44,48,46,48,49,48,54,32,45,48,46,48,54,51,53,44,48,32,45,48,46,49,50,55,44,48,32,45,48,46,
48,54,51,53,44,48,46,48,49,48,54,32,45,48,46,49,50,55,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,45,48,46,49,53,56,55,53,44,48,46,48,49,48,54,32,45,48,46,48,57,53,50,53,44,
48,32,45,48,46,49,52,56,49,54,55,44,45,48,46,48,49,48,54,32,72,32,54,51,46,54,51,57,54,52,32,113,32,45,48,46,49,48,53,56,51,52,44,45,48,46,48,50,49,50,32,45,48,46,50,49,49,54,54,55,44,45,48,46,48,50,49,
50,32,45,48,46,49,48,53,56,51,51,44,48,32,45,48,46,50,48,49,48,56,51,44,45,48,46,48,50,49,50,32,45,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,45,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,45,
48,46,48,52,50,51,51,44,48,32,45,48,46,48,57,53,50,53,44,45,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,55,44,45,48,46,48,50,49,50,32,45,48,46,50,50,50,50,53,44,45,48,46,48,52,50,51,32,45,48,46,48,57,
53,50,53,44,45,48,46,48,50,49,50,32,45,48,46,50,48,49,48,56,51,44,45,48,46,48,54,51,53,32,45,48,46,53,49,56,53,56,52,44,45,48,46,49,54,57,51,51,32,45,48,46,56,55,56,52,49,55,44,45,48,46,52,51,51,57,50,
32,45,48,46,51,52,57,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,54,48,51,50,53,44,45,48,46,54,56,55,57,49,32,45,48,46,48,56,52,54,55,44,45,48,46,49,51,55,53,57,32,45,48,46,49,52,56,49,54,55,44,45,48,
46,50,56,53,55,53,32,45,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,55,32,45,48,46,49,48,53,56,51,51,44,45,48,46,51,49,55,53,32,45,48,46,48,50,49,49,55,44,45,48,46,48,54,51,53,32,45,48,46,48,51,49,55,
53,44,45,48,46,49,50,55,32,48,44,45,48,46,48,54,51,53,32,45,48,46,48,50,49,49,55,44,45,48,46,49,49,54,52,50,32,45,48,46,48,50,49,49,55,44,45,48,46,48,57,53,50,32,45,48,46,48,50,49,49,55,44,45,48,46,50,
49,49,54,55,32,48,44,45,48,46,49,50,55,32,48,46,48,53,50,57,50,44,45,48,46,49,55,57,57,49,32,48,46,48,53,50,57,50,44,45,48,46,48,55,52,49,32,48,46,49,54,57,51,51,52,44,45,48,46,48,56,52,55,32,48,46,49,
50,55,44,45,48,46,48,49,48,54,32,48,46,50,52,51,52,49,54,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,56,52,54,55,44,48,32,48,46,48,53,50,57,50,44,48,32,48,46,48,56,52,54,55,44,48,
46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,46,48,49,48,54,32,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,48,46,48,55,52,48,56,44,48,46,48,49,48,54,32,
48,46,48,55,52,48,56,44,48,46,48,52,50,51,32,48,46,48,57,53,50,53,44,48,46,48,56,52,55,32,48,46,48,51,49,55,53,44,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,48,46,49,49,54,52,50,32,48,46,48,49,48,53,
56,44,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,48,46,49,49,54,52,50,32,48,46,48,50,49,49,55,44,48,46,48,55,52,49,32,48,46,48,51,49,55,53,44,48,46,49,52,56,49,54,32,48,46,48,50,49,49,55,44,48,46,48,
55,52,49,32,48,46,48,53,50,57,50,44,48,46,49,52,56,49,55,32,48,46,49,55,57,57,49,55,44,48,46,52,53,53,48,56,32,48,46,53,51,57,55,53,44,48,46,55,49,57,54,55,32,48,46,49,55,57,57,49,55,44,48,46,49,51,55,
53,56,32,48,46,51,57,49,53,56,52,44,48,46,50,50,50,50,53,32,48,46,50,49,49,54,54,54,44,48,46,48,56,52,55,32,48,46,52,53,53,48,56,51,44,48,46,49,53,56,55,53,32,48,46,48,56,52,54,55,44,48,46,48,50,49,50,
32,48,46,49,54,57,51,51,51,44,48,46,48,51,49,56,32,48,46,48,56,52,54,55,44,48,46,48,49,48,54,32,48,46,49,54,57,51,51,52,44,48,46,48,50,49,50,32,48,46,48,50,49,49,55,44,48,32,48,46,48,53,50,57,50,44,48,
46,48,49,48,54,32,48,46,48,51,49,55,53,44,48,32,48,46,48,54,51,53,44,48,32,48,46,48,52,50,51,51,44,48,46,48,49,48,54,32,48,46,48,57,53,50,53,44,48,32,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,48,46,
49,49,54,52,49,55,44,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,46,48,49,48,54,32,48,46,49,49,54,52,49,55,44,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,32,48,46,49,51,55,53,56,51,44,45,48,46,
48,50,49,50,32,104,32,48,46,48,55,52,48,56,32,113,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,48,46,49,48,53,56,51,52,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,32,48,46,49,48,53,56,
51,51,44,45,48,46,48,49,48,54,32,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,32,48,46,48,51,49,55,53,44,48,32,48,46,48,55,52,48,56,44,45,48,46,48,50,49,50,32,48,46,48,56,
52,54,55,44,45,48,46,48,50,49,50,32,48,46,49,55,57,57,49,55,44,45,48,46,48,51,49,56,32,48,46,48,57,53,50,53,44,45,48,46,48,50,49,50,32,48,46,49,55,57,57,49,54,44,45,48,46,48,53,50,57,32,48,46,50,55,53,
49,54,55,44,45,48,46,49,49,54,52,50,32,48,46,52,56,54,56,51,52,44,45,48,46,50,54,52,53,57,32,48,46,50,50,50,50,53,44,45,48,46,49,53,56,55,53,32,48,46,51,51,56,54,54,54,44,45,48,46,52,50,51,51,51,32,48,
46,48,51,49,55,53,44,45,48,46,48,56,52,55,32,48,46,48,53,50,57,50,44,45,48,46,49,54,57,51,51,32,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,48,46,48,52,50,51,51,44,45,48,46,49,54,57,51,52,32,48,46,
48,50,49,49,55,44,45,48,46,48,56,52,55,32,48,46,48,50,49,49,55,44,45,48,46,50,48,49,48,56,32,48,44,45,48,46,49,49,54,52,50,32,45,48,46,48,50,49,49,55,44,45,48,46,49,57,48,53,32,45,48,46,48,50,49,49,55,
44,45,48,46,48,53,50,57,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,54,51,53,44,45,48,46,49,55,57,
57,50,32,45,48,46,49,54,57,51,51,51,44,45,48,46,50,57,54,51,52,32,45,48,46,49,48,53,56,51,52,44,45,48,46,49,50,55,32,45,48,46,50,53,52,44,45,48,46,50,51,50,56,51,32,45,48,46,50,50,50,50,53,44,45,48,46,
49,53,56,55,53,32,45,48,46,52,57,55,52,49,55,44,45,48,46,50,53,52,32,45,48,46,50,55,53,49,54,55,44,45,48,46,48,57,53,50,32,45,48,46,53,56,50,48,56,51,44,45,48,46,49,53,56,55,53,32,45,48,46,50,57,54,51,
51,52,44,45,48,46,48,55,52,49,32,45,48,46,54,49,51,56,51,52,44,45,48,46,49,51,55,53,56,32,45,48,46,51,49,55,53,44,45,48,46,48,54,51,53,32,45,48,46,54,49,51,56,51,51,44,45,48,46,49,52,56,49,55,32,45,48,
46,49,54,57,51,51,51,44,45,48,46,48,53,50,57,32,45,48,46,51,51,56,54,54,55,44,45,48,46,48,56,52,55,32,45,48,46,49,54,57,51,51,51,44,45,48,46,48,52,50,51,32,45,48,46,51,49,55,53,44,45,48,46,49,48,53,56,
51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,45,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,45,48,46,48,49,48,53,56,44,48,32,45,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,45,48,46,
49,48,53,56,51,51,44,45,48,46,48,52,50,51,32,45,48,46,50,49,49,54,54,54,44,45,48,46,48,56,52,55,32,45,48,46,49,48,53,56,51,52,44,45,48,46,48,52,50,51,32,45,48,46,50,48,49,48,56,52,44,45,48,46,49,48,53,
56,52,32,45,48,46,50,52,51,52,49,54,44,45,48,46,49,52,56,49,54,32,45,48,46,52,52,52,53,44,45,48,46,51,49,55,53,32,45,48,46,50,48,49,48,56,51,44,45,48,46,49,55,57,57,49,32,45,48,46,51,49,55,53,44,45,48,
46,52,53,53,48,56,32,45,48,46,48,53,50,57,50,44,45,48,46,48,57,53,51,32,45,48,46,48,55,52,48,56,44,45,48,46,50,48,49,48,56,32,45,48,46,48,50,49,49,55,44,45,48,46,49,49,54,52,50,32,45,48,46,48,53,50,57,
50,44,45,48,46,50,51,50,56,52,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,49,48,53,56,44,45,48,46,48,55,52,49,32,48,44,45,48,46,48,51,49,56,32,48,44,45,48,46,48,54,51,53,32,45,48,46,48,51,49,55,53,44,
45,48,46,49,50,55,32,45,48,46,48,49,48,53,56,44,45,48,46,51,49,55,53,32,48,46,48,50,49,49,55,44,45,48,46,50,48,49,48,56,32,48,46,48,53,50,57,50,44,45,48,46,51,48,54,57,50,32,48,46,48,51,49,55,53,44,45,
48,46,49,49,54,52,49,32,48,46,48,53,50,57,50,44,45,48,46,50,50,50,50,53,32,48,46,48,51,49,55,53,44,45,48,46,49,48,53,56,51,32,48,46,48,55,52,48,56,44,45,48,46,50,48,49,48,56,32,48,46,49,52,56,49,54,55,
44,45,48,46,51,49,55,53,32,48,46,51,56,49,44,45,48,46,53,50,57,49,55,32,48,46,50,51,50,56,51,52,44,45,48,46,50,50,50,50,53,32,48,46,53,49,56,53,56,52,44,45,48,46,52,48,50,49,54,32,48,46,48,50,49,49,55,
44,45,48,46,48,50,49,50,32,48,46,48,53,50,57,50,44,45,48,46,48,50,49,50,32,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,45,48,46,48,51,49,56,32,48,46,50,51,50,56,51,51,44,45,
48,46,49,49,54,52,50,32,48,46,53,51,57,55,53,44,45,48,46,50,48,49,48,56,32,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,48,46,49,53,56,55,53,44,45,48,46,48,51,49,56,32,48,46,48,55,52,48,56,44,45,48,
46,48,50,49,50,32,48,46,49,53,56,55,53,44,45,48,46,48,52,50,51,32,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,48,46,49,55,57,57,49,55,44,45,48,46,48,50,49,50,32,48,46,49,48,53,56,51,51,44,48,32,48,
46,49,57,48,53,44,45,48,46,48,50,49,50,32,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,48,46,48,57,53,50,53,44,48,32,48,46,48,54,51,53,44,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,45,48,46,48,49,
48,54,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,50,57,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,
101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,
111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,
107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,
58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,54,55,46,53,56,49,50,54,57,44,49,48,
51,46,52,55,57,50,49,32,104,32,52,46,52,50,51,56,51,51,32,48,46,56,48,52,51,51,51,32,113,32,48,46,49,48,53,56,51,51,44,48,32,48,46,50,49,49,54,54,55,44,48,32,48,46,49,48,53,56,51,51,44,48,32,48,46,49,
55,57,57,49,54,44,48,46,48,52,50,51,32,48,46,48,56,52,54,55,44,48,46,48,53,50,57,32,48,46,48,57,53,50,53,44,48,46,49,52,56,49,54,32,48,46,48,50,49,49,55,44,48,46,48,56,52,55,32,48,46,48,50,49,49,55,44,
48,46,50,50,50,50,53,32,118,32,48,46,49,50,55,32,113,32,45,48,46,48,50,49,49,55,44,48,46,48,56,52,55,32,45,48,46,48,52,50,51,51,44,48,46,49,51,55,53,57,32,45,48,46,48,49,48,53,56,44,48,46,48,53,50,57,
32,45,48,46,48,54,51,53,44,48,46,48,57,53,51,32,45,48,46,48,56,52,54,55,44,48,46,48,53,50,57,32,45,48,46,50,51,50,56,51,52,44,48,46,48,53,50,57,32,45,48,46,49,52,56,49,54,54,44,48,32,45,48,46,50,56,53,
55,53,44,48,32,104,32,45,49,46,50,48,54,53,32,113,32,45,48,46,49,49,54,52,49,54,44,48,32,45,48,46,50,51,50,56,51,51,44,48,32,45,48,46,49,48,53,56,51,51,44,45,48,46,48,49,48,54,32,45,48,46,50,48,49,48,
56,51,44,48,46,48,49,48,54,32,45,48,46,48,56,52,54,55,44,48,46,48,49,48,54,32,45,48,46,49,52,56,49,54,55,44,48,46,48,54,51,53,32,45,48,46,48,54,51,53,44,48,46,48,52,50,51,32,45,48,46,48,57,53,50,53,44,
48,46,49,51,55,53,56,32,45,48,46,48,51,49,55,53,44,48,46,48,57,53,51,32,45,48,46,48,50,49,49,55,44,48,46,50,52,51,52,50,32,48,46,48,49,48,53,56,44,48,46,49,52,56,49,54,32,48,46,48,49,48,53,56,44,48,46,
50,54,52,53,56,32,118,32,49,46,48,50,54,53,56,32,51,46,51,52,52,51,52,32,49,46,49,50,49,56,51,32,113,32,48,44,48,46,49,53,56,55,53,32,45,48,46,48,50,49,49,55,44,48,46,50,56,53,55,53,32,45,48,46,48,49,
48,53,56,44,48,46,49,50,55,32,45,48,46,49,49,54,52,49,54,44,48,46,49,55,57,57,50,32,45,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,45,48,46,49,50,55,44,48,46,48,51,49,56,32,45,48,46,48,55,52,48,56,44,
48,32,45,48,46,49,53,56,55,53,44,48,32,45,48,46,49,51,55,53,56,52,44,48,32,45,48,46,50,57,54,51,51,52,44,48,32,45,48,46,49,52,56,49,54,54,44,48,32,45,48,46,50,48,49,48,56,51,44,45,48,46,48,55,52,49,32,
45,48,46,48,54,51,53,44,45,48,46,48,56,52,55,32,45,48,46,48,55,52,48,56,44,45,48,46,50,48,49,48,56,32,48,44,45,48,46,49,49,54,52,50,32,48,44,45,48,46,50,53,52,32,118,32,45,48,46,57,52,49,57,50,32,45,51,
46,52,56,49,57,49,32,45,49,46,48,52,55,55,53,32,113,32,48,44,45,48,46,49,49,54,52,50,32,48,44,45,48,46,50,54,52,53,57,32,48,46,48,49,48,53,56,44,45,48,46,49,53,56,55,53,32,45,48,46,48,50,49,49,55,44,45,
48,46,50,53,52,32,45,48,46,48,53,50,57,50,44,45,48,46,49,54,57,51,51,32,45,48,46,50,52,51,52,49,55,44,45,48,46,49,55,57,57,49,32,45,48,46,49,55,57,57,49,54,44,45,48,46,48,49,48,54,32,45,48,46,51,57,49,
53,56,51,44,45,48,46,48,49,48,54,32,104,32,45,49,46,49,54,52,49,54,55,32,113,32,45,48,46,49,50,55,44,48,32,45,48,46,50,57,54,51,51,51,44,48,46,48,49,48,54,32,45,48,46,49,53,56,55,53,44,48,32,45,48,46,
50,52,51,52,49,55,44,45,48,46,48,51,49,55,32,45,48,46,48,51,49,55,53,44,45,48,46,48,50,49,50,32,45,48,46,48,54,51,53,44,45,48,46,48,52,50,51,32,45,48,46,48,51,49,55,53,44,45,48,46,48,50,49,50,32,45,48,
46,48,53,50,57,50,44,45,48,46,48,53,50,57,32,45,48,46,48,51,49,55,53,44,45,48,46,48,52,50,51,32,45,48,46,48,52,50,51,51,44,45,48,46,49,51,55,53,57,32,45,48,46,48,49,48,53,56,44,45,48,46,48,57,53,50,32,
45,48,46,48,49,48,53,56,44,45,48,46,49,57,48,53,32,48,46,48,49,48,53,56,44,45,48,46,48,57,53,50,32,48,46,48,51,49,55,53,44,45,48,46,49,55,57,57,49,32,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,48,
46,48,53,50,57,50,44,45,48,46,49,49,54,52,50,32,48,46,48,50,49,49,55,44,45,48,46,48,51,49,56,32,48,46,48,53,50,57,50,44,45,48,46,48,52,50,51,32,48,46,48,52,50,51,51,44,45,48,46,48,50,49,50,32,48,46,48,
56,52,54,55,44,45,48,46,48,51,49,56,32,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,50,49,49,55,44,48,32,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,122,34,
32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,51,49,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,
111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,
97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,
45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,
50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,56,51,46,50,57,50,56,56,57,44,49,48,55,46,48,
55,55,53,53,32,113,32,48,44,48,46,48,56,52,55,32,48,44,48,46,49,57,48,53,32,48,46,48,49,48,53,56,44,48,46,48,57,53,50,32,45,48,46,48,49,48,53,56,44,48,46,49,54,57,51,51,32,118,32,48,46,49,48,53,56,51,
32,113,32,45,48,46,48,49,48,53,56,44,48,46,48,51,49,56,32,45,48,46,48,49,48,53,56,44,48,46,48,55,52,49,32,48,46,48,49,48,53,56,44,48,46,48,52,50,51,32,48,44,48,46,48,54,51,53,32,45,48,46,48,49,48,53,56,
44,48,46,48,53,50,57,32,45,48,46,48,49,48,53,56,44,48,46,49,49,54,52,49,32,48,44,48,46,48,53,50,57,32,45,48,46,48,49,48,53,56,44,48,46,49,48,53,56,52,32,45,48,46,48,51,49,55,53,44,48,46,49,52,56,49,54,
32,45,48,46,48,52,50,51,51,44,48,46,51,49,55,53,32,45,48,46,48,49,48,53,56,44,48,46,49,53,56,55,53,32,45,48,46,48,54,51,53,44,48,46,51,48,54,57,49,32,45,48,46,48,51,49,55,53,44,48,46,49,50,55,32,45,48,
46,48,55,52,48,56,44,48,46,50,54,52,53,57,32,45,48,46,48,51,49,55,53,44,48,46,49,50,55,32,45,48,46,48,56,52,54,55,44,48,46,50,53,52,32,45,48,46,49,55,57,57,49,55,44,48,46,52,53,53,48,56,32,45,48,46,52,
53,53,48,56,52,44,48,46,56,50,53,53,32,45,48,46,50,54,52,53,56,51,44,48,46,51,53,57,56,51,32,45,48,46,54,54,54,55,52,57,44,48,46,54,49,51,56,51,32,45,48,46,50,48,49,48,56,52,44,48,46,49,50,55,32,45,48,
46,52,51,51,57,49,55,44,48,46,50,50,50,50,53,32,45,48,46,50,50,50,50,53,44,48,46,48,56,52,55,32,45,48,46,52,56,54,56,51,51,44,48,46,49,54,57,51,51,32,45,48,46,49,49,54,52,49,55,44,48,46,48,52,50,51,32,
45,48,46,50,53,52,44,48,46,48,54,51,53,32,45,48,46,49,50,55,44,48,46,48,49,48,54,32,45,48,46,50,53,52,44,48,46,48,52,50,51,32,45,48,46,49,49,54,52,49,55,44,48,46,48,50,49,50,32,45,48,46,50,51,50,56,51,
52,44,48,46,48,50,49,50,32,45,48,46,49,48,53,56,51,51,44,48,32,45,48,46,50,49,49,54,54,54,44,48,46,48,50,49,50,32,104,32,45,48,46,49,52,56,49,54,55,32,113,32,45,48,46,48,51,49,55,53,44,48,46,48,49,48,
54,32,45,48,46,48,55,52,48,56,44,48,46,48,49,48,54,32,45,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,45,48,46,48,56,52,54,55,44,45,48,46,48,49,48,54,32,104,32,45,50,46,49,49,54,54,54,55,32,113,32,
45,48,46,49,53,56,55,53,44,48,32,45,48,46,50,56,53,55,53,44,45,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,54,44,45,48,46,48,50,49,50,32,45,48,46,49,53,56,55,53,44,45,48,46,49,51,55,53,57,32,45,48,46,
48,52,50,51,51,44,45,48,46,48,56,52,55,32,45,48,46,48,52,50,51,51,44,45,48,46,50,52,51,52,49,32,48,46,48,49,48,53,56,44,45,48,46,49,53,56,55,53,32,48,46,48,49,48,53,56,44,45,48,46,50,56,53,55,53,32,118,
32,45,54,46,50,53,52,55,53,32,113,32,48,44,45,48,46,49,50,55,32,45,48,46,48,49,48,53,56,44,45,48,46,50,54,52,53,57,32,48,44,45,48,46,49,52,56,49,54,32,48,46,48,53,50,57,50,44,45,48,46,50,51,50,56,51,32,
48,46,48,52,50,51,51,44,45,48,46,48,55,52,49,32,48,46,49,53,56,55,53,44,45,48,46,48,57,53,50,32,48,46,48,50,49,49,55,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,50,49,49,55,44,48,
32,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,104,32,50,46,50,57,54,53,56,52,32,113,32,48,46,48,53,50,57,50,44,48,32,48,46,48,57,53,50,53,44,48,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,
48,46,48,57,53,50,53,44,48,32,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,48,46,49,48,53,56,51,51,44,48,46,48,49,48,54,32,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,48,46,49,49,54,52,49,55,44,48,32,
48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,48,46,49,49,54,52,49,54,44,48,46,48,49,48,54,32,48,46,48,54,51,53,44,48,32,48,46,49,49,54,52,49,55,44,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,46,48,
49,48,54,32,48,46,48,57,53,50,53,44,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,32,48,46,49,48,53,56,51,51,44,48,46,48,49,48,54,32,48,46,49,49,54,52,49,55,44,48,46,48,50,49,50,32,48,46,50,50,50,50,
53,44,48,46,48,52,50,51,32,48,46,49,48,53,56,51,52,44,48,46,48,49,48,54,32,48,46,50,49,49,54,54,55,44,48,46,48,52,50,51,32,48,46,50,51,50,56,51,51,44,48,46,48,55,52,49,32,48,46,52,52,52,53,44,48,46,49,
52,56,49,55,32,48,46,50,49,49,54,54,55,44,48,46,48,54,51,53,32,48,46,51,57,49,53,56,51,44,48,46,49,55,57,57,49,32,48,46,49,52,56,49,54,55,44,48,46,48,56,52,55,32,48,46,50,54,52,53,56,51,44,48,46,49,54,
57,51,52,32,48,46,48,51,49,55,53,44,48,46,48,50,49,50,32,48,46,48,54,51,53,44,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,48,46,48,50,49,50,32,48,46,48,54,51,53,44,48,46,48,52,50,51,32,48,46,48,54,51,
53,44,48,46,48,53,50,57,32,48,46,49,49,54,52,49,55,44,48,46,49,48,53,56,51,32,48,46,48,53,50,57,50,44,48,46,48,53,50,57,32,48,46,49,48,53,56,51,51,44,48,46,49,48,53,56,51,32,48,46,48,53,50,57,50,44,48,
46,48,53,50,57,32,48,46,48,56,52,54,55,44,48,46,48,55,52,49,32,48,46,48,52,50,51,51,44,48,46,48,54,51,53,32,48,46,48,56,52,54,55,44,48,46,49,49,54,52,49,32,48,46,48,53,50,57,50,44,48,46,48,53,50,57,32,
48,46,48,57,53,50,53,44,48,46,49,49,54,52,50,32,48,46,48,53,50,57,50,44,48,46,48,54,51,53,32,48,46,48,56,52,54,55,44,48,46,49,51,55,53,56,32,48,46,48,52,50,51,51,44,48,46,48,54,51,53,32,48,46,48,57,53,
50,53,44,48,46,49,51,55,53,57,32,48,46,48,50,49,49,55,44,48,46,48,52,50,51,32,48,46,48,51,49,55,53,44,48,46,48,55,52,49,32,48,46,48,49,48,53,56,44,48,46,48,51,49,56,32,48,46,48,51,49,55,53,44,48,46,48,
55,52,49,32,48,46,48,52,50,51,51,44,48,46,48,56,52,55,32,48,46,48,55,52,48,56,44,48,46,49,54,57,51,52,32,48,46,48,51,49,55,53,44,48,46,48,55,52,49,32,48,46,48,55,52,48,56,44,48,46,49,53,56,55,53,32,48,
46,48,52,50,51,51,44,48,46,49,49,54,52,49,32,48,46,48,54,51,53,44,48,46,50,52,51,52,49,32,48,46,48,51,49,55,53,44,48,46,49,49,54,52,50,32,48,46,48,54,51,53,44,48,46,50,51,50,56,52,32,48,46,48,50,49,49,
55,44,48,46,48,54,51,53,32,48,46,48,50,49,49,55,44,48,46,49,50,55,32,48,44,48,46,48,53,50,57,32,48,46,48,50,49,49,55,44,48,46,49,49,54,52,49,32,48,46,48,53,50,57,50,44,48,46,49,57,48,53,32,48,46,48,53,
50,57,50,44,48,46,52,50,51,51,52,32,48,46,48,49,48,53,56,44,48,46,50,50,50,50,53,32,48,46,48,49,48,53,56,44,48,46,52,52,52,53,32,122,32,109,32,45,49,46,48,48,53,52,49,54,44,48,46,53,53,48,51,51,32,113,
32,48,46,48,50,49,49,55,44,45,48,46,49,48,53,56,51,32,48,46,48,50,49,49,55,44,45,48,46,50,50,50,50,53,32,48,44,45,48,46,49,50,55,32,48,44,45,48,46,50,52,51,52,50,32,48,44,45,48,46,48,56,52,55,32,48,44,
45,48,46,49,53,56,55,53,32,48,46,48,49,48,53,56,44,45,48,46,48,56,52,55,32,45,48,46,48,49,48,53,56,44,45,48,46,49,53,56,55,53,32,48,44,45,48,46,48,51,49,56,32,45,48,46,48,49,48,53,56,44,45,48,46,48,54,
51,53,32,48,44,45,48,46,48,51,49,56,32,48,44,45,48,46,48,55,52,49,32,45,48,46,48,50,49,49,55,44,45,48,46,49,49,54,52,50,32,45,48,46,48,51,49,55,53,44,45,48,46,50,51,50,56,51,32,48,44,45,48,46,49,49,54,
52,50,32,45,48,46,48,51,49,55,53,44,45,48,46,50,51,50,56,52,32,45,48,46,48,50,49,49,55,44,45,48,46,48,56,52,55,32,45,48,46,48,52,50,51,51,44,45,48,46,49,53,56,55,53,32,45,48,46,48,49,48,53,56,44,45,48,
46,48,56,52,55,32,45,48,46,48,51,49,55,53,44,45,48,46,49,54,57,51,51,32,45,48,46,49,49,54,52,49,54,44,45,48,46,51,56,49,32,45,48,46,50,57,54,51,51,51,44,45,48,46,54,54,54,55,53,32,45,48,46,50,57,54,51,
51,51,44,45,48,46,52,55,54,50,53,32,45,48,46,56,55,56,52,49,54,44,45,48,46,55,49,57,54,55,32,45,48,46,48,57,53,50,53,44,45,48,46,48,53,50,57,32,45,48,46,50,48,49,48,56,52,44,45,48,46,48,55,52,49,32,45,
48,46,49,48,53,56,51,51,44,45,48,46,48,51,49,55,32,45,48,46,50,50,50,50,53,44,45,48,46,48,54,51,53,32,45,48,46,49,49,54,52,49,54,44,45,48,46,48,51,49,56,32,45,48,46,50,52,51,52,49,54,44,45,48,46,48,51,
49,56,32,45,48,46,49,49,54,52,49,55,44,45,48,46,48,49,48,54,32,45,48,46,50,51,50,56,51,52,44,45,48,46,48,51,49,56,32,104,32,45,48,46,50,50,50,50,53,32,113,32,45,48,46,48,51,49,55,53,44,45,48,46,48,49,
48,54,32,45,48,46,48,55,52,48,56,44,45,48,46,48,49,48,54,32,45,48,46,48,52,50,51,51,44,48,32,45,48,46,48,56,52,54,55,44,48,32,72,32,55,56,46,52,48,51,51,57,32,113,32,45,48,46,48,50,49,49,55,44,48,46,48,
49,48,54,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,45,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,32,45,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,45,48,46,
49,48,53,56,51,51,44,48,46,48,52,50,51,32,45,48,46,48,52,50,51,51,44,48,46,48,50,49,50,32,45,48,46,48,54,51,53,44,48,46,48,54,51,53,32,45,48,46,48,50,49,49,55,44,48,46,48,52,50,51,32,45,48,46,48,52,50,
51,51,44,48,46,49,52,56,49,55,32,118,32,48,46,48,56,52,55,32,113,32,45,48,46,48,49,48,53,56,44,48,46,48,52,50,51,32,45,48,46,48,49,48,53,56,44,48,46,48,57,53,50,32,48,44,48,46,48,53,50,57,32,48,44,48,
46,48,57,53,51,32,118,32,52,46,56,48,52,56,51,32,113,32,48,44,48,46,48,53,50,57,32,48,44,48,46,49,48,53,56,51,32,48,44,48,46,48,52,50,51,32,48,46,48,49,48,53,56,44,48,46,48,56,52,55,32,118,32,48,46,48,
56,52,55,32,113,32,48,46,48,50,49,49,55,44,48,46,49,48,53,56,51,32,48,46,48,52,50,51,51,44,48,46,49,52,56,49,54,32,48,46,48,56,52,54,55,44,48,46,49,50,55,32,48,46,51,49,55,53,44,48,46,49,50,55,32,48,46,
50,51,50,56,51,51,44,45,48,46,48,49,48,54,32,48,46,52,52,52,53,44,45,48,46,48,49,48,54,32,104,32,48,46,54,49,51,56,51,51,32,113,32,48,46,48,55,52,48,56,44,48,32,48,46,49,53,56,55,53,44,48,46,48,49,48,
54,32,48,46,48,56,52,54,55,44,48,32,48,46,49,52,56,49,54,55,44,45,48,46,48,50,49,50,32,104,32,48,46,49,49,54,52,49,55,32,113,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,48,46,49,49,54,52,49,54,
44,48,32,48,46,48,54,51,53,44,48,32,48,46,49,50,55,44,45,48,46,48,49,48,54,32,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,48,46,49,50,55,44,45,48,46,48,50,49,50,32,48,46,48,54,51,53,44,45,48,46,48,49,
48,54,32,48,46,49,51,55,53,56,52,44,45,48,46,48,51,49,56,32,48,46,49,49,54,52,49,54,44,45,48,46,48,51,49,56,32,48,46,50,50,50,50,53,44,45,48,46,48,54,51,53,32,48,46,49,49,54,52,49,54,44,45,48,46,48,51,
49,56,32,48,46,50,51,50,56,51,51,44,45,48,46,48,56,52,55,32,48,46,51,57,49,53,56,51,44,45,48,46,49,54,57,51,51,32,48,46,54,54,54,55,53,44,45,48,46,52,53,53,48,56,32,48,46,50,56,53,55,53,44,45,48,46,50,
57,54,51,52,32,48,46,52,54,53,54,54,54,44,45,48,46,54,57,56,53,32,48,46,48,53,50,57,50,44,45,48,46,49,49,54,52,50,32,48,46,48,56,52,54,55,44,45,48,46,50,52,51,52,50,32,48,46,48,52,50,51,51,44,45,48,46,
49,51,55,53,56,32,48,46,48,56,52,54,55,44,45,48,46,50,55,53,49,55,32,48,46,48,51,49,55,53,44,45,48,46,49,49,54,52,49,32,48,46,48,52,50,51,51,44,45,48,46,50,52,51,52,49,32,48,46,48,50,49,49,55,44,45,48,
46,49,51,55,53,57,32,48,46,48,52,50,51,51,44,45,48,46,50,54,52,53,57,32,48,46,48,49,48,53,56,44,45,48,46,48,53,50,57,32,48,46,48,49,48,53,56,44,45,48,46,48,56,52,55,32,48,44,45,48,46,48,52,50,51,32,48,
44,45,48,46,48,56,52,55,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,51,51,34,10,32,32,32,32,32,32,32,32,32,32,
32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,
103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,
114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,
39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,56,52,46,49,
53,49,52,54,51,44,49,48,53,46,53,55,52,55,49,32,113,32,48,46,49,51,55,53,56,51,44,48,32,48,46,51,49,55,53,44,48,32,48,46,49,55,57,57,49,54,44,45,48,46,48,49,48,54,32,48,46,50,54,52,53,56,51,44,48,46,48,
52,50,51,32,48,46,48,56,52,54,55,44,48,46,48,53,50,57,32,48,46,49,49,54,52,49,55,44,48,46,49,51,55,53,56,32,48,46,48,52,50,51,51,44,48,46,48,56,52,55,32,48,46,48,56,52,54,55,44,48,46,49,55,57,57,50,32,
48,46,48,53,50,57,50,44,48,46,49,51,55,53,56,32,48,46,48,57,53,50,53,44,48,46,50,55,53,49,54,32,48,46,48,52,50,51,51,44,48,46,49,51,55,53,57,32,48,46,48,57,53,50,53,44,48,46,50,55,53,49,55,32,48,46,48,
53,50,57,50,44,48,46,49,50,55,32,48,46,48,57,53,50,53,44,48,46,50,54,52,53,56,32,48,46,48,52,50,51,51,44,48,46,49,50,55,32,48,46,48,57,53,50,53,44,48,46,50,53,52,32,48,46,48,53,50,57,50,44,48,46,49,49,
54,52,50,32,48,46,48,56,52,54,55,44,48,46,50,52,51,52,50,32,48,46,48,51,49,55,53,44,48,46,49,50,55,32,48,46,48,56,52,54,55,44,48,46,50,53,52,32,48,46,49,50,55,44,48,46,51,48,54,57,50,32,48,46,50,51,50,
56,51,51,44,48,46,54,51,53,32,48,46,49,48,53,56,51,51,44,48,46,51,50,56,48,56,32,48,46,50,51,50,56,51,51,44,48,46,54,51,53,32,48,46,48,50,49,49,55,44,48,46,48,52,50,51,32,48,46,48,50,49,49,55,44,48,46,
48,56,52,55,32,48,44,48,46,48,51,49,56,32,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,48,46,48,54,51,53,44,48,46,49,52,56,49,54,32,48,46,49,49,54,52,49,54,44,48,46,51,48,54,57,49,32,48,46,48,53,50,57,
50,44,48,46,49,52,56,49,55,32,48,46,49,48,53,56,51,52,44,48,46,50,57,54,51,52,32,48,46,48,51,49,55,53,44,48,46,48,55,52,49,32,48,46,48,54,51,53,44,48,46,49,53,56,55,53,32,48,46,48,51,49,55,53,44,48,46,
48,55,52,49,32,48,46,49,48,53,56,51,51,44,48,46,48,57,53,51,32,48,46,48,56,52,54,55,44,48,46,48,51,49,55,32,48,46,49,50,55,44,45,48,46,48,53,50,57,32,48,46,48,53,50,57,50,44,45,48,46,48,57,53,51,32,48,
46,48,55,52,48,56,44,45,48,46,49,52,56,49,55,32,48,46,48,56,52,54,55,44,45,48,46,49,55,57,57,49,32,48,46,49,51,55,53,56,51,44,45,48,46,51,56,49,32,48,46,48,53,50,57,50,44,45,48,46,50,48,49,48,56,32,48,
46,49,50,55,44,45,48,46,51,57,49,53,56,32,48,46,48,57,53,50,53,44,45,48,46,50,52,51,52,50,32,48,46,49,54,57,51,51,52,44,45,48,46,52,56,54,56,51,32,48,46,48,55,52,48,56,44,45,48,46,50,53,52,32,48,46,49,
55,57,57,49,54,44,45,48,46,52,56,54,56,52,32,48,46,48,49,48,53,56,44,45,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,45,48,46,49,51,55,53,56,32,48,46,48,52,50,51,51,44,45,48,46,48,57,53,50,32,48,46,48,
55,52,48,56,44,45,48,46,49,57,48,53,32,48,46,48,51,49,55,53,44,45,48,46,49,48,53,56,51,32,48,46,48,54,51,53,44,45,48,46,49,57,48,53,32,48,46,48,50,49,49,55,44,45,48,46,48,53,50,57,32,48,46,48,51,49,55,
53,44,45,48,46,48,57,53,50,32,48,46,48,49,48,53,56,44,45,48,46,48,52,50,51,32,48,46,48,51,49,55,53,44,45,48,46,48,57,53,51,32,48,46,48,53,50,57,50,44,45,48,46,49,50,55,32,48,46,48,56,52,54,55,44,45,48,
46,50,53,52,32,48,46,48,52,50,51,51,44,45,48,46,49,51,55,53,56,32,48,46,48,57,53,50,53,44,45,48,46,50,54,52,53,56,32,48,46,48,50,49,49,55,44,45,48,46,48,53,50,57,32,48,46,48,51,49,55,53,44,45,48,46,48,
57,53,50,32,48,46,48,49,48,53,56,44,45,48,46,48,52,50,51,32,48,46,48,51,49,55,53,44,45,48,46,48,57,53,51,32,48,46,48,52,50,51,51,44,45,48,46,48,57,53,50,32,48,46,48,55,52,48,56,44,45,48,46,49,57,48,53,
32,48,46,48,51,49,55,53,44,45,48,46,49,48,53,56,52,32,48,46,48,54,51,53,44,45,48,46,50,48,49,48,57,32,48,46,48,51,49,55,53,44,45,48,46,48,56,52,55,32,48,46,48,53,50,57,50,44,45,48,46,49,54,57,51,51,32,
48,46,48,51,49,55,53,44,45,48,46,48,57,53,50,32,48,46,48,56,52,54,55,44,45,48,46,49,53,56,55,53,32,48,46,48,55,52,48,56,44,45,48,46,48,57,53,51,32,48,46,50,48,49,48,56,51,44,45,48,46,49,48,53,56,51,32,
48,46,49,51,55,53,56,52,44,45,48,46,48,49,48,54,32,48,46,50,57,54,51,51,52,44,45,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,32,48,46,49,53,56,55,53,44,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,
48,32,48,46,49,51,55,53,56,51,44,48,46,48,51,49,56,32,48,46,48,57,53,50,53,44,48,46,48,54,51,53,32,48,46,48,53,50,57,50,44,48,46,50,48,49,48,56,32,45,48,46,48,52,50,51,51,44,48,46,49,51,55,53,56,32,45,
48,46,48,55,52,48,56,44,48,46,50,49,49,54,55,32,45,48,46,48,49,48,53,56,44,48,46,48,50,49,50,32,45,48,46,48,50,49,49,55,44,48,46,48,52,50,51,32,48,44,48,46,48,50,49,50,32,45,48,46,48,49,48,53,56,44,48,
46,48,52,50,51,32,45,48,46,49,49,54,52,49,54,44,48,46,50,57,54,51,52,32,45,48,46,50,51,50,56,51,51,44,48,46,54,48,51,50,53,32,45,48,46,49,49,54,52,49,55,44,48,46,50,57,54,51,52,32,45,48,46,50,51,50,56,
51,51,44,48,46,53,57,50,54,55,32,45,48,46,48,51,49,55,53,44,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,48,46,49,53,56,55,53,32,45,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,45,48,46,48,53,50,57,
50,44,48,46,49,51,55,53,56,32,45,48,46,48,56,52,54,55,44,48,46,50,49,49,54,55,32,45,48,46,49,54,57,51,51,51,44,48,46,52,51,51,57,50,32,45,48,46,48,55,52,48,56,44,48,46,50,49,49,54,55,32,45,48,46,49,53,
56,55,53,44,48,46,52,50,51,51,51,32,45,48,46,51,48,54,57,49,55,44,48,46,55,51,48,50,53,32,45,48,46,53,55,49,53,44,49,46,52,55,49,48,57,32,45,48,46,50,54,52,53,56,51,44,48,46,55,52,48,56,51,32,45,48,46,
53,55,49,53,44,49,46,52,55,49,48,56,32,45,48,46,48,50,49,49,55,44,48,46,48,53,50,57,32,45,48,46,48,52,50,51,51,44,48,46,49,48,53,56,51,32,45,48,46,48,49,48,53,56,44,48,46,48,54,51,53,32,45,48,46,48,51,
49,55,53,44,48,46,49,50,55,32,45,48,46,49,54,57,51,51,51,44,48,46,51,57,49,53,57,32,45,48,46,51,53,57,56,51,51,44,48,46,55,55,50,53,57,32,45,48,46,49,57,48,53,44,48,46,51,57,49,53,56,32,45,48,46,53,50,
57,49,54,55,44,48,46,54,48,51,50,53,32,45,48,46,49,49,54,52,49,55,44,48,46,48,54,51,53,32,45,48,46,50,51,50,56,51,51,44,48,46,48,57,53,51,32,45,48,46,49,49,54,52,49,55,44,48,46,48,52,50,51,32,45,48,46,
50,54,52,53,56,52,44,48,46,48,55,52,49,32,45,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,45,48,46,49,49,54,52,49,54,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,45,48,46,
49,49,54,52,49,55,44,48,32,45,48,46,48,56,52,54,55,44,48,46,48,50,49,50,32,45,48,46,49,54,57,51,51,51,44,48,32,45,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,45,48,46,49,48,53,56,51,52,44,45,48,46,
48,49,48,54,32,45,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,45,48,46,49,54,57,51,51,51,44,45,48,46,48,52,50,51,32,45,48,46,48,55,52,48,56,44,45,48,46,48,50,49,50,32,45,48,46,49,49,54,52,49,55,44,
45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,45,48,46,48,54,51,53,32,45,48,46,48,54,51,53,44,45,48,46,49,53,56,55,53,32,48,44,45,48,46,48,56,52,55,32,48,44,45,48,46,49,57,48,53,32,48,44,45,48,46,
48,55,52,49,32,48,44,45,48,46,49,52,56,49,55,32,48,46,48,49,48,53,56,44,45,48,46,48,54,51,53,32,48,46,48,52,50,51,51,44,45,48,46,49,48,53,56,51,32,48,46,48,55,52,48,56,44,45,48,46,49,49,54,52,50,32,48,
46,50,53,52,44,45,48,46,48,54,51,53,32,48,46,49,49,54,52,49,54,44,48,46,48,50,49,50,32,48,46,50,53,52,44,48,46,48,50,49,50,32,48,46,49,51,55,53,56,51,44,48,32,48,46,50,52,51,52,49,54,44,45,48,46,48,52,
50,51,32,48,46,49,53,56,55,53,44,45,48,46,48,53,50,57,32,48,46,50,53,52,44,45,48,46,49,53,56,55,53,32,48,46,49,48,53,56,51,52,44,45,48,46,49,48,53,56,51,32,48,46,49,55,57,57,49,55,44,45,48,46,50,52,51,
52,49,32,48,46,48,55,52,48,56,44,45,48,46,49,50,55,32,48,46,49,50,55,44,45,48,46,50,55,53,49,55,32,48,46,48,54,51,53,44,45,48,46,49,52,56,49,55,32,48,46,49,50,55,44,45,48,46,50,57,54,51,51,32,48,46,48,
52,50,51,51,44,45,48,46,48,57,53,51,32,48,46,48,56,52,54,55,44,45,48,46,50,51,50,56,52,32,48,46,48,53,50,57,50,44,45,48,46,49,51,55,53,56,32,48,46,48,49,48,53,56,44,45,48,46,50,56,53,55,53,32,45,48,46,
48,53,50,57,50,44,45,48,46,49,54,57,51,51,32,45,48,46,49,49,54,52,49,55,44,45,48,46,51,49,55,53,32,45,48,46,48,53,50,57,50,44,45,48,46,49,52,56,49,54,32,45,48,46,49,49,54,52,49,54,44,45,48,46,50,57,54,
51,51,32,45,48,46,48,57,53,50,53,44,45,48,46,50,50,50,50,53,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,52,52,53,32,45,48,46,48,56,52,54,55,44,45,48,46,50,50,50,50,53,32,45,48,46,49,54,57,51,51,51,44,
45,48,46,52,51,51,57,50,32,45,48,46,48,54,51,53,44,45,48,46,49,52,56,49,54,32,45,48,46,49,49,54,52,49,55,44,45,48,46,50,56,53,55,53,32,45,48,46,48,53,50,57,50,44,45,48,46,49,51,55,53,56,32,45,48,46,49,
48,53,56,51,51,44,45,48,46,50,56,53,55,53,32,45,48,46,49,57,48,53,44,45,48,46,52,54,53,54,54,32,45,48,46,51,56,49,44,45,48,46,57,51,49,51,51,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,54,53,54,55,32,
45,48,46,51,55,48,52,49,55,44,45,48,46,57,51,49,51,51,32,45,48,46,49,48,53,56,51,51,44,45,48,46,50,52,51,52,50,32,45,48,46,49,57,48,53,44,45,48,46,52,54,53,54,55,32,45,48,46,48,56,52,54,55,44,45,48,46,
50,51,50,56,51,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,54,53,54,55,32,45,48,46,48,50,49,49,55,44,45,48,46,48,54,51,53,32,45,48,46,48,54,51,53,44,45,48,46,49,54,57,51,51,32,45,48,46,48,52,50,51,51,
44,45,48,46,49,49,54,52,50,32,48,46,48,49,48,53,56,44,45,48,46,49,57,48,53,32,48,46,48,51,49,55,53,44,45,48,46,48,53,50,57,32,48,46,49,50,55,44,45,48,46,48,55,52,49,32,48,46,48,50,49,49,55,44,45,48,46,
48,49,48,54,32,48,46,48,52,50,51,51,44,48,32,48,46,48,51,49,55,53,44,48,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,
32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,51,53,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,
110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,
97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,
105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,
50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,57,50,46,50,52,55,55,49,44,49,48,53,46,52,54,56,56,56,32,113,32,48,46,54,54,54,55,53,44,45,48,46,48,50,49,50,32,49,46,48,
54,56,57,49,55,44,48,46,49,55,57,57,50,32,48,46,52,48,50,49,54,54,44,48,46,50,48,49,48,56,32,48,46,54,52,53,53,56,51,44,48,46,54,48,51,50,53,32,48,46,48,54,51,53,44,48,46,49,48,53,56,51,32,48,46,48,57,
53,50,53,44,48,46,50,51,50,56,51,32,48,46,48,52,50,51,51,44,48,46,49,49,54,52,50,32,48,46,48,55,52,48,56,44,48,46,50,52,51,52,50,32,48,46,48,53,50,57,50,44,48,46,50,48,49,48,56,32,48,46,48,54,51,53,44,
48,46,52,51,51,57,49,32,48,46,48,49,48,53,56,44,48,46,50,51,50,56,52,32,48,46,48,49,48,53,56,44,48,46,52,55,54,50,53,32,118,32,49,46,49,51,50,52,50,32,49,46,54,53,49,32,113,32,48,44,48,46,49,55,57,57,
50,32,45,48,46,48,49,48,53,56,44,48,46,51,53,57,56,51,32,48,44,48,46,49,55,57,57,50,32,45,48,46,49,51,55,53,56,51,44,48,46,50,51,50,56,52,32,45,48,46,48,53,50,57,50,44,48,46,48,50,49,50,32,45,48,46,49,
49,54,52,49,55,44,48,46,48,50,49,50,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,54,44,48,46,48,49,48,54,32,45,48,46,49,51,55,53,56,52,44,48,32,45,48,46,50,54,52,53,56,52,
44,45,48,46,48,49,48,54,32,45,48,46,49,50,55,44,48,32,45,48,46,49,55,57,57,49,54,44,45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,50,44,45,48,46,48,55,52,49,32,45,48,46,48,53,50,57,50,44,45,48,46,49,57,
48,53,32,48,44,45,48,46,49,49,54,52,50,32,48,44,45,48,46,50,51,50,56,52,32,118,32,45,48,46,57,49,48,49,54,32,45,49,46,55,50,53,48,57,32,113,32,48,44,45,48,46,50,56,53,55,53,32,45,48,46,48,49,48,53,56,
44,45,48,46,53,54,48,57,49,32,45,48,46,48,49,48,53,56,44,45,48,46,50,56,53,55,53,32,45,48,46,48,57,53,50,53,44,45,48,46,52,56,54,56,52,32,45,48,46,48,56,52,54,55,44,45,48,46,50,49,49,54,54,32,45,48,46,
50,53,52,44,45,48,46,51,51,56,54,54,32,45,48,46,49,54,57,51,51,52,44,45,48,46,49,51,55,53,57,32,45,48,46,51,57,49,53,56,52,44,45,48,46,50,49,49,54,55,32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,
45,48,46,49,51,55,53,56,51,44,45,48,46,48,50,49,50,32,45,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,45,48,46,49,50,55,44,45,48,46,48,51,49,56,32,45,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,45,
48,46,49,54,57,51,51,51,44,48,32,45,48,46,49,48,53,56,51,52,44,48,32,45,48,46,49,52,56,49,54,55,44,48,46,48,49,48,54,32,45,48,46,48,52,50,51,51,44,48,46,48,50,49,50,32,45,48,46,48,55,52,48,56,44,48,46,
48,50,49,50,32,45,48,46,48,51,49,55,53,44,45,48,46,48,49,48,54,32,45,48,46,48,55,52,48,56,44,48,32,45,48,46,49,51,55,53,56,51,44,48,46,48,51,49,55,32,45,48,46,50,54,52,53,56,51,44,48,46,48,55,52,49,32,
45,48,46,49,49,54,52,49,55,44,48,46,48,51,49,56,32,45,48,46,50,50,50,50,53,44,48,46,48,57,53,50,32,45,48,46,48,52,50,51,51,44,48,46,48,50,49,50,32,45,48,46,48,55,52,48,56,44,48,46,48,52,50,51,32,45,48,
46,48,51,49,55,53,44,48,46,48,50,49,50,32,45,48,46,48,55,52,48,56,44,48,46,48,52,50,51,32,45,48,46,51,55,48,52,49,54,44,48,46,50,54,52,53,57,32,45,48,46,53,51,57,55,53,44,48,46,55,57,51,55,53,32,45,48,
46,48,51,49,55,53,44,48,46,48,56,52,55,32,45,48,46,48,52,50,51,51,44,48,46,49,55,57,57,50,32,45,48,46,48,49,48,53,56,44,48,46,48,56,52,55,32,45,48,46,48,51,49,55,53,44,48,46,49,54,57,51,51,32,45,48,46,
48,50,49,49,55,44,48,46,48,53,50,57,32,45,48,46,48,49,48,53,56,44,48,46,49,48,53,56,52,32,48,46,48,49,48,53,56,44,48,46,48,52,50,51,32,45,48,46,48,49,48,53,56,44,48,46,48,56,52,55,32,118,32,48,46,50,50,
50,50,53,32,113,32,45,48,46,48,49,48,53,56,44,48,46,48,51,49,56,32,45,48,46,48,49,48,53,56,44,48,46,48,55,52,49,32,48,46,48,49,48,53,56,44,48,46,48,52,50,51,32,48,46,48,49,48,53,56,44,48,46,48,57,53,51,
32,118,32,48,46,51,49,55,53,32,49,46,48,49,54,32,48,46,57,51,49,51,51,32,113,32,48,44,48,46,49,49,54,52,50,32,48,44,48,46,50,52,51,52,50,32,48,44,48,46,49,49,54,52,49,32,45,48,46,48,53,50,57,50,44,48,
46,49,57,48,53,32,45,48,46,48,53,50,57,50,44,48,46,48,56,52,55,32,45,48,46,49,57,48,53,44,48,46,48,56,52,55,32,45,48,46,49,50,55,44,48,46,48,49,48,54,32,45,48,46,50,54,52,53,56,52,44,48,46,48,49,48,54,
32,45,48,46,48,56,52,54,55,44,48,32,45,48,46,49,53,56,55,53,44,45,48,46,48,49,48,54,32,45,48,46,48,55,52,48,56,44,45,48,46,48,49,48,54,32,45,48,46,49,50,55,44,45,48,46,48,53,50,57,32,45,48,46,48,56,52,
54,55,44,45,48,46,48,53,50,57,32,45,48,46,48,56,52,54,55,44,45,48,46,50,48,49,48,57,32,48,44,45,48,46,49,52,56,49,54,32,48,44,45,48,46,50,56,53,55,53,32,118,32,45,49,46,50,52,56,56,51,32,45,50,46,53,54,
49,49,55,32,45,48,46,54,52,53,53,56,32,113,32,48,44,45,48,46,48,57,53,50,32,48,44,45,48,46,49,57,48,53,32,48,44,45,48,46,48,57,53,50,32,48,46,48,52,50,51,51,44,45,48,46,49,52,56,49,55,32,48,46,48,51,49,
55,53,44,45,48,46,48,54,51,53,32,48,46,49,48,53,56,51,51,44,45,48,46,48,56,52,55,32,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,48,46,49,49,54,52,49,55,44,45,48,46,48,50,49,50,32,48,46,48,56,52,54,
55,44,45,48,46,48,49,48,54,32,48,46,49,54,57,51,51,51,44,45,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,32,48,46,49,53,56,55,53,44,48,46,48,49,48,54,32,48,46,48,56,52,54,55,44,48,46,48,49,48,54,32,
48,46,49,49,54,52,49,55,44,48,46,48,51,49,56,32,48,46,49,49,54,52,49,55,44,48,46,48,55,52,49,32,48,46,49,48,53,56,51,51,44,48,46,49,57,48,53,32,45,48,46,48,49,48,53,56,44,48,46,49,48,53,56,51,32,48,46,
48,51,49,55,53,44,48,46,50,52,51,52,50,32,48,46,48,50,49,49,55,44,48,46,48,54,51,53,32,48,46,48,56,52,54,55,44,48,46,49,48,53,56,51,32,48,46,49,50,55,44,48,46,48,49,48,54,32,48,46,50,48,49,48,56,51,44,
45,48,46,48,57,53,50,32,48,46,48,56,52,54,55,44,45,48,46,49,48,53,56,51,32,48,46,49,54,57,51,51,52,44,45,48,46,49,54,57,51,51,32,48,46,49,52,56,49,54,54,44,45,48,46,49,48,53,56,52,32,48,46,50,57,54,51,
51,51,44,45,48,46,49,57,48,53,32,48,46,49,53,56,55,53,44,45,48,46,48,57,53,50,32,48,46,51,53,57,56,51,51,44,45,48,46,49,53,56,55,53,32,48,46,48,56,52,54,55,44,45,48,46,48,51,49,56,32,48,46,49,55,57,57,
49,55,44,45,48,46,48,52,50,51,32,48,46,49,48,53,56,51,51,44,45,48,46,48,49,48,54,32,48,46,50,48,49,48,56,51,44,45,48,46,48,51,49,56,32,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,48,46,49,48,53,56,
51,52,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,32,48,46,49,48,53,56,51,51,44,48,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,
61,34,112,97,116,104,51,56,51,55,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,
97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,
45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,
58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,
10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,48,48,46,51,57,51,48,55,44,49,49,48,46,54,51,51,53,53,32,113,32,48,46,48,51,49,56,44,48,46,49,54,57,51,51,32,45,48,46,48,51,49,55,44,48,46,50,56,
53,55,53,32,45,48,46,48,54,51,53,44,48,46,49,48,53,56,51,32,45,48,46,49,54,57,51,51,44,48,46,49,53,56,55,53,32,45,48,46,48,53,50,57,44,48,46,48,50,49,50,32,45,48,46,49,49,54,52,50,44,48,46,48,50,49,50,
32,45,48,46,48,53,50,57,44,48,32,45,48,46,49,49,54,52,49,51,44,48,46,48,50,49,50,32,45,48,46,50,51,50,56,51,52,44,48,46,48,53,50,57,32,45,48,46,52,54,53,54,54,55,44,45,48,46,48,51,49,56,32,45,48,46,50,
50,50,50,53,44,45,48,46,48,55,52,49,32,45,48,46,51,48,54,57,49,55,44,45,48,46,49,57,48,53,32,45,48,46,48,53,50,57,50,44,45,48,46,48,55,52,49,32,45,48,46,48,57,53,50,53,44,45,48,46,49,54,57,51,51,32,45,
48,46,48,52,50,51,51,44,45,48,46,49,48,53,56,52,32,45,48,46,49,48,53,56,51,51,44,45,48,46,49,54,57,51,52,32,45,48,46,48,50,49,49,55,44,45,48,46,48,50,49,50,32,45,48,46,48,53,50,57,50,44,45,48,46,48,52,
50,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,50,49,50,32,45,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,54,44,48,46,48,51,49,56,32,45,48,46,50,50,50,50,53,44,48,46,49,49,54,
52,49,32,45,48,46,48,57,53,50,53,44,48,46,48,56,52,55,32,45,48,46,49,57,48,53,44,48,46,49,52,56,49,55,32,45,48,46,49,51,55,53,56,51,44,48,46,48,56,52,55,32,45,48,46,50,57,54,51,51,51,44,48,46,49,53,56,
55,53,32,45,48,46,49,53,56,55,53,44,48,46,48,54,51,53,32,45,48,46,51,51,56,54,54,55,44,48,46,49,49,54,52,50,32,45,48,46,49,48,53,56,51,51,44,48,46,48,51,49,56,32,45,48,46,50,51,50,56,51,51,44,48,46,48,
52,50,51,32,45,48,46,49,49,54,52,49,55,44,48,46,48,49,48,54,32,45,48,46,50,51,50,56,51,51,44,48,46,48,51,49,56,32,45,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,45,48,46,48,57,53,50,53,44,48,46,48,49,
48,54,32,45,48,46,48,51,49,55,53,44,48,32,45,48,46,48,55,52,48,56,44,48,32,45,48,46,49,49,54,52,49,54,44,48,46,48,50,49,50,32,45,48,46,50,50,50,50,53,44,48,32,104,32,45,48,46,48,57,53,50,53,32,113,32,
45,48,46,48,53,50,57,50,44,45,48,46,48,49,48,54,32,45,48,46,49,48,53,56,51,51,44,45,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,32,45,48,46,48,57,53,50,53,44,45,48,46,48,50,49,50,32,45,48,46,48,
52,50,51,51,44,45,48,46,48,49,48,54,32,45,48,46,48,55,52,48,56,44,45,48,46,48,49,48,54,32,45,48,46,48,50,49,49,55,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,50,44,48,32,45,48,46,48,56,52,54,55,44,45,
48,46,48,50,49,50,32,45,48,46,49,54,57,51,51,51,44,45,48,46,48,52,50,51,32,45,48,46,48,56,52,54,55,44,45,48,46,48,49,48,54,32,45,48,46,49,53,56,55,53,44,45,48,46,48,52,50,51,32,45,48,46,51,49,55,53,44,
45,48,46,49,51,55,53,56,32,45,48,46,53,49,56,53,56,52,44,45,48,46,51,48,54,57,49,32,45,48,46,49,57,48,53,44,45,48,46,49,55,57,57,50,32,45,48,46,51,49,55,53,44,45,48,46,52,57,55,52,50,32,45,48,46,48,57,
53,50,53,44,45,48,46,50,51,50,56,51,32,45,48,46,48,57,53,50,53,44,45,48,46,53,54,48,57,50,32,118,32,45,48,46,50,50,50,50,53,32,113,32,48,46,48,49,48,53,56,44,45,48,46,48,53,50,57,32,48,46,48,49,48,53,
56,44,45,48,46,49,48,53,56,51,32,48,46,48,49,48,53,56,44,45,48,46,48,54,51,53,32,48,46,48,50,49,49,55,44,45,48,46,49,50,55,32,48,46,48,52,50,51,51,44,45,48,46,49,49,54,52,50,32,48,46,48,56,52,54,55,44,
45,48,46,50,51,50,56,51,32,48,46,48,52,50,51,51,44,45,48,46,49,49,54,52,50,32,48,46,49,48,53,56,51,51,44,45,48,46,50,49,49,54,55,32,48,46,49,57,48,53,44,45,48,46,51,48,54,57,50,32,48,46,53,49,56,53,56,
52,44,45,48,46,52,53,53,48,56,32,48,46,51,50,56,48,56,51,44,45,48,46,49,52,56,49,55,32,48,46,55,49,57,54,54,54,44,45,48,46,50,54,52,53,57,32,48,46,49,52,56,49,54,55,44,45,48,46,48,52,50,51,32,48,46,51,
48,54,57,49,55,44,45,48,46,48,54,51,53,32,48,46,49,53,56,55,53,44,45,48,46,48,50,49,50,32,48,46,51,49,55,53,44,45,48,46,48,53,50,57,32,48,46,48,55,52,48,56,44,45,48,46,48,50,49,50,32,48,46,49,51,55,53,
56,51,44,45,48,46,48,50,49,50,32,48,46,48,55,52,48,56,44,48,32,48,46,49,53,56,55,53,44,45,48,46,48,50,49,50,32,48,46,48,55,52,48,56,44,45,48,46,48,50,49,50,32,48,46,49,52,56,49,54,55,44,45,48,46,48,50,
49,50,32,48,46,48,55,52,48,56,44,45,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,45,48,46,48,51,49,56,32,48,46,50,54,52,53,56,51,44,45,48,46,48,54,51,53,32,48,46,52,57,55,52,49,55,44,45,48,46,49,48,53,
56,52,32,48,46,50,51,50,56,51,51,44,45,48,46,48,53,50,57,32,48,46,51,55,48,52,49,54,44,45,48,46,50,52,51,52,49,32,48,46,48,54,51,53,44,45,48,46,48,56,52,55,32,48,46,49,48,53,56,51,52,44,45,48,46,50,49,
49,54,55,32,48,46,48,52,50,51,51,44,45,48,46,49,51,55,53,56,32,48,44,45,48,46,50,57,54,51,51,32,45,48,46,48,54,51,53,44,45,48,46,50,53,52,32,45,48,46,49,57,48,53,44,45,48,46,52,48,50,49,55,32,45,48,46,
49,49,54,52,49,55,44,45,48,46,49,52,56,49,55,32,45,48,46,51,51,56,54,54,55,44,45,48,46,50,51,50,56,51,32,45,48,46,49,50,55,44,45,48,46,48,53,50,57,32,45,48,46,51,48,54,57,49,55,44,45,48,46,48,55,52,49,
32,45,48,46,49,54,57,51,51,51,44,45,48,46,48,50,49,50,32,45,48,46,51,53,57,56,51,51,44,45,48,46,48,50,49,50,32,45,48,46,49,57,48,53,44,48,32,45,48,46,51,55,48,52,49,55,44,48,46,48,50,49,50,32,45,48,46,
49,55,57,57,49,54,44,48,46,48,50,49,50,32,45,48,46,51,48,54,57,49,54,44,48,46,48,54,51,53,32,45,48,46,49,55,57,57,49,55,44,48,46,48,54,51,53,32,45,48,46,51,52,57,50,53,44,48,46,49,55,57,57,50,32,45,48,
46,48,56,52,54,55,44,48,46,48,54,51,53,32,45,48,46,49,53,56,55,53,44,48,46,49,54,57,51,51,32,45,48,46,48,54,51,53,44,48,46,48,57,53,50,32,45,48,46,49,49,54,52,49,55,44,48,46,50,49,49,54,55,32,45,48,46,
48,51,49,55,53,44,48,46,48,56,52,55,32,45,48,46,48,54,51,53,44,48,46,49,55,57,57,50,32,45,48,46,48,50,49,49,55,44,48,46,48,57,53,51,32,45,48,46,48,57,53,50,53,44,48,46,49,52,56,49,54,32,45,48,46,48,52,
50,51,51,44,48,46,48,51,49,56,32,45,48,46,49,52,56,49,54,55,44,48,46,48,53,50,57,32,45,48,46,48,57,53,50,53,44,48,46,48,49,48,54,32,45,48,46,50,48,49,48,56,51,44,48,46,48,49,48,54,32,45,48,46,49,48,53,
56,51,51,44,48,32,45,48,46,50,49,49,54,54,55,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,50,53,44,45,48,46,48,50,49,50,32,45,48,46,49,51,55,53,56,51,44,45,48,46,48,53,50,57,32,45,48,46,48,52,50,51,51,
44,45,48,46,48,51,49,56,32,45,48,46,48,54,51,53,44,45,48,46,49,48,53,56,51,32,45,48,46,48,50,49,49,55,44,45,48,46,48,55,52,49,32,48,44,45,48,46,49,53,56,55,53,32,48,46,48,51,49,55,53,44,45,48,46,49,51,
55,53,56,32,48,46,48,54,51,53,44,45,48,46,50,53,52,32,48,46,48,52,50,51,51,44,45,48,46,49,50,55,32,48,46,48,57,53,50,53,44,45,48,46,50,52,51,52,50,32,48,46,50,48,49,48,56,51,44,45,48,46,51,55,48,52,49,
32,48,46,53,48,56,44,45,48,46,53,55,49,53,32,48,46,51,48,54,57,49,55,44,45,48,46,50,49,49,54,54,32,48,46,55,54,50,44,45,48,46,51,51,56,54,54,32,48,46,49,48,53,56,51,51,44,45,48,46,48,50,49,50,32,48,46,
50,49,49,54,54,55,44,45,48,46,48,51,49,56,32,48,46,49,49,54,52,49,54,44,45,48,46,48,49,48,54,32,48,46,50,51,50,56,51,51,44,45,48,46,48,51,49,56,32,48,46,48,52,50,51,51,44,45,48,46,48,49,48,54,32,48,46,
49,51,55,53,56,51,44,48,32,48,46,48,57,53,50,53,44,48,32,48,46,49,49,54,52,49,55,44,45,48,46,48,50,49,50,32,48,46,55,52,48,56,51,51,44,45,48,46,48,49,48,54,32,49,46,50,57,49,49,54,55,44,48,46,49,54,57,
51,51,32,48,46,53,53,48,51,51,51,44,48,46,49,55,57,57,50,32,48,46,55,55,50,53,56,51,44,48,46,54,56,55,57,50,32,48,46,48,57,53,50,53,44,48,46,50,49,49,54,55,32,48,46,49,48,53,56,51,51,44,48,46,52,57,55,
52,50,32,48,46,48,50,49,49,55,44,48,46,50,55,53,49,54,32,48,46,48,50,49,49,55,44,48,46,53,56,50,48,56,32,118,32,50,46,51,51,56,57,50,32,113,32,48,44,48,46,49,52,56,49,54,32,48,46,48,49,48,53,56,44,48,
46,50,56,53,55,53,32,48,46,48,49,48,53,56,44,48,46,49,51,55,53,56,32,48,46,48,54,51,53,44,48,46,50,50,50,50,53,32,48,46,48,53,50,57,50,44,48,46,48,55,52,49,32,48,46,49,51,55,53,56,55,44,48,46,49,48,53,
56,51,32,48,46,48,57,53,50,44,48,46,48,52,50,51,32,48,46,49,55,57,57,49,44,48,46,48,54,51,53,32,48,46,48,56,52,55,44,48,46,48,49,48,54,32,48,46,49,50,55,44,48,46,48,57,53,51,32,48,46,48,50,49,50,44,48,
46,48,51,49,55,32,48,46,48,50,49,50,44,48,46,48,54,51,53,32,48,44,48,46,48,51,49,56,32,48,46,48,49,48,54,44,48,46,48,56,52,55,32,122,32,109,32,45,49,46,53,49,51,52,49,51,44,45,49,46,49,55,52,55,53,32,
113,32,48,46,48,54,51,53,44,45,48,46,49,52,56,49,55,32,48,46,48,54,51,53,44,45,48,46,51,51,56,54,55,32,48,46,48,49,48,53,56,44,45,48,46,50,48,49,48,56,32,48,46,48,49,48,53,56,44,45,48,46,52,49,50,55,53,
32,48,44,45,48,46,49,49,54,52,50,32,45,48,46,48,49,48,53,56,44,45,48,46,50,49,49,54,55,32,45,48,46,48,49,48,53,56,44,45,48,46,48,57,53,51,32,45,48,46,48,56,52,54,55,44,45,48,46,49,52,56,49,54,32,45,48,
46,48,51,49,55,53,44,45,48,46,48,50,49,50,32,45,48,46,49,52,56,49,54,55,44,45,48,46,48,50,49,50,32,45,48,46,48,50,49,49,55,44,48,46,48,50,49,50,32,45,48,46,48,55,52,48,56,44,48,46,48,50,49,50,32,45,48,
46,48,53,50,57,50,44,48,32,45,48,46,48,57,53,50,53,44,48,46,48,50,49,50,32,45,48,46,48,56,52,54,55,44,48,46,48,50,49,50,32,45,48,46,49,57,48,53,44,48,46,48,52,50,51,32,45,48,46,49,48,53,56,51,51,44,48,
46,48,50,49,50,32,45,48,46,50,49,49,54,54,55,44,48,46,48,52,50,51,32,45,48,46,48,51,49,55,53,44,48,32,45,48,46,48,55,52,48,56,44,48,46,48,49,48,54,32,45,48,46,48,51,49,55,53,44,48,32,45,48,46,48,55,52,
48,56,44,48,32,45,48,46,49,53,56,55,53,44,48,46,48,52,50,51,32,45,48,46,51,52,57,50,53,44,48,46,48,53,50,57,32,45,48,46,49,55,57,57,49,55,44,48,32,45,48,46,51,51,56,54,54,55,44,48,46,48,52,50,51,32,45,
48,46,48,56,52,54,55,44,48,46,48,50,49,50,32,45,48,46,49,53,56,55,53,44,48,46,48,52,50,51,32,45,48,46,48,54,51,53,44,48,46,48,49,48,54,32,45,48,46,49,52,56,49,54,55,44,48,46,48,51,49,56,32,45,48,46,49,
54,57,51,51,51,44,48,46,48,53,50,57,32,45,48,46,51,49,55,53,44,48,46,49,51,55,53,56,32,45,48,46,49,52,56,49,54,54,44,48,46,48,55,52,49,32,45,48,46,50,53,52,44,48,46,49,57,48,53,32,45,48,46,49,48,53,56,
51,51,44,48,46,49,49,54,52,50,32,45,48,46,49,53,56,55,53,44,48,46,50,56,53,55,53,32,45,48,46,48,53,50,57,50,44,48,46,49,53,56,55,53,32,45,48,46,48,52,50,51,51,44,48,46,51,57,49,53,56,32,48,44,48,46,49,
48,53,56,52,32,48,46,48,51,49,55,53,44,48,46,50,48,49,48,57,32,48,46,48,52,50,51,51,44,48,46,48,56,52,55,32,48,46,48,57,53,50,53,44,48,46,49,53,56,55,53,32,48,46,48,56,52,54,55,44,48,46,49,49,54,52,49,
32,48,46,50,50,50,50,53,44,48,46,50,48,49,48,56,32,48,46,49,51,55,53,56,51,44,48,46,48,55,52,49,32,48,46,50,57,54,51,51,51,44,48,46,49,50,55,32,48,46,48,53,50,57,50,44,48,46,48,49,48,54,32,48,46,49,48,
53,56,51,52,44,48,46,48,49,48,54,32,48,46,48,53,50,57,50,44,48,32,48,46,49,48,53,56,51,51,44,48,46,48,49,48,54,32,48,46,48,55,52,48,56,44,48,46,48,50,49,50,32,48,46,49,55,57,57,49,55,44,48,46,48,51,49,
55,32,48,46,49,49,54,52,49,54,44,48,32,48,46,49,57,48,53,44,45,48,46,48,50,49,50,32,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,48,46,49,50,55,44,45,48,46,48,49,48,54,32,48,46,48,54,51,53,44,48,32,48,
46,49,50,55,44,45,48,46,48,50,49,50,32,48,46,48,56,52,54,55,44,45,48,46,48,50,49,50,32,48,46,49,53,56,55,53,44,45,48,46,48,51,49,55,32,48,46,48,56,52,54,55,44,45,48,46,48,49,48,54,32,48,46,49,53,56,55,
53,44,45,48,46,48,52,50,51,32,48,46,51,48,54,57,49,54,44,45,48,46,49,50,55,32,48,46,53,49,56,53,56,51,44,45,48,46,51,48,54,57,50,32,48,46,50,50,50,50,53,44,45,48,46,49,55,57,57,50,32,48,46,51,51,56,54,
54,55,44,45,48,46,52,56,54,56,51,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,51,57,34,10,32,32,32,32,32,32,32,
32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,
101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,
32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,
107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,48,51,
46,56,50,51,50,51,44,49,48,53,46,52,52,55,55,49,32,113,32,48,46,52,48,50,49,55,44,45,48,46,48,49,48,54,32,48,46,54,55,55,51,52,44,48,46,48,56,52,55,32,48,46,50,56,53,55,53,44,48,46,48,57,53,50,32,48,46,
53,49,56,53,56,44,48,46,50,55,53,49,55,32,48,46,48,56,52,55,44,48,46,48,53,50,57,32,48,46,49,51,55,53,56,44,48,46,49,52,56,49,54,32,48,46,48,54,51,53,44,48,46,48,56,52,55,32,48,46,49,51,55,53,57,44,48,
46,49,53,56,55,53,32,48,46,48,50,49,50,44,48,46,48,50,49,50,32,48,46,48,54,51,53,44,48,46,48,53,50,57,32,48,46,48,52,50,51,44,48,46,48,51,49,56,32,48,46,49,48,53,56,51,44,48,46,48,50,49,50,32,48,46,49,
48,53,56,51,44,45,48,46,48,51,49,56,32,48,46,49,55,57,57,50,44,45,48,46,49,50,55,32,48,46,48,56,52,55,44,45,48,46,49,48,53,56,52,32,48,46,49,54,57,51,51,44,45,48,46,49,53,56,55,53,32,48,46,49,52,56,49,
55,44,45,48,46,49,49,54,52,50,32,48,46,51,48,54,57,50,44,45,48,46,50,48,49,48,57,32,48,46,49,53,56,55,53,44,45,48,46,48,57,53,51,32,48,46,51,52,57,50,53,44,45,48,46,49,53,56,55,53,32,48,46,48,56,52,55,
44,45,48,46,48,51,49,55,32,48,46,49,55,57,57,49,44,45,48,46,48,52,50,51,32,48,46,49,48,53,56,52,44,45,48,46,48,50,49,50,32,48,46,50,48,49,48,57,44,45,48,46,48,52,50,51,32,48,46,48,53,50,57,44,45,48,46,
48,49,48,54,32,48,46,48,57,53,50,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,44,48,32,48,46,49,48,53,56,51,44,48,32,48,46,48,53,50,57,44,45,48,46,48,50,49,50,32,48,46,49,52,56,49,55,44,45,48,46,48,49,
48,54,32,48,46,48,57,53,50,44,48,32,48,46,49,51,55,53,56,44,48,46,48,49,48,54,32,48,46,48,53,50,57,44,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,48,46,48,49,48,54,32,48,46,48,57,53,51,44,48,46,48,50,
49,50,32,48,46,49,55,57,57,50,44,48,46,48,52,50,51,32,48,46,48,57,53,51,44,48,46,48,49,48,54,32,48,46,49,55,57,57,49,44,48,46,48,52,50,51,32,48,46,48,53,50,57,44,48,46,48,50,49,50,32,48,46,48,57,53,50,
44,48,46,48,51,49,56,32,48,46,48,53,50,57,44,48,32,48,46,49,48,53,56,52,44,48,46,48,50,49,50,32,48,46,53,50,57,49,54,44,48,46,50,51,50,56,51,32,48,46,55,51,48,50,53,44,48,46,55,49,57,54,55,32,48,46,48,
52,50,51,44,48,46,48,56,52,55,32,48,46,48,54,51,53,44,48,46,49,57,48,53,32,48,46,48,50,49,50,44,48,46,48,57,53,50,32,48,46,48,52,50,51,44,48,46,50,49,49,54,54,32,48,46,48,50,49,50,44,48,46,48,51,49,56,
32,48,46,48,49,48,54,44,48,46,48,55,52,49,32,48,44,48,46,48,51,49,56,32,48,46,48,49,48,54,44,48,46,48,54,51,53,32,118,32,48,46,48,57,53,51,32,113,32,48,46,48,49,48,54,44,48,46,48,52,50,51,32,48,44,48,
46,48,57,53,50,32,48,44,48,46,48,53,50,57,32,48,44,48,46,49,48,53,56,51,32,118,32,48,46,52,49,50,55,53,32,48,46,54,55,55,51,51,32,50,46,48,49,48,56,52,32,113,32,48,44,48,46,49,54,57,51,51,32,48,44,48,
46,52,48,50,49,54,32,48,46,48,49,48,54,44,48,46,50,51,50,56,52,32,45,48,46,48,56,52,55,44,48,46,51,48,54,57,50,32,45,48,46,48,52,50,51,44,48,46,48,51,49,56,32,45,48,46,49,51,55,53,56,44,48,46,48,53,50,
57,32,45,48,46,48,57,53,50,44,48,46,48,49,48,54,32,45,48,46,50,48,49,48,57,44,48,46,48,49,48,54,32,45,48,46,49,48,53,56,51,44,48,32,45,48,46,50,49,49,54,54,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,
50,44,45,48,46,48,49,48,54,32,45,48,46,49,51,55,53,57,44,45,48,46,48,52,50,51,32,45,48,46,48,54,51,53,44,45,48,46,48,51,49,56,32,45,48,46,48,56,52,55,44,45,48,46,49,50,55,32,45,48,46,48,50,49,50,44,45,
48,46,48,54,51,53,32,45,48,46,48,49,48,54,44,45,48,46,49,50,55,32,48,46,48,49,48,54,44,45,48,46,48,55,52,49,32,45,48,46,48,49,48,54,44,45,48,46,49,51,55,53,56,32,45,48,46,48,49,48,54,44,45,48,46,48,53,
50,57,32,45,48,46,48,49,48,54,44,45,48,46,49,49,54,52,50,32,48,46,48,49,48,54,44,45,48,46,48,55,52,49,32,48,46,48,49,48,54,44,45,48,46,49,51,55,53,56,32,118,32,45,48,46,52,55,54,50,53,32,45,50,46,48,50,
49,52,50,32,113,32,48,44,45,48,46,51,52,57,50,53,32,45,48,46,48,50,49,50,44,45,48,46,54,53,54,49,54,32,45,48,46,48,49,48,54,44,45,48,46,51,49,55,53,32,45,48,46,49,52,56,49,54,44,45,48,46,53,50,57,49,55,
32,45,48,46,49,53,56,55,53,44,45,48,46,50,53,52,32,45,48,46,52,56,54,56,52,44,45,48,46,51,55,48,52,50,32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,45,48,46,49,51,55,53,56,44,45,48,46,48,50,49,50,
32,45,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,45,48,46,49,51,55,53,56,44,45,48,46,48,51,49,56,32,45,48,46,48,52,50,51,44,45,48,46,48,49,48,54,32,45,48,46,49,51,55,53,57,44,48,32,45,48,46,48,57,53,
51,44,48,32,45,48,46,49,50,55,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,44,48,46,48,49,48,54,32,45,48,46,49,48,53,56,51,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,44,45,48,46,48,49,48,54,32,45,48,
46,49,48,53,56,51,44,48,46,48,49,48,54,32,45,48,46,49,52,56,49,55,44,48,46,48,51,49,56,32,45,48,46,50,56,53,55,53,44,48,46,48,56,52,55,32,45,48,46,53,53,48,51,52,44,48,46,50,51,50,56,52,32,45,48,46,55,
52,48,56,52,44,48,46,56,49,52,57,50,32,45,48,46,48,53,50,57,44,48,46,49,55,57,57,50,32,45,48,46,48,54,51,53,44,48,46,52,49,50,55,53,32,48,44,48,46,50,51,50,56,51,32,48,44,48,46,52,55,54,50,53,32,118,32,
49,46,51,56,54,52,50,32,49,46,48,50,54,53,56,32,113,32,48,44,48,46,49,50,55,32,48,44,48,46,50,54,52,53,56,32,48,44,48,46,49,50,55,32,45,48,46,48,53,50,57,44,48,46,50,48,49,48,57,32,45,48,46,48,53,50,57,
44,48,46,48,56,52,55,32,45,48,46,49,55,57,57,50,44,48,46,48,57,53,50,32,45,48,46,49,50,55,44,48,46,48,49,48,54,32,45,48,46,50,54,52,53,56,44,48,46,48,49,48,54,32,45,48,46,49,55,57,57,50,44,48,32,45,48,
46,50,54,52,53,57,44,45,48,46,48,52,50,51,32,45,48,46,48,57,53,50,44,45,48,46,48,53,50,57,32,45,48,46,49,49,54,52,49,44,45,48,46,49,54,57,51,52,32,45,48,46,48,49,48,54,44,45,48,46,49,50,55,32,45,48,46,
48,49,48,54,44,45,48,46,50,55,53,49,54,32,118,32,45,49,46,48,48,53,52,50,32,45,49,46,55,52,54,50,53,32,113,32,48,44,45,48,46,51,51,56,54,55,32,45,48,46,48,50,49,50,44,45,48,46,54,50,52,52,50,32,45,48,
46,48,50,49,50,44,45,48,46,50,57,54,51,51,32,45,48,46,49,52,56,49,55,44,45,48,46,53,48,56,32,45,48,46,49,49,54,52,50,44,45,48,46,49,57,48,53,32,45,48,46,50,54,52,53,56,44,45,48,46,50,55,53,49,54,32,45,
48,46,49,52,56,49,55,44,45,48,46,48,57,53,51,32,45,48,46,52,48,50,49,55,44,45,48,46,49,52,56,49,55,32,45,48,46,48,52,50,51,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,51,44,45,48,46,48,49,48,54,32,45,
48,46,48,52,50,51,44,48,32,45,48,46,48,57,53,50,44,48,32,45,48,46,50,51,50,56,51,44,48,32,45,48,46,52,49,50,55,53,44,48,46,48,53,50,57,32,45,48,46,49,54,57,51,51,44,48,46,48,53,50,57,32,45,48,46,51,48,
54,57,50,44,48,46,49,51,55,53,57,32,45,48,46,53,51,57,55,53,44,48,46,51,50,56,48,56,32,45,48,46,55,49,57,54,54,44,48,46,57,56,52,50,53,32,45,48,46,48,52,50,51,44,48,46,49,51,55,53,56,32,45,48,46,48,52,
50,51,44,48,46,51,49,55,53,32,48,46,48,49,48,54,44,48,46,49,54,57,51,51,32,48,46,48,49,48,54,44,48,46,51,51,56,54,54,32,118,32,49,46,49,57,53,57,50,32,49,46,49,54,52,49,55,32,113,32,48,44,48,46,49,51,
55,53,56,32,48,44,48,46,50,56,53,55,53,32,48,44,48,46,49,52,56,49,54,32,45,48,46,48,54,51,53,44,48,46,50,51,50,56,51,32,45,48,46,48,53,50,57,44,48,46,48,55,52,49,32,45,48,46,49,53,56,55,53,44,48,46,48,
56,52,55,32,45,48,46,49,48,53,56,52,44,48,46,48,49,48,54,32,45,48,46,50,50,50,50,53,44,48,46,48,49,48,54,32,104,32,45,48,46,49,53,56,55,53,32,113,32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,45,
48,46,49,50,55,44,45,48,46,48,51,49,56,32,45,48,46,48,53,50,57,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,51,44,45,48,46,48,54,51,53,32,45,48,46,48,53,50,57,44,45,48,46,48,54,51,53,32,45,48,46,48,53,
50,57,44,45,48,46,49,53,56,55,53,32,48,44,45,48,46,49,48,53,56,51,32,48,44,45,48,46,50,50,50,50,53,32,118,32,45,48,46,54,56,55,57,50,32,45,51,46,48,50,54,56,51,32,45,48,46,55,56,51,49,55,32,113,32,48,
44,45,48,46,49,48,53,56,51,32,48,44,45,48,46,50,48,49,48,56,32,48,44,45,48,46,49,48,53,56,51,32,48,46,48,52,50,51,44,45,48,46,49,54,57,51,51,32,48,46,48,51,49,55,44,45,48,46,48,54,51,53,32,48,46,48,57,
53,50,44,45,48,46,48,56,52,55,32,48,46,48,56,52,55,44,45,48,46,48,51,49,55,32,48,46,50,54,52,53,57,44,45,48,46,48,51,49,55,32,48,46,49,57,48,53,44,48,32,48,46,50,55,53,49,54,44,48,46,48,51,49,55,32,48,
46,48,56,52,55,44,48,46,48,52,50,51,32,48,46,49,49,54,52,50,44,48,46,49,48,53,56,51,32,48,46,48,50,49,50,44,48,46,48,53,50,57,32,48,46,48,50,49,50,44,48,46,49,50,55,32,48,46,48,49,48,54,44,48,46,48,55,
52,49,32,48,46,48,50,49,50,44,48,46,49,51,55,53,57,32,48,46,48,49,48,54,44,48,46,48,54,51,53,32,48,46,48,52,50,51,44,48,46,49,48,53,56,51,32,48,46,48,51,49,56,44,48,46,48,52,50,51,32,48,46,49,48,53,56,
51,44,48,46,48,52,50,51,32,48,46,48,50,49,50,44,45,48,46,48,50,49,50,32,48,46,48,52,50,51,44,45,48,46,48,50,49,50,32,48,46,48,51,49,56,44,48,32,48,46,48,53,50,57,44,45,48,46,48,50,49,50,32,48,46,48,54,
51,53,44,45,48,46,48,53,50,57,32,48,46,49,49,54,52,50,44,45,48,46,49,48,53,56,51,32,48,46,48,54,51,53,44,45,48,46,48,53,50,57,32,48,46,49,50,55,44,45,48,46,49,48,53,56,52,32,48,46,50,51,50,56,51,44,45,
48,46,49,54,57,51,51,32,48,46,53,50,57,49,54,44,45,48,46,50,57,54,51,51,32,48,46,49,48,53,56,52,44,45,48,46,48,52,50,51,32,48,46,50,49,49,54,55,44,45,48,46,48,53,50,57,32,48,46,49,48,53,56,51,44,45,48,
46,48,50,49,50,32,48,46,50,50,50,50,53,44,45,48,46,48,53,50,57,32,48,46,48,54,51,53,44,48,32,48,46,49,50,55,44,48,32,48,46,48,55,52,49,44,45,48,46,48,49,48,54,32,48,46,49,51,55,53,56,44,45,48,46,48,49,
48,54,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,52,49,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,
101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,
111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,
107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,
58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,49,48,46,52,53,51,56,54,44,49,48,
52,46,53,49,54,51,56,32,113,32,45,48,46,48,56,52,55,44,45,48,46,48,54,51,53,32,45,48,46,48,57,53,51,44,45,48,46,50,50,50,50,53,32,48,44,45,48,46,49,54,57,51,51,32,48,44,45,48,46,51,50,56,48,56,32,48,44,
45,48,46,48,56,52,55,32,48,44,45,48,46,49,55,57,57,50,32,48,44,45,48,46,48,57,53,50,32,48,46,48,51,49,56,44,45,48,46,49,53,56,55,53,32,48,46,48,52,50,51,44,45,48,46,48,56,52,55,32,48,46,49,54,57,51,51,
44,45,48,46,49,50,55,32,48,46,48,50,49,50,44,45,48,46,48,49,48,54,32,48,46,48,52,50,51,44,48,32,48,46,48,51,49,56,44,48,32,48,46,48,53,50,57,44,45,48,46,48,49,48,54,32,48,46,49,55,57,57,50,44,48,32,48,
46,51,51,56,54,55,44,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,48,46,48,49,48,54,32,48,46,50,49,49,54,54,44,48,46,49,50,55,32,48,46,48,51,49,56,44,48,46,48,54,51,53,32,48,46,48,51,49,56,44,48,46,49,
53,56,55,53,32,48,44,48,46,48,56,52,55,32,48,44,48,46,49,55,57,57,50,32,48,44,48,46,49,57,48,53,32,45,48,46,48,49,48,54,44,48,46,51,53,57,56,51,32,48,44,48,46,49,54,57,51,51,32,45,48,46,49,51,55,53,56,
44,48,46,50,50,50,50,53,32,45,48,46,48,53,50,57,44,48,46,48,50,49,50,32,45,48,46,49,49,54,52,50,44,48,46,48,50,49,50,32,45,48,46,48,53,50,57,44,48,32,45,48,46,49,49,54,52,50,44,48,32,45,48,46,49,49,54,
52,49,44,48,32,45,48,46,50,50,50,50,53,44,48,32,45,48,46,49,48,53,56,51,44,48,32,45,48,46,49,55,57,57,49,44,45,48,46,48,53,50,57,32,122,32,109,32,48,46,55,56,51,49,54,44,54,46,48,48,48,55,53,32,113,32,
48,44,48,46,49,48,53,56,51,32,48,44,48,46,50,50,50,50,53,32,48,46,48,49,48,54,44,48,46,49,48,53,56,51,32,45,48,46,48,52,50,51,44,48,46,49,54,57,51,51,32,45,48,46,48,51,49,55,44,48,46,48,54,51,53,32,45,
48,46,48,57,53,50,44,48,46,48,56,52,55,32,45,48,46,48,54,51,53,44,48,46,48,49,48,54,32,45,48,46,49,52,56,49,55,44,48,46,48,51,49,56,32,104,32,45,48,46,49,53,56,55,53,32,113,32,45,48,46,49,51,55,53,56,
44,48,32,45,48,46,50,52,51,52,49,44,45,48,46,48,49,48,54,32,45,48,46,48,57,53,50,44,45,48,46,48,50,49,50,32,45,48,46,49,52,56,49,55,44,45,48,46,49,48,53,56,52,32,45,48,46,48,52,50,51,44,45,48,46,48,54,
51,53,32,45,48,46,48,52,50,51,44,45,48,46,49,53,56,55,53,32,48,44,45,48,46,49,48,53,56,51,32,48,44,45,48,46,50,48,49,48,56,32,118,32,45,52,46,52,55,54,55,53,32,113,32,48,44,45,48,46,49,49,54,52,50,32,
48,44,45,48,46,50,50,50,50,53,32,48,44,45,48,46,49,49,54,52,50,32,48,46,48,53,50,57,44,45,48,46,49,55,57,57,50,32,48,46,48,51,49,56,44,45,48,46,48,53,50,57,32,48,46,48,56,52,55,44,45,48,46,48,54,51,53,
32,48,46,48,53,50,57,44,45,48,46,48,49,48,54,32,48,46,49,49,54,52,50,44,45,48,46,48,51,49,56,32,48,46,48,50,49,50,44,48,32,48,46,48,52,50,51,44,48,46,48,49,48,54,32,48,46,48,51,49,56,44,48,32,48,46,48,
53,50,57,44,45,48,46,48,49,48,54,32,48,46,49,51,55,53,56,44,48,32,48,46,50,55,53,49,54,44,48,46,48,49,48,54,32,48,46,49,52,56,49,55,44,48,32,48,46,50,48,49,48,57,44,48,46,48,56,52,55,32,48,46,48,53,50,
57,44,48,46,48,54,51,53,32,48,46,48,53,50,57,44,48,46,49,54,57,51,52,32,48,44,48,46,48,57,53,51,32,48,44,48,46,50,48,49,48,56,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,
32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,56,52,51,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,
111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,
109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,
102,105,99,97,116,105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,
46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,49,52,46,56,50,49,49,51,44,49,48,53,46,52,52,55,55,49,32,113,32,48,46,55,56,51,49,55,44,45,48,46,48,49,48,54,32,49,
46,51,48,49,55,53,44,48,46,50,51,50,56,52,32,48,46,53,50,57,49,55,44,48,46,50,51,50,56,51,32,48,46,56,51,54,48,56,44,48,46,55,48,57,48,56,32,48,46,49,51,55,53,57,44,48,46,50,49,49,54,55,32,48,46,50,51,
50,56,52,44,48,46,53,49,56,53,56,32,48,46,48,50,49,50,44,48,46,48,53,50,57,32,48,46,48,51,49,56,44,48,46,49,51,55,53,57,32,48,46,48,49,48,54,44,48,46,48,56,52,55,32,45,48,46,48,49,48,54,44,48,46,49,52,
56,49,54,32,45,48,46,48,51,49,56,44,48,46,48,53,50,57,32,45,48,46,49,48,53,56,51,44,48,46,48,57,53,50,32,45,48,46,48,51,49,56,44,48,46,48,50,49,50,32,45,48,46,48,54,51,53,44,48,46,48,50,49,50,32,45,48,
46,48,51,49,55,44,45,48,46,48,49,48,54,32,45,48,46,48,55,52,49,44,48,32,45,48,46,48,52,50,51,44,48,46,48,49,48,54,32,45,48,46,48,56,52,55,44,48,46,48,49,48,54,32,45,48,46,48,52,50,51,44,45,48,46,48,49,
48,54,32,45,48,46,48,56,52,55,44,45,48,46,48,49,48,54,32,45,48,46,49,49,54,52,49,44,48,32,45,48,46,50,50,50,50,53,44,48,32,45,48,46,49,48,53,56,51,44,45,48,46,48,49,48,54,32,45,48,46,49,55,57,57,49,44,
45,48,46,48,54,51,53,32,45,48,46,48,56,52,55,44,45,48,46,48,54,51,53,32,45,48,46,49,49,54,52,50,44,45,48,46,49,55,57,57,50,32,45,48,46,48,51,49,56,44,45,48,46,49,49,54,52,49,32,45,48,46,48,56,52,55,44,
45,48,46,50,48,49,48,56,32,45,48,46,49,53,56,55,53,44,45,48,46,50,55,53,49,55,32,45,48,46,52,49,50,55,53,44,45,48,46,52,51,51,57,50,32,45,48,46,48,56,52,55,44,45,48,46,48,53,50,57,32,45,48,46,49,55,57,
57,49,44,45,48,46,48,56,52,55,32,45,48,46,48,57,53,50,44,45,48,46,48,52,50,51,32,45,48,46,50,48,49,48,57,44,45,48,46,48,55,52,49,32,45,48,46,49,52,56,49,54,44,45,48,46,48,52,50,51,32,45,48,46,51,57,49,
53,56,44,45,48,46,48,52,50,51,32,45,48,46,50,52,51,52,50,44,45,48,46,48,49,48,54,32,45,48,46,52,48,50,49,55,44,48,46,48,52,50,51,32,45,48,46,48,55,52,49,44,48,46,48,50,49,50,32,45,48,46,49,51,55,53,56,
44,48,46,48,51,49,55,32,45,48,46,48,54,51,53,44,48,46,48,49,48,54,32,45,48,46,49,51,55,53,56,44,48,46,48,51,49,56,32,45,48,46,50,55,53,49,55,44,48,46,49,49,54,52,50,32,45,48,46,52,56,54,56,52,44,48,46,
51,49,55,53,32,45,48,46,50,49,49,54,54,44,48,46,50,48,49,48,57,32,45,48,46,51,50,56,48,56,44,48,46,52,55,54,50,53,32,45,48,46,48,52,50,51,44,48,46,48,57,53,51,32,45,48,46,48,55,52,49,44,48,46,50,48,49,
48,57,32,45,48,46,48,51,49,56,44,48,46,48,57,53,51,32,45,48,46,48,54,51,53,44,48,46,50,49,49,54,54,32,108,32,45,48,46,48,54,51,53,44,48,46,50,56,53,55,53,32,113,32,45,48,46,48,49,48,54,44,48,46,48,53,
50,57,32,45,48,46,48,49,48,54,44,48,46,49,49,54,52,50,32,48,46,48,49,48,54,44,48,46,48,54,51,53,32,45,48,46,48,49,48,54,44,48,46,49,49,54,52,50,32,118,32,48,46,48,56,52,55,32,113,32,45,48,46,48,49,48,
54,44,48,46,48,52,50,51,32,45,48,46,48,50,49,50,44,48,46,49,51,55,53,57,32,48,44,48,46,48,57,53,51,32,48,46,48,50,49,50,44,48,46,49,51,55,53,56,32,48,46,48,49,48,54,44,48,46,48,53,50,57,32,48,44,48,46,
49,48,53,56,51,32,45,48,46,48,49,48,54,44,48,46,48,53,50,57,32,48,44,48,46,49,48,53,56,52,32,48,46,48,49,48,54,44,48,46,48,52,50,51,32,48,46,48,49,48,54,44,48,46,49,52,56,49,54,32,48,46,48,50,49,50,44,
48,46,48,56,52,55,32,48,46,48,51,49,56,44,48,46,49,55,57,57,50,32,48,46,48,50,49,50,44,48,46,48,57,53,50,32,48,46,48,52,50,51,44,48,46,49,55,57,57,50,32,48,46,49,49,54,52,49,44,48,46,51,51,56,54,54,32,
48,46,50,54,52,53,56,44,48,46,53,57,50,54,54,32,48,46,49,53,56,55,53,44,48,46,50,52,51,52,50,32,48,46,52,51,51,57,50,44,48,46,52,50,51,51,52,32,48,46,48,57,53,51,44,48,46,48,53,50,57,32,48,46,49,57,48,
53,44,48,46,48,57,53,50,32,48,46,49,48,53,56,51,44,48,46,48,52,50,51,32,48,46,50,50,50,50,53,44,48,46,48,56,52,55,32,48,46,48,53,50,57,44,48,46,48,49,48,54,32,48,46,48,56,52,55,44,48,46,48,49,48,54,32,
48,46,48,51,49,56,44,48,32,48,46,48,56,52,55,44,48,46,48,49,48,54,32,48,46,48,51,49,56,44,48,46,48,49,48,54,32,48,46,49,48,53,56,51,44,48,46,48,49,48,54,32,104,32,48,46,49,49,54,52,50,32,113,32,48,44,
48,46,48,49,48,54,32,48,46,48,52,50,51,44,48,46,48,49,48,54,32,48,46,48,50,49,50,44,45,48,46,48,49,48,54,32,48,46,48,53,50,57,44,48,32,48,46,48,51,49,56,44,48,32,48,46,48,54,51,53,44,45,48,46,48,49,48,
54,32,48,46,48,55,52,49,44,45,48,46,48,50,49,50,32,48,46,49,51,55,53,56,44,45,48,46,48,49,48,54,32,48,46,48,55,52,49,44,48,32,48,46,49,52,56,49,55,44,45,48,46,48,50,49,50,32,48,46,50,55,53,49,55,44,45,
48,46,48,56,52,55,32,48,46,52,55,54,50,53,44,45,48,46,50,49,49,54,54,32,48,46,50,48,49,48,56,44,45,48,46,49,51,55,53,57,32,48,46,51,51,56,54,55,44,45,48,46,51,52,57,50,53,32,48,46,48,53,50,57,44,45,48,
46,48,56,52,55,32,48,46,48,57,53,51,44,45,48,46,49,55,57,57,50,32,48,46,48,52,50,51,44,45,48,46,48,57,53,50,32,48,46,48,56,52,55,44,45,48,46,49,57,48,53,32,48,46,48,50,49,50,44,45,48,46,48,56,52,55,32,
48,46,48,52,50,51,44,45,48,46,49,53,56,55,53,32,48,46,48,51,49,56,44,45,48,46,48,56,52,55,32,48,46,49,48,53,56,51,44,45,48,46,49,51,55,53,56,32,48,46,48,51,49,55,44,45,48,46,48,51,49,56,32,48,46,49,50,
55,44,45,48,46,48,52,50,51,32,48,46,48,57,53,50,44,45,48,46,48,50,49,50,32,48,46,50,48,49,48,56,44,45,48,46,48,50,49,50,32,48,46,49,49,54,52,50,44,45,48,46,48,49,48,54,32,48,46,50,49,49,54,55,44,48,32,
48,46,49,48,53,56,51,44,48,46,48,49,48,54,32,48,46,49,52,56,49,55,44,48,46,48,52,50,51,32,48,46,48,54,51,53,44,48,46,48,52,50,51,32,48,46,48,55,52,49,44,48,46,49,50,55,32,48,46,48,50,49,50,44,48,46,48,
56,52,55,32,48,44,48,46,49,55,57,57,50,32,45,48,46,48,53,50,57,44,48,46,49,53,56,55,53,32,45,48,46,49,48,53,56,51,44,48,46,51,48,54,57,49,32,45,48,46,48,52,50,51,44,48,46,49,51,55,53,57,32,45,48,46,49,
49,54,52,50,44,48,46,50,55,53,49,55,32,45,48,46,49,53,56,55,53,44,48,46,51,49,55,53,32,45,48,46,52,48,50,49,55,44,48,46,53,54,48,57,50,32,45,48,46,50,51,50,56,51,44,48,46,50,52,51,52,49,32,45,48,46,53,
55,49,53,44,48,46,51,57,49,53,56,32,45,48,46,48,56,52,55,44,48,46,48,52,50,51,32,45,48,46,49,55,57,57,49,44,48,46,48,55,52,49,32,45,48,46,48,57,53,50,44,48,46,48,50,49,50,32,45,48,46,50,48,49,48,57,44,
48,46,48,53,50,57,32,45,48,46,49,49,54,52,49,44,48,46,48,52,50,51,32,45,48,46,50,51,50,56,51,44,48,46,48,52,50,51,32,45,48,46,49,49,54,52,50,44,48,46,48,49,48,54,32,45,48,46,50,51,50,56,51,44,48,46,48,
51,49,56,32,45,48,46,48,52,50,51,44,48,46,48,50,49,50,32,45,48,46,48,56,52,55,44,48,46,48,49,48,54,32,45,48,46,48,52,50,51,44,45,48,46,48,49,48,54,32,45,48,46,48,56,52,55,44,48,32,104,32,45,48,46,48,57,
53,51,32,113,32,45,48,46,48,56,52,55,44,48,32,45,48,46,49,54,57,51,51,44,48,32,45,48,46,48,55,52,49,44,48,46,48,49,48,54,32,45,48,46,49,51,55,53,56,44,45,48,46,48,49,48,54,32,104,32,45,48,46,48,53,50,
57,32,108,32,45,48,46,50,53,52,44,45,48,46,48,51,49,56,32,113,32,45,48,46,49,51,55,53,56,44,45,48,46,48,52,50,51,32,45,48,46,50,54,52,53,56,44,45,48,46,48,55,52,49,32,45,48,46,49,50,55,44,45,48,46,48,
51,49,56,32,45,48,46,50,52,51,52,50,44,45,48,46,48,56,52,55,32,45,48,46,51,56,49,44,45,48,46,49,54,57,51,51,32,45,48,46,54,51,53,44,45,48,46,52,48,50,49,54,32,45,48,46,50,52,51,52,50,44,45,48,46,50,51,
50,56,52,32,45,48,46,52,53,53,48,56,44,45,48,46,53,55,49,53,32,45,48,46,48,53,50,57,44,45,48,46,48,56,52,55,32,45,48,46,48,57,53,51,44,45,48,46,49,57,48,53,32,45,48,46,48,52,50,51,44,45,48,46,49,48,53,
56,52,32,45,48,46,48,56,52,55,44,45,48,46,50,49,49,54,55,32,45,48,46,48,53,50,57,44,45,48,46,49,49,54,52,50,32,45,48,46,48,55,52,49,44,45,48,46,50,52,51,52,50,32,45,48,46,48,50,49,50,44,45,48,46,49,50,
55,32,45,48,46,48,53,50,57,44,45,48,46,50,53,52,32,45,48,46,48,49,48,54,44,45,48,46,48,52,50,51,32,45,48,46,48,49,48,54,44,45,48,46,48,56,52,55,32,48,44,45,48,46,48,52,50,51,32,45,48,46,48,49,48,54,44,
45,48,46,48,56,52,55,32,45,48,46,48,50,49,50,44,45,48,46,48,54,51,53,32,45,48,46,48,50,49,50,44,45,48,46,49,51,55,53,56,32,48,46,48,49,48,54,44,45,48,46,48,55,52,49,32,45,48,46,48,49,48,54,44,45,48,46,
49,51,55,53,57,32,118,32,45,48,46,49,48,53,56,51,32,113,32,45,48,46,48,49,48,54,44,45,48,46,48,53,50,57,32,45,48,46,48,49,48,54,44,45,48,46,49,52,56,49,55,32,48,44,45,48,46,48,57,53,50,32,48,46,48,49,
48,54,44,45,48,46,49,52,56,49,54,32,48,46,48,49,48,54,44,45,48,46,48,53,50,57,32,48,44,45,48,46,48,57,53,51,32,48,44,45,48,46,48,52,50,51,32,48,46,48,49,48,54,44,45,48,46,48,56,52,55,32,48,46,48,50,49,
50,44,45,48,46,48,55,52,49,32,48,46,48,49,48,54,44,45,48,46,49,52,56,49,55,32,48,44,45,48,46,48,55,52,49,32,48,46,48,50,49,50,44,45,48,46,49,51,55,53,56,32,48,46,48,52,50,51,44,45,48,46,49,55,57,57,50,
32,48,46,48,55,52,49,44,45,48,46,51,53,57,56,51,32,48,46,48,51,49,56,44,45,48,46,49,55,57,57,50,32,48,46,48,57,53,50,44,45,48,46,51,51,56,54,55,32,48,46,50,50,50,50,53,44,45,48,46,53,53,48,51,51,32,48,
46,53,51,57,55,53,44,45,48,46,56,56,57,32,48,46,51,49,55,53,44,45,48,46,51,51,56,54,55,32,48,46,56,54,55,56,51,44,45,48,46,53,54,48,57,50,32,48,46,49,49,54,52,50,44,45,48,46,48,53,50,57,32,48,46,50,53,
52,44,45,48,46,48,55,52,49,32,48,46,49,51,55,53,57,44,45,48,46,48,50,49,50,32,48,46,50,56,53,55,53,44,45,48,46,48,53,50,57,32,48,46,48,55,52,49,44,45,48,46,48,49,48,54,32,48,46,49,52,56,49,55,44,45,48,
46,48,49,48,54,32,48,46,48,55,52,49,44,45,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,45,48,46,48,50,49,50,32,122,34,32,47,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,
32,32,105,100,61,34,112,97,116,104,51,56,52,53,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,
97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,
111,110,116,45,102,97,109,105,108,121,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,
105,111,110,58,39,65,108,116,101,32,72,97,97,115,32,71,114,111,116,101,115,107,39,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,
51,51,50,34,10,32,32,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,50,48,46,48,48,56,49,50,44,49,48,53,46,52,52,55,55,49,32,113,32,48,46,55,54,50,44,45,48,46,48,49,48,54,32,49,46,50,56,48,53,57,44,48,
46,49,55,57,57,50,32,48,46,53,49,56,53,56,44,48,46,49,55,57,57,50,32,48,46,56,48,52,51,51,44,48,46,54,52,53,53,56,32,48,46,48,55,52,49,44,48,46,49,49,54,52,50,32,48,46,49,49,54,52,50,44,48,46,50,52,51,
52,50,32,48,46,48,52,50,51,44,48,46,49,49,54,52,50,32,48,46,48,56,52,55,44,48,46,50,54,52,53,56,32,48,46,48,50,49,50,44,48,46,48,55,52,49,32,48,46,48,49,48,54,44,48,46,49,53,56,55,53,32,45,48,46,48,49,
48,54,44,48,46,48,55,52,49,32,45,48,46,48,51,49,56,44,48,46,49,49,54,52,50,32,45,48,46,48,50,49,50,44,48,46,48,50,49,50,32,45,48,46,48,53,50,57,44,48,46,48,52,50,51,32,45,48,46,48,51,49,56,44,48,46,48,
49,48,54,32,45,48,46,48,53,50,57,44,48,46,48,51,49,56,32,45,48,46,48,53,50,57,44,48,46,48,50,49,50,32,45,48,46,49,48,53,56,51,44,48,46,48,49,48,54,32,45,48,46,48,53,50,57,44,45,48,46,48,49,48,54,32,45,
48,46,49,48,53,56,51,44,48,32,45,48,46,48,56,52,55,44,48,46,48,50,49,50,32,45,48,46,50,50,50,50,53,44,48,46,48,49,48,54,32,45,48,46,49,51,55,53,57,44,45,48,46,48,50,49,50,32,45,48,46,49,57,48,53,44,45,
48,46,48,53,50,57,32,45,48,46,48,56,52,55,44,45,48,46,48,53,50,57,32,45,48,46,49,49,54,52,50,44,45,48,46,49,51,55,53,56,32,45,48,46,48,50,49,50,44,45,48,46,48,57,53,50,32,45,48,46,48,55,52,49,44,45,48,
46,49,55,57,57,50,32,45,48,46,48,57,53,50,44,45,48,46,49,54,57,51,51,32,45,48,46,50,54,52,53,57,44,45,48,46,51,48,54,57,49,32,45,48,46,49,49,54,52,49,44,45,48,46,48,56,52,55,32,45,48,46,50,53,52,44,45,
48,46,49,50,55,32,45,48,46,49,51,55,53,56,44,45,48,46,48,52,50,51,32,45,48,46,50,57,54,51,51,44,45,48,46,48,56,52,55,32,45,48,46,48,53,50,57,44,45,48,46,48,50,49,50,32,45,48,46,49,48,53,56,51,44,45,48,
46,48,49,48,54,32,45,48,46,48,53,50,57,44,48,32,45,48,46,49,48,53,56,52,44,45,48,46,48,49,48,54,32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,45,48,46,49,53,56,55,53,44,45,48,46,48,50,49,50,32,45,
48,46,48,57,53,51,44,48,32,45,48,46,49,53,56,55,53,44,48,46,48,50,49,50,32,104,32,45,48,46,48,54,51,53,32,113,32,45,48,46,48,53,50,57,44,48,46,48,49,48,54,32,45,48,46,49,48,53,56,51,44,48,46,48,50,49,
50,32,45,48,46,48,53,50,57,44,48,32,45,48,46,49,48,53,56,51,44,48,46,48,49,48,54,32,45,48,46,50,55,53,49,55,44,48,46,48,54,51,53,32,45,48,46,52,53,53,48,57,44,48,46,49,55,57,57,50,32,45,48,46,49,55,57,
57,49,44,48,46,49,49,54,52,50,32,45,48,46,50,52,51,52,49,44,48,46,51,57,49,53,56,32,45,48,46,48,50,49,50,44,48,46,48,55,52,49,32,45,48,46,48,49,48,54,44,48,46,49,52,56,49,55,32,48,46,48,50,49,50,44,48,
46,48,55,52,49,32,48,46,48,52,50,51,44,48,46,49,50,55,32,48,46,48,54,51,53,44,48,46,49,53,56,55,53,32,48,46,49,52,56,49,54,44,48,46,50,51,50,56,51,32,48,46,48,57,53,50,44,48,46,48,54,51,53,32,48,46,50,
51,50,56,52,44,48,46,49,52,56,49,55,32,48,46,49,54,57,51,51,44,48,46,49,48,53,56,51,32,48,46,51,56,49,44,48,46,49,53,56,55,53,32,48,46,50,49,49,54,54,44,48,46,48,52,50,51,32,48,46,52,50,51,51,51,44,48,
46,49,48,53,56,51,32,48,46,49,51,55,53,56,44,48,46,48,52,50,51,32,48,46,50,55,53,49,55,44,48,46,48,54,51,53,32,48,46,49,51,55,53,56,44,48,46,48,50,49,50,32,48,46,50,55,53,49,54,44,48,46,48,54,51,53,32,
48,46,50,50,50,50,53,44,48,46,48,54,51,53,32,48,46,52,51,51,57,50,44,48,46,49,50,55,32,48,46,50,49,49,54,55,44,48,46,48,53,50,57,32,48,46,52,50,51,51,51,44,48,46,49,51,55,53,57,32,48,46,48,53,50,57,44,
48,46,48,50,49,50,32,48,46,49,48,53,56,52,44,48,46,48,52,50,51,32,48,46,48,53,50,57,44,48,46,48,50,49,50,32,48,46,49,48,53,56,51,44,48,46,48,53,50,57,32,48,46,50,49,49,54,55,44,48,46,49,50,55,32,48,46,
51,55,48,52,50,44,48,46,50,56,53,55,53,32,48,46,49,53,56,55,53,44,48,46,49,53,56,55,53,32,48,46,50,54,52,53,56,44,48,46,52,48,50,49,54,32,48,46,48,50,49,50,44,48,46,48,55,52,49,32,48,46,48,52,50,51,44,
48,46,50,48,49,48,57,32,48,46,48,50,49,50,44,48,46,48,55,52,49,32,48,46,48,50,49,50,44,48,46,49,53,56,55,53,32,48,46,48,49,48,54,44,48,46,48,55,52,49,32,48,46,48,49,48,54,44,48,46,49,54,57,51,51,32,118,
32,48,46,49,48,53,56,51,32,113,32,45,48,46,48,50,49,50,44,48,46,48,55,52,49,32,45,48,46,48,50,49,50,44,48,46,49,52,56,49,55,32,48,44,48,46,48,55,52,49,32,45,48,46,48,50,49,50,44,48,46,49,52,56,49,55,32,
45,48,46,48,51,49,56,44,48,46,49,49,54,52,49,32,45,48,46,48,55,52,49,44,48,46,50,50,50,50,53,32,45,48,46,48,52,50,51,44,48,46,49,48,53,56,51,32,45,48,46,48,57,53,50,44,48,46,49,57,48,53,32,45,48,46,49,
54,57,51,52,44,48,46,50,55,53,49,54,32,45,48,46,52,51,51,57,50,44,48,46,52,52,52,53,32,45,48,46,50,54,52,53,56,44,48,46,49,53,56,55,53,32,45,48,46,53,57,50,54,55,44,48,46,50,55,53,49,54,32,45,48,46,48,
57,53,51,44,48,46,48,51,49,55,32,45,48,46,50,48,49,48,56,44,48,46,48,52,50,51,32,45,48,46,48,57,53,51,44,48,46,48,50,49,50,32,45,48,46,49,57,48,53,44,48,46,48,53,50,57,32,45,48,46,49,48,53,56,51,44,48,
46,48,50,49,50,32,45,48,46,50,49,49,54,55,44,48,46,48,50,49,50,32,45,48,46,49,48,53,56,51,44,48,32,45,48,46,50,49,49,54,54,44,48,46,48,50,49,50,32,104,32,45,48,46,49,48,53,56,52,32,113,32,45,48,46,48,
53,50,57,44,48,46,48,49,48,54,32,45,48,46,49,52,56,49,54,44,48,46,48,49,48,54,32,45,48,46,48,57,53,51,44,48,32,45,48,46,49,52,56,49,55,44,45,48,46,48,49,48,54,32,104,32,45,48,46,49,49,54,52,50,32,113,
32,45,48,46,48,54,51,53,44,45,48,46,48,50,49,50,32,45,48,46,49,51,55,53,56,44,45,48,46,48,50,49,50,32,45,48,46,48,55,52,49,44,48,46,48,49,48,54,32,45,48,46,49,50,55,44,45,48,46,48,49,48,54,32,45,48,46,
48,53,50,57,44,45,48,46,48,49,48,54,32,45,48,46,49,51,55,53,56,44,45,48,46,48,49,48,54,32,45,48,46,48,56,52,55,44,45,48,46,48,50,49,50,32,45,48,46,49,54,57,51,52,44,45,48,46,48,52,50,51,32,45,48,46,48,
55,52,49,44,45,48,46,48,49,48,54,32,45,48,46,49,53,56,55,53,44,45,48,46,48,52,50,51,32,45,48,46,51,50,56,48,56,44,45,48,46,49,48,53,56,52,32,45,48,46,53,55,49,53,44,45,48,46,50,54,52,53,57,32,45,48,46,
50,52,51,52,49,44,45,48,46,49,53,56,55,53,32,45,48,46,52,50,51,51,51,44,45,48,46,52,49,50,55,53,32,45,48,46,48,57,53,50,44,45,48,46,49,51,55,53,56,32,45,48,46,49,53,56,55,53,44,45,48,46,50,56,53,55,53,
32,45,48,46,48,54,51,53,44,45,48,46,49,52,56,49,54,32,45,48,46,49,49,54,52,50,44,45,48,46,51,50,56,48,56,32,45,48,46,48,50,49,50,44,45,48,46,48,54,51,53,32,45,48,46,48,50,49,50,44,45,48,46,49,52,56,49,
55,32,48,46,48,49,48,54,44,45,48,46,48,57,53,50,32,48,46,48,51,49,56,44,45,48,46,49,52,56,49,54,32,48,46,48,51,49,56,44,45,48,46,48,52,50,51,32,48,46,49,48,53,56,51,44,45,48,46,48,56,52,55,32,48,46,48,
53,50,57,44,45,48,46,48,50,49,50,32,48,46,49,52,56,49,55,44,45,48,46,48,50,49,50,32,48,46,48,57,53,51,44,45,48,46,48,49,48,54,32,48,46,49,57,48,53,44,48,32,48,46,48,57,53,51,44,48,46,48,49,48,54,32,48,
46,49,55,57,57,49,44,48,46,48,51,49,56,32,48,46,48,57,53,50,44,48,46,48,49,48,54,32,48,46,49,50,55,44,48,46,48,51,49,56,32,48,46,48,55,52,49,44,48,46,48,53,50,57,32,48,46,48,57,53,51,44,48,46,49,53,56,
55,53,32,48,46,48,51,49,56,44,48,46,48,57,53,51,32,48,46,48,55,52,49,44,48,46,49,55,57,57,50,32,48,46,49,48,53,56,51,44,48,46,50,51,50,56,51,32,48,46,50,56,53,55,53,44,48,46,51,53,57,56,51,32,48,46,49,
50,55,44,48,46,48,57,53,51,32,48,46,50,56,53,55,53,44,48,46,49,52,56,49,55,32,48,46,49,53,56,55,53,44,48,46,48,53,50,57,32,48,46,51,51,56,54,54,44,48,46,49,48,53,56,51,32,108,32,48,46,50,50,50,50,53,44,
48,46,48,51,49,56,32,104,32,48,46,48,54,51,53,32,113,32,48,46,48,55,52,49,44,48,46,48,50,49,50,32,48,46,49,57,48,53,44,48,46,48,50,49,50,32,48,46,49,50,55,44,48,32,48,46,50,49,49,54,55,44,45,48,46,48,
50,49,50,32,48,46,48,55,52,49,44,48,32,48,46,49,49,54,52,50,44,45,48,46,48,49,48,54,32,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,48,46,49,50,55,44,45,48,46,48,49,48,54,32,48,46,48,54,51,53,44,45,48,
46,48,49,48,54,32,48,46,49,49,54,52,49,44,45,48,46,48,50,49,50,32,48,46,51,48,54,57,50,44,45,48,46,48,56,52,55,32,48,46,52,56,54,56,52,44,45,48,46,50,50,50,50,53,32,48,46,49,55,57,57,49,44,45,48,46,49,
51,55,53,56,32,48,46,50,53,52,44,45,48,46,52,54,53,54,55,32,48,46,48,50,49,50,44,45,48,46,48,53,50,57,32,48,46,48,49,48,54,44,45,48,46,49,49,54,52,49,32,45,48,46,48,49,48,54,44,45,48,46,48,54,51,53,32,
45,48,46,48,50,49,50,44,45,48,46,48,57,53,51,32,45,48,46,48,53,50,57,44,45,48,46,50,48,49,48,57,32,45,48,46,49,52,56,49,54,44,45,48,46,50,57,54,51,52,32,45,48,46,48,57,53,50,44,45,48,46,49,48,53,56,51,
32,45,48,46,50,52,51,52,50,44,45,48,46,49,57,48,53,32,45,48,46,48,57,53,50,44,45,48,46,48,54,51,53,32,45,48,46,50,49,49,54,55,44,45,48,46,49,48,53,56,51,32,45,48,46,49,49,54,52,49,44,45,48,46,48,52,50,
51,32,45,48,46,50,51,50,56,51,44,45,48,46,48,56,52,55,32,45,48,46,48,51,49,56,44,45,48,46,48,49,48,54,32,45,48,46,48,54,51,53,44,45,48,46,48,49,48,54,32,45,48,46,48,50,49,50,44,48,32,45,48,46,48,53,50,
57,44,45,48,46,48,50,49,50,32,45,48,46,51,53,57,56,51,44,45,48,46,49,49,54,52,49,32,45,48,46,55,53,49,52,49,44,45,48,46,49,54,57,51,51,32,45,48,46,51,56,49,44,45,48,46,48,54,51,53,32,45,48,46,55,49,57,
54,55,44,45,48,46,50,48,49,48,56,32,45,48,46,49,48,53,56,51,44,45,48,46,48,52,50,51,32,45,48,46,50,48,49,48,56,44,45,48,46,48,55,52,49,32,45,48,46,48,57,53,50,44,45,48,46,48,51,49,56,32,45,48,46,49,55,
57,57,50,44,45,48,46,48,56,52,55,32,45,48,46,50,48,49,48,56,44,45,48,46,49,49,54,52,50,32,45,48,46,51,55,48,52,50,44,45,48,46,50,54,52,53,57,32,45,48,46,49,54,57,51,51,44,45,48,46,49,52,56,49,54,32,45,
48,46,50,54,52,53,56,44,45,48,46,51,55,48,52,49,32,45,48,46,48,51,49,56,44,45,48,46,48,55,52,49,32,45,48,46,48,53,50,57,44,45,48,46,49,52,56,49,55,32,45,48,46,48,49,48,54,44,45,48,46,48,55,52,49,32,45,
48,46,48,51,49,56,44,45,48,46,49,53,56,55,53,32,45,48,46,48,51,49,56,44,45,48,46,49,50,55,32,45,48,46,48,50,49,50,44,45,48,46,50,56,53,55,53,32,48,46,48,49,48,54,44,45,48,46,49,54,57,51,51,32,48,46,48,
51,49,56,44,45,48,46,50,56,53,55,53,32,48,46,48,50,49,50,44,45,48,46,48,53,50,57,32,48,46,48,50,49,50,44,45,48,46,48,56,52,55,32,48,46,48,49,48,54,44,45,48,46,48,52,50,51,32,48,46,48,51,49,55,44,45,48,
46,48,56,52,55,32,48,46,48,57,53,51,44,45,48,46,50,52,51,52,50,32,48,46,50,53,52,44,45,48,46,52,50,51,51,52,32,48,46,49,54,57,51,52,44,45,48,46,49,55,57,57,49,32,48,46,51,56,49,44,45,48,46,51,49,55,53,
32,48,46,49,53,56,55,53,44,45,48,46,48,57,53,50,32,48,46,51,52,57,50,53,44,45,48,46,49,52,56,49,54,32,48,46,49,57,48,53,44,45,48,46,48,54,51,53,32,48,46,52,48,50,49,55,44,45,48,46,49,49,54,52,50,32,48,
46,48,55,52,49,44,45,48,46,48,49,48,54,32,48,46,49,51,55,53,56,44,45,48,46,48,50,49,50,32,48,46,48,55,52,49,44,45,48,46,48,49,48,54,32,48,46,49,53,56,55,53,44,45,48,46,48,50,49,50,32,48,46,48,51,49,56,
44,45,48,46,48,49,48,54,32,48,46,48,56,52,55,44,48,32,48,46,48,53,50,57,44,48,46,48,49,48,54,32,48,46,48,55,52,49,44,45,48,46,48,49,48,54,32,122,34,32,47,62,10,32,32,32,32,32,32,60,47,103,62,10,32,32,
32,32,32,32,60,103,10,32,32,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,51,56,48,55,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,
114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,52,48,48,59,102,111,110,116,45,115,105,122,101,58,49,46,48,50,
54,53,54,52,51,54,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,67,97,108,105,98,114,105,59,116,101,120,116,45,97,108,105,103,110,
58,115,116,97,114,116,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,116,101,120,116,45,97,110,99,104,111,114,58,
115,116,97,114,116,59,102,105,108,108,58,35,102,50,102,50,102,50,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,59,115,116,114,111,107,101,45,119,105,
100,116,104,58,48,46,48,54,57,56,57,51,55,53,34,10,32,32,32,32,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,115,99,97,108,101,40,48,46,57,57,55,56,54,52,55,50,44,49,46,48,48,50,49,51,57,57,
41,34,10,32,32,32,32,32,32,32,32,32,97,114,105,97,45,108,97,98,101,108,61,34,194,169,32,34,62,10,32,32,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,
104,51,56,50,48,34,10,32,32,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,
111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,52,48,48,59,102,111,110,116,45,115,105,122,101,58,49,51,46,52,49,57,53,57,57,53,51,112,120,59,102,111,110,116,45,102,97,109,105,108,
121,58,67,97,108,105,98,114,105,59,102,105,108,108,58,35,102,50,102,50,102,50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,48,54,57,56,57,51,55,53,34,10,32,32,32,32,32,32,32,32,32,32,32,
100,61,34,109,32,52,48,46,55,56,54,50,54,54,44,49,49,49,46,50,51,52,52,57,32,113,32,49,46,48,49,53,54,52,52,44,48,32,49,46,54,57,48,53,53,53,44,45,48,46,51,48,49,52,50,32,48,46,54,55,52,57,49,50,44,45,
48,46,51,48,55,57,55,32,49,46,48,56,49,49,54,57,44,45,48,46,56,52,53,50,55,32,48,46,52,48,54,50,53,55,44,45,48,46,53,51,55,51,49,32,48,46,53,55,54,54,50,51,44,45,49,46,50,54,52,54,52,32,48,46,49,55,54,
57,49,57,44,45,48,46,55,51,51,56,57,32,48,46,49,55,54,57,49,57,44,45,49,46,53,55,50,54,49,32,48,44,45,48,46,57,48,52,50,53,32,45,48,46,49,57,48,48,50,52,44,45,49,46,54,48,53,51,56,32,45,48,46,49,57,48,
48,50,51,44,45,48,46,55,48,55,54,55,32,45,48,46,54,50,50,52,57,49,44,45,49,46,49,57,50,53,54,32,45,48,46,52,51,50,52,54,55,44,45,48,46,52,56,52,56,57,32,45,49,46,49,50,55,48,51,55,44,45,48,46,55,52,48,
52,51,32,45,48,46,54,56,56,48,49,54,44,45,48,46,50,53,53,53,53,32,45,49,46,54,57,48,53,53,53,44,45,48,46,50,53,53,53,53,32,45,48,46,56,57,49,49,52,53,44,48,32,45,49,46,53,53,50,57,53,49,44,48,46,50,53,
53,53,53,32,45,48,46,54,54,49,56,48,55,44,48,46,50,52,56,57,57,32,45,49,46,49,48,48,56,50,55,44,48,46,55,52,54,57,57,32,45,48,46,52,51,57,48,50,44,48,46,52,57,55,57,57,32,45,48,46,54,53,53,50,53,52,44,
49,46,50,52,52,57,56,32,45,48,46,50,48,57,54,56,49,44,48,46,55,52,54,57,57,32,45,48,46,50,48,57,54,56,49,44,49,46,55,52,50,57,55,32,48,44,48,46,57,51,55,48,50,32,48,46,50,48,51,49,50,57,44,49,46,54,53,
49,50,52,32,48,46,50,48,51,49,50,57,44,48,46,55,48,55,54,56,32,48,46,54,51,53,53,57,54,44,49,46,49,56,54,48,49,32,48,46,52,51,57,48,50,44,48,46,52,55,49,55,57,32,49,46,49,50,55,48,51,55,44,48,46,55,49,
52,50,51,32,48,46,54,56,56,48,49,54,44,48,46,50,51,53,56,57,32,49,46,54,53,55,55,57,50,44,48,46,50,51,53,56,57,32,122,32,109,32,52,46,52,48,51,51,48,54,44,45,52,46,48,53,54,48,50,32,113,32,48,44,49,46,
50,52,52,57,56,32,45,48,46,50,57,52,56,54,52,44,50,46,49,53,53,55,56,32,45,48,46,50,56,56,51,49,50,44,48,46,57,48,52,50,53,32,45,48,46,56,53,56,51,56,51,44,49,46,53,48,48,53,52,32,45,48,46,53,55,48,48,
55,49,44,48,46,53,56,57,55,50,32,45,49,46,52,48,50,50,52,51,44,48,46,56,55,56,48,52,32,45,48,46,56,51,50,49,55,50,44,48,46,50,56,49,55,53,32,45,49,46,57,49,51,51,52,49,44,48,46,50,56,49,55,53,32,45,49,
46,49,48,55,51,55,57,44,48,32,45,49,46,57,51,57,53,53,50,44,45,48,46,50,56,49,55,53,32,45,48,46,56,51,50,49,55,50,44,45,48,46,50,56,49,55,54,32,45,49,46,51,56,57,49,51,56,44,45,48,46,56,51,56,55,51,32,
45,48,46,53,53,48,52,49,51,44,45,48,46,53,54,51,53,50,32,45,48,46,56,51,50,49,55,50,44,45,49,46,52,48,50,50,52,32,45,48,46,50,55,53,50,48,55,44,45,48,46,56,51,56,55,51,32,45,48,46,50,55,53,50,48,55,44,
45,49,46,57,53,57,50,49,32,48,44,45,49,46,50,49,56,55,55,32,48,46,50,56,49,55,53,57,44,45,50,46,49,50,51,48,50,32,48,46,50,56,56,51,49,50,44,45,48,46,57,48,52,50,53,32,48,46,56,52,53,50,55,56,44,45,49,
46,53,48,48,53,52,32,48,46,53,54,51,53,49,56,44,45,48,46,53,57,54,50,56,32,49,46,51,57,53,54,57,44,45,48,46,56,57,49,49,52,32,48,46,56,51,56,55,50,53,44,45,48,46,51,48,49,52,50,32,49,46,57,51,57,53,53,
50,44,45,48,46,51,48,49,52,50,32,49,46,49,52,54,54,57,52,44,48,32,49,46,57,55,56,56,54,55,44,48,46,51,48,49,52,50,32,48,46,56,51,50,49,55,50,44,48,46,50,57,52,56,54,32,49,46,51,56,50,53,56,53,44,48,46,
56,54,52,57,51,32,48,46,53,53,48,52,49,52,44,48,46,53,55,48,48,56,32,48,46,56,49,50,53,49,53,44,49,46,52,48,56,56,32,48,46,50,54,56,54,53,52,44,48,46,56,51,50,49,55,32,48,46,50,54,56,54,53,52,44,49,46,
57,48,54,55,57,32,122,32,109,32,45,50,46,54,51,52,49,50,44,50,46,48,49,56,49,56,32,113,32,48,44,48,46,48,57,56,51,32,45,48,46,48,48,54,54,44,48,46,49,55,48,51,55,32,45,48,46,48,48,54,54,44,48,46,48,55,
50,49,32,45,48,46,48,50,54,50,49,44,48,46,49,51,49,48,53,32,45,48,46,48,49,51,49,49,44,48,46,48,53,50,52,32,45,48,46,48,51,50,55,54,44,48,46,48,57,49,55,32,45,48,46,48,49,57,54,54,44,48,46,48,51,57,51,
32,45,48,46,48,56,53,49,56,44,48,46,48,57,56,51,32,45,48,46,48,53,56,57,55,44,48,46,48,53,57,32,45,48,46,50,49,54,50,51,52,44,48,46,49,54,51,56,49,32,45,48,46,49,53,55,50,54,49,44,48,46,49,48,52,56,53,
32,45,48,46,51,54,54,57,52,50,44,48,46,49,57,54,53,56,32,45,48,46,50,48,57,54,56,49,44,48,46,48,56,53,50,32,45,48,46,52,55,49,55,56,51,44,48,46,49,52,52,49,54,32,45,48,46,50,54,50,49,48,49,44,48,46,48,
53,50,52,32,45,48,46,53,53,54,57,54,53,44,48,46,48,53,50,52,32,45,48,46,53,56,51,49,55,54,44,48,32,45,49,46,48,50,56,55,52,57,44,45,48,46,49,56,51,52,55,32,45,48,46,52,52,53,53,55,51,44,45,48,46,49,56,
51,52,56,32,45,48,46,55,52,54,57,56,57,44,45,48,46,53,52,51,56,54,32,45,48,46,51,48,49,52,49,55,44,45,48,46,51,54,54,57,53,32,45,48,46,52,53,56,54,55,56,44,45,48,46,56,57,49,49,53,32,45,48,46,49,53,48,
55,48,57,44,45,48,46,53,51,48,55,54,32,45,48,46,49,53,48,55,48,57,44,45,49,46,50,50,53,51,50,32,48,44,45,48,46,55,54,54,54,53,32,48,46,49,56,51,52,55,50,44,45,49,46,51,50,51,54,50,32,48,46,49,57,48,48,
50,51,44,45,48,46,53,53,54,57,54,32,48,46,53,49,55,54,53,44,45,48,46,57,49,48,56,32,48,46,51,51,52,49,56,44,45,48,46,51,54,48,51,57,32,48,46,55,56,54,51,48,53,44,45,48,46,53,51,48,55,54,32,48,46,52,53,
50,49,50,53,44,45,48,46,49,55,54,57,49,32,48,46,57,55,54,51,50,56,44,45,48,46,49,55,54,57,49,32,48,46,50,53,53,53,52,57,44,48,32,48,46,52,56,52,56,56,56,44,48,46,48,53,50,52,32,48,46,50,51,53,56,57,49,
44,48,46,48,52,53,57,32,48,46,52,51,50,52,54,56,44,48,46,49,50,52,52,57,32,48,46,50,48,51,49,50,56,44,48,46,48,55,56,54,32,48,46,51,54,54,57,52,50,44,48,46,49,56,51,52,55,32,48,46,49,54,51,56,49,51,44,
48,46,49,48,52,56,53,32,48,46,50,51,53,56,57,49,44,48,46,49,55,54,57,50,32,48,46,48,55,56,54,51,44,48,46,48,55,50,49,32,48,46,48,57,56,50,57,44,48,46,49,49,49,52,32,48,46,48,50,54,50,49,44,48,46,48,51,
57,51,32,48,46,48,51,57,51,50,44,48,46,48,57,49,55,32,48,46,48,49,57,54,54,44,48,46,48,53,50,52,32,48,46,48,50,54,50,49,44,48,46,49,50,52,53,32,48,46,48,48,54,54,44,48,46,48,55,50,49,32,48,46,48,48,54,
54,44,48,46,49,53,55,50,54,32,48,44,48,46,48,56,53,50,32,45,48,46,48,49,51,49,49,44,48,46,49,53,55,50,54,32,45,48,46,48,49,51,49,44,48,46,48,55,50,49,32,45,48,46,48,51,50,55,54,44,48,46,49,51,49,48,53,
32,45,48,46,48,49,57,54,54,44,48,46,48,53,50,52,32,45,48,46,48,53,56,57,55,44,48,46,48,56,53,50,32,45,48,46,48,51,50,55,54,44,48,46,48,50,54,50,32,45,48,46,48,56,53,49,56,44,48,46,48,50,54,50,32,45,48,
46,49,49,49,51,57,51,44,48,32,45,48,46,50,50,57,51,51,56,44,45,48,46,48,57,49,55,32,45,48,46,49,49,49,51,57,52,44,45,48,46,48,57,56,51,32,45,48,46,50,56,49,55,54,44,45,48,46,50,48,57,54,56,32,45,48,46,
49,54,51,56,49,51,44,45,48,46,49,49,55,57,53,32,45,48,46,52,48,54,50,53,55,44,45,48,46,50,48,57,54,56,32,45,48,46,50,51,53,56,57,49,44,45,48,46,48,57,56,51,32,45,48,46,53,57,54,50,56,49,44,45,48,46,48,
57,56,51,32,45,48,46,55,48,49,49,50,50,44,48,32,45,49,46,48,56,49,49,54,57,44,48,46,53,51,48,55,54,32,45,48,46,51,55,51,52,57,53,44,48,46,53,51,48,55,53,32,45,48,46,51,55,51,52,57,53,44,49,46,53,52,54,
51,57,32,48,44,48,46,53,51,48,55,54,32,48,46,48,57,56,50,57,44,48,46,57,49,55,51,54,32,48,46,48,57,56,50,57,44,48,46,51,56,54,54,32,48,46,50,56,56,51,49,50,44,48,46,54,52,56,55,32,48,46,49,57,54,53,55,
54,44,48,46,50,53,53,53,53,32,48,46,52,55,56,51,51,54,44,48,46,51,56,48,48,53,32,48,46,50,56,49,55,53,57,44,48,46,49,50,52,53,32,48,46,54,52,56,55,48,49,44,48,46,49,50,52,53,32,48,46,51,51,52,49,55,57,
44,48,32,48,46,53,55,54,54,50,51,44,45,48,46,48,57,56,51,32,48,46,50,52,50,52,52,52,44,45,48,46,49,48,52,56,52,32,48,46,52,49,50,56,49,44,45,48,46,50,50,57,51,52,32,48,46,49,55,54,57,49,57,44,45,48,46,
49,50,52,53,32,48,46,50,57,52,56,54,52,44,45,48,46,50,50,50,55,57,32,48,46,49,49,55,57,52,54,44,45,48,46,49,48,52,56,52,32,48,46,50,48,57,54,56,50,44,45,48,46,49,48,52,56,52,32,48,46,48,51,50,55,54,44,
48,32,48,46,48,53,56,57,55,44,48,46,48,49,57,55,32,48,46,48,51,50,55,54,44,48,46,48,49,57,55,32,48,46,48,52,53,56,55,44,48,46,48,55,50,49,32,48,46,48,49,57,54,54,44,48,46,48,53,50,52,32,48,46,48,50,54,
50,49,44,48,46,49,51,55,54,32,48,46,48,49,51,49,49,44,48,46,48,56,53,50,32,48,46,48,49,51,49,49,44,48,46,50,48,51,49,51,32,122,34,32,47,62,10,32,32,32,32,32,32,60,47,103,62,10,32,32,32,32,60,47,103,62,
10,32,32,60,47,103,62,10,60,47,115,118,103,62,10,0,0};

const char* VASTLogoComponent::copyright_svg = (const char*) resource_VASTLogoComponent_copyright_svg;
const int VASTLogoComponent::copyright_svgSize = 44925;

// JUCER_RESOURCE: dynamics_svg, 13088, "../../Resources/dynamics.svg"
static const unsigned char resource_VASTLogoComponent_dynamics_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,
115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,46,
105,110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,
101,108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,110,
115,35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,45,
110,115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,34,
104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,111,
100,105,112,111,100,105,46,115,111,117,114,99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,107,
115,99,97,112,101,61,34,104,116,116,112,58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,119,
105,100,116,104,61,34,50,49,48,109,109,34,10,32,32,32,104,101,105,103,104,116,61,34,50,57,55,109,109,34,10,32,32,32,105,100,61,34,115,118,103,51,48,50,52,34,10,32,32,32,118,101,114,115,105,111,110,61,
34,49,46,49,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,51,32,40,50,52,48,53,53,52,54,44,32,50,48,49,56,45,48,51,45,49,49,41,34,10,32,32,32,115,111,
100,105,112,111,100,105,58,100,111,99,110,97,109,101,61,34,100,121,110,97,109,105,99,115,46,115,118,103,34,62,10,32,32,60,100,101,102,115,10,32,32,32,32,32,105,100,61,34,100,101,102,115,51,48,50,54,34,
32,47,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,105,101,119,10,32,32,32,32,32,105,100,61,34,98,97,115,101,34,10,32,32,32,32,32,112,97,103,101,99,111,108,111,114,61,34,35,
102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,111,114,61,34,35,54,54,54,54,54,54,34,10,32,32,32,32,32,98,111,114,100,101,114,111,112,97,99,105,116,121,61,34,49,46,48,34,
10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,99,105,116,121,61,34,48,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,115,104,97,100,111,119,61,
34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,61,34,55,46,57,49,57,53,57,53,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,120,61,34,50,53,55,46,57,48,48,49,
57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,53,53,56,46,54,53,52,48,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,100,111,99,117,109,101,110,116,45,117,110,105,116,
115,61,34,112,120,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,116,45,108,97,121,101,114,61,34,108,97,121,101,114,49,34,10,32,32,32,32,32,115,104,111,119,103,114,105,100,
61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,119,105,100,116,104,61,34,53,52,51,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,
105,110,100,111,119,45,104,101,105,103,104,116,61,34,50,56,54,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,120,61,34,45,49,56,34,10,32,32,32,32,32,105,110,107,115,
99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,45,49,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,105,122,101,100,61,34,49,34,32,47,62,
10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,51,48,50,57,34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,10,32,32,32,32,32,32,60,99,99,58,87,
111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,103,101,47,115,118,103,43,120,109,108,
60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,32,32,32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,117,114,99,101,61,34,104,116,116,112,
58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,73,109,97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,105,116,108,101,62,60,
47,100,99,58,116,105,116,108,101,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,114,100,102,58,82,68,70,62,10,32,32,60,47,109,101,116,97,100,97,116,97,62,10,32,32,60,103,
10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,109,111,100,101,61,34,108,97,
121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,62,10,32,32,32,32,60,103,10,32,32,32,32,32,32,32,97,114,105,97,45,108,97,98,101,108,61,34,100,121,110,97,109,105,99,115,34,10,32,
32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,
116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,108,105,110,101,45,104,101,105,103,104,116,58,48,37,59,102,111,110,
116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,
58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,108,101,116,116,101,114,45,115,112,97,99,105,
110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,
115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,34,10,32,32,32,32,32,32,32,105,100,
61,34,116,101,120,116,51,48,51,50,34,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,50,50,52,46,56,56,48,50,56,44,53,51,56,46,53,56,57,56,52,32,113,32,45,49,46,
54,48,49,53,54,44,48,32,45,52,46,53,55,48,51,49,44,50,46,50,54,53,54,51,32,45,50,46,57,54,56,55,53,44,50,46,50,50,54,53,54,32,45,53,46,50,55,51,52,52,44,53,46,48,55,56,49,50,32,45,50,46,50,54,53,54,51,
44,50,46,56,49,50,53,32,45,50,46,50,54,53,54,51,44,52,46,52,49,52,48,55,32,48,44,49,46,50,56,57,48,54,32,49,46,50,49,48,57,52,44,49,46,50,56,57,48,54,32,49,46,55,49,56,55,53,44,48,32,52,46,55,50,54,53,
54,44,45,50,46,50,50,54,53,54,32,51,46,48,52,54,56,56,44,45,50,46,50,54,53,54,51,32,53,46,51,57,48,54,51,44,45,53,46,48,55,56,49,51,32,50,46,51,56,50,56,49,44,45,50,46,56,49,50,53,32,50,46,51,56,50,56,
49,44,45,52,46,50,57,54,56,55,32,48,44,45,49,46,52,52,53,51,50,32,45,49,46,54,48,49,53,54,44,45,49,46,52,52,53,51,50,32,122,32,109,32,49,46,54,55,57,54,57,44,51,46,50,48,51,49,51,32,50,49,46,48,57,51,
55,53,44,45,50,52,46,49,48,49,53,54,32,104,32,51,46,50,48,51,49,50,32,108,32,45,50,52,46,54,48,57,51,55,44,50,56,46,48,56,53,57,51,32,113,32,45,48,46,56,50,48,51,50,44,48,46,57,51,55,53,32,45,49,46,55,
57,54,56,56,44,50,46,49,48,57,51,56,32,45,48,46,57,55,54,53,54,44,49,46,49,55,49,56,55,32,45,49,46,52,52,53,51,49,44,49,46,56,51,53,57,52,32,45,48,46,52,50,57,54,57,44,48,46,54,54,52,48,54,32,45,48,46,
54,50,53,44,49,46,50,56,57,48,54,32,45,48,46,49,53,54,50,53,44,48,46,54,50,53,32,48,46,53,56,53,57,52,44,48,46,54,50,53,32,48,46,57,55,54,53,54,44,48,32,52,46,56,48,52,54,56,44,45,51,46,48,48,55,56,49,
32,51,46,56,50,56,49,51,44,45,51,46,48,52,54,56,56,32,55,46,49,56,55,53,44,45,54,46,48,53,52,54,57,32,118,32,48,46,54,54,52,48,54,32,113,32,45,52,46,54,48,57,51,55,44,52,46,48,50,51,52,52,32,45,55,46,
55,55,51,52,51,44,54,46,52,56,52,51,56,32,45,51,46,49,50,53,44,50,46,52,54,48,57,51,32,45,52,46,53,55,48,51,50,44,50,46,52,54,48,57,51,32,45,49,46,48,49,53,54,50,44,48,32,45,49,46,48,49,53,54,50,44,45,
49,46,50,49,48,57,51,32,48,44,45,49,46,53,54,50,53,32,49,46,48,57,51,55,53,44,45,52,46,48,54,50,53,32,48,44,45,48,46,48,51,57,49,32,45,48,46,48,55,56,49,44,45,48,46,48,55,56,49,32,45,48,46,48,51,57,49,
44,45,48,46,48,55,56,49,32,45,48,46,48,55,56,49,44,45,48,46,48,55,56,49,32,45,53,46,52,50,57,54,57,44,53,46,52,50,57,54,56,32,45,56,46,53,53,52,54,57,44,53,46,52,50,57,54,56,32,45,50,46,50,50,54,53,54,
44,48,32,45,50,46,50,50,54,53,54,44,45,51,46,54,55,49,56,55,32,48,44,45,50,46,56,57,48,54,51,32,50,46,49,56,55,53,44,45,53,46,51,49,50,53,32,50,46,49,56,55,53,44,45,50,46,52,50,49,56,56,32,53,46,51,57,
48,54,50,44,45,51,46,55,56,57,48,54,32,51,46,50,48,51,49,51,44,45,49,46,51,54,55,49,57,32,53,46,55,48,51,49,51,44,45,49,46,51,54,55,49,57,32,49,46,57,57,50,49,57,44,48,32,49,46,57,57,50,49,57,44,49,46,
54,55,57,54,57,32,48,44,49,46,49,55,49,56,55,32,45,48,46,52,54,56,55,53,44,50,46,48,55,48,51,49,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,
58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,
116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,
108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,
101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,
98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,51,53,34,32,47,62,
10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,50,51,57,46,57,53,56,52,44,53,53,53,46,53,52,50,57,55,32,113,32,45,56,46,50,48,51,49,50,44,52,46,49,48,49,53,54,32,
45,49,51,46,56,54,55,49,56,44,56,46,50,56,49,50,53,32,45,53,46,55,48,51,49,51,44,52,46,49,55,57,54,57,32,45,53,46,55,48,51,49,51,44,54,46,57,57,50,49,57,32,48,44,48,46,55,48,51,49,50,32,48,46,53,48,55,
56,49,44,49,46,49,51,50,56,49,32,48,46,52,54,56,55,53,44,48,46,52,54,56,55,53,32,49,46,49,55,49,56,56,44,48,46,52,54,56,55,53,32,49,46,51,54,55,49,57,44,48,32,51,46,48,56,53,57,52,44,45,48,46,57,55,54,
53,54,32,49,46,55,49,56,55,53,44,45,48,46,57,51,55,53,32,51,46,56,54,55,49,56,44,45,50,46,57,54,56,55,53,32,50,46,49,48,57,51,56,44,45,50,46,48,51,49,50,53,32,52,46,57,54,48,57,52,44,45,53,46,51,57,48,
54,51,32,49,46,53,50,51,52,52,44,45,49,46,56,55,53,32,51,46,50,56,49,50,53,44,45,52,46,48,54,50,53,32,49,46,55,57,54,56,56,44,45,50,46,49,52,56,52,52,32,50,46,54,57,53,51,49,44,45,51,46,52,55,54,53,54,
32,122,32,109,32,45,53,46,57,55,54,53,54,44,45,49,49,46,51,54,55,49,57,32,118,32,45,48,46,54,50,53,32,113,32,51,46,49,50,53,44,45,50,46,54,57,53,51,49,32,53,46,49,49,55,49,57,44,45,52,46,49,48,49,53,54,
32,50,46,48,51,49,50,53,44,45,49,46,52,48,54,50,53,32,51,46,53,49,53,54,50,44,45,49,46,52,48,54,50,53,32,49,46,50,49,48,57,52,44,48,32,49,46,50,49,48,57,52,44,49,46,54,48,49,53,54,32,48,44,51,46,51,57,
56,52,52,32,45,52,46,54,52,56,52,52,44,55,46,53,32,45,51,46,51,53,57,51,55,44,50,46,57,54,56,55,53,32,45,51,46,51,53,57,51,55,44,51,46,57,48,54,50,53,32,48,44,48,46,53,56,53,57,52,32,48,46,55,48,51,49,
50,44,48,46,53,56,53,57,52,32,49,46,52,52,53,51,50,44,48,32,53,44,45,50,46,51,56,50,56,49,32,51,46,53,57,51,55,53,44,45,50,46,52,50,49,56,56,32,55,46,52,50,49,56,56,44,45,53,46,53,56,53,57,52,32,51,46,
56,54,55,49,57,44,45,51,46,50,48,51,49,51,32,53,46,57,55,54,53,54,44,45,53,46,51,49,50,53,32,104,32,50,46,57,54,56,55,53,32,108,32,45,49,50,46,53,51,57,48,54,44,49,52,46,50,57,54,56,55,32,113,32,52,46,
51,55,53,44,45,49,46,55,53,55,56,49,32,55,46,53,44,45,51,46,56,50,56,49,50,32,51,46,49,54,52,48,54,44,45,50,46,49,48,57,51,56,32,55,46,57,50,57,54,57,44,45,54,46,50,53,32,118,32,48,46,54,54,52,48,54,32,
113,32,45,52,46,52,53,51,49,51,44,52,46,49,48,49,53,54,32,45,55,46,56,49,50,53,44,54,46,50,56,57,48,54,32,45,51,46,51,53,57,51,56,44,50,46,49,56,55,53,32,45,56,46,53,49,53,54,51,44,52,46,49,48,49,53,55,
32,108,32,45,48,46,55,48,51,49,50,44,48,46,55,56,49,50,53,32,113,32,45,56,46,49,54,52,48,55,44,57,46,49,52,48,54,50,32,45,49,51,46,50,48,51,49,51,44,49,51,46,56,54,55,49,56,32,45,53,46,48,51,57,48,54,
44,52,46,55,50,54,53,55,32,45,56,46,51,50,48,51,49,44,52,46,55,50,54,53,55,32,45,50,46,52,50,49,56,56,44,48,32,45,50,46,52,50,49,56,56,44,45,50,46,50,54,53,54,51,32,48,44,45,49,46,54,52,48,54,50,32,50,
46,50,50,54,53,55,44,45,52,46,49,52,48,54,50,32,50,46,49,56,55,53,44,45,50,46,52,54,48,57,52,32,54,46,56,51,53,57,51,44,45,53,46,53,48,55,56,50,32,52,46,54,52,56,52,52,44,45,51,46,48,48,55,56,49,32,49,
49,46,56,51,53,57,52,44,45,54,46,51,50,56,49,50,32,51,46,56,50,56,49,51,44,45,52,46,57,50,49,56,56,32,57,46,57,50,49,56,56,44,45,49,49,46,54,48,49,53,54,32,45,52,46,49,52,48,54,51,44,51,46,50,48,51,49,
50,32,45,53,46,52,54,56,55,53,44,52,46,50,49,56,55,53,32,45,49,46,51,50,56,49,51,44,49,46,48,49,53,54,50,32,45,51,46,49,54,52,48,55,44,50,46,51,48,52,54,56,32,45,49,46,56,51,53,57,51,44,49,46,50,53,32,
45,51,46,50,56,49,50,53,44,49,46,56,55,53,32,45,49,46,52,48,54,50,53,44,48,46,54,50,53,32,45,50,46,53,44,48,46,54,50,53,32,45,48,46,54,54,52,48,54,44,48,32,45,49,46,48,57,51,55,53,44,45,48,46,52,50,57,
54,56,32,45,48,46,52,50,57,54,56,44,45,48,46,52,50,57,54,57,32,45,48,46,52,50,57,54,56,44,45,49,46,49,55,49,56,56,32,48,44,45,49,46,50,56,57,48,54,32,48,46,53,48,55,56,49,44,45,50,46,52,54,48,57,52,32,
48,46,53,48,55,56,49,44,45,49,46,49,55,49,56,55,32,49,46,54,48,49,53,54,44,45,50,46,51,52,51,55,53,32,49,46,49,51,50,56,49,44,45,49,46,50,49,48,57,51,32,51,46,48,48,55,56,49,44,45,50,46,54,49,55,49,56,
32,51,46,51,53,57,51,56,44,45,50,46,53,32,51,46,51,53,57,51,56,44,45,51,46,56,54,55,49,57,32,48,44,45,48,46,55,48,51,49,51,32,45,48,46,55,56,49,50,53,44,45,48,46,55,48,51,49,51,32,45,49,46,51,50,56,49,
51,44,48,32,45,51,46,52,51,55,53,44,49,46,54,48,49,53,55,32,45,50,46,49,48,57,51,56,44,49,46,54,48,49,53,54,32,45,52,46,57,54,48,57,52,44,51,46,57,56,52,51,55,32,122,34,10,32,32,32,32,32,32,32,32,32,115,
116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,
104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,
104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,
99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,
105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,
32,105,100,61,34,112,97,116,104,51,55,51,55,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,50,53,57,46,56,52,49,50,50,44,53,52,52,46,49,55,53,55,56,32,
118,32,45,48,46,54,50,53,32,113,32,53,46,57,51,55,53,44,45,53,46,53,48,55,56,49,32,56,46,51,50,48,51,49,44,45,53,46,53,48,55,56,49,32,49,46,51,50,56,49,50,44,48,32,49,46,51,50,56,49,50,44,49,46,54,55,
57,54,57,32,48,44,49,46,51,50,56,49,50,32,45,48,46,56,50,48,51,49,44,50,46,54,49,55,49,56,32,45,48,46,56,50,48,51,49,44,49,46,50,56,57,48,55,32,45,51,46,51,50,48,51,49,44,52,46,52,57,50,49,57,32,52,46,
56,52,51,55,53,44,45,52,46,48,50,51,52,52,32,56,46,51,57,56,52,52,44,45,54,46,52,48,54,50,53,32,51,46,53,53,52,54,56,44,45,50,46,51,56,50,56,49,32,54,46,48,57,51,55,53,44,45,50,46,51,56,50,56,49,32,49,
46,51,50,56,49,50,44,48,32,49,46,51,50,56,49,50,44,49,46,56,51,53,57,52,32,48,44,49,46,55,57,54,56,55,32,45,49,46,50,53,44,51,46,53,57,51,55,53,32,45,49,46,50,53,44,49,46,55,53,55,56,49,32,45,52,46,49,
48,49,53,54,44,51,46,56,50,56,49,50,32,45,51,46,48,52,54,56,56,44,50,46,51,48,52,54,57,32,45,51,46,48,52,54,56,56,44,51,46,50,56,49,50,53,32,48,44,48,46,51,57,48,54,51,32,48,46,51,53,49,53,55,44,48,46,
55,52,50,49,57,32,48,46,51,57,48,54,50,44,48,46,51,49,50,53,32,48,46,55,56,49,50,53,44,48,46,51,49,50,53,32,49,46,51,54,55,49,56,44,48,32,51,46,53,57,51,55,53,44,45,49,46,52,56,52,51,56,32,50,46,50,54,
53,54,50,44,45,49,46,53,50,51,52,51,32,52,46,57,50,49,56,55,44,45,51,46,56,50,56,49,50,32,50,46,54,53,54,50,53,44,45,50,46,51,52,51,55,53,32,52,46,50,57,54,56,56,44,45,51,46,55,53,32,118,32,48,46,54,54,
52,48,54,32,113,32,45,50,46,51,56,50,56,50,44,50,46,50,50,54,53,54,32,45,52,46,54,52,56,52,52,44,52,46,49,55,57,54,57,32,45,50,46,50,54,53,54,51,44,49,46,57,49,52,48,54,32,45,52,46,53,51,49,50,53,44,51,
46,51,53,57,51,55,32,45,50,46,50,50,54,53,54,44,49,46,52,48,54,50,53,32,45,51,46,55,49,48,57,52,44,49,46,52,48,54,50,53,32,45,48,46,57,51,55,53,44,48,32,45,49,46,51,54,55,49,57,44,45,48,46,54,50,53,32,
45,48,46,51,57,48,54,50,44,45,48,46,54,50,53,32,45,48,46,51,57,48,54,50,44,45,49,46,50,56,57,48,54,32,48,44,45,49,46,52,56,52,51,55,32,49,46,49,55,49,56,55,44,45,51,46,51,50,48,51,49,32,49,46,49,55,49,
56,56,44,45,49,46,56,55,53,32,51,46,50,52,50,49,57,44,45,51,46,54,51,50,56,49,32,50,46,51,56,50,56,49,44,45,50,46,49,48,57,51,56,32,51,46,50,56,49,50,53,44,45,51,46,51,53,57,51,56,32,48,46,57,51,55,53,
44,45,49,46,50,56,57,48,54,32,45,48,46,53,48,55,56,49,44,45,49,46,50,56,57,48,54,32,45,49,46,56,51,53,57,52,44,48,32,45,53,46,53,52,54,56,56,44,50,46,53,32,45,51,46,55,49,48,57,51,44,50,46,52,54,48,57,
52,32,45,54,46,57,53,51,49,50,44,53,46,50,51,52,51,55,32,45,51,46,50,52,50,49,57,44,50,46,55,51,52,51,56,32,45,54,46,49,51,50,56,49,44,53,46,51,57,48,54,51,32,104,32,45,51,46,48,52,54,56,56,32,108,32,
53,46,49,57,53,51,49,44,45,53,46,56,53,57,51,56,32,113,32,53,46,55,48,51,49,51,44,45,54,46,51,54,55,49,56,32,53,46,55,48,51,49,51,44,45,54,46,57,53,51,49,50,32,48,44,45,48,46,51,57,48,54,51,32,45,48,46,
52,54,56,55,53,44,45,48,46,51,57,48,54,51,32,45,49,46,55,49,56,55,53,44,48,32,45,56,46,49,54,52,48,54,44,53,46,53,56,53,57,52,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,
110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,
97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,
102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,
105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,
109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,
97,116,104,51,55,51,57,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,50,57,55,46,51,48,50,49,53,44,53,51,56,46,53,56,57,56,52,32,113,32,45,50,46,51,
52,51,55,53,44,48,32,45,53,46,50,51,52,51,55,44,50,46,51,48,52,54,57,32,45,50,46,56,53,49,53,54,44,50,46,51,48,52,54,57,32,45,53,44,53,46,50,51,52,51,56,32,45,50,46,49,48,57,51,56,44,50,46,57,50,57,54,
56,32,45,50,46,49,48,57,51,56,44,52,46,49,52,48,54,50,32,48,44,48,46,53,56,53,57,52,32,48,46,51,57,48,54,51,44,48,46,57,55,54,53,54,32,48,46,51,57,48,54,50,44,48,46,51,57,48,54,51,32,48,46,57,55,54,53,
54,44,48,46,51,57,48,54,51,32,49,46,54,48,49,53,54,44,48,32,52,46,54,48,57,51,56,44,45,50,46,50,50,54,53,54,32,51,46,48,48,55,56,49,44,45,50,46,50,50,54,53,55,32,53,46,52,50,57,54,56,44,45,53,46,48,51,
57,48,55,32,50,46,52,50,49,56,56,44,45,50,46,56,49,50,53,32,50,46,52,50,49,56,56,44,45,52,46,52,49,52,48,54,32,48,44,45,49,46,51,54,55,49,57,32,45,49,46,52,56,52,51,56,44,45,49,46,51,54,55,49,57,32,122,
32,109,32,49,48,46,51,49,50,53,44,52,46,56,48,52,54,57,32,45,49,46,57,57,50,49,56,44,49,46,54,55,57,54,57,32,113,32,45,52,46,54,56,55,53,44,51,46,57,48,54,50,53,32,45,54,46,57,53,51,49,51,44,53,46,53,
48,55,56,49,32,45,50,46,50,50,54,53,54,44,49,46,54,48,49,53,54,32,45,51,46,57,52,53,51,49,44,49,46,54,48,49,53,54,32,45,49,46,49,51,50,56,49,44,48,32,45,49,46,49,51,50,56,49,44,45,49,46,50,56,57,48,54,
32,48,44,45,49,46,51,54,55,49,57,32,49,46,48,53,52,54,56,44,45,51,46,56,50,56,49,50,32,45,53,46,53,56,53,57,51,44,53,46,49,49,55,49,56,32,45,56,46,50,52,50,49,56,44,53,46,49,49,55,49,56,32,45,49,46,49,
55,49,56,56,44,48,32,45,49,46,57,49,52,48,55,44,45,48,46,56,57,56,52,51,32,45,48,46,55,52,50,49,56,44,45,48,46,57,51,55,53,32,45,48,46,55,52,50,49,56,44,45,50,46,54,57,53,51,50,32,48,44,45,49,46,57,57,
50,49,56,32,49,46,49,55,49,56,55,44,45,51,46,57,48,54,50,53,32,49,46,49,55,49,56,56,44,45,49,46,57,53,51,49,50,32,51,46,49,50,53,44,45,51,46,52,51,55,53,32,49,46,57,57,50,49,57,44,45,49,46,52,56,52,51,
55,32,52,46,52,49,52,48,54,44,45,50,46,51,52,51,55,53,32,50,46,52,54,48,57,52,44,45,48,46,56,53,57,51,55,32,52,46,55,54,53,54,51,44,45,48,46,56,53,57,51,55,32,49,46,49,51,50,56,49,44,48,32,49,46,54,52,
48,54,50,44,48,46,52,50,57,54,57,32,48,46,53,52,54,56,56,44,48,46,51,57,48,54,50,32,48,46,53,56,53,57,52,44,49,46,51,50,56,49,50,32,45,48,46,48,51,57,49,44,48,46,49,57,53,51,49,32,45,48,46,48,55,56,49,
44,48,46,51,57,48,54,51,32,48,44,48,46,49,53,54,50,53,32,45,48,46,48,55,56,49,44,48,46,52,54,56,55,53,32,45,48,46,48,51,57,49,44,48,46,51,49,50,53,32,45,48,46,48,55,56,49,44,48,46,53,48,55,56,49,32,108,
32,50,46,52,54,48,57,51,44,45,50,46,56,57,48,54,51,32,51,46,50,56,49,50,53,44,45,48,46,50,51,52,51,55,32,45,49,46,48,49,53,54,50,44,49,46,50,53,32,113,32,45,49,46,50,53,44,49,46,52,56,52,51,55,32,45,50,
46,48,51,49,50,53,44,50,46,52,54,48,57,52,32,45,48,46,55,56,49,50,53,44,48,46,57,51,55,53,32,45,49,46,51,50,56,49,51,44,49,46,53,54,50,53,32,45,54,46,48,57,51,55,53,44,54,46,54,48,49,53,54,32,45,54,46,
48,57,51,55,53,44,55,46,55,51,52,51,55,32,48,44,48,46,53,56,53,57,52,32,48,46,53,52,54,56,56,44,48,46,53,56,53,57,52,32,48,46,55,52,50,49,57,44,48,32,50,46,50,50,54,53,54,44,45,48,46,56,53,57,51,56,32,
49,46,52,56,52,51,56,44,45,48,46,56,57,56,52,51,32,51,46,51,50,48,51,49,44,45,50,46,51,52,51,55,53,32,49,46,56,55,53,44,45,49,46,52,52,53,51,49,32,52,46,50,53,55,56,50,44,45,51,46,51,57,56,52,51,32,50,
46,51,56,50,56,49,44,45,49,46,57,57,50,49,57,32,50,46,55,55,51,52,51,44,45,50,46,51,48,52,54,57,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,
58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,
116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,
108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,
101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,
98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,52,49,34,32,47,62,
10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,51,48,54,46,54,51,56,48,57,44,53,52,52,46,49,55,53,55,56,32,118,32,45,48,46,55,48,51,49,50,32,113,32,50,46,56,57,48,
54,51,44,45,50,46,54,49,55,49,57,32,52,46,56,52,51,55,53,44,45,52,46,48,50,51,52,52,32,49,46,57,53,51,49,51,44,45,49,46,52,48,54,50,53,32,51,46,52,55,54,53,54,44,45,49,46,52,48,54,50,53,32,49,46,50,53,
44,48,32,49,46,50,53,44,49,46,54,55,57,54,57,32,48,44,49,46,52,48,54,50,53,32,45,48,46,56,50,48,51,49,44,50,46,55,51,52,51,55,32,45,48,46,56,50,48,51,49,44,49,46,50,56,57,48,54,32,45,50,46,55,55,51,52,
52,44,51,46,55,53,32,53,46,52,54,56,55,53,44,45,52,46,52,57,50,49,57,32,56,46,50,48,51,49,51,44,45,54,46,51,50,56,49,50,32,50,46,55,55,51,52,52,44,45,49,46,56,51,53,57,52,32,52,46,55,54,53,54,50,44,45,
49,46,56,51,53,57,52,32,49,46,52,52,53,51,50,44,48,32,49,46,52,52,53,51,50,44,49,46,51,50,56,49,50,32,48,44,50,46,54,53,54,50,53,32,45,51,46,57,48,54,50,53,44,55,46,51,48,52,54,57,32,108,32,49,46,48,57,
51,55,53,44,45,48,46,56,50,48,51,49,32,113,32,50,46,54,49,55,49,56,44,45,49,46,57,49,52,48,54,32,53,44,45,51,46,54,55,49,56,56,32,50,46,51,56,50,56,49,44,45,49,46,55,53,55,56,49,32,52,46,53,55,48,51,49,
44,45,50,46,57,50,57,54,56,32,50,46,50,50,54,53,54,44,45,49,46,50,49,48,57,52,32,51,46,53,53,52,54,57,44,45,49,46,50,49,48,57,52,32,48,46,54,50,53,44,48,32,48,46,57,55,54,53,54,44,48,46,53,48,55,56,49,
32,48,46,51,57,48,54,50,44,48,46,52,54,56,55,53,32,48,46,51,57,48,54,50,44,49,46,52,48,54,50,53,32,48,44,49,46,55,57,54,56,56,32,45,49,46,50,49,48,57,51,44,51,46,53,53,52,54,57,32,45,49,46,49,55,49,56,
56,44,49,46,55,49,56,55,53,32,45,52,46,48,54,50,53,44,51,46,56,54,55,49,57,32,45,49,46,49,55,49,56,56,44,48,46,56,53,57,51,55,32,45,50,46,50,50,54,53,55,44,49,46,57,57,50,49,56,32,45,49,46,48,53,52,54,
56,44,49,46,49,51,50,56,50,32,45,49,46,48,53,52,54,56,44,49,46,53,50,51,52,52,32,48,44,48,46,55,52,50,49,57,32,49,46,48,57,51,55,53,44,48,46,55,52,50,49,57,32,49,46,55,49,56,55,53,44,48,32,52,46,53,51,
49,50,53,44,45,50,46,48,55,48,51,49,32,50,46,56,53,49,53,54,44,45,50,46,49,48,57,51,56,32,56,46,52,51,55,53,44,45,54,46,56,51,53,57,52,32,118,32,48,46,54,54,52,48,54,32,113,32,45,53,46,51,49,50,53,44,
52,46,53,55,48,51,49,32,45,56,46,49,54,52,48,55,44,54,46,54,55,57,54,57,32,45,50,46,56,49,50,53,44,50,46,49,48,57,51,55,32,45,52,46,57,54,48,57,51,44,50,46,49,48,57,51,55,32,45,49,46,53,50,51,52,52,44,
48,32,45,49,46,53,50,51,52,52,44,45,49,46,53,50,51,52,51,32,48,44,45,49,46,54,55,57,54,57,32,49,46,49,51,50,56,49,44,45,51,46,51,57,56,52,52,32,49,46,49,51,50,56,49,44,45,49,46,55,49,56,55,53,32,51,46,
56,50,56,49,51,44,45,52,46,50,53,55,56,49,32,51,46,49,50,53,44,45,50,46,57,50,57,54,57,32,51,46,49,50,53,44,45,51,46,55,49,48,57,52,32,48,44,45,48,46,55,48,51,49,51,32,45,48,46,54,50,53,44,45,48,46,55,
48,51,49,51,32,45,49,46,48,49,53,54,51,44,48,32,45,52,46,52,49,52,48,55,44,50,46,49,56,55,53,32,45,51,46,51,57,56,52,51,44,50,46,49,52,56,52,52,32,45,55,46,53,51,57,48,54,44,53,46,51,53,49,53,55,32,45,
52,46,49,48,49,53,54,44,51,46,49,54,52,48,54,32,45,54,46,55,53,55,56,49,44,53,46,54,54,52,48,54,32,104,32,45,51,46,50,56,49,50,53,32,108,32,54,46,48,53,52,54,57,44,45,54,46,54,52,48,54,51,32,113,32,48,
46,54,50,53,44,45,48,46,54,54,52,48,54,32,49,46,56,55,53,44,45,49,46,57,57,50,49,56,32,49,46,50,56,57,48,54,44,45,49,46,51,50,56,49,51,32,50,46,49,56,55,53,44,45,50,46,51,56,50,56,50,32,48,46,56,57,56,
52,51,44,45,49,46,48,57,51,55,53,32,48,46,56,57,56,52,51,44,45,49,46,52,56,52,51,55,32,48,44,45,48,46,49,57,53,51,49,32,45,48,46,49,57,53,51,49,44,45,48,46,51,57,48,54,51,32,45,48,46,49,53,54,50,53,44,
45,48,46,50,51,52,51,55,32,45,48,46,53,48,55,56,49,44,45,48,46,50,51,52,51,55,32,45,50,46,49,56,55,53,44,48,32,45,54,46,53,50,51,52,52,44,51,46,51,57,56,52,52,32,45,52,46,51,51,53,57,52,44,51,46,51,57,
56,52,51,32,45,49,48,46,49,57,53,51,49,44,56,46,54,55,49,56,55,32,108,32,45,49,46,49,51,50,56,49,44,49,46,48,53,52,54,57,32,104,32,45,51,46,51,53,57,51,56,32,108,32,56,46,50,52,50,49,57,44,45,57,46,50,
49,56,55,53,32,113,32,50,46,56,49,50,53,44,45,50,46,56,57,48,54,51,32,50,46,56,49,50,53,44,45,51,46,52,51,55,53,32,48,44,45,48,46,53,52,54,56,56,32,45,48,46,52,54,56,55,53,44,45,48,46,53,52,54,56,56,32,
45,48,46,54,54,52,48,54,44,48,32,45,49,46,57,57,50,49,57,44,48,46,56,53,57,51,56,32,45,49,46,51,50,56,49,50,44,48,46,56,50,48,51,49,32,45,50,46,56,57,48,54,50,44,50,46,48,55,48,51,49,32,45,49,46,53,54,
50,53,44,49,46,50,53,32,45,51,46,50,48,51,49,51,44,50,46,54,53,54,50,53,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,
101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,
110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,
97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,
116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,
97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,52,51,34,32,47,62,10,32,32,32,32,32,32,60,
112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,51,53,54,46,57,53,48,53,57,44,53,51,48,46,49,49,51,50,56,32,113,32,48,46,56,53,57,51,56,44,48,32,48,46,56,53,57,51,56,44,49,46,48,53,52,54,
57,32,48,44,48,46,54,50,53,32,45,48,46,51,53,49,53,55,44,49,46,48,49,53,54,50,32,45,48,46,51,53,49,53,54,44,48,46,51,57,48,54,51,32,45,48,46,56,57,56,52,51,44,48,46,51,57,48,54,51,32,45,49,46,48,53,52,
54,57,44,48,32,45,49,46,48,53,52,54,57,44,45,48,46,57,51,55,53,32,48,44,45,48,46,53,52,54,56,56,32,48,46,52,50,57,54,57,44,45,49,46,48,49,53,54,51,32,48,46,52,50,57,54,56,44,45,48,46,53,48,55,56,49,32,
49,46,48,49,53,54,50,44,45,48,46,53,48,55,56,49,32,122,32,109,32,45,49,51,46,53,49,53,54,50,44,49,51,46,57,56,52,51,56,32,45,48,46,48,55,56,49,44,45,48,46,54,50,53,32,113,32,50,46,57,54,56,55,53,44,45,
50,46,54,57,53,51,50,32,54,46,57,53,51,49,51,44,45,53,46,49,49,55,49,57,32,104,32,51,46,53,49,53,54,50,32,108,32,45,57,46,50,49,56,55,53,44,49,48,46,51,49,50,53,32,113,32,45,48,46,57,55,54,53,54,44,49,
46,48,57,51,55,53,32,45,49,46,50,53,44,50,46,48,51,49,50,53,32,45,48,46,50,55,51,52,52,44,48,46,57,51,55,53,32,48,46,52,54,56,55,53,44,48,46,57,51,55,53,32,49,46,57,53,51,49,51,44,48,32,53,46,56,50,48,
51,49,44,45,50,46,56,57,48,54,51,32,51,46,56,54,55,49,57,44,45,50,46,56,57,48,54,50,32,55,46,49,52,56,52,52,44,45,54,46,48,57,51,55,53,32,118,32,48,46,54,54,52,48,55,32,113,32,45,51,46,55,56,57,48,54,
44,51,46,54,51,50,56,49,32,45,55,46,51,48,52,54,57,44,54,46,50,53,32,45,51,46,53,49,53,54,50,44,50,46,54,49,55,49,56,32,45,53,46,55,52,50,49,56,44,50,46,54,49,55,49,56,32,45,49,46,50,56,57,48,55,44,48,
32,45,49,46,50,56,57,48,55,44,45,49,46,51,54,55,49,56,32,48,44,45,52,46,48,54,50,53,32,54,46,51,50,56,49,51,44,45,49,48,46,51,57,48,54,51,32,48,46,51,53,49,53,54,44,45,48,46,51,53,49,53,54,32,48,46,54,
50,53,44,45,48,46,54,54,52,48,54,32,48,46,51,49,50,53,44,45,48,46,51,53,49,53,54,32,48,46,53,56,53,57,52,44,45,48,46,54,50,53,32,45,51,46,53,49,53,54,51,44,50,46,49,48,57,51,55,32,45,54,46,53,54,50,53,
44,52,46,57,54,48,57,52,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,
116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,
105,122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,
45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,
101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,
105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,52,53,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,
34,109,32,51,55,50,46,54,53,51,55,50,44,53,52,50,46,53,55,52,50,50,32,118,32,48,46,54,54,52,48,54,32,113,32,45,57,46,50,53,55,56,50,44,56,46,57,52,53,51,49,32,45,49,53,46,52,50,57,54,57,44,56,46,57,52,
53,51,49,32,45,49,46,54,52,48,54,51,44,48,32,45,50,46,51,56,50,56,49,44,45,48,46,56,50,48,51,49,32,45,48,46,55,52,50,49,57,44,45,48,46,56,53,57,51,55,32,45,48,46,55,52,50,49,57,44,45,51,46,48,48,55,56,
49,32,48,44,45,49,46,56,55,53,32,49,46,50,49,48,57,52,44,45,51,46,55,56,57,48,54,32,49,46,49,55,49,56,55,44,45,49,46,57,49,52,48,55,32,51,46,49,50,53,44,45,51,46,51,53,57,51,56,32,49,46,57,53,51,49,50,
44,45,49,46,52,56,52,51,55,32,52,46,50,57,54,56,55,44,45,50,46,51,48,52,54,57,32,50,46,51,52,51,55,53,44,45,48,46,56,53,57,51,55,32,52,46,53,55,48,51,49,44,45,48,46,56,53,57,51,55,32,49,46,48,49,53,54,
51,44,48,32,49,46,54,52,48,54,51,44,48,46,53,48,55,56,49,32,48,46,54,54,52,48,54,44,48,46,53,48,55,56,49,32,48,46,54,54,52,48,54,44,49,46,52,48,54,50,53,32,48,44,49,46,48,49,53,54,51,32,45,48,46,56,50,
48,51,49,44,49,46,56,51,53,57,52,32,45,48,46,55,56,49,50,53,44,48,46,55,56,49,50,53,32,45,49,46,55,53,55,56,49,44,48,46,55,56,49,50,53,32,45,49,46,49,55,49,56,56,44,48,32,45,49,46,49,55,49,56,56,44,45,
49,46,48,49,53,54,51,32,48,44,45,49,46,53,50,51,52,51,32,49,46,51,54,55,49,57,44,45,49,46,53,50,51,52,51,32,48,46,55,56,49,50,53,44,48,32,48,46,57,51,55,53,44,48,46,55,48,51,49,50,32,48,46,49,53,54,50,
53,44,48,46,50,51,52,51,56,32,48,46,51,49,50,53,44,48,46,50,51,52,51,56,32,48,46,49,57,53,51,49,44,48,32,48,46,51,57,48,54,50,44,45,48,46,51,49,50,53,32,48,46,49,57,53,51,50,44,45,48,46,51,49,50,53,32,
48,46,49,57,53,51,50,44,45,48,46,55,48,51,49,51,32,48,44,45,48,46,54,50,53,32,45,48,46,52,50,57,54,57,44,45,48,46,57,55,54,53,54,32,45,48,46,52,50,57,54,57,44,45,48,46,51,57,48,54,51,32,45,49,46,49,55,
49,56,56,44,45,48,46,51,57,48,54,51,32,45,50,46,48,55,48,51,49,44,48,32,45,53,46,48,51,57,48,54,44,50,46,50,50,54,53,55,32,45,50,46,57,50,57,54,57,44,50,46,50,50,54,53,54,32,45,53,46,48,55,56,49,50,44,
53,46,48,55,56,49,50,32,45,50,46,49,52,56,52,52,44,50,46,56,53,49,53,54,32,45,50,46,49,52,56,52,52,44,52,46,52,53,51,49,51,32,48,44,49,46,50,56,57,48,54,32,49,46,57,49,52,48,54,44,49,46,50,56,57,48,54,
32,51,46,53,53,52,54,57,44,48,32,54,46,57,49,52,48,54,44,45,50,46,49,56,55,53,32,51,46,51,53,57,51,56,44,45,50,46,49,56,55,53,32,56,46,54,51,50,56,50,44,45,54,46,56,55,53,32,122,34,10,32,32,32,32,32,32,
32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,
119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,48,112,120,59,108,105,110,101,45,
104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,
45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,101,120,116,45,97,108,105,103,110,58,115,116,97,114,
116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,
32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,52,55,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,51,55,49,46,55,57,52,51,52,44,53,52,51,46,53,
53,48,55,56,32,56,46,49,54,52,48,54,44,45,55,46,48,51,49,50,53,32,113,32,48,46,57,51,55,53,44,45,49,46,49,51,50,56,49,32,49,46,55,49,56,55,53,44,45,50,46,48,55,48,51,49,32,48,46,55,56,49,50,53,44,45,48,
46,57,55,54,53,54,32,49,46,49,51,50,56,50,44,45,48,46,57,55,54,53,54,32,48,46,51,49,50,53,44,48,32,48,46,53,52,54,56,55,44,48,46,49,57,53,51,49,32,48,46,50,55,51,52,52,44,48,46,49,53,54,50,53,32,48,46,
50,55,51,52,52,44,48,46,53,48,55,56,49,32,48,44,48,46,55,52,50,49,57,32,45,50,46,49,52,56,52,52,44,49,46,56,51,53,57,52,32,49,46,50,53,44,49,46,56,55,53,32,49,46,55,57,54,56,56,44,51,46,50,56,49,50,53,
32,48,46,53,52,54,56,55,44,49,46,52,48,54,50,53,32,48,46,54,54,52,48,54,44,51,46,53,53,52,54,57,32,45,48,46,49,49,55,49,57,44,49,46,51,50,56,49,50,32,45,48,46,51,49,50,53,44,50,46,50,50,54,53,54,32,49,
46,52,48,54,50,53,44,48,46,51,53,49,53,54,32,50,46,53,51,57,48,54,44,45,48,46,48,51,57,49,32,49,46,49,55,49,56,56,44,45,48,46,52,50,57,54,57,32,51,46,50,48,51,49,51,44,45,50,46,52,54,48,57,52,32,118,32,
48,46,54,54,52,48,54,32,113,32,45,49,46,53,54,50,53,44,49,46,57,53,51,49,51,32,45,50,46,56,57,48,54,51,44,50,46,52,50,49,56,56,32,45,49,46,51,50,56,49,50,44,48,46,52,54,56,55,53,32,45,51,46,48,56,53,57,
52,44,45,48,46,48,51,57,49,32,45,48,46,57,51,55,53,44,50,46,49,48,57,51,56,32,45,51,46,48,52,54,56,55,44,51,46,54,51,50,56,50,32,45,50,46,49,48,57,51,56,44,49,46,52,56,52,51,55,32,45,52,46,51,51,53,57,
52,44,50,46,50,50,54,53,54,32,45,50,46,50,50,54,53,54,44,48,46,55,48,51,49,50,32,45,51,46,56,50,56,49,50,44,48,46,55,48,51,49,50,32,45,49,46,53,50,51,52,52,44,48,32,45,50,46,52,54,48,57,52,44,45,48,46,
53,56,53,57,51,32,45,48,46,57,55,54,53,54,44,45,48,46,54,50,53,32,45,48,46,57,55,54,53,54,44,45,49,46,55,49,56,55,53,32,48,44,45,48,46,57,55,54,53,55,32,48,46,53,56,53,57,51,44,45,49,46,53,54,50,53,32,
48,46,53,52,54,56,56,44,45,48,46,54,50,53,32,49,46,54,52,48,54,51,44,45,48,46,54,50,53,32,48,46,55,48,51,49,50,44,48,32,49,46,49,55,49,56,55,44,48,46,51,57,48,54,50,32,48,46,52,50,57,54,57,44,48,46,51,
53,49,53,54,32,48,46,52,50,57,54,57,44,48,46,57,55,54,53,54,32,48,44,48,46,53,48,55,56,50,32,45,48,46,52,54,56,55,53,44,48,46,56,57,56,52,52,32,45,48,46,53,48,55,56,49,44,48,46,51,57,48,54,51,32,45,49,
46,48,53,52,54,57,44,48,46,51,57,48,54,51,32,45,48,46,55,52,50,49,56,44,48,32,45,49,46,48,57,51,55,53,44,45,49,46,50,49,48,57,52,32,45,48,46,53,48,55,56,49,44,48,46,51,53,49,53,54,32,45,48,46,53,48,55,
56,49,44,49,46,48,53,52,54,57,32,48,44,48,46,52,50,57,54,56,32,48,46,56,50,48,51,49,44,48,46,57,51,55,53,32,48,46,55,56,49,50,53,44,48,46,53,48,55,56,49,32,49,46,56,51,53,57,52,44,48,46,53,48,55,56,49,
32,50,46,48,55,48,51,49,44,48,32,52,46,51,55,53,44,45,49,46,55,53,55,56,49,32,50,46,51,48,52,54,57,44,45,49,46,55,57,54,56,56,32,51,46,56,50,56,49,51,44,45,52,46,52,57,50,49,57,32,49,46,53,54,50,53,44,
45,50,46,54,57,53,51,49,32,49,46,53,54,50,53,44,45,53,46,49,57,53,51,49,32,48,44,45,49,46,55,57,54,56,56,32,45,49,46,49,51,50,56,50,44,45,51,46,54,55,49,56,56,32,108,32,45,56,46,57,52,53,51,49,44,55,46,
54,53,54,50,53,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,111,98,108,105,113,117,101,59,102,111,110,116,45,118,97,114,105,97,110,116,58,
110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,
122,101,58,56,48,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,39,59,45,
105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,80,97,108,97,99,101,32,83,99,114,105,112,116,32,77,84,32,79,98,108,105,113,117,101,39,59,116,
101,120,116,45,97,108,105,103,110,58,115,116,97,114,116,59,119,114,105,116,105,110,103,45,109,111,100,101,58,108,114,45,116,98,59,116,101,120,116,45,97,110,99,104,111,114,58,115,116,97,114,116,59,102,
105,108,108,58,35,102,57,102,57,102,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,51,55,52,57,34,32,47,62,10,32,32,32,32,60,47,103,62,10,32,32,60,47,103,62,10,60,47,115,118,103,62,10,
0,0};

const char* VASTLogoComponent::dynamics_svg = (const char*) resource_VASTLogoComponent_dynamics_svg;
const int VASTLogoComponent::dynamics_svgSize = 13088;

// JUCER_RESOURCE: logokreisv_svg, 2555, "../../Resources/logokreis-v.svg"
static const unsigned char resource_VASTLogoComponent_logokreisv_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,
32,115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,
46,105,110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,
47,101,108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,
110,115,35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,
45,110,115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,
34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,
111,100,105,112,111,100,105,46,115,111,117,114,99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,
107,115,99,97,112,101,61,34,104,116,116,112,58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,
119,105,100,116,104,61,34,49,48,48,109,109,34,10,32,32,32,104,101,105,103,104,116,61,34,49,48,48,109,109,34,10,32,32,32,118,105,101,119,66,111,120,61,34,48,32,48,32,49,48,48,32,49,48,48,34,10,32,32,32,
118,101,114,115,105,111,110,61,34,49,46,49,34,10,32,32,32,105,100,61,34,115,118,103,56,34,10,32,32,32,115,111,100,105,112,111,100,105,58,100,111,99,110,97,109,101,61,34,108,111,103,111,107,114,101,105,
115,45,118,46,115,118,103,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,49,32,114,49,53,51,55,49,34,62,10,32,32,60,100,101,102,115,10,32,32,32,32,32,
105,100,61,34,100,101,102,115,50,34,32,47,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,105,101,119,10,32,32,32,32,32,105,100,61,34,98,97,115,101,34,10,32,32,32,32,32,112,97,
103,101,99,111,108,111,114,61,34,35,102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,111,114,61,34,35,54,54,54,54,54,54,34,10,32,32,32,32,32,98,111,114,100,101,114,111,112,
97,99,105,116,121,61,34,49,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,99,105,116,121,61,34,48,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,
97,103,101,115,104,97,100,111,119,61,34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,61,34,49,46,57,55,57,56,57,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,
120,61,34,49,55,54,46,49,53,52,57,54,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,49,55,55,46,48,53,55,54,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,100,111,99,117,
109,101,110,116,45,117,110,105,116,115,61,34,109,109,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,116,45,108,97,121,101,114,61,34,108,97,121,101,114,50,34,10,32,32,32,32,
32,115,104,111,119,103,114,105,100,61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,119,105,100,116,104,61,34,50,48,52,56,34,10,32,32,32,32,32,
105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,104,101,105,103,104,116,61,34,49,48,57,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,120,61,34,50,48,52,
48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,45,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,
105,122,101,100,61,34,49,34,32,47,62,10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,53,34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,10,32,32,
32,32,32,32,60,99,99,58,87,111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,103,101,47,
115,118,103,43,120,109,108,60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,32,32,32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,117,114,
99,101,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,73,109,97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,60,100,99,
58,116,105,116,108,101,62,60,47,100,99,58,116,105,116,108,101,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,114,100,102,58,82,68,70,62,10,32,32,60,47,109,101,116,97,100,
97,116,97,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,
109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,10,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,116,114,97,110,115,108,97,116,101,40,48,
44,45,49,57,55,41,34,32,47,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,
121,101,114,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,50,34,10,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,116,114,97,110,115,108,
97,116,101,40,48,44,45,49,57,55,41,34,62,10,32,32,32,32,60,103,10,32,32,32,32,32,32,32,97,114,105,97,45,108,97,98,101,108,61,34,86,34,10,32,32,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,115,
99,97,108,101,40,48,46,57,51,57,53,51,53,53,52,44,49,46,48,54,52,51,53,53,55,41,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,
102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,50,49,46,51,49,50,49,57,54,55,51,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,
49,50,53,37,59,102,111,110,116,45,102,97,109,105,108,121,58,83,97,110,115,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,
120,59,102,105,108,108,58,35,102,57,102,57,102,57,59,102,105,108,108,45,111,112,97,99,105,116,121,58,48,46,56,50,54,52,49,53,49,50,59,115,116,114,111,107,101,58,110,111,110,101,59,115,116,114,111,107,
101,45,119,105,100,116,104,58,48,46,53,51,50,56,48,52,57,49,112,120,59,115,116,114,111,107,101,45,108,105,110,101,99,97,112,58,98,117,116,116,59,115,116,114,111,107,101,45,108,105,110,101,106,111,105,
110,58,109,105,116,101,114,59,115,116,114,111,107,101,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,52,54,49,57,34,62,10,32,32,32,32,32,32,60,112,97,116,104,
10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,57,48,46,55,55,51,56,51,57,44,50,48,48,46,49,55,52,56,53,32,45,50,55,46,49,50,51,49,44,55,52,46,51,55,54,50,52,32,72,32,52,50,46,49,55,50,48,52,32,76,32,
49,53,46,48,52,56,57,51,57,44,50,48,48,46,49,55,52,56,53,32,104,32,50,48,46,49,51,48,48,51,54,32,108,32,49,55,46,57,56,50,49,54,55,44,53,50,46,50,52,56,49,56,32,49,55,46,57,56,50,49,54,54,44,45,53,50,
46,50,52,56,49,56,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,
110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,98,111,108,100,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,
58,49,48,50,46,50,57,56,53,52,53,56,52,112,120,59,102,111,110,116,45,102,97,109,105,108,121,58,86,101,114,100,97,110,97,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,
105,99,97,116,105,111,110,58,39,86,101,114,100,97,110,97,32,66,111,108,100,39,59,102,105,108,108,58,35,102,57,102,57,102,57,59,102,105,108,108,45,111,112,97,99,105,116,121,58,48,46,56,50,54,52,49,53,49,
50,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,53,51,50,56,48,52,57,49,112,120,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,52,54,54,53,34,32,47,62,10,32,32,32,32,60,47,
103,62,10,32,32,60,47,103,62,10,60,47,115,118,103,62,10,0,0};

const char* VASTLogoComponent::logokreisv_svg = (const char*) resource_VASTLogoComponent_logokreisv_svg;
const int VASTLogoComponent::logokreisv_svgSize = 2555;

// JUCER_RESOURCE: logokreis_svg, 3721, "../../Resources/logokreis.svg"
static const unsigned char resource_VASTLogoComponent_logokreis_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,
115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,46,
105,110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,
101,108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,110,
115,35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,45,
110,115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,34,
104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,111,
100,105,112,111,100,105,46,115,111,117,114,99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,107,
115,99,97,112,101,61,34,104,116,116,112,58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,119,
105,100,116,104,61,34,49,48,48,109,109,34,10,32,32,32,104,101,105,103,104,116,61,34,49,48,48,109,109,34,10,32,32,32,118,105,101,119,66,111,120,61,34,48,32,48,32,49,48,48,32,49,48,48,34,10,32,32,32,118,
101,114,115,105,111,110,61,34,49,46,49,34,10,32,32,32,105,100,61,34,115,118,103,56,34,10,32,32,32,115,111,100,105,112,111,100,105,58,100,111,99,110,97,109,101,61,34,108,111,103,111,107,114,101,105,115,
46,115,118,103,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,49,32,114,49,53,51,55,49,34,62,10,32,32,60,100,101,102,115,10,32,32,32,32,32,105,100,61,
34,100,101,102,115,50,34,62,10,32,32,32,32,60,102,105,108,116,101,114,10,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,101,99,116,61,34,97,108,119,97,121,115,34,10,32,32,32,32,32,
32,32,115,116,121,108,101,61,34,99,111,108,111,114,45,105,110,116,101,114,112,111,108,97,116,105,111,110,45,102,105,108,116,101,114,115,58,115,82,71,66,34,10,32,32,32,32,32,32,32,105,100,61,34,102,105,
108,116,101,114,53,51,55,52,34,10,32,32,32,32,32,32,32,120,61,34,45,48,46,48,48,54,48,48,56,53,51,34,10,32,32,32,32,32,32,32,119,105,100,116,104,61,34,49,46,48,49,50,48,49,55,49,34,10,32,32,32,32,32,32,
32,121,61,34,45,48,46,48,48,53,57,57,49,52,57,52,50,34,10,32,32,32,32,32,32,32,104,101,105,103,104,116,61,34,49,46,48,49,49,57,56,51,34,62,10,32,32,32,32,32,32,60,102,101,71,97,117,115,115,105,97,110,
66,108,117,114,10,32,32,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,101,99,116,61,34,97,108,119,97,121,115,34,10,32,32,32,32,32,32,32,32,32,115,116,100,68,101,118,105,97,116,105,
111,110,61,34,48,46,57,52,50,52,49,50,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,102,101,71,97,117,115,115,105,97,110,66,108,117,114,53,51,55,54,34,32,47,62,10,32,32,32,32,60,47,102,105,108,116,
101,114,62,10,32,32,60,47,100,101,102,115,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,105,101,119,10,32,32,32,32,32,105,100,61,34,98,97,115,101,34,10,32,32,32,32,32,112,97,
103,101,99,111,108,111,114,61,34,35,102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,111,114,61,34,35,54,54,54,54,54,54,34,10,32,32,32,32,32,98,111,114,100,101,114,111,112,
97,99,105,116,121,61,34,49,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,99,105,116,121,61,34,48,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,
97,103,101,115,104,97,100,111,119,61,34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,61,34,49,46,57,55,57,56,57,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,
120,61,34,54,53,46,55,57,53,55,57,53,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,49,52,55,46,55,54,51,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,100,111,99,117,109,
101,110,116,45,117,110,105,116,115,61,34,109,109,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,116,45,108,97,121,101,114,61,34,108,97,121,101,114,50,34,10,32,32,32,32,32,
115,104,111,119,103,114,105,100,61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,119,105,100,116,104,61,34,50,48,52,56,34,10,32,32,32,32,32,105,
110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,104,101,105,103,104,116,61,34,49,48,57,57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,120,61,34,50,48,52,48,
34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,45,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,105,
122,101,100,61,34,49,34,32,47,62,10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,53,34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,10,32,32,32,
32,32,32,60,99,99,58,87,111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,103,101,47,115,
118,103,43,120,109,108,60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,32,32,32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,117,114,99,101,
61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,73,109,97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,
105,116,108,101,62,60,47,100,99,58,116,105,116,108,101,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,114,100,102,58,82,68,70,62,10,32,32,60,47,109,101,116,97,100,97,116,
97,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,109,111,
100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,10,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,116,114,97,110,115,108,97,116,101,40,48,44,45,49,
57,55,41,34,32,47,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,
50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,50,34,10,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,116,114,97,110,115,108,97,116,101,
40,48,44,45,49,57,55,41,34,62,10,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,111,112,97,99,105,116,121,58,49,59,102,105,108,108,58,35,97,51,98,102,97,56,59,102,105,
108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,45,119,105,100,116,104,58,49,46,49,51,55,51,57,48,57,55,59,115,116,114,111,107,101,45,108,105,110,101,99,97,112,58,115,113,117,97,
114,101,59,115,116,114,111,107,101,45,108,105,110,101,106,111,105,110,58,98,101,118,101,108,59,102,105,108,116,101,114,58,117,114,108,40,35,102,105,108,116,101,114,53,51,55,52,41,34,10,32,32,32,32,32,
32,32,100,61,34,77,32,49,56,56,46,51,57,50,53,56,32,48,46,48,57,53,55,48,51,49,50,53,32,65,32,49,56,56,46,50,49,52,50,55,32,49,56,56,46,55,52,57,57,57,32,48,32,48,32,48,32,48,46,49,55,55,55,51,52,51,56,
32,49,56,56,46,56,52,53,55,32,65,32,49,56,56,46,50,49,52,50,55,32,49,56,56,46,55,52,57,57,57,32,48,32,48,32,48,32,49,56,56,46,51,57,50,53,56,32,51,55,55,46,53,57,53,55,32,65,32,49,56,56,46,50,49,52,50,
55,32,49,56,56,46,55,52,57,57,57,32,48,32,48,32,48,32,51,55,54,46,54,48,55,52,50,32,49,56,56,46,56,52,53,55,32,65,32,49,56,56,46,50,49,52,50,55,32,49,56,56,46,55,52,57,57,57,32,48,32,48,32,48,32,49,56,
56,46,51,57,50,53,56,32,48,46,48,57,53,55,48,51,49,50,53,32,122,32,77,32,49,48,48,46,49,52,48,54,50,32,55,48,46,54,55,51,56,50,56,32,76,32,49,56,48,46,56,49,48,53,53,32,55,48,46,54,55,51,56,50,56,32,67,
32,49,57,56,46,57,51,54,54,53,32,55,48,46,54,55,51,56,50,56,32,50,49,52,46,53,55,52,51,32,55,50,46,51,54,49,55,50,57,32,50,50,55,46,55,50,48,55,32,55,53,46,55,51,54,51,50,56,32,67,32,50,52,48,46,56,54,
55,49,49,32,55,57,46,48,48,50,48,54,57,32,50,53,49,46,57,50,49,51,49,32,56,51,46,54,56,49,50,57,53,32,50,54,48,46,56,56,52,55,55,32,56,57,46,55,55,55,51,52,52,32,67,32,50,55,54,46,50,50,50,50,52,32,49,
48,48,46,48,49,32,50,56,56,46,50,55,50,56,52,32,49,49,51,46,56,51,54,54,50,32,50,57,55,46,48,51,55,49,49,32,49,51,49,46,50,53,51,57,49,32,67,32,51,48,53,46,57,48,48,57,55,32,49,52,56,46,53,54,50,51,51,
32,51,49,48,46,51,51,51,57,56,32,49,54,56,46,57,55,51,32,51,49,48,46,51,51,51,57,56,32,49,57,50,46,52,56,54,51,51,32,67,32,51,49,48,46,51,51,51,57,56,32,50,49,53,46,49,50,56,56,32,51,48,53,46,54,48,50,
48,53,32,50,51,53,46,52,51,49,32,50,57,54,46,49,52,48,54,50,32,50,53,51,46,51,57,50,53,56,32,67,32,50,56,54,46,54,55,57,50,32,50,55,49,46,50,52,53,50,57,32,50,55,52,46,55,50,56,50,52,32,50,56,52,46,57,
54,49,53,49,32,50,54,48,46,50,56,55,49,49,32,50,57,52,46,53,52,49,48,50,32,67,32,50,52,57,46,52,51,49,51,55,32,51,48,49,46,55,50,53,54,52,32,50,51,55,46,53,50,57,50,53,32,51,48,54,46,55,51,50,49,57,32,
50,50,52,46,53,56,50,48,51,32,51,48,57,46,53,54,50,53,32,67,32,50,49,49,46,54,51,52,56,50,32,51,49,50,46,51,57,50,56,49,32,49,57,54,46,50,57,56,48,52,32,51,49,51,46,56,48,56,53,57,32,49,55,56,46,53,55,
48,51,49,32,51,49,51,46,56,48,56,53,57,32,76,32,49,48,48,46,49,52,48,54,50,32,51,49,51,46,56,48,56,53,57,32,76,32,49,48,48,46,49,52,48,54,50,32,55,48,46,54,55,51,56,50,56,32,122,32,77,32,49,53,55,46,53,
48,53,56,54,32,49,49,54,46,48,54,56,51,54,32,76,32,49,53,55,46,53,48,53,56,54,32,50,54,56,46,50,53,32,76,32,49,55,49,46,57,57,54,48,57,32,50,54,56,46,50,53,32,67,32,49,56,53,46,54,52,48,52,55,32,50,54,
56,46,50,53,32,49,57,53,46,54,53,49,51,56,32,50,54,55,46,53,57,55,51,49,32,50,48,50,46,48,50,53,51,57,32,50,54,54,46,50,57,49,48,50,32,67,32,50,48,56,46,51,57,57,52,32,50,54,52,46,56,55,53,56,54,32,50,
49,52,46,54,50,51,57,57,32,50,54,50,46,51,55,51,53,54,32,50,50,48,46,54,57,57,50,50,32,50,53,56,46,55,56,49,50,53,32,67,32,50,51,49,46,49,53,54,53,57,32,50,53,50,46,50,52,57,55,55,32,50,51,56,46,56,50,
52,57,55,32,50,52,51,46,53,52,48,49,32,50,52,51,46,55,48,53,48,56,32,50,51,50,46,54,53,52,51,32,67,32,50,52,56,46,53,56,53,49,56,32,50,50,49,46,54,53,57,54,52,32,50,53,49,46,48,50,53,51,57,32,50,48,56,
46,49,48,55,48,56,32,50,53,49,46,48,50,53,51,57,32,49,57,49,46,57,57,54,48,57,32,67,32,50,53,49,46,48,50,53,51,57,32,49,55,53,46,57,57,51,57,54,32,50,52,56,46,51,51,53,49,49,32,49,54,50,46,51,51,50,57,
53,32,50,52,50,46,57,53,55,48,51,32,49,53,49,46,48,49,49,55,50,32,67,32,50,51,55,46,54,55,56,53,53,32,49,51,57,46,53,56,49,54,51,32,50,50,57,46,50,54,51,56,52,32,49,51,48,46,54,53,53,48,53,32,50,49,55,
46,55,49,48,57,52,32,49,50,52,46,50,51,50,52,50,32,67,32,50,49,49,46,56,51,52,56,57,32,49,50,49,46,48,55,53,53,52,32,50,48,53,46,56,48,57,53,57,32,49,49,56,46,57,53,49,56,54,32,49,57,57,46,54,51,52,55,
55,32,49,49,55,46,56,54,51,50,56,32,67,32,49,57,51,46,53,53,57,53,51,32,49,49,54,46,54,54,53,56,52,32,49,56,52,46,51,52,53,55,53,32,49,49,54,46,48,54,56,51,54,32,49,55,49,46,57,57,54,48,57,32,49,49,54,
46,48,54,56,51,54,32,76,32,49,53,55,46,53,48,53,56,54,32,49,49,54,46,48,54,56,51,54,32,122,32,34,10,32,32,32,32,32,32,32,116,114,97,110,115,102,111,114,109,61,34,109,97,116,114,105,120,40,48,46,50,54,
52,53,56,51,51,51,44,48,44,48,44,48,46,50,54,52,53,56,51,51,51,44,48,44,49,57,55,41,34,10,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,49,51,51,34,32,47,62,10,32,32,60,47,103,62,10,60,47,115,118,
103,62,10,0,0};

const char* VASTLogoComponent::logokreis_svg = (const char*) resource_VASTLogoComponent_logokreis_svg;
const int VASTLogoComponent::logokreis_svgSize = 3721;

// JUCER_RESOURCE: vaporizer2_svg, 14741, "../../Resources/vaporizer2.svg"
static const unsigned char resource_VASTLogoComponent_vaporizer2_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,
32,115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,
46,105,110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,
47,101,108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,
110,115,35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,
45,110,115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,
34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,
111,100,105,112,111,100,105,46,115,111,117,114,99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,
107,115,99,97,112,101,61,34,104,116,116,112,58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,
119,105,100,116,104,61,34,50,49,48,109,109,34,10,32,32,32,104,101,105,103,104,116,61,34,50,57,55,109,109,34,10,32,32,32,118,105,101,119,66,111,120,61,34,48,32,48,32,50,49,48,32,50,57,55,34,10,32,32,32,
118,101,114,115,105,111,110,61,34,49,46,49,34,10,32,32,32,105,100,61,34,115,118,103,51,57,48,55,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,51,32,40,
50,52,48,53,53,52,54,44,32,50,48,49,56,45,48,51,45,49,49,41,34,10,32,32,32,115,111,100,105,112,111,100,105,58,100,111,99,110,97,109,101,61,34,118,97,112,111,114,105,122,101,114,50,46,115,118,103,34,62,
10,32,32,60,100,101,102,115,10,32,32,32,32,32,105,100,61,34,100,101,102,115,51,57,48,49,34,32,47,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,105,101,119,10,32,32,32,32,32,
105,100,61,34,98,97,115,101,34,10,32,32,32,32,32,112,97,103,101,99,111,108,111,114,61,34,35,102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,111,114,61,34,35,54,54,54,54,
54,54,34,10,32,32,32,32,32,98,111,114,100,101,114,111,112,97,99,105,116,121,61,34,49,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,99,105,116,121,61,34,48,46,48,
34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,115,104,97,100,111,119,61,34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,61,34,55,46,57,49,57,53,57,54,
34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,120,61,34,52,49,49,46,50,55,57,56,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,54,53,52,46,52,57,55,51,49,34,10,32,32,
32,32,32,105,110,107,115,99,97,112,101,58,100,111,99,117,109,101,110,116,45,117,110,105,116,115,61,34,109,109,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,116,45,108,97,
121,101,114,61,34,108,97,121,101,114,49,34,10,32,32,32,32,32,115,104,111,119,103,114,105,100,61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,119,
105,100,116,104,61,34,54,53,56,51,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,104,101,105,103,104,116,61,34,51,53,49,54,34,10,32,32,32,32,32,105,110,107,115,99,97,
112,101,58,119,105,110,100,111,119,45,120,61,34,45,49,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,45,49,56,34,10,32,32,32,32,32,105,110,107,115,99,97,
112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,105,122,101,100,61,34,49,34,32,47,62,10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,51,57,
48,52,34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,10,32,32,32,32,32,32,60,99,99,58,87,111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,
32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,103,101,47,115,118,103,43,120,109,108,60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,
32,32,32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,117,114,99,101,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,
73,109,97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,105,116,108,101,32,47,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,114,100,102,58,82,68,70,62,
10,32,32,60,47,109,101,116,97,100,97,116,97,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,32,32,32,105,110,107,115,99,
97,112,101,58,103,114,111,117,112,109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,62,10,32,32,32,32,60,103,10,32,32,32,32,32,32,32,97,114,105,97,45,
108,97,98,101,108,61,34,86,65,80,79,82,73,90,69,82,50,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,
105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,49,48,46,53,56,51,51,51,51,48,50,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,46,50,53,59,102,111,110,
116,45,102,97,109,105,108,121,58,115,97,110,115,45,115,101,114,105,102,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,
59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,
50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,56,51,53,34,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,53,56,46,50,54,52,
57,57,44,49,51,53,46,52,55,51,48,50,32,113,32,45,48,46,48,56,52,54,55,44,45,48,46,49,55,57,57,49,32,45,48,46,48,56,52,54,55,44,45,48,46,51,55,48,52,49,32,48,44,45,48,46,52,48,50,49,55,32,48,46,51,52,57,
50,53,44,45,48,46,54,56,55,57,50,32,48,46,51,52,57,50,53,44,45,48,46,50,56,53,55,53,32,48,46,55,55,50,53,56,51,44,45,48,46,50,56,53,55,53,32,48,46,53,54,48,57,49,55,44,48,32,48,46,55,57,51,55,53,44,48,
46,52,56,54,56,51,32,108,32,50,46,51,49,55,55,53,44,52,46,56,52,55,49,55,32,113,32,48,46,50,49,49,54,54,55,44,48,46,52,52,52,53,32,48,46,53,55,49,53,44,48,46,52,52,52,53,32,48,46,51,51,56,54,54,55,44,
48,32,48,46,53,49,56,53,56,51,44,45,48,46,51,57,49,53,56,32,108,32,50,46,51,50,56,51,51,52,44,45,53,46,49,57,54,52,50,32,113,32,45,48,46,48,52,50,51,51,44,48,46,49,54,57,51,51,32,45,48,46,48,52,50,51,
51,44,48,46,51,50,56,48,56,32,48,44,48,46,54,55,55,51,52,32,48,46,54,49,51,56,51,52,44,48,46,57,53,50,53,32,48,46,50,49,49,54,54,54,44,48,46,48,57,53,50,32,48,46,52,50,51,51,51,51,44,48,46,48,57,53,50,
32,48,46,52,56,54,56,51,51,44,48,32,48,46,56,53,55,50,53,44,45,48,46,53,48,56,32,108,32,45,48,46,54,51,53,44,49,46,51,57,55,32,45,50,46,50,55,53,52,49,55,44,52,46,57,54,51,53,57,32,113,32,45,48,46,50,
51,50,56,51,51,44,48,46,53,48,56,32,45,48,46,55,48,57,48,56,51,44,48,46,55,56,51,49,54,32,45,48,46,52,55,54,50,53,44,48,46,50,54,52,53,57,32,45,49,46,48,51,55,49,54,55,44,48,46,50,54,52,53,57,32,45,48,
46,53,55,49,53,44,48,32,45,49,46,48,53,56,51,51,51,44,45,48,46,50,55,53,49,55,32,45,48,46,53,50,57,49,54,54,44,45,48,46,51,48,54,57,50,32,45,48,46,55,57,51,55,53,44,45,48,46,56,54,55,56,51,32,122,34,10,
32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,
110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,
115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,
99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,
45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,55,52,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,
32,55,53,46,52,50,52,49,50,56,44,49,52,49,46,50,53,49,53,50,32,113,32,48,46,48,56,52,54,55,44,48,46,49,55,57,57,50,32,48,46,48,56,52,54,55,44,48,46,51,53,57,56,52,32,48,44,48,46,52,49,50,55,53,32,45,48,
46,51,52,57,50,53,44,48,46,54,57,56,53,32,45,48,46,51,52,57,50,53,44,48,46,50,55,53,49,54,32,45,48,46,55,55,50,53,56,51,44,48,46,50,55,53,49,54,32,45,48,46,53,54,48,57,49,55,44,48,32,45,48,46,55,57,51,
55,53,44,45,48,46,52,55,54,50,53,32,108,32,45,50,46,51,49,55,55,53,44,45,52,46,56,52,55,49,54,32,113,32,45,48,46,50,49,49,54,54,55,44,45,48,46,52,52,52,53,32,45,48,46,53,56,50,48,56,52,44,45,48,46,52,
52,52,53,32,45,48,46,51,50,56,48,56,51,44,48,32,45,48,46,53,48,56,44,48,46,51,56,49,32,108,32,45,50,46,51,50,56,51,51,51,44,53,46,50,48,55,32,113,32,48,46,48,52,50,51,51,44,45,48,46,49,54,57,51,52,32,
48,46,48,52,50,51,51,44,45,48,46,51,50,56,48,57,32,48,44,45,48,46,54,56,55,57,49,32,45,48,46,54,49,51,56,51,51,44,45,48,46,57,54,51,48,56,32,45,48,46,50,49,49,54,54,55,44,45,48,46,48,57,53,51,32,45,48,
46,52,50,51,51,51,51,44,45,48,46,48,57,53,51,32,45,48,46,52,56,54,56,51,51,44,48,32,45,48,46,56,53,55,50,53,44,48,46,53,49,56,53,56,32,108,32,48,46,54,50,52,52,49,55,44,45,49,46,52,48,55,53,56,32,50,46,
50,56,53,57,57,57,44,45,52,46,57,53,51,32,113,32,48,46,50,51,50,56,51,52,44,45,48,46,53,48,56,32,48,46,55,48,57,48,56,52,44,45,48,46,55,56,51,49,55,32,48,46,52,55,54,50,53,44,45,48,46,50,55,53,49,54,32,
49,46,48,50,54,53,56,51,44,45,48,46,50,55,53,49,54,32,48,46,53,56,50,48,56,51,44,48,32,49,46,48,54,56,57,49,55,44,48,46,50,56,53,55,53,32,48,46,53,50,57,49,54,54,44,48,46,51,48,54,57,49,32,48,46,55,57,
51,55,53,44,48,46,56,53,55,50,53,32,122,32,109,32,45,53,46,53,52,53,54,54,54,44,45,49,46,54,52,48,52,49,32,113,32,48,44,45,48,46,51,55,48,52,50,32,48,46,50,52,51,52,49,54,44,45,48,46,54,51,53,32,48,46,
50,52,51,52,49,55,44,45,48,46,50,55,53,49,55,32,48,46,54,48,51,50,53,44,45,48,46,50,55,53,49,55,32,48,46,51,53,57,56,51,52,44,48,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,48,46,50,53,52,44,48,
46,50,54,52,53,56,32,48,46,50,53,52,44,48,46,54,51,53,32,48,44,48,46,51,53,57,56,51,32,45,48,46,50,53,52,44,48,46,54,51,53,32,45,48,46,50,52,51,52,49,54,44,48,46,50,55,53,49,54,32,45,48,46,54,48,51,50,
53,44,48,46,50,55,53,49,54,32,45,48,46,51,53,57,56,51,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,55,53,49,54,32,45,48,46,50,52,51,52,49,54,44,45,48,46,50,55,53,49,55,32,45,48,46,50,52,51,52,49,
54,44,45,48,46,54,51,53,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,
58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,
109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,115,104,105,39,59,
108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,105,108,108,58,35,
54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,55,54,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,
32,32,32,32,32,32,32,32,100,61,34,109,32,56,52,46,56,50,55,56,51,51,44,49,51,54,46,54,50,54,54,49,32,113,32,48,44,48,46,56,56,57,32,45,48,46,54,51,53,44,49,46,54,53,49,32,45,48,46,54,54,54,55,53,44,48,
46,56,48,52,51,51,32,45,49,46,53,50,52,44,48,46,56,48,52,51,51,32,104,32,45,51,46,56,52,49,55,53,32,113,32,45,48,46,50,54,52,53,56,51,44,48,32,45,48,46,52,55,54,50,53,44,45,48,46,51,48,54,57,50,32,45,
48,46,49,57,48,53,44,45,48,46,50,55,53,49,54,32,45,48,46,49,57,48,53,44,45,48,46,53,54,48,57,49,32,48,44,45,48,46,50,54,52,53,57,32,48,46,50,50,50,50,53,44,45,48,46,53,55,49,53,32,48,46,50,51,50,56,51,
51,44,45,48,46,51,48,54,57,50,32,48,46,52,57,55,52,49,55,44,45,48,46,51,48,54,57,50,32,104,32,51,46,56,51,49,49,54,54,32,113,32,48,46,50,48,49,48,56,52,44,48,32,48,46,52,48,50,49,54,55,44,45,48,46,50,
52,51,52,50,32,48,46,50,49,49,54,54,55,44,45,48,46,50,52,51,52,49,32,48,46,50,49,49,54,54,55,44,45,48,46,52,51,51,57,49,32,48,44,45,48,46,50,50,50,50,53,32,45,48,46,49,55,57,57,49,55,44,45,48,46,52,56,
54,56,52,32,45,48,46,49,55,57,57,49,55,44,45,48,46,50,55,53,49,54,32,45,48,46,51,57,49,53,56,51,44,45,48,46,50,55,53,49,54,32,104,32,45,53,46,53,52,53,54,54,55,32,113,32,48,46,55,55,50,53,56,52,44,45,
48,46,48,57,53,50,32,48,46,55,55,50,53,56,52,44,45,48,46,56,53,55,50,53,32,48,44,45,48,46,55,49,57,54,55,32,45,48,46,56,52,54,54,54,55,44,45,48,46,57,50,48,55,53,32,72,32,56,50,46,54,57,32,113,32,48,46,
57,57,52,56,51,51,44,48,32,49,46,53,56,55,53,44,48,46,55,55,50,53,56,32,48,46,53,53,48,51,51,51,44,48,46,55,49,57,54,55,32,48,46,53,53,48,51,51,51,44,49,46,55,51,53,54,55,32,122,32,109,32,45,56,46,53,
49,57,53,56,51,44,53,46,48,52,56,50,53,32,113,32,48,44,45,48,46,51,53,57,56,52,32,48,46,50,52,51,52,49,55,44,45,48,46,54,51,53,32,48,46,50,53,52,44,45,48,46,50,55,53,49,55,32,48,46,54,49,51,56,51,51,44,
45,48,46,50,55,53,49,55,32,48,46,51,53,57,56,51,51,44,48,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,48,46,50,52,51,52,49,55,44,48,46,50,55,53,49,54,32,48,46,50,52,51,52,49,55,44,48,46,54,51,53,
32,48,44,48,46,51,55,48,52,49,32,45,48,46,50,52,51,52,49,55,44,48,46,54,52,53,53,56,32,45,48,46,50,52,51,52,49,55,44,48,46,50,54,52,53,56,32,45,48,46,54,48,51,50,53,44,48,46,50,54,52,53,56,32,45,48,46,
51,53,57,56,51,51,44,48,32,45,48,46,54,49,51,56,51,51,44,45,48,46,50,54,52,53,56,32,45,48,46,50,52,51,52,49,55,44,45,48,46,50,55,53,49,55,32,45,48,46,50,52,51,52,49,55,44,45,48,46,54,52,53,53,56,32,122,
32,109,32,45,48,46,48,49,48,53,56,44,45,50,46,51,52,57,53,32,113,32,48,44,45,48,46,51,55,48,52,50,32,48,46,50,52,51,52,49,54,44,45,48,46,54,51,53,32,48,46,50,52,51,52,49,55,44,45,48,46,50,55,53,49,55,
32,48,46,54,48,51,50,53,44,45,48,46,50,55,53,49,55,32,48,46,51,53,57,56,51,52,44,48,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,48,46,50,53,52,44,48,46,50,54,52,53,56,32,48,46,50,53,52,44,48,46,
54,51,53,32,48,44,48,46,51,53,57,56,51,32,45,48,46,50,53,52,44,48,46,54,51,53,32,45,48,46,50,52,51,52,49,54,44,48,46,50,54,52,53,56,32,45,48,46,54,48,51,50,53,44,48,46,50,54,52,53,56,32,45,48,46,51,53,
57,56,51,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,50,52,51,52,49,54,44,45,48,46,50,55,53,49,55,32,45,48,46,50,52,51,52,49,54,44,45,48,46,54,51,53,32,122,32,109,32,48,
44,45,50,46,50,49,49,57,50,32,113,32,48,44,45,48,46,51,55,48,52,50,32,48,46,50,52,51,52,49,54,44,45,48,46,54,51,53,32,48,46,50,52,51,52,49,55,44,45,48,46,50,55,53,49,55,32,48,46,54,48,51,50,53,44,45,48,
46,50,55,53,49,55,32,48,46,51,53,57,56,51,52,44,48,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,48,46,50,53,52,44,48,46,50,54,52,53,56,32,48,46,50,53,52,44,48,46,54,51,53,32,48,44,48,46,51,53,57,
56,51,32,45,48,46,50,53,52,44,48,46,54,51,53,32,45,48,46,50,52,51,52,49,54,44,48,46,50,55,53,49,55,32,45,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,45,48,46,51,53,57,56,51,51,44,48,32,45,48,46,54,
48,51,50,53,44,45,48,46,50,55,53,49,55,32,45,48,46,50,52,51,52,49,54,44,45,48,46,50,55,53,49,55,32,45,48,46,50,52,51,52,49,54,44,45,48,46,54,51,53,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,
101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,
111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,
97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,
51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,
32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,55,56,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,57,49,46,53,56,48,52,49,51,44,49,52,48,
46,55,55,53,50,55,32,113,32,48,46,52,48,50,49,54,54,44,48,32,48,46,54,50,52,52,49,54,44,45,48,46,50,57,54,51,51,32,48,46,50,50,50,50,53,44,45,48,46,50,57,54,51,51,32,48,46,50,50,50,50,53,44,45,48,46,54,
57,56,53,32,108,32,48,46,48,49,48,53,56,44,45,50,46,57,57,53,48,56,32,113,32,48,44,45,48,46,54,55,55,51,52,32,45,48,46,54,54,54,55,53,44,45,48,46,56,53,55,50,53,32,45,48,46,50,49,49,54,54,55,44,45,48,
46,48,53,50,57,32,45,49,46,48,53,56,51,51,52,44,45,48,46,48,53,50,57,32,48,46,56,48,52,51,51,52,44,45,48,46,50,50,50,50,53,32,48,46,56,48,52,51,51,52,44,45,48,46,56,57,57,53,56,32,48,44,45,48,46,55,48,
57,48,57,32,45,48,46,55,53,49,52,49,55,44,45,48,46,56,53,55,50,53,32,104,32,48,46,56,53,55,50,53,32,113,32,49,46,51,54,53,50,53,44,48,46,48,49,48,54,32,49,46,57,56,57,54,54,55,44,48,46,55,53,49,52,49,
32,48,46,53,57,50,54,54,54,44,48,46,54,56,55,57,50,32,48,46,53,57,50,54,54,54,44,50,46,48,55,52,51,52,32,118,32,50,46,56,56,57,50,53,32,113,32,45,48,46,48,49,48,53,56,44,49,46,49,48,48,54,54,32,45,48,
46,54,50,52,52,49,54,44,49,46,56,56,51,56,51,32,45,48,46,54,54,54,55,53,44,48,46,56,54,55,56,51,32,45,49,46,55,50,53,48,56,52,44,48,46,56,54,55,56,51,32,104,32,45,52,46,48,56,53,49,54,54,32,113,32,45,
49,46,48,53,56,51,51,51,44,48,32,45,49,46,55,50,53,48,56,51,44,45,48,46,56,52,54,54,54,32,45,48,46,54,49,51,56,51,52,44,45,48,46,55,56,51,49,55,32,45,48,46,54,49,51,56,51,52,44,45,49,46,56,55,51,50,53,
32,118,32,45,50,46,56,56,57,50,53,32,113,32,48,44,45,50,46,56,53,55,53,32,50,46,53,55,49,55,53,44,45,50,46,56,52,54,57,50,32,104,32,48,46,57,49,48,49,54,55,32,113,32,45,48,46,55,57,51,55,53,44,48,46,49,
52,56,49,55,32,45,48,46,55,57,51,55,53,44,48,46,56,55,56,52,50,32,48,44,48,46,55,51,48,50,53,32,48,46,55,56,51,49,54,54,44,48,46,56,56,57,32,45,48,46,57,50,48,55,52,57,44,48,32,45,49,46,49,50,49,56,51,
51,44,48,46,48,53,50,57,32,45,48,46,53,56,50,48,56,51,44,48,46,49,54,57,51,52,32,45,48,46,53,56,50,48,56,51,44,48,46,56,54,55,56,52,32,108,32,48,46,48,49,48,53,56,44,50,46,57,57,53,48,56,32,113,32,48,
44,48,46,52,49,50,55,53,32,48,46,50,49,49,54,54,55,44,48,46,54,56,55,57,50,32,48,46,50,49,49,54,54,55,44,48,46,50,55,53,49,54,32,48,46,54,49,51,56,51,51,44,48,46,50,55,53,49,54,32,122,32,109,32,45,50,
46,53,56,50,51,51,52,44,45,53,46,55,52,54,55,53,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,52,51,52,49,55,44,45,48,46,54,50,52,52,49,32,48,46,50,53,52,44,45,48,46,50,55,53,49,55,32,48,46,54,48,
51,50,53,44,45,48,46,50,55,53,49,55,32,48,46,51,53,57,56,51,51,44,48,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,55,32,48,46,50,52,51,52,49,55,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,49,55,44,48,
46,54,50,52,52,49,32,48,44,48,46,51,53,57,56,52,32,45,48,46,50,52,51,52,49,55,44,48,46,54,51,53,32,45,48,46,50,52,51,52,49,55,44,48,46,50,54,52,53,57,32,45,48,46,54,48,51,50,53,44,48,46,50,54,52,53,57,
32,45,48,46,51,52,57,50,53,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,57,32,45,48,46,50,52,51,52,49,55,44,45,48,46,50,55,53,49,54,32,45,48,46,50,52,51,52,49,55,44,45,48,46,54,51,53,32,122,
34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,
102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,49,51,
95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,115,104,105,39,59,108,101,116,116,101,114,45,115,
112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,
108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,56,48,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,
34,109,32,49,48,48,46,49,52,48,55,54,44,49,51,56,46,57,57,55,50,55,32,104,32,49,46,53,53,53,55,53,32,113,32,48,46,49,52,56,49,55,44,48,32,48,46,52,51,51,57,50,44,45,48,46,49,49,54,52,49,32,48,46,54,50,
52,52,49,44,45,48,46,50,53,52,32,49,46,48,52,55,55,53,44,45,48,46,57,51,49,51,52,32,48,46,52,51,51,57,49,44,45,48,46,54,55,55,51,51,32,48,46,52,51,51,57,49,44,45,49,46,51,55,53,56,51,32,48,44,45,48,46,
57,49,48,49,55,32,45,48,46,54,54,54,55,53,44,45,49,46,54,55,50,49,55,32,45,48,46,54,54,54,55,53,44,45,48,46,55,55,50,53,56,32,45,49,46,53,52,53,49,54,44,45,48,46,55,55,50,53,56,32,45,48,46,48,49,48,54,
44,48,32,45,50,46,54,54,55,48,48,53,44,48,32,45,50,46,54,52,53,56,51,51,44,48,32,45,50,46,54,52,53,56,51,51,44,48,32,48,46,56,49,52,57,49,55,44,48,46,51,51,56,54,55,32,48,46,56,49,52,57,49,55,44,48,46,
56,50,53,53,32,48,44,48,46,55,52,48,56,51,32,45,48,46,55,54,50,44,48,46,56,57,57,53,56,32,104,32,53,46,52,50,57,50,53,49,32,113,32,48,46,50,54,52,53,56,44,48,32,48,46,52,51,51,57,50,44,48,46,50,54,52,
53,57,32,48,46,49,52,56,49,54,44,48,46,50,50,50,50,53,32,48,46,49,52,56,49,54,44,48,46,52,56,54,56,51,32,48,44,48,46,50,53,52,32,45,48,46,49,48,53,56,51,44,48,46,52,52,52,53,32,45,48,46,49,50,55,44,48,
46,50,51,50,56,51,32,45,48,46,51,53,57,56,51,44,48,46,50,51,50,56,51,32,104,32,45,51,46,57,50,54,52,50,49,32,113,32,45,48,46,51,52,57,50,53,44,48,32,45,48,46,53,51,57,55,53,44,48,46,50,53,52,32,45,48,
46,49,57,48,53,44,48,46,50,53,52,32,45,48,46,49,57,48,53,44,48,46,54,49,51,56,52,32,48,44,48,46,51,55,48,52,49,32,48,46,51,48,54,57,49,54,44,48,46,54,56,55,57,49,32,108,32,51,46,52,56,49,57,49,53,44,51,
46,52,56,49,57,50,32,113,32,48,46,50,54,52,53,57,44,48,46,50,54,52,53,56,32,48,46,55,53,49,52,50,44,48,46,50,54,52,53,56,32,48,46,51,51,56,54,55,44,48,32,48,46,53,57,50,54,55,44,45,48,46,49,55,57,57,49,
32,108,32,45,48,46,49,55,57,57,50,44,48,46,48,56,52,55,32,113,32,48,46,49,54,57,51,51,44,48,32,48,46,51,50,56,48,56,44,45,48,46,51,51,56,54,54,32,48,46,49,52,56,49,55,44,45,48,46,51,48,54,57,50,32,48,
46,49,52,56,49,55,44,45,48,46,53,49,56,53,57,32,48,44,45,48,46,51,50,56,48,56,32,45,48,46,49,52,56,49,55,44,45,48,46,52,54,53,54,54,32,122,32,109,32,45,52,46,56,50,54,48,48,49,44,50,46,53,57,50,57,50,
32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,52,51,52,49,55,44,45,48,46,54,50,52,52,50,32,48,46,50,52,51,52,49,54,44,45,48,46,50,54,52,53,56,32,48,46,53,57,50,54,54,54,44,45,48,46,50,54,52,53,56,
32,48,46,51,53,57,56,51,52,44,48,32,48,46,53,57,50,54,54,55,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,49,54,44,48,46,50,54,52,53,57,32,48,46,50,52,51,52,49,54,44,48,46,54,50,52,52,50,32,48,44,48,46,
51,53,57,56,51,32,45,48,46,50,52,51,52,49,54,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,51,44,48,46,50,54,52,53,56,32,45,48,46,53,57,50,54,54,55,44,48,46,50,54,52,53,56,32,45,48,46,51,52,57,50,
53,44,48,32,45,48,46,53,57,50,54,54,54,44,45,48,46,50,54,52,53,56,32,45,48,46,50,52,51,52,49,55,44,45,48,46,50,54,52,53,57,32,45,48,46,50,52,51,52,49,55,44,45,48,46,54,50,52,52,50,32,122,32,109,32,45,
48,46,48,49,48,53,56,44,45,50,46,51,48,55,49,55,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,51,50,56,51,51,44,45,48,46,54,50,52,52,49,32,48,46,50,52,51,52,49,55,44,45,48,46,50,55,53,49,55,32,48,
46,54,48,51,50,53,44,45,48,46,50,55,53,49,55,32,48,46,51,52,57,50,53,44,48,32,48,46,53,56,50,48,56,51,44,48,46,50,55,53,49,55,32,48,46,50,52,51,52,49,55,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,49,
55,44,48,46,54,50,52,52,49,32,48,44,48,46,51,52,57,50,53,32,45,48,46,50,52,51,52,49,55,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,51,44,48,46,50,54,52,53,56,32,45,48,46,53,56,50,48,56,51,44,48,
46,50,54,52,53,56,32,45,48,46,51,53,57,56,51,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,50,51,50,56,51,51,44,45,48,46,50,55,53,49,55,32,45,48,46,50,51,50,56,51,51,44,45,
48,46,54,50,52,52,50,32,122,32,109,32,48,44,45,50,46,49,54,57,53,56,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,51,50,56,51,51,44,45,48,46,54,50,52,52,50,32,48,46,50,52,51,52,49,55,44,45,48,46,
50,54,52,53,56,32,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,48,46,51,52,57,50,53,44,48,32,48,46,53,56,50,48,56,51,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,49,55,44,48,46,50,54,52,53,57,32,
48,46,50,52,51,52,49,55,44,48,46,54,50,52,52,50,32,48,44,48,46,51,53,57,56,51,32,45,48,46,50,52,51,52,49,55,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,51,44,48,46,50,54,52,53,56,32,45,48,46,53,
56,50,48,56,51,44,48,46,50,54,52,53,56,32,45,48,46,51,53,57,56,51,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,50,51,50,56,51,51,44,45,48,46,50,54,52,53,57,32,45,48,46,50,
51,50,56,51,51,44,45,48,46,54,50,52,52,50,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,
114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,
110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,
115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,
105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,56,50,34,32,47,62,10,32,32,32,32,32,32,60,112,
97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,48,52,46,51,50,57,56,54,44,49,51,52,46,49,49,56,51,54,32,104,32,54,46,53,55,50,50,53,32,113,32,48,46,51,57,49,53,56,44,48,32,48,46,54,50,52,
52,49,44,48,46,51,48,54,57,49,32,48,46,50,48,49,48,57,44,48,46,50,54,52,53,57,32,48,46,50,48,49,48,57,44,48,46,54,53,54,49,55,32,48,44,48,46,51,56,49,32,45,48,46,49,57,48,53,44,48,46,54,51,53,32,45,48,
46,50,50,50,50,53,44,48,46,50,56,53,55,53,32,45,48,46,53,57,50,54,55,44,48,46,50,56,53,55,53,32,104,32,45,49,46,55,56,56,53,56,32,118,32,52,46,54,57,57,32,104,32,50,46,52,56,55,48,56,32,113,32,45,48,46,
52,49,50,55,53,44,48,46,48,55,52,49,32,45,48,46,54,52,53,53,56,44,48,46,51,52,57,50,53,32,45,48,46,50,50,50,50,53,44,48,46,50,55,53,49,55,32,45,48,46,50,50,50,50,53,44,48,46,54,49,51,56,51,32,48,44,48,
46,51,50,56,48,57,32,48,46,50,48,49,48,56,44,48,46,53,55,49,53,32,48,46,50,51,50,56,51,44,48,46,50,55,53,49,55,32,48,46,54,51,53,44,48,46,51,52,57,50,53,32,104,32,45,54,46,53,55,50,50,53,32,113,32,45,
48,46,51,56,49,44,48,32,45,48,46,53,57,50,54,55,44,45,48,46,50,56,53,55,53,32,45,48,46,50,48,49,48,56,44,45,48,46,50,53,52,32,45,48,46,50,48,49,48,56,44,45,48,46,54,51,53,32,48,44,45,48,46,51,57,49,53,
56,32,48,46,50,50,50,50,53,44,45,48,46,54,55,55,51,51,32,48,46,50,50,50,50,53,44,45,48,46,50,56,53,55,53,32,48,46,54,48,51,50,53,44,45,48,46,50,56,53,55,53,32,104,32,50,46,50,48,49,51,51,32,118,32,45,
52,46,54,57,57,32,104,32,45,50,46,57,49,48,52,49,32,113,32,48,46,52,49,50,55,53,44,45,48,46,48,55,52,49,32,48,46,54,51,53,44,45,48,46,51,52,57,50,53,32,48,46,50,49,49,54,54,44,45,48,46,50,52,51,52,50,
32,48,46,50,49,49,54,54,44,45,48,46,53,55,49,53,32,48,44,45,48,46,51,50,56,48,56,32,45,48,46,50,51,50,56,51,44,45,48,46,54,48,51,50,53,32,45,48,46,50,51,50,56,51,44,45,48,46,50,56,53,55,53,32,45,48,46,
54,52,53,53,56,44,45,48,46,51,53,57,56,51,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,
114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,
110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,
115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,
105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,56,52,34,32,47,62,10,32,32,32,32,32,32,60,112,
97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,50,48,46,48,53,49,51,49,44,49,52,50,46,53,57,53,54,49,32,113,32,48,46,52,49,50,55,53,44,48,32,48,46,54,53,54,49,55,44,45,48,46,50,53,52,32,
48,46,50,52,51,52,50,44,45,48,46,50,54,52,53,57,32,48,46,50,52,51,52,50,44,45,48,46,54,53,54,49,55,32,48,44,45,48,46,51,57,49,53,56,32,45,48,46,50,52,51,52,50,44,45,48,46,54,50,52,52,50,32,45,48,46,50,
51,50,56,51,44,45,48,46,50,52,51,52,49,32,45,48,46,54,53,54,49,55,44,45,48,46,50,52,51,52,49,32,108,32,45,52,46,52,51,52,52,49,44,48,46,48,49,48,54,32,113,32,45,48,46,53,48,56,44,48,32,45,48,46,53,48,
56,44,45,48,46,51,48,54,57,50,32,48,44,45,48,46,50,52,51,52,49,32,48,46,51,49,55,53,44,45,48,46,52,56,54,56,51,32,108,32,53,46,49,54,52,54,54,44,45,51,46,56,56,52,48,56,32,113,32,48,46,51,51,56,54,55,
44,45,48,46,50,57,54,51,52,32,48,46,51,51,56,54,55,44,45,48,46,55,49,57,54,55,32,48,44,45,48,46,51,50,56,48,56,32,45,48,46,50,50,50,50,53,44,45,48,46,54,49,51,56,51,32,45,48,46,50,56,53,55,53,44,45,48,
46,51,56,49,32,45,48,46,55,49,57,54,55,44,45,48,46,51,56,49,32,45,48,46,51,49,55,53,44,48,32,45,48,46,54,49,51,56,51,44,48,46,50,50,50,50,53,32,108,32,45,54,46,49,53,57,53,44,52,46,53,50,57,54,54,32,113,
32,45,48,46,54,56,55,57,50,44,48,46,53,48,56,32,45,48,46,54,56,55,57,50,44,49,46,52,49,56,49,55,32,48,44,48,46,55,55,50,53,56,32,48,46,52,56,54,56,52,44,49,46,51,53,52,54,55,32,48,46,53,50,57,49,54,44,
48,46,54,50,52,52,49,32,49,46,51,49,50,51,51,44,48,46,54,50,52,52,49,32,122,32,109,32,45,52,46,50,49,50,49,54,44,45,54,46,55,57,52,53,32,113,32,45,48,46,51,52,57,50,53,44,48,32,45,48,46,54,50,52,52,50,
44,45,48,46,50,52,51,52,50,32,45,48,46,50,54,52,53,56,44,45,48,46,50,52,51,52,50,32,45,48,46,50,54,52,53,56,44,45,48,46,53,57,50,54,55,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,54,52,53,56,44,45,48,
46,53,57,50,54,54,32,48,46,50,55,53,49,55,44,45,48,46,50,52,51,52,50,32,48,46,54,50,52,52,50,44,45,48,46,50,52,51,52,50,32,48,46,51,53,57,56,51,44,48,32,48,46,54,50,52,52,49,44,48,46,50,52,51,52,50,32,
48,46,50,55,53,49,55,44,48,46,50,51,50,56,51,32,48,46,50,55,53,49,55,44,48,46,53,57,50,54,54,32,48,44,48,46,51,52,57,50,53,32,45,48,46,50,55,53,49,55,44,48,46,53,57,50,54,55,32,45,48,46,50,54,52,53,56,
44,48,46,50,52,51,52,50,32,45,48,46,54,50,52,52,49,44,48,46,50,52,51,52,50,32,122,32,109,32,45,50,46,52,52,52,55,53,44,48,32,113,32,45,48,46,51,52,57,50,53,44,48,32,45,48,46,54,50,52,52,50,44,45,48,46,
50,51,50,56,52,32,45,48,46,50,54,52,53,56,44,45,48,46,50,52,51,52,49,32,45,48,46,50,54,52,53,56,44,45,48,46,54,48,51,50,53,32,48,44,45,48,46,51,52,57,50,53,32,48,46,50,54,52,53,56,44,45,48,46,53,57,50,
54,54,32,48,46,50,55,53,49,55,44,45,48,46,50,52,51,52,50,32,48,46,54,50,52,52,50,44,45,48,46,50,52,51,52,50,32,48,46,51,53,57,56,51,44,48,32,48,46,54,50,52,52,49,44,48,46,50,52,51,52,50,32,48,46,50,55,
53,49,55,44,48,46,50,52,51,52,49,32,48,46,50,55,53,49,55,44,48,46,53,57,50,54,54,32,48,44,48,46,51,53,57,56,52,32,45,48,46,50,55,53,49,55,44,48,46,54,48,51,50,53,32,45,48,46,50,54,52,53,56,44,48,46,50,
51,50,56,52,32,45,48,46,54,50,52,52,49,44,48,46,50,51,50,56,52,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,
111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,
109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,
58,39,49,51,95,82,111,115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,
53,56,51,51,50,59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,56,54,34,32,47,62,10,32,
32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,50,55,46,53,52,55,55,49,44,49,51,52,46,49,49,56,51,54,32,113,32,48,46,51,52,57,50,53,44,48,32,48,46,53,53,48,51,51,44,
48,46,50,54,52,53,56,32,48,46,50,49,49,54,55,44,48,46,50,53,52,32,48,46,50,49,49,54,55,44,48,46,54,49,51,56,51,32,48,44,48,46,51,55,48,52,50,32,45,48,46,50,49,49,54,55,44,48,46,54,50,52,52,50,32,45,48,
46,50,50,50,50,53,44,48,46,50,56,53,55,53,32,45,48,46,53,56,50,48,56,44,48,46,50,56,53,55,53,32,108,32,45,51,46,50,52,57,48,57,44,45,48,46,48,49,48,54,32,113,32,45,48,46,52,48,50,49,54,44,48,32,45,48,
46,54,51,53,44,48,46,51,51,56,54,54,32,45,48,46,50,49,49,54,54,44,48,46,50,57,54,51,52,32,45,48,46,50,49,49,54,54,44,48,46,55,49,57,54,55,32,118,32,50,46,56,56,57,50,53,32,113,32,48,44,48,46,51,56,49,
32,48,46,50,50,50,50,53,44,48,46,54,53,54,49,55,32,48,46,50,50,50,50,53,44,48,46,50,55,53,49,54,32,48,46,54,48,51,50,53,44,48,46,50,55,53,49,54,32,104,32,50,46,57,55,51,57,49,32,113,32,45,48,46,56,51,
54,48,56,44,48,46,49,53,56,55,53,32,45,48,46,56,51,54,48,56,44,48,46,57,51,49,51,52,32,48,44,48,46,55,49,57,54,54,32,48,46,56,48,52,51,51,44,48,46,56,55,56,52,49,32,104,32,45,50,46,57,49,48,52,49,32,113,
32,45,50,46,54,51,53,50,53,44,48,32,45,50,46,54,51,53,50,53,44,45,50,46,56,52,54,57,49,32,118,32,45,50,46,56,57,57,56,52,32,113,32,48,44,45,49,46,48,57,48,48,56,32,48,46,54,49,51,56,51,44,45,49,46,56,
55,51,50,53,32,48,46,54,54,54,55,53,44,45,48,46,56,52,54,54,54,32,49,46,55,51,53,54,55,44,45,48,46,56,52,54,54,54,32,122,32,109,32,45,51,46,51,51,51,55,53,44,52,46,50,55,53,54,54,32,113,32,48,44,45,48,
46,51,53,57,56,51,32,48,46,50,52,51,52,49,44,45,48,46,54,51,53,32,48,46,50,52,51,52,50,44,45,48,46,50,55,53,49,54,32,48,46,54,48,51,50,53,44,45,48,46,50,55,53,49,54,32,48,46,51,53,57,56,52,44,48,32,48,
46,54,48,51,50,53,44,48,46,50,55,53,49,54,32,48,46,50,52,51,52,50,44,48,46,50,55,53,49,55,32,48,46,50,52,51,52,50,44,48,46,54,51,53,32,48,44,48,46,51,53,57,56,52,32,45,48,46,50,52,51,52,50,44,48,46,54,
51,53,32,45,48,46,50,52,51,52,49,44,48,46,50,54,52,53,57,32,45,48,46,54,48,51,50,53,44,48,46,50,54,52,53,57,32,45,48,46,51,53,57,56,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,57,32,45,
48,46,50,52,51,52,49,44,45,48,46,50,55,53,49,54,32,45,48,46,50,52,51,52,49,44,45,48,46,54,51,53,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,
58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,116,
114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,102,97,109,105,108,121,58,39,49,51,95,82,111,115,104,105,39,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,
105,102,105,99,97,116,105,111,110,58,39,49,51,95,82,111,115,104,105,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,119,
105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,59,102,105,108,108,58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,
116,104,56,56,56,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,32,32,100,61,34,109,32,49,51,52,46,54,54,52,55,53,44,49,51,56,46,57,57,55,50,55,32,104,32,49,46,53,53,53,55,
53,32,113,32,48,46,49,52,56,49,55,44,48,32,48,46,52,51,51,57,50,44,45,48,46,49,49,54,52,49,32,48,46,54,50,52,52,49,44,45,48,46,50,53,52,32,49,46,48,52,55,55,53,44,45,48,46,57,51,49,51,52,32,48,46,52,51,
51,57,49,44,45,48,46,54,55,55,51,51,32,48,46,52,51,51,57,49,44,45,49,46,51,55,53,56,51,32,48,44,45,48,46,57,49,48,49,55,32,45,48,46,54,54,54,55,53,44,45,49,46,54,55,50,49,55,32,45,48,46,54,54,54,55,53,
44,45,48,46,55,55,50,53,56,32,45,49,46,53,52,53,49,54,44,45,48,46,55,55,50,53,56,32,45,48,46,48,49,48,54,44,48,32,45,50,46,54,54,55,44,48,32,45,50,46,54,52,53,56,52,44,48,32,45,50,46,54,52,53,56,52,44,
48,32,48,46,56,49,52,57,50,44,48,46,51,51,56,54,55,32,48,46,56,49,52,57,50,44,48,46,56,50,53,53,32,48,44,48,46,55,52,48,56,51,32,45,48,46,55,54,50,44,48,46,56,57,57,53,56,32,104,32,53,46,52,50,57,50,53,
32,113,32,48,46,50,54,52,53,56,44,48,32,48,46,52,51,51,57,50,44,48,46,50,54,52,53,57,32,48,46,49,52,56,49,54,44,48,46,50,50,50,50,53,32,48,46,49,52,56,49,54,44,48,46,52,56,54,56,51,32,48,44,48,46,50,53,
52,32,45,48,46,49,48,53,56,51,44,48,46,52,52,52,53,32,45,48,46,49,50,55,44,48,46,50,51,50,56,51,32,45,48,46,51,53,57,56,51,44,48,46,50,51,50,56,51,32,104,32,45,51,46,57,50,54,52,50,32,113,32,45,48,46,
51,52,57,50,53,44,48,32,45,48,46,53,51,57,55,53,44,48,46,50,53,52,32,45,48,46,49,57,48,53,44,48,46,50,53,52,32,45,48,46,49,57,48,53,44,48,46,54,49,51,56,52,32,48,44,48,46,51,55,48,52,49,32,48,46,51,48,
54,57,50,44,48,46,54,56,55,57,49,32,108,32,51,46,52,56,49,57,49,44,51,46,52,56,49,57,50,32,113,32,48,46,50,54,52,53,57,44,48,46,50,54,52,53,56,32,48,46,55,53,49,52,50,44,48,46,50,54,52,53,56,32,48,46,
51,51,56,54,55,44,48,32,48,46,53,57,50,54,55,44,45,48,46,49,55,57,57,49,32,108,32,45,48,46,49,55,57,57,50,44,48,46,48,56,52,55,32,113,32,48,46,49,54,57,51,51,44,48,32,48,46,51,50,56,48,56,44,45,48,46,
51,51,56,54,54,32,48,46,49,52,56,49,55,44,45,48,46,51,48,54,57,50,32,48,46,49,52,56,49,55,44,45,48,46,53,49,56,53,57,32,48,44,45,48,46,51,50,56,48,56,32,45,48,46,49,52,56,49,55,44,45,48,46,52,54,53,54,
54,32,122,32,109,32,45,52,46,56,50,54,44,50,46,53,57,50,57,50,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,52,51,52,50,44,45,48,46,54,50,52,52,50,32,48,46,50,52,51,52,49,44,45,48,46,50,54,52,53,
56,32,48,46,53,57,50,54,54,44,45,48,46,50,54,52,53,56,32,48,46,51,53,57,56,52,44,48,32,48,46,53,57,50,54,55,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,50,44,48,46,50,54,52,53,57,32,48,46,50,52,51,52,
50,44,48,46,54,50,52,52,50,32,48,44,48,46,51,53,57,56,51,32,45,48,46,50,52,51,52,50,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,44,48,46,50,54,52,53,56,32,45,48,46,53,57,50,54,55,44,48,46,50,54,
52,53,56,32,45,48,46,51,52,57,50,53,44,48,32,45,48,46,53,57,50,54,54,44,45,48,46,50,54,52,53,56,32,45,48,46,50,52,51,52,50,44,45,48,46,50,54,52,53,57,32,45,48,46,50,52,51,52,50,44,45,48,46,54,50,52,52,
50,32,122,32,109,32,45,48,46,48,49,48,54,44,45,50,46,51,48,55,49,55,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,51,50,56,51,44,45,48,46,54,50,52,52,49,32,48,46,50,52,51,52,50,44,45,48,46,50,55,
53,49,55,32,48,46,54,48,51,50,53,44,45,48,46,50,55,53,49,55,32,48,46,51,52,57,50,53,44,48,32,48,46,53,56,50,48,56,44,48,46,50,55,53,49,55,32,48,46,50,52,51,52,50,44,48,46,50,54,52,53,56,32,48,46,50,52,
51,52,50,44,48,46,54,50,52,52,49,32,48,44,48,46,51,52,57,50,53,32,45,48,46,50,52,51,52,50,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,44,48,46,50,54,52,53,56,32,45,48,46,53,56,50,48,56,44,48,46,
50,54,52,53,56,32,45,48,46,51,53,57,56,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,50,51,50,56,51,44,45,48,46,50,55,53,49,55,32,45,48,46,50,51,50,56,51,44,45,48,46,54,50,
52,52,50,32,122,32,109,32,48,44,45,50,46,49,54,57,53,56,32,113,32,48,44,45,48,46,51,53,57,56,51,32,48,46,50,51,50,56,51,44,45,48,46,54,50,52,52,50,32,48,46,50,52,51,52,50,44,45,48,46,50,54,52,53,56,32,
48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,48,46,51,52,57,50,53,44,48,32,48,46,53,56,50,48,56,44,48,46,50,54,52,53,56,32,48,46,50,52,51,52,50,44,48,46,50,54,52,53,57,32,48,46,50,52,51,52,50,44,
48,46,54,50,52,52,50,32,48,44,48,46,51,53,57,56,51,32,45,48,46,50,52,51,52,50,44,48,46,54,50,52,52,50,32,45,48,46,50,51,50,56,51,44,48,46,50,54,52,53,56,32,45,48,46,53,56,50,48,56,44,48,46,50,54,52,53,
56,32,45,48,46,51,53,57,56,51,44,48,32,45,48,46,54,48,51,50,53,44,45,48,46,50,54,52,53,56,32,45,48,46,50,51,50,56,51,44,45,48,46,50,54,52,53,57,32,45,48,46,50,51,50,56,51,44,45,48,46,54,50,52,52,50,32,
122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,46,50,55,50,53,50,48,56,52,112,120,59,102,105,108,108,58,35,54,50,97,52,56,55,
59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,57,48,34,32,47,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,32,32,32,32,
32,32,100,61,34,109,32,49,51,57,46,53,50,49,52,44,49,51,55,46,53,56,53,48,50,32,104,32,51,46,54,55,52,53,52,32,118,32,45,48,46,56,56,48,53,51,32,104,32,45,50,46,50,57,52,52,55,32,118,32,45,48,46,48,49,
54,57,32,113,32,48,46,53,55,53,55,51,44,45,48,46,52,51,49,56,32,48,46,57,56,50,49,51,44,45,48,46,55,56,55,52,32,48,46,52,48,54,52,44,45,48,46,51,54,52,48,55,32,48,46,55,48,50,55,52,44,45,48,46,55,50,56,
49,52,32,48,46,50,57,54,51,51,44,45,48,46,51,55,50,53,51,32,48,46,52,53,55,50,44,45,48,46,55,53,51,53,51,32,48,46,49,54,48,56,54,44,45,48,46,51,56,57,52,55,32,48,46,49,54,48,56,54,44,45,48,46,56,48,52,
51,51,32,48,44,45,48,46,56,54,51,54,32,45,48,46,53,54,55,50,54,44,45,49,46,51,55,49,54,32,45,48,46,53,54,55,50,55,44,45,48,46,53,49,54,52,55,32,45,49,46,52,53,54,50,55,44,45,48,46,53,49,54,52,55,32,45,
48,46,53,54,55,50,55,44,48,32,45,48,46,57,57,57,48,55,44,48,46,49,56,54,50,55,32,45,48,46,52,51,49,56,44,48,46,49,56,54,50,54,32,45,48,46,56,56,57,44,48,46,53,57,50,54,54,32,108,32,48,46,53,54,55,50,55,
44,48,46,54,54,48,52,32,113,32,48,46,51,54,52,48,55,44,45,48,46,51,49,51,50,54,32,48,46,54,49,56,48,55,44,45,48,46,52,51,49,56,32,48,46,50,54,50,52,54,44,45,48,46,49,50,55,32,48,46,53,51,51,52,44,45,48,
46,49,50,55,32,48,46,52,55,52,49,51,44,48,32,48,46,55,54,50,44,48,46,50,56,55,56,55,32,48,46,50,57,54,51,51,44,48,46,50,56,55,56,55,32,48,46,50,57,54,51,51,44,48,46,55,55,48,52,55,32,48,44,48,46,50,57,
54,51,51,32,45,48,46,48,57,51,49,44,48,46,53,53,48,51,51,32,45,48,46,48,57,51,49,44,48,46,50,52,53,53,51,32,45,48,46,51,56,49,44,48,46,53,56,52,50,32,45,48,46,50,55,57,52,44,48,46,51,51,56,54,55,32,45,
48,46,56,50,49,50,55,44,48,46,56,50,57,55,51,32,45,48,46,53,52,49,56,55,44,48,46,52,57,49,48,55,32,45,49,46,52,57,48,49,51,44,49,46,50,55,56,52,55,32,122,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,
101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,98,
111,108,100,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,56,46,52,54,54,54,54,54,50,50,112,120,59,102,111,110,116,45,102,97,109,105,
108,121,58,83,121,110,116,97,120,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,83,121,110,116,97,120,32,66,111,108,100,39,59,108,101,
116,116,101,114,45,115,112,97,99,105,110,103,58,45,49,46,51,50,50,57,49,54,54,51,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,45,49,46,48,53,56,51,51,51,50,56,112,120,59,102,105,108,108,
58,35,54,50,97,52,56,55,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,112,97,116,104,56,57,50,34,32,47,62,10,32,32,32,32,60,47,103,62,10,32,32,32,
32,60,116,101,120,116,10,32,32,32,32,32,32,32,120,109,108,58,115,112,97,99,101,61,34,112,114,101,115,101,114,118,101,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,
108,101,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,49,48,46,53,56,51,51,51,51,48,50,112,120,59,108,105,110,
101,45,104,101,105,103,104,116,58,49,46,50,53,59,102,111,110,116,45,102,97,109,105,108,121,58,115,97,110,115,45,115,101,114,105,102,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,
59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,102,105,108,108,58,35,48,48,48,48,48,48,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,
101,59,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,10,32,32,32,32,32,32,32,120,61,34,49,49,53,46,51,57,51,54,50,34,10,32,32,32,32,32,32,32,121,61,34,49,50,54,46,
56,52,57,53,52,34,10,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,56,52,51,34,62,60,116,115,112,97,110,10,32,32,32,32,32,32,32,32,32,115,111,100,105,112,111,100,105,58,114,111,108,101,61,34,108,
105,110,101,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,116,115,112,97,110,56,52,49,34,10,32,32,32,32,32,32,32,32,32,120,61,34,49,49,53,46,51,57,51,54,50,34,10,32,32,32,32,32,32,32,32,32,121,61,34,
49,51,54,46,53,48,53,48,52,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,34,32,47,62,60,47,116,101,120,116,
62,10,32,32,60,47,103,62,10,60,47,115,118,103,62,10,0,0};

const char* VASTLogoComponent::vaporizer2_svg = (const char*) resource_VASTLogoComponent_vaporizer2_svg;
const int VASTLogoComponent::vaporizer2_svgSize = 14741;

// JUCER_RESOURCE: vast_svg, 4982, "../../Resources/vast.svg"
static const unsigned char resource_VASTLogoComponent_vast_svg[] = { 60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,115,
116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,45,45,32,67,114,101,97,116,101,100,32,119,105,116,104,32,73,110,107,115,99,97,112,101,32,40,104,116,116,112,58,47,47,119,119,119,46,105,
110,107,115,99,97,112,101,46,111,114,103,47,41,32,45,45,62,10,10,60,115,118,103,10,32,32,32,120,109,108,110,115,58,100,99,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,101,
108,101,109,101,110,116,115,47,49,46,49,47,34,10,32,32,32,120,109,108,110,115,58,99,99,61,34,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,110,115,
35,34,10,32,32,32,120,109,108,110,115,58,114,100,102,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,102,45,115,121,110,116,97,120,45,110,
115,35,34,10,32,32,32,120,109,108,110,115,58,115,118,103,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,61,34,104,
116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,32,32,32,120,109,108,110,115,58,120,108,105,110,107,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,
111,114,103,47,49,57,57,57,47,120,108,105,110,107,34,10,32,32,32,120,109,108,110,115,58,115,111,100,105,112,111,100,105,61,34,104,116,116,112,58,47,47,115,111,100,105,112,111,100,105,46,115,111,117,114,
99,101,102,111,114,103,101,46,110,101,116,47,68,84,68,47,115,111,100,105,112,111,100,105,45,48,46,100,116,100,34,10,32,32,32,120,109,108,110,115,58,105,110,107,115,99,97,112,101,61,34,104,116,116,112,
58,47,47,119,119,119,46,105,110,107,115,99,97,112,101,46,111,114,103,47,110,97,109,101,115,112,97,99,101,115,47,105,110,107,115,99,97,112,101,34,10,32,32,32,119,105,100,116,104,61,34,50,49,48,109,109,
34,10,32,32,32,104,101,105,103,104,116,61,34,50,57,55,109,109,34,10,32,32,32,118,105,101,119,66,111,120,61,34,48,32,48,32,50,49,48,32,50,57,55,34,10,32,32,32,118,101,114,115,105,111,110,61,34,49,46,49,
34,10,32,32,32,105,100,61,34,115,118,103,56,34,10,32,32,32,105,110,107,115,99,97,112,101,58,118,101,114,115,105,111,110,61,34,48,46,57,50,46,49,32,114,49,53,51,55,49,34,10,32,32,32,115,111,100,105,112,
111,100,105,58,100,111,99,110,97,109,101,61,34,118,97,115,116,46,115,118,103,34,62,10,32,32,60,100,101,102,115,10,32,32,32,32,32,105,100,61,34,100,101,102,115,50,34,62,10,32,32,32,32,60,108,105,110,101,
97,114,71,114,97,100,105,101,110,116,10,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,101,99,116,61,34,97,108,119,97,121,115,34,10,32,32,32,32,32,32,32,105,100,61,34,108,105,110,
101,97,114,71,114,97,100,105,101,110,116,52,57,48,52,34,62,10,32,32,32,32,32,32,60,115,116,111,112,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,115,116,111,112,45,99,111,108,111,114,58,35,99,
50,99,50,99,50,59,115,116,111,112,45,111,112,97,99,105,116,121,58,49,34,10,32,32,32,32,32,32,32,32,32,111,102,102,115,101,116,61,34,48,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,115,116,111,112,52,
57,48,48,34,32,47,62,10,32,32,32,32,32,32,60,115,116,111,112,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,115,116,111,112,45,99,111,108,111,114,58,35,99,50,99,50,99,50,59,115,116,111,112,45,
111,112,97,99,105,116,121,58,48,59,34,10,32,32,32,32,32,32,32,32,32,111,102,102,115,101,116,61,34,49,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,115,116,111,112,52,57,48,50,34,32,47,62,10,32,32,32,
32,60,47,108,105,110,101,97,114,71,114,97,100,105,101,110,116,62,10,32,32,32,32,60,102,105,108,116,101,114,10,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,101,99,116,61,34,97,108,
119,97,121,115,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,99,111,108,111,114,45,105,110,116,101,114,112,111,108,97,116,105,111,110,45,102,105,108,116,101,114,115,58,115,82,71,66,34,10,32,32,
32,32,32,32,32,105,100,61,34,102,105,108,116,101,114,52,56,56,50,34,10,32,32,32,32,32,32,32,120,61,34,45,48,46,48,48,56,50,49,55,57,54,51,49,34,10,32,32,32,32,32,32,32,119,105,100,116,104,61,34,49,46,
48,49,54,52,51,53,57,34,10,32,32,32,32,32,32,32,121,61,34,45,48,46,48,50,53,51,51,51,56,51,57,34,10,32,32,32,32,32,32,32,104,101,105,103,104,116,61,34,49,46,48,53,48,54,54,55,55,34,62,10,32,32,32,32,32,
32,60,102,101,71,97,117,115,115,105,97,110,66,108,117,114,10,32,32,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,101,99,116,61,34,97,108,119,97,121,115,34,10,32,32,32,32,32,32,32,
32,32,115,116,100,68,101,118,105,97,116,105,111,110,61,34,48,46,52,48,52,48,48,55,52,57,34,10,32,32,32,32,32,32,32,32,32,105,100,61,34,102,101,71,97,117,115,115,105,97,110,66,108,117,114,52,56,56,52,34,
32,47,62,10,32,32,32,32,60,47,102,105,108,116,101,114,62,10,32,32,32,32,60,108,105,110,101,97,114,71,114,97,100,105,101,110,116,10,32,32,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,111,108,108,
101,99,116,61,34,97,108,119,97,121,115,34,10,32,32,32,32,32,32,32,120,108,105,110,107,58,104,114,101,102,61,34,35,108,105,110,101,97,114,71,114,97,100,105,101,110,116,52,57,48,52,34,10,32,32,32,32,32,
32,32,105,100,61,34,108,105,110,101,97,114,71,114,97,100,105,101,110,116,52,57,49,52,34,10,32,32,32,32,32,32,32,120,49,61,34,50,54,46,50,50,53,55,54,57,34,10,32,32,32,32,32,32,32,121,49,61,34,49,51,48,
46,54,51,54,51,50,34,10,32,32,32,32,32,32,32,120,50,61,34,49,53,49,46,56,50,50,50,55,34,10,32,32,32,32,32,32,32,121,50,61,34,49,53,50,46,48,55,53,56,56,34,10,32,32,32,32,32,32,32,103,114,97,100,105,101,
110,116,85,110,105,116,115,61,34,117,115,101,114,83,112,97,99,101,79,110,85,115,101,34,32,47,62,10,32,32,60,47,100,101,102,115,62,10,32,32,60,115,111,100,105,112,111,100,105,58,110,97,109,101,100,118,
105,101,119,10,32,32,32,32,32,105,100,61,34,98,97,115,101,34,10,32,32,32,32,32,112,97,103,101,99,111,108,111,114,61,34,35,102,102,102,102,102,102,34,10,32,32,32,32,32,98,111,114,100,101,114,99,111,108,
111,114,61,34,35,54,54,54,54,54,54,34,10,32,32,32,32,32,98,111,114,100,101,114,111,112,97,99,105,116,121,61,34,49,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,111,112,97,
99,105,116,121,61,34,48,46,48,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,112,97,103,101,115,104,97,100,111,119,61,34,50,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,122,111,111,109,
61,34,49,46,52,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,120,61,34,49,50,54,46,57,50,57,56,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,121,61,34,53,57,52,46,55,56,51,54,
57,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,100,111,99,117,109,101,110,116,45,117,110,105,116,115,61,34,109,109,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,99,117,114,114,101,110,
116,45,108,97,121,101,114,61,34,108,97,121,101,114,49,34,10,32,32,32,32,32,115,104,111,119,103,114,105,100,61,34,102,97,108,115,101,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,
111,119,45,119,105,100,116,104,61,34,49,52,54,51,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,104,101,105,103,104,116,61,34,55,55,48,34,10,32,32,32,32,32,105,110,107,
115,99,97,112,101,58,119,105,110,100,111,119,45,120,61,34,45,56,34,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,119,105,110,100,111,119,45,121,61,34,54,48,34,10,32,32,32,32,32,105,110,107,115,99,
97,112,101,58,119,105,110,100,111,119,45,109,97,120,105,109,105,122,101,100,61,34,49,34,32,47,62,10,32,32,60,109,101,116,97,100,97,116,97,10,32,32,32,32,32,105,100,61,34,109,101,116,97,100,97,116,97,53,
34,62,10,32,32,32,32,60,114,100,102,58,82,68,70,62,10,32,32,32,32,32,32,60,99,99,58,87,111,114,107,10,32,32,32,32,32,32,32,32,32,114,100,102,58,97,98,111,117,116,61,34,34,62,10,32,32,32,32,32,32,32,32,
60,100,99,58,102,111,114,109,97,116,62,105,109,97,103,101,47,115,118,103,43,120,109,108,60,47,100,99,58,102,111,114,109,97,116,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,121,112,101,10,32,32,32,32,
32,32,32,32,32,32,32,114,100,102,58,114,101,115,111,117,114,99,101,61,34,104,116,116,112,58,47,47,112,117,114,108,46,111,114,103,47,100,99,47,100,99,109,105,116,121,112,101,47,83,116,105,108,108,73,109,
97,103,101,34,32,47,62,10,32,32,32,32,32,32,32,32,60,100,99,58,116,105,116,108,101,62,60,47,100,99,58,116,105,116,108,101,62,10,32,32,32,32,32,32,60,47,99,99,58,87,111,114,107,62,10,32,32,32,32,60,47,
114,100,102,58,82,68,70,62,10,32,32,60,47,109,101,116,97,100,97,116,97,62,10,32,32,60,103,10,32,32,32,32,32,105,110,107,115,99,97,112,101,58,108,97,98,101,108,61,34,69,98,101,110,101,32,49,34,10,32,32,
32,32,32,105,110,107,115,99,97,112,101,58,103,114,111,117,112,109,111,100,101,61,34,108,97,121,101,114,34,10,32,32,32,32,32,105,100,61,34,108,97,121,101,114,49,34,62,10,32,32,32,32,60,103,10,32,32,32,
32,32,32,32,97,114,105,97,45,108,97,98,101,108,61,34,86,65,83,84,34,10,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,
45,119,101,105,103,104,116,58,110,111,114,109,97,108,59,102,111,110,116,45,115,105,122,101,58,49,48,46,53,56,51,51,51,51,48,50,112,120,59,108,105,110,101,45,104,101,105,103,104,116,58,49,50,53,37,59,102,
111,110,116,45,102,97,109,105,108,121,58,83,97,110,115,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,48,112,120,59,119,111,114,100,45,115,112,97,99,105,110,103,58,48,112,120,59,102,105,108,
108,58,117,114,108,40,35,108,105,110,101,97,114,71,114,97,100,105,101,110,116,52,57,49,52,41,59,102,105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,59,115,
116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,112,120,59,115,116,114,111,107,101,45,108,105,110,101,99,97,112,58,98,117,116,116,59,115,116,114,111,107,101,45,108,105,110,
101,106,111,105,110,58,109,105,116,101,114,59,115,116,114,111,107,101,45,111,112,97,99,105,116,121,58,49,59,102,105,108,116,101,114,58,117,114,108,40,35,102,105,108,116,101,114,52,56,56,50,41,59,111,112,
97,99,105,116,121,58,49,59,102,105,108,108,45,114,117,108,101,58,110,111,110,122,101,114,111,34,10,32,32,32,32,32,32,32,105,100,61,34,116,101,120,116,52,52,56,55,34,10,32,32,32,32,32,32,32,116,114,97,
110,115,102,111,114,109,61,34,109,97,116,114,105,120,40,49,44,48,44,48,44,48,46,56,56,49,52,57,50,52,53,44,48,44,49,52,46,48,55,55,51,56,56,41,34,62,10,32,32,32,32,32,32,60,112,97,116,104,10,32,32,32,
32,32,32,32,32,32,105,100,61,34,112,97,116,104,52,56,53,57,34,10,32,32,32,32,32,32,32,32,32,115,116,121,108,101,61,34,102,111,110,116,45,115,116,121,108,101,58,110,111,114,109,97,108,59,102,111,110,116,
45,118,97,114,105,97,110,116,58,110,111,114,109,97,108,59,102,111,110,116,45,119,101,105,103,104,116,58,98,111,108,100,59,102,111,110,116,45,115,116,114,101,116,99,104,58,110,111,114,109,97,108,59,102,
111,110,116,45,115,105,122,101,58,53,48,46,55,57,57,57,57,57,50,52,112,120,59,102,111,110,116,45,102,97,109,105,108,121,58,84,97,104,111,109,97,59,45,105,110,107,115,99,97,112,101,45,102,111,110,116,45,
115,112,101,99,105,102,105,99,97,116,105,111,110,58,39,84,97,104,111,109,97,32,66,111,108,100,39,59,108,101,116,116,101,114,45,115,112,97,99,105,110,103,58,45,49,46,48,53,56,51,51,51,50,56,112,120,59,
115,116,114,111,107,101,45,119,105,100,116,104,58,48,46,50,54,52,53,56,51,51,50,112,120,59,102,105,108,108,58,117,114,108,40,35,108,105,110,101,97,114,71,114,97,100,105,101,110,116,52,57,49,52,41,59,102,
105,108,108,45,111,112,97,99,105,116,121,58,49,59,115,116,114,111,107,101,58,110,111,110,101,59,115,116,114,111,107,101,45,111,112,97,99,105,116,121,58,49,59,102,105,108,108,45,114,117,108,101,58,110,
111,110,122,101,114,111,34,10,32,32,32,32,32,32,32,32,32,100,61,34,77,32,49,49,50,46,53,49,56,55,56,44,49,53,54,46,51,57,50,56,53,32,86,32,49,50,54,46,53,48,51,50,32,104,32,45,49,48,46,57,49,52,48,54,
32,118,32,45,55,46,48,52,52,53,51,32,104,32,51,49,46,49,48,53,48,56,32,118,32,55,46,48,52,52,53,51,32,104,32,45,49,48,46,57,49,52,48,55,32,118,32,50,57,46,56,56,57,54,53,32,122,32,109,32,45,50,53,46,52,
52,57,54,48,56,44,48,46,54,54,57,55,51,32,113,32,45,52,46,50,52,49,54,48,49,44,48,32,45,55,46,52,54,54,50,49,49,44,45,48,46,56,49,56,53,54,32,45,51,46,49,57,57,56,48,52,44,45,48,46,56,49,56,53,53,32,45,
53,46,57,53,51,49,50,53,44,45,50,46,48,51,51,57,56,32,118,32,45,56,46,55,56,48,56,54,32,104,32,48,46,56,52,51,51,54,32,113,32,50,46,55,55,56,49,50,53,44,50,46,51,53,54,52,53,32,54,46,49,50,54,55,53,55,
44,51,46,54,50,49,52,57,32,51,46,51,52,56,54,51,51,44,49,46,50,54,53,48,51,32,54,46,52,57,56,56,50,56,44,49,46,50,54,53,48,51,32,48,46,55,57,51,55,53,44,48,32,50,46,48,56,51,53,57,52,44,45,48,46,49,55,
51,54,51,32,49,46,51,49,52,54,52,57,44,45,48,46,49,55,51,54,51,32,50,46,49,48,56,51,57,57,44,45,48,46,53,52,53,55,32,48,46,57,54,55,51,56,50,44,45,48,46,52,50,49,54,56,32,49,46,54,51,55,49,48,57,44,45,
49,46,49,54,53,56,50,32,48,46,54,54,57,55,50,54,44,45,48,46,55,54,56,57,53,32,48,46,54,54,57,55,50,54,44,45,50,46,48,48,57,49,56,32,48,44,45,49,46,51,56,57,48,54,32,45,49,46,48,57,49,52,48,54,44,45,50,
46,50,53,55,50,51,32,45,49,46,48,57,49,52,48,54,44,45,48,46,56,54,56,49,54,32,45,50,46,54,48,52,52,57,50,44,45,49,46,50,54,53,48,52,32,45,49,46,56,56,53,49,53,54,44,45,48,46,52,57,54,48,57,32,45,52,46,
48,52,51,49,54,52,44,45,48,46,57,52,50,53,56,32,45,50,46,49,51,51,50,48,51,44,45,48,46,52,52,54,52,56,32,45,51,46,57,57,51,53,53,53,44,45,49,46,48,57,49,52,32,45,52,46,50,57,49,50,49,44,45,49,46,53,49,
51,48,57,32,45,54,46,49,53,49,53,54,50,44,45,52,46,48,54,55,57,55,32,45,49,46,56,54,48,51,53,49,44,45,50,46,53,53,52,56,56,32,45,49,46,56,54,48,51,53,49,44,45,54,46,51,57,57,54,49,32,48,44,45,53,46,49,
56,52,49,56,32,52,46,51,57,48,52,50,57,44,45,56,46,51,56,51,57,56,32,52,46,51,57,48,52,51,44,45,51,46,50,50,52,54,49,32,49,48,46,57,54,51,54,55,50,44,45,51,46,50,50,52,54,49,32,51,46,50,57,57,48,50,51,
44,48,32,54,46,53,52,56,52,51,55,44,48,46,54,54,57,55,50,32,51,46,50,55,52,50,49,57,44,48,46,54,54,57,55,51,32,53,46,56,53,51,57,48,51,44,49,46,56,49,48,55,53,32,118,32,56,46,52,51,51,53,57,32,104,32,
45,48,46,56,49,56,53,53,32,113,32,45,50,46,48,53,56,55,57,44,45,49,46,55,54,49,49,51,32,45,53,46,48,51,53,51,53,51,44,45,50,46,57,55,54,53,54,32,45,50,46,57,53,49,55,53,56,44,45,49,46,50,49,53,52,51,32,
45,54,46,48,55,55,49,52,56,44,45,49,46,50,49,53,52,51,32,45,49,46,50,49,53,52,51,44,48,32,45,50,46,49,56,50,56,49,51,44,48,46,49,55,51,54,51,32,45,48,46,57,54,55,51,56,50,44,48,46,49,55,51,54,51,32,45,
50,46,48,51,51,57,56,52,44,48,46,54,54,57,55,51,32,45,48,46,56,54,56,49,54,52,44,48,46,51,57,54,56,55,32,45,49,46,53,49,51,48,56,54,44,49,46,49,57,48,54,50,32,45,48,46,54,50,48,49,49,55,44,48,46,55,54,
56,57,53,32,45,48,46,54,50,48,49,49,55,44,49,46,55,51,54,51,51,32,48,44,49,46,52,49,51,56,55,32,48,46,57,57,50,49,56,55,44,50,46,50,53,55,50,51,32,49,46,48,49,54,57,57,51,44,48,46,56,49,56,53,53,32,51,
46,56,57,52,51,51,54,44,49,46,52,56,56,50,56,32,49,46,56,54,48,51,53,50,44,48,46,52,50,49,54,56,32,51,46,53,55,49,56,55,53,44,48,46,56,49,56,53,53,32,49,46,55,51,54,51,50,56,44,48,46,51,57,54,56,56,32,
51,46,54,57,53,56,57,57,44,49,46,48,57,49,52,49,32,51,46,56,52,52,55,50,54,44,49,46,51,56,57,48,54,32,53,46,55,48,53,48,55,52,44,51,46,55,52,53,53,49,32,49,46,56,56,53,49,54,44,50,46,51,51,49,54,52,32,
49,46,56,56,53,49,54,44,54,46,49,55,54,51,54,32,48,44,53,46,53,48,54,54,52,32,45,52,46,51,52,48,56,50,44,56,46,56,53,53,50,56,32,45,52,46,51,49,54,48,49,54,44,51,46,51,52,56,54,51,32,45,49,49,46,54,56,
51,48,48,56,44,51,46,51,52,56,54,51,32,122,32,109,32,45,52,53,46,55,48,54,55,54,56,44,45,48,46,54,54,57,55,51,32,49,50,46,52,55,54,55,53,56,44,45,51,54,46,57,51,52,49,56,32,104,32,49,48,46,49,50,48,51,
49,50,32,108,32,49,50,46,52,55,54,55,53,56,44,51,54,46,57,51,52,49,56,32,104,32,45,57,46,53,52,57,56,48,53,32,108,32,45,50,46,51,48,54,56,51,54,44,45,55,46,53,52,48,54,50,32,72,32,53,50,46,57,55,48,57,
57,56,32,108,32,45,50,46,51,48,54,56,51,54,44,55,46,53,52,48,54,50,32,122,32,109,32,50,49,46,49,56,51,50,48,51,44,45,49,52,46,50,51,55,56,57,32,45,51,46,55,55,48,51,49,50,44,45,49,50,46,49,55,57,49,32,
45,51,46,55,55,48,51,49,51,44,49,50,46,49,55,57,49,32,122,32,77,32,52,57,46,55,57,54,44,49,49,57,46,52,53,56,54,55,32,108,32,45,49,50,46,55,44,51,54,46,57,51,52,49,56,32,104,32,45,57,46,54,55,51,56,50,
56,32,108,32,45,49,50,46,55,44,45,51,54,46,57,51,52,49,56,32,104,32,57,46,54,50,52,50,49,57,32,108,32,56,46,48,51,54,55,49,56,44,50,53,46,48,50,55,57,51,32,56,46,48,51,54,55,49,57,44,45,50,53,46,48,50,
55,57,51,32,122,34,32,47,62,10,32,32,32,32,60,47,103,62,10,32,32,60,47,103,62,10,60,47,115,118,103,62,10,0,0};

const char* VASTLogoComponent::vast_svg = (const char*) resource_VASTLogoComponent_vast_svg;
const int VASTLogoComponent::vast_svgSize = 4982;


//[EndFile] You can add extra defines here...
//[/EndFile]

