/* BootOptionsBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BootOptionsBox.vala, do not modify */

/*
 * RestoreDeviceBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define TEE_JEE_FILE_SYSTEM_KB ((gint64) 1000)
#define ICON_MANAGER_ICON_HARDDRIVE "drive-harddisk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BOOT_OPTIONS_BOX (boot_options_box_get_type ())
#define BOOT_OPTIONS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOT_OPTIONS_BOX, BootOptionsBox))
#define BOOT_OPTIONS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOT_OPTIONS_BOX, BootOptionsBoxClass))
#define IS_BOOT_OPTIONS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOT_OPTIONS_BOX))
#define IS_BOOT_OPTIONS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOT_OPTIONS_BOX))
#define BOOT_OPTIONS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOT_OPTIONS_BOX, BootOptionsBoxClass))

typedef struct _BootOptionsBox BootOptionsBox;
typedef struct _BootOptionsBoxClass BootOptionsBoxClass;
typedef struct _BootOptionsBoxPrivate BootOptionsBoxPrivate;
enum  {
	BOOT_OPTIONS_BOX_0_PROPERTY,
	BOOT_OPTIONS_BOX_NUM_PROPERTIES
};
static GParamSpec* boot_options_box_properties[BOOT_OPTIONS_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
typedef struct _LinuxDistroPrivate LinuxDistroPrivate;

struct _BootOptionsBox {
	GtkBox parent_instance;
	BootOptionsBoxPrivate * priv;
};

struct _BootOptionsBoxClass {
	GtkBoxClass parent_class;
};

struct _BootOptionsBoxPrivate {
	GtkBox* option_box;
	GtkComboBox* cmb_grub_dev;
	GtkCheckButton* chk_reinstall_grub;
	GtkCheckButton* chk_update_initramfs;
	GtkCheckButton* chk_update_grub;
	GtkWindow* parent_window;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _LinuxDistro {
	GObject parent_instance;
	LinuxDistroPrivate * priv;
	gchar* dist_id;
	gchar* description;
	gchar* release;
	gchar* codename;
};

struct _LinuxDistroClass {
	GObjectClass parent_class;
};

static gint BootOptionsBox_private_offset;
static gpointer boot_options_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType boot_options_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BootOptionsBox, g_object_unref)
VALA_EXTERN BootOptionsBox* boot_options_box_new (GtkWindow* _parent_window);
VALA_EXTERN BootOptionsBox* boot_options_box_construct (GType object_type,
                                            GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
static void boot_options_box_add_bootloader_options (BootOptionsBox* self);
static void boot_options_box_refresh_options (BootOptionsBox* self);
static void boot_options_box_add_chk_reinstall_grub (BootOptionsBox* self);
static void __lambda111_ (BootOptionsBox* self,
                   GtkCellLayout* cell_layout,
                   GtkCellRenderer* cell,
                   GtkTreeModel* model,
                   GtkTreeIter* iter);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN gchar* device_description_formatted (Device* self);
VALA_EXTERN gchar* device_description (Device* self);
static void ___lambda111__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                              GtkCellRenderer* cell,
                                              GtkTreeModel* tree_model,
                                              GtkTreeIter* iter,
                                              gpointer self);
static void __lambda112_ (BootOptionsBox* self);
static void boot_options_box_save_grub_device_selection (BootOptionsBox* self);
static void ___lambda112__gtk_combo_box_changed (GtkComboBox* _sender,
                                          gpointer self);
static void boot_options_box_add_chk_update_initramfs (BootOptionsBox* self,
                                                GtkBox* hbox);
static void boot_options_box_add_chk_update_grub (BootOptionsBox* self,
                                           GtkBox* hbox);
static void __lambda110_ (BootOptionsBox* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
static void ___lambda110__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void __lambda113_ (BootOptionsBox* self);
static void ___lambda113__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void __lambda114_ (BootOptionsBox* self);
static void ___lambda114__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void boot_options_box_refresh_cmb_grub_dev (BootOptionsBox* self);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* device_get_block_devices_using_lsblk (const gchar* dev_name);
static void boot_options_box_cmb_grub_dev_select_default (BootOptionsBox* self);
static void boot_options_box_finalize (GObject * obj);
static GType boot_options_box_get_type_once (void);

static inline gpointer
boot_options_box_get_instance_private (BootOptionsBox* self)
{
	return G_STRUCT_MEMBER_P (self, BootOptionsBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BootOptionsBox*
boot_options_box_construct (GType object_type,
                            GtkWindow* _parent_window)
{
	BootOptionsBox * self = NULL;
	GtkWindow* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("BootOptionsBox: BootOptionsBox()");
	self = (BootOptionsBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->option_box);
	self->priv->option_box = _tmp1_;
	_tmp2_ = self->priv->option_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	boot_options_box_add_bootloader_options (self);
	boot_options_box_refresh_options (self);
	tee_jee_logging_log_debug ("BootOptionsBox: BootOptionsBox(): exit");
	return self;
}

BootOptionsBox*
boot_options_box_new (GtkWindow* _parent_window)
{
	return boot_options_box_construct (TYPE_BOOT_OPTIONS_BOX, _parent_window);
}

static void
__lambda111_ (BootOptionsBox* self,
              GtkCellLayout* cell_layout,
              GtkCellRenderer* cell,
              GtkTreeModel* model,
              GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	_tmp3_ = _tmp2_->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		Device* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = dev;
		_tmp5_ = device_description_formatted (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("<b>%s (MBR)</b>", _tmp6_);
		_tmp8_ = _tmp7_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "markup", _tmp8_, NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	} else {
		Device* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = dev;
		_tmp10_ = device_description (_tmp9_);
		_tmp11_ = _tmp10_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp11_, NULL);
		_g_free0 (_tmp11_);
	}
	_g_object_unref0 (dev);
}

static void
___lambda111__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* tree_model,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	__lambda111_ ((BootOptionsBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda112_ (BootOptionsBox* self)
{
	boot_options_box_save_grub_device_selection (self);
}

static void
___lambda112__gtk_combo_box_changed (GtkComboBox* _sender,
                                     gpointer self)
{
	__lambda112_ ((BootOptionsBox*) self);
}

static void
boot_options_box_add_bootloader_options (BootOptionsBox* self)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkCellRendererText* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkCellRendererText* _tmp13_;
	GtkComboBox* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	g_return_if_fail (self != NULL);
	boot_options_box_add_chk_reinstall_grub (self);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = hbox;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 12);
	_tmp2_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->cmb_grub_dev);
	self->priv->cmb_grub_dev = _tmp3_;
	_tmp4_ = self->priv->cmb_grub_dev;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = hbox;
	_tmp6_ = self->priv->cmb_grub_dev;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	cell_text = _tmp7_;
	_tmp8_ = cell_text;
	g_object_set (_tmp8_, "text", "", NULL);
	_tmp9_ = self->priv->cmb_grub_dev;
	_tmp10_ = cell_text;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
	_tmp11_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp11_;
	_tmp12_ = self->priv->cmb_grub_dev;
	_tmp13_ = cell_text;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
	_tmp14_ = self->priv->cmb_grub_dev;
	_tmp15_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, ___lambda111__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp16_ = self->priv->cmb_grub_dev;
	g_signal_connect_object (_tmp16_, "changed", (GCallback) ___lambda112__gtk_combo_box_changed, self, 0);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (hbox);
	hbox = _tmp17_;
	_tmp18_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp18_);
	_tmp19_ = hbox;
	boot_options_box_add_chk_update_initramfs (self, _tmp19_);
	_tmp20_ = hbox;
	boot_options_box_add_chk_update_grub (self, _tmp20_);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (hbox);
}

static void
__lambda110_ (BootOptionsBox* self)
{
	GtkComboBox* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Main* _tmp4_;
	GtkCheckButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkComboBox* _tmp8_;
	_tmp0_ = self->priv->cmb_grub_dev;
	_tmp1_ = self->priv->chk_reinstall_grub;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
	_tmp4_ = App;
	_tmp5_ = self->priv->chk_reinstall_grub;
	_tmp6_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_->reinstall_grub2 = _tmp7_;
	_tmp8_ = self->priv->cmb_grub_dev;
	g_signal_emit_by_name (_tmp8_, "changed");
}

static void
___lambda110__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda110_ ((BootOptionsBox*) self);
}

static void
boot_options_box_add_chk_reinstall_grub (BootOptionsBox* self)
{
	GtkCheckButton* chk = NULL;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("(Re)install GRUB2 on:"));
	g_object_ref_sink (_tmp0_);
	chk = _tmp0_;
	gtk_toggle_button_set_active ((GtkToggleButton*) chk, FALSE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) chk, _ ("Re-installs the GRUB2 bootloader on the selected device."));
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) chk);
	_tmp1_ = _g_object_ref0 (chk);
	_g_object_unref0 (self->priv->chk_reinstall_grub);
	self->priv->chk_reinstall_grub = _tmp1_;
	g_signal_connect_object ((GtkToggleButton*) chk, "toggled", (GCallback) ___lambda110__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (chk);
}

static void
__lambda113_ (BootOptionsBox* self)
{
	Main* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = App;
	_tmp1_ = self->priv->chk_update_initramfs;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_->update_initramfs = _tmp3_;
}

static void
___lambda113__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda113_ ((BootOptionsBox*) self);
}

static void
boot_options_box_add_chk_update_initramfs (BootOptionsBox* self,
                                           GtkBox* hbox)
{
	GtkCheckButton* chk = NULL;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Update initramfs"));
	g_object_ref_sink (_tmp0_);
	chk = _tmp0_;
	gtk_toggle_button_set_active ((GtkToggleButton*) chk, FALSE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) chk, _ ("Re-generates initramfs for all installed kernels. This is generally no" \
"t needed. Select this only if the restored system fails to boot."));
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) chk);
	_tmp1_ = _g_object_ref0 (chk);
	_g_object_unref0 (self->priv->chk_update_initramfs);
	self->priv->chk_update_initramfs = _tmp1_;
	g_signal_connect_object ((GtkToggleButton*) chk, "toggled", (GCallback) ___lambda113__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (chk);
}

static void
__lambda114_ (BootOptionsBox* self)
{
	Main* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = App;
	_tmp1_ = self->priv->chk_update_grub;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_->update_grub = _tmp3_;
}

static void
___lambda114__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda114_ ((BootOptionsBox*) self);
}

static void
boot_options_box_add_chk_update_grub (BootOptionsBox* self,
                                      GtkBox* hbox)
{
	GtkCheckButton* chk = NULL;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Update GRUB menu"));
	g_object_ref_sink (_tmp0_);
	chk = _tmp0_;
	gtk_toggle_button_set_active ((GtkToggleButton*) chk, FALSE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) chk, _ ("Updates the GRUB menu entries (recommended). This is safe to run and s" \
"hould be left selected."));
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) chk);
	_tmp1_ = _g_object_ref0 (chk);
	_g_object_unref0 (self->priv->chk_update_grub);
	self->priv->chk_update_grub = _tmp1_;
	g_signal_connect_object ((GtkToggleButton*) chk, "toggled", (GCallback) ___lambda114__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (chk);
}

static void
boot_options_box_save_grub_device_selection (BootOptionsBox* self)
{
	Main* _tmp0_;
	gchar* _tmp1_;
	Main* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = g_strdup ("");
	_g_free0 (_tmp0_->grub_device);
	_tmp0_->grub_device = _tmp1_;
	_tmp2_ = App;
	if (_tmp2_->reinstall_grub2) {
		Device* entry = NULL;
		GtkTreeIter iter = {0};
		gboolean ok = FALSE;
		GtkComboBox* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp6_;
		GtkTreeModel* _tmp7_;
		GtkTreeModel* _tmp8_;
		GtkTreeModel* _tmp9_;
		GtkTreeModel* _tmp10_;
		GtkTreeIter _tmp11_;
		Device* _tmp12_ = NULL;
		Main* _tmp13_;
		Device* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp3_ = self->priv->cmb_grub_dev;
		_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
		iter = _tmp4_;
		ok = _tmp5_;
		if (!ok) {
			_g_object_unref0 (entry);
			return;
		}
		_tmp6_ = self->priv->cmb_grub_dev;
		_tmp7_ = gtk_combo_box_get_model (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_tree_model_get_type (), GtkTreeModel));
		model = _tmp9_;
		_tmp10_ = model;
		_tmp11_ = iter;
		gtk_tree_model_get (_tmp10_, &_tmp11_, 0, &_tmp12_, -1);
		_g_object_unref0 (entry);
		entry = _tmp12_;
		_tmp13_ = App;
		_tmp14_ = entry;
		_tmp15_ = _tmp14_->device;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_tmp13_->grub_device);
		_tmp13_->grub_device = _tmp16_;
		_g_object_unref0 (model);
		_g_object_unref0 (entry);
	}
}

static void
boot_options_box_refresh_options (BootOptionsBox* self)
{
	GtkCheckButton* _tmp0_;
	Main* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkCheckButton* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkCheckButton* _tmp6_;
	Main* _tmp7_;
	GtkCheckButton* _tmp8_;
	Main* _tmp9_;
	GtkCheckButton* _tmp10_;
	GtkCheckButton* _tmp11_;
	GtkCheckButton* _tmp12_;
	Main* _tmp13_;
	g_return_if_fail (self != NULL);
	boot_options_box_refresh_cmb_grub_dev (self);
	_tmp0_ = self->priv->chk_reinstall_grub;
	_tmp1_ = App;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp1_->reinstall_grub2);
	_tmp2_ = self->priv->cmb_grub_dev;
	_tmp3_ = self->priv->chk_reinstall_grub;
	_tmp4_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, _tmp5_);
	_tmp6_ = self->priv->chk_update_initramfs;
	_tmp7_ = App;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, _tmp7_->update_initramfs);
	_tmp8_ = self->priv->chk_update_grub;
	_tmp9_ = App;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, _tmp9_->update_grub);
	_tmp10_ = self->priv->chk_reinstall_grub;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->chk_update_initramfs;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->chk_update_grub;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = App;
	if (_tmp13_->mirror_system) {
		GtkCheckButton* _tmp14_;
		GtkCheckButton* _tmp15_;
		GtkCheckButton* _tmp16_;
		_tmp14_ = self->priv->chk_reinstall_grub;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
		_tmp15_ = self->priv->chk_update_initramfs;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
		_tmp16_ = self->priv->chk_update_grub;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
	} else {
		Main* _tmp17_;
		Snapshot* _tmp18_;
		LinuxDistro* _tmp19_;
		const gchar* _tmp20_;
		_tmp17_ = App;
		_tmp18_ = _tmp17_->snapshot_to_restore;
		_tmp19_ = _tmp18_->distro;
		_tmp20_ = _tmp19_->dist_id;
		if (g_strcmp0 (_tmp20_, "fedora") == 0) {
			GtkCheckButton* _tmp21_;
			_tmp21_ = self->priv->chk_reinstall_grub;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, FALSE);
		}
	}
}

static void
boot_options_box_refresh_cmb_grub_dev (BootOptionsBox* self)
{
	GtkListStore* store = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp27_;
	GtkListStore* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (2, TYPE_DEVICE, G_TYPE_STRING, -1);
	store = _tmp0_;
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp1_;
		gint _dev_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dev_index = 0;
		_tmp1_ = device_get_block_devices_using_lsblk ("");
		_dev_list = _tmp1_;
		_tmp2_ = _dev_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dev_size = _tmp4_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Device* dev = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			Device* _tmp10_;
			const gchar* _tmp11_;
			gboolean _tmp14_ = FALSE;
			Device* _tmp15_;
			const gchar* _tmp16_;
			Device* _tmp19_;
			GtkListStore* _tmp20_;
			GtkTreeIter _tmp21_ = {0};
			GtkListStore* _tmp22_;
			GtkTreeIter _tmp23_;
			Device* _tmp24_;
			GtkListStore* _tmp25_;
			GtkTreeIter _tmp26_;
			_dev_index = _dev_index + 1;
			_tmp5_ = _dev_index;
			_tmp6_ = _dev_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _dev_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _dev_index);
			dev = (Device*) _tmp8_;
			_tmp10_ = dev;
			_tmp11_ = _tmp10_->type;
			if (g_strcmp0 (_tmp11_, "disk") != 0) {
				Device* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = dev;
				_tmp13_ = _tmp12_->type;
				_tmp9_ = g_strcmp0 (_tmp13_, "part") != 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_g_object_unref0 (dev);
				continue;
			}
			_tmp15_ = dev;
			_tmp16_ = _tmp15_->fstype;
			if (g_strcmp0 (_tmp16_, "luks") == 0) {
				_tmp14_ = TRUE;
			} else {
				Device* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = dev;
				_tmp18_ = _tmp17_->fstype;
				_tmp14_ = g_strcmp0 (_tmp18_, "lvm2") == 0;
			}
			if (_tmp14_) {
				_g_object_unref0 (dev);
				continue;
			}
			_tmp19_ = dev;
			if (_tmp19_->size_bytes < ((guint64) (10 * TEE_JEE_FILE_SYSTEM_KB))) {
				_g_object_unref0 (dev);
				continue;
			}
			_tmp20_ = store;
			gtk_list_store_append (_tmp20_, &_tmp21_);
			iter = _tmp21_;
			_tmp22_ = store;
			_tmp23_ = iter;
			_tmp24_ = dev;
			gtk_list_store_set (_tmp22_, &_tmp23_, 0, _tmp24_, -1);
			_tmp25_ = store;
			_tmp26_ = iter;
			gtk_list_store_set (_tmp25_, &_tmp26_, 1, ICON_MANAGER_ICON_HARDDRIVE, -1);
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_list);
	}
	_tmp27_ = self->priv->cmb_grub_dev;
	_tmp28_ = store;
	gtk_combo_box_set_model (_tmp27_, (GtkTreeModel*) _tmp28_);
	boot_options_box_cmb_grub_dev_select_default (self);
	_g_object_unref0 (store);
}

static void
boot_options_box_cmb_grub_dev_select_default (BootOptionsBox* self)
{
	gboolean _tmp0_ = FALSE;
	GtkComboBox* _tmp1_;
	Main* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	GtkComboBox* _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkListStore* _tmp13_;
	gint index = 0;
	gint active = 0;
	GtkComboBox* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->cmb_grub_dev;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBox* _tmp2_;
		GtkTreeModel* _tmp3_;
		GtkTreeModel* _tmp4_;
		_tmp2_ = self->priv->cmb_grub_dev;
		_tmp3_ = gtk_combo_box_get_model (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	tee_jee_logging_log_debug ("BootOptionsBox: cmb_grub_dev_select_default()");
	_tmp5_ = App;
	_tmp6_ = _tmp5_->grub_device;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		GtkComboBox* _tmp9_;
		_tmp9_ = self->priv->cmb_grub_dev;
		gtk_combo_box_set_active (_tmp9_, -1);
		return;
	}
	_tmp10_ = self->priv->cmb_grub_dev;
	_tmp11_ = gtk_combo_box_get_model (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp13_;
	index = -1;
	active = -1;
	{
		gboolean next = FALSE;
		GtkListStore* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		gboolean _tmp16_;
		_tmp14_ = store;
		_tmp16_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp14_, &_tmp15_);
		iter = _tmp15_;
		next = _tmp16_;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				Device* dev_iter = NULL;
				GtkListStore* _tmp20_;
				GtkTreeIter _tmp21_;
				Device* _tmp22_ = NULL;
				gint _tmp23_;
				Device* _tmp24_;
				const gchar* _tmp25_;
				Main* _tmp26_;
				const gchar* _tmp27_;
				if (!_tmp17_) {
					GtkListStore* _tmp18_;
					gboolean _tmp19_;
					_tmp18_ = store;
					_tmp19_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp18_, &iter);
					next = _tmp19_;
				}
				_tmp17_ = FALSE;
				if (!next) {
					break;
				}
				_tmp20_ = store;
				_tmp21_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, 0, &_tmp22_, -1);
				_g_object_unref0 (dev_iter);
				dev_iter = _tmp22_;
				_tmp23_ = index;
				index = _tmp23_ + 1;
				_tmp24_ = dev_iter;
				_tmp25_ = _tmp24_->device;
				_tmp26_ = App;
				_tmp27_ = _tmp26_->grub_device;
				if (g_strcmp0 (_tmp25_, _tmp27_) == 0) {
					active = index;
					_g_object_unref0 (dev_iter);
					break;
				}
				_g_object_unref0 (dev_iter);
			}
		}
	}
	_tmp28_ = self->priv->cmb_grub_dev;
	gtk_combo_box_set_active (_tmp28_, active);
	tee_jee_logging_log_debug ("BootOptionsBox: cmb_grub_dev_select_default(): exit");
	_g_object_unref0 (store);
}

static void
boot_options_box_class_init (BootOptionsBoxClass * klass,
                             gpointer klass_data)
{
	boot_options_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BootOptionsBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boot_options_box_finalize;
}

static void
boot_options_box_instance_init (BootOptionsBox * self,
                                gpointer klass)
{
	self->priv = boot_options_box_get_instance_private (self);
}

static void
boot_options_box_finalize (GObject * obj)
{
	BootOptionsBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOT_OPTIONS_BOX, BootOptionsBox);
	_g_object_unref0 (self->priv->option_box);
	_g_object_unref0 (self->priv->cmb_grub_dev);
	_g_object_unref0 (self->priv->chk_reinstall_grub);
	_g_object_unref0 (self->priv->chk_update_initramfs);
	_g_object_unref0 (self->priv->chk_update_grub);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (boot_options_box_parent_class)->finalize (obj);
}

static GType
boot_options_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BootOptionsBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boot_options_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BootOptionsBox), 0, (GInstanceInitFunc) boot_options_box_instance_init, NULL };
	GType boot_options_box_type_id;
	boot_options_box_type_id = g_type_register_static (gtk_box_get_type (), "BootOptionsBox", &g_define_type_info, 0);
	BootOptionsBox_private_offset = g_type_add_instance_private (boot_options_box_type_id, sizeof (BootOptionsBoxPrivate));
	return boot_options_box_type_id;
}

GType
boot_options_box_get_type (void)
{
	static volatile gsize boot_options_box_type_id__once = 0;
	if (g_once_init_enter (&boot_options_box_type_id__once)) {
		GType boot_options_box_type_id;
		boot_options_box_type_id = boot_options_box_get_type_once ();
		g_once_init_leave (&boot_options_box_type_id__once, boot_options_box_type_id);
	}
	return boot_options_box_type_id__once;
}

