/* generate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from generate.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libseahorse/seahorse-progress.h"
#include <glib/gi18n-lib.h>
#include "seahorse-common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_SSH_GENERATE_0_PROPERTY,
	SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY,
	SEAHORSE_SSH_GENERATE_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_generate_properties[SEAHORSE_SSH_GENERATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseSshGenerateGenerateKeyData SeahorseSshGenerateGenerateKeyData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseSshGeneratePrivate {
	SeahorseSshSource* _source;
	GtkGrid* details_grid;
	SeahorseSshKeyLengthChooser* key_length_chooser;
	GtkEntry* email_entry;
	GtkComboBoxText* algorithm_combo_box;
};

struct _SeahorseSshGenerateGenerateKeyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshGenerate* self;
	gchar* email;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* t;
	GtkComboBoxText* _tmp4_;
	gchar* _tmp5_;
	SeahorseSshAlgorithm type;
	const gchar* _tmp6_;
	guint bits;
	SeahorseSshKeyLengthChooser* _tmp7_;
	gchar* filename;
	SeahorseSshSource* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	SeahorseSshGenerateOperation* op;
	SeahorseSshGenerateOperation* _tmp13_;
	GCancellable* cancellable;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	SeahorseSshGenerateOperation* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	const gchar* _tmp20_;
	SeahorseSshKey* key;
	SeahorseSshSource* _tmp21_;
	const gchar* _tmp22_;
	SeahorseSshKey* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError* _vala1_e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_;
};

static gint SeahorseSshGenerate_private_offset;
static gpointer seahorse_ssh_generate_parent_class = NULL;

static void seahorse_ssh_generate_on_algo_changed (SeahorseSshGenerate* self,
                                            GtkComboBox* combo);
static void _seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void seahorse_ssh_generate_generate_key_data_free (gpointer _data);
static gboolean seahorse_ssh_generate_generate_key_co (SeahorseSshGenerateGenerateKeyData* _data_);
static void seahorse_ssh_generate_generate_key_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void seahorse_ssh_generate_finalize (GObject * obj);
static GType seahorse_ssh_generate_get_type_once (void);
static void _vala_seahorse_ssh_generate_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_ssh_generate_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_generate_get_instance_private (SeahorseSshGenerate* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshGenerate_private_offset);
}

SeahorseSshGenerate*
seahorse_ssh_generate_construct (GType object_type,
                                 SeahorseSshSource* src,
                                 GtkWindow* parent)
{
	SeahorseSshGenerate * self = NULL;
	SeahorseSshKeyLengthChooser* _tmp0_;
	SeahorseSshKeyLengthChooser* _tmp1_;
	GtkGrid* _tmp2_;
	SeahorseSshKeyLengthChooser* _tmp3_;
	GtkComboBoxText* _tmp4_;
	g_return_val_if_fail (src != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (SeahorseSshGenerate*) g_object_new (object_type, "source", src, "use-header-bar", 1, "transient-for", parent, NULL);
	seahorse_ssh_generate_set_source (self, src);
	_tmp0_ = seahorse_ssh_key_length_chooser_new (SEAHORSE_SSH_ALGORITHM_RSA);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->key_length_chooser);
	self->priv->key_length_chooser = _tmp0_;
	_tmp1_ = self->priv->key_length_chooser;
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	_tmp2_ = self->priv->details_grid;
	_tmp3_ = self->priv->key_length_chooser;
	gtk_grid_attach (_tmp2_, (GtkWidget*) _tmp3_, 1, 3, 1, 1);
	_tmp4_ = self->priv->algorithm_combo_box;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp4_, 0);
	return self;
}

SeahorseSshGenerate*
seahorse_ssh_generate_new (SeahorseSshSource* src,
                           GtkWindow* parent)
{
	return seahorse_ssh_generate_construct (SEAHORSE_SSH_TYPE_GENERATE, src, parent);
}

static void
seahorse_ssh_generate_on_algo_changed (SeahorseSshGenerate* self,
                                       GtkComboBox* combo)
{
	gchar* t = NULL;
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	SeahorseSshKeyLengthChooser* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->algorithm_combo_box;
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
	t = _tmp1_;
	_tmp2_ = self->priv->key_length_chooser;
	seahorse_ssh_key_length_chooser_set_algorithm (_tmp2_, seahorse_ssh_algorithm_from_string (t));
	_g_free0 (t);
}

static void
_seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	seahorse_ssh_generate_on_algo_changed ((SeahorseSshGenerate*) self, _sender);
}

static void
seahorse_ssh_generate_generate_key_data_free (gpointer _data)
{
	SeahorseSshGenerateGenerateKeyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshGenerateGenerateKeyData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_ssh_generate_generate_key (SeahorseSshGenerate* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SeahorseSshGenerateGenerateKeyData* _data_;
	SeahorseSshGenerate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseSshGenerateGenerateKeyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_generate_generate_key_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_ssh_generate_generate_key_co (_data_);
}

void
seahorse_ssh_generate_generate_key_finish (SeahorseSshGenerate* self,
                                           GAsyncResult* _res_)
{
	SeahorseSshGenerateGenerateKeyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Generate a key from the fields that were filled in.
     *
     * Note: make sure you don't destroy the window before this async method
     * has finished
     */
static void
seahorse_ssh_generate_generate_key_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SeahorseSshGenerateGenerateKeyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_generate_generate_key_co (_data_);
}

static gboolean
seahorse_ssh_generate_generate_key_co (SeahorseSshGenerateGenerateKeyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->email_entry;
	_data_->_tmp1_ = gtk_entry_get_text (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->email = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->algorithm_combo_box;
	_data_->_tmp5_ = gtk_combo_box_text_get_active_text (_data_->_tmp4_);
	_data_->t = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->t;
	_data_->type = seahorse_ssh_algorithm_from_string (_data_->_tmp6_);
	_vala_assert (_data_->type != SEAHORSE_SSH_ALGORITHM_UNKNOWN, "type != Algorithm.UNKNOWN");
	_data_->_tmp7_ = _data_->self->priv->key_length_chooser;
	_data_->bits = (guint) seahorse_ssh_key_length_chooser_get_length (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->self->priv->_source;
	_data_->_tmp9_ = seahorse_ssh_source_new_filename_for_algorithm (_data_->_tmp8_, _data_->type);
	_data_->filename = _data_->_tmp9_;
	{
		_data_->_tmp10_ = _data_->t;
		_data_->_tmp11_ = _data_->email;
		_data_->_tmp12_ = _data_->filename;
		g_debug ("generate.vala:82: Generating %s key '%s' (file '%s')", _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp13_ = seahorse_ssh_generate_operation_new ();
		_data_->op = _data_->_tmp13_;
		_data_->_tmp14_ = g_cancellable_new ();
		_data_->cancellable = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->cancellable;
		seahorse_progress_show (_data_->_tmp15_, _ ("Creating Secure Shell Key"), FALSE);
		_data_->_tmp16_ = _data_->op;
		_data_->_tmp17_ = _data_->filename;
		_data_->_tmp18_ = _data_->email;
		_data_->_tmp19_ = _data_->cancellable;
		_data_->_state_ = 1;
		seahorse_ssh_generate_operation_generate_async (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, _data_->type, _data_->bits, _data_->_tmp19_, seahorse_ssh_generate_generate_key_ready, _data_);
		return FALSE;
		_state_1:
		seahorse_ssh_generate_operation_generate_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cancellable);
			_g_object_unref0 (_data_->op);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp20_ = _data_->filename;
			g_debug ("generate.vala:90: Importing generated key (file '%s')", _data_->_tmp20_);
			_data_->_tmp21_ = _data_->self->priv->_source;
			_data_->_tmp22_ = _data_->filename;
			_data_->_state_ = 2;
			seahorse_ssh_source_add_key_from_filename (_data_->_tmp21_, _data_->_tmp22_, seahorse_ssh_generate_generate_key_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp23_ = seahorse_ssh_source_add_key_from_filename_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
			_data_->key = _data_->_tmp23_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_g_object_unref0 (_data_->key);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp24_ = _data_->e;
			_data_->_tmp25_ = _data_->_tmp24_->message;
			seahorse_util_show_error (NULL, _ ("Couldn’t load newly generated Secure Shell key"), _data_->_tmp25_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cancellable);
			_g_object_unref0 (_data_->op);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->cancellable);
		_g_object_unref0 (_data_->op);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp26_ = _data_->_vala1_e;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		seahorse_util_show_error (NULL, _ ("Couldn’t generate Secure Shell key"), _data_->_tmp27_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->filename);
		_g_free0 (_data_->t);
		_g_free0 (_data_->email);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->filename);
	_g_free0 (_data_->t);
	_g_free0 (_data_->email);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshSource*
seahorse_ssh_generate_get_source (SeahorseSshGenerate* self)
{
	SeahorseSshSource* result;
	SeahorseSshSource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_generate_set_source (SeahorseSshGenerate* self,
                                  SeahorseSshSource* value)
{
	SeahorseSshSource* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_generate_get_source (self);
	if (old_value != value) {
		SeahorseSshSource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_generate_properties[SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY]);
	}
}

static void
seahorse_ssh_generate_class_init (SeahorseSshGenerateClass * klass,
                                  gpointer klass_data)
{
	seahorse_ssh_generate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshGenerate_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_generate_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_generate_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_generate_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY, seahorse_ssh_generate_properties[SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", SEAHORSE_SSH_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-ssh-generate.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "details_grid", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, details_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "email_entry", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, email_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "algorithm_combo_box", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, algorithm_combo_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_algo_changed", G_CALLBACK(_seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed));
}

static void
seahorse_ssh_generate_instance_init (SeahorseSshGenerate * self,
                                     gpointer klass)
{
	self->priv = seahorse_ssh_generate_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_ssh_generate_finalize (GObject * obj)
{
	SeahorseSshGenerate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerate);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->key_length_chooser);
	G_OBJECT_CLASS (seahorse_ssh_generate_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_generate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshGenerateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_generate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshGenerate), 0, (GInstanceInitFunc) seahorse_ssh_generate_instance_init, NULL };
	GType seahorse_ssh_generate_type_id;
	seahorse_ssh_generate_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseSshGenerate", &g_define_type_info, 0);
	SeahorseSshGenerate_private_offset = g_type_add_instance_private (seahorse_ssh_generate_type_id, sizeof (SeahorseSshGeneratePrivate));
	return seahorse_ssh_generate_type_id;
}

GType
seahorse_ssh_generate_get_type (void)
{
	static volatile gsize seahorse_ssh_generate_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_generate_type_id__once)) {
		GType seahorse_ssh_generate_type_id;
		seahorse_ssh_generate_type_id = seahorse_ssh_generate_get_type_once ();
		g_once_init_leave (&seahorse_ssh_generate_type_id__once, seahorse_ssh_generate_type_id);
	}
	return seahorse_ssh_generate_type_id__once;
}

static void
_vala_seahorse_ssh_generate_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshGenerate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerate);
	switch (property_id) {
		case SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY:
		g_value_set_object (value, seahorse_ssh_generate_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_generate_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshGenerate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerate);
	switch (property_id) {
		case SEAHORSE_SSH_GENERATE_SOURCE_PROPERTY:
		seahorse_ssh_generate_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

