/* exporter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from exporter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_SSH_EXPORTER_0_PROPERTY,
	SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY,
	SEAHORSE_SSH_EXPORTER_FILENAME_PROPERTY,
	SEAHORSE_SSH_EXPORTER_CONTENT_TYPE_PROPERTY,
	SEAHORSE_SSH_EXPORTER_FILE_FILTER_PROPERTY,
	SEAHORSE_SSH_EXPORTER_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SeahorseSshExporterExportData SeahorseSshExporterExportData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseSshExporterPrivate {
	SeahorseSshKey* key;
	GList* objects;
	gboolean _secret;
};

struct _SeahorseSshExporterExportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshExporter* self;
	GCancellable* cancellable;
	guint8* result;
	size_t result_length1;
	SeahorseSshKeyData* keydata;
	SeahorseSshKey* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	SeahorseSshKey* _tmp7_;
	SeahorsePlace* _tmp8_;
	SeahorsePlace* _tmp9_;
	SeahorseSshKey* _tmp10_;
	gchar* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	guint8* _tmp16_;
	gint _tmp16__length1;
	SeahorseSshKeyData* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	SeahorseSshKeyData* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	SeahorseSshKeyData* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8* _tmp33_;
	gint _tmp33__length1;
	guint8* _tmp34_;
	gint _tmp34__length1;
	GError* _inner_error0_;
};

static gint SeahorseSshExporter_private_offset;
static gpointer seahorse_ssh_exporter_parent_class = NULL;
static SeahorseExporterIface * seahorse_ssh_exporter_seahorse_exporter_parent_iface = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gchar* seahorse_ssh_exporter_get_filename (SeahorseSshExporter* self);
static GList* seahorse_ssh_exporter_real_get_objects (SeahorseExporter* base);
static gboolean seahorse_ssh_exporter_real_add_object (SeahorseExporter* base,
                                                GObject* object);
static void seahorse_ssh_exporter_real_export_data_free (gpointer _data);
static void seahorse_ssh_exporter_real_export (SeahorseExporter* base,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean seahorse_ssh_exporter_real_export_co (SeahorseSshExporterExportData* _data_);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static void seahorse_ssh_exporter_finalize (GObject * obj);
static GType seahorse_ssh_exporter_get_type_once (void);
static void _vala_seahorse_ssh_exporter_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_ssh_exporter_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_exporter_get_instance_private (SeahorseSshExporter* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshExporter_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

SeahorseSshExporter*
seahorse_ssh_exporter_construct (GType object_type,
                                 SeahorseSshKey* key,
                                 gboolean secret)
{
	SeahorseSshExporter * self = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SeahorseSshExporter*) g_object_new (object_type, NULL);
	seahorse_ssh_exporter_set_secret (self, secret);
	if (!seahorse_exporter_add_object ((SeahorseExporter*) self, (GObject*) key)) {
		g_assert_not_reached ();
	}
	return self;
}

SeahorseSshExporter*
seahorse_ssh_exporter_new (SeahorseSshKey* key,
                           gboolean secret)
{
	return seahorse_ssh_exporter_construct (SEAHORSE_SSH_TYPE_EXPORTER, key, secret);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static gchar*
seahorse_ssh_exporter_get_filename (SeahorseSshExporter* self)
{
	SeahorseSshKey* _tmp0_;
	SeahorseSshKeyData* data = NULL;
	SeahorseSshKey* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp4_;
	gboolean _tmp5_ = FALSE;
	SeahorseSshKeyData* _tmp6_;
	const gchar* _tmp33_ = NULL;
	SeahorseSshKey* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* basename = NULL;
	gchar* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->key;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->key;
	_tmp2_ = seahorse_ssh_key_get_key_data (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	data = _tmp4_;
	_tmp6_ = data;
	if (_tmp6_ != NULL) {
		SeahorseSshKeyData* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = data;
		_tmp8_ = seahorse_ssh_key_data_get_partial (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = !_tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* location = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp12_;
		const gchar* _tmp30_;
		location = NULL;
		_tmp11_ = seahorse_ssh_exporter_get_secret (self);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			SeahorseSshKeyData* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = data;
			_tmp14_ = seahorse_ssh_key_data_get_privfile (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			SeahorseSshKeyData* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = data;
			_tmp17_ = seahorse_ssh_key_data_get_privfile (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (location);
			location = _tmp19_;
		} else {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_tmp21_ = seahorse_ssh_exporter_get_secret (self);
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				SeahorseSshKeyData* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp23_ = data;
				_tmp24_ = seahorse_ssh_key_data_get_pubfile (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp20_ = _tmp25_ != NULL;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				SeahorseSshKeyData* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp26_ = data;
				_tmp27_ = seahorse_ssh_key_data_get_pubfile (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (location);
				location = _tmp29_;
			}
		}
		_tmp30_ = location;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = location;
			_tmp32_ = g_path_get_basename (_tmp31_);
			result = _tmp32_;
			_g_free0 (location);
			_g_object_unref0 (data);
			return result;
		}
		_g_free0 (location);
	}
	_tmp34_ = self->priv->key;
	_tmp35_ = seahorse_object_get_nickname ((SeahorseObject*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp33_ = _tmp36_;
	if (_tmp33_ == NULL) {
		_tmp33_ = _ ("SSH Key");
	}
	_tmp37_ = g_strdup (_tmp33_);
	basename = _tmp37_;
	_tmp38_ = seahorse_ssh_exporter_get_secret (self);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		gchar* filename = NULL;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp40_ = basename;
		_tmp41_ = g_strdup_printf ("id_%s", _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = string_strip (_tmp42_);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		filename = _tmp44_;
		_tmp45_ = filename;
		_tmp46_ = string_delimit (_tmp45_, SEAHORSE_BAD_FILENAME_CHARS, '_');
		_tmp47_ = _tmp46_;
		_g_free0 (_tmp47_);
		result = filename;
		_g_free0 (basename);
		_g_object_unref0 (data);
		return result;
	} else {
		gchar* filename = NULL;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp48_ = basename;
		_tmp49_ = g_strdup_printf ("%s.pub", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = string_strip (_tmp50_);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		filename = _tmp52_;
		_tmp53_ = filename;
		_tmp54_ = string_delimit (_tmp53_, SEAHORSE_BAD_FILENAME_CHARS, '_');
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp55_);
		result = filename;
		_g_free0 (basename);
		_g_object_unref0 (data);
		return result;
	}
}

static GList*
seahorse_ssh_exporter_real_get_objects (SeahorseExporter* base)
{
	SeahorseSshExporter * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseSshExporter*) base;
	_tmp0_ = self->priv->objects;
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_ssh_exporter_real_add_object (SeahorseExporter* base,
                                       GObject* object)
{
	SeahorseSshExporter * self;
	SeahorseSshKey* key = NULL;
	SeahorseSshKey* _tmp0_;
	SeahorseSshKey* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	SeahorseSshKey* _tmp8_;
	SeahorseSshKey* _tmp9_;
	SeahorseSshKey* _tmp10_;
	SeahorseSshKey* _tmp11_;
	gboolean result;
	self = (SeahorseSshExporter*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (SEAHORSE_SSH_IS_KEY (object) ? ((SeahorseSshKey*) object) : NULL);
	key = _tmp0_;
	_tmp1_ = key;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (key);
		return result;
	}
	_tmp3_ = seahorse_ssh_exporter_get_secret (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		SeahorseSshKey* _tmp5_;
		SeahorseUsage _tmp6_;
		SeahorseUsage _tmp7_;
		_tmp5_ = key;
		_tmp6_ = seahorse_object_get_usage ((SeahorseObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != SEAHORSE_USAGE_PRIVATE_KEY;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (key);
		return result;
	}
	_tmp8_ = key;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->key);
	self->priv->key = _tmp9_;
	_tmp10_ = self->priv->key;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	self->priv->objects = g_list_append (self->priv->objects, _tmp11_);
	g_object_notify ((GObject*) self, "filename");
	result = TRUE;
	_g_object_unref0 (key);
	return result;
}

static void
seahorse_ssh_exporter_real_export_data_free (gpointer _data)
{
	SeahorseSshExporterExportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshExporterExportData, _data_);
}

static void
seahorse_ssh_exporter_real_export (SeahorseExporter* base,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SeahorseSshExporter * self;
	SeahorseSshExporterExportData* _data_;
	SeahorseSshExporter* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseSshExporter*) base;
	_data_ = g_slice_new0 (SeahorseSshExporterExportData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_exporter_real_export_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_ssh_exporter_real_export_co (_data_);
}

static guint8*
seahorse_ssh_exporter_export_finish (SeahorseExporter* base,
                                     GAsyncResult* _res_,
                                     size_t* result_length1,
                                     GError** error)
{
	guint8* result;
	SeahorseSshExporterExportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
seahorse_ssh_exporter_real_export_co (SeahorseSshExporterExportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->key;
	_data_->_tmp1_ = seahorse_ssh_key_get_key_data (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->keydata = _data_->_tmp3_;
	_data_->_tmp4_ = seahorse_ssh_exporter_get_secret (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_) {
		_data_->_tmp7_ = _data_->self->priv->key;
		_data_->_tmp8_ = seahorse_object_get_place ((SeahorseObject*) _data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->self->priv->key;
		_data_->_tmp11_ = seahorse_ssh_source_export_private (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource), _data_->_tmp10_, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->keydata);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = 0;
		_data_->_tmp12_ = string_get_data (_data_->_tmp6_, &_data_->_tmp13_);
		_data_->_tmp12__length1 = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->_tmp12_;
		_data_->_tmp14__length1 = _data_->_tmp12__length1;
		_data_->_tmp15_ = (_data_->_tmp14_ != NULL) ? _vala_array_dup1 (_data_->_tmp14_, _data_->_tmp14__length1) : _data_->_tmp14_;
		_data_->_tmp15__length1 = _data_->_tmp14__length1;
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp16__length1 = _data_->_tmp15__length1;
		_data_->result_length1 = _data_->_tmp16__length1;
		_data_->result = _data_->_tmp16_;
		_g_free0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->keydata);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->keydata;
	_data_->_tmp18_ = seahorse_ssh_key_data_get_pubfile (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	if (_data_->_tmp19_ == NULL) {
		_data_->_tmp20_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _ ("No public key file is available for this key."));
		_data_->_inner_error0_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->keydata);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->keydata;
	_data_->_tmp22_ = seahorse_ssh_key_data_get_rawdata (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_vala_assert (_data_->_tmp23_ != NULL, "keydata.rawdata != null");
	_data_->_tmp24_ = _data_->keydata;
	_data_->_tmp25_ = seahorse_ssh_key_data_get_rawdata (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = g_strdup_printf ("%s\n", _data_->_tmp26_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp30_ = 0;
	_data_->_tmp29_ = string_get_data (_data_->_tmp28_, &_data_->_tmp30_);
	_data_->_tmp29__length1 = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->_tmp29_;
	_data_->_tmp31__length1 = _data_->_tmp29__length1;
	_data_->_tmp32_ = (_data_->_tmp31_ != NULL) ? _vala_array_dup2 (_data_->_tmp31_, _data_->_tmp31__length1) : _data_->_tmp31_;
	_data_->_tmp32__length1 = _data_->_tmp31__length1;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp33__length1 = _data_->_tmp32__length1;
	_g_free0 (_data_->_tmp28_);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp34__length1 = _data_->_tmp33__length1;
	_data_->result_length1 = _data_->_tmp34__length1;
	_data_->result = _data_->_tmp34_;
	_g_object_unref0 (_data_->keydata);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
seahorse_ssh_exporter_get_secret (SeahorseSshExporter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_secret;
	return result;
}

void
seahorse_ssh_exporter_set_secret (SeahorseSshExporter* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_secret = value;
	g_object_notify ((GObject*) self, "filename");
	g_object_notify ((GObject*) self, "file-filter");
	g_object_notify ((GObject*) self, "content-type");
	g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY]);
}

static gchar*
seahorse_ssh_exporter_real_get_filename (SeahorseExporter* base)
{
	gchar* result;
	SeahorseSshExporter* self;
	gchar* _tmp0_;
	self = (SeahorseSshExporter*) base;
	_tmp0_ = seahorse_ssh_exporter_get_filename (self);
	result = _tmp0_;
	return result;
}

static const gchar*
seahorse_ssh_exporter_real_get_content_type (SeahorseExporter* base)
{
	const gchar* result;
	SeahorseSshExporter* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (SeahorseSshExporter*) base;
	_tmp1_ = seahorse_ssh_exporter_get_secret (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = "application/x-pem-key";
	} else {
		_tmp0_ = "application/x-ssh-key";
	}
	result = _tmp0_;
	return result;
}

static GtkFileFilter*
seahorse_ssh_exporter_real_get_file_filter (SeahorseExporter* base)
{
	GtkFileFilter* result;
	SeahorseSshExporter* self;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (SeahorseSshExporter*) base;
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	filter = _tmp0_;
	_tmp1_ = seahorse_ssh_exporter_get_secret (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkFileFilter* _tmp3_;
		GtkFileFilter* _tmp4_;
		GtkFileFilter* _tmp5_;
		_tmp3_ = filter;
		gtk_buildable_set_name ((GtkBuildable*) _tmp3_, _ ("Secret SSH keys"));
		_tmp4_ = filter;
		gtk_file_filter_add_mime_type (_tmp4_, "application/x-pem-key");
		_tmp5_ = filter;
		gtk_file_filter_add_pattern (_tmp5_, "id_*");
	} else {
		GtkFileFilter* _tmp6_;
		GtkFileFilter* _tmp7_;
		GtkFileFilter* _tmp8_;
		_tmp6_ = filter;
		gtk_buildable_set_name ((GtkBuildable*) _tmp6_, _ ("Public SSH keys"));
		_tmp7_ = filter;
		gtk_file_filter_add_mime_type (_tmp7_, "application/x-ssh-key");
		_tmp8_ = filter;
		gtk_file_filter_add_pattern (_tmp8_, "*.pub");
	}
	result = filter;
	return result;
}

static void
seahorse_ssh_exporter_class_init (SeahorseSshExporterClass * klass,
                                  gpointer klass_data)
{
	seahorse_ssh_exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshExporter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_exporter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_exporter_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_exporter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY, seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY] = g_param_spec_boolean ("secret", "secret", "secret", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_EXPORTER_FILENAME_PROPERTY, seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_EXPORTER_CONTENT_TYPE_PROPERTY, seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_CONTENT_TYPE_PROPERTY] = g_param_spec_string ("content-type", "content-type", "content-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_EXPORTER_FILE_FILTER_PROPERTY, seahorse_ssh_exporter_properties[SEAHORSE_SSH_EXPORTER_FILE_FILTER_PROPERTY] = g_param_spec_object ("file-filter", "file-filter", "file-filter", gtk_file_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_ssh_exporter_seahorse_exporter_interface_init (SeahorseExporterIface * iface,
                                                        gpointer iface_data)
{
	seahorse_ssh_exporter_seahorse_exporter_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_objects = (GList* (*) (SeahorseExporter*)) seahorse_ssh_exporter_real_get_objects;
	iface->add_object = (gboolean (*) (SeahorseExporter*, GObject*)) seahorse_ssh_exporter_real_add_object;
	iface->export = (void (*) (SeahorseExporter*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_ssh_exporter_real_export;
	iface->export_finish = (guint8* (*) (SeahorseExporter*, GAsyncResult*, size_t*, GError**)) seahorse_ssh_exporter_export_finish;
	iface->get_filename = seahorse_ssh_exporter_real_get_filename;
	iface->get_content_type = seahorse_ssh_exporter_real_get_content_type;
	iface->get_file_filter = seahorse_ssh_exporter_real_get_file_filter;
}

static void
seahorse_ssh_exporter_instance_init (SeahorseSshExporter * self,
                                     gpointer klass)
{
	self->priv = seahorse_ssh_exporter_get_instance_private (self);
}

static void
seahorse_ssh_exporter_finalize (GObject * obj)
{
	SeahorseSshExporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporter);
	_g_object_unref0 (self->priv->key);
	(self->priv->objects == NULL) ? NULL : (self->priv->objects = (_g_list_free__g_object_unref0_ (self->priv->objects), NULL));
	G_OBJECT_CLASS (seahorse_ssh_exporter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshExporter), 0, (GInstanceInitFunc) seahorse_ssh_exporter_instance_init, NULL };
	static const GInterfaceInfo seahorse_exporter_info = { (GInterfaceInitFunc) seahorse_ssh_exporter_seahorse_exporter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_ssh_exporter_type_id;
	seahorse_ssh_exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshExporter", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_ssh_exporter_type_id, SEAHORSE_TYPE_EXPORTER, &seahorse_exporter_info);
	SeahorseSshExporter_private_offset = g_type_add_instance_private (seahorse_ssh_exporter_type_id, sizeof (SeahorseSshExporterPrivate));
	return seahorse_ssh_exporter_type_id;
}

GType
seahorse_ssh_exporter_get_type (void)
{
	static volatile gsize seahorse_ssh_exporter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_exporter_type_id__once)) {
		GType seahorse_ssh_exporter_type_id;
		seahorse_ssh_exporter_type_id = seahorse_ssh_exporter_get_type_once ();
		g_once_init_leave (&seahorse_ssh_exporter_type_id__once, seahorse_ssh_exporter_type_id);
	}
	return seahorse_ssh_exporter_type_id__once;
}

static void
_vala_seahorse_ssh_exporter_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshExporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporter);
	switch (property_id) {
		case SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY:
		g_value_set_boolean (value, seahorse_ssh_exporter_get_secret (self));
		break;
		case SEAHORSE_SSH_EXPORTER_FILENAME_PROPERTY:
		g_value_take_string (value, seahorse_exporter_get_filename ((SeahorseExporter*) self));
		break;
		case SEAHORSE_SSH_EXPORTER_CONTENT_TYPE_PROPERTY:
		g_value_set_string (value, seahorse_exporter_get_content_type ((SeahorseExporter*) self));
		break;
		case SEAHORSE_SSH_EXPORTER_FILE_FILTER_PROPERTY:
		g_value_take_object (value, seahorse_exporter_get_file_filter ((SeahorseExporter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_exporter_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshExporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_EXPORTER, SeahorseSshExporter);
	switch (property_id) {
		case SEAHORSE_SSH_EXPORTER_SECRET_PROPERTY:
		seahorse_ssh_exporter_set_secret (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

