/* sidebar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sidebar.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "seahorse-common.h"
#include <gcr/gcr-base.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SEAHORSE_TYPE_SIDEBAR (seahorse_sidebar_get_type ())
#define SEAHORSE_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar))
#define SEAHORSE_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebarClass))
#define SEAHORSE_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_SIDEBAR))
#define SEAHORSE_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_SIDEBAR))
#define SEAHORSE_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_SIDEBAR, SeahorseSidebarClass))

typedef struct _SeahorseSidebar SeahorseSidebar;
typedef struct _SeahorseSidebarClass SeahorseSidebarClass;
typedef struct _SeahorseSidebarPrivate SeahorseSidebarPrivate;
enum  {
	SEAHORSE_SIDEBAR_0_PROPERTY,
	SEAHORSE_SIDEBAR_OBJECTS_PROPERTY,
	SEAHORSE_SIDEBAR_NUM_PROPERTIES
};
static GParamSpec* seahorse_sidebar_properties[SEAHORSE_SIDEBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SEAHORSE_TYPE_SIDEBAR_ITEM (seahorse_sidebar_item_get_type ())
#define SEAHORSE_SIDEBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem))
#define SEAHORSE_SIDEBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItemClass))
#define SEAHORSE_IS_SIDEBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_SIDEBAR_ITEM))
#define SEAHORSE_IS_SIDEBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_SIDEBAR_ITEM))
#define SEAHORSE_SIDEBAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItemClass))

typedef struct _SeahorseSidebarItem SeahorseSidebarItem;
typedef struct _SeahorseSidebarItemClass SeahorseSidebarItemClass;
enum  {
	SEAHORSE_SIDEBAR_CURRENT_COLLECTION_CHANGED_SIGNAL,
	SEAHORSE_SIDEBAR_NUM_SIGNALS
};
static guint seahorse_sidebar_signals[SEAHORSE_SIDEBAR_NUM_SIGNALS] = {0};
typedef struct _SeahorseSidebarItemPrivate SeahorseSidebarItemPrivate;
enum  {
	SEAHORSE_SIDEBAR_ITEM_0_PROPERTY,
	SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY,
	SEAHORSE_SIDEBAR_ITEM_NUM_PROPERTIES
};
static GParamSpec* seahorse_sidebar_item_properties[SEAHORSE_SIDEBAR_ITEM_NUM_PROPERTIES];
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
enum  {
	SEAHORSE_SIDEBAR_ITEM_PLACE_CHANGED_SIGNAL,
	SEAHORSE_SIDEBAR_ITEM_NUM_SIGNALS
};
static guint seahorse_sidebar_item_signals[SEAHORSE_SIDEBAR_ITEM_NUM_SIGNALS] = {0};

struct _SeahorseSidebar {
	GtkListBox parent_instance;
	SeahorseSidebarPrivate * priv;
};

struct _SeahorseSidebarClass {
	GtkListBoxClass parent_class;
};

struct _SeahorseSidebarPrivate {
	GListStore* store;
	GList* backends;
	GcrUnionCollection* _objects;
};

struct _SeahorseSidebarItem {
	GtkListBoxRow parent_instance;
	SeahorseSidebarItemPrivate * priv;
};

struct _SeahorseSidebarItemClass {
	GtkListBoxRowClass parent_class;
};

struct _SeahorseSidebarItemPrivate {
	GtkButton* lock_button;
	SeahorsePlace* _place;
};

struct _Block5Data {
	int _ref_count_;
	SeahorseSidebarItem* self;
	gboolean visible;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkMenuItem* item;
};

struct _Block7Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkMenuItem* item;
};

struct _Block8Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkMenuItem* item;
};

struct _Block9Data {
	int _ref_count_;
	SeahorseSidebarItem* self;
	SeahorseLockable* lockable;
	GtkWindow* window;
};

struct _Block10Data {
	int _ref_count_;
	SeahorseSidebarItem* self;
	SeahorseLockable* lockable;
	GtkWindow* window;
};

struct _Block11Data {
	int _ref_count_;
	SeahorseSidebarItem* self;
	SeahorseDeleter* deleter;
};

struct _Block12Data {
	int _ref_count_;
	SeahorseSidebarItem* self;
	SeahorseLockable* lockable;
};

static gint SeahorseSidebar_private_offset;
static gpointer seahorse_sidebar_parent_class = NULL;
static gint SeahorseSidebarItem_private_offset;
static gpointer seahorse_sidebar_item_parent_class = NULL;

VALA_EXTERN GType seahorse_sidebar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSidebar, g_object_unref)
static void seahorse_sidebar_on_place_removed (SeahorseSidebar* self,
                                        GcrCollection* backend,
                                        GObject* place_obj);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_sidebar_load_backends (SeahorseSidebar* self);
static void seahorse_sidebar_on_place_added (SeahorseSidebar* self,
                                      GcrCollection* backend,
                                      GObject* place_obj);
static void _seahorse_sidebar_on_place_added_gcr_collection_added (GcrCollection* _sender,
                                                            GObject* object,
                                                            gpointer self);
static void _seahorse_sidebar_on_place_removed_gcr_collection_removed (GcrCollection* _sender,
                                                                GObject* object,
                                                                gpointer self);
static void seahorse_sidebar_on_backend_changed (SeahorseSidebar* self,
                                          GObject* obj,
                                          GParamSpec* spec);
static void _seahorse_sidebar_on_backend_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static gint seahorse_sidebar_compare_places (SeahorseSidebar* self,
                                      GObject* obj_a,
                                      GObject* obj_b);
static gint _seahorse_sidebar_compare_places_gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
static void seahorse_sidebar_on_place_changed (SeahorseSidebar* self,
                                        GObject* obj,
                                        GParamSpec* pspec);
static void _seahorse_sidebar_on_place_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void seahorse_sidebar_update_places (SeahorseSidebar* self);
static GtkWidget* seahorse_sidebar_place_widget_create_cb (SeahorseSidebar* self,
                                                    GObject* object);
VALA_EXTERN GType seahorse_sidebar_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSidebarItem, g_object_unref)
VALA_EXTERN SeahorseSidebarItem* seahorse_sidebar_item_new (SeahorsePlace* place);
VALA_EXTERN SeahorseSidebarItem* seahorse_sidebar_item_construct (GType object_type,
                                                      SeahorsePlace* place);
static void seahorse_sidebar_on_sidebar_item_changed (SeahorseSidebar* self,
                                               SeahorseSidebarItem* item);
static void _seahorse_sidebar_on_sidebar_item_changed_seahorse_sidebar_item_place_changed (SeahorseSidebarItem* _sender,
                                                                                    gpointer self);
static void seahorse_sidebar_place_header_cb (SeahorseSidebar* self,
                                       GtkListBoxRow* row,
                                       GtkListBoxRow* before);
VALA_EXTERN SeahorsePlace* seahorse_sidebar_item_get_place (SeahorseSidebarItem* self);
static void seahorse_sidebar_on_row_selected (SeahorseSidebar* self,
                                       GtkListBoxRow* row);
VALA_EXTERN GcrUnionCollection* seahorse_sidebar_get_objects (SeahorseSidebar* self);
static void seahorse_sidebar_update_backend (SeahorseSidebar* self,
                                      SeahorseBackend* backend);
static gboolean seahorse_sidebar_real_popup_menu (GtkWidget* base);
VALA_EXTERN void seahorse_sidebar_item_show_popup_menu (SeahorseSidebarItem* self);
static gboolean seahorse_sidebar_real_button_press_event (GtkWidget* base,
                                                   GdkEventButton* event);
VALA_EXTERN GList* seahorse_sidebar_get_selected_places (SeahorseSidebar* self);
VALA_EXTERN SeahorsePlace* seahorse_sidebar_get_focused_place (SeahorseSidebar* self);
VALA_EXTERN gboolean seahorse_sidebar_set_focused_place_for_uri (SeahorseSidebar* self,
                                                     const gchar* uri);
VALA_EXTERN gboolean seahorse_sidebar_set_focused_place_for_scheme (SeahorseSidebar* self,
                                                        const gchar* uri_scheme);
VALA_EXTERN void seahorse_sidebar_select_next_place (SeahorseSidebar* self);
static void seahorse_sidebar_select_relative (SeahorseSidebar* self,
                                       gint positions);
VALA_EXTERN void seahorse_sidebar_select_previous_place (SeahorseSidebar* self);
VALA_EXTERN GList* seahorse_sidebar_get_backends (SeahorseSidebar* self);
VALA_EXTERN SeahorseSidebar* seahorse_sidebar_new (void);
VALA_EXTERN SeahorseSidebar* seahorse_sidebar_construct (GType object_type);
static void seahorse_sidebar_set_objects (SeahorseSidebar* self,
                                   GcrUnionCollection* value);
static GObject * seahorse_sidebar_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static GtkWidget* _seahorse_sidebar_place_widget_create_cb_gtk_list_box_create_widget_func (GObject* item,
                                                                                     gpointer self);
static void _seahorse_sidebar_place_header_cb_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                        GtkListBoxRow* before,
                                                                        gpointer self);
static void _seahorse_sidebar_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self);
static void seahorse_sidebar_finalize (GObject * obj);
static GType seahorse_sidebar_get_type_once (void);
static void _vala_seahorse_sidebar_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_seahorse_sidebar_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static const gchar* seahorse_sidebar_item_get_lock_icon_name (SeahorseLockable* lockable);
static void seahorse_sidebar_item_update_lock_icon (SeahorseSidebarItem* self,
                                             SeahorseLockable* lockable);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda7_ (Block6Data* _data6_);
static void seahorse_sidebar_item_on_place_lock (SeahorseSidebarItem* self,
                                          GtkWidget* widget,
                                          SeahorseLockable* lockable);
static void ____lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void ___lambda9_ (Block6Data* _data6_);
static void seahorse_sidebar_item_on_place_unlock (SeahorseSidebarItem* self,
                                            GtkMenuItem* widget,
                                            SeahorseLockable* lockable);
static void ____lambda9__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda11_ (Block7Data* _data7_);
static void seahorse_sidebar_item_on_place_delete (SeahorseSidebarItem* self,
                                            GtkMenuItem* item,
                                            SeahorseDeletable* deletable);
static void ____lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda13_ (Block8Data* _data8_);
static void ____lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void __lambda14_ (Block5Data* _data5_,
                  GtkWidget* widget);
static void ___lambda14__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void seahorse_sidebar_item_place_lock (SeahorseSidebarItem* self,
                                       SeahorseLockable* lockable,
                                       GtkWindow* window);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda8_ (Block9Data* _data9_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void seahorse_sidebar_item_place_unlock (SeahorseSidebarItem* self,
                                         SeahorseLockable* lockable,
                                         GtkWindow* window);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda10_ (Block10Data* _data10_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda12_ (Block11Data* _data11_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda12__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void seahorse_sidebar_item_set_place (SeahorseSidebarItem* self,
                                      SeahorsePlace* value);
static GObject * seahorse_sidebar_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void _seahorse_sidebar_item____lambda15_ (Block12Data* _data12_,
                                          GtkButton* b);
static void __seahorse_sidebar_item____lambda15__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void seahorse_sidebar_item_finalize (GObject * obj);
static GType seahorse_sidebar_item_get_type_once (void);
static void _vala_seahorse_sidebar_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_sidebar_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
seahorse_sidebar_get_instance_private (SeahorseSidebar* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSidebar_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_seahorse_sidebar_on_place_added_gcr_collection_added (GcrCollection* _sender,
                                                       GObject* object,
                                                       gpointer self)
{
	seahorse_sidebar_on_place_added ((SeahorseSidebar*) self, _sender, object);
}

static void
_seahorse_sidebar_on_place_removed_gcr_collection_removed (GcrCollection* _sender,
                                                           GObject* object,
                                                           gpointer self)
{
	seahorse_sidebar_on_place_removed ((SeahorseSidebar*) self, _sender, object);
}

static void
_seahorse_sidebar_on_backend_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	seahorse_sidebar_on_backend_changed ((SeahorseSidebar*) self, _sender, pspec);
}

static void
seahorse_sidebar_load_backends (SeahorseSidebar* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = seahorse_backend_get_registered ();
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp0_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* _tmp1_;
			SeahorseBackend* backend = NULL;
			_tmp1_ = _g_object_ref0 ((SeahorseBackend*) backend_it->data);
			backend = _tmp1_;
			{
				SeahorseBackend* _tmp2_;
				SeahorseBackend* _tmp3_;
				SeahorseBackend* _tmp4_;
				SeahorseBackend* _tmp5_;
				SeahorseBackend* _tmp6_;
				SeahorseBackend* _tmp7_;
				GList* _tmp8_;
				_tmp2_ = backend;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				self->priv->backends = g_list_append (self->priv->backends, _tmp3_);
				_tmp4_ = backend;
				g_signal_connect_object ((GcrCollection*) _tmp4_, "added", (GCallback) _seahorse_sidebar_on_place_added_gcr_collection_added, self, 0);
				_tmp5_ = backend;
				g_signal_connect_object ((GcrCollection*) _tmp5_, "removed", (GCallback) _seahorse_sidebar_on_place_removed_gcr_collection_removed, self, 0);
				_tmp6_ = backend;
				g_signal_connect_object ((GObject*) _tmp6_, "notify", (GCallback) _seahorse_sidebar_on_backend_changed_g_object_notify, self, 0);
				_tmp7_ = backend;
				_tmp8_ = gcr_collection_get_objects ((GcrCollection*) _tmp7_);
				{
					GList* obj_collection = NULL;
					GList* obj_it = NULL;
					obj_collection = _tmp8_;
					for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
						GObject* obj = NULL;
						obj = (GObject*) obj_it->data;
						{
							SeahorseBackend* _tmp9_;
							GObject* _tmp10_;
							_tmp9_ = backend;
							_tmp10_ = obj;
							seahorse_sidebar_on_place_added (self, (GcrCollection*) _tmp9_, _tmp10_);
						}
					}
					(obj_collection == NULL) ? NULL : (obj_collection = (g_list_free (obj_collection), NULL));
				}
				_g_object_unref0 (backend);
			}
		}
		(backend_collection == NULL) ? NULL : (backend_collection = (_g_list_free__g_object_unref0_ (backend_collection), NULL));
	}
}

static gint
_seahorse_sidebar_compare_places_gcompare_data_func (gconstpointer a,
                                                     gconstpointer b,
                                                     gpointer self)
{
	gint result;
	result = seahorse_sidebar_compare_places ((SeahorseSidebar*) self, (GObject*) a, (GObject*) b);
	return result;
}

static void
_seahorse_sidebar_on_place_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	seahorse_sidebar_on_place_changed ((SeahorseSidebar*) self, _sender, pspec);
}

static void
seahorse_sidebar_on_place_added (SeahorseSidebar* self,
                                 GcrCollection* backend,
                                 GObject* place_obj)
{
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_;
	SeahorsePlace* _tmp1_;
	SeahorsePlace* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	SeahorsePlace* _tmp7_;
	SeahorsePlace* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (place_obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (place_obj, SEAHORSE_TYPE_PLACE) ? ((SeahorsePlace*) place_obj) : NULL);
	place = _tmp0_;
	_tmp1_ = place;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = place;
	_tmp3_ = seahorse_place_get_label (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	g_debug ("sidebar.vala:69: New place '%s' added", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp7_ = place;
	if (gcr_collection_get_length ((GcrCollection*) _tmp7_) > ((guint) 0)) {
		_tmp6_ = TRUE;
	} else {
		SeahorsePlace* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = place;
		_tmp9_ = seahorse_place_get_show_if_empty (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	}
	if (_tmp6_) {
		GListStore* _tmp11_;
		SeahorsePlace* _tmp12_;
		_tmp11_ = self->priv->store;
		_tmp12_ = place;
		g_list_store_insert_sorted (_tmp11_, (GObject*) _tmp12_, _seahorse_sidebar_compare_places_gcompare_data_func, self);
	}
	_tmp13_ = place;
	g_signal_connect_object ((GObject*) _tmp13_, "notify", (GCallback) _seahorse_sidebar_on_place_changed_g_object_notify, self, 0);
	_g_object_unref0 (place);
}

static void
seahorse_sidebar_on_place_changed (SeahorseSidebar* self,
                                   GObject* obj,
                                   GParamSpec* pspec)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	seahorse_sidebar_update_places (self);
}

static void
seahorse_sidebar_on_place_removed (SeahorseSidebar* self,
                                   GcrCollection* backend,
                                   GObject* place_obj)
{
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_;
	SeahorsePlace* _tmp1_;
	SeahorsePlace* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (place_obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (place_obj, SEAHORSE_TYPE_PLACE) ? ((SeahorsePlace*) place_obj) : NULL);
	place = _tmp0_;
	_tmp1_ = place;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = place;
	_tmp3_ = seahorse_place_get_label (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	g_debug ("sidebar.vala:84: Place '%s' removed", _tmp5_);
	_g_free0 (_tmp5_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GListStore* _tmp8_;
				GListStore* _tmp9_;
				GObject* _tmp10_;
				GObject* _tmp11_;
				SeahorsePlace* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp6_) {
					guint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->store;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp8_))) {
					break;
				}
				_tmp9_ = self->priv->store;
				_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, i);
				_tmp11_ = _tmp10_;
				_tmp12_ = place;
				_tmp13_ = _tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject);
				_g_object_unref0 (_tmp11_);
				if (_tmp13_) {
					GListStore* _tmp14_;
					_tmp14_ = self->priv->store;
					g_list_store_remove (_tmp14_, i);
					break;
				}
			}
		}
	}
	_g_object_unref0 (place);
}

static void
seahorse_sidebar_on_backend_changed (SeahorseSidebar* self,
                                     GObject* obj,
                                     GParamSpec* spec)
{
	SeahorseBackend* backend = NULL;
	SeahorseBackend* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_BACKEND, SeahorseBackend));
	backend = _tmp0_;
	_tmp1_ = seahorse_backend_get_label (backend);
	_tmp2_ = _tmp1_;
	g_debug ("sidebar.vala:95: Backend '%s' changed", _tmp2_);
	seahorse_sidebar_update_places (self);
	_g_object_unref0 (backend);
}

static void
_seahorse_sidebar_on_sidebar_item_changed_seahorse_sidebar_item_place_changed (SeahorseSidebarItem* _sender,
                                                                               gpointer self)
{
	seahorse_sidebar_on_sidebar_item_changed ((SeahorseSidebar*) self, _sender);
}

static GtkWidget*
seahorse_sidebar_place_widget_create_cb (SeahorseSidebar* self,
                                         GObject* object)
{
	SeahorseSidebarItem* item = NULL;
	SeahorseSidebarItem* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = seahorse_sidebar_item_new (G_TYPE_CHECK_INSTANCE_TYPE (object, SEAHORSE_TYPE_PLACE) ? ((SeahorsePlace*) object) : NULL);
	g_object_ref_sink (_tmp0_);
	item = _tmp0_;
	g_signal_connect_object (item, "place-changed", (GCallback) _seahorse_sidebar_on_sidebar_item_changed_seahorse_sidebar_item_place_changed, self, 0);
	result = (GtkWidget*) item;
	return result;
}

static void
seahorse_sidebar_on_sidebar_item_changed (SeahorseSidebar* self,
                                          SeahorseSidebarItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) item);
	g_signal_emit (self, seahorse_sidebar_signals[SEAHORSE_SIDEBAR_CURRENT_COLLECTION_CHANGED_SIGNAL], 0);
}

static void
seahorse_sidebar_place_header_cb (SeahorseSidebar* self,
                                  GtkListBoxRow* row,
                                  GtkListBoxRow* before)
{
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_;
	SeahorsePlace* _tmp1_;
	SeahorsePlace* _tmp2_;
	GtkLabel* label = NULL;
	SeahorsePlace* _tmp12_;
	SeahorsePlaceCategory _tmp13_;
	SeahorsePlaceCategory _tmp14_;
	const gchar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = seahorse_sidebar_item_get_place (G_TYPE_CHECK_INSTANCE_CAST (row, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	place = _tmp2_;
	if (before != NULL) {
		SeahorsePlace* before_place = NULL;
		SeahorsePlace* _tmp3_;
		SeahorsePlace* _tmp4_;
		SeahorsePlace* _tmp5_;
		SeahorsePlace* _tmp6_;
		SeahorsePlaceCategory _tmp7_;
		SeahorsePlaceCategory _tmp8_;
		SeahorsePlace* _tmp9_;
		SeahorsePlaceCategory _tmp10_;
		SeahorsePlaceCategory _tmp11_;
		_tmp3_ = seahorse_sidebar_item_get_place (G_TYPE_CHECK_INSTANCE_CAST (before, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem));
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		before_place = _tmp5_;
		_tmp6_ = place;
		_tmp7_ = seahorse_place_get_category (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = before_place;
		_tmp10_ = seahorse_place_get_category (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp8_ == _tmp11_) {
			gtk_list_box_row_set_header (row, NULL);
			_g_object_unref0 (before_place);
			_g_object_unref0 (place);
			return;
		}
		_g_object_unref0 (before_place);
	}
	_tmp12_ = place;
	_tmp13_ = seahorse_place_get_category (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = seahorse_place_category_to_string (_tmp14_);
	_tmp16_ = (GtkLabel*) gtk_label_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	label = _tmp16_;
	_tmp17_ = label;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "seahorse-sidebar-item-header");
	_tmp19_ = label;
	gtk_label_set_xalign (_tmp19_, 0.f);
	_tmp20_ = label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 9);
	_tmp21_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 6);
	_tmp22_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp22_, 3);
	_tmp23_ = label;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = label;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp24_);
	_g_object_unref0 (label);
	_g_object_unref0 (place);
}

static gint
seahorse_sidebar_compare_places (SeahorseSidebar* self,
                                 GObject* obj_a,
                                 GObject* obj_b)
{
	SeahorsePlace* a = NULL;
	SeahorsePlace* _tmp0_;
	SeahorsePlace* b = NULL;
	SeahorsePlace* _tmp1_;
	SeahorsePlace* _tmp2_;
	SeahorsePlaceCategory _tmp3_;
	SeahorsePlaceCategory _tmp4_;
	SeahorsePlace* _tmp5_;
	SeahorsePlaceCategory _tmp6_;
	SeahorsePlaceCategory _tmp7_;
	SeahorsePlace* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	SeahorsePlace* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gint _tmp26_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (obj_a != NULL, 0);
	g_return_val_if_fail (obj_b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj_a, SEAHORSE_TYPE_PLACE, SeahorsePlace));
	a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj_b, SEAHORSE_TYPE_PLACE, SeahorsePlace));
	b = _tmp1_;
	_tmp2_ = a;
	_tmp3_ = seahorse_place_get_category (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = seahorse_place_get_category (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp4_ != _tmp7_) {
		SeahorsePlace* _tmp8_;
		SeahorsePlaceCategory _tmp9_;
		SeahorsePlaceCategory _tmp10_;
		SeahorsePlace* _tmp11_;
		SeahorsePlaceCategory _tmp12_;
		SeahorsePlaceCategory _tmp13_;
		_tmp8_ = a;
		_tmp9_ = seahorse_place_get_category (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = b;
		_tmp12_ = seahorse_place_get_category (_tmp11_);
		_tmp13_ = _tmp12_;
		result = ((gint) _tmp10_) - ((gint) _tmp13_);
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	_tmp14_ = a;
	_tmp15_ = seahorse_place_get_label (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = g_utf8_casefold (_tmp17_, (gssize) -1);
	_tmp19_ = _tmp18_;
	_tmp20_ = b;
	_tmp21_ = seahorse_place_get_label (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp24_ = g_utf8_casefold (_tmp23_, (gssize) -1);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_utf8_collate (_tmp19_, _tmp25_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	result = _tmp26_;
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}

static void
seahorse_sidebar_on_row_selected (SeahorseSidebar* self,
                                  GtkListBoxRow* row)
{
	GcrUnionCollection* _tmp0_;
	GList* _tmp1_;
	SeahorseSidebarItem* selected = NULL;
	SeahorseSidebarItem* _tmp4_;
	SeahorseSidebarItem* _tmp5_;
	GcrUnionCollection* _tmp6_;
	GList* _tmp7_;
	GcrUnionCollection* _tmp14_;
	SeahorseSidebarItem* _tmp15_;
	SeahorsePlace* _tmp16_;
	SeahorsePlace* _tmp17_;
	g_return_if_fail (self != NULL);
	g_debug ("sidebar.vala:146: Updating objects");
	_tmp0_ = self->priv->_objects;
	_tmp1_ = gcr_union_collection_elements (_tmp0_);
	{
		GList* place_collection = NULL;
		GList* place_it = NULL;
		place_collection = _tmp1_;
		for (place_it = place_collection; place_it != NULL; place_it = place_it->next) {
			GcrCollection* place = NULL;
			place = (GcrCollection*) place_it->data;
			{
				GcrUnionCollection* _tmp2_;
				GcrCollection* _tmp3_;
				_tmp2_ = self->priv->_objects;
				_tmp3_ = place;
				gcr_union_collection_remove (_tmp2_, _tmp3_);
			}
		}
		(place_collection == NULL) ? NULL : (place_collection = (g_list_free (place_collection), NULL));
	}
	_tmp4_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (row) ? ((SeahorseSidebarItem*) row) : NULL);
	selected = _tmp4_;
	_tmp5_ = selected;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (selected);
		return;
	}
	_tmp6_ = self->priv->_objects;
	_tmp7_ = gcr_union_collection_elements (_tmp6_);
	{
		GList* place_collection = NULL;
		GList* place_it = NULL;
		place_collection = _tmp7_;
		for (place_it = place_collection; place_it != NULL; place_it = place_it->next) {
			GcrCollection* place = NULL;
			place = (GcrCollection*) place_it->data;
			{
				SeahorseSidebarItem* _tmp8_;
				SeahorsePlace* _tmp9_;
				SeahorsePlace* _tmp10_;
				GcrCollection* _tmp11_;
				_tmp8_ = selected;
				_tmp9_ = seahorse_sidebar_item_get_place (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = place;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gcr_collection_get_type (), GcrCollection) != _tmp11_) {
					GcrUnionCollection* _tmp12_;
					GcrCollection* _tmp13_;
					_tmp12_ = self->priv->_objects;
					_tmp13_ = place;
					gcr_union_collection_remove (_tmp12_, _tmp13_);
				}
			}
		}
		(place_collection == NULL) ? NULL : (place_collection = (g_list_free (place_collection), NULL));
	}
	_tmp14_ = self->priv->_objects;
	_tmp15_ = selected;
	_tmp16_ = seahorse_sidebar_item_get_place (_tmp15_);
	_tmp17_ = _tmp16_;
	if (!gcr_union_collection_have (_tmp14_, (GcrCollection*) _tmp17_)) {
		GcrUnionCollection* _tmp18_;
		SeahorseSidebarItem* _tmp19_;
		SeahorsePlace* _tmp20_;
		SeahorsePlace* _tmp21_;
		_tmp18_ = self->priv->_objects;
		_tmp19_ = selected;
		_tmp20_ = seahorse_sidebar_item_get_place (_tmp19_);
		_tmp21_ = _tmp20_;
		gcr_union_collection_add (_tmp18_, (GcrCollection*) _tmp21_);
	}
	_g_object_unref0 (selected);
}

static void
seahorse_sidebar_update_places (SeahorseSidebar* self)
{
	SeahorseSidebarItem* old_selected = NULL;
	GtkListBoxRow* _tmp0_;
	SeahorseSidebarItem* _tmp1_;
	SeahorsePlace* place = NULL;
	SeahorseSidebarItem* _tmp2_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (_tmp0_) ? ((SeahorseSidebarItem*) _tmp0_) : NULL);
	old_selected = _tmp1_;
	place = NULL;
	_tmp2_ = old_selected;
	if (_tmp2_ != NULL) {
		SeahorseSidebarItem* _tmp3_;
		SeahorsePlace* _tmp4_;
		SeahorsePlace* _tmp5_;
		SeahorsePlace* _tmp6_;
		_tmp3_ = old_selected;
		_tmp4_ = seahorse_sidebar_item_get_place (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (place);
		place = _tmp6_;
	}
	_tmp7_ = self->priv->backends;
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp7_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* _tmp8_;
			SeahorseBackend* backend = NULL;
			_tmp8_ = _g_object_ref0 ((SeahorseBackend*) backend_it->data);
			backend = _tmp8_;
			{
				SeahorseBackend* _tmp9_;
				_tmp9_ = backend;
				seahorse_sidebar_update_backend (self, _tmp9_);
				_g_object_unref0 (backend);
			}
		}
	}
	gtk_list_box_invalidate_headers ((GtkListBox*) self);
	_g_object_unref0 (place);
	_g_object_unref0 (old_selected);
}

static void
seahorse_sidebar_update_backend (SeahorseSidebar* self,
                                 SeahorseBackend* backend)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcr_collection_get_objects ((GcrCollection*) backend);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_list_free (_tmp1_), NULL));
	if (_tmp2_) {
		return;
	}
	_tmp3_ = gcr_collection_get_objects ((GcrCollection*) backend);
	{
		GList* obj_collection = NULL;
		GList* obj_it = NULL;
		obj_collection = _tmp3_;
		for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
			GObject* obj = NULL;
			obj = (GObject*) obj_it->data;
			{
				SeahorsePlace* place = NULL;
				GObject* _tmp4_;
				SeahorsePlace* _tmp5_;
				gboolean already_in = FALSE;
				gboolean _tmp14_ = FALSE;
				_tmp4_ = obj;
				place = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, SEAHORSE_TYPE_PLACE) ? ((SeahorsePlace*) _tmp4_) : NULL;
				_tmp5_ = place;
				if (_tmp5_ == NULL) {
					continue;
				}
				already_in = FALSE;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							GListStore* _tmp8_;
							GListStore* _tmp9_;
							GObject* _tmp10_;
							GObject* _tmp11_;
							SeahorsePlace* _tmp12_;
							gboolean _tmp13_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = i;
								i = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->store;
							if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp8_))) {
								break;
							}
							_tmp9_ = self->priv->store;
							_tmp10_ = g_list_model_get_object ((GListModel*) _tmp9_, (guint) i);
							_tmp11_ = _tmp10_;
							_tmp12_ = place;
							_tmp13_ = _tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject);
							_g_object_unref0 (_tmp11_);
							if (_tmp13_) {
								already_in = TRUE;
								break;
							}
						}
					}
				}
				if (!already_in) {
					gboolean _tmp15_ = FALSE;
					SeahorsePlace* _tmp16_;
					_tmp16_ = place;
					if (gcr_collection_get_length ((GcrCollection*) _tmp16_) > ((guint) 0)) {
						_tmp15_ = TRUE;
					} else {
						SeahorsePlace* _tmp17_;
						gboolean _tmp18_;
						gboolean _tmp19_;
						_tmp17_ = place;
						_tmp18_ = seahorse_place_get_show_if_empty (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp15_ = _tmp19_;
					}
					_tmp14_ = _tmp15_;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					GListStore* _tmp20_;
					SeahorsePlace* _tmp21_;
					_tmp20_ = self->priv->store;
					_tmp21_ = place;
					g_list_store_insert_sorted (_tmp20_, (GObject*) _tmp21_, _seahorse_sidebar_compare_places_gcompare_data_func, self);
				}
			}
		}
		(obj_collection == NULL) ? NULL : (obj_collection = (g_list_free (obj_collection), NULL));
	}
}

static gboolean
seahorse_sidebar_real_popup_menu (GtkWidget* base)
{
	SeahorseSidebar * self;
	SeahorseSidebarItem* row = NULL;
	GtkListBoxRow* _tmp0_;
	SeahorseSidebarItem* _tmp1_;
	SeahorseSidebarItem* _tmp2_;
	SeahorseSidebarItem* _tmp3_;
	gboolean result;
	self = (SeahorseSidebar*) base;
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (_tmp0_) ? ((SeahorseSidebarItem*) _tmp0_) : NULL);
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (row);
		return result;
	}
	_tmp3_ = row;
	seahorse_sidebar_item_show_popup_menu (_tmp3_);
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

static gboolean
seahorse_sidebar_real_button_press_event (GtkWidget* base,
                                          GdkEventButton* event)
{
	SeahorseSidebar * self;
	gboolean _tmp0_ = FALSE;
	SeahorseSidebarItem* row = NULL;
	GtkListBoxRow* _tmp1_;
	SeahorseSidebarItem* _tmp2_;
	SeahorseSidebarItem* _tmp3_;
	gboolean result;
	self = (SeahorseSidebar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (GTK_WIDGET_CLASS (seahorse_sidebar_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), event)) {
		result = TRUE;
		return result;
	}
	if (event->button != ((guint) 3)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->type != GDK_BUTTON_PRESS;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) event->y);
	_tmp2_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (_tmp1_) ? ((SeahorseSidebarItem*) _tmp1_) : NULL);
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ != NULL) {
		SeahorseSidebarItem* _tmp4_;
		_tmp4_ = row;
		seahorse_sidebar_item_show_popup_menu (_tmp4_);
	}
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

GList*
seahorse_sidebar_get_selected_places (SeahorseSidebar* self)
{
	GList* places = NULL;
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	places = NULL;
	_tmp0_ = gtk_list_box_get_selected_rows ((GtkListBox*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				SeahorseSidebarItem* item = NULL;
				GtkListBoxRow* _tmp1_;
				SeahorseSidebarItem* _tmp2_;
				SeahorseSidebarItem* _tmp3_;
				_tmp1_ = row;
				_tmp2_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (_tmp1_) ? ((SeahorseSidebarItem*) _tmp1_) : NULL);
				item = _tmp2_;
				_tmp3_ = item;
				if (_tmp3_ != NULL) {
					SeahorseSidebarItem* _tmp4_;
					SeahorsePlace* _tmp5_;
					SeahorsePlace* _tmp6_;
					_tmp4_ = item;
					_tmp5_ = seahorse_sidebar_item_get_place (_tmp4_);
					_tmp6_ = _tmp5_;
					places = g_list_append (places, (GcrCollection*) _tmp6_);
				}
				_g_object_unref0 (item);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = places;
	return result;
}

SeahorsePlace*
seahorse_sidebar_get_focused_place (SeahorseSidebar* self)
{
	SeahorseSidebarItem* row = NULL;
	GtkListBoxRow* _tmp0_;
	SeahorseSidebarItem* _tmp1_;
	SeahorsePlace* _tmp2_ = NULL;
	SeahorseSidebarItem* _tmp3_;
	SeahorsePlace* _tmp7_;
	SeahorsePlace* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (SEAHORSE_IS_SIDEBAR_ITEM (_tmp0_) ? ((SeahorseSidebarItem*) _tmp0_) : NULL);
	row = _tmp1_;
	_tmp3_ = row;
	if (_tmp3_ != NULL) {
		SeahorseSidebarItem* _tmp4_;
		SeahorsePlace* _tmp5_;
		SeahorsePlace* _tmp6_;
		_tmp4_ = row;
		_tmp5_ = seahorse_sidebar_item_get_place (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp2_);
	result = _tmp7_;
	_g_object_unref0 (row);
	return result;
}

/**
     * Tries to find a place with the given URI and selects it.
     *
     * @return Whether a matching place was found
     */
gboolean
seahorse_sidebar_set_focused_place_for_uri (SeahorseSidebar* self,
                                            const gchar* uri)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				SeahorseSidebarItem* item = NULL;
				GtkWidget* _tmp1_;
				SeahorseSidebarItem* _tmp2_;
				SeahorseSidebarItem* _tmp3_;
				SeahorsePlace* _tmp4_;
				SeahorsePlace* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp1_ = row;
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem));
				item = _tmp2_;
				_tmp3_ = item;
				_tmp4_ = seahorse_sidebar_item_get_place (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = seahorse_place_get_uri (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strcmp0 (_tmp8_, uri) == 0;
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					SeahorseSidebarItem* _tmp10_;
					_tmp10_ = item;
					gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp10_);
					result = TRUE;
					_g_object_unref0 (item);
					(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
					return result;
				}
				_g_object_unref0 (item);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = FALSE;
	return result;
}

/**
     * Tries to find a place with the given URI scheme and selects it.
     *
     * @return Whether a matching place was found
     */
gboolean
seahorse_sidebar_set_focused_place_for_scheme (SeahorseSidebar* self,
                                               const gchar* uri_scheme)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri_scheme != NULL, FALSE);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				SeahorseSidebarItem* item = NULL;
				GtkWidget* _tmp1_;
				SeahorseSidebarItem* _tmp2_;
				SeahorseSidebarItem* _tmp3_;
				SeahorsePlace* _tmp4_;
				SeahorsePlace* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp1_ = row;
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem));
				item = _tmp2_;
				_tmp3_ = item;
				_tmp4_ = seahorse_sidebar_item_get_place (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = seahorse_place_get_uri (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = g_str_has_prefix (_tmp8_, uri_scheme);
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					SeahorseSidebarItem* _tmp10_;
					_tmp10_ = item;
					gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp10_);
					result = TRUE;
					_g_object_unref0 (item);
					(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
					return result;
				}
				_g_object_unref0 (item);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = FALSE;
	return result;
}

void
seahorse_sidebar_select_next_place (SeahorseSidebar* self)
{
	g_return_if_fail (self != NULL);
	seahorse_sidebar_select_relative (self, 1);
}

void
seahorse_sidebar_select_previous_place (SeahorseSidebar* self)
{
	g_return_if_fail (self != NULL);
	seahorse_sidebar_select_relative (self, -1);
}

static void
seahorse_sidebar_select_relative (SeahorseSidebar* self,
                                  gint positions)
{
	GtkListBoxRow* selected = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* next = NULL;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp6_;
	GtkListBoxRow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected = _tmp1_;
	_tmp2_ = selected;
	if (_tmp2_ == NULL) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = gtk_list_box_get_row_at_index ((GtkListBox*) self, 0);
		gtk_list_box_select_row ((GtkListBox*) self, _tmp3_);
		_g_object_unref0 (selected);
		return;
	}
	_tmp4_ = selected;
	_tmp5_ = gtk_list_box_get_row_at_index ((GtkListBox*) self, gtk_list_box_row_get_index (_tmp4_) + positions);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	next = _tmp6_;
	_tmp7_ = next;
	if (_tmp7_ != NULL) {
		GtkListBoxRow* _tmp8_;
		_tmp8_ = next;
		gtk_list_box_select_row ((GtkListBox*) self, _tmp8_);
	}
	_g_object_unref0 (next);
	_g_object_unref0 (selected);
}

GList*
seahorse_sidebar_get_backends (SeahorseSidebar* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->backends;
	_tmp1_ = g_list_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

SeahorseSidebar*
seahorse_sidebar_construct (GType object_type)
{
	SeahorseSidebar * self = NULL;
	self = (SeahorseSidebar*) g_object_new (object_type, NULL);
	return self;
}

SeahorseSidebar*
seahorse_sidebar_new (void)
{
	return seahorse_sidebar_construct (SEAHORSE_TYPE_SIDEBAR);
}

GcrUnionCollection*
seahorse_sidebar_get_objects (SeahorseSidebar* self)
{
	GcrUnionCollection* result;
	GcrUnionCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_objects;
	result = _tmp0_;
	return result;
}

static void
seahorse_sidebar_set_objects (SeahorseSidebar* self,
                              GcrUnionCollection* value)
{
	GcrUnionCollection* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_sidebar_get_objects (self);
	if (old_value != value) {
		GcrUnionCollection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_objects);
		self->priv->_objects = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_sidebar_properties[SEAHORSE_SIDEBAR_OBJECTS_PROPERTY]);
	}
}

static GtkWidget*
_seahorse_sidebar_place_widget_create_cb_gtk_list_box_create_widget_func (GObject* item,
                                                                          gpointer self)
{
	GtkWidget* result;
	result = seahorse_sidebar_place_widget_create_cb ((SeahorseSidebar*) self, item);
	return result;
}

static void
_seahorse_sidebar_place_header_cb_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                   GtkListBoxRow* before,
                                                                   gpointer self)
{
	seahorse_sidebar_place_header_cb ((SeahorseSidebar*) self, row, before);
}

static void
_seahorse_sidebar_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                             GtkListBoxRow* row,
                                                             gpointer self)
{
	seahorse_sidebar_on_row_selected ((SeahorseSidebar*) self, row);
}

static GObject *
seahorse_sidebar_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseSidebar * self;
	GListStore* _tmp0_;
	parent_class = G_OBJECT_CLASS (seahorse_sidebar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar);
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_BROWSE);
	_tmp0_ = self->priv->store;
	gtk_list_box_bind_model ((GtkListBox*) self, (GListModel*) _tmp0_, _seahorse_sidebar_place_widget_create_cb_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_header_func ((GtkListBox*) self, _seahorse_sidebar_place_header_cb_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GtkListBox*) self, "row-selected", (GCallback) _seahorse_sidebar_on_row_selected_gtk_list_box_row_selected, self, 0);
	seahorse_sidebar_load_backends (self);
	return obj;
}

static void
seahorse_sidebar_class_init (SeahorseSidebarClass * klass,
                             gpointer klass_data)
{
	seahorse_sidebar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSidebar_private_offset);
	((GtkWidgetClass *) klass)->popup_menu = (gboolean (*) (GtkWidget*)) seahorse_sidebar_real_popup_menu;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) seahorse_sidebar_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_sidebar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_sidebar_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_sidebar_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_sidebar_finalize;
	/**
	     * Collection of objects sidebar represents
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SIDEBAR_OBJECTS_PROPERTY, seahorse_sidebar_properties[SEAHORSE_SIDEBAR_OBJECTS_PROPERTY] = g_param_spec_object ("objects", "objects", "objects", gcr_union_collection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Emitted when the state of the current collection changed.
	     * For example: when going from locked to unlocked and vice versa.
	     */
	seahorse_sidebar_signals[SEAHORSE_SIDEBAR_CURRENT_COLLECTION_CHANGED_SIGNAL] = g_signal_new ("current-collection-changed", SEAHORSE_TYPE_SIDEBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
seahorse_sidebar_instance_init (SeahorseSidebar * self,
                                gpointer klass)
{
	GListStore* _tmp0_;
	GcrUnionCollection* _tmp1_;
	self->priv = seahorse_sidebar_get_instance_private (self);
	_tmp0_ = g_list_store_new (SEAHORSE_TYPE_PLACE);
	self->priv->store = _tmp0_;
	self->priv->backends = NULL;
	_tmp1_ = (GcrUnionCollection*) gcr_union_collection_new ();
	self->priv->_objects = _tmp1_;
}

static void
seahorse_sidebar_finalize (GObject * obj)
{
	SeahorseSidebar * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar);
	_tmp0_ = self->priv->backends;
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp0_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* _tmp1_;
			SeahorseBackend* backend = NULL;
			_tmp1_ = _g_object_ref0 ((SeahorseBackend*) backend_it->data);
			backend = _tmp1_;
			{
				SeahorseBackend* _tmp2_;
				GList* _tmp3_;
				_tmp2_ = backend;
				_tmp3_ = gcr_collection_get_objects ((GcrCollection*) _tmp2_);
				{
					GList* obj_collection = NULL;
					GList* obj_it = NULL;
					obj_collection = _tmp3_;
					for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
						GObject* obj = NULL;
						obj = (GObject*) obj_it->data;
						{
							SeahorseBackend* _tmp4_;
							GObject* _tmp5_;
							_tmp4_ = backend;
							_tmp5_ = obj;
							seahorse_sidebar_on_place_removed (self, (GcrCollection*) _tmp4_, (GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SEAHORSE_TYPE_PLACE, SeahorsePlace));
						}
					}
					(obj_collection == NULL) ? NULL : (obj_collection = (g_list_free (obj_collection), NULL));
				}
				_g_object_unref0 (backend);
			}
		}
	}
	_g_object_unref0 (self->priv->store);
	(self->priv->backends == NULL) ? NULL : (self->priv->backends = (_g_list_free__g_object_unref0_ (self->priv->backends), NULL));
	_g_object_unref0 (self->priv->_objects);
	G_OBJECT_CLASS (seahorse_sidebar_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_sidebar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSidebarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_sidebar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSidebar), 0, (GInstanceInitFunc) seahorse_sidebar_instance_init, NULL };
	GType seahorse_sidebar_type_id;
	seahorse_sidebar_type_id = g_type_register_static (gtk_list_box_get_type (), "SeahorseSidebar", &g_define_type_info, 0);
	SeahorseSidebar_private_offset = g_type_add_instance_private (seahorse_sidebar_type_id, sizeof (SeahorseSidebarPrivate));
	return seahorse_sidebar_type_id;
}

GType
seahorse_sidebar_get_type (void)
{
	static volatile gsize seahorse_sidebar_type_id__once = 0;
	if (g_once_init_enter (&seahorse_sidebar_type_id__once)) {
		GType seahorse_sidebar_type_id;
		seahorse_sidebar_type_id = seahorse_sidebar_get_type_once ();
		g_once_init_leave (&seahorse_sidebar_type_id__once, seahorse_sidebar_type_id);
	}
	return seahorse_sidebar_type_id__once;
}

static void
_vala_seahorse_sidebar_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar);
	switch (property_id) {
		case SEAHORSE_SIDEBAR_OBJECTS_PROPERTY:
		g_value_set_object (value, seahorse_sidebar_get_objects (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_sidebar_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SIDEBAR, SeahorseSidebar);
	switch (property_id) {
		case SEAHORSE_SIDEBAR_OBJECTS_PROPERTY:
		seahorse_sidebar_set_objects (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
seahorse_sidebar_item_get_instance_private (SeahorseSidebarItem* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSidebarItem_private_offset);
}

static const gchar*
seahorse_sidebar_item_get_lock_icon_name (SeahorseLockable* lockable)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* result;
	g_return_val_if_fail (lockable != NULL, NULL);
	_tmp0_ = seahorse_lockable_get_unlockable (lockable);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = "changes-prevent-symbolic";
		return result;
	}
	_tmp2_ = seahorse_lockable_get_lockable (lockable);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = "changes-allow-symbolic";
		return result;
	}
	result = NULL;
	return result;
}

static void
seahorse_sidebar_item_update_lock_icon (SeahorseSidebarItem* self,
                                        SeahorseLockable* lockable)
{
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lockable != NULL);
	_tmp0_ = self->priv->lock_button;
	_tmp1_ = gtk_button_get_image (_tmp0_);
	_tmp2_ = seahorse_sidebar_item_get_lock_icon_name (lockable);
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_image_get_type (), GtkImage), "icon-name", _tmp2_, NULL);
}

SeahorseSidebarItem*
seahorse_sidebar_item_construct (GType object_type,
                                 SeahorsePlace* place)
{
	SeahorseSidebarItem * self = NULL;
	g_return_val_if_fail (place != NULL, NULL);
	self = (SeahorseSidebarItem*) g_object_new (object_type, "place", place, NULL);
	return self;
}

SeahorseSidebarItem*
seahorse_sidebar_item_new (SeahorsePlace* place)
{
	return seahorse_sidebar_item_construct (SEAHORSE_TYPE_SIDEBAR_ITEM, place);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->item);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda7_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	SeahorseSidebarItem* self;
	GtkMenuItem* _tmp0_;
	SeahorsePlace* _tmp1_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data6_->item;
	_tmp1_ = self->priv->_place;
	seahorse_sidebar_item_on_place_lock (self, (GtkWidget*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_LOCKABLE, SeahorseLockable));
}

static void
____lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	___lambda7_ (self);
}

static void
___lambda9_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	SeahorseSidebarItem* self;
	GtkMenuItem* _tmp0_;
	SeahorsePlace* _tmp1_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data6_->item;
	_tmp1_ = self->priv->_place;
	seahorse_sidebar_item_on_place_unlock (self, _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_LOCKABLE, SeahorseLockable));
}

static void
____lambda9__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	___lambda9_ (self);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data7_->_data5_->self;
		_g_object_unref0 (_data7_->item);
		block5_data_unref (_data7_->_data5_);
		_data7_->_data5_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda11_ (Block7Data* _data7_)
{
	Block5Data* _data5_;
	SeahorseSidebarItem* self;
	GtkMenuItem* _tmp0_;
	SeahorsePlace* _tmp1_;
	_data5_ = _data7_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data7_->item;
	_tmp1_ = self->priv->_place;
	seahorse_sidebar_item_on_place_delete (self, _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_TYPE_DELETABLE, SeahorseDeletable));
}

static void
____lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda11_ (self);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data8_->_data5_->self;
		_g_object_unref0 (_data8_->item);
		block5_data_unref (_data8_->_data5_);
		_data8_->_data5_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static void
___lambda13_ (Block8Data* _data8_)
{
	Block5Data* _data5_;
	SeahorseSidebarItem* self;
	SeahorsePlace* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkWidget* _tmp2_;
	_data5_ = _data8_->_data5_;
	self = _data5_->self;
	_tmp0_ = self->priv->_place;
	_tmp1_ = _data8_->item;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp1_);
	seahorse_viewable_view ((GObject*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
}

static void
____lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda13_ (self);
}

static void
__lambda14_ (Block5Data* _data5_,
             GtkWidget* widget)
{
	SeahorseSidebarItem* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data5_->self;
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_get_visible (widget);
	_tmp1_ = _tmp0_;
	_data5_->visible |= _tmp1_;
}

static void
___lambda14__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda14_ (self, widget);
}

void
seahorse_sidebar_item_show_popup_menu (SeahorseSidebarItem* self)
{
	Block5Data* _data5_;
	GtkMenu* _tmp0_ = NULL;
	SeahorsePlace* _tmp1_;
	GMenuModel* _tmp2_;
	GMenuModel* _tmp3_;
	GMenuModel* _tmp4_;
	gboolean _tmp5_;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp12_;
	SeahorsePlace* _tmp13_;
	GActionGroup* _tmp14_;
	GActionGroup* _tmp15_;
	GActionGroup* _tmp16_;
	gboolean _tmp17_;
	SeahorsePlace* _tmp26_;
	SeahorsePlace* _tmp39_;
	SeahorsePlace* _tmp47_;
	GtkMenu* _tmp53_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp1_ = self->priv->_place;
	_tmp2_ = seahorse_place_get_menu_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		SeahorsePlace* _tmp6_;
		GMenuModel* _tmp7_;
		GMenuModel* _tmp8_;
		GMenuModel* _tmp9_;
		GtkMenu* _tmp10_;
		_tmp6_ = self->priv->_place;
		_tmp7_ = seahorse_place_get_menu_model (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = (GtkMenu*) gtk_menu_new_from_model (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
	} else {
		GtkMenu* _tmp11_;
		_tmp11_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	_tmp12_ = _g_object_ref0 (_tmp0_);
	menu = _tmp12_;
	_tmp13_ = self->priv->_place;
	_tmp14_ = seahorse_place_get_actions (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_ != NULL;
	_g_object_unref0 (_tmp16_);
	if (_tmp17_) {
		GtkMenu* _tmp18_;
		SeahorsePlace* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		SeahorsePlace* _tmp22_;
		GActionGroup* _tmp23_;
		GActionGroup* _tmp24_;
		GActionGroup* _tmp25_;
		_tmp18_ = menu;
		_tmp19_ = self->priv->_place;
		_tmp20_ = seahorse_place_get_action_prefix (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_place;
		_tmp23_ = seahorse_place_get_actions (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		gtk_widget_insert_action_group ((GtkWidget*) _tmp18_, _tmp21_, _tmp25_);
		_g_object_unref0 (_tmp25_);
	}
	_tmp26_ = self->priv->_place;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, SEAHORSE_TYPE_LOCKABLE)) {
		Block6Data* _data6_;
		GtkMenuItem* _tmp27_;
		GtkMenuItem* _tmp28_;
		SeahorsePlace* _tmp29_;
		GtkMenuItem* _tmp30_;
		GtkMenu* _tmp31_;
		GtkMenuItem* _tmp32_;
		GtkMenuItem* _tmp33_;
		GtkMenuItem* _tmp34_;
		SeahorsePlace* _tmp35_;
		GtkMenuItem* _tmp36_;
		GtkMenu* _tmp37_;
		GtkMenuItem* _tmp38_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Lock"));
		g_object_ref_sink (_tmp27_);
		_data6_->item = _tmp27_;
		_tmp28_ = _data6_->item;
		g_signal_connect_data (_tmp28_, "activate", (GCallback) ____lambda7__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp29_ = self->priv->_place;
		_tmp30_ = _data6_->item;
		g_object_bind_property_with_closures ((GObject*) _tmp29_, "lockable", (GObject*) _tmp30_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp31_ = menu;
		_tmp32_ = _data6_->item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp31_, _tmp32_);
		_tmp33_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Unlock"));
		g_object_ref_sink (_tmp33_);
		_g_object_unref0 (_data6_->item);
		_data6_->item = _tmp33_;
		_tmp34_ = _data6_->item;
		g_signal_connect_data (_tmp34_, "activate", (GCallback) ____lambda9__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp35_ = self->priv->_place;
		_tmp36_ = _data6_->item;
		g_object_bind_property_with_closures ((GObject*) _tmp35_, "unlockable", (GObject*) _tmp36_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp37_ = menu;
		_tmp38_ = _data6_->item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp37_, _tmp38_);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	_tmp39_ = self->priv->_place;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, SEAHORSE_TYPE_DELETABLE)) {
		Block7Data* _data7_;
		GtkMenuItem* _tmp40_;
		GtkMenuItem* _tmp41_;
		SeahorsePlace* _tmp42_;
		GtkMenuItem* _tmp43_;
		GtkMenu* _tmp44_;
		GtkMenuItem* _tmp45_;
		GtkMenuItem* _tmp46_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data5_ = block5_data_ref (_data5_);
		_tmp40_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Delete"));
		g_object_ref_sink (_tmp40_);
		_data7_->item = _tmp40_;
		_tmp41_ = _data7_->item;
		g_signal_connect_data (_tmp41_, "activate", (GCallback) ____lambda11__gtk_menu_item_activate, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp42_ = self->priv->_place;
		_tmp43_ = _data7_->item;
		g_object_bind_property_with_closures ((GObject*) _tmp42_, "deletable", (GObject*) _tmp43_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp44_ = menu;
		_tmp45_ = _data7_->item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp44_, _tmp45_);
		_tmp46_ = _data7_->item;
		gtk_widget_show ((GtkWidget*) _tmp46_);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_tmp47_ = self->priv->_place;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, SEAHORSE_TYPE_VIEWABLE)) {
		Block8Data* _data8_;
		GtkMenuItem* _tmp48_;
		GtkMenuItem* _tmp49_;
		GtkMenu* _tmp50_;
		GtkMenuItem* _tmp51_;
		GtkMenuItem* _tmp52_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->_data5_ = block5_data_ref (_data5_);
		_tmp48_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Properties"));
		g_object_ref_sink (_tmp48_);
		_data8_->item = _tmp48_;
		_tmp49_ = _data8_->item;
		g_signal_connect_data (_tmp49_, "activate", (GCallback) ____lambda13__gtk_menu_item_activate, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		_tmp50_ = menu;
		_tmp51_ = _data8_->item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp50_, _tmp51_);
		_tmp52_ = _data8_->item;
		gtk_widget_show ((GtkWidget*) _tmp52_);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	_data5_->visible = FALSE;
	_tmp53_ = menu;
	gtk_container_foreach ((GtkContainer*) _tmp53_, ___lambda14__gtk_callback, _data5_);
	if (_data5_->visible) {
		GtkMenu* _tmp54_;
		GtkMenu* _tmp55_;
		GtkMenu* _tmp56_;
		_tmp54_ = menu;
		gtk_menu_popup_at_pointer (_tmp54_, NULL);
		_tmp55_ = menu;
		gtk_menu_attach_to_widget (_tmp55_, (GtkWidget*) self, NULL);
		_tmp56_ = menu;
		gtk_widget_show ((GtkWidget*) _tmp56_);
	} else {
		GtkMenu* _tmp57_;
		_tmp57_ = menu;
		gtk_widget_destroy ((GtkWidget*) _tmp57_);
	}
	_g_object_unref0 (menu);
	_g_object_unref0 (_tmp0_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->lockable);
		_g_object_unref0 (_data9_->window);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda8_ (Block9Data* _data9_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseSidebarItem* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (res != NULL);
	{
		seahorse_lockable_lock_finish (_data9_->lockable, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		seahorse_sidebar_item_update_lock_icon (self, _data9_->lockable);
		g_signal_emit (self, seahorse_sidebar_item_signals[SEAHORSE_SIDEBAR_ITEM_PLACE_CHANGED_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		seahorse_util_show_error ((GtkWidget*) _data9_->window, _ ("Couldn’t lock"), _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ (self, source_object, res);
	block9_data_unref (self);
}

static void
seahorse_sidebar_item_place_lock (SeahorseSidebarItem* self,
                                  SeahorseLockable* lockable,
                                  GtkWindow* window)
{
	Block9Data* _data9_;
	SeahorseLockable* _tmp0_;
	GtkWindow* _tmp1_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	GTlsInteraction* interaction = NULL;
	SeahorseInteraction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lockable != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (lockable);
	_g_object_unref0 (_data9_->lockable);
	_data9_->lockable = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (_data9_->window);
	_data9_->window = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	_tmp3_ = seahorse_interaction_new (_data9_->window);
	interaction = (GTlsInteraction*) _tmp3_;
	seahorse_lockable_lock (_data9_->lockable, interaction, cancellable, ___lambda8__gasync_ready_callback, block9_data_ref (_data9_));
	_g_object_unref0 (interaction);
	_g_object_unref0 (cancellable);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
seahorse_sidebar_item_on_place_lock (SeahorseSidebarItem* self,
                                     GtkWidget* widget,
                                     SeahorseLockable* lockable)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (lockable != NULL);
	_tmp0_ = gtk_widget_get_toplevel (widget);
	seahorse_sidebar_item_place_lock (self, lockable, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->lockable);
		_g_object_unref0 (_data10_->window);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda10_ (Block10Data* _data10_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseSidebarItem* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	{
		seahorse_lockable_unlock_finish (_data10_->lockable, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		seahorse_sidebar_item_update_lock_icon (self, _data10_->lockable);
		g_signal_emit (self, seahorse_sidebar_item_signals[SEAHORSE_SIDEBAR_ITEM_PLACE_CHANGED_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		seahorse_util_show_error ((GtkWidget*) _data10_->window, _ ("Couldn’t unlock"), _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self, source_object, res);
	block10_data_unref (self);
}

static void
seahorse_sidebar_item_place_unlock (SeahorseSidebarItem* self,
                                    SeahorseLockable* lockable,
                                    GtkWindow* window)
{
	Block10Data* _data10_;
	SeahorseLockable* _tmp0_;
	GtkWindow* _tmp1_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	GTlsInteraction* interaction = NULL;
	SeahorseInteraction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lockable != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (lockable);
	_g_object_unref0 (_data10_->lockable);
	_data10_->lockable = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (_data10_->window);
	_data10_->window = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	_tmp3_ = seahorse_interaction_new (_data10_->window);
	interaction = (GTlsInteraction*) _tmp3_;
	seahorse_lockable_unlock (_data10_->lockable, interaction, cancellable, ___lambda10__gasync_ready_callback, block10_data_ref (_data10_));
	_g_object_unref0 (interaction);
	_g_object_unref0 (cancellable);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
seahorse_sidebar_item_on_place_unlock (SeahorseSidebarItem* self,
                                       GtkMenuItem* widget,
                                       SeahorseLockable* lockable)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (lockable != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) widget);
	seahorse_sidebar_item_place_unlock (self, lockable, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->deleter);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda12_ (Block11Data* _data11_,
              GObject* obj,
              GAsyncResult* res)
{
	SeahorseSidebarItem* self;
	GError* _inner_error0_ = NULL;
	self = _data11_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseDeleter* _tmp0_;
		_tmp0_ = _data11_->deleter;
		seahorse_deleter_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkContainer* _tmp1_;
		GtkContainer* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		seahorse_util_show_error ((GtkWidget*) _tmp2_, _ ("Couldn’t delete"), _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda12__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda12_ (self, source_object, res);
	block11_data_unref (self);
}

static void
seahorse_sidebar_item_on_place_delete (SeahorseSidebarItem* self,
                                       GtkMenuItem* item,
                                       SeahorseDeletable* deletable)
{
	Block11Data* _data11_;
	SeahorseDeleter* _tmp0_;
	SeahorseDeleter* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (deletable != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = seahorse_deletable_create_deleter (deletable);
	_data11_->deleter = _tmp0_;
	_tmp1_ = _data11_->deleter;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) item);
	if (seahorse_deleter_prompt (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow))) {
		SeahorseDeleter* _tmp3_;
		_tmp3_ = _data11_->deleter;
		seahorse_deleter_delete (_tmp3_, NULL, ____lambda12__gasync_ready_callback, block11_data_ref (_data11_));
	}
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

SeahorsePlace*
seahorse_sidebar_item_get_place (SeahorseSidebarItem* self)
{
	SeahorsePlace* result;
	SeahorsePlace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_place;
	result = _tmp0_;
	return result;
}

void
seahorse_sidebar_item_set_place (SeahorseSidebarItem* self,
                                 SeahorsePlace* value)
{
	SeahorsePlace* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_sidebar_item_get_place (self);
	if (old_value != value) {
		self->priv->_place = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_sidebar_item_properties[SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY]);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SeahorseSidebarItem* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->lockable);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
_seahorse_sidebar_item____lambda15_ (Block12Data* _data12_,
                                     GtkButton* b)
{
	SeahorseSidebarItem* self;
	SeahorseLockable* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SeahorseLockable* _tmp10_;
	self = _data12_->self;
	g_return_if_fail (b != NULL);
	_tmp0_ = _data12_->lockable;
	_tmp1_ = seahorse_lockable_get_unlockable (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SeahorseLockable* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = _data12_->lockable;
		_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		seahorse_sidebar_item_place_unlock (self, _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
	} else {
		SeahorseLockable* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = _data12_->lockable;
		_tmp6_ = seahorse_lockable_get_lockable (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			SeahorseLockable* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = _data12_->lockable;
			_tmp9_ = gtk_widget_get_toplevel ((GtkWidget*) self);
			seahorse_sidebar_item_place_lock (self, _tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_window_get_type (), GtkWindow));
		}
	}
	_tmp10_ = _data12_->lockable;
	seahorse_sidebar_item_update_lock_icon (self, _tmp10_);
}

static void
__seahorse_sidebar_item____lambda15__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_seahorse_sidebar_item____lambda15_ (self, _sender);
}

static GObject *
seahorse_sidebar_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseSidebarItem * self;
	Block12Data* _data12_;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkImage* icon = NULL;
	SeahorsePlace* _tmp7_;
	GIcon* _tmp8_;
	GIcon* _tmp9_;
	GIcon* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkLabel* label = NULL;
	SeahorsePlace* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkLabel* _tmp24_;
	SeahorsePlace* _tmp25_;
	SeahorseLockable* _tmp26_;
	gboolean _tmp27_ = FALSE;
	SeahorseLockable* _tmp28_;
	parent_class = G_OBJECT_CLASS (seahorse_sidebar_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = box;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "seahorse-sidebar-item");
	_tmp3_ = box;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 3);
	_tmp5_ = box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 3);
	_tmp6_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->_place;
	_tmp8_ = seahorse_place_get_icon (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkImage*) gtk_image_new_from_gicon (_tmp10_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	icon = _tmp12_;
	_tmp13_ = box;
	_tmp14_ = icon;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->priv->_place;
	_tmp16_ = seahorse_place_get_label (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	label = _tmp20_;
	_tmp21_ = label;
	gtk_label_set_ellipsize (_tmp21_, PANGO_ELLIPSIZE_END);
	_tmp22_ = label;
	gtk_label_set_xalign (_tmp22_, 0.f);
	_tmp23_ = box;
	_tmp24_ = label;
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
	_tmp25_ = self->priv->_place;
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, SEAHORSE_TYPE_LOCKABLE) ? ((SeahorseLockable*) _tmp25_) : NULL);
	_data12_->lockable = _tmp26_;
	_tmp28_ = _data12_->lockable;
	if (_tmp28_ != NULL) {
		gboolean _tmp29_ = FALSE;
		SeahorseLockable* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		_tmp30_ = _data12_->lockable;
		_tmp31_ = seahorse_lockable_get_lockable (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_) {
			_tmp29_ = TRUE;
		} else {
			SeahorseLockable* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			_tmp33_ = _data12_->lockable;
			_tmp34_ = seahorse_lockable_get_unlockable (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp29_ = _tmp35_;
		}
		_tmp27_ = _tmp29_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		SeahorseLockable* _tmp36_;
		const gchar* _tmp37_;
		GtkButton* _tmp38_;
		GtkButton* _tmp39_;
		GtkStyleContext* _tmp40_;
		GtkButton* _tmp41_;
		GtkButton* _tmp42_;
		GtkBox* _tmp43_;
		GtkButton* _tmp44_;
		_tmp36_ = _data12_->lockable;
		_tmp37_ = seahorse_sidebar_item_get_lock_icon_name (_tmp36_);
		_tmp38_ = (GtkButton*) gtk_button_new_from_icon_name (_tmp37_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp38_);
		_g_object_unref0 (self->priv->lock_button);
		self->priv->lock_button = _tmp38_;
		_tmp39_ = self->priv->lock_button;
		_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) _tmp39_);
		gtk_style_context_add_class (_tmp40_, "flat");
		_tmp41_ = self->priv->lock_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp41_, GTK_ALIGN_END);
		_tmp42_ = self->priv->lock_button;
		g_signal_connect_data (_tmp42_, "clicked", (GCallback) __seahorse_sidebar_item____lambda15__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
		_tmp43_ = box;
		_tmp44_ = self->priv->lock_button;
		gtk_box_pack_end (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (label);
	_g_object_unref0 (icon);
	_g_object_unref0 (box);
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return obj;
}

static void
seahorse_sidebar_item_class_init (SeahorseSidebarItemClass * klass,
                                  gpointer klass_data)
{
	seahorse_sidebar_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSidebarItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_sidebar_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_sidebar_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_sidebar_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_sidebar_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY, seahorse_sidebar_item_properties[SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY] = g_param_spec_object ("place", "place", "place", SEAHORSE_TYPE_PLACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	seahorse_sidebar_item_signals[SEAHORSE_SIDEBAR_ITEM_PLACE_CHANGED_SIGNAL] = g_signal_new ("place-changed", SEAHORSE_TYPE_SIDEBAR_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
seahorse_sidebar_item_instance_init (SeahorseSidebarItem * self,
                                     gpointer klass)
{
	self->priv = seahorse_sidebar_item_get_instance_private (self);
	self->priv->lock_button = NULL;
}

static void
seahorse_sidebar_item_finalize (GObject * obj)
{
	SeahorseSidebarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem);
	_g_object_unref0 (self->priv->lock_button);
	G_OBJECT_CLASS (seahorse_sidebar_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_sidebar_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSidebarItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_sidebar_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSidebarItem), 0, (GInstanceInitFunc) seahorse_sidebar_item_instance_init, NULL };
	GType seahorse_sidebar_item_type_id;
	seahorse_sidebar_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SeahorseSidebarItem", &g_define_type_info, 0);
	SeahorseSidebarItem_private_offset = g_type_add_instance_private (seahorse_sidebar_item_type_id, sizeof (SeahorseSidebarItemPrivate));
	return seahorse_sidebar_item_type_id;
}

GType
seahorse_sidebar_item_get_type (void)
{
	static volatile gsize seahorse_sidebar_item_type_id__once = 0;
	if (g_once_init_enter (&seahorse_sidebar_item_type_id__once)) {
		GType seahorse_sidebar_item_type_id;
		seahorse_sidebar_item_type_id = seahorse_sidebar_item_get_type_once ();
		g_once_init_leave (&seahorse_sidebar_item_type_id__once, seahorse_sidebar_item_type_id);
	}
	return seahorse_sidebar_item_type_id__once;
}

static void
_vala_seahorse_sidebar_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSidebarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem);
	switch (property_id) {
		case SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY:
		g_value_set_object (value, seahorse_sidebar_item_get_place (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_sidebar_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSidebarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_SIDEBAR_ITEM, SeahorseSidebarItem);
	switch (property_id) {
		case SEAHORSE_SIDEBAR_ITEM_PLACE_PROPERTY:
		seahorse_sidebar_item_set_place (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

