/* gkr-backend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gkr-backend.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <libsecret/secret.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "seahorse-common.h"
#include <gio/gio.h>
#include <gcr/gcr-base.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SEAHORSE_GKR_TYPE_MY_SERVICE (seahorse_gkr_my_service_get_type ())
#define SEAHORSE_GKR_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyService))
#define SEAHORSE_GKR_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))
#define SEAHORSE_GKR_IS_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_IS_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_MY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))

typedef struct _SeahorseGkrMyService SeahorseGkrMyService;
typedef struct _SeahorseGkrMyServiceClass SeahorseGkrMyServiceClass;
typedef struct _SeahorseGkrMyServicePrivate SeahorseGkrMyServicePrivate;
enum  {
	SEAHORSE_GKR_MY_SERVICE_0_PROPERTY,
	SEAHORSE_GKR_MY_SERVICE_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_my_service_properties[SEAHORSE_GKR_MY_SERVICE_NUM_PROPERTIES];
enum  {
	SEAHORSE_GKR_BACKEND_0_PROPERTY,
	SEAHORSE_GKR_BACKEND_NAME_PROPERTY,
	SEAHORSE_GKR_BACKEND_LABEL_PROPERTY,
	SEAHORSE_GKR_BACKEND_DESCRIPTION_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_PROPERTY,
	SEAHORSE_GKR_BACKEND_ALIASES_PROPERTY,
	SEAHORSE_GKR_BACKEND_LOADED_PROPERTY,
	SEAHORSE_GKR_BACKEND_SERVICE_PROPERTY,
	SEAHORSE_GKR_BACKEND_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseGkrBackendReadAliasData SeahorseGkrBackendReadAliasData;
enum  {
	SEAHORSE_GKR_BACKEND_ACTIONS_0_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_backend_actions_properties[SEAHORSE_GKR_BACKEND_ACTIONS_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _SeahorseGkrMyService {
	SecretService parent_instance;
	SeahorseGkrMyServicePrivate * priv;
};

struct _SeahorseGkrMyServiceClass {
	SecretServiceClass parent_class;
};

struct _SeahorseGkrBackendPrivate {
	gboolean _loaded;
	SecretService* _service;
	GHashTable* _keyrings;
	GHashTable* _aliases;
	SeahorseActionGroup* _actions;
};

struct _SeahorseGkrBackendReadAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrBackend* self;
	gchar* name;
	SecretService* _tmp0_;
	gchar* object_path;
	SecretService* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* err;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _SeahorseGkrBackendActionsPrivate {
	SeahorseGkrBackend* _backend;
	gboolean _initialized;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseGkrBackendActions* self;
	SeahorseGkrItem* selected_item;
};

static gpointer seahorse_gkr_my_service_parent_class = NULL;
static gint SeahorseGkrBackend_private_offset;
static gpointer seahorse_gkr_backend_parent_class = NULL;
static SeahorseGkrBackend* seahorse_gkr_backend__instance;
static SeahorseGkrBackend* seahorse_gkr_backend__instance = NULL;
static GcrCollectionIface * seahorse_gkr_backend_gcr_collection_parent_iface = NULL;
static SeahorseBackendIface * seahorse_gkr_backend_seahorse_backend_parent_iface = NULL;
static gint SeahorseGkrBackendActions_private_offset;
static gpointer seahorse_gkr_backend_actions_parent_class = NULL;
static GWeakRef seahorse_gkr_backend_actions__instance;
static GWeakRef seahorse_gkr_backend_actions__instance = {0};

VALA_EXTERN GType seahorse_gkr_my_service_get_type (void) G_GNUC_CONST ;
static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base);
static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base);
VALA_EXTERN SeahorseGkrMyService* seahorse_gkr_my_service_new (void);
VALA_EXTERN SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type);
static GType seahorse_gkr_my_service_get_type_once (void);
static void seahorse_gkr_backend_real_dispose (GObject* base);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static guint seahorse_gkr_backend_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base,
                                             GObject* object);
static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base,
                                                       const gchar* uri);
static void seahorse_gkr_backend_read_alias_data_free (gpointer _data);
static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self,
                                      const gchar* name,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void seahorse_gkr_backend_read_alias_finish (SeahorseGkrBackend* self,
                                             GAsyncResult* _res_);
static gboolean seahorse_gkr_backend_read_alias_co (SeahorseGkrBackendReadAliasData* _data_);
static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self);
static GObject * seahorse_gkr_backend_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend___lambda20_ (SeahorseGkrBackend* self,
                                        GObject* obj,
                                        GAsyncResult* res);
static void ___lambda21_ (SeahorseGkrBackend* self,
                   GObject* obj,
                   GParamSpec* pspec);
static void ____lambda21__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda22_ (SeahorseGkrBackend* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda22__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __seahorse_gkr_backend___lambda20__gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void seahorse_gkr_backend_finalize (GObject * obj);
static GType seahorse_gkr_backend_get_type_once (void);
static void _vala_seahorse_gkr_backend_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void seahorse_gkr_backend_actions_on_new_keyring (SeahorseGkrBackendActions* self,
                                                  GSimpleAction* action,
                                                  GVariant* param);
static void _seahorse_gkr_backend_actions_on_new_keyring_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void seahorse_gkr_backend_actions_on_new_item (SeahorseGkrBackendActions* self,
                                               GSimpleAction* action,
                                               GVariant* param);
static void _seahorse_gkr_backend_actions_on_new_item_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void seahorse_gkr_backend_actions_on_copy_secret (SeahorseGkrBackendActions* self,
                                                  GSimpleAction* action,
                                                  GVariant* param);
static void _seahorse_gkr_backend_actions_on_copy_secret_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend);
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type,
                                                                   SeahorseGkrBackend* backend);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda18_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void seahorse_gkr_backend_actions_real_set_actions_for_selected_objects (SeahorseActionGroup* base,
                                                                         GList* objects);
static GObject * seahorse_gkr_backend_actions_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend_actions___lambda19_ (SeahorseGkrBackendActions* self,
                                                GParamSpec* pspec);
static void __seahorse_gkr_backend_actions___lambda19__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void seahorse_gkr_backend_actions_finalize (GObject * obj);
static GType seahorse_gkr_backend_actions_get_type_once (void);
static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static const GActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS[3] = {{"keyring-new", _seahorse_gkr_backend_actions_on_new_keyring_gsimple_action_activate_callback}, {"keyring-item-new", _seahorse_gkr_backend_actions_on_new_item_gsimple_action_activate_callback}, {"copy-secret", _seahorse_gkr_backend_actions_on_copy_secret_gsimple_action_activate_callback}};

static GType
seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base)
{
	SeahorseGkrMyService * self;
	GType result;
	self = (SeahorseGkrMyService*) base;
	result = SEAHORSE_GKR_TYPE_KEYRING;
	return result;
}

static GType
seahorse_gkr_my_service_real_get_item_gtype (SecretService* base)
{
	SeahorseGkrMyService * self;
	GType result;
	self = (SeahorseGkrMyService*) base;
	result = SEAHORSE_GKR_TYPE_ITEM;
	return result;
}

SeahorseGkrMyService*
seahorse_gkr_my_service_construct (GType object_type)
{
	SeahorseGkrMyService * self = NULL;
	self = (SeahorseGkrMyService*) g_object_new (object_type, NULL);
	return self;
}

SeahorseGkrMyService*
seahorse_gkr_my_service_new (void)
{
	return seahorse_gkr_my_service_construct (SEAHORSE_GKR_TYPE_MY_SERVICE);
}

static void
seahorse_gkr_my_service_class_init (SeahorseGkrMyServiceClass * klass,
                                    gpointer klass_data)
{
	seahorse_gkr_my_service_parent_class = g_type_class_peek_parent (klass);
	((SecretServiceClass *) klass)->get_collection_gtype = (GType (*) (SecretService*)) seahorse_gkr_my_service_real_get_collection_gtype;
	((SecretServiceClass *) klass)->get_item_gtype = (GType (*) (SecretService*)) seahorse_gkr_my_service_real_get_item_gtype;
}

static void
seahorse_gkr_my_service_instance_init (SeahorseGkrMyService * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_my_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrMyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_my_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrMyService), 0, (GInstanceInitFunc) seahorse_gkr_my_service_instance_init, NULL };
	GType seahorse_gkr_my_service_type_id;
	seahorse_gkr_my_service_type_id = g_type_register_static (secret_service_get_type (), "SeahorseGkrMyService", &g_define_type_info, 0);
	return seahorse_gkr_my_service_type_id;
}

GType
seahorse_gkr_my_service_get_type (void)
{
	static volatile gsize seahorse_gkr_my_service_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_my_service_type_id__once)) {
		GType seahorse_gkr_my_service_type_id;
		seahorse_gkr_my_service_type_id = seahorse_gkr_my_service_get_type_once ();
		g_once_init_leave (&seahorse_gkr_my_service_type_id__once, seahorse_gkr_my_service_type_id);
	}
	return seahorse_gkr_my_service_type_id__once;
}

static inline gpointer
seahorse_gkr_backend_get_instance_private (SeahorseGkrBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrBackend_private_offset);
}

static void
seahorse_gkr_backend_real_dispose (GObject* base)
{
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_aliases;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->_keyrings;
	g_hash_table_remove_all (_tmp1_);
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
seahorse_gkr_backend_refresh_collections (SeahorseGkrBackend* self)
{
	GHashTable* seen = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* keyrings = NULL;
	SecretService* _tmp3_;
	GList* _tmp4_;
	gchar* object_path = NULL;
	GList* _tmp5_;
	GHashTableIter iter = {0};
	GHashTable* _tmp27_;
	gchar* uri = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	seen = _tmp2_;
	_tmp3_ = self->priv->_service;
	_tmp4_ = secret_service_get_collections (_tmp3_);
	keyrings = _tmp4_;
	_tmp5_ = keyrings;
	{
		GList* keyring_collection = NULL;
		GList* keyring_it = NULL;
		keyring_collection = _tmp5_;
		for (keyring_it = keyring_collection; keyring_it != NULL; keyring_it = keyring_it->next) {
			SecretCollection* _tmp6_;
			SecretCollection* keyring = NULL;
			_tmp6_ = _g_object_ref0 ((SecretCollection*) keyring_it->data);
			keyring = _tmp6_;
			{
				SecretCollection* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				GHashTable* _tmp10_;
				gconstpointer _tmp11_;
				const gchar* _tmp12_;
				gchar* uri = NULL;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GHashTable* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				GHashTable* _tmp18_;
				const gchar* _tmp19_;
				gconstpointer _tmp20_;
				_tmp7_ = keyring;
				_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (object_path);
				object_path = _tmp9_;
				_tmp10_ = self->priv->_aliases;
				_tmp11_ = g_hash_table_lookup (_tmp10_, "session");
				_tmp12_ = object_path;
				if (g_strcmp0 ((const gchar*) _tmp11_, _tmp12_) == 0) {
					_g_object_unref0 (keyring);
					continue;
				}
				_tmp13_ = object_path;
				_tmp14_ = g_strdup_printf ("secret-service://%s", _tmp13_);
				uri = _tmp14_;
				_tmp15_ = seen;
				_tmp16_ = uri;
				_tmp17_ = g_strdup (_tmp16_);
				g_hash_table_add (_tmp15_, _tmp17_);
				_tmp18_ = self->priv->_keyrings;
				_tmp19_ = uri;
				_tmp20_ = g_hash_table_lookup (_tmp18_, _tmp19_);
				if (((SeahorseGkrKeyring*) _tmp20_) == NULL) {
					GHashTable* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					SecretCollection* _tmp24_;
					SeahorseGkrKeyring* _tmp25_;
					SecretCollection* _tmp26_;
					_tmp21_ = self->priv->_keyrings;
					_tmp22_ = uri;
					_tmp23_ = g_strdup (_tmp22_);
					_tmp24_ = keyring;
					_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
					g_hash_table_insert (_tmp21_, _tmp23_, _tmp25_);
					_tmp26_ = keyring;
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp26_);
				}
				_g_free0 (uri);
				_g_object_unref0 (keyring);
			}
		}
	}
	_tmp27_ = self->priv->_keyrings;
	g_hash_table_iter_init (&iter, _tmp27_);
	while (TRUE) {
		gconstpointer _tmp28_ = NULL;
		gboolean _tmp29_;
		gchar* _tmp30_;
		GHashTable* _tmp31_;
		const gchar* _tmp32_;
		_tmp29_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp28_), (gpointer*) NULL);
		_g_free0 (uri);
		_tmp30_ = g_strdup ((const gchar*) _tmp28_);
		uri = _tmp30_;
		if (!_tmp29_) {
			break;
		}
		_tmp31_ = seen;
		_tmp32_ = uri;
		if (!g_hash_table_contains (_tmp31_, _tmp32_)) {
			SeahorseGkrKeyring* keyring = NULL;
			GHashTable* _tmp33_;
			const gchar* _tmp34_;
			gconstpointer _tmp35_;
			SeahorseGkrKeyring* _tmp36_;
			SeahorseGkrKeyring* _tmp37_;
			_tmp33_ = self->priv->_keyrings;
			_tmp34_ = uri;
			_tmp35_ = g_hash_table_lookup (_tmp33_, _tmp34_);
			_tmp36_ = _g_object_ref0 ((SeahorseGkrKeyring*) _tmp35_);
			keyring = _tmp36_;
			g_hash_table_iter_remove (&iter);
			_tmp37_ = keyring;
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp37_);
			_g_object_unref0 (keyring);
		}
	}
	if (!self->priv->_loaded) {
		self->priv->_loaded = TRUE;
		g_object_notify ((GObject*) self, "loaded");
	}
	_g_free0 (uri);
	_g_free0 (object_path);
	(keyrings == NULL) ? NULL : (keyrings = (_g_list_free__g_object_unref0_ (keyrings), NULL));
	_g_hash_table_unref0 (seen);
}

static guint
seahorse_gkr_backend_real_get_length (GcrCollection* base)
{
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_;
	guint result;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_keyrings;
	result = g_hash_table_size (_tmp0_);
	return result;
}

static GList*
seahorse_gkr_backend_real_get_objects (GcrCollection* base)
{
	SeahorseGkrBackend * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = seahorse_gkr_backend_get_keyrings (self);
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_gkr_backend_real_contains (GcrCollection* base,
                                    GObject* object)
{
	SeahorseGkrBackend * self;
	SeahorseGkrKeyring* keyring = NULL;
	SeahorseGkrKeyring* _tmp0_;
	SeahorseGkrKeyring* _tmp1_;
	GHashTable* _tmp2_;
	SeahorseGkrKeyring* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gconstpointer _tmp7_;
	SeahorseGkrKeyring* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	self = (SeahorseGkrBackend*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (SEAHORSE_GKR_IS_KEYRING (object) ? ((SeahorseGkrKeyring*) object) : NULL);
	keyring = _tmp0_;
	_tmp1_ = keyring;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (keyring);
		return result;
	}
	_tmp2_ = self->priv->_keyrings;
	_tmp3_ = keyring;
	_tmp4_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_hash_table_lookup (_tmp2_, _tmp6_);
	_tmp8_ = keyring;
	_tmp9_ = ((SeahorseGkrKeyring*) _tmp7_) == _tmp8_;
	_g_free0 (_tmp6_);
	result = _tmp9_;
	_g_object_unref0 (keyring);
	return result;
}

static SeahorsePlace*
seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base,
                                        const gchar* uri)
{
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	SeahorsePlace* _tmp2_;
	SeahorsePlace* result;
	self = (SeahorseGkrBackend*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->_keyrings;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uri);
	_tmp2_ = _g_object_ref0 ((SeahorsePlace*) ((SeahorseGkrKeyring*) _tmp1_));
	result = _tmp2_;
	return result;
}

void
seahorse_gkr_backend_initialize (void)
{
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	SeahorseGkrBackend* _tmp2_;
	SeahorseGkrBackend* _tmp3_;
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_if_fail (_tmp0_ == NULL);
	_tmp1_ = seahorse_gkr_backend_new ();
	_tmp2_ = _tmp1_;
	seahorse_backend_register ((SeahorseBackend*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = seahorse_gkr_backend__instance;
	g_return_if_fail (_tmp3_ != NULL);
}

SeahorseGkrBackend*
seahorse_gkr_backend_instance (void)
{
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	SeahorseGkrBackend* _tmp2_;
	SeahorseGkrBackend* result;
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp1_ = seahorse_gkr_backend__instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GList*
seahorse_gkr_backend_get_keyrings (SeahorseGkrBackend* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keyrings;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
seahorse_gkr_backend_read_alias_data_free (gpointer _data)
{
	SeahorseGkrBackendReadAliasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrBackendReadAliasData, _data_);
}

static void
seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self,
                                 const gchar* name,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SeahorseGkrBackendReadAliasData* _data_;
	SeahorseGkrBackend* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_data_ = g_slice_new0 (SeahorseGkrBackendReadAliasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_backend_read_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp1_;
	seahorse_gkr_backend_read_alias_co (_data_);
}

static void
seahorse_gkr_backend_read_alias_finish (SeahorseGkrBackend* self,
                                        GAsyncResult* _res_)
{
	SeahorseGkrBackendReadAliasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
seahorse_gkr_backend_read_alias_co (SeahorseGkrBackendReadAliasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_service;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->_service;
		_data_->_tmp2_ = secret_service_read_alias_dbus_path_sync (_data_->_tmp1_, _data_->name, NULL, &_data_->_inner_error0_);
		_data_->object_path = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->object_path;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->_aliases;
			_data_->_tmp5_ = g_strdup (_data_->name);
			_data_->_tmp6_ = _data_->object_path;
			_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
			g_hash_table_insert (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_);
			g_object_notify ((GObject*) _data_->self, "aliases");
		}
		_g_free0 (_data_->object_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->err;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("gkr-backend.vala:189: Couldn't read secret service alias %s: %s", _data_->name, _data_->_tmp9_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self)
{
	g_return_if_fail (self != NULL);
	seahorse_gkr_backend_read_alias (self, "default", NULL, NULL);
	seahorse_gkr_backend_read_alias (self, "session", NULL, NULL);
	seahorse_gkr_backend_read_alias (self, "login", NULL, NULL);
}

void
seahorse_gkr_backend_refresh (SeahorseGkrBackend* self)
{
	g_return_if_fail (self != NULL);
	seahorse_gkr_backend_refresh_aliases (self);
	seahorse_gkr_backend_refresh_collections (self);
}

gboolean
seahorse_gkr_backend_has_alias (SeahorseGkrBackend* self,
                                const gchar* alias,
                                SeahorseGkrKeyring* keyring)
{
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (alias != NULL, FALSE);
	g_return_val_if_fail (keyring != NULL, FALSE);
	_tmp0_ = g_dbus_proxy_get_object_path ((GDBusProxy*) keyring);
	_tmp1_ = g_strdup (_tmp0_);
	object_path = _tmp1_;
	_tmp2_ = self->priv->_aliases;
	_tmp3_ = g_hash_table_lookup (_tmp2_, alias);
	result = g_strcmp0 ((const gchar*) _tmp3_, object_path) == 0;
	_g_free0 (object_path);
	return result;
}

SeahorseGkrBackend*
seahorse_gkr_backend_construct (GType object_type)
{
	SeahorseGkrBackend * self = NULL;
	self = (SeahorseGkrBackend*) g_object_new (object_type, NULL);
	return self;
}

SeahorseGkrBackend*
seahorse_gkr_backend_new (void)
{
	return seahorse_gkr_backend_construct (SEAHORSE_GKR_TYPE_BACKEND);
}

static const gchar*
seahorse_gkr_backend_real_get_name (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseGkrBackend* self;
	self = (SeahorseGkrBackend*) base;
	result = SEAHORSE_GKR_NAME;
	return result;
}

static const gchar*
seahorse_gkr_backend_real_get_label (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseGkrBackend* self;
	self = (SeahorseGkrBackend*) base;
	result = _ ("Passwords");
	return result;
}

static const gchar*
seahorse_gkr_backend_real_get_description (SeahorseBackend* base)
{
	const gchar* result;
	SeahorseGkrBackend* self;
	self = (SeahorseGkrBackend*) base;
	result = _ ("Stored personal passwords, credentials and secrets");
	return result;
}

static SeahorseActionGroup*
seahorse_gkr_backend_real_get_actions (SeahorseBackend* base)
{
	SeahorseActionGroup* result;
	SeahorseGkrBackend* self;
	SeahorseActionGroup* _tmp0_;
	SeahorseActionGroup* _tmp1_;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_actions;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GHashTable*
seahorse_gkr_backend_get_aliases (SeahorseGkrBackend* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aliases;
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_gkr_backend_real_get_loaded (SeahorseBackend* base)
{
	gboolean result;
	SeahorseGkrBackend* self;
	self = (SeahorseGkrBackend*) base;
	result = self->priv->_loaded;
	return result;
}

SecretService*
seahorse_gkr_backend_get_service (SeahorseGkrBackend* self)
{
	SecretService* result;
	SecretService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}

static void
___lambda21_ (SeahorseGkrBackend* self,
              GObject* obj,
              GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	seahorse_gkr_backend_refresh_collections (self);
}

static void
____lambda21__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda21_ ((SeahorseGkrBackend*) self, _sender, pspec);
}

static void
___lambda22_ (SeahorseGkrBackend* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SecretService* _tmp0_;
		_tmp0_ = self->priv->_service;
		secret_service_load_collections_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		seahorse_gkr_backend_refresh_collections (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gkr-backend.vala:89: couldn't load all secret collections: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda22__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda22_ ((SeahorseGkrBackend*) self, source_object, res);
	g_object_unref (self);
}

static void
_seahorse_gkr_backend___lambda20_ (SeahorseGkrBackend* self,
                                   GObject* obj,
                                   GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SecretService* _tmp0_ = NULL;
		SecretService* _tmp1_;
		SecretService* _tmp2_;
		SecretService* _tmp3_;
		SecretService* _tmp4_;
		_tmp1_ = secret_service_open_finish (res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->_service);
		self->priv->_service = _tmp2_;
		_tmp3_ = self->priv->_service;
		g_signal_connect_object ((GObject*) _tmp3_, "notify::collections", (GCallback) ____lambda21__g_object_notify, self, 0);
		_tmp4_ = self->priv->_service;
		secret_service_load_collections (_tmp4_, NULL, ____lambda22__gasync_ready_callback, g_object_ref (self));
		seahorse_gkr_backend_refresh_aliases (self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("gkr-backend.vala:94: couldn't connect to secret service: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify ((GObject*) self, "service");
}

static void
__seahorse_gkr_backend___lambda20__gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	_seahorse_gkr_backend___lambda20_ ((SeahorseGkrBackend*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
seahorse_gkr_backend_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackend * self;
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	SeahorseActionGroup* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_val_if_fail (_tmp0_ == NULL, NULL);
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (seahorse_gkr_backend__instance);
	seahorse_gkr_backend__instance = _tmp1_;
	_tmp2_ = seahorse_gkr_backend_actions_instance (self);
	_g_object_unref0 (self->priv->_actions);
	self->priv->_actions = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_keyrings);
	self->priv->_keyrings = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->_aliases);
	self->priv->_aliases = _tmp8_;
	secret_service_open (SEAHORSE_GKR_TYPE_MY_SERVICE, NULL, SECRET_SERVICE_OPEN_SESSION, NULL, __seahorse_gkr_backend___lambda20__gasync_ready_callback, g_object_ref (self));
	return obj;
}

static void
seahorse_gkr_backend_class_init (SeahorseGkrBackendClass * klass,
                                 gpointer klass_data)
{
	seahorse_gkr_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrBackend_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_gkr_backend_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_NAME_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_LABEL_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_DESCRIPTION_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", SEAHORSE_TYPE_ACTION_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ALIASES_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_ALIASES_PROPERTY] = g_param_spec_boxed ("aliases", "aliases", "aliases", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_LOADED_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_SERVICE_PROPERTY, seahorse_gkr_backend_properties[SEAHORSE_GKR_BACKEND_SERVICE_PROPERTY] = g_param_spec_object ("service", "service", "service", secret_service_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_gkr_backend_gcr_collection_interface_init (GcrCollectionIface * iface,
                                                    gpointer iface_data)
{
	seahorse_gkr_backend_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*) (GcrCollection*)) seahorse_gkr_backend_real_get_length;
	iface->get_objects = (GList* (*) (GcrCollection*)) seahorse_gkr_backend_real_get_objects;
	iface->contains = (gboolean (*) (GcrCollection*, GObject*)) seahorse_gkr_backend_real_contains;
}

static void
seahorse_gkr_backend_seahorse_backend_interface_init (SeahorseBackendIface * iface,
                                                      gpointer iface_data)
{
	seahorse_gkr_backend_seahorse_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_place = (SeahorsePlace* (*) (SeahorseBackend*, const gchar*)) seahorse_gkr_backend_real_lookup_place;
	iface->get_name = seahorse_gkr_backend_real_get_name;
	iface->get_label = seahorse_gkr_backend_real_get_label;
	iface->get_description = seahorse_gkr_backend_real_get_description;
	iface->get_actions = seahorse_gkr_backend_real_get_actions;
	iface->get_loaded = seahorse_gkr_backend_real_get_loaded;
}

static void
seahorse_gkr_backend_instance_init (SeahorseGkrBackend * self,
                                    gpointer klass)
{
	self->priv = seahorse_gkr_backend_get_instance_private (self);
}

static void
seahorse_gkr_backend_finalize (GObject * obj)
{
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	_g_object_unref0 (self->priv->_service);
	_g_hash_table_unref0 (self->priv->_keyrings);
	_g_hash_table_unref0 (self->priv->_aliases);
	_g_object_unref0 (self->priv->_actions);
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackend), 0, (GInstanceInitFunc) seahorse_gkr_backend_instance_init, NULL };
	static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_backend_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_backend_info = { (GInterfaceInitFunc) seahorse_gkr_backend_seahorse_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_gkr_backend_type_id;
	seahorse_gkr_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseGkrBackend", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_gkr_backend_type_id, gcr_collection_get_type (), &gcr_collection_info);
	g_type_add_interface_static (seahorse_gkr_backend_type_id, SEAHORSE_TYPE_BACKEND, &seahorse_backend_info);
	SeahorseGkrBackend_private_offset = g_type_add_instance_private (seahorse_gkr_backend_type_id, sizeof (SeahorseGkrBackendPrivate));
	return seahorse_gkr_backend_type_id;
}

GType
seahorse_gkr_backend_get_type (void)
{
	static volatile gsize seahorse_gkr_backend_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_type_id__once)) {
		GType seahorse_gkr_backend_type_id;
		seahorse_gkr_backend_type_id = seahorse_gkr_backend_get_type_once ();
		g_once_init_leave (&seahorse_gkr_backend_type_id__once, seahorse_gkr_backend_type_id);
	}
	return seahorse_gkr_backend_type_id__once;
}

static void
_vala_seahorse_gkr_backend_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_NAME_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_name ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_LABEL_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_label ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_DESCRIPTION_PROPERTY:
		g_value_set_string (value, seahorse_backend_get_description ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_ACTIONS_PROPERTY:
		g_value_take_object (value, seahorse_backend_get_actions ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_ALIASES_PROPERTY:
		g_value_set_boxed (value, seahorse_gkr_backend_get_aliases (self));
		break;
		case SEAHORSE_GKR_BACKEND_LOADED_PROPERTY:
		g_value_set_boolean (value, seahorse_backend_get_loaded ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_SERVICE_PROPERTY:
		g_value_set_object (value, seahorse_gkr_backend_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
seahorse_gkr_backend_actions_get_instance_private (SeahorseGkrBackendActions* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrBackendActions_private_offset);
}

static void
_seahorse_gkr_backend_actions_on_new_keyring_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	seahorse_gkr_backend_actions_on_new_keyring ((SeahorseGkrBackendActions*) self, action, parameter);
}

static void
_seahorse_gkr_backend_actions_on_new_item_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	seahorse_gkr_backend_actions_on_new_item ((SeahorseGkrBackendActions*) self, action, parameter);
}

static void
_seahorse_gkr_backend_actions_on_copy_secret_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	seahorse_gkr_backend_actions_on_copy_secret ((SeahorseGkrBackendActions*) self, action, parameter);
}

static SeahorseGkrBackendActions*
seahorse_gkr_backend_actions_construct (GType object_type,
                                        SeahorseGkrBackend* backend)
{
	SeahorseGkrBackendActions * self = NULL;
	g_return_val_if_fail (backend != NULL, NULL);
	self = (SeahorseGkrBackendActions*) g_object_new (object_type, "prefix", "gkr", "backend", backend, NULL);
	return self;
}

static SeahorseGkrBackendActions*
seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend)
{
	return seahorse_gkr_backend_actions_construct (SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, backend);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
seahorse_gkr_backend_actions_on_new_keyring (SeahorseGkrBackendActions* self,
                                             GSimpleAction* action,
                                             GVariant* param)
{
	SeahorseGkrKeyringAdd* dialog = NULL;
	SeahorseCatalog* _tmp0_;
	SeahorseCatalog* _tmp1_;
	SeahorseCatalog* _tmp2_;
	SeahorseGkrKeyringAdd* _tmp3_;
	SeahorseGkrKeyringAdd* _tmp4_;
	gint response = 0;
	SeahorseGkrKeyringAdd* _tmp5_;
	SeahorseGkrKeyringAdd* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = seahorse_gkr_keyring_add_new ((GtkWindow*) _tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp5_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		SeahorseCatalog* _tmp6_;
		SeahorseCatalog* _tmp7_;
		SeahorseCatalog* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = _variant_new1 ("secret-service");
		g_action_group_activate_action ((GActionGroup*) _tmp8_, "focus-place", _tmp9_);
		_g_variant_unref0 (_tmp9_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp10_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_g_object_unref0 (dialog);
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
seahorse_gkr_backend_actions_on_new_item (SeahorseGkrBackendActions* self,
                                          GSimpleAction* action,
                                          GVariant* param)
{
	SeahorseGkrItemAdd* dialog = NULL;
	SeahorseCatalog* _tmp0_;
	SeahorseCatalog* _tmp1_;
	SeahorseCatalog* _tmp2_;
	SeahorseGkrItemAdd* _tmp3_;
	SeahorseGkrItemAdd* _tmp4_;
	gint response = 0;
	SeahorseGkrItemAdd* _tmp5_;
	SeahorseGkrItemAdd* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = seahorse_gkr_item_add_new ((GtkWindow*) _tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp5_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		SeahorseCatalog* _tmp6_;
		SeahorseCatalog* _tmp7_;
		SeahorseCatalog* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = _variant_new2 ("secret-service");
		g_action_group_activate_action ((GActionGroup*) _tmp8_, "focus-place", _tmp9_);
		_g_variant_unref0 (_tmp9_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp10_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_g_object_unref0 (dialog);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorseGkrBackendActions* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->selected_item);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda18_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseGkrBackendActions* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		seahorse_gkr_item_copy_secret_to_clipboard_finish (_data1_->selected_item, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		SeahorseCatalog* _tmp0_;
		SeahorseCatalog* _tmp1_;
		SeahorseCatalog* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		seahorse_util_show_error ((GtkWidget*) _tmp2_, "Couldn't copy secret", _tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda18__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda18_ (self, source_object, res);
	block1_data_unref (self);
}

static void
seahorse_gkr_backend_actions_on_copy_secret (SeahorseGkrBackendActions* self,
                                             GSimpleAction* action,
                                             GVariant* param)
{
	Block1Data* _data1_;
	SeahorseCatalog* _tmp0_;
	SeahorseCatalog* _tmp1_;
	SeahorseCatalog* _tmp2_;
	GList* selected = NULL;
	SeahorseCatalog* _tmp3_;
	SeahorseCatalog* _tmp4_;
	SeahorseCatalog* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GObject* _tmp9_;
	SeahorseGkrItem* _tmp10_;
	GtkClipboard* clipboard = NULL;
	SeahorseCatalog* _tmp11_;
	SeahorseCatalog* _tmp12_;
	SeahorseCatalog* _tmp13_;
	GdkDisplay* _tmp14_;
	GtkClipboard* _tmp15_;
	GtkClipboard* _tmp16_;
	GtkClipboard* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = seahorse_catalog_get_selected_objects (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	selected = _tmp7_;
	g_return_if_fail (g_list_length (selected) == ((guint) 1));
	_tmp8_ = selected->data;
	_tmp9_ = (GObject*) _tmp8_;
	_tmp10_ = _g_object_ref0 (SEAHORSE_GKR_IS_ITEM (_tmp9_) ? ((SeahorseGkrItem*) _tmp9_) : NULL);
	_data1_->selected_item = _tmp10_;
	g_return_if_fail (_data1_->selected_item != NULL);
	_tmp11_ = seahorse_action_group_get_catalog ((SeahorseActionGroup*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_widget_get_display ((GtkWidget*) _tmp13_);
	_tmp15_ = gtk_clipboard_get_default (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp13_);
	clipboard = _tmp17_;
	seahorse_gkr_item_copy_secret_to_clipboard (_data1_->selected_item, clipboard, ___lambda18__gasync_ready_callback, block1_data_ref (_data1_));
	_g_object_unref0 (clipboard);
	(selected == NULL) ? NULL : (selected = (_g_list_free__g_object_unref0_ (selected), NULL));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
seahorse_gkr_backend_actions_real_set_actions_for_selected_objects (SeahorseActionGroup* base,
                                                                    GList* objects)
{
	SeahorseGkrBackendActions * self;
	gboolean can_copy_secret = FALSE;
	GAction* _tmp1_;
	self = (SeahorseGkrBackendActions*) base;
	can_copy_secret = FALSE;
	if (g_list_length (objects) == ((guint) 1)) {
		gconstpointer _tmp0_;
		_tmp0_ = objects->data;
		can_copy_secret = SEAHORSE_GKR_IS_ITEM ((GObject*) _tmp0_);
	}
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "copy-secret");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), can_copy_secret);
}

SeahorseActionGroup*
seahorse_gkr_backend_actions_instance (SeahorseGkrBackend* backend)
{
	SeahorseGkrBackendActions* actions = NULL;
	GObject* _tmp0_;
	SeahorseGkrBackendActions* _tmp1_;
	SeahorseGkrBackendActions* _tmp2_;
	SeahorseGkrBackendActions* _tmp3_;
	SeahorseActionGroup* result;
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&seahorse_gkr_backend_actions__instance);
	actions = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	_tmp1_ = actions;
	if (_tmp1_ != NULL) {
		result = (SeahorseActionGroup*) actions;
		return result;
	}
	_tmp2_ = seahorse_gkr_backend_actions_new (backend);
	_g_object_unref0 (actions);
	actions = _tmp2_;
	_tmp3_ = actions;
	g_weak_ref_set (&seahorse_gkr_backend_actions__instance, (GObject*) _tmp3_);
	result = (SeahorseActionGroup*) actions;
	return result;
}

SeahorseGkrBackend*
seahorse_gkr_backend_actions_get_backend (SeahorseGkrBackendActions* self)
{
	SeahorseGkrBackend* result;
	SeahorseGkrBackend* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend;
	result = _tmp0_;
	return result;
}

static void
seahorse_gkr_backend_actions_set_backend (SeahorseGkrBackendActions* self,
                                          SeahorseGkrBackend* value)
{
	SeahorseGkrBackend* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_gkr_backend_actions_get_backend (self);
	if (old_value != value) {
		SeahorseGkrBackend* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backend);
		self->priv->_backend = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_backend_actions_properties[SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY]);
	}
}

static void
_seahorse_gkr_backend_actions___lambda19_ (SeahorseGkrBackendActions* self,
                                           GParamSpec* pspec)
{
	const gchar* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	SecretService* _tmp2_;
	SecretService* _tmp3_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec->name;
	if (g_strcmp0 (_tmp0_, "service") == 0) {
		return;
	}
	if (self->priv->_initialized) {
		return;
	}
	_tmp1_ = self->priv->_backend;
	_tmp2_ = seahorse_gkr_backend_get_service (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	self->priv->_initialized = TRUE;
	g_action_map_add_action_entries ((GActionMap*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS, (gint) G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS), self);
}

static void
__seahorse_gkr_backend_actions___lambda19__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_seahorse_gkr_backend_actions___lambda19_ ((SeahorseGkrBackendActions*) self, pspec);
}

static GObject *
seahorse_gkr_backend_actions_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackendActions * self;
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	self->priv->_initialized = FALSE;
	_tmp0_ = self->priv->_backend;
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) __seahorse_gkr_backend_actions___lambda19__g_object_notify, self, G_CONNECT_AFTER);
	_tmp1_ = self->priv->_backend;
	g_object_notify ((GObject*) _tmp1_, "service");
	return obj;
}

static void
seahorse_gkr_backend_actions_class_init (SeahorseGkrBackendActionsClass * klass,
                                         gpointer klass_data)
{
	seahorse_gkr_backend_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrBackendActions_private_offset);
	((SeahorseActionGroupClass *) klass)->set_actions_for_selected_objects = (void (*) (SeahorseActionGroup*, GList*)) seahorse_gkr_backend_actions_real_set_actions_for_selected_objects;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_backend_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY, seahorse_gkr_backend_actions_properties[SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY] = g_param_spec_object ("backend", "backend", "backend", SEAHORSE_GKR_TYPE_BACKEND, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
seahorse_gkr_backend_actions_instance_init (SeahorseGkrBackendActions * self,
                                            gpointer klass)
{
	self->priv = seahorse_gkr_backend_actions_get_instance_private (self);
}

static void
seahorse_gkr_backend_actions_finalize (GObject * obj)
{
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	_g_object_unref0 (self->priv->_backend);
	G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_backend_actions_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackendActions), 0, (GInstanceInitFunc) seahorse_gkr_backend_actions_instance_init, NULL };
	GType seahorse_gkr_backend_actions_type_id;
	seahorse_gkr_backend_actions_type_id = g_type_register_static (SEAHORSE_TYPE_ACTION_GROUP, "SeahorseGkrBackendActions", &g_define_type_info, 0);
	SeahorseGkrBackendActions_private_offset = g_type_add_instance_private (seahorse_gkr_backend_actions_type_id, sizeof (SeahorseGkrBackendActionsPrivate));
	return seahorse_gkr_backend_actions_type_id;
}

GType
seahorse_gkr_backend_actions_get_type (void)
{
	static volatile gsize seahorse_gkr_backend_actions_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_actions_type_id__once)) {
		GType seahorse_gkr_backend_actions_type_id;
		seahorse_gkr_backend_actions_type_id = seahorse_gkr_backend_actions_get_type_once ();
		g_once_init_leave (&seahorse_gkr_backend_actions_type_id__once, seahorse_gkr_backend_actions_type_id);
	}
	return seahorse_gkr_backend_actions_type_id__once;
}

static void
_vala_seahorse_gkr_backend_actions_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY:
		g_value_set_object (value, seahorse_gkr_backend_actions_get_backend (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_gkr_backend_actions_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_PROPERTY:
		seahorse_gkr_backend_actions_set_backend (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

