/* rygel-media-engine.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_MEDIA_ENGINE_0_PROPERTY,
	RYGEL_MEDIA_ENGINE_NUM_PROPERTIES
};
static GParamSpec* rygel_media_engine_properties[RYGEL_MEDIA_ENGINE_NUM_PROPERTIES];

#define RYGEL_TYPE_ENGINE_LOADER (rygel_engine_loader_get_type ())
#define RYGEL_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoader))
#define RYGEL_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))
#define RYGEL_IS_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_IS_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_ENGINE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))

typedef struct _RygelEngineLoader RygelEngineLoader;
typedef struct _RygelEngineLoaderClass RygelEngineLoaderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	RYGEL_MEDIA_ENGINE_RESOURCE_CHANGED_SIGNAL,
	RYGEL_MEDIA_ENGINE_NUM_SIGNALS
};
static guint rygel_media_engine_signals[RYGEL_MEDIA_ENGINE_NUM_SIGNALS] = {0};

static gpointer rygel_media_engine_parent_class = NULL;
static RygelMediaEngine* rygel_media_engine_instance;
static RygelMediaEngine* rygel_media_engine_instance = NULL;

VALA_EXTERN GType rygel_engine_loader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelEngineLoader* rygel_engine_loader_new (void);
VALA_EXTERN RygelEngineLoader* rygel_engine_loader_construct (GType object_type);
VALA_EXTERN RygelMediaEngine* rygel_engine_loader_load_engine (RygelEngineLoader* self);
static GList* rygel_media_engine_real_get_dlna_profiles (RygelMediaEngine* self);
static RygelDataSource* rygel_media_engine_real_create_data_source_for_resource (RygelMediaEngine* self,
                                                                          RygelMediaObject* item,
                                                                          RygelMediaResource* resource,
                                                                          GHashTable* replacements,
                                                                          GError** error);
static RygelDataSource* rygel_media_engine_real_create_data_source_for_uri (RygelMediaEngine* self,
                                                                     const gchar* uri,
                                                                     GError** error);
static GList* rygel_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* self);
static void rygel_media_engine_finalize (GObject * obj);
static GType rygel_media_engine_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_media_engine_error_quark (void)
{
	return g_quark_from_static_string ("rygel-media-engine-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_media_engine_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_MEDIA_ENGINE_ERROR_NOT_FOUND, "RYGEL_MEDIA_ENGINE_ERROR_NOT_FOUND", "not-found"}, {0, NULL, NULL}};
	GType rygel_media_engine_error_type_id;
	rygel_media_engine_error_type_id = g_enum_register_static ("RygelMediaEngineError", values);
	return rygel_media_engine_error_type_id;
}

GType
rygel_media_engine_error_get_type (void)
{
	static volatile gsize rygel_media_engine_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_engine_error_type_id__once)) {
		GType rygel_media_engine_error_type_id;
		rygel_media_engine_error_type_id = rygel_media_engine_error_get_type_once ();
		g_once_init_leave (&rygel_media_engine_error_type_id__once, rygel_media_engine_error_type_id);
	}
	return rygel_media_engine_error_type_id__once;
}

void
rygel_media_engine_init (GError** error)
{
	RygelMediaEngine* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = rygel_media_engine_instance;
	if (_tmp0_ == NULL) {
		RygelEngineLoader* loader = NULL;
		RygelEngineLoader* _tmp1_;
		RygelEngineLoader* _tmp2_;
		RygelMediaEngine* _tmp3_;
		RygelMediaEngine* _tmp4_;
		_tmp1_ = rygel_engine_loader_new ();
		loader = _tmp1_;
		_tmp2_ = loader;
		_tmp3_ = rygel_engine_loader_load_engine (_tmp2_);
		_g_object_unref0 (rygel_media_engine_instance);
		rygel_media_engine_instance = _tmp3_;
		_tmp4_ = rygel_media_engine_instance;
		if (_tmp4_ == NULL) {
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (RYGEL_MEDIA_ENGINE_ERROR, RYGEL_MEDIA_ENGINE_ERROR_NOT_FOUND, _ ("No media engine found."));
			_inner_error0_ = _tmp5_;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (loader);
			return;
		}
		_g_object_unref0 (loader);
	}
}

/**
     * Get the singleton instance of the currently used media engine.
     *
     * @return An instance of a concrete #RygelMediaEngine implementation.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMediaEngine*
rygel_media_engine_get_default (void)
{
	RygelMediaEngine* _tmp0_;
	RygelMediaEngine* _tmp1_;
	RygelMediaEngine* _tmp2_;
	RygelMediaEngine* result;
	_tmp0_ = rygel_media_engine_instance;
	if (_tmp0_ == NULL) {
		g_error ("rygel-media-engine.vala:75: %s", _ ("MediaEngine.init was not called. Cannot continue."));
	}
	_tmp1_ = rygel_media_engine_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
     * Get a list of the DLNA profiles that the media engine can stream.
     *
     * This information is needed to implement DLNA's
     * ConnectionManager.GetProtocolInfo call and to determine whether Rygel
     * can accept an uploaded file.
     *
     * @return A list of #RygelDLNAProfile<!-- -->s
     */
static GList*
rygel_media_engine_real_get_dlna_profiles (RygelMediaEngine* self)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_get_dlna_profiles'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GList*
rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self)
{
	RygelMediaEngineClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->get_dlna_profiles) {
		return _klass_->get_dlna_profiles (self);
	}
	return NULL;
}

void
rygel_media_engine_get_resources_for_item (RygelMediaEngine* self,
                                           RygelMediaObject* item,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelMediaEngineClass* _klass_;
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->get_resources_for_item) {
		_klass_->get_resources_for_item (self, item, _callback_, _user_data_);
	}
}

GeeList*
rygel_media_engine_get_resources_for_item_finish (RygelMediaEngine* self,
                                                  GAsyncResult* _res_)
{
	RygelMediaEngineClass* _klass_;
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->get_resources_for_item_finish) {
		return _klass_->get_resources_for_item_finish (self, _res_);
	}
	return NULL;
}

/**
     * Get a #DataSource for given #MediaResource representation of the #MediaObject.
     *
     * @param item The #MediaObject to create the #DataSource for
     * @param resource The specific resource to create the #DataSource for
     *
     * @return A #DataSource representing the given item resource
     */
static RygelDataSource*
rygel_media_engine_real_create_data_source_for_resource (RygelMediaEngine* self,
                                                         RygelMediaObject* item,
                                                         RygelMediaResource* resource,
                                                         GHashTable* replacements,
                                                         GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_create_data_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelDataSource*
rygel_media_engine_create_data_source_for_resource (RygelMediaEngine* self,
                                                    RygelMediaObject* item,
                                                    RygelMediaResource* resource,
                                                    GHashTable* replacements,
                                                    GError** error)
{
	RygelMediaEngineClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->create_data_source_for_resource) {
		return _klass_->create_data_source_for_resource (self, item, resource, replacements, error);
	}
	return NULL;
}

/**
     * Get a #DataSource for the URI.
     *
     * @param uri to create the #DataSource for.
     * @return A #DataSource representing the uri
     */
static RygelDataSource*
rygel_media_engine_real_create_data_source_for_uri (RygelMediaEngine* self,
                                                    const gchar* uri,
                                                    GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_create_data_source_for_uri'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelDataSource*
rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self,
                                               const gchar* uri,
                                               GError** error)
{
	RygelMediaEngineClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->create_data_source_for_uri) {
		return _klass_->create_data_source_for_uri (self, uri, error);
	}
	return NULL;
}

/**
     * Get a list of URI schemes that are internal to the engine.
     *
     * @return A list of strings considered protocol schemees
     */
static GList*
rygel_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* self)
{
	GList* result;
	result = NULL;
	return result;
}

GList*
rygel_media_engine_get_internal_protocol_schemes (RygelMediaEngine* self)
{
	RygelMediaEngineClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_ENGINE_GET_CLASS (self);
	if (_klass_->get_internal_protocol_schemes) {
		return _klass_->get_internal_protocol_schemes (self);
	}
	return NULL;
}

RygelMediaEngine*
rygel_media_engine_construct (GType object_type)
{
	RygelMediaEngine * self = NULL;
	self = (RygelMediaEngine*) g_object_new (object_type, NULL);
	return self;
}

static void
rygel_media_engine_class_init (RygelMediaEngineClass * klass,
                               gpointer klass_data)
{
	rygel_media_engine_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = (GList* (*) (RygelMediaEngine*)) rygel_media_engine_real_get_dlna_profiles;
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = (RygelDataSource* (*) (RygelMediaEngine*, RygelMediaObject*, RygelMediaResource*, GHashTable*, GError**)) rygel_media_engine_real_create_data_source_for_resource;
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = (RygelDataSource* (*) (RygelMediaEngine*, const gchar*, GError**)) rygel_media_engine_real_create_data_source_for_uri;
	((RygelMediaEngineClass *) klass)->get_internal_protocol_schemes = (GList* (*) (RygelMediaEngine*)) rygel_media_engine_real_get_internal_protocol_schemes;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_engine_finalize;
	/**
	     * Signaled when one or more #MediaResources<!-- -->s associated with a MediaObject changes.
	     * #get_resources_for_item should be called in response to this signal to retrieve the
	     * updated list of MediaResources for the associated MediaObject.
	     *
	     * @param media_object_uri is the uri associated with a MediaObject.=
	     */
	rygel_media_engine_signals[RYGEL_MEDIA_ENGINE_RESOURCE_CHANGED_SIGNAL] = g_signal_new ("resource-changed", RYGEL_TYPE_MEDIA_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
rygel_media_engine_instance_init (RygelMediaEngine * self,
                                  gpointer klass)
{
}

static void
rygel_media_engine_finalize (GObject * obj)
{
	RygelMediaEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine);
	G_OBJECT_CLASS (rygel_media_engine_parent_class)->finalize (obj);
}

/**
 * This is the base class for media engines that contain knowledge about 
 * the streaming and transformational capabilites of the media library in use.
 *
 * Media engines express what representations of a MediaObject they can
 * produce by returning MediaResource objects which will, in turn, be
 * used to express to endpoints representations can be streamed from
 * the MediaServer. These representations may include transformations,
 * time-scaled representations, and/or encrypted representations.
 *
 * See, for instance, Rygel's built-in "gstreamer" and "simple" media engines,
 * or the external rygel-gst-0-10-media-engine module.
 *
 * The actual media engine used by Rygel at runtime is specified
 * by the media-engine configuration key.
 * For instance, in rygel.conf:
 * media-engine=librygel-media-engine-gst.so
 *
 * Media engines should also derive their own #RygelDataSource,
 * returning an instance of it from create_data_source().
 *
 * See the
 * <link linkend="implementing-media-engines">Implementing Media Engines</link> section.
 */
 G_GNUC_NO_INLINE static GType
rygel_media_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaEngine), 0, (GInstanceInitFunc) rygel_media_engine_instance_init, NULL };
	GType rygel_media_engine_type_id;
	rygel_media_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return rygel_media_engine_type_id;
}

GType
rygel_media_engine_get_type (void)
{
	static volatile gsize rygel_media_engine_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_engine_type_id__once)) {
		GType rygel_media_engine_type_id;
		rygel_media_engine_type_id = rygel_media_engine_get_type_once ();
		g_once_init_leave (&rygel_media_engine_type_id__once, rygel_media_engine_type_id);
	}
	return rygel_media_engine_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

