/* AccountSourceItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AccountSourceItem.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <camel/camel.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_SOURCE_LIST_TYPE_ITEM (mail_source_list_item_get_type ())
#define MAIL_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItem))
#define MAIL_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))
#define MAIL_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))

typedef struct _MailSourceListItem MailSourceListItem;
typedef struct _MailSourceListItemClass MailSourceListItemClass;
typedef struct _MailSourceListItemPrivate MailSourceListItemPrivate;

#define MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM (mail_source_list_expandable_item_get_type ())
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItem))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))

typedef struct _MailSourceListExpandableItem MailSourceListExpandableItem;
typedef struct _MailSourceListExpandableItemClass MailSourceListExpandableItemClass;
typedef struct _MailSourceListExpandableItemPrivate MailSourceListExpandableItemPrivate;

#define MAIL_TYPE_SOURCE_LIST_SORTABLE (mail_source_list_sortable_get_type ())
#define MAIL_SOURCE_LIST_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SOURCE_LIST_SORTABLE, MailSourceListSortable))
#define MAIL_IS_SOURCE_LIST_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SOURCE_LIST_SORTABLE))
#define MAIL_SOURCE_LIST_SORTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MAIL_TYPE_SOURCE_LIST_SORTABLE, MailSourceListSortableIface))

typedef struct _MailSourceListSortable MailSourceListSortable;
typedef struct _MailSourceListSortableIface MailSourceListSortableIface;

#define MAIL_TYPE_ACCOUNT_SOURCE_ITEM (mail_account_source_item_get_type ())
#define MAIL_ACCOUNT_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem))
#define MAIL_ACCOUNT_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItemClass))
#define MAIL_IS_ACCOUNT_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM))
#define MAIL_IS_ACCOUNT_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ACCOUNT_SOURCE_ITEM))
#define MAIL_ACCOUNT_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItemClass))

typedef struct _MailAccountSourceItem MailAccountSourceItem;
typedef struct _MailAccountSourceItemClass MailAccountSourceItemClass;
typedef struct _MailAccountSourceItemPrivate MailAccountSourceItemPrivate;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;

#define MAIL_TYPE_FOLDER_SOURCE_ITEM (mail_folder_source_item_get_type ())
#define MAIL_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem))
#define MAIL_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))
#define MAIL_IS_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_IS_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_FOLDER_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))

typedef struct _MailFolderSourceItem MailFolderSourceItem;
typedef struct _MailFolderSourceItemClass MailFolderSourceItemClass;

#define MAIL_TYPE_ACCOUNT_SAVED_STATE (mail_account_saved_state_get_type ())
#define MAIL_ACCOUNT_SAVED_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ACCOUNT_SAVED_STATE, MailAccountSavedState))
#define MAIL_ACCOUNT_SAVED_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ACCOUNT_SAVED_STATE, MailAccountSavedStateClass))
#define MAIL_IS_ACCOUNT_SAVED_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ACCOUNT_SAVED_STATE))
#define MAIL_IS_ACCOUNT_SAVED_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ACCOUNT_SAVED_STATE))
#define MAIL_ACCOUNT_SAVED_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ACCOUNT_SAVED_STATE, MailAccountSavedStateClass))

typedef struct _MailAccountSavedState MailAccountSavedState;
typedef struct _MailAccountSavedStateClass MailAccountSavedStateClass;
enum  {
	MAIL_ACCOUNT_SOURCE_ITEM_0_PROPERTY,
	MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY,
	MAIL_ACCOUNT_SOURCE_ITEM_NUM_PROPERTIES
};
static GParamSpec* mail_account_source_item_properties[MAIL_ACCOUNT_SOURCE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_CamelFolderInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelFolderInfo_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailAccountSourceItemLoadData MailAccountSourceItemLoadData;
typedef struct _MailAccountSourceItemReloadFoldersData MailAccountSourceItemReloadFoldersData;
typedef struct _Block42Data Block42Data;

#define MAIL_TYPE_ALIAS_DIALOG (mail_alias_dialog_get_type ())
#define MAIL_ALIAS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog))
#define MAIL_ALIAS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialogClass))
#define MAIL_IS_ALIAS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ALIAS_DIALOG))
#define MAIL_IS_ALIAS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ALIAS_DIALOG))
#define MAIL_ALIAS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialogClass))

typedef struct _MailAliasDialog MailAliasDialog;
typedef struct _MailAliasDialogClass MailAliasDialogClass;
enum  {
	MAIL_ACCOUNT_SOURCE_ITEM_LOADED_SIGNAL,
	MAIL_ACCOUNT_SOURCE_ITEM_START_EDIT_SIGNAL,
	MAIL_ACCOUNT_SOURCE_ITEM_NUM_SIGNALS
};
static guint mail_account_source_item_signals[MAIL_ACCOUNT_SOURCE_ITEM_NUM_SIGNALS] = {0};

struct _MailSourceListItem {
	GObject parent_instance;
	MailSourceListItemPrivate * priv;
};

struct _MailSourceListItemClass {
	GObjectClass parent_class;
	GtkMenu* (*get_context_menu) (MailSourceListItem* self);
	void (*edited) (MailSourceListItem* self, const gchar* new_name);
	void (*action_activated) (MailSourceListItem* self);
	void (*activated) (MailSourceListItem* self);
};

struct _MailSourceListExpandableItem {
	MailSourceListItem parent_instance;
	MailSourceListExpandableItemPrivate * priv;
};

struct _MailSourceListExpandableItemClass {
	MailSourceListItemClass parent_class;
	void (*toggled) (MailSourceListExpandableItem* self);
};

struct _MailSourceListSortableIface {
	GTypeInterface parent_iface;
	gboolean (*allow_dnd_sorting) (MailSourceListSortable* self);
	gint (*compare) (MailSourceListSortable* self, MailSourceListItem* a, MailSourceListItem* b);
};

struct _MailAccountSourceItem {
	MailSourceListExpandableItem parent_instance;
	MailAccountSourceItemPrivate * priv;
};

struct _MailAccountSourceItemClass {
	MailSourceListExpandableItemClass parent_class;
};

struct _MailAccountSourceItemPrivate {
	MailBackendAccount* _account;
	GCancellable* connect_cancellable;
	GeeHashMap* folder_items;
	MailAccountSavedState* saved_state;
	CamelOfflineStore* offlinestore;
};

struct _MailAccountSourceItemLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailAccountSourceItem* self;
	CamelFolderInfo* folderinfo;
	CamelOfflineStore* _tmp0_;
	GCancellable* _tmp1_;
	CamelFolderInfo* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _MailAccountSourceItemReloadFoldersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailAccountSourceItem* self;
	CamelOfflineStore* offlinestore;
	MailBackendAccount* _tmp0_;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	CamelOfflineStore* _tmp3_;
	GeeIterator* _folder_item_it;
	GeeHashMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	MailFolderSourceItem* folder_item;
	GeeIterator* _tmp11_;
	gpointer _tmp12_;
	CamelFolderInfo* folder_info;
	CamelOfflineStore* _tmp13_;
	MailFolderSourceItem* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GCancellable* _tmp17_;
	CamelFolderInfo* _tmp18_;
	MailFolderSourceItem* _tmp19_;
	CamelFolderInfo* _tmp20_;
	GError* e;
	GError* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

struct _Block42Data {
	int _ref_count_;
	MailAccountSourceItem* self;
	MailFolderSourceItem* folder_item;
};

static gint MailAccountSourceItem_private_offset;
static gpointer mail_account_source_item_parent_class = NULL;
static MailSourceListSortableIface * mail_account_source_item_mail_source_list_sortable_parent_iface = NULL;

VALA_EXTERN GType mail_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListItem, g_object_unref)
VALA_EXTERN GType mail_source_list_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListExpandableItem, g_object_unref)
VALA_EXTERN GType mail_source_list_sortable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListSortable, g_object_unref)
VALA_EXTERN GType mail_account_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAccountSourceItem, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN GType mail_folder_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFolderSourceItem, g_object_unref)
VALA_EXTERN GType mail_account_saved_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAccountSavedState, g_object_unref)
VALA_EXTERN GtkMenu* mail_source_list_item_get_context_menu (MailSourceListItem* self);
VALA_EXTERN MailAccountSourceItem* mail_account_source_item_new (MailBackendAccount* account);
VALA_EXTERN MailAccountSourceItem* mail_account_source_item_construct (GType object_type,
                                                           MailBackendAccount* account);
static void mail_account_source_item_load_data_free (gpointer _data);
VALA_EXTERN void mail_account_source_item_load (MailAccountSourceItem* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void mail_account_source_item_load_finish (MailAccountSourceItem* self,
                                           GAsyncResult* _res_);
static gboolean mail_account_source_item_load_co (MailAccountSourceItemLoadData* _data_);
static void mail_account_source_item_load_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void mail_account_source_item_show_info (MailAccountSourceItem* self,
                                         CamelFolderInfo* _folderinfo,
                                         MailSourceListExpandableItem* item);
static void _vala_CamelFolderInfo_free (CamelFolderInfo* self);
static void mail_account_source_item_folder_renamed (MailAccountSourceItem* self,
                                              const gchar* old_name,
                                              CamelFolderInfo* folder_info);
VALA_EXTERN void mail_folder_source_item_update_infos (MailFolderSourceItem* self,
                                           CamelFolderInfo* folderinfo);
VALA_EXTERN const gchar* mail_folder_source_item_get_full_name (MailFolderSourceItem* self);
static void mail_account_source_item_folder_deleted (MailAccountSourceItem* self,
                                              CamelFolderInfo* folder_info);
VALA_EXTERN MailSourceListExpandableItem* mail_source_list_item_get_parent (MailSourceListItem* self);
VALA_EXTERN void mail_source_list_expandable_item_remove (MailSourceListExpandableItem* self,
                                              MailSourceListItem* item);
static void mail_account_source_item_folder_created (MailAccountSourceItem* self,
                                              CamelFolderInfo* folder_info);
static void mail_account_source_item_reload_folders_data_free (gpointer _data);
static void mail_account_source_item_reload_folders (MailAccountSourceItem* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void mail_account_source_item_reload_folders_finish (MailAccountSourceItem* self,
                                                     GAsyncResult* _res_);
static gboolean mail_account_source_item_reload_folders_co (MailAccountSourceItemReloadFoldersData* _data_);
VALA_EXTERN MailBackendAccount* mail_account_source_item_get_account (MailAccountSourceItem* self);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
static void mail_account_source_item_reload_folders_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static CamelFolderInfo* _vala_CamelFolderInfo_copy (CamelFolderInfo* self);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
VALA_EXTERN MailFolderSourceItem* mail_folder_source_item_new (MailBackendAccount* account,
                                                   CamelFolderInfo* folderinfo);
VALA_EXTERN MailFolderSourceItem* mail_folder_source_item_construct (GType object_type,
                                                         MailBackendAccount* account,
                                                         CamelFolderInfo* folderinfo);
VALA_EXTERN void mail_account_saved_state_bind_with_expandable_item (MailAccountSavedState* self,
                                                         MailSourceListExpandableItem* item);
static void ___lambda16_ (Block42Data* _data42_);
static void ____lambda16__mail_folder_source_item_start_edit (MailFolderSourceItem* _sender,
                                                       gpointer self);
VALA_EXTERN gboolean mail_folder_source_item_get_is_special_folder (MailFolderSourceItem* self);
VALA_EXTERN void mail_source_list_expandable_item_add (MailSourceListExpandableItem* self,
                                           MailSourceListItem* item);
static gint mail_account_source_item_real_compare (MailSourceListSortable* base,
                                            MailSourceListItem* a,
                                            MailSourceListItem* b);
VALA_EXTERN gint mail_folder_source_item_get_pos (MailFolderSourceItem* self);
static gboolean mail_account_source_item_real_allow_dnd_sorting (MailSourceListSortable* base);
static GtkMenu* mail_account_source_item_real_get_context_menu (MailSourceListItem* base);
static void __lambda17_ (MailAccountSourceItem* self);
VALA_EXTERN GType mail_alias_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAliasDialog, g_object_unref)
VALA_EXTERN MailAliasDialog* mail_alias_dialog_new (const gchar* account_uid);
VALA_EXTERN MailAliasDialog* mail_alias_dialog_construct (GType object_type,
                                              const gchar* account_uid);
static void ___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void mail_account_source_item_set_account (MailAccountSourceItem* self,
                                           MailBackendAccount* value);
static GObject * mail_account_source_item_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
VALA_EXTERN void mail_source_list_item_set_visible (MailSourceListItem* self,
                                        gboolean value);
VALA_EXTERN MailAccountSavedState* mail_account_saved_state_new (MailBackendAccount* account);
VALA_EXTERN MailAccountSavedState* mail_account_saved_state_construct (GType object_type,
                                                           MailBackendAccount* account);
VALA_EXTERN void mail_source_list_item_set_name (MailSourceListItem* self,
                                     const gchar* value);
static void _mail_account_source_item_folder_created_camel_store_folder_created (CamelStore* _sender,
                                                                          CamelFolderInfo* folder_info,
                                                                          gpointer self);
static void _mail_account_source_item_folder_deleted_camel_store_folder_deleted (CamelStore* _sender,
                                                                          CamelFolderInfo* folder_info,
                                                                          gpointer self);
static void _mail_account_source_item_reload_folders_camel_store_folder_info_stale (CamelStore* _sender,
                                                                             gpointer self);
static void _mail_account_source_item_folder_renamed_camel_store_folder_renamed (CamelStore* _sender,
                                                                          const gchar* old_name,
                                                                          CamelFolderInfo* folder_info,
                                                                          gpointer self);
VALA_EXTERN gint mail_source_list_sortable_compare (MailSourceListSortable* self,
                                        MailSourceListItem* a,
                                        MailSourceListItem* b);
VALA_EXTERN gboolean mail_source_list_sortable_allow_dnd_sorting (MailSourceListSortable* self);
static void mail_account_source_item_finalize (GObject * obj);
static GType mail_account_source_item_get_type_once (void);
static void _vala_mail_account_source_item_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_mail_account_source_item_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
mail_account_source_item_get_instance_private (MailAccountSourceItem* self)
{
	return G_STRUCT_MEMBER_P (self, MailAccountSourceItem_private_offset);
}

MailAccountSourceItem*
mail_account_source_item_construct (GType object_type,
                                    MailBackendAccount* account)
{
	MailAccountSourceItem * self = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	self = (MailAccountSourceItem*) g_object_new (object_type, "account", account, NULL);
	return self;
}

MailAccountSourceItem*
mail_account_source_item_new (MailBackendAccount* account)
{
	return mail_account_source_item_construct (MAIL_TYPE_ACCOUNT_SOURCE_ITEM, account);
}

static void
mail_account_source_item_load_data_free (gpointer _data)
{
	MailAccountSourceItemLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailAccountSourceItemLoadData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_account_source_item_load (MailAccountSourceItem* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	MailAccountSourceItemLoadData* _data_;
	MailAccountSourceItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailAccountSourceItemLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_account_source_item_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_account_source_item_load_co (_data_);
}

void
mail_account_source_item_load_finish (MailAccountSourceItem* self,
                                      GAsyncResult* _res_)
{
	MailAccountSourceItemLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_account_source_item_load_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	MailAccountSourceItemLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_account_source_item_load_co (_data_);
}

static void
_vala_CamelFolderInfo_free (CamelFolderInfo* self)
{
	g_boxed_free (camel_folder_info_get_type (), self);
}

static gboolean
mail_account_source_item_load_co (MailAccountSourceItemLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->offlinestore;
		_data_->_tmp1_ = _data_->self->priv->connect_cancellable;
		_data_->_state_ = 1;
		camel_store_get_folder_info ((CamelStore*) _data_->_tmp0_, NULL, CAMEL_STORE_FOLDER_INFO_RECURSIVE, G_PRIORITY_DEFAULT, _data_->_tmp1_, mail_account_source_item_load_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = camel_store_get_folder_info_finish ((CamelStore*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		_data_->folderinfo = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->folderinfo != NULL) {
			mail_account_source_item_show_info (_data_->self, _data_->folderinfo, (MailSourceListExpandableItem*) _data_->self);
		}
		__vala_CamelFolderInfo_free0 (_data_->folderinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_critical ("AccountSourceItem.vala:64: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_account_source_item_folder_renamed (MailAccountSourceItem* self,
                                         const gchar* old_name,
                                         CamelFolderInfo* folder_info)
{
	MailFolderSourceItem* item = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_name != NULL);
	g_return_if_fail (folder_info != NULL);
	_tmp0_ = self->priv->folder_items;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, old_name, &_tmp1_);
	_g_object_unref0 (item);
	item = (MailFolderSourceItem*) _tmp1_;
	mail_folder_source_item_update_infos (item, folder_info);
	_tmp2_ = self->priv->folder_items;
	_tmp3_ = mail_folder_source_item_get_full_name (item);
	_tmp4_ = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp4_, item);
	_g_object_unref0 (item);
}

static void
mail_account_source_item_folder_deleted (MailAccountSourceItem* self,
                                         CamelFolderInfo* folder_info)
{
	MailFolderSourceItem* item = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	MailFolderSourceItem* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder_info != NULL);
	_tmp0_ = self->priv->folder_items;
	_tmp1_ = folder_info->full_name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	item = (MailFolderSourceItem*) _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		MailFolderSourceItem* _tmp4_;
		MailSourceListExpandableItem* _tmp5_;
		MailSourceListExpandableItem* _tmp6_;
		MailFolderSourceItem* _tmp7_;
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = item;
		_tmp5_ = mail_source_list_item_get_parent ((MailSourceListItem*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = item;
		mail_source_list_expandable_item_remove (_tmp6_, (MailSourceListItem*) _tmp7_);
		_tmp8_ = self->priv->folder_items;
		_tmp9_ = folder_info->full_name;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
	}
	_g_object_unref0 (item);
}

static void
mail_account_source_item_folder_created (MailAccountSourceItem* self,
                                         CamelFolderInfo* folder_info)
{
	CamelFolderInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder_info != NULL);
	_tmp0_ = folder_info->parent;
	if (_tmp0_ == NULL) {
		mail_account_source_item_show_info (self, folder_info, (MailSourceListExpandableItem*) self);
	} else {
		CamelFolderInfo* parent_info = NULL;
		CamelFolderInfo* _tmp1_;
		MailFolderSourceItem* parent_item = NULL;
		GeeHashMap* _tmp2_;
		CamelFolderInfo* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_;
		MailFolderSourceItem* _tmp6_;
		_tmp1_ = folder_info->parent;
		parent_info = (CamelFolderInfo*) _tmp1_;
		_tmp2_ = self->priv->folder_items;
		_tmp3_ = parent_info;
		_tmp4_ = _tmp3_->full_name;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp4_);
		parent_item = (MailFolderSourceItem*) _tmp5_;
		_tmp6_ = parent_item;
		if (_tmp6_ == NULL) {
			CamelFolderInfo* _tmp7_;
			_tmp7_ = parent_info;
			mail_account_source_item_folder_created (self, _tmp7_);
			mail_account_source_item_folder_created (self, folder_info);
		} else {
			MailFolderSourceItem* _tmp8_;
			_tmp8_ = parent_item;
			mail_account_source_item_show_info (self, folder_info, (MailSourceListExpandableItem*) _tmp8_);
		}
		_g_object_unref0 (parent_item);
	}
}

static void
mail_account_source_item_reload_folders_data_free (gpointer _data)
{
	MailAccountSourceItemReloadFoldersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailAccountSourceItemReloadFoldersData, _data_);
}

static void
mail_account_source_item_reload_folders (MailAccountSourceItem* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	MailAccountSourceItemReloadFoldersData* _data_;
	MailAccountSourceItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailAccountSourceItemReloadFoldersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_account_source_item_reload_folders_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_account_source_item_reload_folders_co (_data_);
}

static void
mail_account_source_item_reload_folders_finish (MailAccountSourceItem* self,
                                                GAsyncResult* _res_)
{
	MailAccountSourceItemReloadFoldersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_account_source_item_reload_folders_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	MailAccountSourceItemReloadFoldersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_account_source_item_reload_folders_co (_data_);
}

static gboolean
mail_account_source_item_reload_folders_co (MailAccountSourceItemReloadFoldersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_account;
	_data_->_tmp1_ = mail_backend_account_get_service (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, camel_offline_store_get_type (), CamelOfflineStore));
	_data_->offlinestore = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->folder_items;
		_data_->_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp7_);
		_data_->_folder_item_it = _data_->_tmp9_;
		while (TRUE) {
			_data_->_tmp10_ = _data_->_folder_item_it;
			if (!gee_iterator_next (_data_->_tmp10_)) {
				break;
			}
			_data_->_tmp11_ = _data_->_folder_item_it;
			_data_->_tmp12_ = gee_iterator_get (_data_->_tmp11_);
			_data_->folder_item = (MailFolderSourceItem*) _data_->_tmp12_;
			{
				_data_->_tmp13_ = _data_->offlinestore;
				_data_->_tmp14_ = _data_->folder_item;
				_data_->_tmp15_ = mail_folder_source_item_get_full_name (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->self->priv->connect_cancellable;
				_data_->_state_ = 1;
				camel_store_get_folder_info ((CamelStore*) _data_->_tmp13_, _data_->_tmp16_, 0, G_PRIORITY_DEFAULT, _data_->_tmp17_, mail_account_source_item_reload_folders_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp18_ = camel_store_get_folder_info_finish ((CamelStore*) _data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
				_data_->folder_info = _data_->_tmp18_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp19_ = _data_->folder_item;
				_data_->_tmp20_ = _data_->folder_info;
				mail_folder_source_item_update_infos (_data_->_tmp19_, _data_->_tmp20_);
				__vala_CamelFolderInfo_free0 (_data_->folder_info);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp21_ = _data_->e;
				if (!g_error_matches (_data_->_tmp21_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					_data_->_tmp22_ = _data_->e;
					_data_->_tmp23_ = _data_->_tmp22_->message;
					g_critical ("AccountSourceItem.vala:108: %s", _data_->_tmp23_);
				}
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->folder_item);
				_g_object_unref0 (_data_->_folder_item_it);
				_g_object_unref0 (_data_->offlinestore);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->folder_item);
		}
		_g_object_unref0 (_data_->_folder_item_it);
	}
	_g_object_unref0 (_data_->offlinestore);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static CamelFolderInfo*
_vala_CamelFolderInfo_copy (CamelFolderInfo* self)
{
	return g_boxed_copy (camel_folder_info_get_type (), self);
}

static gpointer
__vala_CamelFolderInfo_copy0 (gpointer self)
{
	return self ? _vala_CamelFolderInfo_copy (self) : NULL;
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		MailAccountSourceItem* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->folder_item);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
___lambda16_ (Block42Data* _data42_)
{
	MailAccountSourceItem* self;
	MailFolderSourceItem* _tmp0_;
	self = _data42_->self;
	_tmp0_ = _data42_->folder_item;
	g_signal_emit (self, mail_account_source_item_signals[MAIL_ACCOUNT_SOURCE_ITEM_START_EDIT_SIGNAL], 0, (MailSourceListItem*) _tmp0_);
}

static void
____lambda16__mail_folder_source_item_start_edit (MailFolderSourceItem* _sender,
                                                  gpointer self)
{
	___lambda16_ (self);
}

static void
mail_account_source_item_show_info (MailAccountSourceItem* self,
                                    CamelFolderInfo* _folderinfo,
                                    MailSourceListExpandableItem* item)
{
	CamelFolderInfo* folderinfo = NULL;
	CamelFolderInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = __vala_CamelFolderInfo_copy0 (_folderinfo);
	folderinfo = _tmp0_;
	while (TRUE) {
		Block42Data* _data42_;
		CamelFolderInfo* _tmp1_;
		MailBackendAccount* _tmp2_;
		CamelFolderInfo* _tmp3_;
		MailFolderSourceItem* _tmp4_;
		MailAccountSavedState* _tmp5_;
		MailFolderSourceItem* _tmp6_;
		GeeHashMap* _tmp7_;
		CamelFolderInfo* _tmp8_;
		const gchar* _tmp9_;
		MailFolderSourceItem* _tmp10_;
		MailFolderSourceItem* _tmp11_;
		CamelFolderInfo* _tmp12_;
		CamelFolderInfo* _tmp13_;
		MailFolderSourceItem* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		CamelFolderInfo* _tmp22_;
		CamelFolderInfo* _tmp23_;
		CamelFolderInfo* _tmp24_;
		_data42_ = g_slice_new0 (Block42Data);
		_data42_->_ref_count_ = 1;
		_data42_->self = g_object_ref (self);
		_tmp1_ = folderinfo;
		if (!(_tmp1_ != NULL)) {
			block42_data_unref (_data42_);
			_data42_ = NULL;
			break;
		}
		_tmp2_ = self->priv->_account;
		_tmp3_ = folderinfo;
		_tmp4_ = mail_folder_source_item_new (_tmp2_, _tmp3_);
		_data42_->folder_item = _tmp4_;
		_tmp5_ = self->priv->saved_state;
		_tmp6_ = _data42_->folder_item;
		mail_account_saved_state_bind_with_expandable_item (_tmp5_, (MailSourceListExpandableItem*) _tmp6_);
		_tmp7_ = self->priv->folder_items;
		_tmp8_ = folderinfo;
		_tmp9_ = _tmp8_->full_name;
		_tmp10_ = _data42_->folder_item;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp9_, _tmp10_);
		_tmp11_ = _data42_->folder_item;
		g_signal_connect_data (_tmp11_, "start-edit", (GCallback) ____lambda16__mail_folder_source_item_start_edit, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
		_tmp12_ = folderinfo;
		_tmp13_ = _tmp12_->child;
		if (_tmp13_ != NULL) {
			CamelFolderInfo* _tmp14_;
			CamelFolderInfo* _tmp15_;
			MailFolderSourceItem* _tmp16_;
			_tmp14_ = folderinfo;
			_tmp15_ = _tmp14_->child;
			_tmp16_ = _data42_->folder_item;
			mail_account_source_item_show_info (self, (CamelFolderInfo*) _tmp15_, (MailSourceListExpandableItem*) _tmp16_);
		}
		_tmp17_ = _data42_->folder_item;
		_tmp18_ = mail_folder_source_item_get_is_special_folder (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			MailFolderSourceItem* _tmp20_;
			_tmp20_ = _data42_->folder_item;
			mail_source_list_expandable_item_add ((MailSourceListExpandableItem*) self, (MailSourceListItem*) _tmp20_);
		} else {
			MailFolderSourceItem* _tmp21_;
			_tmp21_ = _data42_->folder_item;
			mail_source_list_expandable_item_add (item, (MailSourceListItem*) _tmp21_);
		}
		_tmp22_ = folderinfo;
		_tmp23_ = _tmp22_->next;
		_tmp24_ = __vala_CamelFolderInfo_copy0 ((CamelFolderInfo*) _tmp23_);
		__vala_CamelFolderInfo_free0 (folderinfo);
		folderinfo = _tmp24_;
		block42_data_unref (_data42_);
		_data42_ = NULL;
	}
	__vala_CamelFolderInfo_free0 (folderinfo);
}

static gint
mail_account_source_item_real_compare (MailSourceListSortable* base,
                                       MailSourceListItem* a,
                                       MailSourceListItem* b)
{
	MailAccountSourceItem * self;
	gboolean _tmp0_ = FALSE;
	gint result;
	self = (MailAccountSourceItem*) base;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (MAIL_IS_FOLDER_SOURCE_ITEM (a)) {
		_tmp0_ = MAIL_IS_FOLDER_SOURCE_ITEM (b);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MailFolderSourceItem* folder_a = NULL;
		MailFolderSourceItem* _tmp1_;
		MailFolderSourceItem* folder_b = NULL;
		MailFolderSourceItem* _tmp2_;
		MailFolderSourceItem* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		MailFolderSourceItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem));
		folder_a = _tmp1_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem));
		folder_b = _tmp2_;
		_tmp3_ = folder_a;
		_tmp4_ = mail_folder_source_item_get_pos (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = folder_b;
		_tmp7_ = mail_folder_source_item_get_pos (_tmp6_);
		_tmp8_ = _tmp7_;
		result = _tmp5_ - _tmp8_;
		_g_object_unref0 (folder_b);
		_g_object_unref0 (folder_a);
		return result;
	}
	result = 0;
	return result;
}

static gboolean
mail_account_source_item_real_allow_dnd_sorting (MailSourceListSortable* base)
{
	MailAccountSourceItem * self;
	gboolean result;
	self = (MailAccountSourceItem*) base;
	result = FALSE;
	return result;
}

static void
__lambda17_ (MailAccountSourceItem* self)
{
	MailBackendAccount* _tmp0_;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GApplication* _tmp5_;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	MailAliasDialog* _tmp9_ = NULL;
	MailAliasDialog* _tmp10_;
	_tmp0_ = self->priv->_account;
	_tmp1_ = mail_backend_account_get_service (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = camel_service_get_uid (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_application_get_default ();
	_tmp6_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_get_type (), GtkApplication));
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = mail_alias_dialog_new (_tmp4_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_window_present ((GtkWindow*) _tmp10_);
	_g_object_unref0 (_tmp10_);
}

static void
___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda17_ ((MailAccountSourceItem*) self);
}

static GtkMenu*
mail_account_source_item_real_get_context_menu (MailSourceListItem* base)
{
	MailAccountSourceItem * self;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* alias_item = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenu* result;
	self = (MailAccountSourceItem*) base;
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Edit Aliases…"));
	g_object_ref_sink (_tmp1_);
	alias_item = _tmp1_;
	g_signal_connect_object (alias_item, "activate", (GCallback) ___lambda17__gtk_menu_item_activate, self, 0);
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) alias_item);
	gtk_widget_show_all ((GtkWidget*) menu);
	result = menu;
	_g_object_unref0 (alias_item);
	return result;
}

MailBackendAccount*
mail_account_source_item_get_account (MailAccountSourceItem* self)
{
	MailBackendAccount* result;
	MailBackendAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
mail_account_source_item_set_account (MailAccountSourceItem* self,
                                      MailBackendAccount* value)
{
	MailBackendAccount* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_account_source_item_get_account (self);
	if (old_value != value) {
		MailBackendAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_account_source_item_properties[MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY]);
	}
}

static void
_mail_account_source_item_folder_created_camel_store_folder_created (CamelStore* _sender,
                                                                     CamelFolderInfo* folder_info,
                                                                     gpointer self)
{
	mail_account_source_item_folder_created ((MailAccountSourceItem*) self, folder_info);
}

static void
_mail_account_source_item_folder_deleted_camel_store_folder_deleted (CamelStore* _sender,
                                                                     CamelFolderInfo* folder_info,
                                                                     gpointer self)
{
	mail_account_source_item_folder_deleted ((MailAccountSourceItem*) self, folder_info);
}

static void
_mail_account_source_item_reload_folders_camel_store_folder_info_stale (CamelStore* _sender,
                                                                        gpointer self)
{
	mail_account_source_item_reload_folders ((MailAccountSourceItem*) self, NULL, NULL);
}

static void
_mail_account_source_item_folder_renamed_camel_store_folder_renamed (CamelStore* _sender,
                                                                     const gchar* old_name,
                                                                     CamelFolderInfo* folder_info,
                                                                     gpointer self)
{
	mail_account_source_item_folder_renamed ((MailAccountSourceItem*) self, old_name, folder_info);
}

static GObject *
mail_account_source_item_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailAccountSourceItem * self;
	GCancellable* _tmp0_;
	GeeHashMap* _tmp1_;
	MailBackendAccount* _tmp2_;
	MailAccountSavedState* _tmp3_;
	MailAccountSavedState* _tmp4_;
	MailBackendAccount* _tmp5_;
	CamelService* _tmp6_;
	CamelService* _tmp7_;
	CamelOfflineStore* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	CamelOfflineStore* _tmp11_;
	CamelOfflineStore* _tmp12_;
	CamelOfflineStore* _tmp13_;
	CamelOfflineStore* _tmp14_;
	parent_class = G_OBJECT_CLASS (mail_account_source_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem);
	mail_source_list_item_set_visible ((MailSourceListItem*) self, TRUE);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->connect_cancellable);
	self->priv->connect_cancellable = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, MAIL_TYPE_FOLDER_SOURCE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->folder_items);
	self->priv->folder_items = _tmp1_;
	_tmp2_ = self->priv->_account;
	_tmp3_ = mail_account_saved_state_new (_tmp2_);
	_g_object_unref0 (self->priv->saved_state);
	self->priv->saved_state = _tmp3_;
	_tmp4_ = self->priv->saved_state;
	mail_account_saved_state_bind_with_expandable_item (_tmp4_, (MailSourceListExpandableItem*) self);
	_tmp5_ = self->priv->_account;
	_tmp6_ = mail_backend_account_get_service (_tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->offlinestore = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, camel_offline_store_get_type (), CamelOfflineStore);
	_tmp8_ = self->priv->offlinestore;
	_tmp9_ = camel_service_get_display_name ((CamelService*) _tmp8_);
	_tmp10_ = _tmp9_;
	mail_source_list_item_set_name ((MailSourceListItem*) self, _tmp10_);
	_tmp11_ = self->priv->offlinestore;
	g_signal_connect_object ((CamelStore*) _tmp11_, "folder-created", (GCallback) _mail_account_source_item_folder_created_camel_store_folder_created, self, 0);
	_tmp12_ = self->priv->offlinestore;
	g_signal_connect_object ((CamelStore*) _tmp12_, "folder-deleted", (GCallback) _mail_account_source_item_folder_deleted_camel_store_folder_deleted, self, 0);
	_tmp13_ = self->priv->offlinestore;
	g_signal_connect_object ((CamelStore*) _tmp13_, "folder-info-stale", (GCallback) _mail_account_source_item_reload_folders_camel_store_folder_info_stale, self, 0);
	_tmp14_ = self->priv->offlinestore;
	g_signal_connect_object ((CamelStore*) _tmp14_, "folder-renamed", (GCallback) _mail_account_source_item_folder_renamed_camel_store_folder_renamed, self, 0);
	return obj;
}

static void
mail_account_source_item_class_init (MailAccountSourceItemClass * klass,
                                     gpointer klass_data)
{
	mail_account_source_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailAccountSourceItem_private_offset);
	((MailSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (MailSourceListItem*)) mail_account_source_item_real_get_context_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_account_source_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_account_source_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_account_source_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_account_source_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY, mail_account_source_item_properties[MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", MAIL_BACKEND_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	mail_account_source_item_signals[MAIL_ACCOUNT_SOURCE_ITEM_LOADED_SIGNAL] = g_signal_new ("loaded", MAIL_TYPE_ACCOUNT_SOURCE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	mail_account_source_item_signals[MAIL_ACCOUNT_SOURCE_ITEM_START_EDIT_SIGNAL] = g_signal_new ("start-edit", MAIL_TYPE_ACCOUNT_SOURCE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, MAIL_SOURCE_LIST_TYPE_ITEM);
}

static void
mail_account_source_item_mail_source_list_sortable_interface_init (MailSourceListSortableIface * iface,
                                                                   gpointer iface_data)
{
	mail_account_source_item_mail_source_list_sortable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare = (gint (*) (MailSourceListSortable*, MailSourceListItem*, MailSourceListItem*)) mail_account_source_item_real_compare;
	iface->allow_dnd_sorting = (gboolean (*) (MailSourceListSortable*)) mail_account_source_item_real_allow_dnd_sorting;
}

static void
mail_account_source_item_instance_init (MailAccountSourceItem * self,
                                        gpointer klass)
{
	self->priv = mail_account_source_item_get_instance_private (self);
}

static void
mail_account_source_item_finalize (GObject * obj)
{
	MailAccountSourceItem * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem);
	_tmp0_ = self->priv->connect_cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->connect_cancellable);
	_g_object_unref0 (self->priv->folder_items);
	_g_object_unref0 (self->priv->saved_state);
	G_OBJECT_CLASS (mail_account_source_item_parent_class)->finalize (obj);
}

static GType
mail_account_source_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailAccountSourceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_account_source_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailAccountSourceItem), 0, (GInstanceInitFunc) mail_account_source_item_instance_init, NULL };
	static const GInterfaceInfo mail_source_list_sortable_info = { (GInterfaceInitFunc) mail_account_source_item_mail_source_list_sortable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType mail_account_source_item_type_id;
	mail_account_source_item_type_id = g_type_register_static (MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, "MailAccountSourceItem", &g_define_type_info, 0);
	g_type_add_interface_static (mail_account_source_item_type_id, MAIL_TYPE_SOURCE_LIST_SORTABLE, &mail_source_list_sortable_info);
	MailAccountSourceItem_private_offset = g_type_add_instance_private (mail_account_source_item_type_id, sizeof (MailAccountSourceItemPrivate));
	return mail_account_source_item_type_id;
}

GType
mail_account_source_item_get_type (void)
{
	static volatile gsize mail_account_source_item_type_id__once = 0;
	if (g_once_init_enter (&mail_account_source_item_type_id__once)) {
		GType mail_account_source_item_type_id;
		mail_account_source_item_type_id = mail_account_source_item_get_type_once ();
		g_once_init_leave (&mail_account_source_item_type_id__once, mail_account_source_item_type_id);
	}
	return mail_account_source_item_type_id__once;
}

static void
_vala_mail_account_source_item_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	MailAccountSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem);
	switch (property_id) {
		case MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY:
		g_value_set_object (value, mail_account_source_item_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_account_source_item_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	MailAccountSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem);
	switch (property_id) {
		case MAIL_ACCOUNT_SOURCE_ITEM_ACCOUNT_PROPERTY:
		mail_account_source_item_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

