
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpixmapsequenceoverlaypainter_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <kpixmapsequence.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qrect.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPixmapSequenceOverlayPainter_Type = nullptr;
static PyTypeObject *Sbk_KPixmapSequenceOverlayPainter_TypeF(void)
{
    return _Sbk_KPixmapSequenceOverlayPainter_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPixmapSequenceOverlayPainterWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPixmapSequenceOverlayPainterWrapper::KPixmapSequenceOverlayPainterWrapper(::QObject * parent) : KPixmapSequenceOverlayPainter(parent)
{
}

KPixmapSequenceOverlayPainterWrapper::KPixmapSequenceOverlayPainterWrapper(const ::KPixmapSequence & seq, ::QObject * parent) : KPixmapSequenceOverlayPainter(seq, parent)
{
}

void KPixmapSequenceOverlayPainterWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, event);
}

void KPixmapSequenceOverlayPainterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, signal);
}

void KPixmapSequenceOverlayPainterWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, event);
}

void KPixmapSequenceOverlayPainterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, signal);
}

bool KPixmapSequenceOverlayPainterWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, event);
}

bool KPixmapSequenceOverlayPainterWrapper::eventFilter(::QObject * obj, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPixmapSequenceOverlayPainter::eventFilter(obj, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, obj, event);
}

void KPixmapSequenceOverlayPainterWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPixmapSequenceOverlayPainter_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPixmapSequenceOverlayPainter", funcName, gil, pyOverride, event);
}

const QMetaObject *KPixmapSequenceOverlayPainterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPixmapSequenceOverlayPainter::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPixmapSequenceOverlayPainterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPixmapSequenceOverlayPainter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPixmapSequenceOverlayPainterWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPixmapSequenceOverlayPainterWrapper *>(this));
    }
    return KPixmapSequenceOverlayPainter::qt_metacast(_clname);
}

KPixmapSequenceOverlayPainterWrapper::~KPixmapSequenceOverlayPainterWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPixmapSequenceOverlayPainter_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPixmapSequenceOverlayPainter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPixmapSequenceOverlayPainter >()))
        return -1;

    KPixmapSequenceOverlayPainterWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KPixmapSequenceOverlayPainter", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::KPixmapSequenceOverlayPainter(QObject*=)
    // 1: KPixmapSequenceOverlayPainter::KPixmapSequenceOverlayPainter(KPixmapSequence,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KPixmapSequenceOverlayPainter(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KPixmapSequenceOverlayPainter(KPixmapSequence,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KPixmapSequenceOverlayPainter(KPixmapSequence,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPixmapSequenceOverlayPainter(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KPixmapSequenceOverlayPainter(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPixmapSequenceOverlayPainter(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KPixmapSequenceOverlayPainterWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KPixmapSequenceOverlayPainterWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KPixmapSequenceOverlayPainter(const KPixmapSequence &seq, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KPixmapSequence *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPixmapSequenceOverlayPainter(KPixmapSequence,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KPixmapSequenceOverlayPainterWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KPixmapSequenceOverlayPainterWrapper(*cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPixmapSequenceOverlayPainter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // alignment()const
        QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::KPixmapSequenceOverlayPainter *>(cppSelf)->alignment();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KPixmapSequenceOverlayPainter::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_interval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // interval()const
        int cppResult = const_cast<const ::KPixmapSequenceOverlayPainter *>(cppSelf)->interval();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_offset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // offset()const
        QPoint cppResult = const_cast<const ::KPixmapSequenceOverlayPainter *>(cppSelf)->offset();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rect()const
        QRect cppResult = const_cast<const ::KPixmapSequenceOverlayPainter *>(cppSelf)->rect();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_sequence(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sequence()const
        KPixmapSequence* cppResult = new KPixmapSequence(const_cast<const ::KPixmapSequenceOverlayPainter *>(cppSelf)->sequence());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAlignment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInterval", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setInterval(int)
            cppSelf->setInterval(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setOffset(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArg)))) {
        overloadId = 0; // setOffset(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOffset", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setOffset(QPoint)
            cppSelf->setOffset(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setRect(QRect)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArg)))) {
        overloadId = 0; // setRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRect", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setRect(QRect)
            cppSelf->setRect(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setSequence(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setSequence(KPixmapSequence)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), (pyArg)))) {
        overloadId = 0; // setSequence(KPixmapSequence)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSequence", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KPixmapSequence *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSequence(KPixmapSequence)
            cppSelf->setSequence(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_setWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequenceOverlayPainter::setWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWidget(QWidget*)
            cppSelf->setWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPixmapSequenceOverlayPainterFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        cppSelf->stop();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KPixmapSequenceOverlayPainter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPixmapSequenceOverlayPainter_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_alignment), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_eventFilter), METH_VARARGS, nullptr},
    {"interval", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_interval), METH_NOARGS, nullptr},
    {"offset", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_offset), METH_NOARGS, nullptr},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_rect), METH_NOARGS, nullptr},
    {"sequence", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_sequence), METH_NOARGS, nullptr},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setAlignment), METH_O, nullptr},
    {"setInterval", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setInterval), METH_O, nullptr},
    {"setOffset", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setOffset), METH_O, nullptr},
    {"setRect", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setRect), METH_O, nullptr},
    {"setSequence", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setSequence), METH_O, nullptr},
    {"setWidget", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_setWidget), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_start), METH_NOARGS, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceOverlayPainterFunc_stop), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPixmapSequenceOverlayPainter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPixmapSequenceOverlayPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPixmapSequenceOverlayPainterWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPixmapSequenceOverlayPainter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPixmapSequenceOverlayPainter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPixmapSequenceOverlayPainter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPixmapSequenceOverlayPainter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPixmapSequenceOverlayPainter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPixmapSequenceOverlayPainter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPixmapSequenceOverlayPainter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPixmapSequenceOverlayPainter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPixmapSequenceOverlayPainter_spec = {
    "1:KWidgetsAddons.KPixmapSequenceOverlayPainter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPixmapSequenceOverlayPainter_slots
};

} //extern "C"

static void *Sbk_KPixmapSequenceOverlayPainter_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPixmapSequenceOverlayPainter *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPixmapSequenceOverlayPainter_PythonToCpp_KPixmapSequenceOverlayPainter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPixmapSequenceOverlayPainter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPixmapSequenceOverlayPainter_PythonToCpp_KPixmapSequenceOverlayPainter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPixmapSequenceOverlayPainter_TypeF()))
        return KPixmapSequenceOverlayPainter_PythonToCpp_KPixmapSequenceOverlayPainter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPixmapSequenceOverlayPainter_PTR_CppToPython_KPixmapSequenceOverlayPainter(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPixmapSequenceOverlayPainter *>(const_cast<void *>(cppIn)), Sbk_KPixmapSequenceOverlayPainter_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPixmapSequenceOverlayPainter_SignatureStrings[] = {
    "1:KWidgetsAddons.KPixmapSequenceOverlayPainter(self,parent:PySide6.QtCore.QObject=nullptr)",
    "0:KWidgetsAddons.KPixmapSequenceOverlayPainter(self,seq:KWidgetsAddons.KPixmapSequence,parent:PySide6.QtCore.QObject=nullptr)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.alignment(self)->PySide6.QtCore.Qt.AlignmentFlag",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.eventFilter(self,obj:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.interval(self)->int",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.offset(self)->PySide6.QtCore.QPoint",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.rect(self)->PySide6.QtCore.QRect",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.sequence(self)->KWidgetsAddons.KPixmapSequence",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setAlignment(self,align:PySide6.QtCore.Qt.AlignmentFlag)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setInterval(self,msecs:int)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setOffset(self,offset:PySide6.QtCore.QPoint)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setRect(self,rect:PySide6.QtCore.QRect)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setSequence(self,seq:KWidgetsAddons.KPixmapSequence)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.setWidget(self,w:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.start(self)",
    "KWidgetsAddons.KPixmapSequenceOverlayPainter.stop(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KPixmapSequenceOverlayPainter_SignatureByteSize = 288;
static constexpr uint8_t KPixmapSequenceOverlayPainter_SignatureBytes[288] = {
    0x78, 0xda, 0x9d, 0x93, 0x4d, 0x6f, 0x83, 0x30, 0x0c, 0x86, 0xef, 0xfb, 0x25, 0x43, 0xca, 0xa2,
    0xed, 0xb2, 0x43, 0xa4, 0x4d, 0x42, 0xd3, 0x26, 0x4d, 0x3d, 0x00, 0xe5, 0xb0, 0x73, 0x00, 0x83,
    0x52, 0x85, 0x84, 0x26, 0x29, 0x6d, 0xff, 0xfd, 0xc2, 0xd7, 0xc6, 0xb6, 0xb2, 0xd6, 0xbd, 0xa0,
    0x10, 0xdb, 0xcf, 0x6b, 0xf3, 0x9a, 0x07, 0xb6, 0xfa, 0x10, 0x45, 0x05, 0xce, 0x86, 0x45, 0xa1,
    0x95, 0xa5, 0xab, 0x58, 0x1c, 0x6a, 0xde, 0xa4, 0xb0, 0xdd, 0x81, 0xca, 0x21, 0x6a, 0xc1, 0x48,
    0x7e, 0x8c, 0xb9, 0x50, 0x0e, 0xcc, 0xad, 0x05, 0x59, 0x92, 0x86, 0x1b, 0x50, 0x8e, 0xc5, 0xc7,
    0x54, 0x14, 0xf0, 0x48, 0x13, 0xf7, 0xa2, 0x0d, 0xd0, 0x24, 0xca, 0x36, 0x90, 0xbb, 0x27, 0xb5,
    0x93, 0xb2, 0x71, 0x26, 0xb8, 0xb9, 0xbf, 0x02, 0x6d, 0x61, 0x7b, 0xa6, 0xea, 0x52, 0x75, 0x8c,
    0x36, 0xe5, 0x52, 0x54, 0xaa, 0xf6, 0xd8, 0xbe, 0x8b, 0xe0, 0xee, 0xf9, 0x37, 0xdd, 0xd1, 0x70,
    0x4a, 0x79, 0x93, 0xbc, 0xc2, 0xd1, 0xa1, 0xed, 0xca, 0x84, 0xfc, 0x9a, 0x52, 0x67, 0x9b, 0x85,
    0xfe, 0x49, 0x9f, 0xfb, 0x27, 0xf8, 0xda, 0xdd, 0xfa, 0xb6, 0x32, 0xad, 0x25, 0x4e, 0xbb, 0x7f,
    0xb6, 0x5c, 0x4e, 0x83, 0xf9, 0x77, 0x1c, 0x40, 0x97, 0xa5, 0x85, 0xc5, 0xef, 0x12, 0x6b, 0x34,
    0xd0, 0xf8, 0x31, 0x97, 0x70, 0x6b, 0x1f, 0xc3, 0xd1, 0xec, 0x78, 0x3d, 0x11, 0xff, 0x2f, 0xc6,
    0xb2, 0x5d, 0xf8, 0x63, 0x31, 0x48, 0xbf, 0x27, 0xec, 0xcc, 0x72, 0x04, 0x68, 0x95, 0xf7, 0xb9,
    0x49, 0xa4, 0xb6, 0x90, 0x5b, 0xe6, 0x83, 0x78, 0x50, 0xf4, 0x6d, 0x16, 0x19, 0x8c, 0x63, 0x27,
    0x1d, 0xc3, 0x93, 0xd7, 0x93, 0x6b, 0xa4, 0xf3, 0x8f, 0x9d, 0x32, 0x0e, 0x0f, 0x4d, 0xe7, 0xe6,
    0x5d, 0xf0, 0xef, 0xe3, 0x15, 0x86, 0xf4, 0x81, 0xbf, 0x9f, 0x75, 0x3d, 0x62, 0x68, 0x32, 0x1c,
    0xb0, 0x60, 0xc7, 0xcd, 0xb8, 0xc3, 0xd8, 0x42, 0xdd, 0x8c, 0x75, 0x9f, 0x6f, 0x1a, 0x0c, 0x83
};
#endif

PyTypeObject *init_KPixmapSequenceOverlayPainter(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX].type;

    Shiboken::AutoDecRef Sbk_KPixmapSequenceOverlayPainter_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KPixmapSequenceOverlayPainter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPixmapSequenceOverlayPainter",
        "KPixmapSequenceOverlayPainter*",
        &Sbk_KPixmapSequenceOverlayPainter_spec,
        &Shiboken::callCppDestructor< KPixmapSequenceOverlayPainter >,
        Sbk_KPixmapSequenceOverlayPainter_Type_bases.object(),
        0);
    auto *pyType = Sbk_KPixmapSequenceOverlayPainter_TypeF(); // references _Sbk_KPixmapSequenceOverlayPainter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPixmapSequenceOverlayPainter_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPixmapSequenceOverlayPainter_SignatureBytes, KPixmapSequenceOverlayPainter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPixmapSequenceOverlayPainter_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPixmapSequenceOverlayPainter_PythonToCpp_KPixmapSequenceOverlayPainter_PTR,
        is_KPixmapSequenceOverlayPainter_PythonToCpp_KPixmapSequenceOverlayPainter_PTR_Convertible,
        KPixmapSequenceOverlayPainter_PTR_CppToPython_KPixmapSequenceOverlayPainter);

    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequenceOverlayPainter");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequenceOverlayPainter*");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequenceOverlayPainter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPixmapSequenceOverlayPainter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPixmapSequenceOverlayPainterWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPixmapSequenceOverlayPainter_TypeF(), &Sbk_KPixmapSequenceOverlayPainter_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPixmapSequenceOverlayPainter::staticMetaObject, sizeof(KPixmapSequenceOverlayPainterWrapper));

    return pyType;
}
