
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "knotifications_python.h"

// main header
#include "knotification_wrapper.h"

// Wrappers providing overrides
#include "knotificationreplyaction_wrapper.h"

// Argument includes
#include <QList>
#include <QMap>
#include <QString>
#include <knotification.h>
#include <knotificationreplyaction.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpixmap.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwindow.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNotification_Type = nullptr;
static PyTypeObject *Sbk_KNotification_TypeF(void)
{
    return _Sbk_KNotification_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNotificationWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNotificationWrapper::KNotificationWrapper(const ::QString & eventId, ::QFlags<KNotification::NotificationFlag> flags, ::QObject * parent) : KNotification(eventId, flags, parent)
{
}

void KNotificationWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_childEvent("KNotification", funcName, gil, pyOverride, event);
}

void KNotificationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationReplyActionWrapper::sbk_o_connectNotify("KNotification", funcName, gil, pyOverride, signal);
}

void KNotificationWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_customEvent("KNotification", funcName, gil, pyOverride, event);
}

void KNotificationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationReplyActionWrapper::sbk_o_connectNotify("KNotification", funcName, gil, pyOverride, signal);
}

bool KNotificationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationReplyActionWrapper::sbk_o_eventFilter("KNotification", funcName, gil, pyOverride, watched, event);
}

void KNotificationWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotification_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationReplyActionWrapper::sbk_o_timerEvent("KNotification", funcName, gil, pyOverride, event);
}

const QMetaObject *KNotificationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNotification::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNotificationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNotification::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNotificationWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNotificationWrapper *>(this));
    }
    return KNotification::qt_metacast(_clname);
}

KNotificationWrapper::~KNotificationWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNotification_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNotification_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNotification >()))
        return -1;

    KNotificationWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KNotification", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNotification::KNotification(QString,QFlags<KNotification::NotificationFlag>=,QObject*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KNotification(QString,QFlags<KNotification::NotificationFlag>,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KNotification(QString,QFlags<KNotification::NotificationFlag>,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
                overloadId = 0; // KNotification(QString,QFlags<KNotification::NotificationFlag>,QObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"flags", 1}, {"parent", 2}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KNotification::NotificationFlag> cppArg1(KNotification::NotificationFlag::CloseOnTimeout);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KNotification(QString,QFlags<KNotification::NotificationFlag>,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KNotificationWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KNotificationWrapper(cppArg0, cppArg1, cppArg2);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNotification >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNotificationFunc_addAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::addAction(QString)->KNotificationAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addAction", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addAction(QString)
            KNotificationAction * cppResult = cppSelf->addAction(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_addDefaultAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::addDefaultAction(QString)->KNotificationAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addDefaultAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addDefaultAction", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addDefaultAction(QString)
            KNotificationAction * cppResult = cppSelf->addDefaultAction(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_appName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // appName()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->appName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_beep(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    if (PyArg_ParseTuple(args, "|O:beep", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KNotification::beep(const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // beep(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // beep(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"reason", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // beep(QString)
            ::KNotification::beep(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_clearActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearActions()
        cppSelf->clearActions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // close()
        cppSelf->close();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_componentName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // componentName()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->componentName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_defaultAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // defaultAction()const
        KNotificationAction * cppResult = const_cast<const ::KNotification *>(cppSelf)->defaultAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_event(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    ::KNotification *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:event", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KNotification::event(KNotification::StandardEvent,const QString&=,const QPixmap&=,const QFlags<KNotification::NotificationFlag>&=)->KNotification*
    // 1: QObject::event(QEvent*)->bool
    // 2: static KNotification::event(KNotification::StandardEvent,QString,QString,const QFlags<KNotification::NotificationFlag>&=)->KNotification*
    // 3: static KNotification::event(KNotification::StandardEvent,QString,QString,QPixmap,const QFlags<KNotification::NotificationFlag>&=)->KNotification*
    // 4: static KNotification::event(KNotification::StandardEvent,QString,QString,QString,const QFlags<KNotification::NotificationFlag>&=)->KNotification*
    // 5: static KNotification::event(QString,const QString&=,const QPixmap&=,const QFlags<KNotification::NotificationFlag>&=,const QString&=)->KNotification*
    // 6: static KNotification::event(QString,QString,QString,const QPixmap&=,const QFlags<KNotification::NotificationFlag>&=,const QString&=)->KNotification*
    // 7: static KNotification::event(QString,QString,QString,QString,const QFlags<KNotification::NotificationFlag>&=,const QString&=)->KNotification*
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[0])))) {
        overloadId = 1; // event(QEvent*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 6; // event(QString,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 7; // event(QString,QString,QString,QString,QFlags<KNotification::NotificationFlag>,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 7; // event(QString,QString,QString,QString,QFlags<KNotification::NotificationFlag>,QString)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                            overloadId = 7; // event(QString,QString,QString,QString,QFlags<KNotification::NotificationFlag>,QString)
                        }
                    }
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 6; // event(QString,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 6; // event(QString,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                            overloadId = 6; // event(QString,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                        }
                    }
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 5; // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 5; // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        overloadId = 5; // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                    }
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_StandardEvent_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // event(KNotification::StandardEvent,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // event(KNotification::StandardEvent,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // event(KNotification::StandardEvent,QString,QString,QFlags<KNotification::NotificationFlag>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 4; // event(KNotification::StandardEvent,QString,QString,QString,QFlags<KNotification::NotificationFlag>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4])))) {
                        overloadId = 4; // event(KNotification::StandardEvent,QString,QString,QString,QFlags<KNotification::NotificationFlag>)
                    }
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 3; // event(KNotification::StandardEvent,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4])))) {
                        overloadId = 3; // event(KNotification::StandardEvent,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                    }
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3])))) {
                    overloadId = 2; // event(KNotification::StandardEvent,QString,QString,QFlags<KNotification::NotificationFlag>)
                }
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // event(KNotification::StandardEvent,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3])))) {
                    overloadId = 0; // event(KNotification::StandardEvent,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // event(KNotification::StandardEvent eventId, const QString &text, const QPixmap &pixmap, const QFlags<KNotification::NotificationFlag> &flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"text", 1}, {"pixmap", 2}, {"flags", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::KNotification::StandardEvent cppArg0{KNotification::Notification};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPixmap cppArg2_local = QPixmap();
            ::QPixmap *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
                if (pythonToCpp[2].isValue())
                    pythonToCpp[2](pyArgs[2], &cppArg2_local);
                else
                    pythonToCpp[2](pyArgs[2], &cppArg2);
                }
            ::QFlags<KNotification::NotificationFlag> cppArg3(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(KNotification::StandardEvent,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, *cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 1: // event(QEvent *event)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QEvent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(QEvent*)
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? reinterpret_cast<QObject *>(cppSelf)->::QObject::event(cppArg0)
                    : reinterpret_cast<QObject *>(cppSelf)->event(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // event(KNotification::StandardEvent eventId, const QString &title, const QString &text, const QFlags<KNotification::NotificationFlag> &flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::KNotification::StandardEvent cppArg0{KNotification::Notification};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<KNotification::NotificationFlag> cppArg3(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(KNotification::StandardEvent,QString,QString,QFlags<KNotification::NotificationFlag>)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 3: // event(KNotification::StandardEvent eventId, const QString &title, const QString &text, const QPixmap &pixmap, const QFlags<KNotification::NotificationFlag> &flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::KNotification::StandardEvent cppArg0{KNotification::Notification};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPixmap cppArg3_local;
            ::QPixmap *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3].isValue())
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            ::QFlags<KNotification::NotificationFlag> cppArg4(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(KNotification::StandardEvent,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, cppArg2, *cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 4: // event(KNotification::StandardEvent eventId, const QString &title, const QString &text, const QString &iconName, const QFlags<KNotification::NotificationFlag> &flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::KNotification::StandardEvent cppArg0{KNotification::Notification};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<KNotification::NotificationFlag> cppArg4(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(KNotification::StandardEvent,QString,QString,QString,QFlags<KNotification::NotificationFlag>)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 5: // event(const QString &eventId, const QString &text, const QPixmap &pixmap, const QFlags<KNotification::NotificationFlag> &flags, const QString &componentName)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"text", 1}, {"pixmap", 2}, {"flags", 3}, {"componentName", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QPixmap cppArg2_local = QPixmap();
            ::QPixmap *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
                if (pythonToCpp[2].isValue())
                    pythonToCpp[2](pyArgs[2], &cppArg2_local);
                else
                    pythonToCpp[2](pyArgs[2], &cppArg2);
                }
            ::QFlags<KNotification::NotificationFlag> cppArg3(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4 = QString();
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 6: // event(const QString &eventId, const QString &title, const QString &text, const QPixmap &pixmap, const QFlags<KNotification::NotificationFlag> &flags, const QString &componentName)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"pixmap", 3}, {"flags", 4}, {"componentName", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPixmap cppArg3_local = QPixmap();
            ::QPixmap *cppArg3 = &cppArg3_local;
            if (pythonToCpp[3]) {
                if (pythonToCpp[3].isValue())
                    pythonToCpp[3](pyArgs[3], &cppArg3_local);
                else
                    pythonToCpp[3](pyArgs[3], &cppArg3);
                }
            ::QFlags<KNotification::NotificationFlag> cppArg4(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5 = QString();
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(QString,QString,QString,QPixmap,QFlags<KNotification::NotificationFlag>,QString)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
        case 7: // event(const QString &eventId, const QString &title, const QString &text, const QString &iconName, const QFlags<KNotification::NotificationFlag> &flags, const QString &componentName)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"flags", 4}, {"componentName", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "event", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<KNotification::NotificationFlag> cppArg4(KNotification::NotificationFlag::CloseOnTimeout);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5 = QString();
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // event(QString,QString,QString,QString,QFlags<KNotification::NotificationFlag>,QString)
                KNotification * cppResult = ::KNotification::event(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_eventId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // eventId()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->eventId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // flags()const
        QFlags<KNotification::NotificationFlag> cppResult = const_cast<const ::KNotification *>(cppSelf)->flags();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_hints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hints()const
        QMap<QString,QVariant> cppResult = const_cast<const ::KNotification *>(cppSelf)->hints();
        pyResult = Shiboken::Conversions::copyToPython(SbkKNotificationsTypeConverters[SBK_KNotifications_QMap_QString_QVariant_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_iconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconName()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->iconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_isAutoDelete(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isAutoDelete()const
        bool cppResult = const_cast<const ::KNotification *>(cppSelf)->isAutoDelete();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_pixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pixmap()const
        QPixmap cppResult = const_cast<const ::KNotification *>(cppSelf)->pixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_replyAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // replyAction()const
        KNotificationReplyAction * cppResult = const_cast<const ::KNotification *>(cppSelf)->replyAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotificationReplyAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_sendEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sendEvent()
        cppSelf->sendEvent();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setAutoDelete(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setAutoDelete(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoDelete(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoDelete", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoDelete(bool)
            cppSelf->setAutoDelete(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setComponentName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setComponentName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setComponentName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComponentName", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentName(QString)
            cppSelf->setComponentName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setEventId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setEventId(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setEventId(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEventId", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEventId(QString)
            cppSelf->setEventId(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setFlags(QFlags<KNotification::NotificationFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<KNotification::NotificationFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFlags", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QFlags<KNotification::NotificationFlag> cppArg0 = QFlags<KNotification::NotificationFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFlags(QFlags<KNotification::NotificationFlag>)
            cppSelf->setFlags(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setHint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setHint", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KNotification::setHint(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
        overloadId = 0; // setHint(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setHint", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHint(QString,QVariant)
            cppSelf->setHint(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setHints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setHints(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKNotificationsTypeConverters[SBK_KNotifications_QMap_QString_QVariant_IDX], (pyArg)))) {
        overloadId = 0; // setHints(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHints", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QMap<QString,QVariant> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHints(QMap<QString,QVariant>)
            cppSelf->setHints(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setIconName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setIconName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setIconName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconName", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconName(QString)
            cppSelf->setIconName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setPixmap(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // setPixmap(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPixmap", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setPixmap(QPixmap)
            cppSelf->setPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTitle", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setUrgency(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setUrgency(KNotification::Urgency)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_Urgency_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setUrgency(KNotification::Urgency)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUrgency", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::KNotification::Urgency cppArg0 = static_cast< ::KNotification::Urgency>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrgency(KNotification::Urgency)
            cppSelf->setUrgency(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setUrls(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setUrls(QList<QUrl>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKNotificationsTypeConverters[SBK_KNotifications_QList_QUrl_IDX], (pyArg)))) {
        overloadId = 0; // setUrls(QList<QUrl>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUrls", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        ::QList<QUrl> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrls(QList<QUrl>)
            cppSelf->setUrls(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_setWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNotification::setWindow(QWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setWindow(QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWindow", errInfo, SbkKNotificationsTypeStructs[SBK_KNotification_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QWindow*)
            cppSelf->setWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_urgency(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // urgency()const
        KNotification::Urgency cppResult = const_cast<const ::KNotification *>(cppSelf)->urgency();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_Urgency_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_urls(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // urls()const
        QList<QUrl> cppResult = const_cast<const ::KNotification *>(cppSelf)->urls();
        pyResult = Shiboken::Conversions::copyToPython(SbkKNotificationsTypeConverters[SBK_KNotifications_QList_QUrl_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // window()const
        QWindow * cppResult = const_cast<const ::KNotification *>(cppSelf)->window();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWindow_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationFunc_xdgActivationToken(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // xdgActivationToken()const
        QString cppResult = const_cast<const ::KNotification *>(cppSelf)->xdgActivationToken();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyMethodDef Sbk_KNotificationMethod_event = {"event", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_event), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr};


static const char *Sbk_KNotification_PropertyStrings[] = {
    "autoDelete:isAutoDelete:",
    "componentName::",
    "eventId::",
    "flags::",
    "hints::",
    "iconName::",
    "text::",
    "title::",
    "urgency::",
    "urls::",
    "xdgActivationToken:",
    nullptr // Sentinel
};

static const char *Sbk_KNotification_EnumFlagInfo[] = {
    "NotificationFlag:IntFlag:NotificationFlags",
    "StandardEvent:IntEnum",
    "Urgency:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNotification_methods[] = {
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_addAction), METH_O, nullptr},
    {"addDefaultAction", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_addDefaultAction), METH_O, nullptr},
    {"appName", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_appName), METH_NOARGS, nullptr},
    {"beep", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_beep), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"clearActions", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_clearActions), METH_NOARGS, nullptr},
    {"close", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_close), METH_NOARGS, nullptr},
    {"componentName", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_componentName), METH_NOARGS, nullptr},
    {"defaultAction", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_defaultAction), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_event), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"eventId", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_eventId), METH_NOARGS, nullptr},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_flags), METH_NOARGS, nullptr},
    {"hints", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_hints), METH_NOARGS, nullptr},
    {"iconName", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_iconName), METH_NOARGS, nullptr},
    {"isAutoDelete", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_isAutoDelete), METH_NOARGS, nullptr},
    {"pixmap", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_pixmap), METH_NOARGS, nullptr},
    {"replyAction", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_replyAction), METH_NOARGS, nullptr},
    {"sendEvent", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_sendEvent), METH_NOARGS, nullptr},
    {"setAutoDelete", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setAutoDelete), METH_O, nullptr},
    {"setComponentName", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setComponentName), METH_O, nullptr},
    {"setEventId", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setEventId), METH_O, nullptr},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setFlags), METH_O, nullptr},
    {"setHint", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setHint), METH_VARARGS, nullptr},
    {"setHints", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setHints), METH_O, nullptr},
    {"setIconName", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setIconName), METH_O, nullptr},
    {"setPixmap", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setPixmap), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setText), METH_O, nullptr},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setTitle), METH_O, nullptr},
    {"setUrgency", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setUrgency), METH_O, nullptr},
    {"setUrls", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setUrls), METH_O, nullptr},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_setWindow), METH_O, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_text), METH_NOARGS, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_title), METH_NOARGS, nullptr},
    {"urgency", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_urgency), METH_NOARGS, nullptr},
    {"urls", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_urls), METH_NOARGS, nullptr},
    {"window", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_window), METH_NOARGS, nullptr},
    {"xdgActivationToken", reinterpret_cast<PyCFunction>(Sbk_KNotificationFunc_xdgActivationToken), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNotification_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNotification *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNotificationWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNotification_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNotification_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNotification_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNotification_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNotification_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNotification_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNotification_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNotification_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNotification_spec = {
    "1:KNotifications.KNotification",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNotification_slots
};

} //extern "C"

static void *Sbk_KNotification_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNotification *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KNotification_NotificationFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNotification::NotificationFlag>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNotification::NotificationFlag *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNotification_NotificationFlag_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_NotificationFlag_IDX])))
        return Enum_PythonToCpp_KNotification_NotificationFlag;
    return {};
}

static PyObject *KNotification_NotificationFlag_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNotification::NotificationFlag>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNotification::NotificationFlag *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KNotification_NotificationFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KNotification::NotificationFlag>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KNotification::NotificationFlag> *>(cppOut) = value;

}

static PyObject *KNotification_NotificationFlag_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KNotification::NotificationFlag> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_NotificationFlag_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KNotification_StandardEvent(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNotification::StandardEvent>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNotification::StandardEvent *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNotification_StandardEvent_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_StandardEvent_IDX])))
        return Enum_PythonToCpp_KNotification_StandardEvent;
    return {};
}

static PyObject *KNotification_StandardEvent_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNotification::StandardEvent>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNotification::StandardEvent *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KNotification_Urgency(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNotification::Urgency>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNotification::Urgency *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNotification_Urgency_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKNotificationsTypeStructs[SBK_KNotification_Urgency_IDX])))
        return Enum_PythonToCpp_KNotification_Urgency;
    return {};
}

static PyObject *KNotification_Urgency_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNotification::Urgency>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNotification::Urgency *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNotification_PythonToCpp_KNotification_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNotification_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNotification_PythonToCpp_KNotification_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNotification_TypeF()))
        return KNotification_PythonToCpp_KNotification_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNotification_PTR_CppToPython_KNotification(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNotification *>(const_cast<void *>(cppIn)), Sbk_KNotification_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNotification_SignatureStrings[] = {
    "KNotifications.KNotification(self,eventId:QString,flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,eventId:QString=None,title:QString=None,text:QString=None,iconName:QString=None,flags:KNotifications.KNotification.NotificationFlag=None,componentName:QString=None,urls:QList[PySide6.QtCore.QUrl]=None,urgency:KNotifications.KNotification.Urgency=None,autoDelete:bool=None,xdgActivationToken:QString=None,hints:QMap[QString, QVariant]=None)",
    "KNotifications.KNotification.addAction(self,label:QString)->KNotifications.KNotificationAction",
    "KNotifications.KNotification.addDefaultAction(self,label:QString)->KNotifications.KNotificationAction",
    "KNotifications.KNotification.appName(self)->QString",
    "KNotifications.KNotification.beep(reason:QString=QString())",
    "KNotifications.KNotification.clearActions(self)",
    "KNotifications.KNotification.close(self)",
    "KNotifications.KNotification.componentName(self)->QString",
    "KNotifications.KNotification.defaultAction(self)->KNotifications.KNotificationAction",
    "7:KNotifications.KNotification.event(eventId:KNotifications.KNotification.StandardEvent,text:QString=QString(),pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage]=QPixmap(),flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout)->KNotifications.KNotification",
    "6:KNotifications.KNotification.event(self,event:PySide6.QtCore.QEvent)->bool",
    "5:KNotifications.KNotification.event(eventId:KNotifications.KNotification.StandardEvent,title:QString,text:QString,flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout)->KNotifications.KNotification",
    "4:KNotifications.KNotification.event(eventId:KNotifications.KNotification.StandardEvent,title:QString,text:QString,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout)->KNotifications.KNotification",
    "3:KNotifications.KNotification.event(eventId:KNotifications.KNotification.StandardEvent,title:QString,text:QString,iconName:QString,flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout)->KNotifications.KNotification",
    "2:KNotifications.KNotification.event(eventId:QString,text:QString=QString(),pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage]=QPixmap(),flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout,componentName:QString=QString())->KNotifications.KNotification",
    "1:KNotifications.KNotification.event(eventId:QString,title:QString,text:QString,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage]=QPixmap(),flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout,componentName:QString=QString())->KNotifications.KNotification",
    "0:KNotifications.KNotification.event(eventId:QString,title:QString,text:QString,iconName:QString,flags:KNotifications.KNotification.NotificationFlag=KNotification.NotificationFlag.CloseOnTimeout,componentName:QString=QString())->KNotifications.KNotification",
    "KNotifications.KNotification.eventId(self)->QString",
    "KNotifications.KNotification.flags(self)->KNotifications.KNotification.NotificationFlag",
    "KNotifications.KNotification.hints(self)->QMap[QString, QVariant]",
    "KNotifications.KNotification.iconName(self)->QString",
    "KNotifications.KNotification.isAutoDelete(self)->bool",
    "KNotifications.KNotification.pixmap(self)->PySide6.QtGui.QPixmap",
    "KNotifications.KNotification.replyAction(self)->KNotifications.KNotificationReplyAction",
    "KNotifications.KNotification.sendEvent(self)",
    "KNotifications.KNotification.setAutoDelete(self,autoDelete:bool)",
    "KNotifications.KNotification.setComponentName(self,componentName:QString)",
    "KNotifications.KNotification.setEventId(self,eventId:QString)",
    "KNotifications.KNotification.setFlags(self,flags:KNotifications.KNotification.NotificationFlag)",
    "KNotifications.KNotification.setHint(self,hint:QString,value:QVariant)",
    "KNotifications.KNotification.setHints(self,hints:QMap[QString, QVariant])",
    "KNotifications.KNotification.setIconName(self,icon:QString)",
    "KNotifications.KNotification.setPixmap(self,pix:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])",
    "KNotifications.KNotification.setText(self,text:QString)",
    "KNotifications.KNotification.setTitle(self,title:QString)",
    "KNotifications.KNotification.setUrgency(self,urgency:KNotifications.KNotification.Urgency)",
    "KNotifications.KNotification.setUrls(self,urls:QList[PySide6.QtCore.QUrl])",
    "KNotifications.KNotification.setWindow(self,window:PySide6.QtGui.QWindow)",
    "KNotifications.KNotification.text(self)->QString",
    "KNotifications.KNotification.title(self)->QString",
    "KNotifications.KNotification.urgency(self)->KNotifications.KNotification.Urgency",
    "KNotifications.KNotification.urls(self)->QList[PySide6.QtCore.QUrl]",
    "KNotifications.KNotification.window(self)->PySide6.QtGui.QWindow",
    "KNotifications.KNotification.xdgActivationToken(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KNotification_SignatureByteSize = 727;
static constexpr uint8_t KNotification_SignatureBytes[727] = {
    0x78, 0xda, 0xd5, 0x58, 0x4b, 0x8f, 0xda, 0x30, 0x10, 0xbe, 0xf3, 0x2b, 0xf6, 0x08, 0x55, 0x1a,
    0xf5, 0xb9, 0x95, 0x22, 0x51, 0x69, 0xc5, 0xee, 0xb6, 0x88, 0x16, 0x48, 0x81, 0xf6, 0xb0, 0xda,
    0x83, 0x49, 0x06, 0xea, 0xd6, 0xd8, 0x51, 0xec, 0x00, 0xf9, 0xf7, 0x4d, 0xe2, 0xbc, 0x48, 0x58,
    0x3b, 0xb0, 0x05, 0xb4, 0x27, 0x88, 0x33, 0xf3, 0xcd, 0xcc, 0xe7, 0x99, 0xf1, 0x38, 0x83, 0x21,
    0x13, 0x78, 0x81, 0x1d, 0x24, 0x30, 0xa3, 0xdc, 0x1c, 0x94, 0x1f, 0xdb, 0x1c, 0xc8, 0xc2, 0x80,
    0x35, 0x50, 0xd1, 0x77, 0x2d, 0x7b, 0x22, 0x7c, 0x4c, 0x97, 0xc6, 0x82, 0xa0, 0x25, 0xb7, 0x06,
    0x0a, 0x3d, 0xb3, 0xfc, 0x70, 0x1f, 0x89, 0x77, 0xd5, 0xaf, 0xcd, 0x1e, 0x61, 0x1c, 0x46, 0x74,
    0x8a, 0x57, 0xc0, 0x02, 0x61, 0x78, 0xc8, 0x8f, 0x4c, 0x5a, 0xe3, 0x70, 0x82, 0x5d, 0xb8, 0x36,
    0x6d, 0xd1, 0x63, 0x3e, 0x98, 0xf6, 0x68, 0xfe, 0x07, 0x1c, 0xd1, 0xa5, 0x01, 0x21, 0x9e, 0xf0,
    0x8d, 0x57, 0xd6, 0x00, 0xc2, 0x0d, 0xf3, 0xdd, 0x11, 0x25, 0x61, 0x77, 0xc8, 0x28, 0x54, 0x5d,
    0x95, 0x8b, 0x02, 0x0b, 0x02, 0x95, 0x25, 0xd8, 0x8a, 0xdd, 0x15, 0xec, 0x30, 0x3a, 0x44, 0xab,
    0x8a, 0xdc, 0x31, 0xa1, 0x26, 0x8a, 0x0e, 0x5b, 0x79, 0xd1, 0x2f, 0x15, 0x75, 0xcc, 0xc0, 0x27,
    0xdc, 0xb2, 0xbf, 0x61, 0x2e, 0x1e, 0xaa, 0x01, 0xce, 0x7c, 0xf2, 0x98, 0x09, 0x2d, 0x81, 0x3a,
    0xa1, 0xda, 0xf4, 0x4c, 0x0a, 0x49, 0x0d, 0x14, 0x08, 0x76, 0x0b, 0x04, 0x04, 0x58, 0x73, 0xc6,
    0x88, 0x5c, 0xdc, 0xba, 0xcb, 0x1b, 0x47, 0xe0, 0x75, 0x22, 0x3f, 0x65, 0x7f, 0x81, 0xee, 0xfa,
    0xf2, 0x1b, 0x53, 0x11, 0x39, 0xf3, 0x1d, 0x79, 0x0f, 0xd9, 0xee, 0x5e, 0xd9, 0x3f, 0x91, 0x8f,
    0x11, 0x15, 0xd2, 0x93, 0x4e, 0x4b, 0xe9, 0x02, 0x72, 0xdd, 0xd8, 0x40, 0x96, 0x2a, 0x04, 0xcd,
    0x81, 0x64, 0x26, 0x3a, 0xaf, 0x3f, 0xab, 0x74, 0xa5, 0x9e, 0x16, 0xfe, 0x16, 0x16, 0x28, 0x20,
    0xe2, 0xa4, 0x56, 0x3c, 0x2f, 0xde, 0xa6, 0x04, 0x3c, 0x82, 0x4b, 0x81, 0xd5, 0x3a, 0x73, 0x00,
    0xaf, 0xed, 0x03, 0xe2, 0xac, 0xa0, 0x34, 0xfd, 0x6d, 0x77, 0x34, 0xa4, 0x39, 0x04, 0x90, 0x2f,
    0x1d, 0xe3, 0xd2, 0xa8, 0x4e, 0x3e, 0xaa, 0x8e, 0x46, 0x82, 0xe5, 0xac, 0x3b, 0x28, 0x1c, 0xb7,
    0xc6, 0x72, 0x33, 0x5e, 0x3f, 0xa9, 0x33, 0x34, 0xa9, 0xc7, 0x76, 0x56, 0x95, 0x4a, 0xd1, 0x89,
    0x40, 0xd4, 0x45, 0xbe, 0x7b, 0x17, 0x0b, 0xef, 0x16, 0x68, 0xce, 0xab, 0xe1, 0xe1, 0xed, 0x0a,
    0x79, 0x96, 0x08, 0xbd, 0xe8, 0xd9, 0x9c, 0xd1, 0x48, 0xb1, 0x54, 0x44, 0x5f, 0x02, 0x6c, 0xda,
    0xe3, 0x44, 0xc4, 0xb8, 0xaa, 0x2c, 0xf7, 0x57, 0x68, 0x09, 0x8f, 0xdd, 0xf4, 0x75, 0x04, 0x75,
    0xf2, 0x2e, 0xa6, 0x21, 0xb0, 0x75, 0xdd, 0x84, 0xba, 0xa2, 0x01, 0xd7, 0xba, 0x61, 0x42, 0x54,
    0x64, 0x24, 0xae, 0xf6, 0xd6, 0xc7, 0x53, 0xed, 0x43, 0xb9, 0x77, 0xee, 0xec, 0xca, 0xe5, 0x09,
    0xfc, 0x70, 0xfe, 0x98, 0x9f, 0x9b, 0x7f, 0x97, 0x27, 0xed, 0xfd, 0xf9, 0x49, 0xab, 0x1e, 0xad,
    0x97, 0x27, 0xe1, 0xdd, 0x21, 0x24, 0xec, 0x8b, 0xe9, 0x85, 0xb6, 0xa4, 0x27, 0xc6, 0x92, 0xe2,
    0xdc, 0xd2, 0xf0, 0xf6, 0xf6, 0x28, 0xde, 0x4e, 0x57, 0x4e, 0x2f, 0x89, 0xbb, 0x37, 0xff, 0x99,
    0xbb, 0xf3, 0x57, 0xd5, 0x73, 0x19, 0xd0, 0xc7, 0xdf, 0x77, 0x0f, 0x1a, 0x5a, 0x92, 0x88, 0x9b,
    0x0c, 0x2b, 0xb5, 0xc8, 0xd4, 0xb8, 0xc9, 0x54, 0x9c, 0x7b, 0xb2, 0x7f, 0x38, 0x56, 0x23, 0x64,
    0x9b, 0x73, 0x50, 0x38, 0x98, 0xdf, 0xe4, 0x33, 0x7c, 0xa6, 0x98, 0x1c, 0xee, 0x4a, 0x2d, 0x59,
    0x43, 0x99, 0xfc, 0xde, 0xea, 0x51, 0x03, 0xf8, 0xe0, 0x91, 0xb0, 0xf9, 0xe0, 0xf7, 0xa3, 0x10,
    0x57, 0xe3, 0x72, 0xa0, 0xf2, 0x6c, 0x68, 0x32, 0xb9, 0x72, 0x10, 0x95, 0xe0, 0xab, 0x17, 0x1a,
    0x3d, 0x40, 0xaf, 0x36, 0xfd, 0xee, 0xcf, 0x58, 0x3d, 0xd2, 0x5d, 0x29, 0x19, 0xab, 0x77, 0x4a,
    0xbd, 0xf6, 0x7d, 0x9e, 0x96, 0xc7, 0xd4, 0xa4, 0x1e, 0xff, 0x2b, 0xce, 0x06, 0xc3, 0x38, 0x51,
    0xf3, 0xfa, 0x5f, 0x23, 0x12, 0x44, 0x31, 0xa6, 0x09, 0xda, 0x0c, 0x86, 0x17, 0x38, 0x4f, 0x5e,
    0x03, 0xf5, 0x48, 0xfd, 0x72, 0xb6, 0x27, 0x8d, 0xa9, 0x39, 0x59, 0xe3, 0x22, 0x7d, 0xe3, 0xe3,
    0xe0, 0xf8, 0xb3, 0x40, 0x6f, 0x6a, 0x1a, 0xb5, 0x4f, 0x69, 0xa8, 0xdc, 0x48, 0x1b, 0xe8, 0xc5,
    0x4d, 0x38, 0x55, 0x2c, 0xf7, 0x63, 0xbd, 0x66, 0x7a, 0x41, 0x97, 0xba, 0x87, 0x5c, 0xe9, 0x9b,
    0x40, 0x13, 0x9e, 0xe1, 0x2a, 0xbf, 0x27, 0xe8, 0xa1, 0x7e, 0x61, 0xea, 0xb2, 0x8d, 0x04, 0xdb,
    0x24, 0xff, 0xad, 0x0a, 0xc3, 0x52, 0x42, 0x83, 0x24, 0x32, 0x7a, 0x9b, 0xf6, 0x3b, 0x91, 0xf3,
    0xda, 0x54, 0x23, 0x28, 0xf1, 0xa9, 0x6b, 0xf9, 0x29, 0x93, 0x3a, 0x40, 0x52, 0x34, 0xfa, 0x27,
    0x29, 0x54, 0x63, 0x6c, 0x0a, 0xfa, 0xea, 0x0d, 0x58, 0x32, 0xa7, 0x06, 0xa8, 0x7f, 0xa4, 0xa9,
    0x92, 0xf2, 0x0f, 0x53, 0x2c, 0x5d, 0xa3
};
#endif

PyTypeObject *init_KNotification(PyObject *module)
{
    if (SbkKNotificationsTypeStructs[SBK_KNotification_IDX].type != nullptr)
        return SbkKNotificationsTypeStructs[SBK_KNotification_IDX].type;

    Shiboken::AutoDecRef Sbk_KNotification_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KNotification_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNotification",
        "KNotification*",
        &Sbk_KNotification_spec,
        &Shiboken::callCppDestructor< KNotification >,
        Sbk_KNotification_Type_bases.object(),
        0);
    auto *pyType = Sbk_KNotification_TypeF(); // references _Sbk_KNotification_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNotification_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNotification_SignatureBytes, KNotification_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNotification_PropertyStrings);
    SbkKNotificationsTypeStructs[SBK_KNotification_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNotification_PythonToCpp_KNotification_PTR,
        is_KNotification_PythonToCpp_KNotification_PTR_Convertible,
        KNotification_PTR_CppToPython_KNotification);

    Shiboken::Conversions::registerConverterName(converter, "KNotification");
    Shiboken::Conversions::registerConverterName(converter, "KNotification*");
    Shiboken::Conversions::registerConverterName(converter, "KNotification&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNotification).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNotificationWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNotification_TypeF(), &Sbk_KNotification_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KNotification_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'NotificationFlag'.
    const char *NotificationFlag_Initializer[] = {
        "CloseOnTimeout",
        "Persistent",
        "LoopSound",
        "SkipGrouping",
        "CloseWhenWindowActivated",
        "DefaultEvent",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t NotificationFlag_InitializerValues[] = {
        uint16_t(KNotification::NotificationFlag::CloseOnTimeout),           //  0x0000  0
        uint16_t(KNotification::NotificationFlag::Persistent),               //  0x0002  2
        uint16_t(KNotification::NotificationFlag::LoopSound),                //  0x0008  8
        uint16_t(KNotification::NotificationFlag::SkipGrouping),             //  0x0010  16
        uint16_t(KNotification::NotificationFlag::CloseWhenWindowActivated), //  0x0020  32
        uint16_t(KNotification::NotificationFlag::DefaultEvent)              //  0xf000  61440
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNotification_TypeF(),
        "1:KNotifications.KNotification.NotificationFlag",
        NotificationFlag_Initializer, NotificationFlag_InitializerValues);
    SbkKNotificationsTypeStructs[SBK_KNotification_NotificationFlag_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKNotificationsTypeStructs[SBK_QFlags_KNotification_NotificationFlag_IDX].type =
        EType;
    // Register converter for enum 'KNotification::NotificationFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNotification_NotificationFlag_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNotification_NotificationFlag,
            is_Enum_PythonToCpp_KNotification_NotificationFlag_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNotification::NotificationFlag");
        Shiboken::Conversions::registerConverterAlias(converter, "NotificationFlag");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KNotification_NotificationFlag_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KNotification_NotificationFlag,
            is_Enum_PythonToCpp_KNotification_NotificationFlag_Convertible);
        // Register converter for flag 'QFlags<KNotification::NotificationFlag>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KNotification::NotificationFlag>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KNotification::NotificationFlags");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'NotificationFlag' enum/flags.

    // Initialization of enum 'StandardEvent'.
    const char *StandardEvent_Initializer[] = {
        "Notification",
        "Warning",
        "Error",
        "Catastrophe",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t StandardEvent_InitializerValues[] = {
        uint8_t(KNotification::StandardEvent::Notification), //  0x00  0
        uint8_t(KNotification::StandardEvent::Warning),      //  0x01  1
        uint8_t(KNotification::StandardEvent::Error),        //  0x02  2
        uint8_t(KNotification::StandardEvent::Catastrophe)   //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNotification_TypeF(),
        "1:KNotifications.KNotification.StandardEvent",
        StandardEvent_Initializer, StandardEvent_InitializerValues);
    SbkKNotificationsTypeStructs[SBK_KNotification_StandardEvent_IDX].type = EType;
    // Register converter for enum 'KNotification::StandardEvent'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNotification_StandardEvent_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNotification_StandardEvent,
            is_Enum_PythonToCpp_KNotification_StandardEvent_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNotification::StandardEvent");
        Shiboken::Conversions::registerConverterAlias(converter, "StandardEvent");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'StandardEvent' enum.

    // Initialization of enum 'Urgency'.
    const char *Urgency_Initializer[] = {
        "DefaultUrgency",
        "LowUrgency",
        "NormalUrgency",
        "HighUrgency",
        "CriticalUrgency",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t Urgency_InitializerValues[] = {
        int8_t(KNotification::Urgency::DefaultUrgency), // -0x01 -1
        int8_t(KNotification::Urgency::LowUrgency),     //  0x0a  10
        int8_t(KNotification::Urgency::NormalUrgency),  //  0x32  50
        int8_t(KNotification::Urgency::HighUrgency),    //  0x46  70
        int8_t(KNotification::Urgency::CriticalUrgency) //  0x5a  90
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNotification_TypeF(),
        "1:KNotifications.KNotification.Urgency",
        Urgency_Initializer, Urgency_InitializerValues);
    SbkKNotificationsTypeStructs[SBK_KNotification_Urgency_IDX].type = EType;
    // Register converter for enum 'KNotification::Urgency'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNotification_Urgency_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNotification_Urgency,
            is_Enum_PythonToCpp_KNotification_Urgency_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNotification::Urgency");
        Shiboken::Conversions::registerConverterAlias(converter, "Urgency");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Urgency' enum.

    PySide::Signal::registerSignals(pyType, &::KNotification::staticMetaObject);
    qRegisterMetaType< ::KNotification::NotificationFlag >("KNotification::NotificationFlag");
    qRegisterMetaType< ::KNotification::StandardEvent >("KNotification::StandardEvent");
    qRegisterMetaType< ::KNotification::Urgency >("KNotification::Urgency");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNotification::staticMetaObject, sizeof(KNotificationWrapper));

    return pyType;
}
