
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kstatusbarjobtracker_wrapper.h"

// Wrappers providing overrides
#include "kabstractwidgetjobtracker_wrapper.h"
#include "knotificationjobuidelegate_wrapper.h"
#include "kuiserverv2jobtracker_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KStatusBarJobTracker_Type = nullptr;
static PyTypeObject *Sbk_KStatusBarJobTracker_TypeF(void)
{
    return _Sbk_KStatusBarJobTracker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KStatusBarJobTrackerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KStatusBarJobTrackerWrapper::KStatusBarJobTrackerWrapper(::QWidget * parent, bool button) : KStatusBarJobTracker(parent, button)
{
}

void KStatusBarJobTrackerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KStatusBarJobTracker", funcName, gil, pyOverride, event);
}

void KStatusBarJobTrackerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KStatusBarJobTracker", funcName, gil, pyOverride, signal);
}

void KStatusBarJobTrackerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KStatusBarJobTracker", funcName, gil, pyOverride, event);
}

void KStatusBarJobTrackerWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::description(job, title, field1, field2);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_description("KStatusBarJobTracker", funcName, gil, pyOverride, job, title, field1, field2);
}

void KStatusBarJobTrackerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KStatusBarJobTracker", funcName, gil, pyOverride, signal);
}

bool KStatusBarJobTrackerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KStatusBarJobTracker", funcName, gil, pyOverride, event);
}

bool KStatusBarJobTrackerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KStatusBarJobTracker", funcName, gil, pyOverride, watched, event);
}

void KStatusBarJobTrackerWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::finished(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::infoMessage(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KStatusBarJobTracker", funcName, gil, pyOverride, job, message);
}

void KStatusBarJobTrackerWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::percent(job, percent);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KStatusBarJobTracker", funcName, gil, pyOverride, job, percent);
}

void KStatusBarJobTrackerWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::processedAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KStatusBarJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KStatusBarJobTrackerWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::registerJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::resumed(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::slotClean(::KJob * job)
{
    static const char *funcName = "slotClean";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::slotClean(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::slotResume(::KJob * job)
{
    static const char *funcName = "slotResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotResume(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::slotStop(::KJob * job)
{
    static const char *funcName = "slotStop";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotStop(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::slotSuspend(::KJob * job)
{
    static const char *funcName = "slotSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotSuspend(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::speed(job, value);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KStatusBarJobTracker", funcName, gil, pyOverride, job, value);
}

void KStatusBarJobTrackerWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::suspended(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KStatusBarJobTracker", funcName, gil, pyOverride, event);
}

void KStatusBarJobTrackerWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::totalAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KStatusBarJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KStatusBarJobTrackerWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::unregisterJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

void KStatusBarJobTrackerWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KStatusBarJobTracker", funcName, gil, pyOverride, job, message);
}

::QWidget * KStatusBarJobTrackerWrapper::widget(::KJob * job)
{
    static const char *funcName = "widget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KStatusBarJobTracker_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::KStatusBarJobTracker::widget(job);
    }
    return KAbstractWidgetJobTrackerWrapper::sbk_o_widget("KStatusBarJobTracker", funcName, gil, pyOverride, job);
}

const QMetaObject *KStatusBarJobTrackerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KStatusBarJobTracker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KStatusBarJobTrackerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KStatusBarJobTracker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KStatusBarJobTrackerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KStatusBarJobTrackerWrapper *>(this));
    }
    return KStatusBarJobTracker::qt_metacast(_clname);
}

KStatusBarJobTrackerWrapper::~KStatusBarJobTrackerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KStatusBarJobTracker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KStatusBarJobTracker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KStatusBarJobTracker >()))
        return -1;

    KStatusBarJobTrackerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KStatusBarJobTracker", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KStatusBarJobTracker::KStatusBarJobTracker(QWidget*=,bool=)
    if (numArgs == 0) {
        overloadId = 0; // KStatusBarJobTracker(QWidget*,bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KStatusBarJobTracker(QWidget*,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // KStatusBarJobTracker(QWidget*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 0}, {"button", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KStatusBarJobTracker(QWidget*,bool)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KStatusBarJobTrackerWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KStatusBarJobTrackerWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KStatusBarJobTracker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_description(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "description", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "description", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        std::pair<QString,QString> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        std::pair<QString,QString> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::description(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->description(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_percent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "percent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::percent(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // percent(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "percent", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // percent(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::percent(cppArg0, cppArg1)
                : cppSelf->percent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_setStatusBarMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KStatusBarJobTracker::setStatusBarMode(QFlags<KStatusBarJobTracker::StatusBarMode>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_QFlags_KStatusBarJobTracker_StatusBarMode_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setStatusBarMode(QFlags<KStatusBarJobTracker::StatusBarMode>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStatusBarMode", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        ::QFlags<KStatusBarJobTracker::StatusBarMode> cppArg0 = QFlags<KStatusBarJobTracker::StatusBarMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStatusBarMode(QFlags<KStatusBarJobTracker::StatusBarMode>)
            cppSelf->setStatusBarMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_slotClean(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotClean(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotClean(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotClean", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotClean(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::slotClean(cppArg0)
                : cppSelf->slotClean(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_speed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "speed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::speed(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // speed(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "speed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // speed(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::speed(cppArg0, cppArg1)
                : cppSelf->speed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_totalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "totalAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::totalAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // totalAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "totalAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::totalAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->totalAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStatusBarJobTrackerFunc_widget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::widget(KJob*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // widget(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "widget", errInfo, SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // widget(KJob*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KStatusBarJobTracker::widget(cppArg0)
                : cppSelf->widget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KStatusBarJobTracker_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KStatusBarJobTracker_EnumFlagInfo[] = {
    "StatusBarMode:IntFlag:yes",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KStatusBarJobTracker_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_description), METH_VARARGS, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_percent), METH_VARARGS, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_registerJob), METH_O, nullptr},
    {"setStatusBarMode", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_setStatusBarMode), METH_O, nullptr},
    {"slotClean", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_slotClean), METH_O, nullptr},
    {"speed", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_speed), METH_VARARGS, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_totalAmount), METH_VARARGS, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_unregisterJob), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_KStatusBarJobTrackerFunc_widget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KStatusBarJobTracker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KStatusBarJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KStatusBarJobTrackerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KStatusBarJobTracker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KStatusBarJobTracker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KStatusBarJobTracker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KStatusBarJobTracker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KStatusBarJobTracker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KStatusBarJobTracker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KStatusBarJobTracker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KStatusBarJobTracker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KStatusBarJobTracker_spec = {
    "1:KJobWidgets.KStatusBarJobTracker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KStatusBarJobTracker_slots
};

} //extern "C"

static void *Sbk_KStatusBarJobTracker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KStatusBarJobTracker *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KStatusBarJobTracker::StatusBarMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KStatusBarJobTracker::StatusBarMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_StatusBarMode_IDX])))
        return Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode;
    return {};
}

static PyObject *KStatusBarJobTracker_StatusBarMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KStatusBarJobTracker::StatusBarMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KStatusBarJobTracker::StatusBarMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KStatusBarJobTracker_StatusBarMode(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KStatusBarJobTracker::StatusBarMode>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KStatusBarJobTracker::StatusBarMode> *>(cppOut) = value;

}

static PyObject *KStatusBarJobTracker_StatusBarMode_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KStatusBarJobTracker::StatusBarMode> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_StatusBarMode_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KStatusBarJobTracker_PythonToCpp_KStatusBarJobTracker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KStatusBarJobTracker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KStatusBarJobTracker_PythonToCpp_KStatusBarJobTracker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KStatusBarJobTracker_TypeF()))
        return KStatusBarJobTracker_PythonToCpp_KStatusBarJobTracker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KStatusBarJobTracker_PTR_CppToPython_KStatusBarJobTracker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KStatusBarJobTracker *>(const_cast<void *>(cppIn)), Sbk_KStatusBarJobTracker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KStatusBarJobTracker_SignatureStrings[] = {
    "KJobWidgets.KStatusBarJobTracker(self,parent:PySide6.QtWidgets.QWidget=nullptr,button:bool=true)",
    "KJobWidgets.KStatusBarJobTracker.description(self,job:KCoreAddons.KJob,title:QString,field1:std.pair[QString, QString],field2:std.pair[QString, QString])",
    "KJobWidgets.KStatusBarJobTracker.percent(self,job:KCoreAddons.KJob,percent:unsigned long)",
    "KJobWidgets.KStatusBarJobTracker.registerJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KStatusBarJobTracker.setStatusBarMode(self,statusBarMode:KJobWidgets.KStatusBarJobTracker.StatusBarMode)",
    "KJobWidgets.KStatusBarJobTracker.slotClean(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KStatusBarJobTracker.speed(self,job:KCoreAddons.KJob,value:unsigned long)",
    "KJobWidgets.KStatusBarJobTracker.totalAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KStatusBarJobTracker.unregisterJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KStatusBarJobTracker.widget(self,job:KCoreAddons.KJob)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KStatusBarJobTracker_SignatureByteSize = 277;
static constexpr uint8_t KStatusBarJobTracker_SignatureBytes[277] = {
    0x78, 0xda, 0xad, 0x93, 0x41, 0x4b, 0xc3, 0x40, 0x10, 0x85, 0xef, 0xfd, 0x15, 0x3d, 0x2a, 0xc4,
    0x80, 0x1e, 0x3c, 0x2c, 0x54, 0xa8, 0xbd, 0x19, 0x04, 0x43, 0x14, 0x0f, 0xe2, 0x61, 0x93, 0x9d,
    0x86, 0xd5, 0x71, 0x66, 0x9d, 0x9d, 0x55, 0xfc, 0xf7, 0xa6, 0x4d, 0x2b, 0x8a, 0x34, 0x4d, 0xd1,
    0xdb, 0xf2, 0xed, 0x9b, 0xf7, 0x66, 0x67, 0xd8, 0xe2, 0x8a, 0xeb, 0x7b, 0xef, 0x5a, 0xd0, 0x98,
    0x17, 0x95, 0x5a, 0x4d, 0xf1, 0xd2, 0x4a, 0x07, 0x6f, 0xc5, 0x36, 0xcf, 0x20, 0x47, 0x11, 0x70,
    0x99, 0x05, 0x2b, 0x40, 0x6a, 0x6e, 0x3e, 0x2a, 0xef, 0xe0, 0x3c, 0x2f, 0x75, 0x5b, 0x52, 0xf6,
    0x87, 0x19, 0x25, 0xc4, 0xa0, 0x92, 0xd5, 0x49, 0x95, 0xc9, 0xd4, 0xcc, 0x38, 0x53, 0x49, 0x70,
    0x3c, 0x29, 0xf6, 0x04, 0xe4, 0x0e, 0x62, 0x23, 0x3e, 0xa8, 0x67, 0xea, 0xc3, 0x9e, 0xb8, 0x36,
    0xc5, 0x82, 0x05, 0xe6, 0xce, 0x31, 0x75, 0x55, 0x9d, 0x38, 0x53, 0xaf, 0x08, 0xa6, 0xac, 0x54,
    0x3c, 0xb5, 0xd9, 0xd2, 0x03, 0xba, 0x53, 0x13, 0xd5, 0xe5, 0xc1, 0x7a, 0x79, 0xd8, 0xf2, 0xe9,
    0xe6, 0xf0, 0xd8, 0x2b, 0xce, 0x06, 0x14, 0x23, 0x3a, 0x0b, 0x20, 0x4d, 0xf7, 0xec, 0x81, 0xae,
    0x36, 0x0a, 0x93, 0x28, 0xfa, 0x96, 0xc0, 0x4d, 0x91, 0xa9, 0x1d, 0xe1, 0x2c, 0xd0, 0xfa, 0xa8,
    0xb0, 0x42, 0xbb, 0xdd, 0x47, 0xf8, 0x44, 0xd0, 0x2f, 0x7c, 0xcd, 0x0e, 0x7a, 0xb3, 0xf8, 0x1d,
    0x99, 0xbd, 0x26, 0x3f, 0x1c, 0xc6, 0x84, 0x22, 0xeb, 0x02, 0xc1, 0xd2, 0xdf, 0x5a, 0x0f, 0x00,
    0x6e, 0x60, 0xb4, 0x6f, 0x16, 0x13, 0x1c, 0x3c, 0x58, 0x65, 0xb5, 0x38, 0x7f, 0xe1, 0x34, 0xb8,
    0xb6, 0x44, 0x5e, 0x7f, 0xd1, 0xfc, 0xae, 0xa3, 0x99, 0x5d, 0xd7, 0x9a, 0xd7, 0xb4, 0x0a, 0x1c,
    0x19, 0x9a, 0xe8, 0xbf, 0xf6, 0xf9, 0xbe, 0xbe, 0x1c, 0xb0, 0x38, 0xb9, 0xd8, 0xf9, 0x07, 0x27,
    0x9f, 0x3f, 0xd7, 0x65, 0xbe
};
#endif

PyTypeObject *init_KStatusBarJobTracker(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX].type;

    Shiboken::AutoDecRef Sbk_KStatusBarJobTracker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]))));

    _Sbk_KStatusBarJobTracker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KStatusBarJobTracker",
        "KStatusBarJobTracker*",
        &Sbk_KStatusBarJobTracker_spec,
        &Shiboken::callCppDestructor< KStatusBarJobTracker >,
        Sbk_KStatusBarJobTracker_Type_bases.object(),
        0);
    auto *pyType = Sbk_KStatusBarJobTracker_TypeF(); // references _Sbk_KStatusBarJobTracker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KStatusBarJobTracker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KStatusBarJobTracker_SignatureBytes, KStatusBarJobTracker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KStatusBarJobTracker_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KStatusBarJobTracker_PythonToCpp_KStatusBarJobTracker_PTR,
        is_KStatusBarJobTracker_PythonToCpp_KStatusBarJobTracker_PTR_Convertible,
        KStatusBarJobTracker_PTR_CppToPython_KStatusBarJobTracker);

    Shiboken::Conversions::registerConverterName(converter, "KStatusBarJobTracker");
    Shiboken::Conversions::registerConverterName(converter, "KStatusBarJobTracker*");
    Shiboken::Conversions::registerConverterName(converter, "KStatusBarJobTracker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KStatusBarJobTracker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KStatusBarJobTrackerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KStatusBarJobTracker_TypeF(), &Sbk_KStatusBarJobTracker_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KStatusBarJobTracker_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'StatusBarMode'.
    const char *StatusBarMode_Initializer[] = {
        "NoInformation",
        "LabelOnly",
        "ProgressOnly",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t StatusBarMode_InitializerValues[] = {
        uint8_t(KStatusBarJobTracker::StatusBarMode::NoInformation), //  0x00  0
        uint8_t(KStatusBarJobTracker::StatusBarMode::LabelOnly),     //  0x01  1
        uint8_t(KStatusBarJobTracker::StatusBarMode::ProgressOnly)   //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KStatusBarJobTracker_TypeF(),
        "1:KJobWidgets.KStatusBarJobTracker.StatusBarMode",
        StatusBarMode_Initializer, StatusBarMode_InitializerValues);
    SbkKJobWidgetsTypeStructs[SBK_KStatusBarJobTracker_StatusBarMode_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKJobWidgetsTypeStructs[SBK_QFlags_KStatusBarJobTracker_StatusBarMode_IDX].type =
        EType;
    // Register converter for enum 'KStatusBarJobTracker::StatusBarMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KStatusBarJobTracker_StatusBarMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode,
            is_Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KStatusBarJobTracker::StatusBarMode");
        Shiboken::Conversions::registerConverterAlias(converter, "StatusBarMode");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KStatusBarJobTracker_StatusBarMode_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KStatusBarJobTracker_StatusBarMode,
            is_Enum_PythonToCpp_KStatusBarJobTracker_StatusBarMode_Convertible);
        // Register converter for flag 'QFlags<KStatusBarJobTracker::StatusBarMode>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KStatusBarJobTracker::StatusBarMode>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KStatusBarJobTracker::yes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'StatusBarMode' enum/flags.

    qRegisterMetaType< ::KStatusBarJobTracker::StatusBarMode >("KStatusBarJobTracker::StatusBarMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KStatusBarJobTracker::staticMetaObject, sizeof(KStatusBarJobTrackerWrapper));

    return pyType;
}
