
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kuser_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <kuser.h>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUser_Type = nullptr;
static PyTypeObject *Sbk_KUser_TypeF(void)
{
    return _Sbk_KUser_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUser_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUser >()))
        return -1;

    ::KUser *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    if (PyArg_ParseTuple(args, "|O:KUser", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUser::KUser(KUser::UIDMode=)
    // 1: KUser::KUser(KUserId)
    // 2: KUser::KUser(KUser)
    // 3: KUser::KUser(QString)
    // 4: KUser::KUser(const char*)
    // 5: KUser::KUser(uint)
    if (numArgs == 0) {
        overloadId = 0; // KUser(KUser::UIDMode)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KUser(KUserId)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // KUser(KUser::UIDMode)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), (pyArgs[0])))) {
        overloadId = 2; // KUser(KUser)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 4; // KUser(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 3; // KUser(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 5; // KUser(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KUser(KUser::UIDMode mode)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"mode", 0}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
                }
            }
            ::KUser::UIDMode cppArg0(KUser::UIDMode::UseEffectiveUID);
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(KUser::UIDMode)
                cptr = new ::KUser(cppArg0);
            }
            break;
        }
        case 1: // KUser(KUserId uid)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUserId cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(KUserId)
                cptr = new ::KUser(cppArg0);
            }
            break;
        }
        case 2: // KUser(const KUser &user)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUser cppArg0_local;
            ::KUser *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(KUser)
                cptr = new ::KUser(*cppArg0);
            }
            break;
        }
        case 3: // KUser(const QString &name)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(QString)
                cptr = new ::KUser(cppArg0);
            }
            break;
        }
        case 4: // KUser(const char *name)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(const char*)
                cptr = new ::KUser(cppArg0);
            }
            break;
        }
        case 5: // KUser(unsigned int uid)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUser(uint)
                cptr = new ::KUser(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUser >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUserFunc_allUserNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allUserNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    if (PyArg_ParseTuple(args, "|O:allUserNames", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUser::allUserNames(uint=)->QStringList
    if (numArgs == 0) {
        overloadId = 0; // allUserNames(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // allUserNames(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allUserNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allUserNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allUserNames(uint)
            QStringList cppResult = ::KUser::allUserNames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_allUsers(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allUsers", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    if (PyArg_ParseTuple(args, "|O:allUsers", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUser::allUsers(uint=)->QList<KUser>
    if (numArgs == 0) {
        overloadId = 0; // allUsers(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // allUsers(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allUsers", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allUsers", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allUsers(uint)
            QList<KUser> cppResult = ::KUser::allUsers(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUser_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_faceIconPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // faceIconPath()const
        QString cppResult = const_cast<const ::KUser *>(cppSelf)->faceIconPath();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_groupId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // groupId()const
        KGroupId cppResult = const_cast<const ::KUser *>(cppSelf)->groupId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_groupNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "groupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    if (PyArg_ParseTuple(args, "|O:groupNames", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUser::groupNames(uint=)const->QStringList
    if (numArgs == 0) {
        overloadId = 0; // groupNames(uint)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // groupNames(uint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "groupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "groupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // groupNames(uint)const
            QStringList cppResult = const_cast<const ::KUser *>(cppSelf)->groupNames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_groups(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "groups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    if (PyArg_ParseTuple(args, "|O:groups", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUser::groups(uint=)const->QList<KUserGroup>
    if (numArgs == 0) {
        overloadId = 0; // groups(uint)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // groups(uint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "groups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "groups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // groups(uint)const
            QList<KUserGroup> cppResult = const_cast<const ::KUser *>(cppSelf)->groups(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUserGroup_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_homeDir(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // homeDir()const
        QString cppResult = const_cast<const ::KUser *>(cppSelf)->homeDir();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_isSuperUser(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSuperUser()const
        bool cppResult = const_cast<const ::KUser *>(cppSelf)->isSuperUser();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KUser *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_loginName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loginName()const
        QString cppResult = const_cast<const ::KUser *>(cppSelf)->loginName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUser::property(KUser::UserProperty)const->QVariant
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UserProperty_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // property(KUser::UserProperty)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "property", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]);

    // Call function/method
    {
        ::KUser::UserProperty cppArg0{KUser::FullName};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // property(KUser::UserProperty)const
            QVariant cppResult = const_cast<const ::KUser *>(cppSelf)->property(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_shell(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shell()const
        QString cppResult = const_cast<const ::KUser *>(cppSelf)->shell();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserFunc_userId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // userId()const
        KUserId cppResult = const_cast<const ::KUser *>(cppSelf)->userId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUser__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KUser_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KUser_EnumFlagInfo[] = {
    "UIDMode:IntEnum",
    "UserProperty:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUser_methods[] = {
    {"allUserNames", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_allUserNames), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"allUsers", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_allUsers), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"faceIconPath", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_faceIconPath), METH_NOARGS, nullptr},
    {"groupId", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_groupId), METH_NOARGS, nullptr},
    {"groupNames", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_groupNames), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"groups", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_groups), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"homeDir", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_homeDir), METH_NOARGS, nullptr},
    {"isSuperUser", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_isSuperUser), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_isValid), METH_NOARGS, nullptr},
    {"loginName", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_loginName), METH_NOARGS, nullptr},
    {"property", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_property), METH_O, nullptr},
    {"shell", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_shell), METH_NOARGS, nullptr},
    {"userId", reinterpret_cast<PyCFunction>(Sbk_KUserFunc_userId), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KUser__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KUser_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), (pyArg)))) {
                // operator!=(const KUser &user) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUser cppArg0_local;
                ::KUser *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), (pyArg)))) {
                // operator==(const KUser &user) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUser cppArg0_local;
                ::KUser *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KUser_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUser_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUser_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUser_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUser_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KUser_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUser_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUser_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUser_spec = {
    "1:KCoreAddons.KUser",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUser_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KUser_UIDMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KUser::UIDMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KUser::UIDMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KUser_UIDMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))
        return Enum_PythonToCpp_KUser_UIDMode;
    return {};
}

static PyObject *KUser_UIDMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KUser::UIDMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KUser::UIDMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KUser_UserProperty(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KUser::UserProperty>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KUser::UserProperty *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KUser_UserProperty_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UserProperty_IDX])))
        return Enum_PythonToCpp_KUser_UserProperty;
    return {};
}

static PyObject *KUser_UserProperty_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KUser::UserProperty>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KUser::UserProperty *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUser_PythonToCpp_KUser_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUser_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUser_PythonToCpp_KUser_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUser_TypeF()))
        return KUser_PythonToCpp_KUser_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUser_PTR_CppToPython_KUser(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUser_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUser_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KUser_COPY_CppToPython_KUser(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KUser *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KUser_TypeF(), new ::KUser(*source), true, true);
}

// Python to C++ copy conversion.
static void KUser_PythonToCpp_KUser_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KUser *>(cppOut) = *reinterpret_cast< ::KUser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KUser_PythonToCpp_KUser_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KUser_TypeF()))
        return KUser_PythonToCpp_KUser_COPY;
    return {};
}

// Implicit conversions.
static void KUser_UIDMode_PythonToCpp_KUser(PyObject *pyIn, void *cppOut)
{
    ::KUser::UIDMode cppIn{KUser::UseEffectiveUID};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, pyIn, &cppIn);
    *reinterpret_cast<::KUser *>(cppOut) = ::KUser(cppIn);
}
static PythonToCppFunc is_KUser_UIDMode_PythonToCpp_KUser_Convertible(PyObject *pyIn)
{
    if (SbkObject_TypeCheck(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX]), pyIn))
        return KUser_UIDMode_PythonToCpp_KUser;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUser_SignatureStrings[] = {
    "5:KCoreAddons.KUser(self,mode:KCoreAddons.KUser.UIDMode=KUser.UIDMode.UseEffectiveUID)",
    "4:KCoreAddons.KUser(self,uid:KCoreAddons.KUserId)",
    "3:KCoreAddons.KUser(self,user:KCoreAddons.KUser)",
    "2:KCoreAddons.KUser(self,name:QString)",
    "1:KCoreAddons.KUser(self,name:char*)",
    "0:KCoreAddons.KUser(self,uid:unsigned int)",
    "KCoreAddons.KUser.allUserNames(maxCount:uint=KCOREADDONS_UINT_MAX)->QStringList",
    "KCoreAddons.KUser.allUsers(maxCount:uint=KCOREADDONS_UINT_MAX)->QList[KCoreAddons.KUser]",
    "KCoreAddons.KUser.faceIconPath(self)->QString",
    "KCoreAddons.KUser.groupId(self)->KCoreAddons.KGroupId",
    "KCoreAddons.KUser.groupNames(self,maxCount:uint=KCOREADDONS_UINT_MAX)->QStringList",
    "KCoreAddons.KUser.groups(self,maxCount:uint=KCOREADDONS_UINT_MAX)->QList[KCoreAddons.KUserGroup]",
    "KCoreAddons.KUser.homeDir(self)->QString",
    "KCoreAddons.KUser.isSuperUser(self)->bool",
    "KCoreAddons.KUser.isValid(self)->bool",
    "KCoreAddons.KUser.loginName(self)->QString",
    "KCoreAddons.KUser.property(self,which:KCoreAddons.KUser.UserProperty)->QVariant",
    "KCoreAddons.KUser.shell(self)->QString",
    "KCoreAddons.KUser.userId(self)->KCoreAddons.KUserId",
    "KCoreAddons.KUser.__copy__(self)->typing._Self",
    "KCoreAddons.KUser.__ne__(self,user:typing.Union[KCoreAddons.KUser, KCoreAddons.KUser.UIDMode])->bool",
    "KCoreAddons.KUser.__eq__(self,user:typing.Union[KCoreAddons.KUser, KCoreAddons.KUser.UIDMode])->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUser_SignatureByteSize = 372;
static constexpr uint8_t KUser_SignatureBytes[372] = {
    0x78, 0xda, 0xad, 0x94, 0x5d, 0x4f, 0x83, 0x30, 0x14, 0x86, 0xef, 0xf9, 0x15, 0xbb, 0x1c, 0x66,
    0x12, 0x3f, 0x6f, 0x96, 0xcc, 0x84, 0x8c, 0xc5, 0x90, 0xb9, 0x0f, 0x45, 0x16, 0x13, 0xb3, 0x34,
    0x95, 0x16, 0x68, 0x52, 0x5a, 0x6c, 0x8b, 0xba, 0x7f, 0x6f, 0xf9, 0x98, 0x66, 0xa1, 0x0c, 0x8d,
    0xde, 0x00, 0xe5, 0x3c, 0xe7, 0x3d, 0x87, 0x97, 0x9e, 0x5e, 0x8f, 0xe7, 0x53, 0x2e, 0xb0, 0x8b,
    0x10, 0x67, 0xd2, 0x99, 0x87, 0x12, 0x8b, 0xa1, 0xc4, 0x34, 0x1e, 0x65, 0x1c, 0xe1, 0x76, 0xcc,
    0x09, 0x7d, 0x6f, 0xa1, 0x23, 0x93, 0x83, 0x95, 0xa3, 0x17, 0xb3, 0x38, 0xc6, 0x91, 0x22, 0x6f,
    0x58, 0xbf, 0xb3, 0xad, 0xab, 0x2e, 0xd9, 0x82, 0xa0, 0x76, 0xc8, 0x47, 0xb6, 0x75, 0xd9, 0x99,
    0xa1, 0x9f, 0xda, 0x31, 0xdb, 0xba, 0xe8, 0x4a, 0x60, 0x30, 0xc3, 0xe3, 0xfb, 0x40, 0x09, 0xc2,
    0x12, 0xdb, 0x3a, 0x3f, 0x8a, 0x45, 0x29, 0x14, 0x27, 0xb6, 0x75, 0x76, 0xac, 0xdd, 0x82, 0x49,
    0x92, 0x30, 0x8c, 0x06, 0x84, 0x29, 0xdb, 0x6a, 0x5b, 0x02, 0x29, 0x2d, 0xef, 0x4b, 0xad, 0x27,
    0x87, 0x19, 0xfc, 0x98, 0xf2, 0x82, 0xa9, 0x71, 0xa1, 0xe9, 0xc9, 0x7c, 0xba, 0x7a, 0x98, 0xb9,
    0x9e, 0xb7, 0x5a, 0x06, 0x20, 0xf4, 0x97, 0x8f, 0x60, 0xe1, 0x3e, 0xd9, 0xa7, 0x37, 0x4d, 0x73,
    0x77, 0x44, 0xaa, 0x6e, 0xbd, 0x9f, 0x6a, 0x95, 0x2a, 0xcf, 0x2d, 0x95, 0xad, 0x41, 0x38, 0x86,
    0x11, 0xf6, 0x23, 0xce, 0xd6, 0x50, 0xa5, 0xd5, 0xe7, 0x7d, 0xb7, 0x62, 0xa0, 0x13, 0xc1, 0x8b,
    0xdc, 0x47, 0x7b, 0xf0, 0x00, 0xb8, 0xad, 0x63, 0x5d, 0x59, 0xb5, 0x15, 0xf5, 0x36, 0xfa, 0xbb,
    0x1f, 0x95, 0xe4, 0xaf, 0xe4, 0xcc, 0x96, 0x54, 0x4d, 0x9b, 0x7c, 0x49, 0x79, 0x86, 0x3d, 0x22,
    0xfa, 0x2d, 0x21, 0x32, 0x28, 0x72, 0x2c, 0xbe, 0xb6, 0x87, 0x86, 0x5f, 0x38, 0xa7, 0x46, 0x72,
    0x03, 0x29, 0x41, 0x3d, 0x14, 0xe5, 0x09, 0x61, 0xa5, 0x59, 0xfd, 0xa5, 0x73, 0xc1, 0x75, 0x65,
    0xb5, 0xab, 0x6d, 0x78, 0x4f, 0x49, 0x94, 0x9a, 0xa6, 0x53, 0x5f, 0xd6, 0x0d, 0x59, 0xca, 0x6d,
    0xa0, 0x20, 0x90, 0x99, 0x4c, 0x95, 0x29, 0xa6, 0xb4, 0xbf, 0x6c, 0x51, 0x4d, 0xa7, 0x71, 0x0f,
    0xd4, 0x83, 0x6b, 0xc8, 0x01, 0x20, 0xe2, 0xf9, 0x0e, 0x80, 0x7d, 0x96, 0xda, 0xe5, 0x5a, 0xdc,
    0x01, 0x81, 0x5e, 0x1a, 0x71, 0x86, 0x1b, 0xb8, 0x9e, 0xf5, 0x86, 0x0f, 0x19, 0xe1, 0xac, 0xfd,
    0x17, 0x47, 0x83, 0xce, 0x43, 0x69, 0xdb, 0xed, 0x34, 0x00, 0xf8, 0xf5, 0x9f, 0x8b, 0x7c, 0x02,
    0x6a, 0x89, 0xd8, 0x1f
};
#endif

PyTypeObject *init_KUser(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KUser_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KUser_IDX].type;

    Shiboken::AutoDecRef Sbk_KUser_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUser_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUser",
        "KUser",
        &Sbk_KUser_spec,
        &Shiboken::callCppDestructor< ::KUser >,
        Sbk_KUser_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_KUser_TypeF(); // references _Sbk_KUser_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUser_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUser_SignatureBytes, KUser_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUser_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KUser_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUser_PythonToCpp_KUser_PTR,
        is_KUser_PythonToCpp_KUser_PTR_Convertible,
        KUser_PTR_CppToPython_KUser,
        KUser_COPY_CppToPython_KUser);

    Shiboken::Conversions::registerConverterName(converter, "KUser");
    Shiboken::Conversions::registerConverterName(converter, "KUser*");
    Shiboken::Conversions::registerConverterName(converter, "KUser&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUser).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KUser_PythonToCpp_KUser_COPY,
        is_KUser_PythonToCpp_KUser_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KUser_UIDMode_PythonToCpp_KUser,
        is_KUser_UIDMode_PythonToCpp_KUser_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KUser_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'UIDMode'.
    const char *UIDMode_Initializer[] = {
        "UseEffectiveUID",
        "UseRealUserID",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t UIDMode_InitializerValues[] = {
        uint8_t(KUser::UIDMode::UseEffectiveUID), //  0x00  0
        uint8_t(KUser::UIDMode::UseRealUserID)    //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KUser_TypeF(),
        "1:KCoreAddons.KUser.UIDMode",
        UIDMode_Initializer, UIDMode_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX].type = EType;
    // Register converter for enum 'KUser::UIDMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KUser_UIDMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KUser_UIDMode,
            is_Enum_PythonToCpp_KUser_UIDMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KUser::UIDMode");
        Shiboken::Conversions::registerConverterAlias(converter, "UIDMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'UIDMode' enum.

    // Initialization of enum 'UserProperty'.
    const char *UserProperty_Initializer[] = {
        "FullName",
        "RoomNumber",
        "WorkPhone",
        "HomePhone",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t UserProperty_InitializerValues[] = {
        uint8_t(KUser::UserProperty::FullName),   //  0x00  0
        uint8_t(KUser::UserProperty::RoomNumber), //  0x01  1
        uint8_t(KUser::UserProperty::WorkPhone),  //  0x02  2
        uint8_t(KUser::UserProperty::HomePhone)   //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KUser_TypeF(),
        "1:KCoreAddons.KUser.UserProperty",
        UserProperty_Initializer, UserProperty_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KUser_UserProperty_IDX].type = EType;
    // Register converter for enum 'KUser::UserProperty'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KUser_UserProperty_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KUser_UserProperty,
            is_Enum_PythonToCpp_KUser_UserProperty_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KUser::UserProperty");
        Shiboken::Conversions::registerConverterAlias(converter, "UserProperty");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'UserProperty' enum.

    qRegisterMetaType< ::KUser >("KUser");
    qRegisterMetaType< ::KUser::UIDMode >("KUser::UIDMode");
    qRegisterMetaType< ::KUser::UserProperty >("KUser::UserProperty");

    return pyType;
}
