
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kosrelease_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KOSRelease_Type = nullptr;
static PyTypeObject *Sbk_KOSRelease_TypeF(void)
{
    return _Sbk_KOSRelease_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KOSRelease_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KOSRelease >()))
        return -1;

    ::KOSRelease *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);

    if (PyArg_ParseTuple(args, "|O:KOSRelease", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KOSRelease::KOSRelease(const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // KOSRelease(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // KOSRelease(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"filePath", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KOSRelease(QString)
            cptr = new ::KOSRelease(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KOSRelease >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KOSReleaseFunc_ansiColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // ansiColor()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->ansiColor();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_bugReportUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bugReportUrl()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->bugReportUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_buildId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // buildId()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->buildId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_cpeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cpeName()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->cpeName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_documentationUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // documentationUrl()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->documentationUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_extraKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // extraKeys()const
        QStringList cppResult = const_cast<const ::KOSRelease *>(cppSelf)->extraKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_extraValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KOSRelease::extraValue(QString)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // extraValue(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "extraValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // extraValue(QString)const
            QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->extraValue(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_homeUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // homeUrl()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->homeUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_idLike(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // idLike()const
        QStringList cppResult = const_cast<const ::KOSRelease *>(cppSelf)->idLike();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_logo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // logo()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->logo();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_prettyName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // prettyName()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->prettyName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_privacyPolicyUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // privacyPolicyUrl()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->privacyPolicyUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_supportUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // supportUrl()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->supportUrl();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_variant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // variant()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->variant();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_variantId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // variantId()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->variantId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // version()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->version();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_versionCodename(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // versionCodename()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->versionCodename();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KOSReleaseFunc_versionId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KOSRelease *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // versionId()const
        QString cppResult = const_cast<const ::KOSRelease *>(cppSelf)->versionId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KOSRelease_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KOSRelease_methods[] = {
    {"ansiColor", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_ansiColor), METH_NOARGS, nullptr},
    {"bugReportUrl", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_bugReportUrl), METH_NOARGS, nullptr},
    {"buildId", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_buildId), METH_NOARGS, nullptr},
    {"cpeName", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_cpeName), METH_NOARGS, nullptr},
    {"documentationUrl", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_documentationUrl), METH_NOARGS, nullptr},
    {"extraKeys", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_extraKeys), METH_NOARGS, nullptr},
    {"extraValue", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_extraValue), METH_O, nullptr},
    {"homeUrl", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_homeUrl), METH_NOARGS, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_id), METH_NOARGS, nullptr},
    {"idLike", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_idLike), METH_NOARGS, nullptr},
    {"logo", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_logo), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_name), METH_NOARGS, nullptr},
    {"prettyName", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_prettyName), METH_NOARGS, nullptr},
    {"privacyPolicyUrl", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_privacyPolicyUrl), METH_NOARGS, nullptr},
    {"supportUrl", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_supportUrl), METH_NOARGS, nullptr},
    {"variant", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_variant), METH_NOARGS, nullptr},
    {"variantId", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_variantId), METH_NOARGS, nullptr},
    {"version", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_version), METH_NOARGS, nullptr},
    {"versionCodename", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_versionCodename), METH_NOARGS, nullptr},
    {"versionId", reinterpret_cast<PyCFunction>(Sbk_KOSReleaseFunc_versionId), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KOSRelease_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KOSRelease_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KOSRelease_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KOSRelease_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KOSRelease_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KOSRelease_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KOSRelease_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KOSRelease_spec = {
    "1:KCoreAddons.KOSRelease",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC,
    Sbk_KOSRelease_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KOSRelease_PythonToCpp_KOSRelease_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KOSRelease_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KOSRelease_PythonToCpp_KOSRelease_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KOSRelease_TypeF()))
        return KOSRelease_PythonToCpp_KOSRelease_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KOSRelease_PTR_CppToPython_KOSRelease(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KOSRelease_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KOSRelease_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KOSRelease_SignatureStrings[] = {
    "KCoreAddons.KOSRelease(self,filePath:QString=QString())",
    "KCoreAddons.KOSRelease.ansiColor(self)->QString",
    "KCoreAddons.KOSRelease.bugReportUrl(self)->QString",
    "KCoreAddons.KOSRelease.buildId(self)->QString",
    "KCoreAddons.KOSRelease.cpeName(self)->QString",
    "KCoreAddons.KOSRelease.documentationUrl(self)->QString",
    "KCoreAddons.KOSRelease.extraKeys(self)->QStringList",
    "KCoreAddons.KOSRelease.extraValue(self,key:QString)->QString",
    "KCoreAddons.KOSRelease.homeUrl(self)->QString",
    "KCoreAddons.KOSRelease.id(self)->QString",
    "KCoreAddons.KOSRelease.idLike(self)->QStringList",
    "KCoreAddons.KOSRelease.logo(self)->QString",
    "KCoreAddons.KOSRelease.name(self)->QString",
    "KCoreAddons.KOSRelease.prettyName(self)->QString",
    "KCoreAddons.KOSRelease.privacyPolicyUrl(self)->QString",
    "KCoreAddons.KOSRelease.supportUrl(self)->QString",
    "KCoreAddons.KOSRelease.variant(self)->QString",
    "KCoreAddons.KOSRelease.variantId(self)->QString",
    "KCoreAddons.KOSRelease.version(self)->QString",
    "KCoreAddons.KOSRelease.versionCodename(self)->QString",
    "KCoreAddons.KOSRelease.versionId(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KOSRelease_SignatureByteSize = 224;
static constexpr uint8_t KOSRelease_SignatureBytes[224] = {
    0x78, 0xda, 0x95, 0x92, 0x4d, 0x4f, 0xc3, 0x30, 0x0c, 0x86, 0xef, 0xfc, 0x92, 0x55, 0x62, 0xfb,
    0x01, 0x48, 0x20, 0xa1, 0x9e, 0x50, 0xa7, 0x31, 0x36, 0xc1, 0xdd, 0x34, 0x5e, 0x67, 0xcd, 0x8d,
    0x2b, 0xc7, 0xad, 0xc8, 0xbf, 0x67, 0x9a, 0xba, 0x0b, 0x9f, 0xce, 0x29, 0x97, 0xe7, 0x71, 0x9c,
    0x37, 0x6f, 0x53, 0x8b, 0xe2, 0x63, 0x08, 0x12, 0xd3, 0xaa, 0x79, 0xde, 0xef, 0x90, 0x11, 0x12,
    0x2e, 0x12, 0xf2, 0xe1, 0xf6, 0x40, 0x8c, 0x5b, 0xb0, 0xe3, 0xdd, 0xcb, 0xde, 0x94, 0x62, 0x77,
    0x3f, 0x9f, 0x8b, 0xaa, 0xba, 0x69, 0x7e, 0xf4, 0x56, 0x10, 0x13, 0xd5, 0xc2, 0xa2, 0x97, 0x09,
    0xd5, 0xf2, 0x61, 0x56, 0x7e, 0xe3, 0xdf, 0xc7, 0x6e, 0x87, 0x83, 0xa8, 0xbd, 0x2a, 0xbb, 0x15,
    0xe2, 0xf0, 0x14, 0x9c, 0x74, 0x3b, 0xe0, 0x06, 0x7a, 0x74, 0xd2, 0x41, 0xda, 0xb1, 0xc7, 0x68,
    0x60, 0x24, 0xd1, 0xbf, 0x12, 0x7e, 0x98, 0x42, 0x83, 0x39, 0x7d, 0xe1, 0xd7, 0x94, 0xec, 0x4f,
    0xe7, 0x0d, 0x78, 0x9c, 0xc3, 0x3e, 0x61, 0xbe, 0xe6, 0xfc, 0xff, 0x85, 0x47, 0xe9, 0xd1, 0xbf,
    0x1e, 0x05, 0x37, 0xb8, 0xa6, 0x13, 0x16, 0x3c, 0x82, 0xa5, 0x13, 0xe7, 0xec, 0xe8, 0xff, 0x85,
    0x41, 0xd1, 0x2c, 0x6f, 0x4a, 0x04, 0x9a, 0xa0, 0xcd, 0x5b, 0x61, 0x6a, 0xb3, 0x3f, 0x97, 0x34,
    0x0e, 0x65, 0xd5, 0x9b, 0x40, 0x09, 0xa2, 0x95, 0xd1, 0xee, 0xaa, 0x4e, 0xa8, 0xe9, 0x5c, 0xbb,
    0x32, 0xba, 0x96, 0x80, 0x05, 0xd1, 0xce, 0xd6, 0xf7, 0x9d, 0x3e, 0x01, 0x2a, 0xd9, 0x70, 0x9e
};
#endif

PyTypeObject *init_KOSRelease(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX].type;

    Shiboken::AutoDecRef Sbk_KOSRelease_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KOSRelease_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KOSRelease",
        "KOSRelease*",
        &Sbk_KOSRelease_spec,
        &Shiboken::callCppDestructor< ::KOSRelease >,
        Sbk_KOSRelease_Type_bases.object(),
        0);
    auto *pyType = Sbk_KOSRelease_TypeF(); // references _Sbk_KOSRelease_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KOSRelease_SignatureStrings);
#else
    InitSignatureBytes(pyType, KOSRelease_SignatureBytes, KOSRelease_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KOSRelease_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KOSRelease_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KOSRelease_PythonToCpp_KOSRelease_PTR,
        is_KOSRelease_PythonToCpp_KOSRelease_PTR_Convertible,
        KOSRelease_PTR_CppToPython_KOSRelease);

    Shiboken::Conversions::registerConverterName(converter, "KOSRelease");
    Shiboken::Conversions::registerConverterName(converter, "KOSRelease*");
    Shiboken::Conversions::registerConverterName(converter, "KOSRelease&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KOSRelease).name());

    qRegisterMetaType< ::KOSRelease *>();

    return pyType;
}
