
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "klistopenfilesjob_wrapper.h"

// Wrappers providing overrides
#include "kjob_wrapper.h"
#include "ksignalhandler_wrapper.h"
#include "kprocess_wrapper.h"
#include "kjobuidelegate_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kprocesslist.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KListOpenFilesJob_Type = nullptr;
static PyTypeObject *Sbk_KListOpenFilesJob_TypeF(void)
{
    return _Sbk_KListOpenFilesJob_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KListOpenFilesJobWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KListOpenFilesJobWrapper::KListOpenFilesJobWrapper(const ::QString & path) : KListOpenFilesJob(path)
{
}

void KListOpenFilesJobWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KListOpenFilesJob", funcName, gil, pyOverride, event);
}

void KListOpenFilesJobWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KListOpenFilesJob", funcName, gil, pyOverride, signal);
}

void KListOpenFilesJobWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KListOpenFilesJob", funcName, gil, pyOverride, event);
}

void KListOpenFilesJobWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KListOpenFilesJob", funcName, gil, pyOverride, signal);
}

bool KListOpenFilesJobWrapper::doKill()
{
    static const char *funcName = "doKill";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doKill();
    }
    return KProcessWrapper::sbk_o_atEnd("KListOpenFilesJob", funcName, gil, pyOverride);
}

bool KListOpenFilesJobWrapper::doResume()
{
    static const char *funcName = "doResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doResume();
    }
    return KProcessWrapper::sbk_o_atEnd("KListOpenFilesJob", funcName, gil, pyOverride);
}

bool KListOpenFilesJobWrapper::doSuspend()
{
    static const char *funcName = "doSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doSuspend();
    }
    return KProcessWrapper::sbk_o_atEnd("KListOpenFilesJob", funcName, gil, pyOverride);
}

::QString KListOpenFilesJobWrapper::errorString() const
{
    // This method belongs to a property.
    static const char *funcName = "1:errorString";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::errorString();
    }
    return KJobWrapper::sbk_o_errorString("KListOpenFilesJob", funcName, gil, pyOverride);
}

bool KListOpenFilesJobWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KListOpenFilesJob", funcName, gil, pyOverride, event);
}

bool KListOpenFilesJobWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KListOpenFilesJob", funcName, gil, pyOverride, watched, event);
}

void KListOpenFilesJobWrapper::start()
{
    static const char *funcName = "start";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KListOpenFilesJob::start();
    }
    KJobUiDelegateWrapper::sbk_o_showErrorMessage("KListOpenFilesJob", funcName, gil, pyOverride);
}

void KListOpenFilesJobWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KListOpenFilesJob_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KListOpenFilesJob", funcName, gil, pyOverride, event);
}

const QMetaObject *KListOpenFilesJobWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KListOpenFilesJob::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KListOpenFilesJobWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KListOpenFilesJob::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KListOpenFilesJobWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KListOpenFilesJobWrapper *>(this));
    }
    return KListOpenFilesJob::qt_metacast(_clname);
}

KListOpenFilesJobWrapper::~KListOpenFilesJobWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KListOpenFilesJob_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KListOpenFilesJob_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KListOpenFilesJob >()))
        return -1;

    KListOpenFilesJobWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KListOpenFilesJob", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KListOpenFilesJob::KListOpenFilesJob(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // KListOpenFilesJob(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KListOpenFilesJob(QString)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KListOpenFilesJobWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KListOpenFilesJobWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KListOpenFilesJob >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KListOpenFilesJobFunc_processInfoList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KListOpenFilesJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // processInfoList()const
        QList<KProcessList::KProcessInfo> cppResult = const_cast<const ::KListOpenFilesJob *>(cppSelf)->processInfoList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KListOpenFilesJobFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KListOpenFilesJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KListOpenFilesJob::start()
            : cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KListOpenFilesJob_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KListOpenFilesJob_EnumFlagInfo[] = {
    "Error:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KListOpenFilesJob_methods[] = {
    {"processInfoList", reinterpret_cast<PyCFunction>(Sbk_KListOpenFilesJobFunc_processInfoList), METH_NOARGS, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KListOpenFilesJobFunc_start), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KListOpenFilesJob_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KListOpenFilesJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KListOpenFilesJobWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KListOpenFilesJob_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KListOpenFilesJob_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KListOpenFilesJob_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KListOpenFilesJob_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KListOpenFilesJob_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KListOpenFilesJob_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KListOpenFilesJob_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KListOpenFilesJob_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KListOpenFilesJob_spec = {
    "1:KCoreAddons.KListOpenFilesJob",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KListOpenFilesJob_slots
};

} //extern "C"

static void *Sbk_KListOpenFilesJob_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KListOpenFilesJob *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KListOpenFilesJob_Error(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KListOpenFilesJob::Error>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KListOpenFilesJob::Error *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KListOpenFilesJob_Error_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_Error_IDX])))
        return Enum_PythonToCpp_KListOpenFilesJob_Error;
    return {};
}

static PyObject *KListOpenFilesJob_Error_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KListOpenFilesJob::Error>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KListOpenFilesJob::Error *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KListOpenFilesJob_PythonToCpp_KListOpenFilesJob_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KListOpenFilesJob_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KListOpenFilesJob_PythonToCpp_KListOpenFilesJob_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KListOpenFilesJob_TypeF()))
        return KListOpenFilesJob_PythonToCpp_KListOpenFilesJob_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KListOpenFilesJob_PTR_CppToPython_KListOpenFilesJob(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KListOpenFilesJob *>(const_cast<void *>(cppIn)), Sbk_KListOpenFilesJob_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KListOpenFilesJob_SignatureStrings[] = {
    "KCoreAddons.KListOpenFilesJob(self,path:QString)",
    "KCoreAddons.KListOpenFilesJob.processInfoList(self)->QList[KCoreAddons.KProcessList.KProcessInfo]",
    "KCoreAddons.KListOpenFilesJob.start(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KListOpenFilesJob_SignatureByteSize = 104;
static constexpr uint8_t KListOpenFilesJob_SignatureBytes[104] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0xf6,
    0xc9, 0x2c, 0x2e, 0xf1, 0x2f, 0x48, 0xcd, 0x73, 0xcb, 0xcc, 0x49, 0x2d, 0xf6, 0xca, 0x4f, 0xd2,
    0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0xc9, 0xb0, 0x0a, 0x0c, 0x2e, 0x29, 0xca, 0xcc,
    0x4b, 0xd7, 0xe4, 0xf2, 0xc6, 0xa7, 0x41, 0xaf, 0xa0, 0x28, 0x3f, 0x39, 0xb5, 0xb8, 0xd8, 0x33,
    0x2f, 0x2d, 0x1f, 0x24, 0x07, 0x36, 0x40, 0x53, 0xd7, 0x2e, 0x10, 0xc4, 0x89, 0x46, 0xd1, 0x1a,
    0x00, 0x51, 0x09, 0x92, 0x80, 0x73, 0x40, 0xda, 0x62, 0x09, 0xd8, 0x50, 0x5c, 0x92, 0x58, 0x04,
    0x35, 0x97, 0x0b, 0x00, 0xcd, 0x58, 0x45, 0x57
};
#endif

PyTypeObject *init_KListOpenFilesJob(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX].type;

    Shiboken::AutoDecRef Sbk_KListOpenFilesJob_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]))));

    _Sbk_KListOpenFilesJob_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KListOpenFilesJob",
        "KListOpenFilesJob*",
        &Sbk_KListOpenFilesJob_spec,
        &Shiboken::callCppDestructor< KListOpenFilesJob >,
        Sbk_KListOpenFilesJob_Type_bases.object(),
        0);
    auto *pyType = Sbk_KListOpenFilesJob_TypeF(); // references _Sbk_KListOpenFilesJob_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KListOpenFilesJob_SignatureStrings);
#else
    InitSignatureBytes(pyType, KListOpenFilesJob_SignatureBytes, KListOpenFilesJob_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KListOpenFilesJob_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KListOpenFilesJob_PythonToCpp_KListOpenFilesJob_PTR,
        is_KListOpenFilesJob_PythonToCpp_KListOpenFilesJob_PTR_Convertible,
        KListOpenFilesJob_PTR_CppToPython_KListOpenFilesJob);

    Shiboken::Conversions::registerConverterName(converter, "KListOpenFilesJob");
    Shiboken::Conversions::registerConverterName(converter, "KListOpenFilesJob*");
    Shiboken::Conversions::registerConverterName(converter, "KListOpenFilesJob&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KListOpenFilesJob).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KListOpenFilesJobWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KListOpenFilesJob_TypeF(), &Sbk_KListOpenFilesJob_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KListOpenFilesJob_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Error'.
    const char *Error_Initializer[] = {
        "NotSupported",
        "InternalError",
        "DoesNotExist",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t Error_InitializerValues[] = {
        int8_t(KListOpenFilesJob::Error::NotSupported),  //  0x65  101
        int8_t(KListOpenFilesJob::Error::InternalError), //  0x66  102
        int8_t(KListOpenFilesJob::Error::DoesNotExist)   //  0x6f  111
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KListOpenFilesJob_TypeF(),
        "1:KCoreAddons.KListOpenFilesJob.Error",
        Error_Initializer, Error_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KListOpenFilesJob_Error_IDX].type = EType;
    // Register converter for enum 'KListOpenFilesJob::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KListOpenFilesJob_Error_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KListOpenFilesJob_Error,
            is_Enum_PythonToCpp_KListOpenFilesJob_Error_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KListOpenFilesJob::Error");
        Shiboken::Conversions::registerConverterAlias(converter, "Error");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::KListOpenFilesJob::Error >("KListOpenFilesJob::Error");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KListOpenFilesJob::staticMetaObject, sizeof(KListOpenFilesJobWrapper));

    return pyType;
}
