
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kfileutils_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qurl.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFileUtils_Type = nullptr;
static PyTypeObject *Sbk_KFileUtils_TypeF(void)
{
    return _Sbk_KFileUtils_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KFileUtils_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KFileUtils");
    return -1;
}

static PyObject *Sbk_KFileUtilsFunc_findAllUniqueFiles(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "findAllUniqueFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OO:findAllUniqueFiles", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFileUtils::findAllUniqueFiles(QStringList,const QStringList&=)->QStringList
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // findAllUniqueFiles(QStringList,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            overloadId = 0; // findAllUniqueFiles(QStringList,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "findAllUniqueFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"nameFilters", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "findAllUniqueFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX]);
            }
        }
        ::QStringList cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1{};
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // findAllUniqueFiles(QStringList,QStringList)
            QStringList cppResult = ::KFileUtils::findAllUniqueFiles(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFileUtilsFunc_makeSuggestedName(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KFileUtils::makeSuggestedName(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // makeSuggestedName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "makeSuggestedName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // makeSuggestedName(QString)
            QString cppResult = ::KFileUtils::makeSuggestedName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFileUtilsFunc_suggestName(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "suggestName", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFileUtils::suggestName(QUrl,QString)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // suggestName(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "suggestName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // suggestName(QUrl,QString)
            QString cppResult = ::KFileUtils::suggestName(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KFileUtils_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFileUtils_methods[] = {
    {"findAllUniqueFiles", reinterpret_cast<PyCFunction>(Sbk_KFileUtilsFunc_findAllUniqueFiles), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"makeSuggestedName", reinterpret_cast<PyCFunction>(Sbk_KFileUtilsFunc_makeSuggestedName), METH_O|METH_STATIC, nullptr},
    {"suggestName", reinterpret_cast<PyCFunction>(Sbk_KFileUtilsFunc_suggestName), METH_VARARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFileUtils_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFileUtils_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFileUtils_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFileUtils_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFileUtils_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFileUtils_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFileUtils_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFileUtils_spec = {
    "1:KCoreAddons.KFileUtils",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFileUtils_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKFileUtils_SignatureStrings[] = {
    "KCoreAddons.KFileUtils.findAllUniqueFiles(dirs:QStringList,nameFilters:QStringList={})->QStringList",
    "KCoreAddons.KFileUtils.makeSuggestedName(oldName:QString)->QString",
    "KCoreAddons.KFileUtils.suggestName(baseURL:typing.Union[PySide6.QtCore.QUrl, QString],oldName:QString)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKFileUtils_SignatureByteSize = 163;
static constexpr uint8_t KCoreAddonsKFileUtils_SignatureBytes[163] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76,
    0xcb, 0xcc, 0x49, 0x0d, 0x2d, 0xc9, 0xcc, 0x29, 0xd6, 0x4b, 0xcb, 0xcc, 0x4b, 0x71, 0xcc, 0xc9,
    0x09, 0xcd, 0xcb, 0x2c, 0x2c, 0x4d, 0x05, 0x09, 0x17, 0x6b, 0xa4, 0x64, 0x16, 0x15, 0x5b, 0x05,
    0x06, 0x97, 0x14, 0x65, 0xe6, 0xa5, 0xfb, 0x64, 0x16, 0x97, 0xe8, 0xe4, 0x25, 0xe6, 0x82, 0xa4,
    0x4a, 0x52, 0x51, 0xc5, 0x6d, 0xab, 0x6b, 0x35, 0x75, 0xed, 0x90, 0x04, 0xb8, 0xbc, 0xb1, 0xdb,
    0x91, 0x9b, 0x98, 0x9d, 0x1a, 0x5c, 0x9a, 0x9e, 0x9e, 0x5a, 0x5c, 0x92, 0x9a, 0xe2, 0x07, 0x34,
    0x4c, 0x23, 0x3f, 0x07, 0x4c, 0xc3, 0x4c, 0x43, 0x18, 0x83, 0xcb, 0x88, 0x62, 0x88, 0x76, 0xb0,
    0xe6, 0xa4, 0xc4, 0xe2, 0xd4, 0xd0, 0x20, 0x1f, 0xab, 0x92, 0xca, 0x02, 0xa0, 0x0e, 0x3d, 0xa0,
    0xd3, 0xf3, 0xf3, 0xa2, 0x03, 0x2a, 0x83, 0x33, 0x53, 0x52, 0xcd, 0xf4, 0x02, 0x4b, 0x40, 0x06,
    0xe8, 0x05, 0x86, 0x16, 0xe5, 0xe8, 0x28, 0x40, 0x0d, 0x8d, 0xd5, 0xc1, 0x6d, 0x1f, 0x00, 0xc3,
    0xd2, 0x66, 0x78
};
#endif

PyTypeObject *init_KCoreAddonsKFileUtils(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX].type;

    Shiboken::AutoDecRef Sbk_KFileUtils_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFileUtils_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFileUtils",
        "KFileUtils",
        &Sbk_KFileUtils_spec,
        nullptr,
        Sbk_KFileUtils_Type_bases.object(),
        0);
    auto *pyType = Sbk_KFileUtils_TypeF(); // references _Sbk_KFileUtils_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKFileUtils_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKFileUtils_SignatureBytes, KCoreAddonsKFileUtils_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFileUtils_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileUtils_IDX].type = pyType;



    return pyType;
}
