#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 833
#define LARGE_STATE_COUNT 9
#define SYMBOL_COUNT 151
#define ALIAS_COUNT 4
#define TOKEN_COUNT 79
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 19

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_module = 2,
  anon_sym_EQ = 3,
  anon_sym_import = 4,
  anon_sym_provider = 5,
  anon_sym_as = 6,
  anon_sym_with = 7,
  anon_sym_LBRACE = 8,
  anon_sym_COMMA = 9,
  anon_sym_RBRACE = 10,
  anon_sym_STAR = 11,
  anon_sym_from = 12,
  anon_sym_using = 13,
  anon_sym_targetScope = 14,
  anon_sym_metadata = 15,
  anon_sym_output = 16,
  anon_sym_param = 17,
  anon_sym_resource = 18,
  anon_sym_existing = 19,
  anon_sym_type = 20,
  anon_sym_var = 21,
  anon_sym_BANG = 22,
  anon_sym_func = 23,
  anon_sym_EQ_GT = 24,
  anon_sym_test = 25,
  anon_sym_assert = 26,
  anon_sym_LPAREN = 27,
  anon_sym_RPAREN = 28,
  anon_sym_AT = 29,
  anon_sym_LBRACK = 30,
  anon_sym_RBRACK = 31,
  anon_sym_COLON = 32,
  anon_sym_if = 33,
  anon_sym_for = 34,
  anon_sym_in = 35,
  anon_sym_DOT = 36,
  anon_sym_DOT_QMARK = 37,
  anon_sym_QMARK = 38,
  anon_sym_COLON_COLON = 39,
  anon_sym_PLUS = 40,
  anon_sym_DASH = 41,
  anon_sym_SLASH = 42,
  anon_sym_PERCENT = 43,
  anon_sym_PIPE_PIPE = 44,
  anon_sym_AMP_AMP = 45,
  anon_sym_PIPE = 46,
  anon_sym_EQ_EQ = 47,
  anon_sym_BANG_EQ = 48,
  anon_sym_EQ_TILDE = 49,
  anon_sym_BANG_TILDE = 50,
  anon_sym_GT = 51,
  anon_sym_GT_EQ = 52,
  anon_sym_LT_EQ = 53,
  anon_sym_LT = 54,
  anon_sym_QMARK_QMARK = 55,
  sym_number = 56,
  anon_sym_true = 57,
  anon_sym_false = 58,
  sym_null = 59,
  anon_sym_SQUOTE = 60,
  anon_sym_DOLLAR = 61,
  anon_sym_POUND = 62,
  sym_string_content = 63,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 64,
  aux_sym__escape_sequence_token1 = 65,
  sym_escape_sequence = 66,
  anon_sym_DOLLAR_LBRACE = 67,
  anon_sym_array = 68,
  anon_sym_bool = 69,
  anon_sym_int = 70,
  anon_sym_object = 71,
  anon_sym_secureObject = 72,
  anon_sym_secureString = 73,
  anon_sym_string = 74,
  sym_comment = 75,
  sym_diagnostic_comment = 76,
  sym__external_asterisk = 77,
  sym__multiline_string_content = 78,
  sym_infrastructure = 79,
  sym_statement = 80,
  sym_declaration = 81,
  sym_module_declaration = 82,
  sym_import_statement = 83,
  sym_import_with_statement = 84,
  sym_import_functionality = 85,
  sym_using_statement = 86,
  sym_target_scope_assignment = 87,
  sym_metadata_declaration = 88,
  sym_output_declaration = 89,
  sym_parameter_declaration = 90,
  sym_resource_declaration = 91,
  sym_type_declaration = 92,
  sym_variable_declaration = 93,
  sym_user_defined_function = 94,
  sym_test_block = 95,
  sym_assert_statement = 96,
  sym_parameters = 97,
  sym_parameter = 98,
  sym_expression = 99,
  sym_primary_expression = 100,
  sym_call_expression = 101,
  sym_lambda_expression = 102,
  sym_arguments = 103,
  sym_parenthesized_expression = 104,
  sym_decorator = 105,
  sym_decorators = 106,
  sym_array = 107,
  sym_object = 108,
  sym_object_property = 109,
  sym_if_statement = 110,
  sym__lhs_expression = 111,
  sym_assignment_expression = 112,
  sym_for_statement = 113,
  sym_for_loop_parameters = 114,
  sym_member_expression = 115,
  sym_subscript_expression = 116,
  sym_resource_expression = 117,
  sym_ternary_expression = 118,
  sym_binary_expression = 119,
  sym_unary_expression = 120,
  sym__literal = 121,
  sym_boolean = 122,
  sym_string = 123,
  sym__string_literal = 124,
  sym__multiline_string_literal = 125,
  sym_multiline_string_content = 126,
  sym__escape_sequence = 127,
  sym_interpolation = 128,
  sym_compatible_identifier = 129,
  sym_type = 130,
  sym__type_not_union = 131,
  sym_primitive_type = 132,
  sym_array_type = 133,
  sym_nullable_type = 134,
  sym_negated_type = 135,
  sym_union_type = 136,
  sym_parenthesized_type = 137,
  sym_parameterized_type = 138,
  sym_type_arguments = 139,
  aux_sym_infrastructure_repeat1 = 140,
  aux_sym_import_functionality_repeat1 = 141,
  aux_sym_parameters_repeat1 = 142,
  aux_sym_arguments_repeat1 = 143,
  aux_sym_decorators_repeat1 = 144,
  aux_sym_array_repeat1 = 145,
  aux_sym_object_repeat1 = 146,
  aux_sym__string_literal_repeat1 = 147,
  aux_sym_multiline_string_content_repeat1 = 148,
  aux_sym_union_type_repeat1 = 149,
  aux_sym_type_arguments_repeat1 = 150,
  alias_sym_loop_enumerator = 151,
  alias_sym_loop_variable = 152,
  alias_sym_nullable_return_type = 153,
  alias_sym_property_identifier = 154,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_module] = "module",
  [anon_sym_EQ] = "=",
  [anon_sym_import] = "import",
  [anon_sym_provider] = "provider",
  [anon_sym_as] = "as",
  [anon_sym_with] = "with",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_STAR] = "*",
  [anon_sym_from] = "from",
  [anon_sym_using] = "using",
  [anon_sym_targetScope] = "targetScope",
  [anon_sym_metadata] = "metadata",
  [anon_sym_output] = "output",
  [anon_sym_param] = "param",
  [anon_sym_resource] = "resource",
  [anon_sym_existing] = "existing",
  [anon_sym_type] = "type",
  [anon_sym_var] = "var",
  [anon_sym_BANG] = "!",
  [anon_sym_func] = "func",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_test] = "test",
  [anon_sym_assert] = "assert",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_QMARK] = ".\?",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_null] = "null",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLAR] = "string_content",
  [anon_sym_POUND] = "string_content",
  [sym_string_content] = "string_content",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_array] = "array",
  [anon_sym_bool] = "bool",
  [anon_sym_int] = "int",
  [anon_sym_object] = "object",
  [anon_sym_secureObject] = "secureObject",
  [anon_sym_secureString] = "secureString",
  [anon_sym_string] = "string",
  [sym_comment] = "comment",
  [sym_diagnostic_comment] = "diagnostic_comment",
  [sym__external_asterisk] = "*",
  [sym__multiline_string_content] = "_multiline_string_content",
  [sym_infrastructure] = "infrastructure",
  [sym_statement] = "statement",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_import_statement] = "import_statement",
  [sym_import_with_statement] = "import_with_statement",
  [sym_import_functionality] = "import_functionality",
  [sym_using_statement] = "using_statement",
  [sym_target_scope_assignment] = "target_scope_assignment",
  [sym_metadata_declaration] = "metadata_declaration",
  [sym_output_declaration] = "output_declaration",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_resource_declaration] = "resource_declaration",
  [sym_type_declaration] = "type_declaration",
  [sym_variable_declaration] = "variable_declaration",
  [sym_user_defined_function] = "user_defined_function",
  [sym_test_block] = "test_block",
  [sym_assert_statement] = "assert_statement",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_call_expression] = "call_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_arguments] = "arguments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_decorator] = "decorator",
  [sym_decorators] = "decorators",
  [sym_array] = "array",
  [sym_object] = "object",
  [sym_object_property] = "object_property",
  [sym_if_statement] = "if_statement",
  [sym__lhs_expression] = "_lhs_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_for_statement] = "for_statement",
  [sym_for_loop_parameters] = "for_loop_parameters",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_resource_expression] = "resource_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym__literal] = "_literal",
  [sym_boolean] = "boolean",
  [sym_string] = "string",
  [sym__string_literal] = "_string_literal",
  [sym__multiline_string_literal] = "_multiline_string_literal",
  [sym_multiline_string_content] = "string_content",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_interpolation] = "interpolation",
  [sym_compatible_identifier] = "compatible_identifier",
  [sym_type] = "type",
  [sym__type_not_union] = "_type_not_union",
  [sym_primitive_type] = "primitive_type",
  [sym_array_type] = "array_type",
  [sym_nullable_type] = "nullable_type",
  [sym_negated_type] = "negated_type",
  [sym_union_type] = "union_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_parameterized_type] = "parameterized_type",
  [sym_type_arguments] = "type_arguments",
  [aux_sym_infrastructure_repeat1] = "infrastructure_repeat1",
  [aux_sym_import_functionality_repeat1] = "import_functionality_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_decorators_repeat1] = "decorators_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym__string_literal_repeat1] = "_string_literal_repeat1",
  [aux_sym_multiline_string_content_repeat1] = "multiline_string_content_repeat1",
  [aux_sym_union_type_repeat1] = "union_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [alias_sym_loop_enumerator] = "loop_enumerator",
  [alias_sym_loop_variable] = "loop_variable",
  [alias_sym_nullable_return_type] = "nullable_return_type",
  [alias_sym_property_identifier] = "property_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_provider] = anon_sym_provider,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_targetScope] = anon_sym_targetScope,
  [anon_sym_metadata] = anon_sym_metadata,
  [anon_sym_output] = anon_sym_output,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_resource] = anon_sym_resource,
  [anon_sym_existing] = anon_sym_existing,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_test] = anon_sym_test,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_QMARK] = anon_sym_DOT_QMARK,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_null] = sym_null,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLAR] = sym_string_content,
  [anon_sym_POUND] = sym_string_content,
  [sym_string_content] = sym_string_content,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_array] = anon_sym_array,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_secureObject] = anon_sym_secureObject,
  [anon_sym_secureString] = anon_sym_secureString,
  [anon_sym_string] = anon_sym_string,
  [sym_comment] = sym_comment,
  [sym_diagnostic_comment] = sym_diagnostic_comment,
  [sym__external_asterisk] = anon_sym_STAR,
  [sym__multiline_string_content] = sym__multiline_string_content,
  [sym_infrastructure] = sym_infrastructure,
  [sym_statement] = sym_statement,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_import_statement] = sym_import_statement,
  [sym_import_with_statement] = sym_import_with_statement,
  [sym_import_functionality] = sym_import_functionality,
  [sym_using_statement] = sym_using_statement,
  [sym_target_scope_assignment] = sym_target_scope_assignment,
  [sym_metadata_declaration] = sym_metadata_declaration,
  [sym_output_declaration] = sym_output_declaration,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_resource_declaration] = sym_resource_declaration,
  [sym_type_declaration] = sym_type_declaration,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_user_defined_function] = sym_user_defined_function,
  [sym_test_block] = sym_test_block,
  [sym_assert_statement] = sym_assert_statement,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_decorator] = sym_decorator,
  [sym_decorators] = sym_decorators,
  [sym_array] = sym_array,
  [sym_object] = sym_object,
  [sym_object_property] = sym_object_property,
  [sym_if_statement] = sym_if_statement,
  [sym__lhs_expression] = sym__lhs_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_for_statement] = sym_for_statement,
  [sym_for_loop_parameters] = sym_for_loop_parameters,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_resource_expression] = sym_resource_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym__literal] = sym__literal,
  [sym_boolean] = sym_boolean,
  [sym_string] = sym_string,
  [sym__string_literal] = sym__string_literal,
  [sym__multiline_string_literal] = sym__multiline_string_literal,
  [sym_multiline_string_content] = sym_string_content,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_interpolation] = sym_interpolation,
  [sym_compatible_identifier] = sym_compatible_identifier,
  [sym_type] = sym_type,
  [sym__type_not_union] = sym__type_not_union,
  [sym_primitive_type] = sym_primitive_type,
  [sym_array_type] = sym_array_type,
  [sym_nullable_type] = sym_nullable_type,
  [sym_negated_type] = sym_negated_type,
  [sym_union_type] = sym_union_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_parameterized_type] = sym_parameterized_type,
  [sym_type_arguments] = sym_type_arguments,
  [aux_sym_infrastructure_repeat1] = aux_sym_infrastructure_repeat1,
  [aux_sym_import_functionality_repeat1] = aux_sym_import_functionality_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_decorators_repeat1] = aux_sym_decorators_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym__string_literal_repeat1] = aux_sym__string_literal_repeat1,
  [aux_sym_multiline_string_content_repeat1] = aux_sym_multiline_string_content_repeat1,
  [aux_sym_union_type_repeat1] = aux_sym_union_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [alias_sym_loop_enumerator] = alias_sym_loop_enumerator,
  [alias_sym_loop_variable] = alias_sym_loop_variable,
  [alias_sym_nullable_return_type] = alias_sym_nullable_return_type,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provider] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_targetScope] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_metadata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_output] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_resource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_existing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_test] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_secureObject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_secureString] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_diagnostic_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__external_asterisk] = {
    .visible = true,
    .named = false,
  },
  [sym__multiline_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_infrastructure] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_functionality] = {
    .visible = true,
    .named = true,
  },
  [sym_using_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_target_scope_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_output_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_user_defined_function] = {
    .visible = true,
    .named = true,
  },
  [sym_test_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorators] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_property] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__lhs_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_multiline_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_compatible_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type_not_union] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_nullable_type] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parameterized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_infrastructure_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_functionality_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multiline_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_loop_enumerator] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_loop_variable] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_nullable_return_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_function = 7,
  field_index = 8,
  field_initializer = 9,
  field_left = 10,
  field_name = 11,
  field_object = 12,
  field_operator = 13,
  field_property = 14,
  field_resource = 15,
  field_returns = 16,
  field_right = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_property] = "property",
  [field_resource] = "resource",
  [field_returns] = "returns",
  [field_right] = "right",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 2},
  [7] = {.index = 10, .length = 2},
  [8] = {.index = 2, .length = 2},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 2},
  [12] = {.index = 18, .length = 2},
  [13] = {.index = 20, .length = 2},
  [14] = {.index = 22, .length = 3},
  [16] = {.index = 25, .length = 1},
  [17] = {.index = 26, .length = 2},
  [18] = {.index = 28, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 1},
    {field_operator, 0},
  [2] =
    {field_arguments, 1},
    {field_function, 0},
  [4] =
    {field_name, 1},
  [5] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [8] =
    {field_object, 0},
    {field_property, 2},
  [10] =
    {field_object, 0},
    {field_resource, 2},
  [12] =
    {field_left, 0},
    {field_right, 2},
  [14] =
    {field_object, 0},
    {field_property, 3},
  [16] =
    {field_index, 2},
    {field_object, 0},
  [18] =
    {field_name, 1},
    {field_returns, 3},
  [20] =
    {field_index, 3},
    {field_object, 0},
  [22] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [25] =
    {field_body, 5},
  [26] =
    {field_body, 6},
    {field_initializer, 2},
  [28] =
    {field_body, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [6] = {
    [2] = alias_sym_property_identifier,
  },
  [8] = {
    [2] = alias_sym_nullable_return_type,
  },
  [10] = {
    [3] = alias_sym_property_identifier,
  },
  [15] = {
    [1] = alias_sym_loop_variable,
    [3] = alias_sym_loop_enumerator,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 5,
  [6] = 3,
  [7] = 2,
  [8] = 3,
  [9] = 9,
  [10] = 9,
  [11] = 9,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 14,
  [17] = 14,
  [18] = 12,
  [19] = 14,
  [20] = 12,
  [21] = 15,
  [22] = 12,
  [23] = 15,
  [24] = 24,
  [25] = 25,
  [26] = 14,
  [27] = 14,
  [28] = 15,
  [29] = 14,
  [30] = 12,
  [31] = 15,
  [32] = 12,
  [33] = 14,
  [34] = 34,
  [35] = 14,
  [36] = 12,
  [37] = 15,
  [38] = 14,
  [39] = 12,
  [40] = 14,
  [41] = 14,
  [42] = 15,
  [43] = 12,
  [44] = 12,
  [45] = 15,
  [46] = 12,
  [47] = 12,
  [48] = 48,
  [49] = 49,
  [50] = 12,
  [51] = 12,
  [52] = 12,
  [53] = 53,
  [54] = 54,
  [55] = 54,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 59,
  [61] = 57,
  [62] = 57,
  [63] = 59,
  [64] = 64,
  [65] = 64,
  [66] = 64,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 68,
  [71] = 54,
  [72] = 69,
  [73] = 67,
  [74] = 68,
  [75] = 69,
  [76] = 67,
  [77] = 54,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 54,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 114,
  [121] = 116,
  [122] = 119,
  [123] = 114,
  [124] = 119,
  [125] = 116,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 116,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 119,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 114,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 152,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 154,
  [158] = 156,
  [159] = 156,
  [160] = 154,
  [161] = 152,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 163,
  [167] = 162,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 170,
  [174] = 174,
  [175] = 169,
  [176] = 176,
  [177] = 168,
  [178] = 178,
  [179] = 179,
  [180] = 171,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 178,
  [186] = 186,
  [187] = 187,
  [188] = 186,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 164,
  [197] = 197,
  [198] = 190,
  [199] = 199,
  [200] = 182,
  [201] = 171,
  [202] = 192,
  [203] = 203,
  [204] = 204,
  [205] = 182,
  [206] = 174,
  [207] = 199,
  [208] = 194,
  [209] = 193,
  [210] = 193,
  [211] = 192,
  [212] = 174,
  [213] = 190,
  [214] = 186,
  [215] = 170,
  [216] = 178,
  [217] = 163,
  [218] = 169,
  [219] = 168,
  [220] = 194,
  [221] = 162,
  [222] = 168,
  [223] = 163,
  [224] = 169,
  [225] = 171,
  [226] = 170,
  [227] = 181,
  [228] = 162,
  [229] = 178,
  [230] = 186,
  [231] = 190,
  [232] = 192,
  [233] = 193,
  [234] = 194,
  [235] = 181,
  [236] = 182,
  [237] = 199,
  [238] = 187,
  [239] = 239,
  [240] = 204,
  [241] = 241,
  [242] = 242,
  [243] = 187,
  [244] = 244,
  [245] = 239,
  [246] = 204,
  [247] = 247,
  [248] = 187,
  [249] = 249,
  [250] = 204,
  [251] = 251,
  [252] = 239,
  [253] = 239,
  [254] = 254,
  [255] = 101,
  [256] = 94,
  [257] = 106,
  [258] = 148,
  [259] = 138,
  [260] = 107,
  [261] = 137,
  [262] = 94,
  [263] = 85,
  [264] = 84,
  [265] = 83,
  [266] = 96,
  [267] = 82,
  [268] = 100,
  [269] = 89,
  [270] = 102,
  [271] = 80,
  [272] = 103,
  [273] = 273,
  [274] = 104,
  [275] = 105,
  [276] = 108,
  [277] = 273,
  [278] = 273,
  [279] = 79,
  [280] = 87,
  [281] = 128,
  [282] = 97,
  [283] = 95,
  [284] = 86,
  [285] = 98,
  [286] = 254,
  [287] = 99,
  [288] = 111,
  [289] = 117,
  [290] = 151,
  [291] = 291,
  [292] = 137,
  [293] = 149,
  [294] = 138,
  [295] = 295,
  [296] = 296,
  [297] = 148,
  [298] = 132,
  [299] = 147,
  [300] = 112,
  [301] = 296,
  [302] = 141,
  [303] = 129,
  [304] = 128,
  [305] = 134,
  [306] = 85,
  [307] = 295,
  [308] = 126,
  [309] = 94,
  [310] = 127,
  [311] = 131,
  [312] = 89,
  [313] = 113,
  [314] = 130,
  [315] = 82,
  [316] = 118,
  [317] = 139,
  [318] = 143,
  [319] = 102,
  [320] = 100,
  [321] = 136,
  [322] = 142,
  [323] = 291,
  [324] = 146,
  [325] = 150,
  [326] = 133,
  [327] = 108,
  [328] = 99,
  [329] = 104,
  [330] = 105,
  [331] = 106,
  [332] = 136,
  [333] = 96,
  [334] = 80,
  [335] = 126,
  [336] = 142,
  [337] = 103,
  [338] = 132,
  [339] = 147,
  [340] = 101,
  [341] = 143,
  [342] = 117,
  [343] = 133,
  [344] = 107,
  [345] = 118,
  [346] = 113,
  [347] = 131,
  [348] = 86,
  [349] = 111,
  [350] = 127,
  [351] = 95,
  [352] = 150,
  [353] = 141,
  [354] = 87,
  [355] = 134,
  [356] = 97,
  [357] = 112,
  [358] = 130,
  [359] = 98,
  [360] = 129,
  [361] = 139,
  [362] = 151,
  [363] = 83,
  [364] = 149,
  [365] = 146,
  [366] = 84,
  [367] = 79,
  [368] = 172,
  [369] = 164,
  [370] = 251,
  [371] = 241,
  [372] = 291,
  [373] = 254,
  [374] = 254,
  [375] = 251,
  [376] = 291,
  [377] = 296,
  [378] = 295,
  [379] = 164,
  [380] = 273,
  [381] = 251,
  [382] = 273,
  [383] = 295,
  [384] = 291,
  [385] = 296,
  [386] = 87,
  [387] = 104,
  [388] = 105,
  [389] = 164,
  [390] = 241,
  [391] = 96,
  [392] = 392,
  [393] = 393,
  [394] = 101,
  [395] = 86,
  [396] = 103,
  [397] = 99,
  [398] = 95,
  [399] = 108,
  [400] = 273,
  [401] = 254,
  [402] = 273,
  [403] = 403,
  [404] = 254,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 98,
  [410] = 97,
  [411] = 411,
  [412] = 254,
  [413] = 273,
  [414] = 79,
  [415] = 172,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 419,
  [422] = 422,
  [423] = 419,
  [424] = 418,
  [425] = 418,
  [426] = 419,
  [427] = 427,
  [428] = 427,
  [429] = 427,
  [430] = 418,
  [431] = 427,
  [432] = 422,
  [433] = 422,
  [434] = 422,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 438,
  [440] = 435,
  [441] = 436,
  [442] = 437,
  [443] = 435,
  [444] = 437,
  [445] = 436,
  [446] = 446,
  [447] = 436,
  [448] = 437,
  [449] = 438,
  [450] = 435,
  [451] = 438,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 455,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 164,
  [465] = 241,
  [466] = 466,
  [467] = 467,
  [468] = 466,
  [469] = 459,
  [470] = 164,
  [471] = 251,
  [472] = 459,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 466,
  [477] = 254,
  [478] = 273,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 164,
  [483] = 483,
  [484] = 273,
  [485] = 485,
  [486] = 254,
  [487] = 241,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 296,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 494,
  [498] = 498,
  [499] = 490,
  [500] = 493,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 494,
  [510] = 493,
  [511] = 291,
  [512] = 512,
  [513] = 508,
  [514] = 492,
  [515] = 507,
  [516] = 506,
  [517] = 512,
  [518] = 493,
  [519] = 492,
  [520] = 506,
  [521] = 505,
  [522] = 512,
  [523] = 490,
  [524] = 524,
  [525] = 503,
  [526] = 295,
  [527] = 527,
  [528] = 164,
  [529] = 241,
  [530] = 530,
  [531] = 505,
  [532] = 505,
  [533] = 496,
  [534] = 492,
  [535] = 506,
  [536] = 507,
  [537] = 508,
  [538] = 507,
  [539] = 496,
  [540] = 508,
  [541] = 241,
  [542] = 512,
  [543] = 494,
  [544] = 503,
  [545] = 496,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 254,
  [552] = 273,
  [553] = 553,
  [554] = 553,
  [555] = 555,
  [556] = 553,
  [557] = 461,
  [558] = 467,
  [559] = 296,
  [560] = 462,
  [561] = 295,
  [562] = 562,
  [563] = 291,
  [564] = 463,
  [565] = 475,
  [566] = 566,
  [567] = 139,
  [568] = 481,
  [569] = 569,
  [570] = 570,
  [571] = 131,
  [572] = 479,
  [573] = 573,
  [574] = 574,
  [575] = 133,
  [576] = 117,
  [577] = 142,
  [578] = 578,
  [579] = 111,
  [580] = 580,
  [581] = 446,
  [582] = 489,
  [583] = 485,
  [584] = 452,
  [585] = 132,
  [586] = 130,
  [587] = 502,
  [588] = 549,
  [589] = 555,
  [590] = 550,
  [591] = 548,
  [592] = 592,
  [593] = 530,
  [594] = 498,
  [595] = 501,
  [596] = 530,
  [597] = 504,
  [598] = 598,
  [599] = 501,
  [600] = 530,
  [601] = 498,
  [602] = 504,
  [603] = 446,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 452,
  [609] = 573,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 574,
  [617] = 617,
  [618] = 578,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 626,
  [628] = 626,
  [629] = 625,
  [630] = 630,
  [631] = 625,
  [632] = 625,
  [633] = 626,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 636,
  [638] = 638,
  [639] = 639,
  [640] = 639,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 530,
  [647] = 530,
  [648] = 648,
  [649] = 648,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 641,
  [656] = 504,
  [657] = 501,
  [658] = 462,
  [659] = 659,
  [660] = 498,
  [661] = 501,
  [662] = 662,
  [663] = 498,
  [664] = 501,
  [665] = 504,
  [666] = 530,
  [667] = 530,
  [668] = 668,
  [669] = 498,
  [670] = 530,
  [671] = 501,
  [672] = 530,
  [673] = 504,
  [674] = 504,
  [675] = 530,
  [676] = 498,
  [677] = 530,
  [678] = 662,
  [679] = 662,
  [680] = 662,
  [681] = 489,
  [682] = 682,
  [683] = 504,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 501,
  [690] = 498,
  [691] = 684,
  [692] = 692,
  [693] = 686,
  [694] = 686,
  [695] = 695,
  [696] = 696,
  [697] = 682,
  [698] = 530,
  [699] = 682,
  [700] = 700,
  [701] = 701,
  [702] = 696,
  [703] = 703,
  [704] = 704,
  [705] = 704,
  [706] = 706,
  [707] = 707,
  [708] = 530,
  [709] = 709,
  [710] = 530,
  [711] = 692,
  [712] = 712,
  [713] = 713,
  [714] = 704,
  [715] = 696,
  [716] = 682,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 128,
  [727] = 727,
  [728] = 148,
  [729] = 729,
  [730] = 730,
  [731] = 722,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 730,
  [736] = 736,
  [737] = 730,
  [738] = 733,
  [739] = 723,
  [740] = 740,
  [741] = 137,
  [742] = 742,
  [743] = 743,
  [744] = 721,
  [745] = 138,
  [746] = 740,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 753,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 751,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 755,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 776,
  [778] = 764,
  [779] = 779,
  [780] = 755,
  [781] = 781,
  [782] = 782,
  [783] = 748,
  [784] = 768,
  [785] = 776,
  [786] = 753,
  [787] = 763,
  [788] = 770,
  [789] = 789,
  [790] = 790,
  [791] = 748,
  [792] = 768,
  [793] = 793,
  [794] = 794,
  [795] = 750,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 754,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 768,
  [809] = 758,
  [810] = 810,
  [811] = 776,
  [812] = 748,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 758,
  [822] = 754,
  [823] = 753,
  [824] = 769,
  [825] = 759,
  [826] = 761,
  [827] = 750,
  [828] = 769,
  [829] = 759,
  [830] = 755,
  [831] = 769,
  [832] = 759,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 130,
        '#', 173,
        '$', 172,
        '%', 154,
        '&', 8,
        '\'', 171,
        '(', 138,
        ')', 139,
        '*', 112,
        '+', 150,
        ',', 109,
        '-', 152,
        '.', 145,
        '/', 153,
        ':', 144,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        '\\', 76,
        ']', 142,
        'a', 232,
        'f', 246,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 190,
        'u', 233,
        'v', 191,
        '{', 108,
        '|', 158,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(89);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 1:
      if (lookahead == '\r') ADVANCE(257);
      if (lookahead != 0) ADVANCE(256);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 130,
        '#', 258,
        '%', 154,
        '&', 8,
        '\'', 171,
        '(', 138,
        '*', 112,
        '+', 150,
        ',', 109,
        '-', 152,
        '.', 145,
        '/', 153,
        ':', 13,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        ']', 142,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 252,
        'v', 191,
        '{', 108,
        '|', 158,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 130,
        '#', 258,
        '%', 154,
        '&', 8,
        '\'', 171,
        '(', 138,
        '*', 112,
        '+', 150,
        ',', 109,
        '-', 151,
        '.', 145,
        '/', 153,
        ':', 13,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 252,
        'v', 191,
        '|', 158,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 129,
        '#', 258,
        '\'', 171,
        '(', 138,
        ')', 139,
        ',', 109,
        '-', 152,
        '.', 145,
        '/', 10,
        '=', 100,
        '>', 163,
        '?', 147,
        '@', 140,
        '[', 141,
        ']', 142,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 252,
        'v', 191,
        '{', 108,
        '|', 157,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      if (lookahead == '*' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(173);
      if (lookahead == '$') ADVANCE(172);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead == '\\') ADVANCE(76);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(174);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '#', 258,
        '(', 138,
        ')', 139,
        '/', 10,
        ':', 143,
        '=', 98,
        '?', 147,
        '[', 141,
        '{', 108,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (lookahead == '*' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == ',') ADVANCE(109);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == 'a') ADVANCE(63);
      if (lookahead == '}') ADVANCE(110);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '&') ADVANCE(156);
      END_STATE();
    case 9:
      if (lookahead == '\'') ADVANCE(179);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(256);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(254);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == ':') ADVANCE(149);
      END_STATE();
    case 14:
      if (lookahead == 'S') ADVANCE(23);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(26);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(51);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(31);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(78);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(21);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(36);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 37:
      if (lookahead == 'g') ADVANCE(113);
      END_STATE();
    case 38:
      if (lookahead == 'g') ADVANCE(35);
      END_STATE();
    case 39:
      if (lookahead == 'i') ADVANCE(45);
      END_STATE();
    case 40:
      if (lookahead == 'i') ADVANCE(27);
      END_STATE();
    case 41:
      if (lookahead == 'l') ADVANCE(30);
      END_STATE();
    case 42:
      if (lookahead == 'm') ADVANCE(50);
      END_STATE();
    case 43:
      if (lookahead == 'm') ADVANCE(121);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 47:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(48);
      END_STATE();
    case 51:
      if (lookahead == 'p') ADVANCE(29);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(32);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(80);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(17);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(69);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(107);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 66:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(14);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(18);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(16);
      END_STATE();
    case 76:
      if (lookahead == 'u') ADVANCE(83);
      if (lookahead == 'x') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '?' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(182);
      if (lookahead != 0) ADVANCE(180);
      END_STATE();
    case 77:
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 78:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 79:
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 82:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 83:
      if (lookahead == '{') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 84:
      if (lookahead == '}') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 85:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 86:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 89:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 130,
        '#', 173,
        '$', 172,
        '%', 154,
        '&', 8,
        '\'', 171,
        '(', 138,
        ')', 139,
        '*', 112,
        '+', 150,
        ',', 109,
        '-', 152,
        '.', 145,
        '/', 153,
        ':', 144,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        ']', 142,
        'a', 232,
        'f', 246,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 190,
        'u', 233,
        'v', 191,
        '{', 108,
        '|', 158,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(89);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 90:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 130,
        '#', 258,
        '%', 154,
        '&', 8,
        '\'', 171,
        '(', 138,
        ')', 139,
        '*', 111,
        '+', 150,
        ',', 109,
        '-', 151,
        '.', 145,
        '/', 153,
        ':', 144,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        ']', 142,
        'a', 61,
        'f', 77,
        'i', 42,
        'm', 28,
        'o', 79,
        'p', 15,
        'r', 33,
        't', 19,
        'u', 62,
        'v', 20,
        '{', 108,
        '|', 158,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(90);
      END_STATE();
    case 91:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 130,
        '#', 258,
        '%', 154,
        '&', 8,
        '(', 138,
        ')', 139,
        '*', 112,
        '+', 150,
        ',', 109,
        '-', 151,
        '.', 145,
        '/', 153,
        ':', 144,
        '<', 167,
        '=', 99,
        '>', 164,
        '?', 148,
        '@', 140,
        '[', 141,
        ']', 142,
        'a', 232,
        'f', 246,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 190,
        'u', 233,
        'v', 191,
        '|', 158,
        '}', 110,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(91);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 92:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 129,
        '#', 258,
        '\'', 171,
        '(', 138,
        '-', 152,
        '/', 10,
        '=', 98,
        '@', 140,
        '[', 141,
        'a', 237,
        'f', 246,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 190,
        'u', 233,
        'v', 191,
        '{', 108,
        '|', 157,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(92);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      if (lookahead == '*' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 93:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '!', 129,
        '#', 258,
        ')', 139,
        ',', 109,
        '.', 145,
        '/', 10,
        '=', 100,
        '?', 147,
        '@', 140,
        '[', 141,
        'a', 67,
        'f', 77,
        'i', 42,
        'm', 28,
        'o', 79,
        'p', 15,
        'r', 33,
        't', 19,
        'u', 62,
        'v', 20,
        '|', 157,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(93);
      END_STATE();
    case 94:
      if (eof) ADVANCE(95);
      ADVANCE_MAP(
        '#', 258,
        '/', 10,
        '@', 140,
        'a', 232,
        'f', 246,
        'i', 213,
        'm', 199,
        'o', 248,
        'p', 186,
        'r', 204,
        't', 190,
        'u', 233,
        'v', 191,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(94);
      if (lookahead == '*' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_module);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '~') ADVANCE(161);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(133);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_provider);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_provider);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_using);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_targetScope);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_targetScope);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_metadata);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_metadata);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_output);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_output);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_param);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_resource);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_resource);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '~') ADVANCE(162);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_func);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_test);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_test);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(149);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '?') ADVANCE(146);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT_QMARK);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(168);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(256);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(155);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(166);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(9);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(184);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '#') ADVANCE(173);
      if (lookahead == '$') ADVANCE(172);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '/') ADVANCE(175);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '*') ADVANCE(177);
      if (lookahead == '/') ADVANCE(255);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '*') ADVANCE(176);
      if (lookahead == '/') ADVANCE(254);
      if (lookahead == '$' ||
          lookahead == '\'' ||
          lookahead == '\\') ADVANCE(12);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '*') ADVANCE(176);
      if (lookahead == '$' ||
          lookahead == '\'' ||
          lookahead == '\\') ADVANCE(12);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(183);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(182);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(229);
      if (lookahead == 'r') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(225);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'y') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'o') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '$' ||
          lookahead == '\'') ADVANCE(256);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(256);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_diagnostic_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(258);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'e', 3,
        'f', 4,
        'i', 5,
        'n', 6,
        'o', 7,
        's', 8,
        't', 9,
        'w', 10,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(11);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'x') ADVANCE(13);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 6:
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 7:
      if (lookahead == 'b') ADVANCE(20);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(21);
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'i') ADVANCE(27);
      END_STATE();
    case 14:
      if (lookahead == 'l') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 19:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 20:
      if (lookahead == 'j') ADVANCE(33);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(34);
      END_STATE();
    case 22:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(40);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 30:
      if (lookahead == 'm') ADVANCE(42);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(46);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 37:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 38:
      if (lookahead == 'y') ADVANCE(49);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 44:
      if (lookahead == 'c') ADVANCE(52);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_array);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(58);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 57:
      if (lookahead == 'O') ADVANCE(60);
      if (lookahead == 'S') ADVANCE(61);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 59:
      if (lookahead == 'g') ADVANCE(62);
      END_STATE();
    case 60:
      if (lookahead == 'b') ADVANCE(63);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_existing);
      END_STATE();
    case 63:
      if (lookahead == 'j') ADVANCE(65);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 67:
      if (lookahead == 'c') ADVANCE(69);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(72);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_secureObject);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_secureString);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 90},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 4},
  [18] = {.lex_state = 4},
  [19] = {.lex_state = 4},
  [20] = {.lex_state = 4},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 4},
  [34] = {.lex_state = 4},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 4},
  [37] = {.lex_state = 4},
  [38] = {.lex_state = 4},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 4},
  [52] = {.lex_state = 4},
  [53] = {.lex_state = 4},
  [54] = {.lex_state = 92},
  [55] = {.lex_state = 92},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 4},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 4},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 4},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 4},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 4},
  [70] = {.lex_state = 4},
  [71] = {.lex_state = 4, .external_lex_state = 2},
  [72] = {.lex_state = 4},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 4},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 4},
  [78] = {.lex_state = 4},
  [79] = {.lex_state = 2},
  [80] = {.lex_state = 2},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 2},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 4},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 4},
  [145] = {.lex_state = 4},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 2},
  [148] = {.lex_state = 2},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 2},
  [152] = {.lex_state = 4},
  [153] = {.lex_state = 4},
  [154] = {.lex_state = 4},
  [155] = {.lex_state = 4},
  [156] = {.lex_state = 4},
  [157] = {.lex_state = 4},
  [158] = {.lex_state = 4},
  [159] = {.lex_state = 4},
  [160] = {.lex_state = 4},
  [161] = {.lex_state = 4},
  [162] = {.lex_state = 4},
  [163] = {.lex_state = 4},
  [164] = {.lex_state = 3, .external_lex_state = 2},
  [165] = {.lex_state = 4},
  [166] = {.lex_state = 4},
  [167] = {.lex_state = 4},
  [168] = {.lex_state = 4},
  [169] = {.lex_state = 4},
  [170] = {.lex_state = 4},
  [171] = {.lex_state = 4},
  [172] = {.lex_state = 2},
  [173] = {.lex_state = 4},
  [174] = {.lex_state = 4},
  [175] = {.lex_state = 4},
  [176] = {.lex_state = 4},
  [177] = {.lex_state = 4},
  [178] = {.lex_state = 4},
  [179] = {.lex_state = 4},
  [180] = {.lex_state = 4},
  [181] = {.lex_state = 4},
  [182] = {.lex_state = 4},
  [183] = {.lex_state = 4},
  [184] = {.lex_state = 4},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 4},
  [187] = {.lex_state = 4},
  [188] = {.lex_state = 4},
  [189] = {.lex_state = 4},
  [190] = {.lex_state = 4},
  [191] = {.lex_state = 4},
  [192] = {.lex_state = 4},
  [193] = {.lex_state = 4},
  [194] = {.lex_state = 4},
  [195] = {.lex_state = 4},
  [196] = {.lex_state = 3, .external_lex_state = 2},
  [197] = {.lex_state = 4},
  [198] = {.lex_state = 4},
  [199] = {.lex_state = 4},
  [200] = {.lex_state = 4},
  [201] = {.lex_state = 4},
  [202] = {.lex_state = 4},
  [203] = {.lex_state = 4},
  [204] = {.lex_state = 4},
  [205] = {.lex_state = 4},
  [206] = {.lex_state = 4},
  [207] = {.lex_state = 4},
  [208] = {.lex_state = 4},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 4},
  [211] = {.lex_state = 4},
  [212] = {.lex_state = 4},
  [213] = {.lex_state = 4},
  [214] = {.lex_state = 4},
  [215] = {.lex_state = 4},
  [216] = {.lex_state = 4},
  [217] = {.lex_state = 4},
  [218] = {.lex_state = 4},
  [219] = {.lex_state = 4},
  [220] = {.lex_state = 4},
  [221] = {.lex_state = 4},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 4},
  [224] = {.lex_state = 4},
  [225] = {.lex_state = 4},
  [226] = {.lex_state = 4},
  [227] = {.lex_state = 4},
  [228] = {.lex_state = 4},
  [229] = {.lex_state = 4},
  [230] = {.lex_state = 4},
  [231] = {.lex_state = 4},
  [232] = {.lex_state = 4},
  [233] = {.lex_state = 4},
  [234] = {.lex_state = 4},
  [235] = {.lex_state = 4},
  [236] = {.lex_state = 4},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 4},
  [239] = {.lex_state = 4},
  [240] = {.lex_state = 4},
  [241] = {.lex_state = 3, .external_lex_state = 2},
  [242] = {.lex_state = 4},
  [243] = {.lex_state = 4},
  [244] = {.lex_state = 3, .external_lex_state = 2},
  [245] = {.lex_state = 4},
  [246] = {.lex_state = 4},
  [247] = {.lex_state = 4},
  [248] = {.lex_state = 4},
  [249] = {.lex_state = 3, .external_lex_state = 2},
  [250] = {.lex_state = 4},
  [251] = {.lex_state = 3, .external_lex_state = 2},
  [252] = {.lex_state = 4},
  [253] = {.lex_state = 4},
  [254] = {.lex_state = 3, .external_lex_state = 2},
  [255] = {.lex_state = 3, .external_lex_state = 2},
  [256] = {.lex_state = 3, .external_lex_state = 2},
  [257] = {.lex_state = 3, .external_lex_state = 2},
  [258] = {.lex_state = 91},
  [259] = {.lex_state = 91},
  [260] = {.lex_state = 3, .external_lex_state = 2},
  [261] = {.lex_state = 91},
  [262] = {.lex_state = 3, .external_lex_state = 2},
  [263] = {.lex_state = 3, .external_lex_state = 2},
  [264] = {.lex_state = 3, .external_lex_state = 2},
  [265] = {.lex_state = 3, .external_lex_state = 2},
  [266] = {.lex_state = 3, .external_lex_state = 2},
  [267] = {.lex_state = 3, .external_lex_state = 2},
  [268] = {.lex_state = 3, .external_lex_state = 2},
  [269] = {.lex_state = 3, .external_lex_state = 2},
  [270] = {.lex_state = 3, .external_lex_state = 2},
  [271] = {.lex_state = 3, .external_lex_state = 2},
  [272] = {.lex_state = 3, .external_lex_state = 2},
  [273] = {.lex_state = 3, .external_lex_state = 2},
  [274] = {.lex_state = 3, .external_lex_state = 2},
  [275] = {.lex_state = 3, .external_lex_state = 2},
  [276] = {.lex_state = 3, .external_lex_state = 2},
  [277] = {.lex_state = 3, .external_lex_state = 2},
  [278] = {.lex_state = 3, .external_lex_state = 2},
  [279] = {.lex_state = 3, .external_lex_state = 2},
  [280] = {.lex_state = 3, .external_lex_state = 2},
  [281] = {.lex_state = 91},
  [282] = {.lex_state = 3, .external_lex_state = 2},
  [283] = {.lex_state = 3, .external_lex_state = 2},
  [284] = {.lex_state = 3, .external_lex_state = 2},
  [285] = {.lex_state = 3, .external_lex_state = 2},
  [286] = {.lex_state = 3, .external_lex_state = 2},
  [287] = {.lex_state = 3, .external_lex_state = 2},
  [288] = {.lex_state = 3, .external_lex_state = 2},
  [289] = {.lex_state = 3, .external_lex_state = 2},
  [290] = {.lex_state = 3, .external_lex_state = 2},
  [291] = {.lex_state = 3, .external_lex_state = 2},
  [292] = {.lex_state = 3, .external_lex_state = 2},
  [293] = {.lex_state = 3, .external_lex_state = 2},
  [294] = {.lex_state = 3, .external_lex_state = 2},
  [295] = {.lex_state = 3, .external_lex_state = 2},
  [296] = {.lex_state = 3, .external_lex_state = 2},
  [297] = {.lex_state = 3, .external_lex_state = 2},
  [298] = {.lex_state = 3, .external_lex_state = 2},
  [299] = {.lex_state = 3, .external_lex_state = 2},
  [300] = {.lex_state = 3, .external_lex_state = 2},
  [301] = {.lex_state = 3, .external_lex_state = 2},
  [302] = {.lex_state = 3, .external_lex_state = 2},
  [303] = {.lex_state = 3, .external_lex_state = 2},
  [304] = {.lex_state = 3, .external_lex_state = 2},
  [305] = {.lex_state = 3, .external_lex_state = 2},
  [306] = {.lex_state = 90},
  [307] = {.lex_state = 3, .external_lex_state = 2},
  [308] = {.lex_state = 3, .external_lex_state = 2},
  [309] = {.lex_state = 90},
  [310] = {.lex_state = 3, .external_lex_state = 2},
  [311] = {.lex_state = 3, .external_lex_state = 2},
  [312] = {.lex_state = 90},
  [313] = {.lex_state = 3, .external_lex_state = 2},
  [314] = {.lex_state = 3, .external_lex_state = 2},
  [315] = {.lex_state = 90},
  [316] = {.lex_state = 3, .external_lex_state = 2},
  [317] = {.lex_state = 3, .external_lex_state = 2},
  [318] = {.lex_state = 3, .external_lex_state = 2},
  [319] = {.lex_state = 90},
  [320] = {.lex_state = 90},
  [321] = {.lex_state = 3, .external_lex_state = 2},
  [322] = {.lex_state = 3, .external_lex_state = 2},
  [323] = {.lex_state = 3, .external_lex_state = 2},
  [324] = {.lex_state = 3, .external_lex_state = 2},
  [325] = {.lex_state = 3, .external_lex_state = 2},
  [326] = {.lex_state = 3, .external_lex_state = 2},
  [327] = {.lex_state = 90},
  [328] = {.lex_state = 90},
  [329] = {.lex_state = 90},
  [330] = {.lex_state = 90},
  [331] = {.lex_state = 90},
  [332] = {.lex_state = 90},
  [333] = {.lex_state = 90},
  [334] = {.lex_state = 90},
  [335] = {.lex_state = 90},
  [336] = {.lex_state = 90},
  [337] = {.lex_state = 90},
  [338] = {.lex_state = 90},
  [339] = {.lex_state = 90},
  [340] = {.lex_state = 90},
  [341] = {.lex_state = 90},
  [342] = {.lex_state = 90},
  [343] = {.lex_state = 90},
  [344] = {.lex_state = 90},
  [345] = {.lex_state = 90},
  [346] = {.lex_state = 90},
  [347] = {.lex_state = 90},
  [348] = {.lex_state = 90},
  [349] = {.lex_state = 90},
  [350] = {.lex_state = 90},
  [351] = {.lex_state = 90},
  [352] = {.lex_state = 90},
  [353] = {.lex_state = 90},
  [354] = {.lex_state = 90},
  [355] = {.lex_state = 90},
  [356] = {.lex_state = 90},
  [357] = {.lex_state = 90},
  [358] = {.lex_state = 90},
  [359] = {.lex_state = 90},
  [360] = {.lex_state = 90},
  [361] = {.lex_state = 90},
  [362] = {.lex_state = 90},
  [363] = {.lex_state = 90},
  [364] = {.lex_state = 90},
  [365] = {.lex_state = 90},
  [366] = {.lex_state = 90},
  [367] = {.lex_state = 90},
  [368] = {.lex_state = 3, .external_lex_state = 2},
  [369] = {.lex_state = 90},
  [370] = {.lex_state = 90},
  [371] = {.lex_state = 90},
  [372] = {.lex_state = 90},
  [373] = {.lex_state = 90},
  [374] = {.lex_state = 90},
  [375] = {.lex_state = 90},
  [376] = {.lex_state = 90},
  [377] = {.lex_state = 90},
  [378] = {.lex_state = 90},
  [379] = {.lex_state = 90},
  [380] = {.lex_state = 90},
  [381] = {.lex_state = 90},
  [382] = {.lex_state = 90},
  [383] = {.lex_state = 90},
  [384] = {.lex_state = 90},
  [385] = {.lex_state = 90},
  [386] = {.lex_state = 90},
  [387] = {.lex_state = 90},
  [388] = {.lex_state = 90},
  [389] = {.lex_state = 90},
  [390] = {.lex_state = 90},
  [391] = {.lex_state = 90},
  [392] = {.lex_state = 90},
  [393] = {.lex_state = 90},
  [394] = {.lex_state = 90},
  [395] = {.lex_state = 90},
  [396] = {.lex_state = 90},
  [397] = {.lex_state = 90},
  [398] = {.lex_state = 90},
  [399] = {.lex_state = 90},
  [400] = {.lex_state = 90},
  [401] = {.lex_state = 90},
  [402] = {.lex_state = 90},
  [403] = {.lex_state = 90},
  [404] = {.lex_state = 90},
  [405] = {.lex_state = 90},
  [406] = {.lex_state = 90},
  [407] = {.lex_state = 90},
  [408] = {.lex_state = 90},
  [409] = {.lex_state = 90},
  [410] = {.lex_state = 90},
  [411] = {.lex_state = 90},
  [412] = {.lex_state = 90},
  [413] = {.lex_state = 90},
  [414] = {.lex_state = 90},
  [415] = {.lex_state = 90},
  [416] = {.lex_state = 90},
  [417] = {.lex_state = 90},
  [418] = {.lex_state = 4, .external_lex_state = 2},
  [419] = {.lex_state = 4, .external_lex_state = 2},
  [420] = {.lex_state = 4, .external_lex_state = 2},
  [421] = {.lex_state = 4, .external_lex_state = 2},
  [422] = {.lex_state = 4, .external_lex_state = 2},
  [423] = {.lex_state = 4, .external_lex_state = 2},
  [424] = {.lex_state = 4, .external_lex_state = 2},
  [425] = {.lex_state = 4, .external_lex_state = 2},
  [426] = {.lex_state = 4, .external_lex_state = 2},
  [427] = {.lex_state = 4, .external_lex_state = 2},
  [428] = {.lex_state = 4, .external_lex_state = 2},
  [429] = {.lex_state = 4, .external_lex_state = 2},
  [430] = {.lex_state = 4, .external_lex_state = 2},
  [431] = {.lex_state = 4, .external_lex_state = 2},
  [432] = {.lex_state = 4, .external_lex_state = 2},
  [433] = {.lex_state = 4, .external_lex_state = 2},
  [434] = {.lex_state = 4, .external_lex_state = 2},
  [435] = {.lex_state = 4, .external_lex_state = 2},
  [436] = {.lex_state = 4, .external_lex_state = 2},
  [437] = {.lex_state = 4, .external_lex_state = 2},
  [438] = {.lex_state = 4, .external_lex_state = 2},
  [439] = {.lex_state = 4, .external_lex_state = 2},
  [440] = {.lex_state = 4, .external_lex_state = 2},
  [441] = {.lex_state = 4, .external_lex_state = 2},
  [442] = {.lex_state = 4, .external_lex_state = 2},
  [443] = {.lex_state = 4, .external_lex_state = 2},
  [444] = {.lex_state = 4, .external_lex_state = 2},
  [445] = {.lex_state = 4, .external_lex_state = 2},
  [446] = {.lex_state = 4},
  [447] = {.lex_state = 4, .external_lex_state = 2},
  [448] = {.lex_state = 4, .external_lex_state = 2},
  [449] = {.lex_state = 4, .external_lex_state = 2},
  [450] = {.lex_state = 4, .external_lex_state = 2},
  [451] = {.lex_state = 4, .external_lex_state = 2},
  [452] = {.lex_state = 4},
  [453] = {.lex_state = 4, .external_lex_state = 2},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 90},
  [456] = {.lex_state = 4},
  [457] = {.lex_state = 4},
  [458] = {.lex_state = 90},
  [459] = {.lex_state = 90},
  [460] = {.lex_state = 90},
  [461] = {.lex_state = 4, .external_lex_state = 2},
  [462] = {.lex_state = 4, .external_lex_state = 2},
  [463] = {.lex_state = 4, .external_lex_state = 2},
  [464] = {.lex_state = 90},
  [465] = {.lex_state = 90},
  [466] = {.lex_state = 90},
  [467] = {.lex_state = 4, .external_lex_state = 2},
  [468] = {.lex_state = 90},
  [469] = {.lex_state = 90},
  [470] = {.lex_state = 90},
  [471] = {.lex_state = 90},
  [472] = {.lex_state = 90},
  [473] = {.lex_state = 4, .external_lex_state = 2},
  [474] = {.lex_state = 4, .external_lex_state = 2},
  [475] = {.lex_state = 4, .external_lex_state = 2},
  [476] = {.lex_state = 90},
  [477] = {.lex_state = 90},
  [478] = {.lex_state = 90},
  [479] = {.lex_state = 4, .external_lex_state = 2},
  [480] = {.lex_state = 4, .external_lex_state = 2},
  [481] = {.lex_state = 4, .external_lex_state = 2},
  [482] = {.lex_state = 90},
  [483] = {.lex_state = 4, .external_lex_state = 2},
  [484] = {.lex_state = 90},
  [485] = {.lex_state = 4, .external_lex_state = 2},
  [486] = {.lex_state = 90},
  [487] = {.lex_state = 90},
  [488] = {.lex_state = 90},
  [489] = {.lex_state = 4, .external_lex_state = 2},
  [490] = {.lex_state = 90},
  [491] = {.lex_state = 90},
  [492] = {.lex_state = 90},
  [493] = {.lex_state = 90},
  [494] = {.lex_state = 90},
  [495] = {.lex_state = 90},
  [496] = {.lex_state = 4, .external_lex_state = 2},
  [497] = {.lex_state = 90},
  [498] = {.lex_state = 4, .external_lex_state = 2},
  [499] = {.lex_state = 90},
  [500] = {.lex_state = 90},
  [501] = {.lex_state = 4, .external_lex_state = 2},
  [502] = {.lex_state = 4, .external_lex_state = 2},
  [503] = {.lex_state = 90},
  [504] = {.lex_state = 4, .external_lex_state = 2},
  [505] = {.lex_state = 90},
  [506] = {.lex_state = 90},
  [507] = {.lex_state = 90},
  [508] = {.lex_state = 90},
  [509] = {.lex_state = 90},
  [510] = {.lex_state = 90},
  [511] = {.lex_state = 90},
  [512] = {.lex_state = 90},
  [513] = {.lex_state = 90},
  [514] = {.lex_state = 90},
  [515] = {.lex_state = 90},
  [516] = {.lex_state = 90},
  [517] = {.lex_state = 90},
  [518] = {.lex_state = 90},
  [519] = {.lex_state = 90},
  [520] = {.lex_state = 90},
  [521] = {.lex_state = 90},
  [522] = {.lex_state = 90},
  [523] = {.lex_state = 90},
  [524] = {.lex_state = 4, .external_lex_state = 2},
  [525] = {.lex_state = 90},
  [526] = {.lex_state = 90},
  [527] = {.lex_state = 4, .external_lex_state = 2},
  [528] = {.lex_state = 90},
  [529] = {.lex_state = 90},
  [530] = {.lex_state = 4, .external_lex_state = 2},
  [531] = {.lex_state = 90},
  [532] = {.lex_state = 90},
  [533] = {.lex_state = 4, .external_lex_state = 2},
  [534] = {.lex_state = 90},
  [535] = {.lex_state = 90},
  [536] = {.lex_state = 90},
  [537] = {.lex_state = 90},
  [538] = {.lex_state = 90},
  [539] = {.lex_state = 4, .external_lex_state = 2},
  [540] = {.lex_state = 90},
  [541] = {.lex_state = 90},
  [542] = {.lex_state = 90},
  [543] = {.lex_state = 90},
  [544] = {.lex_state = 90},
  [545] = {.lex_state = 4, .external_lex_state = 2},
  [546] = {.lex_state = 4, .external_lex_state = 2},
  [547] = {.lex_state = 4, .external_lex_state = 2},
  [548] = {.lex_state = 4, .external_lex_state = 2},
  [549] = {.lex_state = 4, .external_lex_state = 2},
  [550] = {.lex_state = 4, .external_lex_state = 2},
  [551] = {.lex_state = 90},
  [552] = {.lex_state = 90},
  [553] = {.lex_state = 90},
  [554] = {.lex_state = 90},
  [555] = {.lex_state = 4, .external_lex_state = 2},
  [556] = {.lex_state = 90},
  [557] = {.lex_state = 93},
  [558] = {.lex_state = 93},
  [559] = {.lex_state = 90},
  [560] = {.lex_state = 93},
  [561] = {.lex_state = 90},
  [562] = {.lex_state = 4, .external_lex_state = 2},
  [563] = {.lex_state = 90},
  [564] = {.lex_state = 93},
  [565] = {.lex_state = 93},
  [566] = {.lex_state = 4, .external_lex_state = 2},
  [567] = {.lex_state = 4, .external_lex_state = 2},
  [568] = {.lex_state = 93},
  [569] = {.lex_state = 4, .external_lex_state = 2},
  [570] = {.lex_state = 4, .external_lex_state = 2},
  [571] = {.lex_state = 4, .external_lex_state = 2},
  [572] = {.lex_state = 93},
  [573] = {.lex_state = 4, .external_lex_state = 2},
  [574] = {.lex_state = 4, .external_lex_state = 2},
  [575] = {.lex_state = 4, .external_lex_state = 2},
  [576] = {.lex_state = 4, .external_lex_state = 2},
  [577] = {.lex_state = 4, .external_lex_state = 2},
  [578] = {.lex_state = 4, .external_lex_state = 2},
  [579] = {.lex_state = 4, .external_lex_state = 2},
  [580] = {.lex_state = 4, .external_lex_state = 2},
  [581] = {.lex_state = 4, .external_lex_state = 2},
  [582] = {.lex_state = 93},
  [583] = {.lex_state = 93},
  [584] = {.lex_state = 4, .external_lex_state = 2},
  [585] = {.lex_state = 4, .external_lex_state = 2},
  [586] = {.lex_state = 4, .external_lex_state = 2},
  [587] = {.lex_state = 93},
  [588] = {.lex_state = 93},
  [589] = {.lex_state = 93},
  [590] = {.lex_state = 93},
  [591] = {.lex_state = 93},
  [592] = {.lex_state = 93},
  [593] = {.lex_state = 93},
  [594] = {.lex_state = 93},
  [595] = {.lex_state = 93},
  [596] = {.lex_state = 93},
  [597] = {.lex_state = 93},
  [598] = {.lex_state = 93},
  [599] = {.lex_state = 93},
  [600] = {.lex_state = 93},
  [601] = {.lex_state = 93},
  [602] = {.lex_state = 93},
  [603] = {.lex_state = 90},
  [604] = {.lex_state = 90},
  [605] = {.lex_state = 93},
  [606] = {.lex_state = 94},
  [607] = {.lex_state = 90},
  [608] = {.lex_state = 90},
  [609] = {.lex_state = 90},
  [610] = {.lex_state = 90},
  [611] = {.lex_state = 90},
  [612] = {.lex_state = 90},
  [613] = {.lex_state = 90},
  [614] = {.lex_state = 90},
  [615] = {.lex_state = 90},
  [616] = {.lex_state = 90},
  [617] = {.lex_state = 90},
  [618] = {.lex_state = 90},
  [619] = {.lex_state = 90},
  [620] = {.lex_state = 90},
  [621] = {.lex_state = 90},
  [622] = {.lex_state = 90},
  [623] = {.lex_state = 90},
  [624] = {.lex_state = 90},
  [625] = {.lex_state = 5},
  [626] = {.lex_state = 5},
  [627] = {.lex_state = 5},
  [628] = {.lex_state = 5},
  [629] = {.lex_state = 5},
  [630] = {.lex_state = 5},
  [631] = {.lex_state = 5},
  [632] = {.lex_state = 5},
  [633] = {.lex_state = 5},
  [634] = {.lex_state = 5},
  [635] = {.lex_state = 90},
  [636] = {.lex_state = 6},
  [637] = {.lex_state = 6},
  [638] = {.lex_state = 6},
  [639] = {.lex_state = 6},
  [640] = {.lex_state = 6},
  [641] = {.lex_state = 90},
  [642] = {.lex_state = 90},
  [643] = {.lex_state = 90},
  [644] = {.lex_state = 90},
  [645] = {.lex_state = 90},
  [646] = {.lex_state = 4},
  [647] = {.lex_state = 4},
  [648] = {.lex_state = 90},
  [649] = {.lex_state = 90},
  [650] = {.lex_state = 90},
  [651] = {.lex_state = 90},
  [652] = {.lex_state = 90},
  [653] = {.lex_state = 90},
  [654] = {.lex_state = 90},
  [655] = {.lex_state = 90},
  [656] = {.lex_state = 4},
  [657] = {.lex_state = 4},
  [658] = {.lex_state = 4},
  [659] = {.lex_state = 90},
  [660] = {.lex_state = 4},
  [661] = {.lex_state = 4},
  [662] = {.lex_state = 6},
  [663] = {.lex_state = 4},
  [664] = {.lex_state = 4},
  [665] = {.lex_state = 4},
  [666] = {.lex_state = 4},
  [667] = {.lex_state = 4},
  [668] = {.lex_state = 7},
  [669] = {.lex_state = 4},
  [670] = {.lex_state = 4},
  [671] = {.lex_state = 4},
  [672] = {.lex_state = 4},
  [673] = {.lex_state = 4},
  [674] = {.lex_state = 4},
  [675] = {.lex_state = 4},
  [676] = {.lex_state = 4},
  [677] = {.lex_state = 4},
  [678] = {.lex_state = 6},
  [679] = {.lex_state = 6},
  [680] = {.lex_state = 6},
  [681] = {.lex_state = 4},
  [682] = {.lex_state = 90, .external_lex_state = 3},
  [683] = {.lex_state = 4},
  [684] = {.lex_state = 4},
  [685] = {.lex_state = 90, .external_lex_state = 3},
  [686] = {.lex_state = 90},
  [687] = {.lex_state = 90},
  [688] = {.lex_state = 90},
  [689] = {.lex_state = 4},
  [690] = {.lex_state = 4},
  [691] = {.lex_state = 4},
  [692] = {.lex_state = 4},
  [693] = {.lex_state = 90},
  [694] = {.lex_state = 90},
  [695] = {.lex_state = 90},
  [696] = {.lex_state = 90},
  [697] = {.lex_state = 90, .external_lex_state = 3},
  [698] = {.lex_state = 4},
  [699] = {.lex_state = 90, .external_lex_state = 3},
  [700] = {.lex_state = 4},
  [701] = {.lex_state = 90},
  [702] = {.lex_state = 90},
  [703] = {.lex_state = 90},
  [704] = {.lex_state = 4},
  [705] = {.lex_state = 4},
  [706] = {.lex_state = 90},
  [707] = {.lex_state = 7},
  [708] = {.lex_state = 4},
  [709] = {.lex_state = 90},
  [710] = {.lex_state = 4},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 6},
  [713] = {.lex_state = 90},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 90},
  [716] = {.lex_state = 90, .external_lex_state = 3},
  [717] = {.lex_state = 90, .external_lex_state = 3},
  [718] = {.lex_state = 90},
  [719] = {.lex_state = 90},
  [720] = {.lex_state = 6},
  [721] = {.lex_state = 6},
  [722] = {.lex_state = 90},
  [723] = {.lex_state = 90},
  [724] = {.lex_state = 90},
  [725] = {.lex_state = 90},
  [726] = {.lex_state = 4},
  [727] = {.lex_state = 90},
  [728] = {.lex_state = 4},
  [729] = {.lex_state = 90},
  [730] = {.lex_state = 90},
  [731] = {.lex_state = 90},
  [732] = {.lex_state = 6},
  [733] = {.lex_state = 90},
  [734] = {.lex_state = 4},
  [735] = {.lex_state = 90},
  [736] = {.lex_state = 90},
  [737] = {.lex_state = 90},
  [738] = {.lex_state = 90},
  [739] = {.lex_state = 90},
  [740] = {.lex_state = 90},
  [741] = {.lex_state = 4},
  [742] = {.lex_state = 90},
  [743] = {.lex_state = 90},
  [744] = {.lex_state = 6},
  [745] = {.lex_state = 4},
  [746] = {.lex_state = 90},
  [747] = {.lex_state = 90},
  [748] = {.lex_state = 90},
  [749] = {.lex_state = 6},
  [750] = {.lex_state = 6},
  [751] = {.lex_state = 90},
  [752] = {.lex_state = 90},
  [753] = {.lex_state = 90},
  [754] = {.lex_state = 6},
  [755] = {.lex_state = 90},
  [756] = {.lex_state = 6},
  [757] = {.lex_state = 90},
  [758] = {.lex_state = 6},
  [759] = {.lex_state = 6},
  [760] = {.lex_state = 6},
  [761] = {.lex_state = 6},
  [762] = {.lex_state = 6},
  [763] = {.lex_state = 90},
  [764] = {.lex_state = 90},
  [765] = {.lex_state = 90},
  [766] = {.lex_state = 6},
  [767] = {.lex_state = 90},
  [768] = {.lex_state = 90},
  [769] = {.lex_state = 6},
  [770] = {.lex_state = 90},
  [771] = {.lex_state = 90},
  [772] = {.lex_state = 90},
  [773] = {.lex_state = 6},
  [774] = {.lex_state = 90},
  [775] = {.lex_state = 90},
  [776] = {.lex_state = 90},
  [777] = {.lex_state = 90},
  [778] = {.lex_state = 90},
  [779] = {.lex_state = 90},
  [780] = {.lex_state = 90},
  [781] = {.lex_state = 6},
  [782] = {.lex_state = 90},
  [783] = {.lex_state = 90},
  [784] = {.lex_state = 90},
  [785] = {.lex_state = 90},
  [786] = {.lex_state = 90},
  [787] = {.lex_state = 90},
  [788] = {.lex_state = 90},
  [789] = {.lex_state = 7},
  [790] = {.lex_state = 6},
  [791] = {.lex_state = 90},
  [792] = {.lex_state = 90},
  [793] = {.lex_state = 6},
  [794] = {.lex_state = 6},
  [795] = {.lex_state = 6},
  [796] = {.lex_state = 90},
  [797] = {.lex_state = 6},
  [798] = {.lex_state = 90},
  [799] = {.lex_state = 90},
  [800] = {.lex_state = 6},
  [801] = {.lex_state = 6},
  [802] = {.lex_state = 6},
  [803] = {.lex_state = 6},
  [804] = {.lex_state = 6},
  [805] = {.lex_state = 6},
  [806] = {.lex_state = 90},
  [807] = {.lex_state = 90},
  [808] = {.lex_state = 90},
  [809] = {.lex_state = 6},
  [810] = {.lex_state = 6},
  [811] = {.lex_state = 90},
  [812] = {.lex_state = 90},
  [813] = {.lex_state = 6},
  [814] = {.lex_state = 6},
  [815] = {.lex_state = 6},
  [816] = {.lex_state = 6},
  [817] = {.lex_state = 6},
  [818] = {.lex_state = 6},
  [819] = {.lex_state = 90},
  [820] = {.lex_state = 6},
  [821] = {.lex_state = 6},
  [822] = {.lex_state = 6},
  [823] = {.lex_state = 90},
  [824] = {.lex_state = 6},
  [825] = {.lex_state = 6},
  [826] = {.lex_state = 6},
  [827] = {.lex_state = 6},
  [828] = {.lex_state = 6},
  [829] = {.lex_state = 6},
  [830] = {.lex_state = 90},
  [831] = {.lex_state = 6},
  [832] = {.lex_state = 6},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_provider] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_targetScope] = ACTIONS(1),
    [anon_sym_metadata] = ACTIONS(1),
    [anon_sym_output] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_resource] = ACTIONS(1),
    [anon_sym_existing] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_test] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_QMARK] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_secureObject] = ACTIONS(1),
    [anon_sym_secureString] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(5),
    [sym__external_asterisk] = ACTIONS(1),
    [sym__multiline_string_content] = ACTIONS(1),
  },
  [1] = {
    [sym_infrastructure] = STATE(799),
    [sym_statement] = STATE(417),
    [sym_declaration] = STATE(622),
    [sym_module_declaration] = STATE(621),
    [sym_import_statement] = STATE(622),
    [sym_import_with_statement] = STATE(622),
    [sym_import_functionality] = STATE(622),
    [sym_using_statement] = STATE(622),
    [sym_target_scope_assignment] = STATE(622),
    [sym_metadata_declaration] = STATE(621),
    [sym_output_declaration] = STATE(621),
    [sym_parameter_declaration] = STATE(621),
    [sym_resource_declaration] = STATE(621),
    [sym_type_declaration] = STATE(621),
    [sym_variable_declaration] = STATE(621),
    [sym_user_defined_function] = STATE(621),
    [sym_test_block] = STATE(621),
    [sym_assert_statement] = STATE(621),
    [sym_decorator] = STATE(603),
    [sym_decorators] = STATE(622),
    [aux_sym_infrastructure_repeat1] = STATE(417),
    [aux_sym_decorators_repeat1] = STATE(603),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_provider] = ACTIONS(13),
    [anon_sym_using] = ACTIONS(15),
    [anon_sym_targetScope] = ACTIONS(17),
    [anon_sym_metadata] = ACTIONS(19),
    [anon_sym_output] = ACTIONS(21),
    [anon_sym_param] = ACTIONS(23),
    [anon_sym_resource] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_var] = ACTIONS(29),
    [anon_sym_func] = ACTIONS(31),
    [anon_sym_test] = ACTIONS(33),
    [anon_sym_assert] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(59),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(45),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(103),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(105),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(107),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(63),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(109),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(111),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(57),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(115),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(63),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(109),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(117),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_expression] = STATE(90),
    [sym_primary_expression] = STATE(147),
    [sym_call_expression] = STATE(151),
    [sym_lambda_expression] = STATE(149),
    [sym_arguments] = STATE(141),
    [sym_parenthesized_expression] = STATE(79),
    [sym_decorator] = STATE(446),
    [sym_decorators] = STATE(197),
    [sym_array] = STATE(151),
    [sym_object] = STATE(151),
    [sym__lhs_expression] = STATE(780),
    [sym_assignment_expression] = STATE(149),
    [sym_for_statement] = STATE(151),
    [sym_member_expression] = STATE(98),
    [sym_subscript_expression] = STATE(98),
    [sym_resource_expression] = STATE(98),
    [sym_ternary_expression] = STATE(149),
    [sym_binary_expression] = STATE(149),
    [sym_unary_expression] = STATE(149),
    [sym__literal] = STATE(151),
    [sym_boolean] = STATE(151),
    [sym_string] = STATE(151),
    [sym__string_literal] = STATE(128),
    [sym__multiline_string_literal] = STATE(128),
    [sym_parameterized_type] = STATE(714),
    [aux_sym_decorators_repeat1] = STATE(446),
    [aux_sym_array_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_module] = ACTIONS(41),
    [anon_sym_import] = ACTIONS(41),
    [anon_sym_provider] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_STAR] = ACTIONS(47),
    [anon_sym_metadata] = ACTIONS(41),
    [anon_sym_output] = ACTIONS(41),
    [anon_sym_param] = ACTIONS(41),
    [anon_sym_resource] = ACTIONS(49),
    [anon_sym_existing] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(41),
    [anon_sym_var] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(121),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_DOT_QMARK] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(67),
    [anon_sym_COLON_COLON] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(47),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(79),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(83),
    [anon_sym_BANG_EQ] = ACTIONS(83),
    [anon_sym_EQ_TILDE] = ACTIONS(83),
    [anon_sym_BANG_TILDE] = ACTIONS(83),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_QMARK_QMARK] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [anon_sym_true] = ACTIONS(93),
    [anon_sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(99),
    [anon_sym_array] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_int] = ACTIONS(41),
    [anon_sym_object] = ACTIONS(41),
    [anon_sym_secureObject] = ACTIONS(41),
    [anon_sym_secureString] = ACTIONS(41),
    [anon_sym_string] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym_diagnostic_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 34,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_PIPE,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(455), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(673), 1,
      aux_sym_union_type_repeat1,
    STATE(740), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(677), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [133] = 34,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_PIPE,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(458), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(673), 1,
      aux_sym_union_type_repeat1,
    STATE(746), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(677), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [266] = 34,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_PIPE,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(458), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(673), 1,
      aux_sym_union_type_repeat1,
    STATE(740), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(677), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [399] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_BANG,
    ACTIONS(161), 1,
      anon_sym_PIPE,
    ACTIONS(163), 1,
      sym_number,
    ACTIONS(165), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(528), 1,
      sym_expression,
    STATE(551), 1,
      sym_member_expression,
    STATE(559), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(665), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(563), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(667), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(167), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [529] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(401), 1,
      sym_member_expression,
    STATE(543), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(674), 1,
      aux_sym_union_type_repeat1,
    STATE(742), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(666), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [659] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(175), 1,
      sym_identifier,
    ACTIONS(177), 1,
      anon_sym_BANG,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(471), 1,
      sym_expression,
    STATE(477), 1,
      sym_member_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [789] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_BANG,
    ACTIONS(191), 1,
      anon_sym_DASH,
    STATE(339), 1,
      sym_primary_expression,
    STATE(371), 1,
      sym_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [919] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_BANG,
    ACTIONS(191), 1,
      anon_sym_DASH,
    STATE(339), 1,
      sym_primary_expression,
    STATE(375), 1,
      sym_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1049] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(193), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1179] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(379), 1,
      sym_expression,
    STATE(401), 1,
      sym_member_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(597), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(593), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1309] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_BANG,
    ACTIONS(163), 1,
      sym_number,
    ACTIONS(165), 1,
      sym_null,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(551), 1,
      sym_member_expression,
    STATE(559), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(563), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(167), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1439] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(193), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(369), 1,
      sym_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(710), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1569] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(199), 1,
      sym_identifier,
    ACTIONS(201), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(374), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(390), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1699] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_PIPE,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(470), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(673), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(670), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1829] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(465), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [1959] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_BANG,
    ACTIONS(161), 1,
      anon_sym_PIPE,
    ACTIONS(163), 1,
      sym_number,
    ACTIONS(165), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(494), 1,
      sym_expression,
    STATE(551), 1,
      sym_member_expression,
    STATE(559), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(665), 1,
      aux_sym_union_type_repeat1,
    STATE(725), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(563), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(672), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(167), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2089] = 35,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(193), 1,
      anon_sym_BANG,
    ACTIONS(203), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(392), 1,
      sym_expression,
    STATE(592), 1,
      sym_parameterized_type,
    STATE(598), 1,
      sym_array_type,
    STATE(602), 1,
      aux_sym_union_type_repeat1,
    STATE(605), 1,
      sym_nullable_type,
    STATE(610), 1,
      sym_union_type,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 2,
      sym_primitive_type,
      sym_parenthesized_type,
    STATE(708), 2,
      sym__type_not_union,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2223] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      sym_identifier,
    ACTIONS(207), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(381), 1,
      sym_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(412), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2353] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(199), 1,
      sym_identifier,
    ACTIONS(201), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(374), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2483] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_BANG,
    ACTIONS(163), 1,
      sym_number,
    ACTIONS(165), 1,
      sym_null,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(529), 1,
      sym_expression,
    STATE(551), 1,
      sym_member_expression,
    STATE(559), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(563), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(167), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2613] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(209), 1,
      sym_identifier,
    ACTIONS(211), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_number,
    ACTIONS(215), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(486), 1,
      sym_member_expression,
    STATE(491), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(511), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(217), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2743] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier,
    ACTIONS(201), 1,
      anon_sym_BANG,
    ACTIONS(203), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(374), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(389), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(602), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(600), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [2873] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(219), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(541), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3003] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_BANG,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(379), 1,
      sym_expression,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(597), 1,
      aux_sym_union_type_repeat1,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(593), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3133] = 33,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(221), 1,
      sym_identifier,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(229), 1,
      anon_sym_BANG,
    ACTIONS(231), 1,
      anon_sym_LPAREN,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(237), 1,
      sym_number,
    ACTIONS(241), 1,
      sym_null,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(251), 1,
      sym_expression,
    STATE(254), 1,
      sym_member_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(301), 1,
      sym_boolean,
    STATE(589), 1,
      sym_union_type,
    STATE(658), 1,
      sym_parameterized_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(323), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(247), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3263] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(195), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(401), 1,
      sym_member_expression,
    STATE(497), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(597), 1,
      aux_sym_union_type_repeat1,
    STATE(607), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(596), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3393] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(219), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3523] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(219), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(369), 1,
      sym_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(710), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3653] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(487), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3783] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(375), 1,
      sym_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [3913] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(401), 1,
      sym_member_expression,
    STATE(482), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(674), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(675), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4043] = 33,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(251), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_resource,
    ACTIONS(255), 1,
      anon_sym_BANG,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      sym_number,
    ACTIONS(261), 1,
      sym_null,
    STATE(251), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(286), 1,
      sym_member_expression,
    STATE(296), 1,
      sym_boolean,
    STATE(299), 1,
      sym_primary_expression,
    STATE(462), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(767), 1,
      sym_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(291), 2,
      sym_object,
      sym_string,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(489), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(502), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(263), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4173] = 33,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(131), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(370), 1,
      sym_expression,
    STATE(373), 1,
      sym_member_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(384), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4303] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(175), 1,
      sym_identifier,
    ACTIONS(177), 1,
      anon_sym_BANG,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(465), 1,
      sym_expression,
    STATE(477), 1,
      sym_member_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(751), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(587), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4433] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(143), 1,
      sym_number,
    ACTIONS(147), 1,
      sym_null,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(173), 1,
      anon_sym_PIPE,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(377), 1,
      sym_boolean,
    STATE(404), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(482), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(674), 1,
      aux_sym_union_type_repeat1,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(675), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(153), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4563] = 33,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(221), 1,
      sym_identifier,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(229), 1,
      anon_sym_BANG,
    ACTIONS(231), 1,
      anon_sym_LPAREN,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(237), 1,
      sym_number,
    ACTIONS(241), 1,
      sym_null,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(196), 1,
      sym_expression,
    STATE(254), 1,
      sym_member_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(301), 1,
      sym_boolean,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(658), 1,
      sym_parameterized_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(323), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(710), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(247), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4693] = 33,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(251), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_resource,
    ACTIONS(255), 1,
      anon_sym_BANG,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      sym_number,
    ACTIONS(261), 1,
      sym_null,
    STATE(241), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(286), 1,
      sym_member_expression,
    STATE(296), 1,
      sym_boolean,
    STATE(299), 1,
      sym_primary_expression,
    STATE(462), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(767), 1,
      sym_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(291), 2,
      sym_object,
      sym_string,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(489), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(502), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(263), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4823] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(199), 1,
      sym_identifier,
    ACTIONS(265), 1,
      anon_sym_BANG,
    ACTIONS(267), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(374), 1,
      sym_member_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(464), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(656), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(646), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [4953] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      sym_identifier,
    ACTIONS(207), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(369), 1,
      sym_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(412), 1,
      sym_member_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(409), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(710), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5083] = 35,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_BANG,
    ACTIONS(231), 1,
      anon_sym_LPAREN,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(237), 1,
      sym_number,
    ACTIONS(241), 1,
      sym_null,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(253), 1,
      anon_sym_resource,
    ACTIONS(269), 1,
      sym_identifier,
    ACTIONS(271), 1,
      anon_sym_PIPE,
    STATE(249), 1,
      sym_expression,
    STATE(254), 1,
      sym_member_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(301), 1,
      sym_boolean,
    STATE(473), 1,
      sym_parameterized_type,
    STATE(504), 1,
      aux_sym_union_type_repeat1,
    STATE(547), 1,
      sym_nullable_type,
    STATE(566), 1,
      sym_union_type,
    STATE(681), 1,
      sym_parenthesized_type,
    STATE(767), 1,
      sym_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(323), 2,
      sym_object,
      sym_string,
    STATE(483), 2,
      sym_primitive_type,
      sym_array_type,
    STATE(698), 2,
      sym__type_not_union,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(263), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5217] = 35,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_BANG,
    ACTIONS(231), 1,
      anon_sym_LPAREN,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(237), 1,
      sym_number,
    ACTIONS(241), 1,
      sym_null,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(253), 1,
      anon_sym_resource,
    ACTIONS(269), 1,
      sym_identifier,
    ACTIONS(271), 1,
      anon_sym_PIPE,
    STATE(244), 1,
      sym_expression,
    STATE(254), 1,
      sym_member_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(301), 1,
      sym_boolean,
    STATE(474), 1,
      sym_parameterized_type,
    STATE(504), 1,
      aux_sym_union_type_repeat1,
    STATE(546), 1,
      sym_nullable_type,
    STATE(562), 1,
      sym_union_type,
    STATE(681), 1,
      sym_parenthesized_type,
    STATE(767), 1,
      sym_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(323), 2,
      sym_object,
      sym_string,
    STATE(480), 2,
      sym_primitive_type,
      sym_array_type,
    STATE(698), 2,
      sym__type_not_union,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(263), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5351] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(175), 1,
      sym_identifier,
    ACTIONS(177), 1,
      anon_sym_BANG,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(267), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(464), 1,
      sym_expression,
    STATE(477), 1,
      sym_member_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(656), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(376), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(646), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5481] = 33,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(251), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_resource,
    ACTIONS(255), 1,
      anon_sym_BANG,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      sym_number,
    ACTIONS(261), 1,
      sym_null,
    ACTIONS(271), 1,
      anon_sym_PIPE,
    STATE(164), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(286), 1,
      sym_member_expression,
    STATE(296), 1,
      sym_boolean,
    STATE(299), 1,
      sym_primary_expression,
    STATE(462), 1,
      sym_parameterized_type,
    STATE(504), 1,
      aux_sym_union_type_repeat1,
    STATE(548), 1,
      sym_type,
    STATE(555), 1,
      sym_union_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(291), 2,
      sym_object,
      sym_string,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(489), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(530), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(290), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(263), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(223), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5611] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(209), 1,
      sym_identifier,
    ACTIONS(211), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_number,
    ACTIONS(215), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(369), 1,
      sym_expression,
    STATE(486), 1,
      sym_member_expression,
    STATE(491), 1,
      sym_boolean,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(591), 1,
      sym_type,
    STATE(683), 1,
      aux_sym_union_type_repeat1,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(511), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(710), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(217), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5741] = 33,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(181), 1,
      sym_number,
    ACTIONS(183), 1,
      sym_null,
    ACTIONS(199), 1,
      sym_identifier,
    ACTIONS(265), 1,
      anon_sym_BANG,
    ACTIONS(267), 1,
      anon_sym_PIPE,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(374), 1,
      sym_member_expression,
    STATE(385), 1,
      sym_boolean,
    STATE(509), 1,
      sym_expression,
    STATE(560), 1,
      sym_parameterized_type,
    STATE(589), 1,
      sym_union_type,
    STATE(656), 1,
      aux_sym_union_type_repeat1,
    STATE(709), 1,
      sym_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 2,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(372), 2,
      sym_object,
      sym_string,
    STATE(582), 3,
      sym_primitive_type,
      sym_array_type,
      sym_parenthesized_type,
    STATE(647), 3,
      sym__type_not_union,
      sym_nullable_type,
      sym_negated_type,
    STATE(362), 4,
      sym_call_expression,
      sym_array,
      sym_for_statement,
      sym__literal,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    ACTIONS(185), 7,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
    ACTIONS(125), 9,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
  [5871] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(500), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    ACTIONS(273), 4,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_PIPE,
    ACTIONS(277), 5,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [5984] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(493), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    ACTIONS(273), 4,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_PIPE,
    ACTIONS(277), 5,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6097] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(293), 1,
      anon_sym_RBRACK,
    ACTIONS(295), 1,
      anon_sym_for,
    ACTIONS(297), 1,
      anon_sym_QMARK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(5), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6216] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(301), 1,
      anon_sym_COMMA,
    ACTIONS(303), 1,
      anon_sym_RBRACK,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6335] = 29,
    ACTIONS(305), 1,
      sym_identifier,
    ACTIONS(311), 1,
      anon_sym_LBRACE,
    ACTIONS(314), 1,
      anon_sym_COMMA,
    ACTIONS(317), 1,
      anon_sym_resource,
    ACTIONS(320), 1,
      anon_sym_BANG,
    ACTIONS(323), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_AT,
    ACTIONS(329), 1,
      anon_sym_LBRACK,
    ACTIONS(332), 1,
      anon_sym_RBRACK,
    ACTIONS(334), 1,
      anon_sym_DASH,
    ACTIONS(337), 1,
      sym_number,
    ACTIONS(343), 1,
      sym_null,
    ACTIONS(346), 1,
      anon_sym_SQUOTE,
    ACTIONS(349), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(340), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(308), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6454] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(119), 1,
      anon_sym_COMMA,
    ACTIONS(121), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6573] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(101), 1,
      anon_sym_COMMA,
    ACTIONS(103), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6692] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(352), 1,
      anon_sym_COMMA,
    ACTIONS(354), 1,
      anon_sym_RBRACK,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6811] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(356), 1,
      anon_sym_COMMA,
    ACTIONS(358), 1,
      anon_sym_RBRACK,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [6930] = 29,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(113), 1,
      anon_sym_COMMA,
    ACTIONS(115), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(58), 1,
      aux_sym_array_repeat1,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(90), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(197), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7049] = 28,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(360), 1,
      anon_sym_RBRACK,
    ACTIONS(362), 1,
      anon_sym_for,
    STATE(2), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(237), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7165] = 28,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(293), 1,
      anon_sym_RBRACK,
    ACTIONS(295), 1,
      anon_sym_for,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(7), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7281] = 28,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(364), 1,
      anon_sym_RBRACK,
    ACTIONS(366), 1,
      anon_sym_for,
    STATE(4), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(199), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7397] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7510] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(368), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7623] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7736] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(370), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7849] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(510), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    ACTIONS(273), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_PIPE,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [7956] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(358), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8069] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(121), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8182] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(372), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8295] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(354), 1,
      anon_sym_RBRACK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8408] = 27,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(103), 1,
      anon_sym_RBRACK,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8521] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(277), 1,
      anon_sym_EQ,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(493), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    ACTIONS(273), 4,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RPAREN,
      anon_sym_PIPE,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8630] = 26,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(247), 1,
      sym_decorators,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(446), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8740] = 4,
    ACTIONS(376), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8805] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(382), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(380), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8868] = 5,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(386), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(384), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [8935] = 5,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(392), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9002] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(396), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(394), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9065] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(400), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(398), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9128] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(404), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(402), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9191] = 9,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(392), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 28,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9266] = 23,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(63), 1,
      anon_sym_DOT,
    ACTIONS(65), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(69), 1,
      anon_sym_COLON_COLON,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    ACTIONS(412), 1,
      anon_sym_BANG,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(410), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(408), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9369] = 4,
    ACTIONS(394), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(418), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(416), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9434] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(422), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(420), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9497] = 21,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(63), 1,
      anon_sym_DOT,
    ACTIONS(65), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(69), 1,
      anon_sym_COLON_COLON,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(426), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(424), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9596] = 4,
    ACTIONS(420), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(431), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(428), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9661] = 21,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(63), 1,
      anon_sym_DOT,
    ACTIONS(65), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(69), 1,
      anon_sym_COLON_COLON,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(436), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(434), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9760] = 4,
    ACTIONS(441), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(443), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(438), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9825] = 5,
    ACTIONS(450), 1,
      anon_sym_LT,
    STATE(557), 1,
      sym_type_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(448), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 30,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9892] = 15,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 11,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [9979] = 18,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(452), 24,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10072] = 5,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 30,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10139] = 4,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10204] = 11,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(392), 17,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10283] = 5,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(386), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(384), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10350] = 12,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 13,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10431] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(461), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(441), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10494] = 13,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 13,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10577] = 14,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 12,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10662] = 7,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(392), 20,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 29,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10733] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(465), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(463), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10796] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(469), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(467), 32,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10859] = 18,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(473), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(471), 24,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [10952] = 21,
    ACTIONS(53), 1,
      anon_sym_EQ_GT,
    ACTIONS(63), 1,
      anon_sym_DOT,
    ACTIONS(65), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(67), 1,
      anon_sym_QMARK,
    ACTIONS(69), 1,
      anon_sym_COLON_COLON,
    ACTIONS(71), 1,
      anon_sym_PLUS,
    ACTIONS(75), 1,
      anon_sym_PERCENT,
    ACTIONS(77), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(79), 1,
      anon_sym_AMP_AMP,
    ACTIONS(81), 1,
      anon_sym_PIPE,
    ACTIONS(89), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(406), 1,
      anon_sym_DASH,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(47), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(85), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(83), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(332), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(475), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11051] = 4,
    ACTIONS(402), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(480), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(477), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11116] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(485), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(483), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11178] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(489), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(487), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11240] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(493), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(491), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11302] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(521), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(808), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11408] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(500), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(273), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11512] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(540), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(791), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11618] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(499), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(497), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11680] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(503), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(501), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11742] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(538), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(785), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11848] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(531), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(792), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [11954] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(508), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(783), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12060] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(507), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(776), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12166] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(505), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(768), 1,
      sym_if_statement,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12272] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(515), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(811), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12378] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(513), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(812), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12484] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(507), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(505), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12546] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(418), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(416), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12608] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(511), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(509), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12670] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(448), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12732] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(515), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(513), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12794] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(519), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(517), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12856] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(523), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(521), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12918] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(527), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(525), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [12980] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(531), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(529), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13042] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(537), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(748), 1,
      sym_if_statement,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13148] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(535), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(533), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13210] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(539), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(537), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13272] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(543), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(541), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13334] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(547), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(545), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13396] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(536), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(777), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13502] = 4,
    ACTIONS(553), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(551), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(549), 30,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13566] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(557), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(555), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13628] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(561), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(559), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13690] = 25,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(565), 1,
      anon_sym_DOT_QMARK,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(100), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13796] = 25,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(495), 1,
      anon_sym_if,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(532), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    STATE(784), 1,
      sym_if_statement,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13902] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(569), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(567), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [13964] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(573), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(571), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14026] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(577), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(575), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14088] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(573), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(571), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14150] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(581), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(579), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14212] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 31,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14274] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(476), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14377] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(466), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14480] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(583), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(472), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14583] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(585), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(460), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14686] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(297), 1,
      anon_sym_QMARK,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(523), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14789] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(587), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(459), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14892] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(589), 1,
      anon_sym_QMARK,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(499), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [14995] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(591), 1,
      anon_sym_QMARK,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(490), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15098] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(593), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(469), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15201] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(468), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15304] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(387), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15404] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(500), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15504] = 6,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    STATE(302), 1,
      sym_arguments,
    STATE(501), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(386), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(384), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15570] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(408), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15670] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(518), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15770] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(104), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15870] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(105), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [15970] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(108), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16070] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(82), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16170] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(268), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16270] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(615), 4,
      anon_sym_LBRACE,
      anon_sym_AT,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 9,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(613), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16334] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(315), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16434] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(525), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16534] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(399), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16634] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(411), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16734] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(388), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16834] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(103), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [16934] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(405), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17034] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(320), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17134] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(172), 1,
      sym_call_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(553), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 6,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17236] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(266), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17336] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(488), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17436] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(495), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17536] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(396), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17636] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(101), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17736] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(542), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17836] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(394), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [17936] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(393), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18036] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(99), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18136] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(403), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18236] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(86), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18336] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(95), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18436] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(87), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18536] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(81), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18636] = 6,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    STATE(302), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(386), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(384), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18702] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(109), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18802] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(397), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [18902] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(3), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19002] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(96), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19102] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(100), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19202] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(395), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19302] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(407), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19402] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(492), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19502] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(391), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19602] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(544), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19702] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19802] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(354), 1,
      sym_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [19902] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(398), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20002] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(351), 1,
      sym_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20102] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(348), 1,
      sym_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20202] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(503), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20302] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(328), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20402] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(340), 1,
      sym_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20502] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(267), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20602] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(337), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20702] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(510), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20802] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(276), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [20902] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(275), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21002] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(339), 1,
      sym_primary_expression,
    STATE(386), 1,
      sym_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21102] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(329), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21202] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(330), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21302] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(493), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21402] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(327), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21502] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_DASH,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    ACTIONS(597), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_BANG,
    STATE(320), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(414), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(755), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(409), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21602] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(315), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21702] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(368), 1,
      sym_call_expression,
    STATE(554), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 6,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21804] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(274), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [21904] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(272), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22004] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(255), 1,
      sym_expression,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22104] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(287), 1,
      sym_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22204] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(284), 1,
      sym_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22304] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(283), 1,
      sym_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22404] = 23,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_resource,
    ACTIONS(233), 1,
      anon_sym_LBRACK,
    ACTIONS(235), 1,
      anon_sym_DASH,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(605), 1,
      anon_sym_BANG,
    ACTIONS(607), 1,
      anon_sym_LPAREN,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      sym_null,
    STATE(279), 1,
      sym_parenthesized_expression,
    STATE(280), 1,
      sym_expression,
    STATE(299), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_parameterized_type,
    STATE(830), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(285), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(293), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(290), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(223), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22504] = 24,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(415), 1,
      sym_call_expression,
    STATE(556), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 6,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22606] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(333), 1,
      sym_expression,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22706] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_expression,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22806] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(522), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [22906] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(520), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23006] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(519), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23106] = 22,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(623), 1,
      anon_sym_BANG,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(631), 1,
      anon_sym_QMARK,
    ACTIONS(633), 1,
      anon_sym_COLON_COLON,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(643), 1,
      anon_sym_PIPE,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    STATE(302), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(619), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(617), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23204] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(406), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23304] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(517), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23404] = 23,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(623), 1,
      anon_sym_BANG,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(631), 1,
      anon_sym_QMARK,
    ACTIONS(633), 1,
      anon_sym_COLON_COLON,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(658), 1,
      anon_sym_LBRACK,
    ACTIONS(660), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    STATE(501), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(656), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(654), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23504] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(516), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23604] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(514), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23704] = 23,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_resource,
    ACTIONS(91), 1,
      sym_number,
    ACTIONS(95), 1,
      sym_null,
    ACTIONS(97), 1,
      anon_sym_SQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_BANG,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(299), 1,
      anon_sym_DASH,
    STATE(79), 1,
      sym_parenthesized_expression,
    STATE(92), 1,
      sym_expression,
    STATE(147), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_parameterized_type,
    STATE(780), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(128), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(98), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(149), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(151), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(41), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23804] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(512), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [23904] = 23,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(623), 1,
      anon_sym_BANG,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(631), 1,
      anon_sym_QMARK,
    ACTIONS(633), 1,
      anon_sym_COLON_COLON,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(658), 1,
      anon_sym_LBRACK,
    ACTIONS(660), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    STATE(501), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(664), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(662), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24004] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(534), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24104] = 12,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    STATE(302), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 12,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24182] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(506), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24282] = 23,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_resource,
    ACTIONS(137), 1,
      anon_sym_LBRACK,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(275), 1,
      sym_identifier,
    ACTIONS(279), 1,
      anon_sym_BANG,
    ACTIONS(281), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym_number,
    ACTIONS(285), 1,
      sym_null,
    STATE(339), 1,
      sym_primary_expression,
    STATE(367), 1,
      sym_parenthesized_expression,
    STATE(535), 1,
      sym_expression,
    STATE(705), 1,
      sym_parameterized_type,
    STATE(771), 1,
      sym__lhs_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(145), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(359), 3,
      sym_member_expression,
      sym_subscript_expression,
      sym_resource_expression,
    STATE(364), 5,
      sym_lambda_expression,
      sym_assignment_expression,
      sym_ternary_expression,
      sym_binary_expression,
      sym_unary_expression,
    STATE(362), 7,
      sym_call_expression,
      sym_array,
      sym_object,
      sym_for_statement,
      sym__literal,
      sym_boolean,
      sym_string,
    ACTIONS(125), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24382] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24447] = 11,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 12,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24522] = 5,
    ACTIONS(672), 1,
      anon_sym_LT,
    STATE(461), 1,
      sym_type_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(448), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24585] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(465), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(463), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24644] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(575), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(577), 40,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_with,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [24703] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(541), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(543), 40,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_with,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [24762] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(469), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(467), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24821] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(537), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(539), 40,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_with,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [24880] = 5,
    ACTIONS(450), 1,
      anon_sym_LT,
    STATE(557), 1,
      sym_type_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(448), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [24943] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(404), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(402), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25002] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(400), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(398), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25061] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(396), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(394), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25120] = 17,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(674), 1,
      anon_sym_QMARK,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 8,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(452), 21,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25207] = 5,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(392), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25270] = 5,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(386), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(384), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25333] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(422), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(420), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25392] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(461), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(441), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25451] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(382), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(380), 28,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25510] = 12,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 12,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25587] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(678), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25654] = 13,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 11,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25733] = 7,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(392), 20,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25800] = 17,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(674), 1,
      anon_sym_QMARK,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(473), 8,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(471), 21,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25887] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [25954] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(678), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 6,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(666), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(378), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(669), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26021] = 4,
    ACTIONS(681), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26082] = 22,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_EQ_GT,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(633), 1,
      anon_sym_COLON_COLON,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(658), 1,
      anon_sym_LBRACK,
    ACTIONS(674), 1,
      anon_sym_QMARK,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    ACTIONS(683), 1,
      anon_sym_BANG,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(410), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(408), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26179] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(509), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(511), 40,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_with,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [26238] = 5,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26301] = 14,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    ACTIONS(639), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(641), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(646), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 10,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26382] = 8,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(392), 18,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 25,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26451] = 4,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26512] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 7,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(669), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26577] = 10,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_PERCENT,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(621), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(635), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(648), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(650), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(392), 16,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(390), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26650] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(485), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(483), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26708] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(499), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(497), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26766] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26824] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 7,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(669), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26886] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(539), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(537), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [26944] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(573), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(571), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27002] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(543), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(541), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27060] = 5,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(685), 3,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(448), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 24,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27122] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(693), 7,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(695), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(689), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27184] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(577), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(575), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27242] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(523), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(521), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27300] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(573), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(571), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27358] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(489), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(487), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27416] = 5,
    ACTIONS(689), 1,
      anon_sym_PIPE,
    ACTIONS(691), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(695), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(693), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27478] = 4,
    ACTIONS(697), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(551), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(549), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27538] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(448), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(446), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27596] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(511), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(509), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27654] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(531), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(529), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27712] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(402), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 39,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [27770] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(446), 5,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(687), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(448), 16,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(685), 22,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27832] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(507), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(505), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [27890] = 5,
    ACTIONS(450), 1,
      anon_sym_LT,
    STATE(557), 1,
      sym_type_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(446), 9,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
    ACTIONS(448), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [27952] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(418), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(416), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28010] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(519), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(517), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28068] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(420), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(422), 39,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [28126] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(493), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(491), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28184] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(515), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(513), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28242] = 5,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(390), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(392), 37,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [28304] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(503), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(501), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28362] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(547), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(545), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28420] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(561), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(559), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28478] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(441), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(461), 39,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [28536] = 5,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 37,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [28598] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(535), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(533), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28656] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(557), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(555), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28714] = 5,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(378), 21,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 26,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28776] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(569), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(567), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28834] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(581), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(579), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28892] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(527), 22,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(525), 27,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [28950] = 17,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(471), 4,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(473), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
  [29035] = 10,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 6,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(392), 31,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_QMARK_QMARK,
  [29106] = 13,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 5,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(392), 26,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [29183] = 7,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(390), 8,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(392), 35,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29248] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(463), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(465), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29305] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(533), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(535), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29362] = 17,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(452), 4,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
  [29447] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(380), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(382), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29504] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(505), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(507), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29561] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(555), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(557), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29618] = 12,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 5,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(392), 27,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [29693] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(521), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(523), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29750] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(571), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(573), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29807] = 11,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 6,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(392), 27,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [29880] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(559), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(561), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29937] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(497), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(499), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [29994] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(525), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(527), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30051] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(467), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(469), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30108] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(501), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(503), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30165] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(491), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(493), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30222] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(517), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(519), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30279] = 8,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(390), 8,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(392), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30346] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(483), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(485), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30403] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(416), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(418), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30460] = 14,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 5,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(392), 25,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_QMARK_QMARK,
  [30539] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(579), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(581), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30596] = 4,
    ACTIONS(725), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(549), 9,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(551), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30655] = 22,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(408), 2,
      anon_sym_as,
      anon_sym_COLON,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(410), 20,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_RBRACK,
  [30750] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(529), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(531), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30807] = 5,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 8,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30868] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(487), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(489), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30925] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(513), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(515), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [30982] = 4,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 9,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31041] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(446), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(448), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31098] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(545), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(547), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31155] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31212] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(394), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(396), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31269] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(571), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(573), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31326] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(567), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(569), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31383] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(398), 10,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(400), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31440] = 4,
    ACTIONS(737), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 9,
      anon_sym_as,
      anon_sym_BANG,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 38,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31499] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(615), 3,
      sym__external_asterisk,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(374), 8,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(613), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [31559] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 8,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 35,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31620] = 12,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 25,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [31692] = 22,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_QMARK,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(755), 1,
      anon_sym_PIPE,
    ACTIONS(764), 1,
      anon_sym_QMARK_QMARK,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(619), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [31783] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(669), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(691), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(666), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [31842] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 34,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [31901] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(666), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [31962] = 14,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 7,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
    ACTIONS(619), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [32037] = 5,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32094] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(689), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(693), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(691), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(695), 18,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32151] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(446), 4,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(685), 4,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(448), 18,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(687), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
  [32208] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(595), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 8,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32267] = 8,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(666), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [32330] = 12,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 5,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(392), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [32401] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 34,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32462] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(685), 3,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(687), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(446), 5,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(448), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32519] = 7,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(689), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(691), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
    ACTIONS(378), 18,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32580] = 5,
    ACTIONS(689), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(693), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(695), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32637] = 22,
    ACTIONS(408), 1,
      anon_sym_EQ,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(764), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(766), 1,
      anon_sym_QMARK,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(410), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [32727] = 13,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 22,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [32799] = 7,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(390), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(392), 31,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32859] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(599), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 7,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [32917] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(770), 1,
      anon_sym_QMARK,
    ACTIONS(772), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(619), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [33005] = 17,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(764), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(766), 1,
      anon_sym_QMARK,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(452), 3,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 19,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
  [33085] = 22,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(770), 1,
      anon_sym_QMARK,
    ACTIONS(777), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(599), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(775), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [33175] = 22,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(781), 1,
      anon_sym_as,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(779), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [33265] = 11,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(390), 5,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(392), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [33333] = 8,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(390), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(392), 29,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [33395] = 12,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [33465] = 10,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 5,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(392), 27,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_QMARK_QMARK,
  [33531] = 14,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_QMARK_QMARK,
  [33605] = 17,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(764), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(766), 1,
      anon_sym_QMARK,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(471), 3,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(473), 19,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
  [33685] = 8,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(689), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(691), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [33746] = 7,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(689), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(691), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [33805] = 6,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(669), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(666), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [33862] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(783), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [33949] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(669), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(666), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [34004] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(785), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [34091] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(787), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [34178] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(791), 1,
      anon_sym_BANG,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(789), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [34265] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(793), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [34352] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 8,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 34,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34403] = 4,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 34,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34456] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(795), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [34543] = 5,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 7,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34598] = 6,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 6,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 33,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34655] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 8,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 34,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_STAR,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34706] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 7,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(615), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
    ACTIONS(378), 18,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [34758] = 21,
    ACTIONS(797), 1,
      ts_builtin_sym_end,
    ACTIONS(799), 1,
      anon_sym_module,
    ACTIONS(802), 1,
      anon_sym_import,
    ACTIONS(805), 1,
      anon_sym_provider,
    ACTIONS(808), 1,
      anon_sym_using,
    ACTIONS(811), 1,
      anon_sym_targetScope,
    ACTIONS(814), 1,
      anon_sym_metadata,
    ACTIONS(817), 1,
      anon_sym_output,
    ACTIONS(820), 1,
      anon_sym_param,
    ACTIONS(823), 1,
      anon_sym_resource,
    ACTIONS(826), 1,
      anon_sym_type,
    ACTIONS(829), 1,
      anon_sym_var,
    ACTIONS(832), 1,
      anon_sym_func,
    ACTIONS(835), 1,
      anon_sym_test,
    ACTIONS(838), 1,
      anon_sym_assert,
    ACTIONS(841), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(416), 2,
      sym_statement,
      aux_sym_infrastructure_repeat1,
    STATE(603), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(622), 7,
      sym_declaration,
      sym_import_statement,
      sym_import_with_statement,
      sym_import_functionality,
      sym_using_statement,
      sym_target_scope_assignment,
      sym_decorators,
    STATE(621), 10,
      sym_module_declaration,
      sym_metadata_declaration,
      sym_output_declaration,
      sym_parameter_declaration,
      sym_resource_declaration,
      sym_type_declaration,
      sym_variable_declaration,
      sym_user_defined_function,
      sym_test_block,
      sym_assert_statement,
  [34840] = 21,
    ACTIONS(9), 1,
      anon_sym_module,
    ACTIONS(11), 1,
      anon_sym_import,
    ACTIONS(13), 1,
      anon_sym_provider,
    ACTIONS(15), 1,
      anon_sym_using,
    ACTIONS(17), 1,
      anon_sym_targetScope,
    ACTIONS(19), 1,
      anon_sym_metadata,
    ACTIONS(21), 1,
      anon_sym_output,
    ACTIONS(23), 1,
      anon_sym_param,
    ACTIONS(25), 1,
      anon_sym_resource,
    ACTIONS(27), 1,
      anon_sym_type,
    ACTIONS(29), 1,
      anon_sym_var,
    ACTIONS(31), 1,
      anon_sym_func,
    ACTIONS(33), 1,
      anon_sym_test,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_AT,
    ACTIONS(844), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(416), 2,
      sym_statement,
      aux_sym_infrastructure_repeat1,
    STATE(603), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(622), 7,
      sym_declaration,
      sym_import_statement,
      sym_import_with_statement,
      sym_import_functionality,
      sym_using_statement,
      sym_target_scope_assignment,
      sym_decorators,
    STATE(621), 10,
      sym_module_declaration,
      sym_metadata_declaration,
      sym_output_declaration,
      sym_parameter_declaration,
      sym_resource_declaration,
      sym_type_declaration,
      sym_variable_declaration,
      sym_user_defined_function,
      sym_test_block,
      sym_assert_statement,
  [34922] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(850), 1,
      anon_sym_COMMA,
    ACTIONS(852), 1,
      anon_sym_RBRACE,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [34991] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(860), 1,
      anon_sym_COMMA,
    ACTIONS(862), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(429), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35060] = 16,
    ACTIONS(864), 1,
      sym_identifier,
    ACTIONS(870), 1,
      anon_sym_COMMA,
    ACTIONS(873), 1,
      anon_sym_RBRACE,
    ACTIONS(875), 1,
      anon_sym_resource,
    ACTIONS(878), 1,
      anon_sym_AT,
    ACTIONS(881), 1,
      anon_sym_SQUOTE,
    ACTIONS(884), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(887), 1,
      sym__external_asterisk,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(867), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35129] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(890), 1,
      anon_sym_COMMA,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(428), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35198] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(894), 1,
      anon_sym_COMMA,
    ACTIONS(896), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(418), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35267] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(850), 1,
      anon_sym_COMMA,
    ACTIONS(852), 1,
      anon_sym_RBRACE,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(431), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35336] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(890), 1,
      anon_sym_COMMA,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35405] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(898), 1,
      anon_sym_COMMA,
    ACTIONS(900), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35474] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(898), 1,
      anon_sym_COMMA,
    ACTIONS(900), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(427), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35543] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(902), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35612] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(906), 1,
      anon_sym_COMMA,
    ACTIONS(908), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35681] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(910), 1,
      anon_sym_COMMA,
    ACTIONS(912), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35750] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(860), 1,
      anon_sym_COMMA,
    ACTIONS(862), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35819] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(914), 1,
      anon_sym_COMMA,
    ACTIONS(916), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(420), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35888] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(918), 1,
      anon_sym_COMMA,
    ACTIONS(920), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(425), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [35957] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(922), 1,
      anon_sym_COMMA,
    ACTIONS(924), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(430), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36026] = 16,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(926), 1,
      anon_sym_COMMA,
    ACTIONS(928), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(424), 2,
      sym_object_property,
      aux_sym_object_repeat1,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36095] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(930), 1,
      anon_sym_RBRACE,
    STATE(434), 1,
      sym_object_property,
    STATE(533), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36160] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(904), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36225] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(900), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36290] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(932), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36355] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36420] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(936), 1,
      anon_sym_RBRACE,
    STATE(432), 1,
      sym_object_property,
    STATE(496), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36485] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(916), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36550] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(862), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36615] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(938), 1,
      anon_sym_RBRACE,
    STATE(422), 1,
      sym_object_property,
    STATE(545), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36680] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36745] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(912), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36810] = 5,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(452), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(942), 6,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(940), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DASH,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36855] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(908), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36920] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(852), 1,
      anon_sym_RBRACE,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [36985] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(944), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37050] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    STATE(433), 1,
      sym_object_property,
    STATE(539), 1,
      sym_decorators,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37115] = 15,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    ACTIONS(948), 1,
      anon_sym_RBRACE,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37180] = 5,
    ACTIONS(954), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(452), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(952), 6,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(950), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DASH,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37225] = 14,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(527), 1,
      sym_decorators,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(581), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37287] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(959), 7,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(957), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DASH,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37326] = 24,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(963), 1,
      anon_sym_RPAREN,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(967), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(661), 1,
      aux_sym_union_type_repeat1,
    STATE(686), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [37407] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(971), 7,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(969), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DASH,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37446] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(975), 7,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      sym_number,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(973), 23,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DASH,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37485] = 24,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(967), 1,
      anon_sym_PIPE,
    ACTIONS(977), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(661), 1,
      aux_sym_union_type_repeat1,
    STATE(693), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [37566] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(979), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(702), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [37644] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(981), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(695), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [37722] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(985), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(983), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37760] = 6,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(987), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(689), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37804] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(991), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(989), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [37842] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(657), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 7,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [37886] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(993), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(619), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [37960] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(963), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(686), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [38038] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(998), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(996), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38076] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(694), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [38154] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(715), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [38232] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(661), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 7,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [38276] = 13,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(390), 4,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(392), 7,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK_QMARK,
  [38334] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(696), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [38412] = 7,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(987), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(664), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(662), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38458] = 7,
    ACTIONS(627), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(987), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(656), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(654), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38504] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1008), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1006), 20,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38542] = 23,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(961), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_RPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(693), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [38620] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [38663] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [38708] = 5,
    ACTIONS(1010), 1,
      anon_sym_DOT,
    ACTIONS(1012), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(277), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38749] = 6,
    ACTIONS(1014), 1,
      anon_sym_BANG,
    ACTIONS(1016), 1,
      anon_sym_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(656), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(654), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38792] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1020), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1018), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38829] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(671), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 8,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [38872] = 6,
    ACTIONS(1014), 1,
      anon_sym_BANG,
    ACTIONS(1016), 1,
      anon_sym_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(664), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(662), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38915] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [38960] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1024), 9,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1022), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [38997] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [39040] = 22,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(749), 1,
      anon_sym_SLASH,
    ACTIONS(751), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(753), 1,
      anon_sym_AMP_AMP,
    ACTIONS(755), 1,
      anon_sym_PIPE,
    ACTIONS(764), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1026), 1,
      anon_sym_QMARK,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(739), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(760), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(762), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(758), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39115] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1028), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39188] = 5,
    ACTIONS(1014), 1,
      anon_sym_BANG,
    ACTIONS(1016), 1,
      anon_sym_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(689), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [39229] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1030), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39301] = 5,
    ACTIONS(689), 1,
      anon_sym_PIPE,
    ACTIONS(691), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(693), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(695), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [39341] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1032), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39413] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1034), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39485] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(1036), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(664), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39557] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1038), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39629] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(426), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [39681] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(770), 1,
      anon_sym_QMARK,
    ACTIONS(1040), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(595), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39753] = 5,
    ACTIONS(1042), 1,
      anon_sym_PIPE,
    STATE(498), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(617), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [39793] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1045), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39865] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1047), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [39937] = 5,
    ACTIONS(271), 1,
      anon_sym_PIPE,
    STATE(498), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1051), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1049), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [39977] = 4,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(617), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [40015] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1053), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40087] = 5,
    ACTIONS(271), 1,
      anon_sym_PIPE,
    STATE(498), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1057), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1055), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [40127] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1059), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40199] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1061), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40271] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1063), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40343] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1065), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40415] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(1067), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(657), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40487] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1069), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40559] = 5,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [40599] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1071), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40671] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1073), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40743] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1075), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40815] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1077), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40887] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1079), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [40959] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1081), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41031] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1083), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41103] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1085), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41175] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1087), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41247] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1089), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41319] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1091), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41391] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1093), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41463] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(570), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [41515] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1095), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41587] = 5,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(685), 3,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(446), 4,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(448), 19,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [41627] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(569), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [41679] = 6,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    STATE(664), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(384), 7,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(386), 17,
      anon_sym_STAR,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [41721] = 20,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(1097), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41791] = 5,
    ACTIONS(1104), 1,
      anon_sym_PIPE,
    STATE(501), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1100), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [41831] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1107), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41903] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1109), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [41975] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(421), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42027] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1111), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42099] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1113), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42171] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1115), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42243] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1117), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42315] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1119), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42387] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(419), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42439] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1121), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42511] = 21,
    ACTIONS(619), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(1097), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42583] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1123), 1,
      anon_sym_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42655] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(741), 1,
      anon_sym_BANG,
    ACTIONS(965), 1,
      anon_sym_QMARK,
    ACTIONS(1125), 1,
      anon_sym_PIPE,
    STATE(353), 1,
      sym_arguments,
    STATE(671), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42727] = 21,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1127), 1,
      anon_sym_RBRACK,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [42799] = 11,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(151), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(846), 1,
      sym_identifier,
    ACTIONS(854), 1,
      anon_sym_resource,
    ACTIONS(858), 1,
      sym__external_asterisk,
    STATE(423), 1,
      sym_object_property,
    STATE(580), 1,
      sym_resource_declaration,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(281), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(807), 2,
      sym_string,
      sym_compatible_identifier,
    ACTIONS(848), 16,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42851] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(656), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(654), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42888] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(664), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(662), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42925] = 4,
    ACTIONS(1133), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1131), 6,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1129), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42962] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(277), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [42997] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(277), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43032] = 6,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [43073] = 7,
    ACTIONS(456), 1,
      anon_sym_EQ,
    ACTIONS(458), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(374), 5,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [43116] = 20,
    ACTIONS(388), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(141), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [43185] = 20,
    ACTIONS(601), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(302), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [43254] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 7,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1100), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43289] = 20,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_EQ_GT,
    ACTIONS(705), 1,
      anon_sym_QMARK,
    ACTIONS(709), 1,
      anon_sym_SLASH,
    ACTIONS(711), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(713), 1,
      anon_sym_AMP_AMP,
    ACTIONS(715), 1,
      anon_sym_PIPE,
    ACTIONS(723), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(727), 1,
      anon_sym_BANG,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(735), 1,
      anon_sym_COLON_COLON,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(701), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(707), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(719), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(721), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(717), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [43358] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(983), 2,
      anon_sym_EQ,
      anon_sym_DOT,
    ACTIONS(985), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
  [43392] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(996), 2,
      anon_sym_EQ,
      anon_sym_DOT,
    ACTIONS(998), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
  [43426] = 5,
    ACTIONS(689), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(693), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(695), 16,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [43464] = 6,
    ACTIONS(689), 1,
      anon_sym_EQ,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(1135), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [43504] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(687), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(685), 3,
      anon_sym_BANG,
      anon_sym_QMARK,
      anon_sym_PIPE,
    ACTIONS(446), 4,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(448), 16,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [43542] = 4,
    ACTIONS(1102), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(656), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(654), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43578] = 5,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(666), 2,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
    ACTIONS(374), 6,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_QMARK,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(378), 16,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_DOT_QMARK,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_QMARK_QMARK,
  [43616] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(989), 2,
      anon_sym_EQ,
      anon_sym_DOT,
    ACTIONS(991), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
  [43650] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1006), 2,
      anon_sym_EQ,
      anon_sym_DOT,
    ACTIONS(1008), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_DOT_QMARK,
      anon_sym_PIPE,
  [43684] = 4,
    ACTIONS(1102), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(664), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(662), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43720] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(547), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(545), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43753] = 3,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1020), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE,
  [43786] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1139), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1137), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43819] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(873), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1141), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43852] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(519), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(517), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43885] = 5,
    ACTIONS(277), 1,
      anon_sym_EQ,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1145), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [43922] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1149), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1147), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43955] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1153), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1151), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [43988] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(527), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(525), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44021] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(499), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(497), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44054] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(557), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(555), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44087] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1157), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1155), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44120] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(485), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(483), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44153] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1161), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1159), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44186] = 5,
    ACTIONS(856), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(942), 2,
      sym__external_asterisk,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(584), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(940), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44223] = 5,
    ACTIONS(689), 1,
      anon_sym_EQ,
    ACTIONS(1163), 1,
      anon_sym_BANG,
    ACTIONS(1165), 1,
      anon_sym_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [44260] = 3,
    ACTIONS(1022), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1024), 23,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_BANG,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE,
  [44293] = 5,
    ACTIONS(1167), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(952), 2,
      sym__external_asterisk,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    STATE(584), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(950), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44330] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(523), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(521), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44363] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(515), 5,
      sym__external_asterisk,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(513), 19,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_type,
      anon_sym_var,
      anon_sym_SQUOTE,
      sym_identifier,
      anon_sym_array,
      anon_sym_bool,
      anon_sym_int,
      anon_sym_object,
      anon_sym_secureObject,
      anon_sym_secureString,
      anon_sym_string,
  [44396] = 4,
    ACTIONS(617), 1,
      anon_sym_EQ,
    STATE(689), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [44430] = 3,
    ACTIONS(277), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [44461] = 3,
    ACTIONS(1100), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [44492] = 3,
    ACTIONS(277), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(273), 21,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [44523] = 4,
    ACTIONS(1129), 1,
      anon_sym_EQ,
    ACTIONS(1170), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1131), 20,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_COMMA,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_EQ_GT,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_PIPE,
  [44556] = 6,
    ACTIONS(731), 1,
      anon_sym_DOT,
    ACTIONS(733), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(1135), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(775), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [44592] = 4,
    ACTIONS(1172), 1,
      anon_sym_PIPE,
    STATE(595), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44623] = 4,
    ACTIONS(1175), 1,
      anon_sym_PIPE,
    STATE(594), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44654] = 4,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(594), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1051), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44685] = 4,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(595), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44716] = 4,
    ACTIONS(197), 1,
      anon_sym_PIPE,
    STATE(594), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1057), 18,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_EQ,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44747] = 5,
    ACTIONS(1163), 1,
      anon_sym_BANG,
    ACTIONS(1165), 1,
      anon_sym_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(775), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [44780] = 4,
    ACTIONS(203), 1,
      anon_sym_PIPE,
    STATE(601), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1051), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44810] = 4,
    ACTIONS(1178), 1,
      anon_sym_PIPE,
    STATE(599), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1102), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44840] = 4,
    ACTIONS(1181), 1,
      anon_sym_PIPE,
    STATE(601), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(619), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44870] = 4,
    ACTIONS(203), 1,
      anon_sym_PIPE,
    STATE(601), 1,
      aux_sym_union_type_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1057), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_LBRACK,
  [44900] = 4,
    ACTIONS(37), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(608), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(942), 15,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
  [44929] = 4,
    ACTIONS(1143), 1,
      anon_sym_DOT,
    ACTIONS(1145), 1,
      anon_sym_DOT_QMARK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1184), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [44958] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(691), 2,
      anon_sym_LBRACK,
      anon_sym_PIPE,
    ACTIONS(775), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [44985] = 4,
    ACTIONS(1188), 1,
      anon_sym_as,
    ACTIONS(1190), 1,
      anon_sym_with,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1186), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45014] = 4,
    ACTIONS(1170), 1,
      anon_sym_LBRACK,
    ACTIONS(1194), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1192), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45043] = 4,
    ACTIONS(1196), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(608), 2,
      sym_decorator,
      aux_sym_decorators_repeat1,
    ACTIONS(952), 15,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
  [45072] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1149), 17,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
      anon_sym_RBRACK,
  [45096] = 3,
    ACTIONS(1102), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(775), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45122] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1199), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45145] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1201), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45168] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1203), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45191] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1205), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45214] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1207), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45237] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1153), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45260] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1209), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45283] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1157), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45306] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1211), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45329] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1213), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45352] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1215), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45375] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1217), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45398] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1219), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45421] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_diagnostic_comment,
    ACTIONS(1221), 16,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_import,
      anon_sym_provider,
      anon_sym_using,
      anon_sym_targetScope,
      anon_sym_metadata,
      anon_sym_output,
      anon_sym_param,
      anon_sym_resource,
      anon_sym_type,
      anon_sym_var,
      anon_sym_func,
      anon_sym_test,
      anon_sym_assert,
      anon_sym_AT,
  [45444] = 5,
    ACTIONS(1223), 1,
      anon_sym_SQUOTE,
    ACTIONS(1227), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(5), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(630), 3,
      sym__escape_sequence,
      sym_interpolation,
      aux_sym__string_literal_repeat1,
    ACTIONS(1225), 5,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      sym_string_content,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [45467] = 5,
    ACTIONS(1227), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1229), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(632), 3,
      sym__escape_sequence,
      sym_interpolation,
      aux_sym__string_literal_repeat1,
    ACTIONS(1231), 5,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      sym_string_content,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [45490] = 5,
    ACTIONS(1227), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1233), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_comment,
      sym_diagnostic_comment,
    STATE(629), 3,
      sym__escape_sequence,
      sym_interpolation,
      aux_sym__string_literal_repeat1,
    ACTIONS(1235), 5,
      anon_sym_DOLLAR,
      anon_sym_POUND,
