{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The GObjectConstructParam struct is an auxiliary structure used to hand
-- t'GI.GObject.Objects.ParamSpec.ParamSpec'\/t'GI.GObject.Structs.Value.Value' pairs to the /@constructor@/ of a t'GI.GObject.Structs.ObjectClass.ObjectClass'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.ObjectConstructParam
    ( 

-- * Exported types
    ObjectConstructParam(..)                ,
    newZeroObjectConstructParam             ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveObjectConstructParamMethod       ,
#endif



 -- * Properties


-- ** pspec #attr:pspec#
-- | the t'GI.GObject.Objects.ParamSpec.ParamSpec' of the construct parameter

    clearObjectConstructParamPspec          ,
    getObjectConstructParamPspec            ,
#if defined(ENABLE_OVERLOADING)
    objectConstructParam_pspec              ,
#endif
    setObjectConstructParamPspec            ,


-- ** value #attr:value#
-- | the value to set the parameter to

    clearObjectConstructParamValue          ,
    getObjectConstructParamValue            ,
#if defined(ENABLE_OVERLOADING)
    objectConstructParam_value              ,
#endif
    setObjectConstructParamValue            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ObjectConstructParam = ObjectConstructParam (SP.ManagedPtr ObjectConstructParam)
    deriving (Eq)

instance SP.ManagedPtrNewtype ObjectConstructParam where
    toManagedPtr (ObjectConstructParam p) = p

instance BoxedPtr ObjectConstructParam where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr ObjectConstructParam)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ObjectConstructParam where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'ObjectConstructParam' struct initialized to zero.
newZeroObjectConstructParam :: MonadIO m => m ObjectConstructParam
newZeroObjectConstructParam = liftIO $ boxedPtrCalloc >>= wrapPtr ObjectConstructParam

instance tag ~ 'AttrSet => Constructible ObjectConstructParam tag where
    new _ attrs = do
        o <- newZeroObjectConstructParam
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@pspec@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectConstructParam #pspec
-- @
getObjectConstructParamPspec :: MonadIO m => ObjectConstructParam -> m (Maybe GParamSpec)
getObjectConstructParamPspec s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr GParamSpec)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GParamSpec.newGParamSpecFromPtr val'
        return val''
    return result

-- | Set the value of the “@pspec@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectConstructParam [ #pspec 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectConstructParamPspec :: MonadIO m => ObjectConstructParam -> Ptr GParamSpec -> m ()
setObjectConstructParamPspec s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr GParamSpec)

-- | Set the value of the “@pspec@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pspec
-- @
clearObjectConstructParamPspec :: MonadIO m => ObjectConstructParam -> m ()
clearObjectConstructParamPspec s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr GParamSpec)

#if defined(ENABLE_OVERLOADING)
data ObjectConstructParamPspecFieldInfo
instance AttrInfo ObjectConstructParamPspecFieldInfo where
    type AttrBaseTypeConstraint ObjectConstructParamPspecFieldInfo = (~) ObjectConstructParam
    type AttrAllowedOps ObjectConstructParamPspecFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectConstructParamPspecFieldInfo = (~) (Ptr GParamSpec)
    type AttrTransferTypeConstraint ObjectConstructParamPspecFieldInfo = (~)(Ptr GParamSpec)
    type AttrTransferType ObjectConstructParamPspecFieldInfo = (Ptr GParamSpec)
    type AttrGetType ObjectConstructParamPspecFieldInfo = Maybe GParamSpec
    type AttrLabel ObjectConstructParamPspecFieldInfo = "pspec"
    type AttrOrigin ObjectConstructParamPspecFieldInfo = ObjectConstructParam
    attrGet = getObjectConstructParamPspec
    attrSet = setObjectConstructParamPspec
    attrConstruct = undefined
    attrClear = clearObjectConstructParamPspec
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectConstructParam.pspec"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectConstructParam.html#g:attr:pspec"
        })

objectConstructParam_pspec :: AttrLabelProxy "pspec"
objectConstructParam_pspec = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectConstructParam #value
-- @
getObjectConstructParamValue :: MonadIO m => ObjectConstructParam -> m (Maybe GValue)
getObjectConstructParamValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr GValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GValue.newGValueFromPtr val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectConstructParam [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectConstructParamValue :: MonadIO m => ObjectConstructParam -> Ptr GValue -> m ()
setObjectConstructParamValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr GValue)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearObjectConstructParamValue :: MonadIO m => ObjectConstructParam -> m ()
clearObjectConstructParamValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr GValue)

#if defined(ENABLE_OVERLOADING)
data ObjectConstructParamValueFieldInfo
instance AttrInfo ObjectConstructParamValueFieldInfo where
    type AttrBaseTypeConstraint ObjectConstructParamValueFieldInfo = (~) ObjectConstructParam
    type AttrAllowedOps ObjectConstructParamValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectConstructParamValueFieldInfo = (~) (Ptr GValue)
    type AttrTransferTypeConstraint ObjectConstructParamValueFieldInfo = (~)(Ptr GValue)
    type AttrTransferType ObjectConstructParamValueFieldInfo = (Ptr GValue)
    type AttrGetType ObjectConstructParamValueFieldInfo = Maybe GValue
    type AttrLabel ObjectConstructParamValueFieldInfo = "value"
    type AttrOrigin ObjectConstructParamValueFieldInfo = ObjectConstructParam
    attrGet = getObjectConstructParamValue
    attrSet = setObjectConstructParamValue
    attrConstruct = undefined
    attrClear = clearObjectConstructParamValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectConstructParam.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectConstructParam.html#g:attr:value"
        })

objectConstructParam_value :: AttrLabelProxy "value"
objectConstructParam_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ObjectConstructParam
type instance O.AttributeList ObjectConstructParam = ObjectConstructParamAttributeList
type ObjectConstructParamAttributeList = ('[ '("pspec", ObjectConstructParamPspecFieldInfo), '("value", ObjectConstructParamValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveObjectConstructParamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveObjectConstructParamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveObjectConstructParamMethod t ObjectConstructParam, O.OverloadedMethod info ObjectConstructParam p) => OL.IsLabel t (ObjectConstructParam -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveObjectConstructParamMethod t ObjectConstructParam, O.OverloadedMethod info ObjectConstructParam p, R.HasField t ObjectConstructParam p) => R.HasField t ObjectConstructParam p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveObjectConstructParamMethod t ObjectConstructParam, O.OverloadedMethodInfo info ObjectConstructParam) => OL.IsLabel t (O.MethodProxy info ObjectConstructParam) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


