{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A union holding the value of the token.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Unions.TokenValue
    ( 

-- * Exported types
    TokenValue(..)                          ,
    newZeroTokenValue                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTokenValueMethod                 ,
#endif



 -- * Properties


-- ** vBinary #attr:vBinary#
-- | token binary integer value

    getTokenValueVBinary                    ,
    setTokenValueVBinary                    ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vBinary                      ,
#endif


-- ** vChar #attr:vChar#
-- | character value

    getTokenValueVChar                      ,
    setTokenValueVChar                      ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vChar                        ,
#endif


-- ** vComment #attr:vComment#
-- | comment value

    clearTokenValueVComment                 ,
    getTokenValueVComment                   ,
    setTokenValueVComment                   ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vComment                     ,
#endif


-- ** vError #attr:vError#
-- | error value

    getTokenValueVError                     ,
    setTokenValueVError                     ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vError                       ,
#endif


-- ** vFloat #attr:vFloat#
-- | floating point value

    getTokenValueVFloat                     ,
    setTokenValueVFloat                     ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vFloat                       ,
#endif


-- ** vHex #attr:vHex#
-- | hex integer value

    getTokenValueVHex                       ,
    setTokenValueVHex                       ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vHex                         ,
#endif


-- ** vIdentifier #attr:vIdentifier#
-- | token identifier value

    clearTokenValueVIdentifier              ,
    getTokenValueVIdentifier                ,
    setTokenValueVIdentifier                ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vIdentifier                  ,
#endif


-- ** vInt #attr:vInt#
-- | integer value

    getTokenValueVInt                       ,
    setTokenValueVInt                       ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vInt                         ,
#endif


-- ** vInt64 #attr:vInt64#
-- | 64-bit integer value

    getTokenValueVInt64                     ,
    setTokenValueVInt64                     ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vInt64                       ,
#endif


-- ** vOctal #attr:vOctal#
-- | octal integer value

    getTokenValueVOctal                     ,
    setTokenValueVOctal                     ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vOctal                       ,
#endif


-- ** vString #attr:vString#
-- | string value

    clearTokenValueVString                  ,
    getTokenValueVString                    ,
    setTokenValueVString                    ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vString                      ,
#endif


-- ** vSymbol #attr:vSymbol#
-- | token symbol value

    clearTokenValueVSymbol                  ,
    getTokenValueVSymbol                    ,
    setTokenValueVSymbol                    ,
#if defined(ENABLE_OVERLOADING)
    tokenValue_vSymbol                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TokenValue = TokenValue (SP.ManagedPtr TokenValue)
    deriving (Eq)

instance SP.ManagedPtrNewtype TokenValue where
    toManagedPtr (TokenValue p) = p

instance BoxedPtr TokenValue where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr TokenValue)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TokenValue where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'TokenValue' struct initialized to zero.
newZeroTokenValue :: MonadIO m => m TokenValue
newZeroTokenValue = liftIO $ boxedPtrCalloc >>= wrapPtr TokenValue

instance tag ~ 'AttrSet => Constructible TokenValue tag where
    new _ attrs = do
        o <- newZeroTokenValue
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@v_symbol@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vSymbol
-- @
getTokenValueVSymbol :: MonadIO m => TokenValue -> m (Ptr ())
getTokenValueVSymbol s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@v_symbol@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vSymbol 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVSymbol :: MonadIO m => TokenValue -> Ptr () -> m ()
setTokenValueVSymbol s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@v_symbol@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vSymbol
-- @
clearTokenValueVSymbol :: MonadIO m => TokenValue -> m ()
clearTokenValueVSymbol s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data TokenValueVSymbolFieldInfo
instance AttrInfo TokenValueVSymbolFieldInfo where
    type AttrBaseTypeConstraint TokenValueVSymbolFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVSymbolFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TokenValueVSymbolFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint TokenValueVSymbolFieldInfo = (~)(Ptr ())
    type AttrTransferType TokenValueVSymbolFieldInfo = (Ptr ())
    type AttrGetType TokenValueVSymbolFieldInfo = Ptr ()
    type AttrLabel TokenValueVSymbolFieldInfo = "v_symbol"
    type AttrOrigin TokenValueVSymbolFieldInfo = TokenValue
    attrGet = getTokenValueVSymbol
    attrSet = setTokenValueVSymbol
    attrConstruct = undefined
    attrClear = clearTokenValueVSymbol
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vSymbol"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vSymbol"
        })

tokenValue_vSymbol :: AttrLabelProxy "vSymbol"
tokenValue_vSymbol = AttrLabelProxy

#endif


-- | Get the value of the “@v_identifier@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vIdentifier
-- @
getTokenValueVIdentifier :: MonadIO m => TokenValue -> m (Maybe T.Text)
getTokenValueVIdentifier s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@v_identifier@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vIdentifier 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVIdentifier :: MonadIO m => TokenValue -> CString -> m ()
setTokenValueVIdentifier s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@v_identifier@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vIdentifier
-- @
clearTokenValueVIdentifier :: MonadIO m => TokenValue -> m ()
clearTokenValueVIdentifier s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TokenValueVIdentifierFieldInfo
instance AttrInfo TokenValueVIdentifierFieldInfo where
    type AttrBaseTypeConstraint TokenValueVIdentifierFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVIdentifierFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TokenValueVIdentifierFieldInfo = (~) CString
    type AttrTransferTypeConstraint TokenValueVIdentifierFieldInfo = (~)CString
    type AttrTransferType TokenValueVIdentifierFieldInfo = CString
    type AttrGetType TokenValueVIdentifierFieldInfo = Maybe T.Text
    type AttrLabel TokenValueVIdentifierFieldInfo = "v_identifier"
    type AttrOrigin TokenValueVIdentifierFieldInfo = TokenValue
    attrGet = getTokenValueVIdentifier
    attrSet = setTokenValueVIdentifier
    attrConstruct = undefined
    attrClear = clearTokenValueVIdentifier
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vIdentifier"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vIdentifier"
        })

tokenValue_vIdentifier :: AttrLabelProxy "vIdentifier"
tokenValue_vIdentifier = AttrLabelProxy

#endif


-- | Get the value of the “@v_binary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vBinary
-- @
getTokenValueVBinary :: MonadIO m => TokenValue -> m FCT.CULong
getTokenValueVBinary s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@v_binary@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vBinary 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVBinary :: MonadIO m => TokenValue -> FCT.CULong -> m ()
setTokenValueVBinary s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data TokenValueVBinaryFieldInfo
instance AttrInfo TokenValueVBinaryFieldInfo where
    type AttrBaseTypeConstraint TokenValueVBinaryFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVBinaryFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVBinaryFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint TokenValueVBinaryFieldInfo = (~)FCT.CULong
    type AttrTransferType TokenValueVBinaryFieldInfo = FCT.CULong
    type AttrGetType TokenValueVBinaryFieldInfo = FCT.CULong
    type AttrLabel TokenValueVBinaryFieldInfo = "v_binary"
    type AttrOrigin TokenValueVBinaryFieldInfo = TokenValue
    attrGet = getTokenValueVBinary
    attrSet = setTokenValueVBinary
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vBinary"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vBinary"
        })

tokenValue_vBinary :: AttrLabelProxy "vBinary"
tokenValue_vBinary = AttrLabelProxy

#endif


-- | Get the value of the “@v_octal@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vOctal
-- @
getTokenValueVOctal :: MonadIO m => TokenValue -> m FCT.CULong
getTokenValueVOctal s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@v_octal@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vOctal 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVOctal :: MonadIO m => TokenValue -> FCT.CULong -> m ()
setTokenValueVOctal s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data TokenValueVOctalFieldInfo
instance AttrInfo TokenValueVOctalFieldInfo where
    type AttrBaseTypeConstraint TokenValueVOctalFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVOctalFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVOctalFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint TokenValueVOctalFieldInfo = (~)FCT.CULong
    type AttrTransferType TokenValueVOctalFieldInfo = FCT.CULong
    type AttrGetType TokenValueVOctalFieldInfo = FCT.CULong
    type AttrLabel TokenValueVOctalFieldInfo = "v_octal"
    type AttrOrigin TokenValueVOctalFieldInfo = TokenValue
    attrGet = getTokenValueVOctal
    attrSet = setTokenValueVOctal
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vOctal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vOctal"
        })

tokenValue_vOctal :: AttrLabelProxy "vOctal"
tokenValue_vOctal = AttrLabelProxy

#endif


-- | Get the value of the “@v_int@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vInt
-- @
getTokenValueVInt :: MonadIO m => TokenValue -> m FCT.CULong
getTokenValueVInt s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@v_int@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vInt 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVInt :: MonadIO m => TokenValue -> FCT.CULong -> m ()
setTokenValueVInt s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data TokenValueVIntFieldInfo
instance AttrInfo TokenValueVIntFieldInfo where
    type AttrBaseTypeConstraint TokenValueVIntFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVIntFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVIntFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint TokenValueVIntFieldInfo = (~)FCT.CULong
    type AttrTransferType TokenValueVIntFieldInfo = FCT.CULong
    type AttrGetType TokenValueVIntFieldInfo = FCT.CULong
    type AttrLabel TokenValueVIntFieldInfo = "v_int"
    type AttrOrigin TokenValueVIntFieldInfo = TokenValue
    attrGet = getTokenValueVInt
    attrSet = setTokenValueVInt
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vInt"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vInt"
        })

tokenValue_vInt :: AttrLabelProxy "vInt"
tokenValue_vInt = AttrLabelProxy

#endif


-- | Get the value of the “@v_int64@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vInt64
-- @
getTokenValueVInt64 :: MonadIO m => TokenValue -> m Word64
getTokenValueVInt64 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word64
    return val

-- | Set the value of the “@v_int64@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vInt64 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVInt64 :: MonadIO m => TokenValue -> Word64 -> m ()
setTokenValueVInt64 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word64)

#if defined(ENABLE_OVERLOADING)
data TokenValueVInt64FieldInfo
instance AttrInfo TokenValueVInt64FieldInfo where
    type AttrBaseTypeConstraint TokenValueVInt64FieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVInt64FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVInt64FieldInfo = (~) Word64
    type AttrTransferTypeConstraint TokenValueVInt64FieldInfo = (~)Word64
    type AttrTransferType TokenValueVInt64FieldInfo = Word64
    type AttrGetType TokenValueVInt64FieldInfo = Word64
    type AttrLabel TokenValueVInt64FieldInfo = "v_int64"
    type AttrOrigin TokenValueVInt64FieldInfo = TokenValue
    attrGet = getTokenValueVInt64
    attrSet = setTokenValueVInt64
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vInt64"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vInt64"
        })

tokenValue_vInt64 :: AttrLabelProxy "vInt64"
tokenValue_vInt64 = AttrLabelProxy

#endif


-- | Get the value of the “@v_float@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vFloat
-- @
getTokenValueVFloat :: MonadIO m => TokenValue -> m Double
getTokenValueVFloat s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@v_float@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vFloat 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVFloat :: MonadIO m => TokenValue -> Double -> m ()
setTokenValueVFloat s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data TokenValueVFloatFieldInfo
instance AttrInfo TokenValueVFloatFieldInfo where
    type AttrBaseTypeConstraint TokenValueVFloatFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVFloatFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVFloatFieldInfo = (~) Double
    type AttrTransferTypeConstraint TokenValueVFloatFieldInfo = (~)Double
    type AttrTransferType TokenValueVFloatFieldInfo = Double
    type AttrGetType TokenValueVFloatFieldInfo = Double
    type AttrLabel TokenValueVFloatFieldInfo = "v_float"
    type AttrOrigin TokenValueVFloatFieldInfo = TokenValue
    attrGet = getTokenValueVFloat
    attrSet = setTokenValueVFloat
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vFloat"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vFloat"
        })

tokenValue_vFloat :: AttrLabelProxy "vFloat"
tokenValue_vFloat = AttrLabelProxy

#endif


-- | Get the value of the “@v_hex@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vHex
-- @
getTokenValueVHex :: MonadIO m => TokenValue -> m FCT.CULong
getTokenValueVHex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@v_hex@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vHex 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVHex :: MonadIO m => TokenValue -> FCT.CULong -> m ()
setTokenValueVHex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data TokenValueVHexFieldInfo
instance AttrInfo TokenValueVHexFieldInfo where
    type AttrBaseTypeConstraint TokenValueVHexFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVHexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVHexFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint TokenValueVHexFieldInfo = (~)FCT.CULong
    type AttrTransferType TokenValueVHexFieldInfo = FCT.CULong
    type AttrGetType TokenValueVHexFieldInfo = FCT.CULong
    type AttrLabel TokenValueVHexFieldInfo = "v_hex"
    type AttrOrigin TokenValueVHexFieldInfo = TokenValue
    attrGet = getTokenValueVHex
    attrSet = setTokenValueVHex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vHex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vHex"
        })

tokenValue_vHex :: AttrLabelProxy "vHex"
tokenValue_vHex = AttrLabelProxy

#endif


-- | Get the value of the “@v_string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vString
-- @
getTokenValueVString :: MonadIO m => TokenValue -> m (Maybe T.Text)
getTokenValueVString s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@v_string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vString 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVString :: MonadIO m => TokenValue -> CString -> m ()
setTokenValueVString s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@v_string@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vString
-- @
clearTokenValueVString :: MonadIO m => TokenValue -> m ()
clearTokenValueVString s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TokenValueVStringFieldInfo
instance AttrInfo TokenValueVStringFieldInfo where
    type AttrBaseTypeConstraint TokenValueVStringFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVStringFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TokenValueVStringFieldInfo = (~) CString
    type AttrTransferTypeConstraint TokenValueVStringFieldInfo = (~)CString
    type AttrTransferType TokenValueVStringFieldInfo = CString
    type AttrGetType TokenValueVStringFieldInfo = Maybe T.Text
    type AttrLabel TokenValueVStringFieldInfo = "v_string"
    type AttrOrigin TokenValueVStringFieldInfo = TokenValue
    attrGet = getTokenValueVString
    attrSet = setTokenValueVString
    attrConstruct = undefined
    attrClear = clearTokenValueVString
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vString"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vString"
        })

tokenValue_vString :: AttrLabelProxy "vString"
tokenValue_vString = AttrLabelProxy

#endif


-- | Get the value of the “@v_comment@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vComment
-- @
getTokenValueVComment :: MonadIO m => TokenValue -> m (Maybe T.Text)
getTokenValueVComment s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@v_comment@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vComment 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVComment :: MonadIO m => TokenValue -> CString -> m ()
setTokenValueVComment s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@v_comment@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vComment
-- @
clearTokenValueVComment :: MonadIO m => TokenValue -> m ()
clearTokenValueVComment s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TokenValueVCommentFieldInfo
instance AttrInfo TokenValueVCommentFieldInfo where
    type AttrBaseTypeConstraint TokenValueVCommentFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVCommentFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TokenValueVCommentFieldInfo = (~) CString
    type AttrTransferTypeConstraint TokenValueVCommentFieldInfo = (~)CString
    type AttrTransferType TokenValueVCommentFieldInfo = CString
    type AttrGetType TokenValueVCommentFieldInfo = Maybe T.Text
    type AttrLabel TokenValueVCommentFieldInfo = "v_comment"
    type AttrOrigin TokenValueVCommentFieldInfo = TokenValue
    attrGet = getTokenValueVComment
    attrSet = setTokenValueVComment
    attrConstruct = undefined
    attrClear = clearTokenValueVComment
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vComment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vComment"
        })

tokenValue_vComment :: AttrLabelProxy "vComment"
tokenValue_vComment = AttrLabelProxy

#endif


-- | Get the value of the “@v_char@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vChar
-- @
getTokenValueVChar :: MonadIO m => TokenValue -> m Word8
getTokenValueVChar s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word8
    return val

-- | Set the value of the “@v_char@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vChar 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVChar :: MonadIO m => TokenValue -> Word8 -> m ()
setTokenValueVChar s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data TokenValueVCharFieldInfo
instance AttrInfo TokenValueVCharFieldInfo where
    type AttrBaseTypeConstraint TokenValueVCharFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVCharFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVCharFieldInfo = (~) Word8
    type AttrTransferTypeConstraint TokenValueVCharFieldInfo = (~)Word8
    type AttrTransferType TokenValueVCharFieldInfo = Word8
    type AttrGetType TokenValueVCharFieldInfo = Word8
    type AttrLabel TokenValueVCharFieldInfo = "v_char"
    type AttrOrigin TokenValueVCharFieldInfo = TokenValue
    attrGet = getTokenValueVChar
    attrSet = setTokenValueVChar
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vChar"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vChar"
        })

tokenValue_vChar :: AttrLabelProxy "vChar"
tokenValue_vChar = AttrLabelProxy

#endif


-- | Get the value of the “@v_error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tokenValue #vError
-- @
getTokenValueVError :: MonadIO m => TokenValue -> m Word32
getTokenValueVError s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@v_error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tokenValue [ #vError 'Data.GI.Base.Attributes.:=' value ]
-- @
setTokenValueVError :: MonadIO m => TokenValue -> Word32 -> m ()
setTokenValueVError s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TokenValueVErrorFieldInfo
instance AttrInfo TokenValueVErrorFieldInfo where
    type AttrBaseTypeConstraint TokenValueVErrorFieldInfo = (~) TokenValue
    type AttrAllowedOps TokenValueVErrorFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TokenValueVErrorFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TokenValueVErrorFieldInfo = (~)Word32
    type AttrTransferType TokenValueVErrorFieldInfo = Word32
    type AttrGetType TokenValueVErrorFieldInfo = Word32
    type AttrLabel TokenValueVErrorFieldInfo = "v_error"
    type AttrOrigin TokenValueVErrorFieldInfo = TokenValue
    attrGet = getTokenValueVError
    attrSet = setTokenValueVError
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.TokenValue.vError"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Unions-TokenValue.html#g:attr:vError"
        })

tokenValue_vError :: AttrLabelProxy "vError"
tokenValue_vError = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TokenValue
type instance O.AttributeList TokenValue = TokenValueAttributeList
type TokenValueAttributeList = ('[ '("vSymbol", TokenValueVSymbolFieldInfo), '("vIdentifier", TokenValueVIdentifierFieldInfo), '("vBinary", TokenValueVBinaryFieldInfo), '("vOctal", TokenValueVOctalFieldInfo), '("vInt", TokenValueVIntFieldInfo), '("vInt64", TokenValueVInt64FieldInfo), '("vFloat", TokenValueVFloatFieldInfo), '("vHex", TokenValueVHexFieldInfo), '("vString", TokenValueVStringFieldInfo), '("vComment", TokenValueVCommentFieldInfo), '("vChar", TokenValueVCharFieldInfo), '("vError", TokenValueVErrorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTokenValueMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTokenValueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTokenValueMethod t TokenValue, O.OverloadedMethod info TokenValue p) => OL.IsLabel t (TokenValue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTokenValueMethod t TokenValue, O.OverloadedMethod info TokenValue p, R.HasField t TokenValue p) => R.HasField t TokenValue p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTokenValueMethod t TokenValue, O.OverloadedMethodInfo info TokenValue) => OL.IsLabel t (O.MethodProxy info TokenValue) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


