

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Functions
    ( 

 -- * Methods


-- ** x11AtomToXatom #method:x11AtomToXatom#

    x11AtomToXatom                          ,


-- ** x11AtomToXatomForDisplay #method:x11AtomToXatomForDisplay#

    x11AtomToXatomForDisplay                ,


-- ** x11DeviceGetId #method:x11DeviceGetId#

    x11DeviceGetId                          ,


-- ** x11DeviceManagerLookup #method:x11DeviceManagerLookup#

    x11DeviceManagerLookup                  ,


-- ** x11FreeCompoundText #method:x11FreeCompoundText#

    x11FreeCompoundText                     ,


-- ** x11FreeTextList #method:x11FreeTextList#

    x11FreeTextList                         ,


-- ** x11GetDefaultRootXwindow #method:x11GetDefaultRootXwindow#

    x11GetDefaultRootXwindow                ,


-- ** x11GetDefaultScreen #method:x11GetDefaultScreen#

    x11GetDefaultScreen                     ,


-- ** x11GetDefaultXdisplay #method:x11GetDefaultXdisplay#

    x11GetDefaultXdisplay                   ,


-- ** x11GetParentRelativePattern #method:x11GetParentRelativePattern#

    x11GetParentRelativePattern             ,


-- ** x11GetServerTime #method:x11GetServerTime#

    x11GetServerTime                        ,


-- ** x11GetXatomByName #method:x11GetXatomByName#

    x11GetXatomByName                       ,


-- ** x11GetXatomByNameForDisplay #method:x11GetXatomByNameForDisplay#

    x11GetXatomByNameForDisplay             ,


-- ** x11GetXatomName #method:x11GetXatomName#

    x11GetXatomName                         ,


-- ** x11GetXatomNameForDisplay #method:x11GetXatomNameForDisplay#

    x11GetXatomNameForDisplay               ,


-- ** x11GrabServer #method:x11GrabServer#

    x11GrabServer                           ,


-- ** x11LookupXdisplay #method:x11LookupXdisplay#

    x11LookupXdisplay                       ,


-- ** x11RegisterStandardEventType #method:x11RegisterStandardEventType#

    x11RegisterStandardEventType            ,


-- ** x11SetSmClientId #method:x11SetSmClientId#

    x11SetSmClientId                        ,


-- ** x11UngrabServer #method:x11UngrabServer#

    x11UngrabServer                         ,


-- ** x11XatomToAtom #method:x11XatomToAtom#

    x11XatomToAtom                          ,


-- ** x11XatomToAtomForDisplay #method:x11XatomToAtomForDisplay#

    x11XatomToAtomForDisplay                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceCore as GdkX11.X11DeviceCore
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceManagerCore as GdkX11.X11DeviceManagerCore
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Window as GdkX11.X11Window
import qualified GI.Xlib.Structs.Display as Xlib.Display

#else
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceCore as GdkX11.X11DeviceCore
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11DeviceManagerCore as GdkX11.X11DeviceManagerCore
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Window as GdkX11.X11Window
import qualified GI.Xlib.Structs.Display as Xlib.Display

#endif

-- function x11_xatom_to_atom_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xatom"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X atom" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Atom" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_xatom_to_atom_for_display" gdk_x11_xatom_to_atom_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    FCT.CULong ->                           -- xatom : TBasicType TULong
    IO (Ptr Gdk.Atom.Atom)

-- | Convert from an X atom for a t'GI.Gdk.Objects.Display.Display' to the corresponding
-- t'GI.Gdk.Structs.Atom.Atom'.
-- 
-- /Since: 2.2/
x11XatomToAtomForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: A t'GI.Gdk.Objects.Display.Display'
    -> FCT.CULong
    -- ^ /@xatom@/: an X atom
    -> m Gdk.Atom.Atom
    -- ^ __Returns:__ the corresponding t'GI.Gdk.Structs.Atom.Atom'.
x11XatomToAtomForDisplay display xatom = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_xatom_to_atom_for_display display' xatom
    checkUnexpectedReturnNULL "x11XatomToAtomForDisplay" result
    result' <- (newPtr Gdk.Atom.Atom) result
    touchManagedPtr display
    return result'


-- function x11_xatom_to_atom
-- Args: [ Arg
--           { argCName = "xatom"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X atom for the default GDK display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Atom" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_xatom_to_atom" gdk_x11_xatom_to_atom :: 
    FCT.CULong ->                           -- xatom : TBasicType TULong
    IO (Ptr Gdk.Atom.Atom)

-- | Convert from an X atom for the default display to the corresponding
-- t'GI.Gdk.Structs.Atom.Atom'.
x11XatomToAtom ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CULong
    -- ^ /@xatom@/: an X atom for the default GDK display
    -> m Gdk.Atom.Atom
    -- ^ __Returns:__ the corresponding G@/dkAtom/@.
x11XatomToAtom xatom = liftIO $ do
    result <- gdk_x11_xatom_to_atom xatom
    checkUnexpectedReturnNULL "x11XatomToAtom" result
    result' <- (newPtr Gdk.Atom.Atom) result
    return result'


-- function x11_ungrab_server
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_ungrab_server" gdk_x11_ungrab_server :: 
    IO ()

-- | Ungrab the default display after it has been grabbed with
-- 'GI.GdkX11.Functions.x11GrabServer'.
x11UngrabServer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
x11UngrabServer  = liftIO $ do
    gdk_x11_ungrab_server
    return ()


-- function x11_set_sm_client_id
-- Args: [ Arg
--           { argCName = "sm_client_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the client id assigned by the session manager\n   when the connection was opened, or %NULL to remove the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_set_sm_client_id" gdk_x11_set_sm_client_id :: 
    CString ->                              -- sm_client_id : TBasicType TUTF8
    IO ()

-- | Sets the @SM_CLIENT_ID@ property on the application’s leader window so that
-- the window manager can save the application’s state using the X11R6 ICCCM
-- session management protocol.
-- 
-- See the X Session Management Library documentation for more information on
-- session management and the Inter-Client Communication Conventions Manual
-- 
-- /Since: 2.24/
x11SetSmClientId ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@smClientId@/: the client id assigned by the session manager
    --    when the connection was opened, or 'P.Nothing' to remove the property.
    -> m ()
x11SetSmClientId smClientId = liftIO $ do
    maybeSmClientId <- case smClientId of
        Nothing -> return FP.nullPtr
        Just jSmClientId -> do
            jSmClientId' <- textToCString jSmClientId
            return jSmClientId'
    gdk_x11_set_sm_client_id maybeSmClientId
    freeMem maybeSmClientId
    return ()


-- function x11_register_standard_event_type
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_base"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first event type code to register"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_events"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of event type codes to register"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_register_standard_event_type" gdk_x11_register_standard_event_type :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Int32 ->                                -- event_base : TBasicType TInt
    Int32 ->                                -- n_events : TBasicType TInt
    IO ()

-- | Registers interest in receiving extension events with type codes
-- between /@eventBase@/ and @event_base + n_events - 1@.
-- The registered events must have the window field in the same place
-- as core X events (this is not the case for e.g. XKB extension events).
-- 
-- If an event type is registered, events of this type will go through
-- global and window-specific filters (see @/gdk_window_add_filter()/@).
-- Unregistered events will only go through global filters.
-- GDK may register the events of some X extensions on its own.
-- 
-- This function should only be needed in unusual circumstances, e.g.
-- when filtering XInput extension events on the root window.
-- 
-- /Since: 2.4/
x11RegisterStandardEventType ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Int32
    -- ^ /@eventBase@/: first event type code to register
    -> Int32
    -- ^ /@nEvents@/: number of event type codes to register
    -> m ()
x11RegisterStandardEventType display eventBase nEvents = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_register_standard_event_type display' eventBase nEvents
    touchManagedPtr display
    return ()


-- function x11_lookup_xdisplay
-- Args: [ Arg
--           { argCName = "xdisplay"
--           , argType =
--               TInterface Name { namespace = "xlib" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to an X Display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_lookup_xdisplay" gdk_x11_lookup_xdisplay :: 
    Ptr Xlib.Display.Display ->             -- xdisplay : TInterface (Name {namespace = "xlib", name = "Display"})
    IO (Ptr GdkX11.X11Display.X11Display)

-- | Find the t'GI.Gdk.Objects.Display.Display' corresponding to /@xdisplay@/, if any exists.
-- 
-- /Since: 2.2/
x11LookupXdisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Xlib.Display.Display
    -- ^ /@xdisplay@/: a pointer to an X Display
    -> m GdkX11.X11Display.X11Display
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Display.Display', if found, otherwise 'P.Nothing'.
x11LookupXdisplay xdisplay = liftIO $ do
    xdisplay' <- unsafeManagedPtrGetPtr xdisplay
    result <- gdk_x11_lookup_xdisplay xdisplay'
    checkUnexpectedReturnNULL "x11LookupXdisplay" result
    result' <- (newObject GdkX11.X11Display.X11Display) result
    touchManagedPtr xdisplay
    return result'


-- function x11_grab_server
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_grab_server" gdk_x11_grab_server :: 
    IO ()

-- | Call 'GI.GdkX11.Objects.X11Display.x11DisplayGrab' on the default display.
-- To ungrab the server again, use 'GI.GdkX11.Functions.x11UngrabServer'.
-- 
-- 'GI.GdkX11.Functions.x11GrabServer'\/'GI.GdkX11.Functions.x11UngrabServer' calls can be nested.
x11GrabServer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
x11GrabServer  = liftIO $ do
    gdk_x11_grab_server
    return ()


-- function x11_get_xatom_name_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkDisplay where @xatom is defined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xatom"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X atom" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_name_for_display" gdk_x11_get_xatom_name_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    FCT.CULong ->                           -- xatom : TBasicType TULong
    IO CString

-- | Returns the name of an X atom for its display. This
-- function is meant mainly for debugging, so for convenience, unlike
-- @/XAtomName()/@ and 'GI.Gdk.Structs.Atom.atomName', the result doesn’t need to
-- be freed.
-- 
-- /Since: 2.2/
x11GetXatomNameForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' where /@xatom@/ is defined
    -> FCT.CULong
    -- ^ /@xatom@/: an X atom
    -> m T.Text
    -- ^ __Returns:__ name of the X atom; this string is owned by GDK,
    --   so it shouldn’t be modifed or freed.
x11GetXatomNameForDisplay display xatom = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_get_xatom_name_for_display display' xatom
    checkUnexpectedReturnNULL "x11GetXatomNameForDisplay" result
    result' <- cstringToText result
    touchManagedPtr display
    return result'


-- function x11_get_xatom_name
-- Args: [ Arg
--           { argCName = "xatom"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X atom for GDK\8217s default display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_name" gdk_x11_get_xatom_name :: 
    FCT.CULong ->                           -- xatom : TBasicType TULong
    IO CString

-- | Returns the name of an X atom for GDK’s default display. This
-- function is meant mainly for debugging, so for convenience, unlike
-- @/XAtomName()/@ and 'GI.Gdk.Structs.Atom.atomName', the result
-- doesn’t need to be freed. Also, this function will never return 'P.Nothing',
-- even if /@xatom@/ is invalid.
x11GetXatomName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CULong
    -- ^ /@xatom@/: an X atom for GDK’s default display
    -> m T.Text
    -- ^ __Returns:__ name of the X atom; this string is owned by GTK+,
    --   so it shouldn’t be modifed or freed.
x11GetXatomName xatom = liftIO $ do
    result <- gdk_x11_get_xatom_name xatom
    checkUnexpectedReturnNULL "x11GetXatomName" result
    result' <- cstringToText result
    return result'


-- function x11_get_xatom_by_name_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "atom_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_by_name_for_display" gdk_x11_get_xatom_by_name_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- atom_name : TBasicType TUTF8
    IO FCT.CULong

-- | Returns the X atom for a t'GI.Gdk.Objects.Display.Display' corresponding to /@atomName@/.
-- This function caches the result, so if called repeatedly it is much
-- faster than @/XInternAtom()/@, which is a round trip to the server each time.
-- 
-- /Since: 2.2/
x11GetXatomByNameForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> T.Text
    -- ^ /@atomName@/: a string
    -> m FCT.CULong
    -- ^ __Returns:__ a X atom for a t'GI.Gdk.Objects.Display.Display'
x11GetXatomByNameForDisplay display atomName = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    atomName' <- textToCString atomName
    result <- gdk_x11_get_xatom_by_name_for_display display' atomName'
    touchManagedPtr display
    freeMem atomName'
    return result


-- function x11_get_xatom_by_name
-- Args: [ Arg
--           { argCName = "atom_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_xatom_by_name" gdk_x11_get_xatom_by_name :: 
    CString ->                              -- atom_name : TBasicType TUTF8
    IO FCT.CULong

-- | Returns the X atom for GDK’s default display corresponding to /@atomName@/.
-- This function caches the result, so if called repeatedly it is much
-- faster than @/XInternAtom()/@, which is a round trip to the server each time.
x11GetXatomByName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@atomName@/: a string
    -> m FCT.CULong
    -- ^ __Returns:__ a X atom for GDK’s default display.
x11GetXatomByName atomName = liftIO $ do
    atomName' <- textToCString atomName
    result <- gdk_x11_get_xatom_by_name atomName'
    freeMem atomName'
    return result


-- function x11_get_server_time
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkWindow, used for communication\n         with the server.  The window must have\n         GDK_PROPERTY_CHANGE_MASK in its events mask or a hang will\n         result."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_server_time" gdk_x11_get_server_time :: 
    Ptr GdkX11.X11Window.X11Window ->       -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    IO Word32

-- | Routine to get the current X server time stamp.
x11GetServerTime ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Window.IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window', used for communication
    --          with the server.  The window must have
    --          GDK_PROPERTY_CHANGE_MASK in its events mask or a hang will
    --          result.
    -> m Word32
    -- ^ __Returns:__ the time stamp.
x11GetServerTime window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_x11_get_server_time window'
    touchManagedPtr window
    return result


-- function x11_get_parent_relative_pattern
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Pattern" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_parent_relative_pattern" gdk_x11_get_parent_relative_pattern :: 
    IO (Ptr Cairo.Pattern.Pattern)

{-# DEPRECATED x11GetParentRelativePattern ["(Since version 3.24)","Don\\'t use this function"] #-}
-- | Used with 'GI.Gdk.Objects.Window.windowSetBackgroundPattern' to inherit background from
-- parent window. Useful for imitating transparency when compositing is not
-- available. Otherwise behaves like a transparent pattern.
-- 
-- /Since: 3.24.2/
x11GetParentRelativePattern ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Cairo.Pattern.Pattern
x11GetParentRelativePattern  = liftIO $ do
    result <- gdk_x11_get_parent_relative_pattern
    checkUnexpectedReturnNULL "x11GetParentRelativePattern" result
    result' <- (wrapBoxed Cairo.Pattern.Pattern) result
    return result'


-- function x11_get_default_xdisplay
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_default_xdisplay" gdk_x11_get_default_xdisplay :: 
    IO (Ptr Xlib.Display.Display)

-- | Gets the default GTK+ display.
x11GetDefaultXdisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Xlib.Display.Display
    -- ^ __Returns:__ the Xlib Display* for
    -- the display specified in the @--display@ command
    -- line option or the @DISPLAY@ environment variable.
x11GetDefaultXdisplay  = liftIO $ do
    result <- gdk_x11_get_default_xdisplay
    checkUnexpectedReturnNULL "x11GetDefaultXdisplay" result
    result' <- (newPtr Xlib.Display.Display) result
    return result'


-- function x11_get_default_screen
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_default_screen" gdk_x11_get_default_screen :: 
    IO Int32

-- | Gets the default GTK+ screen number.
x11GetDefaultScreen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ returns the screen number specified by
    --   the --display command line option or the DISPLAY environment
    --   variable when 'GI.Gdk.Functions.init' calls 'GI.Xlib.Functions.openDisplay'.
x11GetDefaultScreen  = liftIO $ do
    result <- gdk_x11_get_default_screen
    return result


-- function x11_get_default_root_xwindow
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_get_default_root_xwindow" gdk_x11_get_default_root_xwindow :: 
    IO FCT.CULong

-- | Gets the root window of the default screen
-- (see 'GI.GdkX11.Functions.x11GetDefaultScreen').
x11GetDefaultRootXwindow ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m FCT.CULong
    -- ^ __Returns:__ an Xlib Window.
x11GetDefaultRootXwindow  = liftIO $ do
    result <- gdk_x11_get_default_root_xwindow
    return result


-- function x11_free_text_list
-- Args: [ Arg
--           { argCName = "list"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the value stored in the @list parameter by\n  a call to gdk_x11_display_text_property_to_text_list()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_free_text_list" gdk_x11_free_text_list :: 
    CString ->                              -- list : TBasicType TUTF8
    IO ()

-- | Frees the array of strings created by
-- 'GI.GdkX11.Objects.X11Display.x11DisplayTextPropertyToTextList'.
-- 
-- /Since: 2.24/
x11FreeTextList ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@list@/: the value stored in the /@list@/ parameter by
    --   a call to 'GI.GdkX11.Objects.X11Display.x11DisplayTextPropertyToTextList'.
    -> m ()
x11FreeTextList list = liftIO $ do
    list' <- textToCString list
    gdk_x11_free_text_list list'
    freeMem list'
    return ()


-- function x11_free_compound_text
-- Args: [ Arg
--           { argCName = "ctext"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The pointer stored in @ctext from a call to\n  gdk_x11_display_string_to_compound_text()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_free_compound_text" gdk_x11_free_compound_text :: 
    Word8 ->                                -- ctext : TBasicType TUInt8
    IO ()

-- | Frees the data returned from 'GI.GdkX11.Objects.X11Display.x11DisplayStringToCompoundText'.
-- 
-- /Since: 2.24/
x11FreeCompoundText ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word8
    -- ^ /@ctext@/: The pointer stored in /@ctext@/ from a call to
    --   'GI.GdkX11.Objects.X11Display.x11DisplayStringToCompoundText'.
    -> m ()
x11FreeCompoundText ctext = liftIO $ do
    gdk_x11_free_compound_text ctext
    return ()


-- function x11_device_manager_lookup
-- Args: [ Arg
--           { argCName = "device_manager"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkX11" , name = "X11DeviceManagerCore" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDeviceManager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a device ID, as understood by the XInput2 protocol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11DeviceCore" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_device_manager_lookup" gdk_x11_device_manager_lookup :: 
    Ptr GdkX11.X11DeviceManagerCore.X11DeviceManagerCore -> -- device_manager : TInterface (Name {namespace = "GdkX11", name = "X11DeviceManagerCore"})
    Int32 ->                                -- device_id : TBasicType TInt
    IO (Ptr GdkX11.X11DeviceCore.X11DeviceCore)

-- | Returns the t'GI.Gdk.Objects.Device.Device' that wraps the given device ID.
-- 
-- /Since: 3.2/
x11DeviceManagerLookup ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11DeviceManagerCore.IsX11DeviceManagerCore a) =>
    a
    -- ^ /@deviceManager@/: a t'GI.Gdk.Objects.DeviceManager.DeviceManager'
    -> Int32
    -- ^ /@deviceId@/: a device ID, as understood by the XInput2 protocol
    -> m (Maybe GdkX11.X11DeviceCore.X11DeviceCore)
    -- ^ __Returns:__ The t'GI.Gdk.Objects.Device.Device' wrapping the device ID,
    --          or 'P.Nothing' if the given ID doesn’t currently represent a device.
x11DeviceManagerLookup deviceManager deviceId = liftIO $ do
    deviceManager' <- unsafeManagedPtrCastPtr deviceManager
    result <- gdk_x11_device_manager_lookup deviceManager' deviceId
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GdkX11.X11DeviceCore.X11DeviceCore) result'
        return result''
    touchManagedPtr deviceManager
    return maybeResult


-- function x11_device_get_id
-- Args: [ Arg
--           { argCName = "device"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11DeviceCore" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_device_get_id" gdk_x11_device_get_id :: 
    Ptr GdkX11.X11DeviceCore.X11DeviceCore -> -- device : TInterface (Name {namespace = "GdkX11", name = "X11DeviceCore"})
    IO Int32

-- | Returns the device ID as seen by XInput2.
-- 
-- > If 'GI.Gdk.Functions.disableMultidevice' has been called, this function
-- > will respectively return 2\/3 for the core pointer and keyboard,
-- > (matching the IDs for the Virtual Core Pointer and Keyboard in
-- > XInput 2), but calling this function on any slave devices (i.e.
-- > those managed via XInput 1.x), will return 0.
-- 
-- /Since: 3.2/
x11DeviceGetId ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11DeviceCore.IsX11DeviceCore a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Int32
    -- ^ __Returns:__ the XInput2 device ID.
x11DeviceGetId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_x11_device_get_id device'
    touchManagedPtr device
    return result


-- function x11_atom_to_xatom_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "atom"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GdkAtom, or %GDK_NONE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_atom_to_xatom_for_display" gdk_x11_atom_to_xatom_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Ptr Gdk.Atom.Atom ->                    -- atom : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO FCT.CULong

-- | Converts from a t'GI.Gdk.Structs.Atom.Atom' to the X atom for a t'GI.Gdk.Objects.Display.Display'
-- with the same string value. The special value @/GDK_NONE/@
-- is converted to @/None/@.
-- 
-- /Since: 2.2/
x11AtomToXatomForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: A t'GI.Gdk.Objects.Display.Display'
    -> Gdk.Atom.Atom
    -- ^ /@atom@/: A t'GI.Gdk.Structs.Atom.Atom', or @/GDK_NONE/@
    -> m FCT.CULong
    -- ^ __Returns:__ the X atom corresponding to /@atom@/, or @/None/@
x11AtomToXatomForDisplay display atom = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    atom' <- unsafeManagedPtrGetPtr atom
    result <- gdk_x11_atom_to_xatom_for_display display' atom'
    touchManagedPtr display
    touchManagedPtr atom
    return result


-- function x11_atom_to_xatom
-- Args: [ Arg
--           { argCName = "atom"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GdkAtom" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_atom_to_xatom" gdk_x11_atom_to_xatom :: 
    Ptr Gdk.Atom.Atom ->                    -- atom : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO FCT.CULong

-- | Converts from a t'GI.Gdk.Structs.Atom.Atom' to the X atom for the default GDK display
-- with the same string value.
x11AtomToXatom ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Atom.Atom
    -- ^ /@atom@/: A t'GI.Gdk.Structs.Atom.Atom'
    -> m FCT.CULong
    -- ^ __Returns:__ the X atom corresponding to /@atom@/.
x11AtomToXatom atom = liftIO $ do
    atom' <- unsafeManagedPtrGetPtr atom
    result <- gdk_x11_atom_to_xatom atom'
    touchManagedPtr atom
    return result



