/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-pxi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_pxi_ota_spec_check_result_to_string(FuPxiOtaSpecCheckResult val)
{
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_OK)
        return "ok";
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_FW_OUT_OF_BOUNDS)
        return "fw-out-of-bounds";
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_PROCESS_ILLEGAL)
        return "process-illegal";
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_RECONNECT)
        return "reconnect";
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_FW_IMG_VERSION_ERROR)
        return "fw-img-version-error";
    if (val == FU_PXI_OTA_SPEC_CHECK_RESULT_DEVICE_LOW_BATTERY)
        return "device-low-battery";
    return NULL;
}

const gchar *
fu_pxi_wireless_module_ota_rsp_code_to_string(FuPxiWirelessModuleOtaRspCode val)
{
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_OK)
        return "ok";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_FINISH)
        return "finish";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_FAIL)
        return "fail";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_ERROR)
        return "error";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_WRITE_PKT_LEN_ERROR)
        return "write-pkt-len-error";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_WRITE_PKT_TOTAL_SIZE_ERROR)
        return "write-pkt-total-size-error";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_READ_PKT_LEN_ERROR)
        return "read-pkt-len-error";
    if (val == FU_PXI_WIRELESS_MODULE_OTA_RSP_CODE_NOT_READY)
        return "not-ready";
    return NULL;
}



/**
 * fu_struct_pxi_ota_fw_state_ref: (skip):
 **/
FuStructPxiOtaFwState *
fu_struct_pxi_ota_fw_state_ref(FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pxi_ota_fw_state_unref: (skip):
 **/
void
fu_struct_pxi_ota_fw_state_unref(FuStructPxiOtaFwState *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPxiOtaFwState refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pxi_ota_fw_state_new_internal: (skip):
 **/
static FuStructPxiOtaFwState *
fu_struct_pxi_ota_fw_state_new_internal(void)
{
    FuStructPxiOtaFwState *st = g_new0(FuStructPxiOtaFwState, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pxi_ota_fw_state_get_status: (skip):
 **/
guint8
fu_struct_pxi_ota_fw_state_get_status(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_pxi_ota_fw_state_get_new_flow: (skip):
 **/
guint8
fu_struct_pxi_ota_fw_state_get_new_flow(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_pxi_ota_fw_state_get_offset: (skip):
 **/
guint16
fu_struct_pxi_ota_fw_state_get_offset(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pxi_ota_fw_state_get_checksum: (skip):
 **/
guint16
fu_struct_pxi_ota_fw_state_get_checksum(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pxi_ota_fw_state_get_max_object_size: (skip):
 **/
guint32
fu_struct_pxi_ota_fw_state_get_max_object_size(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pxi_ota_fw_state_get_mtu_size: (skip):
 **/
guint16
fu_struct_pxi_ota_fw_state_get_mtu_size(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pxi_ota_fw_state_get_prn_threshold: (skip):
 **/
guint16
fu_struct_pxi_ota_fw_state_get_prn_threshold(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pxi_ota_fw_state_get_spec_check_result: (skip):
 **/
guint8
fu_struct_pxi_ota_fw_state_get_spec_check_result(const FuStructPxiOtaFwState *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}

/* setters */
/**
 * fu_struct_pxi_ota_fw_state_to_string: (skip):
 **/
static gchar *
fu_struct_pxi_ota_fw_state_to_string(const FuStructPxiOtaFwState *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPxiOtaFwState:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_status(st));
    g_string_append_printf(str, "  new_flow: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_new_flow(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_offset(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_checksum(st));
    g_string_append_printf(str, "  max_object_size: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_max_object_size(st));
    g_string_append_printf(str, "  mtu_size: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_mtu_size(st));
    g_string_append_printf(str, "  prn_threshold: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_prn_threshold(st));
    g_string_append_printf(str, "  spec_check_result: 0x%x\n",
                           (guint) fu_struct_pxi_ota_fw_state_get_spec_check_result(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pxi_ota_fw_state_validate_internal(FuStructPxiOtaFwState *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pxi_ota_fw_state_parse_internal(FuStructPxiOtaFwState *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pxi_ota_fw_state_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pxi_ota_fw_state_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_pxi_ota_fw_state_parse: (skip):
 **/
FuStructPxiOtaFwState *
fu_struct_pxi_ota_fw_state_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructPxiOtaFwState) st = fu_struct_pxi_ota_fw_state_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 15, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructPxiOtaFwState: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 15);
    if (!fu_struct_pxi_ota_fw_state_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
