/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-intel-usb4-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_intel_usb4_opcode_to_string(FuIntelUsb4Opcode val)
{
    if (val == FU_INTEL_USB4_OPCODE_NVM_WRITE)
        return "nvm-write";
    if (val == FU_INTEL_USB4_OPCODE_NVM_AUTH_WRITE)
        return "nvm-auth-write";
    if (val == FU_INTEL_USB4_OPCODE_NVM_READ)
        return "nvm-read";
    if (val == FU_INTEL_USB4_OPCODE_NVM_SET_OFFSET)
        return "nvm-set-offset";
    if (val == FU_INTEL_USB4_OPCODE_DROM_READ)
        return "drom-read";
    return NULL;
}
/**
 * fu_struct_intel_usb4_mbox_ref: (skip):
 **/
FuStructIntelUsb4Mbox *
fu_struct_intel_usb4_mbox_ref(FuStructIntelUsb4Mbox *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_usb4_mbox_unref: (skip):
 **/
void
fu_struct_intel_usb4_mbox_unref(FuStructIntelUsb4Mbox *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelUsb4Mbox refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_usb4_mbox_new_internal: (skip):
 **/
static FuStructIntelUsb4Mbox *
fu_struct_intel_usb4_mbox_new_internal(void)
{
    FuStructIntelUsb4Mbox *st = g_new0(FuStructIntelUsb4Mbox, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_intel_usb4_mbox_get_opcode: (skip):
 **/
FuIntelUsb4Opcode
fu_struct_intel_usb4_mbox_get_opcode(const FuStructIntelUsb4Mbox *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_usb4_mbox_get_status: (skip):
 **/
guint8
fu_struct_intel_usb4_mbox_get_status(const FuStructIntelUsb4Mbox *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_intel_usb4_mbox_set_opcode: (skip):
 **/
void
fu_struct_intel_usb4_mbox_set_opcode(FuStructIntelUsb4Mbox *st, FuIntelUsb4Opcode value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_usb4_mbox_set_status: (skip):
 **/
void
fu_struct_intel_usb4_mbox_set_status(FuStructIntelUsb4Mbox *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_intel_usb4_mbox_new: (skip):
 **/
FuStructIntelUsb4Mbox *
fu_struct_intel_usb4_mbox_new(void)
{
    FuStructIntelUsb4Mbox *st = fu_struct_intel_usb4_mbox_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_intel_usb4_mbox_to_string: (skip):
 **/
static gchar *
fu_struct_intel_usb4_mbox_to_string(const FuStructIntelUsb4Mbox *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelUsb4Mbox:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_intel_usb4_opcode_to_string(fu_struct_intel_usb4_mbox_get_opcode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  opcode: 0x%x [%s]\n", (guint) fu_struct_intel_usb4_mbox_get_opcode(st), tmp);
        } else {
            g_string_append_printf(str, "  opcode: 0x%x\n", (guint) fu_struct_intel_usb4_mbox_get_opcode(st));
        }
    }
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_intel_usb4_mbox_get_status(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_usb4_mbox_validate_internal(FuStructIntelUsb4Mbox *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_intel_usb4_mbox_parse_internal(FuStructIntelUsb4Mbox *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_usb4_mbox_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_usb4_mbox_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_intel_usb4_mbox_parse: (skip):
 **/
FuStructIntelUsb4Mbox *
fu_struct_intel_usb4_mbox_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIntelUsb4Mbox) st = fu_struct_intel_usb4_mbox_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIntelUsb4Mbox: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_intel_usb4_mbox_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_usb4_metadata_nvm_read_ref: (skip):
 **/
FuStructIntelUsb4MetadataNvmRead *
fu_struct_intel_usb4_metadata_nvm_read_ref(FuStructIntelUsb4MetadataNvmRead *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_intel_usb4_metadata_nvm_read_unref: (skip):
 **/
void
fu_struct_intel_usb4_metadata_nvm_read_unref(FuStructIntelUsb4MetadataNvmRead *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIntelUsb4MetadataNvmRead refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_intel_usb4_metadata_nvm_read_new_internal: (skip):
 **/
static FuStructIntelUsb4MetadataNvmRead *
fu_struct_intel_usb4_metadata_nvm_read_new_internal(void)
{
    FuStructIntelUsb4MetadataNvmRead *st = g_new0(FuStructIntelUsb4MetadataNvmRead, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_intel_usb4_metadata_nvm_read_set_address: (skip):
 **/
void
fu_struct_intel_usb4_metadata_nvm_read_set_address(FuStructIntelUsb4MetadataNvmRead *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_usb4_metadata_nvm_read_set_length: (skip):
 **/
void
fu_struct_intel_usb4_metadata_nvm_read_set_length(FuStructIntelUsb4MetadataNvmRead *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_intel_usb4_metadata_nvm_read_new: (skip):
 **/
FuStructIntelUsb4MetadataNvmRead *
fu_struct_intel_usb4_metadata_nvm_read_new(void)
{
    FuStructIntelUsb4MetadataNvmRead *st = fu_struct_intel_usb4_metadata_nvm_read_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
