/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-intel-amt-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_amt_provisioning_state_to_string(FuAmtProvisioningState val)
{
    if (val == FU_AMT_PROVISIONING_STATE_UNPROVISIONED)
        return "unprovisioned";
    if (val == FU_AMT_PROVISIONING_STATE_BEING_PROVISIONED)
        return "being-provisioned";
    if (val == FU_AMT_PROVISIONING_STATE_PROVISIONED)
        return "provisioned";
    return NULL;
}

static const gchar *
fu_amt_host_if_command_to_string(FuAmtHostIfCommand val)
{
    if (val == FU_AMT_HOST_IF_COMMAND_PROVISIONING_MODE_REQUEST)
        return "provisioning-mode-request";
    if (val == FU_AMT_HOST_IF_COMMAND_PROVISIONING_STATE_REQUEST)
        return "provisioning-state-request";
    if (val == FU_AMT_HOST_IF_COMMAND_CODE_VERSIONS_REQUEST)
        return "code-versions-request";
    if (val == FU_AMT_HOST_IF_COMMAND_PROVISIONING_MODE_RESPONSE)
        return "provisioning-mode-response";
    if (val == FU_AMT_HOST_IF_COMMAND_PROVISIONING_STATE_RESPONSE)
        return "provisioning-state-response";
    if (val == FU_AMT_HOST_IF_COMMAND_CODE_VERSIONS_RESPONSE)
        return "code-versions-response";
    return NULL;
}
/**
 * fu_amt_host_if_msg_code_version_request_ref: (skip):
 **/
FuAmtHostIfMsgCodeVersionRequest *
fu_amt_host_if_msg_code_version_request_ref(FuAmtHostIfMsgCodeVersionRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_amt_host_if_msg_code_version_request_unref: (skip):
 **/
void
fu_amt_host_if_msg_code_version_request_unref(FuAmtHostIfMsgCodeVersionRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuAmtHostIfMsgCodeVersionRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_amt_host_if_msg_code_version_request_new_internal: (skip):
 **/
static FuAmtHostIfMsgCodeVersionRequest *
fu_amt_host_if_msg_code_version_request_new_internal(void)
{
    FuAmtHostIfMsgCodeVersionRequest *st = g_new0(FuAmtHostIfMsgCodeVersionRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_amt_host_if_msg_code_version_request_set_version_major: (skip):
 **/
static void
fu_amt_host_if_msg_code_version_request_set_version_major(FuAmtHostIfMsgCodeVersionRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_amt_host_if_msg_code_version_request_set_version_minor: (skip):
 **/
static void
fu_amt_host_if_msg_code_version_request_set_version_minor(FuAmtHostIfMsgCodeVersionRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_amt_host_if_msg_code_version_request_set_command: (skip):
 **/
static void
fu_amt_host_if_msg_code_version_request_set_command(FuAmtHostIfMsgCodeVersionRequest *st, FuAmtHostIfCommand value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_code_version_request_set_length: (skip):
 **/
static void
fu_amt_host_if_msg_code_version_request_set_length(FuAmtHostIfMsgCodeVersionRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_code_version_request_new: (skip):
 **/
FuAmtHostIfMsgCodeVersionRequest *
fu_amt_host_if_msg_code_version_request_new(void)
{
    FuAmtHostIfMsgCodeVersionRequest *st = fu_amt_host_if_msg_code_version_request_new_internal();
    st->buf = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st->buf, 12, 0x0);
    fu_amt_host_if_msg_code_version_request_set_version_major(st, 0x1);
    fu_amt_host_if_msg_code_version_request_set_version_minor(st, 0x1);
    fu_amt_host_if_msg_code_version_request_set_command(st, FU_AMT_HOST_IF_COMMAND_CODE_VERSIONS_REQUEST);
    fu_amt_host_if_msg_code_version_request_set_length(st, 0x0);
    return st;
}
/**
 * fu_amt_host_if_msg_code_version_response_ref: (skip):
 **/
FuAmtHostIfMsgCodeVersionResponse *
fu_amt_host_if_msg_code_version_response_ref(FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_amt_host_if_msg_code_version_response_unref: (skip):
 **/
void
fu_amt_host_if_msg_code_version_response_unref(FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuAmtHostIfMsgCodeVersionResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_amt_host_if_msg_code_version_response_new_internal: (skip):
 **/
static FuAmtHostIfMsgCodeVersionResponse *
fu_amt_host_if_msg_code_version_response_new_internal(void)
{
    FuAmtHostIfMsgCodeVersionResponse *st = g_new0(FuAmtHostIfMsgCodeVersionResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_amt_host_if_msg_code_version_response_get_version_major: (skip):
 **/
static guint8
fu_amt_host_if_msg_code_version_response_get_version_major(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_amt_host_if_msg_code_version_response_get_version_minor: (skip):
 **/
static guint8
fu_amt_host_if_msg_code_version_response_get_version_minor(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_amt_host_if_msg_code_version_response_get_command: (skip):
 **/
static FuAmtHostIfCommand
fu_amt_host_if_msg_code_version_response_get_command(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_code_version_response_get_status: (skip):
 **/
guint32
fu_amt_host_if_msg_code_version_response_get_status(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_code_version_response_get_version_count: (skip):
 **/
guint32
fu_amt_host_if_msg_code_version_response_get_version_count(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 81, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_amt_host_if_msg_code_version_response_to_string: (skip):
 **/
static gchar *
fu_amt_host_if_msg_code_version_response_to_string(const FuAmtHostIfMsgCodeVersionResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuAmtHostIfMsgCodeVersionResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_amt_host_if_msg_code_version_response_get_status(st));
    g_string_append_printf(str, "  version_count: 0x%x\n",
                           (guint) fu_amt_host_if_msg_code_version_response_get_version_count(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_amt_host_if_msg_code_version_response_validate_internal(FuAmtHostIfMsgCodeVersionResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_amt_host_if_msg_code_version_response_get_version_major(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuAmtHostIfMsgCodeVersionResponse.version_major was not valid");
        return FALSE;
    }
    if (fu_amt_host_if_msg_code_version_response_get_version_minor(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuAmtHostIfMsgCodeVersionResponse.version_minor was not valid");
        return FALSE;
    }
    if (fu_amt_host_if_msg_code_version_response_get_command(st) != FU_AMT_HOST_IF_COMMAND_CODE_VERSIONS_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuAmtHostIfMsgCodeVersionResponse.command was not valid, "
                    "expected 'FuAmtHostIfCommand' and got '%s'",
                    fu_amt_host_if_command_to_string(fu_amt_host_if_msg_code_version_response_get_command(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_amt_host_if_msg_code_version_response_parse_internal(FuAmtHostIfMsgCodeVersionResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_amt_host_if_msg_code_version_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_amt_host_if_msg_code_version_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_amt_host_if_msg_code_version_response_parse: (skip):
 **/
FuAmtHostIfMsgCodeVersionResponse *
fu_amt_host_if_msg_code_version_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuAmtHostIfMsgCodeVersionResponse) st = fu_amt_host_if_msg_code_version_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 85, error)) {
        g_prefix_error_literal(error, "invalid struct FuAmtHostIfMsgCodeVersionResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 85);
    if (!fu_amt_host_if_msg_code_version_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_amt_unicode_string_ref: (skip):
 **/
FuAmtUnicodeString *
fu_amt_unicode_string_ref(FuAmtUnicodeString *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_amt_unicode_string_unref: (skip):
 **/
void
fu_amt_unicode_string_unref(FuAmtUnicodeString *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuAmtUnicodeString refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_amt_unicode_string_new_internal: (skip):
 **/
static FuAmtUnicodeString *
fu_amt_unicode_string_new_internal(void)
{
    FuAmtUnicodeString *st = g_new0(FuAmtUnicodeString, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_amt_unicode_string_get_description_length: (skip):
 **/
guint16
fu_amt_unicode_string_get_description_length(const FuAmtUnicodeString *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_unicode_string_get_description_string: (skip):
 **/
gchar *
fu_amt_unicode_string_get_description_string(const FuAmtUnicodeString *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 20, NULL);
}
/**
 * fu_amt_unicode_string_get_version_length: (skip):
 **/
guint16
fu_amt_unicode_string_get_version_length(const FuAmtUnicodeString *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_unicode_string_get_version_string: (skip):
 **/
gchar *
fu_amt_unicode_string_get_version_string(const FuAmtUnicodeString *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 24, 20, NULL);
}

/* setters */
/**
 * fu_amt_unicode_string_to_string: (skip):
 **/
static gchar *
fu_amt_unicode_string_to_string(const FuAmtUnicodeString *st)
{
    g_autoptr(GString) str = g_string_new("FuAmtUnicodeString:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  description_length: 0x%x\n",
                           (guint) fu_amt_unicode_string_get_description_length(st));
    {
        g_autofree gchar *tmp = fu_amt_unicode_string_get_description_string(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  description_string: %s\n", tmp);
    }
    g_string_append_printf(str, "  version_length: 0x%x\n",
                           (guint) fu_amt_unicode_string_get_version_length(st));
    {
        g_autofree gchar *tmp = fu_amt_unicode_string_get_version_string(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version_string: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_amt_unicode_string_validate_internal(FuAmtUnicodeString *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_amt_unicode_string_parse_internal(FuAmtUnicodeString *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_amt_unicode_string_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_amt_unicode_string_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_amt_unicode_string_parse: (skip):
 **/
FuAmtUnicodeString *
fu_amt_unicode_string_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuAmtUnicodeString) st = fu_amt_unicode_string_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 44, error)) {
        g_prefix_error_literal(error, "invalid struct FuAmtUnicodeString: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 44);
    if (!fu_amt_unicode_string_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_ref: (skip):
 **/
FuAmtHostIfMsgProvisioningStateRequest *
fu_amt_host_if_msg_provisioning_state_request_ref(FuAmtHostIfMsgProvisioningStateRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_unref: (skip):
 **/
void
fu_amt_host_if_msg_provisioning_state_request_unref(FuAmtHostIfMsgProvisioningStateRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuAmtHostIfMsgProvisioningStateRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_new_internal: (skip):
 **/
static FuAmtHostIfMsgProvisioningStateRequest *
fu_amt_host_if_msg_provisioning_state_request_new_internal(void)
{
    FuAmtHostIfMsgProvisioningStateRequest *st = g_new0(FuAmtHostIfMsgProvisioningStateRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_amt_host_if_msg_provisioning_state_request_set_version_major: (skip):
 **/
static void
fu_amt_host_if_msg_provisioning_state_request_set_version_major(FuAmtHostIfMsgProvisioningStateRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_set_version_minor: (skip):
 **/
static void
fu_amt_host_if_msg_provisioning_state_request_set_version_minor(FuAmtHostIfMsgProvisioningStateRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_set_command: (skip):
 **/
static void
fu_amt_host_if_msg_provisioning_state_request_set_command(FuAmtHostIfMsgProvisioningStateRequest *st, FuAmtHostIfCommand value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_set_length: (skip):
 **/
static void
fu_amt_host_if_msg_provisioning_state_request_set_length(FuAmtHostIfMsgProvisioningStateRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_provisioning_state_request_new: (skip):
 **/
FuAmtHostIfMsgProvisioningStateRequest *
fu_amt_host_if_msg_provisioning_state_request_new(void)
{
    FuAmtHostIfMsgProvisioningStateRequest *st = fu_amt_host_if_msg_provisioning_state_request_new_internal();
    st->buf = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st->buf, 12, 0x0);
    fu_amt_host_if_msg_provisioning_state_request_set_version_major(st, 0x1);
    fu_amt_host_if_msg_provisioning_state_request_set_version_minor(st, 0x1);
    fu_amt_host_if_msg_provisioning_state_request_set_command(st, FU_AMT_HOST_IF_COMMAND_PROVISIONING_STATE_REQUEST);
    fu_amt_host_if_msg_provisioning_state_request_set_length(st, 0x0);
    return st;
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_ref: (skip):
 **/
FuAmtHostIfMsgProvisioningStateResponse *
fu_amt_host_if_msg_provisioning_state_response_ref(FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_unref: (skip):
 **/
void
fu_amt_host_if_msg_provisioning_state_response_unref(FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuAmtHostIfMsgProvisioningStateResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_new_internal: (skip):
 **/
static FuAmtHostIfMsgProvisioningStateResponse *
fu_amt_host_if_msg_provisioning_state_response_new_internal(void)
{
    FuAmtHostIfMsgProvisioningStateResponse *st = g_new0(FuAmtHostIfMsgProvisioningStateResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_version_major: (skip):
 **/
static guint8
fu_amt_host_if_msg_provisioning_state_response_get_version_major(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_version_minor: (skip):
 **/
static guint8
fu_amt_host_if_msg_provisioning_state_response_get_version_minor(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_command: (skip):
 **/
static FuAmtHostIfCommand
fu_amt_host_if_msg_provisioning_state_response_get_command(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_length: (skip):
 **/
static guint32
fu_amt_host_if_msg_provisioning_state_response_get_length(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_status: (skip):
 **/
guint32
fu_amt_host_if_msg_provisioning_state_response_get_status(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_amt_host_if_msg_provisioning_state_response_get_provisioning_state: (skip):
 **/
FuAmtProvisioningState
fu_amt_host_if_msg_provisioning_state_response_get_provisioning_state(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}

/* setters */
/**
 * fu_amt_host_if_msg_provisioning_state_response_to_string: (skip):
 **/
static gchar *
fu_amt_host_if_msg_provisioning_state_response_to_string(const FuAmtHostIfMsgProvisioningStateResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuAmtHostIfMsgProvisioningStateResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_amt_host_if_msg_provisioning_state_response_get_status(st));
    {
        const gchar *tmp = fu_amt_provisioning_state_to_string(fu_amt_host_if_msg_provisioning_state_response_get_provisioning_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  provisioning_state: 0x%x [%s]\n", (guint) fu_amt_host_if_msg_provisioning_state_response_get_provisioning_state(st), tmp);
        } else {
            g_string_append_printf(str, "  provisioning_state: 0x%x\n", (guint) fu_amt_host_if_msg_provisioning_state_response_get_provisioning_state(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_amt_host_if_msg_provisioning_state_response_validate_internal(FuAmtHostIfMsgProvisioningStateResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_amt_host_if_msg_provisioning_state_response_get_version_major(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuAmtHostIfMsgProvisioningStateResponse.version_major was not valid");
        return FALSE;
    }
    if (fu_amt_host_if_msg_provisioning_state_response_get_version_minor(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuAmtHostIfMsgProvisioningStateResponse.version_minor was not valid");
        return FALSE;
    }
    if (fu_amt_host_if_msg_provisioning_state_response_get_command(st) != FU_AMT_HOST_IF_COMMAND_PROVISIONING_STATE_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuAmtHostIfMsgProvisioningStateResponse.command was not valid, "
                    "expected 'FuAmtHostIfCommand' and got '%s'",
                    fu_amt_host_if_command_to_string(fu_amt_host_if_msg_provisioning_state_response_get_command(st)));
        return FALSE;
    }
    if (fu_amt_host_if_msg_provisioning_state_response_get_length(st) != 0x8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuAmtHostIfMsgProvisioningStateResponse.length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x8,
                    (guint) fu_amt_host_if_msg_provisioning_state_response_get_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_amt_host_if_msg_provisioning_state_response_parse_internal(FuAmtHostIfMsgProvisioningStateResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_amt_host_if_msg_provisioning_state_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_amt_host_if_msg_provisioning_state_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_amt_host_if_msg_provisioning_state_response_parse: (skip):
 **/
FuAmtHostIfMsgProvisioningStateResponse *
fu_amt_host_if_msg_provisioning_state_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuAmtHostIfMsgProvisioningStateResponse) st = fu_amt_host_if_msg_provisioning_state_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 17, error)) {
        g_prefix_error_literal(error, "invalid struct FuAmtHostIfMsgProvisioningStateResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 17);
    if (!fu_amt_host_if_msg_provisioning_state_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
